//////////////////////////////////////////////////////////////////////////////
// Name:        Elements_SetAttribute.cpp
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by genSetAttribute.py
//////////////////////////////////////////////////////////////////////////////

#include "String_wxsvg.h"
#include "SVGAElement.h"
#include "SVGElement.h"
#include "SVGURIReference.h"
#include "SVGTests.h"
#include "SVGLangSpace.h"
#include "SVGExternalResourcesRequired.h"
#include "SVGStylable.h"
#include "SVGTransformable.h"
#include "SVGAltGlyphDefElement.h"
#include "SVGAltGlyphElement.h"
#include "SVGTextPositioningElement.h"
#include "SVGTextContentElement.h"
#include "SVGAltGlyphItemElement.h"
#include "SVGAnimationElement.h"
#include "SVGAnimateColorElement.h"
#include "SVGAnimateElement.h"
#include "SVGAnimateMotionElement.h"
#include "SVGAnimateTransformElement.h"
#include "SVGAnimatedPathData.h"
#include "SVGAnimatedPoints.h"
#include "SVGCircleElement.h"
#include "SVGClipPathElement.h"
#include "SVGColorProfileElement.h"
#include "SVGComponentTransferFunctionElement.h"
#include "SVGCursorElement.h"
#include "SVGDefinitionSrcElement.h"
#include "SVGDefsElement.h"
#include "SVGDescElement.h"
#include "SVGEllipseElement.h"
#include "SVGFEBlendElement.h"
#include "SVGFilterPrimitiveStandardAttributes.h"
#include "SVGFEColorMatrixElement.h"
#include "SVGFEComponentTransferElement.h"
#include "SVGFECompositeElement.h"
#include "SVGFEConvolveMatrixElement.h"
#include "SVGFEDiffuseLightingElement.h"
#include "SVGFEDisplacementMapElement.h"
#include "SVGFEDistantLightElement.h"
#include "SVGFEFloodElement.h"
#include "SVGFEFuncAElement.h"
#include "SVGFEFuncBElement.h"
#include "SVGFEFuncGElement.h"
#include "SVGFEFuncRElement.h"
#include "SVGFEGaussianBlurElement.h"
#include "SVGFEImageElement.h"
#include "SVGFEMergeElement.h"
#include "SVGFEMergeNodeElement.h"
#include "SVGFEMorphologyElement.h"
#include "SVGFEOffsetElement.h"
#include "SVGFEPointLightElement.h"
#include "SVGFESpecularLightingElement.h"
#include "SVGFESpotLightElement.h"
#include "SVGFETileElement.h"
#include "SVGFETurbulenceElement.h"
#include "SVGFilterElement.h"
#include "SVGFitToViewBox.h"
#include "SVGFontElement.h"
#include "SVGFontFaceElement.h"
#include "SVGFontFaceFormatElement.h"
#include "SVGFontFaceNameElement.h"
#include "SVGFontFaceSrcElement.h"
#include "SVGFontFaceUriElement.h"
#include "SVGForeignObjectElement.h"
#include "SVGGElement.h"
#include "SVGGlyphElement.h"
#include "SVGGlyphRefElement.h"
#include "SVGGradientElement.h"
#include "SVGHKernElement.h"
#include "SVGImageElement.h"
#include "SVGLineElement.h"
#include "SVGLinearGradientElement.h"
#include "SVGMPathElement.h"
#include "SVGMarkerElement.h"
#include "SVGMaskElement.h"
#include "SVGMetadataElement.h"
#include "SVGMissingGlyphElement.h"
#include "SVGPathElement.h"
#include "SVGPatternElement.h"
#include "SVGPolygonElement.h"
#include "SVGPolylineElement.h"
#include "SVGRadialGradientElement.h"
#include "SVGRectElement.h"
#include "SVGSVGElement.h"
#include "SVGZoomAndPan.h"
#include "SVGScriptElement.h"
#include "SVGSetElement.h"
#include "SVGStopElement.h"
#include "SVGStyleElement.h"
#include "SVGSwitchElement.h"
#include "SVGSymbolElement.h"
#include "SVGTBreakElement.h"
#include "SVGTRefElement.h"
#include "SVGTSpanElement.h"
#include "SVGTextElement.h"
#include "SVGTextPathElement.h"
#include "SVGTitleElement.h"
#include "SVGUseElement.h"
#include "SVGVKernElement.h"
#include "SVGVideoElement.h"
#include "SVGViewElement.h"
#include "SVGViewSpec.h"

// wxSVGAElement
bool wxSVGAElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("target"))
	m_target.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGAElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("target")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_target.SetAnimVal(attrValue.GetString());
	} else {
	  m_target.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGAltGlyphDefElement
bool wxSVGAltGlyphDefElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAltGlyphDefElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGAltGlyphElement
bool wxSVGAltGlyphElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("glyphRef"))
	m_glyphRef = attrValue;
  else if (attrName == wxT("format"))
	m_format = attrValue;
  else if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAltGlyphElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGAltGlyphElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGTextPositioningElement::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGAltGlyphItemElement
bool wxSVGAltGlyphItemElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAltGlyphItemElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGAnimateColorElement
bool wxSVGAnimateColorElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateColorElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGAnimateElement
bool wxSVGAnimateElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGAnimateMotionElement
bool wxSVGAnimateMotionElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateMotionElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGAnimateTransformElement
bool wxSVGAnimateTransformElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("type"))
  {
    wxSVG_ANIMATETRANSFORM value = wxSVG_ANIMATETRANSFORM_TRANSLATE;
    if (attrValue.Lower() == wxT("scale"))
      value = wxSVG_ANIMATETRANSFORM_SCALE;
    else if (attrValue.Lower() == wxT("rotate"))
      value = wxSVG_ANIMATETRANSFORM_ROTATE;
    else if (attrValue.Lower() == wxT("skewx"))
      value = wxSVG_ANIMATETRANSFORM_SKEWX;
    else if (attrValue.Lower() == wxT("skewy"))
      value = wxSVG_ANIMATETRANSFORM_SKEWY;
    m_type = value;
  }
  else if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateTransformElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGAnimatedPathData
bool wxSVGAnimatedPathData::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("d"))
    m_pathSegList.SetValueAsString(attrValue);
  else 
      return false;

  return true;
}

// wxSVGAnimatedPoints
bool wxSVGAnimatedPoints::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("points"))
    m_points.SetValueAsString(attrValue);
  else 
      return false;

  return true;
}

// wxSVGAnimationElement
bool wxSVGAnimationElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("xlink:href") || attrName == wxT("href"))
	m_href = attrValue;
  else if (attrName == wxT("attributeName"))
	m_attributeName = attrValue;
  else if (attrName == wxT("begin"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_begin = value;
  }
  else if (attrName == wxT("dur"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dur = value;
  }
  else if (attrName == wxT("from"))
    m_from.SetValueAsString(attrValue);
  else if (attrName == wxT("to"))
    m_to.SetValueAsString(attrValue);
  else if (attrName == wxT("fill"))
  {
    wxSVG_ANIMATION_FILL value = wxSVG_ANIMATION_FILL_UNKNOWN;
    if (attrValue.Lower() == wxT("remove"))
      value = wxSVG_ANIMATION_FILL_REMOVE;
    else if (attrValue.Lower() == wxT("freeze"))
      value = wxSVG_ANIMATION_FILL_FREEZE;
    m_fill = value;
  }
  else if (attrName == wxT("additive"))
  {
    wxSVG_ANIMATION_ADDITIVE value = wxSVG_ANIMATION_ADDITIVE_UNKNOWN;
    if (attrValue.Lower() == wxT("replace"))
      value = wxSVG_ANIMATION_ADDITIVE_REPLACE;
    else if (attrValue.Lower() == wxT("sum"))
      value = wxSVG_ANIMATION_ADDITIVE_SUM;
    m_additive = value;
  }
  else if (attrName == wxT("accumulate"))
  {
    wxSVG_ANIMATION_ACCUMULATE value = wxSVG_ANIMATION_ACCUMULATE_UNKNOWN;
    if (attrValue.Lower() == wxT("none"))
      value = wxSVG_ANIMATION_ACCUMULATE_NONE;
    else if (attrValue.Lower() == wxT("sum"))
      value = wxSVG_ANIMATION_ACCUMULATE_SUM;
    m_accumulate = value;
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (SetCustomAttribute(attrName, attrValue));
  else
      return false;

  return true;
}

// wxSVGCircleElement
bool wxSVGCircleElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("cx"))
    m_cx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("cy"))
    m_cy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("r"))
    m_r.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGCircleElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGCircleElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("cx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_cx.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_cx.ResetAnimVal();
	}
  } else if (attrName == wxT("cy")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_cy.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_cy.ResetAnimVal();
	}
  } else if (attrName == wxT("r")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_r.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_r.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGClipPathElement
bool wxSVGClipPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("clipPathUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_clipPathUnits.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGClipPathElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGClipPathElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("clipPathUnits")) {
    m_clipPathUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGColorProfileElement
bool wxSVGColorProfileElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("local"))
	m_local = attrValue;
  else if (attrName == wxT("name"))
	m_name = attrValue;
  else if (attrName == wxT("rendering-intent"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_renderingIntent = (wxRENDERING_INTENT) value;
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGColorProfileElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGColorProfileElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGComponentTransferFunctionElement
bool wxSVGComponentTransferFunctionElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("type"))
  {
    wxSVG_FECOMPONENTTRANSFER_TYPE value = wxSVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("identity"))
      value = wxSVG_FECOMPONENTTRANSFER_TYPE_IDENTITY;
    else if (attrValue.Lower() == wxT("table"))
      value = wxSVG_FECOMPONENTTRANSFER_TYPE_TABLE;
    else if (attrValue.Lower() == wxT("discrete"))
      value = wxSVG_FECOMPONENTTRANSFER_TYPE_DISCRETE;
    else if (attrValue.Lower() == wxT("linear"))
      value = wxSVG_FECOMPONENTTRANSFER_TYPE_LINEAR;
    else if (attrValue.Lower() == wxT("gamma"))
      value = wxSVG_FECOMPONENTTRANSFER_TYPE_GAMMA;
    m_type.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("tableValues"))
    m_tableValues.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("slope"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_slope.SetBaseVal(value);
  }
  else if (attrName == wxT("intercept"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_intercept.SetBaseVal(value);
  }
  else if (attrName == wxT("amplitude"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_amplitude.SetBaseVal(value);
  }
  else if (attrName == wxT("exponent"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_exponent.SetBaseVal(value);
  }
  else if (attrName == wxT("offset"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_offset.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}

bool wxSVGComponentTransferFunctionElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("type")) {
    m_type.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("tableValues")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  wxSVGNumberList list;
	  for (unsigned int i = 0; i < attrValue.GetLengthList().size(); i++) {
		list.push_back(attrValue.GetLengthList()[i].GetValue());
	  }
	  m_tableValues.SetAnimVal(list);
	} else if (attrValue.GetPropertyType() == wxSVG_ANIMATED_NUMBER_LIST) {
	  m_tableValues.SetAnimVal(attrValue.GetNumberList());
	} else {
	  m_tableValues.ResetAnimVal();
	}
  } else if (attrName == wxT("slope")) {
    m_slope.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("intercept")) {
    m_intercept.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("amplitude")) {
    m_amplitude.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("exponent")) {
    m_exponent.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("offset")) {
    m_offset.SetAnimVal(attrValue.GetLength().GetValue());
  } else {
    return false;
  }
  return true;
}

// wxSVGCursorElement
bool wxSVGCursorElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGCursorElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGCursorElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGDefinitionSrcElement
bool wxSVGDefinitionSrcElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGDefinitionSrcElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGDefsElement
bool wxSVGDefsElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGDefsElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGDefsElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGDescElement
bool wxSVGDescElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGDescElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGDescElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGElement
bool wxSVGElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("id"))
	m_id = attrValue;
  else 
      return false;

  return true;
}

// wxSVGEllipseElement
bool wxSVGEllipseElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("cx"))
    m_cx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("cy"))
    m_cy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("rx"))
    m_rx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("ry"))
    m_ry.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGEllipseElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGEllipseElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("cx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_cx.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_cx.ResetAnimVal();
	}
  } else if (attrName == wxT("cy")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_cy.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_cy.ResetAnimVal();
	}
  } else if (attrName == wxT("rx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_rx.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_rx.ResetAnimVal();
	}
  } else if (attrName == wxT("ry")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_ry.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_ry.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGExternalResourcesRequired
bool wxSVGExternalResourcesRequired::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("externalResourcesRequired"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_externalResourcesRequired.SetBaseVal((bool) value);
  }
  else 
      return false;

  return true;
}

bool wxSVGExternalResourcesRequired::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("externalResourcesRequired")) {
    m_externalResourcesRequired.SetAnimVal((bool) attrValue.GetLength().GetValue());
  } else {
    return false;
  }
  return true;
}

// wxSVGFEBlendElement
bool wxSVGFEBlendElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("in2"))
	m_in2.GetBaseVal() = attrValue;
  else if (attrName == wxT("mode"))
  {
    wxSVG_FEBLEND_MODE value = wxSVG_FEBLEND_MODE_UNKNOWN;
    if (attrValue.Lower() == wxT("normal"))
      value = wxSVG_FEBLEND_MODE_NORMAL;
    else if (attrValue.Lower() == wxT("multiply"))
      value = wxSVG_FEBLEND_MODE_MULTIPLY;
    else if (attrValue.Lower() == wxT("screen"))
      value = wxSVG_FEBLEND_MODE_SCREEN;
    else if (attrValue.Lower() == wxT("darken"))
      value = wxSVG_FEBLEND_MODE_DARKEN;
    else if (attrValue.Lower() == wxT("lighten"))
      value = wxSVG_FEBLEND_MODE_LIGHTEN;
    m_mode.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEBlendElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEBlendElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("in2")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in2.SetAnimVal(attrValue.GetString());
	} else {
	  m_in2.ResetAnimVal();
	}
  } else if (attrName == wxT("mode")) {
    m_mode.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEColorMatrixElement
bool wxSVGFEColorMatrixElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("type"))
  {
    wxSVG_FECOLORMATRIX_TYPE value = wxSVG_FECOLORMATRIX_TYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("matrix"))
      value = wxSVG_FECOLORMATRIX_TYPE_MATRIX;
    else if (attrValue.Lower() == wxT("saturate"))
      value = wxSVG_FECOLORMATRIX_TYPE_SATURATE;
    else if (attrValue.Lower() == wxT("huerotate"))
      value = wxSVG_FECOLORMATRIX_TYPE_HUEROTATE;
    else if (attrValue.Lower() == wxT("luminancetoalpha"))
      value = wxSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA;
    m_type.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("values"))
    m_values.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEColorMatrixElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEColorMatrixElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("type")) {
    m_type.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("values")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  wxSVGNumberList list;
	  for (unsigned int i = 0; i < attrValue.GetLengthList().size(); i++) {
		list.push_back(attrValue.GetLengthList()[i].GetValue());
	  }
	  m_values.SetAnimVal(list);
	} else if (attrValue.GetPropertyType() == wxSVG_ANIMATED_NUMBER_LIST) {
	  m_values.SetAnimVal(attrValue.GetNumberList());
	} else {
	  m_values.ResetAnimVal();
	}
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEComponentTransferElement
bool wxSVGFEComponentTransferElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEComponentTransferElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEComponentTransferElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFECompositeElement
bool wxSVGFECompositeElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("in2"))
	m_in2.GetBaseVal() = attrValue;
  else if (attrName == wxT("operator"))
  {
    wxSVG_FECOMPOSITE_OPERATOR value = wxSVG_FECOMPOSITE_OPERATOR_UNKNOWN;
    if (attrValue.Lower() == wxT("over"))
      value = wxSVG_FECOMPOSITE_OPERATOR_OVER;
    else if (attrValue.Lower() == wxT("in"))
      value = wxSVG_FECOMPOSITE_OPERATOR_IN;
    else if (attrValue.Lower() == wxT("out"))
      value = wxSVG_FECOMPOSITE_OPERATOR_OUT;
    else if (attrValue.Lower() == wxT("atop"))
      value = wxSVG_FECOMPOSITE_OPERATOR_ATOP;
    else if (attrValue.Lower() == wxT("xor"))
      value = wxSVG_FECOMPOSITE_OPERATOR_XOR;
    else if (attrValue.Lower() == wxT("arithmetic"))
      value = wxSVG_FECOMPOSITE_OPERATOR_ARITHMETIC;
    m_operator.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("k1"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k1.SetBaseVal(value);
  }
  else if (attrName == wxT("k2"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k2.SetBaseVal(value);
  }
  else if (attrName == wxT("k3"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k3.SetBaseVal(value);
  }
  else if (attrName == wxT("k4"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k4.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFECompositeElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFECompositeElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("in2")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in2.SetAnimVal(attrValue.GetString());
	} else {
	  m_in2.ResetAnimVal();
	}
  } else if (attrName == wxT("operator")) {
    m_operator.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("k1")) {
    m_k1.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("k2")) {
    m_k2.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("k3")) {
    m_k3.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("k4")) {
    m_k4.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEConvolveMatrixElement
bool wxSVGFEConvolveMatrixElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("kernelMatrix"))
    m_kernelMatrix.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("divisor"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_divisor.SetBaseVal(value);
  }
  else if (attrName == wxT("bias"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_bias.SetBaseVal(value);
  }
  else if (attrName == wxT("targetX"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_targetX.SetBaseVal((long int) value);
  }
  else if (attrName == wxT("targetY"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_targetY.SetBaseVal((long int) value);
  }
  else if (attrName == wxT("edgeMode"))
  {
    wxSVG_EDGEMODE value = wxSVG_EDGEMODE_UNKNOWN;
    if (attrValue.Lower() == wxT("duplicate"))
      value = wxSVG_EDGEMODE_DUPLICATE;
    else if (attrValue.Lower() == wxT("wrap"))
      value = wxSVG_EDGEMODE_WRAP;
    else if (attrValue.Lower() == wxT("none"))
      value = wxSVG_EDGEMODE_NONE;
    m_edgeMode.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("preserveAlpha"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_preserveAlpha.SetBaseVal((bool) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEConvolveMatrixElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEConvolveMatrixElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("kernelMatrix")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  wxSVGNumberList list;
	  for (unsigned int i = 0; i < attrValue.GetLengthList().size(); i++) {
		list.push_back(attrValue.GetLengthList()[i].GetValue());
	  }
	  m_kernelMatrix.SetAnimVal(list);
	} else if (attrValue.GetPropertyType() == wxSVG_ANIMATED_NUMBER_LIST) {
	  m_kernelMatrix.SetAnimVal(attrValue.GetNumberList());
	} else {
	  m_kernelMatrix.ResetAnimVal();
	}
  } else if (attrName == wxT("divisor")) {
    m_divisor.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("bias")) {
    m_bias.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("targetX")) {
    m_targetX.SetAnimVal((long int) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("targetY")) {
    m_targetY.SetAnimVal((long int) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("edgeMode")) {
    m_edgeMode.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("preserveAlpha")) {
    m_preserveAlpha.SetAnimVal((bool) attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEDiffuseLightingElement
bool wxSVGFEDiffuseLightingElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("surfaceScale"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_surfaceScale.SetBaseVal(value);
  }
  else if (attrName == wxT("diffuseConstant"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_diffuseConstant.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEDiffuseLightingElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEDiffuseLightingElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("surfaceScale")) {
    m_surfaceScale.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("diffuseConstant")) {
    m_diffuseConstant.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEDisplacementMapElement
bool wxSVGFEDisplacementMapElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("in2"))
	m_in2.GetBaseVal() = attrValue;
  else if (attrName == wxT("scale"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_scale.SetBaseVal(value);
  }
  else if (attrName == wxT("xChannelSelector"))
  {
    wxSVG_CHANNEL value = wxSVG_CHANNEL_UNKNOWN;
    if (attrValue.Lower() == wxT("r"))
      value = wxSVG_CHANNEL_R;
    else if (attrValue.Lower() == wxT("g"))
      value = wxSVG_CHANNEL_G;
    else if (attrValue.Lower() == wxT("b"))
      value = wxSVG_CHANNEL_B;
    else if (attrValue.Lower() == wxT("a"))
      value = wxSVG_CHANNEL_A;
    m_xChannelSelector.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("yChannelSelector"))
  {
    wxSVG_CHANNEL value = wxSVG_CHANNEL_UNKNOWN;
    if (attrValue.Lower() == wxT("r"))
      value = wxSVG_CHANNEL_R;
    else if (attrValue.Lower() == wxT("g"))
      value = wxSVG_CHANNEL_G;
    else if (attrValue.Lower() == wxT("b"))
      value = wxSVG_CHANNEL_B;
    else if (attrValue.Lower() == wxT("a"))
      value = wxSVG_CHANNEL_A;
    m_yChannelSelector.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEDisplacementMapElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEDisplacementMapElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("in2")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in2.SetAnimVal(attrValue.GetString());
	} else {
	  m_in2.ResetAnimVal();
	}
  } else if (attrName == wxT("scale")) {
    m_scale.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("xChannelSelector")) {
    m_xChannelSelector.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("yChannelSelector")) {
    m_yChannelSelector.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEDistantLightElement
bool wxSVGFEDistantLightElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("azimuth"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_azimuth.SetBaseVal(value);
  }
  else if (attrName == wxT("elevation"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_elevation.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEDistantLightElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEDistantLightElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("azimuth")) {
    m_azimuth.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("elevation")) {
    m_elevation.SetAnimVal(attrValue.GetLength().GetValue());
  } else {
    return false;
  }
  return true;
}

// wxSVGFEFloodElement
bool wxSVGFEFloodElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFloodElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEFloodElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEFuncAElement
bool wxSVGFEFuncAElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncAElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEFuncAElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEFuncBElement
bool wxSVGFEFuncBElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncBElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEFuncBElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEFuncGElement
bool wxSVGFEFuncGElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncGElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEFuncGElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEFuncRElement
bool wxSVGFEFuncRElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncRElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEFuncRElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGComponentTransferFunctionElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEGaussianBlurElement
bool wxSVGFEGaussianBlurElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else if (SetCustomAttribute(attrName, attrValue));
  else
  {
    //wxLogDebug(wxT("unknown attribute SVGFEGaussianBlurElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEGaussianBlurElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else if (SetCustomAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEImageElement
bool wxSVGFEImageElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEImageElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEImageElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEMergeElement
bool wxSVGFEMergeElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEMergeElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEMergeElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEMergeNodeElement
bool wxSVGFEMergeNodeElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEMergeNodeElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEMergeNodeElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else {
    return false;
  }
  return true;
}

// wxSVGFEMorphologyElement
bool wxSVGFEMorphologyElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("operator"))
  {
    wxSVG_MORPHOLOGY_OPERATOR value = wxSVG_MORPHOLOGY_OPERATOR_UNKNOWN;
    if (attrValue.Lower() == wxT("erode"))
      value = wxSVG_MORPHOLOGY_OPERATOR_ERODE;
    else if (attrValue.Lower() == wxT("dilate"))
      value = wxSVG_MORPHOLOGY_OPERATOR_DILATE;
    m_operator.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEMorphologyElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEMorphologyElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("operator")) {
    m_operator.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEOffsetElement
bool wxSVGFEOffsetElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("dx"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dx.SetBaseVal(value);
  }
  else if (attrName == wxT("dy"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dy.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEOffsetElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEOffsetElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("dx")) {
    m_dx.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("dy")) {
    m_dy.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFEPointLightElement
bool wxSVGFEPointLightElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_x.SetBaseVal(value);
  }
  else if (attrName == wxT("y"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_y.SetBaseVal(value);
  }
  else if (attrName == wxT("z"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_z.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEPointLightElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFEPointLightElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    m_x.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("y")) {
    m_y.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("z")) {
    m_z.SetAnimVal(attrValue.GetLength().GetValue());
  } else {
    return false;
  }
  return true;
}

// wxSVGFESpecularLightingElement
bool wxSVGFESpecularLightingElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("surfaceScale"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_surfaceScale.SetBaseVal(value);
  }
  else if (attrName == wxT("specularConstant"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_specularConstant.SetBaseVal(value);
  }
  else if (attrName == wxT("specularExponent"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_specularExponent.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFESpecularLightingElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFESpecularLightingElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (attrName == wxT("surfaceScale")) {
    m_surfaceScale.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("specularConstant")) {
    m_specularConstant.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("specularExponent")) {
    m_specularExponent.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFESpotLightElement
bool wxSVGFESpotLightElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_x.SetBaseVal(value);
  }
  else if (attrName == wxT("y"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_y.SetBaseVal(value);
  }
  else if (attrName == wxT("z"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_z.SetBaseVal(value);
  }
  else if (attrName == wxT("pointsAtX"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pointsAtX.SetBaseVal(value);
  }
  else if (attrName == wxT("pointsAtY"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pointsAtY.SetBaseVal(value);
  }
  else if (attrName == wxT("pointsAtZ"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pointsAtZ.SetBaseVal(value);
  }
  else if (attrName == wxT("specularExponent"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_specularExponent.SetBaseVal(value);
  }
  else if (attrName == wxT("limitingConeAngle"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_limitingConeAngle.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFESpotLightElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFESpotLightElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    m_x.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("y")) {
    m_y.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("z")) {
    m_z.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("pointsAtX")) {
    m_pointsAtX.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("pointsAtY")) {
    m_pointsAtY.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("pointsAtZ")) {
    m_pointsAtZ.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("specularExponent")) {
    m_specularExponent.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("limitingConeAngle")) {
    m_limitingConeAngle.SetAnimVal(attrValue.GetLength().GetValue());
  } else {
    return false;
  }
  return true;
}

// wxSVGFETileElement
bool wxSVGFETileElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFETileElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFETileElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("in")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_in1.SetAnimVal(attrValue.GetString());
	} else {
	  m_in1.ResetAnimVal();
	}
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFETurbulenceElement
bool wxSVGFETurbulenceElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("numOctaves"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_numOctaves.SetBaseVal((long int) value);
  }
  else if (attrName == wxT("seed"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_seed.SetBaseVal(value);
  }
  else if (attrName == wxT("stitchTiles"))
  {
    wxSVG_STITCHTYPE value = wxSVG_STITCHTYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("stitch"))
      value = wxSVG_STITCHTYPE_STITCH;
    else if (attrValue.Lower() == wxT("nostitch"))
      value = wxSVG_STITCHTYPE_NOSTITCH;
    m_stitchTiles.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("type"))
  {
    wxSVG_TURBULENCE_TYPE value = wxSVG_TURBULENCE_TYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("fractalnoise"))
      value = wxSVG_TURBULENCE_TYPE_FRACTALNOISE;
    else if (attrValue.Lower() == wxT("turbulence"))
      value = wxSVG_TURBULENCE_TYPE_TURBULENCE;
    m_type.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFETurbulenceElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFETurbulenceElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("numOctaves")) {
    m_numOctaves.SetAnimVal((long int) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("seed")) {
    m_seed.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (attrName == wxT("stitchTiles")) {
    m_stitchTiles.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("type")) {
    m_type.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFilterElement
bool wxSVGFilterElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("filterUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_filterUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("primitiveUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_primitiveUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFilterElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFilterElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("filterUnits")) {
    m_filterUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("primitiveUnits")) {
    m_primitiveUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFilterPrimitiveStandardAttributes
bool wxSVGFilterPrimitiveStandardAttributes::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("result"))
	m_result.GetBaseVal() = attrValue;
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}

bool wxSVGFilterPrimitiveStandardAttributes::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (attrName == wxT("result")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_result.SetAnimVal(attrValue.GetString());
	} else {
	  m_result.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFitToViewBox
bool wxSVGFitToViewBox::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("viewBox"))
    m_viewBox.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("preserveAspectRatio"))
    m_preserveAspectRatio.GetBaseVal().SetValueAsString(attrValue);
  else 
      return false;

  return true;
}

bool wxSVGFitToViewBox::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("viewBox")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  if (attrValue.GetLengthList().size() >= 4) {
		const wxSVGLengthList& list = attrValue.GetLengthList();
		m_viewBox.SetAnimVal(wxSVGRect(list[0], list[1], list[2], list[3]));
	  }
	} else {
	  m_viewBox.ResetAnimVal();
	}
  } else if (attrName == wxT("preserveAspectRatio")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_STRING) {
	  wxSVGPreserveAspectRatio ratio;
	  ratio.SetValueAsString(attrValue.GetString());
	  m_preserveAspectRatio.SetAnimVal(ratio);
	} else {
	  m_preserveAspectRatio.ResetAnimVal();
	}
  } else {
    return false;
  }
  return true;
}

// wxSVGFontElement
bool wxSVGFontElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGFontElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGFontFaceElement
bool wxSVGFontFaceElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGFontFaceFormatElement
bool wxSVGFontFaceFormatElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceFormatElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGFontFaceNameElement
bool wxSVGFontFaceNameElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceNameElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGFontFaceSrcElement
bool wxSVGFontFaceSrcElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceSrcElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGFontFaceUriElement
bool wxSVGFontFaceUriElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceUriElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGForeignObjectElement
bool wxSVGForeignObjectElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGForeignObjectElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGForeignObjectElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGGElement
bool wxSVGGElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGGElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGGElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGGlyphElement
bool wxSVGGlyphElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGGlyphElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGGlyphElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGGlyphRefElement
bool wxSVGGlyphRefElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("glyphRef"))
	m_glyphRef = attrValue;
  else if (attrName == wxT("format"))
	m_format = attrValue;
  else if (attrName == wxT("x"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_x = value;
  }
  else if (attrName == wxT("y"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_y = value;
  }
  else if (attrName == wxT("dx"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dx = value;
  }
  else if (attrName == wxT("dy"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dy = value;
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGGlyphRefElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGGlyphRefElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGGradientElement
bool wxSVGGradientElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("gradientUnits"))
  {
    wxSVG_UNIT_TYPE value = wxSVG_UNIT_TYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("userspaceonuse"))
        value = wxSVG_UNIT_TYPE_USERSPACEONUSE;
    else if (attrValue.Lower() == wxT("objectboundingbox"))
        value = wxSVG_UNIT_TYPE_OBJECTBOUNDINGBOX;
    m_gradientUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("gradientTransform"))
    m_gradientTransform.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("spreadMethod"))
  {
    wxSVG_SPREADMETHOD value = wxSVG_SPREADMETHOD_UNKNOWN;
    if (attrValue.Lower() == wxT("pad"))
      value = wxSVG_SPREADMETHOD_PAD;
    else if (attrValue.Lower() == wxT("reflect"))
      value = wxSVG_SPREADMETHOD_REFLECT;
    else if (attrValue.Lower() == wxT("repeat"))
      value = wxSVG_SPREADMETHOD_REPEAT;
    m_spreadMethod.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}

bool wxSVGGradientElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("gradientUnits")) {
    m_gradientUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("gradientTransform")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_gradientTransform.SetAnimVal(attrValue.GetTransformList());
	} else {
	  m_gradientTransform.ResetAnimVal();
	}
  } else if (attrName == wxT("spreadMethod")) {
    m_spreadMethod.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGHKernElement
bool wxSVGHKernElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGHKernElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGImageElement
bool wxSVGImageElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("preserveAspectRatio"))
    m_preserveAspectRatio.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGImageElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGImageElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (attrName == wxT("preserveAspectRatio")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_STRING) {
	  wxSVGPreserveAspectRatio ratio;
	  ratio.SetValueAsString(attrValue.GetString());
	  m_preserveAspectRatio.SetAnimVal(ratio);
	} else {
	  m_preserveAspectRatio.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGLangSpace
bool wxSVGLangSpace::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("xml:lang"))
	m_xmllang = attrValue;
  else if (attrName == wxT("xml:space"))
	m_xmlspace = attrValue;
  else 
      return false;

  return true;
}

// wxSVGLineElement
bool wxSVGLineElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x1"))
    m_x1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y1"))
    m_y1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("x2"))
    m_x2.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y2"))
    m_y2.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGLineElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGLineElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x1")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x1.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x1.ResetAnimVal();
	}
  } else if (attrName == wxT("y1")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y1.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y1.ResetAnimVal();
	}
  } else if (attrName == wxT("x2")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x2.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x2.ResetAnimVal();
	}
  } else if (attrName == wxT("y2")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y2.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y2.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGLinearGradientElement
bool wxSVGLinearGradientElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x1"))
    m_x1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y1"))
    m_y1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("x2"))
    m_x2.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y2"))
    m_y2.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGGradientElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGLinearGradientElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGLinearGradientElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x1")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x1.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x1.ResetAnimVal();
	}
  } else if (attrName == wxT("y1")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y1.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y1.ResetAnimVal();
	}
  } else if (attrName == wxT("x2")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x2.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x2.ResetAnimVal();
	}
  } else if (attrName == wxT("y2")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y2.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y2.ResetAnimVal();
	}
  } else if (wxSVGGradientElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGMPathElement
bool wxSVGMPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMPathElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGMPathElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGMarkerElement
bool wxSVGMarkerElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("refX"))
    m_refX.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("refY"))
    m_refY.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("markerUnits"))
  {
    wxSVG_MARKERUNITS value = wxSVG_MARKERUNITS_UNKNOWN;
    if (attrValue.Lower() == wxT("userspaceonuse"))
      value = wxSVG_MARKERUNITS_USERSPACEONUSE;
    else if (attrValue.Lower() == wxT("strokewidth"))
      value = wxSVG_MARKERUNITS_STROKEWIDTH;
    m_markerUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("markerWidth"))
    m_markerWidth.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("markerHeight"))
    m_markerHeight.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMarkerElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGMarkerElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("refX")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_refX.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_refX.ResetAnimVal();
	}
  } else if (attrName == wxT("refY")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_refY.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_refY.ResetAnimVal();
	}
  } else if (attrName == wxT("markerUnits")) {
    m_markerUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("markerWidth")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_markerWidth.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_markerWidth.ResetAnimVal();
	}
  } else if (attrName == wxT("markerHeight")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_markerHeight.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_markerHeight.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGMaskElement
bool wxSVGMaskElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("maskUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_maskUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("maskContentUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_maskContentUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMaskElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGMaskElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("maskUnits")) {
    m_maskUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("maskContentUnits")) {
    m_maskContentUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGMetadataElement
bool wxSVGMetadataElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMetadataElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGMissingGlyphElement
bool wxSVGMissingGlyphElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMissingGlyphElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGMissingGlyphElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGPathElement
bool wxSVGPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("pathLength"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pathLength.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else if (wxSVGAnimatedPathData::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPathElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGPathElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("pathLength")) {
    m_pathLength.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGPatternElement
bool wxSVGPatternElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("patternUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_patternUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("patternContentUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_patternContentUnits.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("patternTransform"))
    m_patternTransform.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPatternElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGPatternElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("patternUnits")) {
    m_patternUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("patternContentUnits")) {
    m_patternContentUnits.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("patternTransform")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_patternTransform.SetAnimVal(attrValue.GetTransformList());
	} else {
	  m_patternTransform.ResetAnimVal();
	}
  } else if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGPolygonElement
bool wxSVGPolygonElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else if (wxSVGAnimatedPoints::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPolygonElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGPolygonElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGPolylineElement
bool wxSVGPolylineElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else if (wxSVGAnimatedPoints::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPolylineElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGPolylineElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGRadialGradientElement
bool wxSVGRadialGradientElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("cx"))
    m_cx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("cy"))
    m_cy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("r"))
    m_r.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("fx"))
    m_fx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("fy"))
    m_fy.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGGradientElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGRadialGradientElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGRadialGradientElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("cx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_cx.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_cx.ResetAnimVal();
	}
  } else if (attrName == wxT("cy")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_cy.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_cy.ResetAnimVal();
	}
  } else if (attrName == wxT("r")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_r.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_r.ResetAnimVal();
	}
  } else if (attrName == wxT("fx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_fx.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_fx.ResetAnimVal();
	}
  } else if (attrName == wxT("fy")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_fy.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_fy.ResetAnimVal();
	}
  } else if (wxSVGGradientElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGRectElement
bool wxSVGRectElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("rx"))
    m_rx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("ry"))
    m_ry.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGRectElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGRectElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (attrName == wxT("rx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_rx.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_rx.ResetAnimVal();
	}
  } else if (attrName == wxT("ry")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_ry.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_ry.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGSVGElement
bool wxSVGSVGElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("contentScriptType"))
	m_contentScriptType = attrValue;
  else if (attrName == wxT("contentStyleType"))
	m_contentStyleType = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else if (wxSVGZoomAndPan::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSVGElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGSVGElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGScriptElement
bool wxSVGScriptElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("type"))
	m_type = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGScriptElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGScriptElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGSetElement
bool wxSVGSetElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSetElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGStopElement
bool wxSVGStopElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("offset"))
  {
    double value;
    if (attrValue.Last() == wxT('%') && attrValue.Left(attrValue.Length()-1).ToDouble(&value))
    {
      value = value/100;
      m_offset.SetBaseVal(value);
    }
    else if (attrValue.ToDouble(&value))
      m_offset.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGStopElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGStopElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("offset")) {
    m_offset.SetAnimVal(attrValue.GetLength().GetValue());
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGStylable
bool wxSVGStylable::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("class"))
	m_className.GetBaseVal() = attrValue;
  else if (attrName == wxT("style"))
    m_style.SetCSSText(attrValue);
  else if (SetCustomAttribute(attrName, attrValue));
  else
      return false;

  return true;
}

bool wxSVGStylable::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("class")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_className.SetAnimVal(attrValue.GetString());
	} else {
	  m_className.ResetAnimVal();
	}
  } else if (SetCustomAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGStyleElement
bool wxSVGStyleElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("xml:space"))
	m_xmlspace = attrValue;
  else if (attrName == wxT("type"))
	m_type = attrValue;
  else if (attrName == wxT("media"))
	m_media = attrValue;
  else if (attrName == wxT("title"))
	m_title = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGStyleElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGSwitchElement
bool wxSVGSwitchElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSwitchElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGSwitchElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGSymbolElement
bool wxSVGSymbolElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSymbolElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGSymbolElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTBreakElement
bool wxSVGTBreakElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTBreakElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGTRefElement
bool wxSVGTRefElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTRefElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGTRefElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGTextPositioningElement::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTSpanElement
bool wxSVGTSpanElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTSpanElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGTSpanElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGTextPositioningElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTests
bool wxSVGTests::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("requiredFeatures"))
    m_requiredFeatures.SetValueAsString(attrValue);
  else if (attrName == wxT("requiredExtensions"))
    m_requiredExtensions.SetValueAsString(attrValue);
  else if (attrName == wxT("systemLanguage"))
    m_systemLanguage.SetValueAsString(attrValue);
  else 
      return false;

  return true;
}

// wxSVGTextContentElement
bool wxSVGTextContentElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("textLength"))
    m_textLength.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("lengthAdjust"))
  {
    wxLENGTHADJUST value = wxLENGTHADJUST_UNKNOWN;
    if (attrValue.Lower() == wxT("spacing"))
      value = wxLENGTHADJUST_SPACING;
    else if (attrValue.Lower() == wxT("spacingandglyphs"))
      value = wxLENGTHADJUST_SPACINGANDGLYPHS;
    m_lengthAdjust.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}

bool wxSVGTextContentElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("textLength")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_textLength.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_textLength.ResetAnimVal();
	}
  } else if (attrName == wxT("lengthAdjust")) {
    m_lengthAdjust.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTextElement
bool wxSVGTextElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTextElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGTextElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGTextPositioningElement::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTextPathElement
bool wxSVGTextPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("startOffset"))
    m_startOffset.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("method"))
  {
    wxTEXTPATH_METHODTYPE value = wxTEXTPATH_METHODTYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("align"))
      value = wxTEXTPATH_METHODTYPE_ALIGN;
    else if (attrValue.Lower() == wxT("stretch"))
      value = wxTEXTPATH_METHODTYPE_STRETCH;
    m_method.SetBaseVal((unsigned char) value);
  }
  else if (attrName == wxT("spacing"))
  {
    wxTEXTPATH_SPACINGTYPE value = wxTEXTPATH_SPACINGTYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("auto"))
      value = wxTEXTPATH_SPACINGTYPE_AUTO;
    else if (attrValue.Lower() == wxT("exact"))
      value = wxTEXTPATH_SPACINGTYPE_EXACT;
    m_spacing.SetBaseVal((unsigned char) value);
  }
  else if (wxSVGTextContentElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTextPathElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGTextPathElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("startOffset")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_startOffset.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_startOffset.ResetAnimVal();
	}
  } else if (attrName == wxT("method")) {
    m_method.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (attrName == wxT("spacing")) {
    m_spacing.SetAnimVal((unsigned char) attrValue.GetLength().GetValue());
  } else if (wxSVGTextContentElement::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTextPositioningElement
bool wxSVGTextPositioningElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("dx"))
    m_dx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("dy"))
    m_dy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("rotate"))
    m_rotate.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGTextContentElement::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}

bool wxSVGTextPositioningElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_x.SetAnimVal(attrValue.GetLengthList());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_y.SetAnimVal(attrValue.GetLengthList());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("dx")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_dx.SetAnimVal(attrValue.GetLengthList());
	} else {
	  m_dx.ResetAnimVal();
	}
  } else if (attrName == wxT("dy")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_dy.SetAnimVal(attrValue.GetLengthList());
	} else {
	  m_dy.ResetAnimVal();
	}
  } else if (attrName == wxT("rotate")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  wxSVGNumberList list;
	  for (unsigned int i = 0; i < attrValue.GetLengthList().size(); i++) {
		list.push_back(attrValue.GetLengthList()[i].GetValue());
	  }
	  m_rotate.SetAnimVal(list);
	} else if (attrValue.GetPropertyType() == wxSVG_ANIMATED_NUMBER_LIST) {
	  m_rotate.SetAnimVal(attrValue.GetNumberList());
	} else {
	  m_rotate.ResetAnimVal();
	}
  } else if (wxSVGTextContentElement::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTitleElement
bool wxSVGTitleElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTitleElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGTitleElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGTransformable
bool wxSVGTransformable::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("transform"))
    m_transform.GetBaseVal().SetValueAsString(attrValue);
  else 
      return false;

  return true;
}

bool wxSVGTransformable::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("transform")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH_LIST) {
	  m_transform.SetAnimVal(attrValue.GetTransformList());
	} else {
	  m_transform.ResetAnimVal();
	}
  } else {
    return false;
  }
  return true;
}

// wxSVGURIReference
bool wxSVGURIReference::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("xlink:href") || attrName == wxT("href"))
	m_href.GetBaseVal() = attrValue;
  else 
      return false;

  return true;
}

bool wxSVGURIReference::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("xlink:href")) {
    if (attrValue.GetPropertyType() != wxSVG_ANIMATED_UNKNOWN) {
	  m_href.SetAnimVal(attrValue.GetString());
	} else {
	  m_href.ResetAnimVal();
	}
  } else {
    return false;
  }
  return true;
}

// wxSVGUseElement
bool wxSVGUseElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGUseElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGUseElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGVKernElement
bool wxSVGVKernElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGVKernElement::") + attrName);
    return false;
  }

  return true;
}

// wxSVGVideoElement
bool wxSVGVideoElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("preserveAspectRatio"))
    m_preserveAspectRatio.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("begin"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_begin = value;
  }
  else if (attrName == wxT("dur"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dur = value;
  }
  else if (attrName == wxT("clipBegin"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_clipBegin = value;
  }
  else if (attrName == wxT("clipEnd"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_clipEnd = value;
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGVideoElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGVideoElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (attrName == wxT("x")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_x.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_x.ResetAnimVal();
	}
  } else if (attrName == wxT("y")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_y.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_y.ResetAnimVal();
	}
  } else if (attrName == wxT("width")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_width.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_width.ResetAnimVal();
	}
  } else if (attrName == wxT("height")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_LENGTH) {
	  m_height.SetAnimVal(attrValue.GetLength().GetValue());
	} else {
	  m_height.ResetAnimVal();
	}
  } else if (attrName == wxT("preserveAspectRatio")) {
    if (attrValue.GetPropertyType() == wxSVG_ANIMATED_STRING) {
	  wxSVGPreserveAspectRatio ratio;
	  ratio.SetValueAsString(attrValue.GetString());
	  m_preserveAspectRatio.SetAnimVal(ratio);
	} else {
	  m_preserveAspectRatio.ResetAnimVal();
	}
  } else if (wxSVGURIReference::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGStylable::SetAnimatedValue(attrName, attrValue));
  else if (wxSVGTransformable::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGViewElement
bool wxSVGViewElement::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("viewTarget"))
    m_viewTarget.SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else if (wxSVGZoomAndPan::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGViewElement::") + attrName);
    return false;
  }

  return true;
}

bool wxSVGViewElement::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGFitToViewBox::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGViewSpec
bool wxSVGViewSpec::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (wxSVGZoomAndPan::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}

bool wxSVGViewSpec::SetAnimatedValue(const wxString& attrName, const wxSVGAnimatedType& attrValue) {
  if (wxSVGFitToViewBox::SetAnimatedValue(attrName, attrValue));
  else {
    return false;
  }
  return true;
}

// wxSVGZoomAndPan
bool wxSVGZoomAndPan::SetAttribute(const wxString& attrName, const wxString& attrValue) {
  if (attrName == wxT("zoomAndPan"))
  {
    wxSVG_ZOOMANDPAN value = wxSVG_ZOOMANDPAN_UNKNOWN;
    if (attrValue.Lower() == wxT("disable"))
      value = wxSVG_ZOOMANDPAN_DISABLE;
    else if (attrValue.Lower() == wxT("magnify"))
      value = wxSVG_ZOOMANDPAN_MAGNIFY;
    m_zoomAndPan = (wxSVG_ZOOMANDPAN) value;
  }
  else 
      return false;

  return true;
}

