/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ptolemy.util.ClassUtilities;
import ptolemy.util.StringUtilities;

public class FileUtilities {
    public static BufferedReader STD_IN = null;
    public static PrintWriter STD_OUT = null;
    private static String _CLASSPATH_VALUE = "xxxxxxCLASSPATHxxxxxx";

    private FileUtilities() {
    }

    public static boolean binaryCopyURLToFile(URL uRL, File file) throws IOException {
        URL uRL2 = file.getCanonicalFile().toURI().toURL();
        if (uRL.sameFile(uRL2)) {
            return false;
        }
        File file2 = new File(uRL.getFile());
        if (file2.getPath().indexOf("!/") == -1 && file2.getPath().indexOf("!\\") == -1) {
            try {
                if (file2.getCanonicalFile().toURI().toURL().sameFile(uRL2)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Cannot find canonical file name of '" + file2 + "'");
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        FileUtilities._binaryCopyStream(uRL.openStream(), file);
        return true;
    }

    public static void extractJarFile(String string, String string2) throws IOException {
        JarFile jarFile = new JarFile(string);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            File file = new File(string2, jarEntry.getName());
            if (jarEntry.isDirectory()) {
                if (file.isDirectory() || file.mkdirs()) continue;
                throw new IOException("Warning, failed to create directory for \"" + file + "\".");
            }
            FileUtilities._binaryCopyStream(jarFile.getInputStream(jarEntry), file);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.err.println("Usage: java -classpath $PTII ptolemy.util.FileUtilities jarFile [directory]\nwhere jarFile is the name of the jar file\nand directory is the optional directory in which to extract.");
            StringUtilities.exit(2);
        }
        String string = stringArray[0];
        String string2 = null;
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        try {
            FileUtilities.extractJarFile(string, string2);
        }
        catch (Throwable throwable) {
            System.err.println("Failed to extract \"" + string + "\"");
            throwable.printStackTrace();
            StringUtilities.exit(3);
        }
    }

    public static File nameToFile(String string, URI uRI) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        File file = new File(string);
        if (!file.isAbsolute() && uRI != null) {
            URI uRI2 = uRI.resolve(string);
            String string2 = uRI2.getPath();
            file = new File(StringUtilities.substitute(string2, "%20", " "));
        }
        return file;
    }

    public static URL nameToURL(String string, URI uRI, ClassLoader classLoader) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        if (string.startsWith(_CLASSPATH_VALUE) || string.startsWith("$CLASSPATH")) {
            Object object;
            String string2 = string.startsWith(_CLASSPATH_VALUE) ? _CLASSPATH_VALUE : "$CLASSPATH";
            String string3 = string.substring(string2.length() + 1);
            if (classLoader == null) {
                object = "ptolemy.util.FileUtilities";
                try {
                    Class<?> clazz = Class.forName((String)object);
                    classLoader = clazz.getClassLoader();
                }
                catch (Exception exception) {
                    IOException iOException = new IOException("Cannot look up class \"" + (String)object + "\" or get its ClassLoader.");
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            if ((object = classLoader.getResource(string3)) == null) {
                throw new IOException("Cannot find file '" + string3 + "' in classpath");
            }
            return object;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            if (!file.canRead()) {
                file = new File(StringUtilities.substitute(string, "%20", " "));
                URL uRL = null;
                if (!file.canRead() && (uRL = ClassUtilities.jarURLEntryResource(string)) != null) {
                    file = new File(uRL.getFile());
                }
                if (!file.canRead()) {
                    throw new IOException("Cannot read file '" + string + "' or '" + StringUtilities.substitute(string, "%20", " ") + "'" + (uRL == null ? "" : " or '" + uRL.getFile() + ""));
                }
            }
            return file.toURI().toURL();
        }
        if (uRI != null) {
            URI uRI2;
            try {
                uRI2 = uRI.resolve(string);
            }
            catch (Exception exception) {
                String string4 = StringUtilities.substitute(string, "%20", " ");
                try {
                    uRI2 = uRI.resolve(string4);
                    string = string4;
                }
                catch (Exception exception2) {
                    IOException iOException = new IOException("Problem with URI format in '" + string + "'. " + "and '" + string4 + "' " + "This can happen if the file name " + "is not absolute" + "and is not present relative to the " + "directory in which the specified model " + "was read (which was '" + uRI + "')");
                    iOException.initCause(exception2);
                    throw iOException;
                }
            }
            String string5 = uRI2.toString();
            try {
                if (uRI2.getScheme() != null && uRI2.getAuthority() == null) {
                    string5 = string5.substring(0, 6) + "//" + string5.substring(6);
                }
                return new URL(string5);
            }
            catch (Exception exception) {
                try {
                    return new URL(uRI.toURL(), string5);
                }
                catch (Exception exception3) {
                    try {
                        return new URL(uRI.toURL(), uRI2.toString());
                    }
                    catch (Exception exception4) {
                        IOException iOException = new IOException("Problem with URI format in '" + string5 + "'. " + "This can happen if the '" + string5 + "' is not absolute" + " and is not present relative to the directory" + " in which the specified model was read" + " (which was '" + uRI + "')");
                        iOException.initCause(exception);
                        throw iOException;
                    }
                }
            }
        }
        URL uRL = new URL(string);
        try {
            String string6 = uRL.toString().replaceFirst("(https?:)//?", "$1//");
            uRL = new URL(string6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL;
    }

    public static BufferedReader openForReading(String string, URI uRI, ClassLoader classLoader) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        if (string.trim().equals("System.in")) {
            if (STD_IN == null) {
                STD_IN = new BufferedReader(new InputStreamReader(System.in));
            }
            return STD_IN;
        }
        URL uRL = FileUtilities.nameToURL(string, uRI, classLoader);
        if (uRL == null) {
            throw new IOException("Could not convert \"" + string + "\" with base \"" + uRI + "\" to a URL.");
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(uRL.openStream());
        }
        catch (IOException iOException) {
            try {
                URL uRL2 = ClassUtilities.jarURLEntryResource(uRL.toString());
                if (uRL2 != null) {
                    inputStreamReader = new InputStreamReader(uRL2.openStream());
                }
                return new BufferedReader(inputStreamReader);
            }
            catch (Exception exception) {
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                IOException iOException3 = new IOException("Failed to open \"" + uRL + "\".");
                iOException3.initCause(iOException);
                throw iOException3;
            }
        }
        return new BufferedReader(inputStreamReader);
    }

    public static Writer openForWriting(String string, URI uRI, boolean bl) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        if (string.trim().equals("System.out")) {
            if (STD_OUT == null) {
                STD_OUT = new PrintWriter(System.out);
            }
            return STD_OUT;
        }
        File file = FileUtilities.nameToFile(string, uRI);
        return new FileWriter(file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _binaryCopyStream(InputStream inputStream, File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            FilterOutputStream filterOutputStream = null;
            try {
                int n;
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                    throw new IOException("Failed to create directories for \"" + file2 + "\".");
                }
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                while ((n = bufferedInputStream.read()) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }
}

