/*---------------------------------------------------------------------------*\

    FILE....: TRANSLATE.CPP
    TYPE....: C Module
    AUTHOR..: David Rowe
    DATE....: 1/12/97

    The functions in this module translate messages from the VPB
    into a human readable form, ie the event codes are converted
    to appropriate form.  The functions are used for debugging
    purposes.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <cstring>
#include <cstdio>

#include "translate.h"
#include "messages.h"
#include "contypes.h"   //XXX for MAX_STR


// Error message decode table

//XXX Long obsolete, last understood (but not used) by V4PCI.
#if 0
static const char *errors[] = {
	"CALLPROG error downloading CP state table",	// CALLPROG_TABLE   0
	"TONEG tone generator busy",			// TONEG_BUSY	    1
	"CONFIG object identifer too big",		// CONFIG_SZIDENT   2
	"CONFIG channel number too big",		// CONFIG_SZCH	    3
	"CONFIG bad class",			     	// CONFIG_CLASS	    4
	"CONFIG out of memory",				// CONFIG_MEM	    5
	"CONFIG invalid wire", 				// CONFIG_WIRE	    6
	"CONFIG two many inputs to object",		// CONFIG_INPS	    7
	"CONFIG error during config_iterate",		// CONFIG_IT	    8
	"CONFIG error passing message to object",	// CONFIG_MESS	    9
	"VPBMAIN unknown message type in dispatcher"	// VPBMAIN_MESSAGE  10
};
#endif


/*--------------------------------------------------------------------------*\

	FUNCTION.: translate
	AUTHOR...: David Rowe
	DATE.....: 1/12/97

	Translates a message from the VPB to a human readable string.  The
	calling function is assumed to have MAX_STR storage available in
	s[].

\*--------------------------------------------------------------------------*/

void translate(unsigned short board, char s[], uint16_t mess[])
//  unsigned short board	VPB board number event came from
//  char   s[]		string containing translated message
//  uint16_t   mess[]	message from VPB
{
	long   l;
	long   sum,num;

	switch(mess[1]) {

		case DSP_PONG:
			sprintf(s, "[%02d] Pong\n",board);
		break;

		//XXX
		#if 0
		case DSP_ERROR:
			sprintf(s, "[%02d] DSP Error: %s\n",board,
				errors[mess[2]]);
		break;
		#endif

		case DSP_TONED:
			sprintf(s, "[%02d] CP[%02d] tone detected,"
				"event code = %02d\n",board,mess[2],mess[3]);
		break;

	      #if 0
		case DSP_TONEDOK:
			sprintf(s, "[%02d] CP[%02d] state table OK\n",board,
				mess[2]);
		break;
	      #endif

		case DSP_TONEG:
			sprintf(s, "[%02d] TONEG[%02d] finished (ready for"
				"next tone)\n",board,mess[2]);
		break;

		case DSP_CONFIG_AF:
			sprintf(s, "[%02d] FIFO[%02d] address: %04x\n",
				board,mess[2],mess[4]);
		break;

		case DSP_DTMF:
			sprintf(s, "[%02d] DTMF[%02d] digit %c detected\n",
				board,mess[2],mess[3]);
		break;

		case DSP_CONFIG_FUO:
			sprintf(s, "[%02d] FIFO[%02d] overflow\n",board,
				mess[2]);
		break;

		case DSP_CONFIG_FDU:
			sprintf(s, "[%02d] FIFO[%02d] underflow\n",board,
				mess[2]);
		break;

		case DSP_COMM_MOF:
			sprintf(s, "[%02d] Up message queue overflow\n",board);
		break;

		case DSP_CODEC_RING:
			sprintf(s, "[%02d] CH[%02d] Ring\n",board,mess[2]);
		break;

		case DSP_SPI_LOAD:
			sum = mess[6];
			sum <<= 16;
			sum += mess[7];
			num = mess[8];
			num <<= 16;
			num += mess[9];
			sprintf(s, "[%02d] sam: %3.2f MIPs max: %3.2f MIPs av:"
				"%3.2f MIPs\n",
				board,40.0*mess[3]/mess[10],
				40.0*mess[5]/mess[10],
				(40.0/mess[10])*(float)sum/num);
		break;

		case DSP_DEBUG_LONG:
			l = mess[3];
			l <<= 16;
			l+= mess[4];
			sprintf(s, "debug long[%d] %ld\n",mess[2],l);
		break;

		case DSP_DEBUG_ARRAY:
			l = mess[3];
			{
				int i;
				FILE *f=fopen("mal.txt","wt");
				for(i=0; i<l; i++)
					fprintf(f,"%d\n",(short)mess[4+i]);
				fclose(f);
			}
			sprintf(s, "debug array[%d]\n",mess[2]);
		break;

		case DSP_DEBUG_STACK:
			l = mess[3];
			sprintf(s, "debug stack[%d] 0x%x\n",mess[2],(unsigned short)l);
		break;

		case DSP_VOXON:
			sprintf(s, "Board[%02d] channel[%02d] VOX ON, "
				"event code = %02d\n",board,mess[2],mess[1]);
		break;

		case DSP_VOXOFF:
			sprintf(s, "Board[%02d] channel[%02d] VOX OFF, "
				"event code = %02d\n",board,mess[2],mess[1]);
		break;

		default:
			sprintf(s, "UNKNOWN EVENT Board[%02d] channel[%02d], "
				"event code = %02d\n",board,mess[2],mess[1]);
		break;
	}

	// make sure we havent made s[] to long

	assert(strlen(s) < (MAX_STR-1));
}


