
/* DSP -> PC messages -----------------------------------------------------*/

#ifndef __MESSAGES_DSP_PC__
#define __MESSAGES_DSP_PC__

#define DSP_PONG		1	/* reply to PC_PING			*/
//#define DSP_ERROR		2	/* see error message defs		*/
#define DSP_TONED		4	/* tone det tone detected		*/
//#define DSP_TONEDOK		5	/* tone det state table OK		*/
#define DSP_TONEG		6	/* tone generator finished		*/
#define DSP_CONFIG_AF		7	/* address of channel fifo		*/
#define DSP_DTMF		8	/* DTMF digit detected			*/
#define DSP_CONFIG_FUO		9	/* FIFO UP overflow			*/
#define DSP_CONFIG_FDU		10	/* FIFO DOWN underflow			*/
#define DSP_COMM_MOF		11	/* DSP up message FIFO overflow		*/
#define DSP_CODEC_RING		12	/* RING rising edge detected		*/
#define DSP_SPI_LOAD		13	/* computational load report		*/
#define DSP_CODEC_BKEN		14	/* loop break finished			*/
#define DSP_DEBUG_LONG		15	/* upload a long to PC for debug	*/
#define DSP_DEBUG_ARRAY		16	/* upload an array of shorts to PC 	*/
#define DSP_DEBUG_STACK		17	/* upload current stack position 	*/
#define DSP_TONED_LOG		18	/* upload tone det debug info		*/
#define DSP_VOXON		19	/* voice channel BUSY			*/
#define DSP_VOXOFF		20	/* voice switch IDLE			*/
#define DSP_FIFODIS		21	/* FIFO has been disabled		*/
#define DSP_CODEC_HKOFF		22	/* station port off hook                */
#define DSP_CODEC_HKON		23	/* station port on hook                 */
#define DSP_RING_OFF		24	/* RING falling edge detected		*/
#define DSP_DROP		25	/* Loop drop detected                   */
#define DSP_CODEC_FLASH		26	/* station port hook flash              */
#define DSP_DTMF_DOWN		27	/* DTMF key DOWN event                  */
#define DSP_ISDN_ANS		28	/* A call setup has been ansered 	*/
#define DSP_ISDN_BUSY		29	/* A call setup was busy		*/
#define DSP_ISDN_GET_CINFO	30	/* Upload the calling number		*/
#define DSP_ISDN_GET_CNAM	31	/* Upload the calling name		*/
#define DSP_ISDN_GET_CDNUM	32	/* Upload the called  number		*/
#define DSP_ISDN_CALL_FAIL	33	/* ISDN call failed			*/
#define DSP_ISDN_ANS_FAIL	34	/* ISDN Answer failed			*/
#define DSP_ISDN_RING		35	/* ISDN Ring event, including Call info */
#define DSP_ISDN_PROCEEDING	36	/* ISDN Proceeding event		*/
#define DSP_ISDN_RINGING	37	/* ISDN ringing event			*/
#define DSP_LOOP_OFFHOOK	38	/* Loop Off hook from OpenPCI           */
#define DSP_LOOP_ONHOOK		39	/* Loop On hook from OpenPCI            */
#define DSP_LOOP_POLARITY	40	/* Loop Polarity from OpenPCI           */
#define DSP_LOOP_NOBATT		41	/* Loop battery removed from OpenPCI    */
#define DSP_LOOP_FLASH		42	/* Loop flash detected			*/

#define DSP_PROSLIC_SANITY	50	/* Sanity alert from a ProSLIC port 	*/
#define DSP_PROSLIC_PWR_ALARM	51	/* Power Alarm from a ProSLIC port 	*/
#define DSP_VDAA_ISO_FRAME_E	52	/* ISO-cap frame sync lost on VDAA port */
#define DSP_VDAA_CURRENT	53	/* Under current values for port state  */

#define DSP_ERROR_VDAA		55      /* Error from the VDAA module           */
#define DSP_ERROR_PROSLIC	56      /* Error from the ProSLIC module        */
#define DSP_ERROR_OPCI		57      /* Error from the OpenPCI firmware      */

#define DSP_DTMF_0		64	/* DTMF digit 0 detected		*/
#define DSP_DTMF_1		65	/* DTMF digit 1 detected		*/
#define DSP_DTMF_2		66	/* DTMF digit 2 detected		*/
#define DSP_DTMF_3		67	/* DTMF digit 3 detected		*/
#define DSP_DTMF_4		68	/* DTMF digit 4 detected		*/
#define DSP_DTMF_5		69	/* DTMF digit 5 detected		*/
#define DSP_DTMF_6		70	/* DTMF digit 6 detected		*/
#define DSP_DTMF_7		71	/* DTMF digit 7 detected		*/
#define DSP_DTMF_8		72	/* DTMF digit 8 detected		*/
#define DSP_DTMF_9		73	/* DTMF digit 9 detected		*/
#define DSP_DTMF_A		74	/* DTMF digit A detected		*/
#define DSP_DTMF_B		75	/* DTMF digit B detected		*/
#define DSP_DTMF_C		76	/* DTMF digit C detected		*/
#define DSP_DTMF_D		77	/* DTMF digit D detected		*/
#define DSP_DTMF_STAR		78	/* DTMF digit * detected		*/
#define DSP_DTMF_HASH		79	/* DTMF digit # detected		*/

/* length of DSP -> PC messages (if fixed) */

#define DSP_LPONG		2
//#define DSP_LERROR		3
#define DSP_LTONED		4
//#define DSP_LTONEDOK		3
#define DSP_LTONEG		3
#define DSP_LCONFIG_AF		5
#define DSP_LDTMF		4
#define DSP_LCONFIG_FUO		3
#define DSP_LCONFIG_FDU		3
#define DSP_LCOMM_MOF 		2
#define DSP_LCODEC_RING		3
#define DSP_LSPI_LOAD		11
#define DSP_LCODEC_BKEN		3
#define DSP_LDEBUG_LONG		5
#define DSP_LDEBUG_STACK	4
#define DSP_LTONED_LOG		16
#define DSP_LVOXON		3
#define DSP_LVOXOFF		3
#define DSP_LFIFODIS		3
#define DSP_LCODEC_HKOFF	3
#define DSP_LCODEC_HKON		3
#define DSP_LRING_OFF		3
#define DSP_LDROP		3
#define DSP_LCODEC_FLASH	3
#define DSP_LDTMF_DOWN		4
#define DSP_LISDN_ANS		3
#define DSP_LISDN_BUSY		4
#define DSP_LISDN_GET_CINFO	131
#define DSP_LISDN_GET_CNAM	131
#define DSP_LISDN_GET_CDNUM	131
#define DSP_LISDN_CALL_FAIL	4
#define DSP_LISDN_ANS_FAIL	4
#define DSP_LISDN_PROCEEDING	4
#define DSP_LISDN_RINGING	4
#define DSP_LISDN_RING		4
#define DSP_LLOOP_OFFHOOK	3
#define DSP_LLOOP_ONHOOK	3
#define DSP_LLOOP_POLARITY	3
#define DSP_LLOOP_NOBATT	3
#define DSP_LLOOP_FLASH		3
#define DSP_LDTMF_DIGIT 	3

#endif
