// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLSL2_2D_4S_S_TRACE_AARCH64_H_
#define VIXL_SIM_UMLSL2_2D_4S_S_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_umlsl2_2D_4S_S[] = {
  0xffffffc1017a0000, 0x0000000000000001,
  0xffffff8182f70000, 0x0000000000000001,
  0xffffbf8482ee0000, 0x0000000000000001,
  0xffffbf8482ee0000, 0x0000000000000001,
  0xffffffc0817d0000, 0x0000000000000001,
  0xffffbfc381740000, 0x0000000000000001,
  0xffffbfc381740000, 0x0000000000000001,
  0xffffbfc380f40300, 0x0000000000000001,
  0xffffc002fff70000, 0x0000000000000001,
  0xffffc002fff70000, 0x0000000000000001,
  0xffffc002ff770300, 0x0000000000000001,
  0xffffc002fe770900, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffff800300, 0x0000000000000001,
  0xfffffffffe800900, 0x0000000000000001,
  0xffffffffee806900, 0x0000000000000001,
  0xffffffffff800300, 0x0000000000000001,
  0xfffffffffe800900, 0x0000000000000001,
  0xffffffffee806900, 0x0000000000000001,
  0xffffffffb001e000, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xffffffffef006600, 0x0000000000000001,
  0xffffffffb081dd00, 0x0000000000000001,
  0xffffffff71835700, 0x0000000000000001,
  0xfffffffff0006000, 0x0000000000000001,
  0xffffffffb181d700, 0x0000000000000001,
  0xffffffff72835100, 0x0000000000000001,
  0xffffffff3304ce00, 0x0000000000000001,
  0xffffffffc1817700, 0x0000000000000001,
  0xffffffff8282f100, 0x0000000000000001,
  0xffffffff43046e00, 0x0000000000000001,
  0xffffffbf46046500, 0x0000000000000001,
  0xffffffffc1017a00, 0x0000000000000001,
  0xffffffff8182f700, 0x0000000000000001,
  0xffffffbf8482ee00, 0x0000000000000001,
  0xffffff7f8702e800, 0x0000000000000001,
  0xffffffffc0817d00, 0x0000000000000001,
  0xffffffbfc3817400, 0x0000000000000001,
  0xffffff7fc6016e00, 0x0000000000000001,
  0xffffff3fc8016b00, 0x0000000000000001,
  0xffffffc002fff700, 0x0000000000000001,
  0xffffff80057ff100, 0x0000000000000001,
  0xffffff40077fee00, 0x0000000000000001,
  0xffe6664007998700, 0x0000000000000001,
  0xffffffc0027ffa00, 0x0000000000000001,
  0xffffff80047ff700, 0x0000000000000001,
  0xffe6668004999000, 0x0000000000000001,
  0xffbbbcd55a198f00, 0x0000000000000001,
  0xffffffc001fffd00, 0x0000000000000001,
  0xffe666c002199600, 0x0000000000000001,
  0xffbbbd1557999500, 0x0000000000000001,
  0xff7bbe9559198c00, 0x0000000000000001,
  0xffe6670000199900, 0x0000000000000001,
  0xffbbbd5555999800, 0x0000000000000001,
  0xff7bbed557198f00, 0x0000000000000001,
  0xff3bc05558198900, 0x0000000000000001,
  0xffd55655557fff00, 0x0000000000000001,
  0xff9557d556fff600, 0x0000000000000001,
  0xff55595557fff000, 0x0000000000000001,
  0xff155ad5587fed00, 0x0000000000000001,
  0xffc00180017ff700, 0x0000000000000001,
  0xff800300027ff100, 0x0000000000000001,
  0xff40048002ffee00, 0x0000000000000001,
  0xff00060002ffee00, 0x0000000000000001,
  0xffc0018000fffa00, 0x0000000000000001,
  0xff800300017ff700, 0x0000000000000001,
  0xff400480017ff700, 0x0000000000000001,
  0xff00060000fffa00, 0x0000000000000001,
  0xffc00180007ffd00, 0x0000000000000001,
  0xff800300007ffd00, 0x0000000000000001,
  0xff40048000000000, 0x0000000000000001,
  0xfeeab12aaafffe00, 0x0000000000000001,
  0xffc0018000000000, 0x0000000000000001,
  0xff8002ffff800300, 0x0000000000000001,
  0xff2aafaaaa800100, 0x0000000000000001,
  0xfec44baaaae66500, 0x0000000000000001,
  0xffc0017fff800300, 0x0000000000000001,
  0xff6aae2aaa800100, 0x0000000000000001,
  0xff044a2aaae66500, 0x0000000000000001,
  0xfe844d6aa9666500, 0x0000000000000001,
  0xffaaacaaaafffe00, 0x0000000000000001,
  0xff4448aaab666200, 0x0000000000000001,
  0xfec44beaa9e66200, 0x0000000000000001,
  0xfe444f2aa7e66500, 0x0000000000000001,
  0xff999c0000666400, 0x0000000000000001,
  0xff199f3ffee66400, 0x0000000000000001,
  0xfe99a27ffce66700, 0x0000000000000001,
  0xfe19a5bffa666d00, 0x0000000000000001,
  0xff80033ffe800000, 0x0000000000000001,
  0xff00067ffc800300, 0x0000000000000001,
  0xfe8009bffa000900, 0x0000000000000001,
  0xfe000cfff7001200, 0x0000000000000001,
  0xff80033ffe000300, 0x0000000000000001,
  0xff00067ffb800900, 0x0000000000000001,
  0xfe8009bff8801200, 0x0000000000000001,
  0xfe000cc0387e9200, 0x0000000000000001,
  0xff80033ffd800600, 0x0000000000000001,
  0xff00067ffa800f00, 0x0000000000000001,
  0xfe8009803a7e8f00, 0x0000000000000001,
  0xfe000c8079fd1200, 0x0000000000000001,
  0xff80033ffd000900, 0x0000000000000001,
  0xff0006403cfe8900, 0x0000000000000001,
  0xfe8009407c7d0c00, 0x0000000000000001,
  0xfe000c40bb7b9200, 0x0000000000000001,
  0xff8003003ffe8000, 0x0000000000000001,
  0xff0006007f7d0300, 0x0000000000000001,
  0xfe800900be7b8900, 0x0000000000000001,
  0xfe000c00fcfa1200, 0x0000000000000001,
  0xff8003003f7e8300, 0x0000000000000001,
  0xff0006007e7d0900, 0x0000000000000001,
  0xfe800900bcfb9200, 0x0000000000000001,
  0xfe000c00ccfb3200, 0x0000000000000001,
  0xff8003003efe8600, 0x0000000000000001,
  0xff0006007d7d0f00, 0x0000000000000001,
  0xfe8009008d7caf00, 0x0000000000000001,
  0xfe000c008efca600, 0x0000000000000001,
  0xff8003003e7e8900, 0x0000000000000001,
  0xff0006004e7e2900, 0x0000000000000001,
  0xfe8009004ffe2000, 0x0000000000000001,
  0xfe000c0050fe1a00, 0x0000000000000001,
  0xff8003000fffa000, 0x0000000000000001,
  0xff000600117f9700, 0x0000000000000001,
  0xfe800900127f9100, 0x0000000000000001,
  0xfe000c0012ff8e00, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000004,
  0x0000000000000000, 0xfffffffe00000006,
  0x0000000000000000, 0xfffffffd00000007,
  0x0000000000000000, 0xfffffffd00000007,
  0x0000000000000000, 0xffffffff00000003,
  0x0000000000000000, 0xfffffffe00000004,
  0x0000000000000000, 0xfffffffe00000004,
  0x0000000000000000, 0xfffffffe00000003,
  0x0000000000000000, 0xffffffff00000002,
  0x0000000000000000, 0xffffffff00000002,
  0x0000000000000000, 0xffffffff00000001,
  0x0000000000000000, 0xfffffffeffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffde,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffde,
  0x0000000000000000, 0xffffffffffffff61,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffdf,
  0x0000000000000000, 0xffffffffffffff62,
  0x0000000000000000, 0xfffffffffffffee4,
  0x0000000000000000, 0xffffffffffffffe1,
  0x0000000000000000, 0xffffffffffffff64,
  0x0000000000000000, 0xfffffffffffffee6,
  0x0000000000000000, 0xfffffffffffffe67,
  0x0000000000000000, 0xffffffffffffff84,
  0x0000000000000000, 0xffffffffffffff06,
  0x0000000000000000, 0xfffffffffffffe87,
  0x0000000000000000, 0xffffffffffff7e8a,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff04,
  0x0000000000000000, 0xffffffffffff7f07,
  0x0000000000000000, 0xfffffffffffeff09,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffff7f85,
  0x0000000000000000, 0xfffffffffffeff87,
  0x0000000000000000, 0xfffffffffffe7f88,
  0x0000000000000000, 0xffffffffffff8004,
  0x0000000000000000, 0xffffffffffff0006,
  0x0000000000000000, 0xfffffffffffe8007,
  0x0000000000000000, 0xffffffffcccb4cd4,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffff0004,
  0x0000000000000000, 0xffffffffcccbccd1,
  0x0000000000000000, 0xffffffff7776777c,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffcccc4ccf,
  0x0000000000000000, 0xffffffff7776f77a,
  0x0000000000000000, 0xfffffffef776f77d,
  0x0000000000000000, 0xffffffffccccccce,
  0x0000000000000000, 0xffffffff77777779,
  0x0000000000000000, 0xfffffffef777777c,
  0x0000000000000000, 0xfffffffe7777777e,
  0x0000000000000000, 0xffffffffaaaaaaac,
  0x0000000000000000, 0xffffffff2aaaaaaf,
  0x0000000000000000, 0xfffffffeaaaaaab1,
  0x0000000000000000, 0xfffffffe2aaaaab2,
  0x0000000000000000, 0xffffffff80000004,
  0x0000000000000000, 0xffffffff00000006,
  0x0000000000000000, 0xfffffffe80000007,
  0x0000000000000000, 0xfffffffe00000007,
  0x0000000000000000, 0xffffffff80000003,
  0x0000000000000000, 0xffffffff00000004,
  0x0000000000000000, 0xfffffffe80000004,
  0x0000000000000000, 0xfffffffe00000003,
  0x0000000000000000, 0xffffffff80000002,
  0x0000000000000000, 0xffffffff00000002,
  0x0000000000000000, 0xfffffffe80000001,
  0x0000000000000000, 0xfffffffdd5555557,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffff00000000,
  0x0000000000000000, 0xfffffffe55555556,
  0x0000000000000000, 0xfffffffd8888888a,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xfffffffed5555556,
  0x0000000000000000, 0xfffffffe0888888a,
  0x0000000000000000, 0xfffffffd0889088a,
  0x0000000000000000, 0xffffffff55555557,
  0x0000000000000000, 0xfffffffe8888888b,
  0x0000000000000000, 0xfffffffd8889088b,
  0x0000000000000000, 0xfffffffc8889888a,
  0x0000000000000000, 0xffffffff33333335,
  0x0000000000000000, 0xfffffffe3333b335,
  0x0000000000000000, 0xfffffffd33343334,
  0x0000000000000000, 0xfffffffc3334b332,
  0x0000000000000000, 0xffffffff00008001,
  0x0000000000000000, 0xfffffffe00010000,
  0x0000000000000000, 0xfffffffd00017ffe,
  0x0000000000000000, 0xfffffffc0001fffb,
  0x0000000000000000, 0xffffffff00008000,
  0x0000000000000000, 0xfffffffe0000fffe,
  0x0000000000000000, 0xfffffffd00017ffb,
  0x0000000000000000, 0xfffffffc0001807b,
  0x0000000000000000, 0xffffffff00007fff,
  0x0000000000000000, 0xfffffffe0000fffc,
  0x0000000000000000, 0xfffffffd0001007c,
  0x0000000000000000, 0xfffffffc000100fb,
  0x0000000000000000, 0xffffffff00007ffe,
  0x0000000000000000, 0xfffffffe0000807e,
  0x0000000000000000, 0xfffffffd000080fd,
  0x0000000000000000, 0xfffffffc0000817b,
  0x0000000000000000, 0xffffffff00000081,
  0x0000000000000000, 0xfffffffe00000100,
  0x0000000000000000, 0xfffffffd0000017e,
  0x0000000000000000, 0xfffffffc000001fb,
  0x0000000000000000, 0xffffffff00000080,
  0x0000000000000000, 0xfffffffe000000fe,
  0x0000000000000000, 0xfffffffd0000017b,
  0x0000000000000000, 0xfffffffc0000019b,
  0x0000000000000000, 0xffffffff0000007f,
  0x0000000000000000, 0xfffffffe000000fc,
  0x0000000000000000, 0xfffffffd0000011c,
  0x0000000000000000, 0xfffffffc0000011f,
  0x0000000000000000, 0xffffffff0000007e,
  0x0000000000000000, 0xfffffffe0000009e,
  0x0000000000000000, 0xfffffffd000000a1,
  0x0000000000000000, 0xfffffffc000000a3,
  0x0000000000000000, 0xffffffff00000021,
  0x0000000000000000, 0xfffffffe00000024,
  0x0000000000000000, 0xfffffffd00000026,
  0x0000000000000000, 0xfffffffc00000027,
  0xffffffff00000003, 0xfffffffe00000007,
  0xfffffffe00000005, 0xfffffffc0000000b,
  0xfffffffd00000006, 0xfffffffa0000000d,
  0xfffffffd00000006, 0xfffffffa0000000d,
  0xffffffff00000002, 0xfffffffe00000005,
  0xfffffffe00000003, 0xfffffffc00000007,
  0xfffffffe00000003, 0xfffffffc00000007,
  0xfffffffe00000002, 0xfffffffc00000005,
  0xffffffff00000001, 0xfffffffe00000003,
  0xffffffff00000001, 0xfffffffe00000003,
  0xffffffff00000000, 0xfffffffe00000001,
  0xfffffffefffffffe, 0xfffffffdfffffffd,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xffffffffffffffdd, 0xffffffffffffffbb,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xffffffffffffffdd, 0xffffffffffffffbb,
  0xffffffffffffff60, 0xfffffffffffffec1,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xffffffffffffffde, 0xffffffffffffffbd,
  0xffffffffffffff61, 0xfffffffffffffec3,
  0xfffffffffffffee3, 0xfffffffffffffdc7,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffff63, 0xfffffffffffffec7,
  0xfffffffffffffee5, 0xfffffffffffffdcb,
  0xfffffffffffffe66, 0xfffffffffffffccd,
  0xffffffffffffff83, 0xffffffffffffff07,
  0xffffffffffffff05, 0xfffffffffffffe0b,
  0xfffffffffffffe86, 0xfffffffffffffd0d,
  0xffffffffffff7e89, 0xfffffffffffefd13,
  0xffffffffffffff82, 0xffffffffffffff05,
  0xffffffffffffff03, 0xfffffffffffffe07,
  0xffffffffffff7f06, 0xfffffffffffefe0d,
  0xfffffffffffeff08, 0xfffffffffffdfe11,
  0xffffffffffffff81, 0xffffffffffffff03,
  0xffffffffffff7f84, 0xfffffffffffeff09,
  0xfffffffffffeff86, 0xfffffffffffdff0d,
  0xfffffffffffe7f87, 0xfffffffffffcff0f,
  0xffffffffffff8003, 0xffffffffffff0007,
  0xffffffffffff0005, 0xfffffffffffe000b,
  0xfffffffffffe8006, 0xfffffffffffd000d,
  0xffffffffcccb4cd3, 0xffffffff999699a7,
  0xffffffffffff8002, 0xffffffffffff0005,
  0xffffffffffff0003, 0xfffffffffffe0007,
  0xffffffffcccbccd0, 0xffffffff999799a1,
  0xffffffff7776777b, 0xfffffffeeeeceef7,
  0xffffffffffff8001, 0xffffffffffff0003,
  0xffffffffcccc4cce, 0xffffffff9998999d,
  0xffffffff7776f779, 0xfffffffeeeedeef3,
  0xfffffffef776f77c, 0xfffffffdeeedeef9,
  0xffffffffcccccccd, 0xffffffff9999999b,
  0xffffffff77777778, 0xfffffffeeeeeeef1,
  0xfffffffef777777b, 0xfffffffdeeeeeef7,
  0xfffffffe7777777d, 0xfffffffceeeeeefb,
  0xffffffffaaaaaaab, 0xffffffff55555557,
  0xffffffff2aaaaaae, 0xfffffffe5555555d,
  0xfffffffeaaaaaab0, 0xfffffffd55555561,
  0xfffffffe2aaaaab1, 0xfffffffc55555563,
  0xffffffff80000003, 0xffffffff00000007,
  0xffffffff00000005, 0xfffffffe0000000b,
  0xfffffffe80000006, 0xfffffffd0000000d,
  0xfffffffe00000006, 0xfffffffc0000000d,
  0xffffffff80000002, 0xffffffff00000005,
  0xffffffff00000003, 0xfffffffe00000007,
  0xfffffffe80000003, 0xfffffffd00000007,
  0xfffffffe00000002, 0xfffffffc00000005,
  0xffffffff80000001, 0xffffffff00000003,
  0xffffffff00000001, 0xfffffffe00000003,
  0xfffffffe80000000, 0xfffffffd00000001,
  0xfffffffdd5555556, 0xfffffffbaaaaaaad,
  0xffffffff80000000, 0xffffffff00000001,
  0xfffffffeffffffff, 0xfffffffdffffffff,
  0xfffffffe55555555, 0xfffffffcaaaaaaab,
  0xfffffffd88888889, 0xfffffffb11111113,
  0xffffffff7fffffff, 0xfffffffeffffffff,
  0xfffffffed5555555, 0xfffffffdaaaaaaab,
  0xfffffffe08888889, 0xfffffffc11111113,
  0xfffffffd08890889, 0xfffffffa11121113,
  0xffffffff55555556, 0xfffffffeaaaaaaad,
  0xfffffffe8888888a, 0xfffffffd11111115,
  0xfffffffd8889088a, 0xfffffffb11121115,
  0xfffffffc88898889, 0xfffffff911131113,
  0xffffffff33333334, 0xfffffffe66666669,
  0xfffffffe3333b334, 0xfffffffc66676669,
  0xfffffffd33343333, 0xfffffffa66686667,
  0xfffffffc3334b331, 0xfffffff866696663,
  0xffffffff00008000, 0xfffffffe00010001,
  0xfffffffe0000ffff, 0xfffffffc0001ffff,
  0xfffffffd00017ffd, 0xfffffffa0002fffb,
  0xfffffffc0001fffa, 0xfffffff80003fff5,
  0xffffffff00007fff, 0xfffffffe0000ffff,
  0xfffffffe0000fffd, 0xfffffffc0001fffb,
  0xfffffffd00017ffa, 0xfffffffa0002fff5,
  0xfffffffc0001807a, 0xfffffff8000300f5,
  0xffffffff00007ffe, 0xfffffffe0000fffd,
  0xfffffffe0000fffb, 0xfffffffc0001fff7,
  0xfffffffd0001007b, 0xfffffffa000200f7,
  0xfffffffc000100fa, 0xfffffff8000201f5,
  0xffffffff00007ffd, 0xfffffffe0000fffb,
  0xfffffffe0000807d, 0xfffffffc000100fb,
  0xfffffffd000080fc, 0xfffffffa000101f9,
  0xfffffffc0000817a, 0xfffffff8000102f5,
  0xffffffff00000080, 0xfffffffe00000101,
  0xfffffffe000000ff, 0xfffffffc000001ff,
  0xfffffffd0000017d, 0xfffffffa000002fb,
  0xfffffffc000001fa, 0xfffffff8000003f5,
  0xffffffff0000007f, 0xfffffffe000000ff,
  0xfffffffe000000fd, 0xfffffffc000001fb,
  0xfffffffd0000017a, 0xfffffffa000002f5,
  0xfffffffc0000019a, 0xfffffff800000335,
  0xffffffff0000007e, 0xfffffffe000000fd,
  0xfffffffe000000fb, 0xfffffffc000001f7,
  0xfffffffd0000011b, 0xfffffffa00000237,
  0xfffffffc0000011e, 0xfffffff80000023d,
  0xffffffff0000007d, 0xfffffffe000000fb,
  0xfffffffe0000009d, 0xfffffffc0000013b,
  0xfffffffd000000a0, 0xfffffffa00000141,
  0xfffffffc000000a2, 0xfffffff800000145,
  0xffffffff00000020, 0xfffffffe00000041,
  0xfffffffe00000023, 0xfffffffc00000047,
  0xfffffffd00000025, 0xfffffffa0000004b,
  0xfffffffc00000026, 0xfffffff80000004d,
  0xfffffffe00000006, 0xffffffe000000061,
  0xfffffffc0000000a, 0xffffffc0000000a1,
  0xfffffffa0000000c, 0xffffffa0000000c1,
  0xfffffffa0000000c, 0xffffffa0000000c1,
  0xfffffffe00000004, 0xffffffe000000041,
  0xfffffffc00000006, 0xffffffc000000061,
  0xfffffffc00000006, 0xffffffc000000061,
  0xfffffffc00000004, 0xffffffc000000041,
  0xfffffffe00000002, 0xffffffe000000021,
  0xfffffffe00000002, 0xffffffe000000021,
  0xfffffffe00000000, 0xffffffe000000001,
  0xfffffffdfffffffc, 0xffffffdfffffffc1,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffe, 0xffffffffffffffe1,
  0xfffffffffffffffa, 0xffffffffffffffa1,
  0xffffffffffffffba, 0xfffffffffffffba1,
  0xfffffffffffffffe, 0xffffffffffffffe1,
  0xfffffffffffffffa, 0xffffffffffffffa1,
  0xffffffffffffffba, 0xfffffffffffffba1,
  0xfffffffffffffec0, 0xffffffffffffec01,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0xffffffffffffffbc, 0xfffffffffffffbc1,
  0xfffffffffffffec2, 0xffffffffffffec21,
  0xfffffffffffffdc6, 0xffffffffffffdc61,
  0xffffffffffffffc0, 0xfffffffffffffc01,
  0xfffffffffffffec6, 0xffffffffffffec61,
  0xfffffffffffffdca, 0xffffffffffffdca1,
  0xfffffffffffffccc, 0xffffffffffffccc1,
  0xffffffffffffff06, 0xfffffffffffff061,
  0xfffffffffffffe0a, 0xffffffffffffe0a1,
  0xfffffffffffffd0c, 0xffffffffffffd0c1,
  0xfffffffffffefd12, 0xffffffffffefd121,
  0xffffffffffffff04, 0xfffffffffffff041,
  0xfffffffffffffe06, 0xffffffffffffe061,
  0xfffffffffffefe0c, 0xffffffffffefe0c1,
  0xfffffffffffdfe10, 0xffffffffffdfe101,
  0xffffffffffffff02, 0xfffffffffffff021,
  0xfffffffffffeff08, 0xffffffffffeff081,
  0xfffffffffffdff0c, 0xffffffffffdff0c1,
  0xfffffffffffcff0e, 0xffffffffffcff0e1,
  0xffffffffffff0006, 0xfffffffffff00061,
  0xfffffffffffe000a, 0xffffffffffe000a1,
  0xfffffffffffd000c, 0xffffffffffd000c1,
  0xffffffff999699a6, 0xfffffff999699a61,
  0xffffffffffff0004, 0xfffffffffff00041,
  0xfffffffffffe0006, 0xffffffffffe00061,
  0xffffffff999799a0, 0xfffffff999799a01,
  0xfffffffeeeeceef6, 0xffffffeeeeceef61,
  0xffffffffffff0002, 0xfffffffffff00021,
  0xffffffff9998999c, 0xfffffff9998999c1,
  0xfffffffeeeedeef2, 0xffffffeeeedeef21,
  0xfffffffdeeedeef8, 0xffffffdeeedeef81,
  0xffffffff9999999a, 0xfffffff9999999a1,
  0xfffffffeeeeeeef0, 0xffffffeeeeeeef01,
  0xfffffffdeeeeeef6, 0xffffffdeeeeeef61,
  0xfffffffceeeeeefa, 0xffffffceeeeeefa1,
  0xffffffff55555556, 0xfffffff555555561,
  0xfffffffe5555555c, 0xffffffe5555555c1,
  0xfffffffd55555560, 0xffffffd555555601,
  0xfffffffc55555562, 0xffffffc555555621,
  0xffffffff00000006, 0xfffffff000000061,
  0xfffffffe0000000a, 0xffffffe0000000a1,
  0xfffffffd0000000c, 0xffffffd0000000c1,
  0xfffffffc0000000c, 0xffffffc0000000c1,
  0xffffffff00000004, 0xfffffff000000041,
  0xfffffffe00000006, 0xffffffe000000061,
  0xfffffffd00000006, 0xffffffd000000061,
  0xfffffffc00000004, 0xffffffc000000041,
  0xffffffff00000002, 0xfffffff000000021,
  0xfffffffe00000002, 0xffffffe000000021,
  0xfffffffd00000000, 0xffffffd000000001,
  0xfffffffbaaaaaaac, 0xffffffbaaaaaaac1,
  0xffffffff00000000, 0xfffffff000000001,
  0xfffffffdfffffffe, 0xffffffdfffffffe1,
  0xfffffffcaaaaaaaa, 0xffffffcaaaaaaaa1,
  0xfffffffb11111112, 0xffffffb111111121,
  0xfffffffefffffffe, 0xffffffefffffffe1,
  0xfffffffdaaaaaaaa, 0xffffffdaaaaaaaa1,
  0xfffffffc11111112, 0xffffffc111111121,
  0xfffffffa11121112, 0xffffffa111211121,
  0xfffffffeaaaaaaac, 0xffffffeaaaaaaac1,
  0xfffffffd11111114, 0xffffffd111111141,
  0xfffffffb11121114, 0xffffffb111211141,
  0xfffffff911131112, 0xffffff9111311121,
  0xfffffffe66666668, 0xffffffe666666681,
  0xfffffffc66676668, 0xffffffc666766681,
  0xfffffffa66686666, 0xffffffa666866661,
  0xfffffff866696662, 0xffffff8666966621,
  0xfffffffe00010000, 0xffffffe000100001,
  0xfffffffc0001fffe, 0xffffffc0001fffe1,
  0xfffffffa0002fffa, 0xffffffa0002fffa1,
  0xfffffff80003fff4, 0xffffff80003fff41,
  0xfffffffe0000fffe, 0xffffffe0000fffe1,
  0xfffffffc0001fffa, 0xffffffc0001fffa1,
  0xfffffffa0002fff4, 0xffffffa0002fff41,
  0xfffffff8000300f4, 0xffffff8000300f41,
  0xfffffffe0000fffc, 0xffffffe0000fffc1,
  0xfffffffc0001fff6, 0xffffffc0001fff61,
  0xfffffffa000200f6, 0xffffffa000200f61,
  0xfffffff8000201f4, 0xffffff8000201f41,
  0xfffffffe0000fffa, 0xffffffe0000fffa1,
  0xfffffffc000100fa, 0xffffffc000100fa1,
  0xfffffffa000101f8, 0xffffffa000101f81,
  0xfffffff8000102f4, 0xffffff8000102f41,
  0xfffffffe00000100, 0xffffffe000001001,
  0xfffffffc000001fe, 0xffffffc000001fe1,
  0xfffffffa000002fa, 0xffffffa000002fa1,
  0xfffffff8000003f4, 0xffffff8000003f41,
  0xfffffffe000000fe, 0xffffffe000000fe1,
  0xfffffffc000001fa, 0xffffffc000001fa1,
  0xfffffffa000002f4, 0xffffffa000002f41,
  0xfffffff800000334, 0xffffff8000003341,
  0xfffffffe000000fc, 0xffffffe000000fc1,
  0xfffffffc000001f6, 0xffffffc000001f61,
  0xfffffffa00000236, 0xffffffa000002361,
  0xfffffff80000023c, 0xffffff80000023c1,
  0xfffffffe000000fa, 0xffffffe000000fa1,
  0xfffffffc0000013a, 0xffffffc0000013a1,
  0xfffffffa00000140, 0xffffffa000001401,
  0xfffffff800000144, 0xffffff8000001441,
  0xfffffffe00000040, 0xffffffe000000401,
  0xfffffffc00000046, 0xffffffc000000461,
  0xfffffffa0000004a, 0xffffffa0000004a1,
  0xfffffff80000004c, 0xffffff80000004c1,
  0xffffffe000000060, 0xffffff8300000178,
  0xffffffc0000000a0, 0xffffff0600000272,
  0xffffffa0000000c0, 0xfffffe89000002ef,
  0xffffffa0000000c0, 0xfffffe89000002ef,
  0xffffffe000000040, 0xffffff83000000fb,
  0xffffffc000000060, 0xffffff0600000178,
  0xffffffc000000060, 0xffffff0600000178,
  0xffffffc000000040, 0xffffff06000000fb,
  0xffffffe000000020, 0xffffff830000007e,
  0xffffffe000000020, 0xffffff830000007e,
  0xffffffe000000000, 0xffffff8300000001,
  0xffffffdfffffffc0, 0xffffff82ffffff07,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffe0, 0xffffffffffffff84,
  0xffffffffffffffa0, 0xfffffffffffffe8a,
  0xfffffffffffffba0, 0xffffffffffffeeea,
  0xffffffffffffffe0, 0xffffffffffffff84,
  0xffffffffffffffa0, 0xfffffffffffffe8a,
  0xfffffffffffffba0, 0xffffffffffffeeea,
  0xffffffffffffec00, 0xffffffffffffb1e1,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0xfffffffffffffbc0, 0xffffffffffffef67,
  0xffffffffffffec20, 0xffffffffffffb25e,
  0xffffffffffffdc60, 0xffffffffffff74d8,
  0xfffffffffffffc00, 0xfffffffffffff061,
  0xffffffffffffec60, 0xffffffffffffb358,
  0xffffffffffffdca0, 0xffffffffffff75d2,
  0xffffffffffffccc0, 0xffffffffffff37cf,
  0xfffffffffffff060, 0xffffffffffffc2f8,
  0xffffffffffffe0a0, 0xffffffffffff8572,
  0xffffffffffffd0c0, 0xffffffffffff476f,
  0xffffffffffefd120, 0xffffffffffc0c8e6,
  0xfffffffffffff040, 0xffffffffffffc27b,
  0xffffffffffffe060, 0xffffffffffff8478,
  0xffffffffffefe0c0, 0xffffffffffc105ef,
  0xffffffffffdfe100, 0xffffffffff8286e9,
  0xfffffffffffff020, 0xffffffffffffc1fe,
  0xffffffffffeff080, 0xffffffffffc14375,
  0xffffffffffdff0c0, 0xffffffffff82c46f,
  0xffffffffffcff0e0, 0xffffffffff4444ec,
  0xfffffffffff00060, 0xffffffffffc18178,
  0xffffffffffe000a0, 0xffffffffff830272,
  0xffffffffffd000c0, 0xffffffffff4482ef,
  0xfffffff999699a60, 0xffffffe6ff448308,
  0xfffffffffff00040, 0xffffffffffc180fb,
  0xffffffffffe00060, 0xffffffffff830178,
  0xfffffff999799a00, 0xffffffe6ff830191,
  0xffffffeeeeceef60, 0xffffffbd54d85710,
  0xfffffffffff00020, 0xffffffffffc1807e,
  0xfffffff9998999c0, 0xffffffe6ffc18097,
  0xffffffeeeedeef20, 0xffffffbd5516d616,
  0xffffffdeeedeef80, 0xffffff7ed516d78d,
  0xfffffff9999999a0, 0xffffffe70000001a,
  0xffffffeeeeeeef00, 0xffffffbd55555599,
  0xffffffdeeeeeef60, 0xffffff7ed5555710,
  0xffffffceeeeeefa0, 0xffffff405555580a,
  0xfffffff555555560, 0xffffffd655555580,
  0xffffffe5555555c0, 0xffffff97d55556f7,
  0xffffffd555555600, 0xffffff59555557f1,
  0xffffffc555555620, 0xffffff1ad555586e,
  0xfffffff000000060, 0xffffffc180000178,
  0xffffffe0000000a0, 0xffffff8300000272,
  0xffffffd0000000c0, 0xffffff44800002ef,
  0xffffffc0000000c0, 0xffffff06000002ef,
  0xfffffff000000040, 0xffffffc1800000fb,
  0xffffffe000000060, 0xffffff8300000178,
  0xffffffd000000060, 0xffffff4480000178,
  0xffffffc000000040, 0xffffff06000000fb,
  0xfffffff000000020, 0xffffffc18000007e,
  0xffffffe000000020, 0xffffff830000007e,
  0xffffffd000000000, 0xffffff4480000001,
  0xffffffbaaaaaaac0, 0xfffffef12aaaaaff,
  0xfffffff000000000, 0xffffffc180000001,
  0xffffffdfffffffe0, 0xffffff82ffffff84,
  0xffffffcaaaaaaaa0, 0xffffff2faaaaaa82,
  0xffffffb111111120, 0xfffffecbaaaaaae6,
  0xffffffefffffffe0, 0xffffffc17fffff84,
  0xffffffdaaaaaaaa0, 0xffffff6e2aaaaa82,
  0xffffffc111111120, 0xffffff0a2aaaaae6,
  0xffffffa111211120, 0xfffffe8d2ae92ae6,
  0xffffffeaaaaaaac0, 0xffffffacaaaaaaff,
  0xffffffd111111140, 0xffffff48aaaaab63,
  0xffffffb111211140, 0xfffffecbaae92b63,
  0xffffff9111311120, 0xfffffe4eab27aae6,
  0xffffffe666666680, 0xffffff9c00000065,
  0xffffffc666766680, 0xffffff1f003e8065,
  0xffffffa666866660, 0xfffffea2007cffe8,
  0xffffff8666966620, 0xfffffe2500bb7eee,
  0xffffffe000100000, 0xffffff83003e8001,
  0xffffffc0001fffe0, 0xffffff06007cff84,
  0xffffffa0002fffa0, 0xfffffe8900bb7e8a,
  0xffffff80003fff40, 0xfffffe0c00f9fd13,
  0xffffffe0000fffe0, 0xffffff83003e7f84,
  0xffffffc0001fffa0, 0xffffff06007cfe8a,
  0xffffffa0002fff40, 0xfffffe8900bb7d13,
  0xffffff8000300f40, 0xfffffe0c00bbbb93,
  0xffffffe0000fffc0, 0xffffff83003e7f07,
  0xffffffc0001fff60, 0xffffff06007cfd90,
  0xffffffa000200f60, 0xfffffe89007d3c10,
  0xffffff8000201f40, 0xfffffe0c007d7a13,
  0xffffffe0000fffa0, 0xffffff83003e7e8a,
  0xffffffc000100fa0, 0xffffff06003ebd0a,
  0xffffffa000101f80, 0xfffffe89003efb0d,
  0xffffff8000102f40, 0xfffffe0c003f3893,
  0xffffffe000001000, 0xffffff8300003e81,
  0xffffffc000001fe0, 0xffffff0600007c84,
  0xffffffa000002fa0, 0xfffffe890000ba0a,
  0xffffff8000003f40, 0xfffffe0c0000f713,
  0xffffffe000000fe0, 0xffffff8300003e04,
  0xffffffc000001fa0, 0xffffff0600007b8a,
  0xffffffa000002f40, 0xfffffe890000b893,
  0xffffff8000003340, 0xfffffe0c0000c833,
  0xffffffe000000fc0, 0xffffff8300003d87,
  0xffffffc000001f60, 0xffffff0600007a90,
  0xffffffa000002360, 0xfffffe8900008a30,
  0xffffff80000023c0, 0xfffffe0c00008ba7,
  0xffffffe000000fa0, 0xffffff8300003d0a,
  0xffffffc0000013a0, 0xffffff0600004caa,
  0xffffffa000001400, 0xfffffe8900004e21,
  0xffffff8000001440, 0xfffffe0c00004f1b,
  0xffffffe000000400, 0xffffff8300000fa1,
  0xffffffc000000460, 0xffffff0600001118,
  0xffffffa0000004a0, 0xfffffe8900001212,
  0xffffff80000004c0, 0xfffffe0c0000128f,
  0xffffff8300000177, 0xffffff820000017b,
  0xffffff0600000271, 0xffffff0400000277,
  0xfffffe89000002ee, 0xfffffe86000002f5,
  0xfffffe89000002ee, 0xfffffe86000002f5,
  0xffffff83000000fa, 0xffffff82000000fd,
  0xffffff0600000177, 0xffffff040000017b,
  0xffffff0600000177, 0xffffff040000017b,
  0xffffff06000000fa, 0xffffff04000000fd,
  0xffffff830000007d, 0xffffff820000007f,
  0xffffff830000007d, 0xffffff820000007f,
  0xffffff8300000000, 0xffffff8200000001,
  0xffffff82ffffff06, 0xffffff81ffffff05,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xfffffffffffffe89, 0xfffffffffffffe87,
  0xffffffffffffeee9, 0xffffffffffffeec7,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xfffffffffffffe89, 0xfffffffffffffe87,
  0xffffffffffffeee9, 0xffffffffffffeec7,
  0xffffffffffffb1e0, 0xffffffffffffb141,
  0xffffffffffffff06, 0xffffffffffffff05,
  0xffffffffffffef66, 0xffffffffffffef45,
  0xffffffffffffb25d, 0xffffffffffffb1bf,
  0xffffffffffff74d7, 0xffffffffffff73bb,
  0xfffffffffffff060, 0xfffffffffffff041,
  0xffffffffffffb357, 0xffffffffffffb2bb,
  0xffffffffffff75d1, 0xffffffffffff74b7,
  0xffffffffffff37ce, 0xffffffffffff3635,
  0xffffffffffffc2f7, 0xffffffffffffc27b,
  0xffffffffffff8571, 0xffffffffffff8477,
  0xffffffffffff476e, 0xffffffffffff45f5,
  0xffffffffffc0c8e5, 0xffffffffffc0476f,
  0xffffffffffffc27a, 0xffffffffffffc1fd,
  0xffffffffffff8477, 0xffffffffffff837b,
  0xffffffffffc105ee, 0xffffffffffc084f5,
  0xffffffffff8286e8, 0xffffffffff8185f1,
  0xffffffffffffc1fd, 0xffffffffffffc17f,
  0xffffffffffc14374, 0xffffffffffc0c2f9,
  0xffffffffff82c46e, 0xffffffffff81c3f5,
  0xffffffffff4444eb, 0xffffffffff42c473,
  0xffffffffffc18177, 0xffffffffffc1017b,
  0xffffffffff830271, 0xffffffffff820277,
  0xffffffffff4482ee, 0xffffffffff4302f5,
  0xffffffe6ff448307, 0xffffffe6cc0fcfdb,
  0xffffffffffc180fa, 0xffffffffffc100fd,
  0xffffffffff830177, 0xffffffffff82017b,
  0xffffffe6ff830190, 0xffffffe6cc4ece61,
  0xffffffbd54d8570f, 0xffffffbccc4ece8b,
  0xffffffffffc1807d, 0xffffffffffc1007f,
  0xffffffe6ffc18096, 0xffffffe6cc8dcd65,
  0xffffffbd5516d615, 0xffffffbccc8dcd8f,
  0xffffff7ed516d78c, 0xffffff7dcc8dcf09,
  0xffffffe700000019, 0xffffffe6cccccce7,
  0xffffffbd55555598, 0xffffffbccccccd11,
  0xffffff7ed555570f, 0xffffff7dccccce8b,
  0xffffff4055555809, 0xffffff3ecccccf87,
  0xffffffd65555557f, 0xffffffd60000002b,
  0xffffff97d55556f6, 0xffffff97000001a5,
  0xffffff59555557f0, 0xffffff58000002a1,
  0xffffff1ad555586d, 0xffffff190000031f,
  0xffffffc180000177, 0xffffffc10000017b,
  0xffffff8300000271, 0xffffff8200000277,
  0xffffff44800002ee, 0xffffff43000002f5,
  0xffffff06000002ee, 0xffffff04000002f5,
  0xffffffc1800000fa, 0xffffffc1000000fd,
  0xffffff8300000177, 0xffffff820000017b,
  0xffffff4480000177, 0xffffff430000017b,
  0xffffff06000000fa, 0xffffff04000000fd,
  0xffffffc18000007d, 0xffffffc10000007f,
  0xffffff830000007d, 0xffffff820000007f,
  0xffffff4480000000, 0xffffff4300000001,
  0xfffffef12aaaaafe, 0xfffffeef00000055,
  0xffffffc180000000, 0xffffffc100000001,
  0xffffff82ffffff83, 0xffffff81ffffff83,
  0xffffff2faaaaaa81, 0xffffff2dffffffd7,
  0xfffffecbaaaaaae5, 0xfffffec93333336f,
  0xffffffc17fffff83, 0xffffffc0ffffff83,
  0xffffff6e2aaaaa81, 0xffffff6cffffffd7,
  0xffffff0a2aaaaae5, 0xffffff083333336f,
  0xfffffe8d2ae92ae5, 0xfffffe8a3372336f,
  0xffffffacaaaaaafe, 0xffffffac00000055,
  0xffffff48aaaaab62, 0xffffff47333333ed,
  0xfffffecbaae92b62, 0xfffffec9337233ed,
  0xfffffe4eab27aae5, 0xfffffe4b33b1336f,
  0xffffff9c00000064, 0xffffff9b33333399,
  0xffffff1f003e8064, 0xffffff1d33723399,
  0xfffffea2007cffe7, 0xfffffe9f33b1331b,
  0xfffffe2500bb7eed, 0xfffffe2133f0321f,
  0xffffff83003e8000, 0xffffff82003f0001,
  0xffffff06007cff83, 0xffffff04007dff83,
  0xfffffe8900bb7e89, 0xfffffe8600bcfe87,
  0xfffffe0c00f9fd12, 0xfffffe0800fbfd0d,
  0xffffff83003e7f83, 0xffffff82003eff83,
  0xffffff06007cfe89, 0xffffff04007dfe87,
  0xfffffe8900bb7d12, 0xfffffe8600bcfd0d,
  0xfffffe0c00bbbb92, 0xfffffe0800bd3c0d,
  0xffffff83003e7f06, 0xffffff82003eff05,
  0xffffff06007cfd8f, 0xffffff04007dfd8b,
  0xfffffe89007d3c0f, 0xfffffe86007e3c8b,
  0xfffffe0c007d7a12, 0xfffffe08007e7b0d,
  0xffffff83003e7e89, 0xffffff82003efe87,
  0xffffff06003ebd09, 0xffffff04003f3d87,
  0xfffffe89003efb0c, 0xfffffe86003f7c09,
  0xfffffe0c003f3892, 0xfffffe08003fba0d,
  0xffffff8300003e80, 0xffffff8200003f01,
  0xffffff0600007c83, 0xffffff0400007d83,
  0xfffffe890000ba09, 0xfffffe860000bb87,
  0xfffffe0c0000f712, 0xfffffe080000f90d,
  0xffffff8300003e03, 0xffffff8200003e83,
  0xffffff0600007b89, 0xffffff0400007c87,
  0xfffffe890000b892, 0xfffffe860000ba0d,
  0xfffffe0c0000c832, 0xfffffe080000c9cd,
  0xffffff8300003d86, 0xffffff8200003e05,
  0xffffff0600007a8f, 0xffffff0400007b8b,
  0xfffffe8900008a2f, 0xfffffe8600008b4b,
  0xfffffe0c00008ba6, 0xfffffe0800008cc5,
  0xffffff8300003d09, 0xffffff8200003d87,
  0xffffff0600004ca9, 0xffffff0400004d47,
  0xfffffe8900004e20, 0xfffffe8600004ec1,
  0xfffffe0c00004f1a, 0xfffffe0800004fbd,
  0xffffff8300000fa0, 0xffffff8200000fc1,
  0xffffff0600001117, 0xffffff040000113b,
  0xfffffe8900001211, 0xfffffe8600001237,
  0xfffffe0c0000128e, 0xfffffe08000012b5,
  0xffffff820000017a, 0xffffff810000017e,
  0xffffff0400000276, 0xffffff020000027c,
  0xfffffe86000002f4, 0xfffffe83000002fb,
  0xfffffe86000002f4, 0xfffffe83000002fb,
  0xffffff82000000fc, 0xffffff81000000ff,
  0xffffff040000017a, 0xffffff020000017e,
  0xffffff040000017a, 0xffffff020000017e,
  0xffffff04000000fc, 0xffffff02000000ff,
  0xffffff820000007e, 0xffffff8100000080,
  0xffffff820000007e, 0xffffff8100000080,
  0xffffff8200000000, 0xffffff8100000001,
  0xffffff81ffffff04, 0xffffff80ffffff03,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xfffffffffffffe86, 0xfffffffffffffe84,
  0xffffffffffffeec6, 0xffffffffffffeea4,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xfffffffffffffe86, 0xfffffffffffffe84,
  0xffffffffffffeec6, 0xffffffffffffeea4,
  0xffffffffffffb140, 0xffffffffffffb0a1,
  0xffffffffffffff04, 0xffffffffffffff03,
  0xffffffffffffef44, 0xffffffffffffef23,
  0xffffffffffffb1be, 0xffffffffffffb120,
  0xffffffffffff73ba, 0xffffffffffff729e,
  0xfffffffffffff040, 0xfffffffffffff021,
  0xffffffffffffb2ba, 0xffffffffffffb21e,
  0xffffffffffff74b6, 0xffffffffffff739c,
  0xffffffffffff3634, 0xffffffffffff349b,
  0xffffffffffffc27a, 0xffffffffffffc1fe,
  0xffffffffffff8476, 0xffffffffffff837c,
  0xffffffffffff45f4, 0xffffffffffff447b,
  0xffffffffffc0476e, 0xffffffffffbfc5f8,
  0xffffffffffffc1fc, 0xffffffffffffc17f,
  0xffffffffffff837a, 0xffffffffffff827e,
  0xffffffffffc084f4, 0xffffffffffc003fb,
  0xffffffffff8185f0, 0xffffffffff8084f9,
  0xffffffffffffc17e, 0xffffffffffffc100,
  0xffffffffffc0c2f8, 0xffffffffffc0427d,
  0xffffffffff81c3f4, 0xffffffffff80c37b,
  0xffffffffff42c472, 0xffffffffff4143fa,
  0xffffffffffc1017a, 0xffffffffffc0817e,
  0xffffffffff820276, 0xffffffffff81027c,
  0xffffffffff4302f4, 0xffffffffff4182fb,
  0xffffffe6cc0fcfda, 0xffffffe698db1cae,
  0xffffffffffc100fc, 0xffffffffffc080ff,
  0xffffffffff82017a, 0xffffffffff81017e,
  0xffffffe6cc4ece60, 0xffffffe6991a9b31,
  0xffffffbccc4ece8a, 0xffffffbc43c54606,
  0xffffffffffc1007e, 0xffffffffffc08080,
  0xffffffe6cc8dcd64, 0xffffffe6995a1a33,
  0xffffffbccc8dcd8e, 0xffffffbc4404c508,
  0xffffff7dcc8dcf08, 0xffffff7cc404c685,
  0xffffffe6cccccce6, 0xffffffe6999999b4,
  0xffffffbccccccd10, 0xffffffbc44444489,
  0xffffff7dccccce8a, 0xffffff7cc4444606,
  0xffffff3ecccccf86, 0xffffff3d44444704,
  0xffffffd60000002a, 0xffffffd5aaaaaad6,
  0xffffff97000001a4, 0xffffff962aaaac53,
  0xffffff58000002a0, 0xffffff56aaaaad51,
  0xffffff190000031e, 0xffffff172aaaadd0,
  0xffffffc10000017a, 0xffffffc08000017e,
  0xffffff8200000276, 0xffffff810000027c,
  0xffffff43000002f4, 0xffffff41800002fb,
  0xffffff04000002f4, 0xffffff02000002fb,
  0xffffffc1000000fc, 0xffffffc0800000ff,
  0xffffff820000017a, 0xffffff810000017e,
  0xffffff430000017a, 0xffffff418000017e,
  0xffffff04000000fc, 0xffffff02000000ff,
  0xffffffc10000007e, 0xffffffc080000080,
  0xffffff820000007e, 0xffffff8100000080,
  0xffffff4300000000, 0xffffff4180000001,
  0xfffffeef00000054, 0xfffffeecd55555ab,
  0xffffffc100000000, 0xffffffc080000001,
  0xffffff81ffffff82, 0xffffff80ffffff82,
  0xffffff2dffffffd6, 0xffffff2c5555552c,
  0xfffffec93333336e, 0xfffffec6bbbbbbf8,
  0xffffffc0ffffff82, 0xffffffc07fffff82,
  0xffffff6cffffffd6, 0xffffff6bd555552c,
  0xffffff083333336e, 0xffffff063bbbbbf8,
  0xfffffe8a3372336e, 0xfffffe873bfb3bf8,
  0xffffffac00000054, 0xffffffab555555ab,
  0xffffff47333333ec, 0xffffff45bbbbbc77,
  0xfffffec9337233ec, 0xfffffec6bbfb3c77,
  0xfffffe4b33b1336e, 0xfffffe47bc3abbf8,
  0xffffff9b33333398, 0xffffff9a666666cd,
  0xffffff1d33723398, 0xffffff1b66a5e6cd,
  0xfffffe9f33b1331a, 0xfffffe9c66e5664e,
  0xfffffe2133f0321e, 0xfffffe1d6724e550,
  0xffffff82003f0000, 0xffffff81003f8001,
  0xffffff04007dff82, 0xffffff02007eff82,
  0xfffffe8600bcfe86, 0xfffffe8300be7e84,
  0xfffffe0800fbfd0c, 0xfffffe0400fdfd07,
  0xffffff82003eff82, 0xffffff81003f7f82,
  0xffffff04007dfe86, 0xffffff02007efe84,
  0xfffffe8600bcfd0c, 0xfffffe8300be7d07,
  0xfffffe0800bd3c0c, 0xfffffe0400bebc87,
  0xffffff82003eff04, 0xffffff81003f7f03,
  0xffffff04007dfd8a, 0xffffff02007efd86,
  0xfffffe86007e3c8a, 0xfffffe83007f3d06,
  0xfffffe08007e7b0c, 0xfffffe04007f7c07,
  0xffffff82003efe86, 0xffffff81003f7e84,
  0xffffff04003f3d86, 0xffffff02003fbe04,
  0xfffffe86003f7c08, 0xfffffe83003ffd05,
  0xfffffe08003fba0c, 0xfffffe0400403b87,
  0xffffff8200003f00, 0xffffff8100003f81,
  0xffffff0400007d82, 0xffffff0200007e82,
  0xfffffe860000bb86, 0xfffffe830000bd04,
  0xfffffe080000f90c, 0xfffffe040000fb07,
  0xffffff8200003e82, 0xffffff8100003f02,
  0xffffff0400007c86, 0xffffff0200007d84,
  0xfffffe860000ba0c, 0xfffffe830000bb87,
  0xfffffe080000c9cc, 0xfffffe040000cb67,
  0xffffff8200003e04, 0xffffff8100003e83,
  0xffffff0400007b8a, 0xffffff0200007c86,
  0xfffffe8600008b4a, 0xfffffe8300008c66,
  0xfffffe0800008cc4, 0xfffffe0400008de3,
  0xffffff8200003d86, 0xffffff8100003e04,
  0xffffff0400004d46, 0xffffff0200004de4,
  0xfffffe8600004ec0, 0xfffffe8300004f61,
  0xfffffe0800004fbc, 0xfffffe040000505f,
  0xffffff8200000fc0, 0xffffff8100000fe1,
  0xffffff040000113a, 0xffffff020000115e,
  0xfffffe8600001236, 0xfffffe830000125c,
  0xfffffe08000012b4, 0xfffffe04000012db,
  0xffffff810000017d, 0xffff800300017ff8,
  0xffffff020000027b, 0xffff000600027ff2,
  0xfffffe83000002fa, 0xfffe80090002ffef,
  0xfffffe83000002fa, 0xfffe80090002ffef,
  0xffffff81000000fe, 0xffff80030000fffb,
  0xffffff020000017d, 0xffff000600017ff8,
  0xffffff020000017d, 0xffff000600017ff8,
  0xffffff02000000fe, 0xffff00060000fffb,
  0xffffff810000007f, 0xffff800300007ffe,
  0xffffff810000007f, 0xffff800300007ffe,
  0xffffff8100000000, 0xffff800300000001,
  0xffffff80ffffff02, 0xffff8002ffff0007,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff81, 0xffffffffffff8004,
  0xfffffffffffffe83, 0xfffffffffffe800a,
  0xffffffffffffeea3, 0xffffffffffee806a,
  0xffffffffffffff81, 0xffffffffffff8004,
  0xfffffffffffffe83, 0xfffffffffffe800a,
  0xffffffffffffeea3, 0xffffffffffee806a,
  0xffffffffffffb0a0, 0xffffffffffb001e1,
  0xffffffffffffff02, 0xffffffffffff0007,
  0xffffffffffffef22, 0xffffffffffef0067,
  0xffffffffffffb11f, 0xffffffffffb081de,
  0xffffffffffff729d, 0xffffffffff718358,
  0xfffffffffffff020, 0xfffffffffff00061,
  0xffffffffffffb21d, 0xffffffffffb181d8,
  0xffffffffffff739b, 0xffffffffff728352,
  0xffffffffffff349a, 0xffffffffff3304cf,
  0xffffffffffffc1fd, 0xffffffffffc18178,
  0xffffffffffff837b, 0xffffffffff8282f2,
  0xffffffffffff447a, 0xffffffffff43046f,
  0xffffffffffbfc5f7, 0xffffffffbf460466,
  0xffffffffffffc17e, 0xffffffffffc1017b,
  0xffffffffffff827d, 0xffffffffff8182f8,
  0xffffffffffc003fa, 0xffffffffbf8482ef,
  0xffffffffff8084f8, 0xffffffff7f8702e9,
  0xffffffffffffc0ff, 0xffffffffffc0817e,
  0xffffffffffc0427c, 0xffffffffbfc38175,
  0xffffffffff80c37a, 0xffffffff7fc6016f,
  0xffffffffff4143f9, 0xffffffff3fc8016c,
  0xffffffffffc0817d, 0xffffffffc002fff8,
  0xffffffffff81027b, 0xffffffff80057ff2,
  0xffffffffff4182fa, 0xffffffff40077fef,
  0xffffffe698db1cad, 0xffffe66640079988,
  0xffffffffffc080fe, 0xffffffffc0027ffb,
  0xffffffffff81017d, 0xffffffff80047ff8,
  0xffffffe6991a9b30, 0xffffe66680049991,
  0xffffffbc43c54605, 0xffffbbbcd55a1990,
  0xffffffffffc0807f, 0xffffffffc001fffe,
  0xffffffe6995a1a32, 0xffffe666c0021997,
  0xffffffbc4404c507, 0xffffbbbd15579996,
  0xffffff7cc404c684, 0xffff7bbe9559198d,
  0xffffffe6999999b3, 0xffffe6670000199a,
  0xffffffbc44444488, 0xffffbbbd55559999,
  0xffffff7cc4444605, 0xffff7bbed5571990,
  0xffffff3d44444703, 0xffff3bc05558198a,
  0xffffffd5aaaaaad5, 0xffffd55655558000,
  0xffffff962aaaac52, 0xffff9557d556fff7,
  0xffffff56aaaaad50, 0xffff55595557fff1,
  0xffffff172aaaadcf, 0xffff155ad5587fee,
  0xffffffc08000017d, 0xffffc00180017ff8,
  0xffffff810000027b, 0xffff800300027ff2,
  0xffffff41800002fa, 0xffff40048002ffef,
  0xffffff02000002fa, 0xffff00060002ffef,
  0xffffffc0800000fe, 0xffffc0018000fffb,
  0xffffff810000017d, 0xffff800300017ff8,
  0xffffff418000017d, 0xffff400480017ff8,
  0xffffff02000000fe, 0xffff00060000fffb,
  0xffffffc08000007f, 0xffffc00180007ffe,
  0xffffff810000007f, 0xffff800300007ffe,
  0xffffff4180000000, 0xffff400480000001,
  0xfffffeecd55555aa, 0xfffeeab12aaaffff,
  0xffffffc080000000, 0xffffc00180000001,
  0xffffff80ffffff81, 0xffff8002ffff8004,
  0xffffff2c5555552b, 0xffff2aafaaaa8002,
  0xfffffec6bbbbbbf7, 0xfffec44baaaae666,
  0xffffffc07fffff81, 0xffffc0017fff8004,
  0xffffff6bd555552b, 0xffff6aae2aaa8002,
  0xffffff063bbbbbf7, 0xffff044a2aaae666,
  0xfffffe873bfb3bf7, 0xfffe844d6aa96666,
  0xffffffab555555aa, 0xffffaaacaaaaffff,
  0xffffff45bbbbbc76, 0xffff4448aaab6663,
  0xfffffec6bbfb3c76, 0xfffec44beaa9e663,
  0xfffffe47bc3abbf7, 0xfffe444f2aa7e666,
  0xffffff9a666666cc, 0xffff999c00006665,
  0xffffff1b66a5e6cc, 0xffff199f3ffee665,
  0xfffffe9c66e5664d, 0xfffe99a27ffce668,
  0xfffffe1d6724e54f, 0xfffe19a5bffa666e,
  0xffffff81003f8000, 0xffff80033ffe8001,
  0xffffff02007eff81, 0xffff00067ffc8004,
  0xfffffe8300be7e83, 0xfffe8009bffa000a,
  0xfffffe0400fdfd06, 0xfffe000cfff70013,
  0xffffff81003f7f81, 0xffff80033ffe0004,
  0xffffff02007efe83, 0xffff00067ffb800a,
  0xfffffe8300be7d06, 0xfffe8009bff88013,
  0xfffffe0400bebc86, 0xfffe000cc0387e93,
  0xffffff81003f7f02, 0xffff80033ffd8007,
  0xffffff02007efd85, 0xffff00067ffa8010,
  0xfffffe83007f3d05, 0xfffe8009803a7e90,
  0xfffffe04007f7c06, 0xfffe000c8079fd13,
  0xffffff81003f7e83, 0xffff80033ffd000a,
  0xffffff02003fbe03, 0xffff0006403cfe8a,
  0xfffffe83003ffd04, 0xfffe8009407c7d0d,
  0xfffffe0400403b86, 0xfffe000c40bb7b93,
  0xffffff8100003f80, 0xffff8003003ffe81,
  0xffffff0200007e81, 0xffff0006007f7d04,
  0xfffffe830000bd03, 0xfffe800900be7b8a,
  0xfffffe040000fb06, 0xfffe000c00fcfa13,
  0xffffff8100003f01, 0xffff8003003f7e84,
  0xffffff0200007d83, 0xffff0006007e7d0a,
  0xfffffe830000bb86, 0xfffe800900bcfb93,
  0xfffffe040000cb66, 0xfffe000c00ccfb33,
  0xffffff8100003e82, 0xffff8003003efe87,
  0xffffff0200007c85, 0xffff0006007d7d10,
  0xfffffe8300008c65, 0xfffe8009008d7cb0,
  0xfffffe0400008de2, 0xfffe000c008efca7,
  0xffffff8100003e03, 0xffff8003003e7e8a,
  0xffffff0200004de3, 0xffff0006004e7e2a,
  0xfffffe8300004f60, 0xfffe8009004ffe21,
  0xfffffe040000505e, 0xfffe000c0050fe1b,
  0xffffff8100000fe0, 0xffff8003000fffa1,
  0xffffff020000115d, 0xffff000600117f98,
  0xfffffe830000125b, 0xfffe800900127f92,
  0xfffffe04000012da, 0xfffe000c0012ff8f,
  0xffff800300017ff7, 0xffff800200017ffb,
  0xffff000600027ff1, 0xffff000400027ff7,
  0xfffe80090002ffee, 0xfffe80060002fff5,
  0xfffe80090002ffee, 0xfffe80060002fff5,
  0xffff80030000fffa, 0xffff80020000fffd,
  0xffff000600017ff7, 0xffff000400017ffb,
  0xffff000600017ff7, 0xffff000400017ffb,
  0xffff00060000fffa, 0xffff00040000fffd,
  0xffff800300007ffd, 0xffff800200007fff,
  0xffff800300007ffd, 0xffff800200007fff,
  0xffff800300000000, 0xffff800200000001,
  0xffff8002ffff0006, 0xffff8001ffff0005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xfffffffffffe8009, 0xfffffffffffe8007,
  0xffffffffffee8069, 0xffffffffffee8047,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xfffffffffffe8009, 0xfffffffffffe8007,
  0xffffffffffee8069, 0xffffffffffee8047,
  0xffffffffffb001e0, 0xffffffffffb00141,
  0xffffffffffff0006, 0xffffffffffff0005,
  0xffffffffffef0066, 0xffffffffffef0045,
  0xffffffffffb081dd, 0xffffffffffb0813f,
  0xffffffffff718357, 0xffffffffff71823b,
  0xfffffffffff00060, 0xfffffffffff00041,
  0xffffffffffb181d7, 0xffffffffffb1813b,
  0xffffffffff728351, 0xffffffffff728237,
  0xffffffffff3304ce, 0xffffffffff330335,
  0xffffffffffc18177, 0xffffffffffc180fb,
  0xffffffffff8282f1, 0xffffffffff8281f7,
  0xffffffffff43046e, 0xffffffffff4302f5,
  0xffffffffbf460465, 0xffffffffbf4582ef,
  0xffffffffffc1017a, 0xffffffffffc100fd,
  0xffffffffff8182f7, 0xffffffffff8181fb,
  0xffffffffbf8482ee, 0xffffffffbf8401f5,
  0xffffffff7f8702e8, 0xffffffff7f8601f1,
  0xffffffffffc0817d, 0xffffffffffc080ff,
  0xffffffffbfc38174, 0xffffffffbfc300f9,
  0xffffffff7fc6016e, 0xffffffff7fc500f5,
  0xffffffff3fc8016b, 0xffffffff3fc680f3,
  0xffffffffc002fff7, 0xffffffffc0027ffb,
  0xffffffff80057ff1, 0xffffffff80047ff7,
  0xffffffff40077fee, 0xffffffff4005fff5,
  0xffffe66640079987, 0xffffe6660cd2e65b,
  0xffffffffc0027ffa, 0xffffffffc001fffd,
  0xffffffff80047ff7, 0xffffffff80037ffb,
  0xffffe66680049990, 0xffffe6664cd06661,
  0xffffbbbcd55a198f, 0xffffbbbc4cd0910b,
  0xffffffffc001fffd, 0xffffffffc0017fff,
  0xffffe666c0021996, 0xffffe6668cce6665,
  0xffffbbbd15579995, 0xffffbbbc8cce910f,
  0xffff7bbe9559198c, 0xffff7bbd8cd01109,
  0xffffe66700001999, 0xffffe666cccce667,
  0xffffbbbd55559998, 0xffffbbbccccd1111,
  0xffff7bbed557198f, 0xffff7bbdccce910b,
  0xffff3bc055581989, 0xffff3bbecccf9107,
  0xffffd55655557fff, 0xffffd55600002aab,
  0xffff9557d556fff6, 0xffff95570001aaa5,
  0xffff55595557fff0, 0xffff55580002aaa1,
  0xffff155ad5587fed, 0xffff155900032a9f,
  0xffffc00180017ff7, 0xffffc00100017ffb,
  0xffff800300027ff1, 0xffff800200027ff7,
  0xffff40048002ffee, 0xffff40030002fff5,
  0xffff00060002ffee, 0xffff00040002fff5,
  0xffffc0018000fffa, 0xffffc0010000fffd,
  0xffff800300017ff7, 0xffff800200017ffb,
  0xffff400480017ff7, 0xffff400300017ffb,
  0xffff00060000fffa, 0xffff00040000fffd,
  0xffffc00180007ffd, 0xffffc00100007fff,
  0xffff800300007ffd, 0xffff800200007fff,
  0xffff400480000000, 0xffff400300000001,
  0xfffeeab12aaafffe, 0xfffeeaaf00005555,
  0xffffc00180000000, 0xffffc00100000001,
  0xffff8002ffff8003, 0xffff8001ffff8003,
  0xffff2aafaaaa8001, 0xffff2aadffffd557,
  0xfffec44baaaae665, 0xfffec44933336eef,
  0xffffc0017fff8003, 0xffffc000ffff8003,
  0xffff6aae2aaa8001, 0xffff6aacffffd557,
  0xffff044a2aaae665, 0xffff044833336eef,
  0xfffe844d6aa96665, 0xfffe844a73326eef,
  0xffffaaacaaaafffe, 0xffffaaac00005555,
  0xffff4448aaab6662, 0xffff44473333eeed,
  0xfffec44beaa9e662, 0xfffec4497332eeed,
  0xfffe444f2aa7e665, 0xfffe444bb3316eef,
  0xffff999c00006664, 0xffff999b33339999,
  0xffff199f3ffee664, 0xffff199d73329999,
  0xfffe99a27ffce667, 0xfffe999fb331199b,
  0xfffe19a5bffa666d, 0xfffe19a1f32f199f,
  0xffff80033ffe8000, 0xffff80023fff0001,
  0xffff00067ffc8003, 0xffff00047ffd8003,
  0xfffe8009bffa0009, 0xfffe8006bffb8007,
  0xfffe000cfff70012, 0xfffe0008fff9000d,
  0xffff80033ffe0003, 0xffff80023ffe8003,
  0xffff00067ffb8009, 0xffff00047ffc8007,
  0xfffe8009bff88012, 0xfffe8006bffa000d,
  0xfffe000cc0387e92, 0xfffe0008c039ff0d,
  0xffff80033ffd8006, 0xffff80023ffe0005,
  0xffff00067ffa800f, 0xffff00047ffb800b,
  0xfffe8009803a7e8f, 0xfffe8006803b7f0b,
  0xfffe000c8079fd12, 0xfffe0008807afe0d,
  0xffff80033ffd0009, 0xffff80023ffd8007,
  0xffff0006403cfe89, 0xffff0004403d7f07,
  0xfffe8009407c7d0c, 0xfffe8006407cfe09,
  0xfffe000c40bb7b92, 0xfffe000840bbfd0d,
  0xffff8003003ffe80, 0xffff8002003fff01,
  0xffff0006007f7d03, 0xffff0004007f7e03,
  0xfffe800900be7b89, 0xfffe800600be7d07,
  0xfffe000c00fcfa12, 0xfffe000800fcfc0d,
  0xffff8003003f7e83, 0xffff8002003f7f03,
  0xffff0006007e7d09, 0xffff0004007e7e07,
  0xfffe800900bcfb92, 0xfffe800600bcfd0d,
  0xfffe000c00ccfb32, 0xfffe000800ccfccd,
  0xffff8003003efe86, 0xffff8002003eff05,
  0xffff0006007d7d0f, 0xffff0004007d7e0b,
  0xfffe8009008d7caf, 0xfffe8006008d7dcb,
  0xfffe000c008efca6, 0xfffe0008008efdc5,
  0xffff8003003e7e89, 0xffff8002003e7f07,
  0xffff0006004e7e29, 0xffff0004004e7ec7,
  0xfffe8009004ffe20, 0xfffe8006004ffec1,
  0xfffe000c0050fe1a, 0xfffe00080050febd,
  0xffff8003000fffa0, 0xffff8002000fffc1,
  0xffff000600117f97, 0xffff000400117fbb,
  0xfffe800900127f91, 0xfffe800600127fb7,
  0xfffe000c0012ff8e, 0xfffe00080012ffb5,
  0xffff800200017ffa, 0xffff800100017ffe,
  0xffff000400027ff6, 0xffff000200027ffc,
  0xfffe80060002fff4, 0xfffe80030002fffb,
  0xfffe80060002fff4, 0xfffe80030002fffb,
  0xffff80020000fffc, 0xffff80010000ffff,
  0xffff000400017ffa, 0xffff000200017ffe,
  0xffff000400017ffa, 0xffff000200017ffe,
  0xffff00040000fffc, 0xffff00020000ffff,
  0xffff800200007ffe, 0xffff800100008000,
  0xffff800200007ffe, 0xffff800100008000,
  0xffff800200000000, 0xffff800100000001,
  0xffff8001ffff0004, 0xffff8000ffff0003,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xfffffffffffe8006, 0xfffffffffffe8004,
  0xffffffffffee8046, 0xffffffffffee8024,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xfffffffffffe8006, 0xfffffffffffe8004,
  0xffffffffffee8046, 0xffffffffffee8024,
  0xffffffffffb00140, 0xffffffffffb000a1,
  0xffffffffffff0004, 0xffffffffffff0003,
  0xffffffffffef0044, 0xffffffffffef0023,
  0xffffffffffb0813e, 0xffffffffffb080a0,
  0xffffffffff71823a, 0xffffffffff71811e,
  0xfffffffffff00040, 0xfffffffffff00021,
  0xffffffffffb1813a, 0xffffffffffb1809e,
  0xffffffffff728236, 0xffffffffff72811c,
  0xffffffffff330334, 0xffffffffff33019b,
  0xffffffffffc180fa, 0xffffffffffc1807e,
  0xffffffffff8281f6, 0xffffffffff8280fc,
  0xffffffffff4302f4, 0xffffffffff43017b,
  0xffffffffbf4582ee, 0xffffffffbf450178,
  0xffffffffffc100fc, 0xffffffffffc1007f,
  0xffffffffff8181fa, 0xffffffffff8180fe,
  0xffffffffbf8401f4, 0xffffffffbf8380fb,
  0xffffffff7f8601f0, 0xffffffff7f8500f9,
  0xffffffffffc080fe, 0xffffffffffc08080,
  0xffffffffbfc300f8, 0xffffffffbfc2807d,
  0xffffffff7fc500f4, 0xffffffff7fc4007b,
  0xffffffff3fc680f2, 0xffffffff3fc5007a,
  0xffffffffc0027ffa, 0xffffffffc001fffe,
  0xffffffff80047ff6, 0xffffffff80037ffc,
  0xffffffff4005fff4, 0xffffffff40047ffb,
  0xffffe6660cd2e65a, 0xffffe665d99e332e,
  0xffffffffc001fffc, 0xffffffffc0017fff,
  0xffffffff80037ffa, 0xffffffff80027ffe,
  0xffffe6664cd06660, 0xffffe666199c3331,
  0xffffbbbc4cd0910a, 0xffffbbbbc4470886,
  0xffffffffc0017ffe, 0xffffffffc0010000,
  0xffffe6668cce6664, 0xffffe666599ab333,
  0xffffbbbc8cce910e, 0xffffbbbc04458888,
  0xffff7bbd8cd01108, 0xffff7bbc84470885,
  0xffffe666cccce666, 0xffffe6669999b334,
  0xffffbbbccccd1110, 0xffffbbbc44448889,
  0xffff7bbdccce910a, 0xffff7bbcc4460886,
  0xffff3bbecccf9106, 0xffff3bbd44470884,
  0xffffd55600002aaa, 0xffffd555aaaad556,
  0xffff95570001aaa4, 0xffff95562aac5553,
  0xffff55580002aaa0, 0xffff5556aaad5551,
  0xffff155900032a9e, 0xffff15572aadd550,
  0xffffc00100017ffa, 0xffffc00080017ffe,
  0xffff800200027ff6, 0xffff800100027ffc,
  0xffff40030002fff4, 0xffff40018002fffb,
  0xffff00040002fff4, 0xffff00020002fffb,
  0xffffc0010000fffc, 0xffffc0008000ffff,
  0xffff800200017ffa, 0xffff800100017ffe,
  0xffff400300017ffa, 0xffff400180017ffe,
  0xffff00040000fffc, 0xffff00020000ffff,
  0xffffc00100007ffe, 0xffffc00080008000,
  0xffff800200007ffe, 0xffff800100008000,
  0xffff400300000000, 0xffff400180000001,
  0xfffeeaaf00005554, 0xfffeeaacd555aaab,
  0xffffc00100000000, 0xffffc00080000001,
  0xffff8001ffff8002, 0xffff8000ffff8002,
  0xffff2aadffffd556, 0xffff2aac55552aac,
  0xfffec44933336eee, 0xfffec446bbbbf778,
  0xffffc000ffff8002, 0xffffc0007fff8002,
  0xffff6aacffffd556, 0xffff6aabd5552aac,
  0xffff044833336eee, 0xffff04463bbbf778,
  0xfffe844a73326eee, 0xfffe84477bbb7778,
  0xffffaaac00005554, 0xffffaaab5555aaab,
  0xffff44473333eeec, 0xffff4445bbbc7777,
  0xfffec4497332eeec, 0xfffec446fbbbf777,
  0xfffe444bb3316eee, 0xfffe44483bbaf778,
  0xffff999b33339998, 0xffff999a6666cccd,
  0xffff199d73329998, 0xffff199ba6664ccd,
  0xfffe999fb331199a, 0xfffe999ce6654cce,
  0xfffe19a1f32f199e, 0xfffe199e2663ccd0,
  0xffff80023fff0000, 0xffff80013fff8001,
  0xffff00047ffd8002, 0xffff00027ffe8002,
  0xfffe8006bffb8006, 0xfffe8003bffd0004,
  0xfffe0008fff9000c, 0xfffe0004fffb0007,
  0xffff80023ffe8002, 0xffff80013fff0002,
  0xffff00047ffc8006, 0xffff00027ffd8004,
  0xfffe8006bffa000c, 0xfffe8003bffb8007,
  0xfffe0008c039ff0c, 0xfffe0004c03b7f87,
  0xffff80023ffe0004, 0xffff80013ffe8003,
  0xffff00047ffb800a, 0xffff00027ffc8006,
  0xfffe8006803b7f0a, 0xfffe8003803c7f86,
  0xfffe0008807afe0c, 0xfffe0004807bff07,
  0xffff80023ffd8006, 0xffff80013ffe0004,
  0xffff0004403d7f06, 0xffff0002403dff84,
  0xfffe8006407cfe08, 0xfffe8003407d7f05,
  0xfffe000840bbfd0c, 0xfffe000440bc7e87,
  0xffff8002003fff00, 0xffff8001003fff81,
  0xffff0004007f7e02, 0xffff0002007f7f02,
  0xfffe800600be7d06, 0xfffe800300be7e84,
  0xfffe000800fcfc0c, 0xfffe000400fcfe07,
  0xffff8002003f7f02, 0xffff8001003f7f82,
  0xffff0004007e7e06, 0xffff0002007e7f04,
  0xfffe800600bcfd0c, 0xfffe800300bcfe87,
  0xfffe000800ccfccc, 0xfffe000400ccfe67,
  0xffff8002003eff04, 0xffff8001003eff83,
  0xffff0004007d7e0a, 0xffff0002007d7f06,
  0xfffe8006008d7dca, 0xfffe8003008d7ee6,
  0xfffe0008008efdc4, 0xfffe0004008efee3,
  0xffff8002003e7f06, 0xffff8001003e7f84,
  0xffff0004004e7ec6, 0xffff0002004e7f64,
  0xfffe8006004ffec0, 0xfffe8003004fff61,
  0xfffe00080050febc, 0xfffe00040050ff5f,
  0xffff8002000fffc0, 0xffff8001000fffe1,
  0xffff000400117fba, 0xffff000200117fde,
  0xfffe800600127fb6, 0xfffe800300127fdc,
  0xfffe00080012ffb4, 0xfffe00040012ffdb,
  0xffff800100017ffd, 0xcccccccd9999999a,
  0xffff000200027ffb, 0x9999999b00000000,
  0xfffe80030002fffa, 0x6666666833333333,
  0xfffe80030002fffa, 0x6666666833333333,
  0xffff80010000fffe, 0xcccccccd66666667,
  0xffff000200017ffd, 0x9999999a9999999a,
  0xffff000200017ffd, 0x9999999a9999999a,
  0xffff00020000fffe, 0x9999999a66666667,
  0xffff800100007fff, 0xcccccccd33333334,
  0xffff800100007fff, 0xcccccccd33333334,
  0xffff800100000000, 0xcccccccd00000001,
  0xffff8000ffff0002, 0xcccccccc9999999b,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8001, 0xffffffffccccccce,
  0xfffffffffffe8003, 0xffffffff66666668,
  0xffffffffffee8023, 0xfffffff900000008,
  0xffffffffffff8001, 0xffffffffccccccce,
  0xfffffffffffe8003, 0xffffffff66666668,
  0xffffffffffee8023, 0xfffffff900000008,
  0xffffffffffb000a0, 0xffffffe000000021,
  0xffffffffffff0002, 0xffffffff9999999b,
  0xffffffffffef0022, 0xfffffff93333333b,
  0xffffffffffb0809f, 0xffffffe033333354,
  0xffffffffff71811d, 0xffffffc70000003a,
  0xfffffffffff00020, 0xfffffff9999999a1,
  0xffffffffffb1809d, 0xffffffe0999999ba,
  0xffffffffff72811b, 0xffffffc7666666a0,
  0xffffffffff33019a, 0xffffffae00000053,
  0xffffffffffc1807d, 0xffffffe70000001a,
  0xffffffffff8280fb, 0xffffffcdcccccd00,
  0xffffffffff43017a, 0xffffffb4666666b3,
  0xffffffffbf450177, 0xffffe61b6666804c,
  0xffffffffffc1007e, 0xffffffe6cccccce7,
  0xffffffffff8180fd, 0xffffffcd6666669a,
  0xffffffffbf8380fa, 0xffffe63466668033,
  0xffffffff7f8500f8, 0xffffcc9b33336699,
  0xffffffffffc0807f, 0xffffffe6999999b4,
  0xffffffffbfc2807c, 0xffffe64d9999b34d,
  0xffffffff7fc4007a, 0xffffccb4666699b3,
  0xffffffff3fc50079, 0xffffb31b00004ce6,
  0xffffffffc001fffd, 0xffffe6670000199a,
  0xffffffff80037ffb, 0xffffcccdcccd0000,
  0xffffffff40047ffa, 0xffffb3346666b333,
  0xffffe665d99e332d, 0xf5c24290a3d7570a,
  0xffffffffc0017ffe, 0xffffe666cccce667,
  0xffffffff80027ffd, 0xffffcccd6666999a,
  0xffffe666199c3330, 0xf5c25c29a3d73d71,
  0xffffbbbbc4470885, 0xe4b14b18b4e84e82,
  0xffffffffc000ffff, 0xffffe6669999b334,
  0xffffe666599ab332, 0xf5c275c2d70a570b,
  0xffffbbbc04458887, 0xe4b164b1e81b681c,
  0xffff7bbc84470884, 0xcb17cb1901b501b5,
  0xffffe6669999b333, 0xf5c28f5c3d70a3d8,
  0xffffbbbc44448888, 0xe4b17e4b4e81b4e9,
  0xffff7bbcc4460885, 0xcb17e4b2681b4e82,
  0xffff3bbd44470883, 0xb17e4b194e81b4e8,
  0xffffd555aaaad555, 0xeeeeeeef11111112,
  0xffff95562aac5552, 0xd55555562aaaaaab,
  0xffff5556aaad5550, 0xbbbbbbbd11111111,
  0xffff15572aadd54f, 0xa2222223c4444444,
  0xffffc00080017ffd, 0xe66666671999999a,
  0xffff800100027ffb, 0xccccccce00000000,
  0xffff40018002fffa, 0xb3333334b3333333,
  0xffff00020002fffa, 0x9999999b33333333,
  0xffffc0008000fffe, 0xe6666666e6666667,
  0xffff800100017ffd, 0xcccccccd9999999a,
  0xffff400180017ffd, 0xb33333341999999a,
  0xffff00020000fffe, 0x9999999a66666667,
  0xffffc00080007fff, 0xe6666666b3333334,
  0xffff800100007fff, 0xcccccccd33333334,
  0xffff400180000000, 0xb333333380000001,
  0xfffeeaacd555aaaa, 0x91111111a2222223,
  0xffffc00080000000, 0xe666666680000001,
  0xffff8000ffff8001, 0xccccccccccccccce,
  0xffff2aac55552aab, 0xaaaaaaaaeeeeeef0,
  0xfffec446bbbbf777, 0x81b4e81be4b17e4c,
  0xffffc0007fff8001, 0xe66666664cccccce,
  0xffff6aabd5552aab, 0xc44444446eeeeef0,
  0xffff04463bbbf777, 0x9b4e81b564b17e4c,
  0xfffe84477bbb7777, 0x681b681bfe4afe4c,
  0xffffaaab5555aaaa, 0xddddddde22222223,
  0xffff4445bbbc7776, 0xb4e81b4f17e4b17f,
  0xfffec446fbbbf776, 0x81b501b5b17e317f,
  0xfffe44483bbaf777, 0x4e81e81c17e47e4c,
  0xffff999a6666cccc, 0xd70a3d70f5c28f5d,
  0xffff199ba6664ccc, 0xa3d723d78f5c0f5d,
  0xfffe999ce6654ccd, 0x70a40a3df5c25c2a,
  0xfffe199e2663cccf, 0x3d70f0a428f575c4,
  0xffff80013fff8000, 0xcccce66699998001,
  0xffff00027ffe8001, 0x9999ccccffffccce,
  0xfffe8003bffd0003, 0x6666b3333332e668,
  0xfffe0004fffb0006, 0x333399993332cccf,
  0xffff80013fff0001, 0xcccce66666664cce,
  0xffff00027ffd8003, 0x9999cccc99996668,
  0xfffe8003bffb8006, 0x6666b33299994ccf,
  0xfffe0004c03b7f86, 0x333380193332e64f,
  0xffff80013ffe8002, 0xcccce6663333199b,
  0xffff00027ffc8005, 0x9999cccc33330002,
  0xfffe8003803c7f85, 0x666699b2cccc9982,
  0xfffe0004807bff06, 0x333366993332ffcf,
  0xffff80013ffe0003, 0xcccce665ffffe668,
  0xffff0002403dff83, 0x9999b34c99997fe8,
  0xfffe8003407d7f04, 0x66668032ffffe635,
  0xfffe000440bc7e86, 0x33334d193333194f,
  0xffff8001003fff80, 0xcccccce699999981,
  0xffff0002007f7f01, 0x999999ccffffffce,
  0xfffe800300be7e83, 0x666666b3333332e8,
  0xfffe000400fcfe06, 0x33333399333332cf,
  0xffff8001003f7f81, 0xcccccce66666664e,
  0xffff0002007e7f03, 0x999999cc99999968,
  0xfffe800300bcfe86, 0x666666b29999994f,
  0xfffe000400ccfe66, 0x33333385ffffffaf,
  0xffff8001003eff82, 0xcccccce63333331b,
  0xffff0002007d7f05, 0x999999cc33333302,
  0xfffe8003008d7ee5, 0x6666669f99999962,
  0xfffe0004008efee2, 0x3333336d333332fb,
  0xffff8001003e7f83, 0xcccccce5ffffffe8,
  0xffff0002004e7f63, 0x999999b966666648,
  0xfffe8003004fff60, 0x66666686ffffffe1,
  0xfffe00040050ff5e, 0x3333335466666647,
  0xffff8001000fffe0, 0xccccccd366666661,
  0xffff000200117fdd, 0x999999a0fffffffa,
  0xfffe800300127fdb, 0x6666666e66666660,
  0xfffe00040012ffda, 0x3333333b99999993,
  0xcccccccd99999999, 0xaaaaaaac00000000,
  0x9999999affffffff, 0x55555557aaaaaaaa,
  0x6666666833333332, 0x00000002ffffffff,
  0x6666666833333332, 0x00000002ffffffff,
  0xcccccccd66666666, 0xaaaaaaabaaaaaaab,
  0x9999999a99999999, 0x5555555700000000,
  0x9999999a99999999, 0x5555555700000000,
  0x9999999a66666666, 0x55555556aaaaaaab,
  0xcccccccd33333333, 0xaaaaaaab55555556,
  0xcccccccd33333333, 0xaaaaaaab55555556,
  0xcccccccd00000000, 0xaaaaaaab00000001,
  0xcccccccc9999999a, 0xaaaaaaaa55555557,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffcccccccd, 0xffffffffaaaaaaac,
  0xffffffff66666667, 0xffffffff00000002,
  0xfffffff900000007, 0xfffffff455555562,
  0xffffffffcccccccd, 0xffffffffaaaaaaac,
  0xffffffff66666667, 0xffffffff00000002,
  0xfffffff900000007, 0xfffffff455555562,
  0xffffffe000000020, 0xffffffcaaaaaaae1,
  0xffffffff9999999a, 0xffffffff55555557,
  0xfffffff93333333a, 0xfffffff4aaaaaab7,
  0xffffffe033333353, 0xffffffcb00000036,
  0xffffffc700000039, 0xffffffa100000060,
  0xfffffff9999999a0, 0xfffffff555555561,
  0xffffffe0999999b9, 0xffffffcbaaaaaae0,
  0xffffffc76666669f, 0xffffffa1aaaaab0a,
  0xffffffae00000052, 0xffffff77555555df,
  0xffffffe700000019, 0xffffffd655555580,
  0xffffffcdccccccff, 0xffffffac555555aa,
  0xffffffb4666666b2, 0xffffff820000007f,
  0xffffe61b6666804b, 0xffffd4d85555807e,
  0xffffffe6cccccce6, 0xffffffd60000002b,
  0xffffffcd66666699, 0xffffffabaaaaab00,
  0xffffe63466668032, 0xffffd50200002aff,
  0xffffcc9b33336698, 0xffffaa58000055a9,
  0xffffffe6999999b3, 0xffffffd5aaaaaad6,
  0xffffe64d9999b34c, 0xffffd52c00002ad5,
  0xffffccb4666699b2, 0xffffaa820000557f,
  0xffffb31b00004ce5, 0xffff7fd7aaab2ad4,
  0xffffe66700001999, 0xffffd55655558000,
  0xffffcccdccccffff, 0xffffaaac5555aaaa,
  0xffffb3346666b332, 0xffff800200007fff,
  0xf5c24290a3d75709, 0xeeee6ef111119110,
  0xffffe666cccce666, 0xffffd55600002aab,
  0xffffcccd66669999, 0xffffaaabaaab0000,
  0xf5c25c29a3d73d70, 0xeeee999abbbc1111,
  0xe4b14b18b4e84e81, 0xd27cd27e82d882d8,
  0xffffe6669999b333, 0xffffd555aaaad556,
  0xf5c275c2d70a570a, 0xeeeec444bbbbe667,
  0xe4b164b1e81b681b, 0xd27cfd2882d8582e,
  0xcb17cb1901b501b4, 0xa7d2527f02d8582d,
  0xf5c28f5c3d70a3d7, 0xeeeeeeef11111112,
  0xe4b17e4b4e81b4e8, 0xd27d27d2d82d82d9,
  0xcb17e4b2681b4e81, 0xa7d27d29582d82d8,
  0xb17e4b194e81b4e7, 0x7d27d27f82d82d82,
  0xeeeeeeef11111111, 0xe38e38e3c71c71c8,
  0xd55555562aaaaaaa, 0xb8e38e3a471c71c7,
  0xbbbbbbbd11111110, 0x8e38e39071c71c71,
  0xa2222223c4444443, 0x638e38e6471c71c6,
  0xe666666719999999, 0xd555555680000000,
  0xcccccccdffffffff, 0xaaaaaaacaaaaaaaa,
  0xb3333334b3333332, 0x800000027fffffff,
  0x9999999b33333332, 0x55555557ffffffff,
  0xe6666666e6666666, 0xd55555562aaaaaab,
  0xcccccccd99999999, 0xaaaaaaac00000000,
  0xb333333419999999, 0x8000000180000000,
  0x9999999a66666666, 0x55555556aaaaaaab,
  0xe6666666b3333333, 0xd5555555d5555556,
  0xcccccccd33333333, 0xaaaaaaab55555556,
  0xb333333380000000, 0x8000000080000001,
  0x91111111a2222222, 0x471c71c80e38e38f,
  0xe666666680000000, 0xd555555580000001,
  0xcccccccccccccccd, 0xaaaaaaaaaaaaaaac,
  0xaaaaaaaaeeeeeeef, 0x71c71c7238e38e3a,
  0x81b4e81be4b17e4b, 0x2d82d82e7d27d27e,
  0xe66666664ccccccd, 0xd55555552aaaaaac,
  0xc44444446eeeeeef, 0x9c71c71cb8e38e3a,
  0x9b4e81b564b17e4b, 0x582d82d8fd27d27e,
  0x681b681bfe4afe4b, 0x02d8582ea7d2527e,
  0xddddddde22222222, 0xc71c71c78e38e38f,
  0xb4e81b4f17e4b17e, 0x82d82d83d27d27d3,
  0x81b501b5b17e317e, 0x2d8302d97d27a7d3,
  0x4e81e81c17e47e4b, 0xd82dd82ed27cd27e,
  0xd70a3d70f5c28f5c, 0xbbbbbbbc44444445,
  0xa3d723d78f5c0f5c, 0x66669111eeeec445,
  0x70a40a3df5c25c29, 0x111166674443eef0,
  0x3d70f0a428f575c3, 0xbbbc3bbc4443c446,
  0xcccce66699998000, 0xaaaad555aaaa8001,
  0x9999ccccffffcccd, 0x5555aaaaffffaaac,
  0x6666b3333332e667, 0x00007fffffff8002,
  0x333399993332ccce, 0xaaab5554aaaa0003,
  0xcccce66666664ccd, 0xaaaad55555552aac,
  0x9999cccc99996667, 0x5555aaaa55550002,
  0x6666b33299994cce, 0x00007ffeffff8003,
  0x333380193332e64e, 0xaaab2ad4aaaa2a83,
  0xcccce6663333199a, 0xaaaad554ffffd557,
  0x9999cccc33330001, 0x5555aaa9aaaa5558,
  0x666699b2cccc9981, 0x0000557f5554ffd8,
  0x333366993332ffce, 0xaaab0054aaaa5503,
  0xcccce665ffffe667, 0xaaaad554aaaa8002,
  0x9999b34c99997fe7, 0x5555802a55552a82,
  0x66668032ffffe634, 0x00002affaaaa7fad,
  0x33334d193333194e, 0xaaaad5d4aaaa7f83,
  0xcccccce699999980, 0xaaaaaad5aaaaaa81,
  0x999999ccffffffcd, 0x555555aaffffffac,
  0x666666b3333332e7, 0x0000007fffffff82,
  0x33333399333332ce, 0xaaaaab54aaaaaa03,
  0xcccccce66666664d, 0xaaaaaad55555552c,
  0x999999cc99999967, 0x555555aa55555502,
  0x666666b29999994e, 0x0000007effffff83,
  0x33333385ffffffae, 0xaaaaab34aaaaaa23,
  0xcccccce63333331a, 0xaaaaaad4ffffffd7,
  0x999999cc33333301, 0x555555a9aaaaaa58,
  0x6666669f99999961, 0x0000005f555554f8,
  0x3333336d333332fa, 0xaaaaab0b555554f7,
  0xcccccce5ffffffe7, 0xaaaaaad4aaaaaa82,
  0x999999b966666647, 0x5555558a55555522,
  0x66666686ffffffe0, 0x0000003655555521,
  0x3333335466666646, 0xaaaaaae1ffffffcb,
  0xccccccd366666660, 0xaaaaaab5aaaaaaa1,
  0x999999a0fffffff9, 0x55555561aaaaaaa0,
  0x6666666e6666665f, 0x0000000d5555554a,
  0x3333333b99999992, 0xaaaaaab8aaaaaa9f,
  0xaaaaaaabffffffff, 0x800000047ffffff8,
  0x55555557aaaaaaa9, 0x000000087ffffff2,
  0x00000002fffffffe, 0x8000000bffffffef,
  0x00000002fffffffe, 0x8000000bffffffef,
  0xaaaaaaabaaaaaaaa, 0x80000003fffffffb,
  0x55555556ffffffff, 0x000000077ffffff8,
  0x55555556ffffffff, 0x000000077ffffff8,
  0x55555556aaaaaaaa, 0x00000006fffffffb,
  0xaaaaaaab55555555, 0x800000037ffffffe,
  0xaaaaaaab55555555, 0x800000037ffffffe,
  0xaaaaaaab00000000, 0x8000000300000001,
  0xaaaaaaaa55555556, 0x8000000200000007,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffaaaaaaab, 0xffffffff80000004,
  0xffffffff00000001, 0xfffffffe8000000a,
  0xfffffff455555561, 0xffffffee8000006a,
  0xffffffffaaaaaaab, 0xffffffff80000004,
  0xffffffff00000001, 0xfffffffe8000000a,
  0xfffffff455555561, 0xffffffee8000006a,
  0xffffffcaaaaaaae0, 0xffffffb0000001e1,
  0xffffffff55555556, 0xffffffff00000007,
  0xfffffff4aaaaaab6, 0xffffffef00000067,
  0xffffffcb00000035, 0xffffffb0800001de,
  0xffffffa10000005f, 0xffffff7180000358,
  0xfffffff555555560, 0xfffffff000000061,
  0xffffffcbaaaaaadf, 0xffffffb1800001d8,
  0xffffffa1aaaaab09, 0xffffff7280000352,
  0xffffff77555555de, 0xffffff33000004cf,
  0xffffffd65555557f, 0xffffffc180000178,
  0xffffffac555555a9, 0xffffff82800002f2,
  0xffffff820000007e, 0xffffff430000046f,
  0xffffd4d85555807d, 0xffffbf4480018466,
  0xffffffd60000002a, 0xffffffc10000017b,
  0xffffffabaaaaaaff, 0xffffff81800002f8,
  0xffffd50200002afe, 0xffffbf83000182ef,
  0xffffaa58000055a8, 0xffff7f84000302e9,
  0xffffffd5aaaaaad5, 0xffffffc08000017e,
  0xffffd52c00002ad4, 0xffffbfc200018175,
  0xffffaa820000557e, 0xffff7fc30003016f,
  0xffff7fd7aaab2ad3, 0xffff3fc38004816c,
  0xffffd55655557fff, 0xffffc00180017ff8,
  0xffffaaac5555aaa9, 0xffff80028002fff2,
  0xffff800200007ffe, 0xffff400300047fef,
  0xeeee6ef11111910f, 0xe665a66a199e1988,
  0xffffd55600002aaa, 0xffffc00100017ffb,
  0xffffaaabaaaaffff, 0xffff80018002fff8,
  0xeeee999abbbc1110, 0xe665e668999c9991,
  0xd27cd27e82d882d7, 0xbbbb3bbf199c9990,
  0xffffd555aaaad555, 0xffffc00080017ffe,
  0xeeeec444bbbbe666, 0xe6662667999b1997,
  0xd27cfd2882d8582d, 0xbbbb7bbe199b1996,
  0xa7d2527f02d8582c, 0x7bbb7bc1199b198d,
  0xeeeeeeef11111111, 0xe66666671999999a,
  0xd27d27d2d82d82d8, 0xbbbbbbbd99999999,
  0xa7d27d29582d82d7, 0x7bbbbbc099999990,
  0x7d27d27f82d82d81, 0x3bbbbbc31999998a,
  0xe38e38e3c71c71c7, 0xd555555680000000,
  0xb8e38e3a471c71c6, 0x955555597ffffff7,
  0x8e38e39071c71c70, 0x5555555bfffffff1,
  0x638e38e6471c71c5, 0x1555555dffffffee,
  0xd55555567fffffff, 0xc0000002fffffff8,
  0xaaaaaaacaaaaaaa9, 0x800000057ffffff2,
  0x800000027ffffffe, 0x400000077fffffef,
  0x55555557fffffffe, 0x00000008ffffffef,
  0xd55555562aaaaaaa, 0xc00000027ffffffb,
  0xaaaaaaabffffffff, 0x800000047ffffff8,
  0x800000017fffffff, 0x40000005fffffff8,
  0x55555556aaaaaaaa, 0x00000006fffffffb,
  0xd5555555d5555555, 0xc0000001fffffffe,
  0xaaaaaaab55555555, 0x800000037ffffffe,
  0x8000000080000000, 0x4000000480000001,
  0x471c71c80e38e38e, 0xeaaaaab17fffffff,
  0xd555555580000000, 0xc000000180000001,
  0xaaaaaaaaaaaaaaab, 0x8000000280000004,
  0x71c71c7238e38e39, 0x2aaaaaaf80000002,
  0x2d82d82e7d27d27d, 0xc444444be6666666,
  0xd55555552aaaaaab, 0xc000000100000004,
  0x9c71c71cb8e38e39, 0x6aaaaaae00000002,
  0x582d82d8fd27d27d, 0x0444444a66666666,
  0x02d8582ea7d2527d, 0x8444844d6664e666,
  0xc71c71c78e38e38e, 0xaaaaaaacffffffff,
  0x82d82d83d27d27d2, 0x4444444966666663,
  0x2d8302d97d27a7d2, 0xc444844c6664e663,
  0xd82dd82ed27cd27d, 0x4444c44ee6636666,
  0xbbbbbbbc44444444, 0x9999999c66666665,
  0x66669111eeeec444, 0x1999d99f6664e665,
  0x111166674443eeef, 0x999a19a1e6636668,
  0xbbbc3bbc4443c445, 0x199a59a3e661e66e,
  0xaaaad555aaaa8000, 0x80004002fffe8001,
  0x5555aaaaffffaaab, 0x000080057ffd0004,
  0x00007fffffff8001, 0x8000c0077ffb800a,
  0xaaab5554aaaa0002, 0x00010008fffa0013,
  0xaaaad55555552aab, 0x800040027ffe8004,
  0x5555aaaa55550001, 0x000080047ffd000a,
  0x00007ffeffff8002, 0x8000c005fffb8013,
  0xaaab2ad4aaaa2a82, 0x0000c048fffb7e93,
  0xaaaad554ffffd556, 0x80004001fffe8007,
  0x5555aaa9aaaa5557, 0x000080037ffd0010,
  0x0000557f5554ffd7, 0x800080467ffcfe90,
  0xaaab0054aaaa5502, 0x00008088fffcfd13,
  0xaaaad554aaaa8001, 0x800040017ffe800a,
  0x5555802a55552a81, 0x000040447ffe7e8a,
  0x00002affaaaa7fac, 0x80004086fffe7d0d,
  0xaaaad5d4aaaa7f82, 0x000040c8fffe7b93,
  0xaaaaaad5aaaaaa80, 0x80000042fffffe81,
  0x555555aaffffffab, 0x000000857ffffd04,
  0x0000007fffffff81, 0x800000c77ffffb8a,
  0xaaaaab54aaaaaa02, 0x00000108fffffa13,
  0xaaaaaad55555552b, 0x800000427ffffe84,
  0x555555aa55555501, 0x000000847ffffd0a,
  0x0000007effffff82, 0x800000c5fffffb93,
  0xaaaaab34aaaaaa22, 0x000000d8fffffb33,
  0xaaaaaad4ffffffd6, 0x80000041fffffe87,
  0x555555a9aaaaaa57, 0x000000837ffffd10,
  0x0000005f555554f7, 0x800000967ffffcb0,
  0xaaaaab0b555554f6, 0x0000009afffffca7,
  0xaaaaaad4aaaaaa81, 0x800000417ffffe8a,
  0x5555558a55555521, 0x000000547ffffe2a,
  0x0000003655555520, 0x80000058fffffe21,
  0xaaaaaae1ffffffca, 0x0000005cfffffe1b,
  0xaaaaaab5aaaaaaa0, 0x80000012ffffffa1,
  0x55555561aaaaaa9f, 0x000000177fffff98,
  0x0000000d55555549, 0x8000001b7fffff92,
  0xaaaaaab8aaaaaa9e, 0x0000001effffff8f,
  0x800000047ffffff7, 0x800000037ffffffb,
  0x000000087ffffff1, 0x000000067ffffff7,
  0x8000000bffffffee, 0x80000008fffffff5,
  0x8000000bffffffee, 0x80000008fffffff5,
  0x80000003fffffffa, 0x80000002fffffffd,
  0x000000077ffffff7, 0x000000057ffffffb,
  0x000000077ffffff7, 0x000000057ffffffb,
  0x00000006fffffffa, 0x00000004fffffffd,
  0x800000037ffffffd, 0x800000027fffffff,
  0x800000037ffffffd, 0x800000027fffffff,
  0x8000000300000000, 0x8000000200000001,
  0x8000000200000006, 0x8000000100000005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000003, 0xffffffff80000003,
  0xfffffffe80000009, 0xfffffffe80000007,
  0xffffffee80000069, 0xffffffee80000047,
  0xffffffff80000003, 0xffffffff80000003,
  0xfffffffe80000009, 0xfffffffe80000007,
  0xffffffee80000069, 0xffffffee80000047,
  0xffffffb0000001e0, 0xffffffb000000141,
  0xffffffff00000006, 0xffffffff00000005,
  0xffffffef00000066, 0xffffffef00000045,
  0xffffffb0800001dd, 0xffffffb08000013f,
  0xffffff7180000357, 0xffffff718000023b,
  0xfffffff000000060, 0xfffffff000000041,
  0xffffffb1800001d7, 0xffffffb18000013b,
  0xffffff7280000351, 0xffffff7280000237,
  0xffffff33000004ce, 0xffffff3300000335,
  0xffffffc180000177, 0xffffffc1800000fb,
  0xffffff82800002f1, 0xffffff82800001f7,
  0xffffff430000046e, 0xffffff43000002f5,
  0xffffbf4480018465, 0xffffbf44800102ef,
  0xffffffc10000017a, 0xffffffc1000000fd,
  0xffffff81800002f7, 0xffffff81800001fb,
  0xffffbf83000182ee, 0xffffbf83000101f5,
  0xffff7f84000302e8, 0xffff7f84000201f1,
  0xffffffc08000017d, 0xffffffc0800000ff,
  0xffffbfc200018174, 0xffffbfc2000100f9,
  0xffff7fc30003016e, 0xffff7fc3000200f5,
  0xffff3fc38004816b, 0xffff3fc3800300f3,
  0xffffc00180017ff7, 0xffffc0018000fffb,
  0xffff80028002fff1, 0xffff80028001fff7,
  0xffff400300047fee, 0xffff40030002fff5,
  0xe665a66a199e1987, 0xe665a669e669665b,
  0xffffc00100017ffa, 0xffffc0010000fffd,
  0xffff80018002fff7, 0xffff80018001fffb,
  0xe665e668999c9990, 0xe665e66866686661,
  0xbbbb3bbf199c998f, 0xbbbb3bbe9113110b,
  0xffffc00080017ffd, 0xffffc0008000ffff,
  0xe6662667999b1996, 0xe666266766676665,
  0xbbbb7bbe199b1995, 0xbbbb7bbd9112110f,
  0x7bbb7bc1199b198c, 0x7bbb7bc011121109,
  0xe666666719999999, 0xe6666666e6666667,
  0xbbbbbbbd99999998, 0xbbbbbbbd11111111,
  0x7bbbbbc09999998f, 0x7bbbbbbf9111110b,
  0x3bbbbbc319999989, 0x3bbbbbc191111107,
  0xd55555567fffffff, 0xd55555562aaaaaab,
  0x955555597ffffff6, 0x95555558aaaaaaa5,
  0x5555555bfffffff0, 0x5555555aaaaaaaa1,
  0x1555555dffffffed, 0x1555555c2aaaaa9f,
  0xc0000002fffffff7, 0xc00000027ffffffb,
  0x800000057ffffff1, 0x800000047ffffff7,
  0x400000077fffffee, 0x40000005fffffff5,
  0x00000008ffffffee, 0x00000006fffffff5,
  0xc00000027ffffffa, 0xc0000001fffffffd,
  0x800000047ffffff7, 0x800000037ffffffb,
  0x40000005fffffff7, 0x400000047ffffffb,
  0x00000006fffffffa, 0x00000004fffffffd,
  0xc0000001fffffffd, 0xc00000017fffffff,
  0x800000037ffffffd, 0x800000027fffffff,
  0x4000000480000000, 0x4000000300000001,
  0xeaaaaab17ffffffe, 0xeaaaaaaf55555555,
  0xc000000180000000, 0xc000000100000001,
  0x8000000280000003, 0x8000000180000003,
  0x2aaaaaaf80000001, 0x2aaaaaadd5555557,
  0xc444444be6666665, 0xc44444496eeeeeef,
  0xc000000100000003, 0xc000000080000003,
  0x6aaaaaae00000001, 0x6aaaaaacd5555557,
  0x0444444a66666665, 0x044444486eeeeeef,
  0x8444844d6664e665, 0x8444844a6eedeeef,
  0xaaaaaaacfffffffe, 0xaaaaaaac55555555,
  0x4444444966666662, 0x44444447eeeeeeed,
  0xc444844c6664e662, 0xc4448449eeedeeed,
  0x4444c44ee6636665, 0x4444c44b6eeceeef,
  0x9999999c66666664, 0x9999999b99999999,
  0x1999d99f6664e664, 0x1999d99d99989999,
  0x999a19a1e6636667, 0x999a199f1997999b,
  0x199a59a3e661e66d, 0x199a59a01996999f,
  0x80004002fffe8000, 0x80004001ffff0001,
  0x000080057ffd0003, 0x000080037ffe0003,
  0x8000c0077ffb8009, 0x8000c0047ffd0007,
  0x00010008fffa0012, 0x00010004fffc000d,
  0x800040027ffe8003, 0x800040017fff0003,
  0x000080047ffd0009, 0x000080027ffe0007,
  0x8000c005fffb8012, 0x8000c002fffd000d,
  0x0000c048fffb7e92, 0x0000c044fffcff0d,
  0x80004001fffe8006, 0x80004000ffff0005,
  0x000080037ffd000f, 0x000080017ffe000b,
  0x800080467ffcfe8f, 0x800080437ffdff0b,
  0x00008088fffcfd12, 0x00008084fffdfe0d,
  0x800040017ffe8009, 0x800040007fff0007,
  0x000040447ffe7e89, 0x000040427ffeff07,
  0x80004086fffe7d0c, 0x80004083fffefe09,
  0x000040c8fffe7b92, 0x000040c4fffefd0d,
  0x80000042fffffe80, 0x80000041ffffff01,
  0x000000857ffffd03, 0x000000837ffffe03,
  0x800000c77ffffb89, 0x800000c47ffffd07,
  0x00000108fffffa12, 0x00000104fffffc0d,
  0x800000427ffffe83, 0x800000417fffff03,
  0x000000847ffffd09, 0x000000827ffffe07,
  0x800000c5fffffb92, 0x800000c2fffffd0d,
  0x000000d8fffffb32, 0x000000d4fffffccd,
  0x80000041fffffe86, 0x80000040ffffff05,
  0x000000837ffffd0f, 0x000000817ffffe0b,
  0x800000967ffffcaf, 0x800000937ffffdcb,
  0x0000009afffffca6, 0x00000096fffffdc5,
  0x800000417ffffe89, 0x800000407fffff07,
  0x000000547ffffe29, 0x000000527ffffec7,
  0x80000058fffffe20, 0x80000055fffffec1,
  0x0000005cfffffe1a, 0x00000058fffffebd,
  0x80000012ffffffa0, 0x80000011ffffffc1,
  0x000000177fffff97, 0x000000157fffffbb,
  0x8000001b7fffff91, 0x800000187fffffb7,
  0x0000001effffff8e, 0x0000001affffffb5,
  0x800000037ffffffa, 0x800000027ffffffe,
  0x000000067ffffff6, 0x000000047ffffffc,
  0x80000008fffffff4, 0x80000005fffffffb,
  0x80000008fffffff4, 0x80000005fffffffb,
  0x80000002fffffffc, 0x80000001ffffffff,
  0x000000057ffffffa, 0x000000037ffffffe,
  0x000000057ffffffa, 0x000000037ffffffe,
  0x00000004fffffffc, 0x00000002ffffffff,
  0x800000027ffffffe, 0x8000000180000000,
  0x800000027ffffffe, 0x8000000180000000,
  0x8000000200000000, 0x8000000100000001,
  0x8000000100000004, 0x8000000000000003,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000002, 0xffffffff80000002,
  0xfffffffe80000006, 0xfffffffe80000004,
  0xffffffee80000046, 0xffffffee80000024,
  0xffffffff80000002, 0xffffffff80000002,
  0xfffffffe80000006, 0xfffffffe80000004,
  0xffffffee80000046, 0xffffffee80000024,
  0xffffffb000000140, 0xffffffb0000000a1,
  0xffffffff00000004, 0xffffffff00000003,
  0xffffffef00000044, 0xffffffef00000023,
  0xffffffb08000013e, 0xffffffb0800000a0,
  0xffffff718000023a, 0xffffff718000011e,
  0xfffffff000000040, 0xfffffff000000021,
  0xffffffb18000013a, 0xffffffb18000009e,
  0xffffff7280000236, 0xffffff728000011c,
  0xffffff3300000334, 0xffffff330000019b,
  0xffffffc1800000fa, 0xffffffc18000007e,
  0xffffff82800001f6, 0xffffff82800000fc,
  0xffffff43000002f4, 0xffffff430000017b,
  0xffffbf44800102ee, 0xffffbf4480008178,
  0xffffffc1000000fc, 0xffffffc10000007f,
  0xffffff81800001fa, 0xffffff81800000fe,
  0xffffbf83000101f4, 0xffffbf83000080fb,
  0xffff7f84000201f0, 0xffff7f84000100f9,
  0xffffffc0800000fe, 0xffffffc080000080,
  0xffffbfc2000100f8, 0xffffbfc20000807d,
  0xffff7fc3000200f4, 0xffff7fc30001007b,
  0xffff3fc3800300f2, 0xffff3fc38001807a,
  0xffffc0018000fffa, 0xffffc00180007ffe,
  0xffff80028001fff6, 0xffff80028000fffc,
  0xffff40030002fff4, 0xffff400300017ffb,
  0xe665a669e669665a, 0xe665a669b334b32e,
  0xffffc0010000fffc, 0xffffc00100007fff,
  0xffff80018001fffa, 0xffff80018000fffe,
  0xe665e66866686660, 0xe665e66833343331,
  0xbbbb3bbe9113110a, 0xbbbb3bbe08898886,
  0xffffc0008000fffe, 0xffffc00080008000,
  0xe666266766676664, 0xe66626673333b333,
  0xbbbb7bbd9112110e, 0xbbbb7bbd08890888,
  0x7bbb7bc011121108, 0x7bbb7bbf08890885,
  0xe6666666e6666666, 0xe6666666b3333334,
  0xbbbbbbbd11111110, 0xbbbbbbbc88888889,
  0x7bbbbbbf9111110a, 0x7bbbbbbe88888886,
  0x3bbbbbc191111106, 0x3bbbbbc008888884,
  0xd55555562aaaaaaa, 0xd5555555d5555556,
  0x95555558aaaaaaa4, 0x95555557d5555553,
  0x5555555aaaaaaaa0, 0x5555555955555551,
  0x1555555c2aaaaa9e, 0x1555555a55555550,
  0xc00000027ffffffa, 0xc0000001fffffffe,
  0x800000047ffffff6, 0x800000037ffffffc,
  0x40000005fffffff4, 0x400000047ffffffb,
  0x00000006fffffff4, 0x00000004fffffffb,
  0xc0000001fffffffc, 0xc00000017fffffff,
  0x800000037ffffffa, 0x800000027ffffffe,
  0x400000047ffffffa, 0x40000002fffffffe,
  0x00000004fffffffc, 0x00000002ffffffff,
  0xc00000017ffffffe, 0xc000000100000000,
  0x800000027ffffffe, 0x8000000180000000,
  0x4000000300000000, 0x4000000180000001,
  0xeaaaaaaf55555554, 0xeaaaaaad2aaaaaab,
  0xc000000100000000, 0xc000000080000001,
  0x8000000180000002, 0x8000000080000002,
  0x2aaaaaadd5555556, 0x2aaaaaac2aaaaaac,
  0xc44444496eeeeeee, 0xc4444446f7777778,
  0xc000000080000002, 0xc000000000000002,
  0x6aaaaaacd5555556, 0x6aaaaaabaaaaaaac,
  0x044444486eeeeeee, 0x0444444677777778,
  0x8444844a6eedeeee, 0x844484477776f778,
  0xaaaaaaac55555554, 0xaaaaaaabaaaaaaab,
  0x44444447eeeeeeec, 0x4444444677777777,
  0xc4448449eeedeeec, 0xc44484477776f777,
  0x4444c44b6eeceeee, 0x4444c447f7767778,
  0x9999999b99999998, 0x9999999acccccccd,
  0x1999d99d99989998, 0x1999d99bcccc4ccd,
  0x999a199f1997999a, 0x999a199c4ccbccce,
  0x199a59a01996999e, 0x199a599c4ccb4cd0,
  0x80004001ffff0000, 0x80004000ffff8001,
  0x000080037ffe0002, 0x000080017fff0002,
  0x8000c0047ffd0006, 0x8000c0017ffe8004,
  0x00010004fffc000c, 0x00010000fffe0007,
  0x800040017fff0002, 0x800040007fff8002,
  0x000080027ffe0006, 0x000080007fff0004,
  0x8000c002fffd000c, 0x8000bffffffe8007,
  0x0000c044fffcff0c, 0x0000c040fffe7f87,
  0x80004000ffff0004, 0x80003fffffff8003,
  0x000080017ffe000a, 0x00007fff7fff0006,
  0x800080437ffdff0a, 0x800080407ffeff86,
  0x00008084fffdfe0c, 0x00008080fffeff07,
  0x800040007fff0006, 0x80003fff7fff8004,
  0x000040427ffeff06, 0x000040407fff7f84,
  0x80004083fffefe08, 0x80004080ffff7f05,
  0x000040c4fffefd0c, 0x000040c0ffff7e87,
  0x80000041ffffff00, 0x80000040ffffff81,
  0x000000837ffffe02, 0x000000817fffff02,
  0x800000c47ffffd06, 0x800000c17ffffe84,
  0x00000104fffffc0c, 0x00000100fffffe07,
  0x800000417fffff02, 0x800000407fffff82,
  0x000000827ffffe06, 0x000000807fffff04,
  0x800000c2fffffd0c, 0x800000bffffffe87,
  0x000000d4fffffccc, 0x000000d0fffffe67,
  0x80000040ffffff04, 0x8000003fffffff83,
  0x000000817ffffe0a, 0x0000007f7fffff06,
  0x800000937ffffdca, 0x800000907ffffee6,
  0x00000096fffffdc4, 0x00000092fffffee3,
  0x800000407fffff06, 0x8000003f7fffff84,
  0x000000527ffffec6, 0x000000507fffff64,
  0x80000055fffffec0, 0x80000052ffffff61,
  0x00000058fffffebc, 0x00000054ffffff5f,
  0x80000011ffffffc0, 0x80000010ffffffe1,
  0x000000157fffffba, 0x000000137fffffde,
  0x800000187fffffb6, 0x800000157fffffdc,
  0x0000001affffffb4, 0x00000016ffffffdb,
  0x800000027ffffffd, 0x8000000180000001,
  0x000000047ffffffb, 0x0000000280000001,
  0x80000005fffffffa, 0x8000000300000001,
  0x80000005fffffffa, 0x8000000300000001,
  0x80000001fffffffe, 0x8000000100000001,
  0x000000037ffffffd, 0x0000000180000001,
  0x000000037ffffffd, 0x0000000180000001,
  0x00000002fffffffe, 0x0000000100000001,
  0x800000017fffffff, 0x8000000080000001,
  0x800000017fffffff, 0x8000000080000001,
  0x8000000100000000, 0x8000000000000001,
  0x8000000000000002, 0x7fffffff00000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000001, 0xffffffff80000001,
  0xfffffffe80000003, 0xfffffffe80000001,
  0xffffffee80000023, 0xffffffee80000001,
  0xffffffff80000001, 0xffffffff80000001,
  0xfffffffe80000003, 0xfffffffe80000001,
  0xffffffee80000023, 0xffffffee80000001,
  0xffffffb0000000a0, 0xffffffb000000001,
  0xffffffff00000002, 0xffffffff00000001,
  0xffffffef00000022, 0xffffffef00000001,
  0xffffffb08000009f, 0xffffffb080000001,
  0xffffff718000011d, 0xffffff7180000001,
  0xfffffff000000020, 0xfffffff000000001,
  0xffffffb18000009d, 0xffffffb180000001,
  0xffffff728000011b, 0xffffff7280000001,
  0xffffff330000019a, 0xffffff3300000001,
  0xffffffc18000007d, 0xffffffc180000001,
  0xffffff82800000fb, 0xffffff8280000001,
  0xffffff430000017a, 0xffffff4300000001,
  0xffffbf4480008177, 0xffffbf4480000001,
  0xffffffc10000007e, 0xffffffc100000001,
  0xffffff81800000fd, 0xffffff8180000001,
  0xffffbf83000080fa, 0xffffbf8300000001,
  0xffff7f84000100f8, 0xffff7f8400000001,
  0xffffffc08000007f, 0xffffffc080000001,
  0xffffbfc20000807c, 0xffffbfc200000001,
  0xffff7fc30001007a, 0xffff7fc300000001,
  0xffff3fc380018079, 0xffff3fc380000001,
  0xffffc00180007ffd, 0xffffc00180000001,
  0xffff80028000fffb, 0xffff800280000001,
  0xffff400300017ffa, 0xffff400300000001,
  0xe665a669b334b32d, 0xe665a66980000001,
  0xffffc00100007ffe, 0xffffc00100000001,
  0xffff80018000fffd, 0xffff800180000001,
  0xe665e66833343330, 0xe665e66800000001,
  0xbbbb3bbe08898885, 0xbbbb3bbd80000001,
  0xffffc00080007fff, 0xffffc00080000001,
  0xe66626673333b332, 0xe666266700000001,
  0xbbbb7bbd08890887, 0xbbbb7bbc80000001,
  0x7bbb7bbf08890884, 0x7bbb7bbe00000001,
  0xe6666666b3333333, 0xe666666680000001,
  0xbbbbbbbc88888888, 0xbbbbbbbc00000001,
  0x7bbbbbbe88888885, 0x7bbbbbbd80000001,
  0x3bbbbbc008888883, 0x3bbbbbbe80000001,
  0xd5555555d5555555, 0xd555555580000001,
  0x95555557d5555552, 0x9555555700000001,
  0x5555555955555550, 0x5555555800000001,
  0x1555555a5555554f, 0x1555555880000001,
  0xc0000001fffffffd, 0xc000000180000001,
  0x800000037ffffffb, 0x8000000280000001,
  0x400000047ffffffa, 0x4000000300000001,
  0x00000004fffffffa, 0x0000000300000001,
  0xc00000017ffffffe, 0xc000000100000001,
  0x800000027ffffffd, 0x8000000180000001,
  0x40000002fffffffd, 0x4000000180000001,
  0x00000002fffffffe, 0x0000000100000001,
  0xc0000000ffffffff, 0xc000000080000001,
  0x800000017fffffff, 0x8000000080000001,
  0x4000000180000000, 0x4000000000000001,
  0xeaaaaaad2aaaaaaa, 0xeaaaaaab00000001,
  0xc000000080000000, 0xc000000000000001,
  0x8000000080000001, 0x7fffffff80000001,
  0x2aaaaaac2aaaaaab, 0x2aaaaaaa80000001,
  0xc4444446f7777777, 0xc444444480000001,
  0xc000000000000001, 0xbfffffff80000001,
  0x6aaaaaabaaaaaaab, 0x6aaaaaaa80000001,
  0x0444444677777777, 0x0444444480000001,
  0x844484477776f777, 0x8444844480000001,
  0xaaaaaaabaaaaaaaa, 0xaaaaaaab00000001,
  0x4444444677777776, 0x4444444500000001,
  0xc44484477776f776, 0xc444844500000001,
  0x4444c447f7767777, 0x4444c44480000001,
  0x9999999acccccccc, 0x9999999a00000001,
  0x1999d99bcccc4ccc, 0x1999d99a00000001,
  0x999a199c4ccbcccd, 0x999a199980000001,
  0x199a599c4ccb4ccf, 0x199a599880000001,
  0x80004000ffff8000, 0x8000400000000001,
  0x000080017fff0001, 0x00007fff80000001,
  0x8000c0017ffe8003, 0x8000bffe80000001,
  0x00010000fffe0006, 0x0000fffd00000001,
  0x800040007fff8001, 0x80003fff80000001,
  0x000080007fff0003, 0x00007ffe80000001,
  0x8000bffffffe8006, 0x8000bffd00000001,
  0x0000c040fffe7f86, 0x0000c03d00000001,
  0x80003fffffff8002, 0x80003fff00000001,
  0x00007fff7fff0005, 0x00007ffd80000001,
  0x800080407ffeff85, 0x8000803d80000001,
  0x00008080fffeff06, 0x0000807d00000001,
  0x80003fff7fff8003, 0x80003ffe80000001,
  0x000040407fff7f83, 0x0000403e80000001,
  0x80004080ffff7f04, 0x8000407e00000001,
  0x000040c0ffff7e86, 0x000040bd00000001,
  0x80000040ffffff80, 0x8000004000000001,
  0x000000817fffff01, 0x0000007f80000001,
  0x800000c17ffffe83, 0x800000be80000001,
  0x00000100fffffe06, 0x000000fd00000001,
  0x800000407fffff81, 0x8000003f80000001,
  0x000000807fffff03, 0x0000007e80000001,
  0x800000bffffffe86, 0x800000bd00000001,
  0x000000d0fffffe66, 0x000000cd00000001,
  0x8000003fffffff82, 0x8000003f00000001,
  0x0000007f7fffff05, 0x0000007d80000001,
  0x800000907ffffee5, 0x8000008d80000001,
  0x00000092fffffee2, 0x0000008f00000001,
  0x8000003f7fffff83, 0x8000003e80000001,
  0x000000507fffff63, 0x0000004e80000001,
  0x80000052ffffff60, 0x8000005000000001,
  0x00000054ffffff5e, 0x0000005100000001,
  0x80000010ffffffe0, 0x8000001000000001,
  0x000000137fffffdd, 0x0000001180000001,
  0x800000157fffffdb, 0x8000001280000001,
  0x00000016ffffffda, 0x0000001300000001,
  0x8000000180000000, 0x8000000080000004,
  0x0000000280000000, 0x0000000080000006,
  0x8000000300000000, 0x8000000000000007,
  0x8000000300000000, 0x8000000000000007,
  0x8000000100000000, 0x8000000000000003,
  0x0000000180000000, 0xffffffff80000004,
  0x0000000180000000, 0xffffffff80000004,
  0x0000000100000000, 0xffffffff00000003,
  0x8000000080000000, 0x7fffffff80000002,
  0x8000000080000000, 0x7fffffff80000002,
  0x8000000000000000, 0x7fffffff00000001,
  0x7fffffff00000000, 0x7ffffffdffffffff,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xfffffffe80000000, 0xfffffffe7ffffffe,
  0xffffffee80000000, 0xffffffee7fffffde,
  0xffffffff80000000, 0xffffffff80000000,
  0xfffffffe80000000, 0xfffffffe7ffffffe,
  0xffffffee80000000, 0xffffffee7fffffde,
  0xffffffb000000000, 0xffffffafffffff61,
  0xffffffff00000000, 0xfffffffeffffffff,
  0xffffffef00000000, 0xffffffeeffffffdf,
  0xffffffb080000000, 0xffffffb07fffff62,
  0xffffff7180000000, 0xffffff717ffffee4,
  0xfffffff000000000, 0xffffffefffffffe1,
  0xffffffb180000000, 0xffffffb17fffff64,
  0xffffff7280000000, 0xffffff727ffffee6,
  0xffffff3300000000, 0xffffff32fffffe67,
  0xffffffc180000000, 0xffffffc17fffff84,
  0xffffff8280000000, 0xffffff827fffff06,
  0xffffff4300000000, 0xffffff42fffffe87,
  0xffffbf4480000000, 0xffffbf447fff7e8a,
  0xffffffc100000000, 0xffffffc0ffffff83,
  0xffffff8180000000, 0xffffff817fffff04,
  0xffffbf8300000000, 0xffffbf82ffff7f07,
  0xffff7f8400000000, 0xffff7f83fffeff09,
  0xffffffc080000000, 0xffffffc07fffff82,
  0xffffbfc200000000, 0xffffbfc1ffff7f85,
  0xffff7fc300000000, 0xffff7fc2fffeff87,
  0xffff3fc380000000, 0xffff3fc37ffe7f88,
  0xffffc00180000000, 0xffffc0017fff8004,
  0xffff800280000000, 0xffff80027fff0006,
  0xffff400300000000, 0xffff4002fffe8007,
  0xe665a66980000000, 0xe665a6694ccb4cd4,
  0xffffc00100000000, 0xffffc000ffff8003,
  0xffff800180000000, 0xffff80017fff0004,
  0xe665e66800000000, 0xe665e667cccbccd1,
  0xbbbb3bbd80000000, 0xbbbb3bbcf776777c,
  0xffffc00080000000, 0xffffc0007fff8002,
  0xe666266700000000, 0xe6662666cccc4ccf,
  0xbbbb7bbc80000000, 0xbbbb7bbbf776f77a,
  0x7bbb7bbe00000000, 0x7bbb7bbcf776f77d,
  0xe666666680000000, 0xe66666664cccccce,
  0xbbbbbbbc00000000, 0xbbbbbbbb77777779,
  0x7bbbbbbd80000000, 0x7bbbbbbc7777777c,
  0x3bbbbbbe80000000, 0x3bbbbbbcf777777e,
  0xd555555580000000, 0xd55555552aaaaaac,
  0x9555555700000000, 0x955555562aaaaaaf,
  0x5555555800000000, 0x55555556aaaaaab1,
  0x1555555880000000, 0x15555556aaaaaab2,
  0xc000000180000000, 0xc000000100000004,
  0x8000000280000000, 0x8000000180000006,
  0x4000000300000000, 0x4000000180000007,
  0x0000000300000000, 0x0000000100000007,
  0xc000000100000000, 0xc000000080000003,
  0x8000000180000000, 0x8000000080000004,
  0x4000000180000000, 0x4000000000000004,
  0x0000000100000000, 0xffffffff00000003,
  0xc000000080000000, 0xc000000000000002,
  0x8000000080000000, 0x7fffffff80000002,
  0x4000000000000000, 0x3ffffffe80000001,
  0xeaaaaaab00000000, 0xeaaaaaa8d5555557,
  0xc000000000000000, 0xbfffffff80000001,
  0x7fffffff80000000, 0x7ffffffe80000000,
  0x2aaaaaaa80000000, 0x2aaaaaa8d5555556,
  0xc444444480000000, 0xc44444420888888a,
  0xbfffffff80000000, 0xbfffffff00000000,
  0x6aaaaaaa80000000, 0x6aaaaaa955555556,
  0x0444444480000000, 0x044444428888888a,
  0x8444844480000000, 0x844484418889088a,
  0xaaaaaaab00000000, 0xaaaaaaaa55555557,
  0x4444444500000000, 0x444444438888888b,
  0xc444844500000000, 0xc44484428889088b,
  0x4444c44480000000, 0x4444c4410889888a,
  0x9999999a00000000, 0x9999999933333335,
  0x1999d99a00000000, 0x1999d9983333b335,
  0x999a199980000000, 0x999a1996b3343334,
  0x199a599880000000, 0x199a5994b334b332,
  0x8000400000000000, 0x80003fff00008001,
  0x00007fff80000000, 0x00007ffd80010000,
  0x8000bffe80000000, 0x8000bffb80017ffe,
  0x0000fffd00000000, 0x0000fff90001fffb,
  0x80003fff80000000, 0x80003ffe80008000,
  0x00007ffe80000000, 0x00007ffc8000fffe,
  0x8000bffd00000000, 0x8000bffa00017ffb,
  0x0000c03d00000000, 0x0000c0390001807b,
  0x80003fff00000000, 0x80003ffe00007fff,
  0x00007ffd80000000, 0x00007ffb8000fffc,
  0x8000803d80000000, 0x8000803a8001007c,
  0x0000807d00000000, 0x00008079000100fb,
  0x80003ffe80000000, 0x80003ffd80007ffe,
  0x0000403e80000000, 0x0000403c8000807e,
  0x8000407e00000000, 0x8000407b000080fd,
  0x000040bd00000000, 0x000040b90000817b,
  0x8000004000000000, 0x8000003f00000081,
  0x0000007f80000000, 0x0000007d80000100,
  0x800000be80000000, 0x800000bb8000017e,
  0x000000fd00000000, 0x000000f9000001fb,
  0x8000003f80000000, 0x8000003e80000080,
  0x0000007e80000000, 0x0000007c800000fe,
  0x800000bd00000000, 0x800000ba0000017b,
  0x000000cd00000000, 0x000000c90000019b,
  0x8000003f00000000, 0x8000003e0000007f,
  0x0000007d80000000, 0x0000007b800000fc,
  0x8000008d80000000, 0x8000008a8000011c,
  0x0000008f00000000, 0x0000008b0000011f,
  0x8000003e80000000, 0x8000003d8000007e,
  0x0000004e80000000, 0x0000004c8000009e,
  0x8000005000000000, 0x8000004d000000a1,
  0x0000005100000000, 0x0000004d000000a3,
  0x8000001000000000, 0x8000000f00000021,
  0x0000001180000000, 0x0000000f80000024,
  0x8000001280000000, 0x8000000f80000026,
  0x0000001300000000, 0x0000000f00000027,
  0x8000000080000003, 0x55555557ffffffff,
  0x0000000080000005, 0xaaaaaaaf55555553,
  0x8000000000000006, 0x00000005fffffffd,
  0x8000000000000006, 0x00000005fffffffd,
  0x8000000000000002, 0x5555555755555555,
  0xffffffff80000003, 0xaaaaaaadffffffff,
  0xffffffff80000003, 0xaaaaaaadffffffff,
  0xffffffff00000002, 0xaaaaaaad55555555,
  0x7fffffff80000001, 0x55555556aaaaaaab,
  0x7fffffff80000001, 0x55555556aaaaaaab,
  0x7fffffff00000000, 0x5555555600000001,
  0x7ffffffdfffffffe, 0x55555554aaaaaaad,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff7fffffff, 0xffffffff55555557,
  0xfffffffe7ffffffd, 0xfffffffe00000003,
  0xffffffee7fffffdd, 0xffffffe8aaaaaac3,
  0xffffffff7fffffff, 0xffffffff55555557,
  0xfffffffe7ffffffd, 0xfffffffe00000003,
  0xffffffee7fffffdd, 0xffffffe8aaaaaac3,
  0xffffffafffffff60, 0xffffff95555555c1,
  0xfffffffefffffffe, 0xfffffffeaaaaaaad,
  0xffffffeeffffffde, 0xffffffe95555556d,
  0xffffffb07fffff61, 0xffffff960000006b,
  0xffffff717ffffee3, 0xffffff42000000bf,
  0xffffffefffffffe0, 0xffffffeaaaaaaac1,
  0xffffffb17fffff63, 0xffffff97555555bf,
  0xffffff727ffffee5, 0xffffff4355555613,
  0xffffff32fffffe66, 0xfffffeeeaaaaabbd,
  0xffffffc17fffff83, 0xffffffacaaaaaaff,
  0xffffff827fffff05, 0xffffff58aaaaab53,
  0xffffff42fffffe86, 0xffffff04000000fd,
  0xffffbf447fff7e89, 0xffffa9b0aaab00fb,
  0xffffffc0ffffff82, 0xffffffac00000055,
  0xffffff817fffff03, 0xffffff57555555ff,
  0xffffbf82ffff7f06, 0xffffaa04000055fd,
  0xffff7f83fffeff08, 0xffff54b00000ab51,
  0xffffffc07fffff81, 0xffffffab555555ab,
  0xffffbfc1ffff7f84, 0xffffaa58000055a9,
  0xffff7fc2fffeff86, 0xffff55040000aafd,
  0xffff3fc37ffe7f87, 0xfffeffaf555655a7,
  0xffffc0017fff8003, 0xffffaaacaaaaffff,
  0xffff80027fff0005, 0xffff5558aaab5553,
  0xffff4002fffe8006, 0xffff00040000fffd,
  0xe665a6694ccb4cd3, 0xdddcdde22223221f,
  0xffffc000ffff8002, 0xffffaaac00005555,
  0xffff80017fff0003, 0xffff55575555ffff,
  0xe665e667cccbccd0, 0xdddd333577782221,
  0xbbbb3bbcf776777b, 0xa4f9a4fd05b105af,
  0xffffc0007fff8001, 0xffffaaab5555aaab,
  0xe6662666cccc4cce, 0xdddd88897777cccd,
  0xbbbb7bbbf776f779, 0xa4f9fa5105b0b05b,
  0x7bbb7bbcf776f77c, 0x4fa4a4fe05b0b059,
  0xe66666664ccccccd, 0xddddddde22222223,
  0xbbbbbbbb77777778, 0xa4fa4fa5b05b05b1,
  0x7bbbbbbc7777777b, 0x4fa4fa52b05b05af,
  0x3bbbbbbcf777777d, 0xfa4fa4ff05b05b03,
  0xd55555552aaaaaab, 0xc71c71c78e38e38f,
  0x955555562aaaaaae, 0x71c71c748e38e38d,
  0x55555556aaaaaab0, 0x1c71c720e38e38e1,
  0x15555556aaaaaab1, 0xc71c71cc8e38e38b,
  0xc000000100000003, 0xaaaaaaacffffffff,
  0x8000000180000005, 0x5555555955555553,
  0x4000000180000006, 0x00000004fffffffd,
  0x0000000100000006, 0xaaaaaaaffffffffd,
  0xc000000080000002, 0xaaaaaaac55555555,
  0x8000000080000003, 0x55555557ffffffff,
  0x4000000000000003, 0x00000002ffffffff,
  0xffffffff00000002, 0xaaaaaaad55555555,
  0xc000000000000001, 0xaaaaaaabaaaaaaab,
  0x7fffffff80000001, 0x55555556aaaaaaab,
  0x3ffffffe80000000, 0x0000000100000001,
  0xeaaaaaa8d5555556, 0x8e38e3901c71c71d,
  0xbfffffff80000000, 0xaaaaaaab00000001,
  0x7ffffffe7fffffff, 0x5555555555555557,
  0x2aaaaaa8d5555555, 0xe38e38e471c71c73,
  0xc444444208888889, 0x5b05b05cfa4fa4fb,
  0xbffffffeffffffff, 0xaaaaaaaa55555557,
  0x6aaaaaa955555555, 0x38e38e3971c71c73,
  0x0444444288888889, 0xb05b05b1fa4fa4fb,
  0x8444844188890889, 0x05b0b05d4fa4a4fb,
  0xaaaaaaaa55555556, 0x8e38e38f1c71c71d,
  0x444444438888888a, 0x05b05b07a4fa4fa5,
  0xc44484428889088a, 0x5b0605b2fa4f4fa5,
  0x4444c44108898889, 0xb05bb05da4f9a4fb,
  0x9999999933333334, 0x7777777888888889,
  0x1999d9983333b334, 0xcccd2223dddd8889,
  0x999a1996b3343333, 0x2222ccce8887dddf,
  0x199a5994b334b331, 0x777877788887888b,
  0x80003fff00008000, 0x5555aaab55550001,
  0x00007ffd8000ffff, 0xaaab5555ffff5557,
  0x8000bffb80017ffd, 0x0000ffffffff0003,
  0x0000fff90001fffa, 0x5556aaa955540005,
  0x80003ffe80007fff, 0x5555aaaaaaaa5557,
  0x00007ffc8000fffd, 0xaaab5554aaaa0003,
  0x8000bffa00017ffa, 0x0000fffdffff0005,
  0x0000c0390001807a, 0x555655a955545505,
  0x80003ffe00007ffe, 0x5555aaa9ffffaaad,
  0x00007ffb8000fffb, 0xaaab55535554aaaf,
  0x8000803a8001007b, 0x0000aafeaaa9ffaf,
  0x00008079000100fa, 0x555600a95554aa05,
  0x80003ffd80007ffd, 0x5555aaa955550003,
  0x0000403c8000807d, 0xaaab0054aaaa5503,
  0x8000407b000080fc, 0x000055ff5554ff59,
  0x000040b90000817a, 0x5555aba95554ff05,
  0x8000003f00000080, 0x555555ab55555501,
  0x0000007d800000ff, 0xaaaaab55ffffff57,
  0x800000bb8000017d, 0x000000ffffffff03,
  0x000000f9000001fa, 0x555556a955555405,
  0x8000003e8000007f, 0x555555aaaaaaaa57,
  0x0000007c800000fd, 0xaaaaab54aaaaaa03,
  0x800000ba0000017a, 0x000000fdffffff05,
  0x000000c90000019a, 0x5555566955555445,
  0x8000003e0000007e, 0x555555a9ffffffad,
  0x0000007b800000fb, 0xaaaaab53555554af,
  0x8000008a8000011b, 0x000000beaaaaa9ef,
  0x0000008b0000011e, 0x55555616aaaaa9ed,
  0x8000003d8000007d, 0x555555a955555503,
  0x0000004c8000009d, 0xaaaaab14aaaaaa43,
  0x8000004d000000a0, 0x0000006caaaaaa41,
  0x0000004d000000a2, 0x555555c3ffffff95,
  0x8000000f00000020, 0x5555556b55555541,
  0x0000000f80000023, 0xaaaaaac35555553f,
  0x8000000f80000025, 0x0000001aaaaaaa93,
  0x0000000f00000026, 0x555555715555553d,
  0x55555557fffffffe, 0x3333333666666665,
  0xaaaaaaaf55555552, 0x6666666bfffffffd,
  0x00000005fffffffc, 0x999999a0ccccccc9,
  0x00000005fffffffc, 0x999999a0ccccccc9,
  0x5555555755555554, 0x3333333599999999,
  0xaaaaaaadfffffffe, 0x6666666a66666665,
  0xaaaaaaadfffffffe, 0x6666666a66666665,
  0xaaaaaaad55555554, 0x6666666999999999,
  0x55555556aaaaaaaa, 0x33333334cccccccd,
  0x55555556aaaaaaaa, 0x33333334cccccccd,
  0x5555555600000000, 0x3333333400000001,
  0x55555554aaaaaaac, 0x3333333266666669,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff55555556, 0xffffffff33333335,
  0xfffffffe00000002, 0xfffffffd9999999d,
  0xffffffe8aaaaaac2, 0xffffffe40000001d,
  0xffffffff55555556, 0xffffffff33333335,
  0xfffffffe00000002, 0xfffffffd9999999d,
  0xffffffe8aaaaaac2, 0xffffffe40000001d,
  0xffffff95555555c0, 0xffffff8000000081,
  0xfffffffeaaaaaaac, 0xfffffffe66666669,
  0xffffffe95555556c, 0xffffffe4cccccce9,
  0xffffff960000006a, 0xffffff80cccccd4d,
  0xffffff42000000be, 0xffffff1c000000e5,
  0xffffffeaaaaaaac0, 0xffffffe666666681,
  0xffffff97555555be, 0xffffff82666666e5,
  0xffffff4355555612, 0xffffff1d99999a7d,
  0xfffffeeeaaaaabbc, 0xfffffeb800000149,
  0xffffffacaaaaaafe, 0xffffff9c00000065,
  0xffffff58aaaaab52, 0xffffff37333333fd,
  0xffffff04000000fc, 0xfffffed199999ac9,
  0xffffa9b0aaab00fa, 0xffff986d999a012d,
  0xffffffac00000054, 0xffffff9b33333399,
  0xffffff57555555fe, 0xffffff3599999a65,
  0xffffaa04000055fc, 0xffff98d1999a00c9,
  0xffff54b00000ab50, 0xffff326ccccd9a61,
  0xffffffab555555aa, 0xffffff9a666666cd,
  0xffffaa58000055a8, 0xffff99366666cd31,
  0xffff55040000aafc, 0xffff32d1999a66c9,
  0xfffeffaf555655a6, 0xfffecc6c00013395,
  0xffffaaacaaaafffe, 0xffff999c00006665,
  0xffff5558aaab5552, 0xffff33373333fffd,
  0xffff00040000fffc, 0xfffeccd1999accc9,
  0xdddcdde22223221e, 0xd7090a428f5d5c25,
  0xffffaaac00005554, 0xffff999b33339999,
  0xffff55575555fffe, 0xffff3335999a6665,
  0xdddd333577782220, 0xd70970a68f5cf5c1,
  0xa4f9a4fd05b105ae, 0x92c52c62d3a13a05,
  0xffffaaab5555aaaa, 0xffff999a6666cccd,
  0xdddd88897777cccc, 0xd709d70b5c295c29,
  0xa4f9fa5105b0b05a, 0x92c592c7a06da06d,
  0x4fa4a4fe05b0b058, 0x2c5f2c6406d406d1,
  0xddddddde22222222, 0xd70a3d70f5c28f5d,
  0xa4fa4fa5b05b05b0, 0x92c5f92d3a06d3a1,
  0x4fa4fa52b05b05ae, 0x2c5f92c9a06d3a05,
  0xfa4fa4ff05b05b02, 0xc5f92c653a06d39d,
  0xc71c71c78e38e38e, 0xbbbbbbbc44444445,
  0x71c71c748e38e38c, 0x55555558aaaaaaa9,
  0x1c71c720e38e38e0, 0xeeeeeef444444441,
  0xc71c71cc8e38e38a, 0x8888888f1111110d,
  0xaaaaaaacfffffffe, 0x9999999c66666665,
  0x5555555955555552, 0x33333337fffffffd,
  0x00000004fffffffc, 0xccccccd2ccccccc9,
  0xaaaaaaaffffffffc, 0x6666666cccccccc9,
  0xaaaaaaac55555554, 0x9999999b99999999,
  0x55555557fffffffe, 0x3333333666666665,
  0x00000002fffffffe, 0xccccccd066666665,
  0xaaaaaaad55555554, 0x6666666999999999,
  0xaaaaaaabaaaaaaaa, 0x9999999acccccccd,
  0x55555556aaaaaaaa, 0x33333334cccccccd,
  0x0000000100000000, 0xccccccce00000001,
  0x8e38e3901c71c71c, 0x4444444688888889,
  0xaaaaaaab00000000, 0x9999999a00000001,
  0x5555555555555556, 0x3333333333333335,
  0xe38e38e471c71c72, 0xaaaaaaabbbbbbbbd,
  0x5b05b05cfa4fa4fa, 0x06d3a06f92c5f92d,
  0xaaaaaaaa55555556, 0x9999999933333335,
  0x38e38e3971c71c72, 0x11111111bbbbbbbd,
  0xb05b05b1fa4fa4fa, 0x6d3a06d592c5f92d,
  0x05b0b05d4fa4a4fa, 0xa06da06ff92bf92d,
  0x8e38e38f1c71c71c, 0x7777777888888889,
  0x05b05b07a4fa4fa4, 0xd3a06d3c5f92c5f9,
  0x5b0605b2fa4f4fa4, 0x06d406d6c5f8c5f9,
  0xb05bb05da4f9a4fa, 0x3a07a0705f91f92d,
  0x7777777888888888, 0x5c28f5c3d70a3d71,
  0xcccd2223dddd8888, 0x8f5c8f5e3d703d71,
  0x2222ccce8887ddde, 0xc29028f7d70970a5,
  0x777877788887888a, 0xf5c3c290a3d5d70d,
  0x5555aaab55550000, 0x3333999a66660001,
  0xaaab5555ffff5556, 0x66673333ffff3335,
  0x0000ffffffff0002, 0x999acccccccb999d,
  0x5556aaa955540004, 0xccce6664cccb3339,
  0x5555aaaaaaaa5556, 0x3333999999993335,
  0xaaab5554aaaa0002, 0x666733326665999d,
  0x0000fffdffff0004, 0x999accca66653339,
  0x555655a955545504, 0xccce0064cccb9939,
  0x5555aaa9ffffaaac, 0x33339998cccc6669,
  0xaaab55535554aaae, 0x66673330cccc0005,
  0x0000aafeaaa9ffae, 0x999a66cb33326605,
  0x555600a95554aa04, 0xcccd9a64cccbff39,
  0x5555aaa955550002, 0x33339997ffff999d,
  0xaaab0054aaaa5502, 0x6666cd326665ff9d,
  0x000055ff5554ff58, 0x999a00cbffff98d1,
  0x5555aba95554ff04, 0xcccd3464cccc6539,
  0x555555ab55555500, 0x3333339a66666601,
  0xaaaaab55ffffff56, 0x66666733ffffff35,
  0x000000ffffffff02, 0x99999acccccccb9d,
  0x555556a955555404, 0xccccce64cccccb39,
  0x555555aaaaaaaa56, 0x3333339999999935,
  0xaaaaab54aaaaaa02, 0x666667326666659d,
  0x000000fdffffff04, 0x99999aca66666539,
  0x5555566955555444, 0xccccce17fffffeb9,
  0x555555a9ffffffac, 0x33333398cccccc69,
  0xaaaaab53555554ae, 0x66666730cccccc05,
  0x000000beaaaaa9ee, 0x99999a7e66666585,
  0x55555616aaaaa9ec, 0xcccccdb4cccccbe9,
  0x555555a955555502, 0x33333397ffffff9d,
  0xaaaaab14aaaaaa42, 0x666666e59999991d,
  0x0000006caaaaaa40, 0x99999a1bffffff81,
  0x555555c3ffffff94, 0xcccccd5199999919,
  0x5555556b55555540, 0x3333334d99999981,
  0xaaaaaac35555553e, 0x66666683ffffffe5,
  0x0000001aaaaaaa92, 0x999999b99999997d,
  0x555555715555553c, 0xccccccee66666649,
  0x3333333666666664, 0x00008002fffe8001,
  0x6666666bfffffffc, 0x00010004fffd8001,
  0x999999a0ccccccc8, 0x00018005fffd0001,
  0x999999a0ccccccc8, 0x00018005fffd0001,
  0x3333333599999998, 0x00008001ffff0001,
  0x6666666a66666664, 0x00010002fffe8001,
  0x6666666a66666664, 0x00010002fffe8001,
  0x6666666999999998, 0x00010001ffff0001,
  0x33333334cccccccc, 0x00008000ffff8001,
  0x33333334cccccccc, 0x00008000ffff8001,
  0x3333333400000000, 0x0000800000000001,
  0x3333333266666668, 0x00007ffe00010001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff33333334, 0xffffffff00008001,
  0xfffffffd9999999c, 0xfffffffd00018001,
  0xffffffe40000001c, 0xffffffdd00118001,
  0xffffffff33333334, 0xffffffff00008001,
  0xfffffffd9999999c, 0xfffffffd00018001,
  0xffffffe40000001c, 0xffffffdd00118001,
  0xffffff8000000080, 0xffffff6000500001,
  0xfffffffe66666668, 0xfffffffe00010001,
  0xffffffe4cccccce8, 0xffffffde00110001,
  0xffffff80cccccd4c, 0xffffff61004f8001,
  0xffffff1c000000e4, 0xfffffee3008e8001,
  0xffffffe666666680, 0xffffffe000100001,
  0xffffff82666666e4, 0xffffff63004e8001,
  0xffffff1d99999a7c, 0xfffffee5008d8001,
  0xfffffeb800000148, 0xfffffe6600cd0001,
  0xffffff9c00000064, 0xffffff83003e8001,
  0xffffff37333333fc, 0xffffff05007d8001,
  0xfffffed199999ac8, 0xfffffe8600bd0001,
  0xffff986d999a012c, 0xffff7e8940bb8001,
  0xffffff9b33333398, 0xffffff82003f0001,
  0xffffff3599999a64, 0xffffff03007e8001,
  0xffff98d1999a00c8, 0xffff7f06407d0001,
  0xffff326ccccd9a60, 0xfffeff08807c0001,
  0xffffff9a666666cc, 0xffffff81003f8001,
  0xffff99366666cd30, 0xffff7f84403e0001,
  0xffff32d1999a66c8, 0xfffeff86803d0001,
  0xfffecc6c00013394, 0xfffe7f87c03c8001,
  0xffff999c00006664, 0xffff80033ffe8001,
  0xffff33373333fffc, 0xffff00057ffd8001,
  0xfffeccd1999accc8, 0xfffe8006bffd0001,
  0xd7090a428f5d5c24, 0xcccb666d59968001,
  0xffff999b33339998, 0xffff80023fff0001,
  0xffff3335999a6664, 0xffff00037ffe8001,
  0xd70970a68f5cf5c0, 0xcccbe66a19980001,
  0x92c52c62d3a13a04, 0x7776bbbfc4428001,
  0xffff999a6666cccc, 0xffff80013fff8001,
  0xd709d70b5c295c28, 0xcccc6667d9990001,
  0x92c592c7a06da06c, 0x77773bbd84438001,
  0x2c5f2c6406d406d0, 0xf7777bc084420001,
  0xd70a3d70f5c28f5c, 0xcccce66699998001,
  0x92c5f92d3a06d3a0, 0x7777bbbc44440001,
  0x2c5f92c9a06d3a04, 0xf777fbbf44428001,
  0xc5f92c653a06d39c, 0x77783bc144418001,
  0xbbbbbbbc44444444, 0xaaaad555aaaa8001,
  0x55555558aaaaaaa8, 0x2aab1558aaa90001,
  0xeeeeeef444444440, 0xaaab555aaaa80001,
  0x8888888f1111110c, 0x2aab955baaa78001,
  0x9999999c66666664, 0x80004002fffe8001,
  0x33333337fffffffc, 0x00008004fffd8001,
  0xccccccd2ccccccc8, 0x8000c005fffd0001,
  0x6666666cccccccc8, 0x00010005fffd0001,
  0x9999999b99999998, 0x80004001ffff0001,
  0x3333333666666664, 0x00008002fffe8001,
  0xccccccd066666664, 0x8000c002fffe8001,
  0x6666666999999998, 0x00010001ffff0001,
  0x9999999acccccccc, 0x80004000ffff8001,
  0x33333334cccccccc, 0x00008000ffff8001,
  0xccccccce00000000, 0x8000c00000000001,
  0x4444444688888888, 0xd5566aab55550001,
  0x9999999a00000000, 0x8000400000000001,
  0x3333333333333334, 0x00007fff00008001,
  0xaaaaaaabbbbbbbbc, 0x55562aaa55558001,
  0x06d3a06f92c5f92c, 0x8889c444bbbb8001,
  0x9999999933333334, 0x80003fff00008001,
  0x11111111bbbbbbbc, 0xd555eaaa55558001,
  0x6d3a06d592c5f92c, 0x08898444bbbb8001,
  0xa06da06ff92bf92c, 0x088a84447bbb8001,
  0x7777777888888888, 0x5555aaab55550001,
  0xd3a06d3c5f92c5f8, 0x88894445bbbb0001,
  0x06d406d6c5f8c5f8, 0x888a44457bbb0001,
  0x3a07a0705f91f92c, 0x888b44443bbb8001,
  0x5c28f5c3d70a3d70, 0x3333999a66660001,
  0x8f5c8f5e3d703d70, 0x3334999a26660001,
  0xc29028f7d70970a4, 0x33359998e6668001,
  0xf5c3c290a3d5d70c, 0x33369996a6678001,
  0x3333999a66660000, 0x0000ffffc0000001,
  0x66673333ffff3334, 0x0001fffe80008001,
  0x999acccccccb999c, 0x0002fffc40018001,
  0xccce6664cccb3338, 0x0003fff900030001,
  0x3333999999993334, 0x0000fffec0008001,
  0x666733326665999c, 0x0001fffc80018001,
  0x999accca66653338, 0x0002fff940030001,
  0xccce0064cccb9938, 0x000380793fc30001,
  0x33339998cccc6668, 0x0000fffdc0010001,
  0x66673330cccc0004, 0x0001fffa80028001,
  0x999a66cb33326604, 0x0002807a7fc28001,
  0xcccd9a64cccbff38, 0x000300f97f830001,
  0x33339997ffff999c, 0x0000fffcc0018001,
  0x6666cd326665ff9c, 0x0001807cbfc18001,
  0x999a00cbffff98d0, 0x000200fbbf820001,
  0xcccd3464cccc6538, 0x00028179bf430001,
  0x3333339a66666600, 0x0000807fffc00001,
  0x66666733ffffff34, 0x000100feff808001,
  0x99999acccccccb9c, 0x0001817cff418001,
  0xccccce64cccccb38, 0x000201f9ff030001,
  0x3333339999999934, 0x0000807effc08001,
  0x666667326666659c, 0x000100fcff818001,
  0x99999aca66666538, 0x00018179ff430001,
  0xccccce17fffffeb8, 0x00020199ff330001,
  0x33333398cccccc68, 0x0000807dffc10001,
  0x66666730cccccc04, 0x000100faff828001,
  0x99999a7e66666584, 0x0001811aff728001,
  0xcccccdb4cccccbe8, 0x0002011dff710001,
  0x33333397ffffff9c, 0x0000807cffc18001,
  0x666666e59999991c, 0x0001009cffb18001,
  0x99999a1bffffff80, 0x0001809fffb00001,
  0xcccccd5199999918, 0x000200a1ffaf0001,
  0x3333334d99999980, 0x0000801ffff00001,
  0x66666683ffffffe4, 0x00010022ffee8001,
  0x999999b99999997c, 0x00018024ffed8001,
  0xccccccee66666648, 0x00020025ffed0001,
  0x00008002fffe8000, 0x00008001fffe8004,
  0x00010004fffd8000, 0x00010002fffd8006,
  0x00018005fffd0000, 0x00018002fffd0007,
  0x00018005fffd0000, 0x00018002fffd0007,
  0x00008001ffff0000, 0x00008000ffff0003,
  0x00010002fffe8000, 0x00010000fffe8004,
  0x00010002fffe8000, 0x00010000fffe8004,
  0x00010001ffff0000, 0x0000ffffffff0003,
  0x00008000ffff8000, 0x00007fffffff8002,
  0x00008000ffff8000, 0x00007fffffff8002,
  0x0000800000000000, 0x00007fff00000001,
  0x00007ffe00010000, 0x00007ffd0000ffff,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00008000, 0xffffffff00008000,
  0xfffffffd00018000, 0xfffffffd00017ffe,
  0xffffffdd00118000, 0xffffffdd00117fde,
  0xffffffff00008000, 0xffffffff00008000,
  0xfffffffd00018000, 0xfffffffd00017ffe,
  0xffffffdd00118000, 0xffffffdd00117fde,
  0xffffff6000500000, 0xffffff60004fff61,
  0xfffffffe00010000, 0xfffffffe0000ffff,
  0xffffffde00110000, 0xffffffde0010ffdf,
  0xffffff61004f8000, 0xffffff61004f7f62,
  0xfffffee3008e8000, 0xfffffee3008e7ee4,
  0xffffffe000100000, 0xffffffe0000fffe1,
  0xffffff63004e8000, 0xffffff63004e7f64,
  0xfffffee5008d8000, 0xfffffee5008d7ee6,
  0xfffffe6600cd0000, 0xfffffe6600ccfe67,
  0xffffff83003e8000, 0xffffff83003e7f84,
  0xffffff05007d8000, 0xffffff05007d7f06,
  0xfffffe8600bd0000, 0xfffffe8600bcfe87,
  0xffff7e8940bb8000, 0xffff7e8940bafe8a,
  0xffffff82003f0000, 0xffffff82003eff83,
  0xffffff03007e8000, 0xffffff03007e7f04,
  0xffff7f06407d0000, 0xffff7f06407c7f07,
  0xfffeff08807c0000, 0xfffeff08807aff09,
  0xffffff81003f8000, 0xffffff81003f7f82,
  0xffff7f84403e0000, 0xffff7f84403d7f85,
  0xfffeff86803d0000, 0xfffeff86803bff87,
  0xfffe7f87c03c8000, 0xfffe7f87c03aff88,
  0xffff80033ffe8000, 0xffff80033ffe0004,
  0xffff00057ffd8000, 0xffff00057ffc8006,
  0xfffe8006bffd0000, 0xfffe8006bffb8007,
  0xcccb666d59968000, 0xcccb666d2661ccd4,
  0xffff80023fff0000, 0xffff80023ffe8003,
  0xffff00037ffe8000, 0xffff00037ffd8004,
  0xcccbe66a19980000, 0xcccbe669e663ccd1,
  0x7776bbbfc4428000, 0x7776bbbf3bb8f77c,
  0xffff80013fff8000, 0xffff80013fff0002,
  0xcccc6667d9990000, 0xcccc6667a6654ccf,
  0x77773bbd84438000, 0x77773bbcfbba777a,
  0xf7777bc084420000, 0xf7777bbf7bb8f77d,
  0xcccce66699998000, 0xcccce66666664cce,
  0x7777bbbc44440000, 0x7777bbbbbbbb7779,
  0xf777fbbf44428000, 0xf777fbbe3bb9f77c,
  0x77783bc144418000, 0x77783bbfbbb8f77e,
  0xaaaad555aaaa8000, 0xaaaad55555552aac,
  0x2aab1558aaa90000, 0x2aab1557d553aaaf,
  0xaaab555aaaa80000, 0xaaab55595552aab1,
  0x2aab955baaa78000, 0x2aab9559d5522ab2,
  0x80004002fffe8000, 0x800040027ffe8004,
  0x00008004fffd8000, 0x00008003fffd8006,
  0x8000c005fffd0000, 0x8000c0047ffd0007,
  0x00010005fffd0000, 0x00010003fffd0007,
  0x80004001ffff0000, 0x800040017fff0003,
  0x00008002fffe8000, 0x00008001fffe8004,
  0x8000c002fffe8000, 0x8000c0017ffe8004,
  0x00010001ffff0000, 0x0000ffffffff0003,
  0x80004000ffff8000, 0x800040007fff8002,
  0x00008000ffff8000, 0x00007fffffff8002,
  0x8000c00000000000, 0x8000bffe80000001,
  0xd5566aab55550000, 0xd5566aa92aaa5557,
  0x8000400000000000, 0x80003fff80000001,
  0x00007fff00008000, 0x00007ffe00008000,
  0x55562aaa55558000, 0x55562aa8aaaad556,
  0x8889c444bbbb8000, 0x8889c4424444088a,
  0x80003fff00008000, 0x80003ffe80008000,
  0xd555eaaa55558000, 0xd555eaa92aaad556,
  0x08898444bbbb8000, 0x08898442c444088a,
  0x088a84447bbb8000, 0x088a84418444888a,
  0x5555aaab55550000, 0x5555aaaaaaaa5557,
  0x88894445bbbb0000, 0x888944444443888b,
  0x888a44457bbb0000, 0x888a44430444088b,
  0x888b44443bbb8000, 0x888b4440c445088a,
  0x3333999a66660000, 0x3333999999993335,
  0x3334999a26660000, 0x333499985999b335,
  0x33359998e6668000, 0x33359996199ab334,
  0x33369996a6678000, 0x33369992d99c3332,
  0x0000ffffc0000000, 0x0000fffec0008001,
  0x0001fffe80008000, 0x0001fffc80018000,
  0x0002fffc40018000, 0x0002fff94002fffe,
  0x0003fff900030000, 0x0003fff50004fffb,
  0x0000fffec0008000, 0x0000fffdc0010000,
  0x0001fffc80018000, 0x0001fffa80027ffe,
  0x0002fff940030000, 0x0002fff640047ffb,
  0x000380793fc30000, 0x000380753fc4807b,
  0x0000fffdc0010000, 0x0000fffcc0017fff,
  0x0001fffa80028000, 0x0001fff880037ffc,
  0x0002807a7fc28000, 0x000280777fc3807c,
  0x000300f97f830000, 0x000300f57f8400fb,
  0x0000fffcc0018000, 0x0000fffbc001fffe,
  0x0001807cbfc18000, 0x0001807abfc2007e,
  0x000200fbbf820000, 0x000200f8bf8280fd,
  0x00028179bf430000, 0x00028175bf43817b,
  0x0000807fffc00000, 0x0000807effc00081,
  0x000100feff808000, 0x000100fcff808100,
  0x0001817cff418000, 0x00018179ff41817e,
  0x000201f9ff030000, 0x000201f5ff0301fb,
  0x0000807effc08000, 0x0000807dffc08080,
  0x000100fcff818000, 0x000100faff8180fe,
  0x00018179ff430000, 0x00018176ff43017b,
  0x00020199ff330000, 0x00020195ff33019b,
  0x0000807dffc10000, 0x0000807cffc1007f,
  0x000100faff828000, 0x000100f8ff8280fc,
  0x0001811aff728000, 0x00018117ff72811c,
  0x0002011dff710000, 0x00020119ff71011f,
  0x0000807cffc18000, 0x0000807bffc1807e,
  0x0001009cffb18000, 0x0001009affb1809e,
  0x0001809fffb00000, 0x0001809cffb000a1,
  0x000200a1ffaf0000, 0x0002009dffaf00a3,
  0x0000801ffff00000, 0x0000801efff00021,
  0x00010022ffee8000, 0x00010020ffee8024,
  0x00018024ffed8000, 0x00018021ffed8026,
  0x00020025ffed0000, 0x00020021ffed0027,
  0x00008001fffe8003, 0x00008000fffe8007,
  0x00010002fffd8005, 0x00010000fffd800b,
  0x00018002fffd0006, 0x00017ffffffd000d,
  0x00018002fffd0006, 0x00017ffffffd000d,
  0x00008000ffff0002, 0x00007fffffff0005,
  0x00010000fffe8003, 0x0000fffefffe8007,
  0x00010000fffe8003, 0x0000fffefffe8007,
  0x0000ffffffff0002, 0x0000fffdffff0005,
  0x00007fffffff8001, 0x00007ffeffff8003,
  0x00007fffffff8001, 0x00007ffeffff8003,
  0x00007fff00000000, 0x00007ffe00000001,
  0x00007ffd0000fffe, 0x00007ffc0000fffd,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00007fff, 0xffffffff00007fff,
  0xfffffffd00017ffd, 0xfffffffd00017ffb,
  0xffffffdd00117fdd, 0xffffffdd00117fbb,
  0xffffffff00007fff, 0xffffffff00007fff,
  0xfffffffd00017ffd, 0xfffffffd00017ffb,
  0xffffffdd00117fdd, 0xffffffdd00117fbb,
  0xffffff60004fff60, 0xffffff60004ffec1,
  0xfffffffe0000fffe, 0xfffffffe0000fffd,
  0xffffffde0010ffde, 0xffffffde0010ffbd,
  0xffffff61004f7f61, 0xffffff61004f7ec3,
  0xfffffee3008e7ee3, 0xfffffee3008e7dc7,
  0xffffffe0000fffe0, 0xffffffe0000fffc1,
  0xffffff63004e7f63, 0xffffff63004e7ec7,
  0xfffffee5008d7ee5, 0xfffffee5008d7dcb,
  0xfffffe6600ccfe66, 0xfffffe6600ccfccd,
  0xffffff83003e7f83, 0xffffff83003e7f07,
  0xffffff05007d7f05, 0xffffff05007d7e0b,
  0xfffffe8600bcfe86, 0xfffffe8600bcfd0d,
  0xffff7e8940bafe89, 0xffff7e8940ba7d13,
  0xffffff82003eff82, 0xffffff82003eff05,
  0xffffff03007e7f03, 0xffffff03007e7e07,
  0xffff7f06407c7f06, 0xffff7f06407bfe0d,
  0xfffeff08807aff08, 0xfffeff088079fe11,
  0xffffff81003f7f81, 0xffffff81003f7f03,
  0xffff7f84403d7f84, 0xffff7f84403cff09,
  0xfffeff86803bff86, 0xfffeff86803aff0d,
  0xfffe7f87c03aff87, 0xfffe7f87c0397f0f,
  0xffff80033ffe0003, 0xffff80033ffd8007,
  0xffff00057ffc8005, 0xffff00057ffb800b,
  0xfffe8006bffb8006, 0xfffe8006bffa000d,
  0xcccb666d2661ccd3, 0xcccb666cf32d19a7,
  0xffff80023ffe8002, 0xffff80023ffe0005,
  0xffff00037ffd8003, 0xffff00037ffc8007,
  0xcccbe669e663ccd0, 0xcccbe669b32f99a1,
  0x7776bbbf3bb8f77b, 0x7776bbbeb32f6ef7,
  0xffff80013fff0001, 0xffff80013ffe8003,
  0xcccc6667a6654cce, 0xcccc66677331999d,
  0x77773bbcfbba7779, 0x77773bbc73316ef3,
  0xf7777bbf7bb8f77c, 0xf7777bbe732feef9,
  0xcccce66666664ccd, 0xcccce6663333199b,
  0x7777bbbbbbbb7778, 0x7777bbbb3332eef1,
  0xf777fbbe3bb9f77b, 0xf777fbbd33316ef7,
  0x77783bbfbbb8f77d, 0x77783bbe33306efb,
  0xaaaad55555552aab, 0xaaaad554ffffd557,
  0x2aab1557d553aaae, 0x2aab1556fffe555d,
  0xaaab55595552aab0, 0xaaab5557fffd5561,
  0x2aab9559d5522ab1, 0x2aab9557fffcd563,
  0x800040027ffe8003, 0x80004001fffe8007,
  0x00008003fffd8005, 0x00008002fffd800b,
  0x8000c0047ffd0006, 0x8000c002fffd000d,
  0x00010003fffd0006, 0x00010001fffd000d,
  0x800040017fff0002, 0x80004000ffff0005,
  0x00008001fffe8003, 0x00008000fffe8007,
  0x8000c0017ffe8003, 0x8000bffffffe8007,
  0x0000ffffffff0002, 0x0000fffdffff0005,
  0x800040007fff8001, 0x80003fffffff8003,
  0x00007fffffff8001, 0x00007ffeffff8003,
  0x8000bffe80000000, 0x8000bffd00000001,
  0xd5566aa92aaa5556, 0xd5566aa6ffffaaad,
  0x80003fff80000000, 0x80003fff00000001,
  0x00007ffe00007fff, 0x00007ffd00007fff,
  0x55562aa8aaaad555, 0x55562aa700002aab,
  0x8889c44244440889, 0x8889c43fcccc9113,
  0x80003ffe80007fff, 0x80003ffe00007fff,
  0xd555eaa92aaad555, 0xd555eaa800002aab,
  0x08898442c4440889, 0x08898440cccc9113,
  0x088a844184448889, 0x088a843e8ccd9113,
  0x5555aaaaaaaa5556, 0x5555aaa9ffffaaad,
  0x888944444443888a, 0x88894442cccc1115,
  0x888a44430444088a, 0x888a44408ccd1115,
  0x888b4440c4450889, 0x888b443d4cce9113,
  0x3333999999993334, 0x33339998cccc6669,
  0x333499985999b334, 0x333499968ccd6669,
  0x33359996199ab333, 0x333599934ccee667,
  0x33369992d99c3331, 0x3336998f0cd0e663,
  0x0000fffec0008000, 0x0000fffdc0010001,
  0x0001fffc80017fff, 0x0001fffa80027fff,
  0x0002fff94002fffd, 0x0002fff640047ffb,
  0x0003fff50004fffa, 0x0003fff10006fff5,
  0x0000fffdc000ffff, 0x0000fffcc0017fff,
  0x0001fffa80027ffd, 0x0001fff880037ffb,
  0x0002fff640047ffa, 0x0002fff34005fff5,
  0x000380753fc4807a, 0x000380713fc600f5,
  0x0000fffcc0017ffe, 0x0000fffbc001fffd,
  0x0001fff880037ffb, 0x0001fff680047ff7,
  0x000280777fc3807b, 0x000280747fc480f7,
  0x000300f57f8400fa, 0x000300f17f8501f5,
  0x0000fffbc001fffd, 0x0000fffac0027ffb,
  0x0001807abfc2007d, 0x00018078bfc280fb,
  0x000200f8bf8280fc, 0x000200f5bf8301f9,
  0x00028175bf43817a, 0x00028171bf4402f5,
  0x0000807effc00080, 0x0000807dffc00101,
  0x000100fcff8080ff, 0x000100faff8081ff,
  0x00018179ff41817d, 0x00018176ff4182fb,
  0x000201f5ff0301fa, 0x000201f1ff0303f5,
  0x0000807dffc0807f, 0x0000807cffc080ff,
  0x000100faff8180fd, 0x000100f8ff8181fb,
  0x00018176ff43017a, 0x00018173ff4302f5,
  0x00020195ff33019a, 0x00020191ff330335,
  0x0000807cffc1007e, 0x0000807bffc100fd,
  0x000100f8ff8280fb, 0x000100f6ff8281f7,
  0x00018117ff72811b, 0x00018114ff728237,
  0x00020119ff71011e, 0x00020115ff71023d,
  0x0000807bffc1807d, 0x0000807affc180fb,
  0x0001009affb1809d, 0x00010098ffb1813b,
  0x0001809cffb000a0, 0x00018099ffb00141,
  0x0002009dffaf00a2, 0x00020099ffaf0145,
  0x0000801efff00020, 0x0000801dfff00041,
  0x00010020ffee8023, 0x0001001effee8047,
  0x00018021ffed8025, 0x0001801effed804b,
  0x00020021ffed0026, 0x0002001dffed004d,
  0x00008000fffe8006, 0x00007ffffffe800a,
  0x00010000fffd800a, 0x0000fffefffd8010,
  0x00017ffffffd000c, 0x00017ffcfffd0013,
  0x00017ffffffd000c, 0x00017ffcfffd0013,
  0x00007fffffff0004, 0x00007ffeffff0007,
  0x0000fffefffe8006, 0x0000fffcfffe800a,
  0x0000fffefffe8006, 0x0000fffcfffe800a,
  0x0000fffdffff0004, 0x0000fffbffff0007,
  0x00007ffeffff8002, 0x00007ffdffff8004,
  0x00007ffeffff8002, 0x00007ffdffff8004,
  0x00007ffe00000000, 0x00007ffd00000001,
  0x00007ffc0000fffc, 0x00007ffb0000fffb,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00007ffe, 0xffffffff00007ffe,
  0xfffffffd00017ffa, 0xfffffffd00017ff8,
  0xffffffdd00117fba, 0xffffffdd00117f98,
  0xffffffff00007ffe, 0xffffffff00007ffe,
  0xfffffffd00017ffa, 0xfffffffd00017ff8,
  0xffffffdd00117fba, 0xffffffdd00117f98,
  0xffffff60004ffec0, 0xffffff60004ffe21,
  0xfffffffe0000fffc, 0xfffffffe0000fffb,
  0xffffffde0010ffbc, 0xffffffde0010ff9b,
  0xffffff61004f7ec2, 0xffffff61004f7e24,
  0xfffffee3008e7dc6, 0xfffffee3008e7caa,
  0xffffffe0000fffc0, 0xffffffe0000fffa1,
  0xffffff63004e7ec6, 0xffffff63004e7e2a,
  0xfffffee5008d7dca, 0xfffffee5008d7cb0,
  0xfffffe6600ccfccc, 0xfffffe6600ccfb33,
  0xffffff83003e7f06, 0xffffff83003e7e8a,
  0xffffff05007d7e0a, 0xffffff05007d7d10,
  0xfffffe8600bcfd0c, 0xfffffe8600bcfb93,
  0xffff7e8940ba7d12, 0xffff7e8940b9fb9c,
  0xffffff82003eff04, 0xffffff82003efe87,
  0xffffff03007e7e06, 0xffffff03007e7d0a,
  0xffff7f06407bfe0c, 0xffff7f06407b7d13,
  0xfffeff088079fe10, 0xfffeff088078fd19,
  0xffffff81003f7f02, 0xffffff81003f7e84,
  0xffff7f84403cff08, 0xffff7f84403c7e8d,
  0xfffeff86803aff0c, 0xfffeff868039fe93,
  0xfffe7f87c0397f0e, 0xfffe7f87c037fe96,
  0xffff80033ffd8006, 0xffff80033ffd000a,
  0xffff00057ffb800a, 0xffff00057ffa8010,
  0xfffe8006bffa000c, 0xfffe8006bff88013,
  0xcccb666cf32d19a6, 0xcccb666cbff8667a,
  0xffff80023ffe0004, 0xffff80023ffd8007,
  0xffff00037ffc8006, 0xffff00037ffb800a,
  0xcccbe669b32f99a0, 0xcccbe6697ffb6671,
  0x7776bbbeb32f6ef6, 0x7776bbbe2aa5e672,
  0xffff80013ffe8002, 0xffff80013ffe0004,
  0xcccc66677331999c, 0xcccc66673ffde66b,
  0x77773bbc73316ef2, 0x77773bbbeaa8666c,
  0xf7777bbe732feef8, 0xf7777bbd6aa6e675,
  0xcccce6663333199a, 0xcccce665ffffe668,
  0x7777bbbb3332eef0, 0x7777bbbaaaaa6669,
  0xf777fbbd33316ef6, 0xf777fbbc2aa8e672,
  0x77783bbe33306efa, 0x77783bbcaaa7e678,
  0xaaaad554ffffd556, 0xaaaad554aaaa8002,
  0x2aab1556fffe555c, 0x2aab15562aa9000b,
  0xaaab5557fffd5560, 0xaaab5556aaa80011,
  0x2aab9557fffcd562, 0x2aab95562aa78014,
  0x80004001fffe8006, 0x800040017ffe800a,
  0x00008002fffd800a, 0x00008001fffd8010,
  0x8000c002fffd000c, 0x8000c0017ffd0013,
  0x00010001fffd000c, 0x0000fffffffd0013,
  0x80004000ffff0004, 0x800040007fff0007,
  0x00008000fffe8006, 0x00007ffffffe800a,
  0x8000bffffffe8006, 0x8000bffe7ffe800a,
  0x0000fffdffff0004, 0x0000fffbffff0007,
  0x80003fffffff8002, 0x80003fff7fff8004,
  0x00007ffeffff8002, 0x00007ffdffff8004,
  0x8000bffd00000000, 0x8000bffb80000001,
  0xd5566aa6ffffaaac, 0xd5566aa4d5550003,
  0x80003fff00000000, 0x80003ffe80000001,
  0x00007ffd00007ffe, 0x00007ffc00007ffe,
  0x55562aa700002aaa, 0x55562aa555558000,
  0x8889c43fcccc9112, 0x8889c43d5555199c,
  0x80003ffe00007ffe, 0x80003ffd80007ffe,
  0xd555eaa800002aaa, 0xd555eaa6d5558000,
  0x08898440cccc9112, 0x0889843ed555199c,
  0x088a843e8ccd9112, 0x088a843b9556999c,
  0x5555aaa9ffffaaac, 0x5555aaa955550003,
  0x88894442cccc1114, 0x888944415554999f,
  0x888a44408ccd1114, 0x888a443e1556199f,
  0x888b443d4cce9112, 0x888b4439d558199c,
  0x33339998cccc6668, 0x33339997ffff999d,
  0x333499968ccd6668, 0x33349994c001199d,
  0x333599934ccee666, 0x333599908003199a,
  0x3336998f0cd0e662, 0x3336998b40059994,
  0x0000fffdc0010000, 0x0000fffcc0018001,
  0x0001fffa80027ffe, 0x0001fff880037ffe,
  0x0002fff640047ffa, 0x0002fff34005fff8,
  0x0003fff10006fff4, 0x0003ffed0008ffef,
  0x0000fffcc0017ffe, 0x0000fffbc001fffe,
  0x0001fff880037ffa, 0x0001fff680047ff8,
  0x0002fff34005fff4, 0x0002fff040077fef,
  0x000380713fc600f4, 0x0003806d3fc7816f,
  0x0000fffbc001fffc, 0x0000fffac0027ffb,
  0x0001fff680047ff6, 0x0001fff480057ff2,
  0x000280747fc480f6, 0x000280717fc58172,
  0x000300f17f8501f4, 0x000300ed7f8602ef,
  0x0000fffac0027ffa, 0x0000fff9c002fff8,
  0x00018078bfc280fa, 0x00018076bfc30178,
  0x000200f5bf8301f8, 0x000200f2bf8382f5,
  0x00028171bf4402f4, 0x0002816dbf44846f,
  0x0000807dffc00100, 0x0000807cffc00181,
  0x000100faff8081fe, 0x000100f8ff8082fe,
  0x00018176ff4182fa, 0x00018173ff418478,
  0x000201f1ff0303f4, 0x000201edff0305ef,
  0x0000807cffc080fe, 0x0000807bffc0817e,
  0x000100f8ff8181fa, 0x000100f6ff8182f8,
  0x00018173ff4302f4, 0x00018170ff43046f,
  0x00020191ff330334, 0x0002018dff3304cf,
  0x0000807bffc100fc, 0x0000807affc1017b,
  0x000100f6ff8281f6, 0x000100f4ff8282f2,
  0x00018114ff728236, 0x00018111ff728352,
  0x00020115ff71023c, 0x00020111ff71035b,
  0x0000807affc180fa, 0x00008079ffc18178,
  0x00010098ffb1813a, 0x00010096ffb181d8,
  0x00018099ffb00140, 0x00018096ffb001e1,
  0x00020099ffaf0144, 0x00020095ffaf01e7,
  0x0000801dfff00040, 0x0000801cfff00061,
  0x0001001effee8046, 0x0001001cffee806a,
  0x0001801effed804a, 0x0001801bffed8070,
  0x0002001dffed004c, 0x00020019ffed0073,
  0x00007ffffffe8009, 0x00000082fffffe81,
  0x0000fffefffd800f, 0x00000104fffffd81,
  0x00017ffcfffd0012, 0x00000185fffffd01,
  0x00017ffcfffd0012, 0x00000185fffffd01,
  0x00007ffeffff0006, 0x00000081ffffff01,
  0x0000fffcfffe8009, 0x00000102fffffe81,
  0x0000fffcfffe8009, 0x00000102fffffe81,
  0x0000fffbffff0006, 0x00000101ffffff01,
  0x00007ffdffff8003, 0x00000080ffffff81,
  0x00007ffdffff8003, 0x00000080ffffff81,
  0x00007ffd00000000, 0x0000008000000001,
  0x00007ffb0000fffa, 0x0000007e00000101,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00007ffd, 0xffffffff00000081,
  0xfffffffd00017ff7, 0xfffffffd00000181,
  0xffffffdd00117f97, 0xffffffdd00001181,
  0xffffffff00007ffd, 0xffffffff00000081,
  0xfffffffd00017ff7, 0xfffffffd00000181,
  0xffffffdd00117f97, 0xffffffdd00001181,
  0xffffff60004ffe20, 0xffffff6000005001,
  0xfffffffe0000fffa, 0xfffffffe00000101,
  0xffffffde0010ff9a, 0xffffffde00001101,
  0xffffff61004f7e23, 0xffffff6100004f81,
  0xfffffee3008e7ca9, 0xfffffee300008e81,
  0xffffffe0000fffa0, 0xffffffe000001001,
  0xffffff63004e7e29, 0xffffff6300004e81,
  0xfffffee5008d7caf, 0xfffffee500008d81,
  0xfffffe6600ccfb32, 0xfffffe660000cd01,
  0xffffff83003e7e89, 0xffffff8300003e81,
  0xffffff05007d7d0f, 0xffffff0500007d81,
  0xfffffe8600bcfb92, 0xfffffe860000bd01,
  0xffff7e8940b9fb9b, 0xffff7e890040bb81,
  0xffffff82003efe86, 0xffffff8200003f01,
  0xffffff03007e7d09, 0xffffff0300007e81,
  0xffff7f06407b7d12, 0xffff7f0600407d01,
  0xfffeff088078fd18, 0xfffeff0800807c01,
  0xffffff81003f7e83, 0xffffff8100003f81,
  0xffff7f84403c7e8c, 0xffff7f8400403e01,
  0xfffeff868039fe92, 0xfffeff8600803d01,
  0xfffe7f87c037fe95, 0xfffe7f8700c03c81,
  0xffff80033ffd0009, 0xffff8003003ffe81,
  0xffff00057ffa800f, 0xffff0005007ffd81,
  0xfffe8006bff88012, 0xfffe800600bffd01,
  0xcccb666cbff86679, 0xcccb4cec9a599681,
  0xffff80023ffd8006, 0xffff8002003fff01,
  0xffff00037ffb8009, 0xffff0003007ffe81,
  0xcccbe6697ffb6670, 0xcccbcce99a199801,
  0x7776bbbe2aa5e671, 0x777677bf44c44281,
  0xffff80013ffe0003, 0xffff8001003fff81,
  0xcccc66673ffde66a, 0xcccc4ce799d99901,
  0x77773bbbeaa8666b, 0x7776f7bd44844381,
  0xf7777bbd6aa6e674, 0xf776f80044844201,
  0xcccce665ffffe667, 0xcccccce699999981,
  0x7777bbbaaaaa6668, 0x777777bc44444401,
  0xf777fbbc2aa8e671, 0xf77777ff44444281,
  0x77783bbcaaa7e677, 0x7777784144444181,
  0xaaaad554aaaa8001, 0xaaaaaad5aaaaaa81,
  0x2aab15562aa9000a, 0x2aaaab18aaaaa901,
  0xaaab5556aaa80010, 0xaaaaab5aaaaaa801,
  0x2aab95562aa78013, 0x2aaaab9baaaaa781,
  0x800040017ffe8009, 0x80000042fffffe81,
  0x00008001fffd800f, 0x00000084fffffd81,
  0x8000c0017ffd0012, 0x800000c5fffffd01,
  0x0000fffffffd0012, 0x00000105fffffd01,
  0x800040007fff0006, 0x80000041ffffff01,
  0x00007ffffffe8009, 0x00000082fffffe81,
  0x8000bffe7ffe8009, 0x800000c2fffffe81,
  0x0000fffbffff0006, 0x00000101ffffff01,
  0x80003fff7fff8003, 0x80000040ffffff81,
  0x00007ffdffff8003, 0x00000080ffffff81,
  0x8000bffb80000000, 0x800000c000000001,
  0xd5566aa4d5550002, 0xd555566b55555501,
  0x80003ffe80000000, 0x8000004000000001,
  0x00007ffc00007ffd, 0x0000007f00000081,
  0x55562aa555557fff, 0x5555562a55555581,
  0x8889c43d5555199b, 0x888889c4bbbbbb81,
  0x80003ffd80007ffd, 0x8000003f00000081,
  0xd555eaa6d5557fff, 0xd55555ea55555581,
  0x0889843ed555199b, 0x08888984bbbbbb81,
  0x088a843b9556999b, 0x08890a04bb7bbb81,
  0x5555aaa955550002, 0x555555ab55555501,
  0x888944415554999e, 0x88888945bbbbbb01,
  0x888a443e1556199e, 0x888909c5bb7bbb01,
  0x888b4439d558199b, 0x88898a44bb3bbb81,
  0x33339997ffff999c, 0x3333339a66666601,
  0x33349994c001199c, 0x3333b41a66266601,
  0x3335999080031999, 0x3334349965e66681,
  0x3336998b40059993, 0x3334b51765a66781,
  0x0000fffcc0018000, 0x0000807fffc00001,
  0x0001fff880037ffd, 0x000100feff800081,
  0x0002fff34005fff7, 0x0001817cff400181,
  0x0003ffed0008ffee, 0x000201f9ff000301,
  0x0000fffbc001fffd, 0x0000807effc00081,
  0x0001fff680047ff7, 0x000100fcff800181,
  0x0002fff040077fee, 0x00018179ff400301,
  0x0003806d3fc7816e, 0x00018279ff3fc301,
  0x0000fffac0027ffa, 0x0000807dffc00101,
  0x0001fff480057ff1, 0x000100faff800281,
  0x000280717fc58171, 0x000101faff7fc281,
  0x000300ed7f8602ee, 0x000102f9ff7f8301,
  0x0000fff9c002fff7, 0x0000807cffc00181,
  0x00018076bfc30177, 0x0000817cffbfc181,
  0x000200f2bf8382f4, 0x0000827bffbf8201,
  0x0002816dbf44846e, 0x00008379ffbf4301,
  0x0000807cffc00180, 0x000000ffffffc001,
  0x000100f8ff8082fd, 0x000001feffff8081,
  0x00018173ff418477, 0x000002fcffff4181,
  0x000201edff0305ee, 0x000003f9ffff0301,
  0x0000807bffc0817d, 0x000000feffffc081,
  0x000100f6ff8182f7, 0x000001fcffff8181,
  0x00018170ff43046e, 0x000002f9ffff4301,
  0x0002018dff3304ce, 0x00000399ffff3301,
  0x0000807affc1017a, 0x000000fdffffc101,
  0x000100f4ff8282f1, 0x000001faffff8281,
  0x00018111ff728351, 0x0000029affff7281,
  0x00020111ff71035a, 0x0000031dffff7101,
  0x00008079ffc18177, 0x000000fcffffc181,
  0x00010096ffb181d7, 0x0000019cffffb181,
  0x00018096ffb001e0, 0x0000021fffffb001,
  0x00020095ffaf01e6, 0x000002a1ffffaf01,
  0x0000801cfff00060, 0x0000009ffffff001,
  0x0001001cffee8069, 0x00000122ffffee81,
  0x0001801bffed806f, 0x000001a4ffffed81,
  0x00020019ffed0072, 0x00000225ffffed01,
  0x00000082fffffe80, 0x00000081fffffe84,
  0x00000104fffffd80, 0x00000102fffffd86,
  0x00000185fffffd00, 0x00000182fffffd07,
  0x00000185fffffd00, 0x00000182fffffd07,
  0x00000081ffffff00, 0x00000080ffffff03,
  0x00000102fffffe80, 0x00000100fffffe84,
  0x00000102fffffe80, 0x00000100fffffe84,
  0x00000101ffffff00, 0x000000ffffffff03,
  0x00000080ffffff80, 0x0000007fffffff82,
  0x00000080ffffff80, 0x0000007fffffff82,
  0x0000008000000000, 0x0000007f00000001,
  0x0000007e00000100, 0x0000007d000000ff,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000080, 0xffffffff00000080,
  0xfffffffd00000180, 0xfffffffd0000017e,
  0xffffffdd00001180, 0xffffffdd0000115e,
  0xffffffff00000080, 0xffffffff00000080,
  0xfffffffd00000180, 0xfffffffd0000017e,
  0xffffffdd00001180, 0xffffffdd0000115e,
  0xffffff6000005000, 0xffffff6000004f61,
  0xfffffffe00000100, 0xfffffffe000000ff,
  0xffffffde00001100, 0xffffffde000010df,
  0xffffff6100004f80, 0xffffff6100004ee2,
  0xfffffee300008e80, 0xfffffee300008d64,
  0xffffffe000001000, 0xffffffe000000fe1,
  0xffffff6300004e80, 0xffffff6300004de4,
  0xfffffee500008d80, 0xfffffee500008c66,
  0xfffffe660000cd00, 0xfffffe660000cb67,
  0xffffff8300003e80, 0xffffff8300003e04,
  0xffffff0500007d80, 0xffffff0500007c86,
  0xfffffe860000bd00, 0xfffffe860000bb87,
  0xffff7e890040bb80, 0xffff7e8900403a0a,
  0xffffff8200003f00, 0xffffff8200003e83,
  0xffffff0300007e80, 0xffffff0300007d84,
  0xffff7f0600407d00, 0xffff7f06003ffc07,
  0xfffeff0800807c00, 0xfffeff08007f7b09,
  0xffffff8100003f80, 0xffffff8100003f02,
  0xffff7f8400403e00, 0xffff7f84003fbd85,
  0xfffeff8600803d00, 0xfffeff86007f3c87,
  0xfffe7f8700c03c80, 0xfffe7f8700bebc08,
  0xffff8003003ffe80, 0xffff8003003f7e84,
  0xffff0005007ffd80, 0xffff0005007efd86,
  0xfffe800600bffd00, 0xfffe800600be7d07,
  0xcccb4cec9a599680, 0xcccb4cec6724e354,
  0xffff8002003fff00, 0xffff8002003f7f03,
  0xffff0003007ffe80, 0xffff0003007efe84,
  0xcccbcce99a199800, 0xcccbcce966e564d1,
  0x777677bf44c44280, 0x777677bebc3ab9fc,
  0xffff8001003fff80, 0xffff8001003f7f82,
  0xcccc4ce799d99900, 0xcccc4ce766a5e5cf,
  0x7776f7bd44844380, 0x7776f7bcbbfb3afa,
  0xf776f80044844200, 0xf776f7ff3bfb397d,
  0xcccccce699999980, 0xcccccce66666664e,
  0x777777bc44444400, 0x777777bbbbbbbb79,
  0xf77777ff44444280, 0xf77777fe3bbbb9fc,
  0x7777784144444180, 0x7777783fbbbbb8fe,
  0xaaaaaad5aaaaaa80, 0xaaaaaad55555552c,
  0x2aaaab18aaaaa900, 0x2aaaab17d55553af,
  0xaaaaab5aaaaaa800, 0xaaaaab59555552b1,
  0x2aaaab9baaaaa780, 0x2aaaab99d5555232,
  0x80000042fffffe80, 0x800000427ffffe84,
  0x00000084fffffd80, 0x00000083fffffd86,
  0x800000c5fffffd00, 0x800000c47ffffd07,
  0x00000105fffffd00, 0x00000103fffffd07,
  0x80000041ffffff00, 0x800000417fffff03,
  0x00000082fffffe80, 0x00000081fffffe84,
  0x800000c2fffffe80, 0x800000c17ffffe84,
  0x00000101ffffff00, 0x000000ffffffff03,
  0x80000040ffffff80, 0x800000407fffff82,
  0x00000080ffffff80, 0x0000007fffffff82,
  0x800000c000000000, 0x800000be80000001,
  0xd555566b55555500, 0xd55556692aaaaa57,
  0x8000004000000000, 0x8000003f80000001,
  0x0000007f00000080, 0x0000007e00000080,
  0x5555562a55555580, 0x55555628aaaaaad6,
  0x888889c4bbbbbb80, 0x888889c24444440a,
  0x8000003f00000080, 0x8000003e80000080,
  0xd55555ea55555580, 0xd55555e92aaaaad6,
  0x08888984bbbbbb80, 0x08888982c444440a,
  0x08890a04bb7bbb80, 0x08890a01c404c40a,
  0x555555ab55555500, 0x555555aaaaaaaa57,
  0x88888945bbbbbb00, 0x888889444444438b,
  0x888909c5bb7bbb00, 0x888909c34404c38b,
  0x88898a44bb3bbb80, 0x88898a4143c5440a,
  0x3333339a66666600, 0x3333339999999935,
  0x3333b41a66266600, 0x3333b418995a1935,
  0x3334349965e66680, 0x33343496991a99b4,
  0x3334b51765a66780, 0x3334b51398db1ab2,
  0x0000807fffc00000, 0x0000807effc08001,
  0x000100feff800080, 0x000100fcff810080,
  0x0001817cff400180, 0x00018179ff41817e,
  0x000201f9ff000300, 0x000201f5ff0202fb,
  0x0000807effc00080, 0x0000807dffc08080,
  0x000100fcff800180, 0x000100faff81017e,
  0x00018179ff400300, 0x00018176ff4182fb,
  0x00018279ff3fc300, 0x00018275ff41437b,
  0x0000807dffc00100, 0x0000807cffc080ff,
  0x000100faff800280, 0x000100f8ff81027c,
  0x000101faff7fc280, 0x000101f7ff80c2fc,
  0x000102f9ff7f8300, 0x000102f5ff8083fb,
  0x0000807cffc00180, 0x0000807bffc0817e,
  0x0000817cffbfc180, 0x0000817affc041fe,
  0x0000827bffbf8200, 0x00008278ffc002fd,
  0x00008379ffbf4300, 0x00008375ffbfc47b,
  0x000000ffffffc000, 0x000000feffffc081,
  0x000001feffff8080, 0x000001fcffff8180,
  0x000002fcffff4180, 0x000002f9ffff42fe,
  0x000003f9ffff0300, 0x000003f5ffff04fb,
  0x000000feffffc080, 0x000000fdffffc100,
  0x000001fcffff8180, 0x000001faffff827e,
  0x000002f9ffff4300, 0x000002f6ffff447b,
  0x00000399ffff3300, 0x00000395ffff349b,
  0x000000fdffffc100, 0x000000fcffffc17f,
  0x000001faffff8280, 0x000001f8ffff837c,
  0x0000029affff7280, 0x00000297ffff739c,
  0x0000031dffff7100, 0x00000319ffff721f,
  0x000000fcffffc180, 0x000000fbffffc1fe,
  0x0000019cffffb180, 0x0000019affffb21e,
  0x0000021fffffb000, 0x0000021cffffb0a1,
  0x000002a1ffffaf00, 0x0000029dffffafa3,
  0x0000009ffffff000, 0x0000009efffff021,
  0x00000122ffffee80, 0x00000120ffffeea4,
  0x000001a4ffffed80, 0x000001a1ffffeda6,
  0x00000225ffffed00, 0x00000221ffffed27,
  0x00000081fffffe83, 0x00000080fffffe87,
  0x00000102fffffd85, 0x00000100fffffd8b,
  0x00000182fffffd06, 0x0000017ffffffd0d,
  0x00000182fffffd06, 0x0000017ffffffd0d,
  0x00000080ffffff02, 0x0000007fffffff05,
  0x00000100fffffe83, 0x000000fefffffe87,
  0x00000100fffffe83, 0x000000fefffffe87,
  0x000000ffffffff02, 0x000000fdffffff05,
  0x0000007fffffff81, 0x0000007effffff83,
  0x0000007fffffff81, 0x0000007effffff83,
  0x0000007f00000000, 0x0000007e00000001,
  0x0000007d000000fe, 0x0000007c000000fd,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff0000007f, 0xffffffff0000007f,
  0xfffffffd0000017d, 0xfffffffd0000017b,
  0xffffffdd0000115d, 0xffffffdd0000113b,
  0xffffffff0000007f, 0xffffffff0000007f,
  0xfffffffd0000017d, 0xfffffffd0000017b,
  0xffffffdd0000115d, 0xffffffdd0000113b,
  0xffffff6000004f60, 0xffffff6000004ec1,
  0xfffffffe000000fe, 0xfffffffe000000fd,
  0xffffffde000010de, 0xffffffde000010bd,
  0xffffff6100004ee1, 0xffffff6100004e43,
  0xfffffee300008d63, 0xfffffee300008c47,
  0xffffffe000000fe0, 0xffffffe000000fc1,
  0xffffff6300004de3, 0xffffff6300004d47,
  0xfffffee500008c65, 0xfffffee500008b4b,
  0xfffffe660000cb66, 0xfffffe660000c9cd,
  0xffffff8300003e03, 0xffffff8300003d87,
  0xffffff0500007c85, 0xffffff0500007b8b,
  0xfffffe860000bb86, 0xfffffe860000ba0d,
  0xffff7e8900403a09, 0xffff7e89003fb893,
  0xffffff8200003e82, 0xffffff8200003e05,
  0xffffff0300007d83, 0xffffff0300007c87,
  0xffff7f06003ffc06, 0xffff7f06003f7b0d,
  0xfffeff08007f7b08, 0xfffeff08007e7a11,
  0xffffff8100003f01, 0xffffff8100003e83,
  0xffff7f84003fbd84, 0xffff7f84003f3d09,
  0xfffeff86007f3c86, 0xfffeff86007e3c0d,
  0xfffe7f8700bebc07, 0xfffe7f8700bd3b8f,
  0xffff8003003f7e83, 0xffff8003003efe87,
  0xffff0005007efd85, 0xffff0005007dfd8b,
  0xfffe800600be7d06, 0xfffe800600bcfd0d,
  0xcccb4cec6724e353, 0xcccb4cec33f03027,
  0xffff8002003f7f02, 0xffff8002003eff05,
  0xffff0003007efe83, 0xffff0003007dfe87,
  0xcccbcce966e564d0, 0xcccbcce933b131a1,
  0x777677bebc3ab9fb, 0x777677be33b13177,
  0xffff8001003f7f81, 0xffff8001003eff83,
  0xcccc4ce766a5e5ce, 0xcccc4ce73372329d,
  0x7776f7bcbbfb3af9, 0x7776f7bc33723273,
  0xf776f7ff3bfb397c, 0xf776f7fe337230f9,
  0xcccccce66666664d, 0xcccccce63333331b,
  0x777777bbbbbbbb78, 0x777777bb333332f1,
  0xf77777fe3bbbb9fb, 0xf77777fd33333177,
  0x7777783fbbbbb8fd, 0x7777783e3333307b,
  0xaaaaaad55555552b, 0xaaaaaad4ffffffd7,
  0x2aaaab17d55553ae, 0x2aaaab16fffffe5d,
  0xaaaaab59555552b0, 0xaaaaab57fffffd61,
  0x2aaaab99d5555231, 0x2aaaab97fffffce3,
  0x800000427ffffe83, 0x80000041fffffe87,
  0x00000083fffffd85, 0x00000082fffffd8b,
  0x800000c47ffffd06, 0x800000c2fffffd0d,
  0x00000103fffffd06, 0x00000101fffffd0d,
  0x800000417fffff02, 0x80000040ffffff05,
  0x00000081fffffe83, 0x00000080fffffe87,
  0x800000c17ffffe83, 0x800000bffffffe87,
  0x000000ffffffff02, 0x000000fdffffff05,
  0x800000407fffff81, 0x8000003fffffff83,
  0x0000007fffffff81, 0x0000007effffff83,
  0x800000be80000000, 0x800000bd00000001,
  0xd55556692aaaaa56, 0xd5555666ffffffad,
  0x8000003f80000000, 0x8000003f00000001,
  0x0000007e0000007f, 0x0000007d0000007f,
  0x55555628aaaaaad5, 0x555556270000002b,
  0x888889c244444409, 0x888889bfcccccc93,
  0x8000003e8000007f, 0x8000003e0000007f,
  0xd55555e92aaaaad5, 0xd55555e80000002b,
  0x08888982c4444409, 0x08888980cccccc93,
  0x08890a01c404c409, 0x088909fecc8dcc93,
  0x555555aaaaaaaa56, 0x555555a9ffffffad,
  0x888889444444438a, 0x88888942cccccc15,
  0x888909c34404c38a, 0x888909c0cc8dcc15,
  0x88898a4143c54409, 0x88898a3dcc4ecc93,
  0x3333339999999934, 0x33333398cccccc69,
  0x3333b418995a1934, 0x3333b416cc8dcc69,
  0x33343496991a99b3, 0x33343493cc4ecce7,
  0x3334b51398db1ab1, 0x3334b50fcc0fcde3,
  0x0000807effc08000, 0x0000807dffc10001,
  0x000100fcff81007f, 0x000100faff82007f,
  0x00018179ff41817d, 0x00018176ff43017b,
  0x000201f5ff0202fa, 0x000201f1ff0402f5,
  0x0000807dffc0807f, 0x0000807cffc1007f,
  0x000100faff81017d, 0x000100f8ff82017b,
  0x00018176ff4182fa, 0x00018173ff4302f5,
  0x00018275ff41437a, 0x00018271ff42c3f5,
  0x0000807cffc080fe, 0x0000807bffc100fd,
  0x000100f8ff81027b, 0x000100f6ff820277,
  0x000101f7ff80c2fb, 0x000101f4ff81c377,
  0x000102f5ff8083fa, 0x000102f1ff8184f5,
  0x0000807bffc0817d, 0x0000807affc1017b,
  0x0000817affc041fd, 0x00008178ffc0c27b,
  0x00008278ffc002fc, 0x00008275ffc083f9,
  0x00008375ffbfc47a, 0x00008371ffc045f5,
  0x000000feffffc080, 0x000000fdffffc101,
  0x000001fcffff817f, 0x000001faffff827f,
  0x000002f9ffff42fd, 0x000002f6ffff447b,
  0x000003f5ffff04fa, 0x000003f1ffff06f5,
  0x000000fdffffc0ff, 0x000000fcffffc17f,
  0x000001faffff827d, 0x000001f8ffff837b,
  0x000002f6ffff447a, 0x000002f3ffff45f5,
  0x00000395ffff349a, 0x00000391ffff3635,
  0x000000fcffffc17e, 0x000000fbffffc1fd,
  0x000001f8ffff837b, 0x000001f6ffff8477,
  0x00000297ffff739b, 0x00000294ffff74b7,
  0x00000319ffff721e, 0x00000315ffff733d,
  0x000000fbffffc1fd, 0x000000faffffc27b,
  0x0000019affffb21d, 0x00000198ffffb2bb,
  0x0000021cffffb0a0, 0x00000219ffffb141,
  0x0000029dffffafa2, 0x00000299ffffb045,
  0x0000009efffff020, 0x0000009dfffff041,
  0x00000120ffffeea3, 0x0000011effffeec7,
  0x000001a1ffffeda5, 0x0000019effffedcb,
  0x00000221ffffed26, 0x0000021dffffed4d,
  0x00000080fffffe86, 0x0000007ffffffe8a,
  0x00000100fffffd8a, 0x000000fefffffd90,
  0x0000017ffffffd0c, 0x0000017cfffffd13,
  0x0000017ffffffd0c, 0x0000017cfffffd13,
  0x0000007fffffff04, 0x0000007effffff07,
  0x000000fefffffe86, 0x000000fcfffffe8a,
  0x000000fefffffe86, 0x000000fcfffffe8a,
  0x000000fdffffff04, 0x000000fbffffff07,
  0x0000007effffff82, 0x0000007dffffff84,
  0x0000007effffff82, 0x0000007dffffff84,
  0x0000007e00000000, 0x0000007d00000001,
  0x0000007c000000fc, 0x0000007b000000fb,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff0000007e, 0xffffffff0000007e,
  0xfffffffd0000017a, 0xfffffffd00000178,
  0xffffffdd0000113a, 0xffffffdd00001118,
  0xffffffff0000007e, 0xffffffff0000007e,
  0xfffffffd0000017a, 0xfffffffd00000178,
  0xffffffdd0000113a, 0xffffffdd00001118,
  0xffffff6000004ec0, 0xffffff6000004e21,
  0xfffffffe000000fc, 0xfffffffe000000fb,
  0xffffffde000010bc, 0xffffffde0000109b,
  0xffffff6100004e42, 0xffffff6100004da4,
  0xfffffee300008c46, 0xfffffee300008b2a,
  0xffffffe000000fc0, 0xffffffe000000fa1,
  0xffffff6300004d46, 0xffffff6300004caa,
  0xfffffee500008b4a, 0xfffffee500008a30,
  0xfffffe660000c9cc, 0xfffffe660000c833,
  0xffffff8300003d86, 0xffffff8300003d0a,
  0xffffff0500007b8a, 0xffffff0500007a90,
  0xfffffe860000ba0c, 0xfffffe860000b893,
  0xffff7e89003fb892, 0xffff7e89003f371c,
  0xffffff8200003e04, 0xffffff8200003d87,
  0xffffff0300007c86, 0xffffff0300007b8a,
  0xffff7f06003f7b0c, 0xffff7f06003efa13,
  0xfffeff08007e7a10, 0xfffeff08007d7919,
  0xffffff8100003e82, 0xffffff8100003e04,
  0xffff7f84003f3d08, 0xffff7f84003ebc8d,
  0xfffeff86007e3c0c, 0xfffeff86007d3b93,
  0xfffe7f8700bd3b8e, 0xfffe7f8700bbbb16,
  0xffff8003003efe86, 0xffff8003003e7e8a,
  0xffff0005007dfd8a, 0xffff0005007cfd90,
  0xfffe800600bcfd0c, 0xfffe800600bb7d13,
  0xcccb4cec33f03026, 0xcccb4cec00bb7cfa,
  0xffff8002003eff04, 0xffff8002003e7f07,
  0xffff0003007dfe86, 0xffff0003007cfe8a,
  0xcccbcce933b131a0, 0xcccbcce9007cfe71,
  0x777677be33b13176, 0x777677bdab27a8f2,
  0xffff8001003eff82, 0xffff8001003e7f84,
  0xcccc4ce73372329c, 0xcccc4ce7003e7f6b,
  0x7776f7bc33723272, 0x7776f7bbaae929ec,
  0xf776f7fe337230f8, 0xf776f7fd2ae92875,
  0xcccccce63333331a, 0xcccccce5ffffffe8,
  0x777777bb333332f0, 0x777777baaaaaaa69,
  0xf77777fd33333176, 0xf77777fc2aaaa8f2,
  0x7777783e3333307a, 0x7777783caaaaa7f8,
  0xaaaaaad4ffffffd6, 0xaaaaaad4aaaaaa82,
  0x2aaaab16fffffe5c, 0x2aaaab162aaaa90b,
  0xaaaaab57fffffd60, 0xaaaaab56aaaaa811,
  0x2aaaab97fffffce2, 0x2aaaab962aaaa794,
  0x80000041fffffe86, 0x800000417ffffe8a,
  0x00000082fffffd8a, 0x00000081fffffd90,
  0x800000c2fffffd0c, 0x800000c17ffffd13,
  0x00000101fffffd0c, 0x000000fffffffd13,
  0x80000040ffffff04, 0x800000407fffff07,
  0x00000080fffffe86, 0x0000007ffffffe8a,
  0x800000bffffffe86, 0x800000be7ffffe8a,
  0x000000fdffffff04, 0x000000fbffffff07,
  0x8000003fffffff82, 0x8000003f7fffff84,
  0x0000007effffff82, 0x0000007dffffff84,
  0x800000bd00000000, 0x800000bb80000001,
  0xd5555666ffffffac, 0xd5555664d5555503,
  0x8000003f00000000, 0x8000003e80000001,
  0x0000007d0000007e, 0x0000007c0000007e,
  0x555556270000002a, 0x5555562555555580,
  0x888889bfcccccc92, 0x888889bd5555551c,
  0x8000003e0000007e, 0x8000003d8000007e,
  0xd55555e80000002a, 0xd55555e6d5555580,
  0x08888980cccccc92, 0x0888897ed555551c,
  0x088909fecc8dcc92, 0x088909fbd516d51c,
  0x555555a9ffffffac, 0x555555a955555503,
  0x88888942cccccc14, 0x888889415555549f,
  0x888909c0cc8dcc14, 0x888909be5516d49f,
  0x88898a3dcc4ecc92, 0x88898a3a54d8551c,
  0x33333398cccccc68, 0x33333397ffffff9d,
  0x3333b416cc8dcc68, 0x3333b414ffc17f9d,
  0x33343493cc4ecce6, 0x33343490ff83001a,
  0x3334b50fcc0fcde2, 0x3334b50bff448114,
  0x0000807dffc10000, 0x0000807cffc18001,
  0x000100faff82007e, 0x000100f8ff83007e,
  0x00018176ff43017a, 0x00018173ff448178,
  0x000201f1ff0402f4, 0x000201edff0602ef,
  0x0000807cffc1007e, 0x0000807bffc1807e,
  0x000100f8ff82017a, 0x000100f6ff830178,
  0x00018173ff4302f4, 0x00018170ff4482ef,
  0x00018271ff42c3f4, 0x0001826dff44446f,
  0x0000807bffc100fc, 0x0000807affc180fb,
  0x000100f6ff820276, 0x000100f4ff830272,
  0x000101f4ff81c376, 0x000101f1ff82c3f2,
  0x000102f1ff8184f4, 0x000102edff8285ef,
  0x0000807affc1017a, 0x00008079ffc18178,
  0x00008178ffc0c27a, 0x00008176ffc142f8,
  0x00008275ffc083f8, 0x00008272ffc104f5,
  0x00008371ffc045f4, 0x0000836dffc0c76f,
  0x000000fdffffc100, 0x000000fcffffc181,
  0x000001faffff827e, 0x000001f8ffff837e,
  0x000002f6ffff447a, 0x000002f3ffff45f8,
  0x000003f1ffff06f4, 0x000003edffff08ef,
  0x000000fcffffc17e, 0x000000fbffffc1fe,
  0x000001f8ffff837a, 0x000001f6ffff8478,
  0x000002f3ffff45f4, 0x000002f0ffff476f,
  0x00000391ffff3634, 0x0000038dffff37cf,
  0x000000fbffffc1fc, 0x000000faffffc27b,
  0x000001f6ffff8476, 0x000001f4ffff8572,
  0x00000294ffff74b6, 0x00000291ffff75d2,
  0x00000315ffff733c, 0x00000311ffff745b,
  0x000000faffffc27a, 0x000000f9ffffc2f8,
  0x00000198ffffb2ba, 0x00000196ffffb358,
  0x00000219ffffb140, 0x00000216ffffb1e1,
  0x00000299ffffb044, 0x00000295ffffb0e7,
  0x0000009dfffff040, 0x0000009cfffff061,
  0x0000011effffeec6, 0x0000011cffffeeea,
  0x0000019effffedca, 0x0000019bffffedf0,
  0x0000021dffffed4c, 0x00000219ffffed73,
  0x0000007ffffffe89, 0x00000022ffffffa1,
  0x000000fefffffd8f, 0x00000044ffffff61,
  0x0000017cfffffd12, 0x00000065ffffff41,
  0x0000017cfffffd12, 0x00000065ffffff41,
  0x0000007effffff06, 0x00000021ffffffc1,
  0x000000fcfffffe89, 0x00000042ffffffa1,
  0x000000fcfffffe89, 0x00000042ffffffa1,
  0x000000fbffffff06, 0x00000041ffffffc1,
  0x0000007dffffff83, 0x00000020ffffffe1,
  0x0000007dffffff83, 0x00000020ffffffe1,
  0x0000007d00000000, 0x0000002000000001,
  0x0000007b000000fa, 0x0000001e00000041,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff0000007d, 0xffffffff00000021,
  0xfffffffd00000177, 0xfffffffd00000061,
  0xffffffdd00001117, 0xffffffdd00000461,
  0xffffffff0000007d, 0xffffffff00000021,
  0xfffffffd00000177, 0xfffffffd00000061,
  0xffffffdd00001117, 0xffffffdd00000461,
  0xffffff6000004e20, 0xffffff6000001401,
  0xfffffffe000000fa, 0xfffffffe00000041,
  0xffffffde0000109a, 0xffffffde00000441,
  0xffffff6100004da3, 0xffffff61000013e1,
  0xfffffee300008b29, 0xfffffee3000023a1,
  0xffffffe000000fa0, 0xffffffe000000401,
  0xffffff6300004ca9, 0xffffff63000013a1,
  0xfffffee500008a2f, 0xfffffee500002361,
  0xfffffe660000c832, 0xfffffe6600003341,
  0xffffff8300003d09, 0xffffff8300000fa1,
  0xffffff0500007a8f, 0xffffff0500001f61,
  0xfffffe860000b892, 0xfffffe8600002f41,
  0xffff7e89003f371b, 0xffff7e8900102ee1,
  0xffffff8200003d86, 0xffffff8200000fc1,
  0xffffff0300007b89, 0xffffff0300001fa1,
  0xffff7f06003efa12, 0xffff7f0600101f41,
  0xfffeff08007d7918, 0xfffeff0800201f01,
  0xffffff8100003e03, 0xffffff8100000fe1,
  0xffff7f84003ebc8c, 0xffff7f8400100f81,
  0xfffeff86007d3b92, 0xfffeff8600200f41,
  0xfffe7f8700bbbb15, 0xfffe7f8700300f21,
  0xffff8003003e7e89, 0xffff8003000fffa1,
  0xffff0005007cfd8f, 0xffff0005001fff61,
  0xfffe800600bb7d12, 0xfffe8006002fff41,
  0xcccb4cec00bb7cf9, 0xcccb4cd9669665a1,
  0xffff8002003e7f06, 0xffff8002000fffc1,
  0xffff0003007cfe89, 0xffff0003001fffa1,
  0xcccbcce9007cfe70, 0xcccbccd666866601,
  0x777677bdab27a8f1, 0x7776778c113110a1,
  0xffff8001003e7f83, 0xffff8001000fffe1,
  0xcccc4ce7003e7f6a, 0xcccc4cd466766641,
  0x7776f7bbaae929eb, 0x7776f78a112110e1,
  0xf776f7fd2ae92874, 0xf776f79d11211081,
  0xcccccce5ffffffe7, 0xccccccd366666661,
  0x777777baaaaaaa68, 0x7777778911111101,
  0xf77777fc2aaaa8f1, 0xf777779c111110a1,
  0x7777783caaaaa7f7, 0x777777ae11111061,
  0xaaaaaad4aaaaaa81, 0xaaaaaab5aaaaaaa1,
  0x2aaaab162aaaa90a, 0x2aaaaac8aaaaaa41,
  0xaaaaab56aaaaa810, 0xaaaaaadaaaaaaa01,
  0x2aaaab962aaaa793, 0x2aaaaaebaaaaa9e1,
  0x800000417ffffe89, 0x80000012ffffffa1,
  0x00000081fffffd8f, 0x00000024ffffff61,
  0x800000c17ffffd12, 0x80000035ffffff41,
  0x000000fffffffd12, 0x00000045ffffff41,
  0x800000407fffff06, 0x80000011ffffffc1,
  0x0000007ffffffe89, 0x00000022ffffffa1,
  0x800000be7ffffe89, 0x80000032ffffffa1,
  0x000000fbffffff06, 0x00000041ffffffc1,
  0x8000003f7fffff83, 0x80000010ffffffe1,
  0x0000007dffffff83, 0x00000020ffffffe1,
  0x800000bb80000000, 0x8000003000000001,
  0xd5555664d5555502, 0xd555559b55555541,
  0x8000003e80000000, 0x8000001000000001,
  0x0000007c0000007d, 0x0000001f00000021,
  0x555556255555557f, 0x5555558a55555561,
  0x888889bd5555551b, 0x888888d7eeeeeee1,
  0x8000003d8000007d, 0x8000000f00000021,
  0xd55555e6d555557f, 0xd555557a55555561,
  0x0888897ed555551b, 0x088888c7eeeeeee1,
  0x088909fbd516d51b, 0x088908e7eedeeee1,
  0x555555a955555502, 0x5555556b55555541,
  0x888889415555549e, 0x888888b8eeeeeec1,
  0x888909be5516d49e, 0x888908d8eedeeec1,
  0x88898a3a54d8551b, 0x888988f7eeceeee1,
  0x33333397ffffff9c, 0x3333334d99999981,
  0x3333b414ffc17f9c, 0x3333b36d99899981,
  0x33343490ff830019, 0x3334338c997999a1,
  0x3334b50bff448113, 0x3334b3aa996999e1,
  0x0000807cffc18000, 0x0000801ffff00001,
  0x000100f8ff83007d, 0x0001003effe00021,
  0x00018173ff448177, 0x0001805cffd00061,
  0x000201edff0602ee, 0x00020079ffc000c1,
  0x0000807bffc1807d, 0x0000801efff00021,
  0x000100f6ff830177, 0x0001003cffe00061,
  0x00018170ff4482ee, 0x00018059ffd000c1,
  0x0001826dff44446e, 0x000180f9ffcff0c1,
  0x0000807affc180fa, 0x0000801dfff00041,
  0x000100f4ff830271, 0x0001003affe000a1,
  0x000101f1ff82c3f1, 0x000100daffdff0a1,
  0x000102edff8285ee, 0x00010179ffdfe0c1,
  0x00008079ffc18177, 0x0000801cfff00061,
  0x00008176ffc142f7, 0x000080bcffeff061,
  0x00008272ffc104f4, 0x0000815bffefe081,
  0x0000836dffc0c76e, 0x000081f9ffefd0c1,
  0x000000fcffffc180, 0x0000009ffffff001,
  0x000001f8ffff837d, 0x0000013effffe021,
  0x000002f3ffff45f7, 0x000001dcffffd061,
  0x000003edffff08ee, 0x00000279ffffc0c1,
  0x000000fbffffc1fd, 0x0000009efffff021,
  0x000001f6ffff8477, 0x0000013cffffe061,
  0x000002f0ffff476e, 0x000001d9ffffd0c1,
  0x0000038dffff37ce, 0x00000219ffffccc1,
  0x000000faffffc27a, 0x0000009dfffff041,
  0x000001f4ffff8571, 0x0000013affffe0a1,
  0x00000291ffff75d1, 0x0000017affffdca1,
  0x00000311ffff745a, 0x0000019dffffdc41,
  0x000000f9ffffc2f7, 0x0000009cfffff061,
  0x00000196ffffb357, 0x000000dcffffec61,
  0x00000216ffffb1e0, 0x000000ffffffec01,
  0x00000295ffffb0e6, 0x00000121ffffebc1,
  0x0000009cfffff060, 0x0000003ffffffc01,
  0x0000011cffffeee9, 0x00000062fffffba1,
  0x0000019bffffedef, 0x00000084fffffb61,
  0x00000219ffffed72, 0x000000a5fffffb41,
  0x00000022ffffffa0, 0x00000005fffffff8,
  0x00000044ffffff60, 0x0000000afffffff2,
  0x00000065ffffff40, 0x0000000effffffef,
  0x00000065ffffff40, 0x0000000effffffef,
  0x00000021ffffffc0, 0x00000004fffffffb,
  0x00000042ffffffa0, 0x00000008fffffff8,
  0x00000042ffffffa0, 0x00000008fffffff8,
  0x00000041ffffffc0, 0x00000007fffffffb,
  0x00000020ffffffe0, 0x00000003fffffffe,
  0x00000020ffffffe0, 0x00000003fffffffe,
  0x0000002000000000, 0x0000000300000001,
  0x0000001e00000040, 0x0000000100000007,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000020, 0xffffffff00000004,
  0xfffffffd00000060, 0xfffffffd0000000a,
  0xffffffdd00000460, 0xffffffdd0000006a,
  0xffffffff00000020, 0xffffffff00000004,
  0xfffffffd00000060, 0xfffffffd0000000a,
  0xffffffdd00000460, 0xffffffdd0000006a,
  0xffffff6000001400, 0xffffff60000001e1,
  0xfffffffe00000040, 0xfffffffe00000007,
  0xffffffde00000440, 0xffffffde00000067,
  0xffffff61000013e0, 0xffffff61000001de,
  0xfffffee3000023a0, 0xfffffee300000358,
  0xffffffe000000400, 0xffffffe000000061,
  0xffffff63000013a0, 0xffffff63000001d8,
  0xfffffee500002360, 0xfffffee500000352,
  0xfffffe6600003340, 0xfffffe66000004cf,
  0xffffff8300000fa0, 0xffffff8300000178,
  0xffffff0500001f60, 0xffffff05000002f2,
  0xfffffe8600002f40, 0xfffffe860000046f,
  0xffff7e8900102ee0, 0xffff7e8900018466,
  0xffffff8200000fc0, 0xffffff820000017b,
  0xffffff0300001fa0, 0xffffff03000002f8,
  0xffff7f0600101f40, 0xffff7f06000182ef,
  0xfffeff0800201f00, 0xfffeff08000302e9,
  0xffffff8100000fe0, 0xffffff810000017e,
  0xffff7f8400100f80, 0xffff7f8400018175,
  0xfffeff8600200f40, 0xfffeff860003016f,
  0xfffe7f8700300f20, 0xfffe7f870004816c,
  0xffff8003000fffa0, 0xffff800300017ff8,
  0xffff0005001fff60, 0xffff00050002fff2,
  0xfffe8006002fff40, 0xfffe800600047fef,
  0xcccb4cd9669665a0, 0xcccb4cd3999e1988,
  0xffff8002000fffc0, 0xffff800200017ffb,
  0xffff0003001fffa0, 0xffff00030002fff8,
  0xcccbccd666866600, 0xcccbccd0999c9991,
  0x7776778c113110a0, 0x7776777c999c9990,
  0xffff8001000fffe0, 0xffff800100017ffe,
  0xcccc4cd466766640, 0xcccc4cce999b1997,
  0x7776f78a112110e0, 0x7776f77a999b1996,
  0xf776f79d11211080, 0xf776f77f199b198d,
  0xccccccd366666660, 0xcccccccd9999999a,
  0x7777778911111100, 0x7777777999999999,
  0xf777779c111110a0, 0xf777777e19999990,
  0x777777ae11111060, 0x777777819999998a,
  0xaaaaaab5aaaaaaa0, 0xaaaaaaac00000000,
  0x2aaaaac8aaaaaa40, 0x2aaaaab07ffffff7,
  0xaaaaaadaaaaaaa00, 0xaaaaaab3fffffff1,
  0x2aaaaaebaaaaa9e0, 0x2aaaaab67fffffee,
  0x80000012ffffffa0, 0x800000047ffffff8,
  0x00000024ffffff60, 0x00000007fffffff2,
  0x80000035ffffff40, 0x8000000a7fffffef,
  0x00000045ffffff40, 0x0000000bffffffef,
  0x80000011ffffffc0, 0x800000037ffffffb,
  0x00000022ffffffa0, 0x00000005fffffff8,
  0x80000032ffffffa0, 0x800000077ffffff8,
  0x00000041ffffffc0, 0x00000007fffffffb,
  0x80000010ffffffe0, 0x800000027ffffffe,
  0x00000020ffffffe0, 0x00000003fffffffe,
  0x8000003000000000, 0x8000000480000001,
  0xd555559b55555540, 0xd555555c7fffffff,
  0x8000001000000000, 0x8000000180000001,
  0x0000001f00000020, 0x0000000200000004,
  0x5555558a55555560, 0x5555555a00000002,
  0x888888d7eeeeeee0, 0x8888889066666666,
  0x8000000f00000020, 0x8000000080000004,
  0xd555557a55555560, 0xd555555880000002,
  0x088888c7eeeeeee0, 0x0888888ee6666666,
  0x088908e7eedeeee0, 0x08890891e664e666,
  0x5555556b55555540, 0x55555557ffffffff,
  0x888888b8eeeeeec0, 0x8888888e66666663,
  0x888908d8eedeeec0, 0x888908916664e663,
  0x888988f7eeceeee0, 0x8889889366636666,
  0x3333334d99999980, 0x3333333666666665,
  0x3333b36d99899980, 0x3333b3396664e665,
  0x3334338c997999a0, 0x3334333b66636668,
  0x3334b3aa996999e0, 0x3334b33c6661e66e,
  0x0000801ffff00000, 0x00008002fffe8001,
  0x0001003effe00020, 0x00010004fffd0004,
  0x0001805cffd00060, 0x00018005fffb800a,
  0x00020079ffc000c0, 0x00020005fffa0013,
  0x0000801efff00020, 0x00008001fffe8004,
  0x0001003cffe00060, 0x00010002fffd000a,
  0x00018059ffd000c0, 0x00018002fffb8013,
  0x000180f9ffcff0c0, 0x00018085fffb7e93,
  0x0000801dfff00040, 0x00008000fffe8007,
  0x0001003affe000a0, 0x00010000fffd0010,
  0x000100daffdff0a0, 0x00010083fffcfe90,
  0x00010179ffdfe0c0, 0x00010105fffcfd13,
  0x0000801cfff00060, 0x00007ffffffe800a,
  0x000080bcffeff060, 0x00008082fffe7e8a,
  0x0000815bffefe080, 0x00008104fffe7d0d,
  0x000081f9ffefd0c0, 0x00008185fffe7b93,
  0x0000009ffffff000, 0x00000082fffffe81,
  0x0000013effffe020, 0x00000104fffffd04,
  0x000001dcffffd060, 0x00000185fffffb8a,
  0x00000279ffffc0c0, 0x00000205fffffa13,
  0x0000009efffff020, 0x00000081fffffe84,
  0x0000013cffffe060, 0x00000102fffffd0a,
  0x000001d9ffffd0c0, 0x00000182fffffb93,
  0x00000219ffffccc0, 0x000001a5fffffb33,
  0x0000009dfffff040, 0x00000080fffffe87,
  0x0000013affffe0a0, 0x00000100fffffd10,
  0x0000017affffdca0, 0x00000123fffffcb0,
  0x0000019dffffdc40, 0x00000129fffffca7,
  0x0000009cfffff060, 0x0000007ffffffe8a,
  0x000000dcffffec60, 0x000000a2fffffe2a,
  0x000000ffffffec00, 0x000000a8fffffe21,
  0x00000121ffffebc0, 0x000000adfffffe1b,
  0x0000003ffffffc00, 0x00000022ffffffa1,
  0x00000062fffffba0, 0x00000028ffffff98,
  0x00000084fffffb60, 0x0000002dffffff92,
  0x000000a5fffffb40, 0x00000031ffffff8f,
  0x00000005fffffff7, 0x00000004fffffffb,
  0x0000000afffffff1, 0x00000008fffffff7,
  0x0000000effffffee, 0x0000000bfffffff5,
  0x0000000effffffee, 0x0000000bfffffff5,
  0x00000004fffffffa, 0x00000003fffffffd,
  0x00000008fffffff7, 0x00000006fffffffb,
  0x00000008fffffff7, 0x00000006fffffffb,
  0x00000007fffffffa, 0x00000005fffffffd,
  0x00000003fffffffd, 0x00000002ffffffff,
  0x00000003fffffffd, 0x00000002ffffffff,
  0x0000000300000000, 0x0000000200000001,
  0x0000000100000006, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000003, 0xffffffff00000003,
  0xfffffffd00000009, 0xfffffffd00000007,
  0xffffffdd00000069, 0xffffffdd00000047,
  0xffffffff00000003, 0xffffffff00000003,
  0xfffffffd00000009, 0xfffffffd00000007,
  0xffffffdd00000069, 0xffffffdd00000047,
  0xffffff60000001e0, 0xffffff6000000141,
  0xfffffffe00000006, 0xfffffffe00000005,
  0xffffffde00000066, 0xffffffde00000045,
  0xffffff61000001dd, 0xffffff610000013f,
  0xfffffee300000357, 0xfffffee30000023b,
  0xffffffe000000060, 0xffffffe000000041,
  0xffffff63000001d7, 0xffffff630000013b,
  0xfffffee500000351, 0xfffffee500000237,
  0xfffffe66000004ce, 0xfffffe6600000335,
  0xffffff8300000177, 0xffffff83000000fb,
  0xffffff05000002f1, 0xffffff05000001f7,
  0xfffffe860000046e, 0xfffffe86000002f5,
  0xffff7e8900018465, 0xffff7e89000102ef,
  0xffffff820000017a, 0xffffff82000000fd,
  0xffffff03000002f7, 0xffffff03000001fb,
  0xffff7f06000182ee, 0xffff7f06000101f5,
  0xfffeff08000302e8, 0xfffeff08000201f1,
  0xffffff810000017d, 0xffffff81000000ff,
  0xffff7f8400018174, 0xffff7f84000100f9,
  0xfffeff860003016e, 0xfffeff86000200f5,
  0xfffe7f870004816b, 0xfffe7f87000300f3,
  0xffff800300017ff7, 0xffff80030000fffb,
  0xffff00050002fff1, 0xffff00050001fff7,
  0xfffe800600047fee, 0xfffe80060002fff5,
  0xcccb4cd3999e1987, 0xcccb4cd36669665b,
  0xffff800200017ffa, 0xffff80020000fffd,
  0xffff00030002fff7, 0xffff00030001fffb,
  0xcccbccd0999c9990, 0xcccbccd066686661,
  0x7776777c999c998f, 0x7776777c1113110b,
  0xffff800100017ffd, 0xffff80010000ffff,
  0xcccc4cce999b1996, 0xcccc4cce66676665,
  0x7776f77a999b1995, 0x7776f77a1112110f,
  0xf776f77f199b198c, 0xf776f77e11121109,
  0xcccccccd99999999, 0xcccccccd66666667,
  0x7777777999999998, 0x7777777911111111,
  0xf777777e1999998f, 0xf777777d1111110b,
  0x7777778199999989, 0x7777778011111107,
  0xaaaaaaabffffffff, 0xaaaaaaabaaaaaaab,
  0x2aaaaab07ffffff6, 0x2aaaaaafaaaaaaa5,
  0xaaaaaab3fffffff0, 0xaaaaaab2aaaaaaa1,
  0x2aaaaab67fffffed, 0x2aaaaab4aaaaaa9f,
  0x800000047ffffff7, 0x80000003fffffffb,
  0x00000007fffffff1, 0x00000006fffffff7,
  0x8000000a7fffffee, 0x80000008fffffff5,
  0x0000000bffffffee, 0x00000009fffffff5,
  0x800000037ffffffa, 0x80000002fffffffd,
  0x00000005fffffff7, 0x00000004fffffffb,
  0x800000077ffffff7, 0x80000005fffffffb,
  0x00000007fffffffa, 0x00000005fffffffd,
  0x800000027ffffffd, 0x80000001ffffffff,
  0x00000003fffffffd, 0x00000002ffffffff,
  0x8000000480000000, 0x8000000300000001,
  0xd555555c7ffffffe, 0xd555555a55555555,
  0x8000000180000000, 0x8000000100000001,
  0x0000000200000003, 0x0000000100000003,
  0x5555555a00000001, 0x5555555855555557,
  0x8888889066666665, 0x8888888deeeeeeef,
  0x8000000080000003, 0x8000000000000003,
  0xd555555880000001, 0xd555555755555557,
  0x0888888ee6666665, 0x0888888ceeeeeeef,
  0x08890891e664e665, 0x0889088eeeedeeef,
  0x55555557fffffffe, 0x5555555755555555,
  0x8888888e66666662, 0x8888888ceeeeeeed,
  0x888908916664e662, 0x8889088eeeedeeed,
  0x8889889366636665, 0x8889888feeeceeef,
  0x3333333666666664, 0x3333333599999999,
  0x3333b3396664e664, 0x3333b33799989999,
  0x3334333b66636667, 0x333433389997999b,
  0x3334b33c6661e66d, 0x3334b3389996999f,
  0x00008002fffe8000, 0x00008001ffff0001,
  0x00010004fffd0003, 0x00010002fffe0003,
  0x00018005fffb8009, 0x00018002fffd0007,
  0x00020005fffa0012, 0x00020001fffc000d,
  0x00008001fffe8003, 0x00008000ffff0003,
  0x00010002fffd0009, 0x00010000fffe0007,
  0x00018002fffb8012, 0x00017ffffffd000d,
  0x00018085fffb7e92, 0x00018081fffcff0d,
  0x00008000fffe8006, 0x00007fffffff0005,
  0x00010000fffd000f, 0x0000fffefffe000b,
  0x00010083fffcfe8f, 0x00010080fffdff0b,
  0x00010105fffcfd12, 0x00010101fffdfe0d,
  0x00007ffffffe8009, 0x00007ffeffff0007,
  0x00008082fffe7e89, 0x00008080fffeff07,
  0x00008104fffe7d0c, 0x00008101fffefe09,
  0x00008185fffe7b92, 0x00008181fffefd0d,
  0x00000082fffffe80, 0x00000081ffffff01,
  0x00000104fffffd03, 0x00000102fffffe03,
  0x00000185fffffb89, 0x00000182fffffd07,
  0x00000205fffffa12, 0x00000201fffffc0d,
  0x00000081fffffe83, 0x00000080ffffff03,
  0x00000102fffffd09, 0x00000100fffffe07,
  0x00000182fffffb92, 0x0000017ffffffd0d,
  0x000001a5fffffb32, 0x000001a1fffffccd,
  0x00000080fffffe86, 0x0000007fffffff05,
  0x00000100fffffd0f, 0x000000fefffffe0b,
  0x00000123fffffcaf, 0x00000120fffffdcb,
  0x00000129fffffca6, 0x00000125fffffdc5,
  0x0000007ffffffe89, 0x0000007effffff07,
  0x000000a2fffffe29, 0x000000a0fffffec7,
  0x000000a8fffffe20, 0x000000a5fffffec1,
  0x000000adfffffe1a, 0x000000a9fffffebd,
  0x00000022ffffffa0, 0x00000021ffffffc1,
  0x00000028ffffff97, 0x00000026ffffffbb,
  0x0000002dffffff91, 0x0000002affffffb7,
  0x00000031ffffff8e, 0x0000002dffffffb5,
  0x00000004fffffffa, 0x00000003fffffffe,
  0x00000008fffffff6, 0x00000006fffffffc,
  0x0000000bfffffff4, 0x00000008fffffffb,
  0x0000000bfffffff4, 0x00000008fffffffb,
  0x00000003fffffffc, 0x00000002ffffffff,
  0x00000006fffffffa, 0x00000004fffffffe,
  0x00000006fffffffa, 0x00000004fffffffe,
  0x00000005fffffffc, 0x00000003ffffffff,
  0x00000002fffffffe, 0x0000000200000000,
  0x00000002fffffffe, 0x0000000200000000,
  0x0000000200000000, 0x0000000100000001,
  0x0000000000000004, 0xffffffff00000003,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000002, 0xffffffff00000002,
  0xfffffffd00000006, 0xfffffffd00000004,
  0xffffffdd00000046, 0xffffffdd00000024,
  0xffffffff00000002, 0xffffffff00000002,
  0xfffffffd00000006, 0xfffffffd00000004,
  0xffffffdd00000046, 0xffffffdd00000024,
  0xffffff6000000140, 0xffffff60000000a1,
  0xfffffffe00000004, 0xfffffffe00000003,
  0xffffffde00000044, 0xffffffde00000023,
  0xffffff610000013e, 0xffffff61000000a0,
  0xfffffee30000023a, 0xfffffee30000011e,
  0xffffffe000000040, 0xffffffe000000021,
  0xffffff630000013a, 0xffffff630000009e,
  0xfffffee500000236, 0xfffffee50000011c,
  0xfffffe6600000334, 0xfffffe660000019b,
  0xffffff83000000fa, 0xffffff830000007e,
  0xffffff05000001f6, 0xffffff05000000fc,
  0xfffffe86000002f4, 0xfffffe860000017b,
  0xffff7e89000102ee, 0xffff7e8900008178,
  0xffffff82000000fc, 0xffffff820000007f,
  0xffffff03000001fa, 0xffffff03000000fe,
  0xffff7f06000101f4, 0xffff7f06000080fb,
  0xfffeff08000201f0, 0xfffeff08000100f9,
  0xffffff81000000fe, 0xffffff8100000080,
  0xffff7f84000100f8, 0xffff7f840000807d,
  0xfffeff86000200f4, 0xfffeff860001007b,
  0xfffe7f87000300f2, 0xfffe7f870001807a,
  0xffff80030000fffa, 0xffff800300007ffe,
  0xffff00050001fff6, 0xffff00050000fffc,
  0xfffe80060002fff4, 0xfffe800600017ffb,
  0xcccb4cd36669665a, 0xcccb4cd33334b32e,
  0xffff80020000fffc, 0xffff800200007fff,
  0xffff00030001fffa, 0xffff00030000fffe,
  0xcccbccd066686660, 0xcccbccd033343331,
  0x7776777c1113110a, 0x7776777b88898886,
  0xffff80010000fffe, 0xffff800100008000,
  0xcccc4cce66676664, 0xcccc4cce3333b333,
  0x7776f77a1112110e, 0x7776f77988890888,
  0xf776f77e11121108, 0xf776f77d08890885,
  0xcccccccd66666666, 0xcccccccd33333334,
  0x7777777911111110, 0x7777777888888889,
  0xf777777d1111110a, 0xf777777c08888886,
  0x7777778011111106, 0x7777777e88888884,
  0xaaaaaaabaaaaaaaa, 0xaaaaaaab55555556,
  0x2aaaaaafaaaaaaa4, 0x2aaaaaaed5555553,
  0xaaaaaab2aaaaaaa0, 0xaaaaaab155555551,
  0x2aaaaab4aaaaaa9e, 0x2aaaaab2d5555550,
  0x80000003fffffffa, 0x800000037ffffffe,
  0x00000006fffffff6, 0x00000005fffffffc,
  0x80000008fffffff4, 0x800000077ffffffb,
  0x00000009fffffff4, 0x00000007fffffffb,
  0x80000002fffffffc, 0x800000027fffffff,
  0x00000004fffffffa, 0x00000003fffffffe,
  0x80000005fffffffa, 0x800000047ffffffe,
  0x00000005fffffffc, 0x00000003ffffffff,
  0x80000001fffffffe, 0x8000000180000000,
  0x00000002fffffffe, 0x0000000200000000,
  0x8000000300000000, 0x8000000180000001,
  0xd555555a55555554, 0xd55555582aaaaaab,
  0x8000000100000000, 0x8000000080000001,
  0x0000000100000002, 0x0000000000000002,
  0x5555555855555556, 0x55555556aaaaaaac,
  0x8888888deeeeeeee, 0x8888888b77777778,
  0x8000000000000002, 0x7fffffff80000002,
  0xd555555755555556, 0xd55555562aaaaaac,
  0x0888888ceeeeeeee, 0x0888888af7777778,
  0x0889088eeeedeeee, 0x0889088bf776f778,
  0x5555555755555554, 0x55555556aaaaaaab,
  0x8888888ceeeeeeec, 0x8888888b77777777,
  0x8889088eeeedeeec, 0x8889088c7776f777,
  0x8889888feeeceeee, 0x8889888c77767778,
  0x3333333599999998, 0x33333334cccccccd,
  0x3333b33799989998, 0x3333b335cccc4ccd,
  0x333433389997999a, 0x33343335cccbccce,
  0x3334b3389996999e, 0x3334b334cccb4cd0,
  0x00008001ffff0000, 0x00008000ffff8001,
  0x00010002fffe0002, 0x00010000ffff0002,
  0x00018002fffd0006, 0x00017ffffffe8004,
  0x00020001fffc000c, 0x0001fffdfffe0007,
  0x00008000ffff0002, 0x00007fffffff8002,
  0x00010000fffe0006, 0x0000fffeffff0004,
  0x00017ffffffd000c, 0x00017ffcfffe8007,
  0x00018081fffcff0c, 0x0001807dfffe7f87,
  0x00007fffffff0004, 0x00007ffeffff8003,
  0x0000fffefffe000a, 0x0000fffcffff0006,
  0x00010080fffdff0a, 0x0001007dfffeff86,
  0x00010101fffdfe0c, 0x000100fdfffeff07,
  0x00007ffeffff0006, 0x00007ffdffff8004,
  0x00008080fffeff06, 0x0000807effff7f84,
  0x00008101fffefe08, 0x000080feffff7f05,
  0x00008181fffefd0c, 0x0000817dffff7e87,
  0x00000081ffffff00, 0x00000080ffffff81,
  0x00000102fffffe02, 0x00000100ffffff02,
  0x00000182fffffd06, 0x0000017ffffffe84,
  0x00000201fffffc0c, 0x000001fdfffffe07,
  0x00000080ffffff02, 0x0000007fffffff82,
  0x00000100fffffe06, 0x000000feffffff04,
  0x0000017ffffffd0c, 0x0000017cfffffe87,
  0x000001a1fffffccc, 0x0000019dfffffe67,
  0x0000007fffffff04, 0x0000007effffff83,
  0x000000fefffffe0a, 0x000000fcffffff06,
  0x00000120fffffdca, 0x0000011dfffffee6,
  0x00000125fffffdc4, 0x00000121fffffee3,
  0x0000007effffff06, 0x0000007dffffff84,
  0x000000a0fffffec6, 0x0000009effffff64,
  0x000000a5fffffec0, 0x000000a2ffffff61,
  0x000000a9fffffebc, 0x000000a5ffffff5f,
  0x00000021ffffffc0, 0x00000020ffffffe1,
  0x00000026ffffffba, 0x00000024ffffffde,
  0x0000002affffffb6, 0x00000027ffffffdc,
  0x0000002dffffffb4, 0x00000029ffffffdb,
};
const unsigned kExpectedCount_NEON_umlsl2_2D_4S_S = 3844;

#endif  // VIXL_SIM_UMLSL2_2D_4S_S_TRACE_AARCH64_H_
