/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _vdkxdb_h
#define _vdkxdb_h
#include <xbase/xbase.h>
#include <vdk/dlist.h>

class VDKXTable;
typedef VDKList<VDKXTable> TableList;
typedef VDKListIterator<VDKXTable> TableListIterator;

/*!
  \class VDKXDatabase
  \brief Provides a xbXBase wrapper
*/
class VDKXDatabase: public xbXBase
{
 private:
  TableList tList;
  bool initialized;
 public:
  //! Constructor
  VDKXDatabase();
  //! Destructor
  virtual ~VDKXDatabase();
  /*! 
    Removes a table from database table list
    \param name table name.
    Returns true on success
  */
  bool RemoveTable(char* name);
  //! Returns if xdb is initialized or not
  bool Initialized() { return initialized; }
  /*!
    Returns table address given table name
    \param name table name
   */
  VDKXTable* operator[](char* name);
  /*!
    Returns table address given ordinal position
    \param k ordinal position
  */
  VDKXTable* operator[](int k);
  //! Returns database table list
  TableList* TList() { return &tList; }
  /*!
    Clear database closing and deleting all open tables
  */
  void Clear();
};
/*!
  \fn VDKXError
  Returns a string explaining error.
  \param errorcode a xdb routine returned error code
 */
extern char* VDKXError(short errorcode);

#endif

