/*
 * unity-npapi-plugin-pp-funcs.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_NPAPI_PLUGIN_NPP_FUNCS_H)
#define UNITY_NPAPI_PLUGIN_NPP_FUNCS_H


#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"



/**
 * new plugin instance being created
 */
NPError NPP_New (NPMIMEType pluginType,
            	NPP npp,
            	uint16_t mode,
            	int16_t argc,
            	char* argn[],
            	char* argv[],
            	NPSavedData* saved);

NPError NPP_Destroy (NPP instance, NPSavedData **save);

NPError NPP_SetWindow (NPP instance, NPWindow *window);

NPError NPP_NewStream (NPP        instance, 
                      NPMIMEType type,
                      NPStream*  stream,
                      NPBool     seekable,
                      uint16_t*    stype);

NPError NPP_DestroyStream (NPP       instance, 
                           NPStream* stream, 
                           NPReason  reason);

void NPP_StreamAsFile (NPP         instance,
                      NPStream*   stream,
                      const char* fname);

int32_t NPP_WriteReady (NPP instance, NPStream* stream);

int32_t NPP_Write (NPP instance, 
                NPStream* stream,
                int32_t offset, 
                int32_t len, 
                void* buf);

void NPP_Print (NPP instance, NPPrint* PrintInfo);

int16_t NP_LOADDS NPP_HandleEvent(NPP instance, void* event);

void NPP_URLNotify (NPP         instance, 
                   const char* url,
                   NPReason    reason, 
                   void*       notifyData);

NPError NPP_GetValue (NPP instance, NPPVariable variable, void *value);

NPError NPP_SetValue (NPP instance, NPNVariable variable, void *value);


#endif // UNITY_NPAPI_PLUGIN_NPP_FUNCS_H
