/* Chromium Unity integration extension
 * 
 *   Copyright 2013 Canonical Ltd.
 *
 *   This program is free software: you can redistribute it and/or modify it 
 *   under the terms of the GNU General Public License version 3, as published 
 *   by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but 
 *   WITHOUT ANY WARRANTY; without even the implied warranties of 
 *   MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 *   PURPOSE.  See the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along 
 *   with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

(function () {
    var performContentScriptInitialization = function (loggerf) {

     UnityContentScriptApi = {
       getExtensionSettings: function (callback) {
	 chrome.runtime.sendMessage ({method: "get_extension_settings"}
				       , function (response) {
					 if (response && response.error) {
					   // TODO log
					   return;
					 }
					 
					 callback (response);
				       });
       },
     };
     
     
     // 
     // Initialize if needed
     // 
     var initializeIntegrationScriptIfNeededForUrl = function (loggerf) {
       
       var logger = loggerf || function (m) {};
       
       // does the unity script injection + user script if necessary
       logger ('Base content script, started on url: ' + document.URL);

       var getUserScriptContent = function (url) {
	 var content = null;
	 var xhr = new XMLHttpRequest();

	 xhr.onreadystatechange = function() {
	   if (xhr.readyState == 4) {
	     content = xhr.responseText;
	   }
	 };
	 // mmh blocking
	 xhr.open("GET", url, false);

	 try {
	   xhr.send();
	 } catch(e) {
	   logger ('Could not load user script content from: ' + url);
	 }
	 return content;
       };
       
       /**
        * Injects a given javascript file in the current content script
        * 
        * @param path path *in the current extension* of the required file
        */
       var require = function (path) {
	 try {
	   eval.call (window, getUserScriptContent (chrome.runtime.getURL (path)));
	 }
	 catch (e) {
	   logger ('Failed to add required dependancy: ' + path + ', ' + e);
	 }
       };

       UnityContentScriptApi.getExtensionSettings (
	   function (settings) {
               // Bail out if in incognito mode.
               if (settings && settings.incognito) {
                   return;
               }
	       require ("browser.js");
	 });
       
     }; // initializeIntegrationScriptIfNeededForUrl

     initializeIntegrationScriptIfNeededForUrl (loggerf);
     
   }; // performContentScriptInitialization
   
   // only do it for the top window, not the iframes
   performContentScriptInitialization (
     function (msg) {
       if (top === self) {
         console.log ("Content script: " + msg);
       }
     }
   );

 }
) ();

