# AXI Power Management Unit (PMU)

## Theory of operation

The PMU connects to the AVR running the firmware via SPI. The AVR is the master, the PMU contains a SPI
slave interface that operates as a shift register.
A 'valid' flag is used by the firmware to distinguish valid commands from the FPGA to the AVR from empty
readbacks that are happening as part of refreshing the FPGA's register state.

## Interfaces

### SPI Slave Port

The core comes with a SPI Slave port. The transaction size is set to 64 bytes, i.e. 8 one-byte transactions.
As the slave select line is used for synchronizing the internal state machine, the slave select line needs
to be held low for the entire 64 bytes.

### AXI4lite Slave Port

#### Register MAP

##### Shutdown Register (Offset 0x00)

| 31:8     | 7:0  |
|----------|------|
| reserved | flag |

Writing to the Shutdown Register will generate a Type 0 packet with payload *flag*. On the E312 the firmware
will cut FPGA power when flag is set to 0x7a.

##### Misc Register (Offset 0x04)

| 31:16    | 15:8       | 7:4         | 3:0         |
|----------|------------|-------------|-------------|
| reserved | irq enable | version maj | version min |

The *irq enable* bits can be used to mask IRQs generated by or-ing together the bits
in the Gauge Status Register *status* part.
Writing a '1' to any of the enable bits unmasks the IRQ, writing a '0' masks it.

The *version maj* and *version min* field contain the firmware version.

##### Battery State Register (Offset 0x08)

| 31:24   | 23:8        | 7:6            | 5          | 4:2        |  1:0       |
|---------|-------------|----------------|------------|------------|------------|
| reserved| bat voltage | bat temp alert | bat online | bat health | bat status |

The *bat voltage* field contains the current battery voltage as measured by the firmware as 16 bit unsigned integer.

The *bat temp alert* field contains the current temp alert value for the firmware.
The values are as following:
- 0b00: 60C
- 0b01: 80C
- 0b10: 100C
- 0b11: 120C

The *bat online* bit indicates the state of the battery FET as indicated by the firmware.

The *bat health* field contains the battery health as measured by the firmware.

The values are as following:
- 0b000: Health Good
- 0b001: Unspecified Failure
- 0b010: Overvoltage
- 0b011: Overheat
- 0b100: Too cold

The *bat status* field contains the battery status as detected by the firmware.

The values are as follows:
- 0b00: Not charging
- 0b01: Charging
- 0b10: Full
- 0b11: Discharing


##### Charger State Register (Offset 0x0c)

| 31:5      | 4:3         | 2              | 1:0            |
|-----------|-------------|----------------|----------------|
| reserved  | charge type | charger online | charger health |

The *charge type* field contains the current charge type as reported by the firmware.

The values are as follows:
- 0b00: None
- 0b01: Trickle Charge
- 0b10: Fast Charge
- 0b11: Reserved

The *charger online* field reads '1' if the charger is online, '0' otherwise.

The *charge health* field contains the current charger help  as reported by the firmware.

The values are as follows:
- 0b00: Health Good
- 0b01: Unspecified Failure
- 0b10: Overvoltage
- 0b11: Overheat

##### Gauge Charge / Temp Register (Offset 0x10)

| 31:16     | 15:0        |
|-----------|-------------|
| temp now  | charge now  |

The *temp now* field contains the current temperature as measured by the firmware as 16 bit unsigned integer.

The *charge now* field contains the current accumulated charge value  as measured by the firmware as 16 bit unsigned integer.

##### Gauge Status Register (Offset 0x14)

| 31:24    | 23:16  | 15:0        |
|----------|--------|-------------|
| reserved | status | voltage now |

The *status* field contains the current status as reported by the firmware.

The bits are as follows:
- Bit 7: Battery low alarm
- Bit 6: Temperature alarm
- Bits 5-0: Reserved

The *voltage now* field contains the current voltage value  as measured by the firmware as 16 bit unsigned integer.


##### Gauge Status Register (Offset 0x18)

| 31:16     | 15:0             |
|-----------|------------------|
| reserved  | charge last full |

The *charge now* field contains the current accumulated charge value as measured by the firmware at the point of last charge termination as 16 bit unsigned integer.

##### EEPROM Settings Register (Offset 0x1c)

| 31:8     | 7:0      |
|----------|----------|
| reserved | settings |

The *autoboot* field is divided as follows:

| 7:2      | 1        | 0        |
|----------|----------|----------|
| reserved | db power | autoboot |

Setting the *autoboot* bit will set the firmware autoboot flag to the value specified.

Setting the *db power* bit will instruct the firmware to turn the regulator for the daughterboard on / off.
