-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2008  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Globals; use Globals;

generic
   type Index is (<>);
package CL_Menus is

   Arrays_Not_Matched : exception;

   type MA is array (Index range <>) of UBS;
   type MNA is array (Integer range <>) of UBS;

   -- Give a Menu_Array for the valid characters (Accept_Chars), and a list
   -- of items (Numbered_Menu) to be selected by number (the menu
   -- subroutine will offer them up to 9 at a time).  Char_Words
   -- and Number_Word give the string to be displayed when that option is
   -- selected.  Number trailword is displayed after the numbered selection.
   type CLM_Return is
      record
         Is_Num : Boolean;
         I      : Index;
         N      : Integer;
      end record;

   generic
      Accept_Chars             : MA;
      Char_Words               : MA;
      Default_Prompt           : String := "";
      Default_Number_Word      : String := "";
      Default_Number_Trailword : String := "";
   function Menu (Numbered_Menu    : in MNA;
                  Number_Word      : in String := Default_Number_Word;
                  Prompt           : in String := Default_Prompt;
                  Number_Trailword : in String := Default_Number_Trailword)
                 return CLM_Return;

end CL_Menus;

