C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    *****************
                     SUBROUTINE MOBDIF
C                    *****************
C
C     -------------------------------------------------------
     *( NBMOBS,NDIM,NBCOUF,NELESF,NDMASF,NODESF,COORDF,CALCIU)
C     -------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------                                                       *
C         SOLIDE MOBILE : INITIALISATION DE :                          *
C            - D1MAXF (taille du plus grand element de bord fluide     *
C            - D2MAXF                                                  *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NDIM    !   E  ! D  ! DIMENSION DU PROBLEME                    !
C   !   NPOINS  !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE             !
C   !   NBMOBS  !   E  ! D  ! NOMBRE DE NOEUDS MOBILES                 !
C   !   NMOBIL  !   E  ! D  ! NUM GLOB ET NUM DE SOLIDE DES NOEUDS MOB !
C   !   COORDS  !  TR  ! M  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ROTATI
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : RESSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "mobil.h"
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NBMOBS,NDIM,NBCOUF,NELESF,NDMASF,NODESF(NELESF,NDMASF)
      INTEGER CALCIU
      DOUBLE PRECISION COORDF(NBCOUF,NDIM)
C
C..Variables internes
      INTEGER N,N1,N2,N3
      DOUBLE PRECISION D1,D2,D3,X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3

C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      D1MAXF = 0.
      D2MAXF = 1.E6          
C
      IF (NBMOBS.EQ.0 .AND. .NOT.LSDEPL .AND. 
     *    CALCIU.EQ.0) RETURN
C
C     1- CALCUL DE D1MAXF EN DIMENSION 2
C     ===================================
C
      IF (NDIM.EQ.2) THEN
C      
        DO 100 N=1,NELESF
C
          N1 = NODESF(N,1)
          N2 = NODESF(N,2)
C
          X1 = COORDF(N1,1)
          Y1 = COORDF(N1,2)
          X2 = COORDF(N2,1)
          Y2 = COORDF(N2,2)
C
          D2 = (X2-X1)*(X2-X1) + (Y2-Y1)*(Y2-Y1) 
C
          IF (D2.GT.D1MAXF) D1MAXF = D2
          IF (D2.LT.D2MAXF) D2MAXF = D2
C
  100   CONTINUE
C
C
C     2- CALCUL DE D1MAXF EN DIMENSION 3
C     ==================================
C
      ELSE
C
        DO 200 N=1,NELESF
C
          N1 = NODESF(N,1)
          N2 = NODESF(N,2)
          N3 = NODESF(N,3)
C
          X1 = COORDF(N1,1)
          Y1 = COORDF(N1,2)
          Z1 = COORDF(N1,3)
          X2 = COORDF(N2,1)
          Y2 = COORDF(N2,2)
          Z2 = COORDF(N2,3)
          X3 = COORDF(N3,1)
          Y3 = COORDF(N3,2)
          Z3 = COORDF(N3,3)
C
          D1 = (X2-X1)*(X2-X1) + (Y2-Y1)*(Y2-Y1) + (Z2-Z1)*(Z2-Z1)
          D2 = (X3-X1)*(X3-X1) + (Y3-Y1)*(Y3-Y1) + (Z3-Z1)*(Z3-Z1)
          D3 = (X2-X3)*(X2-X3) + (Y2-Y3)*(Y2-Y3) + (Z2-Z3)*(Z2-Z3) 
C
          IF (D1.GT.D1MAXF) D1MAXF = D1
          IF (D2.GT.D1MAXF) D1MAXF = D2
          IF (D3.GT.D1MAXF) D1MAXF = D3
          IF (D1.LT.D2MAXF) D2MAXF = D1
          IF (D2.LT.D2MAXF) D2MAXF = D2
          IF (D3.LT.D2MAXF) D2MAXF = D3
C
  200   CONTINUE
C
C
      ENDIF
C
C
C     5- Correction pour les problemes d'arrondis
C     ===========================================
      D1MAXF = D1MAXF
      D2MAXF = SQRT(D2MAXF)/10.
C
C
C     6- Impressions
C     ==============
      IF (NBLBLA.GT.0) WRITE(NFECRA,6000) 
     *             SQRT(D1MAXF),D2MAXF*10.,D2MAXF
C
C--------
C FORMATS
C--------
 6000 FORMAT(/,' *** MOBDIF : ',/,
     &       ' Taille du plus grand element de bord fluide : ',E12.5,/,
     &       ' (distance d''acceptation pour le 1er tri)',/,
     &       ' Taille du plus petit element de bord fluide : ',E12.5,/,
     &       ' Distance d''acceptation des ',
     &       'correspondants fluide/solide   : ',E12.5)
C
      RETURN
      END

