/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "DirEntry.h"

// svn
#include "svn_client.h"


namespace svn
{

DirEntry::DirEntry( const sc::String& name )
{
  _name = name;
  _nop  = true;

  _size   = 0;
  _props  = false;
  _rev    = 0;
  _date   = apr_time_now();
  _author = sc::String("");
  _kind = Node_Dir;
}

DirEntry::DirEntry( const sc::String& name, svn_dirent_t* e )
{
  _name = name;
  _nop = false;

  _size   = e->size;
  _props  = e->has_props == TRUE;
  _rev    = e->created_rev;
  _date   = e->time;
  _author = sc::String(e->last_author);  // utf-8 ??

  switch( e->kind )
  {
  case svn_node_file:
    {
      _kind = Node_File;
      break;
    }
  case svn_node_dir:
    {
      _kind = Node_Dir;
      break;
    }
  case svn_node_none:
    {
      _kind = Node_None;
      break;
    }
  default:
    {
      _kind = Node_Unknown;
    }
  }
}

const sc::String& DirEntry::getName() const
{
  return _name;
}

NodeKind DirEntry::getKind() const
{
  return _kind;
}

bool DirEntry::isDir() const
{
  return _kind == Node_Dir;
}

bool DirEntry::isFile() const
{
  return _kind == Node_File;
}

Filesize DirEntry::getSize() const
{
  return _size;
}

bool DirEntry::hasProperties() const
{
  return _props;
}

Revnumber DirEntry::getLastRevision() const
{
  return _rev;
}

Date DirEntry::getLastDate() const
{
  return _date;
}

const sc::String& DirEntry::getLastAuthor() const
{
  return _author;
}

bool DirEntry::isNop() const
{
  return _nop;
}


} // namespace

