/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _DIFFINFOMODELIMPL_H
#define _DIFFINFOMODELIMPL_H

// sc
#include "DiffInfoModel.h"
#include "DiffInfoTarget.h"
#include "DiffInfo.h"
#include "Conflict.h"
class TextModel;

// sys
#include <map>



class DiffInfoModelImpl : public DiffInfoModel, public DiffInfoTarget
{
public:
  DiffInfoModelImpl(); 
  virtual ~DiffInfoModelImpl();

  void setModel( DiffInfoModel::DiffModel dm, TextModel* m );
  void setConflictCnt( int cnt );

  // DiffInfoModel
  DiffInfos& getInfos();
  TextModel* getModel( DiffInfoModel::DiffModel dm );
  
  DiffInfo& getInfo( int numBlock );
  DiffInfo& getDiffInfo( int numDiff );
  const BlockInfo& getBlockInfo( int numBlock );
  const BlockInfo& getDiffBlockInfo( int numDiff );

  int getDiffCnt();
  int getConflictCnt();
  int setActiveDiff( int num );
  int getActiveDiff();
  int nextDiff();
  int prevDiff();
  bool hasNextDiff();
  bool hasPrevDiff();

  // DiffInfoTarget
  void addDiffInfo( const DiffInfo& info );

private:
  typedef std::map<long,long> TMapDiffNumToBlockNum;

  DiffInfos             _infos;
  TMapDiffNumToBlockNum _mapDiffNum;
  TextModel*            _models[dmMax];

  int                   _activeDiff;
  int                   _cntConflicts;
};


#endif //  _DIFFINFOMODELIMPL_H

