/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGPARAM_H
#define _SC_LOGPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "svn/LogBaton.h"
#include "svn/Revision.h"
#include "util/String.h"

namespace svn
{
  class Revision;
  class LogBaton;
}


/**
 * Parameter class for LogCmd.
 */
class LogParam : public ScParam
{
public:
  LogParam( const svn::Paths& pathsOrUrls, const svn::RevisionPtr start,
    const svn::RevisionPtr stop, int limit, bool changedPaths, bool strictHistory,
    svn::LogBaton* baton )
    : _pathsOrUrls(pathsOrUrls), _startRev(start), _stopRev(stop), _limit(limit),
    _changedPaths(changedPaths), _strictHistory(strictHistory), _baton(baton)
  {
  }

  ~LogParam()
  {
    delete _baton;
  }

  const svn::Paths& getPathsOrUrls() const
  {
    return _pathsOrUrls;
  }

  const svn::RevisionPtr getStartRevision() const
  {
    return _startRev;
  }

  void setStartRevision( svn::RevisionPtr rev )
  {
    _startRev = rev;
  }

  const svn::RevisionPtr getStopRevision() const
  {
    return _stopRev;
  }

  void setStopRevision( svn::RevisionPtr rev )
  {
    _stopRev = rev;
  }

  int getLimit() const
  {
    return _limit;
  }

  void setLimit( int limit )
  {
    _limit = limit;
  }

  bool getChangedPaths() const
  {
    return _changedPaths;
  }

  void setChangedPaths( bool changedPaths )
  {
    _changedPaths = changedPaths;
  }

  bool getStrictHistory() const
  {
    return _strictHistory;
  }

  void setStrictHistory( bool strict )
  {
    _strictHistory = strict;
  }

  svn::LogBaton* getBaton() const
  {
    return _baton;
  }

  void setBaton( svn::LogBaton* baton )
  {
    _baton = baton;
  }

  ScParamAccept(LogParam);

private:
  // in
  svn::Paths       _pathsOrUrls;
  svn::RevisionPtr _startRev;
  svn::RevisionPtr _stopRev;
  int              _limit;
  bool             _changedPaths;
  bool             _strictHistory;
  svn::LogBaton*   _baton;
};

#endif // _SC_LOGPARAM_H
