/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.nxg.unity.UnitParserException;

public class Dimensions {
    private static final int ndimensions = 7;
    private static Dimensions unityObject = null;
    static final char[] dimensionIndicators = new char[]{'L', 'M', 'T', 'I', '\u0398', 'N', 'J'};
    private final float[] dimensions;
    static Pattern tokenizer = Pattern.compile("([\\p{Alpha}\u0398])|(-?\\p{Digit}+(\\.\\p{Digit}+)?)");

    Dimensions(float[] fArray) {
        assert (fArray != null && fArray.length == 7);
        this.dimensions = fArray;
    }

    public static final Dimensions unity() {
        if (unityObject == null) {
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            unityObject = new Dimensions(fArray);
        }
        return unityObject;
    }

    public Dimensions multiply(Dimensions dimensions) {
        if (dimensions == null) {
            throw new IllegalArgumentException("Dimension must not be null");
        }
        float[] fArray = new float[7];
        for (int i = 0; i < 7; ++i) {
            fArray[i] = this.dimensions[i] + dimensions.dimensions[i];
        }
        return new Dimensions(fArray);
    }

    public Dimensions multiply(Dimensions dimensions, float f) {
        if (dimensions == null) {
            throw new IllegalArgumentException("Dimension must not be null");
        }
        float[] fArray = new float[7];
        for (int i = 0; i < 7; ++i) {
            fArray[i] = this.dimensions[i] + f * dimensions.dimensions[i];
        }
        return new Dimensions(fArray);
    }

    public static Dimensions multiply(Iterable<Dimensions> iterable) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        for (Dimensions dimensions : iterable) {
            if (dimensions == null) {
                return null;
            }
            for (int i = 0; i < 7; ++i) {
                int n = i;
                fArray[n] = fArray[n] + dimensions.dimensions[i];
            }
        }
        return new Dimensions(fArray);
    }

    public String getURI() {
        StringBuilder stringBuilder = new StringBuilder("http://qudt.org/vocab/dimension#Dimension_SI_");
        for (int i = 0; i < 7; ++i) {
            if (this.dimensions[i] == 0.0f) continue;
            if (this.dimensions[i] == 1.0f) {
                stringBuilder.append(dimensionIndicators[i]);
                continue;
            }
            if (Math.floor(this.dimensions[i]) == (double)this.dimensions[i]) {
                stringBuilder.append(dimensionIndicators[i]).append(String.format("%.0f", Float.valueOf(this.dimensions[i])));
                continue;
            }
            if (Math.floor(2.0f * this.dimensions[i]) == (double)(2.0f * this.dimensions[i])) {
                stringBuilder.append(dimensionIndicators[i]).append(String.format("%.1f", Float.valueOf(this.dimensions[i])));
                continue;
            }
            throw new AssertionError((Object)("Dimension power is an 'odd' fraction: " + dimensionIndicators[i] + '^' + this.dimensions[i] + " (funny, I didn't think we had any of those in practice)"));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < 7; ++i) {
            if (this.dimensions[i] == 0.0f) continue;
            if (this.dimensions[i] == 1.0f) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(dimensionIndicators[i]);
                continue;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            if (Math.floor(this.dimensions[i]) == (double)this.dimensions[i]) {
                stringBuilder.append(dimensionIndicators[i]).append(String.format("^%.0f", Float.valueOf(this.dimensions[i])));
                continue;
            }
            if (Math.floor(2.0f * this.dimensions[i]) == (double)(2.0f * this.dimensions[i])) {
                stringBuilder.append(dimensionIndicators[i]).append(String.format("^%.0f/2", Float.valueOf(2.0f * this.dimensions[i])));
                continue;
            }
            throw new AssertionError((Object)("Dimension power is an 'odd' fraction: " + dimensionIndicators[i] + '^' + this.dimensions[i] + " (funny, I didn't think we had any of those in practice)"));
        }
        return stringBuilder.length() == 0 ? "1" : stringBuilder.toString();
    }

    String toConstructor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new Dimensions(new float[]{");
        for (int i = 0; i < 7; ++i) {
            stringBuilder.append(String.format("%.1ff,", Float.valueOf(this.dimensions[i])));
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    @Deprecated
    public float[] exponents() {
        return this.dimensions;
    }

    public float exponent(BaseQuantity baseQuantity) {
        return this.dimensions[baseQuantity.value];
    }

    public static Dimensions parse(String string) throws UnitParserException {
        Matcher matcher = tokenizer.matcher(string);
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int n = -1;
        block10: while (matcher.find()) {
            String string2;
            if (matcher.group(1) == null) {
                string2 = matcher.group(2);
                assert (string2 != null);
                if (n >= 0) {
                    assert (n < fArray.length);
                    if (fArray[n] != 0.0f) {
                        throw new UnitParserException("Malformed dimension string: " + string + " (repeated base unit in dimension string)");
                    }
                } else {
                    throw new UnitParserException("Malformed dimension string: " + string + " (number without preceding character)");
                }
                fArray[n] = Float.parseFloat(string2);
                n = -1;
                assert (n < 0);
                continue;
            }
            string2 = matcher.group(1);
            assert (string2 != null);
            if (n >= 0) {
                fArray[n] = 1.0f;
            }
            switch (string2.charAt(0)) {
                case 'U': {
                    continue block10;
                }
                case 'L': {
                    n = 0;
                    continue block10;
                }
                case 'M': {
                    n = 1;
                    continue block10;
                }
                case 'T': {
                    n = 2;
                    continue block10;
                }
                case 'I': {
                    n = 3;
                    continue block10;
                }
                case '\u0398': {
                    n = 4;
                    continue block10;
                }
                case 'N': {
                    n = 5;
                    continue block10;
                }
                case 'J': {
                    n = 6;
                    continue block10;
                }
            }
            throw new UnitParserException("Unexpected character in dimension string: " + string);
        }
        if (n >= 0) {
            fArray[n] = 1.0f;
        }
        return new Dimensions(fArray);
    }

    public static enum BaseQuantity {
        LENGTH(0),
        MASS(1),
        TIME(2),
        CURRENT(3),
        TEMPERATURE(4),
        AMOUNT(5),
        LUMINOUSINTENSITY(6);

        private final int value;

        private BaseQuantity(int n2) {
            this.value = n2;
        }
    }
}

