8.1 リスト

# リスト

このセクションでは、非常に有益なデータ構造であるリストについてみていきます。すでに大まかな方法で、音符をリストから無作為に選ぶことをランダムの章で触れました。

```
play choose([50, 55, 62])
```

ここでは、コードやスケールを表現するためにリストの使い方についてみていきます。最初に、コードを演奏する方法をおさらいしてみましょう。sleepを使用しない場合、すべての音が同時に演奏されることを思い出してください。

```
play 52
play 55
play 59
```

このコードの別の表現方法を見てみましょう。

## リストの実行

1つの方法として、[52, 55, 59]のように、すべての音符をリストに配置することがです。使いやすいplay機能は、リストになった音符をどのように演奏するかをすぐに理解します。試してください。

```
play [52, 55, 59]
```

おー、これは読みやすいですね。音符リストの演奏は、通常のパラメータのいずれも妨げになりません。

```
play [52, 55, 59], amp: 0.3
```

もちろん、MIDIの代わりに元来の音符の名前を使うこともできます。

```
play [:E3, :G3, :B3]
```

多少の音楽理論の知識を持っている方なら、幸運なことに3オクターブで*Eマイナー*のコードが演奏されたことがわかるでしょう。

 ## リストへのアクセス

もう一つの非常に便利なリストの機能として、リストから情報を取得する機能です。これは少し奇妙に聞こえるかもしれなませんが、本の23ページを開いてくださいと誰かに頼まれることよりも簡単なことです。リストの場合は、インデックス23の要素は何ですか？と尋ねればいいのです。唯一、奇妙なことは、プログラミングのインデックスは通常、1ではなく0から開始されることです。

リストのインデックスは1,2,3と数える代わりに、0,1,2と数えていきます。

それではもう少し詳細にみてみましょう。

```
[52, 55, 59]
```

これは特に難しいことは何もありません。リストの2番目の要素は何でしょうか？そう、もちろん`55`です。簡単ですね。それでは、同様にコンピュータが答えることができるかどうかを見てみましょう。

```
puts [52, 55, 59][1]
```

以前にこのようなものを見たことがない場合、少し奇妙に見えるかもしれませんが、大丈夫。私を信頼してください。難しいことはありません。上記の行には、`puts`という命令、リストの`52, 55, 59` 、インデックスが`[1 ]`の3つの部分があります。まずはじめに、Sonic Piへログの中から答えを出力させるためputsを命令します。次にリストを与えています。そして最後に第２の要素を問い合わせています。角括弧でインデックスを囲む必要があり、カウントは0で始まるので、2番目の要素のインデックスは1となります。下記、みてみましょう。

```
# indexes:  0   1   2
          [52, 55, 59]
```

コード`puts [52, 55, 59][1]` を実行してみてください。ログに55とポップアップされるでしょう。インデックス `1` を別のインデックスに変えてみてください。さらに長い`list`を与えて、どのように次のコードで使うのかを考えてみてください。なんらかの音楽の構造として音符の連続を表現することができるのではないでしょうか。




