/*
 
 MIT License
 
 Copyright (c) 2019 Harry Lundström
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
 
 */

#ifndef snibbetracker_noise_table_h
#define snibbetracker_noise_table_h

int16_t static_noise_table[44100] = {7063,25593,21601,-18189,-1907,-32485,26101,-16239,16073,-6065,19459,18893,-8883,-24345,27041,-20553,-30785,19843,-5493,4629,-6631,24583,27015,12867,-29075,5123,24705,-14845,-29121,-30601,31983,19215,-26017,13985,20421,6441,-28583,23937,-29929,21243,-8737,1191,16545,1245,-5335,20067,14365,-17179,8127,-3369,-23255,-18329,14139,-4137,-1941,4455,5313,-27941,-15947,-5071,20149,13293,9635,-27655,19079,-591,-4995,-10389,25797,-9857,-575,19179,17051,-22057,-6409,-5453,22709,-23135,-28687,-14433,-705,1751,-12291,-30757,-17891,-32535,-9323,-10809,-10795,10605,24765,8575,10413,9423,13973,12977,-6955,4987,-16471,-24759,-5555,-5319,-29333,3025,26569,-16181,-12239,-3167,-14623,17557,13229,-26143,7871,28425,-11655,-9487,-30623,9657,19739,-13241,-17083,-29679,421,30073,7803,-18751,-19919,13075,-10215,-447,7503,-9227,31677,-7015,-31541,28453,409,30711,5355,21075,-8901,14601,29551,-31749,15435,2853,-28537,6795,-29675,753,-4179,14505,-3947,17233,-26535,29809,-10701,26005,-4917,-1921,-6443,-27437,18895,-19019,10261,6493,-3555,16535,19887,16529,-4747,25095,32079,-9495,-7989,-2993,16147,-11687,14487,4703,1431,-26483,-647,-20933,14473,17549,31097,-6825,30765,-15523,-15387,24459,20675,-5525,-13667,-17767,-275,10461,-23273,3169,-26109,-27249,20675,8705,11525,15921,-14085,16637,29395,16659,1591,-1069,28519,947,-8933,-29785,-3035,32339,29537,-24725,-26033,30637,-6145,-16689,-20591,7437,-1061,-29643,-28657,6333,-4557,-3037,-17165,-20547,7093,-25601,-10533,26441,6099,1381,-14223,19325,-20043,-30585,-1091,6521,-3699,8835,-20301,6205,6393,23605,32255,10775,11367,-5677,-2691,-27367,17431,2159,-21393,28165,-13833,-9187,-22501,-5399,13687,-1235,10167,-3527,-2163,13179,-7651,31289,19425,18027,10483,19191,-17033,32375,32573,-22753,28717,28877,28401,-32203,-22029,-3849,-13587,20115,21465,-25415,-937,13063,1721,4957,-4625,-13335,-19327,4969,13023,-29451,-20059,10541,-4867,32483,29703,-25981,-19913,1331,15865,21429,-31041,-20331,-29029,-8523,4845,27675,15935,-25527,-11789,15751,6571,8235,-17655,5955,14827,5119,31321,-24041,-6195,1077,-5427,-13461,29281,-867,32477,7945,-30821,29381,4005,-5105,-28293,-15213,20267,-19317,-12285,-4073,23123,6297,-25551,-5431,-5509,-11085,-4401,19917,-8109,13161,-13347,-26331,-399,-30699,24453,-3107,3723,28589,-9597,28955,-11411,22441,14773,-25901,6421,-23119,31797,-19565,-7197,1927,-13637,10875,-19677,26625,9389,-10153,6625,3937,17349,19499,-23391,-14641,-11237,-7159,-10579,-29679,22341,25161,-20281,27557,10995,-31775,-30733,-21549,15917,-24013,23735,-16469,-1469,3027,-2849,-9509,419,22417,3219,3935,-13009,11879,6371,-6597,-17207,2599,8297,-32247,-16465,7035,3411,-25743,-10745,5779,-1543,8365,-6725,-2959,-10515,10231,-17675,-5963,-22145,-30967,-9853,-10031,24335,-23927,-29389,-25795,31215,7259,23421,30977,15179,22241,-1703,-6457,-27781,7553,-8959,-715,-30187,-17321,-28941,30105,31829,-20509,13713,26783,-30361,9903,17537,18765,26175,-27905,8395,-23735,-18275,8291,14869,16317,23685,-11631,-21791,-3961,-20691,23789,-9565,-28829,12077,13731,16735,-8943,9713,-16689,-14231,-13931,14613,28401,18227,-30561,9343,-10515,-1597,4869,25131,-12183,20753,-397,-9373,-18719,1435,-17741,-6685,11569,-29033,1363,31915,-15987,-24827,28229,12209,-421,-23839,-11519,27575,-7701,-26955,-1,31005,10005,32367,-22901,-21011,-2405,12957,-26639,1955,21853,2025,2167,22453,-5545,-21711,-21649,-30659,-18627,-9855,20509,-29619,-20723,-9631,-6699,-7141,16817,27377,5171,8867,-481,12775,8905,-18285,28041,27465,30579,19143,18733,-5733,25647,-1079,-12405,-30985,28949,12203,25335,24693,-22921,10823,25161,23321,30805,14245,17009,-12737,20937,31059,22393,-25561,31219,18235,15981,25257,29341,-11369,-14895,-20447,-9011,-13237,-12671,9469,28693,21579,-14167,32233,29663,3547,-28129,-21525,-26619,-14001,13987,-19719,26387,-11289,-21323,20741,-14777,-93,-4493,-30261,-17721,-18157,5989,31621,24149,-2877,-8161,-27525,-9841,-16959,15021,18579,32649,-17977,-29225,-24035,-23627,26033,5031,-9229,-11589,23929,-22693,-19067,-15591,4697,26077,19273,27485,-30795,14133,-29465,-71,-30127,-30079,-26517,25239,-26705,-527,26881,-11603,7665,-31095,-10997,12965,-20635,-15283,24053,12841,9357,-24701,-20763,-24771,-479,5111,27065,-5643,30383,899,27043,18947,-5703,16167,-9431,9137,2659,-31703,11691,13699,-4605,32155,14999,-28205,8305,-7807,22835,-8977,31377,-1983,10915,-14377,23873,26305,7207,-8701,18775,-20037,-11707,13727,7353,-21955,-6473,-29151,-25983,19327,-25947,24879,11097,-20897,-30925,-15221,12541,17327,29903,-24531,13811,-29447,-8747,22025,-31747,-27113,28551,2587,22541,-23463,-29931,28107,16979,21323,17293,-14765,11617,-8351,-7587,1443,-25975,9565,-25797,-26581,-31979,30175,-28489,18999,31821,-22455,-21423,-19529,24699,10793,-31693,-29661,-6011,8331,8761,-21295,13209,16371,10319,19313,-13469,16819,12391,25625,-29423,-7835,30913,107,4063,-6325,28735,21031,12377,-12573,13717,-30017,-17395,-11523,-23507,7431,-28479,-11613,29789,31101,-573,-15639,-13419,23261,-30061,18423,24527,3601,27029,31647,-8035,13051,-24893,25121,11899,14021,-29955,-24287,-8897,10375,27905,-30741,-26011,-14617,12715,28885,-25919,-21661,-23101,-545,-11957,13941,4497,-11073,-2607,14745,6853,26885,-20445,-31795,-25939,17423,6007,7853,-13343,-25,-29827,31939,-23481,-9671,-29779,25321,26629,19277,-17045,24571,31409,-16217,-20721,-23069,12513,-18113,22969,-27127,-15501,29949,18477,21685,-6991,1769,-29569,-28225,-2891,25583,-4293,-29133,19405,-32035,-1521,-27679,-3529,-29895,-11707,-29629,-12703,2563,-4395,26903,26131,-32497,-18715,10237,19015,20379,6031,-19051,5861,-3571,-20141,8193,5263,29059,8183,28155,-28335,-4173,-32131,19387,-16757,13359,-53,15799,-17013,-26339,-19193,15869,-29961,3489,-17553,20557,-13561,-26051,-9799,-29111,-891,19409,-21523,-3073,27731,-29979,26827,-20907,-12709,26139,-23729,-5641,-7861,-16723,-6223,-20533,-9215,26745,-2687,32401,23883,-18273,11367,-13373,6743,-2035,-15591,21481,-1833,31341,-16713,22147,-22607,5599,-10041,-31773,23987,-19603,18737,-4361,23871,-3789,17155,31493,29401,7167,-25555,-5659,26463,-24401,-17679,-2997,24071,15349,7867,-28071,-30133,-22139,-10175,15587,19001,-20163,-16111,663,-14427,-29193,-9999,25433,31087,15729,-14501,-8187,8925,31131,-25533,-28809,29105,-7207,-23919,-23125,19403,7405,-17777,-23221,13329,-3599,-10823,3863,13499,31185,-28673,-1617,3407,31471,-13817,12361,-17471,15973,28273,-21545,23391,-32009,-15901,-15703,17219,689,-28215,-30677,8689,8981,2347,-6361,25863,25093,9643,-26013,10989,-10115,-12397,15275,13583,29875,-31373,-31425,20201,19133,-12399,-8111,-16919,-24169,24149,-113,-8903,19181,-1701,23371,27475,-9569,-27589,8737,-29571,-19041,19249,19689,27553,1139,-6083,-9153,9629,20933,2735,21041,6739,-7983,30939,24225,23709,15803,-24763,-14625,-2731,14723,-24079,14033,-11425,-7107,355,2545,-27655,-31215,24461,14727,-18819,-32335,-14161,-11277,26213,12733,12677,-6591,21985,-11807,-7333,4445,-15623,-9771,-15537,15839,-25291,31965,-27449,7913,-6905,-519,-13331,-4541,1637,-16529,-24909,-27783,25451,10465,25505,-3295,29211,-32439,9411,16137,23203,-21505,17677,14531,27105,22823,-1079,-2343,-6291,9919,-31073,-20873,-19715,-31163,29773,9275,14837,-24227,-25667,20101,441,5007,-26041,18295,-24557,-3853,-31297,4341,-12733,26379,13055,1875,29479,-4079,-17937,30541,26239,13209,24131,21247,-26003,11203,1635,2723,11537,-14797,-23915,24591,25431,-11029,26813,-31815,12809,-29309,19551,-20783,-24853,3777,25359,-31951,21627,4561,21485,-7407,-6333,-14079,-11035,-12521,-32169,-26369,12773,-31957,-1713,-26457,19951,24119,-26555,12729,5351,10969,4313,-12013,6909,-26105,-13657,2927,-24071,-32265,-10291,18063,-2101,-3605,22847,-6459,-21,23407,-30715,26665,15225,25665,-18193,4783,20013,-29145,18431,25747,-3999,-5559,-11915,-8709,16205,-26031,-28479,-19199,-7921,20725,6367,-26139,11135,-31585,29705,-12585,21733,-21251,-18031,-21333,-31371,29365,-11497,27051,20819,7409,-7905,-26585,-12513,-25901,22257,-8099,-13137,-31177,5153,25839,19295,7475,-1555,3241,-15077,-11431,10235,31061,-7031,-13695,24923,30021,-13975,-23275,-18479,-22633,-343,-25511,6113,22709,-27277,17241,-32035,-4537,26115,32639,-26321,14125,-32389,18213,-21475,1877,18721,11373,24555,19669,-3843,2795,-17483,4979,30105,24395,3069,-18999,18023,4955,22131,23323,9325,-131,13151,17399,-19823,-7965,247,19693,16035,3347,15551,3775,4019,14751,-26703,-23749,-7661,-313,24699,14699,20195,15567,-807,-20815,-17901,-2173,28523,-14993,-14511,3049,-21655,-7293,32129,-29173,-16535,23209,6627,6241,8683,31237,-6589,-2161,25767,14101,19587,-3501,-1219,4933,-5973,7657,30519,-21967,-3651,31077,-11591,-4149,-25067,6271,-2581,-17743,31275,-10711,-1935,29383,29693,-17749,-29515,22441,-7155,-10605,-3405,-31491,-29179,20997,-29841,-10007,10051,20045,29617,18265,3333,-16445,26369,16907,-3671,11095,5921,233,-24039,-25543,-17617,-21939,21081,4653,-11561,-15125,-30717,-12291,-21349,-22531,21467,22003,-5421,27693,9715,30949,9445,10837,6939,25371,27939,5549,-14657,-28245,12221,8569,19367,-19241,26795,-28569,-3891,-17019,2433,-15837,17815,-20229,-20101,-15703,23531,-27327,19197,14533,-10915,28169,-5253,21841,8973,-14485,9187,1409,12861,16743,-22527,12711,-19631,11931,29545,931,31007,1979,11035,-6729,-11441,32099,-231,30873,-17287,29029,30923,13335,-6335,-6237,4365,3635,10901,22313,573,-13579,15329,19573,15953,-6299,5439,-18403,20115,-23441,-13175,-5207,12475,-9239,11547,-1979,24751,-23073,-29181,-7519,28721,30027,-27395,2999,-1439,-17093,13711,-6107,18443,-20119,-3149,-725,-1003,-19855,-7109,-18487,-17359,-6207,6147,6767,21043,28493,3505,30921,983,-20699,25887,1279,-11547,20667,14669,-8311,17011,14473,17539,-27479,17861,24847,2769,-3401,22165,24933,-1889,14955,19125,-28269,-7969,-7583,-8375,-3395,-11867,9577,-19813,-19311,3817,-21229,19423,-1381,-23689,28301,-2591,3209,-9013,28671,-31559,12145,-18383,26639,28107,25009,-29527,17379,-3767,-23045,-21061,24097,-22993,-729,-15517,21715,3781,17991,-20523,-32297,-16617,21573,11301,2957,7683,7853,-26771,-3557,-30753,-22875,12919,-10219,-14653,-21529,25463,15077,-32439,32509,20551,-29427,-6695,-32255,31889,10617,24805,29867,-17811,-20509,6979,-18865,-19291,29543,-24111,597,-10175,7671,273,-4969,32071,-16527,9489,27583,-28145,29363,32079,-7507,-27063,-4917,-31741,19313,-20453,24225,-24733,-8555,-4909,-16309,-2669,16941,28929,3913,3781,30605,-26497,7133,21571,-21375,2341,877,28653,3691,32367,27021,-30305,-27413,28117,-24507,-20103,16271,-19001,-28103,23341,-17783,7531,16617,8031,19015,16123,-9531,13601,8385,7111,13581,-10295,14327,27,-5727,-6789,32073,16241,-19695,-14541,23035,22843,8849,27843,14233,8811,15773,6023,-23483,16563,21693,24441,-7777,30921,-14857,-30527,-13665,-907,-6163,27379,25689,11337,14939,2281,-2853,-2341,26261,-18137,2625,-16599,-6359,-23261,21563,409,32109,-22691,6665,9467,-29733,21867,-15783,-11749,-12743,-30317,-30777,31207,14615,11785,-2767,-6391,-12045,-27501,-23203,3189,30379,4417,-31391,17797,15223,-19911,26613,-17061,7427,25645,-13965,3627,-19719,20697,-3791,16777,28039,-9629,-31309,10459,16361,-22731,2885,-21637,-23885,8639,-31665,-4425,-21289,8651,23633,-15319,-4179,10567,-17723,14031,10621,-12943,15083,6171,15987,-1685,30163,18703,11179,-6821,-23411,-31867,-9943,-11465,11889,-24901,-27577,5939,4919,-31817,8245,25729,28401,-30717,8089,12891,-7991,21751,20261,2725,-20095,10415,-23877,15181,15527,-26475,-2345,7509,21579,-7615,1221,4339,-15189,13435,6169,-23867,-2491,-6271,21989,1649,-7123,5761,639,-13083,29375,-30409,-7193,16247,-19703,-7065,-20271,8787,13943,-32527,-24767,-13547,13753,2425,-20019,-15917,-28321,-22707,2613,-11689,-5393,-21817,-15759,20761,-4457,-11631,-14975,30891,-3551,13055,-4657,12095,-29597,23475,9339,-17287,2709,22753,-12767,23233,-7307,-17167,-8723,-8803,-7417,24471,-25121,22541,-22937,6975,27075,30027,22691,16981,-6465,-22553,-13579,4919,22585,-2189,14647,-1729,18719,25907,3033,28869,-31185,-8835,-16679,15833,14753,13987,-13539,-28539,-24413,-8691,-20023,29599,-4375,-4577,-17091,-18765,20085,-27651,29221,-197,14565,19167,-26133,-24859,18561,-16709,26671,-13359,31667,16007,-13733,-22401,-21879,29763,4419,-8453,-23497,-6403,-30795,-15929,-26577,-3371,14513,-5101,-31349,-5767,-25165,-18847,21023,15215,2997,21149,27687,-26373,-10617,1101,9537,-21561,16507,6565,12281,22615,25427,-9707,631,31705,-22441,-24417,-11327,-16779,28643,-11343,-15001,28563,-5267,2571,-4313,-29903,-2041,-29267,1731,-29301,-4729,-14999,-4057,14787,16723,22789,22833,29863,-26567,32161,-18321,-5915,-24023,-2337,-26491,-7485,12761,21535,-13351,-25033,-12667,16657,-22631,-27165,-3183,28009,-13119,21107,5473,25673,-2573,781,12003,-3169,15983,-3989,-16629,-6353,17665,-1963,14741,13409,31809,23935,-2607,6635,32253,19011,28143,30461,-9211,32143,15759,29075,19773,-11023,-28047,-4901,3711,-24643,-949,-31809,-19789,32291,-2351,-5131,-26037,2085,31643,-16421,29291,-15815,-7097,-23839,-3921,18655,-4527,-3339,31415,-28021,10859,-29259,6953,5853,-4581,-8475,11539,16399,27593,4519,-14265,26143,-26105,217,9295,-15947,-411,12893,7969,-31141,15439,20735,22561,-17637,-28179,9431,-27363,24219,-14297,20527,20245,-19743,-23737,18143,-26557,-15915,14571,-24079,19041,-6713,7255,22807,-5727,3775,-14861,29531,-31703,12117,16637,21399,-18899,-7017,5687,8305,-22301,31795,-18125,26347,-28447,2413,28893,-20709,-31269,32295,16319,9047,6977,-5425,-29881,24499,-209,24481,24847,-10327,25803,30639,-21847,-11449,-29929,6661,7591,26427,24285,-5657,-20319,-14369,27291,-22167,-8501,-26147,7751,-29847,19403,-2023,4207,-24915,14021,-20757,23921,24829,-21465,519,-6093,13575,11735,22095,23183,-28589,-10233,-31583,-4013,32215,-13329,7823,-8197,24227,-10487,30347,-24999,14233,6689,4513,10007,13505,12757,32563,-16425,27393,14587,-3357,-911,-2233,18513,-7789,16187,1461,-24379,24939,-10205,28187,-11481,14549,8313,-11517,10111,-91,12209,4345,1107,-21987,-22513,-7313,24669,12163,10677,-9557,-26543,-30449,-25183,8145,31215,27033,-30555,21277,-28171,7517,-32275,-25391,-9993,1939,5145,9483,-26295,-3757,27325,-28455,1129,-32159,-169,15221,-32407,31973,27261,6741,-31615,-10071,-12237,10503,16967,9813,14935,-9963,25061,11323,-28385,6845,6449,31307,-16547,1601,5641,19639,-31681,-26871,18069,-16975,2731,13155,22079,14465,16191,13555,8867,-15905,30083,-11991,-17329,-31537,-22315,-20061,-13533,-12777,-7009,21847,-27855,12443,-10477,-20315,-31961,-5821,-8569,12541,1215,21509,2625,11501,13151,31629,31229,-22325,11075,-457,-19319,26085,-19883,32439,-977,16857,-10575,28381,10187,25899,-2087,-25805,-5915,-8415,-22331,-21907,-25603,19775,16819,23851,30889,-13347,-2687,-24715,27897,14871,29929,-23765,6487,10437,-23097,19595,1391,18439,29181,-12901,7973,-25903,22659,-15651,-18083,5595,28467,-29605,3379,26529,29255,30401,29989,-24833,2353,8329,-16631,-24001,29417,-9325,29481,18497,-15947,-19587,17163,-29503,-31871,8789,-8497,28845,22075,2359,-10097,13553,28195,-22971,-17617,31803,17557,-19357,29953,29517,-22309,16825,-27891,-24129,-17177,-24707,-30481,-30849,21983,25511,22065,28903,8165,-22195,-18133,5381,-8409,-263,29587,-16125,13299,28413,-12325,-17115,-28255,30435,6829,-2357,4107,11061,-26973,26193,31587,-24017,10283,-13253,155,30619,17641,-5161,5797,32559,-18133,27483,6425,-30111,-26019,-15745,-26725,-20959,29511,-1339,23273,22015,-13467,-5065,-10219,-4091,28125,-28247,13909,-14369,-31285,6775,27005,-23021,-23683,-3611,-32547,29351,26163,-22041,-12901,5621,15787,25175,-4389,-5193,-18377,-23543,-26489,7795,-2065,21127,-6487,-11825,2543,-12623,25709,12059,21115,-18265,16539,28945,3659,7915,-13833,-6921,-30963,-21579,-25699,-20887,5171,-19975,-10905,-1701,31921,1483,2563,-11923,-11115,24865,-6805,18985,32259,-12037,-25329,3847,14527,28143,30893,-25279,-18995,27779,2207,-21931,29055,11543,-7025,4459,-30623,21895,12283,-12599,-32281,-1855,1931,5541,-8663,-15467,17867,-19033,-21167,20921,7127,-25283,-18409,-30755,14451,-7743,4099,-4165,-30213,4667,-8501,19877,-29337,4831,-19417,2373,4961,5877,-7931,-4765,-27397,22501,-26667,-5431,-11893,-27523,-5675,31833,-31295,-12071,15203,-15133,-13661,26807,-5061,-14613,2041,7681,27301,17271,1933,-31251,-9775,-24939,-22933,25379,32305,-28941,-22879,22733,6875,-10707,-16007,-20515,24897,-15329,22851,17645,16615,-15327,12505,-17349,25309,-31435,-3567,-16795,25355,23845,15651,-19705,13791,-28475,7213,-22385,-20815,20073,-14169,-1097,13525,-30731,17999,-17885,6105,32629,-11005,17273,-31757,11681,23779,24347,2409,-20493,19987,-29281,29329,-20313,14083,21069,4603,8585,-26281,-17545,21583,14343,-157,-17479,14747,-19275,-26867,-26179,4137,-23343,7805,-27749,-1645,-11891,25527,25755,-15293,-30131,4079,3701,-14291,31763,-16153,-3423,-4529,22555,12241,22823,937,2575,12355,6883,-10887,26873,-24147,9285,-15173,27477,-14873,29889,8725,13743,10775,21485,-7151,-30097,-10995,-19789,-22295,-15089,4777,-3381,31539,25271,-2371,32321,1295,-10075,-8415,26349,4649,-6081,9247,30127,-4773,32189,-3669,-5209,-16715,-14391,10885,17923,-30887,15907,9929,22053,21049,14161,-18891,1389,5129,11221,-26173,-25597,-11293,-27929,27,-8943,1503,5795,3463,-18603,-20641,21935,12315,17517,-2247,18065,-8233,16843,19019,25149,-32583,-29277,6397,31575,19933,-18431,-14253,20901,14345,-26647,3107,-20959,29305,32505,-8611,21923,14441,-28965,4801,4623,25551,-24477,12773,-30565,-2135,20257,5301,19551,-9829,-8303,-31423,-14559,-11643,-23505,-13011,-10381,-24883,9145,15665,463,-17313,-8801,24757,127,16367,25167,13391,-9561,-25165,-27,-2071,27123,-16143,-20727,-5841,-9653,6549,7807,-15293,-6801,-18597,-29977,-14651,4345,13559,483,31907,-30299,24027,-9321,17371,-22747,-8269,4901,-6839,-293,-11663,-18375,27645,-9419,4177,233,-20363,22383,10127,-12403,-21989,23033,-501,12623,3185,-15961,15311,20533,-9423,7477,5035,-14163,18081,-23253,5511,14659,14933,31927,-24777,-31257,16675,4427,19585,-15207,-15537,9135,-21085,15559,-3851,-5343,-30409,13961,25719,-7519,30029,9347,-7421,-31397,-26211,-31257,17503,24219,-10101,1919,-22987,-30177,-25671,-4911,21339,-31927,-32219,-29421,-28145,-20665,-16691,5161,7987,-3553,28369,26633,5861,-11749,29763,-16137,23763,169,2595,22955,-16477,15363,-15323,-17123,11119,19161,-14321,-9911,13141,-13611,-2147,4129,-12439,-22487,-11269,-21621,-5663,20813,32639,17535,-6391,-26053,-7291,-13253,-4089,-523,-23911,-26777,28807,-25587,28121,-12199,-5225,-2829,8079,-26917,23195,-26479,3623,-18975,-26609,-24021,1965,-12897,9675,-6987,-23105,13563,11875,29169,-31907,-4983,1141,19433,-17449,-15983,-19345,-21033,21079,-31101,-18415,-13827,26641,13541,-20563,20783,-19349,-24825,18321,-23377,12531,24305,14813,-31773,19301,-27719,-12525,21619,26507,-8245,21039,22013,23513,-3213,-14119,-2135,13861,-21421,9461,1587,-17491,-7833,5533,-19631,8903,16145,12267,-1395,11189,5913,18811,-10177,-2509,24489,27875,-22267,-5475,30265,-17931,9337,29641,-23619,-31475,-17675,-16007,23787,15835,-17815,4445,-10701,14355,20133,-6095,-27443,-10547,4479,12151,6701,15715,17433,-15097,-13145,-30387,-20235,7131,26805,2567,1913,28485,3843,30323,-29331,-23247,1161,-25735,-9385,-7733,-15765,-21339,21793,-14493,-21929,-21739,-19419,-16687,8617,-13375,28841,19447,3839,10841,-1297,17215,-24215,-23409,26281,-12223,-11611,11891,-27995,-9307,-17893,-20743,4275,-117,-29021,-16701,25981,-19537,23339,7063,14561,5461,26711,-8833,14011,-12769,-8547,-29879,-5173,-823,-30009,-17189,25879,-13035,-14413,13681,-29445,22013,12019,12395,-21673,-25037,-6703,-13253,-8223,-21895,-19619,27045,-12919,-27553,13269,31807,7337,26043,-18807,-27925,-3781,-5887,6621,-13289,30067,-27631,20737,-791,-13553,-11891,-6113,-2727,15067,-8373,12067,-20759,-23161,-55,-23755,-21121,4669,4429,-15363,-24291,1277,23859,-22665,13867,20039,-1359,22233,-11809,25451,-18195,-27279,-16599,-5833,-26027,-27517,-27441,7153,20045,24213,-22305,-32479,21533,15223,-16913,24641,549,25033,-3369,-11645,5121,22427,31629,10277,13707,-4195,-21201,-24195,-19901,-8061,12611,3121,7715,25903,-16067,25565,5893,453,-11557,-14007,25755,-16613,6127,-7225,-3297,-1847,6729,-19155,14997,6635,24861,28571,-7213,-3901,5587,-24135,12217,-2195,-26041,6755,10263,-27717,23141,22029,29031,-3557,27653,-30227,-13477,-31161,24729,-27739,-28673,24131,-23359,8795,26327,-19513,9269,1613,31247,25473,-16753,30563,1147,-18767,-7443,-3605,7095,16017,-25911,-16189,-18567,-3191,29171,-14595,-9799,-18385,-27977,-15789,-32473,-23015,5157,19171,9793,29367,11089,-12397,10069,15091,-11963,-20901,30525,5993,-10737,839,-19855,-29909,30711,-12337,-30737,-539,-18969,3065,-9075,19027,-28275,12919,4467,32275,12155,19249,-29315,-24885,-21907,18589,-7677,-15493,31017,32363,-20601,25261,25109,14611,-18295,-29375,13285,-13109,-27577,3635,-3653,-11521,-3137,8955,28231,7391,20013,28747,24129,-8285,3407,-20753,21383,-6401,10681,5657,-23509,-31057,-27839,-4417,-1789,1493,-23787,25703,-16365,-5585,25053,8829,-12355,-5079,1149,-28741,-27145,8907,-4905,-18177,9143,-12191,3819,3617,7757,16799,7181,13737,-28677,-4113,-16499,15379,-1507,26835,-15205,13029,8947,7647,-15957,27033,-9807,-20585,-27299,-12727,-25813,-25793,2455,-32655,957,9555,11487,-4455,7867,11831,-12603,-30763,22657,-22125,-27155,-26831,-12381,32305,-28331,-22629,32427,4191,-19755,28923,31579,-31885,26975,-6915,6733,18437,19073,12671,9225,-25517,-32537,4955,31107,-22165,-32621,-16301,14785,-19129,7827,3119,-17775,15089,-20869,25941,-24657,11355,-13087,-28339,-18335,24835,-12633,-4267,-23991,-12643,10901,-21789,29279,-31667,25449,-32083,-21497,-18991,8131,-13185,25185,-22275,8617,-23691,-11759,-12655,14973,-25035,3545,3559,-24611,-3001,-5059,28585,-13019,-1609,14675,-27255,-8719,-9441,15179,23541,10435,-9847,22077,-25253,31909,10035,6795,25787,8879,-8511,10967,-31307,-14391,-11337,17517,11303,-15263,31337,-18953,4335,-18129,-31741,-31667,30621,-4097,12847,-17161,-29563,-14205,-14273,21751,10253,5351,3637,-26109,-20773,15933,10567,-29421,32429,-27347,18759,31019,-17699,25655,30435,6929,-25303,26589,-25849,31327,6339,-22563,795,-24923,4121,-14073,-16161,20147,-22097,-31883,-13871,-26381,-5209,-8907,-27867,835,-20943,29007,7555,29677,-17649,18893,-9821,-5611,-22617,23371,-28429,-25723,-11499,-16501,-13997,-7397,-25989,-21995,-7225,-12373,-30001,27663,23087,29185,-10655,-1841,-25973,27481,31743,26181,5141,5609,16225,-22775,-27009,-10525,23943,12883,-24273,29239,12409,4537,25915,-18521,3063,9867,8821,-8529,-32645,27969,-12969,-28935,-8839,-5991,16267,-28181,30249,21553,10743,-5803,30727,8735,4381,9083,9201,30141,-16709,25331,5761,5669,-13667,-21649,-31599,-17133,-27481,4319,-31557,-29455,-21803,14263,27525,-6605,-10357,-32235,-12661,-22509,16595,-18013,11489,21287,107,763,30001,7749,-6075,-11031,-12729,31273,3115,30291,4941,-12751,-21689,19885,23019,28109,-9579,9501,14649,-31749,14755,1249,-6639,20287,-19915,21527,-19909,5461,15113,-22001,14539,17499,30773,-22419,12795,11621,-1897,25993,1929,18187,-11625,32687,-17715,18665,-11489,8221,16909,16261,8019,11795,-31217,-28421,1381,1711,25213,-11935,2687,-8859,-9983,22119,25453,23183,25873,13505,-32087,-26233,7371,-6181,-31443,-29923,-18423,-20331,27539,30007,22105,-15771,-3991,-987,28387,407,20959,-15785,-17643,11355,7931,-18151,-5563,-3667,-29943,29125,28061,21327,24541,-31915,-26549,10543,-20559,13525,27711,-15419,31687,16717,-601,-18263,-8405,13807,-6197,15307,29839,6909,-26777,22645,29235,22437,3263,-13929,-26205,-1553,25389,-2213,8533,2937,-2517,13583,20885,-13411,-31799,-24243,27201,-21283,15149,-5099,16023,8959,-26845,953,19735,-2653,14917,19959,18115,-23755,15753,-8443,-26359,-9513,8445,-13165,-28969,24421,-12599,-26119,17477,-8401,20135,-30579,22259,30581,-26849,-16775,-18371,-32589,-7701,-4145,-7861,-32203,-19661,16465,27685,-6907,7463,-29703,12497,-31605,22135,-29311,-28931,-3807,17831,-19971,2037,11559,25599,-19439,10209,6965,-917,28387,87,-10117,-353,10299,8403,-10905,14815,17493,1653,32153,-745,-16113,20327,-19807,-489,30989,22951,-9205,-12795,-31929,67,-8059,-2181,-25745,11447,31941,-29575,-6669,26343,-12529,21905,-20105,-13925,-20587,-11859,16183,8065,21675,-26485,20975,4773,4665,-4145,-25723,-19325,-16735,-15701,-12883,-23531,-14083,5439,-20097,-10641,-8001,-8023,12475,-2087,30843,-7469,16631,5705,-3895,-5083,13547,16159,-8231,-1163,15685,-29429,20793,28133,-3235,-8443,19867,-18337,6535,-30215,-4129,-183,-21493,-19491,7575,-29251,14485,-29765,10243,-6827,-8739,-26793,18853,-20879,3283,30159,24121,-7241,-6073,11671,-4499,5241,-11819,-12735,-23141,6175,-27581,21033,-17811,-139,17123,21831,29771,-10851,-12117,28381,-23865,3481,17513,6075,-24247,24083,13811,-19451,9397,-11993,15117,-24809,19223,-13243,24949,5967,-6309,-17439,8253,22745,-1927,-27421,29157,-28795,-6633,-23409,10375,-19979,-16633,-1165,-4719,-18701,-11379,26853,26501,15519,-14797,8129,21633,-27121,29973,-27847,13673,23257,19977,1349,-29083,19435,7529,-14553,28809,26155,-24977,3721,-10561,11769,-11745,-20619,-24843,27123,-29617,20811,-5593,-28023,-10659,18367,-3169,-13173,18281,6219,-28813,-31611,-27641,-10971,6761,-10269,-3705,-23977,20927,-14801,-4275,15887,4471,23543,-8913,-11301,-26467,3869,11575,28039,30891,10567,-14625,-2267,-30837,-2189,13749,2985,31949,-21305,-15129,-19669,19015,13739,21979,26109,-8947,17931,17431,8681,11569,-3183,-31107,-313,-18173,5893,-1721,15399,-14725,11473,22687,-4883,30645,15869,28465,-3965,2779,27711,-23649,-11261,-12315,32165,-4049,29663,21809,-10343,15955,24451,28251,2379,-21259,-19529,32569,31489,-31165,4917,-20397,-10691,-899,11485,21339,11639,-25339,14385,8305,-17621,-32479,7261,-21811,93,-26117,-24319,-2175,-16779,-19917,-4031,-14835,217,20879,17991,-11225,-7035,-25943,18357,-23319,7753,-6881,-6517,12939,8117,17883,7309,6943,-30623,-8161,-29695,20541,-14739,-20937,9523,5365,-20975,18181,-30791,-3025,-13111,27923,2935,-29585,11073,32255,4981,12521,-10481,-26975,-5837,-20705,-28185,-30221,27411,-28621,28629,-12459,-32629,-23087,1643,8653,-1863,39,-16089,-15303,9069,-11465,-25823,1237,9535,1683,-28401,11437,7083,5771,-29739,-7725,-27713,29965,27801,-17653,25495,10373,-8987,-16073,26283,10203,11867,17601,-26793,-28005,32663,-22131,-16639,-29211,4543,-657,23455,-11097,-847,-21999,-10915,27459,201,21699,-11549,-2497,20947,-2699,21387,-13857,-1575,-12413,22781,-2819,-23749,5031,-6699,-11101,-31339,-24021,25073,6993,12439,-5477,-3765,12723,-17737,1051,-30579,-27675,20971,5359,3043,24115,23941,-13661,18741,23561,8369,19605,-11821,4221,28829,13301,-6039,-8497,-21903,20197,-24495,-12325,-11749,-27153,-9719,2833,15865,-26559,19825,12597,-31495,19947,29407,-14969,-31045,-22203,-17735,30337,-12127,-24957,26733,-2625,-17029,28009,-11455,-6611,-32009,-13491,-18029,6329,-16459,-32115,13247,9711,29063,24271,5909,5727,-26147,1463,1495,21655,24717,-8479,26159,32375,31503,-8495,-1397,21005,31627,6741,25403,-13573,-16875,-17467,12563,-29399,6493,-1429,22603,-30675,-6659,-18677,-16397,28991,4621,-7707,21081,31391,18553,-16943,22189,-28387,-21397,15281,-27403,6245,17171,-30383,-7735,12363,32241,18401,-2223,27391,-15999,-20133,30323,23941,-19115,16389,-16953,-4921,-13969,-1985,-19799,2279,13525,-31837,-3785,10043,10537,-5423,12713,-4623,15781,-1719,2253,20189,14017,-13897,-10705,26007,31019,2245,-24051,29109,6033,-8767,19041,5019,11085,-27827,-457,-23531,-20737,-23377,14779,-15107,18909,20975,-7829,3681,-2727,7543,5331,-19761,-11329,27423,-23007,29225,3503,7449,12327,26645,17809,-4791,10265,20873,-1305,-8311,2567,16269,11623,29597,5237,-19175,20507,-13335,2015,23801,-4183,-1141,9087,3445,29635,3705,-1527,11465,14261,-4223,-18997,-8355,4257,-31797,5433,12549,-55,-17839,-10841,14615,9057,-19471,6855,-24111,25539,-22353,-2655,-24985,-4737,-20081,-27883,973,18637,-24855,-30303,14883,-28757,-8957,-11945,23969,-2595,3827,16787,14907,-24255,24173,17973,1077,13143,-31795,26495,-13713,-4475,12809,-5167,-14285,1663,18513,26967,-13377,-6387,32257,-29397,21133,21609,-11009,21233,9231,16259,32585,-26269,-29587,-7403,15597,-22211,-19923,32677,15767,17679,-24955,-2963,2055,-6131,9615,26419,29707,-19195,-13935,-7735,-11273,-27983,13731,4897,-10495,1427,-23485,-1165,-625,25309,-29043,28691,-7409,-30727,12469,30439,7563,28539,-12849,-31605,20453,15749,-4675,1843,21515,-17819,-14955,11729,-1461,-10135,-22775,-3933,16425,4667,-19619,-2707,19383,-5583,-6009,-22419,18975,22229,-15021,-26909,26699,-2971,-15905,32603,-4545,17623,26751,-25417,14509,-8085,25461,-26411,-29827,22097,-28633,-30021,-32229,7591,-13203,-29161,319,23345,-22459,-17617,-26013,16641,-13979,-9943,-4359,-6519,2817,6165,-23183,12617,26985,10105,26405,30987,-18377,-21227,-7633,-3683,9817,23903,10393,24059,9803,-8615,21941,-10067,2973,1489,29437,-1223,15813,24491,-28225,10897,-31407,-8365,29291,-21117,-13699,-21155,32623,30895,-7015,-32261,1193,-23097,28911,9309,22335,-6053,29783,5071,4987,-28467,-11679,-29417,-24011,-26609,24367,-995,28081,25625,-29479,18333,-26245,5993,-4925,-26279,14191,-2167,-13961,3751,-23555,-7421,32599,-873,-19197,20753,4445,-2077,-6853,3611,-22917,-30829,27447,5013,-25115,-13629,10889,30797,15499,-22889,-11023,-26531,31971,7521,31225,-14421,20973,-21769,-9233,-25839,295,30659,25413,10123,-8163,24419,32311,30603,24685,-29489,-17261,12091,-21257,20733,5361,-16863,6629,-15047,-15339,-13619,12301,17289,-14205,-19189,18293,11025,185,27263,28827,-21869,-2157,-16607,-22919,-9147,-4067,-11701,1999,12663,10205,10175,19871,-12579,-26923,10979,25429,-27677,-28769,-12441,-3047,25917,-22007,-28339,-445,27327,21029,-22839,-29153,6783,5411,30725,20015,-25887,-3879,-16155,-16825,-27169,-8789,-16937,4903,11327,-21667,6273,-17607,28777,-17447,15919,23281,21631,23583,-23095,-1285,-2351,-13637,29037,-27239,9591,26417,-21907,-21963,-2819,-29933,-9005,3487,-2055,-7753,13411,4691,-21161,-29199,29803,19071,-29351,7749,7273,-10515,-5041,-4615,16341,28645,20803,-6425,-39,-12015,14799,13185,4263,-12123,29861,-6313,-29779,22869,-31181,-16703,-4349,14075,-23895,-10995,2071,-4465,27799,13119,1365,-16989,31077,-9377,-14069,-28463,5787,-5455,-1569,-28255,32475,32311,-31613,2067,3253,-11335,-26855,-20663,-29235,19655,-16217,-15721,-7973,-11035,-23259,-15365,15,23225,1983,4149,-18531,17799,19515,-13173,-27641,6547,-6037,19573,-26385,-11017,5853,-24243,15599,19035,28755,16791,3251,18345,28911,6203,-25137,13513,26909,6961,-10465,-25141,-4051,3461,13023,-18227,17489,-11291,1653,-27925,10229,8385,-1859,-16851,4025,-7441,28455,-30447,8723,-11509,2161,-9475,-18987,18255,-26499,-32545,28463,19039,26401,-25747,-30433,-23739,-10451,23793,-15699,31291,-9235,20703,10499,26393,-27957,-14177,-12007,20347,8689,7935,-19743,30675,-16491,-30295,30827,-24115,18589,5307,2445,-7285,-26353,18779,-383,30063,-18359,9649,6979,-19115,25143,-2633,23079,31845,-14831,7355,2577,-16499,27823,14109,9843,5167,-21969,20009,30547,-20093,-11625,28487,-11155,9441,-9433,23597,-23647,6151,16837,-14399,12641,-10825,-28885,-5713,22469,8355,25265,10801,-11625,20551,9895,25957,-13985,16667,1755,2057,9605,-713,-7495,-15947,4683,-7005,19979,-16041,-16689,29945,-20611,-27985,-19627,25109,19143,16501,-26765,-16215,26003,-17007,-10761,-16343,29217,-15207,-30931,2143,12091,-9587,-4417,-9273,32233,5805,20371,5111,-23371,-9161,30269,-10551,-3339,-28067,-18461,20217,-24569,-15761,-12601,3707,31085,-8279,-24483,-16675,11937,11365,22927,29423,30511,-19361,-26525,19555,-4251,29891,29019,10483,30607,7443,32141,-16007,25405,24567,27431,-28333,16391,16661,-14417,26479,28881,-17703,26271,30375,-24321,22897,-593,-32543,-3481,-11023,-16317,4123,-345,32363,-10519,-7063,-28747,29487,-13523,27101,-5787,-28519,-11185,24839,4003,30959,26671,-20575,17871,-6567,27373,-16107,-14009,-18047,10243,-7355,16461,-28699,27485,26107,19867,-2805,30051,-30479,15659,-13929,27071,23245,11521,-20531,-31063,9123,-23441,1271,-12197,-28189,13017,6435,11419,28597,-29389,-25081,29187,10339,22263,-29365,-12855,-14519,18011,-12925,-17437,-28399,24343,-9051,-24303,6607,24337,1847,12705,1195,12241,8629,-10647,27367,-32455,19955,23417,32593,-17735,19197,5063,25087,29121,21043,25201,-18847,15813,-3945,-9747,-6815,2629,12529,-5783,28189,11359,8249,16663,22887,26899,8323,17777,-24405,-12909,18213,-30279,-27713,-27057,-11797,1531,-31287,-28727,24011,-23047,-8095,-13323,9729,1281,25135,-15305,23649,4717,15703,-2433,-9731,20077,-8375,-20947,-17869,5741,9753,-3721,32363,-9415,14721,8861,25055,24527,3383,16109,-10523,2215,-19167,8163,19351,20075,10117,28117,-8257,4813,22027,-22051,-19477,27597,12857,-6103,-18201,4121,26407,25921,32679,-31381,-6589,4589,-28703,-17247,-26655,-19909,-19447,15039,29321,22075,-2693,-4219,-1103,-12509,-11359,-29801,115,6077,18117,-9001,12317,24213,-27123,-1969,-4733,8623,30097,-20161,7751,-12733,20805,16509,-10279,30423,14753,27589,2885,30281,-28157,21085,17899,1825,-16601,12553,-9167,-12763,-19055,-3401,17281,-16639,22393,-32571,-16421,27545,-8355,3643,-4421,-8667,-17785,-16775,27177,31135,-3729,22355,-3881,-21685,24331,-6997,15827,-5739,2485,-7161,30875,15897,-4073,8925,-8713,-3697,-28561,-9615,-26039,-23343,-1911,-26661,2101,-20197,7485,13841,-32349,29369,-13641,19631,21957,9273,7539,-1367,6567,11403,17151,-32365,13421,-18801,-5457,12843,-21537,19049,-13,31193,32349,-4945,-21939,26231,6881,24105,-493,7381,-11825,9393,32409,-32677,29917,28091,-5163,-30589,-20973,3889,-3643,30091,-19659,4569,24985,-27001,-11313,18279,-32475,22911,-22797,803,-8375,-11655,-13275,25507,-31899,5719,24735,10725,14201,-3395,13993,18441,20841,-10159,11951,-26329,18739,22147,-15511,-23089,8861,1471,8863,-28619,3545,-21687,4683,-29555,16123,-28361,12601,22633,9493,16805,27081,7645,-31525,-27331,29543,23667,28439,19639,-28391,-21761,-323,-6629,-12515,17159,14563,32479,19143,8595,4465,-9689,-15487,-21871,-13179,-25891,27857,6103,11253,-17585,-6517,23189,2495,-13051,-20115,-527,-22871,7153,22093,-17601,-29667,23135,13167,-16037,-23715,-15619,7747,-29791,-22551,24331,-3031,27737,549,-14459,-14431,-20805,2531,-26299,8867,-10013,-28497,13827,-19117,-3355,4103,9335,-26781,-28695,-23261,343,-24231,20955,297,-9355,-19129,4935,20055,-8495,-6411,26679,-20643,22227,3613,16245,-10857,9961,25561,-417,-1129,10731,-11293,-29165,16871,23979,-26645,12119,-13165,28355,-1389,-26937,29323,-13481,13833,20389,-24593,-31365,-14931,16779,-2255,18897,9275,11505,-29133,30341,19099,-16445,24535,9303,26905,-3033,-1295,29059,32487,22787,-4861,4773,-20627,-21175,-3051,13661,30105,-22021,-895,9363,3,28941,-11639,-6755,9551,6045,-3691,-5117,27745,18399,-23289,1933,18985,31013,11763,32281,-30219,-26391,23503,10025,-1769,1303,7873,8101,31691,12947,10871,-1243,-6777,-23611,-24411,31941,24975,1081,7471,-12043,8117,-20823,21435,-13241,-20545,-13201,27923,1909,30995,-2731,12579,-30045,17871,-16329,-9243,20847,19547,-28457,-19259,31953,27461,-31877,26837,13325,16473,12699,29331,-25,29829,-13027,-6979,-12805,-2129,-21221,11859,9619,-23297,-4917,-14519,13243,10421,25063,27109,19659,-23837,22901,3493,20397,3781,-30011,2821,23847,-14161,-5789,-9547,11221,-16393,-32187,13025,12925,-17001,-30187,-1601,21175,-31581,-28121,-30431,-30981,24459,27469,17381,-30175,559,2007,32309,-13247,19031,-28719,-31043,12059,21107,9359,12131,-4071,-22109,32327,14703,-16515,24637,29779,381,29379,7033,18371,12587,-25057,28395,-4571,28711,1045,-11759,9055,-11243,8155,22167,32319,-32115,13871,15053,993,-29651,30663,-28787,-9547,13151,-17921,-9719,6501,23,-20709,-28293,-29915,-31751,-15239,-20369,6519,29481,30675,-26523,-30993,4895,-1521,-11553,1333,-13265,-25157,-7807,-15805,20317,10163,13547,-7721,22509,15913,2003,24615,23501,-989,21661,9909,4405,31455,-29227,-2525,14743,-15073,19747,20717,-20949,22121,-1337,-1223,21761,-29205,-12253,14061,-2827,-19391,-4635,7481,15257,28923,13395,6833,-4185,24335,-6169,-31371,27411,26379,2969,-3711,13391,13563,17057,-1523,8315,19025,-2195,-14135,-7577,18989,-26311,5065,-20143,-24195,30735,-2143,24185,11703,19333,4509,13293,-17839,-7345,3123,-9483,-14451,-32005,32493,9169,10391,26369,23259,-23273,4875,6309,-17859,-14035,7645,28449,-18787,-20373,-26625,15539,-14279,-26007,-14783,27657,-11281,-23165,-13871,-28975,-17437,-15205,11865,-12529,26463,-30275,6319,16443,-741,-5355,10587,-18177,-11553,75,-8369,-25883,-6893,-12107,-15387,-22245,-26619,13729,-21469,-16695,-8955,23309,31723,-17261,-5467,31421,11021,12749,29905,2189,12973,-10987,5225,-1547,4601,-28589,-25653,-19469,-5955,-18565,-25111,-7047,28277,-24701,7487,-887,16059,29133,19527,-24655,-14733,15733,27347,2831,-1677,-17085,5851,28863,-12167,30295,28099,15763,15111,19319,12539,25175,9055,12049,-5695,10089,5827,8783,15933,-15667,-22525,-13511,-29769,20157,9755,32235,-11865,-12331,28407,16359,19471,25561,12041,-23525,-29477,4157,-8331,7811,-4031,11847,16825,-20611,-29645,2899,16011,6573,14221,2599,-31705,-26831,-30323,11113,-17177,-25267,-15461,-22763,2021,4895,937,1393,8221,12475,6813,-5613,9803,-16327,-22009,20995,15769,-8697,26069,-21919,-32093,9977,30251,13929,6265,20209,-22591,-7729,-16477,-3525,-16017,-11985,-5249,-25815,25589,25149,21525,1499,-2185,14123,-14229,-30995,-21265,-7083,11421,-28155,303,-26029,24263,17297,-13315,9431,-20759,3283,-2885,-7055,14409,1129,25183,22211,14107,-8985,12785,-23739,-13085,3149,31635,-15223,-24111,11759,-24041,7293,4303,4609,-5433,-24455,-2851,-24387,14857,-833,4419,999,947,30407,-5855,12445,15153,1827,24711,2243,-10065,15649,-1367,15381,-31499,-27289,-3277,18153,20169,21719,-12629,-19607,3499,6521,8317,-12967,767,22935,-15179,8913,-22709,-25755,-17717,-6649,-23225,30747,8003,-763,11321,16115,31239,13953,20873,-6713,4605,-20167,-19665,13917,-2299,5801,28619,32171,21583,-15181,10249,4491,32035,32285,27749,-31177,-6909,-24543,29965,-22087,19061,8479,18385,-4755,6861,32575,-4989,7729,4939,21105,24189,6311,18645,-26653,3843,31541,-11589,29643,-9625,25999,-21895,-28447,25183,21237,19233,13943,-15739,24905,-14557,-22067,-23609,6851,-18639,-31097,-16905,18161,24813,32323,31899,29031,21623,9051,14841,-15471,13059,-2645,12131,-16587,-16647,29923,-14077,-24307,7533,27829,-21617,-27649,-13331,-21027,-8235,-28159,-15069,20051,10767,-2783,-2507,-23197,-21147,14039,1555,-19911,4467,13175,-27083,-13373,-2417,-10775,26649,19339,18475,5645,-27841,32307,6589,26543,-7657,16921,10219,18189,-31813,1161,20147,30165,-10375,-16709,-28401,2325,4993,16271,-19049,13541,21577,-25195,2281,-21535,-19637,31251,25701,-431,10377,19845,-147,-2787,-11961,27969,-5741,12385,-9481,13515,271,9361,27151,-7179,-12525,-25969,-14407,-16461,1999,21547,-31341,-325,-27383,-8561,11879,1791,249,-21579,24685,29467,-15433,-29737,31961,-27749,-4571,25917,-22205,-13501,21597,24775,-21449,8733,25947,4043,-8247,-21143,17929,7227,12331,26781,7017,7939,-12961,-15069,5005,24361,-31469,97,25319,19045,7429,-9935,-9385,-5415,-14149,-785,-26441,-16011,31787,7981,29933,29355,13409,-20231,8153,-4179,12203,-26333,6965,11357,25919,9691,17077,11805,18901,-1,27787,9677,22105,-201,10699,-22851,8773,-16121,31639,-3957,-19275,16617,-30935,5185,23417,25561,5453,28361,4369,5141,4981,16077,-13661,13113,-17545,23547,-25299,-19713,-829,8207,-22105,-24261,-25177,-17663,-18775,-14315,25101,5195,8259,-839,-29121,16733,77,25817,-9063,-32719,-15475,-15261,-17809,13867,-6515,8941,-6807,2873,32485,-895,2419,15825,3719,-25105,19271,-8109,13253,31005,-25743,-29429,28157,-14039,27565,16545,-19031,6441,30947,21025,-5491,29387,14933,29099,29759,-8461,-18595,-5125,11591,26933,11909,11685,-18591,-625,26133,-12679,-3935,31395,10177,-10569,1187,24389,25263,-5195,27661,32425,-15029,29587,-7373,1757,-26607,8851,-3635,21385,21485,-25595,-10715,-30693,999,-3393,-22655,32087,641,1337,-24041,24877,-10569,-79,-17243,-29387,-1821,-29325,6785,-21983,875,25163,13419,7267,14121,7999,155,25199,20275,28823,-30637,-16683,-1207,19589,-30501,27225,-19455,19219,-5283,-8561,8311,3307,863,19685,29343,24217,-31317,23807,19785,-9649,18991,21967,30553,20341,29517,-14187,10329,-27217,23373,7019,-10373,31875,23073,-391,16467,6035,26167,30201,7255,18893,-7557,-31313,-6765,-10597,13157,6117,31421,16847,13155,-24801,25009,24133,-15021,27033,-31335,-31537,-12737,27861,15341,887,25345,-10873,14893,22687,3873,-3329,11835,3327,-12515,-6903,-31359,-30229,6365,-2981,16697,-6873,-9039,-31897,31833,-16027,-28557,-10039,21289,-17075,-25881,25817,-6503,383,-655,-7213,-15105,2417,-19641,22953,17333,6297,-29191,25785,25229,-13705,-7617,22975,41,19523,-11159,5421,18329,15305,791,-26585,-23619,10091,-19243,-12595,-18021,-2419,21461,-27601,8569,22243,15649,5761,14113,10913,29127,-12039,10015,5689,-31825,-693,8387,-27409,28103,3429,16433,-2095,-26635,-17603,7713,-1261,-31877,-30655,-1381,-22673,-16703,19881,-18507,13687,-15879,-24921,-22373,3085,10729,24871,20093,1957,-20747,-16837,-4913,-7651,-26055,28095,17673,-2099,29789,-23431,-25667,16457,19609,-16713,28495,28519,-19575,-23451,-32129,-919,-7995,15517,14843,12377,-14391,2581,-21187,18253,-19851,-22941,25379,-21701,25973,-6361,22493,11773,-11785,17805,-7411,18599,-17845,6023,15065,-31225,-5727,-2955,-8787,10039,-28319,-16647,19029,3547,21473,-10173,-1227,12843,26049,25483,6735,-4463,24227,-7487,28375,-7391,31841,-22325,6833,11503,-9883,23687,-18903,-19495,-4841,3015,3757,-31273,-26655,-11677,-7553,-19995,-14285,16449,16635,113,-15605,-31689,-23091,-16147,-23951,5671,10407,-5119,-8123,20781,9307,-13687,-16665,-14321,10571,-15239,-24639,-14135,-31173,18901,15891,16641,21899,4607,21137,-10969,24627,28573,28339,-8069,8845,22385,-29767,-14459,-23505,-23099,-24585,-24955,-3269,15743,19585,27215,18059,19449,-30973,9659,-1087,-3477,-9485,5185,21397,8595,-115,23017,-2377,24853,-18335,-31565,23835,-32107,-17425,-9253,-25525,31789,22839,6977,21897,19591,-2743,24383,-11877,-6745,-12121,10451,14973,-7353,14021,-12149,-2379,-19463,12951,28865,-19723,-15929,-28467,-2049,19965,-7921,13685,-25593,10649,-17157,-16059,1277,4821,15371,-22723,8531,-18025,799,-25051,18859,-26321,-22751,-5465,14029,-11067,21791,12603,-19833,-27327,-24365,2459,29767,5517,-26033,7005,28453,-935,-10509,25937,-22395,919,-29507,12715,-7211,31387,9709,-13821,15257,27391,28347,-8731,26661,-30907,6143,3021,21509,1537,3427,-12701,14881,-3641,1831,22303,28973,15613,-1329,-6213,19231,-21191,-6867,25757,26819,-1543,3909,23603,-15269,295,-30153,-9777,18315,2829,10413,7023,-16521,-18303,-8525,16921,15639,-32739,-32295,32173,8149,-23597,3685,-21873,3299,-12799,20293,-2627,11931,-26263,23939,1107,27043,2197,1335,-4425,-13013,32389,3441,5643,8887,4437,-13471,-19903,-25585,4743,2371,-8039,-8531,-13415,4177,-131,10873,6957,3557,867,-1017,-6373,20941,13951,31585,5667,-4681,32569,18051,6741,30145,-26433,-12945,2401,-28883,25635,-4425,-18037,5347,-6661,-25685,-20937,23755,-497,14183,-6469,-16027,-24029,12711,-28557,10581,26673,-27223,16887,-19501,32635,19235,-19047,-2357,19223,-27039,18171,-11855,8683,23641,-28721,-3867,-8687,-8725,4941,7977,-23775,22079,15577,-20705,-8493,26613,-9031,-26183,-6301,-8387,-26739,-3731,-6987,-4783,-11,-5601,22617,1599,-27261,-29805,-19531,-28839,-9453,10881,17739,4307,-32087,31163,-17085,13423,13189,3939,3639,9093,-31717,-19449,-19939,-2303,21015,25941,-12559,-24671,-32279,18977,-28293,-16363,26315,-23715,-31527,31045,29251,-24769,-26513,-4287,21919,1259,26303,18325,23959,22271,13663,-7779,-17393,-5659,-31925,-3339,20471,-3237,-12129,21999,29593,10299,9117,-4311,1879,-19141,-23775,18469,31111,-17445,-7159,-13745,-11309,-32737,3537,-1055,14639,-9473,15791,-26679,-20885,-22835,20653,31129,26489,4315,17451,19245,22897,-3381,-9265,-16831,-941,14851,29991,26303,14539,14555,-19285,-355,30197,10415,-27311,29793,-19419,31111,-29177,-2369,20875,13479,29485,23763,-10597,12645,-3265,9239,-1121,2085,20923,31333,-30137,-31963,-31215,11159,-22239,21837,-2833,-4401,-6393,16437,10419,-2499,-19367,-11431,15519,-1909,26579,11837,-29707,-10977,-27425,22659,-8683,-21959,-1071,12873,12527,-25419,-32379,-11561,-19295,17077,32557,20139,-13675,26761,-5893,27917,27663,1947,-1057,-12553,16257,4535,-13269,32339,20403,12961,-14209,-11407,25379,-31447,-5551,-7169,4811,-30369,10335,21619,6525,19235,-20101,-14063,18349,-31455,-1745,5041,-32581,-1795,18803,5359,10103,-941,17863,7249,-11337,21805,-19865,-8389,21931,7349,22675,-2011,9557,-16027,-28495,-24159,-163,-14583,-30333,-21689,-29745,30775,-32401,3479,-13777,24041,27271,32695,-20979,-22275,6061,20789,25875,-12325,-1173,-15511,-21113,-3257,24231,20591,20673,-19409,-4457,-17223,-7989,-25051,13155,-32533,3593,23015,15997,22811,3621,11799,-7637,-397,-4285,-28231,-24465,-30237,-3343,16491,15701,23513,7035,-5925,-2507,2697,23759,-3349,-1595,29499,14593,16285,4715,4913,-4327,-4065,9319,-27485,-22615,6343,32073,30777,-16811,9447,27101,2465,-8107,-15507,-26149,-16175,20103,20171,-3901,30969,11389,-27353,-23315,12299,-2931,19697,15345,24485,27405,12701,-11591,15401,29055,-32521,21475,14289,-29847,2373,16835,12417,9319,-21113,9403,16287,-21235,-23899,-30781,-18313,-885,-1655,24263,10497,-8595,21533,-6567,-24767,-321,11457,-11045,-6193,14801,-8625,-13565,-4959,-10613,-10261,2305,-3307,27535,29033,28685,9855,26249,30077,22189,-26889,-6857,23351,19587,20209,-10367,-3033,-10105,27095,-17699,32135,11881,-21773,-16973,-9553,-18549,-13587,12761,13577,-821,26309,-9835,24279,-32579,-20429,23943,9413,2591,18831,22183,-2333,-27887,-29185,-7559,4519,-12679,16077,-20385,-25679,-595,-169,-32589,-4895,12149,-30805,26707,-8439,-31451,-22123,-4793,-32333,29327,11799,-20547,3689,-26671,-7421,22449,7663,-13831,-29631,-21643,13363,-1537,-20967,-17495,-11367,-20989,-8825,31095,-21031,17519,-15563,-30637,20907,-12917,-5179,18047,16799,-12671,19829,24223,-13029,3791,-9353,13711,20207,-2675,-14439,29857,9491,-6245,24125,-18041,-19705,5821,-8985,17705,-25473,5099,22113,-9725,30287,-1433,13601,-12919,-29167,25203,23003,13017,20425,-8689,-28081,15329,-10243,-29019,19639,24567,23683,-29321,-13263,23355,25071,-20431,-17515,-3655,30233,-26397,-15551,32333,-2745,-5269,23341,-10343,21863,-11799,-15727,9467,-20515,21679,32637,-20911,-19769,-21503,1061,2155,-30275,31493,16849,-9599,-4889,-5877,30043,-11761,23613,27471,17503,-28817,19019,24599,32393,-29861,27831,23285,-27531,18803,2591,7419,14949,31403,15273,-7515,25289,12131,1965,-9017,-2103,-30381,27419,-31091,11111,15959,-15271,29011,6539,-18169,5227,22741,11383,615,29111,28063,-3907,-28733,-4301,-22737,-16497,-16549,-26477,11887,28961,11385,-14397,-27917,21659,17801,-13219,-32177,-14223,20787,-10489,-31477,3509,-29381,27207,20057,-12295,29361,-10375,7085,-8671,5085,-14869,25293,-22027,-19631,14497,-30513,20161,6537,30453,-24825,17139,12163,637,17369,8651,24663,-15559,28581,-21491,-433,-21941,-27483,18611,-27653,1495,-4415,29027,13611,-21521,30677,277,-23621,-2361,23821,-1481,4965,-1779,-22589,31239,21759,3969,-19703,-12585,22549,-11743,9001,-4707,-24823,-26659,-24541,-12603,26147,18007,-23089,30563,2881,-27889,22519,6535,-4781,-15441,-19037,-21401,6365,5419,29433,29063,11487,-23439,24925,13443,21737,-20705,-13735,23131,5703,7433,5781,-29685,-7203,19883,-10307,15401,24615,-31585,-30067,-15299,20515,4497,-6713,-6561,7511,11275,26147,-24761,22743,18049,-25819,3053,-32505,20719,24517,24461,-9319,-28595,-3209,-1805,2359,32671,-32279,-24825,5729,16975,21295,3375,16881,-9949,19801,-15115,26397,-20669,2947,-20785,19059,-29095,-11653,18449,25955,-2015,-1713,-24289,29241,4413,-15235,-17425,-10413,4721,20043,-7739,-853,3175,-7601,23995,-12873,-29919,27221,-6867,-31727,1729,-2779,2105,-21317,-29463,27315,33,5715,14363,32227,-5357,-3983,25673,-9533,2893,-24973,4545,-26705,-22087,22989,-19081,14241,12283,6667,-18059,18719,14527,31839,4563,-327,-11421,31395,27239,-27867,-997,-11309,27553,-11991,26755,-25659,16049,-3581,30645,-4465,31929,13821,26165,21821,-14205,-19837,-30045,6915,6793,8473,-29405,25563,-26373,-10937,-4115,-23081,31019,-12771,30777,-11039,-17465,-32305,-25985,-19377,24115,8861,3567,30611,13831,-23601,1523,-31475,-17937,26763,32311,27049,-3189,-2573,-16393,-23571,-32279,22559,14955,-6691,-25291,31751,-17701,2183,-23753,-11261,32151,20519,-4037,31533,-9635,-22565,-13647,-23125,-1793,-22531,-28785,-23875,-4361,23717,31513,-27513,-7503,-25003,27629,32549,16661,-25237,14403,-20995,8479,5093,-9005,5345,-22177,12803,23115,-11793,12135,2893,-22247,4009,-7919,-4603,31187,16905,13919,-21329,-7677,-20809,14133,26231,15445,-14035,5907,-22771,-2169,21221,2985,12087,22799,-4547,-23665,-16527,9131,22573,-23147,25753,-29331,-25295,-22557,-18373,535,633,15495,-14535,-3483,-21693,-32639,-2557,10139,-8535,3309,17703,-11959,-17949,20447,-12889,807,-11553,-22263,17701,15575,14609,17649,-8277,-11765,23365,11253,-9037,-10075,-15667,-1057,-10873,28111,-3707,16557,-6261,3901,26871,6667,-28863,20353,-23595,-28695,-13435,26265,-14167,-31787,23433,21903,8519,-12967,19951,-31395,12155,-3657,-12321,-14721,28409,-10925,-17847,-22481,1135,-15875,28279,27241,13705,-23025,-22201,-9947,-17519,-4839,-15545,-3561,-23839,4299,20267,17159,18091,-25747,-25405,6731,2589,-32091,31303,-4299,2455,14859,19849,12923,2901,-24749,-15069,14475,14221,-14937,-1563,-4365,24379,-13619,5597,4255,1421,9827,743,24355,8499,-22665,2349,15081,-26545,-1665,-4377,193,12739,-23597,7081,-27661,-5689,-30983,-15629,-20401,-21989,23759,-867,-24999,-27531,5853,-10359,-10851,-15013,-23645,-17525,3657,-17653,-24237,-2027,-11899,14675,32269,-32297,-21445,-15115,25737,25917,-27463,26221,-24943,-16019,18073,-27351,9277,1277,26653,9207,-407,-27979,-2463,653,4707,10777,-9837,-9441,-20805,11269,-8449,-6921,-13973,25303,3707,19759,8173,-26601,24555,5455,-6703,30381,5205,-28635,-7775,-18423,1747,-17865,13,-9861,-13723,31141,7505,-31283,-21063,2943,24449,3103,-17135,22719,5639,-5287,-5793,-4789,22147,-14025,-10211,-7901,12487,6205,7013,25517,1247,-21467,18941,-23917,-10755,21617,-30451,5025,21467,26487,27917,-22445,19121,21309,-24349,18891,-19355,-15831,-19165,-32155,-2883,24587,20457,21757,22643,-7807,-20753,15297,4911,9845,-16785,-11453,23355,22529,-31203,28937,-2825,91,-161,-31751,-20833,429,-18859,-3089,-27799,26701,26963,-19843,-7149,8409,10695,-31247,18159,-12919,-22755,-8519,-4669,15897,-2119,19343,-18133,26253,26695,5751,-10311,7757,5907,-14869,11467,-21745,6041,-4525,12793,-25827,-8453,-24271,9745,-12423,-17263,-27317,6635,8981,10327,6865,-26801,9459,-8239,-17553,-411,17379,-3557,20693,-2255,32567,1191,21247,-2789,20195,13803,-24299,10203,28117,-14397,28481,-997,10669,-3527,17083,1643,14245,-8847,-9555,32741,30287,819,-22385,-5883,1901,15253,-27403,-18055,-30947,-1399,-8301,-12581,5345,32443,4669,4683,-16695,-6661,-26695,-29419,-11797,29599,-21957,-29379,5083,17683,-1309,14369,-22127,10273,-27335,9871,25101,-747,8469,-29887,-23907,-25289,9177,21955,-30467,11311,26997,-31977,-15063,-23127,22815,-17699,-13783,7017,19957,-17523,-26033,16315,7085,-17463,16831,12233,13461,-2103,19797,-14261,28535,-12541,-26597,30937,-14041,-9597,-29459,-28155,9457,18957,27133,16481,-24477,8355,21991,28021,2505,19079,-2297,-28793,29737,25031,26117,-3151,-8565,2293,189,3167,-14917,18813,-20499,-25559,1299,-17295,29819,14153,-21389,31231,23767,22181,31963,8777,-22485,22263,22779,-7973,-3545,-16089,24985,-27171,27517,-4643,9825,-30381,25925,31951,-10037,-22653,22857,-10909,6937,-8605,-2055,-31371,27239,30729,-21423,-16105,17045,4889,-29663,15463,15851,6743,-8073,19611,22409,-16865,-16885,10317,-30885,3905,26749,-23461,-4671,-13335,-27733,19859,-27321,-17459,11249,-23675,-5799,-27405,30437,-5133,31497,20013,-29423,-18043,22517,28395,5883,-19373,18011,-3613,4295,6061,5367,20749,17767,18999,-31587,853,27051,17397,15063,-2001,-28615,7897,17771,23845,8735,11489,25157,-27147,-12491,28291,24891,11359,-11117,-31527,29351,15735,24175,-26781,17689,-29479,-18027,30731,-5099,-3647,26179,-25227,-8867,-25425,28625,-1803,31779,-6509,19369,11057,14055,27187,-3587,-15187,-17215,-23803,8637,3323,4453,-10185,-15417,-8189,28373,9639,-20043,-29307,-23331,20469,28903,16909,7703,18535,9801,31951,-12307,30677,2597,-9957,5115,-16033,-16439,-8777,-9847,-31577,19197,-11967,26703,3829,-4839,-14229,-17385,2013,-7921,29851,-29555,5677,-4475,2981,25825,-8335,24349,25995,-18639,21425,32559,-12157,-2219,-22567,17905,-8255,-9619,-19069,8715,-4409,5669,-30287,3675,24363,-18193,-17985,31097,-615,17073,25427,-28859,-22827,-20167,-27593,10767,21565,12587,-899,16889,13615,15419,-3203,29827,5289,25767,1511,11647,-26769,-27569,11295,-20983,14323,1033,-25079,11035,-7751,-21587,-28285,-6111,-21887,22973,-20773,32405,23969,3957,-27185,-8535,-3831,17309,-13669,20727,12587,-7115,9913,1759,-9547,22609,-7291,-3473,15183,-24253,-23953,-4597,-14923,-19441,-19635,20775,-27583,-2757,-8253,17527,-25589,3661,-6013,-9301,25603,-885,-23289,-10273,14187,5831,9237,-15505,12195,8101,6149,-25183,1367,13399,5777,30949,-12737,1605,27531,20335,-18969,-7805,3253,-581,-4087,-17805,29305,28107,21409,18723,-21531,-21151,10165,-12839,10587,-19811,485,10079,-30783,17967,-17775,1651,17035,-14365,-30693,9101,-9787,-3173,-14039,8771,-5331,-13305,26577,-20707,22445,-5295,-14941,-17577,-20437,-23791,22185,10497,-509,1429,1161,15821,4625,4351,32101,13615,21869,19785,-19447,-31231,441,-8339,-9315,-21425,5911,-12785,-955,-5357,4385,28229,-29139,-5175,-18585,25459,8217,22335,4697,14643,3519,30509,19749,-15177,-31967,18371,18875,-21919,27613,23383,-15549,7369,-17779,3683,2637,17263,14693,6301,-23725,11105,-11159,-17783,-9669,-8471,25351,-30101,-11063,-24881,30949,2749,-29823,26973,21869,-29375,-5531,30653,-3045,-4323,-5837,-31103,10973,-22061,7959,-10577,-5559,11041,15429,-24229,-8823,10579,-7713,-32631,-3719,2993,-27145,-2891,-29095,-13091,12221,10977,-197,1901,15065,28771,11335,-22163,-929,-17415,-26889,-25095,-8351,-1727,-19025,-23669,-15397,-3981,-1041,-3295,-12387,-9999,14521,-25343,30799,-24823,-22689,8035,30125,-17895,32209,3189,-17509,32339,24019,-21579,-29077,-15203,-4649,26303,-24453,-28461,-13607,3683,15129,-17385,15481,4027,-22853,-19563,-29209,-13111,28647,25003,12873,26673,10567,-26901,31255,23621,-18545,-6997,2521,28023,24185,8543,-7163,-14127,30105,22861,-7839,13485,24233,-23965,-8605,-17069,1025,-27455,26449,-1457,10615,8063,-21775,-32527,-1913,-945,14903,1851,17685,23559,-11213,12217,-12555,-12951,25347,22361,-16751,-12093,8453,-17469,-31659,32429,-28585,-24741,-20547,5887,-15819,-21103,32307,10197,-6233,21117,21005,-19253,-8233,-31425,-32121,-10687,-2653,10635,23503,15649,18667,15221,14341,-5479,24317,2737,-5405,30547,-12833,-17039,1837,1469,30427,14635,18129,-2017,-30507,-10823,16527,-30693,9783,-4753,-22133,16325,16187,23157,27089,-1673,-11301,27441,23623,7549,-16603,-19421,-13473,24213,30147,15631,22807,-1001,-5555,10817,-373,-6501,29875,-21239,-19191,4549,14323,19097,-32127,22507,-131,17397,-30807,-8835,-2609,-9877,-32667,-11721,-17707,32167,16349,-10353,-31977,-12021,-4637,-26285,29001,10809,-1771,24455,-15853,12389,-10013,2781,-5803,-29933,17591,22269,9795,-28821,29361,-9367,20761,7925,26725,-26529,13293,817,20439,-20967,22055,8009,-18737,-22959,31867,13547,-847,31193,24679,-14619,-27023,18845,-28117,-10931,28851,-20263,-3813,-12383,14481,-24277,24233,26393,26375,-8727,-23531,-4393,-2401,-10913,12929,25151,15437,-5885,26313,3869,11109,-555,25017,-19207,1585,9861,-12259,-29003,26783,22571,17539,2939,16555,20209,-16581,15851,-4473,26767,-18213,-27469,12367,-29959,25281,7543,13487,-29889,14325,21725,16141,-29235,13367,6505,2547,-11291,6899,13465,-97,7785,11827,-19965,21485,-21461,-23825,29079,23551,29743,-12553,-30925,-24719,7309,29741,16767,-14651,5675,18637,19133,-15291,205,8375,-10193,-28751,4487,-30637,32485,-16887,-20401,30639,22651,-4295,9609,1647,13129,733,-7689,-2873,1781,18761,30291,20883,-22441,-22251,29017,27579,-14729,15449,-22629,9981,29111,25377,5045,29915,-1073,-29423,3867,24563,24997,-19259,29833,-14853,-26425,-12549,18111,19203,-15835,-19681,30643,24211,-13949,9545,27841,5307,-18399,-4583,18767,-11279,17569,-31491,-17527,-17865,9305,-5267,6045,-10511,16945,26621,-923,2423,12193,-7959,-23221,-25357,-20629,17187,31197,-32419,-29401,16647,12159,-9159,-14159,23325,-26419,7035,1611,2693,27325,-20651,32519,-13117,-11939,-11891,12351,20889,1409,18151,-12799,14019,16565,8451,20193,-24775,9569,3735,-31585,14765,-23701,-28113,2097,22695,17643,19649,-10855,-23759,-29655,28585,-26751,11975,-23131,-20611,-29035,29009,-22343,28527,-21151,25043,29637,-15681,14465,-31493,-18227,13141,-14295,-15801,-26429,-7325,715,11429,437,-21903,32425,31921,29019,2613,-15951,-10571,-27073,24703,1379,24979,-7749,26587,-31573,-23077,19461,-27599,-9009,16655,6031,21881,31773,4549,10691,22687,3019,-12631,22421,-3955,14339,7121,9513,-29483,25513,-15981,22303,-29659,31051,-5495,27437,18017,28137,1419,-29203,24921,4813,15113,-21909,-6643,18085,1743,-29097,-25697,-23241,10925,-21627,17965,20177,20811,4753,-3103,-6035,11187,-4433,-23351,17233,10089,21459,9353,-27385,32743,22029,15197,24351,-16619,-16731,4061,12797,-27259,-26521,-4035,-19605,-26703,31107,17455,19163,18425,681,-27661,-15163,1591,-17613,27575,29725,12213,4765,-837,-1619,20415,-28931,14025,-10421,6049,19409,32323,-26115,29141,18481,15879,16907,-13081,7115,-32065,4383,1193,-12849,-19811,-7077,-24307,8507,31323,4971,30931,-27059,-5207,20063,6037,7375,10299,13221,24121,-24453,24091,20177,11421,-7949,21653,-3847,17571,14913,22993,-25709,-26517,-1973,-873,7025,12195,25555,29903,-24875,22511,-12693,31995,29331,16437,10517,-3013,17661,-2025,30315,-27975,22547,10809,-25361,27797,29289,2285,-16325,15309,9265,-10521,-19035,4899,23257,-31219,1829,-16553,26367,5915,-28637,-31141,25127,-21587,30275,16771,-3615,-24505,7481,5731,-22735,-9309,-31937,-5519,5261,15747,21275,13415,14467,1849,-9047,22735,11029,27803,-5605,13871,21449,-29199,29957,-16231,15315,-18789,-3857,-30979,2389,-26935,2507,-10159,24121,-17899,18941,12339,17321,7291,26859,8157,31479,-2861,-13673,24953,14233,-8121,-14175,19229,14737,519,-11049,18941,-31427,-9203,-15943,-1305,19581,21441,-27729,32035,26183,-31563,5749,21885,19245,32755,-1759,-10661,-30143,15673,26425,-25681,-32613,-24939,5563,15215,-22425,-14171,-26193,4091,-15555,-31215,27929,27535,-25897,-1215,19033,-523,27629,20957,15541,27747,-12483,4883,14013,-14725,10633,-24627,-17513,18443,-32513,22367,-14003,-19381,24689,-16855,-7551,-2017,-19159,15725,-14709,-24611,10301,-25007,-28085,-12463,23545,24141,-14397,-27451,-15283,23675,16555,17149,-26349,2209,16325,21025,-16077,-14971,2963,-11625,13359,-577,-12487,-31997,-9329,14351,30529,30357,16613,32193,3771,-9573,-15797,-25959,14621,22847,-3763,-15931,5607,-28025,15059,-17125,-13155,-8393,32293,-9481,25735,-7083,28811,-16141,4581,-32013,28947,-17561,-939,5815,17417,-25111,-16749,17215,-26685,18897,10577,27071,-29583,-7013,3471,8151,-5587,8991,-32589,549,30081,18377,-1399,12809,-14953,2687,4969,15595,13933,3577,19087,-16159,-27787,25035,7215,24093,-32427,-32439,13113,-11957,4515,-21813,20737,-7333,1881,4761,-11515,-31963,26573,-11917,17345,16879,-23677,28191,31567,-18695,6813,10777,28809,7795,-11197,-6721,5335,11665,-31467,-27381,-24787,-2547,26987,-18993,-10001,-21303,14741,30187,-16769,-437,-19707,-27431,-16913,23247,32023,-23151,22121,-15667,-3467,31125,21517,-11195,-18751,-27699,-6371,4391,-17739,-28293,30625,-8939,12717,17793,5089,-22071,28945,11035,-6733,-6249,13145,-14029,-16925,13337,7447,-18363,29387,23623,14437,28225,15645,-4959,-2213,19715,6209,11799,-25247,-14711,-1215,18061,-26453,-13507,-18407,7239,18139,-25367,-3473,17553,-26373,2773,-12401,14579,-17517,9215,1947,18815,7111,27569,649,21715,-9949,521,8675,29041,-28343,-13647,-13889,-10705,23097,25623,15785,11105,-26973,10193,1911,-15081,7037,-26801,23041,-8953,26573,-26831,26795,-15335,667,-24613,-27099,-16293,4963,-27291,28807,-23229,15719,5709,-13527,-24865,-6709,-6527,-14815,55,-14863,3475,-8489,27007,-487,-24917,-19063,-10601,2863,9969,-31337,2989,19271,2529,10775,-1841,-29343,-25513,27801,29103,25951,11837,20025,-29631,-23045,-18931,-6081,12403,-20959,26941,6999,-30927,-2791,10709,10233,12949,-32491,-10915,-20169,16405,1581,14233,-4477,-24723,24931,-9741,25209,-1681,-23913,13893,-24959,-24959,-30843,-13701,-139,18407,28879,-1389,24709,-13189,17627,22377,-28007,-8727,-20033,9975,-3457,18745,13277,-6265,8315,29257,-7713,-26261,2437,-4547,25975,-31241,-20579,15433,-18161,4375,-20523,18043,-3967,-31357,-22131,-12077,29579,27725,14697,-13781,16625,26339,31921,32483,-27679,-8483,1333,28151,29245,-12621,7361,-30869,16791,4899,20017,30661,7437,-271,24833,-19259,21963,29985,-26953,18407,32495,-27309,-6175,13073,22513,28943,21709,14471,6067,-25787,26469,13781,11155,-19205,9067,-7065,-11287,-7411,-7577,19795,-32279,-23301,9783,-21387,-7091,-2065,14629,-18885,-28381,20813,16041,-10729,17685,9359,4831,32601,-24847,-25647,18529,-8913,-19933,-12113,14515,6221,-2933,25445,26237,31695,26667,-23069,-24469,28329,-6633,-23663,-5533,-5577,16759,-17715,21249,24937,7173,31373,-13323,1297,9417,-2279,11949,4535,-17953,-20643,25581,11843,9901,-3439,-5441,10757,-25009,5187,5435,-14121,18025,-18279,3165,-22253,-15037,-32199,5145,20791,-16783,-30877,-17363,1169,-24289,-16451,-25775,23555,-25267,-3823,-32233,14863,-15501,-28281,-23387,-22159,-753,-19791,-2259,-27607,22753,-4601,-11095,25693,-11529,7839,23119,-1427,-4175,3497,30077,10063,-14855,-8235,-3283,-25173,-21279,-25363,15341,-5231,26477,-1717,29391,32673,20573,-13039,-20823,26425,-13621,31581,-5045,-14151,-18285,17309,-597,27869,2497,8611,12553,-1131,-17083,-30577,5135,-22231,26123,28621,-2923,-2259,12359,-27323,17779,32609,-29913,23955,5679,-1099,5917,19629,-24555,7277,1571,29971,-1819,-1025,-10975,-3681,32311,22875,32559,-10183,16717,-1275,-25061,32449,-24437,-14173,5459,-29845,-18385,-23767,18985,-15901,-13733,32729,19041,16031,-7153,10147,-10785,-29149,5271,-29487,27155,14773,22343,-2677,12569,25511,7725,-14679,10183,17189,5511,13253,-29409,-25075,215,-21281,-8627,4667,-9711,8991,-10813,-27741,28741,-17665,9469,21409,6427,-5149,18615,-28865,11587,25957,-15991,-29691,22489,21849,28073,13227,-13103,23529,-1007,28823,-22201,18281,11661,11553,32119,-9429,32307,17049,-873,-19783,-2033,26931,-17615,-3771,-14107,-7975,-27051,-1111,-18183,17949,6495,24429,-3013,8509,13331,-19133,-13361,15975,-18737,19005,-13189,7847,11725,-20293,21373,-7299,2519,-6519,-20079,24821,11813,-32159,14093,2299,24791,-24199,-25735,-5249,-17413,-18587,-20465,6573,-20665,5257,-18859,15021,2855,4965,-7279,11509,7917,14853,12941,-13107,22843,-8013,-17993,27879,-23893,-5277,9947,-5979,-30239,27773,-30151,6555,6577,19309,-8367,5231,-32557,-9403,20763,29637,-30545,8133,21075,-27367,4797,8237,23519,27417,13047,-21227,-6507,-13055,30085,-28805,7567,13205,30117,-22579,4569,28311,14149,-22211,16323,-6441,-23391,-26519,27089,4685,-32667,-22419,16131,-11099,12037,-5521,-20951,-25753,-9971,-31865,-29307,30285,-32393,-4655,-20473,9155,-7189,-7881,22963,-23393,9167,-10823,8585,17981,21893,23213,10701,603,-24903,6331,30841,29549,9659,-19793,24195,-22129,-17507,-19199,2147,9173,7761,-921,21315,16315,-10159,-28531,-28737,-11279,6793,-14481,-19063,1931,11111,24127,-23737,13963,-28719,-27933,14665,-27551,-14865,31715,23805,5395,10847,-31741,-30815,5443,-16151,30969,12929,30083,-1875,3629,21137,-25163,30283,21333,-21889,9297,6315,-31263,87,18955,-11827,24773,21955,9579,17737,-9839,28513,24217,16473,27451,-8587,31161,-25629,-14071,-12021,-3347,10051,18263,-16205,-11991,-25059,-1231,11539,-5303,-4871,-22795,-10709,31741,14387,32671,-19869,3043,13277,-10465,6257,-29487,29819,19735,13067,-17741,-9695,29119,27561,7895,-16933,8027,-25533,-30707,-16103,9853,-24277,26761,9641,3139,-4635,16315,-10507,-825,-375,31925,18949,-21769,-21513,-18179,-28265,-10333,30989,32145,-21339,1977,-12033,-9585,-18321,15825,16855,-28655,-9335,-11571,28619,29871,-31857,-23981,-28233,9191,-21243,-29845,25823,-28889,-17589,143,25835,-25273,17663,26699,6873,32347,-27129,17123,13321,7263,-27097,22987,19127,-7605,-30415,14595,-7469,9187,-20675,-27937,10297,-28999,-10811,-1653,-27393,-28001,-29565,26287,-27443,-22435,1469,16649,-26725,-19971,-13625,18049,-18659,29205,-32119,-30759,22119,17199,-23089,12711,-25679,14417,7109,4621,-25253,18509,30495,26439,15827,-31071,8091,2141,-11545,-12897,6927,-32209,24965,8881,13937,-5331,-26921,-25989,25241,1055,5251,18443,-7511,-29793,2267,-1251,-18741,-28493,14137,17461,3201,-22985,-17377,8767,3663,-3953,-18401,-23931,-29525,-23623,-31033,427,24449,10317,-20579,11791,-30047,-15875,23173,-28679,-7121,26911,23925,29663,17195,-13677,21573,17945,-18183,-18521,-29075,-475,-6219,-9661,20103,29109,-889,-6861,9983,3389,527,-3925,11337,2649,16899,-6729,16283,-15403,15871,-12845,30751,18465,30709,15451,17729,-17739,17785,7043,-123,8907,-8033,-17253,14017,27793,-14651,3999,18831,14297,28795,25363,22951,3645,23101,29393,1405,-11311,-15061,17233,29575,-27553,22579,10439,-9191,-12151,-32511,7931,-6805,-22117,-20355,22455,-13861,1595,-39,-30089,14993,-4165,-25537,-19931,-603,12617,25529,-1213,-16343,18507,16969,32039,27389,301,-925,-23527,10695,-14229,-19601,-13929,-22009,5697,-357,11989,-19727,22931,-10905,-31,-23423,-31591,-3587,-1611,-29979,-32133,-26161,26179,-5399,7575,20565,-9771,-16129,29299,-23229,13467,-15219,28955,-25875,-27379,-7305,19339,30381,22365,-20585,-20981,-20077,-7493,-7681,4325,-1043,24185,23905,-18969,-21297,-3399,-13555,9563,18751,-17971,-5225,-13743,25805,-27865,-22603,-6065,17083,-16897,25519,15979,-28229,1933,-31097,29077,3711,-19415,-16371,26191,-18427,-709,-12115,29325,17743,6559,-12613,-14017,-9303,-13863,18693,-28135,11419,20337,26119,6867,-12957,455,28831,-495,2969,4485,-5563,17615,-28043,-30691,-22493,-2019,-8719,-27373,26703,-7475,-10923,15833,5623,-10433,1223,-26727,24291,25811,19679,-22301,29965,25991,26361,6701,8081,12747,-11219,21859,-15517,17351,-12933,-11217,2155,12501,-24723,1739,-18837,-5767,-12099,-6511,-8023,17143,23371,-16653,-1429,2225,17861,12301,-24381,-10361,-15991,-6959,15039,-31659,17095,-1405,19015,27751,-3425,-30419,12129,31099,15135,25649,-15689,21577,21971,17825,11663,4139,31705,-12659,12097,-1557,-22241,-10415,-26373,-2689,4251,-14327,-28347,-19509,21845,20249,-7987,-26657,30491,27375,-27313,3799,-1707,8531,-13753,-18221,-12445,-10263,-29525,-27337,-13221,10301,24259,21255,-15427,28557,-31171,-25303,24441,-9381,-15823,-17783,-2669,15073,-23337,-22523,-28099,12731,-27247,-8751,17143,2289,-16149,4313,-15621,22443,-22845,-12323,28105,-26349,26715,-453,25395,-26257,-9347,-19911,-28355,-20895,6171,-32679,-9337,3439,-5749,18791,-12669,-13169,22129,-8573,4607,27145,-21871,-30373,4171,17555,-15415,14131,-28647,-11541,-14945,-1005,5957,-29299,-26415,13087,9719,9353,-26749,-25787,18791,-2747,193,16765,5245,-9553,-31273,-26003,9035,965,6413,30273,-15265,6199,-31611,-11343,29215,30295,29571,-24743,4081,10617,-19625,-27651,7155,-10045,-12157,-13903,23355,22255,18525,-3387,2471,-32525,4807,25799,11033,17187,-27117,10667,13597,-21499,-3281,9745,2031,-17397,3431,-14467,-27305,-8823,-5495,23361,4959,25523,-27019,12185,-30763,16837,-1863,-1543,-11213,-2067,-16771,-19309,-6691,-10537,11073,-18547,6839,-20505,12395,-17761,-9393,-6585,-5091,19021,-21781,-32117,7463,-13333,31605,11325,4851,-7559,5169,30467,-26393,-13195,-24625,27013,-26019,-24621,-26617,28919,27987,-32239,-19377,21163,26103,3735,-9641,13181,-2119,24613,721,-17427,7875,13473,13787,26719,4415,12129,18029,25233,3707,28701,23231,-11975,31527,22757,15215,-23631,26665,27301,20795,-20047,-30691,-14599,-17671,-6575,-27277,19237,21279,-583,405,32465,-28275,17443,-2071,27539,-28681,15415,21939,30125,-6895,20929,315,31779,-20521,-3521,-29981,-12441,18313,27407,-25989,-32049,-25063,12535,-30083,-22839,-30587,21223,26875,5443,-20433,25893,26479,-23085,28213,12063,-26601,29711,-19941,-32163,12495,3539,12953,-5573,-19423,23069,4225,7443,-27449,9645,6407,-21543,-22407,5613,29501,-25071,9571,-28835,-10073,16133,30033,7843,12829,2945,-3857,-18499,22993,30571,-263,4709,-23261,21127,4429,30791,22443,-18559,-12439,-32025,-24917,-21107,26023,29181,-31847,24827,3627,-17879,26539,-12475,23023,-30835,-19817,23945,-25881,16019,17429,28375,-9489,-1955,13837,25599,1733,28199,-15677,28795,-22083,19227,-753,-28395,-29445,3607,-3285,19147,611,17409,-29665,-26101,-12179,7497,16125,28877,-29729,25433,-27375,955,-11763,13221,30383,-19447,20223,27917,17187,24273,-16699,-7897,31275,-11283,-5817,-20865,-20825,6251,-16171,-16609,-5239,25217,-2531,-15457,-10011,19735,-7009,5059,-3371,-2565,-10135,-24901,21053,-17,-26839,-14279,-18613,10139,-1051,12243,-29373,-31263,-13101,-4813,12075,-23033,-15843,-11165,-28481,-31291,479,-21207,-7933,9587,27921,31997,-6787,4883,-7777,-147,217,32597,-31563,9405,-21481,-17223,-10443,30965,9207,-14419,-11197,4549,15053,22161,-1275,-29889,-26671,-24547,28005,13815,-5263,-1143,-10389,28259,23757,-22781,17821,4961,-7439,-15505,9587,-23031,7049,-16007,32619,29745,487,31571,-24817,-5557,30313,-23835,-16733,12153,23435,3589,10255,-25813,-4663,-17259,-22087,6999,32253,13039,-4261,-3143,-13371,31557,-6641,-19451,18339,-14173,-3759,-12417,32231,-20023,30305,3983,26127,19689,21899,-12237,23495,15899,25437,19291,24565,-10645,-9179,-7273,23703,-12835,-2041,5481,13605,-10997,-30385,23079,31129,18249,2805,14575,-30281,-1541,-26997,8777,30169,-15193,20967,-7847,32553,-26573,-9455,-6683,-7165,7673,32455,25835,-19599,13695,10347,15335,28311,32347,-24785,8251,-12557,14721,17515,-29075,12561,-4063,-28713,-6563,-18119,-10867,-30523,32709,24239,14941,-23237,9179,1619,-6025,-24589,-27597,1739,-7107,20497,17347,-20459,-13299,5055,20581,3987,10897,25897,22841,-15757,-23829,-30103,31263,-21827,5703,-27385,23605,-17867,-25435,-26071,28347,-29563,-8647,-9003,-28837,11271,5367,16995,18543,-32547,-17013,-24637,27037,-9711,17121,-10455,-21189,-32649,-24647,-8745,2023,-14241,29409,6627,29555,29211,1821,-15827,-2141,-24841,-18199,29641,-18133,20733,-4639,1239,20223,663,-8497,-31065,-5783,-15757,-9049,4265,-16015,-27013,-10451,21559,2943,-28055,-6789,-23111,-12327,-28149,-13341,8331,10741,-29985,-26627,6419,11257,-19915,28423,23155,-3113,15747,16551,22745,-11211,31755,31285,4975,-16629,2857,-29053,-7469,8037,11233,-14851,15695,-20207,-27171,-23469,-25957,-24373,-14977,-17041,-25691,8273,-25201,-29265,-26643,-539,-29107,-12597,3637,-20019,-11417,-12325,5911,-20003,-9559,18649,31693,-13275,9355,-9033,3489,-22925,12601,20715,21303,3153,-31431,6551,-11105,-20765,11509,30925,-25085,25259,30733,-20413,-17697,381,17039,-10861,28749,-6259,24181,9901,14743,-21725,-9069,-9943,-25415,-16503,27661,-21525,27529,2757,2757,2759,-28293,-26823,27871,-29073,28323,-24879,22009,3475,-13645,21351,26441,-17869,-8807,5207,12993,-7677,-5659,29315,-18699,25205,8631,31955,13721,-26605,-19545,4561,-20625,22889,10095,-13413,-10215,-6951,5491,1843,22351,-8413,-6733,-9083,21151,20375,15801,8635,9515,-16301,2753,-28275,7035,12989,-3679,645,-5193,-8399,-1869,26773,4887,1353,-25475,16259,32135,7141,8327,12597,30693,27191,25613,29845,-11905,-25597,-6265,-6081,29083,-29351,13591,21389,12069,-3403,9727,12745,18041,-27095,5769,9929,-6205,24791,-6785,-10395,-16841,-16983,19341,14937,29701,-9353,-5875,18011,-22363,20123,-21423,-16359,26997,-28757,28367,-27413,19333,-5905,12877,26615,-30255,-21223,-21623,32211,31763,-19463,17429,-15377,8749,-14903,-24667,31615,271,24123,30569,31355,8889,15933,5401,-10879,-13523,-31639,-13933,21977,-3697,-29823,17715,-12217,23885,23817,-3043,19811,-20669,2953,-8737,5981,-20717,-25093,16525,-11833,5179,5737,2727,-6703,-16901,16137,2965,21119,-10529,22687,-3199,28687,-22935,-23501,-29679,6839,-5415,2023,-23751,22515,-5791,-19557,22467,-8677,26881,-14491,28027,-18879,11357,12157,-17959,-9269,-20985,5105,-7399,8053,-9859,29893,20783,2327,-21547,-21515,7545,13,1575,27891,-19933,-18401,-28297,24487,-6251,-22155,-2573,-18569,-31097,31067,19117,-19869,-9563,247,4031,31145,8609,28719,-3639,-19357,-24665,6599,-2409,10887,-507,-2677,2327,-27549,-20999,-30613,-13523,-23111,-26009,17945,133,-13091,30591,-4567,32137,-21877,14611,1595,-1193,-10229,-24377,-7147,-3303,31169,15369,6857,21707,-13639,-23727,-23959,16307,-15021,15477,15633,15865,21985,16045,-31355,12611,-5085,-23287,30519,-12361,-23129,-2497,22287,-21821,-18149,15817,6341,-3215,18035,-11109,-23649,28133,-739,4297,-10863,-1941,5101,13979,-6347,2083,-12605,-9639,-24889,-29283,-30843,-12565,23205,-3495,22983,3815,24355,169,-2993,-1115,-5413,21229,13211,-17009,-31163,-19427,32015,-32747,11689,-18867,-4073,21673,15647,-31859,20525,-14223,-10929,-4081,10051,-32417,-11535,-23857,13639,-9509,-13357,15537,32121,-18513,-21399,-4095,31381,-26671,-10749,12351,17091,-1037,1281,-32737,4753,-9175,-15493,20637,28317,-16703,14687,15715,-4789,-24125,-20471,-26079,31793,17311,7007,-8679,10081,-291,4203,-19033,20767,-17075,-20613,18811,-2135,22459,-32141,-26163,-5391,-1473,4873,-23181,-11087,-32621,-28267,29427,28569,-12329,-27003,26931,-21013,-15223,26915,15629,4575,-12035,9571,10019,7799,-6441,1295,2309,-18353,-17239,-18369,2581,-20203,19983,28631,27761,11095,12757,-30551,-25707,-8183,3357,-25549,31027,1083,-31195,10497,-167,9969,17909,-30343,1615,-15135,637,3087,30297,-29743,-22959,-30643,-16153,2363,-21157,-28035,-15709,-2445,-8263,-19491,-14253,-28279,11123,20545,-23053,28231,-16915,30573,-13681,1385,-2053,9059,9493,-28203,-20509,12927,10215,30183,27289,8763,18271,27599,-5821,-12805,-28985,-2427,27489,-9835,23177,-28501,24983,-12523,10571,3823,6185,6585,-13249,3279,-23481,-24901,-22117,28961,16339,19911,-2239,28319,17717,-18017,-5703,-4111,-23515,2531,-15319,6309,-10097,22751,-20185,12225,5239,13007,-31463,32561,-27877,20363,20405,-16385,-11373,-11385,-11581,-32053,15567,17343,26875,21783,14355,30767,5239,-29727,2115,-4491,-8767,31343,9305,7759,-15897,-3409,-26479,6275,-7053,-11201,20531,-2007,2697,27219,19845,18949,-32509,17725,22751,28503,-19899,30639,24657,16201,-28611,22751,20987,9281,-11329,20787,4987,-4225,-2927,15511,-17557,-10653,31309,-29583,-2009,21995,-12459,-32409,-12165,-21721,-1595,30355,32515,-10317,-23479,12973,-4003,23681,-12473,-2117,-13895,25869,23363,-20391,24587,17347,27771,-10247,-19059,-5423,1771,-19511,10279,8641,-1433,2147,-28569,-7335,-17883,-22373,-10485,-12755,-11907,-7683,-30045,15879,-681,-10257,24881,-28633,22757,2089,29875,-18933,6623,17755,20287,-25367,-3259,-9435,11389,25041,-5953,5933,16791,-8555,-4081,12101,17161,-1411,-9139,-21051,2277,-10911,-22323,-23731,-20643,-30717,2933,-10005,-14565,-31315,26223,-10165,-16131,-30675,-21699,-15467,-7173,-6341,17667,-28761,-7899,-12597,-3023,-21209,19049,15727,7053,-32129,-1323,14825,-11811,-12439,24135,15765,-2083,-17607,-463,10425,29511,5713,-8639,10061,-14735,-3967,20573,-16121,9185,14105,19979,-29439,-1423,3011,-16775,-20137,31887,-27671,22655,1945,27075,-21081,15805,-4873,-12303,21805,-21183,22677,29581,14149,17385,7867,28137,-13855,32151,13723,-4511,-2945,18355,-2817,23827,16967,22037,19629,-3591,-9851,9641,15735,23973,10489,-11255,14285,27061,-9445,-30949,-32227,-13463,9839,-5545,-31441,-30843,29805,-27431,-13901,-8117,10401,19591,18319,-19119,15737,29323,-10741,18385,1413,7187,10635,7143,-19037,32603,8365,4917,-381,-10749,-1785,5201,-32669,-24777,28533,-29007,20341,16513,-6163,19389,28041,7135,-10823,7835,15021,9849,-18019,21175,21547,-4269,-3007,-19799,-13155,15357,22941,10471,12259,-21045,22593,10135,-6513,21729,25969,-13387,-28783,-3991,8345,10343,-31989,-10819,3757,22941,19085,6627,-28899,29911,-5579,-7719,23055,-28085,14435,-9267,5865,-20545,-28907,5329,-25155,20491,-2511,-28387,-13097,2669,19555,-7273,-28377,11263,16517,-4245,14745,22977,-28593,-22769,6491,13619,-20591,2179,-26873,-10647,-3919,-19681,24893,-19707,-19931,14353,-28091,21595,19795,11647,-20029,-927,-11383,22447,-14413,9139,-14183,29541,-10715,-30457,-14043,2483,-29447,-24373,11069,-16055,17607,14061,-21833,11585,-19185,29985,-3635,16501,-11467,-17329,-28185,-31325,5627,-695,-32475,15025,-8911,20553,-16353,-4745,-23391,-4121,-4479,-8707,-21621,-21711,-24133,23797,-28599,9725,-26971,-5915,-13129,28335,25297,15639,-28013,23911,-7681,-21757,1605,21443,5785,28243,10649,-23901,10785,-28501,18545,-7987,-28905,-30111,21809,-3687,22339,-24971,-13599,18971,21491,16189,-12893,25509,-2041,10813,-21335,6889,-22077,23,-14763,23219,-31429,12309,-25867,-8907,28877,-9853,-8387,-29141,5449,9783,-30991,-27287,-16539,5389,-27539,7749,20515,9517,-22773,18087,19621,-2405,617,12383,28351,-27051,16349,-30675,-26851,30597,-10809,-15555,-24727,7609,20727,-25447,27621,-20563,807,-19495,3979,15263,-2773,25413,8141,31581,-2749,-12433,21077,6515,-18181,-4949,-19405,5741,5299,-30307,4039,31453,9251,31109,-13119,28455,23745,28703,8119,-6383,-14843,-8795,-1247,-9165,14547,-28159,-5959,-29581,30829,2787,28877,-27515,15515,-30771,471,-14635,29395,-29149,23739,-11063,32453,-10439,-20259,1479,8343,17767,-29913,17243,-5591,-7365,-22719,2635,-29861,-30655,5187,-8923,-31739,-9197,17647,-15579,7667,-12873,24235,-9507,-31173,-869,-859,-20239,13511,1597,21085,29545,-9411,18135,-15723,26593,-18907,-3189,-4639,3093,-11949,-31235,-7171,31427,29439,-11413,-2761,-18245,-21597,-3421,-30755,17609,1513,-10765,-15557,-9675,-23537,-25031,28253,22211,-10009,-20119,7971,-573,1265,9777,22987,12517,-15959,3283,-26315,7513,27075,27561,2891,4217,11151,-23347,16775,-4483,2749,-26949,10141,31399,29565,-3611,-9297,29519,16731,-22931,-17019,10653,-5605,23483,31259,23185,1261,22487,-16527,24669,-29831,14499,7603,-13013,27557,-2193,18611,-22847,26235,13035,-30407,-19401,6569,15015,18857,-2123,6667,25851,25519,25563,-7931,-30319,15583,21665,12115,-5205,3467,-15061,12737,17007,12301,23515,25487,16029,24539,-6753,-17731,29067,32755,-2225,17659,-20001,21377,7719,-27903,-17119,-30707,-25923,-26455,3567,-23967,16567,-23831,10879,1719,23027,27689,5243,14541,-13389,-18637,2741,-29293,4681,29171,13987,-22139,4615,25757,-20931,-14013,10681,8923,26571,-1549,-18489,8331,-31209,-22941,21391,-11073,-12495,28803,-29807,-29293,81,27501,-21097,7331,-25195,7221,-23373,-20263,12775,407,545,19143,8373,-1263,-5279,-19037,29181,-15033,12291,-13251,18251,-31785,19121,31053,-18683,2215,-26311,-12899,-18799,20315,-19217,21469,-29983,31977,-17225,25655,-31533,-3209,-9901,20799,111,22227,19139,10473,-31545,26789,20961,21373,7693,-15961,32011,-27635,-24095,9065,-27763,-16261,12433,-31657,849,-24349,13501,15891,22707,19311,8235,-19991,-4177,29097,-4801,-18141,17959,-25083,-13917,-18215,17593,-26553,2963,29387,-23247,783,-22021,-1595,-9381,7207,19757,-22239,29853,1567,-13131,4107,-4227,-19003,20725,2547,-6049,27621,32233,26403,-3,-3713,32199,21315,5359,12965,-10817,-13455,-5263,8875,-6159,10405,16925,8473,-15479,-6285,-13549,6651,-24035,-11295,-11223,22277,-17979,-25357,-27399,-19635,-1667,26625,-2735,-29173,6717,31997,-18823,-30125,-26055,-14915,-24897,-24897,-25135,-27333,-1175,11035,-2333,24073,-30235,-29791,23059,-22651,-19043,-19647,8669,5953,18653,-32521,5925,-31557,-25323,-26291,-7515,14599,-4089,14095,-26631,6467,27981,563,-991,-24087,15963,-27283,-12747,-14289,15727,-3979,25885,27559,-27577,4065,28573,-30627,14301,-22207,23363,-24231,-29375,3123,-32097,1005,23707,-20039,24043,-12445,7285,-9711,7061,-26527,-18175,-24849,-9057,-15521,13349,11299,24279,10831,-21349,-27907,-12349,-26739,17295,1437,29883,29143,-23467,9111,-31173,18701,-3751,-28321,30185,19075,-4687,31797,-24999,-32085,-6409,20385,-28665,17373,4107,-4631,3817,-6601,-24735,5709,-7757,27571,29981,-18717,26563,19115,1647,18421,-2947,-19189,25619,3537,4539,-14779,31921,18303,-3119,-22923,-18341,901,-7757,10807,-30179,1393,-12993,25743,67,-15143,19551,-3797,-15879,28775,-32545,10815,-26123,3025,19049,9571,8389,14643,22519,-7321,28423,5675,18101,-2195,-5589,11297,-5321,16453,29273,21869,22743,-21213,23995,27393,-3951,16539,7897,9149,22621,10711,-18005,6513,6607,2389,25865,5671,-5215,-29887,-22993,-16293,7701,-17545,-9123,-5247,9921,-7127,-5391,26243,-1191,19075,-6029,-23237,30553,-26283,16295,-3163,-27003,-18827,25025,-23455,-27273,9493,31401,-18637,8711,-14129,4783,-26783,10277,-28437,-18559,3749,24253,-29741,-32067,-22139,-21427,28201,4245,24057,24493,17335,-21757,-3833,-15493,10529,-11647,-15451,15073,26053,15817,25067,17305,-21633,-20437,28717,26885,-30105,-17201,17479,-21409,23277,-27155,-25101,14743,-23691,-21149,-25357,-25805,-22847,9929,22907,21733,19593,23869,5155,-23245,-32733,-5873,-23729,5987,6867,-11227,27579,-27165,6689,239,11787,-32601,-18233,31473,24997,28983,-5127,3351,8183,-24469,-32419,18211,12593,-27527,10877,23847,-19465,-12391,-6863,-17767,-4153,30859,-15897,-17297,-12075,-12135,-28567,-28977,22047,6243,-16885,28001,-20409,-11803,-16553,25611,13339,-13055,31097,5537,-4931,7747,-25603,-22155,-7291,-11005,30651,-12441,-6641,-18991,9023,-12707,-7001,11139,-21021,-10063,-18007,-18981,-7633,-5353,-17615,23475,21961,9453,-31,-23315,17853,24771,-16345,-2855,-19001,-30983,-23597,16329,22005,15253,29343,5739,-16921,-4853,-1819,24921,4335,-32383,-20583,-1437,13379,-17191,-22059,14883,-9057,6439,-9007,-22369,1129,4049,12637,-16883,-17987,-767,13469,18341,-16479,25887,-12305,2981,7105,-8185,-30611,8225,16001,-30435,27221,-4509,21405,19637,-11081,-19931,29427,-9073,-10697,26565,-12771,-28721,-15187,-19861,-6435,13653,27265,-721,995,953,-4385,17267,8633,-11571,23875,-8991,-5225,-27589,329,-871,-28823,-18035,-27419,-27225,-18291,-5233,-13385,-9377,-12921,13783,-23315,19207,24555,2453,-8159,9831,9277,-16801,6179,20951,-3107,8273,20183,-11247,8333,265,-17735,-28951,-12211,8939,20177,-30661,29103,25149,-18443,3281,8935,30535,-19863,27755,-12939,-24957,27577,5017,13087,-685,10601,-22997,-12721,11067,-12525,-13303,-10305,-5831,31339,-3265,18411,-21773,-13853,-17333,-29299,-10215,-3127,-19791,4311,-27669,-22847,15597,-27589,16987,30513,24683,9157,25835,-26351,-14609,8193,1461,-25109,21877,24477,15049,15059,-9041,15035,31367,12767,-8827,-10069,29897,25177,-32575,-23985,-22627,131,15649,-3549,-12813,-4593,-3633,5959,2857,14877,7849,-15751,29615,1249,1421,2051,-15273,-23633,-30469,24251,25927,-871,21427,10603,3553,-17829,21151,24531,-2603,3019,8425,15165,3233,-18087,17649,-9327,-11423,9415,15217,23139,4897,-29181,-19297,-21433,-1181,-20859,3025,-27503,23565,5307,-8857,3871,-28325,-29165,-8535,2371,-3237,21403,-14921,-3521,-15409,4051,-30285,-27147,-27119,-27565,16331,6265,-18975,9571,-26587,-1193,-13271,22665,-23581,15531,6577,24157,2357,20035,13473,2601,-19655,4647,31741,10119,6825,3967,5069,-27577,6547,-20691,25925,-19075,-22527,30283,12129,14443,-12821,-24919,975,-14499,4823,-26727,26477,17759,13197,22535,11581,2527,31,-14327,-23383,-18021,5351,8189,-35,-20955,-15527,30831,-12199,1037,-32303,2741,-8339,20371,13879,18471,-4377,5629,32435,3693,-13143,-5857,-7827,13117,-17857,15113,26813,31755,-13085,-9751,2901,-14245,-22021,1173,24359,-10151,17057,26681,-31365,-14249,-26481,12287,-21693,20987,3157,17429,25537,-13531,-20007,-27349,-31197,5725,2513,16029,-30553,9033,-25597,1237,11371,12717,9495,3887,31477,26203,3933,-27817,-12003,-30985,8433,18355,-6101,-291,23751,9229,30023,-17657,-27789,-19827,1699,-26703,13943,31837,-18617,861,31953,21475,30643,32465,-15971,-9327,-3927,28631,-23043,4333,-4251,27803,14127,-26087,14395,18591,-29783,21705,5711,20827,10037,6403,-16719,3687,6953,-8609,5939,-11599,5045,22623,-23079,-26281,-31929,-2787,51,-14501,-21113,-9321,13007,-13601,-19991,-13319,11635,-30885,-22247,19421,21405,23493,-323,-9967,32639,17771,26859,11855,-8663,-8473,-22359,-24081,-5707,4439,26103,1343,23635,3795,-11569,-29545,-14067,20837,-6873,-2153,-12929,-16121,-32149,-28659,2017,2619,-30483,12925,29501,-28397,-17767,12627,8141,-22783,-9759,-6933,-18253,-15083,-22699,-29081,24735,10703,-20177,13945,-3263,-6213,7979,-8579,-21623,4443,1889,15129,-3419,-16571,-20763,-14609,-7351,24577,-17645,-28467,17305,957,26317,-11127,7467,-12691,907,25813,-3365,-23285,4517,22903,28735,22159,28865,25181,-14355,6365,14799,18041,30461,-7459,-2943,9427,-22861,-15245,1005,21199,-25823,13923,30775,27009,23615,6987,-24535,-23425,-6079,-5235,22053,-25289,9789,-227,30213,27845,-4081,19165,-13087,11467,25567,-3331,-30101,-17565,-1033,-6031,18059,7989,29295,-6417,-6235,-13383,28259,-5623,-14859,-4439,14429,24957,8147,18975,15793,-1863,-16869,22821,-17967,-11829,5737,11695,6489,811,-22211,-29757,17141,-32207,-22709,-12619,27027,-3221,-21267,-23715,-21831,-13043,-6675,1759,-2507,-19587,-28061,-5237,30277,-10175,21093,22811,7567,23811,17459,20099,-27623,30157,-23919,26383,8835,-18777,18879,17549,25275,-3803,22875,5513,-9369,12219,23531,-13031,-14597,-2325,16201,-14167,12333,-22615,-12319,31915,-15075,-15833,26751,-27293,20921,25137,-28597,-13109,1971,22417,-24007,2245,17759,2113,-12303,-29771,-25609,-6523,4809,591,30047,31871,26967,-31485,6059,-26087,24061,-32249,12755,-2039,-20707,17075,-9823,22273,8097,9695,23149,-11243,8223,28713,-18227,8811,30893,-20029,8583,-13109,-14651,4639,-19033,-18033,-16249,22679,3225,-9085,-4363,-28243,25397,13433,2665,-1989,-21861,26647,30785,6293,31621,5515,3717,-1409,23727,-7647,-17365,3359,29455,-1281,26089,-30141,-18545,-10651,23453,-15591,21065,19325,-20817,-14437,17283,5187,-4439,18841,-25833,21633,-20925,2571,1347,21383,-27209,-21303,11691,13461,10437,26279,21791,28255,-2123,9585,-18813,1841,-22893,-13645,12857,-8217,25687,-19521,25459,-13355,-17699,-29083,-3917,21687,-11585,-28981,2593,-24505,10645,-12639,32341,12315,14371,7399,25729,-31819,17221,12751,-12315,22717,-16443,-20223,5247,13377,-27701,-18535,25249,2483,-15527,-11355,-12545,28631,-23787,13421,-29373,-5051,11161,-7069,-2759,16447,-7443,6017,-24535,-23287,27685,-4353,11275,30229,17585,-19753,-16087,-10819,19977,-10617,2799,-30433,-18047,25153,-28853,-3781,4113,28193,21165,-10281,-8149,-4865,8043,17093,-19531,-16729,21717,16521,-30037,10973,-5387,9953,3697,-18765,23973,10529,-2839,26187,-17761,-7933,25401,8563,4401,29881,-7423,3271,-31167,28779,15957,-6263,-22081,-10667,-7097,-12941,-9495,25331,21557,12275,-4969,11561,-20761,15963,30195,-16943,32057,14571,-15447,13307,32161,-22867,23159,14069,-8813,-16693,-20417,21781,-6005,-29437,19939,-26553,-19287,30849,15859,14935,-16123,-16703,7107,-23761,6729,-25065,-31527,17113,23191,23533,-11585,-10135,-30989,6503,-18337,-8385,24101,-7249,-14275,-30235,-25049,-20853,-17249,-10015,13031,-9969,7365,-16601,-2779,12821,-15585,-22491,-30449,-27943,-27359,4935,21851,-14499,-29935,-31643,-32677,-28039,-6589,-665,5827,20703,11883,1875,-20621,19949,10305,-24611,-2303,22305,5363,26221,-21629,-7583,-16189,-10587,27277,10009,29887,-23385,18773,32323,-30385,-133,-26157,-25951,24407,20205,21037,-4893,-7443,-6831,-89,-121,-25387,-18837,-6467,8831,-16791,23691,-32665,16933,31649,-23003,7541,31589,21225,6893,-16825,-30769,-8833,-22347,-17901,-16703,15255,-1071,9019,-12043,-411,13685,-25521,29245,-15247,-32289,4857,-32183,-14827,1013,-29335,-23117,20903,-12017,-13633,26469,5505,-29823,-32515,-6477,-24425,31677,-17829,2911,32503,24129,4681,21449,25287,107,16913,29571,24525,22367,9123,-25453,-8839,-11889,-11355,-24903,-6399,-28103,-28101,-495,-7709,-27313,-2103,-24135,-7147,1335,15393,-20667,-26537,13821,18199,10255,-2243,31773,4457,817,23569,21209,2637,-12759,-22295,-17129,-29327,-23643,3521,-1833,-32357,16753,9055,16159,-13509,4181,-13515,-21945,-29875,-20815,-18325,20749,20003,-4835,-18819,12205,-12405,9599,25651,32669,-1639,20725,-18105,-30233,-1757,-3651,-30797,-25669,-20193,229,29849,-21473,31895,-30491,-1637,-8279,-32591,-30949,21549,19057,-6677,23665,-11053,-7209,-2819,-25703,-5387,2721,24483,-21061,26145,9345,-24107,4621,-17269,-13131,14271,-16293,19419,-10185,27523,15785,-16273,15257,-19723,-16793,12289,18675,25983,15195,-19625,28401,-24039,31611,-21837,-27165,-6827,-18359,30697,10109,15697,30655,-22169,-49,6743,1569,5121,-2203,-6127,15311,24323,-5213,2451,-32683,-4341,25183,19981,-6923,14687,-25665,-28341,7137,23391,-16885,9767,-14201,-28711,-22773,-27455,-23435,30065,12555,29875,30257,25321,25961,-32387,-5285,24763,-20627,-13641,15961,3319,1955,963,32557,14961,-31277,20041,30215,-29987,24395,-1759,-12585,17913,-18401,30487,-17629,26567,13247,22425,-8477,-28871,-22873,-13833,-3777,7683,2789,3307,-25559,-17261,11323,-24113,27499,1567,-22455,6573,19501,-11365,13511,1163,-14567,-19823,-5171,32119,5419,-31985,2243,-6029,20291,-10655,23107,-8863,-27955,9443,17265,-20239,28167,-27189,-771,-5263,9663,-12025,849,18755,-4783,-8771,7705,-9791,-11699,25351,-32549,8707,-8407,-13511,-21189,-21515,-5591,-13677,-3323,-28761,25939,19569,-28351,-4403,26639,28711,-4029,25277,11737,-3669,-4889,-2881,2211,-11637,16581,24783,-23225,28963,-6767,-32487,-6233,22739,24545,-20589,-27213,-22069,5095,-23655,13671,-14625,-13615,16769,13031,-27809,-28151,1017,-12271,-7387,17489,13751,14823,16261,19013,-2913,28503,-22989,-3123,-9557,-7853,-23539,7737,-8097,-1199,4343,-13597,31201,29613,25501,-3951,-24527,25805,-12929,10945,-7207,-25483,29941,-19669,15079,-13849,-11787,-18527,26719,-1257,16095,-31153,16771,7743,-30775,-393,-6905,-14185,-19061,20687,24571,6501,949,-1431,-20953,-3385,-24405,-15083,-28987,-14981,-6515,-22671,28377,-29215,8923,22601,17597,-26247,-29421,-32527,-28657,22427,29799,6099,-18313,25533,-11237,-11643,-4245,2975,-11701,-4407,-29535,10255,-30643,6943,29211,6293,-32443,21923,8701,25367,22183,-9289,-22349,2311,-21523,-20991,18485,14825,-4873,-635,-20587,-3785,11657,24461,20867,31669,-25329,-16823,7685,-14459,27029,-28715,28573,31379,6993,22341,25227,-22353,-6973,21865,15867,-14629,-17043,-12031,17223,-4093,14447,-1161,15775,27283,-16289,22133,-5219,2763,-31413,27795,2421,-20255,-8041,-15481,12791,6581,24341,6835,-14989,-32397,2529,10459,-3629,6513,5387,15701,-28493,27295,-3,-9241,-14611,26939,-16341,2133,-7023,-16527,7587,-21051,-14025,-14851,-747,-997,9541,-20015,-20671,29715,-22137,24493,26417,-21227,-20359,-24719,22109,-18767,-17287,13675,1291,-5651,-21609,3299,-16887,-11669,1959,18471,-5793,2727,1589,11927,23715,-27309,2451,-30569,-8555,31339,-3707,-6857,22017,28323,32121,-12445,19115,-15015,9469,23627,-65,-5607,-3549,-14557,11487,-8909,-10099,-32511,-7213,-1317,-6281,8319,21261,-27485,-4065,10545,-2891,-29383,17733,-12903,-14281,11803,-24193,-4459,-3039,29245,11043,-25677,24937,5247,19087,-819,-8439,-30329,21991,28553,-27887,-25593,2869,-27981,-17471,14043,3939,4037,5277,7219,10293,-26847,-22397,-14401,-31719,17239,691,-18247,-10665,-28415,-29903,-10857,10207,-22301,28823,-26641,27839,9637,12021,-13673,7043,11841,-22975,-23697,8325,-25689,19923,15285,-25091,-5643,-17429,-14689,21767,7197,-29241,-32405,19309,-26591,26913,5929,-28921,-28567,-25337,-547,25023,15793,597,-9117,-16869,21571,2405,-22693,-6649,19131,18121,20813,-26941,27609,31473,-30771,20733,-5641,8231,-25467,17459,24635,-6639,2203,-4143,12847,-25567,-14675,10985,-2281,-12473,-23963,4419,9283,-25375,75,1809,29249,-9175,-7043,26211,1951,397,-28551,-26713,-853,-4713,6285,-21789,-20849,-23011,17105,29039,-4309,-12697,16399,-30331,5881,-2273,-15277,-8685,23437,18609,7147,-16227,2575,19165,-22035,-15641,24019,-18683,31571,27975,25231,30849,20207,17937,1329,-18199,24663,-16091,-6559,23181,-5599,-22753,19725,29599,-5473,-5693,-18257,24103,3507,8491,-27377,-32043,-12401,20375,24429,-527,-20085,-24745,-14075,7793,-30215,-17083,-16561,22833,-27773,883,19759,993,30123,10943,23419,-16077,-20195,-26481,32347,-15101,-11637,9705,29911,-1427,-3689,31987,17143,2399,-14999,639,29759,-11673,18985,-10979,1773,18879,32585,-21035,1521,-26543,14499,5473,25785,-23855,-17439,11067,6221,-1507,12769,-17121,-677,2137,-27951,29995,23267,1447,1301,28499,26989,11163,-8211,69,31243,-27793,-7379,4957,-6027,11285,-7855,8281,-25355,-5493,4845,9483,-17737,2969,-2715,-31509,-10689,-32755,5109,8301,-25957,-23401,19571,8079,-21805,-14045,-1243,-13297,26203,-25095,-21739,20395,25451,2347,26809,14985,-4491,-8837,29989,-24637,18569,-15183,-3239,9885,5981,-11221,-14669,-14845,-12495,13035,-21039,-1403,-18335,-29067,14143,-11847,18189,-32715,24881,-20549,-14587,-23687,10349,-18281,-29181,-10799,16653,23733,-31825,-47,-17429,-7283,-8563,-12695,-5219,12925,18627,-2257,-6811,-12459,30067,-18507,-32425,-2477,-23745,18379,26843,-4643,-5761,15373,20017,-28265,-27311,-19423,-19009,-12211,-2137,31869,-18087,-1495,13745,-9369,1801,-19983,-19565,8809,-4643,-2151,17079,-15275,30513,17341,11553,-6289,1393,14029,-18069,-27615,-21729,13485,16037,26043,-14127,-26665,21603,11491,-30373,23715,-23145,-9097,-30307,12531,31629,29759,-12873,23575,-2595,21435,5241,-5651,-29649,-13049,23729,6893,19997,28817,22681,-13069,995,4375,-12039,11363,10663,-31981,-19795,-10579,-22059,13317,9529,31429,9505,-27031,20699,25397,-3933,11215,11367,-14879,-6033,-31999,10833,8073,7067,23281,-26335,-5001,25997,8083,-10465,-13047,-9023,-17201,5645,28761,-15571,15325,851,-16925,5503,-8263,-9929,-28333,22341,-24985,-11523,-27513,-21513,-30653,20093,633,12083,-31079,9767,-12385,30719,431,7853,-19401,799,-11561,-347,-30829,4495,-15697,18257,13015,-10991,3039,-661,29797,20815,5771,-15081,15211,-14599,-21101,-5775,-27251,-4971,7333,10101,18199,-7181,4953,11185,22249,-31149,26489,-3419,-21203,-15373,-6199,-11895,-3007,20339,-19287,28627,18925,12453,27717,17347,23481,-13559,-27401,14823,32413,-29713,-18171,-14009,1461,12851,22031,587,23851,-30667,-17015,-5067,-263,-32581,2389,15771,-29203,23809,-15205,21145,-9597,21397,23167,-865,6451,14023,19429,22983,3663,-5877,21035,23545,10015,15049,13799,-30003,-3177,7643,-22745,-22045,13807,-12665,-21389,1821,-923,-4633,32057,17073,-30331,-13013,16039,1469,-22593,-16687,3047,2127,3609,28769,9229,-11093,-1207,28451,7401,561,-13011,-5711,-8045,-22335,-8355,16677,-19507,4311,26503,-2765,-11501,1307,-4447,19705,19093,-25729,19631,14127,-11629,-30607,20245,-12449,6891,-1015,-26237,-19183,-11667,-25755,-16593,32273,29077,-16543,879,25219,25469,-21293,-9635,-4645,-18215,32575,13647,-29917,-345,24549,30583,-1419,-22895,9357,19237,-29643,24323,29241,-1377,-27893,12741,14579,-26401,2469,-19585,-4885,7387,17467,16003,4805,7453,4041,17031,-21561,5155,2449,-7471,-2687,-18595,4333,-8833,-30885,9753,-4001,-29971,-30131,22479,-18903,-25451,-23535,-18833,-21583,-28677,16919,-27081,-27097,25187,4117,26763,20337,-22079,22615,-14849,19575,2497,16441,16215,3513,32259,-15855,-19051,-10231,-3447,-27809,-1499,-32227,-26283,6555,3221,-23403,-3493,8651,-25745,13537,-32513,-23567,-6715,28079,4423,2691,4387,-5217,-28875,-26869,-8607,20111,13899,29623,-9939,431,28919,23299,-681,-2591,22507,-10471,21765,-15007,1303,-10491,27073,2295,15045,28505,9657,30415,-7305,27505,-12565,5847,20531,26199,-2503,-4585,-15281,-11575,10773,32055,-31963,22333,8661,10765,-20995,12217,-9395,30785,11953,131,12379,17099,4257,-27741,1355,469,5709,-14053,-4857,10339,15903,14435,-13983,-26245,-6845,17755,18781,18771,-17207,-13067,28599,19593,-17095,17357,10661,-21205,-26729,-22363,-18569,28847,-10243,-3321,-8585,14675,-28337,21117,-30887,31445,14441,10181,-27157,-4435,19611,18671,-2377,8857,3709,12343,4331,32763,26023,-30327,-11797,15085,18159,-21189,-17205,32097,-22673,-6313,30785,-16529,-19095,27875,27465,-32749,-14873,-24043,-22975,-15879,18943,3639,-2187,-17235,28243,4065,22791,-1949,-13719,14123,-30343,-16955,20439,-28611,10513,6009,-5909,23087,-29067,9689,-29813,-26153,-27325,-11209,16047,15857,24731,9693,-9965,14593,14643,9897,9041,16615,5427,30985,2479,18863,22825,30943,17233,-25487,3607,-14235,-2597,-10769,5593,-2175,-11593,26973,23113,17551,-16559,-14613,-9925,30941,-6551,27171,6725,27803,22739,25195,22557,-4149,-14879,6151,3955,-12181,-6657,30199,-31995,6289,-21221,26445,-11901,-29579,1141,-25351,-2397,905,-4111,16047,6329,-21735,-31965,3001,30993,26193,10233,12401,18671,23473,-14995,21001,-25321,4431,17163,32295,-143,2499,-20523,10833,-14335,14541,-2705,11395,21173,4577,-16773,15783,22343,8499,-30687,-14101,-28645,20111,32441,26969,14755,-16371,29107,-32037,-25857,15801,15021,3521,-29573,10055,-27119,-27055,-147,10965,-25645,-18567,15709,-16767,-26933,-28409,-18027,28709,26229,22817,26257,29267,-17853,10627,23073,12193,-4881,8879,-15975,-32549,-4507,-21687,-8709,6381,25627,13911,-23611,21037,-12457,6465,-1043,18687,18329,-24805,-3565,-20753,-29447,-11295,-9413,-21737,815,-23065,16399,-24489,2757,-13191,-8219,1361,-8857,1837,1341,-27533,21103,-25291,-14587,-13455,4831,-30407,-19165,31199,3405,-12571,-32259,-25953,-791,-767,12263,-6357,-28519,-22943,-16797,3505,30111,12143,-11289,-17837,16205,-8631,-991,-25061,-27205,29149,18845,-26885,-22581,-23029,-5913,7599,-30665,11475,-27281,23621,-26189,12513,-947,-13845,-3893,21281,-23353,-24447,-8707,-12023,26109,-14067,21,19821,-1995,1865,-8983,-11017,13755,-24419,7605,5831,25027,27347,467,-27183,26133,-18861,25129,27033,-27091,-9015,-20703,19421,22951,-20849,-23991,-15679,-17975,-315,10177,-26195,-27009,6579,9869,-23981,-25459,15303,31339,471,-30557,16549,3591,-3615,-21587,-28563,31571,24399,19893,25587,-26237,-11761,28627,-17875,21727,-19665,14485,-27705,-29909,10643,17317,-18537,-10045,-22307,3253,12705,1929,27351,26403,10871,-12613,-10789,-24553,-12271,-28147,18015,5531,23729,32387,-5435,-11489,25265,8335,16867,-25717,-32603,20869,-12329,1099,24009,19331,13659,-17849,807,-23309,-12177,-13361,-1531,12965,-18039,-25487,15805,-7673,691,-363,-11599,2307,-26797,32335,-19627,13079,-12437,1163,2323,-24149,17771,14083,-19259,32429,23237,-2641,-27645,5149,14845,-12837,-16045,-19175,-5539,20161,25721,7175,1039,15407,13961,19809,-14371,23021,-16959,13865,-13283,23841,-4699,-19877,6503,-26153,15477,-3757,4023,26833,-26171,-22425,-14187,17009,8351,-24431,-3777,13141,-8671,13257,-28527,29199,22049,18405,-6689,6309,-22337,21587,-4811,-2635,8033,-2853,-10015,4539,-10145,-13141,27379,26063,-21663,-13275,971,-16681,-4675,-29155,-27589,13711,21873,21329,-16951,-25565,6919,19865,14161,23341,-17475,-6157,-9101,-9569,27375,26383,2247,-9993,1737,-685,-4917,-1749,-2171,-19063,-4187,12243,-32249,-9239,23949,-12019,27891,-17995,-4453,-15969,4663,-15415,21473,-13803,-11449,17425,-25349,-4615,5943,-6353,-20555,9599,-16909,4983,-30319,16753,24137,-18309,6655,19331,14161,-32563,-16389,-22099,25775,10299,2183,-12687,-15995,-21271,-20335,25659,-31089,-10449,10613,-25447,-23175,1963,4223,-23715,-30867,24131,-23357,-30879,-21721,5123,-17055,-20873,-25039,27871,-14269,17723,11009,17817,24859,3191,17605,-10911,-25029,-14677,-8721,9951,-19819,-10641,-25073,-32061,7313,22273,-14393,-25521,21409,25957,-7837,-17385,-2845,-3067,23717,14087,-18653,-3257,28763,12285,-27703,-2593,-8847,-12865,27733,1953,27911,-23205,-30887,23331,10551,-18117,18471,1433,9565,-523,-23261,-871,18369,-12977,24881,-13289,28293,-18305,28391,-1587,31723,-22435,14839,29109,14611,-19385,2225,-30053,11037,29411,-15257,-1675,15509,29311,-5619,32039,23133,-32503,-1775,-15583,17083,-9203,21277,-28307,-9007,347,-20033,4319,22841,30837,13693,-29667,29161,-23697,23737,20875,15987,-21647,17865,-23759,27837,-22243,12395,-24159,-13681,-2129,-12891,31861,-4403,-27439,-26365,-6907,16625,-26155,-10789,-15663,-15909,31297,3777,-30215,-27415,-5339,-21023,4541,27359,24161,19749,-17699,-16981,-2033,6903,3213,-13171,2519,-14095,789,-10241,24671,4585,26661,15279,14763,6693,8385,-1459,31055,12397,6043,-31101,-29981,-8195,1161,-28609,-9793,14771,-3751,-27553,-32491,12311,-893,-28145,-24943,-1099,-10383,-6745,-17527,-16305,9725,-18649,-10009,-997,7435,30729,27099,-14591,-27055,7103,12509,-27611,-11861,-10545,19289,30839,-2521,14485,29671,28513,17023,28435,3555,19717,27197,-19245,-1013,-17109,-12005,5603,-22147,-4057,-30929,-16793,11913,8575,3209,-2711,16231,24525,15961,15221,6627,21297,-29111,1737,2145,-7731,10425,16837,3375,24371,-11399,10633,-6823,-4225,23891,5541,-11589,-17331,-12381,31885,-10601,-12193,-9151,-17853,24313,-5779,32221,11121,-6675,-12695,-19613,-18301,-1541,26755,20729,-3979,13021,3813,-17637,-16987,2319,24863,12985,-19829,-28523,-17803,11085,-31011,26635,-10283,25137,14697,-4793,-18579,-6791,16251,20121,18041,27625,31601,29993,-12541,29381,-5041,-9267,13211,6347,23641,-19455,2595,7995,-5057,-1129,26245,29567,22881,3143,-1537,29617,9399,27537,7279,-23931,24661,15363,203,-5655,23933,30569,-14627,-24957,28129,-16859,-877,-2901,-3139,30677,30993,20065,26943,30227,-8225,21133,28041,12081,-9231,10149,-25133,1735,32215,-10931,-27219,23081,25797,-22419,-1763,-17021,-24561,-30805,32565,-28905,-29145,18449,17025,-6791,-7523,-30763,-2057,-791,-18299,-19701,19049,4503,-30495,-10297,-7843,9699,7665,18729,6081,-31585,9757,11263,5575,20541,-8241,8699,-5955,-18325,20189,17783,-30251,32173,-12707,3303,-24077,2265,-21697,31867,24999,-2437,-24143,7649,26463,-32219,-19677,17193,10705,17249,-31117,30839,-25865,9637,21031,-31739,-11391,18845,-14975,6187,-28849,14711,-32507,-1093,-26337,-32681,19809,6823,32287,23141,-23917,-17067,-15901,-12331,25349,-24463,7299,-30015,14887,-29525,-4649,-23893,-8531,-21229,22845,-9035,-29593,30331,-23003,25073,-10601,11835,9349,21347,13917,-567,19111,7595,23095,31737,12681,1707,-26563,30983,-3241,-32115,-26649,4229,24609,-185,30179,-15575,8267,4929,-22697,-2959,-17791,-6685,13237,-27463,-15693,-4291,24945,7493,-31855,13899,27791,8317,-17041,-26105,-10241,5659,-2349,7703,4767,-29897,18683,12059,30321,-2877,8095,-21613,-15695,-22469,18795,12773,-27701,22471,-9593,-18049,-17181,19605,-31233,-24757,18983,13943,-17469,-19459,7939,-23829,-25175,-29149,2235,-18689,31147,-28967,-11395,-32649,-23551,-11057,253,30105,28807,-13241,-4045,-32717,321,17205,8373,6179,-22001,19551,-5415,-15991,-32485,30291,18639,-14081,-24879,30965,-2237,11267,17983,-27199,12625,23507,27207,4725,32125,-24449,32505,2067,5427,-21051,7365,-11801,1295,-6171,17613,-11445,-14785,-8901,5073,-25535,8143,-1657,-15661,-31337,4049,-5269,23827,18149,8929,-19465,-15871,18339,12527,-30353,7367,-6529,32197,2607,7171,-17163,7389,-27725,10775,8913,-23815,9377,26225,-32275,-30657,-25419,-16977,2287,18939,-1133,1947,-8477,-26987,25863,-9145,12343,24443,-24721,-19385,2851,-16093,32485,5549,-21123,-21841,-30341,19955,19481,-3615,30049,10037,5815,-8451,24703,2253,-14115,-3641,-8989,27467,12597,-29159,-18213,-16895,-10471,22711,30029,7321,3239,24161,965,1763,-3909,29439,-1803,29481,-16847,-3977,-8207,-3275,-19881,15231,8729,11055,9653,27917,-27211,11413,-255,20321,22797,23255,-21829,24605,10907,-18067,16867,27173,-10947,8915,11063,15651,-27229,-29419,-10785,-18833,-2423,-29417,10603,-10591,-19335,17145,-29125,28603,30505,-5223,14137,8535,-32629,-27327,30843,-13943,-9681,5313,26211,-13001,18671,26369,-28501,14661,-25497,-25937,-18059,10075,-29695,1635,-6711,-13007,-4883,-20761,12283,4701,-30139,3305,14137,25493,-13167,-21431,-17219,-17305,-17185,-25473,4051,-17219,-6191,-6647,4419,6087,-17185,20523,17125,-19129,5727,-22057,2371,-1621,4275,12837,4597,-27525,28843,-8549,3029,26721,-21883,28261,-12095,-16765,9957,10409,8291,-4489,-25019,-29509,-617,28417,-15533,5199,-1835,11127,29235,-21929,-8035,8541,549,22657,17757,-26763,15387,-2223,-25769,6881,-21549,26025,24571,6467,13201,23107,-3231,16577,-2797,-25043,4833,16945,18097,-2659,-24109,-7895,-11807,-15535,-14509,-24085,2313,-12137,5523,24291,28897,-24141,24989,-19895,-31175,-22235,8037,11367,-10375,-3849,31591,-28041,23087,-13863,29755,-19055,-11439,-4259,-22603,-10783,-32267,28837,12067,25135,-13001,23603,437,-2971,-20573,-23911,-21113,745,-15785,19825,10645,-7433,30835,-11381,3897,10983,-25597,-1949,3983,24495,673,-32163,20043,10401,-3119,-14007,-32467,13911,-31839,21189,9499,-7085,-8859,-2567,-23789,-3109,23065,17995,-13511,-8545,22363,6363,28465,-17875,22477,9155,-21521,-27367,-1175,32747,5931,-6801,-22455,7559,7417,6555,-17581,-239,-25083,7685,-19721,6409,-28675,-26021,23101,1533,-15909,-26823,28597,-12199,24203,4519,-17417,6503,26671,-26329,18819,16545,-6255,-27981,-10145,-10685,-25209,-32585,4077,18693,3163,8927,24215,4207,-20141,-28331,-9331,31485,24663,-16739,-6605,-14429,6429,19695,-1671,5331,12399,-23523,9107,25437,-29487,29577,-3129,2783,21569,20997,-22435,7957,22191,-16047,5117,-11115,21501,-8079,-15521,18921,21657,1461,26145,12469,-28459,-3191,29957,-11839,30163,13503,-6319,5267,-15399,25231,31323,-1257,13673,17803,-30671,-5663,17741,-9845,-19469,-32407,25703,-15653,6201,-6837,23929,-20049,11859,11425,-13823,26955,-20607,4949,7491,1739,-19901,6725,-20319,-22263,-5353,9191,-14017,-14387,7697,31513,-7259,-5363,13489,9133,-8089,19373,17409,-29433,3723,22789,27803,3727,26881,-12417,15397,-24625,32489,10713,-1445,3929,21617,31015,-9799,-24787,-9833,3215,6041,11855,16323,8433,15657,9809,17509,21061,20835,-3159,21163,27943,18197,31193,-16049,-26079,28773,-6477,-9279,-13483,-16181,-1125,7371,15267,19591,13263,573,31643,4879,-12013,-14359,16759,-9089,-22393,-6131,9571,5957,30883,17247,-2007,3373,-14277,12493,-13761,-20241,-9263,23065,11707,591,25739,-11011,-10617,-14695,-5689,-14241,18773,26345,30369,27389,2201,13229,26419,217,10009,-17975,2669,11735,13161,6359,-21321,-25085,16093,-7295,1403,-22799,29835,30103,9633,8271,-8015,26667,-2033,16671,20823,3801,32037,-8537,20229,-9471,2219,-3323,-28329,27113,1933,-21751,-26977,13633,9421,-6531,-18883,3927,-24917,20501,19057,13933,-3667,20971,-11255,9363,2935,20421,-9015,-30075,29049,-22089,-9785,20489,18455,-959,-16875,883,5741,5729,-15321,16965,-11223,-26205,-2459,14629,21157,-25381,-18963,32677,11371,8025,-10669,-14299,-16455,-23253,1401,13853,-28677,21211,-28963,201,18737,21271,6341,4835,-15677,3671,10023,13833,-29285,28233,-25167,-30967,5429,18245,9379,2155,27323,-4373,17349,15907,23095,-31659,29033,25495,16281,3057,-28021,-26743,6651,24375,11501,28431,25425,14803,14595,-6337,29101,20019,-12153,-1677,-13079,-22119,15019,-13817,28831,-4067,-16183,-31341,-2733,801,19817,-11869,-20633,-627,-13353,7001,10027,24991,261,-11283,12731,-25283,25761,-18431,-16539,12225,15831,-9935,2399,-129,-12035,31117,-4993,22477,21961,2533,19115,1129,10803,18509,-29277,15105,30623,30153,-15507,2565,24253,-9941,55,-14207,1755,-14519,7099,22041,15117,-14083,-16483,-32425,-16059,16645,22303,28625,12265,28501,26151,-25557,28917,3015,-13001,-31091,12409,28097,-18659,13335,-26267,22699,15975,-5809,-11043,-27099,-9505,7201,-14707,8697,23113,25143,-15095,16185,-13905,32293,-4331,-15137,-22403,24225,-21547,-1165,-16689,-7487,-32155,28375,-20801,10965,-10029,-14465,-5861,-18129,18735,28559,9135,-32049,-25087,-8031,17819,-23835,-2593,-12203,9957,32607,5373,-30811,-265,-18627,-29873,-31153,1829,1819,31491,9155,-13979,-10121,10377,-3285,28359,-20245,29389,-11731,10933,-15791,8505,925,-2445,-32757,-9671,22225,-12181,-12795,31433,-4031,-7307,-27299,22145,-7699,16609,-29055,5109,-1471,-21135,-25825,-29163,24551,18075,-30229,-4633,-31373,-28477,-31523,17495,-26843,-16049,-30265,5945,10601,17911,27105,3023,6473,-27761,11423,13429,-11441,-28105,-12737,-2227,-28197,28003,-21183,2891,-879,31049,30177,1675,27647,-6463,16223,20489,22847,13887,15419,-1579,-23547,-12061,-28691,-19753,-2321,28881,-32291,30551,3153,-24959,29435,-13651,-29193,2249,-23461,5573,17289,-13557,-10525,-25647,29053,-7349,-2527,-9357,4747,-5343,17283,877,-7647,29305,31851,-29325,13405,-11967,-7991,-29019,15059,-8259,-28739,17403,-18417,17681,21049,6893,19341,4677,11225,-17799,4793,-13173,-26267,14847,-22065,6887,-12107,-943,1817,-3217,-18709,30365,4839,-17441,-29895,-11175,-28969,6689,18569,-12173,-12169,2811,29507,7007,-24335,-11055,25393,20329,29941,24167,-22577,-22209,5567,-30665,-28947,-12755,-29319,-28213,501,29245,9187,-10747,23335,9341,17837,795,-18949,5473,21001,-22839,29323,-7835,28975,-31083,23767,18919,-31929,14239,17439,22399,7229,-30575,21609,25653,-4563,23701,24479,32549,10983,23595,-5685,-2359,-8959,-1273,2073,24267,11213,13783,-26133,23683,-28321,19419,-13975,-16361,-27241,-19453,-20889,16223,14757,27121,21131,-11793,19793,-14957,6053,16317,-28753,-14977,-12781,1921,28079,-19347,12147,3243,-19837,-30977,23883,-20971,-21017,-27605,-1367,13865,-20075,933,11809,27331,4221,17533,5451,-19619,6631,30629,-17555,30707,-12023,20799,-1663,14315,-6709,15095,9437,-12451,-29787,29767,-16263,-18413,-28095,26061,32257,-31533,-26271,-709,843,-7785,25873,23219,-19363,583,31935,-1023,25441,-31365,-17187,-7577,-28247,-25969,-28575,27001,-19641,32429,27861,-6265,7587,17573,-22549,-3921,-5937,23047,29613,32689,3093,10977,-39,-4111,14623,5191,-8941,-15851,-25119,-9097,-9773,20091,9287,-31971,9169,25609,25665,-21231,-18901,22535,3489,-23897,3913,13081,-23481,-853,-12341,-167,3983,6275,-8697,7795,-10315,-30339,-695,28323,31311,-9905,-20993,-23263,-10519,12193,-24807,-24291,-1425,1861,-9273,-21839,5877,-10131,24057,-31201,-11993,-2877,9457,-6355,-7035,24459,-14167,-30699,31505,-17777,25269,21903,-4205,22911,-17275,26945,15093,-28391,-23917,9289,5877,6719,2695,-4145,-15265,1553,3169,-29235,-465,-22501,7793,32263,-6183,6237,16533,-12043,15445,-2449,-22261,-30645,21759,4487,-29325,-2009,-27477,-5523,18751,29047,17995,-20803,-21931,9487,623,-29507,-28473,30317,2697,28529,7785,22907,28685,27867,22935,-30157,-10617,-18923,-23121,21495,-24023,-12997,-27337,-24303,9943,-15625,-17721,-13391,-25979,5137,4117,32427,-7725,-12277,14319,7995,17367,-29371,-3019,-18505,-8701,-32395,-21425,3907,-24661,21249,3597,31443,-31503,-22415,15653,22725,-21367,1035,-3785,-11263,5313,4731,-8683,-14521,-21219,-17011,-391,21977,4653,7317,18387,6315,22797,15593,-7407,-6635,20277,-14411,-22019,-19055,-24203,31825,-22213,-8631,4073,27637,28299,10235,-11059,-26689,11401,-15805,18511,17931,15177,-7055,-30437,-17991,31493,29533,-5599,-13067,-13977,21299,-6543,-11749,27689,-3507,29509,-20965,4041,6441,-29673,-27237,24299,-14723,-21577,19135,12357,4833,3613,14051,-32093,-3981,-22235,27111,-4441,3147,-20905,-28649,29183,-6911,5795,-12577,219,-7589,-32081,27875,-30297,-20161,30179,-28929,-21535,-23183,10233,-7039,22613,9073,-23727,-14527,-2249,-10391,-6893,-15563,30381,25683,13713,27777,21325,-15819,-21435,16809,-31237,-19685,5835,28505,14503,-1963,22047,-11215,21467,24751,-19873,-2889,-26497,2565,21459,15101,30345,3755,-32055,-7287,-12501,-7777,27777,-27643,28125,-18035,-22561,-6217,5329,-24237,-15379,32453,-29451,29721,-1463,-32225,3727,-32271,17835,-18299,-20281,-22743,15381,17039,-12065,29911,-813,-11,-20915,-7219,10529,13657,11863,1217,-6435,20513,-17435,13775,30191,-14659,-31967,31799,-3453,27057,-7745,13309,7487,-17005,26671,2365,19677,22793,-29829,-15145,-17313,-13431,24953,27491,25621,-20153,20749,21199,-30093,1889,19641,-20241,-30125,3435,-4447,27191,5595,-21817,19543,-3053,-30677,9773,22247,9245,-3411,12933,31559,-23167,26339,-7893,-18275,-5393,-13191,-19727,-27795,-26697,-10723,-13815,-27941,-17373,16225,-18043,10189,3545,-8423,-32301,-16577,31441,25901,16899,-8383,-6057,11939,-23799,6349,7005,-31729,29557,-11431,-3195,-29385,-23973,27083,30703,-21713,4235,-25635,24873,-31115,9395,16467,-15821,11765,-9749,-22765,31325,24697,-12455,28481,-1273,8677,-5287,-26895,21677,-1351,30205,17515,-21001,-17827,-5153,11375,12383,23597,23819,-29901,19911,24297,-4313,-14515,23959,14699,29337,-23885,9263,13349,15553,31221,-5805,11605,-7969,5113,-11333,29275,-14049,-17461,-26579,13153,-223,19659,-16407,-12723,-16253,20779,-18093,25219,-30711,26095,4695,-8327,17393,28625,7461,21001,-23331,28457,691,3623,8827,-26229,14413,10511,29575,-11119,-3487,-32151,30711,13739,11483,31297,26251,-87,12089,8697,26769,-983,-18063,-32431,23113,15325,17559,-18565,-20779,-9133,17959,25041,-8759,20693,-27269,8909,-23893,2621,-10897,15121,-16345,2573,-32021,-27057,-25101,30099,9367,775,-31763,-18163,-17871,-15635,-5447,-11495,-8281,12021,29075,26849,-22371,-22369,-5171,-23185,-25959,3939,-12379,-3241,29531,9325,20275,28283,1523,6095,1507,19333,-1929,-8031,-9267,-383,-20461,2731,11885,2881,-25641,347,-21399,-22987,27259,-24471,-5437,15731,7741,9357,-18573,19441,-26581,-3639,-27463,-30319,195,-30193,16199,8085,24375,-6567,-24861,-5003,-6617,-6653,26809,10245,16989,-28785,-25357,-13811,-22115,-1181,-7677,6125,-22313,-32599,21629,-539,19259,6977,12437,14153,-27945,1901,30135,27121,8135,11707,18715,27003,-6445,-19723,-23667,3605,9911,-22931,1299,-14969,-10003,8553,12669,2833,8103,-23673,30169,4183,-29195,9053,24997,31143,-19931,9799,2749,-27741,21199,22001,13935,27383,14619,-6053,29223,11471,29089,-12953,-1675,641,10931,-5507,14519,28231,-8047,9797,31067,30005,7373,-26249,-20485,11611,-15741,-10387,3755,-17833,19669,-705,-13707,-31025,6387,-4631,-2323,-8795,291,13791,-31015,-25991,9519,-769,-32101,18281,-1883,-13799,-1575,-16991,15813,27777,-17921,-26449,30675,-5875,-1617,15319,20565,-2151,-7911,-18367,23061,-289,-24547,22063,-11837,13737,-20565,-26085,-5687,10647,18951,-6167,-5261,31515,16191,5827,-499,-30101,3945,-29651,15701,-25987,-10023,24663,-6145,-12305,-12599,-31681,-25701,-27755,-13899,9171,-32221,14465,-24669,6239,2657,2567,19171,18783,-5837,-22039,-28069,-2293,-4723,24145,9369,32367,29743,31265,-11563,1745,32047,32157,-8715,-15319,-5381,-10703,-26825,9057,23309,-28693,-2779,-10797,-1757,3547,-30711,-14849,25415,-9247,21539,-6785,-21355,-14385,29825,-3813,-521,19359,-31861,-28091,-18963,17797,-8671,-16695,1371,-25823,5639,-17057,7821,-14105,20803,-14555,-17639,13465,16075,15871,-6223,1095,27085,1163,-9233,-20281,14185,29587,-9047,-20481,19545,6621,-507,-23361,-14797,-13433,-25361,-20051,17331,-27971,25127,-23181,-32047,5175,103,16563,24249,-11419,4107,-4887,-29331,-25701,14077,-15137,-10487,-493,25091,27837,-4701,20161,23317,30169,-17163,5459,-26199,-11691,15437,-10913,13085,24331,-3959,22271,23773,-24729,30873,24011,-7349,-9597,-25637,3477,27943,4413,-22215,24461,19467,25235,-12389,-24351,-22103,1361,-1269,17115,-2831,-15257,9571,21903,-9859,18155,-3713,16521,281,-15681,997,22093,-31057,3149,20593,-7165,13441,-6505,-20493,9107,15867,-13641,22595,-24675,-30127,7391,24495,-20687,6021,6539,-10527,-17711,23273,9395,11513,32647,19589,-21827,-18387,-713,4391,877,30749,-22853,-22751,-5543,-2801,30663,-19635,9577,-1463,22161,5443,27909,-32011,1629,-25387,9059,7213,-16211,17419,2541,30981,-2095,16779,-6475,8321,-14645,-9113,31417,5621,16735,-17757,-12919,27753,22213,-18663,-24357,1225,-21833,-32489,24893,-17049,21279,-15349,19419,8477,-3371,-2429,-28093,6541,26533,-22917,25931,13231,-4177,32043,-16849,28269,-21121,-6699,-4775,2649,1645,-11011,-13725,3367,13877,-17115,20663,10893,-31837,-30517,-30457,-15271,-30733,-6663,-287,21131,14653,-14091,3211,30743,21367,-16135,-30603,6971,-26877,-115,14575,-9715,7579,22219,11115,19365,10203,-24847,-23595,-28479,2679,-16055,27319,18165,20999,6093,16593,6987,-8161,-26751,22305,-3301,21775,15025,-6055,-18611,-2561,-20217,5967,6675,-8121,-14033,-495,2539,-1881,31029,24815,-23207,17225,18377,-15767,19389,16013,27277,8811,20665,19971,22177,31571,17473,9751,29605,29287,-8879,-11079,31703,-24821,10521,4119,9745,-8891,-23767,28641,-11489,19989,8487,6621,-4435,30061,6833,-5835,14043,8095,2873,-32371,709,-19479,2333,-6041,19655,-30533,937,-5809,4707,-1283,-17117,-13317,-31149,9855,3001,-23577,18545,-17621,-16179,16393,3193,29095,26967,-4397,-153,25283,3707,-29883,5645,-30395,-28421,-3825,-14023,15407,3959,-5191,13771,19513,11913,-9793,18755,30487,-25525,24977,-22399,27747,-5307,-20789,26155,-21849,11417,-31449,1841,-23893,-6653,32701,8579,-6713,4905,-32089,-1741,4197,6617,-2577,-5849,-3415,2519,-24313,7969,26717,-14903,-20791,-23263,-8573,-10105,7945,24377,-19737,6727,13411,15919,19813,17443,14645,-24159,433,1245,-11969,-233,14415,-29027,20483,-4557,11147,18617,12847,-24971,-16087,-4155,24595,27391,18603,-14397,-22195,-23951,3211,2655,-30961,17871,6547,-27797,4659,-29307,-31631,-32453,-18055,30425,-12283,-23111,-14451,-16975,5189,26101,28967,-25329,-17373,15749,-31059,12985,-2089,-4541,6161,2793,-12159,21551,-4707,-26301,24231,14115,-31499,28247,1011,1183,19621,-24089,-9515,-19193,-24751,16643,6093,-27549,-29637,11367,-7287,4051,-17215,-28625,-21193,23637,-15943,-10973,-29595,-22567,6855,-15671,-27463,-24033,8525,15603,30355,-18439,-4213,31365,-13983,24931,32451,6549,24649,30645,-1637,-13987,-24991,25959,755,8139,6641,-13003,-16653,19,-15745,-25351,21821,14953,-24865,-19393,23953,-5169,-2685,2473,-9881,-26329,8143,1987,30707,-9617,15047,-15493,18845,-27789,9759,-14205,-20609,29203,10741,24679,-14299,-13187,-30089,14895,-12273,18987,6139,15221,24333,26477,20861,327,-15985,657,18373,-19427,26301,-14763,30687,-1725,20481,30703,1349,-4959,-5679,-32767,30773,5315,-19233,17583,6619,12235,-26833,4849,25925,27133,29093,601,-19217,5481,-23515,1681,4667,-28215,-14419,-25073,20613,21477,-28911,-2429,-26007,-13045,-3897,4135,6193,17759,11313,4851,5425,-2753,-25319,21321,-13025,-27783,22719,4145,841,22577,-13345,29657,25939,-6731,-19383,-15813,13347,-17533,24137,5171,2163,-22137,-21117,7865,-5215,27025,32695,1697,13683,-5571,10279,6549,28539,-5331,-17683,-17661,-26697,-15491,-16329,-2927,13499,-27669,-10345,-17389,-1969,-14845,-17527,-3621,-3515,5205,-12687,-14037,-16045,-10799,3873,6433,-25703,-17613,-10595,-31409,-16205,-7087,16411,21213,21625,-19225,25851,29211,30287,15551,-11907,10611,-10699,-6153,-16609,-851,-28899,26823,3761,9057,18219,20491,5633,-22937,21225,21111,-19159,26137,-17721,-6469,-10645,-17837,327,-18255,-2929,-17903,11581,-6141,-7843,19387,-177,27913,29651,1567,-32317,-7097,-31559,-6433,10337,-8487,13357,31899,26855,14097,6865,11399,15239,10187,22893,-15591,32259,-10221,16861,-6453,-10279,27883,-27071,9975,-7127,8727,-10057,17217,11619,-13535,18223,21117,-21533,13299,28769,6497,8451,-8385,13427,4055,-25363,12765,-26181,17385,-29481,-2821,21197,9827,-6543,-25277,16049,-25445,767,31257,15209,22515,11085,-11733,-14393,19105,-27303,26997,25147,5019,-16893,21007,31345,-17375,-15495,-23683,-739,24775,22865,-15907,14793,27033,-24267,15795,-12937,5415,19619,32117,-19097,17613,-25491,22871,6633,1719,-18741,32047,-28585,-20117,-24171,-24417,-3395,7037,-24313,20307,-29543,-9265,-32003,23653,-4431,-32501,13893,-10025,-17271,16065,-15369,7491,-4295,18729,10591,8505,12221,5405,-19177,-24799,-30307,25571,-2461,31131,28955,32735,14199,31685,-6929,-19385,3221,-18041,2801,15077,21995,-16039,-32555,29151,-16431,-13559,22741,11259,2995,-11003,-1557,31321,23231,-32601,-20385,-21021,-25093,26539,-2411,-31631,-14895,-13819,-9379,15807,26277,-24361,17455,21881,28273,-18441,27761,28507,-32245,4435,26459,-18053,3849,-24003,-6947,6005,-29903,-6211,-24573,-4409,-7031,26155,-15919,18165,22285,-9293,-29115,-3767,-31265,-31293,18429,-8947,21519,-32481,22761,-7021,12519,23841,7823,3949,29331,5585,14123,-25411,-25647,13937,-3729,16395,-26001,19061,20669,-21581,10141,19729,20235,9555,17981,21755,-10549,9819,11381,-14887,-1467,-15167,10317,-17213,21683,-11559,27519,24393,24417,-26337,7923,-6023,-6067,-12909,13209,8111,8913,-30289,-25555,-23685,-32227,-7955,30889,-9849,3061,-9753,27497,-19695,-15835,31565,-2861,-2571,16587,-14209,28893,30475,14881,26967,-21169,-10255,-10001,-22549,-26991,22263,14699,24179,-24349,17235,6597,-21989,12119,-17257,10207,-31773,-4137,-28627,10279,-4183,477,-8041,31205,-27781,-8413,23265,-32333,-21099,-15917,-13315,3575,-14105,-29585,5817,-15989,9429,-9057,7009,8689,-7091,2369,32699,-21269,3669,-24699,23979,-27259,-17419,22251,28081,16805,32427,8849,12663,6113,31699,-28001,-14417,6987,-8309,-1835,15547,-14699,-2567,-25759,29677,-28789,-20831,24205,26833,-29569,14415,-6667,-19501,-29851,1479,17811,-18233,-30865,-9053,-8951,20453,12519,15769,-18705,-10979,19299,21555,-13245,8517,18219,5717,-8067,-4753,-685,-6795,9855,12095,-21385,26851,9129,12023,11637,6731,2393,-22447,6767,6945,7777,15807,30995,-6063,-26809,24493,27707,23729,18423,-21675,-18731,11601,417,-8219,-15015,-17581,-13467,-8971,-13815,-17287,28341,-3399,11871,25875,-4509,14639,-5137,8511,-18041,-22879,8717,11609,9381,-9985,10377,14767,2407,-1573,6455,6335,-22651,-30057,29645,-30773,27121,15681,15141,-297,-25287,28867,-12607,-18861,-10889,18393,-5419,-18423,-6171,11701,-18295,-21793,30327,26359,-7419,-7339,24903,12495,16483,-12005,8289,-22479,-13187,-4099,24809,5899,-29453,-3777,7417,11079,10361,-3505,-11225,12441,23397,8219,-32311,23319,13973,18265,3177,24049,28279,29649,25193,-3353,-23091,-26731,5845,-22315,-259,13395,14111,29971,26925,9911,32007,29433,-2253,8887,10445,32541,6649,-14511,24577,-19323,-5839,27017,25825,7971,-2763,5889,13321,-169,13719,23779,4947,32007,10511,26547,6533,6381,11821,31333,16753,24689,-14325,10177,-23781,-25905,-1373,-28959,-10703,2191,-24543,14127,-14675,13009,873,28065,30655,24049,10133,16439,-13021,-30721,-16745,10433,-32143,25507,29577,-2249,-15643,-3417,23855,-7455,-9477,4401,-20513,-16337,-15505,27371,12793,-19679,-25265,4629,-797,5983,26237,-32309,-22767,-8973,21057,9449,-10807,-4853,19015,-27735,-32115,21815,14671,20917,13335,-6467,23769,25377,6533,20361,-32381,811,-20821,875,-3147,29515,29667,12245,-6337,-21349,-28261,-22553,-2785,27481,-12173,-18529,-10303,12363,25337,-14275,-31559,-839,-19079,-32627,15871,-10077,24817,18591,-12887,-27489,-441,-24307,6833,17705,-30429,-6775,10983,29931,-13135,-2847,-28287,16661,-10849,-31953,12251,-28913,-9007,-15561,-5355,13843,-9435,10611,-1911,26967,-14619,-27453,-4761,-25027,1687,29393,-1047,30891,15961,19089,27669,-25459,-25401,14583,-9121,-13983,-31817,-8583,24557,-32011,19867,-2305,-19143,16391,27709,15433,-6665,14627,4517,47,-9727,3523,4801,13803,-31345,-19991,-22523,30725,-20971,17473,-18171,-21881,3197,26869,-31763,-28531,-28875,29111,-10105,26353,25869,8483,-31813,-16149,-6091,-14373,26195,-9779,-20047,18329,25689,-355,-11529,753,1749,-30467,14815,22361,20893,12133,-27629,-18663,15259,9907,27439,-277,-27145,19283,4335,24503,5921,14939,-11693,-12137,15103,6679,-7763,-10477,-8191,12919,11573,-11991,22389,28355,-32113,5297,27643,18049,-9485,-67,-32041,31997,-7893,22773,2663,-20353,-11509,13267,2827,-10989,28171,-25911,-24467,5989,-16499,13627,-31955,-32369,-28803,-17487,-3081,23935,4965,16823,311,16993,-17189,26031,31011,-4717,3401,12075,-19011,951,-14721,25063,27373,-23111,-32361,11687,-11133,27417,9473,7915,-10301,-4807,8977,-9645,20221,-8377,8009,-18653,-11321,9091,3237,-15557,-17799,-3227,4859,-2991,-14869,20629,30095,14787,16837,-29547,6081,18089,-8589,6533,10769,-25053,28655,30551,-17483,12859,-21691,237,-21971,13859,-12983,-2413,-14881,27817,-24031,-7147,-29317,-7931,-4419,24243,24703,11923,-30473,-25167,21961,9639,709,28847,-20989,-10613,-21581,8371,32483,30827,-12921,14903,-5061,-30467,4363,-26143,5397,-6851,-14281,21429,30379,-7325,23459,-2979,-12225,-26963,-499,-13481,-29999,-4063,-13295,-4865,14385,-9363,-31627,27017,-30733,-6463,19357,559,6367,-28559,29037,-12023,5459,-21011,4145,-21483,10635,4897,-19297,-19543,-19745,5721,11265,-11299,14691,28861,31543,17453,-5825,-15721,-5301,9403,22859,21805,-18511,8635,8697,-3377,-9731,1413,22519,-2733,-6049,14457,29031,2405,18721,-3969,-20653,-7987,22279,24659,465,-11117,-27583,-27599,-27641,815,-1763,26817,11937,10355,14443,-6129,-4927,10035,16099,-24869,-28073,15871,6409,-22223,14207,7329,25125,28593,-7975,13801,16589,15651,-28121,-12657,-10631,7867,31509,-14347,23015,19179,26773,-11097,-23233,11233,27311,-13147,16117,-1207,24465,12837,-18951,-29583,-10211,-14199,11113,-14907,-13061,4799,-23713,3843,12323,15319,-21201,-20227,9247,31729,-9751,145,-15267,18701,-14849,-16527,-3967,25917,-32159,19871,-12565,17841,21265,15089,32449,-20193,8349,-2509,27249,-10775,20029,-30351,-20707,18933,9727,25345,-6837,19537,13399,11599,19307,11169,16045,-13403,18225,-24909,20747,25201,-11743,19839,-27215,4777,-13907,4115,-9621,-29765,2881,-30189,25993,13753,-7785,19877,-21131,-21081,25485,28723,23035,28615,-26683,-15547,21261,28159,-24487,-27585,17305,-17447,19633,-20393,-5727,-865,-7707,16049,-28367,-14911,-29553,-15667,-19569,-1465,-9513,-2167,1259,-28007,-1041,-13889,-6687,-11829,-12905,20055,-8651,-5591,-19459,16733,24767,32213,-3519,30109,-23207,15951,26805,5255,-29471,20823,19833,14979,22053,16591,-24473,31395,-31655,13101,-30141,-26559,-28865,1621,23185,-10921,3773,-25545,-31555,16867,-32593,-18853,26651,-14925,9231,22455,31043,20409,2761,-18659,17365,-2617,25019,26163,21677,-1647,11075,1061,-22121,-18155,-4913,-7359,29321,24127,15833,7375,2775,26925,-7709,-15023,9141,-2775,-1133,16675,24433,4051,-5953,-8521,16925,26231,17021,-17145,-29223,10951,6231,-16549,-31485,-1443,30615,24411,24495,-8159,2221,-31759,-11307,6703,-22793,16721,8209,-513,7051,5811,-1067,9743,-31103,-8699,-4841,9577,-20399,14817,-23215,-1291,-12409,32087,-11829,-12411,-10133,-15709,8919,14755,-6941,-23931,-28875,28145,-23985,-27859,-5115,-13259,22187,-1287,-7251,-3385,-23971,11951,-29137,16257,10119,7371,18337,-29319,-32753,1951,6211,-29807,24819,-14009,-10175,-113,-5359,-25335,31039,327,28779,-31533,-13209,8199,-31141,15821,29069,1693,-7611,943,31945,-21117,-12935,-30345,-26597,26309,12017,-30279,4433,31269,-5669,-6567,24603,20881,-15605,-29147,-20941,18951,10697,899,-30179,7999,553,-26909,27177,-12389,32285,-8079,-30457,-14627,22799,-21509,-20693,-7877,-27559,-17571,-21855,-24411,32521,18473,23705,20051,-5981,-939,-4145,-12981,-15631,-15803,-5051,26569,-20845,-25651,31253,-12285,18523,-849,-14591,-31169,-5751,-18023,18831,-2607,22839,-6395,-25045,-23215,7511,-59,-21171,16761,6319,12123,3009,29795,-3179,14691,-30769,-16755,-13447,-7115,-1537,-27703,-18277,28799,25751,-6413,503,-22677,1411,-10115,30927,16531,15073,-30853,6657,-4533,8861,27075,15633,-8535,-3187,22547,4987,-5099,-12127,-20629,12599,135,24333,25203,12049,-12153,6107,1173,-17769,-19425,4245,23891,-7403,13369,-31193,-9325,2605,-2277,-29557,23035,21245,-31039,30793,-1265,6373,26331,-26543,-22483,-4999,-19833,9665,27443,-10109,7585,3581,19993,1767,-4337,30241,16075,7973,-25051,-2519,-27707,39,-29849,22581,-17275,21281,25915,-6161,-10201,-17851,-20613,32423,-1289,7075,5507,15941,6195,-30037,9433,11331,-27505,-23111,-7917,17649,-1325,-20731,-11069,-18637,-707,-24965,26455,20725,1153,16807,-4547,27665,-12533,-22941,1903,-22403,20861,-22819,29863,-30025,26207,-5365,-14861,-22859,19897,21421,-24763,1295,-15747,30031,-21363,-14651,6545,7169,18833,-18351,-32059,2927,-30275,-28959,-13331,-6405,9713,-24009,22543,2141,-5921,16159,4829,4317,-19237,15855,6811,22881,-16147,29209,-8589,-4193,29235,26161,9547,15577,-9259,26161,16387,-29019,24045,27263,-15289,-12067,-13045,28491,-29957,-12123,-28299,-7149,8369,-6341,-27131,-32611,16189,-27921,13141,-1487,16873,4039,25035,13685,-27177,-18957,-5389,-31061,-15157,32091,-8737,-2537,6835,-31201,-605,-24827,-25895,-15037,29909,9373,23755,2865,-27645,-22951,-21907,29841,-20291,-737,-13203,-8241,28261,32591,-251,20105,-3391,13359,-21069,22851,3717,-3259,2411,11175,-10313,-7037,-7691,22123,26995,-181,14053,-4653,22443,19729,-22647,-31967,-27299,-25229,-32501,31607,-6609,-10939,6775,31477,-31019,-15635,-5545,-19603,-29291,-27443,-20635,-26967,-21421,-295,11501,7855,23263,-9727,6339,22757,15691,-1995,7853,-2543,-13707,21373,18557,7957,31195,10753,15775,22987,8027,9381,-17989,7639,-17205,27883,-29821,-27295,-11513,-4335,5443,-15359,-11141,23797,-30659,-24277,-28425,3507,9233,-22651,23641,-28821,10457,-15151,-1871,-22739,13483,27293,18313,6265,31735,-19399,-26183,-459,-11511,27877,3327,3059,28457,-16781,-11407,11309,20125,-6181,-22359,-17345,17507,-21177,25679,20963,-17519,-9975,-21305,4559,11303,30621,-8459,13375,-12867,-12307,-30647,6319,8085,3559,20127,-24703,9791,521,14479,3689,-16191,21973,7529,-13253,-15965,6749,-10597,5829,-20877,25599,4193,1471,8697,13639,-16439,-1065,-31431,2895,6399,-1783,30069,24525,-22467,285,-10329,-1019,19941,1277,22327,-7711,-1697,-14647,8933,-30989,22583,19549,22497,-26819,-25589,-4345,22301,22791,-3615,27811,16633,25079,-14383,-5669,-18647,-30869,3779,6069,23201,-1791,22375,14435,-6287,-27059,17341,15299,-31161,13561,-17301,-31233,-23753,15419,-2961,9591,30121,-32761,-7151,-8547,-22579,-2171,-15573,3327,5311,-24769,22287,25081,-2935,6553,22115,-31639,31977,-19689,31715,-26811,-26489,28513,28667,-41,4789,-3139,-6873,11445,8685,23745,15841,18853,5029,18797,-26461,-19429,1849,-1721,32489,-16649,-19659,1783,17209,26651,-12071,-7499,-14743,-3645,6263,7345,27817,-13803,-7473,5135,-11713,-10221,-23915,32351,27737,25207,21431,-16381,-11209,19055,-10313,-15847,-26895,3969,-23771,12265,24343,-7165,10621,-19267,24197,31491,5757,-2999,-20087,14763,-15163,11223,-7907,-4383,29125,1463,-6077,28709,24627,-11879,10253,-31,-2553,-13727,-31073,29443,-10391,-2691,-10077,26529,32005,-15105,875,-6351,-17443,12205,-35,-19243,-10735,-20903,-13895,25745,25743,5031,-5033,-12959,14199,26987,-16707,-9947,-6773,-32027,-4019,13585,-27715,2725,-10033,-13187,-9405,32019,-26387,23349,-4421,-15633,29193,-24657,-3545,32507,31283,31143,-2757,-11539,15843,-4259,-28365,26413,-29579,-7751,9339,2225,25983,23045,9793,31721,12501,-29461,18025,-19829,18221,-19009,-12283,27561,-3543,3561,-9371,22051,14663,20155,-5619,-5913,3973,-20221,-13037,25293,14997,-14557,-24081,5955,-10325,-26443,22843,-7253,-30609,31253,-6799,-3425,28203,-27403,-4115,30263,-11789,4365,23329,-2993,4825,16811,-709,-11223,-18491,19059,-30981,27577,28309,-9385,3255,19585,-17013,-25009,-22737,-14997,23853,-923,17981,16601,26895,22201,-27887,-26661,20555,10377,18513,-31085,26609,10601,23791,32395,4007,-31291,-16203,-30055,-28085,615,-19371,3911,-11971,-21073,29163,3015,-1197,-45,13203,-18337,-7471,-15197,24777,6337,-4597,-12907,-31765,31043,23157,-11691,16291,-18849,-31003,-28501,30425,-20451,-23265,16615,-11775,-19963,2313,10643,21963,-27455,25333,32011,29725,11997,19707,-25521,-32267,27407,-18359,17505,153,4629,-893,-7317,24181,7561,-24679,-27879,-21947,15273,-10187,-3771,-17971,273,-25407,-1861,25357,-9545,-18873,31775,-12175,5785,18499,-3637,8793,-12317,-813,3831,1993,8473,-5975,10995,26493,28167,18179,-5085,-31559,1589,26787,-30293,32235,-2207,-4491,-465,-29561,24231,-11177,8385,1401,3939,13111,-1049,-15183,-21109,15909,3031,-31,-24061,1081,-17835,-8303,20505,22503,8149,-28137,-29347,19157,-24855,14177,-8915,31059,12629,-13883,-30861,-8323,1277,32591,-3049,-23813,23961,-12535,-6523,-19177,24987,4219,-13395,31855,29837,-2825,8893,-18865,-18005,-3081,27747,-4739,27961,-25571,-9769,31475,8315,10061,-11959,-28907,9091,3355,26929,-14127,-12043,13691,-1845,-17399,32129,-17347,597,-25369,-27973,-19155,21713,21331,-31467,-30005,26959,-14871,2649,489,14041,-6515,-13413,-11689,-927,15053,21383,-19609,-12985,-17165,31657,-19387,-4049,28811,-9927,-14303,27889,29275,-17047,-6869,5329,25603,-1829,31689,-14821,-10381,17333,2431,10109,25961,-30217,21247,-26975,-14725,26033,28895,3235,-24407,28735,16235,28971,-22675,18953,-19589,-20633,265,-4255,24333,7965,30269,28239,-14447,-14641,-3373,-24369,-14459,-28117,-17813,30551,-1403,-14789,9193,14851,25223,23789,-25981,-20107,2357,7343,2617,4901,31801,-20965,-6465,-3847,15663,-31957,15219,3491,6745,-14099,-10513,-20063,10851,-30913,-21099,-10925,-22313,6183,29527,24495,-28727,-32759,32607,27251,-21703,-25703,-12249,21559,-7497,-9361,2547,-6119,17645,14307,7155,31331,-17893,-55,-23467,22207,13777,-5789,7551,16153,23885,-30911,3941,-23617,4387,-9671,-20979,11809,21421,23231,28009,3781,-24657,2261,24395,11403,-4189,22957,14611,-17055,311,-31247,12577,26781,10201,-10533,23309,-30885,1845,-7253,-24915,4751,9027,-13185,18203,-6249,21013,-27813,-17865,-6781,-15527,-29247,7395,9517,-24433,-24923,10525,-14975,-1661,-23787,12859,-14351,3035,-8801,-27685,-23887,-11061,-7385,-24849,413,31251,-19637,-20417,25213,1815,20055,8671,22307,-15623,16137,-31075,26223,-14147,-15891,-31233,-24473,27831,21583,-16847,-5135,-9015,-13553,4237,15991,-18131,-3803,17745,-27871,3161,14841,10089,-633,18615,-23693,-25961,-5233,-14161,-1849,21469,-17607,6565,14861,15939,-26609,-14461,-6923,18769,25301,-21319,3059,7773,14387,-30795,12367,26391,-4025,32151,10347,18415,20737,-6321,-12069,25765,-22393,-17855,-9837,-17611,1475,-8653,-22467,-10043,21563,-8435,25157,-16307,-26379,-23659,2165,9395,6215,-18821,-6819,-12381,15325,9223,6299,22337,22107,17933,5005,22563,5585,22151,28947,22487,297,-12065,26173,-3567,-7771,-22101,31713,-17743,13507,-27631,17595,3663,13065,-21679,-23471,25915,-817,30677,8851,-11807,-4629,-30471,20503,-9543,-31993,-26573,-24031,30313,-11023,-11687,-18507,23277,-23207,12771,-8209,21443,-5277,10543,-16011,-29363,24591,-25201,-30761,-15323,8877,14073,12647,8691,27415,-6649,-24573,-22523,-23873,12921,-30953,-26069,-13345,31297,29377,-26873,-10269,9609,6031,21121,27149,-32327,-985,16539,21599,2627,-27147,-29945,4537,24581,-9785,14975,7789,30967,-13439,15263,3761,20363,19111,9387,-3577,-28227,-18541,-31799,-23719,-10047,-6301,-1861,26891,1363,14177,25565,16743,-29013,-6643,4663,-29417,-25615,18041,-26609,-14035,30495,-19291,28943,30787,28813,20105,-18753,25165,-13901,-9179,-25399,-20661,-2853,-12155,-29053,-1901,14969,-14523,22143,32333,-4485,22859,4987,-18023,-26945,29721,2853,26131,31171,3173,-32213,17191,-28115,19631,-31853,-19613,-925,22623,-28771,-4973,-28801,20771,-7685,-745,-24659,32505,3033,-32413,-1809,-10925,-2943,-7733,26001,13979,-27399,-4475,15177,6527,-22531,10117,-30405,8329,-3027,-30011,8155,6149,-28307,-2901,-28307,-5973,-5257,22557,-31275,8779,25897,28233,23149,-12849,27013,25787,9631,-27983,8465,29145,18637,-26069,12297,-19051,-4171,-12891,-30057,731,5741,10735,-10611,31327,11229,31057,28971,30981,26227,-6277,11973,16115,-18603,403,21637,-21345,-20827,26571,11211,7535,5003,-11681,-10927,-26669,13565,-25835,-1607,-10811,20819,2735,11503,-15529,8547,32567,-2323,10409,20013,6299,14567,-30157,-9631,-31005,-5201,-9597,-25423,-23511,171,26683,-15767,15815,-11759,7467,-18417,-31065,-12053,-27617,-11059,-25651,9397,-26687,-21427,-30869,-2159,1085,13107,17221,28153,-7087,11433,823,-20215,27813,-3017,-7551,-771,13955,-25867,-10699,-18605,593,-7223,-30549,-11745,-17803,-6887,29011,-265,-16877,14389,-6923,31687,19451,22959,-25631,25837,-4875,25939,4945,10615,7461,24505,11707,-1691,3251,25447,-10165,-2519,-29831,28451,22181,-30603,5245,-10899,-24199,26611,-29017,6489,-861,7273,-14169,-1349,-16195,18641,-30403,-21551,-12899,29231,12343,26759,-31725,17185,-9907,13009,6319,32185,-16259,-20315,-21269,-12035,30289,-16163,-29385,-30641,-20637,7243,8799,10227,-27699,-6973,-23485,-23023,7405,-93,-12745,-2381,18633,-27285,21873,13779,24481,22539,20773,28613,-5381,-12297,10869,-1071,16187,20963,5853,-15615,6437,-10565,20311,-35,-26215,-18907,-1161,-6679,-2947,-9067,-29343,28587,29287,95,5541,-13179,-19313,-5023,-16133,12731,-26045,-4721,-7259,12683,32403,-8635,-3925,15967,-28601,-8997,-26821,4659,-30901,-2559,-26563,10301,-20365,-17999,-31013,14791,-10071,-5043,15781,8831,-23911,23195,12351,18169,-25679,3771,2733,31589,21703,-19765,-2135,-497,26495,-17761,-28021,29297,22087,7697,-28733,-5749,29715,28183,28625,8311,18255,-20839,27361,-12723,-8475,5743,31365,-12185,-3505,-5619,-32555,-9413,-13409,3577,-5055,17677,15301,-18331,-15975,-2705,7543,22463,-18463,-11605,-24503,-17137,-14575,-27599,-26899,5541,-11615,10397,2019,-29227,13097,-8781,-32235,-14133,26617,11611,20745,13033,22929,5089,1811,15447,27459,1531,9537,-26399,21259,-18379,18485,14349,-17889,2159,-26221,97,-15413,-21703,-22733,27319,18599,30791,-27559,-12285,19329,-6817,22577,-1243,-2943,9683,18907,-12161,-7749,11425,-8743,-20465,14621,24971,-14935,31073,-12163,19283,10403,-26379,-22483,-31609,-607,21033,-12103,-16357,-23767,12569,5773,27015,21469,-10507,-10077,20685,-7973,10359,-25403,5631,8639,13561,-20071,31615,-7861,28957,5063,13413,-31929,-763,3203,26039,-32031,10307,13857,28213,32447,19687,31175,-11279,18189,18717,-16503,20847,12585,13329,-8187,15029,11097,-27489,-8327,-1799,10567,-25749,11395,-2543,-15563,-29231,16955,12051,29943,12365,5265,-6745,7037,23523,-26313,25397,8901,24781,11417,-22419,18153,5867,17605,-179,-14207,20067,13345,15777,-1269,9969,-32513,28145,-20247,23187,-30857,-6653,-21039,-1711,-13267,12665,1687,10411,-6419,17957,3987,7117,-2511,-30321,-32237,9295,-12357,-15843,28441,-21461,-6851,-3283,-24333,26035,-12733,27543,-22383,32575,8321,-13983,-29839,13779,-16747,-31121,12215,32139,10419,-24161,30739,22675,4313,-25417,6701,22633,3479,7037,-19893,-6389,23321,-32409,-6571,23015,23783,-2609,25455,1993,-15901,-27823,1627,3719,-21833,15863,8323,30983,30313,8445,-26115,14995,22167,-7083,14987,-29671,-311,-1761,19603,22547,2567,21423,-8583,-14817,-26447,-3105,27185,-32713,17263,-4359,-17669,26965,15359,-26713,-10959,15665,26491,-7605,-28247,32507,22343,-14969,-15913,-29351,7131,31221,-27555,-13695,27019,12095,-19575,-25781,-21593,-15743,20521,-12473,3733,24317,22299,-23775,32603,17141,-3299,-5737,16845,-20595,-5967,-30867,23261,-29129,1455,-13243,-32443,25229,-6959,17261,22189,-29941,-9769,15585,-2971,-16709,24757,-6743,-28563,-28707,-32563,-32603,6267,-4519,-4375,-26403,26981,28861,24077,-17443,4957,7041,32241,12617,-25267,29933,-28945,-21191,17037,-10277,9889,-11501,13731,11271,21521,11371,-11259,9693,-14593,-2451,8507,24571,24959,-4723,30021,2613,-19107,-16399,-9271,14417,-1981,-28625,-32091,-19081,10881,23059,24619,-23017,-26561,-26143,16351,9699,16053,-18489,-14847,13079,5887,30689,-29699,-11485,29245,-1981,30743,19305,-27703,-17511,-2825,17517,8221,-2495,-14483,20067,4557,22331,-20745,11935,-30325,-28585,-27423,453,-14075,-4213,24303,-14787,13523,-13097,-2581,-16641,-15903,23959,15313,-15279,22249,-20519,25775,7373,-16923,-10903,-25193,-15001,-16613,3215,18433,8773,-21385,7593,-6857,13343,-8839,-20123,7803,8661,-17489,-31067,26241,-17157,25441,10401,26749,-7251,11831,-19483,14039,26971,-13881,-27611,-20249,-12999,-7831,10813,-24975,-27429,8661,-2597,-17981,26277,-23281,18673,-23677,22845,-17929,-29381,-32049,12913,-21893,-8717,24897,-3303,-23149,-19473,-20851,6051,22663,-10653,26611,-22121,-24603,6581,-22151,-10531,-7493,17545,-24865,-21217,-25091,-747,-55,-31625,15097,20157,5329,29641,-19619,7855,12123,-9777,22879,30565,-30471,11537,20367,1281,30991,-13339,-25031,26071,-5983,16897,3539,17207,-15869,-4027,-4091,19867,-3795,-18209,-1817,-32581,5207,2675,-25845,-23213,21231,-32545,23835,-20439,5717,8145,28989,26669,29559,21263,-11301,-25371,18797,-22229,1431,-30949,19397,23475,24783,-8837,22281,8995,-28981,5993,-26865,4595,13033,13601,-21733,5115,20127,29391,-26629,32639,26587,18439,-31119,9585,4849,8475,15427,15707,-12165,-6567,-22661,5849,-20299,3203,29343,17843,2201,13863,7561,-20507,-32573,-15807,-6997,24461,-2851,25341,-7225,609,-15491,-13577,-13951,-14147,-20027,-21551,-21649,26959,-28733,-10677,-32321,-11895,17543,-15307,19643,-24227,13529,29273,26649,1059,26653,4461,-16835,13199,-25291,-14291,-11565,-12217,-23867,-23133,2259,15973,12581,9245,-9405,-22797,13825,31791,-7491,30515,-12017,-21755,-32569,4831,-11789,8823,-20811,-21247,-22243,4545,11955,-17001,26865,-17355,-8001,-11739,13047,-25717,-29461,-827,-6915,16305,-28461,27523,23375,-14809,-19477,-23703,-15439,14509,-23633,-3145,11617,1623,2041,2249,28271,26421,-4941,-31583,4787,27325,30979,-23701,6237,17785,2065,27779,-901,-21109,15119,14089,-9429,25843,32073,6081,21659,-32539,-8629,-11279,13791,-25419,-3687,20351,-14515,4343,-28731,21109,-28753,30037,7183,1047,19353,14443,-10009,-10391,-75,-29005,15489,9529,22915,31865,-14183,17367,-5333,-95,12023,22299,-14855,4665,-411,21897,17529,11549,-10573,2965,11323,-26271,2629,12603,7619,-16481,8929,-5905,14569,14271,-31149,19941,-17273,-24975,-23735,-26289,-27163,25069,-5021,-12597,9653,-32685,21011,20927,-5431,-8711,-23563,-20393,-3201,-12425,15637,6343,29215,9597,15977,11119,15479,22291,-26045,6067,-31225,-10467,18525,-28735,20229,-17495,8203,-32503,-891,17713,27067,-22603,-16393,-25181,-8297,677,29013,-25751,-17097,-6191,8603,5275,-32379,-14277,5337,-27865,31829,-14941,12023,17043,-23425,-8373,18909,177,10143,1047,10103,-4169,-32421,5657,-30033,-24347,-13979,-11781,15661,19651,21207,-26819,30055,32147,189,12929,-26595,15361,6059,-10855,-6035,15097,-23271,-24703,-29299,28743,29709,-15477,-28319,-14669,-32761,-21741,-7695,12795,18867,-26213,6543,-16005,18255,-18617,15677,5775,-16839,2313,643,-25469,-13863,-24491,-26681,12279,-6087,-13339,-20365,-8811,-6901,9137,6867,-5549,-21255,-7077,-11949,17677,18153,21853,28379,-1915,24017,12699,24931,-21725,-8341,-32741,-12049,-28001,27445,24551,11559,23011,-2379,24335,-15877,-23427,-28499,-25285,19283,17363,-19869,-1525,-9267,11463,-12055,16895,-24675,24171,-5959,-26555,26989,23483,1165,24515,-8063,3057,-24237,-3527,13235,-10881,26175,-19937,28579,13821,25709,8703,-30217,2625,-10097,843,12249,17093,19543,-27609,-6737,2171,-29681,-10219,-10551,-10337,31163,-1803,7219,-3237,-24675,-13773,-26883,7621,7847,-1733,17715,-127,24105,-15801,-24219,19001,-23105,7987,6709,-32503,4515,-21065,32317,-11307,7637,29201,-18109,16019,14865,17707,-9765,-29221,-32373,30835,-553,-11653,-265,-18763,-20535,18953,31825,-10193,29907,-21437,-7369,-11009,30455,21091,-13933,31801,18797,-22697,-13351,-6261,5883,26801,16349,-8757,-9329,17061,16283,-28145,-10255,-28325,-26215,22517,-31299,-23101,17759,431,32757,-5513,-19959,-2837,6961,-16401,30217,4811,-29263,1065,-4839,-8745,341,13579,20165,17697,28945,2663,-21337,26435,12833,-6977,29621,16199,21365,-7519,-31353,4755,17527,-16227,-7629,14195,9193,30035,28151,19853,31591,-17401,6797,-11739,9897,-2257,8765,-8153,-19421,-10525,-18889,12493,31245,-15751,3,27641,-23777,-3367,25227,-26683,20973,-15865,-9237,-24709,4425,-24987,-25689,-23723,-25667,4867,-12563,-27793,-9233,-2547,-22175,-30937,-31137,16107,-20451,-9383,29837,2225,-31465,-5679,-31997,-23283,-17467,14619,-7445,21025,-19229,13681,22237,-32751,18589,3217,-24495,-30779,14591,-22165,5151,-25507,20285,-1541,28105,-13969,13349,18555,24057,30761,-22525,10817,-23191,11745,-10361,-19169,32183,15209,22591,-23805,-22901,-22243,9245,-699,24545,-9457,-25399,5031,5169,23063,-18497,-7849,-29429,25189,-19127,31995,-32585,7757,13135,17829,26841,-32295,20665,18667,6613,32021,-10705,25377,5011,-6125,-8567,-17119,28123,9337,21203,-27531,19723,1201,-21683,3043,17275,3005,18571,17641,-10297,-8581,-8839,-13049,18891,28885,28557,29601,18711,-27687,19029,967,-20145,9831,-1893,24691,2149,-16093,27081,4653,-8885,-8501,-15163,8621,-26991,-16561,-18855,19275,8345,-14369,32445,-16511,30105,32341,-2505,19879,9275,15623,-21471,14295,-13543,22099,26063,-8967,1007,1609,-24281,-27419,-7223,11041,-32419,20727,-23061,21973,-15585,-22759,8893,-22357,5535,2381,31107,20681,-30567,18547,30217,9901,-12913,-7349,7303,-31727,-17221,2027,-20821,-4699,26167,-30687,-10285,4751,16703,25777,-21823,4097,-18671,-31537,-13297,-14031,7411,10983,-25891,-17651,-9533,1699,17525,17339,25973,-9957,25877,9301,9265,6955,13237,-29615,-28515,-6331,-2137,-29001,21185,-18429,-29491,28875,-6605,-22285,21875,-20065,-11113,-20605,25647,3845,-2091,-25879,-9243,22937,3387,9585,-13887,29395,15715,8277,27885,-1469,16745,12959,1995,-31359,17523,-29461,23749,25955,21117,21503,28139,-28367,-8535,-11347,29247,-23603,22277,-2921,-11429,-21929,-27161,5649,31843,18501,24947,-25979,-3863,6605,-23341,26667,-7949,23633,-21157,-6247,-25095,-10983,-13751,12293,25409,4641,1427,-32497,22093,-1145,4507,-19307,29429,8183,10655,15415,11241,29483,13903,27455,-3443,-14593,18947,9791,-17027,11905,2793,-8305,-10791,19803,23225,7573,-20075,3909,6513,-4723,15411,20807,3045,-28875,-31683,25331,-3217,-14377,28277,-5479,32299,19393,10403,-6765,-13535,-24851,15103,-8331,2199,-14183,6747,10855,-21027,-5557,21567,-14059,-5353,-16905,9401,-27415,-83,18601,16109,18879,-28243,-30261,-19527,-19011,23635,2231,1823,14401,18245,-1559,-17925,-24757,19785,-4071,-32757,2089,24189,5803,12691,19635,29731,-27885,17859,-4903,29879,-28009,16687,18505,-20873,32723,6663,22229,-7447,-25343,10773,30487,-30619,13821,32595,1809,-30123,27397,16127,-30149,-15669,1287,-9669,-11087,27039,12971,16833,-1661,-28739,4413,-22543,21011,30491,20161,24425,-18775,-26135,14825,-5883,-499,-6621,-9165,10433,15901,-20475,-13197,5169,21821,111,3179,15837,32069,11143,32709,-25323,12005,28805,3049,-8931,5123,-29681,-16561,-23767,19245,12055,24321,7715,22151,-11861,-23043,-1213,-7857,-27845,-16451,-9481,3399,-20687,22221,29999,8011,18143,-16857,-30713,-931,5407,-31633,4761,-8813,-18585,29197,-6269,-3407,11303,-28583,3095,24495,-29733,10481,32027,-24445,20575,-28053,27357,2535,-16551,7885,-10435,-14885,16601,20885,7243,9627,-26897,-7869,-25325,3979,17547,5901,23927,-8571,32289,-23579,28907,22465,2897,-18735,-12467,14631,-8573,8793,-15559,26587,7969,29117,-1649,-23013,-16271,-24803,-5379,9759,27673,-15195,-22193,-10233,-29275,-17873,-2627,17271,2567,-1815,1533,3431,-25059,-12985,-26669,-2863,-27397,-20143,-17697,20697,-133,25133,26543,-3551,14299,-14645,-14951,20729,-14025,-6581,-14919,-25597,-2513,-32717,-2389,-3029,-129,-21645,29927,-7859,15697,18159,-16809,-21261,6057,9843,9015,-18067,24095,11581,-27605,-7055,29983,2007,-27243,-13661,10463,22257,-22425,-20575,-2857,4139,9161,21393,4185,-4783,-3785,-4721,-10123,-11923,-3281,14715,-32725,-13467,-5669,-15661,5171,-20929,28599,3889,20651,9247,13953,26813,32751,16169,15515,-16853,27303,-7687,24807,-17893,2537,28435,11021,14941,-31635,-17369,653,22725,-20161,-129,-9231,12929,-29405,26693,24595,28287,22509,21891,-10459,29125,563,21071,-9047,23731,-8011,21035,-30779,-5821,-1051,603,11151,19959,18133,15815,-20541,-4985,16033,-31561,-14717,-28875,21845,5695,15093,-14351,22967,5363,11691,4777,-11147,-17295,645,5473,21737,-30161,32549,-32633,32497,-3205,-5325,9071,-1151,28589,-1631,14659,24675,11731,6595,2683,-19603,27279,-2727,31595,-21139,-28465,-20727,4641,-2691,-22919,6109,26077,-29741,7865,-11669,-8011,29511,29841,-13085,6205,3495,-5989,-12391,-8265,-1767,23335,4113,-23655,-7687,9745,7853,-20419,11323,30031,32209,3417,-8353,30867,5889,10081,22037,-28721,-835,-22911,-15655,4825,24537,22471,-31999,23905,23835,-19039,3531,11219,6459,21545,-613,-19057,29449,27051,4177,15595,-32171,15215,-23377,16713,-4587,28299,22829,31363,-1951,26913,-13579,25387,23597,26015,-22477,3291,-9701,-18957,9359,-15493,29107,-31747,3659,-5653,-11457,-26215,31431,-14373,-11559,4517,2225,15039,-26323,2823,-12613,225,26171,28641,5379,29577,15265,-23249,7471,-12623,23241,6071,-26621,15609,2861,-26795,-24241,-16717,21973,14251,-17563,-18367,11247,18725,-15201,16263,-26763,-5067,7049,20377,-21029,24967,5625,12359,19327,11893,-8833,-32481,26777,14965,-9993,-1947,18687,10981,-3405,-24079,9453,4043,-27497,-13035,-6905,3507,24131,28343,28083,-1927,29459,-8107,31221,-23825,-17797,28901,-8895,-27331,-30495,-5237,-32729,12747,-19627,2267,8203,-25351,9785,28239,-11109,-28741,-5455,-25827,-2423,7825,-13077,10487,31521,-7449,13421,-29521,-23237,18949,27849,-5069,-30549,12875,-30003,-3253,-23001,-11577,-14195,23667,26265,-18939,-29109,29493,-26557,-17637,25355,-29209,-20659,21785,-24457,21309,-25819,19723,9161,17507,-13327,-1815,8267,-16455,29403,-32627,14979,15305,8955,9815,-9575,1933,15055,-15583,31923,-14815,595,9893,-3289,24273,-7651,22125,7257,-8205,30019,22323,-26455,-3417,14493,-22025,18363,26805,1379,-22887,-2363,-16891,-23637,-7807,-14153,8177,-18649,-1479,30029,-11143,-11757,21801,4497,-3989,-24339,-7203,-31355,30051,-17475,16255,26527,1869,8863,-21821,29879,30279,1331,-10093,21697,6329,-8831,-17045,-28541,12645,-15869,-17605,-17189,10713,6367,-14741,30521,5945,32361,1773,31495,12797,-12167,23447,8927,26099,21891,-13983,-23051,16019,-4163,14303,-6977,-23971,-10387,5553,-23835,-3855,6507,-25739,-15755,-3813,-21541,14361,1945,-13387,16083,15027,-16771,31117,3785,14261,16605,30127,305,-10039,12603,1013,-21407,-19967,-2959,-18803,15885,-23783,13473,5111,-19065,-31813,2319,-27339,8409,25621,-13173,27157,23351,20345,30025,7553,-5157,13779,-26395,10995,32419,-11613,17987,-13757,-31929,14537,-11723,6821,2927,-25953,-15469,-14979,1941,-18861,23905,-19997,30665,-1189,2243,5157,9751,-26901,-31983,-31575,4801,12265,19853,9555,5365,-15371,30101,17949,10825,-12139,-14801,3557,-11505,10583,-3487,14399,21911,-2135,21185,2147,12345,-29615,-22987,-25055,-7763,-7301,32017,-22223,-26419,16025,23321,-14419,-18403,-2393,-1643,19909,-26159,10967,-25155,-27775,20503,-14705,-18645,11963,-14525,-20115,14847,23897,-24701,-5493,-6777,-24251,30693,32239,-935,8061,-9637,6851,-6507,-5221,-11119,12277,29809,-16133,18355,20251,26681,23847,-27223,2543,-9597,-17803,-15295,18039,7439,-29523,6489,-18651,21507,22699,21209,8057,1847,-22777,13883,24211,-11871,17583,-6999,-657,1629,24355,-2739,17471,29911,-11155,4357,-5115,2917,2647,-14927,-18709,27985,-25757,-1995,-3371,16823,24141,-15203,-21483,13083,-6253,13745,-10559,-26427,11763,-18621,3205,-32379,-17721,-4147,28879,7123,-14889,5995,26379,-16723,4991,-15701,11125,-13549,-5595,2427,-331,6435,-697,-9429,24629,519,-11837,16187,-5855,24443,27933,-22361,2507,-26805,11639,-13071,22303,-19999,-18025,15151,11573,-7843,5749,845,-25323,-28213,9487,-18007,-10865,30737,24413,-8549,26197,23871,-24557,2207,-32121,-13925,19553,-31805,-1111,-12209,-28993,9535,12331,10457,-14063,14821,-12901,-5245,31543,8505,-1879,-18739,-9813,-3047,11003,-29799,-28519,29317,-29769,-803,-26603,11087,10749,13969,14969,-21147,8699,-27273,5843,4039,-28747,173,945,19827,-20925,20899,-22611,-23719,-6165,-23269,-6299,25677,4507,-17211,-31597,17129,-11071,-31203,11919,-30599,1101,-907,19565,-25145,4337,-1251,-6677,30507,-12549,11547,17499,-13875,17777,-18953,-13983,-9747,4691,-11315,-20619,-12441,-159,5555,31309,14841,361,24653,15015,22197,-21415,23539,-27343,19819,30883,18385,-1097,32457,-955,-4331,-7903,8533,-4041,25557,12901,25141,32577,-27849,-26995,30185,-9985,-17411,24669,-27213,-9621,15519,-21691,-17693,-1825,32361,-4285,-7353,-16985,-19815,-10227,609,-16101,17227,-25113,-625,-19569,7189,-20541,-28681,13031,-29325,9131,-18807,27453,-24535,-20945,18813,-30233,18733,9307,31057,-26319,-12547,-9115,-1181,-21267,-17255,25251,-22935,-26439,15087,-16207,14947,-8329,-22393,-5305,3501,24317,23371,-29411,-18833,-10463,28389,-30333,-27505,-31915,-23695,2433,-8237,8895,-17053,3515,15713,30039,-26473,23107,-21147,15951,25991,-26685,-5515,23415,-8745,11683,-15021,16553,-3817,-601,-21877,-4919,30145,-13241,-11609,29485,-27393,-24133,22529,-21937,-12895,-18177,-1661,-1937,15215,-26859,24675,-7793,7519,-4959,12033,-24157,18151,-17773,-20185,9697,-26303,4209,24559,-2989,6935,24955,-32223,-11881,-13731,10553,6591,-9717,-13301,-19741,-777,-28447,17497,15093,-29639,22317,15911,18127,-12169,-8159,25107,-17597,-4131,4663,-17935,14027,16779,-4205,20527,5615,-10065,-32295,13049,31119,25183,24165,24525,-18405,-22799,31519,2283,18877,-2799,-7405,-12319,21125,-25589,5849,-14065,-15783,4905,-19267,18781,28933,-6839,-25633,-21531,1065,-1475,23581,-32157,-27779,-22119,-955,-5687,23369,-11735,12103,-11865,-19221,6013,-4159,-8261,8483,16259,-29519,21225,2419,22225,25249,3941,21653,-16655,24571,32495,31529,-12353,-30959,8173,-19783,2493,6579,12619,4669,-5057,-1693,-19077,18697,-10877,263,7959,-19475,25705,12723,-3349,-14251,1199,11309,-1719,6941,-19989,13247,20237,-9045,-6373,-32231,-30365,5337,30929,-20673,-9747,9489,6571,-9047,-28517,-1995,657,31853,-23057,30459,-28911,8129,28839,-20179,-18865,-25595,-26979,-17599,18461,4577,-21579,-17579,20911,-27659,-32589,8995,-16067,22575,31961,22221,-12407,-11875,19585,-28149,-21633,-3257,-28869,-5131,-3665,-10375,-16869,-31009,18783,-1485,1633,25823,-30887,-31229,-21295,26909,1227,-23433,14135,-25841,20537,-7085,-6279,-26481,21743,-2443,11217,-23639,28065,-28891,13249,-26059,29477,25663,6467,2451,-27285,-1681,-8947,14521,-21545,7385,-25439,-27389,-21907,12817,-3199,29367,13151,21603,11523,5669,31209,30085,32181,-15081,16325,-25633,-25665,-28927,18833,-18187,22271,21441,25479,-1437,27891,-9013,1781,-22943,-27765,-895,5509,32345,4431,4369,9903,-21793,-29363,18043,617,13517,17213,15111,21293,31475,-19069,31623,-12781,-20511,14985,2569,-16653,-8121,-9147,-7215,11759,-25309,5335,-2301,-16655,29443,-27611,-19053,10037,-20625,23667,28429,-30317,-19721,2379,-12651,19707,-11723,371,-2819,-8713,15633,14641,-25043,8265,-23529,-29977,-19349,29047,24467,-20351,26509,20279,-30667,-12143,17601,-17343,-15611,17017,-5569,25175,14443,-18005,2345,23349,-16829,-9021,23115,-8057,20081,-8303,30675,-17187,-14557,-26033,21397,16579,-31753,6795,20427,28445,2551,-12135,-28055,28699,10729,29631,-10109,19113,32635,19023,-23111,26885,-13885,-24899,18681,31703,7803,11135,26407,21077,25383,22289,-8763,9765,-4559,32407,4833,6569,26097,-11839,-26305,-30731,32403,6385,1589,9535,8697,-3193,-12419,-14897,5355,10237,4989,1017,-13259,-29785,-1899,-9851,7633,-30621,-20827,30283,7213,28225,21453,30031,28895,3601,9893,-21373,22805,15701,21887,-17173,24503,-21961,-28133,-25883,-21211,-4069,2795,28973,25977,-2371,27651,15509,19935,26441,1545,14979,-31527,26149,-13983,-25319,21053,9079,9835,-4503,-2703,-18603,-13945,28113,-9187,31857,-19057,-28253,-341,10291,-11435,-8859,-17109,955,-31505,-14015,12605,27857,-2191,-12381,21417,9959,-5943,-12375,-3389,27131,-17617,-8991,-17691,-12049,-30875,27037,-18479,23573,16795,8871,-14395,5157,-29833,31509,-9697,283,23993,-703,28259,-3381,-18027,-20767,-1317,6973,12775,-5139,-28923,11543,18693,-23865,6213,-2029,13253,-9223,27431,-25799,20305,29867,28111,22263,-30341,14703,22957,-29731,-7787,-25121,-3497,8793,-12959,2569,-30843,-7657,2567,21887,11391,7073,-26731,11305,707,11161,-413,3625,32561,16243,22609,18215,12431,-17777,-10333,-25135,-29409,16647,-2173,28269,-22281,-16127,963,-3291,-32509,13315,-31667,32503,-20893,17535,-1041,-12803,23819,28569,-15373,11419,26513,-32235,-9195,21353,8047,23949,-29439,-25357,-10809,27633,-14135,-6329,-10005,569,-12605,3039,15357,7649,23633,-12165,1649,-7237,-7437,17391,-1309,11399,-4781,29251,-30149,-6845,25581,-29279,-11557,-17141,-11229,-16149,13095,14071,21495,-27769,-5365,-7473,12449,18811,17349,4499,-20387,22501,9619,-27515,10367,-20953,17261,-20889,-22145,-31539,20745,6725,28513,8663,-24181,13021,14485,24547,7177,16473,-26097,-23331,30191,22623,32117,29807,18841,-8909,5053,-22523,32347,22243,-1347,3745,13801,-2635,4651,-17837,9259,12383,20367,13209,16555,-23421,4471,24061,-27157,15291,24517,-24825,6977,-6825,29219,-28093,-7735,-5307,-24867,26909,6099,-763,-2947,-8871,-30367,-28425,-17435,29687,18943,-21243,-21371,3669,-4121,-4913,-1259,-20001,1745,-32181,-14383,-6227,-8819,-3829,-2383,-32283,-28549,-7719,6183,-32481,-11299,6805,11693,-12773,-1363,9673,31559,-22597,18175,-10101,23863,-15953,-24611,-8423,28629,-4435,26921,6093,-25795,18053,-26997,893,-26673,23511,26787,-18673,-8185,30915,1715,28375,-17945,20095,-29739,-24517,19203,29503,8927,-209,6763,763,12435,-3343,27853,4237,-30939,8197,-15111,22653,11369,-27935,-18161,19181,-13883,21899,-13577,-5679,23403,-9657,15671,-21469,267,22555,16127,-7959,31471,-14897,28383,-3945,15981,32057,-1237,24579,11809,-31605,10913,24535,10385,14311,-13621,-22983,-23079,-4095,-19271,-20439,-16591,-15949,-24033,-2567,13583,31173,-27857,-18799,-25533,16947,14121,-445,-24425,-25577,715,1673,1729,19461,-32071,-18253,-24895,13383,4641,-3817,-13545,-14161,13253,-26915,18719,-31983,5953,-18649,-8535,-24261,29905,16607,-769,26815,-22789,8453,29545,5373,-9603,5471,-273,-17883,29483,-637,21145,-30369,3021,22147,-22513,1659,24047,-687,21605,-29395,-9959,31905,-249,3689,3877,939,-20687,26311,22287,20911,-29293,1883,-31987,7835,22921,14867,20565,-5827,-29977,-28625,-27371,16455,119,20251,28347,-17683,-29733,12653,-12167,8305,-25259,-6113,9669,24033,6373,19607,8819,-21549,1343,7791,-26703,-22029,-4633,-30155,15125,-26683,31347,-1433,14487,23805,-16243,-9875,2513,-129,-19735,19883,-16101,16555,19809,9667,-8537,12099,-9829,-4331,-7467,-21349,-20207,21317,-1083,3999,25619,16537,-24155,5253,3761,13067,2297,-6429,12363,27693,-12865,16913,7117,11535,-2443,17763,12649,-19151,25785,-10165,-17005,-14015,25181,-26207,-22711,29729,16167,-12303,25969,-6871,-25109,9771,-11885,28365,11101,32093,23245,8625,-24263,7309,14721,2633,7795,3857,-22081,-9619,1181,-15007,16597,28069,20933,28875,-7773,1105,4251,-7285,12233,-6779,14661,-25895,-30743,24555,15809,7831,7379,25623,163,-13665,23691,-26881,305,-18941,14579,-17727,22391,-843,-19713,13547,-8757,-15161,-21253,1045,-18445,18351,121,-19485,-22821,-5095,12403,-9675,15889,27779,-11077,-10705,17399,9025,14507,1647,5057,-17173,26903,17153,-12869,5745,1769,-21829,13857,-30867,-32533,21401,13871,6899,14549,13169,14683,14777,32639,27951,11263,28529,10199,15389,-28785,24515,1299,-16855,11987,-15089,-17249,3807,701,-22563,18009,19067,-20399,65,31943,1025,-27903,-28107,21909,-15701,1129,-31693,28423,21095,-2633,15763,15133,-11837,-4801,-23103,-31823,24913,-7277,-21871,-24945,25631,22951,-27759,-29043,16111,-13687,-29163,22093,-12111,-5085,-24955,-2105,6165,2237,30695,-18171,-14939,27047,-30931,22599,-28233,11271,12655,18333,-21037,30347,-11135,-12115,-8551,-10447,25159,-7089,-9327,-7271,-12417,6663,-21807,19185,-12427,31761,26473,13571,5635,7339,-17271,12653,-6053,-27307,29651,-9771,-8907,15469,3753,5379,4255,-3325,-6601,-23613,1529,-6443,26597,-20645,1051,25297,21399,325,21223,28905,-19029,24515,-17541,6343,18887,-24045,8561,16335,-2107,-26415,23541,9927,-7183,-13185,30693,7397,-11701,-24667,-21289,-613,25791,17517,22211,-13983,-21641,29307,-11227,-21527,-8363,-6807,1705,16203,-1033,-25697,12845,-4941,-26841,-8073,31257,-14687,387,-4265,6867,-14543,10523,23113,25401,12859,-11293,26615,-30131,-32223,-31027,31773,27153,-20241,-22887,3317,-31243,-2079,28251,11875,6407,-17395,26487,-21895,-29243,6953,-8585,643,-11453,-18597,20953,-32703,-18613,4043,-31075,4061,2379,3379,16463,-16105,12991,-30705,-99,-31197,-14259,-21729,5453,15165,-9015,-8867,-4887,13751,26843,-10733,-6497,27615,-10803,-2769,29027,3199,12545,11065,32061,26155,-22637,17281,-21893,9,-10637,-13361,18709,4821,11637,21053,-10837,-21673,-30655,2149,-6745,-11733,-17459,14529,5633,-31537,-28395,-27755,-25977,27853,195,663,-2941,-25795,9163,-14739,-9033,17623,28639,26747,22135,-13643,-6133,-4661,-27855,13211,1001,22437,1891,-30849,5837,-18923,-23805,-26637,9485,2955,-12725,6533,19667,-13217,12425,3013,16043,9051,-7005,20083,29975,8729,-28643,-10667,1421,16421,12627,12405,-363,29001,12721,5423,-15819,-20415,18333,-20371,21671,23683,-26105,-4315,17601,32429,-17229,17283,3611,-1329,-11563,5979,13233,16843,-28493,14877,13567,9367,-3929,3325,20371,-767,14439,-24691,21717,21395,-21181,28863,-4675,-28069,2917,-11423,19405,12695,18215,13325,17183,24483,-2559,15077,22137,3913,3295,2113,-13563,14799,21713,-30247,-30703,-12625,-11611,-10691,-19601,2911,29119,-8095,-9547,-30823,-14029,-2241,-75,22177,27159,2731,-3735,3973,-23025,-12089,16203,16201,-21485,-12999,-3605,11003,-28681,20787,-21825,26411,27545,-4909,-17927,5839,5199,-9245,-18885,30173,5785,29907,-25689,20169,7097,-13337,9743,26003,28725,-11831,-25745,16875,18923,-25649,-8173,-25419,-25167,7429,-15677,27707,-21535,-22641,12555,-28349,9059,17919,5099,-32473,-31085,-9323,-8835,8141,31895,-18201,-16255,-4405,14319,10715,-12459,-31009,11507,-1161,511,-1095,-20141,24147,19669,2343,-31461,5833,-9489,10815,15661,29617,32599,17627,26647,-15973,2409,27217,-1819,95,-1343,28195,-17937,24899,31767,-29947,14205,-7563,3419,-20959,-31911,-14345,-29215,16471,3603,-15961,6215,-16139,-19199,-8435,-31759,-1271,2209,22095,7925,20615,-27163,-21191,7435,29869,14369,-6945,-12659,16777,-22729,-11403,26179,-19863,-25007,31987,30049,12125,-27587,-3911,-30039,-4599,10975,30347,-31385,-10825,21431,-13629,17441,-26075,-27309,-729,-8669,23647,25475,16631,8485,-25407,-13627,11347,-14453,12797,-8521,21521,-1385,31679,15961,9733,2713,-25241,24597,1007,-11383,-23213,22491,-11581,-23487,3287,-24305,21361,5113,3699,10591,-13133,31173,22171,-13129,-23653,28213,-30749,-1233,18373,-12199,10707,-31421,14717,17193,6839,30689,17107,16291,-30123,12765,-25917,-8145,-4503,-19455,10867,-19989,5313,-29441,26427,2875,8635,29949,22823,7447,-23039,5693,-16309,16279,-22347,-15147,-1867,5095,31209,-28513,26745,-27769,2195,-16189,-12295,-13763,16633,-30993,8293,-12499,-1587,-3053,-1387,-8021,-20145,17967,-20539,19633,3833,-27925,-1195,25347,24527,14973,-17253,557,-25593,11899,10765,26837,19083,-6909,-24961,16643,-10181,32177,-4975,-11219,-27127,-11143,-8487,9775,-28589,-16317,5589,12637,-31125,-27599,-25785,-14115,-161,22723,13189,8741,24953,23603,-3937,-4107,24423,22905,11357,18973,30705,-27099,-15459,-2871,12963,13413,-4911,17531,-27415,-24403,10259,-19119,31115,22605,9863,-821,-1203,10679,-19595,-32125,3515,25859,-21597,-17293,-11263,26971,-5703,5259,-27951,28615,25353,-20435,-13609,-15845,12625,-27963,3261,945,14297,-28061,9039,-3415,-8225,20115,29943,4153,-6733,9481,13203,-20319,-24641,7153,10091,31725,-8417,1485,25037,-21469,-19659,-1995,14661,-9025,-3913,-699,-19481,24031,-6605,-17337,-30021,-30829,22645,23373,8423,-513,21873,8921,-18957,-15627,-6537,8577,24535,19651,20773,3061,-19313,-29149,14173,-31463,-19637,-29025,3219,14075,-19781,-15381,-899,20047,14249,16569,20883,15451,28271,6155,30931,18675,28205,12131,-17145,-15439,7445,15237,-32039,6967,18817,-16765,11987,-14065,-12297,17611,20379,12463,12659,24915,27403,-26619,-8309,1297,26669,-32649,31361,-20729,27369,-12115,-11135,10041,-23311,13925,-14657,-14899,-13123,-1229,24377,20311,-17897,-21955,37,2149,-16627,31613,31839,26845,17013,-11001,10361,-7211,-26231,-19857,4487,27189,-16659,-32405,6193,2719,-11339,-3411,10987,-28917,-23887,-16909,6123,13693,31291,-8857,8369,18725,-2017,-20311,-4087,28941,-2955,6209,3607,-2865,-15825,22207,-1127,-11917,32201,16357,-16589,15153,5553,-8679,-16299,31519,17039,32681,-2175,-13587,-481,-28889,2365,22825,30387,-3991,3023,-13395,21537,3049,-4363,-29247,-2091,31809,30299,22555,10701,22301,-4489,-18811,18907,-28141,-28909,-14463,-19369,16967,7323,-25433,25173,-23853,-27011,-31455,-19475,13775,32353,-12223,7983,20943,-2429,-21695,2211,-27441,20361,-21823,-18497,-11937,21385,-2257,-18007,-8773,-25097,14405,21463,-2687,-10361,24847,5653,21101,-26493,29677,-22555,-145,-17719,30619,13335,-13563,-30317,-27025,-21291,31191,13469,9837,-26939,-3437,31177,-19717,21441,-14335,-26335,2131,10917,19931,29693,-8925,3401,-13185,22431,-19871,-13257,4143,30067,-22745,-17037,9899,17713,-28995,24169,16155,8637,-7361,-8339,4883,10827,17559,4927,7447,-27237,29495,7967,12915,-2675,-27005,-5811,-28177,28517,6787,29071,10043,-27383,-14401,15003,12709,-6809,-31625,-8555,-19297,-9627,-18429,13435,16705,-12019,23731,-3017,-1777,6799,21551,379,-13381,12879,-17601,-6127,26959,30329,-2509,-31243,7371,18213,-18319,-23347,2387,10819,-29029,-399,-32703,29817,-12937,7257,-5593,24903,-23689,-32673,21717,24921,17179,-17155,4299,26999,-11349,23037,-9911,-18671,10551,-29679,18911,-5093,-18785,-7489,5637,-29227,-609,-14307,30611,18145,17515,-4533,9389,-6747,-31979,18311,-19555,-8389,-30665,10017,32129,27453,13067,61,17407,-403,16341,26591,24711,-3471,-23135,-29419,4937,-17009,-30605,-29255,4975,-26585,-15493,-32651,1855,-27667,-2971,-26845,-13339,-8577,17143,31655,13939,-15745,-20169,-251,-26375,29199,12187,4735,7785,11241,-25511,11937,23115,-16447,-25473,-20875,-8571,-17611,2851,3075,29979,21127,-12513,-14633,-19747,-32575,-32221,18965,-17293,-14659,15519,-30217,28863,3675,17691,-12427,-28367,-12303,18819,16933,31369,-28425,2841,9291,24079,7573,-2437,-31939,-25505,29313,-28331,6879,-8929,2499,-10443,-30111,13359,-641,32687,-12013,-981,10215,20639,-24267,4869,16939,10199,19639,23025,-28561,-4183,-18391,17023,-30513,8583,1887,-3843,-1939,-23629,-10561,7775,-4545,3509,31999,23179,11125,8013,-24135,-4643,12311,6559,-12151,-28525,11117,-3307,24513,19059,-22575,21309,-12897,8681,6859,2617,-12999,13833,21047,25409,-2423,14435,-13343,-7195,-23159,8189,-18817,-15305,32515,-19487,-8021,-17667,-17483,1043,2515,-9371,23967,16667,-1165,3619,-17703,28525,20249,201,13069,28665,25633,-25305,5537,-6545,11061,-18391,19003,17711,-15235,27415,27713,10019,15181,16819,13289,-10143,24349,28539,-7869,-25027,31729,17987,-28455,-6367,5537,-11427,3971,7361,26171,-9245,32441,-26173,20293,-4561,-7209,-19635,-7973,-7465,18325,-30527,-22033,-3465,13443,-30089,19301,-9577,-19985,23393,15439,29469,-28551,29171,-10457,-19481,-21209,-27105,-31007,26891,4169,8037,-11925,29337,25713,17187,-29731,-1459,26105,-9863,-32711,-29383,22195,-5321,2437,-31525,-23575,28767,9679,13865,-20405,-28377,5347,-2381,1825,-19941,-7829,-8553,-465,25855,-31209,213,22071,8001,-22789,9889,1293,18881,-581,-6731,-31491,-29743,-24325,24825,21767,7169,29541,-19473,-30963,-11479,-27073,-29485,-6555,-7727,9173,18515,21845,24173,9321,-1707,9095,5707,-24837,-3323,18943,-16535,12503,-31925,22631,-17807,1711,-28549,311,29487,17125,29757,7059,13333,21993,18691,13901,2199,-15485,17043,28791,-24569,-16257,-25513,25311,-2643,-20463,-7021,16607,-18351,19253,-32649,-26053,12447,10557,10749,-26149,-18675,29795,-87,26019,-11103,26517,24985,14111,-22571,8617,-7967,-23749,-5867,-1123,-17779,8113,25899,-4075,-32589,-21475,14835,-27007,-30015,11159,-21995,-3591,-24583,16403,32745,31153,-29345,6649,3249,-17079,-14167,13963,-3599,-23791,-365,-1979,3187,661,24467,31575,-19203,6569,-29881,32759,18439,-23483,31513,-31061,-31949,4853,6817,14065,-10635,1251,-13299,17641,7853,-9185,-1189,-1939,25429,12281,19507,-13425,-6159,27815,2975,-23543,-18007,-24743,-4921,-4135,22173,12159,7189,-29429,18059,4575,4131,22849,-26985,15061,16895,-10991,-4681,14069,-10553,11435,26763,14101,10721,12083,-27013,-9889,32401,12343,16545,-12497,-24469,24431,-25807,20007,-29455,31599,-11613,21739,-721,-15353,16221,881,-13727,11537,32727,-11981,3273,22761,15921,-8107,-26879,-30161,-17119,32241,25619,-10861,-30115,27647,17077,28665,21633,901,-24261,-12775,11969,32413,31659,10619,19231,-25047,16855,17263,12769,-19797,23751,-14889,27511,27047,25433,29437,22677,-32267,20637,18973,-31375,23719,677,-32363,-9675,-21243,-18119,-16875,-2383,-9857,-22313,30021,12807,10061,10561,-749,-32663,167,-24773,-24547,26489,7997,-10541,19365,-5505,-16387,13405,-28143,-5691,16653,31937,21611,9883,25181,-2093,-6385,15589,-20797,-8917,-15569,-19805,28935,17669,26549,-14221,-30793,21329,-15567,-24223,31741,13095,10149,21429,-19217,10611,18489,-26863,32101,20143,-12469,10331,20935,-22913,23407,-16337,-12733,7623,-17643,-14001,10213,7021,11133,-171,-23669,-22759,-18721,17677,1775,-4109,-20427,-6809,-32093,11145,6861,31553,-6515,-3137,29117,3257,13263,25127,-917,28497,9857,-29807,9551,11099,-951,-6477,-32563,-23831,3243,-28829,9419,-27477,-19097,9079,22831,6477,-155,-5867,7143,-9517,-1941,-5371,5253,-20521,-4101,11003,31939,-5105,29933,-25069,29139,-9295,-3609,13589,4007,-24143,-333,27049,-14527,12215,22191,-18317,10151,2127,17033,-5605,5749,10705,2161,-12125,20813,-27715,-21777,-15687,-32103,19993,4365,2699,-10041,-9859,3601,27987,12811,22815,-2779,-11185,26153,3991,21839,30709,-23873,16129,28055,-21685,7313,30763,16837,-6485,-11733,-11473,-30751,-32027,-7661,1699,17569,-19113,8781,-16341,-16671,12541,15353,10967,19711,-8757,-4615,6069,17129,-28491,-1677,-12929,-3933,7231,16801,31143,-22605,29035,4679,-24015,515,-6457,-2029,32509,3337,23171,16357,29981,-24803,-27659,18279,-20795,30477,-14069,31179,-1167,-31271,219,9099,6057,2917,-18367,17985,19505,10169,-30477,-29175,25525,8695,-29049,-26477,28937,10001,-15633,-20535,23283,12499,11521,19533,23555,-14489,5031,-13213,19705,21901,-14627,15641,21301,-18141,21921,-7983,-26583,16579,28057,17923,-31987,23411,-7253,29443,-26147,-881,-6873,14031,22679,8149,-16011,-32759,4519,31835,28319,-18611,-16397,-26789,25761,31011,825,-27473,719,22405,-24245,4411,-13525,-5985,-12871,-17543,-20625,10671,-22225,-15377,-7819,20499,2493,21709,27903,-21453,-23391,4909,-14029,3567,-22001,-28265,-24433,-24207,-22557,-10427,-13659,-10005,-23311,26753,4101,31731,31073,-24843,27331,5503,-9901,-27179,26781,-3031,28009,16355,17867,-19729,11811,-2437,-18315,-22999,-26773,-20239,71,5021,-20691,-31187,-20253,29573,-2889,-15999,-16437,21233,16861,-16963,24299,-28755,-4691,-20579,-1337,6219,-29441,7915,29523,4513,26067,11821,14399,-21815,-11623,-6163,24753,-5339,31047,-3979,17469,-7509,6281,-25337,-17981,27027,14161,32185,6717,20961,18523,27851,24175,-20513,3691,20581,-12747,31645,17059,-1921,10675,-22609,-25167,10351,17243,-9049,3921,23739,-11729,-24403,20277,-6269,-2757,-19705,10497,-19773,-9365,-16475,-18455,-4493,-25151,-23909,5609,-93,2673,-31735,-12927,28915,29359,-51,-18159,-17511,-20699,2873,-31171,-29741,20185,23565,-31613,14843,-31169,13107,6971,25153,-25671,8799,-26621,23217,9415,31775,-13925,18437,10283,1983,21781,-18133,30889,-14939,17765,-2809,26195,-5301,9863,30785,-8763,-27175,-29049,-15857,12749,30933,1949,-19801,22489,22517,28015,32029,2965,-2855,-24145,-26357,12149,23873,18263,-17761,-17603,7279,28621,-15711,-26415,12603,-1531,-9745,-24503,-21349,-26917,-29625,10135,-1,-17699,-11255,12697,11267,-32649,-29691,3989,-6755,-32767,9845,27431,-18341,8675,30693,7811,-10427,-23495,22751,26281,-8213,12141,-32513,19629,2113,-29499,31345,28153,-17203,-903,-2333,12689,12383,-23535,4643,27413,8469,-26739,26787,-13999,-18973,3843,10713,4821,20983,4671,-18401,-17475,5509,-20439,6359,27195,12675,17103,-8039,-12813,-27113,-31791,-17821,6045,1043,18269,11253,-30225,9945,30191,-25847,-16233,29091,-27695,1969,-9881,-11095,21149,-30747,13899,11223,12667,11591,18683,25979,17479,21557,28143,28851,6151,26277,-239,-24899,13617,13485,19303,19209,-633,12743,3733,-3581,13811,-17687,-15405,-9507,29213,-8289,-17571,-21073,23211,-29491,11927,23889,28683,-19737,-4375,-29945,9391,-941,25443,-1569,10647,17325,-4515,-22881,-28837,24569,-767,-9113,-30177,-20277,-28111,-30277,3509,-20517,-14237,28367,-22111,17313,7425,11811,-20539,23419,4615,29645,-17233,17991,-17629,-31991,7607,-27881,-31953,12707,32499,-26497,-32603,-29599,-8785,-21057,-21453,-8825,23165,-18987,22427,-22575,23113,-29285,23067,-23865,20647,6559,-18741,-28361,9991,13935,24941,6763,14831,17779,13301,12985,-8521,-27631,-28907,1875,29233,-13131,2341,20575,-21487,6629,-13971,30745,-30083,-31563,-3673,-18239,20493,11769,-1737,7809,15489,8951,24225,28195,-12965,-6431,-26899,4807,30189,8639,15979,-24159,-22917,32643,24499,2091,-4853,143,-31959,16809,-10315,-31417,32567,9817,25899,-1827,28011,-15909,-8791,19987,-6751,-32245,10815,22231,12315,19031,-22291,5859,12157,-27249,20617,26253,-29617,-8249,7545,-17665,11765,14505,-3729,19535,31651,-10497,-13397,-21401,-2229,10947,18479,-15695,-22267,-1235,9685,-11351,-18321,-6253,13967,-30693,17211,-9325,22185,27545,-14277,20989,-18777,19221,26089,-23511,15567,19863,-13973,24703,1691,31959,2975,-18111,-1739,-393,-3465,491,-29225,31595,-23279,-22383,-29967,8115,-18267,-4351,-14677,32469,-10337,-23163,30655,23149,-11013,12185,-19337,-22559,22737,-14149,-11965,-3853,-12841,29721,17251,-4749,-11255,18017,22959,-7563,13595,25551,-18175,26195,-22531,26319,27535,28337,21989,3983,25443,6037,-8659,-7123,-18837,-26935,-18041,3053,-29357,-11361,2305,1731,-31727,-16115,-15863,-31261,15507,-27641,-11357,20859,25145,32585,-31069,-7799,29073,7035,5951,7461,22885,-14267,-14903,-24085,-5939,24365,25863,-20313,14161,-27635,28405,-15523,-23257,29621,-27903,-15465,-25607,-21233,18635,-19921,-28919,-4939,19413,14263,31201,-15591,1371,7357,-20817,10223,30737,-11309,24375,13337,-3637,12333,-11965,-4513,7885,-18175,-25915,-22425,24307,-27041,-25241,-26723,29727,-21481,-21263,29779,3813,28579,7007,-22955,26533,29791,10601,-30459,-4517,7303,29455,2207,-879,26991,-225,12285,32723,-18839,18375,12433,-30885,-1485,-12159,31093,3747,-7859,6345,-11989,2363,-22999,-25255,-23043,21365,19993,5047,-889,-12983,-9553,-23895,-23411,-15411,15611,27643,-1907,29939,-7557,-31643,29459,-17059,-16555,3721,-6051,3567,24221,-31897,20235,10479,20019,-4407,21401,12871,-17161,-29671,19127,-9129,31065,-12577,20917,14625,-18423,-19001,-7057,609,-455,-11593,23405,7389,-15337,30125,-14249,21661,8893,23547,-8505,-32147,1101,16243,-30959,-13665,-3235,7801,15495,32529,527,-12443,-26647,-3457,-231,-19723,-14791,29357,-22481,3229,5873,5195,97,-28619,6353,-10585,693,-22379,9611,24167,-15627,8499,19181,-19659,5709,-5157,3553,-8831,10043,30781,-1517,29311,-15239,-24299,-17643,-1347,29893,26321,-921,28223,-13115,22117,-21979,-8477,-15059,-19625,-17759,31005,31023,11503,-8659,5183,-11125,-27323,-27787,17279,16957,-25221,-18665,4219,-30329,-32575,-23961,-19301,-15739,22065,29697,-8085,6159,11295,22187,2585,-8643,847,-1043,2767,31345,25419,-6281,7933,18119,-25571,-27891,-841,5219,8327,5601,19197,-2731,26413,-32093,14093,-5189,12429,19939,15249,-27277,24121,-2683,-24865,-17603,2475,-18555,17827,-13297,23585,-23409,21333,-17243,-16863,8191,28475,22265,-10453,-217,13991,5317,-30859,27261,15911,9841,-28949,-28815,-1773,-12371,13983,-1881,20257,-11663,27715,-20135,6743,11703,17355,-17855,-10937,-18727,307,-31319,26489,26101,30499,25253,-1809,-15099,24183,673,29055,1359,31003,2333,-3167,20063,12497,-11077,407,-6543,-28087,27381,-6909,-25625,-5733,22003,-30207,-621,18131,-22065,-19651,11905,-18229,-4681,7001,-973,27651,19153,-25093,30675,-12093,31081,-14023,-29037,-15551,-22543,29155,10079,-28537,18227,-31163,29761,16231,-26013,-30145,-7375,32087,-1851,9265,-22405,-18617,12337,-31847,15805,20029,-24277,-16441,28437,-9225,963,30619,-30041,23397,29025,-17565,-16217,-17579,-27525,-14107,-8325,-25207,9765,383,-9103,21693,12731,-25521,32185,-8291,25729,-31763,-8947,4375,-18203,31705,3509,-5679,28445,-25819,21511,18737,2653,18025,-26175,-15663,-25867,-4295,32211,-15471,-1881,17291,26349,17599,15489,11501,24611,19653,13803,-11759,16685,-1365,-14677,-26637,-30349,26453,12353,3789,17457,-10279,-26521,-2823,-13913,-26271,11941,17095,8577,-30037,-31099,7465,20795,439,9891,-22687,14197,-24697,-12211,16745,11893,5867,-23563,-28287,3831,1447,-14517,-21107,-13889,-3825,-13085,5295,-27935,-19059,-19205,13895,21001,-9707,5105,-7345,-12923,28345,10209,-18025,-12631,-28583,17933,-15599,13647,-6013,29155,7617,20625,8401,30309,-19387,30313,-10751,-21741,-3669,-6657,-29799,30289,-9475,-12821,-24519,31641,25905,23727,-25043,-1753,-5325,2425,-31733,19823,-13979,-24521,6777,-27861,24355,-18473,-3255,-239,23661,-10933,-20183,-12465,-11231,20781,13489,22955,-3179,-25253,22633,10529,14799,16201,-32293,-14791,20867,-27851,1677,-1881,16299,523,-4727,13565,-12867,-5999,20683,18761,4019,-28931,18753,14731,-32337,-21335,581,-16493,3597,24777,20793,21129,-30207,-28227,-31569,-18479,-14805,3317,-20869,-10081,-28103,14071,29241,3927,4569,27541,2671,569,-17529,18587,27737,4945,-13425,-12701,26007,-13873,-23525,13997,23599,-14631,-22301,-29223,20201,-14831,23349,-22895,2189,3471,-2405,-17331,1577,1597,8249,3931,3617,17297,-26467,-9349,12107,-2131,9187,-20709,-15683,-30699,-11275,9149,19955,28181,5819,2359,-14633,-7431,-9387,22787,-4081,673,13457,-11463,-15751,1733,-2149,-30255,-31661,-8121,-5033,-2983,-7227,29263,26699,15501,5945,-24695,14101,-7801,14635,-4981,-30527,-17255,23145,27807,21331,-29221,-21125,-2445,-22237,-28775,3191,17673,21497,7443,-14645,-18023,17917,-2981,8299,-2371,-11473,7691,27671,19579,13673,28643,-10077,9389,-15823,-3221,-10273,-7371,-29115,3229,-19769,-1371,17629,-12543,-4479,12643,4065,32495,26353,21767,-2707,28021,731,19787,21373,5887,-25433,141,-21547,-15801,11995,-4439,30747,25367,30359,-19519,-15505,24709,-31843,7083,14435,569,-26893,-4603,6061,-2711,-26445,31933,-29467,28443,26595,30151,9579,20411,-29073,26583,20489,-28379,-9625,7375,26035,-14347,22239,845,-21859,-1591,-32563,29375,9447,20929,7331,-5121,24095,18353,-13217,11261,-9843,18843,24789,7195,-4851,-12631,9627,-26347,-7311,-24741,-17455,25837,-12169,-13309,-25415,-19761,-24183,-29141,10299,-10547,-14719,7905,4053,22369,25337,-14145,3969,-21851,-21977,23447,5031,-10315,32059,-32487,9833,24481,29127,-31111,-5233,-6365,-25609,2603,8561,14923,-10201,27227,-19961,29051,6275,18677,-29243,647,-25435,-10329,-18227,22481,14191,5729,4867,7365,31237,-6297,-12319,21799,12261,29059,-30515,-16397,22891,28083,-2811,-21077,13939,-15493,9551,15911,22025,-32669,31191,8133,-15565,1755,-25543,6435,-8733,-5109,-29383,-8019,27677,-26577,-12083,-5203,13773,-7177,21475,24591,-25391,8173,-19435,23081,10251,-25165,-11783,-26467,-5409,-22409,-30961,32143,26339,-12769,-4699,-8735,32413,-25209,32307,16079,-31995,23571,-27597,895,7687,4927,26823,-20485,-3125,-29647,-29817,-27501,-13605,25149,22961,21539,-22179,28565,-30727,-25377,26241,-18801,13381,-18973,-12423,-2053,4797,4315,32073,19953,-6453,-25883,-31469,3317,11835,-1257,-31529,-28761,31625,17265,-19871,-25501,-26309,25015,24971,-5097,-32737,5249,-22123,10951,29729,1291,-11679,-27845,-21929,-15161,-21245,25141,20935,-30427,-26761,-23333,32673,9295,27301,-21179,9533,-14851,-13871,30077,14929,-21475,19795,10727,-1399,-3859,-4897,-24663,26553,-10779,16909,9935,-8729,19629,-553,-3409,-26381,-11479,-3527,3625,31031,8763,-7501,2747,691,749,-26061,-5195,-28269,-4293,-16571,3353,-29337,-20023,-23227,-5669,-12609,16703,-29179,15681,10189,-123,16039,11367,-3935,-22199,-25029,-10365,20349,16971,12667,13991,-16357,-8275,19049,9625,-3967,-28703,-32643,-11215,27815,1723,-29031,19177,3765,28841,29983,-32607,5031,-3461,-2257,9633,11433,-21191,-2743,5793,15181,-1169,2687,719,3459,-16011,-15577,-18587,1291,-21613,-3195,6651,-24057,2619,-27387,10441,18605,-1385,-31985,-11119,5605,18335,5517,-19625,-30143,-2157,23623,15301,4709,28421,-16397,-21035,16191,23915,4397,15019,-17495,11957,32255,-14879,3139,-12977,-22591,10715,-27239,157,-6749,4025,16667,15493,521,-31201,1023,-619,9211,4419,-4795,-6519,-23917,5339,-941,28203,-31599,-28607,22507,-20573,28331,-25363,-771,-5003,-27915,26031,-24165,21865,-32675,-24661,-3653,-6863,-10395,3631,-12543,-15049,21669,-13633,11487,-26073,-12959,27275,-19357,25659,14157,-17575,28693,16193,-32405,-7839,10983,30497,18373,-22541,-10787,32427,217,-29899,741,-9133,-24057,-5515,25741,16967,6081,19037,-11845,-19483,19079,-23671,-9511,23433,-26451,-9393,3067,21755,1755,293,-22507,-19213,8467,2449,-9707,3909,671,-1601,26329,13749,-7001,3419,-14911,31137,8089,32631,7199,-12927,30113,-26953,22127,-21563,-16757,-3025,-7011,-21399,-19445,-12063,-10685,23255,-30763,16401,2157,-2863,-31611,-27291,26857,-21599,12061,-15861,-16691,23377,5309,-30433,-15185,15279,5361,-16293,24325,231,-14097,15031,-21607,-27693,-20917,5557,-22437,-24737,-26617,29455,-7599,7577,-413,4241,13805,14327,17465,4317,-18235,8863,-13033,6085,16253,4785,-16575,-15805,7339,-9539,8207,-22421,-17429,-5339,-22239,4041,7973,29529,-27689,23509,9899,-19539,-12173,-2787,8657,-1127,-17359,457,2145,-4743,6791,9615,-14993,-21265,-11443,6755,-4907,31359,5329,14231,25211,29277,8157,-13525,18511,-5451,-20519,23391,-26651,-4415,-28235,-14373,-11151,2363,459,15223,-16607,-14909,22881,-17205,31317,21101,7651,-3565,22497,15321,-14655,-32235,-4467,15451,-28871,-27635,12941,-23871,-24021,15285,-27755,-19225,7863,-29683,9117,-10761,13373,31601,1907,-13149,-32709,15849,-31149,-225,-4347,-17769,28307,16817,-29607,-20819,20999,15185,-7077,-2191,-6049,27777,-25501,-9011,-7323,28661,17947,-21373,8881,25115,-5487,-15543,22393,-27533,29523,30445,-12005,-11151,7323,-10101,11805,28489,6483,30507,-25435,27577,28765,-22127,1781,-27513,-10635,3547,28093,-26017,-27579,-445,-11519,32443,20161,2543,3171,-2165,19287,-371,-16017,-7761,8755,1043,24529,-18223,29973,28525,27367,14509,-1385,-21845,4543,-7107,-8153,-11341,5617,-31587,-15413,-20195,15903,9235,16811,17875,6587,5025,31349,22813,26669,6137,-31469,23259,-6819,-4051,-21587,-20815,32215,-29731,-21467,24399,12917,31227,24067,11713,-12949,-7713,-31145,9159,-13769,-16131,-5547,6537,8881,-30379,-15171,-17235,27395,32671,-27749,23785,-26631,3735,-18009,-6617,-16015,-27435,-9961,-1507,32319,11141,8579,1555,30407,-8641,27101,17819,-18149,20963,13763,13497,18869,-20809,7439,-28241,4915,31739,27011,-13287,-3895,-14317,-8595,-27999,-7943,-32235,-7917,-31939,23465,-19823,-12777,-5489,13851,12395,-24323,-2477,-20641,-3111,4339,19909,-24831,-18435,-7973,1399,-23119,-22219,-31849,-15513,31243,-25363,7433,8759,-501,27745,20235,1557,4857,27691,-23011,11635,-18079,10427,-15647,-11769,-29069,26603,-29361,-16383,19819,-20219,14925,-20013,4941,-4953,-28207,-31015,-21765,-24771,-5943,26955,-20795,-30271,19395,-14113,6895,20099,21657,10433,16905,15633,17945,7591,32191,-18103,10609,30067,-29379,19577,25965,-24193,13981,8633,-18061,1093,12363,-24893,31139,-31821,-17617,-7541,-27041,-5743,8703,-29783,-18635,23253,26661,-32355,10299,15667,-4271,-24913,-27039,9199,-11235,21533,12711,-8883,-20451,-5507,31873,9397,-30217,2317,12211,10545,-5627,-21887,23631,29229,-4187,-12197,-26165,-32123,14943,-4917,-13015,159,22899,-25999,1309,-32289,-25027,30125,28157,-15367,-8565,-637,17329,-15473,-27073,-31305,21983,-16383,20181,-29023,-20635,-32661,13701,-32137,-14217,-12765,16457,-31771,-22165,7817,22557,-3539,2613,-16189,-4149,-16933,1437,22925,201,6559,5987,261,-7533,-17335,5839,8229,16203,22235,5419,-16865,-32431,-23483,26097,-16381,-11043,-23203,9669,29067,9217,-28479,-14049,-14313,6875,-9059,-22953,-2749,-3927,-25377,19823,-31607,-12871,-19393,14973,-20025,20305,4845,6219,-24715,24445,7153,-753,24945,7093,-14227,5527,14307,2339,-17507,-9187,-22913,-29107,-2033,-26055,26775,-28845,18629,28211,-15281,-13865,7289,14587,-29049,-26175,-5419,13379,-6135,31887,21119,-6553,1777,26453,-6977,-22173,851,15531,-22041,-11593,-15059,-29773,-9223,-29163,-19359,-14585,6783,10499,29833,-21901,-8325,-31157,3119,30991,-26065,10847,-11155,-13177,19835,-21195,5613,8141,-26559,13553,-25125,14543,30927,15609,7843,14263,-11495,-25321,6781,-2095,-21209,-30623,11639,-2765,-18105,22241,-15859,-18245,24929,18933,-29289,10057,13241,27999,22031,-12789,-26519,-10877,14917,18847,6717,31795,-7413,-11023,-6929,-9037,22949,5539,9421,-3923,-18805,4495,20601,-2163,-5425,31555,-22937,14517,-21213,-23957,-13339,-26125,-19911,29289,32665,8435,241,23897,15809,20907,-21723,-29577,18849,-20171,-17959,-503,-22243,24435,14277,7533,-9039,29401,7547,13833,-27997,-18205,-3871,12973,-9083,5567,17835,-22139,8533,-3465,15627,32587,-6135,21461,-20631,30553,-32471,24693,21569,28361,26789,-9291,6281,-15735,7407,22547,9605,-6959,1209,-325,-24237,-9587,-11803,-10099,-30749,-963,-303,18655,16249,-7395,17887,12845,-6381,32465,-23049,-32461,-11075,-25793,-4735,13787,-21471,27019,16113,-6209,-32277,-11905,25741,13205,17243,-4887,-24869,-9501,14777,-28407,25045,-18451,-24643,-8589,8369,13183,28859,-8955,20031,-11397,-22085,-20737,-28569,-13107,-30643,-11015,-22931,-27809,-8481,32093,18145,7853,-7181,19307,25375,-19003,20139,28055,-17065,17503,31021,-20013,8773,-23379,-19861,6677,-1841,30545,24879,13737,-19259,-24333,28833,22567,16209,-26545,-16885,-29533,27197,-16271,-14931,32385,-30871,-26037,26631,-16395,17337,-1073,30533,3893,9471,-17913,-17607,26099,-1639,14911,-16849,-16231,11399,1813,-24399,23435,-15709,11713,-18907,-21215,-6415,-29979,6563,-7469,23003,3241,4579,17981,15817,10327,17211,-10501,30101,20059,11803,-24937,13247,21359,26447,-22543,7691,10867,-17941,20413,-20787,-13551,25129,28559,20063,3609,-29871,-8049,26913,-14371,19203,-19303,15805,4219,-1491,14095,-29909,20259,-26361,20771,-30361,2971,-30513,18377,-16851,14743,-6901,-11151,-8879,28547,-9673,14313,29433,21355,27879,26577,-14013,-14477,-12251,-19819,-12357,-7433,-31315,-10209,19593,-13119,22307,-7737,-32229,13241,-20495,-29645,2363,-13937,32291,-4743,19523,-19407,28111,8105,19977,-1061,-9517,-1705,19259,-6357,13583,31299,-21615,5299,-31391,16633,-23493,30939,17713,23463,4979,-26211,-15467,3439,-3525,-15327,-8717,-2315,-3331,32451,6737,-22903,-14761,19635,20457,-1529,-22185,10149,27915,8757,-29697,24359,-2321,29339,15309,-17501,-30145,29215,27369,-6775,9075,301,12593,20933,9271,-32301,-14323,29937,-31129,-28405,-9743,933,-6801,-28285,-4895,9665,-24643,-15299,5721,-9101,30279,8967,29075,19289,26019,-15113,2765,3855,32019,31543,20223,5481,17907,11217,-29241,-32147,21403,-6021,-22737,-30169,31207,11829,26441,-101,-26367,-15791,-15981,361,6409,10939,-3525,-28133,-15531,-15297,-11053,-6845,22859,5739,-28875,20069,-10839,5263,25749,29035,17307,23395,-31319,-14087,-15469,-19061,25129,23633,-7491,30537,13741,-23077,20163,-5427,-13275,4159,-31725,-31001,-1115,-13571,31357,-12443,-11311,-4777,-26501,22151,-31803,21471,19069,6837,3419,26007,-18769,7393,-2571,-29845,-31885,-20035,-31901,-29847,-7241,-18835,8081,13377,32029,-1803,29113,2341,-6325,-23155,23435,3017,23613,22975,4935,11037,19955,-25887,-7921,6827,-11947,-2377,8341,8139,20721,2621,8809,-14351,23033,-5329,-6823,-14411,1579,-15541,2067,-1429,18457,11825,-27199,-831,-9211,24663,-15607,-3929,-7239,27631,3427,-14451,-12141,5629,32089,8965,671,-8969,-17701,12041,-4891,20843,13421,-24105,-29299,-17973,20427,26993,-31201,-3895,-21317,-23519,4673,14535,19717,-31179,29339,13919,-22271,7627,-7871,14203,11409,-13847,20827,22071,6929,89,29293,23477,-8511,-12821,-21749,3273,11485,-651,-24479,-13713,3523,17313,4913,-31881,30467,-31911,-1429,21849,11231,10391,32721,-27397,-28023,-5575,-3193,-15991,31485,-30471,13067,-11827,-16657,5563,-27925,-507,-14485,-23525,18239,11639,-24067,-19903,-30201,6601,-10965,-28345,28305,-3693,-25221,-30363,-11865,-4233,9967,-16615,30499,-18403,7297,24997,30563,-13429,-12825,-9831,31731,30255,5323,-17185,29773,9877,-14201,30577,-31309,20201,18597,23187,17607,29651,-7245,-29087,-10705,29523,28045,14415,-26413,-24305,32451,29565,17427,791,23483,16325,-24175,-28161,-16741,15053,24885,-10433,4915,26291,14271,-15891,10411,-17829,5529,-8859,-1457,1423,-28097,-3043,7691,12033,-27519,3065,-17307,15753,-9259,21047,-20527,27297,10907,12707,-31151,-17433,-10429,11159,-18349,-5519,30639,21983,26815,-10663,-3581,30923,32007,-30375,-18573,14723,29277,24609,-19,5161,-27625,-17773,-20199,-26447,12929,-20927,-653,2785,-10773,3371,10963,-27393,28567,8963,-21987,-5355,23171,26009,-8709,23467,-5585,27889,18061,-13259,22309,10147,-2109,-23039,-6549,4959,-19335,9111,9677,-23939,11127,-22655,28771,14637,-15389,5513,28909,-25513,-18727,-10493,-9017,24809,4003,-31559,-1265,26277,-26599,6809,7645,27761,12427,-21839,5585,17267,-4005,30753,-17171,-12697,30801,-869,-17591,26369,22161,1473,21193,8279,4773,-379,25829,-999,22263,-32005,-31735,10921,-20623,-27245,20517,21883,-6747,10793,-6853,29401,-6787,25401,11931,-16759,-15695,25133,13079,13789,21893,-21677,10789,-9397,-5777,24877,-5177,-9465,27239,22309,-3003,30831,-20737,-28223,29915,-12425,-2483,-17353,10103,-27613,2919,8037,6741,24303,24985,30005,763,22311,29229,6179,29861,-6847,-16627,-31495,-30929,-21811,14161,18899,-25159,23853,-3211,5879,15149,-249,4315,9217,-27131,-9073,-14469,-12229,-28023,-17605,-17533,2173,-10381,31423,-32003,25431,-1711,12301,23069,-3209,-8653,22859,25523,15397,-31801,-7373,-1429,5679,3145,28439,11661,32537,14887,-20167,-19367,-6625,31641,31557,2621,9443,-15969,-29721,12201,-361,4623,20471,-8111,-20985,4109,28881,-17213,9897,-11653,6449,-21307,20703,31331,-3831,15673,20803,-20257,-29045,-6769,-7181,103,-2967,4505,10033,-2695,-12263,-20877,25169,28881,-28941,26735,9887,-25919,27473,-26531,-15997,1371,29329,-24269,-30645,-27391,2825,23889,-29633,-11133,-28381,8283,-14639,26101,29303,-23645,-6503,12943,-2895,26047,-17347,-6015,23191,21741,-24587,1781,24871,13685,21867,-23639,29559,30515,-15121,-17505,21969,-14301,2985,13933,1015,-8821,15599,15901,-25469,-16247,15639,-30189,25005,-25885,4859,1695,-32613,-31127,-20523,-27057,-21755,22855,13163,21495,14629,-14767,-29339,20781,18877,-7099,4863,-11993,-23,-7273,21983,23811,10313,-9583,15777,339,-22633,5385,-15973,29433,645,4001,-11911,-3113,11193,30151,5441,-4387,-27721,-28985,27119,-14071,16391,23143,10131,-16771,-9105,-10341,-25749,875,7941,19487,-23607,13283,21691,-28059,-21407,-18937,22661,31441,8465,32717,20549,-23745,14887,-6531,-15197,27655,10173,-24161,18935,-8371,3519,21017,-4487,-14371,17969,23401,679,709,-21493,-25019,26299,-23625,-7215,24937,14037,-9899,4111,8813,10987,19399,-14389,20689,-16393,-20969,-13195,-30799,-2601,-24503,25823,9295,-25519,6815,21927,21901,32103,-13087,21149,-20181,1445,25985,-10181,-18695,4149,-28667,-28917,-31835,2477,-2191,-26833,7737,14183,-1101,-28737,-29213,-7543,2551,477,-11599,17143,29697,8715,-25281,1617,27763,-11121,-8109,-2665,12967,25951,22551,-103,25391,25621,-20581,-16669,-6275,31799,15317,-6115,-32573,3015,13011,21821,-2773,26969,30993,32745,27515,19111,5355,-4793,-16001,17589,28279,26207,1897,22827,1477,-13797,20379,5519,11241,31727,19357,-4887,10869,2339,-27609,-11241,-17253,4297,-31459,-29861,-18105,18525,-32527,-9843,-29955,21281,-16001,14493,30765,-28429,-25115,-28489,25225,-11261,-20739,-9757,23933,-21917,6431,14325,32019,22365,20205,-15021,17725,-15159,3945,-26279,23829,14395,25491,25327,53,14723,-19595,16319,5439,-8543,-695,26149,-7267,-10623,30259,16037,-21527,-15471,-5641,6021,-12121,23795,3441,13413,-30245,14517,-2099,-31347,12083,-22467,-13103,11795,-22077,-19579,-22051,-24241,-11163,-7239,27727,-5705,-26941,32741,-14489,-8327,1851,20687,16395,25353,-21913,6229,24281,-17109,-17273,-21871,-27985,-15293,-8031,10295,-10131,31113,-2771,-4993,9655,-7181,-6187,2515,-10729,12135,10945,-4239,-11775,9495,-6017,23205,-6195,4413,20147,32505,3185,-28041,25373,3433,12251,-5709,24183,-10741,21819,-30439,8631,24003,29679,27675,27141,29363,18689,-11245,-73,-3541,-28745,-4769,32381,16285,15161,-10353,-10725,22799,-3475,-20681,-18445,11583,23639,32141,-15513,3837,1495,6465,-24739,7065,-28953,-31015,-28411,-29493,2775,-26289,-20767,-5123,-10947,6045,-11777,23607,4003,7871,6677,23387,-21079,-9841,-16321,-409,795,-31613,1371,10369,13355,-11399,7947,-15111,20923,32539,-5439,-19923,17615,15651,-22763,-1171,-23161,-23725,19669,16233,-11383,25713,1185,-28353,6007,-31835,-31999,-1689,-15753,-15761,-8457,-24981,16653,-9867,20981,32627,13667,2791,-19253,-6673,25909,-29489,8737,-28055,-13223,24527,-817,22669,-19749,4271,-3791,-32393,9239,28893,-16075,6443,9339,-25453,14603,-24795,811,-15359,32517,-7745,-19769,-11437,29181,-13937,-29695,2463,21701,6823,-23233,6703,-12679,3197,-6121,7479,-16727,-16721,-22511,-20839,-28101,5013,13343,-31615,32399,-3045,-9455,9071,13459,19015,25735,-8343,16469,15165,10913,-32611,30081,9399,987,3767,-18001,23083,-30251,-27471,-22993,-4383,-20445,26151,-23975,-10437,-11691,23679,-31835,1415,27541,-1551,-13435,21147,19645,5573,-3503,25083,23281,25621,-26719,-32675,-11813,23623,4943,26419,30997,25761,24847,-4693,13423,2385,31435,-16997,-26803,-10505,-15343,-13435,2447,19691,-2661,6821,10255,-7579,6371,-32383,-21289,-1175,32191,-23915,-27809,-3979,8415,-1285,9875,-31375,20863,22599,-14121,11215,10639,7919,-19399,-20501,11049,27531,23037,3029,-21197,-26575,13583,4687,-19629,-16835,17,6091,-18011,-31775,-19949,25211,-26189,13845,21371,-27227,9023,-9455,-10305,-19153,-31385,-26821,-4819,-1755,-7483,-22445,-20697,-15637,28503,30443,12235,-26803,-28071,30479,-29025,-12341,32101,25447,-14487,23663,19867,-4533,11547,9501,-26999,23715,-31415,-12167,26327,30003,-25497,-17221,13705,-21877,20045,26485,7141,21283,15163,21339,19215,-20345,1399,20085,-15155,-1999,3529,-9387,-28315,-7541,-18245,-14061,-15461,25907,-21381,-32447,14549,2373,5933,14565,-297,-25517,-23391,3411,-19949,-20519,26601,-7317,17455,17061,24303,19359,32001,1393,-3375,-693,7341,24655,-16411,-8867,-4041,-32095,-21653,-31049,2119,9303,-29303,28983,-23553,10583,-17245,16035,15989,-31965,-1757,21523,26523,-18511,15751,14385,-1813,-24767,10943,26367,-19507,10199,30031,20113,8389,12309,-27289,24437,-22393,-4579,-27919,-11835,-18185,993,12893,-29515,4153,-14453,-1651,20901,11197,22675,-6713,-3649,-9525,-16811,10209,9291,24793,22787,-31389,27017,-16019,29979,6609,-15497,8103,4283,3869,5735,-17131,9777,-1911,-20377,-6807,-7901,27061,-16977,-24101,-4399,-26207,26063,4051,-27789,2835,-24347,-16589,19193,13623,-15029,-30253,5799,99,4529,25177,-25529,-28271,26545,31381,-9023,-13879,3695,32409,28789,-2147,13869,29471,5947,-21183,-9543,-32071,-26163,-14333,-16533,-9753,-30153,-28389,10995,25745,7965,-27367,24635,-25379,-6165,-24279,2459,23629,29183,16477,-25809,-21129,-11449,-21723,-19251,-13043,-12755,-23175,17081,26463,-25153,10415,-16509,-6323,17233,-28585,-19769,-20825,11287,29775,-13709,-8889,10425,9213,-16889,19579,-535,-27703,4429,-25079,2657,22509,-25343,-1497,-20531,12233,-4993,6995,-8717,6029,-4099,28715,-7745,15773,1427,-21727,-15583,29483,11809,22947,-12391,7133,33,9113,-22477,24709,31153,-31313,-239,-31121,-31267,-2777,26855,19251,-13341,32519,-16445,26257,29571,30565,-18027,27151,3375,21653,-4007,-2277,-2131,21935,20893,-10343,12969,-11589,-12575,-20151,-1947,23563,-19837,31971,1269,10641,-19223,-10905,-15207,-2255,11723,21133,-31199,27267,-23091,-19051,-17299,6133,-11591,-9107,-5887,-6329,-17619,-4219,-27535,605,-19241,703,-10343,2035,-11001,-28215,-23091,-1895,-12675,-10011,8433,30007,20571,-26679,28493,5223,-531,-30329,-19435,-24083,20567,24655,-10923,12289,10465,-25687,-16629,11177,23767,20679,22615,-18249,-17739,26033,15407,8631,15075,-14771,-26183,-20229,-28261,-9003,-5061,49,28405,23733,20089,873,-23939,28481,15423,22615,-22899,-3627,-28299,12825,-105,-19127,11405,-22595,-11043,-14839,17419,-9495,-12649,-4357,-28047,-969,2013,-11301,-24805,7205,-27375,-287,6845,24251,10115,-12567,-15041,28631,24447,28519,-1029,-22677,-4497,26135,9371,9441,14331,-6525,6589,-17667,-2535,-12041,-5825,-21381,26189,2539,9477,16137,-32577,-367,-9139,-5725,-31757,4991,-27265,16757,26505,17789,13195,-6341,22031,-3427,5291,-5217,-12905,1247,-23569,24819,-5241,-16627,-27361,30115,21945,1235,21415,-707,29457,15917,-9167,-883,16773,-31263,3893,11015,-22583,6773,-4251,-25927,19311,22753,8855,-9429,29705,-2035,-13049,-2229,15779,-24181,4841,4047,-18737,11879,5319,-1063,15421,-7237,-7325,13349,13973,5043,8901,-25075,-7223,16107,-10775,12167,12721,659,-23525,23555,-2531,-16465,-1253,17685,17667,-26787,2417,24709,-10513,-15421,-10117,17541,24841,28987,-21097,-3787,-30541,23909,26329,-2559,16683,20587,-25193,-29981,-22331,-27969,-28207,-30431,6213,-677,-4203,-23927,27545,-1261,31867,30497,-5481,-2291,25393,8901,-30679,-1901,869,-30045,15489,18609,6203,-18163,-17989,24653,24383,-8099,-12817,-25961,-27763,-26741,-16961,-16737,21765,-22215,-22879,4845,30241,-26883,27203,23855,-17015,-589,-27265,29393,-2005,23867,-32373,10281,-25251,-4005,-26743,4367,-6733,-1559,-1173,2687,-23687,-11329,18117,-6831,-827,-10039,3417,11381,-14285,17789,6135,10095,-21409,11141,457,-17809,12247,-15247,29231,25973,-24219,30179,-31881,-30153,25035,10877,18635,1047,22913,6071,-16501,-8299,26443,8793,-17957,30573,-21841,16707,18873,959,-11919,-4653,13579,30121,-29487,32543,-6661,14369,-24893,24829,22055,17991,-28115,31773,18119,25553,9947,737,-15543,-28555,-23193,-24807,-4393,16371,16257,7057,28657,3225,2319,18449,12225,6375,-20563,-3849,-8811,12243,-31175,-28689,7485,9651,6929,-22027,-30305,-22495,-8099,-7793,9701,31855,-30889,-17757,-21705,11873,-11809,2521,21335,16241,-13593,-29383,2123,29525,-4319,10703,-9179,-5957,9879,13015,-14261,15065,32425,-23411,-9113,-14069,-15311,7327,-6287,9267,20913,17429,-9297,-23229,15027,24873,-1913,-1031,8459,5671,14197,-9529,2869,18541,-15785,-20933,23485,-5709,31617,13977,21029,-16261,-30979,-16925,17727,13673,29947,-3133,24955,-17701,11773,-29,24959,-8381,30285,-11907,4873,-27093,30183,-16723,-953,-32733,14109,-2915,13623,-17171,-10357,27121,19831,-23931,23181,721,-26675,-24551,26033,13575,9645,29635,1159,1515,22945,31347,18283,-13321,22481,11829,31945,17523,31927,-25145,-12071,14327,-10521,-19237,7689,-7157,23383,-27207,16943,-11813,-4019,15791,21045,-6547,-32693,15117,-26217,-11305,25853,665,3059,13361,29837,-25841,-23557,28475,-18489,5815,4445,-6905,-17679,-30001,24681,-26765,23331,16091,30355,-27855,-6427,-28515,-1953,-14815,26509,23643,27519,-27157,881,-20419,8785,-8365,17535,-28273,-12727,32693,26685,32043,-30391,-28135,12189,-25099,-12679,5241,-3069,29209,451,18975,-661,7063,11025,25779,1317,25549,-9881,-31491,-26801,8491,-30739,9785,4081,26257,-29439,32475,17629,-961,20839,17845,19615,29201,-4031,-20075,5355,19595,16131,-29763,-13981,-3323,20925,17877,23657,-22657,1539,14713,-6515,3627,10791,-1789,-7843,-31603,-24919,-9225,1199,6957,-8149,-13451,3185,-21485,28843,-20421,-17325,-21091,-21795,4345,14681,-3697,-32313,-31273,-26599,10447,16103,-20463,-9591,7703,25015,-133,-12767,26081,29449,24247,13745,-9509,-909,-22333,2053,10237,-4303,5043,16493,-23611,23577,12127,-9423,14387,-29587,-28469,-27103,-20729,-28891,9823,-4593,409,-25643,13993,25561,21339,10357,10713,30999,-8037,26955,-15511,-23567,-30015,-13219,-21409,1587,-1041,-11567,24217,29149,7355,9391,6305,-7493,-5003,28191,-17519,-25857,22559,15699,10081,17315,23709,24473,26211,2649,-6721,12293,23367,-29463,-18835,5019,-5011,-31131,-11061,-11545,-9871,3089,-11513,-2749,-4625,-9641,28497,13905,-14881,9079,19323,7687,9569,-11385,-5533,-17299,5971,8233,21897,-31583,1063,21041,1473,24885,-21479,26787,28871,12267,-25227,-8337,-24763,-17517,14203,24001,19953,-3953,7525,-25757,-7387,31877,-10173,-2919,25187,26943,-15681,2387,-12811,14191,-661,7433,17699,-19921,-24631,-27487,10269,-30621,26883,17097,20571,27609,-26193,12359,-29725,9719,15875,14833,-7617,31575,-24493,18871,31139,-31209,-13939,5091,14131,2389,-28175,-18559,18357,28491,28189,26723,22303,26981,14021,29689,3239,32291,1323,8315,237,22459,-20017,10097,28019,30581,-20193,-10391,-2257,-8905,8893,-26929,27857,-12131,-25641,-19945,-31953,-7847,25043,14655,1035,-2173,-31819,30133,-31007,27555,26545,-24147,-15075,24983,-3637,12127,-21223,-21851,-11425,31765,9505,-22821,7181,9937,-71,-22453,-25597,-2477,-19109,-9443,3885,19119,-207,-16397,26253,-13745,-19293,-26957,2275,17039,-28163,-7873,-12889,22815,-18639,27383,-28095,-20871,6863,-12277,-5105,25647,14721,6249,30169,5005,9601,-9027,-20951,28545,16353,30667,-6269,8535,-15283,21137,-13223,-13543,-27981,32749,32499,-20631,-15161,-22883,-731,26531,-20323,-8679,-9805,9435,32125,25249,26105,30987,-18439,1513,-2197,23883,-16351,20225,-28815,-27379,20533,-23587,-19787,2349,10517,-5987,5717,-3471,24545,29989,-3745,13897,-10491,9595,23509,-2895,6365,-1791,-29229,-22605,25495,4327,-20315,-3539,13713,32359,-16575,-9977,11173,4229,9347,5917,27797,-24401,-23789,-3629,-10413,21967,17299,7265,6401,22727,25339,15819,-24269,-7531,30407,9999,-7119,15475,29151,-20997,-10243,-3379,17583,23051,-22449,12129,14695,16899,-8757,-16157,-10833,23827,-23327,3129,8273,13165,17031,-20267,13867,-3879,-1469,12863,-26985,-9583,-89,-16243,16277,18461,4523,-17843,-23751,-19519,6857,19205,9865,-13423,22221,26885,-20455,-16217,-17271,-23971,-6321,-31345,-12551,-16811,18327,-9253,-26989,-3625,6247,-22259,18589,11171,-23215,13977,28019,22861,-5465,14793,-11637,12087,-27459,-31419,-10995,-18043,-29755,-25829,-14641,1365,2445,-28013,32647,32601,-22997,-21571,31739,-10547,-13829,-3665,-15055,-18129,9141,1407,-30025,30163,13501,16113,19815,30917,-18273,25111,-16673,-12169,-8181,-9271,-257,-21387,-19993,-30797,15609,-16795,26567,3677,-1403,2027,-25777,-16573,15037,8969,11827,3337,-25185,-10177,-3503,12477,-29423,-7933,22807,-20905,30135,9497,-25081,21979,-31083,4097,-20777,19207,-31059,7195,2493,-6407,25735,-24033,-1035,15871,14705,1411,-24795,-9147,-11277,-22069,-17637,32089,-31855,1771,-3277,21485,2641,16697,7591,-24751,-9819,-13407,25549,-8509,-23191,22705,-4195,-16461,19859,47,-18251,1785,-21729,-6287,30341,-12305,-11675,27269,29689,-25861,19771,31811,15445,-9431,2385,31267,-17839,-32239,-9101,-29425,12801,-22691,20429,-11177,30113,-16297,2307,24349,13157,12661,-15065,1663,7719,13025,5365,-25525,26587,-29141,17597,-24787,2565,-18873,22259,8555,-11041,1905,29387,22705,-6605,-22755,-18767,-12861,16269,9045,-25835,-5323,29435,-20295,-16673,-21063,-16589,9897,5601,27801,-32457,-20819,24003,25259,-2543,23795,17031,28173,3743,-25203,11055,4211,-21067,-9391,28679,-12913,-4315,10317,-5155,-22757,22881,-11411,12923,-7597,-28181,-29389,31933,-26035,-29269,10553,18881,-7095,24077,21749,-20351,31777,-26401,-8813,-30965,25323,6755,3351,15525,21429,31737,-4113,-20339,-29963,-31747,-2977,30961,4609,-2587,8873,-29909,19759,-3027,21949,-1515,-67,25709,17745,-12243,-8317,-15397,-15413,-8173,-16285,2679,-4395,26367,-3817,-6779,27855,27161,31313,9787,-21075,-10187,21977,12177,-6387,-15319,-3117,-27787,-26989,5147,-31257,17495,-22311,1507,4379,-18135,-20115,-217,6541,32425,23711,-31271,-13195,-15205,15415,3297,12625,26013,-10111,29391,-30313,-22143,-7033,-13273,-22407,23751,9995,-10219,-9875,22321,7795,-4457,-11133,-15873,-21277,13919,-27411,-1559,-2689,5489,20553,-26299,-7621,28407,-8095,29087,24423,18795,-15309,23411,-4647,-4961,-27049,-10057,27409,-2313,27971,7527,-3931,-25597,1737,10471,26085,26965,28955,-30959,11421,-26515,-30739,17893,-21317,-31403,-12493,-29781,901,-15681,11087,-3377,-13499,-25333,-5811,16763,-21837,-30967,-12701,27367,32437,-16337,6231,-17953,15569,24575,14709,8063,-23293,1329,-24677,-5077,-19423,-20311,-1917,15799,28327,-28785,16957,-12419,-6659,-1755,29129,24457,-9459,-3991,14625,-27853,25417,5799,-17915,4415,16937,28957,12119,-6451,8571,6349,-9139,-10629,-16313,-1437,-1875,-4235,-18565,28235,-6755,30867,-12929,-6497,27617,15057,14715,-11869,-23125,-9941,20315,-31073,28639,30057,27145,14691,32309,-3839,-2849,-8219,5703,13151,30899,2305,-5129,-26701,-13125,-20421,23557,20603,32611,3127,-15285,-21607,20147,-7197,13917,9527,14311,-3943,-32485,26807,-16501,-2741,657,25207,-27779,-26355,-16621,8157,-11547,15013,1293,21265,-23471,30279,15897,-5649,-13825,8931,3479,-10637,-14895,-819,-12213,-12209,22753,9613,385,-17909,-4159,10833,9815,-21061,-23899,-18655,-21727,-15523,-10497,-27129,801,9483,-17887,-32457,-28427,8827,-17295,22617,19261,14371,-28175,-14555,-4421,-4307,12743,-22539,20759,-26545,-16183,23689,21461,-17927,4259,-12361,-10555,-25507,299,31131,-31989,1691,25921,20937,14849,-11349,12619,-5133,6827,-26157,29243,-28139,19989,-4303,22139,-21677,31215,5633,25073,13357,20361,30621,-8297,-15071,-27855,-16669,-7419,18841,-691,-27817,-2307,-917,22025,9405,-12715,-1241,-23145,-18313,12983,15099,-5523,14755,-15475,7151,-13235,26775,29669,-30673,12689,-10059,13433,-28837,11913,-6635,2149,-1863,3979,6309,-28117,1971,669,28275,24155,-32415,-19569,-3751,-9569,-16697,-17507,6199,-31395,13389,-29121,-29229,-16629,-12827,-8647,-2355,-20687,5489,-28601,-31389,-22879,22459,-8931,22503,-10709,12403,29863,-23313,-10817,-31129,8357,-1571,-11635,-15,-4935,-1847,5613,22933,18091,-24909,-29813,-15609,31051,3407,16841,-12759,19817,12913,-26799,-10513,-15033,27507,17097,-27707,-16573,28191,-29163,28479,-26725,-2341,17827,29671,23259,-13981,849,-23443,-24033,26023,-14333,-20029,1739,-11613,32125,-15679,-30859,24337,5425,-4389,-8089,12371,16297,-31733,-23075,-3677,-16021,-19027,12539,-19831,-4053,18801,25207,10657,-4565,6211,-12883,-26241,-17075,30439,12193,-19951,-6713,19255,4535,-28445,-29269,30215,-22435,17443,17139,28255,17753,-6997,12923,913,2947,-29159,26887,18135,-31183,-18001,753,-14567,-13637,26105,-10099,-9049,14261,-6489,20519,6357,-11051,-20733,18567,16663,27335,15577,32241,9427,20829,-10745,19389,21735,7527,11707,-4359,-5141,31785,26579,2565,-17165,-16049,-28633,-31955,-16889,15689,9579,-29143,-16535,2953,1059,30343,-16677,-10839,6973,-3939,-24169,26451,-26021,-30667,-24131,6483,31677,-22965,-2847,-24911,-6263,31003,-7277,21503,-30851,30353,24329,24111,27863,-20761,28905,-29243,-4551,-25693,-30273,-15633,18341,18621,22103,30095,8035,19585,32365,3047,21613,-10921,-22071,-29319,21097,22011,-6925,-27665,-8159,30017,4867,6705,12289,28827,-30847,-22203,25337,-6749,-10783,32459,26183,-9087,30685,14809,-18455,-2723,27629,31033,28083,2985,29491,-11817,-7469,907,9075,5333,-19045,-28623,-2757,31881,-655,757,-8733,9411,8083,-29287,-7193,11103,7357,-22309,-31943,27075,-25283,-29355,16463,6011,24295,-16765,-5931,-31931,-17009,21389,5737,-9763,-20349,15813,12989,6389,14951,13685,-24077,-18015,-13347,-25727,-12197,-7929,13391,1287,-14957,-12597,-8039,-1723,-2659,-18061,-27623,-22873,-13803,-28077,-3779,-23313,-3215,20291,30487,-29691,2047,-24131,17499,-14187,19417,19839,-4761,-4667,-3643,14693,-4219,-13241,-19379,-5537,-21457,-31,-939,-8421,11231,18343,-477,15891,-3757,30863,-5671,11977,18211,1691,-25379,1261,19443,13277,-25267,-5575,-14387,-12307,-23679,2441,1419,-12037,-3273,12031,16419,25239,30317,-9223,-24335,-25773,-14475,30139,2141,5251,26389,-21705,25101,28993,-25497,-11157,24929,12315,-4825,20393,-8949,-30587,29419,-23133,10965,-10839,5315,-12467,-31797,3041,-19711,-9441,-27289,535,-171,-18211,31315,-8771,14707,-17299,6615,22091,24537,-27351,11263,21875,7241,2215,-8615,25101,7809,-27909,20153,19355,-15077,2369,11819,2305,-8223,-6977,31273,12679,-23463,7513,-24221,-14547,-7061,-17475,16771,-17575,10975,-30325,-24191,-17769,-13833,-2739,14297,-24109,-6575,26089,-20247,22547,-1615,-23839,-6053,31591,-7889,22311,-15337,23531,-26133,-31921,17757,-28117,-18877,-22491,-9625,-30541,11863,6897,-12167,26055,-16855,9183,-22763,-10321,-25047,24393,-25831,5367,-4093,-1621,2289,-7761,24007,-20533,-28483,3903,-7245,-10253,28205,19683,-6855,-28573,-22667,19373,8065,-4433,-4729,-16885,26553,-24871,16861,-6855,29781,-31477,5761,26027,-13805,10229,16963,22003,-32197,23645,1101,12025,32619,11933,6203,-27803,5123,-32285,-21831,-5381,-12475,16983,18179,11673,25173,-21459,22489,11433,-15443,6693,10303,21211,-19359,-5465,15727,5875,-24213,-8809,-24629,7797,19585,26271,16125,-1115,-25485,-9459,6455,25221,-16765,11385,32215,31937,17833,24575,23007,645,4709,-25987,13043,1657,-16751,-20669,-3361,-15201,22633,10447,-14079,5475,-16563,-4375,-24373,-6111,24291,16119,-6961,32579,17235,-15751,11037,12727,-1673,-7279,-12679,4049,25615,11439,-28663,-21545,22787,-11591,10847,25415,-17793,-31815,16055,12253,18351,-4051,2449,4541,11757,-17949,18103,-21257,-6815,-13591,-5635,-24469,15975,-12375,-7555,21439,14153,-24659,-22275,-8681,-31025,2035,-11063,-22715,14379,31091,22395,23145,28591,20659,7801,32443,2033,15093,29169,23199,15373,-30225,6865,29145,28837,6527,-23337,-32209,31463,-27017,-1541,-29019,14243,-26387,25781,-29281,5655,-6177,31011,2057,-30503,-1641,1277,22083,475,-13449,-30033,31035,-8871,-9353,-13043,-23617,-12611,19367,-22763,9101,-11645,25569,14921,29123,-19465,-32253,-2431,10299,16489,-31009,22541,-7453,6599,25049,-23133,3695,27393,8603,-6371,4717,-31529,-7285,-24415,15487,-21557,15659,-31819,24577,-10415,30095,-15369,15045,14615,-10421,10535,-17979,1139,-2911,1765,19597,-20019,-25637,-4799,-4415,-24911,-7701,-23519,11247,17901,-22943,-32661,30025,-11059,-21099,-12823,6633,7225,-6309,-21773,-24141,31593,24705,-19763,15715,2203,32239,-26989,219,6721,-21111,21301,-13521,-2371,-9193,12939,23245,24547,-2797,24087,6597,-17463,17627,30465,-22251,16485,-20341,-11403,32485,5607,-30051,3285,23885,-32295,2599,17095,11157,-5657,-19069,13551,4653,-4359,-20233,-943,-18417,16975,4071,-7797,18039,-5367,29197,-6493,-26375,-17789,-26713,-15681,-6059,2283,11463,20675,6611,7017,6973,7639,-2279,28715,11209,14395,27291,5511,11501,5677,-18743,-13385,13737,-20655,20957,11211,-1219,-697,9837,-26683,21091,759,-23051,7373,-25953,-1355,28067,-14621,-10059,3515,901,2731,-1235,-5719,-2767,23525,-7259,1073,-8287,15109,31265,-545,-1017,-5653,8527,-10593,-7511,-24613,-28425,-26563,5267,-31829,-19431,27333,-27361,-29953,8721,-32455,10567,-20337,-6715,-26387,-31363,16273,18227,-32465,31435,-15349,5923,-10223,-3271,2841,21905,26725,30989,271,25563,-20117,30315,-28405,-18299,-19605,-7325,24045,19807,30823,-11423,-3583,4237,20593,-7839,15263,18333,-28679,-29487,20367,-4707,-23743,22851,27467,-12611,22363,-2301,-24277,-13255,18585,11029,15203,-3161,18227,-32499,12635,10659,12807,18327,10201,5213,-28457,-25419,-27053,-10255,-21833,22427,18647,13007,22915,27421,26427,13875,5975,11057,-28901,-10497,29303,375,-20717,28777,5431,23227,24577,-2585,-5917,6759,23491,3011,8441,31785,20383,12727,-14325,-18339,17539,-19373,32135,15235,-4923,26201,27923,963,-14041,-8749,-1151,-27133,19201,-3047,23171,1065,-13771,291,25093,23363,-24019,-8069,7381,-4409,3159,-13637,8103,-17169,23561,9129,15609,-24463,-14161,63,-19629,-24381,-3417,25103,-31255,-1553,-27067,20405,-11697,5363,3861,-7505,225,-31161,16543,15309,6655,20455,-21073,-29779,-28201,1399,-28127,21363,-14179,-32543,-30313,-19957,-15087,-19755,22429,5369,-13469,28985,-30901,-9145,-22973,12115,-24801,-393,5951,11325,14637,-15913,-14153,-2091,21555,-15801,18517,-11149,16887,32731,12909,27857,5035,11697,-12727,-30649,-26233,-3533,-12653,-25043,1151,-20597,17977,25743,-11101,-30565,-495,-10785,-16311,-26029,7003,-7481,-5103,7099,-30609,-9533,-9333,27245,14189,-21849,10215,30053,26241,31245,10329,-19885,-3119,-237,10659,30117,-12349,-26811,-1301,-471,-19423,25561,13537,-26225,10625,-8967,1339,17107,17153,-13965,8057,3541,-641,14459,-10999,1067,17795,15371,-26131,4035,-17853,18485,24867,19923,-859,-26423,-525,11783,30133,-12405,28021,-2247,21657,-15045,16375,19647,18821,28577,-5727,-11173,15461,5841,-25113,14189,-6073,16923,-7975,31357,26017,22425,-13831,-11069,10081,20717,-1083,3877,5567,27411,30977,18451,-3597,183,30489,15031,-17579,9769,11965,32001,-7835,29631,-6941,-30311,23647,29809,31785,31667,18915,-25579,-3909,13919,16017,-28441,-25297,-12817,-31921,15649,14005,-20623,-31321,16077,3253,-5129,21561,17347,-21027,20727,24749,3081,-11779,-169,23843,-31183,29997,-8779,25385,167,-24951,-9811,29723,-31995,28583,6401,-29853,-32437,-12491,19491,29781,32585,20407,19573,-29741,3185,26743,14653,-12503,27625,-27603,-15367,-17437,-22963,-12875,2223,-14469,-2207,-28987,-16505,-10569,15691,-8769,-23775,11175,31537,243,3361,-19065,23067,22141,-7717,-21507,9935,-5119,4095,-3813,-4743,13975,-9201,3027,-6213,23699,-32615,-1759,-20031,22587,21621,-8827,-3231,7733,7493,14843,31903,-11887,13161,-8965,21335,8531,-14443,-12869,-31395,-2689,-1473,5423,-31243,5513,-18579,10641,-2995,-11747,-8129,7497,30607,26875,4105,24547,17381,21443,8209,-3471,26059,-15913,32095,9649,-28259,-31855,15363,-2329,24909,12197,-22797,-1823,26131,8055,-32193,-24839,28981,14341,-26863,10883,-26929,27365,-12997,-17115,20239,7955,7691,20537,-8439,16371,-30733,7831,-9247,30279,19685,12373,11713,-12527,417,-24095,9841,-18049,-17149,-27129,8293,-31641,-9567,471,-19841,30901,-5451,-31323,-14647,18247,25225,-7023,-10265,-4647,7113,-865,-13381,2775,20019,-17953,-29811,27227,16173,-19839,-13193,30109,22001,17649,949,20763,29615,-16629,-8031,9239,9217,28769,3653,32035,-30845,4757,-12975,3039,15617,-4069,13639,-12541,-21565,7919,-14079,8431,4103,-137,-16639,20307,-21603,30027,-29565,-23531,-15235,-22995,-25965,-19041,18527,6241,-30923,15597,-15013,-28455,-6021,31317,-26711,17923,8643,-30149,30991,-20177,5753,27739,-23343,-4077,7149,7261,-12301,15607,-29715,-10685,-26053,8069,5993,-12727,-23187,-3383,-1237,21741,16389,-139,-217,2655,28725,-8293,-2961,27721,3759,-23787,16761,8249,27837,-6557,17851,-11787,-25853,-22709,-21627,22659,667,-9053,11789,20029,-25989,-21233,14639,-7529,-23747,-27427,-32331,20093,-3177,-17887,-24731,-5249,-11949,25101,27395,31201,-9675,20269,1289,13869,-24505,10699,31921,5011,-7369,-24439,-7559,18695,7627,-5925,26385,-19903,23981,11107,18801,-23589,19199,24697,-31601,17071,-689,11903,16455,4073,13257,-23699,353,7611,-4555,28457,-12061,-24165,-31485,11897,1843,11675,-14351,14213,-26197,15725,29915,-2597,-7615,-5819,12053,4113,26039,-17517,-29809,5665,-15033,18033,-24483,-13677,1345,-20543,10477,31029,18483,-20947,-28865,-14031,14097,1687,28279,9989,-30079,-26421,-26995,-24649,25137,28793,7303,-14865,28613,-11617,11883,16351,22243,17343,-29017,-1329,5761,11445,2521,-30069,24703,15099,18353,-10791,14027,7037,15991,-10845,-28325,26213,10387,-30173,-15683,30785,-3769,24167,-7487,-23961,-16441,31301,6761,-12871,-22789,29379,-27051,3011,10145,-27191,12289,18913,10939,21071,-26417,-28059,-13611,14219,19811,27551,-18091,-6697,28753,3947,13883,10947,25113,4605,-22317,10615,-2671,-10163,12811,22337,15259,-9859,31359,-717,2905,-27787,16707,30315,23567,-9067,32513,11715,75,1399,-25513,-23425,22831,-14123,-31503,-32013,-32167,12657,2407,18149,7933,25437,8381,2617,5895,-30339,-13185,14677,-1509,-13051,-17571,-29429,13697,30963,25911,-791,-4217,13165,12477,-15287,12579,-27113,-30323,3779,-7925,14021,-31073,-25301,8745,25147,-4737,-15599,-3163,32383,-2015,-3875,-12911,19853,31529,-29141,10765,26667,-24861,2201,22759,24589,9843,-8377,-30081,19817,17565,-32291,27803,17607,5623,115,14733,24329,-2013,18669,27191,11749,-721,-12681,19419,13497,28863,-11283,-10563,-11433,-27695,8061,8097,10165,-18983,13585,-13741,-5231,4555,11815,-24075,16423,24573,-19375,2779,26481,22483,-23447,28031,29343,6099,-20531,6163,-28265,-14117,7773,25561,13917,-12697,-29197,-12739,-17339,4711,1815,30665,8059,-13625,26099,4543,-5533,-28503,-14439,-20775,-27481,-16349,4703,-21071,-6449,-11205,15771,12409,20271,-27515,27647,3725,-9759,9539,3771,2279,13279,24645,16495,77,28343,-12003,-25391,4875,11699,21049,-3057,-773,22971,12671,11473,9223,21077,22225,-26641,23587,-19739,14111,-27409,30609,593,-22965,-9837,-15741,255,4705,17793,-5609,20389,-30337,-28753,-32521,19127,2495,25125,22013,16283,-13479,-14945,-10803,21269,14709,227,-16569,24311,29453,15671,477,-9939,-5381,-26739,21285,-23003,-27747,-22281,-23819,5205,-24539,13801,14901,22803,-8271,25511,-32715,-31105,-22479,-23769,-13977,14309,19869,28271,-4029,25859,31095,-29093,32327,-23143,-29331,14291,-15435,24877,-31323,-18557,28463,-22941,9453,1699,-27245,28861,21115,-10485,-3689,31825,-19947,17387,-10637,-22589,17235,-2897,-15175,11455,-22013,6647,23701,6159,6449,-19589,-10749,21,-2567,31237,-25445,15945,4897,-9149,11595,22939,31467,-1855,-4253,125,-14495,23639,10831,32749,27067,-28279,10007,5719,29559,26743,28859,743,27665,-12353,-11817,16155,-23307,20945,-32343,-2075,-11577,-10947,-305,25065,-2207,-1807,30257,25373,-3635,21833,10507,16573,15601,-23761,10919,1191,19869,-31759,-219,-11945,5483,-12297,1321,-21573,10823,30473,-20137,17983,29935,8507,-28445,-28797,31183,-12151,14699,26699,-8283,-29363,29409,9823,-4495,-8723,27401,-6659,5443,-19077,3243,30731,-9171,-30519,-6999,-4391,-20131,4987,-6387,-13983,-8423,28775,18943,177,22913,-5749,30137,-3361,-12373,-31903,-12351,21191,15029,-8569,19019,13715,-8661,21795,32303,28589,-25617,-9239,32351,26579,15779,27169,-22321,20171,-22153,-28255,13289,3867,-26915,20057,-11431,14467,-13613,25705,7423,15911,5919,-3153,-2777,-26693,-12733,17721,20657,25449,-26149,-19941,-11837,10795,29393,-2553,875,18031,-14601,9965,20279,25907,-18481,5767,-22355,-14065,-11553,-97,-4019,15261,-19289,-8453,-24061,-3431,-9633,21265,31783,-22573,24791,-12239,-4129,-7837,-217,20681,-26411,8763,8585,-26667,-12067,7481,20575,23373,4979,-9995,13081,-15785,-18907,-21655,2797,15281,-27633,-14959,31719,-20631,-25955,28709,18011,7393,-25991,-8423,-13341,28573,-19835,-14857,-26403,23283,3469,29689,-8757,-11543,26981,19679,-27661,-7383,21035,-32219,-20669,-13,-27637,-20151,-20571,14579,-21753,-6451,15791,-16101,-31675,16757,-31753,17467,14317,20577,11285,6733,29863,19351,19783,-28019,55,-11837,-365,12205,-705,-13993,17041,14765,30225,13971,-6191,-13069,5425,10397,-1347,-30499,-21407,-22119,1461,12657,-16617,9551,29677,-21051,12631,12245,4195,26745,-22463,-22257,-17405,5857,-17413,10985,10261,19869,29575,28777,-6625,-11679,25109,20087,18437,-6201,-21703,-20413,-24551,26075,-9063,23017,-26025,11261,-15805,10535,30565,19791,-32317,26653,16595,-13393,4437,-11955,-31325,11725,-10345,-6807,7909,-4345,-31497,4189,-3263,-13235,-32705,25417,13657,1119,-19887,15539,-2051,-9265,-21487,1123,-26403,19031,31007,-17739,12985,-22891,1383,16605,7245,-10431,-14275,-7037,13335,30547,-3873,28971,-3813,-18159,-10327,157,3407,24779,31725,3301,17465,-19867,29619,-10939,-30795,3413,-7571,-11451,-5377,-27873,30969,-2329,-25921,-1319,-26875,6261,15539,1697,8963,-23867,-10991,3937,29105,18035,-8345,32521,25321,-22657,9713,-12759,32363,31443,-3825,-2413,-18057,-3769,-4905,-4633,-22419,5485,-24097,-10511,11377,-28605,-7199,25545,-151,5019,-1549,-30371,-5063,11197,-28771,15767,27689,-1719,-9209,-2317,29973,-13625,-24905,-30483,14047,8081,4949,-13321,23241,-789,-30215,-30917,-31755,-6891,32039,-25083,-8031,-875,5499,9597,1081,-14015,28521,20035,-5837,-23463,10467,-6983,-13247,22351,-8235,-12849,-28333,25667,16165,-22421,-29469,4519,-11423,16371,26919,25143,13441,623,-21761,-14017,6749,-22403,14457,26379,-18137,19329,-13045,13939,27603,1651,18871,-20573,-26299,6969,10313,-11439,13467,30769,-13119,-161,22477,12757,13003,-20489,10791,3831,26407,12877,-2193,29843,-26737,-21751,-29223,13373,22809,30893,-18079,15573,-25467,-28559,-22817,12609,-26971,-13389,2031,-16279,-4177,-16091,-6601,-11095,30547,-2569,-20997,-4265,10021,-25955,24751,-26715,24467,-27769,6883,-16693,-30549,-4265,-20917,24647,1327,18025,25319,11607,27577,19949,3535,12721,14353,-19663,1413,-5249,-23987,12527,23665,-2783,-12759,22097,-7699,16825,-30183,-5179,-20097,24523,8577,14393,9181,14531,15751,15281,-23769,-5965,-1957,-25301,333,19367,-15989,23491,6671,-14257,31757,15621,1391,17967,28215,-23183,10717,30071,-6337,31465,11045,8695,-31657,-17935,12353,-5459,-23589,18297,8743,10723,-3043,25211,16473,-29709,-25035,-51,29377,-12535,-1169,6121,-22513,-11115,27415,-23661,-23059,-1089,-21659,-10441,-8491,11751,-30631,-6875,-24929,13731,21079,-9367,24227,3493,-13857,10013,-23341,-17127,15689,29347,1419,-14627,27599,-8815,9835,-10155,18403,12443,269,-13023,-18965,485,-3855,2831,-16751,-27483,22129,-13387,-18369,-12197,-20091,3195,22979,-13029,19547,-19783,26523,2647,-28263,13491,-21875,-8589,-7189,8773,-5995,11157,22561,-5365,-25453,83,-13967,-11423,24929,-9457,9651,-8831,10835,-28569,-24153,-26013,23597,-19517,24095,9605,18993,-28345,7415,26839,-12427,-18559,13721,-17841,1629,-27095,-18167,-21133,4701,-29321,16239,-21427,20441,10559,-28195,-5599,-28719,16609,16421,-6675,-15425,-13883,9489,32709,-29243,15367,-25239,-2653,-31325,15071,8273,14475,-12269,15723,14947,1969,-29983,13571,24385,-17111,26227,4323,18319,4869,17201,7101,-6371,-12829,-16861,25321,-21949,-12983,19415,-7231,15163,21251,-4471,15509,3329,-17297,-29773,-1841,-23143,24667,-21617,-20343,27579,-31369,-7417,20107,-24593,26835,-5681,-9467,-17869,16359,15997,31757,30727,13349,7713,3465,15707,11039,4191,-32387,-13293,-21077,27483,-7383,9743,28893,-31311,-6563,-23461,-8643,-6239,-22413,-26273,-15199,-21251,-15463,10003,5345,29533,-9347,-31295,-11597,-32123,28651,-21825,-24873,-12901,9971,-3643,28079,13331,-9669,-4497,-21419,-17935,-5829,2205,12255,-26825,4431,18313,17627,20273,-8317,-25021,-9645,13647,-28985,17169,-11753,-16301,5369,-4103,-18551,9731,12309,-27687,2391,-13279,6575,5313,30747,7983,-9281,-19389,23497,-19741,-21395,31703,27645,-27675,15679,-16821,-2941,-29015,-17025,23049,-10971,10125,30677,13315,30255,13557,-19103,29709,15547,-6943,4933,-8479,10495,4383,-14225,-14547,13219,-8583,-23203,14199,20761,26375,-11663,-18439,-9955,-22937,17945,-8199,6581,27127,-25063,14377,-7001,1981,-29759,32177,-20151,1329,32203,-16481,-7455,-12863,-22629,11837,-16873,28449,-9889,-25777,-10823,-6579,14951,7019,-6263,24061,17165,-19733,-14261,25761,21019,-31131,-24017,3131,-32549,5645,-26795,-11137,-30447,3361,-17803,-4265,8319,10589,18299,-13683,-22829,4567,719,17835,-24355,-24649,14479,-3107,-8045,-28521,43,-24125,-29677,-15607,-7811,26971,37,-779,-13301,-17589,3423,-10389,14523,16673,-31493,-13973,28705,18587,-18323,28423,24485,19205,2365,29467,-7993,1835,-28487,8605,-9823,17977,15171,28977,15799,-10663,-6267,22635,-8379,-21727,-29555,6387,-1309,-12893,10869,14593,26939,-32345,17323,31007,7325,-27435,-10591,-18895,7931,-8851,-2733,-27539,-13941,-27525,-26465,22177,-29521,-31757,29259,-11761,-16781,17697,18635,8591,487,-30427,-27895,-12197,-9489,4351,30687,-28961,8509,-12879,-8913,-9637,19969,15907,2469,-18037,-14747,-14813,915,-26019,-21417,3101,12879,-19847,-23627,6845,7639,-5999,17239,657,11245,-18159,-16111,-5647,-26085,6413,-30571,18713,-10587,32581,25229,11187,-29873,-24085,-16371,1619,9045,13435,17251,10971,-26673,21865,28543,-17485,-31097,23227,-25879,-31859,-4709,8111,3367,23019,347,-18785,14999,32235,-11471,-2333,32373,-3173,-319,-15095,23661,-20447,-4643,-10337,-14027,-29465,-3221,-15287,24165,1633,-22181,-2349,5961,-32639,17283,11003,28785,6307,15705,24759,30073,31333,-21785,-8635,4427,13433,-10443,-31359,11299,-26051,-26017,-26607,16863,-19901,-23785,-6453,-2197,12971,27235,-28771,15557,32245,11507,-12259,-30797,-20701,-32517,18705,1529,-639,-7375,7523,6615,11801,4503,23713,23393,23539,-20025,5477,29359,19701,-32361,-25889,14287,-1593,5277,21523,-16647,27707,26897,-22379,18855,22111,-29655,19549,27663,28793,4347,30003,24373,-19351,-14535,-3289,8335,-25587,27095,31141,13003,-17087,-31243,15267,11183,-32191,6807,29837,-11611,-15605,28663,-26879,7695,28415,417,-13421,-27323,-24449,-19253,329,-7459,-28659,-19161,-10177,-26797,-30587,32173,-16917,16821,-8617,-1597,11971,3297,12597,10639,18835,14597,15417,-24945,20001,30139,19451,-2993,3925,18097,9583,28777,11701,-13205,-5445,21913,-27035,-30403,-24903,13351,-28491,-5915,-14783,-25059,-11425,30665,-229,-7971,19989,23979,21723,-16601,29135,-8427,-13621,15987,-5821,-8449,-10507,4887,12693,11457,12647,10621,-22405,-16215,29017,-31131,1117,20981,29709,10037,-5561,23783,3335,11433,479,28159,27081,13089,26079,4367,-23199,5705,1891,-30333,-21027,23685,-2879,-24713,-9465,30543,6649,-11109,30837,24143,-15643,-22345,6127,1797,-11081,-11465,14231,-25153,-3939,-22079,18911,-3995,4763,8225,9087,9379,22571,26877,-28919,19129,-27827,15845,11463,21753,30261,-23995,-17673,30181,-99,18279,30525,27615,13515,-11667,30753,-3617,22937,7777,7191,-15095,32351,-17867,27323,8349,3905,2147,11071,-12567,-17981,21675,31963,-395,-24267,23655,14719,30629,-17255,-29509,-26131,5659,11549,-30899,30525,2953,13873,-30143,18197,-10995,-19823,-1423,-6567,-12977,-14039,1963,18395,10403,-22305,21629,-30465,-26863,-28943,-13817,24821,11855,10737,27463,12173,-30641,24013,27389,-6033,-15907,27949,-16293,11339,-467,-7829,2793,8843,26651,-19705,-3565,-26881,-4117,-9487,-6253,10837,-7335,-28903,11443,25745,21715,-18619,-7355,-23145,-13287,17591,10653,-20511,22549,-28579,9591,-21477,-31893,29037,-9679,31067,20113,763,31719,15969,10663,31131,29159,7513,30067,-3699,77,18865,-8717,17733,-15643,7027,-17271,-31337,-7251,17933,8777,-21419,-12663,16453,26997,-28245,-1925,12255,-3595,-21159,10203,29539,26415,-1799,23787,-421,-6485,-21733,-10611,14875,-10897,-5113,21087,-6679,-10067,-9563,15673,29825,-28041,26871,733,-13179,-18835,-31681,-1443,-22531,9281,-137,-17379,-6851,-26299,131,23857,22261,1525,5501,27325,-16275,2603,8891,-4061,29763,-14013,-13271,29687,25723,31055,1353,-3139,-27051,22709,-8941,-25723,-23211,14047,19299,4589,25973,-3257,-21431,-25279,31985,-23295,30529,6023,-27873,-29337,-9129,16063,30101,-24961,10843,-12455,24433,-7579,-6869,16545,-617,19979,-19445,-9137,17041,5453,8493,-20489,12783,22665,28891,-1997,-10957,-29507,29781,27213,-1363,23287,1351,29021,-20549,-24941,27313,-32185,26835,7553,-4909,-25461,-13173,15541,18905,23665,-3279,187,-4347,-16791,-21685,30327,-28181,17545,-30639,5695,-31219,27701,11215,-5713,-19913,415,-5179,-29551,81,-28233,-10547,-19193,-27199,10553,5083,-31113,-27249,-23373,16435,31639,6355,26517,29765,9667,-6737,-16335,17635,22099,24005,133,-14993,30249,-23949,-6659,6535,-7577,32035,25801,-22657,-5415,6439,-5581,-26595,-1837,-15599,9405,-11295,5091,10639,17309,-6697,20277,8861,21147,3691,22219,21743,10031,-28521,14913,11497,3713,-3509,-8615,31213,-5369,-23987,-2723,22809,-29853,-15667,-28251,-28243,31401,-9515,26275,30765,-19205,21225,8323,13601,-23139,-21987,-3373,-16571,-12357,-29499,-32541,12585,16581,5749,18237,-4689,25581,-31975,21593,-31373,-19339,-249,8611,-6477,-30395,-31781,15569,-12089,-25029,-6407,-31513,1365,3605,7275,-21141,-2355,-15167,-2849,-6603,28249,23425,14379,16513,-23383,-14215,14653,30935,-23455,22669,-22335,-26963,-21697,4879,-8975,705,30255,-6247,-14979,1353,-10595,-20611,-24695,25159,-10769,4853,27581,-273,32555,-23913,-16539,-2883,-30607,-1151,-27545,17925,-4219,-20869,-25831,20235,5667,14283,-10249,17761,-14799,30345,11445,11997,-19541,12143,-13657,10143,6967,23811,8717,16063,18727,-15161,-25069,15941,16995,30433,-20917,28007,-26687,32105,-29837,-12943,-25985,29271,-25045,-27159,29981,-23685,13027,-16847,5329,23911,-6725,-919,14969,-19025,-19715,-13771,-6507,-18481,3431,-15247,-31825,-26891,20269,1147,2539,-10839,2259,-1567,-8999,-3259,-3979,5121,16037,-22719,4593,-7395,12383,-22019,-32641,-18295,-31255,-9591,-313,-19061,26083,1371,20419,-29149,10271,-5771,-12407,-25849,18923,-26721,-11157,-23501,-27621,6361,-5431,3441,10831,16103,-16467,-21983,2531,-18029,-13925,-18599,-5073,31743,-15185,26351,-18377,-15789,-18991,25075,-21247,-11237,119,14957,-11073,8365,-11909,-32609,-4157,-27575,3397,-7305,11937,15845,13165,-6171,20697,-6971,-997,12195,9147,28239,3315,-21815,3253,-15407,29049,-20339,-13817,12687,-22641,20967,3291,-27737,3465,-31061,-8319,9927,-26421,-20653,-2811,-20461,12425,16093,-1013,6307,20059,137,-13599,-2681,21539,-25377,28135,5739,25417,8485,-18247,-4715,-21767,5023,6105,21053,1585,16479,-14291,-24793,29755,-27883,3939,-2135,18763,-5811,14419,-12965,-5089,-20159,-17245,18967,-9771,2691,-19657,-28809,-30309,-30771,17913,-18405,-12613,-3083,7349,-30255,16213,-23893,10823,16679,7565,1629,-31447,-7357,-8023,22457,5775,-11991,-26637,-32601,-20335,-28183,-21861,23113,11429,-1615,25105,20833,28043,-10413,-1039,-30729,-19597,-18221,-21583,-24299,12861,12413,5419,-25019,20799,1853,-14521,-12025,-11905,-17653,-29079,-703,25753,-22977,6825,6195,31291,-4673,31199,1649,-29207,4635,-23291,21343,32177,10053,9769,21837,12853,1055,5979,4267,-10161,-11235,-28569,-6361,-31627,-29287,-12019,-30777,-24785,14451,-19291,14821,-1875,7467,-16295,-28425,-21,-29129,23365,14665,-18355,24723,15923,27445,8627,21147,4763,16583,-29693,-17573,3167,-9683,32679,-7607,-21237,24687,-285,32655,23039,14035,5431,-25041,30351,-22405,-6045,11759,26245,-15995,28221,20919,-12277,26747,27141,22121,6761,28631,20819,-12757,5023,-19379,-26005,17205,19813,11547,12883,-3395,-11577,-9201,-7765,14325,-21623,2941,1161,-27911,31383,22113,-13787,5077,-9777,4879,-7559,3607,-4433,-14479,13697,22807,-20873,23075,31539,8931,19753,-22069,-7523,27187,3333,-25713,7859,13305,-15719,30605,-10423,-15321,-32037,-20559,1735,-24105,-5925,2247,121,-29027,17017,8495,-29823,12133,18861,7323,-8255,-9979,24213,-19787,-2599,5499,-11241,2017,-12535,-9417,-28103,16781,23615,-5055,7757,1939,-12965,-29793,11457,427,26595,7663,-8399,-13361,2707,14819,3089,-6831,1941,23699,-13943,8683,-30899,22105,-9681,-3255,-13229,-6325,-25089,30155,27129,16337,-11921,-26269,-12437,-1015,-22443,5695,19749,-25035,14705,-13733,-27927,22705,-12659,7357,19923,23345,-227,-15547,22161,18253,-18763,-32107,17731,469,-8987,6319,5099,24433,-4683,-11755,-5811,29263,24525,25215,-28275,31977,-16429,18025,-19195,-9257,-23715,-19391,-5187,-27557,13203,-4339,-3483,-32493,20717,-5707,-1119,-13647,-15071,-32079,-4811,-16791,-20995,16355,6785,-20085,-28071,24121,-16279,-12001,9535,9181,8057,6679,-17143,917,-9589,31865,-8925,3505,-6843,-197,11713,-29637,11063,9829,32707,-21293,-19805,17807,-29011,-29643,24141,9495,387,8489,-22259,9753,2453,5065,-26947,-5665,7863,28309,-16751,-6295,19347,-25741,1003,-2541,7625,-32183,-4525,14091,25983,-29329,949,3263,-14603,-15763,7269,-18275,-5893,27383,14955,-4367,-25441,8665,-8281,109,-16933,-831,27959,13441,2091,8459,21531,-15751,28703,-7747,2897,-23981,28917,-7077,-13393,-599,16253,15293,-20101,-26171,-4201,12425,10555,-32245,20601,22499,-23023,16529,-4961,17601,-7151,-20923,-23027,13791,-30493,24729,-26485,28537,21919,-2593,-12081,12771,-11769,21195,17231,-21605,-11909,-15975,-10579,-25201,-30521,4115,16221,-3557,30311,10983,22357,16351,11609,14629,22785,16069,-15889,-18821,-19037,20831,13361,11619,-31785,19339,-23561,23485,-8035,5905,19579,-13029,12139,-15313,28931,19521,18267,-28875,10077,22737,8717,28159,-25919,-18337,-7811,-28929,26983,765,-19321,-24045,21281,25323,-1321,7877,-871,22237,-26417,-23343,1259,32551,-21433,9807,-25183,24837,15867,-11003,-10247,-19553,24765,8827,31513,-23935,32317,-18271,-2299,5303,-18775,-13229,-1307,29579,-29687,25441,20393,-6827,-10705,9419,-30063,-15849,-7357,-16271,-3147,29053,-12739,-24193,13165,7745,4427,14525,-24803,-20053,-18267,-13213,21573,-22419,13277,-28851,-17769,-25529,-15395,-22201,-3245,17949,-5917,1753,-29515,22151,-19431,-21183,17653,2539,4047,-13943,-21957,-18079,-881,701,-32695,-25279,-29347,-26429,-22841,-17711,-26069,-5055,25645,-30049,19225,28009,-2293,27991,8771,13289,871,9539,3917,25657,-13465,-24071,-28993,12161,-13555,-25267,-30621,-30985,6103,-10785,-3439,-12669,-30563,-24367,-14319,21431,13871,21123,10453,26433,-2087,30099,-7001,7527,8327,23759,-413,-6687,-30473,-30405,-12573,25843,23485,-16017,15111,21255,-16615,-13485,-29987,24915,31721,-16555,-12895,31323,-19083,31539,29693,-20447,3635,8207,-15265,5295,-7891,13495,-15537,16985,-8905,-14623,-27427,-5175,-19245,15131,27325,-31669,-4391,-23467,-29207,29197,-17945,-16163,21529,20373,-21849,13487,-21647,10641,-21979,13931,-22533,6361,10045,4831,-13091,-29175,30627,-30207,-28647,-13837,-8043,9151,-18725,23199,20751,-27461,-8457,-4409,-1853,-21777,-9199,-17943,14653,-6025,-25409,7761,3803,3365,-7525,-4587,27291,-25327,13297,-12751,29983,6559,-9789,2173,14479,7607,-19553,10483,13231,9139,-25915,-31203,23903,-5669,-17357,22707,26545,-26365,17277,-22607,-22371,-28505,21923,22265,-14919,-28465,26369,10209,12583,-18389,-27639,-26461,16067,16683,28627,-17467,10953,-5415,-15389,12631,3545,-22481,20933,7627,-13305,20367,1605,31013,-27301,1723,-27921,4715,-3737,27369,-6645,-29551,-4695,-20363,-23441,-15917,29913,13965,-125,-4129,-1567,-14215,5205,-21133,9677,30745,-24939,-27569,10101,4275,-6387,-6403,-17243,-14777,14465,15529,8419,9019,-18175,-26803,-19475,-6103,-16601,21575,8911,-4895,13085,29809,-24141,29429,18843,2881,-17285,-15999,31729,3925,12729,30915,17945,-3521,-9399,19009,-2267,-26911,1303,8137,30865,23167,1733,-3753,5775,-1087,14317,28001,3287,-17421,-2773,-28293,-31643,32519,-7291,-2913,-17077,-307,1429,11725,-22493,1901,22399,28139,21565,23507,-29009,-9789,21475,25069,-12375,5377,-13801,19199,-28213,21001,31817,-22119,16199,-4491,4285,29969,-31495,30867,1297,23887,-23185,-12553,-26907,5887,-31217,-31525,-2989,6729,-23977,-32075,-6553,9883,23487,15445,-24445,26161,-7411,13357,18347,3269,24043,7183,-4537,7333,12429,4235,4703,-1885,21995,-15905,-2219,27093,-5531,24779,-18721,32601,-6013,-12597,-8795,-2917,28937,14119,-16591,-20565,26119,16129,-1301,-1819,18703,11171,-13675,-29289,11489,21233,21081,28093,-15847,-18975,8883,-3995,13359,-11117,-10521,-27655,3675,25233,4819,-16815,17199,-24287,3487,17677,17821,6355,-13055,-15369,8737,20199,-6847,-15457,-20405,-11835,20105,-595,-3063,-1841,-30587,6907,3859,25093,19947,21545,2241,-27167,-23763,22419,24947,-31005,17389,28537,16283,-7451,-17329,30441,-10515,-10631,28229,-22115,4455,14423,-20659,20131,-29557,16619,-5373,-22321,14115,-26521,8965,-5197,-21217,22163,-9811,30793,-15199,-8307,25113,23865,2289,-6723,-17671,-13929,21751,-5687,18469,7137,8613,-8153,-23035,10203,30949,29,8623,12593,-28133,-11805,-393,2437,-25373,19953,11087,12935,14537,-7529,-11789,25231,29147,-17403,27501,-15695,30659,-22885,-25337,-16521,-15141,-21703,-12491,23465,31305,11249,31061,-23169,-11601,-32555,-27981,-17507,-8185,27009,32599,16649,-28569,-11999,25621,28061,27331,18831,25197,785,17493,2719,-2771,-7071,18857,-4375,-5641,-13217,-10969,-25725,5639,6919,24865,-27657,-16223,7437,-9577,32389,32239,-21637,-8961,23285,-25605,-12013,4633,-2065,11191,921,-16747,-935,6947,10017,-4601,-18833,-16391,16447,421,-2575,21105,8331,22445,15385,-32299,32371,-5235,22593,-533,3025,32535,-4445,-15075,28093,30023,27531,30925,-10857,24589,-18597,6673,14803,9999,21279,14443,-13087,14425,6561,18393,2269,-17471,-3877,17127,-2147,19893,-16013,-3797,-6651,-12851,-10281,18409,5503,7989,-24685,-5093,-21603,22849,-29753,12375,-32749,2547,3343,17891,-7069,-22101,-28417,-16847,1269,24563,2415,14997,-5997,-8735,25433,16677,-3347,-28939,1109,6959,16685,-919,14019,-1955,-28671,-5821,-20775,-877,-7951,-11073,-14541,-25969,-20975,-30213,17035,-14909,-1963,28941,14607,-20609,30805,14383,-23383,4161,-19897,-13871,15841,17365,5963,589,-21217,-29655,11189,23341,4759,4533,23059,22097,-8031,18567,27419,-24051,-31083,-4811,-17035,-21427,20617,26877,32637,-20303,-10899,-27825,28435,28023,29005,21135,4555,11689,26597,8341,373,11559,26043,-7985,1389,14063,28047,32095,-10745,6565,-24647,30839,527,-20511,-32505,18057,28173,17721,-29733,28583,7533,-18557,24271,-26765,-27397,31351,18195,-7409,-11367,31371,3551,15767,21833,4935,23455,6385,21041,-18605,30443,16877,523,-13119,16303,6593,25709,15965,7469,26961,21743,-199,-23003,27039,1481,27249,9739,27691,31649,20535,24909,-9241,1983,29343,7633,7617,7181,25639,19095,1675,6585,-19875,-27405,14479,-9153,20303,32061,28369,24357,29901,13101,27755,-8811,-10441,17407,-5449,20455,-31705,-23873,7583,-16681,-14863,5447,-32655,-2689,2861,-27717,25443,-21119,-26235,24085,31543,14915,-4549,17653,3905,31353,-18363,-32183,1051,19257,22121,-217,17031,-27913,16137,24685,27617,-19509,22587,-31939,31681,-13019,-10047,2145,-25575,-19899,15503,-19915,21899,-13235,25295,-10835,-9503,-30845,18367,18923,-13813,-1429,29445,-32171,12097,1643,-4569,-13379,-17053,19363,32397,9937,-2109,-13455,5127,-11275,-2711,32317,3731,-12813,-13525,22643,-1321,7221,-25011,10781,-31147,-19547,-16289,18323,-17949,-22921,13685,32525,25503,12875,-26781,17743,23701,4161,-24431,-8995,-4255,22227,-6825,12505,-16069,-19365,-32033,-17283,-30753,-5961,-13943,-20633,14623,13363,-13979,-27961,-16521,-1681,-16609,-5539,11279,27593,-30373,7397,-14935,18209,-27289,13209,19407,-17719,-18179,-29845,-19271,13663,-9955,-16299,-23863,-5309,-3249,31949,25385,4641,-15707,31737,22369,-14753,-1363,24495,-5003,-23003,17441,-11859,18653,22675,-12139,-30303,4033,9331,-29887,-557,-17013,20757,-5005,15127,4625,4657,9793,3915,-25789,-6769,-23535,-22537,-2109,6029,-12831,479,-19581,-18205,-22311,-7319,-11295,-14543,10413,13343,-20443,2955,-12093,-29565,30977,15153,10297,30183,22603,-30405,-11523,-22793,5403,-25399,-12771,-30553,3067,28201,4075,-19887,-31929,-479,-13809,16191,9487,-14577,19389,29241,-6075,-3191,23649,-6255,-31797,-12489,-8745,-7707,7617,22871,8663,16921,8721,29509,-22397,-21193,-20145,-30317,-28475,-11941,24885,-26109,1123,-26783,-3117,21311,21509,-3253,-24843,13637,-6981,28259,11017,-613,-31161,18947,-7683,24857,30405,19087,1721,7525,-30201,7363,10897,-23501,-30973,6749,-15103,26079,-4387,-20279,11209,16189,-13191,-19481,29553,-14945,4663,29617,15473,14563,-16717,28071,-4017,24123,9993,-19101,17859,2257,-26743,4409,-29371,11813,8701,12787,24525,-23741,17333,-5323,-19823,-5867,8183,31579,-27369,-26093,-43,-31643,19455,14855,27601,-29845,-12093,31093,-12359,-4205,20425,-5921,31519,15455,11695,-6425,1469,18001,12731,-18659,21965,7673,-21447,26751,20867,31239,16599,-13735,20303,-13917,-19289,5989,-8619,-29547,-6595,-27349,-26567,31389,-7367,31413,-11557,-20811,18425,8565,11939,-21835,1189,-11083,-25919,31607,-22399,11743,18503,1227,14533,-21957,-29307,32299,3577,12521,-12671,20751,-16841,-24645,16523,15729,-21043,-9993,-7925,31149,6471,19533,19395,-25371,-9779,-15081,-2615,-5353,6803,-25609,12667,-28853,-1169,-9623,-1801,-15109,-20061,-12069,31257,-6431,15607,10367,-30323,13077,-30957,-27339,25827,9907,-23295,16749,4335,-17923,-49,217,30713,-32005,-28785,-32181,27255,-11631,-18043,22887,26447,-23801,-9845,-4405,2189,2081,15257,-30545,10807,10459,20221,31129,-1699,791,-19071,-13125,-30961,25523,24943,-19919,14009,24539,-3245,20733,1857,13635,-28757,-17607,28371,5373,-11409,-4001,-32145,-11795,-27757,2293,-21065,16639,15953,18629,22653,10503,-30279,17111,5981,31263,-17625,25003,-675,-19347,5967,-7365,-6713,21927,-889,187,-16737,-27521,-14539,14909,7217,-30961,14209,-13857,-13221,-9797,4059,-4601,-28889,-3175,-25647,11181,3867,-24433,-11965,13089,-24331,-9639,-4211,-15587,17637,13477,-4535,-18075,3179,-10025,-28517,1053,-25717,19193,-3457,10991,-25275,-22075,16659,4675,-22457,24823,-2595,21465,-19059,-17113,9783,-19569,4043,-10895,-21017,-10555,-28947,2863,9263,17219,-11699,17969,-7515,28747,9465,5025,-30131,27353,-1427,-23577,7233,-21941,-8013,-18251,-8697,19601,-10321,-28077,7565,-17433,-5357,-12063,9531,3165,30799,26467,-27109,29595,-11257,-18663,-29035,-31091,19785,4829,4941,3343,21287,13005,-13605,-21965,-13559,26543,-109,-10699,-7325,20593,12089,139,-28249,-2975,-20427,-16317,-13127,16213,-17611,-1515,26035,-16713,19165,-6925,-255,16705,423,22107,12023,24015,-32495,3917,17113,24575,16255,29253,18573,-4383,-9757,-23163,29429,7175,-20261,30851,-4979,-28685,-2795,-1555,-1423,-2629,-25061,-28323,5703,21939,7105,-11721,-1673,32349,14907,-19411,22849,-19679,-26803,-26947,-4753,-26243,-24155,-9935,-28455,-3423,7301,11,-18851,12861,14751,-6881,11697,-15597,29285,15225,22279,28931,21119,-15999,-15811,-4479,-9741,-16189,-7891,-5873,24241,-27537,26247,23259,-12663,21505,3877,18443,-21335,-3649,-20111,4365,-1759,-31433,8393,30671,-25281,147,28595,17397,25229,3173,-22227,-28433,-18493,8843,-28993,17957,2533,13039,-11757,17313,7403,25725,28833,11585,-24335,-11917,-21817,26507,-10357,25253,15857,-18333,-3279,-21447,9411,18931,-1839,13737,-285,-17193,19873,-23111,28737,-15003,7267,30845,20069,-14371,3147,-14191,17101,-28615,10885,31377,-15409,-15051,-29853,-11721,-24859,12869,21841,-2233,4779,28227,-7073,-11113,-22665,-8355,2391,7331,-3515,5305,21281,24459,-17479,12585,-30331,14733,20155,-31801,11059,-5233,-31489,6497,-2793,-19971,6017,-5923,-7345,-11247,28151,15045,3423,27745,22375,4095,-1919,-11259,27479,7417,5791,-17011,9465,14979,19273,29483,87,3539,29575,-22277,-25867,-11347,29643,-4985,10225,7605,3695,17297,-12457,-12319,-29875,-273,-21151,-29217,-14131,-18263,-12499,18093,-22037,18889,-6081,24457,5325,-23109,19803,-24661,-4179,-12715,-10831,1423,-22501,-6601,1037,-26351,-30285,-21461,-3563,-1601,19871,-7473,20377,-17713,10971,22351,-17193,15295,26835,9817,26301,6407,-11665,22213,-29137,-2031,-14419,-17177,-17471,9073,-9597,-31925,8959,12709,6517,-8575,32487,28571,9563,18247,27795,10501,-4113,-20737,22147,26885,-27299,-31961,-3995,26663,-22443,-17673,2957,-1789,-16487,20761,8941,-9659,-20071,21633,-7103,-9759,-11247,32025,8459,26609,-1063,-4543,-31581,28825,21627,11989,-22759,-11137,29525,-5335,29847,16397,-8877,13505,14515,-30149,-18349,8475,5339,-15739,19797,-13563,-26877,-3729,18063,6621,535,-4697,10761,-14937,12847,-24963,-9233,1723,-18763,-3785,-13945,-30601,-31249,-32553,267,11569,-10603,-28301,-22737,28261,-29733,19083,-23559,-23629,-13501,9441,-13045,4651,-21857,18325,-32109,-8539,-6245,17661,-3017,-12751,-18269,26043,-17855,-19135,22659,10801,-5437,12153,-14837,-29407,5935,-14553,-27981,-9481,11691,8141,29799,-277,-10655,-1897,17435,3825,32209,21487,13885,-2771,16469,-25615,-19245,2469,-16451,-24815,-9093,-24979,29623,-5639,-29075,-4909,-15667,-23291,18111,-21535,5523,12753,24041,-30519,-27003,-28531,-11899,22611,25033,-18251,-635,-21067,-20227,11513,-25027,7571,20871,-30625,-23131,-25129,-1827,4653,-8605,-11701,5553,863,775,-31589,29209,-24043,-19499,3785,17741,-8597,-169,26505,13453,3235,17053,29445,26261,-14363,10365,125,-28315,-12325,-8607,16685,-4307,18041,28929,-18367,29543,15637,13755,19553,26145,12901,12387,27223,11921,-8087,-25891,-15035,-11219,24159,-10371,-5881,20129,-11621,18597,15263,645,22951,-16717,19813,-5425,-25481,-2093,5931,-26757,-31323,-31965,2395,8311,1953,32135,-581,-20045,-13205,2095,4679,-16953,9939,-11065,8041,11019,-6557,7267,-30285,-20335,26737,1183,8057,16025,32009,-6647,-5391,2495,-31511,16609,32085,29937,14285,22225,29787,11111,28671,-13137,23919,18655,-11405,-15451,19713,10279,-20217,-8327,9419,10207,13545,-15103,-23185,-10627,-31861,25415,-16063,3929,9577,-16041,-14999,17601,-21507,13179,-15279,-32077,29179,9675,-5823,24231,12231,-14701,23559,-15109,-15577,-18403,-1397,27611,-20359,19621,-13019,-10819,-4141,-21749,-2015,-7267,-3697,31781,28033,23959,12265,19717,18893,-10061,14625,18087,16365,-19769,-5529,-15689,23635,12871,-31709,-16975,3807,10945,-26419,30715,-477,-27313,-10819,1013,-24713,-12927,21163,16667,1623,14821,-2883,7605,-2329,31729,-1245,27845,-17977,-30201,12143,-2167,8347,-20451,-2563,16397,-12667,17915,3525,-27909,6743,15721,30721,-24349,-1249,22757,-7009,-1605,17869,-23087,-1301,-1731,2715,-7197,9031,-18231,3621,30325,-15381,-3475,30149,3689,-355,-19919,12113,5193,31299,-20523,25419,-18615,-23773,-2065,4857,-31301,1227,-22503,28219,453,-4667,-17473,28789,-13519,-16005,11043,-6553,10587,5985,28663,-12303,27615,-17245,-10281,2627,26421,-23925,2717,-25633,-9289,-20203,-31395,-7875,8551,-5705,-28153,-12625,2565,-30059,-24115,8787,8571,-6003,10979,22965,-30237,-8031,-245,455,19437,-25243,-24731,-1707,14263,-26647,-9447,-15291,-1015,13069,16999,28351,-25217,-24339,-27751,-18143,-23427,-10937,-381,15919,18353,-14543,991,-9539,14305,-23449,-7777,17603,17241,31875,31597,9965,26983,-9353,-605,-28669,-509,1303,-13701,7739,-19575,-30249,-10169,-20851,777,-8239,-19431,-28479,-16401,18757,25407,-27853,20555,24465,6513,-1217,-20279,9613,19401,-24787,-15763,5085,1825,-12489,-9075,19895,17171,28635,-28649,30633,-7641,-3915,-8477,-21687,6605,-29317,16695,-27005,255,287,30675,-23501,27273,22651,-7555,23299,-5969,-4101,-12571,-25165,2273,-31407,2421,27757,-29721,18739,-19223,-14969,-17981,3947,-16217,-17011,-4637,-17785,-20881,21177,6481,-647,433,-3045,1959,24927,29241,5911,-26555,-26841,11939,-20523,14991,10361,-5621,15423,20833,27867,30183,19681,19449,-6799,11865,28853,27583,-10551,-18327,-14779,27497,-23963,6611,21899,4583,17813,4899,18211,-4673,23613,-18821,-6081,6157,-29495,9061,-16503,27729,2263,10485,-27269,24075,-3623,-14539,13161,6057,-4207,3569,12015,1525,-25129,-9913,16135,-315,-16811,31225,-6381,20081,-30351,-22375,17361,26785,-3983,17765,-12785,7949,9909,-8907,-20987,21567,-25257,20765,8011,23095,-17031,-6505,16569,-3265,-28295,18901,19947,21181,-6197,-25107,-5695,9365,23433,14373,-24305,32347,31843,24039,-735,9243,23755,-855,26413,32031,-25057,-15611,23621,-17883,20571,16917,11073,-27967,9817,31729,10627,25763,15289,-11071,14029,-22731,10695,-17873,-433,29887,32525,15921,4625,-7607,-20559,17671,-6169,-10895,-21637,-21089,18079,5049,32307,21111,-6717,-9969,-4149,30161,7007,-27337,4729,-27187,18981,-19463,1285,22963,-3619,-10329,-19053,19931,11845,-16815,16613,9841,-23545,-27919,-14011,-25711,-1195,9453,1195,1281,11085,-29371,4213,17623,9613,911,10377,10825,-6177,-23731,29813,-18681,-31777,-5937,1263,-14487,28151,16961,31285,23911,-9285,31515,147,-27073,-22419,-2323,6619,-32493,-20709,-18671,29851,11963,-2539,30677,13875,6615,21487,-29199,15413,22325,17483,25921,-22131,-10173,-9755,-941,12595,-2985,16327,5149,7327,-18137,6051,-12205,-25341,-12851,-12289,20347,-7265,-32331,-10513,-19851,32157,-26653,6591,-8771,5875,-31209,-11685,-5035,-26881,-7439,1083,-25917,-3467,-20483,-27573,-31871,4255,13619,-23283,21517,-6135,30517,24867,-3605,22843,-1267,-18975,9607,-12979,-8247,-6357,-23621,-2141,-30793,-24845,-5285,30439,9887,-28525,13583,7873,-12241,-28615,8839,-23395,-6577,-15971,-12897,11401,-5725,-31053,-3893,-30063,-6577,-2661,22305,-7359,22427,24165,9859,25959,7727,24931,-29117,9837,-18579,-16355,21711,-14483,24091,24777,21713,11119,22241,-4655,-15077,20437,8199,16715,-22281,-16347,12477,-30915,24055,3127,-4821,11319,26975,-12351,12897,8633,-1599,30075,-11123,5165,-27911,-28075,-30535,-20297,16183,753,-8849,11479,-7439,-8023,9901,11443,23221,19461,-6991,-13907,-2309,-17235,-9439,-11337,14941,-26887,7679,8993,10075,29695,30493,16845,5913,28805,-651,-20511,-24237,-4735,19589,-24389,-11815,32515,-28295,24495,-851,-18975,26373,-32167,6615,16943,-17365,20001,21269,22985,-15711,-19277,4377,16193,-12943,13977,24061,26429,-21891,18437,-627,-19965,-27213,26241,24977,-23965,29093,-13817,3145,17199,-30977,26597,-5929,6439,14019,-5497,10653,-19607,16069,-19917,-16609,-3873,-30251,25083,-20263,4825,11173,8245,14093,15439,7427,-17833,20079,23003,2013,-6203,-10221,20685,-23115,-23827,7919,-6589,-18881,-22549,-16483,-20937,21819,-28259,-28709,-2903,6023,18439,-23095,-30879,32559,-8123,16237,-1291,-23643,1497,-30847,-24849,3031,15753,-27737,961,14877,16531,-28647,6187,-32299,15613,-13673,12139,9185,22537,-14017,-19509,12221,-17083,28379,6961,1475,13807,-19863,-12857,-25013,-16475,-25777,-10819,5467,1873,15397,-19705,22135,-20623,-12539,-6811,-12759,-14925,13087,7353,23521,-1017,-9605,-24151,-6597,-909,-22749,31831,7595,28031,-30441,-6899,-30567,31413,-2951,-16057,-27337,-11715,31697,-27327,24887,-32637,-31529,-20027,28807,30571,3269,6825,16679,-32473,-15183,-22235,25283,-17239,-12855,-21233,11935,27385,5661,-27657,-15873,-3029,-4437,-16233,24375,14351,-345,1305,-28263,13889,171,-17703,-18343,-24457,16957,-15009,-32701,26917,-12931,23977,-7025,20757,18185,29413,16647,1277,10127,-9081,-23939,26681,-21675,-4849,16205,30435,15755,7611,-9037,3737,22063,-3511,13071,-5493,-3129,16923,5833,-8497,-28893,-27545,31541,-8567,-17299,25617,-20931,-13369,7299,-21937,-29313,4357,19181,7935,-11789,31957,28265,-16867,10321,30805,-6645,-26615,16073,2685,21731,-5565,28553,-23749,-9415,17531,-2471,6519,-14615,-25161,9315,-23335,13923,16503,15835,-7429,-19133,-10191,-7587,-10239,-11107,15383,-9857,-11761,-18575,1265,27613,20597,-9511,26051,-2279,30555,-191,-27791,-26575,7875,-27387,-10769,-12993,28309,-3079,20103,30559,-10239,-553,-15973,12105,371,-4243,21203,26959,-23939,3781,-23687,-6293,-1473,-3929,-4477,-24833,15161,9949,15305,-2479,-14559,9465,22419,16365,-32433,-18251,-10303,29771,2767,-30277,1389,11323,-24801,19037,17589,-31139,-18025,7287,-10889,13521,28825,14675,12335,27693,-11303,-13721,-4795,-15357,15661,115,29089,-9775,-9763,-999,-32481,26803,-21383,-8377,29107,25607,-6779,16595,-6755,28165,-9067,24379,16547,-25431,-16543,-797,25413,20633,22793,15525,9933,-4377,18895,-26981,2123,21393,26375,2683,-2483,-7565,-29305,20067,25053,-959,-4003,14243,-31825,-11157,-24539,31299,-32277,4451,17327,13817,4881,26569,29355,10151,-6541,537,-21409,-1101,21725,12111,-21831,9577,7157,32005,-12549,21927,21547,-17773,28351,-9559,5417,-3917,-4213,28049,13,8205,-3531,10581,9707,11995,5113,6385,1639,-6247,27945,28857,32041,767,-23261,399,-2105,-20923,-171,-4661,-27873,13315,19809,-5657,-14175,13685,19751,-5611,-11567,4927,-28073,20137,15017,-14027,17601,-21645,-20583,-16159,-21299,-26339,1877,13703,4999,-14639,26777,-12193,-30997,26323,25211,-29881,26361,31391,14475,18291,-13927,14129,15695,-3569,-21545,31359,14037,-26393,-12617,-8695,-1351,-32659,3473,23647,30183,-32269,4923,6765,-30815,-14381,-29165,-12081,29647,-3945,-15667,-20521,-10257,29579,-18855,13317,12083,-21671,-12113,8115,1931,1523,17643,-26457,-16459,31343,8637,-18043,13349,21421,26231,-13637,-26657,17587,12455,4229,22147,-25177,-29165,15839,-10261,4659,-10517,26489,6931,24385,25691,25057,8315,-761,-15415,-29267,-205,17091,1897,18623,-12629,6071,-16001,-579,23793,-9215,-23509,-17513,31991,30745,-5067,26575,22881,-10451,-28345,8707,-24793,27825,-26355,-18527,4389,31667,-2103,12527,15351,-17695,29033,-24997,-17983,-4697,-3525,-31199,19567,155,-28691,31473,12571,-12595,-24429,-13563,20039,7955,-12947,6635,-29003,-19013,29139,-1123,-17267,17495,-17451,13893,-21519,-1663,8511,27263,-13073,3873,1045,-12889,6379,-18435,-13047,-27099,-20435,-14643,20641,24975,1135,-4885,10143,18489,-24719,20825,-17195,-2143,8173,-28255,19455,767,13741,-11665,10159,-7129,14517,-21805,-27737,20755,26331,-11977,21635,7527,23665,-17235,-9197,-5711,-8277,4757,-27307,31847,23513,-8043,6109,28317,6765,-25947,13481,331,-8909,-3523,5337,17129,-13639,2995,-24795,-30767,-1049,-8095,-13551,14387,-32219,-6011,5683,17509,-263,7093,-23717,7151,32599,11381,26731,15665,8965,-10281,17583,2953,5645,18305,6651,-19127,-31933,14159,10683,-14723,-10909,-16263,-15935,10609,31627,-20337,-9823,-25565,20235,18819,15823,-11083,28595,-31165,15299,-30163,20381,-6583,-31771,-4235,-29569,-29447,-6819,3259,22751,-28217,11353,-29819,18269,-9687,24709,-12525,-25531,-9807,-31159,-13079,16151,4915,5051,-1645,-24253,-30171,-15001,-29717,-22729,-11003,-69,4525,23955,3051,16167,-7875,6129,-13663,-26077,4027,20463,-25163,31937,-30481,32319,18909,17741,-21867,-18335,-24383,-29463,-15557,8467,17299,8775,22605,-9905,-22763,-19127,16091,25193,2735,77,-24427,17449,-25781,2725,-24641,22249,-19287,14125,21029,-2573,509,22057,-18007,-19615,2603,31385,-5089,-13607,17279,-6357,-28507,-21281,8035,-26055,-18801,14505,-5913,22393,-8447,23999,-12751,-28561,-19853,15725,-31641,-14885,6021,-11425,-17805,-22719,8797,-1909,8531,-15697,4077,20335,6601,-11215,-32205,29629,-27457,10321,-6319,-6015,21515,21937,-29423,-19667,-15505,28261,-29831,28215,-11069,-2977,6617,-15679,-5931,-15365,18315,-24727,1845,-19659,-9681,-17343,-9849,-20177,-8257,-3773,17169,4905,28895,23905,-26185,21821,-9957,-2507,-19057,12271,-3331,21647,8373,4507,-9759,1637,-18485,-4273,-19833,6341,12153,18275,-31355,16759,-21725,14739,-28225,19663,24247,26981,20909,8983,-27229,-24729,-25103,-2117,-9185,11451,21271,941,15987,-16519,25389,11761,575,17525,22483,-1087,5287,-27985,-8987,-17043,3781,-27995,16359,26477,12859,-16225,-12987,9873,3009,-32615,26949,8349,5619,-6873,-5693,-30521,19613,-30785,-12785,7707,12903,-1705,-22573,25933,31773,10409,24705,26463,32751,17775,-25709,-28473,18663,7077,-12085,13883,18323,1843,28205,-32309,-7365,-12365,25791,-3343,19821,3365,-463,13457,6665,14801,26721,-8295,17161,4407,-15589,-16099,2919,31425,6189,14281,24157,7283,21729,-30939,-115,21699,-31651,13549,-25333,-19121,-1199,30427,995,1911,-23219,-17417,-7197,2139,24909,-16899,2593,-32459,743,24155,-11143,-2093,10635,29549,13163,-24431,11531,5069,-22009,4857,-30431,-32673,28183,-21155,11695,-3903,-22139,-11113,-5353,-13171,-17135,25455,-1855,-11185,17609,-14883,-19387,-12055,17453,-25883,-18885,30261,-18823,27555,32493,-3689,-15121,-7329,-5675,15451,13469,-14297,-3489,12027,15409,-12843,-1067,3265,-3929,3987,16885,15097,-13351,-2719,14853,7085,-15073,5989,-29367,3695,8549,28371,-2407,17441,-22897,21517,13647,-16605,21043,-24775,-23059,1149,11419,18341,-27195,2915,12755,631,30785,-3811,-27349,-4841,1643,4077,-31261,16089,8957,-3279,-12877,9177,29741,1025,-16373,-12867,-9621,8695,-20297,10275,5949,-28935,-6449,407,8167,22167,-20337,-6707,28761,6547,-21665,-17243,-28179,9063,17687,-26179,-4607,20913,20655,-2113,-7091,14503,27521,-14013,-13055,-11113,-32613,-28469,20687,8775,25755,9737,-10003,7417,6567,-7297,8577,-24583,-6311,-3009,14869,-9491,-6157,-14083,14905,14629,-30549,17439,6353,5383,11569,-5309,19739,733,-25041,-15091,25421,15403,-7795,32209,2891,20275,31901,-7157,8713,22349,28513,-32199,-17683,-28161,-16317,751,17389,9467,-21395,31483,8105,11707,-4129,-18417,15767,27667,12197,-25371,-14153,1023,10347,-29491,-21965,21317,-209,13199,-3775,-13621,30591,12229,14509,-991,-29089,-24995,-21221,-32239,-15163,11071,13581,-14081,-26129,25477,-30585,-25757,-13791,6919,23377,16379,16555,31897,23699,-17591,7181,-23525,-27329,-20931,-10699,1877,6695,-16781,12157,27077,5401,-21711,-27261,24721,-23727,-15825,20093,-5533,-2057,25833,-18623,27265,23617,31669,31919,-7743,4515,-16703,5929,32449,31277,6433,-16215,20437,19161,447,31417,-9453,-24717,-11,-473,30141,-28415,11013,9963,-9443,-5765,9515,-14975,21643,20939,-23903,30607,25641,-18727,9423,13871,1441,-30905,-12797,-17825,3231,-29271,-11485,24407,2769,5801,25507,29565,4707,9043,-9335,-23387,4531,-11771,8661,-16877,12285,21389,-623,-5637,-3991,28725,27343,14583,-5115,-2279,2389,30663,-16117,23843,-21327,14379,21857,17493,12487,23459,-6117,12897,-29437,28149,-9365,11067,10885,11903,-21649,-19461,-1643,16215,26033,3503,-8089,7817,-27017,481,13807,-28237,3593,6201,-5947,-27315,-21671,-4001,-31097,-20759,2209,-31729,-22623,-12681,26387,-7619,-11305,-21459,27275,-3397,-27235,9335,435,5815,-11859,28827,-13589,-31905,15657,6423,-9521,-12121,20299,-24741,-16095,-10627,27053,-15655,-5729,-18261,16525,-8653,-25341,-10451,-21467,3577,18943,-5057,425,-2623,-4241,3871,21803,27713,-189,6785,-20427,15109,-23191,13625,3895,-15951,-6393,23381,3219,6705,24157,-2543,-18005,-6033,-29165,11447,23185,4399,-2635,-14051,-3979,31587,-26569,-7343,27321,-21193,31651,10891,-5157,27221,-21201,-28779,-7861,-31391,20899,-23507,-10383,-8951,25109,10455,-8511,-7743,-15683,-13957,23127,-9637,6779,31811,8885,-24947,-26219,-13069,10983,15665,13599,-29483,-21391,-8761,-19421,883,15971,-25651,20601,2343,-8433,-16967,17521,11795,-7231,4097,-22309,16919,-14591,-22071,8489,-22795,-11575,12155,16157,24891,20983,355,-19843,-28903,5541,-5305,22053,31947,-8655,19819,-32643,16449,11671,7245,-15127,10427,3873,-7499,25149,-18829,-25723,-6637,-17927,-4925,-7185,15521,26047,-8341,29405,17833,20367,-3147,-31943,25485,-18643,27521,-1497,-1277,24791,-9253,-16383,957,16893,5665,24729,1801,31547,29933,-26351,-8961,23335,15525,23253,6627,7481,12507,-30779,-5539,12989,-10715,-2027,-13515,31803,4509,25119,-9329,25627,4001,-4257,-15771,20539,28661,2341,15861,-27735,-27719,-8205,17871,-8643,5521,-11831,-24305,-25191,1867,32649,-7491,29459,-18531,23951,14751,2651,-29803,11513,-29997,-23207,16941,-21523,-21935,7929,10277,-29441,10867,-27393,21831,25423,-13855,-29569,29879,24113,-4189,30803,23363,15359,-1585,17277,-25519,3287,-16435,2385,23127,-2621,-30119,10893,30761,-8183,-2517,24309,2419,909,-12691,-9271,18977,30947,-22929,24159,-29991,-4445,-24539,10607,17899,-3327,20843,24933,17097,-24537,2965,22143,25477,-30513,27319,-10411,-20147,-29985,-28763,-1311,-28547,-32701,25731,-3251,-5401,26935,-24613,31573,-14695,5015,-10171,913,-1859,-14227,-8047,-12603,28155,-23605,7165,29987,27917,29919,-21991,-7097,26893,-7133,17737,-16595,-11839,-30393,-5779,-12529,-17133,-12857,-26025,6095,2737,30117,26273,-12901,24175,-24879,26651,-26113,-14709,-28301,31439,-31003,-21859,31719,-32109,-13877,-593,-20651,-14285,19451,851,-12839,-14257,17715,-209,3847,22993,21567,-1203,11537,-32725,8277,30015,-23025,-29409,22785,13833,-31727,-14103,-5753,-31571,-1329,10279,1479,-5153,16307,3691,17095,-16833,-24019,-12099,-16267,-6729,-7027,24409,-1293,10191,12995,-27081,19055,-10853,16311,-4117,6683,-24027,-24697,-10913,3023,-8981,31087,-30045,-30467,5329,-29503,26107,29553,3167,4263,9349,-29607,-11031,-9787,-18685,-20417,23727,-2443,20801,27713,-5655,28629,-2753,-9519,31355,-1389,-16251,-14799,20969,17647,29553,13203,-26091,-28783,2495,27701,-13949,9357,-21191,-13353,15023,-30437,-12833,-16337,-10473,-4267,28771,-31709,-26617,18299,-29979,28379,-1481,-14483,12549,-9365,-5091,21701,22753,-12153,-4143,6795,13165,7999,11715,16139,-22719,27117,6949,5601,24067,-5923,-8155,25775,-10489,-4043,-7977,8175,9965,32297,-18329,-11959,-23819,-421,-22543,14431,-10785,-7119,-7109,20305,23255,-23343,4975,-24935,-13819,-30901,3089,-2803,8349,-7481,1663,31875,15333,-11421,-22559,9457,-8117,-4665,7429,-9045,-3715,8977,5467,-12685,17809,21695,-23823,1425,14039,28871,-8349,-27185,4749,-23677,-20555,24327,29815,1051,19657,4493,8157,30515,-21935,16605,7767,-25245,15257,22269,1819,9675,-14071,-9993,-14007,20027,-8911,16309,9419,-30281,-9529,-16025,-11441,-31071,25275,-12343,7427,32761,-8277,5189,30779,30227,55,3,-21245,5945,25307,16445,9949,19485,-17559,29491,14791,21597,21571,-11493,7287,-16389,21757,-11983,-16869,-17901,-8759,14873,18853,-13529,16361,-13389,-16923,-32141,1991,27625,27555,-15987,-10601,10319,-5089,32083,4367,-30599,25649,-5841,-26757,29243,28653,15951,-23485,-23177,-22827,20773,13793,8749,-26437,30819,-21341,27611,-2247,19223,32249,9635,-29735,-14819,16763,-23667,-4093,19345,2401,-31723,4353,9555,11731,9791,-31367,7997,-12675,6441,-26355,-15373,-7023,-19639,13603,11591,-25277,479,-14275,-25417,9975,5413,-10651,8509,-7701,-17173,-20403,24759,-30933,28223,-23581,-5617,17773,-17121,3699,11893,-23429,13237,25713,-2431,23427,-11157,32077,2323,-30739,9315,28975,-32075,-2057,-3409,31681,-10129,-13169,23429,12185,-14797,-24007,-19763,24843,18001,-32043,6675,-17863,23405,1637,28713,-26843,-28659,-12241,18969,-19207,-18117,-31393,-32683,-7303,-16151,-20699,12441,32329,7803,-7545,-21943,27537,-7153,27823,10075,-17233,-93,-10477,-24655,-28109,-17397,15105,29345,26533,18593,10859,-23029,-15461,-21523,-20015,-9073,-22651,-22665,-5775,-12903,-28687,27207,28371,-6003,3585,6663,-17545,-1497,-24655,32197,6645,6621,-7495,28913,-22827,-20515,-22321,24583,18453,2715,-1975,29855,19345,2025,6471,13613,-2933,-22241,-22785,2467,-31837,-7711,-2071,32165,2175,-13419,23525,1323,-6119,-22165,23891,-17137,-25113,8847,-21089,7707,7857,-23451,32713,18245,3617,-26185,30011,24575,14623,-7003,-3455,-32215,-27145,-5345,-16181,-2493,11119,18217,-24877,-14457,-11427,-2109,-8953,29745,1327,4731,3829,-23411,-21755,-32087,-9779,-10177,-18061,1077,-18587,-4617,-7795,26235,18781,18703,-32375,-12039,23149,-32343,3635,6685,15163,-20407,9657,27525,-21423,-27281,20627,-3549,31345,19881,-28891,6211,-14919,-13817,16589,-39,-19763,5535,17797,15563,19683,-23643,13149,-4175,14295,7773,11745,7241,-11711,23233,12275,-9779,-7987,8369,-3937,15409,-14409,26139,12239,-20893,-31295,-14727,-26005,14569,4363,-25607,18105,-537,10103,211,-10617,-2899,27121,30191,-19781,-27443,-16799,32187,-26153,-19759,17983,-4287,16299,-15751,15325,-9821,-10815,13371,-16997,-28795,-20717,31691,31493,-19407,27857,9437,2347,26913,-21773,-12573,3529,-29895,-23929,-17085,14427,32057,1581,11481,15169,-13093,-18187,-29155,-21715,-27525,-31069,-13973,-541,8551,-9141,-22161,-31553,30093,-26271,17193,4999,-14825,-22257,-30853,2427,469,-6387,30595,-1679,-6921,-4759,4447,15685,-27841,-20327,-30213,25563,-9745,27507,27353,-29901,20965,-20911,-19455,19957,13255,12151,8149,-19495,6255,-157,21895,-8057,-29803,14599,-16903,-25433,2559,17465,-19347,6183,-30925,-31547,22517,22739,-24733,-23297,-17049,7899,-26045,21725,15773,-18667,27035,27033,-5657,-2743,12197,-16777,14799,13449,-21269,12853,13227,-16645,5937,-30809,30189,-6325,23971,21945,-25203,-3381,-12997,26943,-20309,11203,-1461,-12033,-11067,29143,-13993,19639,21801,-10055,-11963,-10563,-25565,20757,-4615,-4165,-11835,-17835,-853,2017,17451,31205,-29651,10047,-22123,-12477,-21237,13957,14753,15397,25609,-18117,29929,29131,-25345,-14593,8675,20707,13761,-2563,11933,-6435,31759,-2423,24123,18491,-15495,-24229,2131,27129,22619,-7017,16589,23397,20817,30779,18963,2385,-23569,22475,-4989,25267,657,16123,-5875,4717,-26613,18607,-10639,1435,-23151,20045,19397,16825,-9225,-20543,31613,18169,-30607,7271,28189,20507,-1915,-18377,-5525,-14329,2957,17363,-32705,24583,-26803,-5633,-9915,1515,24837,30025,12833,-10501,-22555,31655,-3869,15831,3475,-11207,-13895,20103,-25643,11391,15099,-6855,-7563,-2093,-5765,17501,13727,24375,-7995,27487,20869,1119,-21333,-11357,12067,19651,26185,28053,7829,-25731,-27887,-23979,16795,-1691,1487,-6665,-28665,13441,-11435,14059,-32439,15623,19687,32121,25137,-25313,2387,11203,5167,-3781,1961,32613,-12907,22751,25187,11339,-18119,-16745,24527,-14855,10267,-14353,-12383,6741,-26687,-30811,-5663,27005,-29245,-20275,12157,-19575,25099,-15241,-8433,9013,11959,-25429,23161,-9557,-11913,16787,-609,-16819,4159,-28415,22301,-6283,30291,27883,-16137,26627,-23519,6247,-5815,16619,7961,-32089,12985,2627,-29345,-23555,-13813,9305,-8025,-29459,28743,11763,-22855,13399,-1049,-27999,-3723,-4417,-16029,-16741,32745,-31937,-4247,19267,9273,-14615,30635,15699,-19735,29257,131,13545,-32151,4395,375,4333,9129,7445,13291,21313,-27255,-19011,-7043,15255,16453,-31405,22207,9923,-13119,527,-8737,14221,-19207,-22217,517,12605,28795,-12303,21259,7549,-23017,-11561,-3287,-3305,13481,10085,3611,-14323,20557,-11115,19713,-26275,15349,23045,11103,11041,32473,1677,-6747,31539,22013,11317,24705,-15937,-23381,-25891,31493,-28539,-22423,6715,-20479,-29127,-30319,17879,14763,1959,19479,16503,3307,-12249,-30353,26063,-1381,21477,-21517,-25801,-21215,5057,-5811,15439,28235,-11709,-3441,26929,-13157,27699,19855,-11757,-21981,21177,-22961,4155,31659,9353,-31021,1853,-9829,-9101,-27221,-29835,16083,-26869,-22081,-29747,-3337,-13385,-819,-32057,31793,14527,-31821,-19089,-1517,-17479,13799,32277,31181,-29067,-1541,-13875,8757,23311,-2893,-28087,19279,-517,20427,-25141,13873,-23539,-11357,16431,-11929,23361,-43,-32673,11075,-1889,29603,-16515,9531,581,-22869,-5987,29381,-10649,32301,-22451,-15883,-29425,25193,-25773,-17281,-12015,7599,-12763,-24043,-16835,127,24481,11817,8187,15763,30207,-18679,10955,24565,-29915,-26827,-30785,-32747,9223,1005,31211,14653,-24357,20983,1875,29075,27363,4253,-32217,7377,-7819,22551,3779,-199,-28333,13685,17095,13521,-28445,-28785,-32689,12681,-14861,-22213,-5919,-23987,4105,-14829,28137,-20485,23899,695,-7981,-4029,15243,-6203,2431,23125,28217,-30461,32019,-24735,19829,16285,-601,-29211,21573,-28133,31261,-9853,-627,-975,-6365,29035,23653,-8255,-24461,-22077,-20119,-7133,30571,-3029,-11789,27601,18407,25337,-10361,-21109,18233,2881,-23119,-14641,-993,-11015,2127,16313,15427,14277,14323,1819,25971,17495,29557,-4223,29607,4797,2915,25641,-32641,-13981,9861,-15649,-24981,-7869,-32659,-12631,-26185,31185,-17821,20639,-22241,-31653,9431,23919,12943,1387,22503,-14881,17097,23723,-1043,20069,-32049,30579,5925,27885,13615,-31535,2559,887,9201,27467,2525,27261,9487,-15013,23409,27921,-26473,-28417,1743,-8547,-13047,-17813,29025,-31317,6089,12941,-18919,-15575,23475,19801,7017,25551,-12459,16831,7989,-26301,-27639,-31877,-26165,21573,30631,20299,-25229,17521,-631,-9137,-32689,1673,-10435,-25215,-11849,-5485,-1339,9777,20555,20137,-5213,-21461,-20745,-26789,18385,-28493,9257,-12063,14405,3401,-829,-2879,31023,14467,-6999,-2187,-5853,-5755,-18207,5731,-17099,-26883,24297,-3973,-18021,-11749,25691,-25767,24087,15585,-4373,16531,20213,26627,-32027,9601,-4577,10827,-27619,27221,-11661,2109,25127,-2961,16827,4141,-11509,4475,-25101,-31935,-24559,-32313,-7525,-13519,-20587,-16591,-12395,-22021,18565,-11921,27627,5653,-29873,28009,4293,-6655,8427,6887,-8147,29971,19715,-17699,-21129,-11255,16925,-28215,-18869,-22371,12713,-231,22007,-18943,-30267,21519,-18121,-30349,-26377,-9609,24851,12815,23367,22183,4187,-29407,3533,-13993,4805,-213,15035,-17147,9487,-8367,-20163,-12831,21351,-24151,5293,27961,-9761,24361,16957,-28931,11195,1013,-22141,30457,-20733,25213,-9667,20085,-7553,-24733,-23859,-2029,15985,19529,1109,-5355,19359,27093,-3831,19289,-13739,30409,32693,28737,-14965,-18799,-24257,-13913,-21449,2099,14267,-11923,9961,26127,31093,-20823,28231,4473,-18099,18925,12471,-6865,-2931,-3119,-6081,1735,-11421,-27787,-23415,-32617,-11449,-20811,29419,-32005,-11359,24493,23011,137,-2701,17605,-19833,25343,17423,12401,8715,-20737,29455,5687,30833,12713,-4081,863,9003,-5881,24739,14145,27525,2551,3575,-27895,-24315,-25083,7381,-28467,17579,8143,9123,19053,5169,-32007,5807,14993,893,-10747,31165,13003,22479,-15397,-4227,-18713,-32533,13125,-27107,-6409,-993,-4191,-7887,4359,-22405,-24875,2137,-9025,21863,-3471,-21587,-22041,16239,26555,-2801,-26779,6789,5697,-28871,22257,-11725,-19933,-23655,-2389,12919,2229,30249,-18097,-16741,-29067,5399,23789,-18479,28399,-15479,-8505,-15677,23125,-31929,5017,-25473,-11475,-2827,-1519,6581,-21601,-1353,-22925,26169,18337,-24937,6293,26897,-7589,29025,-17819,-23505,-19193,-29609,4257,31991,21513,7273,-16113,12329,32603,5449,18527,24767,26867,12519,19423,3465,18089,-23897,-11255,6623,24241,-8653,-16159,32667,-15513,22977,23289,-32031,9973,20791,1327,-223,26435,32463,7063,-1385,-19329,25801,-7127,861,-27327,19627,20897,18029,20971,-10091,-26075,-31899,-737,-18921,23557,12287,457,11419,8573,29349,-30073,13295,29987,25693,-1497,-25941,-17951,-13181,17377,15607,-32079,-18951,-14867,-22065,6555,-10363,-8875,-17055,-14203,17489,4753,-30983,-6005,-17549,5709,981,19559,-3293,18221,-24379,31481,31275,27551,29397,8871,-17543,-11055,25879,-16713,17007,16501,-22721,-13335,-26925,-17163,11317,1629,22647,-4105,6611,9927,-18685,-4431,17261,27853,-1089,16049,-22767,-15041,32267,-10195,-5157,23269,28895,8719,-6679,-25233,-21213,16817,-29711,15939,29081,2819,-12727,-2899,29603,-1831,4739,-705,-12823,2271,16373,-18031,25541,-5669,1001,14121,18031,9475,-30419,27737,28343,-12313,2111,-4379,-19975,-195,31657,-31049,-23763,14353,-20587,7995,4897,-25879,-21145,1023,15083,11137,-4957,-32727,-28213,4623,23093,28111,5885,9229,31429,18065,-20307,-9341,22343,-15751,10619,16645,-21799,417,-21839,3145,9411,16877,19309,-15341,-28801,-30301,-26825,18395,17313,-8633,-26179,-4695,-28633,-26511,-24819,-18149,22371,18429,22449,18515,8423,10255,-19231,-28923,10023,9447,-32083,-17137,-14325,-15119,21295,-6173,-12243,703,-749,-10485,-19889,-253,-22469,17009,-5423,3169,26597,-20147,-8469,-10853,8813,-9521,9971,11037,-28433,-22925,16635,-9123,10545,21719,-17385,14021,-10719,-3005,-10363,-11043,-9105,-26529,749,-26333,13481,6411,-9835,24937,183,-24989,-6805,-25003,-31047,-29391,-2345,9379,-5501,-11743,16843,-30435,6121,-17717,15393,22971,-9681,10019,8363,-18033,-3851,591,19441,-12385,-31729,30765,-26407,26331,-21451,19727,4073,16945,25891,-12605,-12413,-31003,-16333,4375,-21719,-22233,-24675,26741,-14295,27645,-13739,-693,-14133,1347,20337,-23439,-32315,-6023,-2717,9135,-28107,31791,-19375,-121,-3111,-22165,23047,14895,-7181,12903,-16821,-18955,-20679,15127,24725,-14817,-12399,-23521,-20383,30755,14763,435,15425,-10669,31693,-6809,-28103,-30535,-18735,-14451,-11161,29793,29583,-25087,8417,19277,-24105,32389,3985,-31707,5063,15521,-30951,-13563,31251,-21693,5923,-22819,25035,24683,-7405,-23301,-10797,-26975,30973,11357,26545,-16021,-9525,12579,-13291,22881,-8815,2717,-15845,16839,27479,-9261,-16871,-2191,-15765,-19429,11747,-22737,-21071,-20087,7059,-3963,14661,32487,15495,30045,23929,-20947,-17907,23187,15337,205,4527,-22717,-16821,-6603,7497,13565,-21465,-12519,22805,31159,-16295,-4801,-24233,-17257,-14311,31635,-1309,16533,-16263,-12371,5665,28073,25609,-31661,-4041,11453,2571,-467,5055,575,28141,-14373,-16595,-15567,16809,-22207,27679,-31407,-1931,-26967,-16611,-29039,15873,22335,-23191,16437,18423,-17001,-20897,-31487,-26061,3143,-27271,-29923,-23173,-22947,-31787,23439,-5723,12929,20049,-19815,9729,-16383,5935,-2389,-545,2329,4343,-19709,4707,-22357,7481,31805,-32239,-12443,29541,-21557,5865,-13081,5989,-5453,17617,-17051,-5725,19741,-21225,13101,-16155,-15613,-21477,-8357,29433,4543,741,-4593,-25507,17521,-799,-18599,-22109,-26981,6103,-13329,25463,16297,11163,-28185,-31131,-4017,23843,21813,9701,-9859,9407,2635,24963,-7099,18639,-13733,-12911,-14883,-4543,25435,-17777,31535,30337,-5133,8973,5669,-22641,1405,-4201,18255,14387,-18477,21743,-14697,22203,-2533,-6511,9931,-25537,-28485,21961,-2453,31541,1459,11027,-18393,-11007,-8997,-29851,22311,-21033,-24121,-25943,13317,-7157,1913,18447,-8903,17469,-15115,25587,-889,-3659,31081,3365,-11831,-30229,23209,-13957,5843,27793,30861,23063,31325,23043,22117,6305,-5467,-7043,22151,-14639,-23963,-7215,13561,-19263,-31265,13291,23407,-22747,-10065,-28769,-31363,17133,-25955,9405,-18437,9889,-10025,-23347,3179,-8859,-3615,-14825,32457,-8447,19553,15811,-18977,-16923,-25215,-5107,-9897,-22549,-23165,407,20107,18015,-21603,23291,12755,2087,-14811,22921,15189,-5273,28261,-27863,9243,5813,-13427,21551,-6085,27505,-28215,-17053,2577,-31089,-19619,17451,25463,-1179,9945,4861,31481,28039,-29589,21929,-32001,-32517,27379,-26841,-13929,-27623,17977,9089,-13197,1887,-24729,-7653,9589,4201,24215,8619,29085,-13377,5461,26853,19737,-31689,-9749,29235,12829,-3119,2161,-19189,-23091,-24577,-21009,-2787,-14073,23565,4119,6015,21071,-8163,8733,-30057,2215,1379,26005,5823,24377,18163,-18671,28461,-18667,17749,-31047,27033,-18247,-10683,-11071,22407,21161,-1563,-14603,-16633,10115,-1959,32643,24731,6053,12631,-4187,-18035,-28233,-2251,21683,-32699,-11343,-27023,12457,-30743,18357,-8511,9201,15929,-2329,20883,23029,-23649,-22847,7233,-9477,7499,11483,-25765,669,21741,-19091,-9883,-2795,1371,-30609,29087,-21283,-30297,30679,-14985,-18973,-7441,21765,-15959,1133,12587,-25091,-16267,3951,10957,-9613,24199,2177,1531,19063,-23035,11929,14971,24113,-3413,31895,-27043,11273,3451,-29563,-13821,11303,-31149,14859,-26767,-10683,-13699,31051,23385,20415,26909,1199,9489,9579,30317,-3561,26949,14591,-6513,-25435,-20629,20417,2135,4145,-26965,10149,26833,12731,-3095,15989,14903,-13963,-11251,19123,12235,28817,5095,24235,20229,-3031,14923,4123,185,15783,-24629,14363,24715,27251,22523,125,-3567,11003,-25985,27309,-25079,9883,-27565,22063,-6629,-10203,6727,-17341,-24133,31065,-1297,6437,32467,23105,21439,15909,-25263,-27137,-5921,8081,5927,-15019,3249,6057,3855,19813,18125,11057,-27103,741,-26253,2167,-28455,7211,1395,29759,-771,-403,30669,11597,-18157,16763,-28489,-25303,23643,12061,2403,4523,-1739,-30833,28997,22467,-27131,-12313,-9503,-22637,18317,15775,-28359,-9679,29699,23861,3713,-12751,-11751,-1337,-2623,15327,-16263,-19781,-15727,12995,17847,-24339,-23923,-31377,31499,12957,-28255,-29211,27595,-11513,18579,26359,-21115,-28443,13545,20633,19709,11051,-3857,-25471,14821,-15221,6951,-23983,7463,-13247,-27485,7503,8339,25529,-8911,24143,-23165,-5213,-22763,-10449,-8853,14843,26341,27711,27309,17115,-155,-17251,-24391,12757,15119,9777,18415,-30695,-30471,12069,-1407,6127,681,22387,7645,18165,16327,3067,13101,-18269,28275,20417,-9307,-9843,19699,3039,-1921,-8407,-30897,-12535,10649,-26705,3111,-21573,-10307,15705,-32173,22781,-1351,15093,24563,859,9385,26341,21115,-1817,-4435,14127,-7677,2073,16247,-19051,5027,4263,5137,23587,-13055,27247,-24227,-26501,2075,8235,-4239,-18035,-26565,-681,4625,-3371,29589,5297,17909,-29053,-18963,23647,3679,27783,-4869,-12039,20679,18583,-28085,10503,32105,-24963,-21327,23937,-30133,-1827,8897,31157,13835,-8307,12767,7737,-9225,-17687,32123,14475,-5181,-2581,-4061,7615,-9637,269,31565,-1939,-26395,-27059,-6897,-7265,24417,-9151,-20373,-17615,23333,-15229,5633,32425,-30477,26329,19633,1717,7343,-8819,-5659,15871,15781,-18039,24275,12523,-32239,-26103,22045,25565,20917,9393,-15049,1611,-16797,-18485,11235,-8263,-27571,-4533,1903,-1867,-19873,-11659,28247,-3689,-8595,29059,31451,-23501,-26013,-26243,32467,24859,-5025,-6439,18391,-27241,20455,-5125,29493,-25825,-11147,-6389,27785,-30021,29101,-6515,6665,-7,-5779,-29637,2135,5053,26897,-27769,14429,12601,-32075,-31919,-11931,9279,15383,5929,-29249,16277,17719,-203,-7993,-7331,-9599,-19097,20551,12519,13885,-19147,16367,8599,499,-14433,25043,31899,-18951,-20669,-19145,-20143,-26767,13211,-8295,-25259,-3329,-8417,18427,-17507,6175,13573,-4243,-30117,-1235,15479,-29745,18515,23451,-11857,-21255,-24145,-23941,-561,-14643,28711,8401,30609,-14071,16205,-25891,-8529,16653,30577,23593,-30809,-27167,-30369,253,28081,-22639,-20279,1453,17483,28171,-18443,-20623,-3325,15433,-15325,22229,28091,9955,-25589,9623,-14943,16955,18427,22287,-25739,-23407,-22211,-29419,5013,13635,23761,28429,-4885,19,-17943,-1721,-28561,-5743,-18811,30407,-14461,-931,11397,-7951,-29961,-6615,28687,-7285,25261,5761,23231,-14623,23035,10287,14517,-2479,-5203,-31113,22201,31899,-18857,-15989,-1073,-24537,5765,17767,31627,-10039,17067,-5219,30281,-14019,10543,-30551,-18433,31167,-13009,-23267,-18927,-31805,-15875,32667,30041,-6459,31669,27485,-25811,6899,16783,-14093,24511,-17727,-23997,-29107,-2813,-30577,8707,-3079,-3585,25791,13891,15415,-6461,-29183,16387,-28291,1247,-24905,-26787,-12283,-32503,12521,-9705,-17261,-6725,5265,11765,2823,-23343,23883,-7103,-4265,8143,2891,6987,31077,-5735,-2183,-8213,27625,-24267,1587,-20989,-13581,-9429,-19231,-22065,-3623,22473,7953,24197,31763,-12919,27857,-14545,-26745,-11993,6875,-21125,-2609,-11033,18247,12973,-9849,-19725,10053,-6715,-19089,2691,55,-3131,-18555,-11077,7639,-1469,-8305,-15687,-32053,-26843,25083,23909,-22525,-2331,-12683,-499,-12817,-16245,-20231,19031,21403,-29315,-17507,-2075,27643,1549,10031,27535,18197,-10913,-16805,-8183,18601,2933,-11847,-29025,-6617,-10081,13795,-20291,-23477,-29847,5891,22481,8569,-28521,25923,-15363,-7831,21639,16389,-22663,-14561,9437,-17361,30523,-13103,-29309,4655,-20057,5675,26159,19243,-18435,7031,10443,-7803,30839,-24933,27151,-15269,-13089,-4601,-27897,22651,-3321,13105,28235,6177,-12995,8133,25425,-29557,-24329,20539,23339,4463,21339,10771,3369,-17347,5945,18935,1667,-32027,1839,-24123,6625,-16815,7491,-16343,13113,31547,-31397,27429,19219,-30457,-17587,-32349,-27217,-17587,22649,26471,21725,19395,-15299,16575,-9279,-9917,30595,30293,-28475,6313,-3857,22979,-10881,20319,-4663,-20307,-12953,-13845,18071,28213,28939,20895,-24635,-16797,5511,10933,-8591,-31081,29229,2267,-3023,25067,-19371,2501,5795,-15479,10299,-4187,-10225,-24469,21199,-22605,31491,9005,-1111,-3801,-9401,-14185,-10501,-12261,12017,28085,28339,-24513,-6425,-7907,-15473,-17761,-26813,22943,-29939,-19847,-15651,-14409,19041,-10793,-9231,17255,-12487,27983,11263,16891,-11385,4017,-19231,-3211,17943,25857,6567,-7019,27811,10679,32247,-18747,-6373,23157,-9783,-2375,-11077,5331,3771,-22981,-10811,3823,17959,-20843,31039,-11635,-10067,3087,-24987,30169,11641,7467,-23623,10115,-5843,23751,11681,-17371,-29723,-15847,29879,-31019,-22677,-6451,15715,18791,-20507,24607,-21893,-9137,16767,-10353,-23831,-15191,-19833,27633,20907,29869,5801,27769,-21999,3075,15971,-6957,30939,-27331,19179,-32203,-21441,-12115,30931,24813,26971,-15833,-3547,-9361,11747,11035,-12693,-28371,-11643,-17691,-31509,7649,-32619,-613,-19433,10729,20293,21747,16539,15137,-13401,-18723,659,-17379,-19117,8885,13889,-22055,18137,3425,6949,-18023,-17255,-17793,29523,8803,-27535,4147,24211,-17545,12929,25371,26357,-29249,16063,-29447,-21947,5215,16841,-15303,9047,-6169,-25971,24879,11205,11307,29465,-24535,-30163,1761,18915,-32217,12037,-6457,1209,-6939,12275,-12329,-25613,-16591,-25285,16443,-21159,26143,-31871,-9117,23593,15461,1713,45,6875,-20245,-29653,-20003,-8951,-6961,23901,24939,26633,-7151,-19199,-16571,-13111,3787,525,-31607,-29333,-81,4959,20871,9525,-27601,12971,30131,23257,9217,32067,-18863,18051,12519,15281,32151,32519,-22309,8815,22855,22511,-79,26021,3229,-10911,-32429,-11973,15579,18945,26155,31163,-12409,11257,-29899,-22539,15001,-3163,21477,-29155,31619,-20275,-3793,-8121,3767,-16493,-12435,-32319,6219,-5289,15415,-6219,-6319,26671,-2067,-29445,26647,-7183,-26577,32147,15433,-24123,-3935,-14747,30639,-31433,7927,-15163,877,-24207,-25025,825,-27893,18451,-32693,-289,-17633,30541,24847,-12229,25463,11259,4891,16963,13417,-28433,-30951,13997,-22287,7927,-22595,-6599,10085,20911,-20803,-23801,-28965,4751,20405,6303,9007,-31687,19303,26483,30095,12395,-24043,-22917,32107,-5449,27809,-23819,17067,-19663,6219,28113,-22553,-16849,25567,-25879,-25339,19633,-7219,21571,-3021,-9673,-10577,20635,4351,-32083,-12463,23181,-10159,-29823,31515,-2013,-20887,-12853,-26945,-25023,30609,-27581,1035,-4041,12501,2229,13485,1091,-31601,13169,-857,1647,-5007,-19433,-5053,-24323,-10165,-21593,-5403,-1087,3759,-983,27905,22183,631,-17607,12963,27771,-4533,11251,7611,-9953,17175,-27449,16773,13757,4851,-1467,31767,-29823,29065,517,27619,13641,10359,20121,-8123,-21039,3587,-18713,23059,22297,11613,-2005,19133,27015,-5257,17955,32589,-26303,-10169,-1577,4613,-15291,20763,27881,1113,11525,29155,-9529,9043,-139,16201,-11261,-8133,11893,-6577,-16745,3251,29775,-7059,-31793,6113,29939,8851,-29979,1269,27267,-32499,-14411,-5767,-25193,-16979,17937,-4999,-12513,-18489,-4645,-25053,-10795,31331,-11801,9301,13809,17553,23195,17757,-11987,29087,-20407,-3857,-30747,14973,-25467,28233,-26853,-6573,-6753,-14539,-8411,-8119,-20501,9647,3857,2477,921,10253,26081,-20881,27073,-8997,10623,17863,3107,-30943,4203,-23697,15977,1327,11783,-10843,-1865,-28441,-26693,-15823,-16041,-13557,1395,-21077,30581,24613,315,-20469,28595,27087,-13665,13827,-9497,13309,-3169,2815,-19239,-27551,3991,30849,12643,23227,23133,-29481,8199,-29859,5629,29941,-22861,-12977,27023,6489,-10515,2861,17643,22893,-3775,-26427,-2083,-18237,-17851,-13961,9519,-5601,27801,31247,31917,7999,24931,-27495,21999,29603,-5279,447,-28451,14207,20057,-24565,-30277,-17041,23747,-3649,-19791,18199,14843,11579,7053,20807,1121,19181,-223,29393,4835,-20731,929,11383,8607,12947,1701,5595,-21401,-1615,-16429,32579,14639,-5547,19285,-32291,6995,-31619,-21843,-23029,-13601,-15785,18029,25267,75,-11855,-29969,2977,24267,-29733,25883,-11037,-2227,32421,-23749,13091,-7695,27041,-16385,-30287,7029,23973,-8521,24911,-19219,-29767,-10601,-12747,-13137,-21375,1891,-31247,1031,23691,-18071,10889,15229,-30245,445,-2249,-1413,13153,8027,14211,27317,-22813,-10107,32409,31693,-26039,-20097,-8643,5641,13415,11401,-28587,6403,5097,-16187,17515,-23939,18319,-12183,1679,32649,10607,-7083,435,19269,29479,15355,-28733,-26469,12795,14379,-31927,-13259,7109,2129,-25947,-29375,22477,14431,-30293,-1105,13021,703,5619,-16377,-14353,-21045,28155,27451,-4645,31125};

#endif
