# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   constants

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/constants.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
#Ax,Xx,Mx,Rx,Hx,Dx,Px,Ep,Db,Gt,Tex=Array.new(11){{}}
YEAR='2014'
Sfx={
  txt:                       '.txt',
  txt_textile:               '.textile',
  txt_asciidoc:              '.ad',
  txt_markdown:              '.md',
  txt_rst:                   '.rst',
  html:                      '.html',
  xhtml:                     '.xhtml',
  xml:                       '.xml',
  xml_sax:                   '.sax.xml',
  xml_dom:                   '.dom.xml',
  xml_scaffold:              '.scaffold.xml',
  xml_scaffold_structure_sisu:     '.scaffold.sisu.xml',
  xml_scaffold_structure_collapse: '.scaffold.collapse.xml',
  xml_docbook:               '.docbook.xml',
  xml_docbook_article:       '.article.docbook.xml',
  xml_docbook_book:          '.book.docbook.xml',
  xml_fictionbook:           '.fb2',
  epub:                      '.epub',
  epub_xhtml:                '.xhtml',
  odt:                       '.odt',
  pdf:                       '.pdf',
  manpage:                   '.1',
  info:                      '.info',
  texinfo:                   '.texinfo',
  sql:                       '.sql.db',
}
Ax={
  tab:                       "\t",
}
Xx={
  protect:                   '☞',
  segment:                   'Ф',
  relative_path:             '☼',
  html_relative2:            '※※',
  html_relative1:            '※',
}
Mx={
  ocn_id_char:               'o',
  note:                      'note_',
  note_ref:                  'noteref_',
  note_astx:                 'note_astx_',
  note_ref_astx:             'noteref_astx_',
  note_plus:                 'note_plus_',
  note_ref_plus:             'noteref_plus_',
  meta_o:                    '〔@',   meta_c: '〕',
  lv_o_0:                    0,
  lv_o_1:                    1,
  lv_o_2:                    2,
  lv_o_3:                    3,
  lv_o_4:                    4,
  lv_o_5:                    5,
  lv_o_6:                    6,
  lv_o_7:                    7,
  lv_o_8:                    8,
  lv_o_9:                    9,
  lv_o:                      '〔',         lv_c:                '〕',
  en_a_o:                    '【',         en_a_c:              '】',          #endnote Mx[:en_a_o]='~{'; Mx[:en_a_c]='}~'
  en_b_o:                    '〖',         en_b_c:              '〗',          #endnote Mx[:en_b_o]='~['; Mx[:en_b_c]=']~'
  bl_o:                      '〔',         bl_c:                '〕',          #block text mark
  gr_o:                      '〔',         gr_c:                '〕',          #group text mark #REPLACE & RETIRE
  id_o:                      '〔',         id_c:                '〕',          #object id mark
  tc_o:                      '『',         tc_c:                "』",          #table row mark #Mx[:tc_c]="』\n"
  tc_p:                      '┆',                                              #table col/misc mark
  pa_o:                      '〔',         pa_c:                '〕',          #affects paragraph mark
  mk_o:                      '〔',         mk_c:                '〕',          #generic mark
  gl_o:                      '〔',         gl_c:                '〕',          #glyph
  fa_o: '〔', fa_o_c: '¤', fa_c_o: '¤', fa_c: '〕',
  idx_o:                     '▩',         idx_c:               '▩',
  nbsp:                      '░',                                              #'▭ '
  br_line:                   '╱',                                              #lB ▌  9612 ┘ ¶
  br_nl:                     '╲',                                              #lB ▌ 』  ┘
  br_paragraph:              '█',                                              #FB █  9608 # PP ∥  8741 #▐  #'┘' #'¶' #FB █  9608  lB ▌  9612   RB ▐  9616
  br_obj:                    'break_obj',
  br_page_line:              '▭',
  br_page:                   '┼',
  br_page_new:               '╋',
  lnk_o:                     '⌠',          lnk_c:               '⌡',           #'⌈' '⌋' '⌠' '⌡' #Mx[:lnk_o: '◁'; Mx[:lnk_c: '▷' #‹ ›
  url_o:                     '◘',          url_c:               '◙',
  rel_o:                     '⌈',          rel_c:               '⌋',
  tag_o:                     '⌊',          tag_c:               '⌉',
  sm_set_o:                  '◢',          sm_set_c:            '◣',
  sm_subset_o:               '◢',          sm_subset_c:         '◣',
  vline:                     '┆',                                              #  ¦ |
}
Mx[:fa_bold_o]=              "#{Mx[:fa_o]}b#{Mx[:fa_o_c]}"
Mx[:fa_bold_c]=              "#{Mx[:fa_c_o]}b#{Mx[:fa_c]}"
Mx[:fa_italics_o]=           "#{Mx[:fa_o]}i#{Mx[:fa_o_c]}"
Mx[:fa_italics_c]=           "#{Mx[:fa_c_o]}i#{Mx[:fa_c]}"
Mx[:fa_underscore_o]=        "#{Mx[:fa_o]}u#{Mx[:fa_o_c]}"
Mx[:fa_underscore_c]=        "#{Mx[:fa_c_o]}u#{Mx[:fa_c]}"
Mx[:fa_cite_o]=              "#{Mx[:fa_o]}cite#{Mx[:fa_o_c]}"
Mx[:fa_cite_c]=              "#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}"
Mx[:fa_insert_o]=            "#{Mx[:fa_o]}ins#{Mx[:fa_o_c]}"
Mx[:fa_insert_c]=            "#{Mx[:fa_c_o]}ins#{Mx[:fa_c]}"
Mx[:fa_strike_o]=            "#{Mx[:fa_o]}del#{Mx[:fa_o_c]}"
Mx[:fa_strike_c]=            "#{Mx[:fa_c_o]}del#{Mx[:fa_c]}"
Mx[:fa_superscript_o]=       "#{Mx[:fa_o]}sup#{Mx[:fa_o_c]}"
Mx[:fa_superscript_c]=       "#{Mx[:fa_c_o]}sup#{Mx[:fa_c]}"
Mx[:fa_subscript_o]=         "#{Mx[:fa_o]}sub#{Mx[:fa_o_c]}"
Mx[:fa_subscript_c]=         "#{Mx[:fa_c_o]}sub#{Mx[:fa_c]}"
Mx[:fa_hilite_o]=            "#{Mx[:fa_o]}hi#{Mx[:fa_o_c]}"
Mx[:fa_hilite_c]=            "#{Mx[:fa_c_o]}hi#{Mx[:fa_c]}"
Mx[:fa_monospace_o]=         "#{Mx[:fa_o]}mono#{Mx[:fa_o_c]}"
Mx[:fa_monospace_c]=         "#{Mx[:fa_c_o]}mono#{Mx[:fa_c]}"
Mx[:gl_bullet]=              "#{Mx[:gl_o]}●#{Mx[:gl_c]}"
Mx[:br_endnotes]=            "#{Mx[:mk_o]}ENDNOTES#{Mx[:mk_c]}"
Mx[:br_eof]=                 "#{Mx[:mk_o]}EOF#{Mx[:mk_c]}"
Mx[:pa_non_object_dummy_heading]="#{Mx[:pa_o]}-##{Mx[:pa_c]}"                  #unnumbered paragraph, delete when not required [used in dummy headings, eg. for segmented html] (place marker at end of paragraph)
Mx[:pa_non_object_no_heading]="#{Mx[:pa_o]}~##{Mx[:pa_c]}"                     #unnumbered paragraph (place marker at end of paragraph)
Hx={
  br_obj:                    { obj: Mx[:br_obj] },                             # line sep
  br_page_line:              { obj: Mx[:br_page_line] },                       # line across page
  br_page:                   { obj: Mx[:br_page] },                            # newpage
  br_page_new:               { obj: Mx[:br_page_new] },                        # clearpage
}
#Mx[:sm_set_o]='∈ '; Mx[:sm_set_c]='∋ '
#Mx[:sm_subset_o]='∈ '; Mx[:sm_subset_c]='∋ '
Rx={
  mx_fa_clean:               /#{Mx[:fa_o]}.+?#{Mx[:fa_c]}|#{Mx[:pa_o]}.+?#{Mx[:pa_c]}|#{Mx[:mk_o]}.+?#{Mx[:mk_c]}/,
  lv:                        /〔([0-9]):(\S*?)〕/,
  lv_0:                      /#{Mx[:lv_o_0]}(\S*?)#{Mx[:lv_c]}/,
  lv_1:                      /#{Mx[:lv_o_1]}(\S*?)#{Mx[:lv_c]}/,
  lv_2:                      /#{Mx[:lv_o_2]}(\S*?)#{Mx[:lv_c]}/,
  lv_3:                      /#{Mx[:lv_o_3]}(\S*?)#{Mx[:lv_c]}/,
  lv_4:                      /#{Mx[:lv_o_4]}(\S*?)#{Mx[:lv_c]}/,
  lv_5:                      /#{Mx[:lv_o_5]}(\S*?)#{Mx[:lv_c]}/,
  lv_6:                      /#{Mx[:lv_o_6]}(\S*?)#{Mx[:lv_c]}/,
  lv_7:                      /#{Mx[:lv_o_7]}(\S*?)#{Mx[:lv_c]}/,
  lv_8:                      /#{Mx[:lv_o_8]}(\S*?)#{Mx[:lv_c]}/,
  lv_9:                      /#{Mx[:lv_o_9]}(\S*?)#{Mx[:lv_c]}/,
  meta:                      /#{Mx[:meta_o]}(\S+?)#{Mx[:meta_c]}/,
}
Dx={
  ocn_o:                     '「',         ocn_c:                   '」',
  url_o:                     '‹',          url_c:                   '›',
  url_o_xml:                 '&lt;',       url_c_xml:               '&gt;',
  rel_o:                     '‹',          rel_c:                   '›',
  lt_xml:                    '&lt;',       gt_xml:                  '&gt;',
}
Tex={
  backslash:                 "\\\\",
  backslash:                 "\\\\",
  tilde:                     '\\\\\\~',
}
Px={
  bold_o:                    '*',          bold_c:                   '*',
  italics_o:                 '/',          italics_c:                '/',
  underscore_o:              '_',          underscore_c:             '_',
 #emphasis_o:                '*',          emphasis_c:               '*',
 #bold_o:                    '!',          bold_c:                   '!',
  cite_o:                    '"',          cite_c:                   '"',
  insert_o:                  '+',          insert_c:                 '+',
  strike_o:                  '-',          strike_c:                 '-',
  superscript_o:             '^',          superscript_c:            '^',
  subscript_o:               '[',          subscript_c:              ']',
  hilite_o:                  '*',          hilite_c:                 '*',
  monospace_o:               '',           monospace_c:              '',
  po_bold_o:                 '!{',         po_bold_c:                '}!',
  po_italics_o:              '/{',         po_italics_c:             '}/',
  po_underscore_o:           '_{',         po_underscore_c:          '}_',
  po_cite_o:                 '"{',         po_cite_c:                '}"',
  po_insert_o:               '+{',         po_insert_c:              '}+',
  po_strike_o:               '-{',         po_strike_c:              '}-',
  po_superscript_o:          '^{',         po_superscript_c:         '}^',
  po_subscript_o:            ',{',         po_subscript_c:           '},',
  po_hilite_o:               '*{',         po_hilite_c:              '}*',
  po_monospace_o:            '#{',         po_monospace_c:           '}#',
  lng_lst:                   SiSU_is[:language_list],
  lv1:                       '*',
  lv2:                       '=',
  lv3:                       '=',
  lv4:                       '-',
  lv5:                       '.',
  lv6:                       '.',
}
Px[:lng_lst_rgx]=Px[:lng_lst].join('|')
Ep={
  alt:                       :on,
  d_oebps:                   'OEBPS',
  d_image:                   'OEBPS/image',
  d_css:                     'OEBPS/css',
  f_ncx:                     'toc.ncx',
  f_opf:                     'content.opf',
}
$ep=if Ep[:alt]==:on
  {
    o:   'opf:',
    hsp: ' ',
  }
else
  {
    o:   '',
    hsp: '&nbsp;',
  }
end
Db={
  name_prefix:               "SiSU#{SiSU_is[:version_dir]}a_",
  name_prefix_db:            "sisu_#{SiSU_is[:version_dir]}a_",
  col_title:                  800,
  col_title_part:             400,
  col_title_edition:           10,
  col_name:                   600,
  col_creator_misc_short:     100,
  col_language:               100,
  col_language_char:            6,
  col_date_text:               10,
  col_txt_long:               600,
  col_txt_short:              200,
  col_identify_hash:          256,
  col_library:                 30,
  col_small:                   16,
  col_filename:               256,
  col_digest:                  64,
  col_filesize:                10,
  col_info_note:             2500,
}
Gt={
  grotto:                    'sisu_src',
  git:                       'sisu:',
  src:                       'src',
  pods:                      'pods',
  sisupod:                   'sisupod',
  pod:                       'pod',
  files:                     'files',
  doc:                       'doc',
  po:                        'po4a/po',
  pot:                       'po4a/pot',
  image:                     'image',
  audio:                     'audio',
  video:                     'video',
  conf:                      'doc/_sisu',
}
S_CONF={
  header_make: 'sisu_document_make',
  rc_yml: 'sisurc.yml',
}
ANSI_C={
  red:                       "\033[#{31}m",
  green:                     "\033[#{32}m",
  yellow:                    "\033[#{33}m",
  blue:                      "\033[#{34}m",
  fuchsia:                   "\033[#{35}m",
  cyan:                      "\033[#{36}m",
  inv_red:                   "\033[#{41}m",
  inv_green:                 "\033[#{42}m",
  inv_yellow:                "\033[#{43}m",
  inv_blue:                  "\033[#{44}m",
  inv_fuchsia:               "\033[#{45}m",
  inv_cyan:                  "\033[#{46}m",
  b_red:                     "\033[#{91}m",
  b_green:                   "\033[#{92}m",
  b_yellow:                  "\033[#{93}m",
  b_blue:                    "\033[#{94}m",
  b_fuchsia:                 "\033[#{95}m",
  b_cyan:                    "\033[#{96}m",
  off:                       "\033[m"
}
DISABLE={
  epub: {
    internal_navigation:     true,
    per_section_title:       true,
    ncx_navpoint_unique_id:  true,
  },
}
DEVELOPER={
  maintenance:               :false,
}
__END__
utils.rb
consider:
  〔comment〕
  〔links?????〕
   import document?
check:
  bold line

┆┆⋮┇┊┋
『』
「」
〔〕
【】

·
¤
 #˝ " λ Ω  β   α π  Ѫ Ж  Я Ѳ  ѳ   Ф ㈣
 Ѳ  ѳ   Ф
 ♩ ♭   ✠   ▭  ▬  ▪
【】〖〗◢ ◣ ◀ ▶ ◘ ◙
《》「」
 ‹ › ∗ 
'〔lv1〕','〔lv2〕','〔lv3〕','〔lv4〕','〔lv5〕','〔lv6〕','〔lv7〕','〔lv8〕','〔lv9〕'
'〔 Ѳ1〕','〔 Ѳ2〕','〔 Ѳ3〕','〔 Ѳ4〕','〔 Ѳ5〕','〔Ѳ6〕','〔Ѳ7〕','〔Ѳ8〕','〔Ѳ9〕'
◁▷
◀this is text or an image▶ http://
p __FILE__ +':'+ __LINE__.to_s
p __FILE__ + ' ' + __LINE__.to_s + ' ' + html
puts "#{__FILE__} #{__LINE__} #{o.inspect}"
puts __FILE__ + ' ' + __LINE__.to_s + '-->  ' + o.inspect
puts %{-\t#{__FILE__}::#{__LINE__}::#{caller}:\n"#{name}"}
p "\t" + txt.obj + " << #{__FILE__} #{__LINE__} >>"
p (__FILE__ + ' ' + __LINE__.to_s + '--> ' + dob.inspect) if dob.is==:heading
data.each {|o| p (__FILE__ + ' ' + __LINE__.to_s + '--> ' + o.inspect) if o.is==:heading}
puts "#{__FILE__} #{__LINE__} #{para}" if @opt.act[:maintenance][:set]==:on
puts "#{__FILE__} #{__LINE__} #{t_o}" if @opt.act[:maintenance][:set]==:on
 dr ┌  9484   dR ┍  9485   Dr ┎  9486   DR ┏  9487   dl ┐  9488   dL ┑  9489   Dl ┒  9490   LD ┓  9491  ur └  9492   uR ┕  9493   Ur ┖  9494   UR ┗  9495   ul ┘  9496   uL ┙  9497   Ul ┚  9498   UL ┛  9499   vr ├
 dr ┌  9484   dR ┍  9485   Dr ┎  9486   DR ┏  9487   dl ┐  9488   dL ┑  9489   Dl ┒  9490   LD ┓  9491  ur └  9492   uR ┕  9493   Ur ┖  9494   UR ┗  9495   ul ┘  9496   uL ┙  9497   Ul ┚  9498   UL ┛  9499   vr ├
 └  ┘
Iu ⌠  8992   Il ⌡ <7 ⌈  8968   >7 ⌉  8969   7< ⌊  8970   7> ⌋  8971
<" 『 12302  >" 』 12303
<' 「 12300  >' 」 12301
