/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CopyDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/19
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __COPYDLG_H__
#define __COPYDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _COPY_DLG
{
	gint value;
	gdouble x_pitch;			/* ピッチ */
	gdouble y_pitch;			
	gint repeats;				/* 繰り返し回数 */

	GtkWidget *x_pitch_entry;
	GtkWidget *y_pitch_entry;
	GtkWidget *repeats_entry;
	GtkWidget *parent;			
	GtkWidget *dialog;			
};
typedef struct _COPY_DLG COPY_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _COPYDLG_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _COPYDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* コピー【移動/複写】設定 */
gint CopyDialog(COPY_DLG *copy_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __COPYDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CopyDlg.h
 * ====================================================================
 */
