/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file TrayIcon.cxx
    \author Romain BONDUE
    \date 08/07/2006 */
#include "TrayIcon.h"

extern "C"{
#include "eggtrayicon.h"
}



nsGUI::CTrayIcon::CTrayIcon (const std::string& FileName,
                             ::GCallback CallBack, void* pData) throw()
    : m_pTrayIcon (0),
      m_pIcon (0),
      m_pToolTipsGroup (::gtk_tooltips_new()),
      m_CurrentIconFileName (FileName),
      m_CallBack (CallBack),
      m_pCallBackData (pData)
{
} // CTrayIcon()


nsGUI::CTrayIcon::~CTrayIcon () throw()
{
    if (m_pTrayIcon)
        ::gtk_widget_destroy (GTK_WIDGET (m_pTrayIcon));
    ::gtk_object_destroy (GTK_OBJECT (m_pToolTipsGroup));

} // ~CTrayIcon()


void nsGUI::CTrayIcon::Show () throw()
{
    if (!m_pTrayIcon)
    {
        m_pTrayIcon = GTK_WIDGET (::egg_tray_icon_new ("RutilT"));
        m_pIcon = GTK_IMAGE (::gtk_image_new_from_file
                 (m_CurrentIconFileName.c_str()));
        ::GtkWidget* const pEventBox (::gtk_event_box_new());
        ::g_signal_connect_swapped (G_OBJECT (pEventBox), "button-press-event",
                                    m_CallBack, m_pCallBackData);
        ::gtk_container_add (GTK_CONTAINER (pEventBox), GTK_WIDGET (m_pIcon));
        ::gtk_container_add (GTK_CONTAINER (m_pTrayIcon), pEventBox);
        ::gtk_widget_show_all (m_pTrayIcon);
    }

} // Show()


void nsGUI::CTrayIcon::Hide () throw()
{
    if (m_pTrayIcon)
    {
        ::gtk_widget_destroy (m_pTrayIcon);
        m_pTrayIcon = 0;
    }

} // Hide()
