/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDriversRoot.hxx
    \author Romain BONDUE
    \date 19/02/2006
    \warning This file should only be included from RTDriversRoot.h */
inline nsWireless::CRT2400DriverRoot::~CRT2400DriverRoot () throw() {}


inline void nsWireless::CRT2400DriverRoot::SetSSID (const std::string& SSID)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetSSID (SSID);

} // SetSSID()


inline void nsWireless::CRT2400DriverRoot::SetFrequency (double Frequency)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetFrequency (Frequency);

} // SetFrequency()


inline void nsWireless::CRT2400DriverRoot::SetChannel (unsigned Channel)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetChannel (Channel);

} // SetChannel()


inline nsWireless::CEncryptionD nsWireless::CRT2400DriverRoot::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    return CSuWProtocol::GetEncryption();

} // GetEncryption()


inline void nsWireless::CRT2400DriverRoot::SetEncryption
                                                (const CEncryptionD& Descriptor)
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    CSuWProtocol::SetEncryption (Descriptor);

} // SetEncryption()


inline void nsWireless::CRT2400DriverRoot::SetMode (Mode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetMode (Mode);

} // SetMode()


inline void nsWireless::CRT2400DriverRoot::SetTxRate (int TxRate)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetTxRate (TxRate);

} // SetTxRate()


inline void nsWireless::CRT2400DriverRoot::SetAPMacAddr
                                                    (const CMacAddress& Addr)
                                    throw (std::bad_alloc, nsErrors::CSystemExc)
{
    CSuWProtocol::SetAPMacAddr (Addr);

} // SetAPMacAddr()


inline void nsWireless::CRT2400DriverRoot::Scan () throw (nsErrors::CSystemExc)
{
    CSuWProtocol::Scan();

} // Scan()


inline nsWireless::CRT2500DriverRoot::~CRT2500DriverRoot () throw() {}


inline void nsWireless::CRT2500DriverRoot::SetSSID (const std::string& SSID)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetSSID (SSID);

} // SetSSID()


inline void nsWireless::CRT2500DriverRoot::SetFrequency (double Frequency)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetFrequency (Frequency);

} // SetFrequency()


inline void nsWireless::CRT2500DriverRoot::SetChannel (unsigned Channel)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetChannel (Channel);

} // SetChannel()


inline nsWireless::CEncryptionD nsWireless::CRT2500DriverRoot::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    return CSuWProtocol::GetEncryption();

} // GetEncryption()


inline void nsWireless::CRT2500DriverRoot::SetEncryption
                                                (const CEncryptionD& Descriptor)
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    CSuWProtocol::SetEncryption (Descriptor);

} // SetEncryption()


inline void nsWireless::CRT2500DriverRoot::SetMode (Mode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetMode (Mode);

} // SetMode()


inline void nsWireless::CRT2500DriverRoot::SetTxRate (int TxRate)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetTxRate (TxRate);

} // SetTxRate()


inline void nsWireless::CRT2500DriverRoot::SetAPMacAddr
                                                    (const CMacAddress& Addr)
                                    throw (std::bad_alloc, nsErrors::CSystemExc)
{
    CSuWProtocol::SetAPMacAddr (Addr);

} // SetAPMacAddr()


inline void nsWireless::CRT2500DriverRoot::Scan () throw (nsErrors::CSystemExc)
{
    CSuWProtocol::Scan();

} // Scan()


inline nsWireless::CRT2570DriverRoot::~CRT2570DriverRoot () throw() {}


inline void nsWireless::CRT2570DriverRoot::SetSSID (const std::string& SSID)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetSSID (SSID);

} // SetSSID()


inline void nsWireless::CRT2570DriverRoot::SetFrequency (double Frequency)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetFrequency (Frequency);

} // SetFrequency()


inline void nsWireless::CRT2570DriverRoot::SetChannel (unsigned Channel)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetChannel (Channel);

} // SetChannel()


inline nsWireless::CEncryptionD nsWireless::CRT2570DriverRoot::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    return CSuWProtocol::GetEncryption();

} // GetEncryption()


inline void nsWireless::CRT2570DriverRoot::SetEncryption
                                                (const CEncryptionD& Descriptor)
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    CSuWProtocol::SetEncryption (Descriptor);

} // SetEncryption()


inline void nsWireless::CRT2570DriverRoot::SetMode (Mode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetMode (Mode);

} // SetMode()


inline void nsWireless::CRT2570DriverRoot::SetTxRate (int TxRate)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetTxRate (TxRate);

} // SetTxRate()


inline void nsWireless::CRT2570DriverRoot::SetAPMacAddr
        (const CMacAddress& Addr) throw (std::bad_alloc, nsErrors::CSystemExc)
{
    CSuWProtocol::SetAPMacAddr (Addr);

} // SetAPMacAddr()


inline void nsWireless::CRT2570DriverRoot::Scan () throw (nsErrors::CSystemExc)
{
    CSuWProtocol::Scan();

} // Scan()


inline nsWireless::CRT61DriverRoot::~CRT61DriverRoot () throw() {}


inline void nsWireless::CRT61DriverRoot::SetSSID (const std::string& SSID)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetSSID (SSID);

} // SetSSID()


inline void nsWireless::CRT61DriverRoot::SetFrequency (double Frequency)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetFrequency (Frequency);

} // SetFrequency()


inline void nsWireless::CRT61DriverRoot::SetChannel (unsigned Channel)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetChannel (Channel);

} // SetChannel()


inline nsWireless::CEncryptionD nsWireless::CRT61DriverRoot::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    return CSuWProtocol::GetEncryption();

} // GetEncryption()


inline void nsWireless::CRT61DriverRoot::SetEncryption
                                            (const CEncryptionD& Descriptor)
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    CSuWProtocol::SetEncryption (Descriptor);

} // SetEncryption()


inline void nsWireless::CRT61DriverRoot::SetMode (Mode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetMode (Mode);

} // SetMode()


inline void nsWireless::CRT61DriverRoot::SetTxRate (int TxRate)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetTxRate (TxRate);

} // SetTxRate()


inline void nsWireless::CRT61DriverRoot::SetAPMacAddr (const CMacAddress& Addr)
                                    throw (std::bad_alloc, nsErrors::CSystemExc)
{
    CSuWProtocol::SetAPMacAddr (Addr);

} // SetAPMacAddr()


inline void nsWireless::CRT61DriverRoot::Scan () throw (nsErrors::CSystemExc)
{
    UpdateScanTime();
    CSuWProtocol::Scan();

} // Scan()


inline nsWireless::CRT73DriverRoot::~CRT73DriverRoot () throw() {}


inline void nsWireless::CRT73DriverRoot::SetSSID (const std::string& SSID)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetSSID (SSID);

} // SetSSID()


inline void nsWireless::CRT73DriverRoot::SetFrequency (double Frequency)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetFrequency (Frequency);

} // SetFrequency()


inline void nsWireless::CRT73DriverRoot::SetChannel (unsigned Channel)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetChannel (Channel);

} // SetChannel()


inline nsWireless::CEncryptionD nsWireless::CRT73DriverRoot::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    return CSuWProtocol::GetEncryption();

} // GetEncryption()


inline void nsWireless::CRT73DriverRoot::SetEncryption
                                            (const CEncryptionD& Descriptor)
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    CSuWProtocol::SetEncryption (Descriptor);

} // SetEncryption()


inline void nsWireless::CRT73DriverRoot::SetMode (Mode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetMode (Mode);

} // SetMode()


inline void nsWireless::CRT73DriverRoot::SetTxRate (int TxRate)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetTxRate (TxRate);

} // SetTxRate()


inline void nsWireless::CRT73DriverRoot::SetAPMacAddr (const CMacAddress& Addr)
                                    throw (std::bad_alloc, nsErrors::CSystemExc)
{
    CSuWProtocol::SetAPMacAddr (Addr);

} // SetAPMacAddr()


inline void nsWireless::CRT73DriverRoot::Scan () throw (nsErrors::CSystemExc)
{
    UpdateScanTime();
    CSuWProtocol::Scan();

} // Scan()
