use chrono::DateTime;
use chrono_tz::Tz;

use crate::{Accessibility, Leg, ProductsSelection};

/// The type of station board (departures, arrivals)
pub enum StationBoardKind {
    Departures,
    Arrivals,
}

#[derive(Debug, Clone)]
/// The options for [`Provider::station_board`](crate::Provider::station_board)
///
/// A provider can also ignore some of the options if this is not supported by the API.
pub struct StationBoardOptions {
    /// How many results to include.
    pub results: u64,
    /// When should the station board start.
    pub when: Option<DateTime<Tz>>,
    /// How accessible the journey must be.
    pub accessibility: Accessibility,
    /// What products to route with.
    pub products: ProductsSelection,
    /// What language to query with.
    pub language: Option<String>,
}

impl Default for StationBoardOptions {
    fn default() -> Self {
        StationBoardOptions {
            results: 5,
            when: Default::default(),
            accessibility: Default::default(),
            products: Default::default(),
            language: Default::default(),
        }
    }
}

/// The response for [`Provider::station_board`](crate::Provider::station_board)
#[derive(Debug, Clone)]
pub struct StationBoardResponse {
    /// The list of legs which is the result of the request.
    pub legs: Vec<Leg>,
}
