/*
*  RAL -- Rubrica Addressbook Library
*  file: types.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_LOOKUP_TABLE_H
#define _R_LOOKUP_TABLE_H

#include <glib.h>


typedef struct _lookuptable {
  gchar* str;
  gchar* lbl;
  gint   val;
} RLookupTable;


typedef struct _pairtable {
  gchar* str;
  gint   left;
  gint   right;
} RPairTable;


gint   r_lookup_table_str2enum (RLookupTable *table, gchar* str);
gchar* r_lookup_table_enum2str (RLookupTable *table, gint value);

gchar* r_lookup_table_str2lbl  (RLookupTable *table, gchar* str);
gchar* r_lookup_table_enum2lbl (RLookupTable *table, gint value);


gint   r_lookup_table_get_pair_left  (RPairTable *table, gint item);
gint   r_lookup_table_get_pair_right (RPairTable *table, gint item);
gchar* r_lookup_table_pair2str       (RPairTable *table, gint item);

#endif
