#include "rheolef/rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

point g (const point& x) { 
	Float r = sqrt(sqr(x[0])+sqr(x[1]));
	return point(-x[1],x[0])/sqr(r);
}
int main(int argc, char**argv) {
  geo  omega (argv[1]);
  space Vh (omega, "P2", "vector");
  space Qh  (omega, "P1");
  domain boundary = omega.boundary();
  Vh.block(boundary);
  space Wi (omega, boundary,  "P2");
  space Wh = Wi*Wi;
  field uh (Vh);
  uh[boundary]  = interpolate (Wh, g);
  field ph (Qh, 0.);
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div");
  int   max_iter  = 50;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
  
  field pi_h_u = interpolate (Vh, g);
  cout << catchmark("ue")  << pi_h_u;
  field eh = pi_h_u - uh;
  cout << catchmark("err")  << eh;
  form m (Vh, Vh, "mass");
  Float error_linf = eh.max_abs();
  Float error_l2   = sqrt(m(eh,eh));
  cerr << "error_linf = " << error_linf << endl;
  cerr << "error_l2   = " << error_l2   << endl;

  field nue = sqrt(sqr(field(pi_h_u[0])) + sqr(field(pi_h_u[1])));
  field nuh = sqrt(sqr(field(uh[0])) + sqr(field(uh[1])));
  cout << catchmark("nue")  << nue;
  cout << catchmark("nu")   << nuh;
  return 0;
}
