# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from GatewaySensorManager.idl.

use strict;

package Raritan::RPC::peripheral::GatewaySensorManager_2_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "peripheral.GatewaySensorManager:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::peripheral::GatewaySensorManager_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant MODBUS_VENDOR_NAME => 0;

use constant MODBUS_PRODUCT_CODE => 1;

use constant MODBUS_REVISION => 2;

use constant MODBUS_VENDOR_URL => 3;

use constant MODBUS_PRODUCT_NAME => 5;

use constant MODBUS_MODEL_NAME => 6;

use constant MODBUS_APP_NAME => 7;

use Raritan::RPC::peripheral::GatewaySensorManager_2_0_0::ConfigurationPackage;

sub getConfiguration($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getConfiguration', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::peripheral::GatewaySensorManager_2_0_0::ConfigurationPackage::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'});
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

use constant ERR_CONFIG_INCONSISTENT => 1;

use constant ERR_CONFIG_STORAGE_FAILED => 2;

use Raritan::RPC::peripheral::GatewaySensorManager_2_0_0::ConfigurationPackage;

sub setConfiguration($$) {
    my ($self, $cfg) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'cfg'} = [];
    foreach my $key0 (keys %{$cfg}) {
        my $value0 = $cfg->{$key0};
        my $elem0 = {};
        $elem0->{'key'} = "$key0";
        $elem0->{'value'} = Raritan::RPC::peripheral::GatewaySensorManager_2_0_0::ConfigurationPackage::encode($value0);
        push(@{$args->{'cfg'}}, $elem0);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setConfiguration', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::peripheral::GatewaySensorManager_2_0_0::Feedback;

sub getFeedback($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getFeedback', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ValObjCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'peripheral.GatewaySensorManager_2_0_0.Feedback');
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('peripheral.GatewaySensorManager', 2, 0, 0, 'Raritan::RPC::peripheral::GatewaySensorManager_2_0_0');
1;
