% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wk-crs.R
\name{wk_crs_inherit}
\alias{wk_crs_inherit}
\alias{wk_crs_longlat}
\alias{wk_crs_auto}
\alias{wk_crs_auto_value}
\title{Special CRS values}
\usage{
wk_crs_inherit()

wk_crs_longlat(crs = NULL)

wk_crs_auto()

wk_crs_auto_value(x, crs)
}
\arguments{
\item{crs}{A value for the coordinate reference system supplied by
the user.}

\item{x}{A raw input to a construuctor whose length and crs attributte
is used to determine the default CRS returned by \code{\link[=wk_crs_auto]{wk_crs_auto()}}.}
}
\description{
The CRS handling in the wk package requires two sentinel CRS values.
The first, \code{\link[=wk_crs_inherit]{wk_crs_inherit()}}, signals that the vector should inherit
a CRS of another vector if combined. This is useful for empty, \code{NULL},
and/or zero-length geometries. The second, \code{\link[=wk_crs_auto]{wk_crs_auto()}}, is used
as the default argument of \code{crs} for constructors so that zero-length
geometries are assigned a CRS of \code{wk_crs_inherit()} by default.
}
\examples{
wk_crs_auto_value(list(), wk_crs_auto())
wk_crs_auto_value(list(), 1234)
wk_crs_auto_value(list(NULL), wk_crs_auto())

}
