% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd-plot.R
\name{plot.wk_grd_xy}
\alias{plot.wk_grd_xy}
\alias{plot.wk_grd_rct}
\title{Plot grid objects}
\usage{
\method{plot}{wk_grd_xy}(x, ...)

\method{plot}{wk_grd_rct}(
  x,
  ...,
  image = NULL,
  interpolate = FALSE,
  oversample = 4,
  border = NA,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  add = FALSE
)
}
\arguments{
\item{x}{A \code{\link[=wkb]{wkb()}} or \code{\link[=wkt]{wkt()}}}

\item{...}{Passed to plotting functions for features: \code{\link[graphics:points]{graphics::points()}}
for point and multipoint geometries, \code{\link[graphics:lines]{graphics::lines()}} for linestring
and multilinestring geometries, and \code{\link[graphics:polypath]{graphics::polypath()}} for polygon
and multipolygon geometries.}

\item{image}{A raster or nativeRaster to pass to \code{\link[graphics:rasterImage]{graphics::rasterImage()}}.
use \code{NULL} to do a quick-and-dirty rescale of the data such that the low
value is black and the high value is white.}

\item{interpolate}{Use \code{TRUE} to perform interpolation between color values.}

\item{oversample}{A scale on the number of pixels on the device to use for
sampling estimation of large raster values. Use \code{Inf} to disable.}

\item{border}{Color to use for polygon borders. Use \code{NULL} for the default
and \code{NA} to skip plotting borders.}

\item{asp, xlab, ylab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{bbox}{The limits of the plot as a \code{\link[=rct]{rct()}} or compatible object}

\item{add}{Should a new plot be created, or should \code{handleable} be added to the
existing plot?}
}
\value{
\code{x}, invisibly.
}
\description{
Plot grid objects
}
\examples{
plot(grd_rct(volcano))
plot(grd_xy(volcano))

}
