% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematic.R
\name{thematic_with_theme}
\alias{thematic_with_theme}
\alias{thematic_local_theme}
\alias{thematic_set_theme}
\alias{thematic_get_theme}
\alias{thematic_get_option}
\alias{thematic_get_mixture}
\title{Tools for getting and restoring global state}
\usage{
thematic_with_theme(theme, expr)

thematic_local_theme(theme, .local_envir = parent.frame())

thematic_set_theme(theme)

thematic_get_theme(resolve = TRUE)

thematic_get_option(name = "", default = NULL, resolve = TRUE)

thematic_get_mixture(amounts = 0.5, default = NULL)
}
\arguments{
\item{theme}{a \code{thematic_theme()} object (or a return value of \link{thematic_on}/\code{\link[=thematic_get_theme]{thematic_get_theme()}})
or \code{NULL} (in which case \code{thematic_off()} is called).}

\item{expr}{R code that produces a plot.}

\item{.local_envir}{The environment to use for scoping.}

\item{resolve}{whether or not \code{'auto'} values should be resolved before returning}

\item{name}{a theme element name (e.g., \code{fg}, \code{bg}, etc.)}

\item{default}{a default value to return in the event no thematic theme is active.}

\item{amounts}{value(s) between 0 and 1 specifying how much to mix \code{bg} (0) and \code{fg} (1).}
}
\value{
the result of \code{expr}.
}
\description{
These functions are helpful for getting and/or temporarily activating a
\code{\link[=thematic_theme]{thematic_theme()}}.
}
\section{Functions}{
\itemize{
\item \code{thematic_with_theme()}: similar to \code{\link[=thematic_on]{thematic_on()}}, but for an single plot.

\item \code{thematic_local_theme()}: similar to \code{\link[=thematic_with_theme]{thematic_with_theme()}}, but de-couples
the theme from the plot expression.

\item \code{thematic_set_theme()}: set a given \code{theme} object as the current theme.

\item \code{thematic_get_theme()}: obtain the current \code{theme}.

\item \code{thematic_get_option()}: obtain a particular \code{theme} option (and provide a \code{default}
if no \code{theme} is active).

\item \code{thematic_get_mixture()}: obtain a mixture of the current \code{theme}'s \code{bg} and \code{fg}.

}}
\examples{

# Use thematic_with_theme() for a one-time use of thematic
thematic_with_theme(
  thematic_theme("darkblue", "skyblue", accent = "red"),
  plot(1:10, col = thematic_get_option("accent"), pch = 19)
)

# Use thematic_set_theme() if doing something more complicated
# like programming on top thematic (without causing side effects)
my_plot <- function(expr, las = 3, ...) {
  old_theme <- thematic_on("black", "white")
  on.exit(thematic_set_theme(old_theme), add = TRUE)
  opts <- par(las = las)
  on.exit(par(opts), add = TRUE)
  # Imagine some more customization with ...
  force(expr)
}
my_plot(plot(1:10))

thematic_off()
thematic_get_option("bg", "white")
thematic_on(bg = "red")
thematic_get_option("bg", "white")
thematic_off()

thematic_with_theme(
  thematic_theme("darkblue", "skyblue"),
  scales::show_col(thematic_get_mixture(seq(0, 1, by = 0.1)))
)

}
