% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{subset.Assay}
\alias{subset.Assay}
\title{Subset an Assay}
\usage{
\method{subset}{Assay}(x, cells = NULL, features = NULL, ...)
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{cells}{Cell names}

\item{features}{Feature names}

\item{...}{Ignored}
}
\value{
\code{x} with just the cells and features specified by
\code{cells} and \code{features}
}
\description{
Subset an Assay
}
\examples{
rna <- pbmc_small[["RNA"]]
rna2 <- subset(rna, features = VariableFeatures(rna))
rna2

}
\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{split.Assay}()}
}
\concept{assay}
