% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threads.R
\name{setRcppMLthreads}
\alias{setRcppMLthreads}
\title{Set the number of threads RcppML should use}
\usage{
setRcppMLthreads(threads)
}
\arguments{
\item{threads}{number of threads to be used in RcppML functions that are parallelized with OpenMP.}
}
\description{
The number of threads is 0 by default (corresponding to all available threads), but can be set manually using this function. If you clear environment variables or affect the "RcppMLthreads" environment variable specifically, you will need to set your number of preferred threads again.
}
\details{
The number of threads set affects OpenMP parallelization only for functions in the RcppML package. It does not affect other R packages that use OpenMP. Parallelization is used for projection of linear factor models with rank > 2, calculation of mean squared error for linear factor models, and for divisive clustering.
}
\examples{
\dontrun{
# set serial configuration
setRcppMLthreads(1)
getRcppMLthreads()

# restore default parallel configuration, 
# letting OpenMP decide how many threads to use
setRcppMLthreads(0)
getRcppMLthreads()
}
}
\seealso{
\code{\link{getRcppMLthreads}}
}
\author{
Zach DeBruine
}
