% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{plotly-shiny}
\alias{plotly-shiny}
\alias{plotlyOutput}
\alias{renderPlotly}
\title{Shiny bindings for plotly}
\usage{
plotlyOutput(outputId, width = "100\%", height = "400px", inline = FALSE)

renderPlotly(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended. Note that, for height, using "auto"
or "100\%" generally will not work as expected, because of how
height is computed with HTML/CSS.}

\item{inline}{use an inline (\code{span()}) or block container
(\code{div()}) for the output}

\item{expr}{An expression that generates a plotly}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using plotly within Shiny
applications and interactive Rmd documents.
}
