% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_geometry.R
\name{write_geometry}
\alias{write_geometry}
\title{Write geometries and attributes to NetCDF-CF}
\usage{
write_geometry(
  nc_file,
  geom_data,
  instance_dim_name = NULL,
  variables = list()
)
}
\arguments{
\item{nc_file}{\code{character} file path to the nc file to be created.}

\item{geom_data}{sf \code{data.frame} with POINT, LINESTRING, MULTILINESTRING, 
POLYGON, or MULTIPOLYGON geometries. Note that three dimensional geometries 
are not supported. sp geometries will be coerced to sf with sf::as_Spatial.}

\item{instance_dim_name}{\code{character} Not required if adding geometry to a 
NetCDF-CF Discrete Sampling Geometries timeSeries file. For a new file, will 
use package default -- "instance" -- if not supplied.}

\item{variables}{\code{character} If a an existing netCDF files is provided, this 
list of variables that should be related to the geometries.}
}
\description{
Creates a file with point, line or polygon instance data ready for the 
extended NetCDF-CF timeSeries featuretype format.

Will also add attributes if provided data has them.
}
\examples{

hucPolygons <- sf::read_sf(system.file('extdata','example_huc_eta.json', package = 'ncdfgeom'))

hucPolygons_nc <- ncdfgeom::write_geometry(nc_file=tempfile(), 
                                           geom_data = hucPolygons)
try({
  ncdump <- system(paste("ncdump -h", hucPolygons_nc), intern = TRUE)
  cat(ncdump ,sep = "\n")
}, silent = TRUE)

}
\references{
\enumerate{
  \item \url{http://cfconventions.org/cf-conventions/cf-conventions.html}
}
}
