% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.regression.R
\name{binreg}
\alias{binreg}
\title{Binomial Regression for censored competing risks data}
\usage{
binreg(formula, data, cause = 1, time = NULL, beta = NULL,
  offset = NULL, weights = NULL, cens.weights = NULL,
  cens.model = ~+1, se = TRUE, kaplan.meier = TRUE, cens.code = 0,
  no.opt = FALSE, method = "nr", ...)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest}

\item{time}{time of interest}

\item{beta}{starting values}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{cens.weights}{censoring weights}

\item{cens.model}{stratified cox model}

\item{se}{to compute se's  based on IPCW}

\item{kaplan.meier}{uses Kaplan-Meier for baseline than standard Cox}

\item{cens.code}{gives censoring code}

\item{no.opt}{to not optimize}

\item{method}{for optimization}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Simple version of comp.risk function of timereg for just one time-point thus fitting the model 
\deqn{P(T \leq t, \epsilon=1 | X ) = expit( X^T beta) }
}
\details{
Based on binomial regresion IPCW response estimating equation: 
\deqn{ X ( \Delta I(T \leq t, \epsilon=1 )/G_c(T_i-) - expit( X^T beta)) = 0 }
for IPCW adjusted responses.
}
\examples{

data(bmt)
# logistic regresion with IPCW binomial regression 
out <- binreg(Event(time,cause)~tcell+platelet,bmt,time=50)
summary(out)
predict(out,data.frame(tcell=c(0,1),platelet=c(1,1)),se=TRUE)

outs <- binreg(Event(time,cause)~tcell+platelet,bmt,time=50,cens.model=~strata(tcell,platelet))
summary(outs)

}
\author{
Thomas Scheike
}
