% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_cluster.R
\name{fortify.silhouette}
\alias{fortify.silhouette}
\title{Convert \code{cluster::silhouette} to \code{data.frame}}
\usage{
\method{fortify}{silhouette}(model, data = NULL, ...)
}
\arguments{
\item{model}{Silhouette instance}

\item{data}{original dataset, if needed}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{cluster::silhouette} to \code{data.frame}
}
\examples{
\dontrun{
fortify(cluster::silhouette(cluster::pam(iris[-5], 3)))
fortify(cluster::silhouette(cluster::clara(iris[-5], 3)))
fortify(cluster::silhouette(cluster::fanny(iris[-5], 3)))

mod = stats::kmeans(iris[-5], 3)
fortify(cluster::silhouette(mod$cluster, stats::dist(iris[-5])))
}
}
