require("fitdistrplus")
require("actuar")

x <- c(3.1334614, 1.0300544, 0.8839272, 0.7503320, 1.9378476, 1.7571313, 0.5369516, 
       3.1181863, 1.7412457, 1.1514215, 1.6252670, 1.3333488, 3.0594471, 1.0479867, 
       0.4466562, 0.4387154, 1.5234127, 1.5476924, 1.3279816, 1.3978141)
ft_igam <- fitdist(x, "invgamma")

x <- c(2.3,0.1,2.7,2.2,0.4,2.6,0.2,1.,7.3,3.2,0.8,1.2,33.7,14.,
       21.4,7.7,1.,1.9,0.7,12.6,3.2,7.3,4.9,4000.,2.5,6.7,3.,63.,
       6.,1.6,10.1,1.2,1.5,1.2,30.,3.2,3.5,1.2,0.2,1.9,0.7,17.,
       2.8,4.8,1.3,3.7,0.2,1.8,2.6,5.9,2.6,6.3,1.4,0.8)
ft_llogis <- fitdist(x,"llogis")


x <- c(0.3837053, 0.8576858, 0.3552237, 0.6226119, 0.4783756, 0.3139799, 0.4051403, 
       0.4537631, 0.4711057, 0.5647414, 0.6479617, 0.7134207, 0.5259464, 0.5949068, 
       0.3509200, 0.3783077, 0.5226465, 1.0241043, 0.4384580, 1.3341520)
ft_iw <- fitdist(x,"invweibull")


x <- c(2.06832800,  0.80102221,  9.32589765,  4.31776597,  1.10230717,  2.06120589, 
       1.17598984,  0.49806928, 27.25326920,  0.03468531,  1.92468452,  0.07877918,  
       0.58094911,  0.31080116, 3.86929105,  1.05732456,  3.06687014,  7.48990404,  
       0.18640324,  2.50568830)
#equivalent to Pareto type 2
ft_par2 <- fitdist(x, "pareto") 

x <- c(1.083905, 1.266773, 1.044362, 1.557070, 1.227676, 1.195054, 1.241101, 
       1.224004, 1.014631, 1.173721, 1.051038, 1.104520, 1.133755, 1.051605, 
       1.081230, 1.123193, 1.005997, 1.044696, 1.155369, 1.039439)

#equivalent to Pareto type 1                  
ft_par1 <-fitdist(x, "pareto1", upper=c(Inf, min(x)), fix.arg=list(min = 1),
                  control=list(trace=1, REPORT=1), silent=FALSE) 
