% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf-package.R
\docType{data}
\name{SPEA2minstoptimeRichmond}
\alias{SPEA2minstoptimeRichmond}
\title{Results of SPEA2 when minimising electrical cost and maximising the
minimum idle time of pumps on Richmond water network.}
\format{A data frame as produced by \code{\link{read.data.sets}}. The second
 column measures time in seconds and corresponds to a maximisation problem.}
\source{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}. Operational Optimisation of Water Distribution
 Networks. PhD thesis, School of Engineering and the Built Environment,
 Edinburgh Napier University, UK, 2009.
}
\usage{
SPEA2minstoptimeRichmond
}
\description{
The data has the only goal of providing an example of use of eafplot.
}
\examples{
data(HybridGA)
data(SPEA2minstoptimeRichmond)
SPEA2minstoptimeRichmond[,2] <- SPEA2minstoptimeRichmond[,2] / 60
eafplot (SPEA2minstoptimeRichmond, xlab = expression(C[E]),
        ylab = "Minimum idle time (minutes)",
        las = 1, log = "y", maximise = c(FALSE, TRUE))

}
\keyword{datasets}
