% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-meta-get-rows-affected.R
\docType{data}
\name{spec_meta_get_rows_affected}
\alias{spec_meta_get_rows_affected}
\title{spec_meta_get_rows_affected}
\value{
\code{dbGetRowsAffected()} returns a scalar number (integer or numeric),
the number of rows affected by a data manipulation statement
issued with \code{\link[=dbSendStatement]{dbSendStatement()}}.
The value is available directly after the call
and does not change after calling \code{\link[=dbFetch]{dbFetch()}}.
\code{NA_integer_} or \code{NA_numeric_} are allowed if the number of rows affected is not known.

For queries issued with \code{\link[=dbSendQuery]{dbSendQuery()}},
zero is returned before
and after the call to \code{dbFetch()}.
\code{NA} values are not allowed.
}
\description{
spec_meta_get_rows_affected
}
\section{Failure modes}{

Attempting to get the rows affected for a result set cleared with
\code{\link[=dbClearResult]{dbClearResult()}} gives an error.
}

\seealso{
Other meta specifications: 
\code{\link{spec_get_info}},
\code{\link{spec_meta_bind}},
\code{\link{spec_meta_column_info}},
\code{\link{spec_meta_get_row_count}},
\code{\link{spec_meta_get_statement}},
\code{\link{spec_meta_has_completed}},
\code{\link{spec_meta_is_valid}}
}
\concept{meta specifications}
