% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDataFrame.R
\name{checkDataFrame}
\alias{checkDataFrame}
\alias{check_data_frame}
\alias{assertDataFrame}
\alias{assert_data_frame}
\alias{testDataFrame}
\alias{test_data_frame}
\alias{expect_data_frame}
\title{Check if an argument is a data frame}
\usage{
checkDataFrame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

check_data_frame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

assertDataFrame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_data_frame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testDataFrame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

test_data_frame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

expect_data_frame(
  x,
  types = character(0L),
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{types}{[\code{character}]\cr
Character vector of class names. Each list element must inherit
from at least one of the provided types.
The types \dQuote{logical}, \dQuote{integer}, \dQuote{integerish}, \dQuote{double},
\dQuote{numeric}, \dQuote{complex}, \dQuote{character}, \dQuote{factor}, \dQuote{atomic}, \dQuote{vector}
\dQuote{atomicvector}, \dQuote{array}, \dQuote{matrix}, \dQuote{list}, \dQuote{function},
\dQuote{environment} and \dQuote{null} are supported.
For other types \code{\link[base]{inherits}} is used as a fallback to check \code{x}'s inheritance.
Defaults to \code{character(0)} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are columns with only missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{max.rows}{[\code{integer(1)}]\cr
Maximum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{max.cols}{[\code{integer(1)}]\cr
Maximum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to test for a specific set of names.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertDataFrame}/\code{assert_data_frame} return 
 \code{x} invisibly, whereas
 \code{checkDataFrame}/\code{check_data_frame} and 
 \code{testDataFrame}/\code{test_data_frame} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertDataFrame}/\code{assert_data_frame}
 throws an error message, 
 \code{testDataFrame}/\code{test_data_frame}
 returns \code{FALSE},
 and \code{checkDataFrame}/\code{check_data_frame} 
 return a string with the error message.
 The function \code{expect_data_frame} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a data frame
}
\examples{
testDataFrame(iris)
testDataFrame(iris, types = c("numeric", "factor"), min.rows = 1, col.names = "named")
}
\seealso{
Other compound: 
\code{\link{checkArray}()},
\code{\link{checkDataTable}()},
\code{\link{checkMatrix}()},
\code{\link{checkTibble}()}

Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkAtomic}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDate}()},
\code{\link{checkDouble}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFormula}()},
\code{\link{checkFunction}()},
\code{\link{checkIntegerish}()},
\code{\link{checkInteger}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkMatrix}()},
\code{\link{checkNull}()},
\code{\link{checkNumeric}()},
\code{\link{checkPOSIXct}()},
\code{\link{checkRaw}()},
\code{\link{checkVector}()}
}
\concept{basetypes}
\concept{compound}
