% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adephylo-package.R
\docType{data}
\name{lizards}
\alias{lizards}
\title{Phylogeny and quantitative traits of lizards}
\format{\code{lizards} is a list containing the 3 following objects :
\describe{ \item{traits}{is a data frame with 18 species and 8 traits.}
\item{hprA}{is a character string giving the phylogenetic tree (hypothesized
phylogenetic relationships based on immunological distances) in Newick
format.} \item{hprB}{is a character string giving the phylogenetic tree
(hypothesized phylogenetic relationships based on morphological
characteristics) in Newick format.} }}
\description{
This data set describes the phylogeny of 18 lizards as reported by Bauwens
and D\'iaz-Uriarte (1997). It also gives life-history traits corresponding
to these 18 species.
}
\details{
Variables of \code{lizards$traits} are the following ones : mean.L (mean
length (mm)), matur.L (length at maturity (mm)), max.L (maximum length
(mm)), hatch.L (hatchling length (mm)), hatch.m (hatchling mass (g)),
clutch.S (Clutch size), age.mat (age at maturity (number of months of
activity)), clutch.F (clutch frequency).
}
\note{
This dataset replaces the former version in ade4.
}
\examples{

\dontrun{
if(require(ape) && require(phylobase)){

## see data
data(lizards)
liz.tr <- read.tree(tex=lizards$hprA) # make a tree
liz <- phylo4d(liz.tr, lizards$traits) # make a phylo4d object
table.phylo4d(liz)

## compute and plot principal components
if(require(ade4)){
liz.pca1 <- dudi.pca(lizards$traits, cent=TRUE,
   scale=TRUE, scannf=FALSE, nf=2) # PCA of traits
myPC <- phylo4d(liz.tr, liz.pca1$li) # store PC in a phylo4d object
varlab <- paste("Principal \\ncomponent", 1:2) # make labels for PCs
table.phylo4d(myPC, ratio=.8, var.lab=varlab) # plot the PCs
add.scatter.eig(liz.pca1$eig,2,1,2,posi="topleft", inset=c(0,.15))
title("Phylogeny and the principal components")

## compute a pPCA ##
## remove size effect
temp <- lapply(liz.pca1$tab, function(e) residuals(lm(e~-1+liz.pca1$li[,1])) )
temp <- data.frame(temp)
row.names(temp) <- tipLabels(liz)

## build corresponding phylo4d object
liz.noSize <- phylo4d(liz.tr, temp)
ppca1 <- ppca(liz.noSize, method="Abouheif", scale=FALSE, scannf=FALSE)
plot(ppca1)

}
}
}

}
\references{
Bauwens, D., and D\'iaz-Uriarte, R. (1997) Covariation of
life-history traits in lacertid lizards: a comparative study.
\emph{American Naturalist}, \bold{149}, 91--111.

See a data description at \url{http://pbil.univ-lyon1.fr/R/pdf/pps063.pdf}
(in French).
}
\keyword{datasets}
