% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRare.R
\name{plotRare}
\alias{plotRare}
\title{Plot of rarefaction effect}
\usage{
plotRare(obj, cl = NULL, ...)
}
\arguments{
\item{obj}{A MRexperiment object with count data or matrix.}

\item{cl}{Vector of classes for various samples.}

\item{...}{Additional plot arguments.}
}
\value{
Library size and number of detected features
}
\description{
This function plots the number of observed features vs. the depth of coverage.
}
\examples{

data(mouseData)
cl = factor(pData(mouseData)[,3])
res = plotRare(mouseData,cl=cl,pch=21,bg=cl)
tmp=lapply(levels(cl), function(lv) lm(res[,"ident"]~res[,"libSize"]-1, subset=cl==lv))
for(i in 1:length(levels(cl))){
   abline(tmp[[i]], col=i)
}
legend("topleft", c("Diet 1","Diet 2"), text.col=c(1,2),box.col=NA)

}
\seealso{
\code{\link{plotOrd}}, \code{\link{plotMRheatmap}}, \code{\link{plotCorr}}, \code{\link{plotOTU}}, \code{\link{plotGenus}}
}
