// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/viz/common/quads/largest_draw_quad.h"

#include <stddef.h>

#include <algorithm>

#include "components/viz/common/quads/debug_border_draw_quad.h"
#include "components/viz/common/quads/picture_draw_quad.h"
#include "components/viz/common/quads/render_pass_draw_quad.h"
#include "components/viz/common/quads/solid_color_draw_quad.h"
#include "components/viz/common/quads/stream_video_draw_quad.h"
#include "components/viz/common/quads/surface_draw_quad.h"
#include "components/viz/common/quads/texture_draw_quad.h"
#include "components/viz/common/quads/tile_draw_quad.h"
#include "components/viz/common/quads/yuv_video_draw_quad.h"

namespace {

template <typename...>
struct MaxSize {};
template <class T, class... Args>
struct MaxSize<T, Args...> {
  static constexpr size_t value = sizeof(T) > MaxSize<Args...>::value
                                      ? sizeof(T)
                                      : MaxSize<Args...>::value;
};
template <>
struct MaxSize<> {
  static constexpr size_t value = 0;
};

constexpr size_t kLargestDrawQuadSize = MaxSize<viz::DebugBorderDrawQuad,
                                                viz::PictureDrawQuad,
                                                viz::RenderPassDrawQuad,
                                                viz::SolidColorDrawQuad,
                                                viz::StreamVideoDrawQuad,
                                                viz::SurfaceDrawQuad,
                                                viz::TextureDrawQuad,
                                                viz::TileDrawQuad,
                                                viz::YUVVideoDrawQuad>::value;

template <typename...>
struct MaxAlign {};
template <class T, class... Args>
struct MaxAlign<T, Args...> {
  static constexpr size_t value = alignof(T) > MaxAlign<Args...>::value
                                      ? alignof(T)
                                      : MaxAlign<Args...>::value;
};
template <>
struct MaxAlign<> {
  static constexpr size_t value = 0;
};

constexpr size_t kLargestDrawQuadAlignment =
    MaxAlign<viz::DebugBorderDrawQuad,
             viz::PictureDrawQuad,
             viz::RenderPassDrawQuad,
             viz::SolidColorDrawQuad,
             viz::StreamVideoDrawQuad,
             viz::SurfaceDrawQuad,
             viz::TextureDrawQuad,
             viz::TileDrawQuad,
             viz::YUVVideoDrawQuad>::value;

}  // namespace

namespace viz {

size_t LargestDrawQuadSize() {
  return kLargestDrawQuadSize;
}

size_t LargestDrawQuadAlignment() {
  return kLargestDrawQuadAlignment;
}

}  // namespace viz
