/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "configdialog.h"
#include "configparams.h"

#include <QPushButton>
#include <QComboBox>
#include <QSettings>
#include <QImage>
#include <QImageWriter>
#include "global.h"
#include "supportfunctions.h"
#include "videocapture.h"
#include "rigcontrol.h"

/**
	\class configDialog 
	
	The configDialog provides access to the application-wide configuration parameters.
*/



/**
  constructor for configDialog
*/
configDialog::configDialog(QWidget *, const char *) :Ui::configForm()
{
	setupUi(this);
  int i=0;
  setModal(FALSE);
  foreach (QByteArray format, QImageWriter::supportedImageFormats())
    {
      QString text = tr("%1").arg(QString(format));
      defaultImageFormatComboBox->addItem(text);
      ftpDefaultImageFormatComboBox->addItem(text);
    }
  for(i=0;i<(NUMSSTVMODES-1);i++) // exclude Calibrate
    {
      repeaterTxModeComboBox->addItem(getSSTVModeNameLong((esstvMode)i));
    }
  readSettings();
	connect(rxImagesPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseRxImagesPath()));
	connect(txImagesPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseTxImagesPath()));
	connect(templatesPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseTemplatesPath()));
  connect(audioPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseAudioPath()));
	connect(docPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseDocPath()));
  connect(rp1BrowseButton,SIGNAL(clicked()),SLOT(slotRp1BrowseButton()));
  connect(rp2BrowseButton,SIGNAL(clicked()),SLOT(slotRp2BrowseButton()));
  connect(rp3BrowseButton,SIGNAL(clicked()),SLOT(slotRp3BrowseButton()));
  connect(rp4BrowseButton,SIGNAL(clicked()),SLOT(slotRp4BrowseButton()));
  connect(repeaterTemplateBrowseButton,SIGNAL(clicked()),SLOT(slotRepeaterTemplateBrowseButton()));
  connect(idleTemplateBrowseButton,SIGNAL(clicked()),SLOT(slotIdleTemplateBrowseButton()));
  connect(enablePTTCheckBox,SIGNAL(clicked()),SLOT(slotEnableCAT()));
  connect(enablePTTCheckBox,SIGNAL(clicked()),SLOT(slotEnablePTT()));
}

/**
	destructor for configDialog
*/
configDialog::~configDialog()
{
}

/** read variables from config file

	Read the config file and initializes the variables. If not found, default values will be used.
	\sa writeSettings
	
*/
void configDialog::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("Config");
  myCallsign=qSettings.value("callsign",QString("NOCALL")).toString();
  myQth=qSettings.value("qth",QString("NOWHERE")).toString();
  myLastname=qSettings.value("lastname",QString("NONAME")).toString();
  myFirstname=qSettings.value("firstname",QString("NOFIRSTNAME")).toString();
  myLocator=qSettings.value("locator",QString("NOLOCATOR")).toString();

	rxImagesPath=qSettings.value("rxImagesPath",QString(getenv("HOME"))+"/").toString();
	txImagesPath=qSettings.value("txImagesPath",QString(getenv("HOME"))+"/").toString();
	templatesPath=qSettings.value("templatesPath",QString(getenv("HOME"))+"/").toString();
	audioPath=qSettings.value("audioPath",QString(getenv("HOME"))+"/").toString();
	docPath  =qSettings.value("docPath",QString("/usr/share/doc/qsstv/")).toString();
	defaultImageFormat=qSettings.value("defaultImageFormat","png").toString();
	samplingrate=qSettings.value("samplingrate",11025).toInt();
	rxClock=qSettings.value("rxclock",11025.).toDouble();
	txClock=qSettings.value("txclock",11025.).toDouble();
	inputAudioDevice=qSettings.value("inputAudioDevice","default").toString();
	outputAudioDevice=qSettings.value("outputAudioDevice","default").toString();
	serialPort=qSettings.value("serialPort","/dev/ttyS0").toString();
  radioModel=qSettings.value("radioModel","dummy").toString();
  civAddress=qSettings.value("civAddress",0x70).toInt();
  baudrate=qSettings.value("baudrate",9600).toInt();
  parity=qSettings.value("parity","None").toString();
  stopbits=qSettings.value("stopbits",1).toInt();
  databits=qSettings.value("databits",8).toInt();
  handshake=qSettings.value("handshake","None").toString();

  enableCAT=qSettings.value("enableCAT",0).toBool();
  enableSerialPTT=qSettings.value("enableSerialPTT",0).toBool();
  pttSerialPort=qSettings.value("pttSerialPort",pttSerialPort).toString();

	cwText=qSettings.value("cwtext","").toString();
	cwTone=qSettings.value("cwtone",800).toInt();
	cwWPM=qSettings.value("cwWPM",12).toInt();
	enableFTP=qSettings.value("enableFTP",FALSE).toBool();
	ftpPort=qSettings.value("ftpPort",21).toInt();
	ftpRemoteHost=qSettings.value("ftpRemoteHost","").toString();
	ftpRemoteDirectory=qSettings.value("ftpRemoteDirectory","/").toString();
	ftpLogin=qSettings.value("ftpLogin","").toString();
	ftpPassword=qSettings.value("ftpPassword","").toString();
	ftpFilename=qSettings.value("ftpFilename","").toString();
	ftpDefaultImageFormat=qSettings.value("ftpDefaultImageFormat","png").toString();
	repeaterImageInterval=qSettings.value("repeaterImageInterval",10).toInt();
	repeaterEnable=qSettings.value("repeaterEnable",FALSE).toBool();
	repeaterTxMode=(esstvMode)qSettings.value("repeaterTxMode",0).toInt();
	repeaterImage1=qSettings.value("repeaterImage1","").toString();
	repeaterImage2=qSettings.value("repeaterImage2","").toString();
	repeaterImage3=qSettings.value("repeaterImage3","").toString();
	repeaterImage4=qSettings.value("repeaterImage4","").toString();
	repeaterAcknowledge=qSettings.value("repeaterAcknowledge","").toString();
	repeaterTemplate=qSettings.value("repeaterTemplate","").toString();
  idleTemplate=qSettings.value("idleTemplate","").toString();
  videoDevice=qSettings.value("videoDevice","/dev/video0").toString();
	channelNumber=qSettings.value("channelNumber",0).toInt();
//	framesPerSecondIndex=qSettings.value("framesPerSecondIndex",0).toInt();
	colorFormatIndex=qSettings.value("colorFormatIndex",0).toInt();
	sizeIndex=qSettings.value("sizeIndex",0).toInt();
	qSettings.endGroup();
	setParams();
}

/**
 write variables to config file
		\sa readSettings
	
*/
void configDialog::writeSettings()
{
	getParams();
	QSettings qSettings;
	qSettings.beginGroup("Config");
  qSettings.setValue("callsign",myCallsign);
  qSettings.setValue("qth",myQth);
  qSettings.setValue("locator",myLocator);
  qSettings.setValue("lastname",myLastname);
  qSettings.setValue("firstname",myFirstname);
	qSettings.setValue("rxImagesPath",rxImagesPath);
	qSettings.setValue("txImagesPath",txImagesPath);
	qSettings.setValue("templatesPath",templatesPath);
	qSettings.setValue("audioPath",audioPath);
	qSettings.setValue("docPath",docPath);
	qSettings.setValue("defaultImageFormat",defaultImageFormat);
	qSettings.setValue("samplingrate",samplingrate);
	qSettings.setValue("rxclock",rxClock);
	qSettings.setValue("txclock",txClock);
	qSettings.setValue("inputAudioDevice",inputAudioDevice);
	qSettings.setValue("outputAudioDevice",outputAudioDevice);
  qSettings.setValue("serialPort",serialPort);
  qSettings.setValue("radioModel",radioModel);
  qSettings.setValue("civAddress",civAddress);
  qSettings.setValue("baudrate",baudrate);
  qSettings.setValue("parity",parity);
  qSettings.setValue("stopbits",stopbits);
  qSettings.setValue("databits",databits);
  qSettings.setValue("handshake",handshake);

  qSettings.setValue("enableCAT",enableCAT);
  qSettings.setValue("enableSerialPTT",enableSerialPTT);
  qSettings.setValue("pttSerialPort",pttSerialPort);


	qSettings.setValue("cwtext",cwText);
	qSettings.setValue("cwtone",cwTone);
	qSettings.setValue("cwWPM",cwWPM);
	qSettings.setValue("enableFTP",enableFTP);
	qSettings.setValue("ftpPort",ftpPort);
	qSettings.setValue("ftpRemoteHost",ftpRemoteHost);
	qSettings.setValue("ftpRemoteDirectory",ftpRemoteDirectory);
	qSettings.setValue("ftpLogin",ftpLogin);
	qSettings.setValue("ftpPassword",ftpPassword);
	qSettings.setValue("ftpFilename",ftpFilename);
	qSettings.setValue("ftpDefaultImageFormat",ftpDefaultImageFormat);
	qSettings.setValue("repeaterImageInterval",repeaterImageInterval);
	qSettings.setValue("repeaterEnable",repeaterEnable);
	qSettings.setValue("repeaterTxMode",repeaterTxMode);
	qSettings.setValue("repeaterImage1",repeaterImage1);
	qSettings.setValue("repeaterImage2",repeaterImage2);
	qSettings.setValue("repeaterImage3",repeaterImage3);
	qSettings.setValue("repeaterImage4",repeaterImage4);
	qSettings.setValue("repeaterAcknowledge",repeaterAcknowledge);
	qSettings.setValue("repeaterTemplate",repeaterTemplate);
  qSettings.setValue("idleTemplate",idleTemplate);
	qSettings.setValue("videoDevice",videoDevice);
	qSettings.setValue("channelNumber",channelNumber);
//	qSettings.setValue("framesPerSecondIndex",framesPerSecondIndex);
	qSettings.setValue("colorFormatIndex",colorFormatIndex);
	qSettings.setValue("sizeIndex",sizeIndex);
	qSettings.endGroup();
}


/**
	Opens the configuration dialog
*/

void configDialog::exec()
{
  videoCapture vc;
  int i=0;
  colorFormatComboBox->clear();
  sizeComboBox->clear();

  if(vc.open())
  {
    QList <QString> description;
    vc.getFormatList(description);
    for(i=0;i<description.count();i++)
    {
      colorFormatComboBox->addItem(description[i]);
    }

    QList<QSize> sizeList(vc.getSizesList());

    for(i=0;i<sizeList.count();i++)
    {
      sizeComboBox->addItem(QString::number(sizeList[i].width())+ " x " + QString::number(sizeList[i].height()));
    }
    vc.close();
  }
	setParams();
	if(QDialog::exec())
		{
			writeSettings();
		}
}

/**
 copies the values from the variables to the userinterface
		\sa getParams
	
*/

void configDialog::setParams()
{
  if(rigController->getRadioList(radioModelComboBox)) setValue(radioModel,radioModelComboBox);
  setValue(myCallsign,callsignLineEdit);
  setValue(myLastname,lastnameLineEdit);
  setValue(myFirstname,firstnameLineEdit);
  setValue(myQth,qthLineEdit);
  setValue(myLocator,locatorLineEdit);
	setValue(rxImagesPath, rxImagesPathLineEdit);
	setValue(txImagesPath, txImagesPathLineEdit);
	setValue(templatesPath, templatesPathLineEdit);
	setValue(audioPath, audioPathLineEdit);
	setValue(docPath,docPathLineEdit);
	setValue(defaultImageFormat, defaultImageFormatComboBox);
	setValue(rxClock,rxClockLineEdit,9);
	setValue(txClock,txClockLineEdit,9);
	setValue(inputAudioDevice,inputAudioDeviceLineEdit);
	setValue(outputAudioDevice,outputAudioDeviceLineEdit);
  setValue(serialPort,serialPortLineEdit);

  setValue(civAddress,civAddressLineEdit);
  setValue(baudrate,baudrateComboBox);
  setValue(parity,parityComboBox);
  setValue(stopbits,stopbitsComboBox);
  setValue(databits,databitsComboBox);
  setValue(handshake,handshakeComboBox);
  setValue(enableCAT,enableCATCheckBox);
	setValue(cwText,cwTextLineEdit);
	setValue(cwTone,cwToneSpinBox);
	setValue(cwWPM,cwWPMSpinBox);
	setValue(enableFTP,enableFTPCheckBox);
	setValue(ftpPort,ftpPortSpinBox);
	setValue(ftpRemoteHost,remoteHostLineEdit);
	setValue(ftpRemoteDirectory,remoteDirectoryLineEdit);
	setValue(ftpLogin,ftpLoginLineEdit);
	setValue(ftpPassword,ftpPasswordLineEdit);
	setValue(ftpFilename,ftpFilenameLineEdit);
	setValue(ftpDefaultImageFormat,ftpDefaultImageFormatComboBox);
	setValue(repeaterEnable,repeaterEnableCheckBox);
  setIndex(repeaterTxMode,repeaterTxModeComboBox);
	setValue(repeaterImage1,repeaterImage1LineEdit);
	setValue(repeaterImage2,repeaterImage2LineEdit);
	setValue(repeaterImage3,repeaterImage3LineEdit);
	setValue(repeaterImage4,repeaterImage4LineEdit);
  setValue(idleTemplate,idleTemplateLineEdit);
	setValue(repeaterTemplate,repeaterTemplateLineEdit);
	setValue(videoDevice,videoDeviceLineEdit);
	setValue(channelNumber, channelSpinBox);
  setIndex(colorFormatIndex,colorFormatComboBox);
  setIndex(sizeIndex,sizeComboBox);
  setValue(enableSerialPTT,enablePTTCheckBox);
  setValue(pttSerialPort,pttSerialPortLineEdit);
	
}

/**
 copies the values from the userinterface to the variables

		\sa setParams
	
*/

void configDialog::getParams()
{
  getValue(myCallsign,callsignLineEdit);
  getValue(myLastname,lastnameLineEdit);
  getValue(myFirstname,firstnameLineEdit);
  getValue(myQth,qthLineEdit);
  getValue(myLocator,locatorLineEdit);
	getValue(rxImagesPath, rxImagesPathLineEdit);
	getValue(txImagesPath, txImagesPathLineEdit);
	getValue(templatesPath, templatesPathLineEdit);
	getValue(audioPath, audioPathLineEdit);
	getValue(docPath,docPathLineEdit);
	getValue(defaultImageFormat, defaultImageFormatComboBox);
	getValue(rxClock,rxClockLineEdit);
	getValue(txClock,txClockLineEdit);
	getValue(inputAudioDevice,inputAudioDeviceLineEdit);
	getValue(outputAudioDevice,outputAudioDeviceLineEdit);
  getValue(serialPort,serialPortLineEdit);
  if(radioModelComboBox->count()!=0) getValue(radioModel,radioModelComboBox);
  getValue(civAddress,civAddressLineEdit);
  getValue(baudrate,baudrateComboBox);
  getValue(parity,parityComboBox);
  getValue(stopbits,stopbitsComboBox);
  getValue(databits,databitsComboBox);
  getValue(handshake,handshakeComboBox);
  getValue(enableCAT,enableCATCheckBox);
	getValue(cwText,cwTextLineEdit);
	getValue(cwTone,cwToneSpinBox);
	getValue(cwWPM,cwWPMSpinBox);
	getValue(enableFTP,enableFTPCheckBox);
	getValue(ftpPort,ftpPortSpinBox);
	getValue(ftpRemoteHost,remoteHostLineEdit);
	getValue(ftpRemoteDirectory,remoteDirectoryLineEdit);
	getValue(ftpLogin,ftpLoginLineEdit);
	getValue(ftpPassword,ftpPasswordLineEdit);
	getValue(ftpFilename,ftpFilenameLineEdit);
	getValue(ftpDefaultImageFormat,ftpDefaultImageFormatComboBox);
	getValue(repeaterEnable,repeaterEnableCheckBox);
  int temp;
  getIndex(temp,repeaterTxModeComboBox);
  repeaterTxMode=esstvMode(temp);
	getValue(repeaterImage1,repeaterImage1LineEdit);
	getValue(repeaterImage2,repeaterImage2LineEdit);
	getValue(repeaterImage3,repeaterImage3LineEdit);
	getValue(repeaterImage4,repeaterImage4LineEdit);
  getValue(idleTemplate,idleTemplateLineEdit);
	getValue(repeaterTemplate,repeaterTemplateLineEdit);
	getValue(videoDevice,videoDeviceLineEdit);
	getValue(channelNumber, channelSpinBox);
  getIndex(colorFormatIndex,colorFormatComboBox);
  getIndex(sizeIndex,sizeComboBox);
  getValue(enableSerialPTT,enablePTTCheckBox);
  getValue(pttSerialPort,pttSerialPortLineEdit);
}

/**
	Browse function for path where the rximages are stored
*/


void configDialog::slotBrowseRxImagesPath()
{
	browseDir(rxImagesPathLineEdit,rxImagesPath);
}

/**
	Browse function for path where the tximages are stored
*/

void configDialog::slotBrowseTxImagesPath()
{
	browseDir(txImagesPathLineEdit,txImagesPath);
}

/**
	Browse function for path where the templates are stored
*/

void configDialog::slotBrowseTemplatesPath()
{
	browseDir(templatesPathLineEdit,templatesPath);
}

/**
	Browse function for audio path
*/

void configDialog::slotBrowseAudioPath()
{
	browseDir(audioPathLineEdit,audioPath);
}

/**
	Browse function for documentation path
*/


void configDialog::slotBrowseDocPath()
{
	browseDir(docPathLineEdit,docPath);
}

void configDialog::slotRp1BrowseButton()
{
  browseGetFile(repeaterImage1LineEdit,txImagesPath);
}

void configDialog::slotRp2BrowseButton()
{
  browseGetFile(repeaterImage2LineEdit,txImagesPath);
}

void configDialog::slotRp3BrowseButton()
{
  browseGetFile(repeaterImage3LineEdit,txImagesPath);
}

void configDialog::slotRp4BrowseButton()
{
  browseGetFile(repeaterImage4LineEdit,txImagesPath);
}

void configDialog::slotRepeaterTemplateBrowseButton()
{
  browseGetFile(repeaterTemplateLineEdit,templatesPath);
}

void configDialog::slotIdleTemplateBrowseButton()
{
  browseGetFile(idleTemplateLineEdit,templatesPath);
}


void configDialog::slotEnableCAT()
{
  if(enableCATCheckBox->isChecked())
  {
    enablePTTCheckBox->setChecked(FALSE);
    rigController->init();
  }
  getParams();
}

void configDialog::slotEnablePTT()
{
   if(enablePTTCheckBox->isChecked())
  {
     enableCATCheckBox->setChecked(FALSE);
     rigController->disable();
   }
   getParams();
}

