r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Media
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""


from datetime import datetime
from typing import Any, Dict, Optional, Union
from twilio.base import deserialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class PlaybackGrantInstance(InstanceResource):

    """
    :ivar sid: The unique string generated to identify the PlayerStreamer resource that this PlaybackGrant authorizes views for.
    :ivar url: The absolute URL of the resource.
    :ivar account_sid: The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this resource.
    :ivar date_created: The date and time in GMT when the resource was created specified in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    :ivar grant: The grant that authorizes the player sdk to connect to the livestream
    """

    def __init__(self, version: Version, payload: Dict[str, Any], sid: str):
        super().__init__(version)

        self.sid: Optional[str] = payload.get("sid")
        self.url: Optional[str] = payload.get("url")
        self.account_sid: Optional[str] = payload.get("account_sid")
        self.date_created: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_created")
        )
        self.grant: Optional[Dict[str, object]] = payload.get("grant")

        self._solution = {
            "sid": sid,
        }
        self._context: Optional[PlaybackGrantContext] = None

    @property
    def _proxy(self) -> "PlaybackGrantContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: PlaybackGrantContext for this PlaybackGrantInstance
        """
        if self._context is None:
            self._context = PlaybackGrantContext(
                self._version,
                sid=self._solution["sid"],
            )
        return self._context

    def create(
        self,
        ttl: Union[int, object] = values.unset,
        access_control_allow_origin: Union[str, object] = values.unset,
    ) -> "PlaybackGrantInstance":
        """
        Create the PlaybackGrantInstance

        :param ttl: The time to live of the PlaybackGrant. Default value is 15 seconds. Maximum value is 60 seconds.
        :param access_control_allow_origin: The full origin URL where the livestream can be streamed. If this is not provided, it can be streamed from any domain.

        :returns: The created PlaybackGrantInstance
        """
        return self._proxy.create(
            ttl=ttl,
            access_control_allow_origin=access_control_allow_origin,
        )

    async def create_async(
        self,
        ttl: Union[int, object] = values.unset,
        access_control_allow_origin: Union[str, object] = values.unset,
    ) -> "PlaybackGrantInstance":
        """
        Asynchronous coroutine to create the PlaybackGrantInstance

        :param ttl: The time to live of the PlaybackGrant. Default value is 15 seconds. Maximum value is 60 seconds.
        :param access_control_allow_origin: The full origin URL where the livestream can be streamed. If this is not provided, it can be streamed from any domain.

        :returns: The created PlaybackGrantInstance
        """
        return await self._proxy.create_async(
            ttl=ttl,
            access_control_allow_origin=access_control_allow_origin,
        )

    def fetch(self) -> "PlaybackGrantInstance":
        """
        Fetch the PlaybackGrantInstance


        :returns: The fetched PlaybackGrantInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "PlaybackGrantInstance":
        """
        Asynchronous coroutine to fetch the PlaybackGrantInstance


        :returns: The fetched PlaybackGrantInstance
        """
        return await self._proxy.fetch_async()

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Media.V1.PlaybackGrantInstance {}>".format(context)


class PlaybackGrantContext(InstanceContext):
    def __init__(self, version: Version, sid: str):
        """
        Initialize the PlaybackGrantContext

        :param version: Version that contains the resource
        :param sid: The SID of the PlayerStreamer resource to fetch.
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "sid": sid,
        }
        self._uri = "/PlayerStreamers/{sid}/PlaybackGrant".format(**self._solution)

    def create(
        self,
        ttl: Union[int, object] = values.unset,
        access_control_allow_origin: Union[str, object] = values.unset,
    ) -> PlaybackGrantInstance:
        """
        Create the PlaybackGrantInstance

        :param ttl: The time to live of the PlaybackGrant. Default value is 15 seconds. Maximum value is 60 seconds.
        :param access_control_allow_origin: The full origin URL where the livestream can be streamed. If this is not provided, it can be streamed from any domain.

        :returns: The created PlaybackGrantInstance
        """
        data = values.of(
            {
                "Ttl": ttl,
                "AccessControlAllowOrigin": access_control_allow_origin,
            }
        )

        payload = self._version.create(method="POST", uri=self._uri, data=data)

        return PlaybackGrantInstance(self._version, payload, sid=self._solution["sid"])

    async def create_async(
        self,
        ttl: Union[int, object] = values.unset,
        access_control_allow_origin: Union[str, object] = values.unset,
    ) -> PlaybackGrantInstance:
        """
        Asynchronous coroutine to create the PlaybackGrantInstance

        :param ttl: The time to live of the PlaybackGrant. Default value is 15 seconds. Maximum value is 60 seconds.
        :param access_control_allow_origin: The full origin URL where the livestream can be streamed. If this is not provided, it can be streamed from any domain.

        :returns: The created PlaybackGrantInstance
        """
        data = values.of(
            {
                "Ttl": ttl,
                "AccessControlAllowOrigin": access_control_allow_origin,
            }
        )

        payload = await self._version.create_async(
            method="POST", uri=self._uri, data=data
        )

        return PlaybackGrantInstance(self._version, payload, sid=self._solution["sid"])

    def fetch(self) -> PlaybackGrantInstance:
        """
        Fetch the PlaybackGrantInstance


        :returns: The fetched PlaybackGrantInstance
        """

        payload = self._version.fetch(
            method="GET",
            uri=self._uri,
        )

        return PlaybackGrantInstance(
            self._version,
            payload,
            sid=self._solution["sid"],
        )

    async def fetch_async(self) -> PlaybackGrantInstance:
        """
        Asynchronous coroutine to fetch the PlaybackGrantInstance


        :returns: The fetched PlaybackGrantInstance
        """

        payload = await self._version.fetch_async(
            method="GET",
            uri=self._uri,
        )

        return PlaybackGrantInstance(
            self._version,
            payload,
            sid=self._solution["sid"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Media.V1.PlaybackGrantContext {}>".format(context)


class PlaybackGrantList(ListResource):
    def __init__(self, version: Version, sid: str):
        """
        Initialize the PlaybackGrantList

        :param version: Version that contains the resource
        :param sid: The unique string generated to identify the PlayerStreamer resource associated with this PlaybackGrant

        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "sid": sid,
        }

    def get(self) -> PlaybackGrantContext:
        """
        Constructs a PlaybackGrantContext

        """
        return PlaybackGrantContext(self._version, sid=self._solution["sid"])

    def __call__(self) -> PlaybackGrantContext:
        """
        Constructs a PlaybackGrantContext

        """
        return PlaybackGrantContext(self._version, sid=self._solution["sid"])

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Media.V1.PlaybackGrantList>"
