#
#    <pytcpwrap - Python wrapper for libwrap used for hosts.allow/hosts.deny access control>
#    Copyright (C) <2004>  <Eugene Coetzee>
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   e-mail author : eugene@reedflute.com
#   postal address   : Dwarsstreet 75, Potchefstroom,NW Province, 2531, Rebublic of South Africa		

import libtcpwrap
import socket

class TCPWrap:
	def __init__(self,app,hostname,ipaddr):
		if not app:
			self.allow=False
			return
		else:	
			self.app=app
		if not hostname and not ipaddr:
			self.allow=False
			return
		if hostname and ipaddr:
			sock_hostname=socket.getfqdn(ipaddr)
			sock_ipaddr=socket.gethostbyname(hostname)
			if hostname!=sock_hostname or ipaddr!=sock_ipaddr:
				self.allow=False
				return
			else:
				self.hostname=hostname
				self.ipaddr=ipaddr

		if not hostname:
			sock_hostname=socket.getfqdn(ipaddr)
			if not sock_hostname:
				self.alow=False
				return
			else:
				self.hostname=sock_hostname
				self.ipaddr=ipaddr
		if not ipaddr:
			sock_ipaddr=socket.gethostbyname(hostname)
			if not sock_ipaddr:
				self.alow=False
				return
			else:
				self.ipaddr=sock_ipaddr
				self.hostname=hostname
		self.username=""
		self.allow=libtcpwrap.hosts_ctl(self.app,self.hostname,self.ipaddr,self.username)

	def Deny(self):
		if self.allow:
			return False
		return True

	def Allow(self):
		if self.allow:
			return True 
		return False

