---
title: Why not X?
---

There are a number of formats and approaches that can achieve more or
less the same purpose as StrictYAML. Below is a series of comparisons
with some of the more famous ones:

- [Why avoid using environment variables as configuration?](environment-variables-as-config)
- [Why not use HJSON?](hjson)
- [Why not HOCON?](hocon)
- [Why not use INI files?](ini)
- [Why not use JSON Schema for validation?](json-schema)
- [Why not JSON for simple configuration files?](json)
- [Why not JSON5?](json5)
- [Why not use the YAML 1.2 standard? - we don't need a new standard!](ordinary-yaml)
- [Why not use kwalify with standard YAML to validate my YAML?](pykwalify)
- [Why not use Python's schema library (or similar) for validation?](python-schema)
- [Why not use SDLang?](sdlang)
- [What is wrong with TOML?](toml)
- [Why shouldn't I just use Python code for configuration?](turing-complete-code)
- [Why not use XML for configuration or DSLs?](xml)


If you'd like to write or link to a rebuttal to any argument raised
here, feel free to raise a ticket.