# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IssueContractBaseProperties(Model):
    """Issue contract Base Properties.

    :param created_date: Date and time when the issue was created.
    :type created_date: datetime
    :param state: Status of the issue. Possible values include: 'proposed',
     'open', 'removed', 'resolved', 'closed'
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created
     for.
    :type api_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
    }

    def __init__(self, *, created_date=None, state=None, api_id: str=None, **kwargs) -> None:
        super(IssueContractBaseProperties, self).__init__(**kwargs)
        self.created_date = created_date
        self.state = state
        self.api_id = api_id
