# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class WebService(Resource):
    """Instance of an Azure ML web service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :param name: Specifies the name of the resource.
    :type name: str
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: Contains resource tags defined as key/value pairs.
    :type tags: dict
    :param properties: Contains the property payload that describes the web
     service.
    :type properties: :class:`WebServiceProperties
     <azure.mgmt.machinelearning.models.WebServiceProperties>`
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'WebServiceProperties'},
    }

    def __init__(self, location, properties, name=None, tags=None):
        super(WebService, self).__init__(name=name, location=location, tags=tags)
        self.properties = properties
