import os
import sys

try:
    # TODO: If we made the tests dir a package this could be avoided by using
    # package-relative imports
    import conv_base
except ImportError:
    sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                    os.pardir)))
    import conv_base


class Test1311(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f125w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1311_%s.fits"
        cls.setup2()

class Test1312(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f125w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),23.3,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1312_%s.fits"
        cls.setup2()

class Test1313(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f125w"
        cls.spectrum="spec(earthshine.fits)*0.5+spec(Zodi.fits)*0.5+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1313_%s.fits"
        cls.setup2()

class Test1314(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f126n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1314_%s.fits"
        cls.setup2()

class Test1315(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f126n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1315_%s.fits"
        cls.setup2()

class Test1316(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f126n"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1316_%s.fits"
        cls.setup2()

class Test1317(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f127m"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1317_%s.fits"
        cls.setup2()

class Test1318(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f127m"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1318_%s.fits"
        cls.setup2()

class Test1319(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f127m"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1319_%s.fits"
        cls.setup2()

class Test1320(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f128n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1320_%s.fits"
        cls.setup2()

class Test1321(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f128n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1321_%s.fits"
        cls.setup2()

class Test1322(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f128n"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1322_%s.fits"
        cls.setup2()

class Test1323(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f130n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1323_%s.fits"
        cls.setup2()

class Test1324(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f130n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1324_%s.fits"
        cls.setup2()

class Test1325(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f130n"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1325_%s.fits"
        cls.setup2()

class Test1326(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f132n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1326_%s.fits"
        cls.setup2()

class Test1327(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f132n"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1327_%s.fits"
        cls.setup2()

class Test1328(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f132n"
        cls.spectrum="rn(unit(1.0,flam),band(sdss,r),28.0,vegamag)+em(13200.0,5.0,1.0E-13,flam)"
        cls.fname="C1328_%s.fits"
        cls.setup2()

class Test1329(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f132n"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1329_%s.fits"
        cls.setup2()

class Test1330(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f139m"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1330_%s.fits"
        cls.setup2()

class Test1331(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f139m"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1331_%s.fits"
        cls.setup2()

class Test1332(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f139m"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1332_%s.fits"
        cls.setup2()

class Test1333(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1333_%s.fits"
        cls.setup2()

class Test1334(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1334_%s.fits"
        cls.setup2()

class Test1335(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec($PYSYN_CDBS/calspec/g191b2b_mod_004.fits),0.3),band(johnson,b),28.0,vegamag)"
        cls.fname="C1335_%s.fits"
        cls.setup2()

class Test1336(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec($PYSYN_CDBS/calspec/gd153_mod_004.fits),0.2),band(johnson,b),28.0,vegamag)"
        cls.fname="C1336_%s.fits"
        cls.setup2()

class Test1337(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec($PYSYN_CDBS/calspec/gd71_mod_005.fits),0.1),band(johnson,b),28.0,vegamag)"
        cls.fname="C1337_%s.fits"
        cls.setup2()

class Test1338(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec(egal.dat),0.1),band(johnson,b),28.0,vegamag)"
        cls.fname="C1338_%s.fits"
        cls.setup2()

class Test1339(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec(egal.dat),1.0),band(johnson,b),28.0,vegamag)"
        cls.fname="C1339_%s.fits"
        cls.setup2()

class Test1340(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec(qso_template.fits),3.0),band(johnson,b),28.0,vegamag)"
        cls.fname="C1340_%s.fits"
        cls.setup2()

class Test1341(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec(spiral.fits),0.2),band(johnson,b),28.0,vegamag)"
        cls.fname="C1341_%s.fits"
        cls.setup2()

class Test1342(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="rn(z(spec(spiral.fits),2.0),band(johnson,b),28.0,vegamag)"
        cls.fname="C1342_%s.fits"
        cls.setup2()

class Test1343(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f140w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1343_%s.fits"
        cls.setup2()

class Test1344(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1344_%s.fits"
        cls.setup2()

class Test1345(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1345_%s.fits"
        cls.setup2()

class Test1346(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="rn(unit(1.0,flam),band(sdss,g),28.0,vegamag)"
        cls.fname="C1346_%s.fits"
        cls.setup2()

class Test1347(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="rn(unit(1.0,flam),band(sdss,i),28.0,vegamag)"
        cls.fname="C1347_%s.fits"
        cls.setup2()

class Test1348(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="rn(unit(1.0,flam),box(5000.0,1.0),1.0e-18,flam)"
        cls.fname="C1348_%s.fits"
        cls.setup2()

class Test1349(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="rn(unit(1.0,fnu),band(sdss,z),28.0,vegamag)"
        cls.fname="C1349_%s.fits"
        cls.setup2()

class Test1350(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)"
        cls.fname="C1350_%s.fits"
        cls.setup2()

class Test1351(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)*0.2+spec(el1302a.fits)*0.01333333333+spec(el1356a.fits)*0.012+spec(el2471a.fits)*0.01)"
        cls.fname="C1351_%s.fits"
        cls.setup2()

class Test1352(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1352_%s.fits"
        cls.setup2()

class Test1353(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f153m"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))*2.0"
        cls.fname="C1353_%s.fits"
        cls.setup2()

class Test1354(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),22.0,vegamag)"
        cls.fname="C1354_%s.fits"
        cls.setup2()

class Test1355(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),28.0,vegamag)"
        cls.fname="C1355_%s.fits"
        cls.setup2()

class Test1356(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_1.fits),band(cousins,i),28.0,vegamag)*ebmvx(0.04,gal1)"
        cls.fname="C1356_%s.fits"
        cls.setup2()

class Test1357(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_1.fits),band(cousins,i),28.0,vegamag)*ebmvx(0.08,gal1)"
        cls.fname="C1357_%s.fits"
        cls.setup2()

class Test1358(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_10.fits),band(cousins,i),28.0,vegamag)*ebmvx(0.08,gal1)"
        cls.fname="C1358_%s.fits"
        cls.setup2()

class Test1359(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_10.fits),band(cousins,i),28.0,vegamag)*ebmvx(0.12,gal3)"
        cls.fname="C1359_%s.fits"
        cls.setup2()

class Test1360(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,f160w"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_10.fits),band(cousins,i),28.0,vegamag)*ebmvx(0.16,smc)"
        cls.fname="C1360_%s.fits"
        cls.setup2()

