# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=6.2.0 --output=unicodedb_6_2_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '6.2.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x0c ABOVE RIGHT'
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x03 AN'
'\x05 AND '
'\x0f AND COLD SWEAT'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\t AND PICK'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x06 ARROW'
'\x05 BACK'
'\x04 BAR'
'\x06 BELOW'
'\t BEVERAGE'
'\x06 BLOCK'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x04 CAR'
'\x07 CER-WA'
'\n CHARACTER'
'\x06 CHART'
'\x07 CHIKI '
'\x07 CIRCLE'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING GABA'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x11 DOWN BLACK ARROW'
'\t DRACHMAS'
'\x07 ENGINE'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ILUT'
'\x03 IN'
'\x0e IN SILHOUETTE'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x0e KISIM5 TIMES '
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x0b LANE MERGE'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\x07 MUOMAE'
'\x06 MURDA'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x08 OF FOOD'
'\r OPPOSING KUR'
'\x04 ORE'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x02 P'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\x12 PLUS LU PLUS ESH2'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\x11 PLUS SHA3 PLUS A'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x07 POMMEE'
'\x04 POT'
'\x0c PUNCTUATION'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x08 ROTUNDA'
'\x06 RULER'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\t SPARKLER'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\x12 THROUGH DESCENDER'
'\x07 TIMES '
'\x08 TIMES A'
'\x10 TIMES A PLUS NA'
'\n TIMES BAD'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x08 TIMES U'
'\x06 TONE-'
'\x08 TTUDDAG'
'\x02 U'
'\r VARIANT FORM'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DESCENDER'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH INK PEN'
'\r WITH JEGOGAN'
'\x1b WITH LEFTWARDS ARROW ABOVE'
'\x0e WITH LONG LEG'
'\x14 WITH OBLIQUE STROKE'
'\x12 WITH PALATAL HOOK'
'\x12 WITH SMILING EYES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x07 WOLOSO'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x06-PIEUP'
'\n-POINTING '
'\x19-POINTING DOUBLE TRIANGLE'
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x010'
'\x080 BRONZE'
'\x050 DWO'
'\x0b0 FOOTSTOOL'
'\x040 KO'
'\x040 MA'
'\x050 MAN'
'\x040 NI'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x070 SPEAR'
'\x030 U'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 ZO'
'\x030-0'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x071 ARROW'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DU'
'\x051 DWE'
'\x061 GOLD'
'\x081 HELMET'
'\x061 HORN'
'\x041 KU'
'\x031 O'
'\x041 PO'
'\x041 QI'
'\x041 SA'
'\x041 SI'
'\x051 TWO'
'\x061 WINE'
'\x031-0'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\n2 PLUS ASH'
'\n2 PLUS GAL'
'\x0b2 PLUS GIR2'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x042 SO'
'\x042 WO'
'\x072 WOMAN'
'\x032-0'
'\x0220'
'\x0221'
'\x0222'
'\t247 DIPTE'
'\x03253'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x043 PA'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x073 WHEEL'
'\x033-0'
'\x03305'
'\x0233'
'\x0234'
'\x0239'
'\x014'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x044 KE'
'\x044 NE'
'\x044 TE'
'\x044 WA'
'\x044 ZE'
'\x034-0'
'\x0240'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AU'
'\t5 BATHTUB'
'\t5 CYPERUS'
'\x045 DE'
'\x045 JU'
'\x065 MERI'
'\x045 MO'
'\x045 NU'
'\x045 TO'
'\x045 WE'
'\x065 WOOL'
'\x035-0'
'\x0250'
'\x0253'
'\x0255'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 JE'
'\x046 JO'
'\x046 NA'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x056 TA2'
'\x066 TREE'
'\x036-0'
'\x03620'
'\x036D7'
'\x017'
'\x047 DI'
'\x047 JA'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 ZA'
'\x0270'
'\x0272'
'\x0372C'
'\x0279'
'\x018'
'\x038 A'
'\x038 E'
'\x038 I'
'\x088 KANAKO'
'\x058 NWA'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 TA'
'\x049 TU'
'\x04904A'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x06A HAAM'
'\x06A MFON'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\nA TANG LAI'
'\x07A WITH '
'\x05A YUE'
'\x04A-HA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x03AAF'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\nAB2 TIMES '
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\x06ABOVE '
'\x0eABOVE REVERSE '
'\tABULATION'
'\x03AC '
'\x13ACCENT ATNAH HAFUKH'
'\x03ACE'
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x0bACKNOWLEDGE'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x02AE'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\tAGOLITIC '
'\x04AGON'
'\x08AGRAPHOS'
'\x02AH'
'\x08AH WITH '
'\x04AHAD'
'\x08AHAPRANA'
'\x05AHMI '
'\x02AI'
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x0cAKAARAANSAYA'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x05ALGAR'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x04AMBA'
'\x07AME DIE'
'\x03AMI'
'\x04AMLA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN2'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x06ANCORA'
'\x03AND'
'\x0fAND FEMALE SIGN'
'\x18AND MALE AND FEMALE SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x06ANGLE '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x08ANGULAR '
'\x08ANI SIGN'
'\x08ANS SIGN'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\x03APP'
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x05AR B '
'\x04ARAE'
'\x08ARCASITE'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x07ARDNESS'
'\nARFUL FACE'
'\x05ARGE '
'\x0bARGE CIRCLE'
'\x0bARGE SQUARE'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\tARM CLOCK'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW WITH '
'\x0eARSI YEH WITH '
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x04ASAT'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x08ATAKANA '
'\x13ATED TELLER MACHINE'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x14ATIN CAPITAL LETTER '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x02AU'
'\x07AU MARK'
'\x04AULA'
'\x07AULDRON'
'\x07AUNTLET'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x08AVAGRAHA'
'\x04AVE-'
'\x0fAVONIC ASTERISK'
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x0eAVY CHECK MARK'
'\x02AW'
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x06AYEROK'
'\x0bAYING CARD '
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x08BACKWARD'
'\x03BAD'
'\x03BAG'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x05BALAG'
'\x04BALL'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\tBASE UNIT'
'\x04BASH'
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x05BENDE'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x06BGBIEE'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x03BIN'
'\x07BINING '
'\x0cBINING MARK '
'\x05BISAH'
'\x06BISCUS'
'\x0fBJOINED LETTER '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\rBLACK HEXAGON'
'\x11BLACK SHOGI PIECE'
'\x03BLE'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x07BOARDER'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x04BOOK'
'\x05BOOTS'
'\x06BOTTLE'
'\x11BOTTOM HALF BLACK'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x0cBREVE-MACRON'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x04BSET'
'\x03BSP'
'\nBSTRUCTION'
'\x03BU '
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C SIGN'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x08CABLEWAY'
'\x03CAH'
'\x05CAKRA'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x07CAP TEN'
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x05CECAK'
'\x05CECEK'
'\x03CEL'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x06CER-WA'
'\x05CEREK'
'\x02CH'
'\nCH BALLOON'
'\x03CHA'
'\x06CHAMKO'
'\x14CHARACTER INTRODUCER'
'\x03CHE'
'\nCHECK MARK'
'$CHED LEFT SEMICIRCLE WITH THREE DOTS'
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x06CHIRET'
'\x03CHO'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x06CHURCH'
'\x04CHWA'
'\nCHWA WITH '
'\x02CI'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x06CIRCLE'
'\rCIRCLE INSIDE'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\x04CKET'
'\x05CKING'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\nCOMBINING '
'\x07COMING '
'\x0fCOMING ENVELOPE'
'\x05COMMA'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x11CONSONANT SIGN PA'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x0fCROSS ON SHIELD'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x06CTOPUS'
'\x04CTOR'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x12CUP WITHOUT HANDLE'
'\x04CURL'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY LOOP'
'\tCURSIVE L'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x07D CHIME'
'\x04D HA'
'\x07D INDEX'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x06DAGGER'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\tDATE MARK'
'\x04DBAG'
'\x05DBOAT'
'\x02DD'
'\x04DDDA'
'\x05DDING'
'\x02DE'
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\tDESCENDER'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x02DF'
'\x04DGER'
'\x03DHA'
'\x07DHALATH'
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\rDIAERESIZED U'
'\tDIAGONAL '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\x0eDIFIER LETTER '
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x05DIUM '
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x02DO'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x07DOUBLE '
'\nDOUBLE BAR'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\rDOUBLE MUCAAD'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x04DOWN'
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\tDOWN SIGN'
'\tDOWNWARDS'
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS TREND'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x06DUCEUS'
'\x03DUG'
'\x03DUN'
'\tDUN3 GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\x02DY'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\x1fE DOT OVER TWO DOTS PUNCTUATION'
'\x05E GEE'
'\x07E GLASS'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E0'
'\x02E2'
'\x03E80'
'\x02EA'
'\x04EACE'
'\x07EAD ORE'
'\x05EAGLE'
'\x03EAM'
'\x04EANS'
'\nEARLY FORM'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\x05EBOOK'
'\x0bECTION MARK'
'\x03ED '
'\x08ED BRICK'
'\x06ED ICE'
'\x0eED PARAGRAPHOS'
'\x07ED RICE'
'\tEDESTRIAN'
'\x06EDIAL '
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x03EEN'
'\x04EENG'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x0fEFTWARDS ARROWS'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\tEIGHT OF '
'\x06EIGHTH'
'\x16EIGHTY ON BLACK SQUARE'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x0cELECTED AREA'
'\x03ELF'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x05EMBIC'
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x04ENCH'
'\nENCH FRIES'
'\rENCY EXCHANGE'
'\x03END'
'\x0eEND OF SECTION'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\nENS SYMBOL'
'\x07ENSHUET'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x03EOW'
'\x08EPARATOR'
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x0fERING MEGAPHONE'
'\x05ERN W'
'\x04ERSE'
'\x06ERTED '
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\x08ESCENDER'
'\x1dESENTATION FORM FOR VERTICAL '
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x06ESHTIN'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\nEVANAGARI '
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\x12EVERSED C WITH DOT'
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x02EW'
'\x02EX'
'\x06EXAGON'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x17EXCLAMATION MARK SYMBOL'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EY '
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\x15F WITH TWO DOTS ABOVE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x12FACING SVASTI SIGN'
'\tFACING UP'
'\x10FALLING DIAGONAL'
'\x06FAMILY'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FEUQ'
'\x06FF OF '
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIFTY'
'\x06FIFTY '
'\x0bFILE FOLDER'
'\x07FINAGH '
'\x06FINAL '
'\tFINAL NGA'
'\x08FINAL TH'
'\x07FINAL Y'
'\x04FIRE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x0cFIVE HUNDRED'
'\x02FL'
'\x04FLAG'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x16FLATTENED OPEN A ABOVE'
'\x15FLATTENED PARENTHESIS'
'\x05FLICT'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x04FOUR'
'\nFOUR BELOW'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x08FROM BAR'
'\x08FROWNING'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT ICE CREAM'
'\x0cFT RERENGGAN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x03GAG'
'\x03GAH'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x03GAR'
'\x08GARITIC '
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x06GERINE'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x0bGGAGE CLAIM'
'\nGGER WITH '
'\nGGRAVATION'
'\x03GGY'
'\x02GH'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x08GHT RAIL'
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x04GIDA'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'!GOLIAN LETTER MANCHU ALI GALI LHA'
'\x04GONG'
'\x03GOU'
'\x02GR'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x02GW'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x04HAIN'
'\x03HAL'
'\x14HALA CONSONANT SIGN '
'\x04HALF'
'\x0fHALF RING ABOVE'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\tHARD SIGN'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x04HEAD'
'\x05HEAD '
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x08HEAVY YA'
'\x0bHEELED SHOE'
'\x04HEEN'
'\x03HEH'
'\x12HEN WITH DIAERESIS'
'\x03HER'
'\x06HERMES'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x16HEXIFORM LONG ANUSVARA'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\x0cHI TIMES BAD'
'\x03HID'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x03HIN'
'\rHINESE TONE Y'
'\x07HIOPIC '
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x0bHJONG TILE '
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOO'
'\x04HOOK'
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x04HOOL'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x06HORT A'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
'"HREE DOTS POINTING DOWNWARDS ABOVE'
' HREE DOTS POINTING UPWARDS BELOW'
'\tHREE FOR '
'\x08HREE OF '
'\x05HROOM'
'\x04HSHU'
'\x02HU'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x03HUR'
'\x02HV'
'\x02HW'
'\x03HWA'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x02I0'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x10IAMOND IN SQUARE'
'\x0bIAN LETTER '
'\x0eIAN RUPEE SIGN'
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IAUDA'
'\x02IC'
'\x05ICAL '
'\x0cICE CONTROL '
'\x0cICE OF PIZZA'
'3ICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x1bIERSTRASS ELLIPTIC FUNCTION'
'\x03IES'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\x06IFIED '
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\x0fIGHT WITH STARS'
'\tIGHTH ASH'
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x02IN'
'\x03IN '
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINARBORAS'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\rING HAND SIGN'
'\x0eING HANDS SIGN'
'\tING HEART'
'\tING LANES'
'\x07ING OF '
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x06INKING'
'\x07INNABAR'
'\nINOCULAR O'
'\x03INS'
'\x06INSHIP'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x04INU '
'\x08INVERTED'
'\tINVERTED '
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INYA'
'\x03ION'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x0cIRAGANA HOKA'
'\nIRAL SHELL'
'\x05IRAMA'
'\x05IRCLE'
'\x06IRCLES'
'\x05IRCUT'
'\x04IRED'
'\x03IRL'
'\x04IRON'
'\x0cIRST SUBUNIT'
'\x04IRTY'
'\x02IS'
'\x08IS BELOW'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x0cIT SEPARATOR'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x15ITALIC SMALL DOTLESS '
'\x04ITAR'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\tITRA SIGN'
'\x04ITSA'
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE SLOW SIGN'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\nIXTHS DISH'
'\x14IXTY ON BLACK SQUARE'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x03JOA'
'\x06JOINED'
'\x05JOKER'
'\x04JONG'
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x08K SYMBOL'
'\x07K WITH '
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x06KAVYKA'
'\x06KAYAH '
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x07KHAMTI '
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING FACE'
'\x04KINI'
'\x0eKISH LIRA SIGN'
'\x0fKISIM5 TIMES BI'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x04KMA '
'\x02KO'
'\x03KO '
'\x04KOET'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x0bKTIESELSKAB'
'\x02KU'
'\x03KUE'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x03LAA'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x03LAH'
'\x03LAI'
'\x03LAL'
'\x03LAM'
'\tLAM WITH '
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\nLANE MERGE'
'\tLARGEMENT'
'\x03LAS'
'\x14LASHING SWEAT SYMBOL'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x0bLCE TSA CAN'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\tLD TAMIL '
'\x04LDE '
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x13LEADING MCHAN RTAGS'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\tLEFT HOOK'
'\nLEFT-HAND '
'\x12LEFT-STEM TONE BAR'
'\x0fLEFTWARDS ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\nLEK ATTAK '
'\x06LENDAR'
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x05LENIS'
'\x04LEPH'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x06LETTER'
'\x07LETTER '
'\tLETTER KH'
'\x0bLETTER LLLA'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x10LETTER VOCALIC L'
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x02LF'
'\x07LF FACE'
'\x0fLF SECTION SIGN'
'\x03LFA'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0bLIEVED FACE'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\nLIGHT BULB'
'\nLIMITATION'
'\x04LINE'
'\x0eLINE EXTENSION'
'\tLINE FEED'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x07LKY WAY'
'\x02LL'
'\x08LL MOON '
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\x0cLLER COASTER'
'\x07LLEYBUS'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x07LLOWING'
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOBE '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG OVER '
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOON'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'\x16LOW PARAPHRASE BRACKET'
'\x08LOW TONE'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x02LT'
'\x0bLTERNATE YA'
'\x14LTIPLE MUSICAL NOTES'
'\x08LTRY LEG'
'\x02LU'
'\x0bLU PLUS IGI'
'\x03LUB'
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x08LWAY CAR'
'\x02LX'
'\x02LY'
'\x04LY H'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x0bM TIMES SHE'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x05MALL '
'\x06MALL A'
'#MALL ARABIC LETTER TAH AND TWO DOTS'
'\x08MALL AXE'
'\x06MALL F'
'\x0cMALL LETTER '
'\x15MALL Q WITH HOOK TAIL'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\x0eMARK LOWER DOT'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAY'
'\x02MB'
'\x03MBA'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x08MBINING '
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\x19MBOL FOR SAMARITAN SOURCE'
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\nME PLUS DA'
'\nME PLUS EN'
'\x11ME PLUS GAN2 TENU'
'\x08MEASURE '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x07MEDIUM '
'\x04MEEM'
'\nMEEM WITH '
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x04MERA'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x03MID'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE TILDE'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\nMILLE SIGN'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\x05MISRA'
'\x03MIT'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\x02MP'
'\x03MPL'
'\x05MROCK'
'\x05MSHAE'
'\x03MSP'
'\x02MU'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x07N WITH '
'\x12N WITH MIDDLE HOOK'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x03NAH'
'\nNAKE BELOW'
'\x03NAP'
'\x03NAR'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x05NCESS'
'\x03ND '
'\x0bND TWO DOTS'
'\x08NDA FACE'
'\nNDA PA NJI'
'\x04NDA2'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x03NE '
'\x0cNE HALF SIGN'
'\x06NE OF '
'\x04NED '
'\x05NEGAR'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x04NEMA'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x0bNEUTRAL YER'
'\x03NEY'
'\x02NG'
'\x03NG '
'\x11NG STROKE OVERLAY'
'\x03NGA'
'\x04NGA2'
'\x03NGE'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x02NI'
'\x08NI ABOVE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\x05NING '
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x04NJAM'
'\x03NJI'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x06NNADA '
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x04NOON'
'\nNOON WITH '
'\x04NOSE'
'\x05NOTCH'
'\x04NOTE'
'\nNOTE WITH '
'\x08NOWLEDGE'
'\x06NOWMAN'
'\tNS SYMBOL'
'\x06NSANAQ'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x05NTAIN'
'\tNTESSENCE'
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x02NU'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\tO HUNDRED'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAT'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x07OCALIC '
'\tOCCLUSION'
'\x06OCENCE'
'\x08OCK SALT'
'\x0bOCOLATE BAR'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\tOENICIAN '
'\x03OF '
'\x0bOF MASHFAAT'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x07OGICAL '
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0cOGONEK ABOVE'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x02OK'
'\x05OKARA'
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x06OLCANO'
'\x03OLD'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x0bOLDING BACK'
'\x04OLIN'
'\nOLLAR SIGN'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\tOMBINING '
'\x04OMBU'
'\x07OMERANG'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0cON US SYMBOL'
'\x13ON VIEWING CEREMONY'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x03ONG'
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\x05ONG S'
'\x0bONG S WITH '
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x10ONJOINING MACRON'
'\tONSONANT '
'\x04ONTH'
'\x07ONTIEEN'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\x06OOPED '
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x05OPARD'
'\x05OPEN '
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x07OPWATCH'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x04ORNS'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x06OSETTE'
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x0fOTA WITH STROKE'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x08OTLESS J'
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x08OTPRINTS'
'\x0cOTTOM HALF O'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x11OUBLE MONOCULAR O'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x13OUR DOT PUNCTUATION'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\tOURA SIGN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\x07OUT HUB'
'\tOUT MOUTH'
'\tOUTH WIND'
'\nOUTHERN TA'
'\x0cOUTING WHALE'
'\x15OVAL WITH OVAL INSIDE'
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\tOVER LONG'
'\tOVER MUSH'
'\x08OVER NUN'
'\x08OVER SAG'
'\tOVER SHE '
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x02OW'
'\x03OW '
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x1bOWN POINTING BACKHAND INDEX'
'\x1cOWN-POINTING DOUBLE TRIANGLE'
'\x07OX BACK'
'\x02OY'
'\x03OZE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\x11P ON BLACK SQUARE'
'\x07P PIEET'
'\nP STREAMER'
'\x07P WITH '
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x03PAH'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x0cPAP PLUS PAP'
'\x05PARAQ'
'\x0bPARENTHESIS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x11PE WITH DESCENDER'
'\x0bPEDESTRIANS'
'\x04PEEP'
'\x04PEN '
'\x05PEN E'
'\tPEN MOUTH'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x04PER '
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x18PERSET PRECEDING SOLIDUS'
'\x08PERSIAN '
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x0ePHONE RECEIVER'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x06PICKET'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x05PIRIT'
'\x10PLACEHOLDER MARK'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUG'
'\x04PLUM'
'\nPLUS ERIN2'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\nPOLICE CAR'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\tPPOINTED '
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\x0ePROTECTED AREA'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x06PSTICK'
'\x05PTIC '
'\x05PTIVE'
'\x02PU'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x08PUSHPIKA'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x01Q'
'\x07Q WITH '
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x0fQUADRUPLE ARROW'
' QUALS SIGN ABOVE LEFTWARDS ARROW'
'\x05QUARE'
'\x0cQUARE BUTTON'
'\x06QUARED'
'\x07QUARTER'
'\x0bQUARTER ASH'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\tQUEEN OF '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x06R FACE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x02R0'
'\x02R2'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x05RADA '
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x08RAL FACE'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x0cRANCHING OUT'
'\rRANGE DIAMOND'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x07RARIETY'
'\x05RASHA'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x08RAUGHTS '
'\x03RAY'
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x08RECT HIT'
'\nRED CIRCLE'
'\nRED DRAGON'
'\x08RED FACE'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x0bREE HUNDRED'
'\x05REEK '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x05RELAA'
'\x06REMEDY'
'\x06RENGTH'
'\x04REPA'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x08REVERSE '
'\tREVERSED '
'\x0fREVERSED OPEN E'
'\x04RFER'
'\x02RG'
'\x04RGE '
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x0cRIAGE RETURN'
'\x0cRIAL TRAMWAY'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x03RIG'
'\x05RIGHT'
'\x06RIGHT '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x0fRIGHT RERENGGAN'
'\x0bRIGHT-HAND '
'\x0fRIGHT-POINTING '
'\x14RIGHT-POINTING ANGLE'
'+RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x10RIGHTWARDS ARROW'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x03RII'
'\x06RIKRIK'
'\x07RILLIC '
'\x04RIN2'
'\x04RING'
'\nRING ABOVE'
'\nRING BELOW'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x06RIPT G'
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\x0eRK NOON GHUNNA'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x03RMT'
'\x0cRMUKHI SIGN '
'\x05RNED '
'\nRNING SIGN'
'\x02RO'
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROITIC '
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x04ROLL'
'\x03ROM'
'\x03RON'
'\x1bRONOMICAL SYMBOL FOR URANUS'
'\x04ROSH'
'\x04ROSS'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\rRPENTRY PLANE'
'\x02RR'
'\x03RRA'
'\rRRIAGE SYMBOL'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x02RT'
'\x06RT OF '
'\x06RTCAKE'
'\tRTER MARK'
'\x04RTH '
'\x07RTHIAN '
'\x07RTICAL '
'\x17RTOISE SHELL BRACKETED '
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0fS IN SILHOUETTE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x02S0'
'\x02SA'
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAG'
'\x03SAH'
'\x03SAL'
'\rSAL PLUS TUG2'
'\nSALIZATION'
'\x08SALT OF '
'\x03SAM'
'\x06SANDAL'
'\x04SANG'
'\x07SANGAN '
'\x05SARGA'
'\x05SASAK'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\nSEEN WITH '
'\rSELECTED AREA'
'\tSEMICOLON'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x06SERET '
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x07SEVENTH'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\tSH SYMBOL'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\x04SHAD'
'\x04SHAE'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x04SHES'
'\x05SHESH'
'\x07SHESHIG'
'\x05SHGAB'
'\x07SHIFT T'
'\x05SHIMA'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x04SHU2'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\tSIVE FACE'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x05SLASH'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x0eSMALL CAPITAL '
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\rSMALL LETTER '
'\rSMALL LETTERS'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\x12SMALL WHITE CIRCLE'
'\tSMALL YUS'
'\x0cSMILING EYES'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x02SO'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x0eSOUTH ARABIAN '
'\x02SP'
'\x05SPACE'
'\x13SPACING CANDRABINDU'
'\x06SPADES'
'\x06SPAPER'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x0cSQUIQUADRATE'
'\x02SS'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x04SSOM'
'\x0eSSPORT CONTROL'
'\x02ST'
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x07STATERS'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x07STITUTE'
'\x04STLE'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x0bSTORIC SITE'
'\x03STR'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x18STROKE THROUGH DESCENDER'
'\nSTRUCTION '
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x13SUBSTITUTION MARKER'
'\x04SUKU'
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x07SVARITA'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x03TAB'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x06TAGRAM'
'\x03TAH'
'\x17TAH WITH TWO DOTS ABOVE'
'\x08TAI LUE '
'\x04TAIL'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x03TAR'
'\x06TAU RO'
'\x06TAUROS'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\x0cTCHING CHICK'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\x06TEDUNG'
'\x03TEE'
'\x05TEGEH'
'\x0fTELLITE ANTENNA'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x07THIEUTH'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\x06THREE '
'\x10THREE DOTS ABOVE'
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x03THW'
'\x02TI'
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x0bTIEE SHEUOQ'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x04TILL'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x05TMAAU'
'\x05TNESS'
'\x06TO BOX'
'\x03TOM'
'\x0bTONAL MARK '
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x15TONE MARK SGAW KAREN '
'\x05TONE-'
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x05TORCH'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x02TR'
'\x0cTRAGRAM FOR '
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x15TRANSPOSITION BRACKET'
'\x14TRANSPOSITION MARKER'
'\x14TRATERRESTRIAL ALIEN'
'\x03TRE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x0bTRIAN CAMEL'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x05TRING'
'\x05TRIOL'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x05TROKE'
'\x18TROL SEQUENCE INTRODUCER'
'\x03TSA'
'\x03TSE'
'\x02TT'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x05TTOM '
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
"'TWO DOTS VERTICALLY BELOW AND SMALL TAH"
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x0bTWO-HEADED '
'\x02TY'
'\x0fTYSCAPE AT DUSK'
'\x01U'
'\x02U '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x03U U'
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x02U0'
'\x02U2'
'\x02U3'
'\nU3 PLUS AN'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x10UBLE PARENTHESIS'
'\x0fUBLE RING BELOW'
'\x0cUBLE SVARITA'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x06UCIBLE'
'\x02UD'
'\x05UDAAT'
'\x06UDATTA'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x02UG'
'\x06UGGAGE'
'\x04UGU '
'\x02UH'
'\x04UHUR'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x05UMPET'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x0bUND PUSHPIN'
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x03UNO'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x1aUP POINTING BACKHAND INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x18UP WITH EXCLAMATION MARK'
'\x1bUP-POINTING DOUBLE TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x08UROPEAN '
'\x03URT'
'\x03URU'
'\x02US'
'\x07US TENT'
'\tUSED FACE'
'\x03USH'
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x02UT'
'\x04UTAE'
'\x05UTEUX'
'\x04UTH '
'\x0bUTH CORNERS'
'\x05UTIES'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02V0'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\x07VANESE '
'\x07VAPOURS'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x08VE SASAK'
'\x04VEDE'
'\x03VEE'
'!VELOPE WITH DOWNWARDS ARROW ABOVE'
'\tVELOPMENT'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x17VERTICAL BAR WITH QUILL'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x08VESSEL B'
'\x07VESTAN '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x02VI'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x03VIN'
'\x04VINE'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x03VOP'
'\x0cVORCE SYMBOL'
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x11VOWEL LENGTH MARK'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x04VUEQ'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\x13W BRIGHTNESS SYMBOL'
'\nW OR MODEL'
'\x08W PRINTS'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\x03WAN'
'\x06WARDS '
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x05WEST '
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x05WFISH'
'\x02WG'
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x1cWHITE DOWN-POINTING TRIANGLE'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\x05WIANG'
'\x07WIGNYAN'
'\x05WINDU'
'\nWING HEART'
'\tWING STAR'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\tWITH CURL'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\x0cWITH STROKE '
'\tWITH TIP '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x05WLING'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x1aWNING FACE WITH OPEN MOUTH'
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\tWRY SMILE'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x07X BELOW'
'\tX MACHINE'
'\x1eX POINTED STAR WITH MIDDLE DOT'
'\x13X WITH PALATAL HOOK'
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x02XG'
'\tXHAUSTION'
'\x02XI'
'\x05XING '
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x05XTRA-'
'\x03XWG'
'\x01Y'
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x0eY SMALL SQUARE'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\x06YIN-DO'
'\x10YIR MKPARAQ MEUN'
'\x05YIZET'
'\x08YLLABLE '
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\x1bYMBOL MULTIPLE MEASURE REST'
'\x02YN'
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x04YODH'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x02YP'
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x08YRILLIC '
'\nYRILLIC EN'
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x0eZAKAYA LANTERN'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\tZIR SASAK'
'\x03ZOA'
'\x03ZOO'
'\x02ZW'
'\x08ZWARAKAY'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68108,
 -58426,
 -1,
 132311,
 34379,
 -1,
 197838,
 88555,
 -1,
 263229,
 161937,
 -1,
 327835,
 210122,
 -1,
 393314,
 265921,
 73909,
 458832,
 330803,
 73911,
 589823,
 393216,
 -1,
 589903,
 492145,
 -1,
 655378,
 528065,
 -1,
 720910,
 591057,
 -1,
 -65524,
 672000,
 73914,
 -65523,
 735409,
 73913,
 -1,
 795442,
 73912,
 983056,
 685861,
 73917,
 -1,
 920684,
 73918,
 -65519,
 940141,
 73916,
 -1,
 1054734,
 73915,
 1245211,
 619918,
 -1,
 1310743,
 1194139,
 -1,
 1376278,
 1255547,
 73957,
 -1,
 1312180,
 73958,
 -1,
 1327034,
 73959,
 1572890,
 1248961,
 -1,
 -65511,
 1535338,
 73956,
 -1,
 1592138,
 73955,
 -1,
 1542313,
 73960,
 1835043,
 1193162,
 -1,
 1900576,
 1785439,
 73933,
 1966111,
 1838386,
 73934,
 -1,
 1901784,
 73935,
 -1,
 1928634,
 73936,
 2228223,
 1838785,
 -1,
 -65502,
 2125162,
 73932,
 -1,
 2185403,
 73931,
 2359338,
 1787958,
 -1,
 2424870,
 2310074,
 73946,
 -1,
 2360626,
 73947,
 2555945,
 2363073,
 -1,
 -65496,
 2521457,
 73945,
 -1,
 2574390,
 73944,
 -1,
 2524849,
 73948,
 2818097,
 2308251,
 -1,
 2883631,
 2756289,
 -1,
 2949166,
 2837322,
 73938,
 -1,
 2884905,
 73939,
 -1,
 2884933,
 73937,
 -65488,
 2852606,
 73941,
 -1,
 3096178,
 73940,
 3276854,
 2762875,
 -1,
 3342388,
 3233901,
 73929,
 -1,
 3278628,
 73930,
 3538943,
 3296074,
 73927,
 -1,
 3409193,
 73928,
 3604539,
 3220174,
 -1,
 3670073,
 3554911,
 73924,
 -1,
 3625582,
 73925,
 -65478,
 3639035,
 73926,
 -1,
 3739329,
 73923,
 3932225,
 3545077,
 -1,
 3997758,
 3902145,
 73921,
 -1,
 3933563,
 73922,
 4194303,
 3935937,
 -1,
 -65472,
 4091279,
 73920,
 -1,
 4137678,
 73919,
 4325444,
 3901003,
 73962,
 4456447,
 4268750,
 73963,
 -1,
 4326643,
 73964,
 4522054,
 4283490,
 73952,
 -1,
 4457579,
 73953,
 4653129,
 4477476,
 -1,
 -65464,
 4603487,
 73951,
 -1,
 4663549,
 73950,
 4849740,
 4603487,
 -1,
 -65461,
 4814636,
 73943,
 -1,
 4863760,
 73942,
 -65459,
 4816677,
 73961,
 -65458,
 5007170,
 73954,
 -1,
 5065592,
 73949,
 -1,
 550265,
 73965,
 5308502,
 415853,
 73974,
 5439487,
 5246003,
 73975,
 5505023,
 5308416,
 -1,
 -65452,
 5406830,
 73976,
 -65451,
 5465474,
 73977,
 -1,
 5513629,
 73978,
 5701721,
 5262154,
 73970,
 -65448,
 5640950,
 73972,
 -1,
 5702116,
 73971,
 5898331,
 5664106,
 73979,
 -1,
 5835978,
 73980,
 6029405,
 5841614,
 73968,
 -1,
 5964731,
 73969,
 6160479,
 5969962,
 73966,
 -1,
 6095181,
 73967,
 -65440,
 6125443,
 73981,
 -65439,
 6246948,
 73973,
 -1,
 6291987,
 73910,
 6488193,
 343647,
 73984,
 6553709,
 6450538,
 -1,
 6619243,
 6491338,
 73994,
 6750207,
 6555352,
 -1,
 -65433,
 6645570,
 73999,
 -65432,
 6705613,
 73998,
 -65431,
 6766848,
 73997,
 -65430,
 6829411,
 73996,
 -1,
 6885103,
 73995,
 7143423,
 6556723,
 73992,
 -1,
 7012883,
 73993,
 7209079,
 6518158,
 -1,
 7274614,
 7157915,
 74001,
 7405567,
 7208960,
 -1,
 7405685,
 7306809,
 -1,
 7471220,
 7356855,
 -1,
 -65421,
 7438117,
 74004,
 -1,
 7477313,
 74003,
 -1,
 7417077,
 74005,
 -1,
 7348676,
 74002,
 -1,
 7213591,
 74000,
 7864443,
 7146802,
 73988,
 7995391,
 7798784,
 -1,
 -65414,
 7890316,
 73989,
 -1,
 7938487,
 73990,
 8126592,
 7798784,
 -1,
 8192127,
 8094321,
 -1,
 -65410,
 8160843,
 73986,
 -1,
 8202363,
 73985,
 -1,
 8135083,
 73987,
 -1,
 8070402,
 73991,
 8519833,
 6456907,
 74006,
 8585354,
 8457267,
 74008,
 8716287,
 8519680,
 -1,
 8716425,
 8618609,
 -1,
 8781959,
 8669403,
 74009,
 -1,
 8718133,
 74010,
 -65400,
 8746497,
 74012,
 -1,
 8871010,
 74011,
 -1,
 8665200,
 74013,
 9109647,
 8547690,
 74021,
 9175182,
 9078347,
 -1,
 -65395,
 9140005,
 74024,
 -1,
 9197677,
 74023,
 -1,
 9113111,
 74022,
 9437333,
 9052878,
 74014,
 9568255,
 9371648,
 -1,
 9568404,
 9470577,
 -1,
 -65389,
 9521945,
 74016,
 -1,
 9572090,
 74015,
 -1,
 9528725,
 74017,
 9830551,
 9392676,
 74019,
 -1,
 9766761,
 74020,
 -65384,
 9784138,
 74018,
 -1,
 9896284,
 74007,
 10158079,
 8466021,
 73982,
 -1,
 10028883,
 73983,
 10223908,
 281418,
 -1,
 10289392,
 10161857,
 74167,
 10354922,
 10237180,
 -1,
 10420452,
 10295285,
 74168,
 10551295,
 10354688,
 -1,
 10551523,
 10453617,
 -1,
 10617001,
 10489537,
 74169,
 10682534,
 10552529,
 -1,
 -65372,
 10636304,
 74172,
 -65371,
 10696074,
 74171,
 -1,
 10756914,
 74170,
 -65369,
 10647379,
 74175,
 -65368,
 10901613,
 74174,
 -1,
 10963786,
 74173,
 11141296,
 10585675,
 74213,
 11206829,
 11076817,
 -1,
 -65364,
 11175511,
 74215,
 -1,
 11210433,
 74214,
 -65362,
 11171621,
 74218,
 -65361,
 11346638,
 74217,
 -1,
 11406433,
 74216,
 11600057,
 11105678,
 -1,
 11665592,
 11548827,
 -1,
 11731124,
 11634347,
 74207,
 -1,
 11666847,
 74208,
 11862199,
 11683347,
 -1,
 -65354,
 11829358,
 74206,
 -1,
 11889110,
 74205,
 -1,
 11806983,
 74204,
 -1,
 11634857,
 74209,
 12189888,
 11552822,
 -1,
 12255422,
 12158539,
 -1,
 12320957,
 12208970,
 74194,
 -1,
 12256527,
 74195,
 -1,
 12258506,
 74193,
 12582911,
 12205663,
 74191,
 -1,
 12474477,
 74192,
 12648645,
 12143434,
 -1,
 12714179,
 12617291,
 74198,
 -1,
 12667722,
 74199,
 -65340,
 12666254,
 74197,
 -1,
 12783923,
 74196,
 12976331,
 12598879,
 -1,
 13041866,
 12931620,
 74188,
 13172735,
 12977361,
 -1,
 -65335,
 13062602,
 74190,
 -1,
 13121713,
 74189,
 -1,
 12990224,
 74187,
 13369552,
 12924106,
 -1,
 13435086,
 13338590,
 74182,
 -1,
 13370629,
 74183,
 13631487,
 13373121,
 74180,
 -1,
 13528426,
 74181,
 13697237,
 13336121,
 -1,
 13762772,
 13635265,
 -1,
 -65325,
 13715589,
 74211,
 -1,
 13776074,
 74210,
 -1,
 13707492,
 74212,
 14024921,
 13652516,
 -1,
 14090456,
 13969531,
 74200,
 -1,
 14025980,
 74201,
 -1,
 14060376,
 74202,
 14287069,
 13973659,
 -1,
 14352604,
 14225089,
 74184,
 -1,
 14306122,
 74185,
 -1,
 14302870,
 74186,
 14549216,
 14227445,
 -1,
 -65313,
 14499423,
 74177,
 -1,
 14553159,
 74176,
 -65311,
 14506397,
 74203,
 -65310,
 14691325,
 74179,
 -1,
 14754720,
 74178,
 -1,
 10517376,
 74219,
 15073279,
 10382698,
 74220,
 15138815,
 14942208,
 -1,
 15139048,
 15041164,
 74221,
 -1,
 15074730,
 74222,
 15335423,
 15087728,
 74223,
 -1,
 15205427,
 74224,
 15401197,
 10310180,
 74228,
 15532031,
 15337299,
 74229,
 -1,
 15402372,
 74230,
 15597807,
 15354698,
 74226,
 -1,
 15533918,
 74227,
 -1,
 15547911,
 74225,
 15794464,
 10257995,
 74235,
 15859987,
 15731763,
 74237,
 15990783,
 15794176,
 -1,
 15991054,
 15892025,
 -1,
 16056589,
 15942071,
 -1,
 16122107,
 16009270,
 -1,
 16187642,
 16060487,
 -1,
 16253177,
 16125130,
 74246,
 -1,
 16188640,
 74247,
 -1,
 16190515,
 74245,
 -1,
 16137823,
 74248,
 16515326,
 16087156,
 -1,
 -65283,
 16468090,
 74255,
 -1,
 16516320,
 74254,
 16711937,
 16472173,
 -1,
 -65280,
 16680523,
 74253,
 -1,
 16722043,
 74252,
 16908548,
 16665464,
 -1,
 -65277,
 16856340,
 74250,
 -1,
 16909536,
 74249,
 17105158,
 16854618,
 74240,
 -1,
 17041077,
 74241,
 -65273,
 17073402,
 74256,
 -65272,
 17192171,
 74251,
 -65271,
 17252743,
 74244,
 -65270,
 17316588,
 74243,
 -65269,
 17380707,
 74242,
 -65268,
 17438785,
 74239,
 -1,
 17502743,
 74238,
 -1,
 16002293,
 74257,
 17760529,
 15955342,
 -1,
 -65264,
 17722567,
 74260,
 -1,
 17775256,
 74261,
 -65262,
 17719831,
 74259,
 -1,
 17900011,
 74258,
 18088217,
 15807806,
 74263,
 18219007,
 18022400,
 -1,
 18219288,
 18111719,
 -1,
 -65257,
 18189588,
 74264,
 -1,
 18246365,
 74265,
 -1,
 18184181,
 74266,
 18481436,
 18043428,
 74269,
 18612223,
 18416712,
 74270,
 -1,
 18481663,
 74271,
 -65251,
 18434890,
 74268,
 -65250,
 18626715,
 74267,
 -65249,
 18681034,
 74262,
 -1,
 18745082,
 74236,
 19005439,
 15744607,
 74231,
 -65246,
 18904869,
 74234,
 -65245,
 18962144,
 74233,
 -1,
 19024714,
 74232,
 19202457,
 10176566,
 -1,
 19267967,
 19140289,
 74071,
 19333481,
 19203800,
 -1,
 19398964,
 19281098,
 -1,
 19464493,
 19336897,
 74082,
 19530027,
 19426666,
 74085,
 -1,
 19465613,
 74086,
 -65236,
 19486907,
 74084,
 -1,
 19614538,
 74083,
 19792178,
 19414623,
 74087,
 19857713,
 19756840,
 -1,
 -65232,
 19818988,
 74089,
 -1,
 19866052,
 74090,
 -1,
 19819959,
 74088,
 20185087,
 19760715,
 74091,
 -1,
 20082117,
 74092,
 20250942,
 19363214,
 -1,
 20316474,
 20199579,
 -1,
 -65225,
 20285003,
 74115,
 -65224,
 20332474,
 74114,
 -65223,
 20392059,
 74113,
 -1,
 20451009,
 74112,
 20644156,
 20254401,
 74110,
 -1,
 20606314,
 74111,
 -65219,
 20613172,
 74117,
 -1,
 20725887,
 74116,
 20906310,
 20206116,
 -1,
 20971844,
 20850811,
 74100,
 21102591,
 20907217,
 -1,
 -65214,
 21004215,
 74103,
 -65213,
 21051149,
 74102,
 -1,
 21112836,
 74101,
 21364735,
 20921951,
 74104,
 -1,
 21235055,
 74105,
 21430603,
 20874827,
 74119,
 -65208,
 21395237,
 74123,
 -65207,
 21452782,
 74122,
 -65206,
 21504718,
 74121,
 -1,
 21564467,
 74120,
 21758289,
 21370869,
 -1,
 21823824,
 21696193,
 -1,
 -65202,
 21785962,
 74078,
 -65201,
 21842885,
 74077,
 -1,
 21897934,
 74076,
 -1,
 21773919,
 74079,
 22151509,
 21696193,
 74072,
 22217044,
 22094542,
 74073,
 -1,
 22152479,
 74074,
 -1,
 22181728,
 74075,
 22413657,
 22104118,
 -1,
 22479192,
 22363743,
 74096,
 -1,
 22422222,
 74097,
 -1,
 22417911,
 74095,
 22675804,
 22370413,
 -1,
 -65189,
 22644978,
 74107,
 -1,
 22685819,
 74106,
 22872415,
 22629194,
 -1,
 -65186,
 22840907,
 74099,
 -1,
 22888031,
 74098,
 23069026,
 22822495,
 -1,
 -65183,
 23024164,
 74094,
 -1,
 23082765,
 74093,
 23265637,
 23013499,
 -1,
 -65180,
 23230304,
 74081,
 -1,
 23294697,
 74080,
 -65178,
 23238450,
 74124,
 -65177,
 23429002,
 74118,
 -65176,
 23491857,
 74109,
 -1,
 23554335,
 74108,
 23724399,
 19276494,
 -1,
 23789932,
 23661936,
 74131,
 -1,
 23725083,
 74132,
 -65171,
 23727410,
 74130,
 -65170,
 23858378,
 74129,
 -1,
 23923763,
 74128,
 24117619,
 23689585,
 74140,
 24248319,
 24051712,
 -1,
 -65166,
 24143303,
 74142,
 -1,
 24202191,
 74141,
 24379767,
 24070986,
 74135,
 24510463,
 24313856,
 -1,
 -65162,
 24412792,
 74136,
 -1,
 24453598,
 74137,
 24641914,
 24334884,
 -1,
 -65159,
 24579378,
 74139,
 -1,
 24644659,
 74138,
 24838524,
 24594486,
 74133,
 -1,
 24774453,
 74134,
 24969598,
 24775731,
 74125,
 -1,
 24904041,
 74126,
 -1,
 24909813,
 74127,
 25166219,
 19236427,
 74154,
 25231746,
 25128298,
 74163,
 -1,
 25166738,
 74164,
 25362820,
 25185098,
 74160,
 -1,
 25297427,
 74161,
 25493894,
 25300274,
 74157,
 -1,
 25429904,
 74158,
 -65145,
 25458794,
 74165,
 -65144,
 25581677,
 74162,
 -65143,
 25628183,
 74159,
 -65142,
 25693386,
 74156,
 -1,
 25756626,
 74155,
 25952663,
 25116255,
 74144,
 26018193,
 25916814,
 -1,
 26083727,
 25969034,
 74152,
 -1,
 26018854,
 74153,
 -65136,
 26032283,
 74151,
 -1,
 26153495,
 74150,
 26345877,
 25954008,
 -1,
 26411412,
 26314315,
 74146,
 -1,
 26354382,
 74147,
 -1,
 26351681,
 74145,
 -65130,
 26302573,
 74149,
 -1,
 26550990,
 74148,
 -65128,
 25924491,
 74166,
 -1,
 26685018,
 74143,
 26870272,
 19166606,
 -1,
 26935761,
 26818715,
 -1,
 27001268,
 26885727,
 -1,
 27066794,
 26956324,
 74438,
 27197439,
 27002584,
 -1,
 27197856,
 27083008,
 74444,
 -1,
 27132435,
 74445,
 27328931,
 27138037,
 -1,
 -65118,
 27297956,
 74441,
 -1,
 27333143,
 74440,
 -65116,
 27293181,
 74449,
 -65115,
 27482061,
 74448,
 -65114,
 27546081,
 74447,
 -65113,
 27609885,
 74446,
 -65112,
 27669898,
 74443,
 -65111,
 27731211,
 74442,
 -1,
 27791041,
 74439,
 27984302,
 27028842,
 74451,
 28114943,
 27918336,
 -1,
 -65107,
 28016750,
 74452,
 -1,
 28075556,
 74453,
 28246450,
 27927246,
 74435,
 28377087,
 28182232,
 -1,
 -65103,
 28262791,
 74437,
 -1,
 28315329,
 74436,
 -65101,
 28212911,
 74454,
 -1,
 28465795,
 74450,
 28639682,
 26939073,
 74413,
 28705215,
 28576970,
 74414,
 28835839,
 28640984,
 -1,
 28836281,
 28739147,
 74421,
 -1,
 28771544,
 74422,
 -65094,
 28804400,
 74420,
 -65093,
 28932202,
 74419,
 -65092,
 28989853,
 74418,
 -65091,
 29046619,
 74417,
 -65090,
 29104193,
 74416,
 -1,
 29167297,
 74415,
 -65088,
 28667319,
 74425,
 -65087,
 29300771,
 74424,
 -1,
 29363677,
 74423,
 29557197,
 28584059,
 74426,
 29622726,
 29521701,
 74432,
 -65083,
 29576212,
 74434,
 -1,
 29625395,
 74433,
 29819339,
 29556736,
 -1,
 29884874,
 29779482,
 -1,
 -65079,
 29851333,
 74429,
 -1,
 29898012,
 74428,
 -1,
 29834764,
 74427,
 -65076,
 29775981,
 74431,
 -1,
 30094585,
 74430,
 30343167,
 29525579,
 74455,
 -65073,
 30219149,
 74458,
 -65072,
 30280755,
 74457,
 -1,
 30344200,
 74456,
 30540272,
 26873537,
 74387,
 30605804,
 30487754,
 74389,
 30736383,
 30539776,
 -1,
 30736873,
 30638705,
 -1,
 30802395,
 30705227,
 -1,
 -65065,
 30766885,
 74406,
 -65064,
 30829930,
 74405,
 -65063,
 30888484,
 74404,
 -65062,
 30939125,
 74403,
 -1,
 31001651,
 74402,
 31195614,
 30766478,
 -1,
 -65059,
 31144697,
 74400,
 -1,
 31199767,
 74399,
 31392225,
 31148086,
 -1,
 -65056,
 31361729,
 74395,
 -1,
 31396343,
 74394,
 31588835,
 31336452,
 74391,
 -1,
 31528949,
 74392,
 -65052,
 31555265,
 74401,
 -65051,
 31677538,
 74398,
 -65050,
 31741453,
 74397,
 -65049,
 31805925,
 74396,
 -65048,
 31865009,
 74393,
 -1,
 31919809,
 74390,
 -65046,
 30696977,
 74407,
 -65045,
 32070780,
 74388,
 -1,
 32127088,
 74408,
 32309742,
 30559050,
 74409,
 -1,
 32244376,
 74410,
 -65041,
 32271722,
 74412,
 -1,
 32397902,
 74411,
 32571897,
 30508619,
 74466,
 32637427,
 32533866,
 74473,
 -1,
 32575114,
 74474,
 32768501,
 32592420,
 74471,
 -1,
 32708113,
 74472,
 32899575,
 32711374,
 74468,
 -1,
 32836659,
 74469,
 -65032,
 32849467,
 74470,
 -1,
 32965791,
 74467,
 33226751,
 32521823,
 74459,
 33227261,
 33109194,
 74461,
 33357823,
 33164594,
 74462,
 -1,
 33227919,
 74463,
 -65026,
 33180548,
 74465,
 -65025,
 33376375,
 74464,
 -1,
 33423891,
 74460,
 33620580,
 26838603,
 74507,
 33686068,
 33582442,
 74536,
 33751585,
 33654347,
 74551,
 33817119,
 33687256,
 -1,
 33882634,
 33764554,
 -1,
 33948169,
 33820353,
 74556,
 -65017,
 33910122,
 74559,
 -65016,
 33970363,
 74558,
 -1,
 34032458,
 74557,
 -1,
 33916491,
 74560,
 34275854,
 33850955,
 -1,
 -65012,
 34239769,
 74574,
 -65011,
 34284238,
 74573,
 -1,
 34342149,
 74572,
 34538002,
 34225759,
 -1,
 -65008,
 34502437,
 74564,
 -65007,
 34558500,
 74563,
 -1,
 34617101,
 74562,
 34800149,
 34502030,
 -1,
 -65004,
 34750601,
 74570,
 -1,
 34814483,
 74569,
 34996759,
 34737857,
 74552,
 -1,
 34961405,
 74553,
 -65000,
 34964723,
 74571,
 -64999,
 35088194,
 74568,
 -64998,
 35149434,
 74567,
 -64997,
 35213797,
 74566,
 -64996,
 35277353,
 74565,
 -64995,
 35338417,
 74561,
 -64994,
 35399718,
 74555,
 -1,
 35461250,
 74554,
 35717119,
 33760043,
 74575,
 -1,
 35587956,
 74576,
 35783214,
 33688627,
 74539,
 35913727,
 35718872,
 -1,
 35914279,
 35817131,
 74545,
 36044799,
 35849425,
 -1,
 -64986,
 35920303,
 74547,
 -1,
 35984913,
 74546,
 36176428,
 35851969,
 -1,
 36241963,
 36111569,
 -1,
 -64982,
 36198595,
 74541,
 -1,
 36255921,
 74540,
 -1,
 36195146,
 74542,
 -64979,
 36133986,
 74544,
 -1,
 36452529,
 74543,
 36635184,
 35733087,
 74549,
 -1,
 36572362,
 74550,
 36766259,
 36569088,
 -1,
 -64974,
 36730869,
 74538,
 -1,
 36774431,
 74537,
 -1,
 36703538,
 74548,
 37028416,
 33628878,
 74515,
 37093951,
 36962304,
 -1,
 37159483,
 37061233,
 -1,
 37225017,
 37127776,
 74519,
 -1,
 37159443,
 74520,
 -64966,
 37180941,
 74518,
 -1,
 37296193,
 74517,
 37487165,
 37124085,
 74522,
 -1,
 37422842,
 74523,
 -64962,
 37440285,
 74516,
 -1,
 37566576,
 74521,
 -1,
 37062690,
 74524,
 37814859,
 36983332,
 74525,
 37880390,
 37750488,
 -1,
 -64957,
 37848651,
 74529,
 -64956,
 37910376,
 74528,
 -64955,
 37967072,
 74527,
 -1,
 38030281,
 74526,
 38208074,
 37849257,
 74531,
 38338559,
 38143704,
 -1,
 -64951,
 38233922,
 74533,
 -1,
 38291745,
 74532,
 -1,
 38148584,
 74530,
 38535764,
 37779237,
 74577,
 38601297,
 38471384,
 -1,
 38666831,
 38554386,
 74579,
 -1,
 38628714,
 74580,
 -64944,
 38633253,
 74581,
 -1,
 38735553,
 74578,
 -64942,
 38572959,
 74582,
 -64941,
 38897902,
 74584,
 -1,
 38931507,
 74583,
 39125595,
 38469632,
 -1,
 39191129,
 39085671,
 -1,
 -64937,
 39159408,
 74512,
 -64936,
 39222675,
 74511,
 -1,
 39282515,
 74510,
 -64934,
 39159435,
 74509,
 -1,
 39401564,
 74508,
 39584351,
 39097907,
 -1,
 39649886,
 39521482,
 74586,
 -1,
 39585605,
 74587,
 -1,
 39618123,
 74588,
 39846497,
 39540845,
 74534,
 -1,
 39780883,
 74535,
 -64926,
 39814433,
 74585,
 -64925,
 39917557,
 74514,
 -1,
 39980083,
 74513,
 40174259,
 33558209,
 73728,
 40239740,
 40114165,
 73738,
 40305269,
 40173568,
 -1,
 40370804,
 40272497,
 -1,
 40436331,
 40320607,
 -1,
 -64918,
 40392314,
 73745,
 -1,
 40449808,
 73744,
 40632942,
 40383740,
 -1,
 -64915,
 40589499,
 73742,
 -1,
 40651594,
 73741,
 -64913,
 40601184,
 73748,
 -64912,
 40794095,
 73747,
 -64911,
 40848329,
 73746,
 -64910,
 40908977,
 73743,
 -64909,
 40970282,
 73740,
 -1,
 41031189,
 73739,
 -1,
 40319088,
 73749,
 41353215,
 40242227,
 73750,
 41418751,
 41223896,
 -1,
 -64904,
 41320229,
 73755,
 -64903,
 41383784,
 73754,
 -64902,
 41440491,
 73753,
 -64901,
 41497955,
 73752,
 -1,
 41556058,
 73751,
 41747081,
 40192842,
 73760,
 41812615,
 41682648,
 -1,
 41878145,
 41764918,
 -1,
 -64896,
 41827935,
 73766,
 -1,
 41881674,
 73765,
 -64894,
 41847640,
 73768,
 -64893,
 42039250,
 73767,
 -64892,
 42088625,
 73764,
 -64891,
 42153819,
 73763,
 -64890,
 42214662,
 73762,
 -1,
 42275351,
 73761,
 -64888,
 41758011,
 73770,
 -1,
 42406695,
 73769,
 42599061,
 41710990,
 -1,
 42664596,
 42547355,
 73784,
 42730130,
 42598400,
 -1,
 42795664,
 42689866,
 -1,
 42861199,
 42755393,
 73788,
 -1,
 42795309,
 73789,
 -1,
 42829055,
 73787,
 -64879,
 42768181,
 73785,
 -1,
 43010229,
 73786,
 -64877,
 42677524,
 73791,
 -1,
 43125811,
 73790,
 -1,
 42603070,
 73783,
 43385502,
 42534616,
 -1,
 -64873,
 43349493,
 73736,
 -64872,
 43407408,
 73735,
 -64871,
 43469808,
 73734,
 -64870,
 43532544,
 73733,
 -64869,
 43595953,
 73732,
 -64868,
 43660643,
 73731,
 -64867,
 43718721,
 73730,
 -1,
 43781825,
 73729,
 43975334,
 43341933,
 73773,
 44040869,
 43909120,
 -1,
 44106403,
 44001761,
 -1,
 -64862,
 44071808,
 73777,
 -1,
 44130793,
 73776,
 -64860,
 44073411,
 73775,
 -1,
 44262713,
 73774,
 -1,
 44005330,
 73778,
 44499626,
 43937130,
 -1,
 44565161,
 44437575,
 73780,
 -1,
 44500819,
 73781,
 -1,
 44517553,
 73782,
 44761774,
 44451894,
 73757,
 44892159,
 44697304,
 -1,
 -64851,
 44791825,
 73759,
 -1,
 44838382,
 73758,
 45023920,
 44717031,
 73771,
 -1,
 44959593,
 73772,
 -64847,
 44984670,
 73779,
 -64846,
 45097678,
 73756,
 -1,
 45157427,
 73737,
 45351677,
 40130669,
 -1,
 45417169,
 45319755,
 74337,
 45482704,
 45373549,
 74339,
 45548229,
 45452241,
 74349,
 45678591,
 45481984,
 -1,
 45679299,
 45551455,
 -1,
 -64838,
 45647531,
 74359,
 -64837,
 45709491,
 74358,
 -64836,
 45767069,
 74357,
 -64835,
 45828984,
 74356,
 -64834,
 45893827,
 74355,
 -64833,
 45957380,
 74354,
 -64832,
 46020700,
 74353,
 -64831,
 46082082,
 74352,
 -64830,
 46143919,
 74351,
 -1,
 46208538,
 74350,
 46465023,
 45632099,
 74360,
 -1,
 46335885,
 74361,
 46596095,
 45481984,
 -1,
 46596812,
 46484475,
 -1,
 46662345,
 46560765,
 74342,
 -1,
 46597237,
 74343,
 -64822,
 46631768,
 74344,
 -64821,
 46748734,
 74341,
 -1,
 46806410,
 74340,
 46990030,
 46539270,
 74347,
 -1,
 46924458,
 74348,
 -64817,
 46956654,
 74345,
 -1,
 47080968,
 74346,
 -1,
 45419541,
 74338,
 47317740,
 45366879,
 74316,
 47383269,
 47274327,
 74322,
 47513599,
 47318744,
 -1,
 47514329,
 47413202,
 74330,
 47644671,
 47449304,
 -1,
 47645400,
 47544101,
 74332,
 -1,
 47580384,
 74333,
 -1,
 47579190,
 74331,
 47842013,
 47451841,
 -1,
 47907548,
 47806245,
 74324,
 -1,
 47842528,
 74325,
 -1,
 47863917,
 74323,
 48104160,
 47810123,
 -1,
 -64801,
 48068389,
 74335,
 -1,
 48106593,
 74334,
 48300771,
 48060525,
 -1,
 -64798,
 48269554,
 74329,
 -1,
 48310395,
 74328,
 -64796,
 48256246,
 74327,
 -1,
 48445532,
 74326,
 48628457,
 47338020,
 74319,
 48758783,
 48563994,
 -1,
 -64792,
 48655742,
 74321,
 -1,
 48715963,
 74320,
 -64790,
 48592373,
 74336,
 -64789,
 48827443,
 74318,
 -1,
 48891653,
 74317,
 49087223,
 47255233,
 74302,
 49152755,
 49034492,
 74304,
 49218290,
 49086464,
 -1,
 -64784,
 49185430,
 74306,
 -64783,
 49242660,
 74307,
 -1,
 49300538,
 74305,
 -1,
 49180010,
 74308,
 49545974,
 49107492,
 74310,
 -64779,
 49482803,
 74311,
 -1,
 49546086,
 74309,
 -1,
 49482803,
 74303,
 49872895,
 49031291,
 74312,
 49938431,
 49741824,
 -1,
 49939196,
 49840753,
 -1,
 -64773,
 49907678,
 74314,
 -1,
 49942209,
 74313,
 -1,
 49903605,
 74315,
 50201403,
 45294286,
 -1,
 50266914,
 50138817,
 73813,
 50332445,
 50214090,
 73814,
 50462719,
 50266755,
 -1,
 50463495,
 50345162,
 -1,
 50529028,
 50413151,
 73821,
 -1,
 50490807,
 73822,
 50660102,
 50466497,
 73819,
 -1,
 50595160,
 73820,
 -1,
 50628574,
 73823,
 50856716,
 50416458,
 -1,
 50922251,
 50824779,
 73829,
 -64758,
 50876964,
 73831,
 -1,
 50922851,
 73830,
 -1,
 50859713,
 73828,
 51184399,
 50824779,
 -1,
 -64754,
 51148581,
 73837,
 -1,
 51186807,
 73836,
 51381009,
 51135760,
 73825,
 -1,
 51316028,
 73826,
 51512084,
 51320821,
 -1,
 -64749,
 51461727,
 73818,
 -1,
 51515975,
 73817,
 51708695,
 51449537,
 -1,
 -64746,
 51663847,
 73816,
 -1,
 51709272,
 73815,
 -64744,
 51674917,
 73835,
 -64743,
 51869812,
 73834,
 -64742,
 51931085,
 73833,
 -64741,
 51992989,
 73832,
 -64740,
 52054235,
 73827,
 -1,
 52115633,
 73824,
 52298529,
 50294122,
 73839,
 52428799,
 52235969,
 -1,
 -64736,
 52301106,
 73841,
 -1,
 52366538,
 73840,
 -1,
 52253220,
 73838,
 52626227,
 50234955,
 73850,
 52691752,
 52582509,
 73860,
 52757287,
 52628682,
 73861,
 52887551,
 52691475,
 73862,
 -1,
 52757011,
 73863,
 -1,
 52694322,
 73864,
 53019435,
 52631541,
 73854,
 -64726,
 52956211,
 73856,
 -1,
 53020430,
 73855,
 53216047,
 52953088,
 -1,
 -64723,
 53180405,
 73853,
 -64722,
 53241181,
 73851,
 -1,
 53295216,
 73852,
 53478193,
 53163210,
 73857,
 -1,
 53446622,
 73858,
 -64718,
 53439927,
 73865,
 -1,
 53557403,
 73859,
 53805055,
 52575839,
 73842,
 53805879,
 53695012,
 73844,
 -64714,
 53742643,
 73846,
 -1,
 53806953,
 73845,
 54002489,
 53762157,
 73847,
 -1,
 53936736,
 73848,
 -64710,
 53966629,
 73849,
 -1,
 54073333,
 73843,
 54264688,
 50145403,
 73866,
 54330196,
 54236855,
 73889,
 54460415,
 54265560,
 -1,
 54461251,
 54348618,
 -1,
 54526785,
 54398657,
 73903,
 -1,
 54479692,
 73904,
 -64702,
 54494795,
 73906,
 -1,
 54607455,
 73905,
 54788935,
 54398657,
 73890,
 54854470,
 54723890,
 73891,
 -1,
 54789982,
 73892,
 -1,
 54810733,
 73893,
 55051083,
 54741046,
 -1,
 55116618,
 54990369,
 73900,
 -1,
 55051881,
 73901,
 -1,
 55084718,
 73902,
 55313230,
 55019083,
 -1,
 -64691,
 55255758,
 73908,
 -1,
 55315507,
 73907,
 55509840,
 55261361,
 73897,
 -1,
 55443987,
 73898,
 55640914,
 55453738,
 73895,
 -1,
 55575059,
 73896,
 -64685,
 55591172,
 73899,
 -1,
 55711809,
 73894,
 55903069,
 54286445,
 73879,
 56033279,
 55836672,
 -1,
 56034138,
 55935601,
 -1,
 56099673,
 55981406,
 73880,
 -1,
 56034997,
 73881,
 -1,
 56054996,
 73882,
 -64677,
 55999360,
 73885,
 -64676,
 56254975,
 73884,
 -1,
 56304017,
 73883,
 56492902,
 55839795,
 73869,
 56623103,
 56428248,
 -1,
 56623970,
 56522126,
 -1,
 -64671,
 56572435,
 73874,
 -1,
 56627735,
 73873,
 -64669,
 56591947,
 73875,
 -64668,
 56776205,
 73872,
 -64667,
 56833418,
 73871,
 -1,
 56889053,
 73870,
 57082729,
 56454506,
 -1,
 -64664,
 57033202,
 73887,
 -1,
 57093117,
 73886,
 57279340,
 57016320,
 -1,
 -64661,
 57246338,
 73867,
 -1,
 57304421,
 73868,
 -64659,
 57243488,
 73888,
 -64658,
 57428810,
 73878,
 -64657,
 57489239,
 73877,
 -1,
 57550091,
 73876,
 57738135,
 54230585,
 -1,
 57803655,
 57675457,
 74475,
 57869179,
 57750730,
 74483,
 57999359,
 57804504,
 -1,
 58000247,
 57898789,
 -1,
 -64650,
 57968203,
 74487,
 -1,
 58009723,
 74486,
 -64648,
 57968606,
 74489,
 -64647,
 58164474,
 74488,
 -64646,
 58210396,
 74485,
 -1,
 58268079,
 74484,
 58459009,
 57802752,
 -1,
 58524543,
 58425969,
 -1,
 -64642,
 58480141,
 74478,
 -1,
 58538723,
 74477,
 -64640,
 58472560,
 74479,
 -1,
 58660443,
 74476,
 58852229,
 58398709,
 74480,
 58982399,
 58785792,
 -1,
 -64636,
 58882944,
 74482,
 -1,
 58943035,
 74481,
 -64634,
 58813802,
 74491,
 -1,
 59066501,
 74490,
 59245455,
 57753183,
 74494,
 59310989,
 59207018,
 74497,
 59441151,
 59244544,
 -1,
 59442060,
 59336286,
 74499,
 -1,
 59376100,
 74500,
 -1,
 59409061,
 74498,
 -64626,
 59263818,
 74496,
 -1,
 59573941,
 74495,
 59769749,
 59213387,
 74501,
 59835282,
 59731306,
 74505,
 -1,
 59770024,
 74506,
 -64621,
 59789860,
 74504,
 -64620,
 59918390,
 74503,
 -1,
 59978995,
 74502,
 60227583,
 59713659,
 74492,
 -1,
 60097043,
 74493,
 60294075,
 57692708,
 -1,
 60359598,
 60261963,
 74284,
 60425129,
 60323621,
 74290,
 60490658,
 60358656,
 -1,
 60556191,
 60457585,
 -1,
 -64611,
 60528195,
 74293,
 -64610,
 60574489,
 74292,
 -1,
 60624577,
 74291,
 60818337,
 60515838,
 74294,
 -1,
 60753641,
 74295,
 -1,
 60760568,
 74296,
 61079551,
 60427466,
 74297,
 61145087,
 60948480,
 -1,
 61146024,
 61047409,
 -1,
 61211559,
 61083329,
 74298,
 -1,
 61146346,
 74299,
 -1,
 61154430,
 74300,
 -1,
 61094000,
 74301,
 61473707,
 60372170,
 74286,
 -1,
 61407763,
 74287,
 -64596,
 61436208,
 74289,
 -64595,
 61561760,
 74288,
 -1,
 61604962,
 74285,
 61801399,
 60296897,
 74272,
 61866929,
 61765413,
 74278,
 -1,
 61803571,
 74279,
 61998004,
 61800448,
 -1,
 -64589,
 61964965,
 74273,
 -1,
 62011504,
 74274,
 -64587,
 61959530,
 74277,
 -64586,
 62142619,
 74276,
 -1,
 62196787,
 74275,
 62391225,
 61750879,
 74282,
 -1,
 62347373,
 74283,
 62586879,
 62335099,
 74280,
 -1,
 62485902,
 74281,
 62653398,
 60243551,
 74047,
 62718915,
 62607908,
 74062,
 62784450,
 62652416,
 -1,
 -64577,
 62751397,
 74063,
 -64576,
 62815104,
 74066,
 -64575,
 62874123,
 74065,
 -1,
 62923218,
 74064,
 -1,
 62734817,
 74067,
 63177674,
 62665930,
 74053,
 63307775,
 63127135,
 74054,
 63373311,
 63176704,
 -1,
 -64569,
 63271248,
 74056,
 -64568,
 63333796,
 74057,
 -64567,
 63387760,
 74058,
 -1,
 63448280,
 74055,
 63636429,
 63130442,
 74059,
 -64564,
 63573043,
 74061,
 -1,
 63637284,
 74060,
 63833041,
 63579394,
 74050,
 63963135,
 63767548,
 -1,
 -64560,
 63863680,
 74052,
 -1,
 63904653,
 74051,
 -64558,
 63797029,
 74070,
 -64557,
 64056682,
 74069,
 -64556,
 64116845,
 74068,
 -64555,
 64165877,
 74049,
 -1,
 64225282,
 74048,
 64422896,
 62601371,
 -1,
 64488418,
 64372319,
 74029,
 64618495,
 64423640,
 -1,
 64619483,
 64493073,
 74030,
 -1,
 64556083,
 74031,
 -64548,
 64587339,
 74038,
 -64547,
 64714706,
 74037,
 -64546,
 64773218,
 74036,
 -64545,
 64834097,
 74035,
 -64544,
 64894232,
 74034,
 -64543,
 64955719,
 74033,
 -1,
 65017921,
 74032,
 65209323,
 64456267,
 74039,
 65274858,
 65148939,
 74040,
 65404927,
 65210072,
 -1,
 -64538,
 65308638,
 74045,
 -64537,
 65359793,
 74044,
 -64536,
 65423649,
 74043,
 -64535,
 65485044,
 74042,
 -1,
 65540903,
 74041,
 -1,
 65227637,
 74046,
 65863679,
 65146561,
 74025,
 65864687,
 65732608,
 -1,
 -64530,
 65831022,
 74026,
 -1,
 65878128,
 74027,
 -1,
 65817418,
 74028,
 66126859,
 64382723,
 -1,
 66192390,
 66076255,
 74367,
 66257919,
 66125824,
 -1,
 66323454,
 66224753,
 -1,
 66388982,
 66291275,
 74375,
 -1,
 66325555,
 74376,
 66520056,
 66338399,
 74373,
 -1,
 66459637,
 74374,
 66651131,
 66459637,
 -1,
 -64518,
 66618955,
 74371,
 -1,
 66666079,
 74370,
 66847741,
 66588353,
 74368,
 -1,
 66787317,
 74369,
 -1,
 66791547,
 74372,
 -1,
 66265619,
 74377,
 67174399,
 66220507,
 74378,
 67239935,
 67043328,
 -1,
 67240965,
 67142257,
 -1,
 -64509,
 67212867,
 74381,
 -64508,
 67274718,
 74380,
 -1,
 67324132,
 74379,
 -1,
 67199538,
 74382,
 67568650,
 66129601,
 74362,
 -64504,
 67528451,
 74365,
 -64503,
 67590253,
 74364,
 -1,
 67642062,
 74363,
 -1,
 67513946,
 74366,
 67896356,
 66066421,
 -1,
 67961877,
 67833537,
 73792,
 68027408,
 67914570,
 73796,
 -64497,
 67965232,
 73798,
 -1,
 68027301,
 73797,
 68224018,
 67988842,
 73799,
 -1,
 68161328,
 73800,
 -64493,
 68172220,
 73795,
 -64492,
 68302070,
 73794,
 -1,
 68362958,
 73793,
 68551711,
 67929675,
 73805,
 68617243,
 68485120,
 -1,
 68682778,
 68576596,
 -1,
 -64487,
 68651250,
 73807,
 -1,
 68685660,
 73806,
 -1,
 68624773,
 73808,
 68944925,
 68578666,
 73811,
 -1,
 68881459,
 73812,
 69140479,
 68899293,
 73809,
 -1,
 69010351,
 73810,
 69271551,
 68501087,
 73801,
 69337087,
 69142232,
 -1,
 -64478,
 69222660,
 73804,
 -64477,
 69285258,
 73803,
 -1,
 69340865,
 73802,
 69534776,
 67868211,
 -1,
 69600300,
 69484127,
 74595,
 69665832,
 69539829,
 74598,
 -1,
 69599822,
 74599,
 -64471,
 69637696,
 74601,
 -64470,
 69743818,
 74600,
 -64469,
 69799114,
 74597,
 -1,
 69862589,
 74596,
 70059057,
 69568075,
 74602,
 70124591,
 69995888,
 74603,
 -1,
 70059744,
 74604,
 -64464,
 70079012,
 74606,
 -1,
 70196109,
 74605,
 70386743,
 69996225,
 74589,
 70452277,
 70320128,
 -1,
 -64460,
 70418542,
 74590,
 -1,
 70482833,
 74591,
 -64458,
 70408273,
 74593,
 -1,
 70595786,
 74592,
 -1,
 70330728,
 74594,
 70909951,
 69496170,
 -1,
 70911035,
 70782657,
 74383,
 -1,
 70850549,
 74384,
 -64452,
 70878795,
 74386,
 -1,
 70991455,
 74385,
 71173320,
 220244,
 -1,
 71238756,
 71119191,
 -1,
 71304275,
 71197822,
 -1,
 71369797,
 71273581,
 74812,
 71435332,
 71303168,
 -1,
 -64445,
 71374837,
 74815,
 -1,
 71438017,
 74814,
 -1,
 71372082,
 74813,
 71697481,
 71309301,
 -1,
 71763016,
 71635754,
 74834,
 -1,
 71698320,
 74835,
 -1,
 71732031,
 74808,
 71959628,
 71661499,
 -1,
 -64437,
 71927371,
 74800,
 -1,
 71961651,
 74790,
 72156239,
 71906927,
 -1,
 -64434,
 72123979,
 74785,
 -1,
 72158259,
 74776,
 72352849,
 72095249,
 74754,
 -1,
 72287925,
 74828,
 -64430,
 72320587,
 74767,
 -1,
 72426823,
 74761,
 72679423,
 71255692,
 -1,
 72680537,
 72578446,
 -1,
 72746072,
 72628664,
 -1,
 -64425,
 72713803,
 74801,
 -1,
 72748083,
 74791,
 -1,
 72697584,
 74844,
 73008221,
 72620021,
 -1,
 73073756,
 72946474,
 74836,
 -1,
 73009040,
 74837,
 -1,
 73042751,
 74809,
 73270368,
 72955503,
 -1,
 -64417,
 73238091,
 74786,
 -1,
 73272371,
 74777,
 73466978,
 73209361,
 74755,
 -1,
 73402037,
 74829,
 -64413,
 73434699,
 74768,
 -1,
 73540935,
 74762,
 73729160,
 71204409,
 -1,
 73794680,
 73678179,
 -1,
 73860203,
 73758651,
 -1,
 73925737,
 73827915,
 74798,
 -1,
 73861008,
 74799,
 74121215,
 73862195,
 74788,
 -1,
 73992080,
 74789,
 74187887,
 73799669,
 -1,
 74253422,
 74156863,
 74806,
 -1,
 74188688,
 74807,
 -1,
 74191658,
 74833,
 74450034,
 74157110,
 -1,
 -64399,
 74386604,
 74811,
 -1,
 74452000,
 74810,
 74646645,
 74397295,
 -1,
 -64396,
 74614347,
 74784,
 -1,
 74648627,
 74775,
 74843255,
 74585617,
 74753,
 -1,
 74778293,
 74827,
 -1,
 74786119,
 74760,
 75104255,
 73765525,
 -1,
 75105404,
 75006303,
 -1,
 -64389,
 75074581,
 74846,
 -1,
 75113799,
 74843,
 75302015,
 75069371,
 -1,
 -64386,
 75269707,
 74797,
 -1,
 75303987,
 74787,
 75498626,
 75249263,
 -1,
 -64383,
 75466315,
 74783,
 -1,
 75500595,
 74774,
 75695237,
 75438069,
 -1,
 -64380,
 75664191,
 74805,
 -1,
 75698986,
 74832,
 75891847,
 75634193,
 74752,
 -1,
 75826869,
 74826,
 -1,
 75837023,
 74841,
 76088479,
 73692558,
 -1,
 76154004,
 76033925,
 -1,
 76219535,
 76123227,
 -1,
 76285070,
 76152832,
 -1,
 -64371,
 76224501,
 74819,
 -1,
 76287681,
 74818,
 -1,
 76221642,
 74817,
 -64368,
 76187211,
 74770,
 -64367,
 76511168,
 74793,
 -64366,
 76559988,
 74779,
 -64365,
 76621127,
 74764,
 -1,
 76682769,
 74757,
 76874908,
 76105436,
 -1,
 76940439,
 76813841,
 74756,
 -1,
 76875445,
 74830,
 -64360,
 76909604,
 74816,
 -64359,
 77039179,
 74769,
 -64358,
 77100992,
 74792,
 -64357,
 77149812,
 74778,
 -1,
 77210951,
 74763,
 77463551,
 76822977,
 -1,
 -64354,
 77354618,
 74803,
 -1,
 77407559,
 74802,
 77595826,
 76045543,
 -1,
 77661359,
 77552032,
 -1,
 77726884,
 77627722,
 -1,
 -64349,
 77696021,
 74845,
 -1,
 77735239,
 74842,
 77923495,
 77674095,
 -1,
 -64346,
 77891147,
 74782,
 -1,
 77925427,
 74773,
 78120106,
 77867131,
 -1,
 -64343,
 78084054,
 74840,
 -1,
 78135542,
 74847,
 78316717,
 78059509,
 -1,
 -64340,
 78285631,
 74804,
 -1,
 78320426,
 74831,
 -64338,
 78280652,
 74796,
 -1,
 78474454,
 74848,
 78708735,
 77614279,
 -1,
 -64335,
 78608724,
 74849,
 -1,
 78671054,
 74850,
 78841024,
 77552234,
 -1,
 78906557,
 78797216,
 -1,
 78972088,
 78875719,
 74822,
 -64330,
 78908722,
 74824,
 -64329,
 78974154,
 74823,
 -1,
 79036418,
 74825,
 -64327,
 78939723,
 74772,
 -64326,
 79198144,
 74795,
 -64325,
 79246964,
 74781,
 -64324,
 79308103,
 74766,
 -1,
 79369745,
 74759,
 79626239,
 78853932,
 -1,
 -64321,
 79517306,
 74838,
 -1,
 79572566,
 74839,
 79822847,
 78785339,
 -1,
 79824067,
 79727744,
 74820,
 -1,
 79760586,
 74821,
 -64316,
 79791691,
 74771,
 -64315,
 79919040,
 74794,
 -64314,
 79967860,
 74780,
 -64313,
 80028999,
 74765,
 -1,
 80090641,
 74758,
 80347135,
 71134184,
 -1,
 80348364,
 80225447,
 -1,
 -64309,
 80315480,
 74867,
 -1,
 80355363,
 74866,
 -64307,
 80317819,
 74865,
 -1,
 80502495,
 74864,
 80676051,
 159082,
 -1,
 80741586,
 80637290,
 -1,
 -64303,
 80712789,
 127835,
 -1,
 80751714,
 128177,
 -1,
 80695836,
 10160,
 81003734,
 80641030,
 -1,
 -64299,
 80961418,
 128707,
 -1,
 81007890,
 127854,
 -1,
 80963346,
 9982,
 81266288,
 89319,
 -1,
 81331608,
 81220717,
 -1,
 81397016,
 81271750,
 -1,
 81462551,
 81368591,
 -1,
 81528078,
 81415761,
 -1,
 81593571,
 81471611,
 -1,
 81659103,
 81556878,
 11757,
 -1,
 81595156,
 11765,
 -64288,
 81620330,
 11756,
 -64287,
 81746029,
 11753,
 -64286,
 81809956,
 11752,
 -1,
 81873738,
 11751,
 82052329,
 81542751,
 42613,
 82117864,
 82011064,
 -1,
 -64282,
 82061435,
 42655,
 -64281,
 82123221,
 11775,
 -1,
 82185921,
 11772,
 -1,
 82061435,
 11767,
 82445550,
 82023507,
 -1,
 -64277,
 82413131,
 11771,
 -64276,
 82460255,
 42614,
 -64275,
 82521622,
 42617,
 -1,
 82581092,
 11770,
 82773235,
 82408846,
 -1,
 82838770,
 82720923,
 -1,
 -64271,
 82779568,
 11763,
 -1,
 82841281,
 11762,
 -1,
 82796050,
 42618,
 83100918,
 82744883,
 -1,
 -64267,
 83048979,
 11748,
 -1,
 83110011,
 11749,
 83297528,
 83068491,
 42615,
 -1,
 83249909,
 42612,
 83428603,
 83263033,
 -1,
 -64262,
 83392131,
 11760,
 -1,
 83437691,
 11758,
 83625213,
 83385575,
 11754,
 -1,
 83580261,
 42619,
 83756287,
 83572913,
 11759,
 -1,
 83717984,
 42616,
 83887362,
 83698382,
 -1,
 -64255,
 83838890,
 11768,
 -1,
 83896443,
 11747,
 84083973,
 83826677,
 -1,
 -64252,
 84033666,
 11774,
 -1,
 84093051,
 11744,
 -64250,
 84053161,
 11745,
 -64249,
 84240408,
 11755,
 -64248,
 84301683,
 11769,
 -64247,
 84365238,
 11773,
 -64246,
 84428936,
 11750,
 -64245,
 84489907,
 11746,
 -64244,
 84554522,
 11764,
 -64243,
 84614608,
 11761,
 -1,
 84676289,
 11766,
 84870417,
 81493561,
 -1,
 -64240,
 84819256,
 42610,
 -1,
 84880396,
 42608,
 85067028,
 84829955,
 -1,
 -64237,
 85024457,
 1159,
 -1,
 85071838,
 42621,
 -64235,
 85036902,
 42607,
 -64234,
 85215592,
 42620,
 -1,
 85278245,
 42609,
 -1,
 81420496,
 65062,
 85525823,
 81339086,
 -1,
 85591345,
 85471093,
 -1,
 85656872,
 85533936,
 -1,
 85722398,
 85622329,
 -1,
 -64227,
 85693074,
 43234,
 -1,
 85736798,
 43235,
 85919009,
 85685646,
 -1,
 -64224,
 85870297,
 43238,
 -1,
 85929856,
 43239,
 86115620,
 85864791,
 -1,
 -64221,
 86074490,
 43236,
 -1,
 86132360,
 43237,
 -64219,
 86087377,
 43232,
 -64218,
 86269950,
 43233,
 -64217,
 86334111,
 43241,
 -1,
 86387509,
 43240,
 86574384,
 85610065,
 -1,
 -64214,
 86543860,
 43248,
 -64213,
 86607435,
 43243,
 -64212,
 86666696,
 43247,
 -64211,
 86730562,
 43246,
 -64210,
 86792387,
 43245,
 -64209,
 86853768,
 43244,
 -1,
 86904513,
 43242,
 -1,
 86538391,
 43249,
 87228415,
 85548263,
 -1,
 87229754,
 87131953,
 -1,
 87295285,
 87184030,
 862,
 -1,
 87228614,
 863,
 87426359,
 87235363,
 861,
 -1,
 87359686,
 860,
 -64200,
 87388926,
 858,
 -64199,
 87508045,
 7676,
 -1,
 87564010,
 7629,
 87818239,
 87195193,
 -1,
 87819582,
 87719913,
 -1,
 -64195,
 87767031,
 7616,
 -1,
 87822382,
 7617,
 -1,
 87752716,
 856,
 88081764,
 85478218,
 -1,
 88147290,
 88020716,
 -1,
 88212820,
 88111618,
 -1,
 88278342,
 88149697,
 -1,
 -64188,
 88247252,
 7638,
 -64187,
 88300775,
 7637,
 -1,
 88352891,
 7636,
 88540489,
 88239468,
 -1,
 -64184,
 88503410,
 7651,
 -1,
 88545602,
 7626,
 88737099,
 88492874,
 7645,
 -1,
 88694939,
 7653,
 -64180,
 88708659,
 7654,
 -64179,
 88831374,
 7652,
 -64178,
 88889453,
 7648,
 -64177,
 88950838,
 7644,
 -64176,
 89015290,
 7640,
 -64175,
 89076938,
 7642,
 -64174,
 89142087,
 7635,
 -64173,
 89206433,
 7641,
 -1,
 89267147,
 7639,
 89522175,
 88166010,
 -1,
 -64170,
 89419114,
 7650,
 -64169,
 89479277,
 7649,
 -64168,
 89543204,
 7647,
 -64167,
 89606986,
 7646,
 -1,
 89666762,
 7643,
 89851235,
 88091361,
 -1,
 89916770,
 89784320,
 -1,
 89982305,
 89855396,
 -1,
 90047840,
 89930271,
 -1,
 -64161,
 89987394,
 852,
 -1,
 90050480,
 7678,
 -1,
 89981126,
 8430,
 -1,
 89930002,
 849,
 -1,
 89886680,
 8429,
 -1,
 89809024,
 8427,
 90506609,
 88043999,
 -1,
 90572144,
 90439680,
 -1,
 90637679,
 90510756,
 -1,
 90703214,
 90585631,
 -1,
 90768749,
 90640065,
 -1,
 90834284,
 90724659,
 -1,
 -64149,
 90802668,
 854,
 -1,
 90842978,
 7679,
 -1,
 90774251,
 848,
 -1,
 90708290,
 853,
 -1,
 90636486,
 8431,
 -1,
 90585362,
 855,
 -1,
 90542040,
 8428,
 91358585,
 90460830,
 -1,
 91424118,
 91294174,
 -1,
 -64140,
 91371505,
 7622,
 -64139,
 91429667,
 7628,
 -1,
 91492392,
 7620,
 91750399,
 91357184,
 -1,
 -64136,
 91648504,
 65061,
 -1,
 91704706,
 65060,
 91882882,
 91305906,
 -1,
 91948415,
 91826816,
 -1,
 92013950,
 91913785,
 -1,
 -64131,
 91976574,
 119362,
 -1,
 92024491,
 119363,
 -1,
 91973775,
 119364,
 92340223,
 91887468,
 -1,
 -64127,
 92230302,
 7621,
 -1,
 92278843,
 7624,
 92472714,
 91819713,
 -1,
 92538246,
 92437600,
 -1,
 -64123,
 92477762,
 857,
 -1,
 92540848,
 8432,
 92734857,
 92480176,
 -1,
 -64120,
 92689054,
 7623,
 -1,
 92747780,
 7625,
 -1,
 92688465,
 7677,
 92997005,
 92444479,
 -1,
 -64116,
 92936514,
 7631,
 -1,
 92999600,
 859,
 93193616,
 92964427,
 -1,
 -64113,
 93156755,
 7634,
 -1,
 93220207,
 7633,
 93390227,
 93156750,
 -1,
 -64110,
 93358987,
 7619,
 -1,
 93411561,
 7618,
 -64108,
 93361057,
 851,
 -64107,
 93544001,
 7630,
 -64106,
 93603175,
 7632,
 -64105,
 93663817,
 850,
 -1,
 93723433,
 7627,
 93914687,
 81292196,
 -1,
 93980138,
 93877646,
 -1,
 94045664,
 93934463,
 -1,
 94111154,
 94002407,
 11423,
 94176689,
 94063811,
 -1,
 94242219,
 94118121,
 -1,
 94307747,
 94189723,
 -1,
 94373281,
 94244545,
 11471,
 -1,
 94338617,
 11477,
 -64094,
 94331555,
 11469,
 -1,
 94448426,
 11475,
 94635430,
 94271269,
 -1,
 -64091,
 94585230,
 11483,
 -1,
 94645034,
 11461,
 -64089,
 94593355,
 11455,
 -64088,
 94778744,
 11479,
 -64087,
 94842454,
 11463,
 -64086,
 94905717,
 11481,
 -1,
 94966195,
 11445,
 95223807,
 94198807,
 -1,
 95225263,
 95115373,
 -1,
 -64082,
 95196505,
 11489,
 -1,
 95237901,
 11487,
 -64080,
 95195130,
 11491,
 -1,
 95385611,
 11485,
 -1,
 94135313,
 11441,
 95618489,
 94053070,
 -1,
 95684024,
 95567571,
 -1,
 -64075,
 95640170,
 11451,
 -64074,
 95701234,
 11449,
 -64073,
 95763641,
 11467,
 -1,
 95818341,
 11443,
 -1,
 95621724,
 11399,
 96077248,
 95559950,
 -1,
 96142783,
 96048621,
 -1,
 -64068,
 96106469,
 11500,
 -64067,
 96164458,
 11453,
 -64066,
 96220536,
 11502,
 -1,
 96283441,
 11447,
 -1,
 96101193,
 11459,
 96536004,
 96040334,
 -1,
 -64062,
 96494609,
 11403,
 -64061,
 96551310,
 11429,
 -1,
 96604950,
 11457,
 96798152,
 96487478,
 -1,
 -64058,
 96761972,
 11421,
 -64057,
 96811747,
 11437,
 -1,
 96867436,
 11413,
 97060299,
 96763449,
 -1,
 -64054,
 97008306,
 11409,
 -1,
 97064753,
 11431,
 97256910,
 97019651,
 -1,
 -64051,
 97220724,
 11439,
 -1,
 97271391,
 11425,
 97453521,
 97209162,
 -1,
 -64048,
 97392444,
 11415,
 -1,
 97454810,
 11473,
 97650132,
 97390273,
 -1,
 -64045,
 97603286,
 11393,
 -1,
 97667606,
 11465,
 -64043,
 97621663,
 11405,
 -64042,
 97816055,
 11395,
 -64041,
 97879740,
 11433,
 -64040,
 97940469,
 11427,
 -64039,
 97999466,
 11419,
 -64038,
 98063885,
 11417,
 -64037,
 98123579,
 11411,
 -64036,
 98187779,
 11407,
 -64035,
 98252120,
 11397,
 -64034,
 98316966,
 11435,
 -64033,
 98380593,
 11401,
 -1,
 98441890,
 11507,
 98697215,
 94016907,
 -1,
 98698724,
 98596238,
 -1,
 -64029,
 98664341,
 11495,
 -1,
 98712505,
 11498,
 98895335,
 98650166,
 -1,
 -64026,
 98843366,
 11497,
 -1,
 98898319,
 11492,
 -64024,
 98860942,
 11496,
 -64023,
 99051810,
 11494,
 -1,
 99112468,
 11493,
 99288630,
 93920198,
 -1,
 99354161,
 99226765,
 -1,
 99419651,
 99310823,
 11422,
 99485186,
 99372227,
 -1,
 99550716,
 99426537,
 -1,
 99616244,
 99498139,
 -1,
 99681778,
 99552961,
 11470,
 -1,
 99647033,
 11476,
 -64013,
 99639971,
 11468,
 -1,
 99756842,
 11474,
 99943927,
 99579685,
 -1,
 -64010,
 99893646,
 11482,
 -1,
 99953450,
 11460,
 -64008,
 99901771,
 11454,
 -64007,
 100087160,
 11478,
 -64006,
 100150870,
 11462,
 -64005,
 100214133,
 11480,
 -1,
 100274611,
 11444,
 100532223,
 99507223,
 -1,
 100533760,
 100423789,
 -1,
 -64001,
 100504921,
 11488,
 -1,
 100546317,
 11486,
 -63999,
 100503546,
 11490,
 -1,
 100694027,
 11484,
 -1,
 99443729,
 11440,
 100926986,
 99361486,
 -1,
 100992521,
 100875987,
 -1,
 -63994,
 100948586,
 11450,
 -63993,
 101009650,
 11448,
 -63992,
 101072057,
 11466,
 -1,
 101126757,
 11442,
 -1,
 100930140,
 11398,
 101385745,
 100868366,
 -1,
 101451280,
 101357037,
 -1,
 -63987,
 101414885,
 11499,
 -63986,
 101472874,
 11452,
 -63985,
 101528952,
 11501,
 -1,
 101591857,
 11446,
 -1,
 101409609,
 11458,
 101844501,
 101348750,
 -1,
 -63981,
 101803025,
 11402,
 -63980,
 101859726,
 11428,
 -1,
 101913366,
 11456,
 102106649,
 101795894,
 -1,
 -63977,
 102070388,
 11420,
 -63976,
 102120163,
 11436,
 -1,
 102175852,
 11412,
 102368796,
 102071865,
 -1,
 -63973,
 102316722,
 11408,
 -1,
 102373169,
 11430,
 102565407,
 102328067,
 -1,
 -63970,
 102529140,
 11438,
 -1,
 102579807,
 11424,
 102762018,
 102517578,
 -1,
 -63967,
 102700860,
 11414,
 -1,
 102763226,
 11472,
 102958629,
 102698689,
 -1,
 -63964,
 102911702,
 11392,
 -1,
 102976022,
 11464,
 -63962,
 102930079,
 11404,
 -63961,
 103124471,
 11394,
 -63960,
 103188156,
 11432,
 -63959,
 103248885,
 11426,
 -63958,
 103307882,
 11418,
 -63957,
 103372301,
 11416,
 -63956,
 103431995,
 11410,
 -63955,
 103496195,
 11406,
 -63954,
 103560536,
 11396,
 -63953,
 103625382,
 11434,
 -63952,
 103689009,
 11400,
 -1,
 103750306,
 11506,
 104005631,
 99311469,
 -1,
 104007221,
 103906137,
 -1,
 -63948,
 103960104,
 11505,
 -1,
 104011303,
 11504,
 -1,
 103963245,
 11503,
 104269371,
 99245817,
 -1,
 -63944,
 104238399,
 11516,
 -63943,
 104284758,
 11515,
 -63942,
 104346809,
 11513,
 -1,
 104408354,
 11514,
 104597054,
 104214871,
 -1,
 -63939,
 104564873,
 11518,
 -1,
 104623594,
 11517,
 -1,
 104552337,
 11519,
 104859228,
 93881931,
 -1,
 104924763,
 104815603,
 -1,
 104990286,
 104892825,
 -1,
 105055813,
 104955449,
 -1,
 -63932,
 105026194,
 119649,
 -1,
 105069918,
 119650,
 105252424,
 105018766,
 -1,
 -63929,
 105203417,
 119653,
 -1,
 105262976,
 119654,
 105449035,
 105197911,
 -1,
 -63926,
 105407610,
 119651,
 -1,
 105465480,
 119652,
 -63924,
 105406462,
 119648,
 -63923,
 105601695,
 119656,
 -1,
 105655093,
 119655,
 105906175,
 104955996,
 -1,
 105907794,
 105807417,
 -1,
 -63919,
 105878162,
 119658,
 -1,
 105921886,
 119659,
 106104405,
 105870734,
 -1,
 -63916,
 106055385,
 119662,
 -1,
 106114944,
 119663,
 106301016,
 106049879,
 -1,
 -63913,
 106259578,
 119660,
 -1,
 106317448,
 119661,
 -63911,
 106258430,
 119657,
 -63910,
 106453663,
 119665,
 -1,
 106507061,
 119664,
 -1,
 104884616,
 128145,
 106759782,
 104814701,
 -1,
 106825313,
 106705239,
 -1,
 -63905,
 106793806,
 128533,
 -63904,
 106849390,
 128534,
 -1,
 106901213,
 127882,
 107087460,
 106790190,
 -1,
 -63901,
 107058038,
 128119,
 -1,
 107116684,
 128679,
 -63899,
 107056385,
 127978,
 -1,
 107250834,
 983186,
 107415147,
 106716834,
 -1,
 107480682,
 107363935,
 -1,
 -63895,
 107436593,
 127859,
 -1,
 107489403,
 127850,
 -1,
 107424334,
 127834,
 107742829,
 107384684,
 128004,
 -1,
 107676094,
 128046,
 -63890,
 107696181,
 128165,
 -63889,
 107819665,
 9904,
 -1,
 107880301,
 127864,
 108070737,
 81213595,
 -1,
 108136259,
 108007105,
 -1,
 108201695,
 108089894,
 -1,
 108267190,
 108154449,
 -1,
 108332672,
 108212938,
 -1,
 108398199,
 108288109,
 43590,
 -1,
 108344522,
 43586,
 -63880,
 108368979,
 43592,
 -63879,
 108494393,
 43589,
 -63878,
 108559280,
 43595,
 -63877,
 108621162,
 43593,
 -63876,
 108685059,
 43591,
 -63875,
 108743498,
 43594,
 -63874,
 108808246,
 43584,
 -63873,
 108868810,
 43585,
 -1,
 108928418,
 43588,
 109119114,
 108288109,
 -1,
 109184645,
 109066395,
 -1,
 -63869,
 109152255,
 43536,
 -63868,
 109201230,
 43538,
 -1,
 109252289,
 43537,
 109446792,
 109130954,
 -1,
 -63865,
 109414399,
 43530,
 -1,
 109448897,
 43531,
 -63863,
 109414399,
 43543,
 -1,
 109579969,
 43544,
 109774478,
 109078275,
 -1,
 -63860,
 109733698,
 43547,
 -63859,
 109787313,
 43548,
 -1,
 109842113,
 43546,
 110036626,
 109716174,
 -1,
 -63856,
 109983921,
 43542,
 -63855,
 110043947,
 43545,
 -1,
 110104257,
 43541,
 110298774,
 109975541,
 -1,
 -63852,
 110246065,
 43550,
 -63851,
 110303274,
 43553,
 -1,
 110366401,
 43549,
 110560921,
 110263865,
 -1,
 -63848,
 110508209,
 43540,
 -1,
 110563009,
 43539,
 110757532,
 110523790,
 -1,
 -63845,
 110720482,
 43558,
 -1,
 110759617,
 43559,
 110954143,
 110711332,
 -1,
 -63842,
 110921727,
 43551,
 -1,
 110956225,
 43552,
 111150754,
 110905398,
 -1,
 -63839,
 111098033,
 43527,
 -1,
 111152833,
 43526,
 111347365,
 111101744,
 -1,
 -63836,
 111294641,
 43535,
 -1,
 111349441,
 43534,
 111543976,
 111293642,
 -1,
 -63833,
 111491249,
 43529,
 -1,
 111546049,
 43528,
 111740587,
 111484322,
 -1,
 -63830,
 111687857,
 43533,
 -1,
 111742657,
 43532,
 111937197,
 111677121,
 43520,
 -1,
 111885919,
 43524,
 -63826,
 111907989,
 43554,
 -63825,
 112036842,
 43557,
 -63824,
 112100939,
 43522,
 -63823,
 112160200,
 43555,
 -63822,
 112221415,
 43525,
 -63821,
 112282488,
 43556,
 -63820,
 112344671,
 43521,
 -63819,
 112408753,
 43560,
 -1,
 112470139,
 43523,
 112658114,
 108236539,
 -1,
 112723643,
 112594625,
 -1,
 -63815,
 112690763,
 43569,
 -63814,
 112737887,
 43568,
 -1,
 112791233,
 43561,
 112985789,
 112690763,
 43565,
 -1,
 112928891,
 43570,
 113116863,
 112942311,
 43567,
 -1,
 113059963,
 43566,
 113247937,
 113065567,
 43562,
 -1,
 113196639,
 43563,
 -1,
 113191722,
 43564,
 113444560,
 112600304,
 -1,
 113510086,
 113409593,
 -1,
 -63803,
 113480338,
 43602,
 -1,
 113524062,
 43603,
 113706697,
 113472910,
 -1,
 -63800,
 113657561,
 43606,
 -1,
 113717120,
 43607,
 113903308,
 113652055,
 -1,
 -63797,
 113861754,
 43604,
 -1,
 113919624,
 43605,
 -63795,
 113874641,
 43600,
 -63794,
 114057214,
 43601,
 -63793,
 114121375,
 43609,
 -1,
 114174773,
 43608,
 114362073,
 113385602,
 -1,
 114427605,
 114307786,
 -1,
 -63789,
 114383409,
 43587,
 -63788,
 114446884,
 43596,
 -1,
 114505883,
 43597,
 -63786,
 114398357,
 43571,
 -63785,
 114659251,
 43574,
 -63784,
 114716104,
 43572,
 -1,
 114772856,
 43573,
 115015679,
 114322376,
 -1,
 115017437,
 114893518,
 -1,
 -63780,
 114975771,
 43614,
 -1,
 115020706,
 43613,
 -63778,
 114984045,
 43615,
 -1,
 115178310,
 43612,
 115345209,
 108153497,
 -1,
 115410705,
 115297873,
 -1,
 115476199,
 115375673,
 -1,
 115541733,
 115441209,
 -1,
 -63772,
 115488966,
 69906,
 -1,
 115543866,
 69905,
 -63770,
 115488966,
 69911,
 -1,
 115674938,
 69910,
 115869420,
 115431533,
 -1,
 -63767,
 115840152,
 69904,
 -63766,
 115890389,
 69909,
 -63765,
 115946751,
 69899,
 -1,
 116002618,
 69914,
 116197106,
 115811022,
 -1,
 116262640,
 116138702,
 -1,
 -63761,
 116209862,
 69908,
 -1,
 116264762,
 69907,
 -63759,
 116209862,
 69913,
 -1,
 116395834,
 69912,
 116590325,
 116167763,
 -1,
 -63756,
 116561048,
 69920,
 -1,
 116592442,
 69921,
 116786936,
 116549379,
 -1,
 -63753,
 116734150,
 69916,
 -1,
 116789050,
 69915,
 116983547,
 116738102,
 -1,
 -63750,
 116930758,
 69896,
 -1,
 116985658,
 69895,
 117180158,
 116934448,
 -1,
 -63747,
 117127366,
 69903,
 -1,
 117182266,
 69902,
 117376769,
 117126346,
 -1,
 -63744,
 117323974,
 69898,
 -1,
 117378874,
 69897,
 117573380,
 117316550,
 -1,
 -63741,
 117520582,
 69901,
 -1,
 117575482,
 69900,
 117769991,
 117512181,
 -1,
 -63738,
 117717190,
 69918,
 -1,
 117772090,
 69917,
 -63736,
 117739446,
 69924,
 -63735,
 117933643,
 69893,
 -63734,
 117994986,
 69925,
 -63733,
 118058463,
 69922,
 -63732,
 118116992,
 69919,
 -63731,
 118180744,
 69923,
 -63730,
 118242911,
 69892,
 -63729,
 118307014,
 69926,
 -63728,
 118368379,
 69894,
 -1,
 118427450,
 69891,
 118621986,
 115352270,
 -1,
 118687520,
 118571277,
 -1,
 118753046,
 118652473,
 -1,
 -63723,
 118723218,
 69944,
 -1,
 118766942,
 69945,
 118949657,
 118715790,
 -1,
 -63720,
 118900441,
 69948,
 -1,
 118960000,
 69949,
 119146268,
 118894935,
 -1,
 -63717,
 119104634,
 69946,
 -1,
 119162504,
 69947,
 -63715,
 119117521,
 69942,
 -63714,
 119300094,
 69943,
 -63713,
 119364255,
 69951,
 -1,
 119417653,
 69950,
 -63711,
 118645787,
 69954,
 -1,
 119542690,
 69953,
 119736111,
 118590420,
 -1,
 119801646,
 119695019,
 -1,
 119867175,
 119738049,
 69927,
 -63706,
 119834187,
 69935,
 -1,
 119881311,
 69933,
 120063785,
 119834187,
 69930,
 -1,
 120030795,
 69931,
 120194859,
 120020199,
 69934,
 -1,
 120143455,
 69936,
 120325933,
 120143455,
 69928,
 -1,
 120274527,
 69929,
 -1,
 120268923,
 69932,
 -1,
 119751979,
 69939,
 120588085,
 119698830,
 -1,
 120653620,
 120537373,
 -1,
 -63694,
 120622621,
 69890,
 -63693,
 120659035,
 69888,
 -1,
 120722524,
 69889,
 -1,
 120597023,
 69952,
 -63690,
 120548632,
 69955,
 -63689,
 120937725,
 69937,
 -63688,
 121000586,
 69940,
 -1,
 121050932,
 69938,
 121243458,
 115305834,
 -1,
 121308990,
 121208484,
 -1,
 121374525,
 121277094,
 128200,
 -1,
 121307302,
 128185,
 -1,
 121317300,
 128201,
 121634815,
 121245719,
 983058,
 121700351,
 121503744,
 -1,
 -63679,
 121606577,
 983139,
 -1,
 121665286,
 983136,
 -1,
 121193425,
 9939,
 121898826,
 108079227,
 -1,
 121964359,
 121861273,
 -1,
 -63674,
 121934944,
 127800,
 -1,
 121978952,
 127826,
 -63672,
 121928836,
 127792,
 -63671,
 122121475,
 127937,
 -1,
 122170868,
 128227,
 122357582,
 121847391,
 -1,
 -63668,
 122319944,
 9911,
 -63667,
 122375399,
 128696,
 -1,
 122429277,
 128020,
 -63665,
 122325749,
 9962,
 -63664,
 122581910,
 127876,
 -1,
 122641799,
 127851,
 122816563,
 108041299,
 -1,
 122882030,
 122778337,
 -1,
 122947487,
 122845698,
 -1,
 123012956,
 122888910,
 -1,
 123078489,
 122983987,
 -1,
 -63657,
 123049647,
 42633,
 -63656,
 123113545,
 42627,
 -1,
 123153343,
 42563,
 -63654,
 123048009,
 42625,
 -63653,
 123298855,
 42605,
 -1,
 123357098,
 42569,
 123537251,
 122977849,
 -1,
 123602784,
 123499918,
 -1,
 -63649,
 123572297,
 42639,
 -1,
 123631235,
 42641,
 -63647,
 123572297,
 42637,
 -63646,
 123742512,
 42635,
 -1,
 123805136,
 42643,
 123996012,
 123499918,
 -1,
 124061545,
 123952653,
 -1,
 124127080,
 124004475,
 -1,
 -63641,
 124080676,
 42599,
 -1,
 124144458,
 42597,
 -1,
 124068819,
 42595,
 124452863,
 124008603,
 -1,
 -63637,
 124358729,
 42647,
 -1,
 124401844,
 1319,
 124585843,
 123956586,
 -1,
 124651378,
 124530656,
 -1,
 -63633,
 124622511,
 1297,
 -63632,
 124687907,
 42581,
 -63631,
 124748975,
 42593,
 -1,
 124790898,
 42565,
 -1,
 124598449,
 1303,
 125044601,
 124536061,
 -1,
 125110136,
 124993635,
 -1,
 -63626,
 125080821,
 42579,
 -63625,
 125116327,
 42589,
 -1,
 125177537,
 42583,
 -1,
 125046465,
 42567,
 125437821,
 125015123,
 -1,
 -63621,
 125393005,
 42591,
 -63620,
 125447706,
 42577,
 -1,
 125505664,
 1305,
 125699970,
 125384859,
 -1,
 125765505,
 125636368,
 -1,
 -63616,
 125730012,
 1279,
 -1,
 125779083,
 1277,
 -1,
 125734985,
 42645,
 126027655,
 125642875,
 -1,
 126093190,
 125979480,
 -1,
 -63611,
 126047774,
 1313,
 -1,
 126106763,
 1299,
 -1,
 126048401,
 1315,
 126355339,
 125966325,
 -1,
 -63607,
 126317564,
 42573,
 -63606,
 126373393,
 42587,
 -1,
 126436294,
 42603,
 126617486,
 126326323,
 -1,
 -63603,
 126565961,
 42629,
 -1,
 126626793,
 42561,
 126814097,
 126576387,
 -1,
 -63600,
 126757138,
 1317,
 -1,
 126816981,
 1231,
 127010708,
 126768995,
 -1,
 -63597,
 126957515,
 42571,
 -1,
 127017560,
 42601,
 127207319,
 126957239,
 -1,
 -63594,
 127171819,
 1275,
 -1,
 127214641,
 1271,
 127403930,
 127146950,
 -1,
 -63591,
 127357152,
 42585,
 -1,
 127409616,
 42631,
 -63589,
 127373385,
 1309,
 -63588,
 127560757,
 1307,
 -63587,
 127621665,
 42575,
 -63586,
 127684322,
 1301,
 -1,
 127734413,
 1311,
 127928297,
 122887317,
 -1,
 127993768,
 127869646,
 -1,
 128059301,
 127964723,
 -1,
 -63581,
 128030383,
 42632,
 -63580,
 128094281,
 42626,
 -1,
 128134079,
 42562,
 -63578,
 128028745,
 42624,
 -63577,
 128279591,
 42604,
 -1,
 128337834,
 42568,
 128518063,
 127958585,
 -1,
 128583596,
 128480654,
 -1,
 -63573,
 128553033,
 42638,
 -1,
 128611971,
 42640,
 -63571,
 128553033,
 42636,
 -63570,
 128723248,
 42634,
 -1,
 128785872,
 42642,
 128976824,
 128480654,
 -1,
 129042357,
 128933389,
 -1,
 129107892,
 128985211,
 -1,
 -63565,
 129061412,
 42598,
 -1,
 129125194,
 42596,
 -1,
 129049555,
 42594,
 129433599,
 128989339,
 -1,
 -63561,
 129339465,
 42646,
 -1,
 129382580,
 1318,
 129566655,
 128937322,
 -1,
 129632190,
 129511392,
 -1,
 -63557,
 129603247,
 1296,
 -63556,
 129668643,
 42580,
 -63555,
 129729711,
 42592,
 -1,
 129771634,
 42564,
 -1,
 129579185,
 1302,
 130025413,
 129516797,
 -1,
 130090948,
 129974371,
 -1,
 -63550,
 130061557,
 42578,
 -63549,
 130097063,
 42588,
 -1,
 130158273,
 42582,
 -1,
 130027201,
 42566,
 130418633,
 129995859,
 -1,
 -63545,
 130373741,
 42590,
 -63544,
 130428442,
 42576,
 -1,
 130486400,
 1304,
 130680782,
 130365595,
 -1,
 130746317,
 130617104,
 -1,
 -63540,
 130710748,
 1278,
 -1,
 130759819,
 1276,
 -1,
 130715721,
 42644,
 131008467,
 130623611,
 -1,
 131074002,
 130960216,
 -1,
 -63535,
 131028510,
 1312,
 -1,
 131087499,
 1298,
 -1,
 131029137,
 1314,
 131336151,
 130947061,
 -1,
 -63531,
 131298300,
 42572,
 -63530,
 131354129,
 42586,
 -1,
 131417030,
 42602,
 131598298,
 131307059,
 -1,
 -63527,
 131546697,
 42628,
 -1,
 131607529,
 42560,
 131794909,
 131553123,
 -1,
 -63524,
 131741643,
 42570,
 -1,
 131801688,
 42600,
 131991520,
 131741367,
 -1,
 -63521,
 131955947,
 1274,
 -1,
 131998769,
 1270,
 132188131,
 131931078,
 -1,
 -63518,
 132141280,
 42584,
 -1,
 132193744,
 42630,
 -63516,
 132157513,
 1308,
 -63515,
 132344885,
 1306,
 -63514,
 132409371,
 1316,
 -63513,
 132471329,
 42574,
 -63512,
 132533986,
 1300,
 -1,
 132584077,
 1310,
 132777964,
 127880785,
 -1,
 -63509,
 132741590,
 7467,
 -1,
 132798427,
 42606,
 -63507,
 132737027,
 42623,
 -1,
 132925800,
 42622,
 133105714,
 122841940,
 -1,
 133171189,
 133070393,
 -1,
 -63503,
 133137995,
 67633,
 -63502,
 133192935,
 67632,
 -63501,
 133250655,
 67631,
 -63500,
 133310587,
 67630,
 -1,
 133369537,
 67629,
 133564411,
 133133710,
 -1,
 -63497,
 133531211,
 67628,
 -63496,
 133586151,
 67627,
 -63495,
 133643871,
 67626,
 -63494,
 133703803,
 67625,
 -1,
 133762753,
 67624,
 133957633,
 133524842,
 -1,
 -63491,
 133924427,
 67623,
 -63490,
 133979367,
 67622,
 -63489,
 134037087,
 67621,
 -63488,
 134097019,
 67620,
 -1,
 134155969,
 67619,
 134350855,
 133916419,
 -1,
 -63485,
 134317643,
 67618,
 -63484,
 134372583,
 67617,
 -63483,
 134430303,
 67616,
 -63482,
 134490235,
 67615,
 -1,
 134549185,
 67614,
 134744077,
 134305901,
 -1,
 -63479,
 134710859,
 67613,
 -63478,
 134765799,
 67612,
 -63477,
 134823519,
 67611,
 -63476,
 134883451,
 67610,
 -1,
 134942401,
 67609,
 135137299,
 134697508,
 -1,
 -63473,
 135104075,
 67608,
 -63472,
 135159015,
 67607,
 -63471,
 135216735,
 67606,
 -63470,
 135276667,
 67605,
 -1,
 135335617,
 67604,
 135530521,
 135088970,
 -1,
 -63467,
 135497291,
 67603,
 -63466,
 135552231,
 67602,
 -63465,
 135609951,
 67601,
 -63464,
 135669883,
 67600,
 -1,
 135728833,
 67599,
 135923743,
 135481398,
 -1,
 -63461,
 135890507,
 67598,
 -63460,
 135945447,
 67597,
 -63459,
 136003167,
 67596,
 -63458,
 136063099,
 67595,
 -1,
 136122049,
 67594,
 136316964,
 135892844,
 -1,
 -63455,
 136273127,
 67637,
 -63454,
 136330847,
 67636,
 -63453,
 136390779,
 67635,
 -1,
 136449729,
 67634,
 136644647,
 136287795,
 -1,
 -63450,
 136600807,
 67647,
 -1,
 136646337,
 67644,
 136841258,
 136614815,
 -1,
 -63447,
 136783995,
 67640,
 -1,
 136842945,
 67639,
 137037869,
 136791856,
 -1,
 -63444,
 136994023,
 67592,
 -1,
 137039553,
 67589,
 -63442,
 137004619,
 67588,
 -63441,
 137190631,
 67587,
 -63440,
 137248351,
 67586,
 -63439,
 137308283,
 67585,
 -1,
 137367233,
 67584,
 -1,
 133046152,
 127744,
 137627858,
 122767317,
 -1,
 137693357,
 137568342,
 -1,
 137758790,
 137632710,
 -1,
 -63433,
 137703767,
 64207,
 -63432,
 137767035,
 64206,
 -63431,
 137831118,
 64205,
 -63430,
 137894854,
 64204,
 -63429,
 137959413,
 64203,
 -63428,
 138022593,
 64202,
 -63427,
 138088074,
 64201,
 -63426,
 138153558,
 64200,
 -63425,
 138219031,
 64199,
 -63424,
 138284509,
 64198,
 -63423,
 138349936,
 64197,
 -63422,
 138415410,
 64196,
 -63421,
 138480842,
 64195,
 -63420,
 138546227,
 64194,
 -63419,
 138611619,
 64193,
 -1,
 138677024,
 64192,
 138872919,
 137697269,
 -1,
 -63416,
 138817879,
 64191,
 -63415,
 138881147,
 64190,
 -63414,
 138945230,
 64189,
 -63413,
 139008966,
 64188,
 -63412,
 139073525,
 64187,
 -63411,
 139136705,
 64186,
 -63410,
 139202186,
 64185,
 -63409,
 139267670,
 64184,
 -63408,
 139333143,
 64183,
 -63407,
 139398621,
 64182,
 -63406,
 139464048,
 64181,
 -63405,
 139529522,
 64180,
 -63404,
 139594954,
 64179,
 -63403,
 139660339,
 64178,
 -63402,
 139725731,
 64177,
 -1,
 139791136,
 64176,
 139987048,
 138809025,
 -1,
 -63399,
 139931991,
 64175,
 -63398,
 139995259,
 64174,
 -63397,
 140059342,
 64173,
 -63396,
 140123078,
 64172,
 -63395,
 140187637,
 64171,
 -63394,
 140250817,
 64170,
 -63393,
 140316298,
 64169,
 -63392,
 140381782,
 64168,
 -63391,
 140447255,
 64167,
 -63390,
 140512733,
 64166,
 -63389,
 140578160,
 64165,
 -63388,
 140643634,
 64164,
 -63387,
 140709066,
 64163,
 -63386,
 140774451,
 64162,
 -63385,
 140839843,
 64161,
 -1,
 140905248,
 64160,
 141101177,
 139923082,
 -1,
 -63382,
 141046103,
 64159,
 -63381,
 141109371,
 64158,
 -63380,
 141173454,
 64157,
 -63379,
 141237190,
 64156,
 -63378,
 141301749,
 64155,
 -63377,
 141364929,
 64154,
 -63376,
 141430410,
 64153,
 -63375,
 141495894,
 64152,
 -63374,
 141561367,
 64151,
 -63373,
 141626845,
 64150,
 -63372,
 141692272,
 64149,
 -63371,
 141757746,
 64148,
 -63370,
 141823178,
 64147,
 -63369,
 141888563,
 64146,
 -63368,
 141953955,
 64145,
 -1,
 142019360,
 64144,
 142215306,
 141037142,
 -1,
 -63365,
 142160215,
 64143,
 -63364,
 142223483,
 64142,
 -63363,
 142287566,
 64141,
 -63362,
 142351302,
 64140,
 -63361,
 142415861,
 64139,
 -63360,
 142479041,
 64138,
 -63359,
 142544522,
 64137,
 -63358,
 142610006,
 64136,
 -63357,
 142675479,
 64135,
 -63356,
 142740957,
 64134,
 -63355,
 142806384,
 64133,
 -63354,
 142871858,
 64132,
 -63353,
 142937290,
 64131,
 -63352,
 143002675,
 64130,
 -63351,
 143068067,
 64129,
 -1,
 143133472,
 64128,
 143329435,
 142151191,
 -1,
 -63348,
 143274327,
 64127,
 -63347,
 143337595,
 64126,
 -63346,
 143401678,
 64125,
 -63345,
 143465414,
 64124,
 -63344,
 143529973,
 64123,
 -63343,
 143593153,
 64122,
 -63342,
 143658634,
 64121,
 -63341,
 143724118,
 64120,
 -63340,
 143789591,
 64119,
 -63339,
 143855069,
 64118,
 -63338,
 143920496,
 64117,
 -63337,
 143985970,
 64116,
 -63336,
 144051402,
 64115,
 -63335,
 144116787,
 64114,
 -63334,
 144182179,
 64113,
 -1,
 144247584,
 64112,
 144443558,
 143270606,
 -1,
 -63331,
 144379530,
 64217,
 -63330,
 144445014,
 64216,
 -63329,
 144510487,
 64215,
 -63328,
 144575965,
 64214,
 -63327,
 144641392,
 64213,
 -63326,
 144706866,
 64212,
 -63325,
 144772298,
 64211,
 -63324,
 144837683,
 64210,
 -63323,
 144903075,
 64209,
 -1,
 144968480,
 64208,
 145164458,
 144379357,
 -1,
 -63320,
 145105614,
 64109,
 -63319,
 145169350,
 64108,
 -1,
 145233909,
 64107,
 145489919,
 145099827,
 -1,
 -63316,
 145371479,
 64047,
 -1,
 145434747,
 64046,
 145686527,
 137657571,
 -1,
 145688764,
 145569947,
 12752,
 145754296,
 145659443,
 12757,
 145819828,
 145724979,
 12741,
 145885363,
 145790515,
 12750,
 -1,
 145831114,
 12769,
 -1,
 145843971,
 12747,
 146081974,
 145788780,
 12749,
 -1,
 146027722,
 12744,
 -63305,
 146046521,
 12746,
 -1,
 146158794,
 12742,
 146344122,
 145712899,
 12743,
 -1,
 146313379,
 12748,
 -63301,
 146314319,
 12768,
 -1,
 146420938,
 12758,
 146606278,
 145651086,
 12753,
 146671808,
 146576947,
 12759,
 -63297,
 146642483,
 12766,
 -1,
 146706595,
 12745,
 146868419,
 146640748,
 12740,
 -63294,
 146839091,
 12760,
 -1,
 146879690,
 12767,
 -63292,
 146832953,
 12761,
 -63291,
 147023619,
 12755,
 -1,
 147076298,
 12762,
 147261642,
 146564867,
 12754,
 -63288,
 147232307,
 12764,
 -63287,
 147272906,
 12770,
 -1,
 147333838,
 12763,
 147523788,
 147226169,
 12736,
 -1,
 147478637,
 12765,
 -63283,
 147493914,
 12738,
 -63282,
 147624099,
 12737,
 -63281,
 147680295,
 12771,
 -63280,
 147740781,
 12751,
 -63279,
 147792590,
 12756,
 -1,
 147856306,
 12739,
 148048265,
 137563841,
 -1,
 148113735,
 148002925,
 983098,
 148179268,
 148050027,
 -1,
 148244709,
 148135143,
 -1,
 148310244,
 148195261,
 -1,
 148375773,
 148265069,
 6361,
 148504575,
 148344684,
 -1,
 148506843,
 148397287,
 6347,
 -1,
 148462823,
 6349,
 148701183,
 148455007,
 6343,
 -1,
 148586079,
 6345,
 148768991,
 148338062,
 6362,
 -1,
 148715675,
 6363,
 -63264,
 148733497,
 6357,
 -63263,
 148858627,
 6356,
 -63262,
 148918820,
 6360,
 -63261,
 148981814,
 6358,
 -1,
 149035974,
 6359,
 -1,
 148280403,
 6320,
 149293302,
 148213612,
 -1,
 149358832,
 149250309,
 -1,
 149424367,
 149324274,
 -1,
 149489898,
 149380327,
 5754,
 -1,
 149445863,
 5755,
 149620972,
 149438047,
 5752,
 -1,
 149569119,
 5753,
 149752046,
 149556929,
 5756,
 -1,
 149688001,
 5757,
 -1,
 149695092,
 5751,
 -1,
 149369563,
 5758,
 150014197,
 149302896,
 -1,
 150079732,
 149948946,
 -1,
 -63245,
 150036728,
 6369,
 -1,
 150081338,
 6370,
 -1,
 150023684,
 6365,
 -1,
 149952450,
 6323,
 150407427,
 149255566,
 -1,
 150472958,
 150345666,
 6335,
 150601727,
 150422930,
 -1,
 150604028,
 150501157,
 -1,
 -63237,
 150573129,
 6378,
 -1,
 150626552,
 6379,
 -63235,
 150554670,
 6385,
 -1,
 150748295,
 6380,
 150931714,
 150419611,
 -1,
 -63232,
 150901629,
 6338,
 -63231,
 150955772,
 6336,
 -1,
 151001026,
 6337,
 -1,
 150890236,
 6334,
 151259407,
 150371897,
 -1,
 151324936,
 151224533,
 -1,
 -63226,
 151294025,
 6373,
 -63225,
 151347448,
 6374,
 -1,
 151392058,
 6375,
 151587083,
 151277279,
 -1,
 -63222,
 151556169,
 6376,
 -1,
 151609592,
 6377,
 151783694,
 151535170,
 -1,
 -63219,
 151726203,
 6371,
 -1,
 151785153,
 6372,
 -1,
 151721922,
 6327,
 152045849,
 151219562,
 -1,
 152111383,
 152014700,
 -1,
 152176915,
 152067303,
 6353,
 -1,
 152132839,
 6354,
 152307989,
 152125023,
 6351,
 -1,
 152256095,
 6352,
 -63210,
 152250996,
 6350,
 -1,
 152374977,
 6355,
 -63208,
 152049602,
 6341,
 -1,
 152504858,
 6368,
 152701217,
 152000621,
 -1,
 152766751,
 152670060,
 -1,
 152832285,
 152722663,
 6346,
 -1,
 152788199,
 6348,
 153026559,
 152780383,
 6342,
 -1,
 152911455,
 6344,
 -63200,
 152725244,
 6331,
 -1,
 153032642,
 6332,
 153225515,
 152640716,
 -1,
 153291047,
 153171146,
 -1,
 153356582,
 153259884,
 -1,
 -63195,
 153323083,
 6381,
 -1,
 153358017,
 6384,
 -1,
 153292602,
 6383,
 153618730,
 153232397,
 -1,
 -63191,
 153583427,
 6389,
 -1,
 153626823,
 6382,
 -1,
 153569330,
 6386,
 153880879,
 153184003,
 -1,
 -63187,
 153850749,
 6326,
 -63186,
 153904892,
 6324,
 -1,
 153950146,
 6325,
 154143028,
 153819125,
 -1,
 154208563,
 154085875,
 -1,
 -63182,
 154168682,
 6388,
 -1,
 154225482,
 6387,
 -1,
 154160058,
 5759,
 154470711,
 154113107,
 -1,
 -63178,
 154429180,
 6339,
 -1,
 154474434,
 6340,
 154667322,
 154421302,
 -1,
 -63175,
 154636336,
 6329,
 -1,
 154671042,
 6328,
 154863933,
 154612426,
 -1,
 -63172,
 154827313,
 6366,
 -1,
 154889796,
 6367,
 155060544,
 154799809,
 -1,
 -63169,
 155030611,
 6321,
 -1,
 155064258,
 6322,
 -63167,
 155014224,
 6330,
 -63166,
 155208864,
 6333,
 -63165,
 155270744,
 5120,
 -1,
 155331017,
 6364,
 155519302,
 148118895,
 983097,
 -1,
 155451659,
 983170,
 -1,
 155461729,
 127852,
 155715968,
 148073834,
 -1,
 155781499,
 155664110,
 -1,
 155846991,
 155747915,
 66226,
 155975679,
 155813451,
 66239,
 156041215,
 155878987,
 66212,
 -63155,
 155944523,
 66235,
 -63154,
 155978954,
 66256,
 -1,
 156044339,
 66248,
 156240213,
 155809166,
 66224,
 156305746,
 156204601,
 66242,
 -1,
 156240947,
 66243,
 156436820,
 156252315,
 66222,
 -1,
 156372019,
 66223,
 -1,
 156398990,
 66232,
 156633434,
 156193316,
 66218,
 156762111,
 156571637,
 66250,
 -63144,
 156634418,
 66253,
 -63143,
 156699850,
 66252,
 -1,
 156765235,
 66251,
 156961118,
 156588141,
 66229,
 -63140,
 156915821,
 66227,
 -63139,
 156972234,
 66244,
 -1,
 157033166,
 66238,
 157223265,
 156925497,
 66221,
 157351935,
 157187641,
 66247,
 -1,
 157223987,
 66230,
 157419876,
 157174602,
 66211,
 157548543,
 157360846,
 66214,
 -1,
 157420595,
 66254,
 157616486,
 157379946,
 66213,
 -1,
 157576554,
 66249,
 157747560,
 157574915,
 66231,
 -1,
 157682739,
 66209,
 157878634,
 157698102,
 66236,
 -1,
 157813811,
 66237,
 158009708,
 157826655,
 66233,
 -1,
 157957727,
 66245,
 158140782,
 157955274,
 66240,
 -1,
 158075955,
 66241,
 158271856,
 158083195,
 66234,
 -1,
 158207027,
 66255,
 158402930,
 158212814,
 66210,
 -1,
 158338099,
 66220,
 158534005,
 158342108,
 -1,
 -63116,
 158469423,
 66246,
 -1,
 158534691,
 66225,
 158730615,
 158469825,
 66208,
 -1,
 158665779,
 66215,
 -63112,
 158700447,
 66228,
 -63111,
 158821415,
 66216,
 -63110,
 158883047,
 66219,
 -1,
 158930933,
 66217,
 -63108,
 155742547,
 983073,
 -63107,
 159082284,
 127887,
 -63106,
 159147216,
 127904,
 -63105,
 159195880,
 128199,
 -1,
 159254102,
 9936,
 159451525,
 155680313,
 128008,
 159580159,
 159383998,
 128049,
 159645695,
 159451044,
 -1,
 -63100,
 159552385,
 128572,
 -1,
 159612892,
 128569,
 -63098,
 159415423,
 9963,
 -63097,
 159733196,
 128247,
 -63096,
 159796746,
 128197,
 -1,
 159851075,
 127797,
 160041415,
 147999562,
 -1,
 160106945,
 159997159,
 -1,
 160172474,
 160046911,
 -1,
 160238006,
 160104900,
 -1,
 160303515,
 160202297,
 -1,
 160369045,
 160272236,
 -1,
 160434578,
 160324839,
 -1,
 -63087,
 160369432,
 128349,
 -1,
 160433007,
 128337,
 160694271,
 160377800,
 -1,
 -63084,
 160566040,
 128359,
 -1,
 160629615,
 128347,
 160827800,
 160316766,
 -1,
 -63081,
 160762648,
 128350,
 -1,
 160826223,
 128338,
 161087487,
 160771069,
 -1,
 -63078,
 160959256,
 128357,
 -1,
 161022831,
 128345,
 161221026,
 160265614,
 -1,
 161286559,
 161171161,
 -1,
 -63074,
 161221400,
 128353,
 -1,
 161284975,
 128341,
 161546239,
 161230720,
 -1,
 -63071,
 161418008,
 128354,
 -1,
 161481583,
 128342,
 161679785,
 161165655,
 -1,
 161745318,
 161637498,
 -1,
 -63067,
 161680152,
 128351,
 -1,
 161743727,
 128339,
 162004991,
 161695368,
 -1,
 -63064,
 161876760,
 128352,
 -1,
 161940335,
 128340,
 162138544,
 161622139,
 -1,
 162204077,
 162090677,
 -1,
 -63060,
 162138904,
 128358,
 -1,
 162202479,
 128346,
 162463743,
 162152642,
 -1,
 -63057,
 162335512,
 128355,
 -1,
 162399087,
 128343,
 162597299,
 162095102,
 -1,
 -63054,
 162532120,
 128348,
 -1,
 162595695,
 128336,
 162856959,
 162552479,
 -1,
 -63051,
 162728728,
 128356,
 -1,
 162792303,
 128344,
 163053567,
 160207232,
 -1,
 163056057,
 162951795,
 128257,
 -1,
 162990056,
 128258,
 -1,
 162998155,
 128259,
 163315711,
 160134835,
 -1,
 163318206,
 163205871,
 -1,
 -63043,
 163278415,
 128235,
 -1,
 163336544,
 128234,
 -63041,
 163285199,
 127746,
 -63040,
 163467384,
 128272,
 -1,
 163519167,
 128213,
 163711428,
 160054879,
 -1,
 -63037,
 163670027,
 128203,
 -1,
 163732214,
 127867,
 163971071,
 163648668,
 -1,
 -63034,
 163857123,
 128079,
 -1,
 163917160,
 127916,
 164104688,
 159989343,
 -1,
 164170222,
 164065084,
 -1,
 164235757,
 164121910,
 -1,
 164301270,
 164191279,
 -1,
 164366799,
 164265529,
 -1,
 -63027,
 164335698,
 12873,
 -63026,
 164379613,
 12874,
 -1,
 164441133,
 12872,
 164628946,
 164328846,
 -1,
 -63023,
 164579067,
 12877,
 -1,
 164638643,
 12878,
 164825557,
 164573527,
 -1,
 -63020,
 164782882,
 12875,
 -1,
 164839530,
 12876,
 -1,
 164768607,
 12879,
 165087715,
 164249183,
 -1,
 165153248,
 165028903,
 -1,
 165218779,
 165103670,
 -1,
 -63014,
 165176306,
 12871,
 -1,
 165233208,
 12869,
 165415390,
 165154497,
 -1,
 -63011,
 165357647,
 127568,
 -1,
 165420352,
 127569,
 -63009,
 165377624,
 12870,
 -1,
 165571855,
 12868,
 165806079,
 165117777,
 -1,
 -63006,
 165703018,
 127276,
 -1,
 165747654,
 127275,
 165939688,
 165026758,
 -1,
 166005223,
 165901421,
 -1,
 -63002,
 165954300,
 9938,
 -1,
 166004190,
 128320,
 -1,
 165946062,
 127277,
 166267371,
 165890751,
 -1,
 -62998,
 166217768,
 12925,
 -1,
 166272436,
 12924,
 -62996,
 166237084,
 127278,
 -1,
 166410655,
 12926,
 -1,
 164203334,
 127914,
 -62993,
 164136507,
 127750,
 -1,
 166615540,
 127910,
 166791686,
 164064618,
 983074,
 166857214,
 166747367,
 -1,
 166922748,
 166820784,
 -1,
 166988279,
 166865451,
 -1,
 -62987,
 166952393,
 9876,
 -62986,
 167008707,
 127370,
 -1,
 167064385,
 127884,
 167250427,
 166920192,
 -1,
 167315962,
 167209606,
 128322,
 -1,
 167250095,
 128321,
 -1,
 167269364,
 10060,
 -1,
 167199484,
 9932,
 -62979,
 166892135,
 128081,
 -1,
 167518216,
 128010,
 167709187,
 166827091,
 -1,
 167774722,
 167658138,
 -1,
 -62975,
 167719351,
 128546,
 -1,
 167779557,
 128575,
 -1,
 167738409,
 128302,
 168099839,
 167651451,
 -1,
 -62971,
 167999053,
 127769,
 -1,
 168043852,
 128179,
 168233481,
 166733947,
 -1,
 -62968,
 168194203,
 9907,
 -1,
 168240273,
 8373,
 -62966,
 168196212,
 983187,
 -62965,
 168376160,
 983200,
 -1,
 168435106,
 983171,
 168628143,
 10363,
 -1,
 168693427,
 168573048,
 -1,
 168757902,
 168627905,
 -1,
 168823399,
 168692512,
 -1,
 168888863,
 168758578,
 -1,
 168954387,
 168824176,
 77877,
 -1,
 168890049,
 77878,
 169085461,
 168889546,
 77874,
 -1,
 169021121,
 77875,
 169216535,
 169020467,
 77872,
 -1,
 169152193,
 77873,
 169347609,
 169151264,
 77869,
 -1,
 169283265,
 77870,
 -62950,
 169283210,
 77882,
 -62949,
 169414230,
 77881,
 -62948,
 169479703,
 77880,
 -62947,
 169545181,
 77879,
 -62946,
 169610546,
 77876,
 -1,
 169675683,
 77871,
 169871916,
 168823715,
 -1,
 169937442,
 169807383,
 77844,
 -1,
 169873089,
 77845,
 170068516,
 169872690,
 77840,
 -1,
 170004161,
 77841,
 -62939,
 170004106,
 77847,
 -62938,
 170135126,
 77846,
 -62937,
 170200541,
 77843,
 -62936,
 170265968,
 77842,
 -62935,
 170331338,
 77839,
 -62934,
 170396723,
 77838,
 -62933,
 170462115,
 77837,
 -1,
 170527520,
 77836,
 170723897,
 169806624,
 -1,
 170789424,
 170659293,
 77830,
 -62929,
 170727413,
 77832,
 -1,
 170790593,
 77831,
 170986034,
 170724720,
 77828,
 -1,
 170921665,
 77829,
 -62925,
 170921610,
 77835,
 -62924,
 171052630,
 77834,
 -62923,
 171118103,
 77833,
 -62922,
 171183410,
 77827,
 -62921,
 171248842,
 77826,
 -62920,
 171314227,
 77825,
 -1,
 171379619,
 77824,
 171575877,
 170659018,
 -1,
 171641404,
 171510835,
 77860,
 -1,
 171577025,
 77861,
 -62915,
 171576970,
 77868,
 -62914,
 171707990,
 77867,
 -62913,
 171773463,
 77866,
 -62912,
 171838941,
 77865,
 -62911,
 171904368,
 77864,
 -62910,
 171969842,
 77863,
 -62909,
 172035274,
 77862,
 -62908,
 172100515,
 77859,
 -1,
 172165920,
 77858,
 172362320,
 171511261,
 -1,
 -62905,
 172297866,
 77902,
 -62904,
 172363350,
 77901,
 -62903,
 172428823,
 77900,
 -62902,
 172494301,
 77899,
 -62901,
 172559728,
 77898,
 -62900,
 172625202,
 77897,
 -62899,
 172690634,
 77896,
 -62898,
 172756019,
 77895,
 -62897,
 172821411,
 77894,
 -1,
 172886816,
 77893,
 173083227,
 172297584,
 -1,
 -62894,
 173018762,
 77892,
 -62893,
 173084246,
 77891,
 -62892,
 173149719,
 77890,
 -62891,
 173215197,
 77889,
 -62890,
 173280624,
 77888,
 -62889,
 173346098,
 77887,
 -62888,
 173411530,
 77886,
 -62887,
 173476915,
 77885,
 -62886,
 173542307,
 77884,
 -1,
 173607712,
 77883,
 173804134,
 173018163,
 -1,
 -62883,
 173739658,
 77857,
 -62882,
 173805142,
 77856,
 -62881,
 173870615,
 77855,
 -62880,
 173936093,
 77854,
 -62879,
 174001520,
 77853,
 -62878,
 174066994,
 77852,
 -62877,
 174132426,
 77851,
 -62876,
 174197811,
 77850,
 -62875,
 174263203,
 77849,
 -1,
 174328608,
 77848,
 -1,
 173739593,
 77903,
 174653439,
 168759085,
 -1,
 174656116,
 174525216,
 -1,
 174721644,
 174591511,
 78867,
 -62869,
 174659573,
 78869,
 -1,
 174722753,
 78868,
 -62867,
 174657162,
 78871,
 -62866,
 174853718,
 78870,
 -62865,
 174919133,
 78866,
 -62864,
 174984560,
 78865,
 -62863,
 175050034,
 78864,
 -62862,
 175115466,
 78863,
 -62861,
 175180851,
 78862,
 -1,
 175246243,
 78861,
 175442559,
 174591027,
 -1,
 -62858,
 175378058,
 78891,
 -62857,
 175443542,
 78890,
 -62856,
 175509015,
 78889,
 -62855,
 175574493,
 78888,
 -62854,
 175639920,
 78887,
 -62853,
 175705394,
 78886,
 -62852,
 175770826,
 78885,
 -62851,
 175836211,
 78884,
 -62850,
 175901603,
 78883,
 -1,
 175967008,
 78882,
 176163466,
 175377315,
 -1,
 -62847,
 176098954,
 78881,
 -62846,
 176164438,
 78880,
 -62845,
 176229911,
 78879,
 -62844,
 176295389,
 78878,
 -62843,
 176360816,
 78877,
 -62842,
 176426290,
 78876,
 -62841,
 176491722,
 78875,
 -62840,
 176557107,
 78874,
 -62839,
 176622499,
 78873,
 -1,
 176687904,
 78872,
 176947199,
 176098506,
 -1,
 -62836,
 176819251,
 78894,
 -62835,
 176884643,
 78893,
 -1,
 176950048,
 78892,
 177146621,
 168712301,
 -1,
 177212102,
 177081120,
 -1,
 177277599,
 177147082,
 -1,
 177343123,
 177212951,
 78361,
 -1,
 177278657,
 78362,
 177474197,
 177278320,
 78358,
 -1,
 177409729,
 78359,
 177605271,
 177409330,
 78356,
 -1,
 177540801,
 78357,
 177736345,
 177540298,
 78354,
 -1,
 177671873,
 78355,
 -62822,
 177671818,
 78364,
 -62821,
 177802838,
 78363,
 -62820,
 177868253,
 78360,
 -62819,
 177933363,
 78353,
 -62818,
 177998755,
 78352,
 -1,
 178064160,
 78351,
 178260652,
 177212323,
 -1,
 178326179,
 178196054,
 78336,
 -62814,
 178264053,
 78338,
 -1,
 178327233,
 78337,
 -62812,
 178261642,
 78339,
 -62811,
 178458135,
 78335,
 -62810,
 178523613,
 78334,
 -62809,
 178589040,
 78333,
 -62808,
 178654514,
 78332,
 -62807,
 178719946,
 78331,
 -62806,
 178785331,
 78330,
 -62805,
 178850723,
 78329,
 -1,
 178916128,
 78328,
 179112632,
 178195507,
 -1,
 179178159,
 179047792,
 78345,
 -1,
 179113665,
 78346,
 -62800,
 179113610,
 78350,
 -62799,
 179244630,
 78349,
 -62798,
 179310103,
 78348,
 -62797,
 179375581,
 78347,
 -62796,
 179440946,
 78344,
 -62795,
 179506378,
 78343,
 -62794,
 179571763,
 78342,
 -62793,
 179637155,
 78341,
 -1,
 179702560,
 78340,
 179899074,
 179047200,
 -1,
 -62790,
 179834506,
 78327,
 -62789,
 179899990,
 78326,
 -62788,
 179965463,
 78325,
 -62787,
 180030941,
 78324,
 -62786,
 180096368,
 78323,
 -62785,
 180161842,
 78322,
 -62784,
 180227274,
 78321,
 -62783,
 180292659,
 78320,
 -1,
 180358051,
 78319,
 180617215,
 179834162,
 -1,
 -62780,
 180489267,
 78367,
 -62779,
 180554659,
 78366,
 -1,
 180620064,
 78365,
 180816612,
 177178280,
 -1,
 180882133,
 180751267,
 -1,
 180947658,
 180817494,
 78409,
 -1,
 180883137,
 78410,
 181078732,
 180882339,
 78401,
 -1,
 181014209,
 78402,
 181209806,
 181013280,
 78399,
 -1,
 181145281,
 78400,
 -62769,
 181145226,
 78411,
 -62768,
 181276183,
 78408,
 -62767,
 181341661,
 78407,
 -62766,
 181407088,
 78406,
 -62765,
 181472562,
 78405,
 -62764,
 181537994,
 78404,
 -1,
 181603379,
 78403,
 181799647,
 180816672,
 -1,
 -62761,
 181735050,
 78398,
 -62760,
 181800534,
 78397,
 -62759,
 181866007,
 78396,
 -62758,
 181931485,
 78395,
 -62757,
 181996912,
 78394,
 -62756,
 182062386,
 78393,
 -62755,
 182127818,
 78392,
 -62754,
 182193203,
 78391,
 -1,
 182258595,
 78390,
 182517759,
 181734451,
 -1,
 182520546,
 182389811,
 78414,
 -1,
 182456001,
 78415,
 -62749,
 182455203,
 78413,
 -1,
 182586144,
 78412,
 182845439,
 180767598,
 -1,
 182848241,
 182717347,
 -1,
 182913768,
 182783511,
 78385,
 -1,
 182849217,
 78386,
 -62743,
 182849162,
 78388,
 -62742,
 182980182,
 78387,
 -62741,
 183045597,
 78384,
 -62740,
 183111024,
 78383,
 -62739,
 183176498,
 78382,
 -62738,
 183241930,
 78381,
 -62737,
 183307315,
 78380,
 -62736,
 183372707,
 78379,
 -1,
 183438112,
 78378,
 183634684,
 182782752,
 -1,
 183700212,
 183569776,
 78372,
 -1,
 183635649,
 78373,
 -62731,
 183635594,
 78377,
 -62730,
 183766614,
 78376,
 -62729,
 183832087,
 78375,
 -62728,
 183897565,
 78374,
 -62727,
 183962930,
 78371,
 -62726,
 184028362,
 78370,
 -62725,
 184093747,
 78369,
 -1,
 184159139,
 78368,
 -1,
 183569577,
 78389,
 184421217,
 177087264,
 -1,
 184486676,
 184356208,
 -1,
 184552201,
 184421152,
 77997,
 -62719,
 184499807,
 78006,
 -62718,
 184563867,
 78005,
 -62717,
 184628426,
 78004,
 -62716,
 184693079,
 78003,
 -62715,
 184756347,
 78002,
 -62714,
 184820430,
 78001,
 -62713,
 184884166,
 78000,
 -62712,
 184948725,
 77999,
 -1,
 185011905,
 77998,
 185207563,
 184487218,
 78011,
 -1,
 185142977,
 78012,
 185338637,
 185142323,
 78008,
 -1,
 185274049,
 78009,
 -62706,
 185273994,
 78017,
 -62705,
 185405014,
 78016,
 -62704,
 185470487,
 78015,
 -62703,
 185535965,
 78014,
 -62702,
 185601392,
 78013,
 -62701,
 185666762,
 78010,
 -1,
 185732003,
 78007,
 185928485,
 184421853,
 -1,
 185994014,
 185863703,
 78025,
 -62697,
 185940123,
 78033,
 -62696,
 186004682,
 78032,
 -62695,
 186069335,
 78031,
 -62694,
 186132603,
 78030,
 -62693,
 186196686,
 78029,
 -62692,
 186260422,
 78028,
 -62691,
 186324981,
 78027,
 -1,
 186388161,
 78026,
 -62689,
 185929181,
 78024,
 -62688,
 186518896,
 78023,
 -62687,
 186584370,
 78022,
 -62686,
 186649802,
 78021,
 -62685,
 186715187,
 78020,
 -62684,
 186780579,
 78019,
 -1,
 186845984,
 78018,
 187042610,
 185863474,
 -1,
 187108136,
 186977878,
 77994,
 -1,
 187043521,
 77995,
 187239210,
 187043293,
 77991,
 -1,
 187174593,
 77992,
 -62677,
 187174538,
 77996,
 -62676,
 187305495,
 77993,
 -62675,
 187370864,
 77990,
 -62674,
 187436338,
 77989,
 -62673,
 187501770,
 77988,
 -62672,
 187567155,
 77987,
 -62671,
 187632547,
 77986,
 -1,
 187697952,
 77985,
 187894591,
 186977482,
 -1,
 187960117,
 187829554,
 77978,
 -1,
 187895489,
 77979,
 188091191,
 187894691,
 77974,
 -1,
 188026561,
 77975,
 -62664,
 188026506,
 77984,
 -62663,
 188157526,
 77983,
 -62662,
 188222999,
 77982,
 -62661,
 188288477,
 77981,
 -62660,
 188353904,
 77980,
 -62659,
 188419274,
 77977,
 -62658,
 188484659,
 77976,
 -1,
 188549920,
 77973,
 188746571,
 187829299,
 -1,
 188812098,
 188681751,
 77969,
 -1,
 188747457,
 77970,
 -62653,
 188747402,
 77972,
 -62652,
 188878422,
 77971,
 -62651,
 188943837,
 77968,
 -62650,
 189009264,
 77967,
 -62649,
 189074738,
 77966,
 -62648,
 189140170,
 77965,
 -62647,
 189205555,
 77964,
 -62646,
 189270947,
 77963,
 -1,
 189336352,
 77962,
 189533014,
 188681123,
 -1,
 -62643,
 189468298,
 77961,
 -62642,
 189533782,
 77960,
 -62641,
 189599255,
 77959,
 -62640,
 189664733,
 77958,
 -62639,
 189730160,
 77957,
 -62638,
 189795634,
 77956,
 -62637,
 189861066,
 77955,
 -62636,
 189926451,
 77954,
 -62635,
 189991843,
 77953,
 -1,
 190057248,
 77952,
 190316543,
 189467424,
 -1,
 190319449,
 190189142,
 77949,
 -1,
 190254785,
 77950,
 -62630,
 190254730,
 77951,
 -62629,
 190385687,
 77948,
 -62628,
 190451165,
 77947,
 -62627,
 190516592,
 77946,
 -62626,
 190582066,
 77945,
 -62625,
 190647498,
 77944,
 -62624,
 190712883,
 77943,
 -1,
 190778275,
 77942,
 190974899,
 184388583,
 -1,
 191040380,
 190909491,
 -1,
 191105904,
 190974752,
 78726,
 -62619,
 191056714,
 78738,
 -62618,
 191121462,
 78737,
 -62617,
 191186736,
 78736,
 -62616,
 191250015,
 78735,
 -62615,
 191314075,
 78734,
 -62614,
 191378634,
 78733,
 -62613,
 191443287,
 78732,
 -62612,
 191506555,
 78731,
 -62611,
 191570638,
 78730,
 -62610,
 191634374,
 78729,
 -62609,
 191698933,
 78728,
 -1,
 191762113,
 78727,
 191957874,
 191041162,
 78749,
 -1,
 191893185,
 78750,
 192088948,
 191893078,
 78747,
 -1,
 192024257,
 78748,
 192220022,
 192023754,
 78741,
 -1,
 192155329,
 78742,
 -62601,
 192155159,
 78746,
 -62600,
 192286173,
 78745,
 -62599,
 192351600,
 78744,
 -62598,
 192417074,
 78743,
 -62597,
 192482355,
 78740,
 -1,
 192547747,
 78739,
 192744338,
 190974752,
 -1,
 192809863,
 192678819,
 78690,
 -62593,
 192757343,
 78699,
 -62592,
 192821403,
 78698,
 -62591,
 192885962,
 78697,
 -62590,
 192950615,
 78696,
 -62589,
 193013883,
 78695,
 -62588,
 193077966,
 78694,
 -62587,
 193141702,
 78693,
 -62586,
 193206261,
 78692,
 -1,
 193269441,
 78691,
 193465226,
 192744983,
 78706,
 -62583,
 193402869,
 78708,
 -1,
 193466049,
 78707,
 193661836,
 193399859,
 78700,
 -1,
 193597121,
 78701,
 -62579,
 193597066,
 78710,
 -62578,
 193728086,
 78709,
 -62577,
 193793501,
 78705,
 -62576,
 193858928,
 78704,
 -62575,
 193924402,
 78703,
 -1,
 193989834,
 78702,
 194186146,
 192678819,
 -1,
 194251671,
 194120611,
 78712,
 -62571,
 194190278,
 78715,
 -62570,
 194254837,
 78714,
 -1,
 194318017,
 78713,
 194513818,
 194186291,
 78716,
 -62567,
 194451445,
 78718,
 -1,
 194514625,
 78717,
 -62565,
 194449034,
 78725,
 -62564,
 194645590,
 78724,
 -62563,
 194711063,
 78723,
 -62562,
 194776541,
 78722,
 -62561,
 194841968,
 78721,
 -62560,
 194907442,
 78720,
 -62559,
 194972874,
 78719,
 -1,
 195037984,
 78711,
 195234737,
 194120906,
 -1,
 195300261,
 195169815,
 78761,
 -1,
 195235521,
 78762,
 195431335,
 195235018,
 78756,
 -1,
 195366593,
 78757,
 195562409,
 195365795,
 78753,
 -1,
 195497665,
 78754,
 195693483,
 195496736,
 78751,
 -1,
 195628737,
 78752,
 -62548,
 195628682,
 78764,
 -62547,
 195759702,
 78763,
 -62546,
 195825117,
 78760,
 -62545,
 195890544,
 78759,
 -62544,
 195956018,
 78758,
 -1,
 196021299,
 78755,
 196280319,
 195169636,
 78765,
 -1,
 196153025,
 78766,
 196348933,
 190930195,
 -1,
 196414406,
 196283168,
 -1,
 196479932,
 196349405,
 78423,
 -62537,
 196424023,
 78429,
 -62536,
 196487291,
 78428,
 -62535,
 196551374,
 78427,
 -62534,
 196615110,
 78426,
 -62533,
 196679669,
 78425,
 -1,
 196742849,
 78424,
 196938686,
 196414832,
 78421,
 -1,
 196873921,
 78422,
 197069760,
 196873123,
 78416,
 -1,
 197004993,
 78417,
 -62527,
 197004938,
 78432,
 -62526,
 197135958,
 78431,
 -62525,
 197201431,
 78430,
 -62524,
 197266738,
 78420,
 -62523,
 197332170,
 78419,
 -1,
 197397555,
 78418,
 197594071,
 196349130,
 -1,
 197659596,
 197529053,
 78469,
 -62519,
 197599950,
 78473,
 -62518,
 197663686,
 78472,
 -62517,
 197728245,
 78471,
 -1,
 197791425,
 78470,
 197987278,
 197594314,
 78465,
 -1,
 197922497,
 78466,
 198118352,
 197921568,
 78461,
 -1,
 198053569,
 78462,
 -62511,
 198053514,
 78476,
 -62510,
 198184534,
 78475,
 -62509,
 198250007,
 78474,
 -62508,
 198315376,
 78468,
 -62507,
 198380850,
 78467,
 -62506,
 198446131,
 78464,
 -1,
 198511523,
 78463,
 198708198,
 197528627,
 -1,
 198773722,
 198643338,
 78459,
 -1,
 198708929,
 78460,
 198904796,
 198708592,
 78454,
 -1,
 198840001,
 78455,
 199035870,
 198839602,
 78452,
 -1,
 198971073,
 78453,
 199166944,
 198970144,
 78447,
 -1,
 199102145,
 78448,
 -62495,
 199102038,
 78458,
 -62494,
 199233047,
 78457,
 -62493,
 199298525,
 78456,
 -62492,
 199363786,
 78451,
 -62491,
 199429171,
 78450,
 -1,
 199494563,
 78449,
 199691253,
 198642595,
 -1,
 199756779,
 199625504,
 78433,
 -62487,
 199695302,
 78436,
 -62486,
 199759861,
 78435,
 -1,
 199823041,
 78434,
 200018925,
 199691914,
 78445,
 -1,
 199954113,
 78446,
 -62482,
 199954006,
 78444,
 -62481,
 200085015,
 78443,
 -62480,
 200150493,
 78442,
 -62479,
 200215920,
 78441,
 -62478,
 200281394,
 78440,
 -62477,
 200346826,
 78439,
 -62476,
 200412211,
 78438,
 -1,
 200477603,
 78437,
 200674304,
 199626034,
 -1,
 -62473,
 200609418,
 78486,
 -62472,
 200674902,
 78485,
 -62471,
 200740375,
 78484,
 -62470,
 200805853,
 78483,
 -62469,
 200871280,
 78482,
 -62468,
 200936754,
 78481,
 -62467,
 201002186,
 78480,
 -62466,
 201067571,
 78479,
 -62465,
 201132963,
 78478,
 -1,
 201198368,
 78477,
 201457663,
 200609136,
 -1,
 201460740,
 201329440,
 78487,
 -62461,
 201398261,
 78489,
 -1,
 201461441,
 78488,
 -1,
 201395107,
 78490,
 201722957,
 196301434,
 -1,
 201788445,
 201657251,
 -1,
 201853968,
 201722931,
 78268,
 -62455,
 201799835,
 78276,
 -62454,
 201864394,
 78275,
 -62453,
 201929047,
 78274,
 -62452,
 201992315,
 78273,
 -62451,
 202056398,
 78272,
 -62450,
 202120134,
 78271,
 -62449,
 202184693,
 78270,
 -1,
 202247873,
 78269,
 202443794,
 201788951,
 78283,
 -1,
 202378945,
 78284,
 202574868,
 202378717,
 78281,
 -1,
 202510017,
 78282,
 202705942,
 202509680,
 78279,
 -1,
 202641089,
 78280,
 202837016,
 202640160,
 78265,
 -1,
 202772161,
 78266,
 -62439,
 202772106,
 78286,
 -62438,
 202903126,
 78285,
 -62437,
 202968370,
 78278,
 -62436,
 203033802,
 78277,
 -1,
 203099043,
 78267,
 203295787,
 201723082,
 -1,
 203361313,
 203230410,
 78304,
 -62432,
 203298805,
 78306,
 -1,
 203361985,
 78305,
 203557923,
 203295651,
 78301,
 -1,
 203493057,
 78302,
 -62428,
 203493002,
 78312,
 -62427,
 203624022,
 78311,
 -62426,
 203689495,
 78310,
 -62425,
 203754973,
 78309,
 -62424,
 203820400,
 78308,
 -62423,
 203885874,
 78307,
 -62422,
 203951155,
 78303,
 -1,
 204016416,
 78300,
 204213305,
 203230259,
 -1,
 204278830,
 204148310,
 78297,
 -1,
 204213953,
 78298,
 204409904,
 204213554,
 78292,
 -1,
 204345025,
 78293,
 204540978,
 204344371,
 78289,
 -1,
 204476097,
 78290,
 -62413,
 204476042,
 78299,
 -62412,
 204606999,
 78296,
 -62411,
 204672477,
 78295,
 -62410,
 204737904,
 78294,
 -62409,
 204803274,
 78291,
 -62408,
 204868515,
 78288,
 -1,
 204933920,
 78287,
 205130822,
 204147488,
 -1,
 205196349,
 205065123,
 78253,
 -62404,
 205133813,
 78255,
 -1,
 205196993,
 78254,
 205392959,
 205130954,
 78257,
 -1,
 205328065,
 78258,
 -62400,
 205328010,
 78264,
 -62399,
 205459030,
 78263,
 -62398,
 205524503,
 78262,
 -62397,
 205589981,
 78261,
 -62396,
 205655408,
 78260,
 -62395,
 205720882,
 78259,
 -1,
 205786163,
 78256,
 206045183,
 205065522,
 -1,
 206048329,
 205916960,
 78313,
 -1,
 205983425,
 78314,
 -62390,
 205983026,
 78318,
 -62389,
 206113994,
 78317,
 -62388,
 206179379,
 78316,
 -1,
 206244771,
 78315,
 206441621,
 201666982,
 -1,
 206507100,
 206376242,
 -1,
 206572625,
 206442007,
 78132,
 -1,
 206507713,
 78133,
 206703699,
 206507485,
 78130,
 -1,
 206638785,
 78131,
 206834773,
 206638448,
 78128,
 -1,
 206769857,
 78129,
 -62378,
 206769802,
 78135,
 -62377,
 206900822,
 78134,
 -62376,
 206966066,
 78127,
 -62375,
 207031498,
 78126,
 -62374,
 207096883,
 78125,
 -62373,
 207162275,
 78124,
 -1,
 207227680,
 78123,
 207424618,
 206441674,
 -1,
 207490143,
 207359574,
 78120,
 -1,
 207425217,
 78121,
 207621217,
 207425047,
 78118,
 -1,
 207556289,
 78119,
 207752291,
 207555491,
 78111,
 -1,
 207687361,
 78112,
 -62364,
 207687306,
 78122,
 -62363,
 207818205,
 78117,
 -62362,
 207883632,
 78116,
 -62361,
 207949106,
 78115,
 -62360,
 208014538,
 78114,
 -62359,
 208079923,
 78113,
 -1,
 208145184,
 78110,
 208342134,
 207359027,
 -1,
 208407661,
 208276387,
 78100,
 -1,
 208342721,
 78101,
 -62354,
 208342666,
 78109,
 -62353,
 208473686,
 78108,
 -62352,
 208539159,
 78107,
 -62351,
 208604637,
 78106,
 -62350,
 208670064,
 78105,
 -62349,
 208735538,
 78104,
 -62348,
 208800970,
 78103,
 -62347,
 208866355,
 78102,
 -1,
 208931616,
 78099,
 209128578,
 208276387,
 -1,
 209194105,
 209063114,
 78091,
 -1,
 209129153,
 78092,
 -62342,
 209129098,
 78098,
 -62341,
 209260118,
 78097,
 -62340,
 209325591,
 78096,
 -62339,
 209391069,
 78095,
 -62338,
 209456496,
 78094,
 -62337,
 209521970,
 78093,
 -62336,
 209587251,
 78090,
 -62335,
 209652643,
 78089,
 -1,
 209718048,
 78088,
 209915021,
 209062688,
 -1,
 209980549,
 209849251,
 78078,
 -1,
 209915585,
 78079,
 -62330,
 209915530,
 78087,
 -62329,
 210046550,
 78086,
 -62328,
 210112023,
 78085,
 -62327,
 210177501,
 78084,
 -62326,
 210242928,
 78083,
 -62325,
 210308402,
 78082,
 -62324,
 210373834,
 78081,
 -1,
 210439219,
 78080,
 210698239,
 209849712,
 -1,
 210701458,
 210570147,
 78137,
 -62320,
 210639814,
 78140,
 -62319,
 210704373,
 78139,
 -1,
 210767553,
 78138,
 -62317,
 210635978,
 78142,
 -62316,
 210897971,
 78141,
 -1,
 210963232,
 78136,
 211160284,
 206386416,
 -1,
 211225763,
 211094834,
 -1,
 211291289,
 211160432,
 78196,
 -1,
 211226305,
 78197,
 211422363,
 211225802,
 78193,
 -1,
 211357377,
 78194,
 -62308,
 211357322,
 78201,
 -62307,
 211488342,
 78200,
 -62306,
 211553815,
 78199,
 -62305,
 211619293,
 78198,
 -62304,
 211684658,
 78195,
 -62303,
 211749939,
 78192,
 -62302,
 211815331,
 78191,
 -1,
 211880736,
 78190,
 212077744,
 211160266,
 -1,
 212143270,
 212012567,
 78186,
 -1,
 212078273,
 78187,
 212274344,
 212078045,
 78184,
 -1,
 212209345,
 78185,
 -62295,
 212209290,
 78189,
 -62294,
 212340310,
 78188,
 -62293,
 212405616,
 78183,
 -62292,
 212471090,
 78182,
 -62291,
 212536522,
 78181,
 -62290,
 212601907,
 78180,
 -62289,
 212667299,
 78179,
 -1,
 212732704,
 78178,
 212929725,
 212012083,
 -1,
 212995251,
 212864477,
 78173,
 -1,
 212930241,
 78174,
 213126325,
 212929312,
 78166,
 -1,
 213061313,
 78167,
 -62282,
 213061258,
 78177,
 -62281,
 213192278,
 78176,
 -62280,
 213257751,
 78175,
 -62279,
 213323120,
 78172,
 -62278,
 213388594,
 78171,
 -62277,
 213454026,
 78170,
 -62276,
 213519411,
 78169,
 -1,
 213584803,
 78168,
 213781706,
 212863776,
 -1,
 213847233,
 213716503,
 78150,
 -62272,
 213784565,
 78152,
 -1,
 213847745,
 78151,
 214043843,
 213781981,
 78148,
 -1,
 213978817,
 78149,
 -62268,
 213978762,
 78154,
 -62267,
 214109782,
 78153,
 -62266,
 214175088,
 78147,
 -62265,
 214240562,
 78146,
 -62264,
 214305994,
 78145,
 -62263,
 214371379,
 78144,
 -1,
 214436771,
 78143,
 214633686,
 213715875,
 -1,
 214699213,
 214567843,
 78156,
 -1,
 214634177,
 78157,
 -62258,
 214634122,
 78165,
 -62257,
 214765142,
 78164,
 -62256,
 214830615,
 78163,
 -62255,
 214896093,
 78162,
 -62254,
 214961520,
 78161,
 -62253,
 215026994,
 78160,
 -62252,
 215092426,
 78159,
 -62251,
 215157811,
 78158,
 -1,
 215223072,
 78155,
 215482367,
 214568304,
 -1,
 -62248,
 215354674,
 78206,
 -62247,
 215420106,
 78205,
 -62246,
 215485491,
 78204,
 -62245,
 215550883,
 78203,
 -1,
 215616288,
 78202,
 215813400,
 211121631,
 -1,
 215878891,
 215747491,
 -1,
 215944417,
 215813426,
 78560,
 -62240,
 215881717,
 78562,
 -1,
 215944897,
 78561,
 216141027,
 215879191,
 78565,
 -1,
 216075969,
 78566,
 -62236,
 216075914,
 78568,
 -62235,
 216206934,
 78567,
 -62234,
 216272349,
 78564,
 -62233,
 216337776,
 78563,
 -62232,
 216403146,
 78559,
 -62231,
 216468531,
 78558,
 -62230,
 216533923,
 78557,
 -1,
 216599328,
 78556,
 216796408,
 215813171,
 -1,
 216861935,
 216731101,
 78575,
 -62226,
 216799221,
 78577,
 -1,
 216862401,
 78576,
 -62224,
 216796810,
 78580,
 -62223,
 216993366,
 78579,
 -62222,
 217058839,
 78578,
 -62221,
 217124208,
 78574,
 -62220,
 217189682,
 78573,
 -62219,
 217255114,
 78572,
 -62218,
 217320499,
 78571,
 -62217,
 217385891,
 78570,
 -1,
 217451296,
 78569,
 217648388,
 216730826,
 -1,
 217713915,
 217582960,
 78586,
 -1,
 217648833,
 78587,
 -62212,
 217648778,
 78591,
 -62211,
 217779798,
 78590,
 -62210,
 217845271,
 78589,
 -62209,
 217910749,
 78588,
 -62208,
 217976114,
 78585,
 -62207,
 218041546,
 78584,
 -62206,
 218106931,
 78583,
 -62205,
 218172323,
 78582,
 -1,
 218237728,
 78581,
 218434832,
 217582368,
 -1,
 218500359,
 218369501,
 78551,
 -1,
 218435265,
 78552,
 218631433,
 218434611,
 78546,
 -1,
 218566337,
 78547,
 -62198,
 218566282,
 78555,
 -62197,
 218697302,
 78554,
 -62196,
 218762775,
 78553,
 -62195,
 218828144,
 78550,
 -62194,
 218893618,
 78549,
 -62193,
 218959050,
 78548,
 -1,
 219024291,
 78545,
 219283455,
 218369330,
 -1,
 -62190,
 219155933,
 78598,
 -62189,
 219221360,
 78597,
 -62188,
 219286834,
 78596,
 -62187,
 219352266,
 78595,
 -62186,
 219417651,
 78594,
 -62185,
 219483043,
 78593,
 -1,
 219548448,
 78592,
 219745613,
 215778984,
 -1,
 219811110,
 219679795,
 -1,
 219876636,
 219745930,
 78674,
 -1,
 219811521,
 78675,
 220007710,
 219811018,
 78667,
 -1,
 219942593,
 78668,
 -62177,
 219942486,
 78673,
 -62176,
 220073495,
 78672,
 -62175,
 220138973,
 78671,
 -62174,
 220204400,
 78670,
 -62173,
 220269874,
 78669,
 -62172,
 220335155,
 78666,
 -62171,
 220400547,
 78665,
 -1,
 220465952,
 78664,
 220663090,
 219745482,
 -1,
 220728617,
 220597299,
 78678,
 -1,
 220663489,
 78679,
 -62166,
 220663434,
 78686,
 -62165,
 220794454,
 78685,
 -62164,
 220859927,
 78684,
 -62163,
 220925405,
 78683,
 -62162,
 220990832,
 78682,
 -62161,
 221056306,
 78681,
 -62160,
 221121738,
 78680,
 -62159,
 221186979,
 78677,
 -1,
 221252384,
 78676,
 221449534,
 220597024,
 -1,
 221515062,
 221384157,
 78648,
 -62155,
 221452277,
 78650,
 -1,
 221515457,
 78649,
 -62153,
 221449866,
 78653,
 -62152,
 221646422,
 78652,
 -62151,
 221711895,
 78651,
 -62150,
 221777264,
 78647,
 -62149,
 221842738,
 78646,
 -62148,
 221908170,
 78645,
 -62147,
 221973555,
 78644,
 -1,
 222038947,
 78643,
 222235977,
 221383587,
 -1,
 -62144,
 222170762,
 78663,
 -62143,
 222236246,
 78662,
 -62142,
 222301719,
 78661,
 -62141,
 222367197,
 78660,
 -62140,
 222432624,
 78659,
 -62139,
 222498098,
 78658,
 -62138,
 222563530,
 78657,
 -62137,
 222628915,
 78656,
 -62136,
 222694307,
 78655,
 -1,
 222759712,
 78654,
 223019007,
 222170418,
 -1,
 -62133,
 222891059,
 78689,
 -62132,
 222956451,
 78688,
 -1,
 223021856,
 78687,
 223219070,
 219709100,
 -1,
 223284572,
 223152928,
 -1,
 223350097,
 223219338,
 78610,
 -1,
 223284929,
 78611,
 223481171,
 223284822,
 78608,
 -1,
 223416001,
 78609,
 223612245,
 223415831,
 78606,
 -1,
 223547073,
 78607,
 223743319,
 223546570,
 78601,
 -1,
 223678145,
 78602,
 -62120,
 223677917,
 78605,
 -62119,
 223808880,
 78604,
 -62118,
 223874354,
 78603,
 -62117,
 223939635,
 78600,
 -1,
 224005027,
 78599,
 224202089,
 223218595,
 -1,
 224267615,
 224136669,
 78619,
 -1,
 224202433,
 78620,
 224398689,
 224201635,
 78613,
 -1,
 224333505,
 78614,
 -62110,
 224333450,
 78623,
 -62109,
 224464470,
 78622,
 -62108,
 224529943,
 78621,
 -62107,
 224595312,
 78618,
 -62106,
 224660786,
 78617,
 -62105,
 224726218,
 78616,
 -62104,
 224791603,
 78615,
 -1,
 224856864,
 78612,
 225054068,
 224136243,
 -1,
 -62101,
 224988810,
 78633,
 -62100,
 225054294,
 78632,
 -62099,
 225119767,
 78631,
 -62098,
 225185245,
 78630,
 -62097,
 225250672,
 78629,
 -62096,
 225316146,
 78628,
 -62095,
 225381578,
 78627,
 -62094,
 225446963,
 78626,
 -62093,
 225512355,
 78625,
 -1,
 225577760,
 78624,
 225837055,
 224988362,
 -1,
 225840503,
 225709258,
 78638,
 -1,
 225775297,
 78639,
 225971577,
 225774643,
 78636,
 -1,
 225906369,
 78637,
 -62086,
 225906141,
 78642,
 -62085,
 226037104,
 78641,
 -62084,
 226102578,
 78640,
 -62083,
 226167715,
 78635,
 -1,
 226233120,
 78634,
 226430383,
 223160677,
 -1,
 226495884,
 226364467,
 -1,
 226561410,
 226430550,
 78066,
 -1,
 226496193,
 78067,
 226692484,
 226495264,
 78057,
 -1,
 226627265,
 78058,
 -62075,
 226627210,
 78068,
 -62074,
 226758167,
 78065,
 -62073,
 226823645,
 78064,
 -62072,
 226889072,
 78063,
 -62071,
 226954546,
 78062,
 -62070,
 227019978,
 78061,
 -62069,
 227085363,
 78060,
 -1,
 227150755,
 78059,
 227347865,
 226429859,
 -1,
 227413391,
 227282455,
 78053,
 -1,
 227348161,
 78054,
 227544465,
 227347933,
 78051,
 -1,
 227479233,
 78052,
 -62062,
 227479178,
 78056,
 -62061,
 227610198,
 78055,
 -62060,
 227675504,
 78050,
 -62059,
 227740978,
 78049,
 -62058,
 227806410,
 78048,
 -62057,
 227871795,
 78047,
 -62056,
 227937187,
 78046,
 -1,
 228002592,
 78045,
 228199845,
 227281696,
 -1,
 228265372,
 228134538,
 78043,
 -1,
 228200129,
 78044,
 228396446,
 228200022,
 78041,
 -1,
 228331201,
 78042,
 -62049,
 228331031,
 78040,
 -62048,
 228462045,
 78039,
 -62047,
 228527472,
 78038,
 -62046,
 228592946,
 78037,
 -62045,
 228658378,
 78036,
 -62044,
 228723763,
 78035,
 -1,
 228789155,
 78034,
 229048319,
 228134090,
 -1,
 229051816,
 228920626,
 78073,
 -1,
 228986561,
 78074,
 -62039,
 228986454,
 78077,
 -62038,
 229117463,
 78076,
 -62037,
 229182941,
 78075,
 -62036,
 229248202,
 78072,
 -62035,
 229313587,
 78071,
 -62034,
 229378979,
 78070,
 -1,
 229444384,
 78069,
 229641691,
 226399805,
 -1,
 229707209,
 229575587,
 -1,
 229772731,
 229641584,
 78842,
 -62029,
 229719647,
 78851,
 -62028,
 229783707,
 78850,
 -62027,
 229848266,
 78849,
 -62026,
 229912919,
 78848,
 -62025,
 229976187,
 78847,
 -62024,
 230040270,
 78846,
 -62023,
 230104006,
 78845,
 -62022,
 230168565,
 78844,
 -1,
 230231745,
 78843,
 230428100,
 229707229,
 78852,
 -62019,
 230373531,
 78860,
 -62018,
 230438090,
 78859,
 -62017,
 230502743,
 78858,
 -62016,
 230566011,
 78857,
 -62015,
 230630094,
 78856,
 -62014,
 230693830,
 78855,
 -62013,
 230758389,
 78854,
 -1,
 230821569,
 78853,
 -62011,
 230362418,
 78841,
 -62010,
 230952138,
 78840,
 -62009,
 231017523,
 78839,
 -62008,
 231082915,
 78838,
 -1,
 231148320,
 78837,
 231407615,
 229640992,
 -1,
 231411151,
 231279667,
 78821,
 -62004,
 231350990,
 78825,
 -62003,
 231414726,
 78824,
 -62002,
 231479285,
 78823,
 -1,
 231542465,
 78822,
 231738834,
 231345354,
 78826,
 -61999,
 231675893,
 78828,
 -1,
 231739073,
 78827,
 231935444,
 231673200,
 78831,
 -1,
 231870145,
 78832,
 232066518,
 231869746,
 78829,
 -1,
 232001217,
 78830,
 -61993,
 232001162,
 78836,
 -61992,
 232132182,
 78835,
 -61991,
 232197655,
 78834,
 -61990,
 232263133,
 78833,
 -1,
 232328099,
 78820,
 232525313,
 229600692,
 -1,
 232590825,
 232459171,
 -1,
 232656351,
 232525277,
 78530,
 -1,
 232591041,
 78531,
 232787425,
 232590112,
 78523,
 -1,
 232722113,
 78524,
 -61982,
 232722058,
 78534,
 -61981,
 232853078,
 78533,
 -61980,
 232918551,
 78532,
 -61979,
 232983920,
 78529,
 -61978,
 233049394,
 78528,
 -61977,
 233114826,
 78527,
 -61976,
 233180211,
 78526,
 -1,
 233245603,
 78525,
 233442806,
 232524576,
 -1,
 233508333,
 233376970,
 78514,
 -61972,
 233445365,
 78516,
 -1,
 233508545,
 78515,
 233704943,
 233442355,
 78512,
 -1,
 233639617,
 78513,
 -61968,
 233639562,
 78522,
 -61967,
 233770582,
 78521,
 -61966,
 233836055,
 78520,
 -61965,
 233901533,
 78519,
 -61964,
 233966960,
 78518,
 -61963,
 234032434,
 78517,
 -1,
 234097571,
 78511,
 234356735,
 233376819,
 -1,
 -61960,
 234229386,
 78544,
 -61959,
 234294870,
 78543,
 -61958,
 234360343,
 78542,
 -61957,
 234425821,
 78541,
 -61956,
 234491248,
 78540,
 -61955,
 234556722,
 78539,
 -61954,
 234622154,
 78538,
 -61953,
 234687539,
 78537,
 -61952,
 234752931,
 78536,
 -1,
 234818336,
 78535,
 235015717,
 232492976,
 -1,
 235081233,
 234949539,
 -1,
 235146757,
 235015766,
 78789,
 -1,
 235081409,
 78790,
 235277831,
 235081239,
 78787,
 -1,
 235212481,
 78788,
 235408905,
 235212082,
 78783,
 -1,
 235343553,
 78784,
 235539979,
 235342624,
 78778,
 -1,
 235474625,
 78779,
 -61940,
 235474570,
 78791,
 -61939,
 235605469,
 78786,
 -61938,
 235670896,
 78785,
 -61937,
 235736266,
 78782,
 -61936,
 235801651,
 78781,
 -1,
 235867043,
 78780,
 236064285,
 235014944,
 -1,
 236129812,
 235998858,
 78776,
 -1,
 236064449,
 78777,
 236260886,
 236063946,
 78769,
 -1,
 236195521,
 78770,
 -61929,
 236195414,
 78775,
 -61928,
 236326423,
 78774,
 -61927,
 236391901,
 78773,
 -61926,
 236457328,
 78772,
 -61925,
 236522802,
 78771,
 -61924,
 236588083,
 78768,
 -1,
 236653475,
 78767,
 236912639,
 235998259,
 -1,
 236916256,
 236784946,
 78796,
 -1,
 236850881,
 78797,
 -61919,
 236850544,
 78798,
 -61918,
 236981450,
 78795,
 -61917,
 237046835,
 78794,
 -61916,
 237112227,
 78793,
 -1,
 237177632,
 78792,
 237375045,
 234953695,
 -1,
 237440563,
 237308704,
 -1,
 237506091,
 237374515,
 77915,
 -61911,
 237444038,
 77918,
 -61910,
 237508597,
 77917,
 -1,
 237571777,
 77916,
 -61908,
 237440650,
 77925,
 -61907,
 237702742,
 77924,
 -61906,
 237768215,
 77923,
 -61905,
 237833693,
 77922,
 -61904,
 237899120,
 77921,
 -61903,
 237964594,
 77920,
 -61902,
 238030026,
 77919,
 -1,
 238095267,
 77914,
 238292543,
 237374371,
 -1,
 238358070,
 238226208,
 77926,
 -1,
 238292673,
 77927,
 -61897,
 238292618,
 77936,
 -61896,
 238423638,
 77935,
 -61895,
 238489111,
 77934,
 -61894,
 238554589,
 77933,
 -61893,
 238620016,
 77932,
 -61892,
 238685490,
 77931,
 -61891,
 238750922,
 77930,
 -61890,
 238816307,
 77929,
 -1,
 238881699,
 77928,
 239140863,
 238226483,
 -1,
 -61887,
 239013170,
 77941,
 -61886,
 239078602,
 77940,
 -61885,
 239143987,
 77939,
 -61884,
 239209379,
 77938,
 -1,
 239274784,
 77937,
 239472219,
 237321911,
 -1,
 239537746,
 239405856,
 -1,
 239603273,
 239472266,
 78225,
 -1,
 239537857,
 78226,
 239734347,
 239537520,
 78220,
 -1,
 239668929,
 78221,
 -61876,
 239668822,
 78224,
 -61875,
 239799831,
 78223,
 -61874,
 239865309,
 78222,
 -61873,
 239930674,
 78219,
 -61872,
 239996106,
 78218,
 -61871,
 240061491,
 78217,
 -1,
 240126883,
 78216,
 240386047,
 239471523,
 -1,
 240389717,
 240257955,
 78229,
 -1,
 240324289,
 78230,
 240520791,
 240323360,
 78227,
 -1,
 240455361,
 78228,
 -61864,
 240455024,
 78234,
 -61863,
 240586034,
 78233,
 -61862,
 240651466,
 78232,
 -1,
 240716851,
 78231,
 240914027,
 239429439,
 -1,
 240979560,
 240847648,
 -1,
 241045087,
 240913610,
 78494,
 -1,
 240979649,
 78495,
 241176161,
 240978851,
 78491,
 -1,
 241110721,
 78492,
 -61854,
 241110666,
 78501,
 -61853,
 241241686,
 78500,
 -61852,
 241307159,
 78499,
 -61851,
 241372637,
 78498,
 -61850,
 241438064,
 78497,
 -61849,
 241503538,
 78496,
 -1,
 241568819,
 78493,
 241827839,
 240913315,
 -1,
 -61846,
 241699747,
 78503,
 -1,
 241765152,
 78502,
 241962616,
 240882662,
 -1,
 242028143,
 241896754,
 78802,
 -61842,
 241965045,
 78804,
 -1,
 242028225,
 78803,
 242224753,
 241962582,
 78809,
 -1,
 242159297,
 78810,
 242355827,
 242159069,
 78806,
 -1,
 242290369,
 78807,
 -61836,
 242290199,
 78808,
 -61835,
 242421104,
 78805,
 -61834,
 242486474,
 78801,
 -61833,
 242551859,
 78800,
 -1,
 242617251,
 78799,
 242814595,
 241912689,
 -1,
 242880123,
 242748893,
 78249,
 -1,
 242814657,
 78250,
 243011197,
 242814003,
 78244,
 -1,
 242945729,
 78245,
 -61826,
 242945622,
 78252,
 -61825,
 243076631,
 78251,
 -61824,
 243142000,
 78248,
 -61823,
 243207474,
 78247,
 -61822,
 243272906,
 78246,
 -1,
 243338147,
 78243,
 243535502,
 242751495,
 -1,
 243601030,
 243469680,
 77908,
 -1,
 243535553,
 77909,
 -61817,
 243535498,
 77913,
 -61816,
 243666518,
 77912,
 -61815,
 243731991,
 77911,
 -61814,
 243797469,
 77910,
 -61813,
 243862834,
 77907,
 -61812,
 243928266,
 77906,
 -61811,
 243993651,
 77905,
 -1,
 244059043,
 77904,
 244256408,
 243504273,
 -1,
 244321937,
 244190115,
 78811,
 -1,
 244256449,
 78812,
 -61806,
 244256342,
 78819,
 -61805,
 244387351,
 78818,
 -61804,
 244452829,
 78817,
 -61803,
 244518256,
 78816,
 -61802,
 244583730,
 78815,
 -61801,
 244649162,
 78814,
 -1,
 244714547,
 78813,
 244911778,
 244201645,
 -1,
 244977307,
 244846045,
 78212,
 -1,
 244911809,
 78213,
 -61796,
 244911702,
 78215,
 -61795,
 245042711,
 78214,
 -61794,
 245108080,
 78211,
 -61793,
 245173554,
 78210,
 -61792,
 245238986,
 78209,
 -61791,
 245304371,
 78208,
 -1,
 245369763,
 78207,
 245567147,
 244861043,
 -1,
 -61788,
 245501526,
 78242,
 -61787,
 245566999,
 78241,
 -61786,
 245632477,
 78240,
 -61785,
 245697904,
 78239,
 -61784,
 245763378,
 78238,
 -61783,
 245828810,
 78237,
 -61782,
 245894195,
 78236,
 -1,
 245959587,
 78235,
 246218751,
 245525553,
 -1,
 -61779,
 246091287,
 78510,
 -61778,
 246156765,
 78509,
 -61777,
 246222192,
 78508,
 -61776,
 246287666,
 78507,
 -61775,
 246353098,
 78506,
 -61774,
 246418483,
 78505,
 -1,
 246483875,
 78504,
 246681461,
 168656441,
 -1,
 246746995,
 246627285,
 -1,
 246812513,
 246707598,
 -1,
 246878048,
 246781314,
 -1,
 246943442,
 246815686,
 -1,
 247008976,
 246881222,
 -1,
 247074505,
 246954139,
 -1,
 247140034,
 247019675,
 -1,
 247205565,
 247081083,
 43813,
 -1,
 247146619,
 43812,
 247336639,
 247140033,
 43808,
 -1,
 247271105,
 43811,
 -61760,
 247301707,
 43809,
 -61759,
 247422183,
 43814,
 -1,
 247479903,
 43810,
 247664324,
 247081083,
 11709,
 -1,
 247605371,
 11708,
 247795398,
 247598785,
 11704,
 -1,
 247729857,
 11707,
 -61753,
 247760459,
 11705,
 -61752,
 247880935,
 11710,
 -1,
 247938655,
 11706,
 248123083,
 247015547,
 11693,
 -1,
 248064123,
 11692,
 248254157,
 248057537,
 11688,
 -1,
 248188609,
 11691,
 -61746,
 248219211,
 11689,
 -61745,
 248339687,
 11694,
 -1,
 248397407,
 11690,
 -61743,
 246963478,
 11655,
 -1,
 248527966,
 11664,
 248712931,
 246887626,
 -1,
 248778459,
 248681555,
 -1,
 248843990,
 248719483,
 11741,
 -1,
 248785019,
 11740,
 248975064,
 248778433,
 11736,
 -1,
 248909505,
 11739,
 -61735,
 248940107,
 11737,
 -61734,
 249060583,
 11742,
 -1,
 249118303,
 11738,
 249302753,
 248723573,
 -1,
 249368286,
 249243771,
 11670,
 -1,
 249309307,
 11669,
 249499360,
 249302721,
 11667,
 -1,
 249433793,
 4895,
 -1,
 249445983,
 11668,
 -61726,
 249257238,
 4879,
 -1,
 249647357,
 11658,
 249827061,
 248652494,
 -1,
 249892589,
 249766606,
 -1,
 249958124,
 249837723,
 -1,
 250023656,
 249899131,
 43789,
 -1,
 249964667,
 43788,
 -61719,
 249988683,
 43785,
 -61718,
 250109159,
 43790,
 -61717,
 250166879,
 43786,
 -1,
 250220346,
 43787,
 -1,
 249912598,
 11661,
 250482420,
 249861683,
 -1,
 250547952,
 250423419,
 43797,
 -1,
 250488955,
 43796,
 -61711,
 250512971,
 43793,
 -61710,
 250633447,
 43798,
 -61709,
 250691167,
 43794,
 -1,
 250744634,
 43795,
 -1,
 250436886,
 11660,
 251006725,
 249787790,
 -1,
 251072254,
 250967438,
 -1,
 251137785,
 251013243,
 11685,
 -1,
 251078779,
 11684,
 251268859,
 251072193,
 11680,
 -1,
 251203265,
 11683,
 -61700,
 251233867,
 11681,
 -61699,
 251354343,
 11686,
 -1,
 251412063,
 11682,
 251596547,
 251013637,
 -1,
 -61696,
 251554851,
 5004,
 -61695,
 251615309,
 4992,
 -61694,
 251671750,
 5000,
 -1,
 251730862,
 4996,
 -61692,
 251550998,
 11651,
 -1,
 251870302,
 11652,
 252055315,
 250943477,
 -1,
 252120846,
 251992053,
 -1,
 252186377,
 252061819,
 43821,
 -1,
 252127355,
 43820,
 252317451,
 252120769,
 43816,
 -1,
 252251841,
 43819,
 -61684,
 252282443,
 43817,
 -61683,
 252402919,
 43822,
 -1,
 252460639,
 43818,
 252645138,
 252088172,
 -1,
 252710673,
 252586107,
 4999,
 -1,
 252651643,
 4998,
 -1,
 252657247,
 4997,
 -1,
 252599574,
 11653,
 252972830,
 252018233,
 -1,
 253038363,
 252936405,
 -1,
 253103895,
 252979323,
 43781,
 -1,
 253044859,
 43780,
 -61672,
 253068875,
 43777,
 -61671,
 253189351,
 43782,
 -61670,
 253247071,
 43778,
 -1,
 253300538,
 43779,
 -61668,
 253007697,
 4935,
 -61667,
 253451542,
 11654,
 -1,
 253508702,
 11663,
 253693736,
 252941875,
 -1,
 253759271,
 253662771,
 -1,
 253824802,
 253700219,
 11701,
 -1,
 253765755,
 11700,
 253955876,
 253759169,
 11696,
 -1,
 253890241,
 11699,
 -61659,
 253920843,
 11697,
 -61658,
 254041319,
 11702,
 -1,
 254099039,
 11698,
 -1,
 253713686,
 11659,
 254349106,
 253662111,
 -1,
 254414641,
 254317651,
 -1,
 254480172,
 254355579,
 11733,
 -1,
 254421115,
 11732,
 254611246,
 254414529,
 11728,
 -1,
 254545601,
 11731,
 -61649,
 254576203,
 11729,
 -61648,
 254696679,
 11734,
 -1,
 254754399,
 11730,
 -1,
 254369046,
 4743,
 255004476,
 254307367,
 -1,
 255070011,
 254973011,
 -1,
 255135542,
 255010939,
 11717,
 -1,
 255076475,
 11716,
 255266616,
 255069889,
 11712,
 -1,
 255200961,
 11715,
 -61639,
 255231563,
 11713,
 -61638,
 255352039,
 11718,
 -1,
 255409759,
 11714,
 -1,
 255024406,
 4679,
 255659846,
 254953526,
 -1,
 255725381,
 255628371,
 -1,
 255790912,
 255666299,
 11725,
 -1,
 255731835,
 11724,
 255921986,
 255725249,
 11720,
 -1,
 255856321,
 11723,
 -61629,
 255886923,
 11721,
 -61628,
 256007399,
 11726,
 -1,
 256065119,
 11722,
 -1,
 255679766,
 4783,
 256315213,
 255616771,
 -1,
 256380747,
 256282476,
 -1,
 256446282,
 256321659,
 5007,
 -1,
 256387195,
 5006,
 -1,
 256392799,
 5005,
 -61620,
 256335126,
 11666,
 -1,
 256588894,
 11665,
 256773971,
 256266788,
 -1,
 256839506,
 256741228,
 -1,
 256905041,
 256780411,
 4995,
 -1,
 256845947,
 4994,
 -1,
 256851551,
 4993,
 -1,
 256793878,
 11649,
 257167191,
 256718019,
 -1,
 257232726,
 257108091,
 5003,
 -1,
 257173627,
 5002,
 -1,
 257179231,
 5001,
 257429338,
 257120365,
 -1,
 -61607,
 257398209,
 11657,
 -1,
 257449238,
 11656,
 -61605,
 257398209,
 4847,
 -61604,
 257594142,
 4815,
 -61603,
 257651704,
 11650,
 -61602,
 257708137,
 11648,
 -61601,
 257771503,
 11662,
 -1,
 257834078,
 4615,
 -1,
 246819359,
 4960,
 258084718,
 246776579,
 -1,
 258150246,
 258024142,
 -1,
 258215781,
 258092475,
 5009,
 -1,
 258148931,
 5016,
 -1,
 258162782,
 5012,
 258412393,
 258099254,
 -1,
 -61592,
 258378555,
 5017,
 -1,
 258419789,
 5013,
 -61590,
 258381180,
 5008,
 -61589,
 258570327,
 5011,
 -61588,
 258634458,
 5010,
 -61587,
 258685693,
 5015,
 -1,
 258743874,
 5014,
 258998271,
 258023469,
 -1,
 259002226,
 258881067,
 -1,
 -61583,
 258954228,
 4959,
 -1,
 259003252,
 4957,
 -1,
 258969305,
 4958,
 -61580,
 246715295,
 983047,
 -1,
 259201013,
 983096,
 259395461,
 246634605,
 -1,
 259460994,
 259334864,
 -1,
 259526529,
 259415537,
 -1,
 259592060,
 259489337,
 -1,
 259657595,
 259550940,
 983048,
 -1,
 259588311,
 983095,
 -1,
 259600524,
 983046,
 -61571,
 259552963,
 983134,
 -61570,
 259812212,
 983178,
 -61569,
 259872043,
 983099,
 -61568,
 259936073,
 983064,
 -1,
 259995727,
 983177,
 -1,
 259494340,
 128282,
 260247428,
 259419175,
 983051,
 -1,
 260212793,
 983050,
 -1,
 260213973,
 128233,
 260444048,
 259331288,
 128066,
 260509581,
 260407512,
 -1,
 260575116,
 260460653,
 -1,
 260640651,
 260509377,
 -1,
 -61558,
 260601975,
 127759,
 -1,
 260658641,
 127758,
 -1,
 260583263,
 127757,
 -1,
 260535418,
 9178,
 261029887,
 260440951,
 -1,
 -61553,
 260927878,
 127806,
 -1,
 260985597,
 127805,
 261164952,
 260394230,
 -1,
 261230487,
 261104183,
 -1,
 261296022,
 261160960,
 -1,
 -61548,
 261260125,
 128294,
 -61547,
 261319116,
 128268,
 -1,
 261377843,
 128161,
 -1,
 261231150,
 9191,
 -1,
 261187832,
 128024,
 261689244,
 261125518,
 -1,
 261754779,
 261626822,
 983104,
 -1,
 261690485,
 983103,
 -1,
 261689025,
 983135,
 261951392,
 261643495,
 -1,
 -61538,
 261914169,
 983049,
 -61537,
 261968420,
 983100,
 -1,
 262032202,
 983067,
 262213539,
 261919993,
 -1,
 -61534,
 262174094,
 128064,
 -1,
 262223723,
 128083,
 262410150,
 262181791,
 -1,
 -61531,
 262374364,
 128125,
 -1,
 262433596,
 128529,
 262606761,
 262376242,
 -1,
 -61528,
 262564518,
 127972,
 -1,
 262610142,
 127984,
 -61526,
 262573351,
 127794,
 -61525,
 262761619,
 11072,
 -61524,
 262825794,
 983179,
 -61523,
 262883187,
 9167,
 -61522,
 262939989,
 11790,
 -1,
 262998629,
 128231,
 263198094,
 168564725,
 -1,
 263263323,
 263130817,
 -1,
 263328599,
 263215081,
 -1,
 263394124,
 263278161,
 -1,
 263459566,
 263350019,
 -1,
 263525094,
 263404025,
 -1,
 263590036,
 263465085,
 -1,
 263655410,
 263542893,
 -1,
 263720913,
 263599306,
 -1,
 263786433,
 263669814,
 -1,
 263851964,
 263751243,
 -1,
 -61509,
 263808771,
 92598,
 -1,
 263868964,
 92619,
 264048575,
 263794407,
 -1,
 -61506,
 264016799,
 92543,
 -1,
 264048783,
 92553,
 264306687,
 263982785,
 92531,
 -1,
 264180486,
 92601,
 264376266,
 263730378,
 -1,
 264441798,
 264341067,
 -1,
 -61500,
 264400385,
 92550,
 -61499,
 264464131,
 92624,
 -1,
 264507603,
 92563,
 264765439,
 264382587,
 -1,
 264769481,
 264668863,
 92607,
 -1,
 264732217,
 92535,
 -1,
 264710775,
 92557,
 264966092,
 264341183,
 92640,
 -1,
 264928825,
 92657,
 265097167,
 264920295,
 -1,
 -61490,
 265055271,
 92544,
 -1,
 265119491,
 92541,
 -61488,
 265039689,
 92579,
 -1,
 265227969,
 92658,
 265424859,
 263660238,
 -1,
 265490391,
 265359041,
 -1,
 265555926,
 265424579,
 -1,
 -61483,
 265517746,
 92562,
 -1,
 265574487,
 92637,
 -1,
 265512707,
 92518,
 265818074,
 265436767,
 -1,
 -61479,
 265776167,
 92558,
 -1,
 265819349,
 92592,
 -1,
 265783538,
 92528,
 266080225,
 265373488,
 -1,
 266145760,
 266020987,
 -1,
 266211295,
 266086523,
 92628,
 -1,
 266142128,
 92648,
 -1,
 266177486,
 92547,
 -1,
 266080409,
 92554,
 266473446,
 266041125,
 -1,
 266538981,
 266438219,
 -1,
 -61468,
 266494287,
 92527,
 -1,
 266545275,
 92545,
 -1,
 266485788,
 92540,
 266801129,
 266442291,
 -1,
 -61464,
 266767028,
 92609,
 -1,
 266802389,
 92583,
 266997740,
 266769756,
 -1,
 -61461,
 266936192,
 92589,
 -1,
 267000203,
 92608,
 267194351,
 266960441,
 -1,
 -61458,
 267159721,
 92604,
 -1,
 267195497,
 92622,
 267390961,
 267128513,
 92662,
 -1,
 267331707,
 92613,
 -1,
 267340463,
 92584,
 267587594,
 263612163,
 -1,
 267653113,
 267552331,
 92576,
 267718647,
 267587265,
 -1,
 -61450,
 267676711,
 92618,
 -1,
 267724923,
 92529,
 -61448,
 267670052,
 92561,
 -1,
 267855995,
 92649,
 268046335,
 267587265,
 -1,
 268111868,
 267980481,
 92524,
 -1,
 268063268,
 92536,
 268304383,
 268043462,
 -1,
 -61442,
 268194306,
 92634,
 -1,
 268250387,
 92625,
 268439555,
 267992671,
 92663,
 268566527,
 268380283,
 -1,
 -61438,
 268467769,
 92621,
 -1,
 268512606,
 92593,
 268701704,
 268380283,
 -1,
 268767239,
 268666443,
 -1,
 -61434,
 268735391,
 92647,
 -1,
 268795449,
 92605,
 -1,
 268708813,
 92548,
 269090815,
 268655847,
 92568,
 -1,
 268984206,
 92610,
 269160477,
 267538980,
 -1,
 269226000,
 269094593,
 92667,
 269291534,
 269166715,
 92600,
 -1,
 269242916,
 92542,
 -61425,
 269249575,
 92668,
 -1,
 269379331,
 92555,
 269553682,
 269172319,
 92654,
 -1,
 269494900,
 92611,
 269684757,
 269497786,
 -1,
 -61420,
 269626365,
 92581,
 -1,
 269684417,
 92551,
 269881368,
 269621511,
 -1,
 -61417,
 269846697,
 92520,
 -1,
 269887611,
 92582,
 -61415,
 269848052,
 92617,
 -61414,
 270042815,
 92614,
 -61413,
 270098318,
 92671,
 -61412,
 270152273,
 92591,
 -1,
 270216189,
 92666,
 270405680,
 269123129,
 -1,
 270471204,
 270339777,
 -1,
 270536737,
 270405313,
 92635,
 -1,
 270494759,
 92577,
 -61406,
 270494759,
 92636,
 -61405,
 270619172,
 92530,
 -1,
 270674973,
 92559,
 270864424,
 270435915,
 -1,
 270929959,
 270815780,
 92586,
 -1,
 270864512,
 92569,
 -1,
 270864512,
 92566,
 271126572,
 270818535,
 -1,
 271192107,
 271080679,
 92537,
 -1,
 271145069,
 92519,
 -1,
 271150119,
 92630,
 271450111,
 271067259,
 -1,
 271454255,
 271353419,
 92669,
 -1,
 271388861,
 92572,
 -1,
 271407213,
 92672,
 271650882,
 270373971,
 -1,
 271716406,
 271615563,
 -1,
 -61389,
 271674407,
 92644,
 -61388,
 271734893,
 92645,
 -61387,
 271789406,
 92594,
 -1,
 271847590,
 92641,
 272044091,
 271658727,
 -1,
 272109625,
 271978624,
 92567,
 -1,
 272072249,
 92623,
 -61382,
 272077727,
 92639,
 -1,
 272192036,
 92606,
 272371774,
 271999564,
 -1,
 -61379,
 272334272,
 92642,
 -1,
 272376072,
 92643,
 272568385,
 272318047,
 -1,
 -61376,
 272531001,
 92590,
 -1,
 272575092,
 92564,
 -1,
 272503913,
 92588,
 272830542,
 271611278,
 -1,
 272896072,
 272775323,
 -1,
 272961606,
 272850151,
 92659,
 -1,
 272919591,
 92660,
 -61369,
 272909576,
 92638,
 -1,
 273035021,
 92580,
 273223755,
 272836731,
 -1,
 -61366,
 273186361,
 92560,
 -1,
 273229947,
 92534,
 -61364,
 273188552,
 92571,
 -61363,
 273375058,
 92525,
 -1,
 273420090,
 92549,
 273616987,
 272780106,
 -1,
 273682517,
 273571047,
 -1,
 273748051,
 273636583,
 -1,
 -61358,
 273710649,
 92556,
 -1,
 273766509,
 92523,
 -61356,
 273706023,
 92664,
 -1,
 273895972,
 92539,
 274075737,
 273616577,
 -1,
 -61353,
 274033703,
 92633,
 -61352,
 274097923,
 92521,
 -1,
 274141942,
 92575,
 -61350,
 274040395,
 92653,
 -1,
 274280186,
 92595,
 274468968,
 273565750,
 -1,
 274534496,
 274433611,
 -1,
 -61346,
 274497081,
 92620,
 -61345,
 274555215,
 92538,
 -1,
 274607741,
 92587,
 274796645,
 274475131,
 -1,
 274862180,
 274761291,
 -1,
 -61341,
 274830239,
 92646,
 -1,
 274862208,
 92570,
 -1,
 274824761,
 92599,
 -61338,
 274753772,
 92532,
 -61337,
 275078375,
 92665,
 -1,
 275136095,
 92670,
 275320948,
 274411863,
 -1,
 275386480,
 275285579,
 -1,
 275452014,
 275316736,
 -1,
 -61332,
 275411053,
 92661,
 -61331,
 275463775,
 92616,
 -1,
 275520527,
 92626,
 275775487,
 275392635,
 92596,
 -1,
 275676729,
 92612,
 275845234,
 275320513,
 92603,
 -1,
 275803175,
 92673,
 -61325,
 275799890,
 92627,
 -1,
 275917428,
 92651,
 276107393,
 275264714,
 -1,
 276172926,
 276052123,
 -1,
 276238460,
 276113531,
 -1,
 276303995,
 276203083,
 -1,
 -61319,
 276272031,
 92552,
 -61318,
 276322413,
 92565,
 -1,
 276369536,
 92615,
 -1,
 276266553,
 92602,
 -61315,
 276193106,
 92674,
 -1,
 276565829,
 92578,
 276824063,
 276109575,
 -1,
 -61312,
 276728782,
 92597,
 -1,
 276790841,
 92585,
 276959367,
 276065642,
 -1,
 277024901,
 276893377,
 -1,
 -61308,
 276982823,
 92526,
 -1,
 277031035,
 92656,
 -61306,
 276971965,
 92546,
 -1,
 277163889,
 92655,
 277352588,
 276926316,
 -1,
 277418123,
 277317195,
 -1,
 -61302,
 277372135,
 92533,
 -1,
 277424251,
 92650,
 -1,
 277360497,
 92574,
 277680273,
 277318612,
 -1,
 277745808,
 277620859,
 -1,
 -61297,
 277710527,
 92573,
 -1,
 277751931,
 92652,
 -1,
 277700434,
 92522,
 -61294,
 277634279,
 92631,
 -61293,
 277954143,
 92632,
 -1,
 278007489,
 92629,
 278204731,
 263529168,
 -1,
 278270153,
 278157421,
 -1,
 278335655,
 278213834,
 -1,
 278401183,
 278284342,
 -1,
 278466715,
 278343399,
 -1,
 -61286,
 278425936,
 92432,
 -1,
 278466749,
 92457,
 -61284,
 278435084,
 92435,
 -61283,
 278628594,
 92412,
 -61282,
 278675484,
 92476,
 -1,
 278729833,
 92414,
 278986751,
 278344906,
 -1,
 278991012,
 278859457,
 -1,
 279056547,
 278926070,
 92465,
 -1,
 278990976,
 92409,
 -1,
 279013123,
 92483,
 -61275,
 278958015,
 92467,
 -61274,
 279218626,
 92485,
 -1,
 279261041,
 92475,
 279449775,
 278284080,
 -1,
 279515306,
 279395935,
 92403,
 -1,
 279456372,
 92405,
 279646381,
 279457511,
 -1,
 -61268,
 279608889,
 92407,
 -1,
 279646351,
 92430,
 -61266,
 279611422,
 92487,
 -1,
 279778409,
 92418,
 279974071,
 279410062,
 -1,
 280039603,
 279920668,
 -1,
 -61262,
 280002105,
 92459,
 -1,
 280061699,
 92447,
 280236214,
 279984283,
 -1,
 -61259,
 280202138,
 92486,
 -1,
 280242804,
 92408,
 -1,
 280201385,
 92480,
 280498364,
 279942227,
 -1,
 -61255,
 280463359,
 92463,
 -61254,
 280510047,
 92493,
 -61253,
 280571517,
 92450,
 -1,
 280630006,
 92410,
 280826050,
 280437454,
 -1,
 280891584,
 280766587,
 -1,
 -61249,
 280857550,
 92425,
 -1,
 280897659,
 92437,
 -61247,
 280846222,
 92440,
 -1,
 281023222,
 92471,
 281219271,
 280788537,
 -1,
 281284806,
 281159803,
 -1,
 -61243,
 281249961,
 92472,
 -1,
 281290875,
 92505,
 -1,
 281250756,
 92514,
 -61240,
 281183819,
 92503,
 -1,
 281493087,
 92507,
 281678052,
 278221348,
 92497,
 281743569,
 281620823,
 -1,
 281809101,
 281697511,
 92445,
 -1,
 281761901,
 92404,
 281940176,
 281751271,
 -1,
 -61233,
 281902649,
 92424,
 -1,
 281940096,
 92458,
 -1,
 281886748,
 92466,
 282202325,
 281687482,
 -1,
 -61229,
 282156571,
 92438,
 -61228,
 282214428,
 92444,
 -1,
 282275624,
 92442,
 282464474,
 282142843,
 -1,
 282530009,
 282429003,
 -1,
 -61224,
 282492473,
 92427,
 -1,
 282548333,
 92478,
 -1,
 282471031,
 92496,
 282792158,
 282400757,
 -1,
 282857693,
 282726202,
 92448,
 -1,
 282789442,
 92515,
 -1,
 282823103,
 92401,
 283054305,
 282726081,
 -1,
 -61216,
 283004219,
 92426,
 -1,
 283061406,
 92482,
 -61214,
 283020983,
 92510,
 -61213,
 283215435,
 92499,
 -1,
 283271359,
 92441,
 283447543,
 281638286,
 -1,
 283513070,
 283392155,
 -1,
 283578603,
 283453563,
 -1,
 283644138,
 283543115,
 -1,
 -61207,
 283612063,
 92501,
 -1,
 283644032,
 92417,
 -1,
 283584635,
 92413,
 -61204,
 283543115,
 92504,
 -61203,
 283861577,
 92508,
 -1,
 283918652,
 92500,
 284102898,
 283477579,
 -1,
 -61200,
 284067403,
 92498,
 -61199,
 284108923,
 92419,
 -1,
 284168320,
 92473,
 284365045,
 284036801,
 -1,
 -61196,
 284322855,
 92516,
 -1,
 284387075,
 92423,
 -61194,
 284320602,
 92452,
 -1,
 284503821,
 92428,
 284692741,
 283396150,
 -1,
 284758271,
 284633211,
 -1,
 284823806,
 284722763,
 -1,
 -61189,
 284780291,
 92460,
 -61188,
 284844904,
 92431,
 -61187,
 284906020,
 92454,
 -1,
 284954847,
 92415,
 -1,
 284786233,
 92420,
 285217027,
 284722763,
 92489,
 -61183,
 285174823,
 92479,
 -61182,
 285237074,
 92422,
 -1,
 285300845,
 92474,
 -61180,
 285185292,
 92502,
 -1,
 285446084,
 92449,
 285610257,
 284655161,
 -1,
 285675788,
 285550715,
 -1,
 285741323,
 285640267,
 -1,
 -61175,
 285703737,
 92416,
 -61174,
 285759597,
 92481,
 -1,
 285806758,
 92451,
 -1,
 285682295,
 92456,
 286069006,
 285640267,
 92433,
 -1,
 286024538,
 92477,
 -61169,
 286024265,
 92492,
 -61168,
 286146143,
 92513,
 -1,
 286199936,
 92491,
 286396699,
 285559626,
 -1,
 286462232,
 286337147,
 -1,
 286527766,
 286426699,
 -1,
 -61163,
 286478884,
 92484,
 -1,
 286527667,
 92439,
 -61161,
 286490169,
 92464,
 -1,
 286665335,
 92495,
 -61159,
 286427305,
 92446,
 -61158,
 286810697,
 92511,
 -1,
 286867484,
 92406,
 287052068,
 286353155,
 -1,
 287117599,
 287016523,
 -1,
 -61154,
 287083418,
 92443,
 -1,
 287140903,
 92509,
 287314210,
 287058043,
 -1,
 -61151,
 287280029,
 92462,
 -1,
 287320187,
 92506,
 -61149,
 287261953,
 92461,
 -1,
 287446121,
 92469,
 287641900,
 287020115,
 -1,
 287707434,
 287606347,
 -1,
 287772969,
 287661287,
 -1,
 -61144,
 287729411,
 92470,
 -1,
 287789604,
 92468,
 -1,
 287740732,
 92453,
 -61141,
 287648765,
 92429,
 -1,
 287969439,
 92421,
 288166194,
 287599978,
 -1,
 288231728,
 288107520,
 -1,
 -61137,
 288186075,
 92490,
 -1,
 288249800,
 92512,
 -61135,
 288178492,
 92494,
 -1,
 288362639,
 92455,
 288559413,
 288132972,
 -1,
 -61132,
 288523976,
 92411,
 -1,
 288560233,
 92402,
 288756024,
 288503459,
 -1,
 -61129,
 288698101,
 92488,
 -1,
 288755514,
 92434,
 289013759,
 288698711,
 -1,
 -61126,
 288894739,
 92436,
 -1,
 288952122,
 92517,
 289149390,
 278141896,
 -1,
 289214832,
 289101933,
 -1,
 289280330,
 289158346,
 -1,
 289345861,
 289223882,
 -1,
 289411396,
 289310283,
 92362,
 -61119,
 289365902,
 92341,
 -61118,
 289428004,
 92347,
 -61117,
 289483461,
 92370,
 -1,
 289542314,
 92336,
 -1,
 289352701,
 92307,
 289804616,
 289294390,
 -1,
 -61113,
 289769478,
 92303,
 -1,
 289805525,
 92309,
 -61111,
 289759058,
 92368,
 -1,
 289936597,
 92395,
 290132306,
 289240462,
 -1,
 290197838,
 290096715,
 -1,
 -61107,
 290153329,
 92359,
 -1,
 290216045,
 92374,
 -61105,
 290152274,
 92371,
 -61104,
 290339252,
 92351,
 -61103,
 290402048,
 92325,
 -1,
 290459329,
 92350,
 290656603,
 290071246,
 -1,
 290722134,
 290598631,
 -1,
 -61099,
 290684473,
 92349,
 -1,
 290721985,
 92308,
 290918745,
 290655937,
 -1,
 -61096,
 290875139,
 92378,
 -1,
 290935332,
 92375,
 -61094,
 290873207,
 92317,
 -1,
 291061693,
 92331,
 291246435,
 290604848,
 -1,
 291311967,
 291186811,
 -1,
 -61090,
 291277774,
 92389,
 -1,
 291318391,
 92360,
 291508578,
 291245761,
 -1,
 -61087,
 291459620,
 92367,
 -1,
 291515341,
 92356,
 -1,
 291473438,
 92333,
 291770729,
 291208761,
 -1,
 291836263,
 291711099,
 -1,
 -61082,
 291801471,
 92345,
 -1,
 291854445,
 92372,
 -61080,
 291800656,
 92314,
 -1,
 291966778,
 92340,
 292163948,
 291739187,
 -1,
 -61077,
 292106020,
 92323,
 -1,
 292163265,
 92304,
 292360559,
 292097729,
 -1,
 -61074,
 292318247,
 92396,
 -1,
 292379519,
 92338,
 -1,
 292328811,
 92313,
 292622733,
 289165860,
 -1,
 292688259,
 292558837,
 -1,
 292753784,
 292628603,
 -1,
 292819318,
 292718155,
 -1,
 -61067,
 292787103,
 92385,
 -1,
 292835876,
 92315,
 -61065,
 292777473,
 92354,
 -1,
 292957049,
 92311,
 293147003,
 292699743,
 92381,
 -61062,
 293109305,
 92326,
 -1,
 293171623,
 92343,
 293343616,
 293080769,
 -1,
 293409151,
 293277379,
 -1,
 -61058,
 293366060,
 92387,
 -1,
 293411823,
 92318,
 -1,
 293362894,
 92383,
 293732351,
 293307979,
 -1,
 -61054,
 293611643,
 92324,
 -1,
 293671055,
 92364,
 293867914,
 292622017,
 -1,
 293933447,
 293808251,
 -1,
 -61050,
 293894260,
 92363,
 -1,
 293950551,
 92382,
 294191103,
 293863424,
 -1,
 -61047,
 294083462,
 92376,
 -1,
 294144468,
 92339,
 -61045,
 293832383,
 92391,
 -61044,
 294273052,
 92390,
 -1,
 294335954,
 92344,
 294523294,
 292571190,
 -1,
 294588825,
 294463611,
 -1,
 294654357,
 294553163,
 -1,
 294719891,
 294614414,
 -1,
 -61038,
 294664894,
 92319,
 -1,
 294727537,
 92384,
 -61036,
 294670884,
 92386,
 -1,
 294865162,
 92321,
 295047576,
 294606959,
 -1,
 -61033,
 294997148,
 92393,
 -1,
 295055883,
 92394,
 -1,
 295009849,
 92361,
 295309724,
 294553163,
 -1,
 -61029,
 295271993,
 92366,
 -1,
 295330140,
 92373,
 -61027,
 295266266,
 92328,
 -1,
 295440186,
 92329,
 295637413,
 294491219,
 -1,
 295702947,
 295601739,
 -1,
 -61023,
 295670588,
 92388,
 -61022,
 295719460,
 92305,
 -1,
 295764800,
 92322,
 -61020,
 295644991,
 92327,
 -1,
 295898938,
 92377,
 296096173,
 295599673,
 -1,
 296161705,
 296044007,
 -1,
 -61016,
 296126157,
 92358,
 -1,
 296161048,
 92334,
 296358316,
 296102011,
 -1,
 -61013,
 296324002,
 92346,
 -1,
 296386105,
 92400,
 -1,
 296292181,
 92332,
 296620469,
 296056206,
 -1,
 296686001,
 296564891,
 -1,
 -61008,
 296650782,
 92379,
 -1,
 296699144,
 92392,
 296882612,
 296626299,
 -1,
 -61005,
 296848334,
 92330,
 -1,
 296911056,
 92380,
 -1,
 296847065,
 92335,
 297144763,
 296569674,
 -1,
 297210297,
 297078465,
 -1,
 -61000,
 297166595,
 92342,
 -1,
 297226788,
 92357,
 -60998,
 297174603,
 92365,
 -1,
 297354504,
 92397,
 297537984,
 297101059,
 -1,
 297603519,
 297483871,
 -1,
 -60994,
 297562535,
 92316,
 -1,
 297621613,
 92398,
 -1,
 297544701,
 92399,
 297865669,
 297481418,
 -1,
 297931204,
 297810097,
 -1,
 -60989,
 297889281,
 92310,
 -1,
 297953027,
 92320,
 -1,
 297867505,
 92312,
 298193352,
 297832300,
 -1,
 -60985,
 298158547,
 92369,
 -1,
 298193898,
 92306,
 298389963,
 298159580,
 -1,
 -60982,
 298357663,
 92337,
 -1,
 298389687,
 92353,
 -60980,
 298349841,
 92355,
 -60979,
 298529973,
 92348,
 -1,
 298589064,
 92352,
 298783308,
 289083075,
 -1,
 298848754,
 298735725,
 -1,
 298914262,
 298810937,
 -1,
 298979797,
 298849385,
 92223,
 299106303,
 298909696,
 -1,
 -60972,
 298998734,
 92194,
 -1,
 299062780,
 92185,
 -1,
 298934877,
 92178,
 299307484,
 298857674,
 -1,
 299373018,
 299256597,
 -1,
 -60967,
 299326689,
 92182,
 -1,
 299369274,
 92160,
 -60965,
 299316807,
 92229,
 -1,
 299504649,
 92173,
 299700704,
 299275347,
 -1,
 299766239,
 299646559,
 92239,
 -1,
 299728502,
 92225,
 -1,
 299708029,
 92233,
 299962851,
 299669043,
 -1,
 -60958,
 299927797,
 92191,
 -1,
 299962061,
 92167,
 300159462,
 299923237,
 -1,
 -60955,
 300105756,
 92237,
 -1,
 300158657,
 92241,
 300356073,
 300107830,
 -1,
 -60952,
 300302922,
 92180,
 -1,
 300355407,
 92227,
 300552684,
 300294955,
 -1,
 -60949,
 300487641,
 92212,
 -1,
 300548820,
 92201,
 300749295,
 300486337,
 -1,
 -60946,
 300706855,
 92245,
 -1,
 300748493,
 92164,
 -60944,
 300697438,
 92231,
 -60943,
 300892483,
 92204,
 -1,
 300952573,
 92244,
 301142537,
 298799652,
 -1,
 301208062,
 301076161,
 -1,
 301273596,
 301148283,
 -1,
 301339129,
 301224484,
 92238,
 -60937,
 301305327,
 92174,
 -60936,
 301353712,
 92203,
 -1,
 301406611,
 92171,
 -60934,
 301299828,
 92230,
 -60933,
 301554894,
 92210,
 -1,
 301615580,
 92186,
 -60931,
 301229860,
 92221,
 -1,
 301751194,
 92175,
 301928963,
 301161703,
 -1,
 301994498,
 301883218,
 -1,
 -60927,
 301951994,
 92198,
 -1,
 302002029,
 92214,
 -1,
 301946994,
 92190,
 302256646,
 301865002,
 -1,
 -60923,
 302214183,
 92246,
 -1,
 302275790,
 92232,
 -60921,
 302222816,
 92176,
 -60920,
 302396876,
 92196,
 -1,
 302460716,
 92197,
 302649881,
 301102478,
 -1,
 302715410,
 302594203,
 -1,
 302780942,
 302679627,
 -1,
 -60915,
 302731812,
 92215,
 -1,
 302787774,
 92165,
 302977553,
 302726751,
 -1,
 -60912,
 302935553,
 92222,
 -1,
 302995788,
 92168,
 -1,
 302932560,
 92224,
 303239702,
 302669031,
 -1,
 -60908,
 303201849,
 92235,
 -60907,
 303262759,
 92220,
 -1,
 303323885,
 92208,
 -60905,
 303205316,
 92181,
 -60904,
 303449465,
 92195,
 -1,
 303509304,
 92177,
 303698474,
 302606083,
 -1,
 303764001,
 303632065,
 -1,
 303829534,
 303697601,
 -1,
 -60899,
 303787521,
 92226,
 -1,
 303845924,
 92236,
 -60897,
 303789950,
 92187,
 -60896,
 303978420,
 92189,
 -1,
 304022228,
 92200,
 304222760,
 303718289,
 -1,
 304288293,
 304179013,
 -1,
 -60892,
 304231906,
 92169,
 -1,
 304289834,
 92170,
 304545791,
 304240129,
 -1,
 -60889,
 304428514,
 92162,
 -1,
 304486442,
 92163,
 -60887,
 304187859,
 92205,
 -1,
 304623229,
 92202,
 304812595,
 303646774,
 -1,
 304878126,
 304752763,
 -1,
 -60883,
 304842835,
 92179,
 -1,
 304905785,
 92211,
 305074737,
 304811713,
 -1,
 -60880,
 305032231,
 92240,
 -1,
 305082804,
 92199,
 -60878,
 305039823,
 92213,
 -1,
 305228450,
 92219,
 305402427,
 304774713,
 -1,
 305467959,
 305366603,
 -1,
 -60874,
 305402035,
 92206,
 -1,
 305464082,
 92172,
 305664570,
 305409767,
 -1,
 -60871,
 305627332,
 92209,
 -1,
 305664166,
 92234,
 -1,
 305612298,
 92166,
 305926721,
 305351498,
 -1,
 305992254,
 305890891,
 92243,
 -1,
 305926323,
 92207,
 -60865,
 305946500,
 92216,
 -60864,
 306065024,
 92184,
 -1,
 306123888,
 92183,
 306319942,
 305870026,
 -1,
 306385477,
 306264760,
 -1,
 -60860,
 306343425,
 92188,
 -1,
 306394824,
 92193,
 -1,
 306321868,
 92161,
 306647625,
 306284107,
 -1,
 -60856,
 306600710,
 92228,
 -1,
 306645461,
 92192,
 -60854,
 306613457,
 92242,
 -60853,
 306803780,
 92218,
 -1,
 306852593,
 92217,
 307040925,
 298719223,
 -1,
 307106400,
 306991652,
 -1,
 307171925,
 307042293,
 -1,
 307237458,
 307105473,
 -1,
 -60847,
 307172577,
 92255,
 -1,
 307233546,
 92252,
 -60845,
 307202511,
 92292,
 -60844,
 307381742,
 92268,
 -1,
 307441488,
 92286,
 307630681,
 307105473,
 92300,
 307757055,
 307561295,
 -1,
 -60840,
 307661495,
 92296,
 -1,
 307703558,
 92295,
 307892828,
 307573079,
 -1,
 -60837,
 307847082,
 92267,
 -1,
 307906325,
 92284,
 308089439,
 307834599,
 -1,
 -60834,
 308051587,
 92290,
 -1,
 308112423,
 92281,
 -1,
 308044016,
 92287,
 308351601,
 307058797,
 -1,
 308417129,
 308294858,
 -1,
 308482663,
 308360394,
 -1,
 308548197,
 308447695,
 92282,
 -1,
 308478669,
 92283,
 -60826,
 308489962,
 92277,
 -1,
 308612929,
 92298,
 -60824,
 308436818,
 92302,
 -1,
 308759093,
 92276,
 308941420,
 308384851,
 -1,
 -60821,
 308887146,
 92269,
 -1,
 308940947,
 92288,
 309138031,
 308901262,
 -1,
 -60818,
 309083668,
 92247,
 -1,
 309144573,
 92299,
 -60816,
 309101074,
 92260,
 -1,
 309274631,
 92261,
 309465721,
 308311438,
 -1,
 309531253,
 309410323,
 -1,
 -60812,
 309495506,
 92266,
 -1,
 309558924,
 92265,
 -60810,
 309495807,
 92285,
 -60809,
 309674012,
 92249,
 -60808,
 309735047,
 92250,
 -1,
 309793291,
 92279,
 309990018,
 309413942,
 -1,
 310055550,
 309931751,
 -1,
 -60804,
 310023508,
 92272,
 -60803,
 310078458,
 92270,
 -1,
 310120591,
 92294,
 310317697,
 310001247,
 -1,
 -60800,
 310275111,
 92301,
 -1,
 310323873,
 92253,
 -1,
 310252278,
 92256,
 310579847,
 309946115,
 -1,
 -60796,
 310544760,
 92289,
 -60795,
 310592999,
 92263,
 -60794,
 310651583,
 92257,
 -1,
 310711762,
 92274,
 310907533,
 310528842,
 -1,
 310973067,
 310841025,
 -1,
 -60790,
 310923848,
 92259,
 -1,
 310973234,
 92273,
 -60788,
 310927189,
 92251,
 -1,
 311111293,
 92297,
 311300754,
 310869561,
 -1,
 311366289,
 311264845,
 -1,
 -60784,
 311319430,
 92264,
 -1,
 311382728,
 92248,
 -1,
 311299905,
 92280,
 311628437,
 311268435,
 -1,
 -60780,
 311570243,
 92254,
 -1,
 311628067,
 92258,
 311825048,
 311572175,
 -1,
 -60777,
 311789251,
 92262,
 -1,
 311842925,
 92271,
 312021659,
 311767571,
 -1,
 -60774,
 311987150,
 92291,
 -1,
 312027259,
 92293,
 -60772,
 311989137,
 92278,
 -1,
 312184298,
 92275,
 312410111,
 306983257,
 -1,
 312414892,
 312301677,
 -1,
 312480417,
 312378955,
 92697,
 -1,
 312414336,
 92696,
 312611492,
 312428336,
 -1,
 -60765,
 312575679,
 92698,
 -1,
 312610959,
 92688,
 312808103,
 312554698,
 -1,
 -60762,
 312757032,
 92711,
 -1,
 312816892,
 92712,
 -60760,
 312776025,
 92681,
 -60759,
 312967196,
 92704,
 -60758,
 313030500,
 92702,
 -60757,
 313081439,
 92708,
 -1,
 313140040,
 92687,
 313332405,
 312374670,
 -1,
 313397937,
 313276571,
 -1,
 -60753,
 313361995,
 92700,
 -60752,
 313416935,
 92713,
 -1,
 313475388,
 92691,
 -60750,
 313363396,
 92690,
 -60749,
 313605727,
 92692,
 -60748,
 313667441,
 92693,
 -1,
 313725689,
 92727,
 313922238,
 313280566,
 -1,
 313987769,
 313862267,
 -1,
 -60744,
 313949753,
 92695,
 -1,
 314005613,
 92710,
 -60742,
 313955596,
 92694,
 -60741,
 314148427,
 92677,
 -60740,
 314206018,
 92726,
 -60739,
 314268903,
 92719,
 -1,
 314314433,
 92675,
 314512071,
 313879914,
 -1,
 314577603,
 314452091,
 -1,
 -60735,
 314543054,
 92709,
 -60734,
 314595437,
 92721,
 -1,
 314648699,
 92679,
 314839750,
 314523231,
 -1,
 -60731,
 314785375,
 92683,
 -1,
 314845812,
 92684,
 -1,
 314803787,
 92707,
 315101902,
 314462756,
 92689,
 315167435,
 315037685,
 -1,
 -60726,
 315108349,
 92720,
 -1,
 315166522,
 92724,
 -60724,
 315120871,
 92723,
 -60723,
 315304571,
 92685,
 -1,
 315363009,
 92722,
 315560659,
 315063865,
 -1,
 315626194,
 315494081,
 -1,
 -60719,
 315566203,
 92680,
 -1,
 315625153,
 92686,
 -1,
 315567741,
 92725,
 315888344,
 315516675,
 -1,
 315953879,
 315828347,
 -1,
 -60714,
 315919310,
 92703,
 -1,
 315959419,
 92706,
 -1,
 315918015,
 92714,
 316216028,
 315837258,
 -1,
 -60710,
 316170825,
 92718,
 -60709,
 316227167,
 92717,
 -1,
 316280513,
 92682,
 316478175,
 316183635,
 -1,
 -60706,
 316432969,
 92699,
 -1,
 316477121,
 92701,
 316674786,
 316444524,
 -1,
 -60703,
 316639231,
 92705,
 -1,
 316673729,
 92716,
 -60701,
 316641113,
 92728,
 -60700,
 316835403,
 92676,
 -60699,
 316879796,
 92715,
 -1,
 316942964,
 92678,
 317133545,
 263489099,
 -1,
 -60696,
 317073531,
 42696,
 -1,
 317132928,
 42711,
 317330156,
 317073531,
 -1,
 -60693,
 317295566,
 42693,
 -1,
 317335675,
 42698,
 -60691,
 317275743,
 42717,
 -1,
 317460161,
 42667,
 317657857,
 263411821,
 -1,
 317723379,
 317605680,
 -1,
 -60687,
 317687487,
 42686,
 -60686,
 317729396,
 42694,
 -1,
 317788303,
 42674,
 317985527,
 317666506,
 -1,
 -60683,
 317934376,
 42707,
 -60682,
 317994236,
 42708,
 -1,
 318049985,
 42709,
 318247673,
 317949515,
 42685,
 -1,
 318181504,
 42684,
 318378748,
 318209593,
 -1,
 -60677,
 318344132,
 42731,
 -1,
 318384756,
 42695,
 -60675,
 318346585,
 42664,
 -60674,
 318535524,
 42691,
 -60673,
 318586463,
 42703,
 -60672,
 318645064,
 42673,
 -1,
 318705345,
 42715,
 318903054,
 317605942,
 -1,
 318968581,
 318856423,
 42719,
 -60668,
 318934878,
 42734,
 -1,
 318977757,
 42735,
 319165193,
 318908539,
 -1,
 -60665,
 319130574,
 42692,
 -60664,
 319192633,
 42683,
 -1,
 319248493,
 42706,
 -60662,
 319132940,
 42682,
 -60661,
 319391307,
 42659,
 -60660,
 319448898,
 42729,
 -60659,
 319503967,
 42725,
 -1,
 319557313,
 42657,
 319755033,
 318853668,
 42675,
 319820562,
 319694971,
 -1,
 -60655,
 319772781,
 42722,
 -1,
 319826551,
 42671,
 320017173,
 319756277,
 -1,
 -60652,
 319958013,
 42720,
 -1,
 320016186,
 42727,
 -60650,
 319981131,
 42677,
 -60649,
 320167143,
 42726,
 -60648,
 320224863,
 42702,
 -1,
 320278209,
 42723,
 320475939,
 319714702,
 -1,
 320541471,
 320419995,
 -1,
 -60644,
 320505419,
 42688,
 -60643,
 320560359,
 42710,
 -60642,
 320618812,
 42678,
 -1,
 320679793,
 42680,
 -60640,
 320506820,
 42676,
 -60639,
 320814687,
 42679,
 -60638,
 320876401,
 42681,
 -1,
 320934649,
 42732,
 321131309,
 320433514,
 -1,
 321196840,
 321071227,
 -1,
 -60634,
 321162190,
 42704,
 -60633,
 321214573,
 42721,
 -1,
 321267835,
 42661,
 321458987,
 321142367,
 -1,
 -60630,
 321404511,
 42668,
 -1,
 321464948,
 42669,
 -60628,
 321422923,
 42700,
 -1,
 321589376,
 42705,
 321786677,
 321093177,
 -1,
 321852209,
 321726587,
 -1,
 -60624,
 321814073,
 42728,
 -1,
 321869933,
 42730,
 322048820,
 321785537,
 -1,
 -60621,
 321988731,
 42662,
 -1,
 322047681,
 42672,
 -1,
 321994335,
 42724,
 322310971,
 321735498,
 -1,
 -60617,
 322274891,
 42701,
 -60616,
 322331209,
 42718,
 -60615,
 322387551,
 42716,
 -60614,
 322447995,
 42670,
 -1,
 322506433,
 42666,
 322704192,
 322253143,
 -1,
 -60611,
 322668107,
 42712,
 -60610,
 322723666,
 42713,
 -60609,
 322775668,
 42699,
 -1,
 322834245,
 42733,
 323031876,
 322671699,
 -1,
 -60606,
 322996916,
 42689,
 -60605,
 323052105,
 42687,
 -1,
 323096257,
 42690,
 323294023,
 322998124,
 -1,
 -60602,
 323258367,
 42697,
 -1,
 323292865,
 42714,
 -60600,
 323257931,
 42658,
 -60599,
 323443943,
 42663,
 -60598,
 323501663,
 42665,
 -60597,
 323562100,
 42660,
 -1,
 323620545,
 42656,
 323818323,
 263331845,
 -1,
 323883858,
 323768868,
 -1,
 323949393,
 323820020,
 -1,
 -60592,
 323912998,
 42737,
 -1,
 323963575,
 42736,
 -1,
 323900029,
 42741,
 -1,
 323833995,
 42740,
 -60588,
 323778257,
 42742,
 -60587,
 324234520,
 42743,
 -60586,
 324295397,
 42738,
 -1,
 324351161,
 42739,
 324539383,
 263277386,
 -1,
 324604918,
 324485775,
 -1,
 324670361,
 324554321,
 -1,
 324735841,
 324632121,
 -1,
 324801376,
 324669121,
 6946,
 324927487,
 324730880,
 -1,
 -60578,
 324829084,
 6947,
 -60577,
 324884512,
 6942,
 -1,
 324947042,
 6941,
 -1,
 324769607,
 6983,
 325194598,
 324687981,
 -1,
 325260132,
 325127873,
 6950,
 -1,
 325191160,
 6945,
 -60571,
 325227669,
 6940,
 -1,
 325334268,
 6935,
 325522283,
 325142582,
 -1,
 325587818,
 325455553,
 6931,
 -60567,
 325529967,
 6981,
 -1,
 325583642,
 6932,
 -1,
 325532956,
 6982,
 325849969,
 325460779,
 6948,
 325976063,
 325780231,
 -1,
 325981040,
 325880575,
 -1,
 -60561,
 325931730,
 6944,
 -1,
 325980893,
 6943,
 -1,
 325914748,
 6949,
 326243190,
 325783233,
 -1,
 326308724,
 326191374,
 6917,
 -1,
 326239911,
 6918,
 -60555,
 326270509,
 6987,
 -1,
 326385991,
 6928,
 326570874,
 326202850,
 6962,
 326696959,
 326501919,
 -1,
 -60551,
 326592322,
 6961,
 -1,
 326644988,
 6960,
 326833021,
 326528456,
 6957,
 326959103,
 326764041,
 6923,
 -1,
 326829735,
 6924,
 327029632,
 326781816,
 6958,
 327155711,
 326959845,
 6925,
 -1,
 327026343,
 6926,
 327226242,
 326993997,
 6921,
 -1,
 327157415,
 6922,
 327357316,
 327182146,
 6951,
 -1,
 327287385,
 6952,
 327488390,
 327311013,
 6929,
 -1,
 327419559,
 6930,
 327619464,
 327436110,
 6938,
 -1,
 327549512,
 6939,
 327750538,
 327565639,
 6919,
 -1,
 327681703,
 6920,
 327881612,
 327693564,
 6933,
 -1,
 327811597,
 6934,
 328012687,
 327821435,
 -1,
 -60530,
 327960846,
 6927,
 -1,
 328020335,
 6984,
 328209297,
 327949282,
 6936,
 -1,
 328139410,
 6937,
 328340371,
 328144938,
 6953,
 -1,
 328270458,
 6954,
 -60524,
 328308322,
 6986,
 -60523,
 328438933,
 6956,
 -60522,
 328503219,
 6959,
 -60521,
 328568003,
 6985,
 -60520,
 328618621,
 6955,
 -1,
 328677553,
 6963,
 328864706,
 324622389,
 -1,
 328930216,
 328803022,
 -1,
 328995746,
 328863425,
 -1,
 329061280,
 328948273,
 7012,
 329187327,
 328990720,
 -1,
 -60513,
 329088416,
 7013,
 -1,
 329135654,
 7018,
 -60511,
 329007766,
 7017,
 -1,
 329264282,
 7015,
 329454501,
 328935547,
 -1,
 -60508,
 329419115,
 7016,
 -1,
 329472561,
 7010,
 -60506,
 329419115,
 7011,
 -60505,
 329605244,
 7009,
 -1,
 329663126,
 7014,
 329847731,
 328867885,
 -1,
 329913262,
 329796014,
 -1,
 329978796,
 329877609,
 7021,
 -1,
 329910554,
 7024,
 330170367,
 329928440,
 7022,
 -1,
 330041626,
 7025,
 -60497,
 329875488,
 7019,
 -60496,
 330188701,
 7023,
 -60495,
 330250153,
 7027,
 -60494,
 330312835,
 7020,
 -1,
 330373448,
 7026,
 330568635,
 329797048,
 -1,
 330634168,
 330523047,
 -1,
 -60490,
 330598763,
 7033,
 -60489,
 330646166,
 7036,
 -1,
 330699712,
 7032,
 330956799,
 330571705,
 -1,
 -60486,
 330860618,
 7035,
 -1,
 330895863,
 7034,
 331153407,
 330527298,
 -1,
 331158463,
 331047283,
 -1,
 -60482,
 331122722,
 7028,
 -1,
 331157808,
 7029,
 331415551,
 331096003,
 -1,
 -60479,
 331319370,
 7030,
 -1,
 331354615,
 7031,
 331551700,
 328830715,
 -1,
 331617226,
 331513401,
 -1,
 331682761,
 331551403,
 6974,
 331808767,
 331612160,
 -1,
 331813832,
 331706491,
 6975,
 -1,
 331744935,
 6977,
 -1,
 331776021,
 6976,
 -1,
 331623022,
 6965,
 332075980,
 331581595,
 6966,
 -1,
 332006947,
 6967,
 332207054,
 332037509,
 6968,
 -1,
 332137007,
 6969,
 332338128,
 332164555,
 6970,
 -1,
 332269223,
 6971,
 332469202,
 332294297,
 6978,
 -1,
 332400295,
 6979,
 332660735,
 332417915,
 6972,
 -1,
 332531367,
 6973,
 332731362,
 331490544,
 -1,
 332796888,
 332693049,
 -1,
 -60457,
 332763794,
 6994,
 -1,
 332807518,
 6995,
 332993499,
 332756366,
 -1,
 -60454,
 332941017,
 6998,
 -1,
 333000576,
 6999,
 333190110,
 332935511,
 -1,
 -60451,
 333145210,
 6996,
 -1,
 333203080,
 6997,
 -60449,
 333158097,
 6992,
 -60448,
 333340670,
 6993,
 -60447,
 333404831,
 7001,
 -1,
 333458229,
 7000,
 333648874,
 332691601,
 -1,
 333714406,
 333613215,
 -1,
 -60443,
 333672843,
 6912,
 -1,
 333716533,
 6913,
 -60441,
 333675936,
 6915,
 -60440,
 333869197,
 6964,
 -60439,
 333913449,
 6914,
 -1,
 333978113,
 6916,
 334173167,
 333604674,
 -1,
 334238702,
 334123556,
 -1,
 -60435,
 334179465,
 7008,
 -1,
 334237774,
 7003,
 -1,
 334191587,
 7002,
 334500852,
 334109887,
 -1,
 334566387,
 334456642,
 -1,
 -60430,
 334524565,
 7007,
 -1,
 334583815,
 7005,
 -1,
 334526638,
 7006,
 -60427,
 334467411,
 7004,
 -1,
 334762081,
 6980,
 -1,
 324554956,
 127880,
 335025217,
 324501049,
 -1,
 335090750,
 334959098,
 -1,
 335156261,
 335040081,
 -1,
 335221768,
 335115662,
 -1,
 335287302,
 335167890,
 -1,
 -60419,
 335254677,
 7132,
 -60418,
 335318963,
 7116,
 -60417,
 335377890,
 7129,
 -60416,
 335441352,
 7123,
 -60415,
 335505218,
 7112,
 -60414,
 335565437,
 7125,
 -60413,
 335629176,
 7135,
 -60412,
 335689905,
 7107,
 -60411,
 335754492,
 7119,
 -1,
 335810241,
 7105,
 -60409,
 335242507,
 7126,
 -1,
 335941313,
 7128,
 336139278,
 335173741,
 -1,
 -60406,
 336106645,
 7136,
 -60405,
 336159511,
 7127,
 -60404,
 336213244,
 7133,
 -60403,
 336274219,
 7138,
 -1,
 336334529,
 7113,
 336532501,
 336089636,
 -1,
 336598036,
 336465601,
 7124,
 336723967,
 336550236,
 -1,
 -60398,
 336623074,
 7130,
 -60397,
 336681155,
 7114,
 -1,
 336738481,
 7108,
 -1,
 336533546,
 7139,
 336991255,
 336488258,
 7111,
 -1,
 336939752,
 7117,
 -60392,
 336958613,
 7131,
 -60391,
 337088435,
 7115,
 -60390,
 337151563,
 7141,
 -60389,
 337210824,
 7122,
 -60388,
 337267576,
 7134,
 -60387,
 337332505,
 7110,
 -60386,
 337397582,
 7120,
 -60385,
 337460831,
 7140,
 -60384,
 337524913,
 7106,
 -60383,
 337589500,
 7118,
 -60382,
 337650475,
 7121,
 -60381,
 337714146,
 7137,
 -60380,
 337778730,
 7109,
 -1,
 337841857,
 7104,
 338039856,
 335122171,
 -1,
 338105384,
 338003531,
 7150,
 -1,
 338035147,
 7151,
 338236459,
 338053395,
 -1,
 -60374,
 338189543,
 7149,
 -1,
 338247263,
 7147,
 338433069,
 338176123,
 7143,
 -1,
 338372731,
 7145,
 -60370,
 338388847,
 7144,
 -60369,
 338517223,
 7148,
 -1,
 338574943,
 7146,
 338760760,
 337999246,
 -1,
 338826295,
 338728338,
 -1,
 338891829,
 338781955,
 -1,
 -60364,
 338838012,
 7165,
 -1,
 338891777,
 7167,
 -60362,
 338843846,
 7164,
 -1,
 339036194,
 7166,
 -1,
 338772271,
 7142,
 339285051,
 338716576,
 -1,
 -60358,
 339239085,
 7155,
 -1,
 339294081,
 7154,
 339542015,
 339222658,
 -1,
 -60355,
 339434033,
 7152,
 -1,
 339490971,
 7153,
 339678272,
 335034523,
 128704,
 -1,
 339641590,
 128705,
 -1,
 339640511,
 128267,
 339874889,
 334977133,
 -1,
 339940424,
 339822646,
 127974,
 340066303,
 339893082,
 -1,
 -60347,
 339973401,
 128180,
 -60346,
 340028082,
 128183,
 -60345,
 340078421,
 128182,
 -1,
 340141454,
 128181,
 -1,
 339874606,
 127820,
 340399183,
 339811254,
 128118,
 340525055,
 340328448,
 -1,
 -60340,
 340426230,
 128700,
 -60339,
 340467244,
 128036,
 -60338,
 340531914,
 127868,
 -1,
 340595667,
 128124,
 340792404,
 340335558,
 -1,
 340857939,
 340740150,
 -1,
 -60334,
 340818697,
 983056,
 -1,
 340855080,
 128281,
 -1,
 340821018,
 128043,
 341120087,
 340751758,
 -1,
 -60330,
 341068227,
 127936,
 -1,
 341125631,
 9918,
 341316698,
 341077354,
 -1,
 -60327,
 341252435,
 128136,
 -1,
 341311766,
 128202,
 -1,
 341259901,
 128708,
 341579001,
 263220586,
 -1,
 341644528,
 341512585,
 -1,
 341709985,
 341593681,
 -1,
 341775461,
 341674964,
 -1,
 341840996,
 341728613,
 -1,
 341906530,
 341798250,
 69643,
 -1,
 341863786,
 69644,
 342097919,
 341855050,
 69645,
 -1,
 341986122,
 69646,
 -1,
 341774017,
 69679,
 342234219,
 341737017,
 -1,
 342299753,
 342195769,
 -1,
 -60312,
 342243505,
 69662,
 -1,
 342298305,
 69661,
 -60310,
 342243505,
 69667,
 -1,
 342429377,
 69666,
 342627440,
 342187239,
 69649,
 342753279,
 342576344,
 -1,
 -60306,
 342652060,
 69686,
 -60305,
 342711074,
 69687,
 -1,
 342773828,
 69685,
 342955125,
 342579309,
 -1,
 -60302,
 342922389,
 69660,
 -60301,
 342972611,
 69665,
 -60300,
 343028988,
 69655,
 -1,
 343084737,
 69670,
 343282811,
 342893262,
 -1,
 343348345,
 343220942,
 -1,
 -60296,
 343292081,
 69664,
 -1,
 343346881,
 69663,
 -60294,
 343292081,
 69669,
 -1,
 343477953,
 69668,
 343676031,
 343215809,
 69637,
 -60291,
 343639627,
 69650,
 -60290,
 343686751,
 69648,
 -1,
 343740097,
 69638,
 343938179,
 343635342,
 -1,
 -60287,
 343897570,
 69681,
 -60286,
 343947441,
 69680,
 -1,
 344002241,
 69682,
 344200325,
 343901771,
 69641,
 -1,
 344163915,
 69642,
 344331400,
 344155907,
 -1,
 -60281,
 344275121,
 69672,
 -1,
 344329921,
 69671,
 344528011,
 344279882,
 -1,
 -60278,
 344476536,
 69684,
 -1,
 344526529,
 69678,
 344724622,
 344475702,
 -1,
 -60275,
 344668337,
 69652,
 -1,
 344723137,
 69651,
 344921233,
 344672048,
 -1,
 -60272,
 344864945,
 69659,
 -1,
 344919745,
 69658,
 345117843,
 344866399,
 69639,
 -1,
 345063007,
 69640,
 345248918,
 345060554,
 -1,
 -60267,
 345192625,
 69654,
 -1,
 345247425,
 69653,
 345445529,
 345185222,
 -1,
 -60264,
 345389233,
 69657,
 -1,
 345444033,
 69656,
 345642140,
 345380853,
 -1,
 -60261,
 345585841,
 69674,
 -1,
 345640641,
 69673,
 -60259,
 345609365,
 69676,
 -60258,
 345796040,
 69677,
 -60257,
 345854589,
 69675,
 -60256,
 345913521,
 69683,
 -1,
 345974907,
 69647,
 346166462,
 341662767,
 -1,
 346231978,
 346127929,
 -1,
 346297510,
 346197868,
 -1,
 -60251,
 346250471,
 69715,
 -1,
 346303728,
 69724,
 346494121,
 346241179,
 -1,
 -60248,
 346452018,
 69716,
 -1,
 346506591,
 69725,
 -1,
 346434557,
 69723,
 346756271,
 346191246,
 -1,
 346821805,
 346703577,
 69719,
 -1,
 346785336,
 69728,
 347013119,
 346763136,
 69720,
 -1,
 346916408,
 69729,
 347083958,
 346698071,
 -1,
 347149491,
 347036903,
 -1,
 -60238,
 347114177,
 69717,
 -1,
 347174157,
 69726,
 347406335,
 347094623,
 -1,
 -60235,
 347311273,
 69718,
 -1,
 347354289,
 69727,
 347542714,
 347037694,
 69714,
 347668479,
 347471872,
 -1,
 -60231,
 347570551,
 69733,
 -1,
 347618845,
 69732,
 347804860,
 347495071,
 69722,
 -1,
 347768376,
 69731,
 347996159,
 347745077,
 69721,
 -1,
 347903059,
 69730,
 348067025,
 346131412,
 -1,
 348132560,
 348022443,
 -1,
 348198085,
 348098133,
 -1,
 348263619,
 348155242,
 69694,
 -1,
 348220778,
 69695,
 348454911,
 348212042,
 69696,
 -1,
 348343114,
 69697,
 348525769,
 348131009,
 -1,
 -60217,
 348489291,
 69701,
 -60216,
 348536415,
 69699,
 -1,
 348589761,
 69688,
 348787915,
 348489291,
 69692,
 -1,
 348751435,
 69693,
 348918989,
 348733023,
 69690,
 -1,
 348864095,
 69691,
 -60210,
 348871911,
 69700,
 -60209,
 348989563,
 69698,
 -1,
 349051290,
 69689,
 -1,
 348079403,
 69702,
 349312226,
 348005070,
 -1,
 349377760,
 349257997,
 -1,
 349443286,
 349339193,
 -1,
 -60203,
 349409938,
 69736,
 -1,
 349453662,
 69737,
 349639897,
 349402510,
 -1,
 -60200,
 349587161,
 69740,
 -1,
 349646720,
 69741,
 349836508,
 349581655,
 -1,
 -60197,
 349791354,
 69738,
 -1,
 349849224,
 69739,
 -60195,
 349804241,
 69734,
 -60194,
 349986814,
 69735,
 -60193,
 350050975,
 69743,
 -1,
 350104373,
 69742,
 -60191,
 349332507,
 69704,
 -1,
 350229410,
 69703,
 350426344,
 349272209,
 -1,
 -60188,
 350391837,
 69634,
 -60187,
 350456420,
 69636,
 -60186,
 350504901,
 69635,
 -60185,
 350559323,
 69632,
 -1,
 350622812,
 69633,
 350879743,
 350383048,
 -1,
 350885100,
 350767946,
 -1,
 -60181,
 350839820,
 69709,
 -1,
 350896749,
 69707,
 351081711,
 350823812,
 -1,
 -60178,
 351045442,
 69706,
 -1,
 351108665,
 69705,
 -1,
 351019319,
 69708,
 351343861,
 341589599,
 -1,
 351409396,
 351281870,
 -1,
 -60173,
 351352315,
 127753,
 -1,
 351414617,
 128112,
 -1,
 351349449,
 128188,
 351671544,
 351283567,
 -1,
 -60169,
 351619153,
 983124,
 -1,
 351675086,
 127838,
 -1,
 351624875,
 128148,
 351933733,
 341542475,
 -1,
 351999264,
 351876298,
 128027,
 352124927,
 351945359,
 -1,
 352130328,
 352013905,
 -1,
 352195846,
 352082029,
 -1,
 352261377,
 352162899,
 -1,
 -60160,
 352197602,
 6671,
 -1,
 352259777,
 6670,
 352457988,
 352203978,
 -1,
 -60157,
 352405640,
 6659,
 -1,
 352456385,
 6658,
 -60155,
 352415176,
 6667,
 -1,
 352587457,
 6666,
 352785673,
 352145956,
 -1,
 -60152,
 352741186,
 6663,
 -1,
 352784065,
 6662,
 -60150,
 352752789,
 6672,
 -60149,
 352947178,
 6675,
 -60148,
 353009327,
 6664,
 -60147,
 353072610,
 6676,
 -60146,
 353136072,
 6673,
 -60145,
 353199938,
 6660,
 -60144,
 353258360,
 6674,
 -60143,
 353323144,
 6656,
 -60142,
 353388366,
 6669,
 -60141,
 353450161,
 6678,
 -60140,
 353514748,
 6657,
 -60139,
 353575723,
 6665,
 -60138,
 353639394,
 6668,
 -60137,
 353703978,
 6661,
 -1,
 353767105,
 6677,
 353965342,
 352095995,
 -1,
 -60134,
 353928779,
 6680,
 -60133,
 353983719,
 6682,
 -60132,
 354041439,
 6679,
 -60131,
 354101371,
 6681,
 -1,
 354160768,
 6683,
 -60129,
 353920901,
 6686,
 -1,
 354298996,
 6687,
 354549759,
 351958414,
 128652,
 354555172,
 354451001,
 -1,
 -60125,
 354514331,
 128101,
 -1,
 354550329,
 128100,
 -1,
 354485883,
 128655,
 354817369,
 351882058,
 -1,
 354882899,
 354750466,
 -1,
 354948398,
 354841998,
 -1,
 355013932,
 354898750,
 -1,
 -60118,
 354974785,
 11089,
 -60117,
 355029357,
 11050,
 -1,
 355083457,
 11049,
 -60115,
 354970810,
 128306,
 -1,
 355228526,
 9927,
 355407158,
 354896714,
 -1,
 355472691,
 355347169,
 -1,
 355538226,
 355404439,
 9194,
 -1,
 355469754,
 9198,
 -1,
 355467969,
 9944,
 355794943,
 355407145,
 -1,
 -60107,
 355695466,
 11035,
 -1,
 355737279,
 11044,
 355931451,
 355365454,
 -1,
 355996985,
 355870507,
 9193,
 -1,
 355928506,
 9197,
 -60102,
 355959846,
 9199,
 -1,
 356083836,
 11091,
 356259136,
 355881508,
 -1,
 356324671,
 356199015,
 -1,
 -60098,
 356274541,
 11047,
 -1,
 356328641,
 11045,
 -1,
 356278570,
 9912,
 356586821,
 356197070,
 -1,
 356652356,
 356544300,
 -1,
 -60093,
 356602795,
 9922,
 -1,
 356665920,
 9923,
 -1,
 356607703,
 9196,
 356914504,
 356551952,
 -1,
 -60089,
 356881530,
 11037,
 -1,
 356942340,
 11054,
 357111115,
 356875833,
 -1,
 -60086,
 357077766,
 9942,
 -1,
 357135636,
 9951,
 357307726,
 357054619,
 -1,
 -60083,
 357262007,
 11052,
 -1,
 357314614,
 11042,
 -60081,
 357272136,
 9195,
 -60080,
 357461286,
 10067,
 -60079,
 357525628,
 11039,
 -60078,
 357577519,
 9873,
 -1,
 357638517,
 9960,
 357832022,
 354846722,
 -1,
 -60075,
 357775928,
 128153,
 -1,
 357833407,
 128216,
 358088703,
 357784807,
 -1,
 -60072,
 357994653,
 128033,
 -1,
 358054898,
 127804,
 358225263,
 354770151,
 -1,
 358290784,
 358188264,
 -1,
 -60068,
 358253416,
 9185,
 -60067,
 358314516,
 11813,
 -60066,
 358377440,
 9181,
 -60065,
 358436252,
 11812,
 -1,
 358490765,
 9183,
 358684005,
 358247053,
 -1,
 -60062,
 358651749,
 12730,
 -60061,
 358698719,
 12729,
 -60060,
 358760761,
 12589,
 -1,
 358823587,
 12728,
 359011689,
 358637218,
 -1,
 359077224,
 358962164,
 128278,
 -1,
 359007896,
 128209,
 -1,
 359036302,
 128218,
 359273835,
 358961700,
 983247,
 -1,
 359208949,
 128163,
 -60052,
 359240787,
 128102,
 -60051,
 359371361,
 127923,
 -60050,
 359434939,
 128144,
 -1,
 359470296,
 128023,
 359667072,
 358164603,
 -1,
 359732601,
 359618669,
 -1,
 359798135,
 359675202,
 -1,
 359863669,
 359747161,
 -1,
 -60044,
 359810283,
 983621,
 -1,
 359863207,
 2510,
 -60042,
 359823511,
 2493,
 -1,
 360002925,
 2555,
 -60040,
 359765691,
 9187,
 -1,
 360153848,
 127857,
 360322428,
 359680842,
 983055,
 360447999,
 360270666,
 128276,
 -1,
 360318926,
 128277,
 360519039,
 360255169,
 -1,
 -60034,
 360481467,
 128147,
 -1,
 360541559,
 128059,
 -1,
 360459633,
 127866,
 360781193,
 359611999,
 -1,
 360846724,
 360738154,
 -1,
 -60029,
 360808726,
 127874,
 -1,
 360850126,
 128038,
 361043335,
 360784585,
 -1,
 -60026,
 360990138,
 128692,
 -1,
 361048187,
 128690,
 -60024,
 360992806,
 127921,
 -1,
 361187919,
 128089,
 361371020,
 360748115,
 -1,
 -60021,
 361338476,
 983249,
 -1,
 361398202,
 983246,
 -60019,
 361330062,
 983057,
 -1,
 361523441,
 983125,
 361699908,
 263146314,
 -1,
 361764774,
 361631425,
 -1,
 361830284,
 361726640,
 -1,
 361895608,
 361788814,
 -1,
 361961125,
 361845566,
 -1,
 362026658,
 361909841,
 -1,
 362091954,
 361987641,
 -1,
 362157478,
 362055243,
 -1,
 362223013,
 362116068,
 -1,
 362288538,
 362187743,
 -1,
 -60007,
 362231793,
 983615,
 -1,
 362287144,
 983616,
 362485149,
 362241255,
 -1,
 -60004,
 362440771,
 7432,
 -1,
 362489979,
 7444,
 362681759,
 362430047,
 7433,
 -1,
 362634157,
 42879,
 362812833,
 362625181,
 686,
 -1,
 362741896,
 687,
 -59998,
 362769817,
 11385,
 -59997,
 362892106,
 42881,
 -59996,
 362951882,
 7543,
 -1,
 363008128,
 7426,
 -1,
 362172964,
 42871,
 363271594,
 362100891,
 -1,
 363337129,
 363225832,
 42853,
 -1,
 363267781,
 42855,
 -1,
 363268494,
 7546,
 363533742,
 363202468,
 -1,
 -59988,
 363484714,
 7541,
 -59987,
 363537585,
 11366,
 -1,
 363602561,
 566,
 -59985,
 363501107,
 42793,
 -59984,
 363753648,
 42795,
 -59983,
 363815250,
 7446,
 -1,
 363860384,
 11383,
 364058060,
 362031227,
 -1,
 364123588,
 363988900,
 -1,
 364189112,
 364088714,
 983555,
 364314623,
 364118074,
 -1,
 -59977,
 364197873,
 983557,
 -1,
 364253224,
 983559,
 364451259,
 364142158,
 -1,
 -59974,
 364413505,
 983585,
 -1,
 364449832,
 983583,
 364647870,
 364389815,
 -1,
 -59971,
 364610113,
 983589,
 -1,
 364646440,
 983587,
 364844481,
 364584717,
 -1,
 -59968,
 364794526,
 983561,
 -1,
 364846278,
 983563,
 -59966,
 364805340,
 583,
 -59965,
 364998848,
 7570,
 -1,
 365058895,
 11384,
 365237703,
 364083018,
 -1,
 -59962,
 365195456,
 7576,
 -1,
 365258616,
 7563,
 365434314,
 365181068,
 -1,
 -59959,
 365382977,
 42787,
 -1,
 365445601,
 42789,
 -59957,
 365401873,
 7578,
 -1,
 365592121,
 42859,
 365762015,
 364017038,
 -1,
 365827540,
 365707241,
 -1,
 365893073,
 365780199,
 7441,
 -59952,
 365848659,
 7442,
 -1,
 365889954,
 7443,
 -59950,
 365856331,
 7453,
 -59949,
 366052693,
 7455,
 -1,
 366093465,
 7454,
 366286298,
 365758372,
 -1,
 -59946,
 366251402,
 983575,
 -59945,
 366312885,
 575,
 -59944,
 366372728,
 7562,
 -59943,
 366435654,
 42921,
 -1,
 366499370,
 7540,
 366679518,
 366222987,
 -1,
 -59940,
 366637248,
 7573,
 -59939,
 366688241,
 983617,
 -1,
 366743592,
 983618,
 -1,
 366613223,
 42892,
 367007219,
 365706847,
 -1,
 367072746,
 366938020,
 -1,
 367138277,
 367011255,
 -1,
 -59933,
 367100481,
 983591,
 -59932,
 367146993,
 983590,
 -1,
 367202344,
 983566,
 367400424,
 367091290,
 -1,
 -59929,
 367362625,
 983595,
 -1,
 367398952,
 983593,
 -59927,
 367358144,
 7574,
 -1,
 367547057,
 983565,
 367728113,
 367025061,
 -1,
 -59924,
 367689273,
 42887,
 -59923,
 367752590,
 42885,
 -59922,
 367816042,
 42883,
 -59921,
 367867082,
 7545,
 -59920,
 367931735,
 42876,
 -1,
 367993550,
 42874,
 -59918,
 367687054,
 42861,
 -1,
 368141196,
 7548,
 368317955,
 366939841,
 -1,
 368383483,
 368248740,
 -1,
 368449016,
 368336462,
 -1,
 -59913,
 368411201,
 983581,
 -1,
 368447528,
 983579,
 -59911,
 368409820,
 11365,
 -59910,
 368603328,
 7567,
 -1,
 368661169,
 983553,
 368842237,
 368348116,
 42809,
 -1,
 368773330,
 42811,
 -59906,
 368809043,
 42813,
 -59905,
 368936523,
 42807,
 -59904,
 368991463,
 42805,
 -59903,
 369054078,
 7568,
 -59902,
 369109283,
 983612,
 -1,
 369168065,
 42803,
 369366547,
 368274794,
 -1,
 369432077,
 369295360,
 -1,
 369497612,
 369398155,
 -1,
 -59897,
 369459777,
 983603,
 -59896,
 369523932,
 589,
 -59895,
 369583992,
 7561,
 -59894,
 369646918,
 42919,
 -59893,
 369710634,
 7538,
 -1,
 369767163,
 7539,
 -1,
 369456242,
 42843,
 370021905,
 369373152,
 -1,
 370087440,
 369957830,
 8580,
 -1,
 370018390,
 42815,
 -1,
 370041217,
 7572,
 370343935,
 369985705,
 42869,
 -1,
 370214415,
 42845,
 370415140,
 369319143,
 -1,
 370480669,
 370345892,
 -1,
 370546201,
 370445706,
 983569,
 370671615,
 370475066,
 -1,
 -59880,
 370554865,
 983571,
 -1,
 370610216,
 983573,
 370868223,
 370495590,
 -1,
 -59877,
 370773910,
 11386,
 -59876,
 370827599,
 42829,
 -1,
 370891320,
 42827,
 371070499,
 370436158,
 -1,
 371136034,
 371023108,
 -1,
 -59872,
 371093696,
 7575,
 -59871,
 371144689,
 983613,
 -1,
 371200040,
 983614,
 -1,
 371075395,
 7571,
 -1,
 371023079,
 42831,
 371529265,
 370378315,
 -1,
 371594798,
 371460004,
 -1,
 371660330,
 371544741,
 -1,
 -59864,
 371622465,
 983611,
 -59863,
 371668977,
 983577,
 -1,
 371724328,
 983609,
 371922477,
 371613262,
 -1,
 -59860,
 371884609,
 983607,
 -1,
 371920936,
 983605,
 -1,
 371880128,
 7577,
 -59857,
 371551114,
 7551,
 -59856,
 372134436,
 42872,
 -1,
 372189307,
 7531,
 372381245,
 371477322,
 -1,
 372446777,
 372311972,
 -1,
 -59852,
 372408897,
 983599,
 -59851,
 372469967,
 42894,
 -59850,
 372533112,
 7557,
 -59849,
 372587377,
 42825,
 -59848,
 372647589,
 11361,
 -1,
 372712065,
 564,
 372905532,
 372400289,
 -1,
 -59845,
 372849521,
 7837,
 -1,
 372909233,
 7836,
 -1,
 372869289,
 42866,
 373167687,
 372318926,
 -1,
 373233219,
 373098404,
 -1,
 -59840,
 373188472,
 7553,
 -59839,
 373249578,
 7533,
 -59838,
 373308560,
 7569,
 -1,
 373367425,
 545,
 -59836,
 373196969,
 42865,
 -59835,
 373515220,
 567,
 -59834,
 373566403,
 7839,
 -1,
 373626874,
 568,
 373823056,
 373132244,
 -1,
 373888589,
 373753764,
 -1,
 -59830,
 373846567,
 11377,
 -59829,
 373909368,
 7564,
 -59828,
 373957809,
 42847,
 -1,
 374022785,
 11380,
 -59826,
 373855315,
 42849,
 -59825,
 374162851,
 42851,
 -1,
 374221936,
 42857,
 374412889,
 373774445,
 -1,
 374478423,
 374343588,
 -1,
 -59821,
 374433656,
 7559,
 -59820,
 374496582,
 42917,
 -59819,
 374560298,
 7536,
 -59818,
 374613041,
 42897,
 -1,
 374678145,
 565,
 -59816,
 374442153,
 42868,
 -1,
 374813917,
 983567,
 375002721,
 374368055,
 -1,
 375068254,
 374961550,
 -1,
 375133789,
 375030924,
 7549,
 -1,
 375064261,
 42833,
 -1,
 375090525,
 42837,
 -59809,
 375023480,
 7560,
 -59808,
 375281194,
 7537,
 -1,
 375337850,
 42835,
 375527018,
 374952484,
 -1,
 375592550,
 375457700,
 -1,
 -59804,
 375554625,
 983601,
 -59803,
 375613304,
 7558,
 -1,
 375674410,
 7535,
 375854697,
 375537601,
 -1,
 -59800,
 375819220,
 7933,
 -1,
 375869400,
 7931,
 -1,
 375818409,
 42867,
 376116850,
 375474283,
 -1,
 376182381,
 376077532,
 42817,
 -1,
 376111184,
 42821,
 376313456,
 376120014,
 -1,
 -59793,
 376258234,
 42819,
 -1,
 376319535,
 11370,
 -59791,
 376268664,
 7556,
 -1,
 376462662,
 42915,
 376641145,
 376060059,
 -1,
 376706678,
 376594704,
 -1,
 -59787,
 376649713,
 983619,
 -1,
 376705064,
 983620,
 -59785,
 376646810,
 42791,
 -59784,
 376836767,
 11382,
 -1,
 376899632,
 11368,
 377099904,
 376576966,
 -1,
 377165436,
 377063154,
 42797,
 -1,
 377096194,
 42799,
 377296511,
 377096100,
 -1,
 -59778,
 377257180,
 572,
 -1,
 377297026,
 42899,
 -1,
 377249678,
 42863,
 377558661,
 377067061,
 -1,
 -59774,
 377519541,
 576,
 -59773,
 377579384,
 7566,
 -59772,
 377640490,
 7542,
 -1,
 377693233,
 11372,
 377886347,
 377515047,
 -1,
 377951882,
 377816996,
 -1,
 -59768,
 377912597,
 42839,
 -59767,
 377961630,
 587,
 -1,
 378021041,
 42841,
 -1,
 377906952,
 569,
 378279569,
 377828554,
 -1,
 378345103,
 378210212,
 -1,
 -59762,
 378300280,
 7555,
 -1,
 378363206,
 42913,
 -59760,
 378294535,
 578,
 -1,
 378484913,
 983199,
 378672791,
 378214389,
 -1,
 378738325,
 378603428,
 -1,
 -59756,
 378693496,
 7552,
 -1,
 378754602,
 7532,
 -59754,
 378696747,
 42823,
 -1,
 378889215,
 7447,
 379066010,
 378639497,
 -1,
 -59751,
 379026652,
 591,
 -1,
 379080913,
 7935,
 379262621,
 379012914,
 -1,
 -59748,
 379223260,
 585,
 -1,
 379266502,
 983597,
 379459232,
 379203976,
 -1,
 -59745,
 379414392,
 7554,
 -1,
 379475498,
 7534,
 -59743,
 379425746,
 7565,
 -1,
 379621284,
 11379,
 379846655,
 361962645,
 -1,
 -59740,
 379750031,
 7550,
 -1,
 379797154,
 7547,
 380043263,
 361924524,
 -1,
 380049064,
 379942286,
 8347,
 -1,
 379985542,
 8340,
 -59735,
 380015519,
 8339,
 -59734,
 380144596,
 7525,
 -59733,
 380208715,
 7524,
 -59732,
 380272185,
 8348,
 -59731,
 380333418,
 7523,
 -59730,
 380397315,
 8346,
 -59729,
 380460263,
 8338,
 -59728,
 380524653,
 8345,
 -59727,
 380588580,
 8344,
 -59726,
 380652362,
 8343,
 -59725,
 380717110,
 8342,
 -59724,
 380782384,
 11388,
 -59723,
 380845663,
 7522,
 -59722,
 380909723,
 8341,
 -59721,
 380971131,
 8337,
 -1,
 381030081,
 8336,
 381228896,
 361831573,
 -1,
 381294285,
 381167739,
 -1,
 381359817,
 381224868,
 -1,
 381425343,
 381324682,
 983554,
 381550591,
 381354042,
 -1,
 -59714,
 381433841,
 983556,
 -1,
 381489192,
 983558,
 381687490,
 381378126,
 -1,
 -59711,
 381649473,
 983584,
 -1,
 381685800,
 983582,
 381884101,
 381625783,
 -1,
 -59708,
 381846081,
 983588,
 -1,
 381882408,
 983586,
 382080712,
 381820685,
 -1,
 -59705,
 382030494,
 983560,
 -1,
 382082246,
 983562,
 -1,
 382041308,
 582,
 382342860,
 381302924,
 -1,
 -59701,
 382291265,
 42786,
 -1,
 382353889,
 42788,
 -1,
 382303801,
 42858,
 382605018,
 381255225,
 -1,
 382670549,
 382569259,
 -1,
 382736081,
 382602945,
 11375,
 -1,
 382685561,
 11376,
 -59694,
 382700500,
 581,
 -59693,
 382815050,
 42880,
 -59692,
 382878724,
 42878,
 -1,
 382941339,
 42893,
 383129303,
 382614783,
 42852,
 -1,
 383059653,
 42854,
 -59688,
 383096371,
 42792,
 -59687,
 383217840,
 42794,
 -1,
 383256640,
 574,
 383457000,
 382537409,
 -1,
 383522529,
 383387556,
 -1,
 383588063,
 383475278,
 -1,
 -59682,
 383550017,
 983580,
 -1,
 383586344,
 983578,
 -59680,
 383548636,
 570,
 -1,
 383734449,
 983552,
 383915747,
 383486932,
 42808,
 -1,
 383846610,
 42810,
 -59676,
 383882323,
 42812,
 -59675,
 384009803,
 42806,
 -59674,
 384064743,
 42804,
 -59673,
 384127353,
 11373,
 -1,
 384175809,
 42802,
 384374518,
 383401567,
 -1,
 384440048,
 384326565,
 -1,
 -59669,
 384400953,
 42886,
 -59668,
 384464270,
 42884,
 -59667,
 384527722,
 42882,
 -59666,
 384578762,
 42877,
 -59665,
 384643415,
 42875,
 -1,
 384705230,
 42873,
 384898805,
 384370596,
 -1,
 384964340,
 384851534,
 -1,
 -59661,
 384926273,
 983594,
 -1,
 384962600,
 983592,
 -1,
 384914097,
 983564,
 -1,
 384857486,
 42860,
 385292033,
 384331114,
 -1,
 385357567,
 385220608,
 -1,
 385423102,
 385323403,
 -1,
 385488636,
 385383993,
 -1,
 -59653,
 385433957,
 983602,
 -1,
 385487250,
 11364,
 -59651,
 385449180,
 588,
 -1,
 385637702,
 42918,
 -1,
 385381490,
 42842,
 -59648,
 385321140,
 42844,
 -1,
 385822697,
 42814,
 386012939,
 385254989,
 -1,
 386078474,
 385978763,
 -1,
 386144007,
 386028197,
 -1,
 -59643,
 386105921,
 983610,
 -59642,
 386152433,
 983576,
 -1,
 386207784,
 983608,
 386465791,
 386096718,
 -1,
 -59639,
 386368065,
 983606,
 -1,
 386404392,
 983604,
 -1,
 386013314,
 580,
 386668307,
 385971598,
 -1,
 386733840,
 386598820,
 -1,
 -59634,
 386698634,
 983574,
 -59633,
 386760117,
 11390,
 -1,
 386817350,
 42920,
 -59631,
 386683788,
 586,
 -59630,
 386939370,
 7838,
 -1,
 386994919,
 42891,
 387192605,
 386620647,
 -1,
 387258140,
 387123108,
 -1,
 387323673,
 387222922,
 983568,
 387448831,
 387252282,
 -1,
 -59624,
 387332081,
 983570,
 -1,
 387387432,
 983572,
 387645439,
 387272806,
 -1,
 -59621,
 387539279,
 42828,
 -1,
 387603000,
 42826,
 -1,
 387210471,
 42830,
 387847971,
 387140440,
 -1,
 -59617,
 387809857,
 983598,
 -59616,
 387864106,
 11362,
 -59615,
 387922801,
 42824,
 -59614,
 387983013,
 11360,
 -1,
 388044930,
 573,
 388241194,
 387795051,
 -1,
 388306726,
 388201692,
 42816,
 -1,
 388235344,
 42820,
 388437801,
 388244174,
 -1,
 -59608,
 388382394,
 42818,
 -1,
 388443695,
 11369,
 -1,
 388390214,
 42914,
 388699953,
 388176838,
 -1,
 388765485,
 388663026,
 42796,
 -1,
 388696066,
 42798,
 388896560,
 388695972,
 -1,
 -59601,
 388857052,
 571,
 -1,
 388896898,
 42898,
 -1,
 388849550,
 42862,
 389158710,
 388664276,
 -1,
 -59597,
 389125203,
 42848,
 -59596,
 389170595,
 42850,
 -59595,
 389229680,
 42856,
 -1,
 389285952,
 42846,
 389486396,
 389113655,
 -1,
 389551931,
 389445006,
 -1,
 389617466,
 389514380,
 11363,
 -1,
 389547717,
 42832,
 -1,
 389573981,
 42836,
 -1,
 389493626,
 42834,
 389879619,
 389435940,
 -1,
 389945152,
 389824449,
 -1,
 -59585,
 389909460,
 7932,
 -1,
 389959640,
 7930,
 390201343,
 389875620,
 -1,
 -59582,
 390103617,
 983600,
 -1,
 390151307,
 11374,
 390338377,
 389822619,
 -1,
 390403911,
 390268836,
 -1,
 -59578,
 390347915,
 42922,
 -1,
 390407217,
 11367,
 -59576,
 390343834,
 42790,
 -1,
 390533791,
 11381,
 390731597,
 390280394,
 -1,
 -59573,
 390680839,
 577,
 -59572,
 390740145,
 983198,
 -1,
 390793555,
 42912,
 390993744,
 390698549,
 -1,
 -59569,
 390954421,
 11391,
 -1,
 390997041,
 11371,
 391190355,
 390960265,
 -1,
 -59566,
 391150812,
 590,
 -1,
 391205073,
 7934,
 391386966,
 391146537,
 -1,
 -59563,
 391347477,
 42838,
 -1,
 391390385,
 42840,
 391583577,
 391338121,
 -1,
 -59560,
 391535942,
 42916,
 -1,
 391586865,
 42896,
 391780188,
 391530290,
 -1,
 -59557,
 391742017,
 983596,
 -1,
 391806172,
 584,
 391976799,
 391714805,
 -1,
 -59554,
 391935019,
 42822,
 -1,
 391973282,
 579,
 -1,
 391942052,
 11378,
 392238980,
 381177425,
 -1,
 392304514,
 392198599,
 -1,
 392370023,
 392265273,
 7451,
 392495103,
 392334123,
 -1,
 -59547,
 392392042,
 7450,
 -59546,
 392450596,
 43002,
 -1,
 392505467,
 11387,
 392697708,
 392326506,
 -1,
 392763243,
 392638432,
 -1,
 -59542,
 392719722,
 7449,
 -1,
 392779885,
 7438,
 -1,
 392726697,
 42870,
 393025391,
 392649959,
 7439,
 -59538,
 392988235,
 7445,
 -1,
 393046099,
 7440,
 393222002,
 392964219,
 7431,
 -59535,
 393189134,
 7459,
 -1,
 393248981,
 7430,
 393418612,
 393154241,
 7424,
 -1,
 393357435,
 7425,
 -59531,
 393385523,
 7458,
 -59530,
 393514860,
 7457,
 -59529,
 393579476,
 7456,
 -59528,
 393643595,
 7452,
 -59527,
 393704846,
 42801,
 -59526,
 393766659,
 7448,
 -59525,
 393826852,
 7437,
 -59524,
 393890656,
 7436,
 -59523,
 393955382,
 7435,
 -59522,
 394020656,
 7434,
 -59521,
 394080599,
 42800,
 -59520,
 394142414,
 7429,
 -59519,
 394206150,
 7428,
 -1,
 394270891,
 7427,
 -59517,
 392269440,
 7460,
 -1,
 394400179,
 7461,
 394657791,
 392179019,
 -1,
 394663816,
 394555632,
 -1,
 -59513,
 394618627,
 43004,
 -1,
 394670423,
 43003,
 394860427,
 394608223,
 -1,
 -59510,
 394812553,
 43005,
 -1,
 394855160,
 43006,
 -1,
 394794223,
 43007,
 395122585,
 361787666,
 -1,
 395188114,
 395074791,
 -1,
 395253649,
 395139488,
 -1,
 -59504,
 395211529,
 68415,
 -1,
 395257347,
 68413,
 -1,
 395210438,
 128310,
 395515797,
 395150731,
 -1,
 -59500,
 395473705,
 68414,
 -1,
 395519541,
 68412,
 395712408,
 395451012,
 -1,
 -59497,
 395650241,
 128311,
 -1,
 395714239,
 128309,
 -1,
 395669499,
 128308,
 395974562,
 395074803,
 -1,
 396040093,
 395921955,
 -1,
 -59492,
 395992285,
 3807,
 -1,
 396048247,
 3806,
 396236704,
 395981723,
 -1,
 -59489,
 396189582,
 983203,
 -1,
 396236738,
 983204,
 -59487,
 396194805,
 983205,
 -1,
 396382310,
 983206,
 396564389,
 395934740,
 -1,
 -59484,
 396530075,
 127772,
 -1,
 396590582,
 127767,
 -1,
 396503140,
 128030,
 396826960,
 361709151,
 -1,
 396892338,
 396777581,
 -1,
 396957873,
 396830843,
 -1,
 397023405,
 396891355,
 -1,
 397088826,
 396967890,
 -1,
 397154328,
 397023221,
 -1,
 397219834,
 397085603,
 -1,
 397285313,
 397151008,
 -1,
 397350834,
 397217136,
 -1,
 -59472,
 397300315,
 65669,
 -59471,
 397357416,
 65668,
 -1,
 397410743,
 65667,
 397612981,
 397282954,
 -1,
 -59468,
 397562416,
 65677,
 -1,
 397619548,
 65676,
 397809592,
 397545046,
 -1,
 -59465,
 397759017,
 65675,
 -1,
 397816194,
 65674,
 398006203,
 397741591,
 -1,
 -59462,
 397955646,
 65673,
 -1,
 398012791,
 65672,
 398202814,
 397938141,
 -1,
 -59459,
 398152277,
 65671,
 -1,
 398209378,
 65670,
 -59457,
 398134587,
 65666,
 -59456,
 398331037,
 65665,
 -1,
 398396231,
 65664,
 398596044,
 397217245,
 -1,
 -59453,
 398528138,
 65713,
 -59452,
 398593622,
 65712,
 -59451,
 398659095,
 65711,
 -59450,
 398724573,
 65710,
 -59449,
 398790000,
 65709,
 -59448,
 398855474,
 65708,
 -59447,
 398920921,
 65707,
 -59446,
 398986309,
 65706,
 -59445,
 399051683,
 65705,
 -1,
 399117088,
 65704,
 399316950,
 398528023,
 -1,
 -59442,
 399249034,
 65722,
 -59441,
 399314518,
 65721,
 -59440,
 399379991,
 65720,
 -59439,
 399445508,
 65719,
 -59438,
 399510834,
 65718,
 -59437,
 399576300,
 65717,
 -59436,
 399641651,
 65716,
 -59435,
 399707043,
 65715,
 -1,
 399772448,
 65714,
 399972319,
 399248752,
 -1,
 -59432,
 399904396,
 65703,
 -59431,
 399969878,
 65702,
 -59430,
 400035351,
 65701,
 -59429,
 400100658,
 65699,
 -59428,
 400166090,
 65698,
 -59427,
 400231475,
 65697,
 -59426,
 400296928,
 65696,
 -1,
 400362272,
 65695,
 400562151,
 399904342,
 -1,
 -59423,
 400494218,
 65729,
 -59422,
 400559472,
 65728,
 -59421,
 400624946,
 65727,
 -59420,
 400690378,
 65726,
 -59419,
 400755763,
 65725,
 -59418,
 400821155,
 65724,
 -1,
 400886560,
 65723,
 401086445,
 400493874,
 -1,
 -59415,
 401018333,
 65694,
 -59414,
 401083829,
 65693,
 -59413,
 401148979,
 65692,
 -59412,
 401214416,
 65691,
 -1,
 401279778,
 65690,
 401479667,
 401017907,
 -1,
 -59409,
 401411462,
 65682,
 -59408,
 401476873,
 65681,
 -59407,
 401542228,
 65680,
 -59406,
 401607597,
 65679,
 -1,
 401673070,
 65678,
 401872887,
 401411274,
 -1,
 -59403,
 401804339,
 65687,
 -59402,
 401869834,
 65686,
 -1,
 401935186,
 65685,
 402194431,
 401804938,
 -1,
 -59399,
 402066391,
 65731,
 -1,
 402131744,
 65730,
 402391039,
 397151283,
 -1,
 402397189,
 402263408,
 -1,
 -59395,
 402329226,
 65757,
 -59394,
 402394710,
 65756,
 -59393,
 402460183,
 65755,
 -59392,
 402525661,
 65754,
 -59391,
 402591088,
 65753,
 -59390,
 402656564,
 65752,
 -59389,
 402721994,
 65751,
 -59388,
 402787379,
 65750,
 -1,
 402852771,
 65749,
 403052558,
 402328882,
 -1,
 -59385,
 402984586,
 65748,
 -59384,
 403050070,
 65747,
 -59383,
 403115485,
 65745,
 -59382,
 403180912,
 65744,
 -59381,
 403246361,
 65743,
 -59380,
 403311669,
 65742,
 -59379,
 403377078,
 65741,
 -1,
 403442550,
 65740,
 403642389,
 402984138,
 -1,
 -59376,
 403574237,
 65739,
 -59375,
 403639602,
 65738,
 -59374,
 403705105,
 65737,
 -59373,
 403770419,
 65736,
 -59372,
 403835813,
 65735,
 -1,
 403901282,
 65734,
 404160511,
 403573811,
 -1,
 -59369,
 404032892,
 65733,
 -1,
 404097841,
 65732,
 404357119,
 397118923,
 -1,
 404363320,
 404229171,
 -1,
 404428837,
 404294563,
 -1,
 -59364,
 404360842,
 65778,
 -59363,
 404426326,
 65777,
 -59362,
 404491799,
 65776,
 -59361,
 404557277,
 65775,
 -59360,
 404622704,
 65774,
 -59359,
 404688178,
 65773,
 -59358,
 404753610,
 65772,
 -59357,
 404818995,
 65771,
 -59356,
 404884387,
 65770,
 -1,
 404949792,
 65769,
 405149744,
 404359968,
 -1,
 -59353,
 405081738,
 65768,
 -59352,
 405147222,
 65767,
 -59351,
 405212695,
 65766,
 -59350,
 405278173,
 65765,
 -59349,
 405343600,
 65764,
 -59348,
 405409074,
 65763,
 -59347,
 405474506,
 65762,
 -59346,
 405539891,
 65761,
 -59345,
 405605283,
 65760,
 -1,
 405670688,
 65759,
 405870647,
 405081139,
 -1,
 -59342,
 405802634,
 65784,
 -59341,
 405868118,
 65783,
 -59340,
 405933591,
 65782,
 -59339,
 405999069,
 65781,
 -59338,
 406064179,
 65780,
 -1,
 406129571,
 65779,
 -1,
 405802432,
 65785,
 -59335,
 404294949,
 65786,
 -1,
 406326300,
 65758,
 406526115,
 397049296,
 -1,
 406591632,
 406474732,
 -1,
 406657094,
 406523415,
 -1,
 -59330,
 406589043,
 65572,
 -59329,
 406654499,
 65551,
 -59328,
 406719987,
 65608,
 -59327,
 406785456,
 65592,
 -59326,
 406850907,
 65597,
 -59325,
 406916327,
 65558,
 -59324,
 406981724,
 65567,
 -59323,
 407047114,
 65603,
 -1,
 407112509,
 65554,
 407312464,
 406588784,
 -1,
 -59320,
 407244452,
 65586,
 -59319,
 407309950,
 65585,
 -59318,
 407375390,
 65546,
 -59317,
 407440806,
 65565,
 -59316,
 407506262,
 65591,
 -59315,
 407571716,
 65578,
 -59314,
 407637071,
 65564,
 -59313,
 407702469,
 65545,
 -1,
 407767896,
 65570,
 407967834,
 407243827,
 -1,
 -59310,
 407899801,
 65606,
 -59309,
 407965280,
 65538,
 -59308,
 408030772,
 65577,
 -59307,
 408096249,
 65580,
 -59306,
 408161650,
 65600,
 -59305,
 408227148,
 65562,
 -59304,
 408292596,
 65560,
 -59303,
 408357877,
 65573,
 -1,
 408423309,
 65599,
 408623204,
 407898912,
 -1,
 -59300,
 408555167,
 65582,
 -59299,
 408620632,
 65536,
 -59298,
 408686105,
 65543,
 -59297,
 408751593,
 65561,
 -59296,
 408817067,
 65589,
 -59295,
 408882513,
 65587,
 -59294,
 408947961,
 65566,
 -59293,
 409013390,
 65579,
 -1,
 409078720,
 65541,
 409278573,
 408554973,
 -1,
 -59290,
 409210537,
 65590,
 -59289,
 409276024,
 65610,
 -59288,
 409341487,
 65553,
 -59287,
 409406974,
 65611,
 -59286,
 409472405,
 65550,
 -59285,
 409537667,
 65607,
 -59284,
 409603052,
 65539,
 -1,
 409668445,
 65576,
 409868406,
 409210162,
 -1,
 -59281,
 409800301,
 65605,
 -59280,
 409865695,
 65547,
 -59279,
 409931152,
 65542,
 -59278,
 409996615,
 65552,
 -59277,
 410062028,
 65601,
 -59276,
 410127512,
 65594,
 -59275,
 410192895,
 65583,
 -1,
 410258312,
 65593,
 410458239,
 409799882,
 -1,
 -59272,
 410390164,
 65568,
 -59271,
 410455644,
 65537,
 -59270,
 410521145,
 65588,
 -59269,
 410586596,
 65549,
 -59268,
 410651902,
 65609,
 -59267,
 410717321,
 65574,
 -59266,
 410782714,
 65581,
 -1,
 410848077,
 65563,
 411048072,
 410389411,
 -1,
 -59263,
 410979908,
 65596,
 -59262,
 411045358,
 65571,
 -59261,
 411110817,
 65559,
 -59260,
 411176258,
 65544,
 -59259,
 411241698,
 65557,
 -59258,
 411307155,
 65584,
 -59257,
 411372528,
 65569,
 -1,
 411437930,
 65540,
 411637901,
 410979926,
 -1,
 -59254,
 411569726,
 65612,
 -59253,
 411635063,
 65602,
 -59252,
 411700199,
 65555,
 -1,
 411765570,
 65556,
 412024831,
 411569802,
 -1,
 -59249,
 411896836,
 65613,
 -1,
 411962155,
 65604,
 412221439,
 406541462,
 -1,
 412227734,
 412094038,
 -1,
 -59245,
 412159626,
 65629,
 -59244,
 412224989,
 65628,
 -59243,
 412290250,
 65627,
 -1,
 412355635,
 65626,
 412555417,
 412159453,
 -1,
 -59240,
 412486962,
 65624,
 -1,
 412552394,
 65623,
 412752028,
 412486962,
 -1,
 -59237,
 412683914,
 65621,
 -1,
 412749335,
 65620,
 412948639,
 412683171,
 -1,
 -59234,
 412880522,
 65617,
 -1,
 412946006,
 65616,
 -59232,
 412880467,
 65625,
 -59231,
 413076941,
 65622,
 -59230,
 413142316,
 65619,
 -1,
 413207727,
 65618,
 413466623,
 406476648,
 -1,
 413472940,
 413338531,
 -1,
 413538472,
 413404362,
 -1,
 -59225,
 413470106,
 65689,
 -1,
 413535441,
 65688,
 413735083,
 413469747,
 -1,
 -59222,
 413666916,
 65684,
 -1,
 413732392,
 65683,
 -1,
 413666768,
 65700,
 -1,
 413404338,
 65746,
 414121983,
 396951552,
 -1,
 414128304,
 414023401,
 983068,
 -1,
 414058045,
 983142,
 -1,
 414069300,
 983062,
 -1,
 396904546,
 128279,
 414390541,
 396841508,
 -1,
 414456076,
 414325602,
 -1,
 414521563,
 414404177,
 -1,
 414587065,
 414479758,
 -1,
 -59209,
 414545378,
 6426,
 -59208,
 414595249,
 6425,
 -1,
 414650049,
 6427,
 414849211,
 414553237,
 6421,
 -1,
 414799981,
 6410,
 414980286,
 414809657,
 -1,
 -59203,
 414922929,
 6412,
 -1,
 414977729,
 6411,
 415176897,
 414934787,
 -1,
 -59200,
 415119537,
 6417,
 -1,
 415174337,
 6416,
 415373508,
 415127661,
 -1,
 -59197,
 415315196,
 6405,
 -1,
 415370945,
 6415,
 415570119,
 415320118,
 -1,
 -59194,
 415512753,
 6402,
 -1,
 415567553,
 6401,
 415766730,
 415516464,
 -1,
 -59191,
 415709361,
 6409,
 -1,
 415764161,
 6408,
 415963341,
 415708362,
 -1,
 -59188,
 415905969,
 6404,
 -1,
 415960769,
 6403,
 416159952,
 415900366,
 -1,
 -59185,
 416102577,
 6414,
 -1,
 416157377,
 6413,
 416356563,
 416095174,
 -1,
 -59182,
 416299185,
 6407,
 -1,
 416353985,
 6406,
 416553174,
 416290805,
 -1,
 -59179,
 416495793,
 6419,
 -1,
 416550593,
 6418,
 -59177,
 416518067,
 6424,
 -59176,
 416705992,
 6422,
 -59175,
 416764541,
 6420,
 -59174,
 416828280,
 6423,
 -1,
 416889009,
 6428,
 417077488,
 414479758,
 -1,
 417143015,
 417026943,
 -1,
 417208544,
 417093741,
 -1,
 -59169,
 417150204,
 6449,
 -1,
 417205953,
 6452,
 -59167,
 417169071,
 6451,
 -59166,
 417361352,
 6455,
 -59165,
 417425218,
 6453,
 -59164,
 417485437,
 6454,
 -59163,
 417549176,
 6456,
 -59162,
 417613960,
 6448,
 -1,
 417666140,
 6450,
 417863916,
 417087773,
 -1,
 -59159,
 417822181,
 6459,
 -59158,
 417880017,
 6457,
 -59157,
 417943736,
 6464,
 -1,
 418007475,
 6458,
 418250751,
 417826577,
 -1,
 -59154,
 418157717,
 6441,
 -59153,
 418222003,
 6443,
 -1,
 418278856,
 6442,
 418453756,
 417042124,
 -1,
 418519291,
 418383439,
 -1,
 418584821,
 418451137,
 6432,
 -59148,
 418547275,
 6438,
 -1,
 418594399,
 6436,
 418781431,
 418536679,
 6440,
 -1,
 418733287,
 6437,
 418912505,
 418719867,
 6439,
 -1,
 418850939,
 6435,
 -59142,
 418874955,
 6434,
 -1,
 418987615,
 6433,
 -1,
 418449910,
 6400,
 419240202,
 418391280,
 -1,
 419305728,
 419200569,
 -1,
 -59137,
 419271314,
 6472,
 -1,
 419315038,
 6473,
 419502339,
 419263886,
 -1,
 -59134,
 419448537,
 6476,
 -1,
 419508096,
 6477,
 419698950,
 419443031,
 -1,
 -59131,
 419652730,
 6474,
 -1,
 419710600,
 6475,
 -59129,
 419665617,
 6470,
 -59128,
 419848190,
 6471,
 -59127,
 419912351,
 6479,
 -1,
 419965749,
 6478,
 -59125,
 419196184,
 6469,
 -1,
 420098121,
 6468,
 -1,
 414402114,
 13007,
 420354381,
 414350673,
 -1,
 420419914,
 420302417,
 -1,
 420485405,
 420380217,
 -1,
 420550936,
 420438018,
 -1,
 420616471,
 420501600,
 -1,
 -59117,
 420577782,
 42232,
 -59116,
 420632771,
 42236,
 -59115,
 420693941,
 42237,
 -59114,
 420750021,
 42234,
 -1,
 420813463,
 42235,
 -1,
 420567247,
 42233,
 421075227,
 420509070,
 -1,
 -59110,
 421017777,
 42206,
 -1,
 421072577,
 42205,
 -59108,
 421017777,
 42197,
 -1,
 421203649,
 42196,
 421402912,
 420447819,
 42228,
 -59105,
 421345435,
 42230,
 -1,
 421406843,
 42229,
 421599523,
 421369395,
 -1,
 -59102,
 421542065,
 42211,
 -1,
 421596865,
 42212,
 421796134,
 421557646,
 -1,
 -59099,
 421738673,
 42219,
 -1,
 421793473,
 42210,
 421992745,
 421750531,
 -1,
 -59096,
 421935281,
 42194,
 -1,
 421990081,
 42193,
 422189355,
 421944551,
 42227,
 -1,
 422127739,
 42231,
 422320430,
 422140013,
 -1,
 -59091,
 422262012,
 42213,
 -1,
 422317761,
 42208,
 422517041,
 422266934,
 -1,
 -59088,
 422459569,
 42200,
 -1,
 422514369,
 42199,
 422713652,
 422459547,
 -1,
 -59085,
 422656177,
 42216,
 -1,
 422710977,
 42214,
 422910263,
 422655178,
 -1,
 -59082,
 422852785,
 42221,
 -1,
 422907585,
 42198,
 423106873,
 422848635,
 42224,
 -1,
 423069259,
 42225,
 423237948,
 423043790,
 -1,
 -59077,
 423204419,
 42204,
 -1,
 423235265,
 42195,
 423434559,
 423173062,
 -1,
 -59074,
 423377073,
 42203,
 -1,
 423431873,
 42202,
 423631169,
 423366337,
 42222,
 -1,
 423569531,
 42223,
 -59070,
 423597205,
 42220,
 -59069,
 423728106,
 42215,
 -59068,
 423792563,
 42218,
 -59067,
 423842429,
 42207,
 -59066,
 423906168,
 42209,
 -59065,
 423970638,
 42201,
 -59064,
 424033887,
 42226,
 -59063,
 424096180,
 42217,
 -1,
 424155178,
 42192,
 424411135,
 420375496,
 -1,
 -59060,
 424293561,
 42239,
 -1,
 424353872,
 42238,
 -59058,
 420319038,
 8374,
 -59057,
 424504221,
 128132,
 -1,
 424556281,
 128648,
 424745460,
 396765307,
 -1,
 424810934,
 424699922,
 -1,
 424876424,
 424758865,
 -1,
 424941916,
 424836665,
 -1,
 425007447,
 424902201,
 -1,
 -59050,
 424949937,
 7246,
 -1,
 425004737,
 7245,
 425204058,
 424965518,
 -1,
 -59047,
 425146545,
 7192,
 -1,
 425201345,
 7191,
 -59045,
 425146545,
 7179,
 -1,
 425332417,
 7178,
 425531744,
 424896259,
 -1,
 -59042,
 425479032,
 7183,
 -59041,
 425539761,
 7184,
 -1,
 425594561,
 7182,
 425793892,
 425482349,
 -1,
 -59038,
 425759893,
 7177,
 -59037,
 425800956,
 7173,
 -1,
 425856705,
 7181,
 426056040,
 425740342,
 -1,
 -59034,
 426003320,
 7169,
 -59033,
 426064049,
 7170,
 -1,
 426118849,
 7168,
 426318188,
 425992910,
 -1,
 -59030,
 426284611,
 7193,
 -59029,
 426320683,
 7247,
 -1,
 426380993,
 7180,
 426580335,
 426276238,
 -1,
 -59026,
 426522801,
 7201,
 -1,
 426577601,
 7200,
 426776946,
 426529316,
 -1,
 -59023,
 426724216,
 7190,
 -1,
 426774209,
 7189,
 426973557,
 426719387,
 -1,
 -59020,
 426920824,
 7198,
 -1,
 426970817,
 7197,
 427170168,
 426915018,
 -1,
 -59017,
 427117432,
 7172,
 -1,
 427167425,
 7171,
 427366779,
 427110743,
 -1,
 -59014,
 427314040,
 7186,
 -1,
 427364033,
 7185,
 427563390,
 427301830,
 -1,
 -59011,
 427505841,
 7175,
 -1,
 427560641,
 7174,
 427760001,
 427497461,
 -1,
 -59008,
 427707256,
 7188,
 -1,
 427757249,
 7187,
 -59006,
 427725973,
 7194,
 -59005,
 427921331,
 7202,
 -59004,
 427985898,
 7199,
 -59003,
 428043720,
 7195,
 -59002,
 428100472,
 7196,
 -59001,
 428164942,
 7176,
 -1,
 428216001,
 7203,
 428415382,
 424813808,
 -1,
 428480908,
 428375609,
 -1,
 -58997,
 428446354,
 7234,
 -1,
 428490078,
 7235,
 428677519,
 428438926,
 -1,
 -58994,
 428623577,
 7238,
 -1,
 428683136,
 7239,
 428874130,
 428618071,
 -1,
 -58991,
 428827770,
 7236,
 -1,
 428885640,
 7237,
 -58989,
 428840657,
 7232,
 -58988,
 429023230,
 7233,
 -58987,
 429087391,
 7241,
 -1,
 429140789,
 7240,
 429332896,
 428351618,
 -1,
 429398425,
 429283437,
 7216,
 -1,
 429364580,
 7220,
 429529499,
 429344822,
 7213,
 -1,
 429462464,
 7221,
 -58980,
 429489721,
 7219,
 -58979,
 429616490,
 7218,
 -58978,
 429680387,
 7217,
 -58977,
 429740580,
 7214,
 -1,
 429804362,
 7215,
 429988264,
 429297403,
 -1,
 430053795,
 429950539,
 7210,
 -1,
 430016075,
 7211,
 430184869,
 430005479,
 7208,
 -1,
 430136551,
 7209,
 -58970,
 430128735,
 7207,
 -58969,
 430254203,
 7212,
 -1,
 430313274,
 7206,
 430512559,
 429943752,
 -1,
 430578093,
 430472761,
 -1,
 430643628,
 430536748,
 7231,
 -1,
 430571779,
 7230,
 -1,
 430575395,
 7227,
 -58962,
 430529723,
 7228,
 -1,
 430775701,
 7229,
 431030271,
 430470542,
 -1,
 431036851,
 430933777,
 -1,
 -58958,
 431002773,
 7204,
 -1,
 431058376,
 7205,
 431292415,
 430981405,
 -1,
 -58955,
 431189685,
 7222,
 -1,
 431250469,
 7223,
 431430128,
 424752242,
 -1,
 431495637,
 431394769,
 -1,
 431561160,
 431429034,
 -1,
 431626690,
 431526283,
 -1,
 431692225,
 431586873,
 -1,
 431757758,
 431637764,
 -1,
 -58947,
 431721118,
 11025,
 -1,
 431761281,
 11024,
 432013311,
 431690134,
 -1,
 -58944,
 431918494,
 11065,
 -1,
 431957819,
 11066,
 -1,
 431629942,
 11064,
 432216519,
 431558582,
 -1,
 432282054,
 432173287,
 -1,
 -58939,
 432243271,
 11083,
 -1,
 432280257,
 11074,
 -1,
 432214721,
 11082,
 -1,
 432177624,
 11070,
 432609747,
 431523372,
 -1,
 432675282,
 432543146,
 -1,
 432740817,
 432640395,
 -1,
 432806351,
 432701216,
 11067,
 432930815,
 432736164,
 -1,
 -58930,
 432835998,
 11068,
 -1,
 432875323,
 11069,
 -58928,
 432770462,
 11060,
 -1,
 433006395,
 11061,
 -1,
 432682074,
 11062,
 -1,
 432637050,
 11063,
 -58924,
 432565379,
 11077,
 -1,
 433265182,
 11013,
 433461739,
 431423488,
 -1,
 433527258,
 433419662,
 -1,
 -58920,
 433489859,
 11778,
 -58919,
 433537020,
 11814,
 -1,
 433588932,
 10181,
 433789407,
 433483114,
 -1,
 433854942,
 433733831,
 -1,
 -58915,
 433819814,
 11012,
 -1,
 433855006,
 11020,
 -1,
 433787319,
 11788,
 434117090,
 433736522,
 -1,
 -58911,
 434079781,
 128709,
 -1,
 434136700,
 11804,
 434313701,
 434054532,
 -1,
 -58908,
 434276171,
 11816,
 -1,
 434341052,
 11780,
 434510312,
 434247089,
 -1,
 -58905,
 434469351,
 11056,
 -1,
 434511581,
 11058,
 -58903,
 434474339,
 11808,
 -58902,
 434668465,
 11785,
 -1,
 434708366,
 9948,
 434962431,
 433392094,
 -1,
 434969070,
 434844103,
 4054,
 -1,
 434899057,
 4056,
 -58897,
 434924106,
 128269,
 -1,
 435042662,
 9958,
 -58895,
 431382887,
 128006,
 -58894,
 435181402,
 127819,
 -58893,
 435233897,
 128210,
 -1,
 435294460,
 127811,
 435493424,
 424711251,
 -1,
 435558931,
 435429017,
 -1,
 435624441,
 435519033,
 66199,
 -58888,
 435584569,
 66200,
 -1,
 435632283,
 66185,
 435821051,
 435574893,
 66191,
 -1,
 435771501,
 66193,
 435952125,
 435769892,
 66190,
 -1,
 435900964,
 66192,
 436083199,
 435898422,
 66187,
 -1,
 436029494,
 66196,
 436214273,
 436021371,
 66177,
 -1,
 436164717,
 66202,
 436345347,
 436148213,
 66178,
 -1,
 436287643,
 66179,
 436476421,
 436276929,
 66176,
 -1,
 436426861,
 66201,
 -58874,
 436442675,
 66184,
 -58873,
 436573087,
 66204,
 -58872,
 436637548,
 66183,
 -58871,
 436700747,
 66194,
 -58870,
 436761998,
 66198,
 -58869,
 436825450,
 66197,
 -58868,
 436890663,
 66188,
 -58867,
 436954883,
 66195,
 -58866,
 437013322,
 66189,
 -58865,
 437077808,
 66186,
 -58864,
 437141087,
 66182,
 -58863,
 437205147,
 66203,
 -58862,
 437269706,
 66180,
 -1,
 437330638,
 66181,
 437583871,
 435496146,
 -1,
 437590575,
 437472849,
 -1,
 437656087,
 437550649,
 67887,
 -1,
 437616185,
 67892,
 437787161,
 437613966,
 67891,
 -1,
 437745038,
 67886,
 437918235,
 437737581,
 67883,
 -1,
 437868653,
 67896,
 438049309,
 437865290,
 67881,
 -1,
 438015059,
 67895,
 438180383,
 437987451,
 67876,
 -1,
 438130797,
 67894,
 438311457,
 438111937,
 67872,
 -1,
 438261869,
 67893,
 -58846,
 438277203,
 67879,
 -58845,
 438406100,
 67877,
 -58844,
 438470219,
 67888,
 -58843,
 438529386,
 67885,
 -58842,
 438594599,
 67890,
 -58841,
 438656231,
 67884,
 -58840,
 438719012,
 67882,
 -58839,
 438782006,
 67880,
 -58838,
 438845023,
 67878,
 -58837,
 438908106,
 67874,
 -58836,
 438972759,
 67889,
 -58835,
 439034574,
 67875,
 -58834,
 439098310,
 67897,
 -1,
 439162869,
 67873,
 -1,
 437552200,
 67903,
 439425599,
 435444967,
 -1,
 439491126,
 439361343,
 128274,
 439556661,
 439436099,
 -1,
 -58828,
 439523025,
 983079,
 -1,
 439574526,
 983076,
 -1,
 439486732,
 128271,
 439818809,
 439454892,
 -1,
 -58824,
 439766602,
 128140,
 -1,
 439827750,
 127977,
 440015420,
 439769652,
 -1,
 -58821,
 439963110,
 11059,
 -1,
 440018284,
 10188,
 -58819,
 439979886,
 128261,
 -58818,
 440174574,
 128557,
 -1,
 440225838,
 127853,
 440408643,
 439381354,
 -1,
 -58815,
 440360167,
 983220,
 -58814,
 440422948,
 983215,
 -1,
 440477819,
 983217,
 -1,
 440349015,
 983065,
 440737268,
 361663444,
 -1,
 440802466,
 440667841,
 -1,
 440867745,
 440745569,
 -1,
 440933264,
 440827344,
 -1,
 440998781,
 440881124,
 -1,
 441064060,
 440948845,
 -1,
 441129559,
 441005258,
 42507,
 441195092,
 441070794,
 -1,
 441260623,
 441133179,
 42500,
 -58802,
 441210989,
 42501,
 -1,
 441264251,
 42271,
 441457233,
 441212135,
 42460,
 -1,
 441408743,
 42384,
 -58798,
 441419339,
 42421,
 -58797,
 441531999,
 42308,
 -1,
 441585345,
 42348,
 -58795,
 441147278,
 42428,
 -58794,
 441723901,
 42467,
 -1,
 441783079,
 42315,
 441981541,
 441066190,
 -1,
 442047072,
 441933031,
 42450,
 442112607,
 441994489,
 -1,
 -58789,
 442071788,
 42514,
 -58788,
 442126973,
 42538,
 -58787,
 442189960,
 42513,
 -58786,
 442249652,
 42512,
 -1,
 442312068,
 42539,
 -1,
 442064103,
 42374,
 442571362,
 441985147,
 42490,
 -1,
 442509435,
 42261,
 -58781,
 442533451,
 42411,
 -58780,
 442646111,
 42298,
 -1,
 442699457,
 42337,
 442899053,
 441947219,
 -1,
 442964584,
 442850535,
 42464,
 -1,
 442916071,
 42388,
 443095658,
 442902651,
 42506,
 -1,
 443033723,
 42275,
 -58773,
 443057739,
 42425,
 -58772,
 443170399,
 42312,
 -1,
 443223745,
 42352,
 443423349,
 442844976,
 -1,
 443488880,
 443374823,
 42457,
 -1,
 443440359,
 42381,
 443619954,
 443426939,
 42497,
 -1,
 443558011,
 42268,
 -58765,
 443582027,
 42418,
 -58764,
 443694687,
 42305,
 -1,
 443748033,
 42344,
 443947639,
 443374823,
 42463,
 -1,
 443899111,
 42387,
 444078713,
 443885691,
 42505,
 -1,
 444016763,
 42274,
 -58758,
 444040779,
 42424,
 -58757,
 444153439,
 42311,
 -1,
 444206785,
 42351,
 444406420,
 441012772,
 -1,
 444471941,
 444347834,
 -1,
 444537472,
 444423399,
 42438,
 -1,
 444488935,
 42363,
 444668546,
 444475515,
 42478,
 -1,
 444606587,
 42250,
 -58749,
 444630603,
 42400,
 -58748,
 444743263,
 42287,
 -1,
 444796609,
 42326,
 444996237,
 444405749,
 -1,
 445061768,
 444947687,
 42436,
 -1,
 445013223,
 42361,
 445192842,
 444999803,
 42475,
 -1,
 445130875,
 42248,
 -58741,
 445154891,
 42398,
 -58740,
 445267551,
 42285,
 -1,
 445320897,
 42323,
 445520527,
 444947687,
 42462,
 -1,
 445471975,
 42386,
 445651601,
 445458555,
 42504,
 -1,
 445589627,
 42273,
 -58734,
 445613643,
 42423,
 -58733,
 445726303,
 42310,
 -1,
 445779649,
 42350,
 445979308,
 444342990,
 -1,
 446044837,
 445921435,
 -1,
 446110366,
 445986971,
 -1,
 446175897,
 446061799,
 42446,
 -1,
 446127335,
 42370,
 446306971,
 446113915,
 42486,
 -1,
 446244987,
 42257,
 -58724,
 446269003,
 42407,
 -58723,
 446381663,
 42294,
 -1,
 446435009,
 42333,
 446634656,
 446061799,
 42445,
 -1,
 446586087,
 42369,
 446765730,
 446572667,
 42485,
 -1,
 446703739,
 42256,
 -58717,
 446727755,
 42406,
 -58716,
 446840415,
 42293,
 -1,
 446893761,
 42332,
 447093415,
 445996263,
 42449,
 -1,
 447044839,
 42373,
 447224489,
 447031419,
 42489,
 -1,
 447162491,
 42260,
 -58710,
 447186507,
 42410,
 -58709,
 447299167,
 42297,
 -1,
 447352513,
 42336,
 447552191,
 445925430,
 -1,
 447617719,
 447506179,
 -1,
 447683249,
 447555707,
 42476,
 -58704,
 447633517,
 42477,
 -1,
 447686779,
 42249,
 447879859,
 447634663,
 42437,
 -1,
 447831271,
 42362,
 448010933,
 447811265,
 42324,
 -1,
 447961197,
 42325,
 -58698,
 447972939,
 42399,
 -1,
 448085599,
 42286,
 448273081,
 447569127,
 42459,
 -1,
 448224487,
 42383,
 448404155,
 448211067,
 42499,
 -1,
 448342139,
 42270,
 448535229,
 448335553,
 42346,
 -1,
 448485485,
 42347,
 -58690,
 448497227,
 42420,
 -1,
 448609887,
 42307,
 448797394,
 447493322,
 -1,
 448862922,
 448731125,
 -1,
 448928452,
 448814311,
 42439,
 -58685,
 448879847,
 42364,
 -1,
 448944237,
 42440,
 449125063,
 448866427,
 42479,
 -58682,
 449075309,
 42480,
 -1,
 449128571,
 42251,
 -58680,
 449087051,
 42401,
 -58679,
 449265247,
 42288,
 -1,
 449318593,
 42327,
 449518285,
 448800891,
 42502,
 -58676,
 449468525,
 42503,
 -1,
 449521787,
 42272,
 449714895,
 449469671,
 42461,
 -1,
 449666279,
 42385,
 -58672,
 449676875,
 42422,
 -58671,
 449789535,
 42309,
 -1,
 449842881,
 42349,
 450042594,
 448763443,
 -1,
 450108123,
 449984667,
 -1,
 450173654,
 450059495,
 42454,
 -1,
 450125031,
 42378,
 450304728,
 450111611,
 42494,
 -1,
 450242683,
 42265,
 -58663,
 450266699,
 42415,
 -58662,
 450379359,
 42302,
 -1,
 450432705,
 42341,
 450632413,
 450059495,
 42453,
 -1,
 450583783,
 42377,
 450763487,
 450570363,
 42493,
 -1,
 450701435,
 42264,
 -58656,
 450725451,
 42414,
 -58655,
 450838111,
 42301,
 -1,
 450891457,
 42340,
 451091185,
 450006892,
 -1,
 451156711,
 451042535,
 42431,
 451222246,
 451108071,
 42356,
 -1,
 451172461,
 42357,
 -1,
 451172461,
 42432,
 451418859,
 451094651,
 42470,
 451484394,
 451356795,
 42243,
 -1,
 451434605,
 42244,
 -1,
 451434605,
 42471,
 451681005,
 451380811,
 42393,
 -1,
 451631213,
 42394,
 451812079,
 451624543,
 42280,
 -1,
 451762285,
 42281,
 452001791,
 451743425,
 42318,
 -1,
 451893357,
 42319,
 452074241,
 451051065,
 -1,
 452139770,
 452016283,
 -1,
 452205301,
 452091111,
 42444,
 -1,
 452156647,
 42368,
 452336375,
 452143227,
 42484,
 -1,
 452274299,
 42255,
 -58632,
 452298315,
 42405,
 -58631,
 452410975,
 42292,
 -1,
 452464321,
 42331,
 452664060,
 452091111,
 42443,
 -1,
 452615399,
 42367,
 452795134,
 452601979,
 42483,
 -1,
 452733051,
 42254,
 -58625,
 452757067,
 42404,
 -58624,
 452869727,
 42291,
 -1,
 452923073,
 42330,
 453122833,
 452031886,
 -1,
 453188362,
 453064859,
 -1,
 453253893,
 453139687,
 42452,
 -1,
 453205223,
 42376,
 453384967,
 453191803,
 42492,
 -1,
 453322875,
 42263,
 -58616,
 453346891,
 42413,
 -58615,
 453459551,
 42300,
 -1,
 453512897,
 42339,
 453712652,
 453139687,
 42451,
 -1,
 453663975,
 42375,
 453843726,
 453650555,
 42491,
 -1,
 453781627,
 42262,
 -58609,
 453805643,
 42412,
 -58608,
 453918303,
 42299,
 -1,
 453971649,
 42338,
 454171425,
 453056501,
 -1,
 454236954,
 454113435,
 -1,
 454302485,
 454188263,
 42434,
 -1,
 454253799,
 42359,
 454433559,
 454240379,
 42473,
 -1,
 454371451,
 42246,
 -58600,
 454395467,
 42396,
 -58599,
 454508127,
 42283,
 -1,
 454561473,
 42321,
 454761244,
 454188263,
 42435,
 -1,
 454712551,
 42360,
 454892318,
 454699131,
 42474,
 -1,
 454830203,
 42247,
 -58593,
 454854219,
 42397,
 -58592,
 454966879,
 42284,
 -1,
 455020225,
 42322,
 455220014,
 454113435,
 -1,
 455285541,
 455171303,
 42429,
 -58588,
 455236839,
 42355,
 -1,
 455301229,
 42430,
 455482152,
 455223419,
 42468,
 -58585,
 455432301,
 42469,
 -1,
 455485563,
 42242,
 455678762,
 455444043,
 42391,
 -1,
 455628909,
 42392,
 455809836,
 455622239,
 42278,
 -1,
 455759981,
 42279,
 455999487,
 455741121,
 42316,
 -1,
 455891053,
 42317,
 456071991,
 455166794,
 -1,
 456137522,
 456009851,
 42487,
 -58575,
 456088156,
 42508,
 -1,
 456140923,
 42258,
 456334132,
 456088807,
 42447,
 -1,
 456285415,
 42371,
 -58571,
 456296011,
 42408,
 -58570,
 456408671,
 42295,
 -1,
 456462017,
 42334,
 456661823,
 456037459,
 -1,
 456727354,
 456613095,
 42458,
 -1,
 456678631,
 42382,
 456858428,
 456665211,
 42498,
 -1,
 456796283,
 42269,
 -58563,
 456820299,
 42419,
 -58562,
 456932959,
 42306,
 -1,
 456986305,
 42345,
 457186119,
 456625108,
 -1,
 457251650,
 457137383,
 42442,
 -1,
 457202919,
 42366,
 457382724,
 457189499,
 42482,
 -1,
 457320571,
 42253,
 -58555,
 457344587,
 42403,
 -58554,
 457457247,
 42290,
 -1,
 457510593,
 42329,
 457710415,
 457141610,
 -1,
 457775946,
 457661671,
 42448,
 -1,
 457727207,
 42372,
 457907020,
 457713787,
 42488,
 -1,
 457844859,
 42259,
 -58547,
 457868875,
 42409,
 -58546,
 457981535,
 42296,
 -1,
 458034881,
 42335,
 458234711,
 457664259,
 -1,
 458300242,
 458185959,
 42433,
 -1,
 458251495,
 42358,
 458431316,
 458238075,
 42472,
 -1,
 458369147,
 42245,
 -58539,
 458393163,
 42395,
 -58538,
 458505823,
 42282,
 -1,
 458559169,
 42320,
 458759007,
 458180400,
 -1,
 458824538,
 458710247,
 42456,
 -1,
 458775783,
 42380,
 458955612,
 458762363,
 42496,
 -1,
 458893435,
 42267,
 -58531,
 458917451,
 42417,
 -58530,
 459030111,
 42304,
 -1,
 459083457,
 42343,
 459283303,
 458699095,
 -1,
 459348834,
 459234535,
 42441,
 -1,
 459300071,
 42365,
 459479908,
 459286651,
 42481,
 -1,
 459417723,
 42252,
 -58523,
 459441739,
 42402,
 -58522,
 459554399,
 42289,
 -1,
 459607745,
 42328,
 459807599,
 459217862,
 -1,
 459873130,
 459758823,
 42455,
 -1,
 459824359,
 42379,
 460004204,
 459810939,
 42495,
 -1,
 459942011,
 42266,
 -58515,
 459966027,
 42416,
 -58514,
 460078687,
 42303,
 -1,
 460132033,
 42342,
 460331891,
 459758823,
 42426,
 460397426,
 460283111,
 42353,
 -1,
 460347501,
 42354,
 -1,
 460347501,
 42427,
 460594039,
 460269691,
 42465,
 460659574,
 460531835,
 42240,
 -1,
 460609645,
 42241,
 -1,
 460609645,
 42466,
 460856185,
 460555851,
 42389,
 -1,
 460806253,
 42390,
 460987259,
 460799583,
 42276,
 -1,
 460937325,
 42277,
 461176831,
 460918465,
 42313,
 -1,
 461068397,
 42314,
 461307903,
 440947856,
 -1,
 461314946,
 461209145,
 -1,
 -58496,
 461267068,
 42525,
 -58495,
 461324950,
 42517,
 -1,
 461377338,
 42521,
 461577095,
 461251278,
 -1,
 461642630,
 461528295,
 -1,
 -58491,
 461594748,
 42523,
 -1,
 461638274,
 42526,
 -1,
 461575104,
 42522,
 461904778,
 461522998,
 -1,
 -58487,
 461867371,
 42524,
 -1,
 461908649,
 42516,
 462101389,
 461844823,
 -1,
 -58484,
 462039721,
 42515,
 -1,
 462098234,
 42520,
 -58482,
 462051995,
 42518,
 -58481,
 462243840,
 42527,
 -1,
 462297201,
 42519,
 462494622,
 440870128,
 -1,
 462560148,
 462454329,
 -1,
 -58477,
 462525074,
 42530,
 -1,
 462568798,
 42531,
 462756759,
 462517646,
 -1,
 -58474,
 462702297,
 42534,
 -1,
 462761856,
 42535,
 462953370,
 462696791,
 -1,
 -58471,
 462906490,
 42532,
 -1,
 462964360,
 42533,
 -58469,
 462919377,
 42528,
 -58468,
 463101950,
 42529,
 -58467,
 463166111,
 42537,
 -1,
 463219509,
 42536,
 -58465,
 462449944,
 42511,
 -58464,
 463353017,
 42510,
 -1,
 463413328,
 42509,
 463667199,
 440824173,
 -1,
 463674385,
 463539107,
 -1,
 463739822,
 463605386,
 917762,
 -58459,
 463670922,
 917942,
 -58458,
 463736406,
 917941,
 -58457,
 463801879,
 917940,
 -58456,
 463867357,
 917939,
 -58455,
 463932784,
 917938,
 -58454,
 463998258,
 917937,
 -58453,
 464063690,
 917936,
 -58452,
 464129075,
 917935,
 -58451,
 464194467,
 917934,
 -1,
 464259872,
 917933,
 464460729,
 463670870,
 917761,
 -58448,
 464391818,
 917932,
 -58447,
 464457302,
 917931,
 -58446,
 464522775,
 917930,
 -58445,
 464588253,
 917929,
 -58444,
 464653680,
 917928,
 -58443,
 464719154,
 917927,
 -58442,
 464784586,
 917926,
 -58441,
 464849971,
 917925,
 -58440,
 464915363,
 917924,
 -1,
 464980768,
 917923,
 465181636,
 464391703,
 917760,
 -58437,
 465112714,
 917922,
 -58436,
 465178198,
 917921,
 -58435,
 465243671,
 917920,
 -58434,
 465309149,
 917919,
 -58433,
 465374576,
 917918,
 -58432,
 465440050,
 917917,
 -58431,
 465505482,
 917916,
 -58430,
 465570867,
 917915,
 -58429,
 465636259,
 917914,
 -1,
 465701664,
 917913,
 465902543,
 465112541,
 -1,
 -58426,
 465833610,
 917912,
 -58425,
 465899094,
 917911,
 -58424,
 465964567,
 917910,
 -58423,
 466030045,
 917909,
 -58422,
 466095472,
 917908,
 -58421,
 466160946,
 917907,
 -58420,
 466226378,
 917906,
 -58419,
 466291763,
 917905,
 -58418,
 466357155,
 917904,
 -1,
 466422560,
 917903,
 466623450,
 465833328,
 -1,
 -58415,
 466554506,
 917902,
 -58414,
 466619990,
 917901,
 -58413,
 466685463,
 917900,
 -58412,
 466750941,
 917899,
 -58411,
 466816368,
 917898,
 -58410,
 466881842,
 917897,
 -58409,
 466947274,
 917896,
 -58408,
 467012659,
 917895,
 -58407,
 467078051,
 917894,
 -1,
 467143456,
 917893,
 467344357,
 466554162,
 -1,
 -58404,
 467275402,
 917892,
 -58403,
 467340886,
 917891,
 -58402,
 467406359,
 917890,
 -58401,
 467471837,
 917889,
 -58400,
 467537264,
 917888,
 -58399,
 467602738,
 917887,
 -58398,
 467668170,
 917886,
 -58397,
 467733555,
 917885,
 -58396,
 467798947,
 917884,
 -1,
 467864352,
 917883,
 468065264,
 467274954,
 -1,
 -58393,
 467996298,
 917882,
 -58392,
 468061782,
 917881,
 -58391,
 468127255,
 917880,
 -58390,
 468192733,
 917879,
 -58389,
 468258160,
 917878,
 -58388,
 468323634,
 917877,
 -58387,
 468389066,
 917876,
 -58386,
 468454451,
 917875,
 -58385,
 468519843,
 917874,
 -1,
 468585248,
 917873,
 468786171,
 467995699,
 -1,
 -58382,
 468717194,
 917872,
 -58381,
 468782678,
 917871,
 -58380,
 468848151,
 917870,
 -58379,
 468913629,
 917869,
 -58378,
 468979056,
 917868,
 -58377,
 469044530,
 917867,
 -58376,
 469109962,
 917866,
 -58375,
 469175347,
 917865,
 -58374,
 469240739,
 917864,
 -1,
 469306144,
 917863,
 469507078,
 468716451,
 -1,
 -58371,
 469438090,
 917862,
 -58370,
 469503574,
 917861,
 -58369,
 469569047,
 917860,
 -58368,
 469634525,
 917859,
 -58367,
 469699952,
 917858,
 -58366,
 469765426,
 917857,
 -58365,
 469830858,
 917856,
 -58364,
 469896243,
 917855,
 -58363,
 469961635,
 917854,
 -1,
 470027040,
 917853,
 470286335,
 469437216,
 -1,
 -58360,
 470158986,
 917852,
 -58359,
 470224470,
 917851,
 -58358,
 470289943,
 917850,
 -58357,
 470355421,
 917849,
 -58356,
 470420848,
 917848,
 -58355,
 470486322,
 917847,
 -58354,
 470551754,
 917846,
 -58353,
 470617139,
 917845,
 -58352,
 470682531,
 917844,
 -1,
 470747936,
 917843,
 470948949,
 463604787,
 -1,
 471014429,
 470879538,
 917767,
 -58348,
 470945418,
 917992,
 -58347,
 471010902,
 917991,
 -58346,
 471076375,
 917990,
 -58345,
 471141853,
 917989,
 -58344,
 471207280,
 917988,
 -58343,
 471272754,
 917987,
 -58342,
 471338186,
 917986,
 -58341,
 471403571,
 917985,
 -58340,
 471468963,
 917984,
 -1,
 471534368,
 917983,
 471735336,
 470944970,
 917766,
 -58337,
 471666314,
 917982,
 -58336,
 471731798,
 917981,
 -58335,
 471797271,
 917980,
 -58334,
 471862749,
 917979,
 -58333,
 471928176,
 917978,
 -58332,
 471993650,
 917977,
 -58331,
 472059082,
 917976,
 -58330,
 472124467,
 917975,
 -58329,
 472189859,
 917974,
 -1,
 472255264,
 917973,
 472456243,
 471665715,
 917765,
 -58326,
 472387210,
 917972,
 -58325,
 472452694,
 917971,
 -58324,
 472518167,
 917970,
 -58323,
 472583645,
 917969,
 -58322,
 472649072,
 917968,
 -58321,
 472714546,
 917967,
 -58320,
 472779978,
 917966,
 -58319,
 472845363,
 917965,
 -58318,
 472910755,
 917964,
 -1,
 472976160,
 917963,
 473177150,
 472386467,
 917764,
 -58315,
 473108106,
 917962,
 -58314,
 473173590,
 917961,
 -58313,
 473239063,
 917960,
 -58312,
 473304541,
 917959,
 -58311,
 473369968,
 917958,
 -58310,
 473435442,
 917957,
 -58309,
 473500874,
 917956,
 -58308,
 473566259,
 917955,
 -58307,
 473631651,
 917954,
 -1,
 473697056,
 917953,
 473898057,
 473107232,
 917763,
 -58304,
 473829002,
 917952,
 -58303,
 473894486,
 917951,
 -58302,
 473959959,
 917950,
 -58301,
 474025437,
 917949,
 -58300,
 474090864,
 917948,
 -58299,
 474156338,
 917947,
 -58298,
 474221770,
 917946,
 -58297,
 474287155,
 917945,
 -58296,
 474352547,
 917944,
 -1,
 474417952,
 917943,
 474618961,
 473828720,
 917768,
 -58293,
 474549725,
 917999,
 -58292,
 474615152,
 917998,
 -58291,
 474680626,
 917997,
 -58290,
 474746058,
 917996,
 -58289,
 474811443,
 917995,
 -58288,
 474876835,
 917994,
 -1,
 474942240,
 917993,
 -58286,
 474549898,
 917772,
 -58285,
 475074134,
 917771,
 -58284,
 475139607,
 917770,
 -1,
 475205085,
 917769,
 475405408,
 470879882,
 -1,
 -58281,
 475336330,
 917842,
 -58280,
 475401814,
 917841,
 -58279,
 475467287,
 917840,
 -58278,
 475532765,
 917839,
 -58277,
 475598192,
 917838,
 -58276,
 475663666,
 917837,
 -58275,
 475729098,
 917836,
 -58274,
 475794483,
 917835,
 -58273,
 475859875,
 917834,
 -1,
 475925280,
 917833,
 476126315,
 475336278,
 -1,
 -58270,
 476057226,
 917832,
 -58269,
 476122710,
 917831,
 -58268,
 476188183,
 917830,
 -58267,
 476253661,
 917829,
 -58266,
 476319088,
 917828,
 -58265,
 476384562,
 917827,
 -58264,
 476449994,
 917826,
 -58263,
 476515379,
 917825,
 -58262,
 476580771,
 917824,
 -1,
 476646176,
 917823,
 476847222,
 476057111,
 -1,
 -58259,
 476778122,
 917822,
 -58258,
 476843606,
 917821,
 -58257,
 476909079,
 917820,
 -58256,
 476974557,
 917819,
 -58255,
 477039984,
 917818,
 -58254,
 477105458,
 917817,
 -58253,
 477170890,
 917816,
 -58252,
 477236275,
 917815,
 -58251,
 477301667,
 917814,
 -1,
 477367072,
 917813,
 477568129,
 476777949,
 -1,
 -58248,
 477499018,
 917812,
 -58247,
 477564502,
 917811,
 -58246,
 477629975,
 917810,
 -58245,
 477695453,
 917809,
 -58244,
 477760880,
 917808,
 -58243,
 477826354,
 917807,
 -58242,
 477891786,
 917806,
 -58241,
 477957171,
 917805,
 -58240,
 478022563,
 917804,
 -1,
 478087968,
 917803,
 478289036,
 477498736,
 -1,
 -58237,
 478219914,
 917802,
 -58236,
 478285398,
 917801,
 -58235,
 478350871,
 917800,
 -58234,
 478416349,
 917799,
 -58233,
 478481776,
 917798,
 -58232,
 478547250,
 917797,
 -58231,
 478612682,
 917796,
 -58230,
 478678067,
 917795,
 -58229,
 478743459,
 917794,
 -1,
 478808864,
 917793,
 479009943,
 478219570,
 -1,
 -58226,
 478940810,
 917792,
 -58225,
 479006294,
 917791,
 -58224,
 479071767,
 917790,
 -58223,
 479137245,
 917789,
 -58222,
 479202672,
 917788,
 -58221,
 479268146,
 917787,
 -58220,
 479333578,
 917786,
 -58219,
 479398963,
 917785,
 -58218,
 479464355,
 917784,
 -1,
 479529760,
 917783,
 479789055,
 478940362,
 -1,
 -58215,
 479661706,
 917782,
 -58214,
 479727190,
 917781,
 -58213,
 479792663,
 917780,
 -58212,
 479858141,
 917779,
 -58211,
 479923568,
 917778,
 -58210,
 479989042,
 917777,
 -58209,
 480054474,
 917776,
 -58208,
 480119859,
 917775,
 -58207,
 480185251,
 917774,
 -1,
 480250656,
 917773,
 480452003,
 440759694,
 -1,
 480517394,
 480381859,
 983230,
 480582831,
 480448138,
 983252,
 -58202,
 480513674,
 983432,
 -58201,
 480579158,
 983431,
 -58200,
 480644631,
 983430,
 -58199,
 480710109,
 983429,
 -58198,
 480775536,
 983428,
 -58197,
 480841010,
 983427,
 -58196,
 480906442,
 983426,
 -58195,
 480971827,
 983425,
 -58194,
 481037219,
 983424,
 -1,
 481102624,
 983423,
 481303738,
 480513622,
 983251,
 -58191,
 481234570,
 983422,
 -58190,
 481300054,
 983421,
 -58189,
 481365527,
 983420,
 -58188,
 481431005,
 983419,
 -58187,
 481496432,
 983418,
 -58186,
 481561906,
 983417,
 -58185,
 481627338,
 983416,
 -58184,
 481692723,
 983415,
 -58183,
 481758115,
 983414,
 -1,
 481823520,
 983413,
 482024645,
 481234455,
 983250,
 -58180,
 481955466,
 983412,
 -58179,
 482020950,
 983411,
 -58178,
 482086423,
 983410,
 -58177,
 482151901,
 983409,
 -58176,
 482217328,
 983408,
 -58175,
 482282802,
 983407,
 -58174,
 482348234,
 983406,
 -58173,
 482413619,
 983405,
 -58172,
 482479011,
 983404,
 -1,
 482544416,
 983403,
 482745552,
 481955293,
 983245,
 -58169,
 482676362,
 983402,
 -58168,
 482741846,
 983401,
 -58167,
 482807319,
 983400,
 -58166,
 482872797,
 983399,
 -58165,
 482938224,
 983398,
 -58164,
 483003698,
 983397,
 -58163,
 483069130,
 983396,
 -58162,
 483134515,
 983395,
 -58161,
 483199907,
 983394,
 -1,
 483265312,
 983393,
 483466459,
 482676080,
 983244,
 -58158,
 483397258,
 983392,
 -58157,
 483462742,
 983391,
 -58156,
 483528215,
 983390,
 -58155,
 483593693,
 983389,
 -58154,
 483659120,
 983388,
 -58153,
 483724594,
 983387,
 -58152,
 483790026,
 983386,
 -58151,
 483855411,
 983385,
 -58150,
 483920803,
 983384,
 -1,
 483986208,
 983383,
 484187366,
 483396914,
 983243,
 -58147,
 484118154,
 983382,
 -58146,
 484183638,
 983381,
 -58145,
 484249111,
 983380,
 -58144,
 484314589,
 983379,
 -58143,
 484380016,
 983378,
 -58142,
 484445490,
 983377,
 -58141,
 484510922,
 983376,
 -58140,
 484576307,
 983375,
 -58139,
 484641699,
 983374,
 -1,
 484707104,
 983373,
 484908273,
 484117706,
 983242,
 -58136,
 484839050,
 983372,
 -58135,
 484904534,
 983371,
 -58134,
 484970007,
 983370,
 -58133,
 485035485,
 983369,
 -58132,
 485100912,
 983368,
 -58131,
 485166386,
 983367,
 -58130,
 485231818,
 983366,
 -58129,
 485297203,
 983365,
 -58128,
 485362595,
 983364,
 -1,
 485428000,
 983363,
 485629180,
 484838451,
 983241,
 -58125,
 485559946,
 983362,
 -58124,
 485625430,
 983361,
 -58123,
 485690903,
 983360,
 -58122,
 485756381,
 983359,
 -58121,
 485821808,
 983358,
 -58120,
 485887282,
 983357,
 -58119,
 485952714,
 983356,
 -58118,
 486018099,
 983355,
 -58117,
 486083491,
 983354,
 -1,
 486148896,
 983353,
 486350087,
 485559203,
 983240,
 -58114,
 486280842,
 983352,
 -58113,
 486346326,
 983351,
 -58112,
 486411799,
 983350,
 -58111,
 486477277,
 983349,
 -58110,
 486542704,
 983348,
 -58109,
 486608178,
 983347,
 -58108,
 486673610,
 983346,
 -58107,
 486738995,
 983345,
 -58106,
 486804387,
 983344,
 -1,
 486869792,
 983343,
 487129087,
 486279968,
 983239,
 -58103,
 487001738,
 983342,
 -58102,
 487067222,
 983341,
 -58101,
 487132695,
 983340,
 -58100,
 487198173,
 983339,
 -58099,
 487263600,
 983338,
 -58098,
 487329074,
 983337,
 -58097,
 487394506,
 983336,
 -58096,
 487459891,
 983335,
 -58095,
 487525283,
 983334,
 -1,
 487590688,
 983333,
 487791958,
 480447539,
 983231,
 487857438,
 487722290,
 983257,
 -58091,
 487788170,
 983482,
 -58090,
 487853654,
 983481,
 -58089,
 487919127,
 983480,
 -58088,
 487984605,
 983479,
 -58087,
 488050032,
 983478,
 -58086,
 488115506,
 983477,
 -58085,
 488180938,
 983476,
 -58084,
 488246323,
 983475,
 -58083,
 488311715,
 983474,
 -1,
 488377120,
 983473,
 488578345,
 487787722,
 983256,
 -58080,
 488509066,
 983472,
 -58079,
 488574550,
 983471,
 -58078,
 488640023,
 983470,
 -58077,
 488705501,
 983469,
 -58076,
 488770928,
 983468,
 -58075,
 488836402,
 983467,
 -58074,
 488901834,
 983466,
 -58073,
 488967219,
 983465,
 -58072,
 489032611,
 983464,
 -1,
 489098016,
 983463,
 489299252,
 488508467,
 983255,
 -58069,
 489229962,
 983462,
 -58068,
 489295446,
 983461,
 -58067,
 489360919,
 983460,
 -58066,
 489426397,
 983459,
 -58065,
 489491824,
 983458,
 -58064,
 489557298,
 983457,
 -58063,
 489622730,
 983456,
 -58062,
 489688115,
 983455,
 -58061,
 489753507,
 983454,
 -1,
 489818912,
 983453,
 490020159,
 489229219,
 983254,
 -58058,
 489950858,
 983452,
 -58057,
 490016342,
 983451,
 -58056,
 490081815,
 983450,
 -58055,
 490147293,
 983449,
 -58054,
 490212720,
 983448,
 -58053,
 490278194,
 983447,
 -58052,
 490343626,
 983446,
 -58051,
 490409011,
 983445,
 -58050,
 490474403,
 983444,
 -1,
 490539808,
 983443,
 490741066,
 489949984,
 983253,
 -58047,
 490671754,
 983442,
 -58046,
 490737238,
 983441,
 -58045,
 490802711,
 983440,
 -58044,
 490868189,
 983439,
 -58043,
 490933616,
 983438,
 -58042,
 490999090,
 983437,
 -58041,
 491064522,
 983436,
 -58040,
 491129907,
 983435,
 -58039,
 491195299,
 983434,
 -1,
 491260704,
 983433,
 491461970,
 490671472,
 983258,
 -58036,
 491392477,
 983489,
 -58035,
 491457904,
 983488,
 -58034,
 491523378,
 983487,
 -58033,
 491588810,
 983486,
 -58032,
 491654195,
 983485,
 -58031,
 491719587,
 983484,
 -1,
 491784992,
 983483,
 -58029,
 491392650,
 983262,
 -58028,
 491916886,
 983261,
 -58027,
 491982359,
 983260,
 -1,
 492047837,
 983259,
 492248417,
 487722634,
 983238,
 -58024,
 492179082,
 983332,
 -58023,
 492244566,
 983331,
 -58022,
 492310039,
 983330,
 -58021,
 492375517,
 983329,
 -58020,
 492440944,
 983328,
 -58019,
 492506418,
 983327,
 -58018,
 492571850,
 983326,
 -58017,
 492637235,
 983325,
 -58016,
 492702627,
 983324,
 -1,
 492768032,
 983323,
 492969324,
 492179030,
 983237,
 -58013,
 492899978,
 983322,
 -58012,
 492965462,
 983321,
 -58011,
 493030935,
 983320,
 -58010,
 493096413,
 983319,
 -58009,
 493161840,
 983318,
 -58008,
 493227314,
 983317,
 -58007,
 493292746,
 983316,
 -58006,
 493358131,
 983315,
 -58005,
 493423523,
 983314,
 -1,
 493488928,
 983313,
 493690231,
 492899863,
 983236,
 -58002,
 493620874,
 983312,
 -58001,
 493686358,
 983311,
 -58000,
 493751831,
 983310,
 -57999,
 493817309,
 983309,
 -57998,
 493882736,
 983308,
 -57997,
 493948210,
 983307,
 -57996,
 494013642,
 983306,
 -57995,
 494079027,
 983305,
 -57994,
 494144419,
 983304,
 -1,
 494209824,
 983303,
 494411138,
 493620701,
 983235,
 -57991,
 494341770,
 983302,
 -57990,
 494407254,
 983301,
 -57989,
 494472727,
 983300,
 -57988,
 494538205,
 983299,
 -57987,
 494603632,
 983298,
 -57986,
 494669106,
 983297,
 -57985,
 494734538,
 983296,
 -57984,
 494799923,
 983295,
 -57983,
 494865315,
 983294,
 -1,
 494930720,
 983293,
 495132045,
 494341488,
 983234,
 -57980,
 495062666,
 983292,
 -57979,
 495128150,
 983291,
 -57978,
 495193623,
 983290,
 -57977,
 495259101,
 983289,
 -57976,
 495324528,
 983288,
 -57975,
 495390002,
 983287,
 -57974,
 495455434,
 983286,
 -57973,
 495520819,
 983285,
 -57972,
 495586211,
 983284,
 -1,
 495651616,
 983283,
 495852952,
 495062322,
 983233,
 -57969,
 495783562,
 983282,
 -57968,
 495849046,
 983281,
 -57967,
 495914519,
 983280,
 -57966,
 495979997,
 983279,
 -57965,
 496045424,
 983278,
 -57964,
 496110898,
 983277,
 -57963,
 496176330,
 983276,
 -57962,
 496241715,
 983275,
 -57961,
 496307107,
 983274,
 -1,
 496372512,
 983273,
 496631807,
 495783114,
 983232,
 -57958,
 496504458,
 983272,
 -57957,
 496569942,
 983271,
 -57956,
 496635415,
 983270,
 -57955,
 496700893,
 983269,
 -57954,
 496766320,
 983268,
 -57953,
 496831794,
 983267,
 -57952,
 496897226,
 983266,
 -57951,
 496962611,
 983265,
 -57950,
 497028003,
 983264,
 -1,
 497093408,
 983263,
 497294819,
 480389243,
 -1,
 497360344,
 497231068,
 -1,
 497425857,
 497318033,
 -1,
 497491374,
 497356481,
 -1,
 497556909,
 497441907,
 -1,
 497622442,
 497519609,
 7403,
 -1,
 497551791,
 7404,
 -57941,
 497583874,
 7409,
 -57940,
 497686605,
 7402,
 -1,
 497751089,
 7401,
 -1,
 497512315,
 7410,
 498015668,
 497454629,
 -1,
 498081201,
 497977319,
 7395,
 -1,
 498010543,
 7399,
 498212275,
 498013267,
 7397,
 -1,
 498141615,
 7400,
 -1,
 498171309,
 7394,
 498408890,
 497970538,
 -1,
 498474424,
 498348063,
 -1,
 -57929,
 498436071,
 7396,
 -1,
 498472019,
 7398,
 -57927,
 498434306,
 7408,
 -1,
 498623396,
 7411,
 -57925,
 498373816,
 7380,
 -57924,
 498764388,
 7414,
 -57923,
 498827988,
 7405,
 -57922,
 498883217,
 7379,
 -57921,
 498946207,
 7407,
 -57920,
 499009477,
 7413,
 -1,
 499071685,
 7406,
 499318783,
 497386255,
 -1,
 499326407,
 499225772,
 -1,
 499391941,
 499272012,
 7383,
 -1,
 499320370,
 7385,
 -57914,
 499335686,
 7382,
 -1,
 499454264,
 7381,
 499654091,
 499285561,
 -1,
 -57911,
 499618498,
 7390,
 -57910,
 499676004,
 7387,
 -1,
 499727770,
 7391,
 499916238,
 499599496,
 -1,
 -57907,
 499876065,
 7388,
 -1,
 499938494,
 7376,
 500112849,
 499852676,
 -1,
 -57904,
 500074348,
 7386,
 -1,
 500137553,
 7389,
 500309460,
 500046908,
 -1,
 -57901,
 500242754,
 7384,
 -1,
 500305840,
 7412,
 -57899,
 500266950,
 7377,
 -57898,
 500462256,
 7392,
 -57897,
 500525862,
 7378,
 -1,
 500569772,
 7393,
 500768226,
 497317101,
 -1,
 500833758,
 500727353,
 -1,
 500899292,
 500764620,
 983069,
 -1,
 500827709,
 983143,
 -57891,
 500854283,
 128678,
 -1,
 500973925,
 11823,
 -57889,
 500781857,
 9896,
 -57888,
 501108558,
 9168,
 -57887,
 501167119,
 8286,
 -1,
 501225616,
 10186,
 -1,
 500726821,
 9910,
 501489131,
 497237599,
 -1,
 501554665,
 501425187,
 -1,
 501620200,
 501481472,
 -1,
 -57881,
 501560654,
 127918,
 -1,
 501619738,
 128249,
 -1,
 501554389,
 128252,
 -57878,
 501505824,
 127931,
 -1,
 501816086,
 128243,
 502013425,
 501450869,
 -1,
 502078960,
 501964802,
 -1,
 -57874,
 502038632,
 8530,
 -57873,
 502101789,
 8528,
 -1,
 502160062,
 8529,
 -1,
 502044418,
 8585,
 502406643,
 501972537,
 983070,
 -1,
 502363534,
 983144,
 -1,
 502357716,
 127755,
 502604355,
 440696377,
 -1,
 502669542,
 502533825,
 -1,
 502734679,
 502617685,
 -1,
 502800177,
 502693331,
 -1,
 502865465,
 502749293,
 -1,
 502930963,
 502814829,
 -1,
 502996487,
 502880365,
 -1,
 503062015,
 502927041,
 -1,
 -57859,
 503023179,
 983843,
 -57858,
 503070303,
 983840,
 -1,
 503123649,
 983833,
 503324161,
 503023179,
 983836,
 -1,
 503285323,
 983837,
 503455235,
 503274727,
 983841,
 -1,
 503405799,
 983842,
 503586309,
 503397983,
 983834,
 -1,
 503529055,
 983835,
 503775231,
 503523451,
 983838,
 -1,
 503654523,
 983839,
 503848459,
 502927041,
 -1,
 -57847,
 503809611,
 983711,
 -57846,
 503856735,
 983708,
 -1,
 503910081,
 983701,
 504110605,
 503809611,
 983704,
 -1,
 504071755,
 983705,
 504241679,
 504061159,
 983709,
 -1,
 504192231,
 983710,
 504372753,
 504184415,
 983702,
 -1,
 504315487,
 983703,
 504561663,
 504309883,
 983706,
 -1,
 504440955,
 983707,
 504634912,
 502895699,
 -1,
 504700440,
 504565441,
 -1,
 -57834,
 504661579,
 983689,
 -57833,
 504708703,
 983686,
 -1,
 504762049,
 983679,
 504962586,
 504661579,
 983682,
 -1,
 504923723,
 983683,
 505093660,
 504913127,
 983687,
 -1,
 505044199,
 983688,
 505224734,
 505036383,
 983680,
 -1,
 505167455,
 983681,
 505413631,
 505161851,
 983684,
 -1,
 505292923,
 983685,
 505486893,
 504575178,
 -1,
 505552421,
 505417409,
 -1,
 -57821,
 505513547,
 983667,
 -57820,
 505560671,
 983664,
 -1,
 505614017,
 983657,
 505814567,
 505513547,
 983660,
 -1,
 505775691,
 983661,
 505945641,
 505765095,
 983665,
 -1,
 505896167,
 983666,
 506076715,
 505888351,
 983658,
 -1,
 506019423,
 983659,
 506265599,
 506013819,
 983662,
 -1,
 506144891,
 983663,
 506338865,
 505417409,
 -1,
 -57809,
 506299979,
 983733,
 -57808,
 506347103,
 983730,
 -1,
 506400449,
 983723,
 506601011,
 506299979,
 983726,
 -1,
 506562123,
 983727,
 506732085,
 506551527,
 983731,
 -1,
 506682599,
 983732,
 506863159,
 506674783,
 983724,
 -1,
 506805855,
 983725,
 507052031,
 506800251,
 983728,
 -1,
 506931323,
 983729,
 507125345,
 502822286,
 -1,
 507190856,
 507066523,
 -1,
 507256383,
 507121345,
 -1,
 -57795,
 507217483,
 983865,
 -57794,
 507264607,
 983862,
 -1,
 507317953,
 983855,
 507518529,
 507217483,
 983858,
 -1,
 507479627,
 983859,
 507649603,
 507469031,
 983863,
 -1,
 507600103,
 983864,
 507780677,
 507592287,
 983856,
 -1,
 507723359,
 983857,
 507911751,
 507717755,
 983860,
 -1,
 507848827,
 983861,
 -1,
 507867862,
 983911,
 508108373,
 507147662,
 -1,
 508173901,
 508038849,
 -1,
 -57781,
 508134987,
 983876,
 -57780,
 508182111,
 983873,
 -1,
 508235457,
 983866,
 508436047,
 508134987,
 983869,
 -1,
 508397131,
 983870,
 508567121,
 508386535,
 983874,
 -1,
 508517607,
 983875,
 508698195,
 508509791,
 983867,
 -1,
 508640863,
 983868,
 508887039,
 508635259,
 983871,
 -1,
 508766331,
 983872,
 508960345,
 508038849,
 -1,
 -57769,
 508921419,
 983887,
 -57768,
 508968543,
 983884,
 -1,
 509021889,
 983877,
 509222491,
 508921419,
 983880,
 -1,
 509183563,
 983881,
 509353565,
 509172967,
 983885,
 -1,
 509304039,
 983886,
 509484639,
 509296223,
 983878,
 -1,
 509427295,
 983879,
 509673471,
 509421691,
 983882,
 -1,
 509552763,
 983883,
 509746824,
 507071306,
 -1,
 509812348,
 509692746,
 -1,
 509877872,
 509758282,
 -1,
 509943400,
 509808321,
 -1,
 -57754,
 509904459,
 983810,
 -57753,
 509951583,
 983807,
 -1,
 510004929,
 983800,
 510205546,
 509904459,
 983803,
 -1,
 510166603,
 983804,
 510336620,
 510156007,
 983808,
 -1,
 510287079,
 983809,
 510467694,
 510279263,
 983801,
 -1,
 510410335,
 983802,
 510656511,
 510404731,
 983805,
 -1,
 510535803,
 983806,
 510729844,
 509808321,
 -1,
 -57742,
 510690891,
 983821,
 -57741,
 510738015,
 983818,
 -1,
 510791361,
 983811,
 510991990,
 510690891,
 983814,
 -1,
 510953035,
 983815,
 511123064,
 510942439,
 983819,
 -1,
 511073511,
 983820,
 511254138,
 511065695,
 983812,
 -1,
 511196767,
 983813,
 511442943,
 511191163,
 983816,
 -1,
 511322235,
 983817,
 511516288,
 509742785,
 -1,
 -57730,
 511477323,
 983788,
 -57729,
 511524447,
 983785,
 -1,
 511577793,
 983778,
 511778434,
 511477323,
 983781,
 -1,
 511739467,
 983782,
 511909508,
 511728871,
 983786,
 -1,
 511859943,
 983787,
 512040582,
 511852127,
 983779,
 -1,
 511983199,
 983780,
 512229375,
 511977595,
 983783,
 -1,
 512108667,
 983784,
 512302754,
 509691958,
 -1,
 512368278,
 512261040,
 -1,
 512433806,
 512298689,
 983899,
 -57716,
 512394827,
 983910,
 -57715,
 512441951,
 983907,
 -1,
 512495297,
 983900,
 512695952,
 512394827,
 983903,
 -1,
 512656971,
 983904,
 512827026,
 512646375,
 983908,
 -1,
 512777447,
 983909,
 512958100,
 512769631,
 983901,
 -1,
 512900703,
 983902,
 513146879,
 512895099,
 983905,
 -1,
 513026171,
 983906,
 513220250,
 512298689,
 -1,
 -57704,
 513181259,
 983656,
 -57703,
 513228383,
 983653,
 -1,
 513281729,
 983646,
 513482396,
 513181259,
 983649,
 -1,
 513443403,
 983650,
 513613470,
 513432807,
 983654,
 -1,
 513563879,
 983655,
 513744544,
 513556063,
 983647,
 -1,
 513687135,
 983648,
 513933311,
 513681531,
 983651,
 -1,
 513812603,
 983652,
 514006716,
 512261689,
 -1,
 514072240,
 513965625,
 -1,
 514137768,
 514002625,
 -1,
 -57690,
 514098763,
 983700,
 -57689,
 514145887,
 983697,
 -1,
 514199233,
 983690,
 514399914,
 514098763,
 983693,
 -1,
 514360907,
 983694,
 514530988,
 514350311,
 983698,
 -1,
 514481383,
 983699,
 514662062,
 514473567,
 983691,
 -1,
 514604639,
 983692,
 514850815,
 514599035,
 983695,
 -1,
 514730107,
 983696,
 514924212,
 514002625,
 -1,
 -57678,
 514885195,
 983722,
 -57677,
 514932319,
 983719,
 -1,
 514985665,
 983712,
 515186358,
 514885195,
 983715,
 -1,
 515147339,
 983716,
 515317432,
 515136743,
 983720,
 -1,
 515267815,
 983721,
 515448506,
 515259999,
 983713,
 -1,
 515391071,
 983714,
 515637247,
 515385467,
 983717,
 -1,
 515516539,
 983718,
 515710678,
 513961322,
 -1,
 515776202,
 515665258,
 -1,
 515841730,
 515706561,
 -1,
 -57664,
 515802699,
 983832,
 -57663,
 515849823,
 983829,
 -1,
 515903169,
 983822,
 516103876,
 515802699,
 983825,
 -1,
 516064843,
 983826,
 516234950,
 516054247,
 983830,
 -1,
 516185319,
 983831,
 516366024,
 516177503,
 983823,
 -1,
 516308575,
 983824,
 516554751,
 516302971,
 983827,
 -1,
 516434043,
 983828,
 516628174,
 515706561,
 -1,
 -57652,
 516589131,
 983777,
 -57651,
 516636255,
 983774,
 -1,
 516689601,
 983767,
 516890320,
 516589131,
 983770,
 -1,
 516851275,
 983771,
 517021394,
 516840679,
 983775,
 -1,
 516971751,
 983776,
 517152468,
 516963935,
 983768,
 -1,
 517095007,
 983769,
 517341183,
 517089403,
 983772,
 -1,
 517220475,
 983773,
 517414627,
 515675219,
 -1,
 517480155,
 517344961,
 -1,
 -57639,
 517441099,
 983766,
 -57638,
 517488223,
 983763,
 -1,
 517541569,
 983756,
 517742301,
 517441099,
 983759,
 -1,
 517703243,
 983760,
 517873375,
 517692647,
 983764,
 -1,
 517823719,
 983765,
 518004449,
 517815903,
 983757,
 -1,
 517946975,
 983758,
 518193151,
 517941371,
 983761,
 -1,
 518072443,
 983762,
 518266608,
 517376980,
 -1,
 518332136,
 518196929,
 -1,
 -57626,
 518293067,
 983799,
 -57625,
 518340191,
 983796,
 -1,
 518393537,
 983789,
 518594282,
 518293067,
 983792,
 -1,
 518555211,
 983793,
 518725356,
 518544615,
 983797,
 -1,
 518675687,
 983798,
 518856430,
 518667871,
 983790,
 -1,
 518798943,
 983791,
 519045119,
 518793339,
 983794,
 -1,
 518924411,
 983795,
 519118589,
 518219523,
 -1,
 519184117,
 519048897,
 -1,
 -57613,
 519145035,
 983744,
 -57612,
 519192159,
 983741,
 -1,
 519245505,
 983734,
 519446263,
 519145035,
 983737,
 -1,
 519407179,
 983738,
 519577337,
 519396583,
 983742,
 -1,
 519527655,
 983743,
 519708411,
 519519839,
 983735,
 -1,
 519650911,
 983736,
 519897087,
 519645307,
 983739,
 -1,
 519776379,
 983740,
 519970570,
 519066148,
 -1,
 520036098,
 519900865,
 -1,
 -57600,
 519997003,
 983755,
 -57599,
 520044127,
 983752,
 -1,
 520097473,
 983745,
 520298244,
 519997003,
 983748,
 -1,
 520259147,
 983749,
 520429318,
 520248551,
 983753,
 -1,
 520379623,
 983754,
 520560392,
 520371807,
 983746,
 -1,
 520502879,
 983747,
 520749055,
 520497275,
 983750,
 -1,
 520628347,
 983751,
 520822551,
 519915312,
 -1,
 520888079,
 520752833,
 -1,
 -57587,
 520848971,
 983854,
 -57586,
 520896095,
 983851,
 -1,
 520949441,
 983844,
 521150225,
 520848971,
 983847,
 -1,
 521111115,
 983848,
 521281299,
 521100519,
 983852,
 -1,
 521231591,
 983853,
 521412373,
 521223775,
 983845,
 -1,
 521354847,
 983846,
 521601023,
 521349243,
 983849,
 -1,
 521480315,
 983850,
 521674532,
 520763547,
 -1,
 521740060,
 521604801,
 -1,
 -57574,
 521700939,
 983898,
 -57573,
 521748063,
 983895,
 -1,
 521801409,
 983888,
 522002206,
 521700939,
 983891,
 -1,
 521963083,
 983892,
 522133280,
 521952487,
 983896,
 -1,
 522083559,
 983897,
 522264354,
 522075743,
 983889,
 -1,
 522206815,
 983890,
 522452991,
 522201211,
 983893,
 -1,
 522332283,
 983894,
 522584063,
 521608134,
 -1,
 522592041,
 522456769,
 -1,
 -57561,
 522552907,
 983678,
 -57560,
 522600031,
 983675,
 -1,
 522653377,
 983668,
 522854187,
 522552907,
 983671,
 -1,
 522815051,
 983672,
 522985261,
 522804455,
 983676,
 -1,
 522935527,
 983677,
 523116335,
 522927711,
 983669,
 -1,
 523058783,
 983670,
 523304959,
 523053179,
 983673,
 -1,
 523184251,
 983674,
 523378508,
 502733766,
 -1,
 523444043,
 523329761,
 -1,
 523509560,
 523393133,
 983629,
 523575094,
 523458669,
 983627,
 -1,
 523524205,
 983639,
 -57545,
 523539539,
 983625,
 -1,
 523646154,
 983623,
 523837243,
 523466126,
 983643,
 -57542,
 523793806,
 983642,
 -1,
 523843739,
 983641,
 524033854,
 523782986,
 983634,
 524156927,
 523979594,
 983637,
 -1,
 524045130,
 983636,
 524230464,
 523992633,
 983628,
 -1,
 524189241,
 983626,
 524361538,
 524184938,
 983633,
 -1,
 524316010,
 983638,
 524492612,
 524306486,
 983622,
 -1,
 524450736,
 983645,
 -57531,
 524457043,
 983632,
 -57530,
 524585940,
 983635,
 -57529,
 524642051,
 983630,
 -57528,
 524702244,
 983631,
 -57527,
 524764976,
 983640,
 -57526,
 524826779,
 983644,
 -1,
 524884934,
 983624,
 -1,
 523399207,
 3063,
 525147984,
 523313870,
 -1,
 -57522,
 525091091,
 3046,
 -57521,
 525150735,
 3062,
 -1,
 525211589,
 3059,
 -57519,
 525112572,
 3061,
 -57518,
 525366618,
 3065,
 -57517,
 525426514,
 3024,
 -57516,
 525491255,
 3066,
 -57515,
 525555584,
 3060,
 -57514,
 525618799,
 2998,
 -1,
 525669874,
 3064,
 525869192,
 502677089,
 -1,
 525934592,
 525828336,
 -1,
 526000029,
 525880913,
 -1,
 526065522,
 525945674,
 -1,
 526131054,
 526018162,
 -1,
 526196576,
 526075958,
 -1,
 -57506,
 526160874,
 6692,
 -57505,
 526203057,
 6693,
 -1,
 526257857,
 6691,
 526458723,
 526155321,
 -1,
 -57502,
 526399665,
 6709,
 -1,
 526454465,
 6708,
 526655334,
 526411523,
 -1,
 -57499,
 526596273,
 6717,
 -1,
 526651073,
 6715,
 526851945,
 526588870,
 -1,
 -57496,
 526792881,
 6699,
 -1,
 526847681,
 6697,
 -57494,
 526816405,
 6719,
 -57493,
 527005154,
 6698,
 -57492,
 527068924,
 6704,
 -57491,
 527120561,
 6732,
 -1,
 527184308,
 6716,
 527376240,
 526061249,
 6723,
 -1,
 527313019,
 6739,
 -57487,
 527337471,
 6724,
 -1,
 527453048,
 6730,
 527638408,
 526007109,
 -1,
 527703927,
 527594894,
 -1,
 -57483,
 527660514,
 6727,
 -57482,
 527710385,
 6726,
 -1,
 527765185,
 6728,
 527966075,
 527648822,
 -1,
 -57479,
 527930346,
 6690,
 -57478,
 527972529,
 6689,
 -1,
 528027329,
 6688,
 528228222,
 527924793,
 -1,
 -57475,
 528169137,
 6707,
 -1,
 528223937,
 6706,
 528424833,
 528180995,
 -1,
 -57472,
 528365745,
 6713,
 -1,
 528420545,
 6712,
 528621444,
 528358342,
 -1,
 -57469,
 528562353,
 6696,
 -1,
 528617153,
 6695,
 -57467,
 528585877,
 6720,
 -57466,
 528772860,
 6702,
 -57465,
 528824497,
 6729,
 -1,
 528888244,
 6714,
 529080205,
 527592810,
 -1,
 529145740,
 529010369,
 6721,
 -57461,
 529104559,
 6701,
 -1,
 529160387,
 6705,
 -1,
 529106943,
 6722,
 529407889,
 529029229,
 -1,
 -57457,
 529372309,
 6700,
 -57456,
 529413372,
 6694,
 -1,
 529469121,
 6710,
 529670035,
 529368651,
 6735,
 -1,
 529630795,
 6736,
 529801109,
 529612383,
 6733,
 -1,
 529743455,
 6734,
 -57450,
 529764275,
 6725,
 -57449,
 529883384,
 6738,
 -57448,
 529945213,
 6718,
 -57447,
 530003984,
 6740,
 -57446,
 530066036,
 6737,
 -57445,
 530129707,
 6703,
 -57444,
 530192426,
 6711,
 -1,
 530255553,
 6731,
 530456511,
 525957265,
 -1,
 530522024,
 530401334,
 -1,
 530587557,
 530464271,
 -1,
 530653092,
 530515837,
 -1,
 -57438,
 530582896,
 6777,
 -57437,
 530648370,
 6776,
 -1,
 530713802,
 6775,
 -1,
 530582106,
 6780,
 530980775,
 530517835,
 6824,
 -1,
 530926372,
 6825,
 -1,
 530918681,
 6819,
 531177389,
 530478562,
 -1,
 531242923,
 531137243,
 6826,
 -1,
 531188516,
 6827,
 -57428,
 531206093,
 6818,
 -1,
 531319524,
 6752,
 531505074,
 531124956,
 -1,
 531570608,
 531450093,
 6772,
 -1,
 531497660,
 6744,
 -57423,
 531535066,
 6823,
 -1,
 531658275,
 6779,
 531832756,
 531468613,
 6816,
 -1,
 531795898,
 6817,
 531963831,
 531792702,
 -1,
 -57418,
 531893299,
 6774,
 -1,
 531958691,
 6773,
 532160442,
 531918186,
 -1,
 -57415,
 532099082,
 6822,
 -1,
 532156102,
 6778,
 532357053,
 532101275,
 -1,
 -57412,
 532309756,
 6820,
 -1,
 532353984,
 6828,
 -57410,
 532292999,
 6821,
 -1,
 532487145,
 6829,
 532684757,
 530419451,
 -1,
 532750278,
 532634855,
 6763,
 532815812,
 532680387,
 -1,
 -57405,
 532748610,
 6764,
 -1,
 532811696,
 6771,
 -57403,
 532780115,
 6765,
 -1,
 532962535,
 6768,
 533143498,
 532710987,
 6761,
 533209033,
 533104203,
 6762,
 -1,
 533145723,
 6760,
 -1,
 533145723,
 6759,
 533405646,
 533073601,
 6753,
 -57396,
 533347935,
 6769,
 -57395,
 533407867,
 6767,
 -1,
 533466817,
 6755,
 533667793,
 533364281,
 -1,
 -57392,
 533608748,
 6770,
 -1,
 533664442,
 6756,
 533864403,
 533610079,
 6757,
 -1,
 533806687,
 6758,
 -57388,
 533811943,
 6754,
 -1,
 533932155,
 6766,
 534126563,
 532644086,
 -1,
 534192089,
 534085177,
 -1,
 -57384,
 534155922,
 6802,
 -1,
 534199646,
 6803,
 534388700,
 534148494,
 -1,
 -57381,
 534333145,
 6806,
 -1,
 534392704,
 6807,
 534585311,
 534327639,
 -1,
 -57378,
 534537338,
 6804,
 -1,
 534595208,
 6805,
 -57376,
 534550225,
 6800,
 -57375,
 534732798,
 6801,
 -57374,
 534796959,
 6809,
 -1,
 534850357,
 6808,
 535044081,
 534068397,
 -1,
 535109607,
 535002681,
 -1,
 -57370,
 535073426,
 6786,
 -1,
 535117150,
 6787,
 535306218,
 535065998,
 -1,
 -57367,
 535250649,
 6790,
 -1,
 535310208,
 6791,
 535502829,
 535245143,
 -1,
 -57364,
 535454842,
 6788,
 -1,
 535512712,
 6789,
 -57362,
 535467729,
 6784,
 -57361,
 535650302,
 6785,
 -57360,
 535714463,
 6793,
 -1,
 535767861,
 6792,
 536018943,
 534978565,
 -1,
 536027135,
 535911308,
 -1,
 536092664,
 535974436,
 -1,
 536158199,
 536029792,
 -1,
 -57354,
 536112584,
 6741,
 -1,
 536169336,
 6742,
 -1,
 536088257,
 6748,
 536420347,
 536038218,
 -1,
 -57350,
 536372854,
 6746,
 -1,
 536416005,
 6743,
 -57348,
 536376802,
 6750,
 -57347,
 536558411,
 6747,
 -57346,
 536621777,
 6745,
 -1,
 536680490,
 6749,
 -1,
 535975030,
 6783,
 536944734,
 525897223,
 -1,
 537010240,
 536890961,
 -1,
 537075745,
 536957212,
 -1,
 537141255,
 537024621,
 -1,
 -57339,
 537105854,
 43664,
 -57338,
 537156839,
 43672,
 -1,
 537212791,
 43656,
 537403404,
 537086006,
 -1,
 537468939,
 537344155,
 -1,
 -57334,
 537418983,
 43650,
 -1,
 537476180,
 43652,
 -1,
 537418983,
 43648,
 537731087,
 537361977,
 -1,
 -57330,
 537681127,
 43668,
 -1,
 537738324,
 43670,
 537927698,
 537683715,
 -1,
 -57327,
 537877735,
 43676,
 -1,
 537934932,
 43678,
 538124309,
 537861062,
 -1,
 -57324,
 538074343,
 43658,
 -1,
 538131540,
 43660,
 -57322,
 538088894,
 43684,
 -57321,
 538283579,
 43690,
 -57320,
 538344111,
 43662,
 -57319,
 538407925,
 43686,
 -57318,
 538467559,
 43694,
 -57317,
 538531585,
 43682,
 -57316,
 538595430,
 43688,
 -57315,
 538655828,
 43692,
 -57314,
 538720119,
 43654,
 -57313,
 538784664,
 43680,
 -57312,
 538846596,
 43666,
 -1,
 538909335,
 43674,
 539164671,
 537017157,
 -1,
 539172902,
 539056237,
 -1,
 -57308,
 539137470,
 43665,
 -57307,
 539188455,
 43673,
 -1,
 539244407,
 43657,
 539435051,
 539117622,
 -1,
 539500586,
 539375771,
 -1,
 -57303,
 539450599,
 43651,
 -1,
 539507796,
 43653,
 -1,
 539450599,
 43649,
 539762734,
 539393593,
 -1,
 -57299,
 539712743,
 43669,
 -1,
 539769940,
 43671,
 539959345,
 539715331,
 -1,
 -57296,
 539909351,
 43677,
 -1,
 539966548,
 43679,
 540155956,
 539892678,
 -1,
 -57293,
 540105959,
 43659,
 -1,
 540163156,
 43661,
 -57291,
 540120510,
 43685,
 -57290,
 540315195,
 43691,
 -57289,
 540375727,
 43663,
 -57288,
 540439541,
 43687,
 -57287,
 540499175,
 43695,
 -57286,
 540563201,
 43683,
 -57285,
 540627046,
 43689,
 -57284,
 540687444,
 43693,
 -57283,
 540751735,
 43655,
 -57282,
 540816280,
 43681,
 -57281,
 540878212,
 43667,
 -1,
 540940951,
 43675,
 541139023,
 536973010,
 -1,
 541204551,
 541068993,
 -1,
 -57277,
 541168723,
 43708,
 -57276,
 541231103,
 43707,
 -57275,
 541284461,
 43709,
 -57274,
 541348388,
 43710,
 -1,
 541396673,
 43697,
 541597771,
 541165131,
 43700,
 541663306,
 541534331,
 43699,
 -1,
 541593281,
 43705,
 -1,
 541593281,
 43706,
 541859917,
 541539935,
 43698,
 -1,
 541789889,
 43704,
 -57266,
 541809895,
 43702,
 -1,
 541927547,
 43701,
 542122070,
 541097469,
 -1,
 542187603,
 542067358,
 -1,
 -57262,
 542136429,
 43739,
 -1,
 542195300,
 43743,
 -57260,
 542144035,
 43741,
 -57259,
 542333983,
 43740,
 -1,
 542391383,
 43742,
 542580827,
 542081822,
 -1,
 -57256,
 542540147,
 43713,
 -57255,
 542604007,
 43714,
 -57254,
 542661663,
 43712,
 -1,
 542714742,
 43711,
 542965759,
 542528225,
 -1,
 -57251,
 542850035,
 43703,
 -1,
 542905280,
 43696,
 543162367,
 536890629,
 -1,
 543170667,
 543063609,
 -1,
 543236198,
 543121527,
 -1,
 -57246,
 543165917,
 6516,
 -57245,
 543231344,
 6515,
 -57244,
 543296818,
 6514,
 -57243,
 543362250,
 6513,
 -1,
 543427635,
 6512,
 543629417,
 543192462,
 -1,
 -57240,
 543570097,
 6497,
 -1,
 543624897,
 6483,
 -57238,
 543570097,
 6487,
 -1,
 543755969,
 6486,
 543957102,
 543107195,
 6507,
 -57235,
 543897755,
 6502,
 -1,
 543959163,
 6501,
 544153713,
 543887041,
 6499,
 -57232,
 544114687,
 6508,
 -1,
 544161375,
 6509,
 544350323,
 544114251,
 6503,
 -1,
 544286843,
 6506,
 544481398,
 544302851,
 -1,
 -57227,
 544422065,
 6490,
 -1,
 544476865,
 6489,
 544678008,
 544431335,
 6505,
 -1,
 544627943,
 6504,
 544809083,
 544626797,
 -1,
 -57222,
 544748796,
 6482,
 -1,
 544804545,
 6498,
 545005694,
 544753718,
 -1,
 -57219,
 544946353,
 6496,
 -1,
 545001153,
 6480,
 -57217,
 544969877,
 6485,
 -57216,
 545166314,
 6481,
 -57215,
 545229802,
 6493,
 -57214,
 545289698,
 6484,
 -57213,
 545352757,
 6495,
 -57212,
 545411709,
 6491,
 -57211,
 545475448,
 6488,
 -57210,
 545537631,
 6500,
 -57209,
 545601713,
 6494,
 -1,
 545665460,
 6492,
 545857761,
 525814529,
 -1,
 545923266,
 545803857,
 -1,
 545988752,
 545881657,
 -1,
 546054286,
 545947193,
 -1,
 -57203,
 545994929,
 71317,
 -1,
 546049729,
 71316,
 -57201,
 545994929,
 71322,
 -1,
 546180801,
 71321,
 546381973,
 545937517,
 -1,
 -57198,
 546346133,
 71315,
 -57197,
 546396355,
 71320,
 -57196,
 546452732,
 71310,
 -1,
 546508481,
 71325,
 546709659,
 546317006,
 -1,
 546775193,
 546644686,
 -1,
 -57192,
 546715825,
 71319,
 -1,
 546770625,
 71318,
 -57190,
 546715825,
 71324,
 -1,
 546901697,
 71323,
 547102879,
 546639553,
 71296,
 -57187,
 547063371,
 71305,
 -57186,
 547110495,
 71303,
 -1,
 547163841,
 71297,
 547365025,
 547063371,
 71300,
 -1,
 547325515,
 71301,
 547496100,
 547321230,
 -1,
 -57181,
 547436721,
 71335,
 -1,
 547491521,
 71336,
 547692711,
 547450218,
 -1,
 -57178,
 547646920,
 71338,
 -1,
 547688129,
 71332,
 547889322,
 547645187,
 -1,
 -57175,
 547829937,
 71327,
 -1,
 547884737,
 71326,
 548085933,
 547833910,
 -1,
 -57172,
 548026545,
 71307,
 -1,
 548081345,
 71306,
 548282544,
 548030256,
 -1,
 -57169,
 548223153,
 71314,
 -1,
 548277953,
 71313,
 548479154,
 548224607,
 71298,
 -1,
 548421215,
 71299,
 548610229,
 548418762,
 -1,
 -57164,
 548550833,
 71309,
 -1,
 548605633,
 71308,
 548806840,
 548543430,
 -1,
 -57161,
 548747441,
 71312,
 -1,
 548802241,
 71311,
 549003451,
 548739061,
 -1,
 -57158,
 548944049,
 71329,
 -1,
 548998849,
 71328,
 -57156,
 548967573,
 71331,
 -57155,
 549161962,
 71334,
 -57154,
 549215463,
 71304,
 -57153,
 549278333,
 71330,
 -57152,
 549342072,
 71333,
 -57151,
 549402801,
 71337,
 -1,
 549464187,
 71302,
 549658832,
 545858800,
 -1,
 549724358,
 549617209,
 -1,
 -57147,
 549687954,
 71362,
 -1,
 549731678,
 71363,
 549920969,
 549680526,
 -1,
 -57144,
 549865177,
 71366,
 -1,
 549924736,
 71367,
 550117580,
 549859671,
 -1,
 -57141,
 550069370,
 71364,
 -1,
 550127240,
 71365,
 -57139,
 550082257,
 71360,
 -57138,
 550264830,
 71361,
 -57137,
 550328991,
 71369,
 -1,
 550382389,
 71368,
 550576347,
 549621499,
 -1,
 550641877,
 550506177,
 -1,
 -57133,
 550602315,
 71349,
 -57132,
 550649439,
 71347,
 -1,
 550702785,
 71341,
 550904023,
 550602315,
 71344,
 -1,
 550864459,
 71345,
 551035097,
 550846047,
 71342,
 -1,
 550977119,
 71343,
 -57126,
 550984935,
 71348,
 -1,
 551102587,
 71346,
 551354367,
 550533265,
 -1,
 551362783,
 551259636,
 -1,
 -57122,
 551319099,
 71340,
 -1,
 551382704,
 71350,
 -57120,
 551312421,
 71351,
 -1,
 551490652,
 71339,
 551690468,
 545806445,
 -1,
 -57117,
 551630440,
 127818,
 -1,
 551685994,
 127883,
 -57115,
 551654439,
 128661,
 -1,
 551819253,
 983061,
 552018302,
 502605947,
 -1,
 552083805,
 551977863,
 -1,
 552149242,
 552016838,
 -1,
 552214771,
 552099047,
 -1,
 552280304,
 552163437,
 -1,
 552345839,
 552238649,
 -1,
 -57107,
 552300264,
 119563,
 -57106,
 552348893,
 119582,
 -1,
 552407059,
 119573,
 -1,
 552303674,
 119608,
 552730623,
 552228778,
 -1,
 -57102,
 552615689,
 119634,
 -1,
 552677029,
 119630,
 552870136,
 552161500,
 -1,
 552935671,
 552806523,
 -1,
 -57098,
 552884764,
 119590,
 -1,
 552936176,
 119613,
 -1,
 552897285,
 119631,
 -57095,
 552810905,
 119585,
 -1,
 553135332,
 119558,
 553328904,
 552084174,
 -1,
 553394433,
 553270879,
 -1,
 553459967,
 553341476,
 -1,
 -57090,
 553408126,
 119625,
 -1,
 553468800,
 119612,
 -57088,
 553422110,
 119568,
 -1,
 553595500,
 119636,
 553787653,
 553330811,
 -1,
 -57085,
 553740283,
 119623,
 -57084,
 553792022,
 119567,
 -1,
 553852701,
 119586,
 -57082,
 553749433,
 119584,
 -57081,
 554001493,
 119619,
 -1,
 554046796,
 119624,
 554246417,
 553265275,
 -1,
 554311949,
 554195053,
 -1,
 -57077,
 554257471,
 119603,
 -57076,
 554312671,
 119583,
 -1,
 554377471,
 119600,
 -57074,
 554275869,
 119626,
 -57073,
 554533047,
 119610,
 -57072,
 554587227,
 119618,
 -1,
 554636813,
 119580,
 554836251,
 554200426,
 -1,
 554901786,
 554772603,
 -1,
 554967320,
 554857870,
 -1,
 555032855,
 554909279,
 -1,
 -57066,
 554990643,
 119579,
 -1,
 555033617,
 119596,
 -1,
 554986140,
 119598,
 -57063,
 554913072,
 119578,
 -1,
 555225082,
 119572,
 -1,
 554845823,
 119605,
 555491620,
 554774871,
 -1,
 555557151,
 555452549,
 -1,
 -57058,
 555506204,
 119595,
 -1,
 555548965,
 119559,
 555753762,
 555506919,
 -1,
 -57055,
 555711576,
 119638,
 -1,
 555765833,
 119576,
 -57053,
 555700013,
 119606,
 -1,
 555880876,
 119632,
 556081452,
 555447694,
 -1,
 556146986,
 556039737,
 -1,
 556212521,
 556096743,
 -1,
 -57048,
 556174505,
 119601,
 -1,
 556231373,
 119628,
 -1,
 556167284,
 119593,
 -57045,
 556090295,
 119621,
 -1,
 556412874,
 119627,
 556605746,
 556020938,
 -1,
 556671279,
 556537549,
 119592,
 -1,
 556597813,
 119615,
 -57040,
 556631774,
 119614,
 -57039,
 556756942,
 119602,
 -1,
 556818063,
 119599,
 556998968,
 556558083,
 -1,
 557064502,
 556928705,
 -1,
 -57035,
 557024476,
 119604,
 -1,
 557064039,
 119588,
 -57033,
 557026074,
 119594,
 -1,
 557198479,
 119571,
 557392189,
 556928705,
 -1,
 -57030,
 557348423,
 119564,
 -57029,
 557397652,
 119633,
 -57028,
 557459528,
 119577,
 -1,
 557522256,
 119617,
 557719873,
 557339172,
 -1,
 -57025,
 557663556,
 119560,
 -57024,
 557722067,
 119609,
 -1,
 557782584,
 119616,
 557982022,
 557665098,
 -1,
 558047557,
 557911745,
 -1,
 -57020,
 558010242,
 119597,
 -1,
 558045923,
 119637,
 -1,
 557984506,
 119589,
 558309706,
 557914101,
 -1,
 -57016,
 558263993,
 119566,
 -57015,
 558325509,
 119587,
 -1,
 558372253,
 119561,
 558571853,
 558272435,
 -1,
 -57012,
 558530470,
 119620,
 -1,
 558581340,
 119575,
 558768464,
 558521575,
 -1,
 -57009,
 558721771,
 119565,
 -1,
 558782589,
 119635,
 558965075,
 558712886,
 -1,
 -57006,
 558908373,
 119591,
 -1,
 558967474,
 119562,
 559161686,
 558907873,
 -1,
 -57003,
 559110657,
 119622,
 -1,
 559161648,
 119570,
 559358297,
 559102107,
 -1,
 -57000,
 559308564,
 119574,
 -1,
 559355158,
 119629,
 -56998,
 559322589,
 119569,
 -56997,
 559516818,
 119607,
 -56996,
 559581605,
 119611,
 -1,
 559630341,
 119581,
 559817079,
 552029002,
 -1,
 559882611,
 559777836,
 -1,
 559948139,
 559821898,
 -1,
 560013671,
 559906361,
 -1,
 560079204,
 559977196,
 -1,
 -56989,
 560029097,
 3194,
 -1,
 560082847,
 3197,
 560332799,
 560020974,
 -1,
 -56986,
 560225705,
 3195,
 -1,
 560279455,
 3198,
 560472426,
 559964186,
 -1,
 -56983,
 560422313,
 3193,
 -1,
 560476063,
 3196,
 -1,
 560436956,
 3192,
 560734573,
 559910697,
 3170,
 -1,
 560679754,
 3171,
 560865648,
 560691345,
 -1,
 -56977,
 560825729,
 3199,
 -1,
 560863075,
 3133,
 561119231,
 560811601,
 -1,
 -56974,
 561022123,
 3160,
 -1,
 561064046,
 3161,
 561315839,
 559818875,
 -1,
 -56971,
 561221166,
 128250,
 -56970,
 561280607,
 128301,
 -1,
 561342736,
 128222,
 561521019,
 559765613,
 -1,
 -56967,
 561479225,
 9978,
 -56966,
 561535684,
 127934,
 -1,
 561591815,
 8376,
 561840127,
 561450689,
 -1,
 -56963,
 561737125,
 128198,
 -1,
 561783406,
 127861,
 561979877,
 551960159,
 -1,
 562045378,
 561918658,
 -1,
 562110911,
 561991249,
 -1,
 562176429,
 562074707,
 -1,
 562241960,
 562106049,
 11568,
 562307463,
 562176718,
 11575,
 562372998,
 562242254,
 11577,
 -1,
 562313371,
 11578,
 -1,
 562313371,
 11576,
 562569610,
 562271795,
 11619,
 -56951,
 562533939,
 11621,
 -1,
 562575515,
 11594,
 562766221,
 562527801,
 11612,
 -56948,
 562724409,
 11615,
 -1,
 562772123,
 11613,
 562962832,
 562722190,
 11609,
 -56945,
 562918798,
 11610,
 -1,
 562968731,
 11611,
 563159443,
 562907190,
 11581,
 563281919,
 563099803,
 11589,
 -1,
 563165339,
 11583,
 563356054,
 563098826,
 11571,
 563478527,
 563296411,
 11606,
 -1,
 563361947,
 11572,
 563552664,
 563309930,
 11604,
 -1,
 563506538,
 11605,
 563683738,
 563493019,
 11584,
 -1,
 563624091,
 11587,
 563814812,
 563615733,
 11569,
 -1,
 563755163,
 11570,
 -56931,
 563778643,
 11618,
 -56930,
 563908460,
 11617,
 -56929,
 563973076,
 11616,
 -56928,
 564030503,
 11591,
 -56927,
 564094723,
 11602,
 -56926,
 564156525,
 11599,
 -56925,
 564220452,
 11598,
 -56924,
 564284234,
 11597,
 -56923,
 564348720,
 11574,
 -56922,
 564408663,
 11580,
 -56921,
 564469154,
 11614,
 -1,
 564530881,
 11588,
 564732330,
 562178171,
 11622,
 -1,
 564696147,
 11579,
 -56917,
 564692555,
 11603,
 -56916,
 564813031,
 11623,
 -1,
 564870751,
 11593,
 565060025,
 562134585,
 -1,
 565125560,
 565020393,
 -1,
 565191089,
 565069878,
 11582,
 -1,
 565131419,
 11590,
 565322164,
 565130442,
 -1,
 -56909,
 565270637,
 11600,
 -1,
 565328027,
 11607,
 -56907,
 565286670,
 11596,
 -56906,
 565472295,
 11592,
 -56905,
 565533233,
 11601,
 -1,
 565590171,
 11586,
 -1,
 565057460,
 11620,
 565846460,
 564992348,
 -1,
 -56901,
 565790512,
 11573,
 -1,
 565852315,
 11585,
 566099967,
 565776065,
 -1,
 -56898,
 566007105,
 11608,
 -1,
 566048978,
 11595,
 -56896,
 562067184,
 11632,
 -56895,
 566187831,
 11631,
 -1,
 566239345,
 11647,
 566436312,
 561977727,
 -1,
 566501837,
 566383609,
 -1,
 566567367,
 566433781,
 -1,
 -56890,
 566524250,
 4048,
 -1,
 566577302,
 983207,
 -56888,
 566526868,
 4058,
 -56887,
 566713554,
 4050,
 -56886,
 566777578,
 4049,
 -56885,
 566840592,
 4057,
 -56884,
 566903699,
 4051,
 -1,
 566960083,
 4052,
 567157205,
 566457742,
 -1,
 567222738,
 567117602,
 -1,
 -56880,
 567170251,
 3982,
 -56879,
 567233719,
 3981,
 -1,
 567297184,
 3983,
 567541759,
 567165213,
 -1,
 -56876,
 567439208,
 4046,
 -1,
 567493792,
 3980,
 567738367,
 567103057,
 -1,
 -56873,
 567637148,
 3948,
 -1,
 567691925,
 3947,
 567878111,
 566381794,
 -1,
 567943646,
 567841163,
 -1,
 568009181,
 567879080,
 -1,
 -56868,
 567941442,
 11807,
 -1,
 568004528,
 11806,
 -1,
 567964403,
 11803,
 -1,
 567894467,
 11081,
 568336865,
 567817828,
 128005,
 -1,
 568263102,
 128047,
 -56862,
 568291345,
 128555,
 -56861,
 568417430,
 68410,
 -56860,
 568481218,
 9202,
 -1,
 568532834,
 127915,
 568730116,
 561929447,
 -1,
 568795638,
 568685813,
 -1,
 568861173,
 568729384,
 -1,
 568926700,
 568790493,
 -1,
 -56854,
 568856143,
 127552,
 -56853,
 568921545,
 127560,
 -1,
 568986812,
 127557,
 569188847,
 568856087,
 -1,
 -56850,
 569118227,
 127558,
 -1,
 569183135,
 127556,
 569385458,
 569118064,
 -1,
 -56847,
 569317414,
 127555,
 -1,
 569380038,
 127559,
 569638911,
 569314669,
 -1,
 -56844,
 569511555,
 127554,
 -1,
 569576348,
 127553,
 -1,
 568806533,
 127274,
 569844224,
 568747781,
 -1,
 569909754,
 569784497,
 -1,
 -56839,
 569867833,
 127913,
 -1,
 569921222,
 11833,
 -56837,
 569872957,
 128285,
 -56836,
 570065768,
 9184,
 -56835,
 570126868,
 11811,
 -56834,
 570189792,
 9180,
 -56833,
 570248604,
 11810,
 -1,
 570303117,
 9182,
 -56831,
 569793125,
 128069,
 -56830,
 570446923,
 127813,
 -56829,
 570510144,
 128508,
 -1,
 570573168,
 128701,
 570761752,
 568683882,
 -1,
 570827276,
 570711271,
 -1,
 570892811,
 570779395,
 -1,
 570958346,
 570834756,
 -1,
 -56823,
 570897142,
 128032,
 -1,
 570959838,
 127865,
 -1,
 570900045,
 127942,
 -1,
 570839070,
 128654,
 571286034,
 570768991,
 -1,
 571351568,
 571216910,
 -1,
 -56817,
 571307294,
 128208,
 -1,
 571355956,
 128681,
 -56815,
 571286551,
 128305,
 -1,
 571482147,
 8285,
 571679255,
 571215553,
 -1,
 571744789,
 571626020,
 128650,
 -1,
 571670782,
 128651,
 -56810,
 571687393,
 128646,
 -1,
 571810354,
 128668,
 -1,
 571640040,
 127930,
 572072490,
 570701979,
 -1,
 572138020,
 572026930,
 -1,
 572203555,
 572063744,
 -1,
 572269088,
 572148554,
 -1,
 572334623,
 572211838,
 -1,
 -56802,
 572289503,
 9886,
 -1,
 572345708,
 9887,
 -1,
 572271338,
 11057,
 572653567,
 572203726,
 -1,
 -56798,
 572547961,
 8278,
 -1,
 572604838,
 10176,
 -1,
 572131876,
 11835,
 572858921,
 572098123,
 -1,
 572924456,
 572806342,
 -1,
 -56793,
 572885543,
 128077,
 -1,
 572925815,
 128078,
 -1,
 572873067,
 9928,
 -1,
 572810330,
 128173,
 573252151,
 572032587,
 -1,
 573317686,
 573205866,
 -1,
 573383220,
 573266360,
 -1,
 573448752,
 573339022,
 -1,
 -56785,
 573395832,
 8526,
 -1,
 573451222,
 11829,
 -56783,
 573411606,
 9929,
 -56782,
 573580119,
 11832,
 -56781,
 573644880,
 11826,
 -1,
 573708869,
 9930,
 -56779,
 573342433,
 128034,
 -1,
 573852244,
 8378,
 -1,
 573263760,
 127799,
 574104130,
 573214572,
 -1,
 574169665,
 574053607,
 -1,
 574235200,
 574095360,
 -1,
 574300733,
 574170532,
 -1,
 -56772,
 574256555,
 11818,
 -1,
 574293483,
 8282,
 -56770,
 574264104,
 128109,
 -56769,
 574444944,
 128108,
 -1,
 574503504,
 128149,
 -1,
 574163492,
 11834,
 -1,
 574113214,
 128256,
 -1,
 574032621,
 128085,
 574891518,
 502551076,
 -1,
 574956331,
 574840039,
 -1,
 575021835,
 574891233,
 -1,
 575087262,
 574977422,
 -1,
 575152792,
 575034174,
 -1,
 575218262,
 575110713,
 7511,
 575283795,
 575179563,
 -1,
 575349325,
 575213249,
 7492,
 -56756,
 575295865,
 7579,
 -1,
 575350907,
 7494,
 575545935,
 575296036,
 7514,
 -1,
 575473988,
 7597,
 -56752,
 575507412,
 7610,
 -56751,
 575627642,
 7500,
 -56750,
 575684191,
 7502,
 -1,
 575748251,
 7587,
 -56748,
 575234386,
 7508,
 -56747,
 575879848,
 7615,
 -1,
 575932776,
 7605,
 576135775,
 575151046,
 7580,
 576201309,
 576066693,
 -1,
 576266842,
 576142943,
 7590,
 -1,
 576194978,
 7591,
 -56741,
 576226891,
 7608,
 -56740,
 576346221,
 7600,
 -1,
 576408394,
 7595,
 -56738,
 576142051,
 7521,
 -1,
 576522254,
 7581,
 576725604,
 576071803,
 7497,
 -56735,
 576689934,
 7614,
 -56734,
 576749781,
 7582,
 -56733,
 576812837,
 7604,
 -1,
 576870961,
 7505,
 577053290,
 576681358,
 -1,
 577118824,
 576986054,
 -1,
 -56729,
 577074034,
 7586,
 -1,
 577125957,
 7498,
 -56727,
 577060850,
 7513,
 -1,
 577243335,
 7603,
 577446510,
 576985077,
 7495,
 -56724,
 577397759,
 7509,
 -56723,
 577449613,
 7517,
 -1,
 577508743,
 7601,
 577708658,
 577410611,
 7611,
 577830911,
 577636260,
 -1,
 -56719,
 577728704,
 7612,
 -1,
 577774209,
 7613,
 577970805,
 577668683,
 7512,
 -56716,
 577923971,
 7607,
 -1,
 577962177,
 7606,
 578167417,
 577920231,
 7506,
 578289663,
 578119742,
 -1,
 -56712,
 578182375,
 7507,
 -1,
 578234491,
 7499,
 578429566,
 578112330,
 -1,
 578495101,
 578357156,
 -1,
 -56708,
 578449600,
 7593,
 -1,
 578512760,
 7594,
 -1,
 578437299,
 43001,
 578757250,
 578368714,
 7501,
 578879487,
 578711618,
 -1,
 -56703,
 578775294,
 7520,
 -1,
 578827608,
 7518,
 579019397,
 578691790,
 7496,
 -56700,
 578970589,
 7585,
 -1,
 579021763,
 7519,
 579216008,
 578948801,
 7491,
 -56697,
 579162489,
 7493,
 -1,
 579224033,
 7516,
 579412618,
 579177428,
 7515,
 -1,
 579340487,
 7609,
 579543692,
 579364611,
 7510,
 -1,
 579484387,
 7602,
 579674767,
 579491977,
 -1,
 -56690,
 579629248,
 7599,
 -1,
 579685806,
 7598,
 579871377,
 579621412,
 7504,
 -1,
 579799239,
 7596,
 580002452,
 579812959,
 -1,
 -56685,
 579953544,
 7589,
 -1,
 579996066,
 7588,
 -56683,
 579956986,
 7583,
 -56682,
 580143158,
 7503,
 -56681,
 580208442,
 7592,
 -1,
 580268375,
 7584,
 580461211,
 575112197,
 -1,
 -56678,
 580407608,
 42785,
 -1,
 580467581,
 42784,
 580714495,
 580401307,
 -1,
 -56675,
 580608765,
 42890,
 -1,
 580660123,
 765,
 580854471,
 575019974,
 -1,
 580919994,
 580785285,
 -1,
 580985508,
 580873578,
 7487,
 581107711,
 580923360,
 -1,
 -56669,
 580999277,
 7483,
 -1,
 581052539,
 7474,
 581247654,
 580934887,
 7484,
 -1,
 581207627,
 7485,
 581378728,
 581187739,
 7476,
 -1,
 581306786,
 43000,
 581509802,
 581310453,
 7470,
 -1,
 581440895,
 7471,
 581640876,
 581439169,
 7468,
 -1,
 581576827,
 7469,
 -56659,
 581603180,
 7490,
 -56658,
 581733332,
 11389,
 -56657,
 581797451,
 7489,
 -56656,
 581860921,
 7488,
 -56655,
 581920515,
 7486,
 -56654,
 581982317,
 7482,
 -56653,
 582046244,
 7481,
 -56652,
 582110026,
 7480,
 -56651,
 582174774,
 7479,
 -56650,
 582240048,
 7478,
 -56649,
 582303327,
 7477,
 -56648,
 582366410,
 7475,
 -56647,
 582428795,
 7473,
 -1,
 582492878,
 7472,
 582689477,
 580860871,
 -1,
 582755008,
 582631908,
 -1,
 -56643,
 582711197,
 42754,
 -56642,
 582776081,
 42758,
 -56641,
 582839420,
 42756,
 -1,
 582904162,
 42752,
 583139327,
 582685636,
 -1,
 -56638,
 583038877,
 42755,
 -56637,
 583103761,
 42759,
 -56636,
 583167100,
 42757,
 -1,
 583231842,
 42753,
 -56634,
 582653464,
 7544,
 -1,
 583360313,
 42889,
 583541466,
 580800792,
 -1,
 583607001,
 583467008,
 -1,
 583672525,
 583552364,
 -1,
 583738060,
 583598260,
 767,
 -1,
 583678490,
 753,
 -1,
 583666420,
 42773,
 583934674,
 583607684,
 -1,
 584000209,
 583894198,
 -1,
 -56624,
 583959317,
 42763,
 -1,
 584011203,
 42768,
 -1,
 583963242,
 751,
 584262357,
 583889232,
 -1,
 -56620,
 584210993,
 755,
 -1,
 584267499,
 754,
 -56618,
 584223199,
 752,
 -56617,
 584417857,
 759,
 -56616,
 584467590,
 42783,
 -1,
 584523515,
 42888,
 -1,
 583544184,
 42778,
 584786667,
 583477371,
 -1,
 584852200,
 584750153,
 -1,
 584917730,
 584798492,
 -1,
 584983264,
 584853075,
 -1,
 -56609,
 584942357,
 42764,
 -1,
 584994243,
 42769,
 -56607,
 584928707,
 42774,
 -1,
 585117977,
 983972,
 585367551,
 584858437,
 -1,
 585376486,
 585246291,
 -1,
 -56603,
 585335573,
 42760,
 -1,
 585387459,
 42765,
 -56601,
 585321923,
 42770,
 -1,
 585511221,
 983971,
 585760767,
 584800563,
 -1,
 -56598,
 585650488,
 764,
 -1,
 585710461,
 762,
 585900790,
 584734234,
 -1,
 585966321,
 585835897,
 -1,
 586031856,
 585901725,
 -1,
 -56593,
 585971703,
 757,
 -1,
 586027054,
 758,
 -1,
 585971703,
 756,
 586350591,
 585891840,
 -1,
 586359541,
 586229331,
 -1,
 -56588,
 586318613,
 42762,
 -1,
 586370499,
 42767,
 -1,
 586304963,
 42772,
 586621692,
 585854524,
 -1,
 -56584,
 586582486,
 42779,
 -56583,
 586630278,
 42782,
 -56582,
 586690633,
 42781,
 -56581,
 586753879,
 42780,
 -1,
 586817571,
 760,
 587014913,
 586562373,
 -1,
 587080448,
 586950227,
 -1,
 -56577,
 587039509,
 42761,
 -1,
 587091395,
 42766,
 -1,
 587025859,
 42771,
 587342597,
 586950056,
 -1,
 -56573,
 587304278,
 42775,
 -56572,
 587364732,
 42776,
 -1,
 587414729,
 42777,
 587604744,
 587274528,
 -1,
 -56569,
 587551032,
 763,
 -1,
 587611005,
 761,
 -56567,
 587565891,
 42864,
 -56566,
 587751854,
 766,
 -1,
 587806295,
 4348,
 587997977,
 574969965,
 -1,
 588063507,
 587947239,
 -1,
 588129042,
 588003253,
 -1,
 588194577,
 588092499,
 -1,
 -56560,
 588136929,
 9867,
 -1,
 588190656,
 9866,
 -1,
 588130730,
 119552,
 -1,
 588082735,
 128669,
 588522261,
 588007905,
 128018,
 -1,
 588448190,
 128053,
 588653336,
 588460371,
 -1,
 -56553,
 588616278,
 128184,
 -1,
 588650565,
 128176,
 -1,
 588593031,
 6314,
 588915492,
 587957835,
 -1,
 588981025,
 588864438,
 -1,
 589046560,
 588911027,
 9968,
 589168639,
 588972032,
 -1,
 -56546,
 589065780,
 128670,
 -56545,
 589110268,
 128672,
 -1,
 589175222,
 128693,
 -1,
 588972510,
 128507,
 589439779,
 588936835,
 128001,
 -1,
 589365694,
 128045,
 -1,
 589398229,
 128068,
 589636392,
 588847581,
 128241,
 589758463,
 589561856,
 -1,
 -56537,
 589664751,
 128242,
 -1,
 589716993,
 128244,
 -56535,
 589599912,
 128511,
 -56534,
 589860348,
 127909,
 -1,
 589914049,
 127889,
 590095350,
 574892155,
 -1,
 590160790,
 590032533,
 -1,
 590226282,
 590105418,
 -1,
 590291817,
 590163649,
 -1,
 590357302,
 590239853,
 -1,
 590422834,
 590297006,
 43977,
 -1,
 590349055,
 44001,
 590553908,
 590352065,
 43973,
 -1,
 590480127,
 43999,
 -56523,
 590517397,
 43747,
 -1,
 590633155,
 43752,
 590816061,
 590315065,
 -1,
 590881594,
 590773817,
 -1,
 -56519,
 590821553,
 43749,
 -1,
 590876353,
 43748,
 591078204,
 590823761,
 43975,
 -1,
 591004415,
 44000,
 -1,
 591019308,
 43978,
 591274819,
 590750414,
 -1,
 591340353,
 591209166,
 -1,
 -56512,
 591280305,
 43751,
 -1,
 591335105,
 43750,
 -56510,
 591282513,
 43991,
 -1,
 591478060,
 43993,
 591668039,
 591230350,
 -1,
 -56507,
 591623650,
 43754,
 -56506,
 591673521,
 43753,
 -1,
 591729398,
 43969,
 591930187,
 591619843,
 -1,
 591995722,
 591859393,
 43972,
 -1,
 591921919,
 43998,
 -1,
 591935784,
 43984,
 592192335,
 591874102,
 -1,
 592257870,
 592141986,
 43968,
 -1,
 592184063,
 43995,
 -1,
 592198956,
 43976,
 592454481,
 592139975,
 43971,
 -1,
 592380671,
 43997,
 592585555,
 592399372,
 43970,
 -1,
 592511743,
 43996,
 592716630,
 592529200,
 -1,
 -56491,
 592658769,
 43990,
 -1,
 592722216,
 43987,
 592913240,
 592658015,
 43983,
 -1,
 592839423,
 44002,
 593044315,
 592852170,
 -1,
 -56486,
 592993954,
 43986,
 -1,
 593050924,
 43992,
 593240926,
 592977314,
 -1,
 -56483,
 593183057,
 43974,
 -1,
 593235649,
 43746,
 593437537,
 593172469,
 -1,
 -56480,
 593377576,
 43994,
 -1,
 593432257,
 43989,
 -56478,
 593401056,
 43980,
 -56477,
 593596361,
 43979,
 -56476,
 593660146,
 43982,
 -56475,
 593718827,
 43988,
 -56474,
 593779943,
 43745,
 -56473,
 593837593,
 43981,
 -56472,
 593897595,
 43744,
 -1,
 593958679,
 43985,
 -1,
 590252204,
 44012,
 594223999,
 590187476,
 -1,
 594289534,
 594175659,
 -1,
 594355058,
 594218689,
 -1,
 594420592,
 594284225,
 -1,
 -56465,
 594380363,
 43759,
 -1,
 594427487,
 43757,
 -56463,
 594380363,
 43758,
 -1,
 594565364,
 44005,
 594748277,
 594314827,
 -1,
 -56460,
 594708043,
 43756,
 -1,
 594761972,
 44008,
 594944888,
 594689631,
 -1,
 -56457,
 594893044,
 44004,
 -1,
 594951775,
 43755,
 -56455,
 594908450,
 44006,
 -56454,
 595103261,
 43765,
 -56453,
 595163888,
 44007,
 -56452,
 595222521,
 44003,
 -56451,
 595287142,
 44010,
 -1,
 595336715,
 44009,
 -1,
 594232619,
 43766,
 595600269,
 594158832,
 -1,
 595665795,
 595557945,
 -1,
 -56446,
 595628690,
 44018,
 -1,
 595672414,
 44019,
 595862406,
 595621262,
 -1,
 -56443,
 595805913,
 44022,
 -1,
 595865472,
 44023,
 596059017,
 595800407,
 -1,
 -56440,
 596010106,
 44020,
 -1,
 596067976,
 44021,
 -56438,
 596022993,
 44016,
 -56437,
 596205566,
 44017,
 -56436,
 596269727,
 44025,
 -1,
 596323125,
 44024,
 596517777,
 595529409,
 -1,
 -56433,
 596470707,
 44013,
 -56432,
 596531954,
 43762,
 -1,
 596588941,
 43761,
 596779924,
 596450820,
 -1,
 -56429,
 596716330,
 44011,
 -1,
 596775719,
 43760,
 -56427,
 596742989,
 43764,
 -1,
 596934109,
 43763,
 597107678,
 590115875,
 -1,
 597173181,
 597048067,
 -1,
 597238715,
 597118545,
 -1,
 597304223,
 597196345,
 -1,
 597369756,
 597239931,
 67994,
 -1,
 597297635,
 67995,
 597500830,
 597298881,
 67992,
 -1,
 597428707,
 67993,
 -1,
 597449959,
 67996,
 597697444,
 597252205,
 -1,
 597762978,
 597633147,
 67980,
 -1,
 597690851,
 67981,
 597950463,
 597692097,
 67978,
 -1,
 597821923,
 67979,
 598025128,
 597652878,
 -1,
 598090663,
 597954241,
 67987,
 -1,
 598018531,
 67988,
 -1,
 598026363,
 67989,
 598287274,
 597978568,
 67982,
 -1,
 598215139,
 67983,
 598418349,
 598231094,
 -1,
 -56404,
 598358193,
 67985,
 -1,
 598412993,
 67990,
 598614959,
 598349866,
 67974,
 -1,
 598542819,
 67975,
 -56400,
 598578325,
 67972,
 -56399,
 598708147,
 67973,
 -56398,
 598764597,
 67991,
 -56397,
 598828866,
 67976,
 -56396,
 598891751,
 67971,
 -56395,
 598954621,
 67977,
 -56394,
 599018360,
 67984,
 -56393,
 599080543,
 67970,
 -56392,
 599145183,
 67986,
 -56391,
 599206011,
 67969,
 -56390,
 599270187,
 67997,
 -1,
 599330497,
 67968,
 599588863,
 597196313,
 67998,
 -1,
 599460323,
 67999,
 599719935,
 597107366,
 -1,
 599729115,
 599600833,
 -1,
 599794627,
 599686713,
 -1,
 -56383,
 599743719,
 68022,
 -56382,
 599795835,
 68021,
 -1,
 599854785,
 68020,
 600056774,
 599750030,
 -1,
 -56379,
 599992443,
 68017,
 -1,
 600051393,
 68015,
 600253385,
 600004717,
 -1,
 -56376,
 600189051,
 68010,
 -1,
 600248001,
 68009,
 600449996,
 600197174,
 -1,
 -56373,
 600389809,
 68013,
 -1,
 600444609,
 68018,
 600646606,
 600379073,
 68000,
 -1,
 600600400,
 68016,
 -56369,
 600609941,
 68004,
 -56368,
 600739763,
 68005,
 -56367,
 600796616,
 68011,
 -56366,
 600861749,
 68019,
 -56365,
 600926018,
 68007,
 -56364,
 600988903,
 68003,
 -56363,
 601051773,
 68008,
 -56362,
 601115512,
 68012,
 -56361,
 601177695,
 68002,
 -56360,
 601242335,
 68014,
 -56359,
 601303163,
 68001,
 -56358,
 601367339,
 68023,
 -1,
 601430058,
 68006,
 601686015,
 599678504,
 -1,
 -56355,
 601584595,
 68030,
 -1,
 601637341,
 68031,
 601826285,
 597066628,
 -1,
 601891820,
 601767748,
 -1,
 601957350,
 601849401,
 -1,
 602022884,
 601920251,
 -1,
 -56349,
 601974260,
 9173,
 -1,
 602032115,
 9174,
 -56347,
 601977726,
 9175,
 -1,
 602156715,
 9176,
 602350569,
 601903277,
 -1,
 -56344,
 602310166,
 9172,
 -1,
 602372146,
 9170,
 -56342,
 602306631,
 9171,
 -56341,
 602499215,
 9177,
 -1,
 602544931,
 9169,
 -1,
 601840871,
 128647,
 602809329,
 601761126,
 -1,
 -56337,
 602771634,
 9898,
 -56336,
 602831467,
 9900,
 -1,
 602872362,
 9899,
 -56334,
 602766259,
 983172,
 -56333,
 603020149,
 128697,
 -56332,
 603084545,
 128221,
 -56331,
 603148427,
 127816,
 -1,
 603199079,
 127830,
 603399342,
 590036575,
 -1,
 603464867,
 603329637,
 -1,
 603530349,
 603410001,
 -1,
 603595787,
 603487801,
 -1,
 603661314,
 603545719,
 -1,
 -56324,
 603590230,
 94105,
 -56323,
 603655703,
 94104,
 -56322,
 603721181,
 94103,
 -56321,
 603786608,
 94102,
 -56320,
 603852082,
 94101,
 -56319,
 603917514,
 94100,
 -1,
 603982899,
 94099,
 604185606,
 603616654,
 -1,
 -56316,
 604141026,
 93994,
 -56315,
 604190897,
 93998,
 -1,
 604245697,
 94007,
 604447753,
 604131039,
 -1,
 -56312,
 604411029,
 93980,
 -1,
 604442305,
 93978,
 -56310,
 604405423,
 93966,
 -1,
 604573377,
 93962,
 604775448,
 603543661,
 -1,
 604840975,
 604738643,
 -1,
 -56306,
 604780721,
 93997,
 -1,
 604835521,
 93996,
 605037586,
 604788845,
 -1,
 -56303,
 604977329,
 93973,
 -1,
 605032129,
 93972,
 605234197,
 604976330,
 -1,
 -56300,
 605173937,
 93988,
 -1,
 605228737,
 93987,
 605430807,
 605163201,
 93968,
 -1,
 605386255,
 94032,
 -1,
 605370545,
 93969,
 605627428,
 604739123,
 -1,
 605692959,
 605591091,
 -1,
 605758493,
 605648270,
 -1,
 -56292,
 605721749,
 94017,
 -1,
 605753025,
 94014,
 -56290,
 605721749,
 94016,
 -1,
 605884097,
 94013,
 606086178,
 605648270,
 -1,
 -56287,
 606025905,
 94006,
 -1,
 606080705,
 94012,
 -56285,
 606025905,
 94005,
 -1,
 606211777,
 94011,
 606413871,
 605590876,
 -1,
 606479403,
 606371385,
 -1,
 606544937,
 606434702,
 -1,
 -56280,
 606484657,
 94000,
 -1,
 606539457,
 94009,
 -56278,
 606502575,
 93964,
 -1,
 606670529,
 93965,
 -56276,
 606431042,
 93954,
 -56275,
 606821136,
 93970,
 -56274,
 606881928,
 93984,
 -1,
 606939254,
 94001,
 607134776,
 606367826,
 -1,
 607200311,
 607084663,
 -1,
 -56270,
 607129174,
 94111,
 -56269,
 607194589,
 94110,
 -56268,
 607260016,
 94109,
 -56267,
 607325490,
 94108,
 -56266,
 607390771,
 94107,
 -1,
 607456163,
 94106,
 -1,
 607156068,
 94002,
 607724610,
 607068878,
 -1,
 607790141,
 607688243,
 -1,
 -56261,
 607753795,
 93995,
 -56260,
 607795377,
 93999,
 -1,
 607850177,
 94008,
 608052288,
 607735519,
 -1,
 -56257,
 608015509,
 93981,
 -1,
 608046785,
 93979,
 -56255,
 607986475,
 93967,
 -1,
 608177857,
 93963,
 608379978,
 607653569,
 -1,
 608445513,
 608333631,
 -1,
 608511047,
 608393325,
 -1,
 -56250,
 608449788,
 93989,
 -1,
 608505537,
 93971,
 -56248,
 608474984,
 94015,
 -1,
 608653949,
 93958,
 -1,
 608385179,
 94019,
 608904272,
 608324426,
 -1,
 608969806,
 608843931,
 -1,
 -56243,
 608933013,
 93977,
 -1,
 608964289,
 93976,
 -56241,
 608933013,
 93975,
 -1,
 609095361,
 93974,
 609297492,
 608859534,
 -1,
 -56238,
 609252834,
 94004,
 -56237,
 609302705,
 94003,
 -1,
 609357505,
 94010,
 609559641,
 609236170,
 -1,
 609625176,
 609499291,
 -1,
 -56233,
 609564849,
 93993,
 -1,
 609619649,
 93992,
 -1,
 609554113,
 93983,
 609887324,
 609520596,
 -1,
 -56229,
 609825204,
 93961,
 -1,
 609881793,
 93960,
 610083935,
 609840167,
 -1,
 -56226,
 610022652,
 93986,
 -1,
 610078401,
 93985,
 610280546,
 610035459,
 -1,
 -56223,
 610225016,
 93955,
 -1,
 610275009,
 93952,
 610477157,
 610226724,
 -1,
 -56220,
 610416817,
 93957,
 -1,
 610471617,
 93956,
 610673768,
 610416795,
 -1,
 -56217,
 610613425,
 94020,
 -1,
 610668225,
 93990,
 -56215,
 610636778,
 93991,
 -56214,
 610832307,
 94018,
 -56213,
 610879624,
 93982,
 -56212,
 610939316,
 93959,
 -1,
 610998314,
 93953,
 611198105,
 603492091,
 -1,
 611263607,
 611139167,
 94049,
 611329138,
 611192513,
 94050,
 611450879,
 611276909,
 94051,
 -1,
 611333322,
 94052,
 -56205,
 611288651,
 94056,
 -56204,
 611474663,
 94053,
 -56203,
 611539505,
 94057,
 -56202,
 611597919,
 94055,
 -1,
 611657851,
 94054,
 611853440,
 611192513,
 94036,
 611918970,
 611801197,
 94039,
 -1,
 611857610,
 94040,
 612050044,
 611854459,
 94067,
 -1,
 611985531,
 94068,
 -56195,
 612009547,
 94075,
 -56194,
 612122207,
 94073,
 -56193,
 612186844,
 94038,
 -1,
 612241089,
 94037,
 612443271,
 611812939,
 94058,
 612508804,
 612372161,
 94059,
 612630527,
 612456557,
 94060,
 -1,
 612512970,
 94061,
 -56187,
 612468299,
 94062,
 -56186,
 612653617,
 94064,
 -1,
 612707114,
 94063,
 612902029,
 612378747,
 94045,
 612967562,
 612855146,
 94071,
 -1,
 612920682,
 94069,
 613098636,
 612915309,
 94046,
 -1,
 613037258,
 94047,
 -1,
 613039711,
 94074,
 613295249,
 612850919,
 94041,
 -56177,
 613254731,
 94076,
 -56176,
 613309671,
 94042,
 -1,
 613364048,
 94048,
 613557395,
 613258323,
 94065,
 -1,
 613498463,
 94066,
 613688469,
 613519212,
 94044,
 -1,
 613637351,
 94043,
 613819543,
 613643392,
 94072,
 -1,
 613772650,
 94070,
 614006783,
 613767277,
 94077,
 -1,
 613889226,
 94078,
 614081694,
 611156751,
 -1,
 -56165,
 614040403,
 94096,
 -56164,
 614101471,
 94095,
 -56163,
 614144322,
 94098,
 -1,
 614207408,
 94097,
 614465535,
 614037649,
 -1,
 614474914,
 614363208,
 -1,
 -56159,
 614436505,
 94034,
 -1,
 614471213,
 94035,
 -1,
 614405677,
 94033,
 614737066,
 603398414,
 -1,
 614802599,
 614685927,
 -1,
 -56154,
 614757983,
 128300,
 -1,
 614820106,
 127908,
 615055359,
 614727680,
 -1,
 -56151,
 614948788,
 983226,
 -1,
 614998948,
 983227,
 615195821,
 614685290,
 -1,
 -56148,
 615130434,
 128189,
 -1,
 615193496,
 128656,
 -1,
 615141328,
 127756,
 615458133,
 603328193,
 -1,
 615523574,
 615398433,
 -1,
 615589054,
 615478670,
 -1,
 615654582,
 615532265,
 -1,
 615720117,
 615586758,
 -1,
 -56140,
 615662903,
 127006,
 -1,
 615725526,
 126988,
 -1,
 615651429,
 126997,
 615982267,
 615591830,
 -1,
 616047802,
 615914438,
 -1,
 -56135,
 615990583,
 127007,
 -1,
 616053206,
 126989,
 -1,
 615979109,
 126998,
 -56132,
 615942370,
 127015,
 -56131,
 616262478,
 127014,
 -1,
 616326401,
 126977,
 616506569,
 615546425,
 -1,
 616572100,
 616469236,
 -1,
 616637635,
 616504262,
 -1,
 -56126,
 616580407,
 127002,
 -1,
 616643030,
 126984,
 -1,
 616568933,
 126993,
 616955903,
 616513016,
 -1,
 616965320,
 616831942,
 -1,
 -56121,
 616908087,
 127003,
 -1,
 616970710,
 126985,
 -1,
 616896613,
 126994,
 617227476,
 616444247,
 -1,
 617293007,
 617178288,
 -1,
 617358542,
 617225158,
 -1,
 -56115,
 617301303,
 127004,
 -1,
 617363926,
 126986,
 -1,
 617289829,
 126995,
 617676799,
 617236138,
 -1,
 617686227,
 617552838,
 -1,
 -56110,
 617628983,
 127005,
 -1,
 617691606,
 126987,
 -1,
 617617509,
 126996,
 617948379,
 617176295,
 -1,
 618013914,
 617896369,
 -1,
 618079449,
 617946054,
 -1,
 -56104,
 618022199,
 127001,
 -1,
 618084822,
 126983,
 -1,
 618010725,
 126992,
 -1,
 617967450,
 127011,
 618407138,
 617896045,
 -1,
 618472673,
 618349169,
 -1,
 618538208,
 618404806,
 -1,
 -56097,
 618480951,
 127009,
 -1,
 618543574,
 126991,
 -1,
 618469477,
 127000,
 -1,
 618423053,
 126979,
 618865897,
 618342523,
 -1,
 618931432,
 618807517,
 -1,
 618996967,
 618863558,
 -1,
 -56090,
 618939703,
 127008,
 -1,
 619002326,
 126990,
 -1,
 618928229,
 126999,
 -1,
 618862143,
 126976,
 619324653,
 618827628,
 -1,
 -56085,
 619267086,
 127017,
 -56084,
 619330551,
 126982,
 -1,
 619392628,
 126978,
 619586800,
 619255850,
 -1,
 -56081,
 619533496,
 127012,
 -1,
 619585343,
 127019,
 -56079,
 619540486,
 126980,
 -56078,
 619735505,
 127010,
 -56077,
 619792378,
 127018,
 -56076,
 619853872,
 126981,
 -56075,
 619912817,
 127013,
 -1,
 619976540,
 127016,
 620176670,
 615471213,
 128104,
 620242200,
 620110690,
 -1,
 620307732,
 620187217,
 -1,
 620373261,
 620236481,
 -1,
 620438781,
 620328334,
 2126,
 -56068,
 620402227,
 2129,
 -1,
 620443803,
 2132,
 620635391,
 620396089,
 2133,
 -1,
 620592697,
 2120,
 620766465,
 620578870,
 2122,
 -1,
 620721634,
 2121,
 -56062,
 620729907,
 2118,
 -56061,
 620850538,
 2131,
 -56060,
 620915751,
 2130,
 -56059,
 620979971,
 2128,
 -56058,
 621041773,
 2125,
 -56057,
 621105700,
 2124,
 -56056,
 621169482,
 2123,
 -56055,
 621232609,
 2136,
 -56054,
 621295771,
 2116,
 -56053,
 621360330,
 2114,
 -56052,
 621421262,
 2115,
 -1,
 621484021,
 2113,
 621683984,
 620314207,
 -1,
 -56049,
 621641273,
 2119,
 -1,
 621697133,
 2127,
 -56047,
 621644647,
 2117,
 -56046,
 621824191,
 2135,
 -56045,
 621885730,
 2112,
 -1,
 621946943,
 2134,
 -56043,
 620269160,
 2138,
 -56042,
 622095292,
 2142,
 -56041,
 622147127,
 2139,
 -1,
 622203154,
 2137,
 622404893,
 620167168,
 -1,
 622470428,
 622367115,
 -1,
 -56037,
 622429492,
 128115,
 -1,
 622475332,
 128114,
 -1,
 622400394,
 128107,
 -1,
 622360024,
 128094,
 622798144,
 620120906,
 -1,
 622863675,
 622729174,
 -1,
 622929195,
 622808657,
 -1,
 622994728,
 622861882,
 -1,
 623060260,
 622942317,
 3451,
 -1,
 623007853,
 3450,
 623191334,
 623004490,
 3453,
 -1,
 623135562,
 3454,
 -56025,
 623146137,
 3452,
 -1,
 623265846,
 3455,
 -56023,
 622953710,
 3386,
 -56022,
 623401762,
 3369,
 -1,
 623453729,
 3406,
 623650095,
 622890773,
 -1,
 623715630,
 623594314,
 3426,
 -1,
 623659850,
 3427,
 -1,
 623670425,
 3396,
 623912244,
 623598639,
 -1,
 623977779,
 623861762,
 -1,
 -56014,
 623935863,
 3442,
 -1,
 623984157,
 3441,
 -1,
 623935553,
 3440,
 624239929,
 623850560,
 -1,
 624305464,
 624189442,
 -1,
 -56009,
 624258254,
 3443,
 -1,
 624310541,
 3444,
 -1,
 624263586,
 3445,
 -56006,
 624195735,
 3389,
 -1,
 624501680,
 3449,
 624754687,
 622798973,
 -1,
 624764223,
 624661005,
 -1,
 -56002,
 624720012,
 9894,
 -1,
 624759643,
 9895,
 -1,
 624694091,
 9893,
 625026385,
 622756129,
 -1,
 625091910,
 624980304,
 -1,
 625157445,
 625030886,
 -1,
 -55996,
 625119528,
 10221,
 -1,
 625161054,
 10223,
 -1,
 625113285,
 10187,
 625419593,
 625036657,
 -1,
 -55992,
 625381672,
 10220,
 -1,
 625423198,
 10222,
 625616204,
 625362466,
 -1,
 -55989,
 625559344,
 120485,
 -1,
 625622623,
 120484,
 625812815,
 625547961,
 -1,
 -55986,
 625768948,
 120779,
 -1,
 625810565,
 120778,
 -55984,
 625768037,
 120001,
 -1,
 625947108,
 10189,
 626140500,
 624977667,
 -1,
 -55981,
 626085117,
 127809,
 -1,
 626132609,
 9967,
 -1,
 626095264,
 9901,
 626402801,
 615421157,
 -1,
 626468251,
 626346826,
 -1,
 626533783,
 626405057,
 -1,
 626599283,
 626477555,
 -1,
 626664798,
 626533070,
 -1,
 626730333,
 626598606,
 -1,
 -55972,
 626669745,
 43625,
 -1,
 626724545,
 43624,
 -1,
 626669745,
 43626,
 626992481,
 626623667,
 -1,
 -55968,
 626931889,
 43623,
 -1,
 626986689,
 43622,
 627189092,
 626940013,
 -1,
 -55965,
 627152021,
 43621,
 -1,
 627183297,
 43627,
 627385703,
 627132208,
 -1,
 -55962,
 627325105,
 43620,
 -1,
 627379905,
 43619,
 627582314,
 627325083,
 -1,
 -55959,
 627521713,
 43630,
 -1,
 627576513,
 43629,
 627778925,
 627514310,
 -1,
 -55956,
 627718321,
 43618,
 -1,
 627773121,
 43617,
 -55954,
 627742275,
 43634,
 -55953,
 627938282,
 43633,
 -55952,
 627996130,
 43628,
 -55951,
 628059592,
 43635,
 -55950,
 628110588,
 43616,
 -1,
 628175284,
 43631,
 628368774,
 626554254,
 -1,
 628434309,
 628308305,
 -1,
 628499832,
 628381805,
 -1,
 -55945,
 628462741,
 4218,
 -1,
 628494017,
 4220,
 628696443,
 628443190,
 -1,
 -55942,
 628635825,
 4214,
 -1,
 628690625,
 4213,
 -55940,
 628659779,
 4217,
 -55939,
 628850909,
 4224,
 -55938,
 628910324,
 4221,
 -55937,
 628963505,
 4225,
 -55936,
 629028092,
 4215,
 -55935,
 629092788,
 4222,
 -55934,
 629154603,
 4219,
 -55933,
 629218274,
 4216,
 -55932,
 629282858,
 4223,
 -1,
 629345985,
 4130,
 -1,
 628372908,
 4193,
 629613965,
 628315998,
 -1,
 629679498,
 629545206,
 -1,
 -55927,
 629614715,
 4189,
 -1,
 629673665,
 4188,
 -55925,
 629627466,
 4186,
 -55924,
 629819321,
 4187,
 -1,
 629876859,
 4136,
 630072721,
 629549494,
 -1,
 -55921,
 630036015,
 4207,
 -55920,
 630086416,
 4206,
 -1,
 630142728,
 4208,
 630334868,
 630034546,
 -1,
 -55917,
 630292701,
 4197,
 -1,
 630352931,
 4198,
 -55915,
 630289700,
 4238,
 -55914,
 630470672,
 4159,
 -1,
 630526436,
 43642,
 630783999,
 626482737,
 -1,
 -55911,
 630680683,
 43637,
 -55910,
 630742310,
 43636,
 -1,
 630799424,
 43638,
 630990282,
 626423182,
 -1,
 631055796,
 630931741,
 -1,
 631121320,
 631011208,
 -1,
 631186851,
 631079742,
 -1,
 -55904,
 631115229,
 4234,
 -55903,
 631180656,
 4233,
 -55902,
 631246026,
 4232,
 -1,
 631311411,
 4231,
 631570431,
 631120118,
 -1,
 631580071,
 631472958,
 -1,
 -55898,
 631508170,
 4236,
 -1,
 631573555,
 4235,
 -1,
 631516143,
 4237,
 631842222,
 631083141,
 -1,
 -55894,
 631770480,
 4205,
 -55893,
 631835954,
 4204,
 -55892,
 631901386,
 4203,
 -55891,
 631966771,
 4202,
 -1,
 632032163,
 4201,
 632235441,
 631785979,
 -1,
 -55888,
 632163530,
 4251,
 -1,
 632228771,
 4250,
 -55886,
 632190261,
 4239,
 -55885,
 632383422,
 43643,
 -1,
 632428040,
 4154,
 632628674,
 630995286,
 -1,
 632694200,
 632585785,
 -1,
 -55881,
 632656530,
 4242,
 -1,
 632700254,
 4243,
 632890811,
 632649102,
 -1,
 -55878,
 632833753,
 4246,
 -1,
 632893312,
 4247,
 633087422,
 632828247,
 -1,
 -55875,
 633037946,
 4244,
 -1,
 633095816,
 4245,
 -55873,
 633050833,
 4240,
 -55872,
 633233406,
 4241,
 -55871,
 633297567,
 4249,
 -1,
 633350965,
 4248,
 633602047,
 632591755,
 -1,
 633611719,
 633475541,
 -1,
 -55867,
 633570695,
 43641,
 -55866,
 633626622,
 43640,
 -1,
 633679933,
 43639,
 633929727,
 633567112,
 -1,
 -55863,
 633823230,
 4254,
 -1,
 633876541,
 4255,
 634070497,
 630951675,
 -1,
 634136018,
 634025358,
 -1,
 634201553,
 634075473,
 -1,
 634267087,
 634136699,
 4228,
 -1,
 634191877,
 4229,
 -55856,
 634204900,
 4230,
 -1,
 634326842,
 4227,
 -1,
 634140063,
 4194,
 634594774,
 634079599,
 -1,
 -55852,
 634553931,
 4211,
 -55851,
 634609124,
 4210,
 -1,
 634661492,
 4212,
 634856921,
 634556530,
 -1,
 -55848,
 634816511,
 4200,
 -1,
 634859239,
 4199,
 635053532,
 634804062,
 -1,
 -55845,
 635002087,
 4148,
 -1,
 635060540,
 4147,
 635250142,
 634982876,
 4252,
 -1,
 635190879,
 4253,
 -55841,
 635207533,
 4139,
 -55840,
 635319829,
 4209,
 -1,
 635381888,
 4149,
 635577837,
 634003586,
 -1,
 635643372,
 635523620,
 -1,
 635708904,
 635578976,
 -1,
 -55835,
 635671701,
 4155,
 -55834,
 635735987,
 4157,
 -55833,
 635792840,
 4156,
 -1,
 635844785,
 4158,
 636092415,
 635658143,
 -1,
 -55830,
 635984067,
 4190,
 -55829,
 636047997,
 4191,
 -1,
 636111736,
 4192,
 -1,
 635598734,
 4226,
 636364272,
 635536168,
 -1,
 -55825,
 636307856,
 4196,
 -1,
 636369416,
 4195,
 -1,
 636311314,
 43632,
 636626427,
 626361931,
 -1,
 636691962,
 636581262,
 -1,
 636757497,
 636632900,
 -1,
 636823031,
 636712334,
 -1,
 -55818,
 636786079,
 119081,
 -1,
 636821745,
 127932,
 -55816,
 636771157,
 127925,
 -1,
 636963301,
 127929,
 -1,
 636698113,
 127812,
 -1,
 636637612,
 127926,
 -55812,
 636587884,
 983173,
 -55811,
 637243222,
 983211,
 -1,
 637294522,
 983223,
 637479308,
 574846350,
 -1,
 637544126,
 637406913,
 -1,
 637609580,
 637504227,
 -1,
 637675075,
 637554257,
 -1,
 637740553,
 637635540,
 -1,
 637806088,
 637689189,
 -1,
 637871622,
 637758826,
 43144,
 -1,
 637824362,
 43145,
 638058495,
 637815626,
 43146,
 -1,
 637946698,
 43147,
 -1,
 637734593,
 43182,
 638199311,
 637697593,
 -1,
 638264845,
 638156345,
 -1,
 -55796,
 638204081,
 43165,
 -1,
 638258881,
 43164,
 -55794,
 638204081,
 43170,
 -1,
 638389953,
 43169,
 638592532,
 638146669,
 -1,
 -55791,
 638555285,
 43163,
 -55790,
 638605507,
 43168,
 -55789,
 638661884,
 43158,
 -1,
 638717633,
 43173,
 638920218,
 638526158,
 -1,
 638985752,
 638853838,
 -1,
 -55785,
 638924977,
 43167,
 -1,
 638979777,
 43166,
 -55783,
 638924977,
 43172,
 -1,
 639110849,
 43171,
 639313438,
 638848705,
 43138,
 -55780,
 639272523,
 43153,
 -55779,
 639319647,
 43150,
 -1,
 639372993,
 43139,
 639575586,
 639268238,
 -1,
 -55776,
 639530466,
 43184,
 -55775,
 639580337,
 43183,
 -1,
 639635137,
 43185,
 639837732,
 639534667,
 43142,
 -1,
 639796811,
 43143,
 639968807,
 639788803,
 -1,
 -55770,
 639908017,
 43175,
 -1,
 639962817,
 43174,
 640165417,
 639917287,
 43151,
 -1,
 640113895,
 43152,
 640296492,
 640109386,
 -1,
 -55765,
 640240504,
 43187,
 -1,
 640290497,
 43181,
 640493103,
 640239670,
 -1,
 -55762,
 640432305,
 43155,
 -1,
 640487105,
 43154,
 640689714,
 640436016,
 -1,
 -55759,
 640628913,
 43162,
 -1,
 640683713,
 43161,
 640886324,
 640630367,
 43140,
 -1,
 640826975,
 43141,
 641017399,
 640824522,
 -1,
 -55754,
 640956593,
 43157,
 -1,
 641011393,
 43156,
 641214009,
 640952443,
 43148,
 -1,
 641149051,
 43149,
 641345084,
 641145798,
 -1,
 -55749,
 641284273,
 43160,
 -1,
 641339073,
 43159,
 641541695,
 641275893,
 -1,
 -55746,
 641480881,
 43177,
 -1,
 641535681,
 43176,
 -55744,
 641504405,
 43179,
 -55743,
 641691080,
 43180,
 -55742,
 641749629,
 43178,
 -1,
 641808561,
 43186,
 642000469,
 637636347,
 -1,
 642065993,
 641961557,
 -1,
 642131527,
 642018666,
 43194,
 -1,
 642084202,
 43195,
 642318335,
 642075466,
 43196,
 -1,
 642206538,
 43197,
 642393677,
 641994433,
 -1,
 -55733,
 642352715,
 43203,
 -55732,
 642399839,
 43200,
 -1,
 642453185,
 43189,
 642655823,
 642352715,
 43192,
 -1,
 642614859,
 43193,
 642786897,
 642604263,
 43201,
 -1,
 642735335,
 43202,
 642917971,
 642727519,
 43190,
 -1,
 642858591,
 43191,
 643104767,
 642852987,
 43198,
 -1,
 642984059,
 43199,
 643180134,
 641934030,
 -1,
 643245668,
 643121421,
 -1,
 643311194,
 643202617,
 -1,
 -55719,
 643273362,
 43218,
 -1,
 643317086,
 43219,
 643507805,
 643265934,
 -1,
 -55716,
 643450585,
 43222,
 -1,
 643510144,
 43223,
 643704416,
 643445079,
 -1,
 -55713,
 643654778,
 43220,
 -1,
 643712648,
 43221,
 -55711,
 643667665,
 43216,
 -55710,
 643850238,
 43217,
 -55709,
 643914399,
 43225,
 -1,
 643967797,
 43224,
 -55707,
 643195931,
 43215,
 -1,
 644092834,
 43214,
 644294251,
 643135633,
 -1,
 644359786,
 644255220,
 -1,
 -55703,
 644314683,
 43137,
 -1,
 644378288,
 43204,
 -1,
 644289628,
 43136,
 -1,
 644227240,
 43188,
 644687546,
 637555691,
 -1,
 644753032,
 644632145,
 -1,
 644818546,
 644709945,
 -1,
 -55696,
 644773358,
 2065,
 -55695,
 644826599,
 2056,
 -1,
 644878141,
 2069,
 645080694,
 644759135,
 -1,
 -55692,
 645043283,
 2052,
 -55691,
 645103161,
 2055,
 -1,
 645159021,
 2063,
 645342841,
 645035406,
 -1,
 -55688,
 645284686,
 2062,
 -1,
 645347661,
 2068,
 645539452,
 645273589,
 -1,
 -55685,
 645481959,
 2049,
 -1,
 645533498,
 2053,
 -55683,
 645502647,
 2054,
 -55682,
 645699115,
 2057,
 -55681,
 645755781,
 2067,
 -55680,
 645819709,
 2066,
 -55679,
 645880930,
 2061,
 -55678,
 645944950,
 2060,
 -55677,
 646007697,
 2059,
 -55676,
 646072492,
 2058,
 -55675,
 646133064,
 2050,
 -55674,
 646197926,
 2064,
 -55673,
 646259570,
 2051,
 -1,
 646320706,
 2048,
 646522522,
 644714235,
 -1,
 646588047,
 646467737,
 -1,
 646653580,
 646516417,
 2082,
 -1,
 646581953,
 2079,
 -55667,
 646612555,
 2086,
 -55666,
 646725215,
 2089,
 -1,
 646785147,
 2076,
 646981266,
 646536423,
 2091,
 647102463,
 646942005,
 2081,
 -1,
 646975169,
 2078,
 647177877,
 646935950,
 -1,
 -55660,
 647137376,
 2092,
 -1,
 647183632,
 2085,
 647374487,
 647106241,
 2083,
 -1,
 647302849,
 2080,
 -55656,
 647333451,
 2087,
 -55655,
 647446111,
 2090,
 -1,
 647506043,
 2077,
 647702189,
 646474696,
 -1,
 647767714,
 647630529,
 -1,
 647833247,
 647714925,
 -1,
 -55650,
 647780569,
 2110,
 -1,
 647837218,
 2098,
 -55648,
 647791340,
 2100,
 -55647,
 647984061,
 2108,
 -1,
 648033388,
 2097,
 648226469,
 647730739,
 -1,
 -55644,
 648168715,
 2104,
 -1,
 648220803,
 2106,
 648423080,
 648181134,
 -1,
 -55641,
 648371701,
 2109,
 -1,
 648428567,
 2101,
 -55639,
 648381810,
 2107,
 -55638,
 648572005,
 2105,
 -55637,
 648632825,
 2096,
 -55636,
 648697199,
 2103,
 -1,
 648747245,
 2099,
 648947385,
 647647780,
 -1,
 649012917,
 648877383,
 -1,
 649078449,
 648954337,
 2070,
 -1,
 649005542,
 2071,
 -55630,
 649026925,
 2072,
 -55629,
 649157113,
 2093,
 -55628,
 649211180,
 2075,
 -1,
 649274192,
 2073,
 649527295,
 648961487,
 -1,
 -55625,
 649427007,
 2084,
 -55624,
 649477727,
 2088,
 -1,
 649538860,
 2074,
 -1,
 648875893,
 2102,
 -55621,
 644650032,
 127927,
 -55620,
 649756710,
 128225,
 -55619,
 649808254,
 127862,
 -1,
 649871710,
 9973,
 650061693,
 637483163,
 -1,
 650127217,
 649989825,
 -1,
 650192688,
 650079739,
 -1,
 650258177,
 650137169,
 -1,
 650323657,
 650218452,
 -1,
 650389192,
 650272101,
 -1,
 650454726,
 650341738,
 70025,
 -1,
 650407274,
 70026,
 650641407,
 650398538,
 70027,
 -1,
 650529610,
 70028,
 -1,
 650317505,
 70062,
 650782415,
 650280505,
 -1,
 650847949,
 650739257,
 -1,
 -55604,
 650786993,
 70044,
 -1,
 650841793,
 70043,
 -55602,
 650786993,
 70049,
 -1,
 650972865,
 70048,
 651175636,
 650729581,
 -1,
 -55599,
 651138197,
 70042,
 -55598,
 651188419,
 70047,
 -55597,
 651244796,
 70037,
 -1,
 651300545,
 70052,
 651503322,
 651109070,
 -1,
 651568856,
 651436750,
 -1,
 -55593,
 651507889,
 70046,
 -1,
 651562689,
 70045,
 -55591,
 651507889,
 70051,
 -1,
 651693761,
 70050,
 651896542,
 651431617,
 70019,
 -55588,
 651855435,
 70032,
 -55587,
 651902559,
 70030,
 -1,
 651955905,
 70020,
 652158690,
 651851150,
 -1,
 -55584,
 652113378,
 70064,
 -55583,
 652163249,
 70063,
 -1,
 652218049,
 70065,
 652420836,
 652117579,
 70023,
 -1,
 652379723,
 70024,
 652551911,
 652371715,
 -1,
 -55578,
 652490929,
 70054,
 -1,
 652545729,
 70053,
 652748522,
 652495690,
 -1,
 -55575,
 652692344,
 70061,
 -1,
 652742337,
 70060,
 652945133,
 652691510,
 -1,
 -55572,
 652884145,
 70034,
 -1,
 652938945,
 70033,
 653141744,
 652887856,
 -1,
 -55569,
 653080753,
 70041,
 -1,
 653135553,
 70040,
 653338354,
 653082207,
 70021,
 -1,
 653278815,
 70022,
 653469429,
 653276362,
 -1,
 -55564,
 653408433,
 70036,
 -1,
 653463233,
 70035,
 653666040,
 653401030,
 -1,
 -55561,
 653605041,
 70039,
 -1,
 653659841,
 70038,
 653862651,
 653596661,
 -1,
 -55558,
 653801649,
 70056,
 -1,
 653856449,
 70055,
 -55556,
 653825173,
 70058,
 -55555,
 654011848,
 70059,
 -55554,
 654073063,
 70031,
 -55553,
 654135933,
 70057,
 -55552,
 654194865,
 70066,
 -1,
 654256251,
 70029,
 654452497,
 650219259,
 -1,
 654518023,
 654413397,
 -1,
 654583557,
 654470506,
 70072,
 -1,
 654536042,
 70073,
 654770175,
 654527306,
 70074,
 -1,
 654658378,
 70075,
 654845707,
 654446273,
 -1,
 -55543,
 654804555,
 70079,
 -55542,
 654851679,
 70077,
 -1,
 654905025,
 70067,
 655107853,
 654804555,
 70070,
 -1,
 655066699,
 70071,
 655238927,
 655048287,
 70068,
 -1,
 655179359,
 70069,
 -55536,
 655187175,
 70078,
 -1,
 655304827,
 70076,
 655501090,
 654385870,
 -1,
 655566624,
 655442189,
 -1,
 655632150,
 655523385,
 -1,
 -55531,
 655594130,
 70098,
 -1,
 655637854,
 70099,
 655828761,
 655586702,
 -1,
 -55528,
 655771353,
 70102,
 -1,
 655830912,
 70103,
 656025372,
 655765847,
 -1,
 -55525,
 655975546,
 70100,
 -1,
 656033416,
 70101,
 -55523,
 655988433,
 70096,
 -55522,
 656171006,
 70097,
 -55521,
 656235167,
 70105,
 -1,
 656288565,
 70104,
 -55519,
 655516699,
 70086,
 -1,
 656413602,
 70085,
 656615214,
 655455630,
 -1,
 656680749,
 656556317,
 -1,
 656746279,
 656641524,
 -1,
 -55514,
 656700987,
 70018,
 -1,
 656764592,
 70080,
 656942890,
 656674497,
 -1,
 -55511,
 656903149,
 70081,
 -1,
 656956523,
 70017,
 -55509,
 656902756,
 70083,
 -55508,
 657082309,
 70082,
 -1,
 657136731,
 70016,
 -1,
 656616733,
 70088,
 -55505,
 656564050,
 70084,
 -1,
 657330055,
 70087,
 657532784,
 650152916,
 -1,
 657598319,
 657473262,
 -1,
 657663804,
 657526465,
 -1,
 657729334,
 657616234,
 -1,
 -55499,
 657682229,
 66684,
 -1,
 657729659,
 66680,
 -55497,
 657690697,
 66679,
 -55496,
 657880869,
 66664,
 -55495,
 657933584,
 66682,
 -55494,
 657995931,
 66669,
 -55493,
 658060792,
 66673,
 -1,
 658122116,
 66665,
 658319171,
 657612007,
 -1,
 -55490,
 658279322,
 66668,
 -55489,
 658337130,
 66681,
 -55488,
 658401023,
 66677,
 -55487,
 658462829,
 66666,
 -55486,
 658522449,
 66678,
 -1,
 658575863,
 66676,
 658777929,
 658253947,
 -1,
 658843463,
 658706113,
 -1,
 -55482,
 658800185,
 66672,
 -1,
 658861418,
 66685,
 -55480,
 658797721,
 66683,
 -1,
 658978426,
 66663,
 659171150,
 658734649,
 -1,
 659236685,
 659110043,
 -1,
 -55476,
 659177662,
 66644,
 -1,
 659239248,
 66654,
 -1,
 659186522,
 66641,
 659498834,
 659111519,
 -1,
 -55472,
 659435863,
 66662,
 -55471,
 659496284,
 66674,
 -1,
 659559207,
 66686,
 659760981,
 659461369,
 -1,
 -55468,
 659722092,
 66687,
 -1,
 659754689,
 66648,
 659957592,
 659722898,
 -1,
 -55465,
 659906257,
 66667,
 -1,
 659957883,
 66658,
 660154203,
 659912078,
 -1,
 -55462,
 660114181,
 66646,
 -1,
 660167911,
 66645,
 660350814,
 660099620,
 -1,
 -55459,
 660291997,
 66661,
 -1,
 660351443,
 66656,
 660547425,
 660289691,
 -1,
 -55456,
 660506987,
 66649,
 -1,
 660541214,
 66659,
 -55454,
 660510549,
 66655,
 -55453,
 660704968,
 66653,
 -55452,
 660769235,
 66675,
 -55451,
 660829191,
 66670,
 -55450,
 660891705,
 66640,
 -55449,
 660954210,
 66671,
 -55448,
 661016710,
 66660,
 -55447,
 661080620,
 66642,
 -55446,
 661145621,
 66657,
 -55445,
 661206326,
 66652,
 -55444,
 661271088,
 66643,
 -55443,
 661332954,
 66651,
 -55442,
 661397119,
 66647,
 -1,
 661461426,
 66650,
 -1,
 657533496,
 127847,
 -1,
 657479598,
 9752,
 661792631,
 650067551,
 -1,
 661858165,
 661730421,
 -1,
 -55436,
 661808363,
 983075,
 -1,
 661864929,
 983078,
 -55434,
 661808899,
 128674,
 -1,
 662002697,
 9961,
 662185851,
 661740775,
 -1,
 -55431,
 662147176,
 128703,
 -55430,
 662205647,
 127856,
 -1,
 662266817,
 127776,
 -55428,
 662148179,
 983197,
 -1,
 662383278,
 128017,
 662579211,
 650013876,
 -1,
 662644724,
 662512336,
 -1,
 662710204,
 662576070,
 -1,
 662775738,
 662652889,
 -1,
 662841237,
 662703472,
 -1,
 662906758,
 662768691,
 -1,
 -55420,
 662834764,
 127545,
 -55419,
 662900074,
 127516,
 -1,
 662965293,
 127520,
 663168905,
 662834826,
 -1,
 -55416,
 663096512,
 127511,
 -1,
 663161898,
 127509,
 663365516,
 663096626,
 -1,
 -55413,
 663293231,
 127525,
 -1,
 663358361,
 127540,
 663562127,
 663293130,
 -1,
 -55410,
 663499181,
 127534,
 -1,
 663559485,
 127506,
 -55408,
 663499184,
 127517,
 -55407,
 663692246,
 127532,
 -55406,
 663754783,
 127505,
 -55405,
 663817862,
 127524,
 -55404,
 663883225,
 127546,
 -1,
 663948326,
 127518,
 664151974,
 662769117,
 -1,
 664217498,
 664079411,
 -1,
 -55400,
 664145587,
 127527,
 -55399,
 664210883,
 127537,
 -1,
 664276327,
 127504,
 664479645,
 664145481,
 -1,
 -55396,
 664407690,
 127542,
 -1,
 664473174,
 127543,
 664676256,
 664407408,
 -1,
 -55393,
 664606724,
 127519,
 -1,
 664669882,
 127515,
 664872867,
 664603850,
 -1,
 -55390,
 664800710,
 127528,
 -1,
 664865686,
 127535,
 -55388,
 664809897,
 127526,
 -55387,
 665004395,
 127541,
 -1,
 665062927,
 127513,
 665266094,
 664079895,
 -1,
 665331626,
 665193840,
 -1,
 -55383,
 665259305,
 127544,
 -1,
 665324592,
 127522,
 -55381,
 665264931,
 127521,
 -55380,
 665456438,
 127539,
 -55379,
 665521846,
 127538,
 -1,
 665586712,
 127514,
 665790389,
 665193837,
 -1,
 665855922,
 665717536,
 -1,
 -55375,
 665783946,
 127530,
 -1,
 665848608,
 127529,
 -55373,
 665784115,
 127512,
 -55372,
 665980547,
 127508,
 -1,
 666045635,
 127533,
 666249145,
 665718358,
 -1,
 -55369,
 666182439,
 127536,
 -55368,
 666246117,
 127523,
 -1,
 666308285,
 127510,
 -1,
 666177198,
 127531,
 -55365,
 662724898,
 127378,
 -1,
 666520394,
 127377,
 666707931,
 662653770,
 -1,
 666773464,
 666638066,
 -1,
 -55361,
 666736179,
 127305,
 -55360,
 666801235,
 127304,
 -55359,
 666866591,
 127303,
 -55358,
 666931052,
 127302,
 -55357,
 666995668,
 127301,
 -55356,
 667059787,
 127300,
 -55355,
 667123257,
 127299,
 -55354,
 667186574,
 127298,
 -55353,
 667250026,
 127297,
 -55352,
 667315239,
 127296,
 -55351,
 667379459,
 127295,
 -55350,
 667442407,
 127294,
 -55349,
 667506797,
 127293,
 -55348,
 667570724,
 127292,
 -55347,
 667634506,
 127291,
 -55346,
 667699254,
 127290,
 -55345,
 667764528,
 127289,
 -55344,
 667827807,
 127288,
 -55343,
 667891867,
 127287,
 -55342,
 667956426,
 127286,
 -55341,
 668021079,
 127285,
 -55340,
 668084347,
 127284,
 -55339,
 668148430,
 127283,
 -55338,
 668212166,
 127282,
 -55337,
 668276725,
 127281,
 -1,
 668339905,
 127280,
 668598271,
 666721824,
 -1,
 -55334,
 668492387,
 10191,
 -1,
 668537671,
 10190,
 668739552,
 666662286,
 -1,
 -55331,
 668693902,
 127309,
 -55330,
 668754743,
 127384,
 -55329,
 668803790,
 127308,
 -1,
 668865263,
 9949,
 669067238,
 668682294,
 -1,
 669132773,
 668997234,
 -1,
 -55325,
 669087202,
 127490,
 -55324,
 669141674,
 127489,
 -1,
 669197267,
 127507,
 -1,
 669069648,
 9919,
 669460457,
 669014125,
 -1,
 -55320,
 669398218,
 127382,
 -1,
 669462576,
 127381,
 669657068,
 669397335,
 -1,
 -55317,
 669610034,
 127379,
 -1,
 669672589,
 11820,
 -55315,
 669618241,
 127311,
 -55314,
 669814614,
 127386,
 -55313,
 669878831,
 127385,
 -55312,
 669936381,
 127310,
 -55311,
 669998754,
 127383,
 -55310,
 670062661,
 127307,
 -55309,
 670121914,
 127380,
 -1,
 670187071,
 127306,
 670433279,
 662568960,
 -1,
 670443514,
 670339467,
 -1,
 -55305,
 670403198,
 11028,
 -55304,
 670466884,
 11026,
 -55303,
 670519617,
 11029,
 -1,
 670571217,
 11027,
 670771200,
 670376654,
 -1,
 670836735,
 670716452,
 13175,
 670957567,
 670760960,
 -1,
 -55298,
 670858112,
 13176,
 -1,
 670900818,
 13177,
 -1,
 670779184,
 127376,
 671164419,
 670709915,
 -1,
 -55294,
 671106323,
 127488,
 -1,
 671167690,
 13004,
 671361030,
 671099003,
 -1,
 -55291,
 671321044,
 13006,
 -1,
 671379727,
 13005,
 -55289,
 671321046,
 13278,
 -55288,
 671499909,
 13178,
 -55287,
 671561022,
 13311,
 -55286,
 671626242,
 9974,
 -1,
 671682260,
 13279,
 671885436,
 662537803,
 -1,
 671950965,
 671832173,
 -1,
 672016494,
 671884180,
 -1,
 672081980,
 671960657,
 -1,
 672147475,
 672028781,
 -1,
 -55279,
 672109717,
 7057,
 -55278,
 672150780,
 7053,
 -1,
 672206529,
 7060,
 672409624,
 672084311,
 -1,
 672475159,
 672350710,
 -1,
 -55274,
 672420388,
 7103,
 -1,
 672483382,
 7102,
 -1,
 672403137,
 7062,
 672737307,
 672363918,
 -1,
 -55270,
 672699541,
 7087,
 -1,
 672730817,
 7070,
 672933918,
 672689514,
 -1,
 -55267,
 672870119,
 7099,
 -1,
 672927425,
 7067,
 673130529,
 672877386,
 -1,
 -55264,
 673066727,
 7100,
 -1,
 673124033,
 7068,
 673327140,
 673073206,
 -1,
 -55261,
 673265841,
 7086,
 -1,
 673320641,
 7050,
 673523750,
 673261691,
 7048,
 -1,
 673482315,
 7049,
 673654825,
 673454069,
 -1,
 -55256,
 673593521,
 7101,
 -1,
 673648321,
 7064,
 673851435,
 673582785,
 7043,
 -1,
 673785979,
 7046,
 -55252,
 673814083,
 7056,
 -55251,
 673944725,
 7066,
 -55250,
 674010090,
 7071,
 -55249,
 674074547,
 7069,
 -55248,
 674139114,
 7063,
 -55247,
 674203211,
 7045,
 -55246,
 674266799,
 7058,
 -55245,
 674327605,
 7051,
 -55244,
 674391874,
 7061,
 -55243,
 674454759,
 7047,
 -55242,
 674517629,
 7065,
 -55241,
 674580302,
 7055,
 -55240,
 674643551,
 7044,
 -55239,
 674707633,
 7072,
 -55238,
 674772220,
 7052,
 -55237,
 674833195,
 7059,
 -1,
 674896866,
 7054,
 675096650,
 672015600,
 -1,
 675162176,
 675053113,
 -1,
 -55233,
 675123858,
 7090,
 -1,
 675167582,
 7091,
 675358787,
 675116430,
 -1,
 -55230,
 675301081,
 7094,
 -1,
 675360640,
 7095,
 675555398,
 675295575,
 -1,
 -55227,
 675505274,
 7092,
 -1,
 675563144,
 7093,
 -55225,
 675518161,
 7088,
 -55224,
 675700734,
 7089,
 -55223,
 675764895,
 7097,
 -1,
 675818293,
 7096,
 676014164,
 675048405,
 -1,
 676079694,
 675964675,
 -1,
 -55219,
 676039460,
 7362,
 -1,
 676074489,
 7361,
 -55217,
 676036007,
 7360,
 -55216,
 676220585,
 7364,
 -55215,
 676284555,
 7365,
 -55214,
 676340541,
 7366,
 -55213,
 676404233,
 7363,
 -1,
 676468781,
 7367,
 676669532,
 675974919,
 -1,
 676735067,
 676616301,
 -1,
 -55209,
 676697638,
 7077,
 -55208,
 676749118,
 7079,
 -55207,
 676804354,
 7076,
 -55206,
 676867868,
 7081,
 -1,
 676925575,
 7078,
 -1,
 676681139,
 7080,
 677193829,
 676624529,
 -1,
 677259364,
 677144386,
 -1,
 677324899,
 677206125,
 -1,
 677390434,
 677262538,
 -1,
 -55199,
 677351802,
 7042,
 -1,
 677399716,
 7041,
 -1,
 677352710,
 7040,
 -1,
 677270148,
 7082,
 -1,
 677219862,
 7083,
 677783661,
 677126333,
 -1,
 677849193,
 677738035,
 -1,
 -55192,
 677810099,
 7085,
 -1,
 677859965,
 7084,
 678045804,
 677797011,
 -1,
 -55189,
 677986637,
 7075,
 -1,
 678040082,
 7074,
 -1,
 677992080,
 7073,
 -1,
 677713763,
 7098,
 678373488,
 671970169,
 127749,
 -1,
 678298706,
 127748,
 678504563,
 678297600,
 -1,
 -55182,
 678465947,
 127774,
 -1,
 678500661,
 9925,
 -55180,
 678459146,
 127751,
 -1,
 678638467,
 127803,
 678832248,
 671905166,
 -1,
 -55177,
 678783084,
 128671,
 -1,
 678836963,
 127843,
 679028858,
 678762485,
 983102,
 -1,
 678984823,
 983101,
 -55173,
 678981898,
 127940,
 -1,
 679110854,
 10185,
 679291081,
 671847507,
 -1,
 679356601,
 679235825,
 -1,
 679422122,
 679300689,
 -1,
 679487621,
 679378489,
 -1,
 679553155,
 679444025,
 -1,
 -55166,
 679501031,
 43024,
 -1,
 679558228,
 43025,
 -55164,
 679501031,
 43028,
 -1,
 679689300,
 43029,
 679880843,
 679420622,
 -1,
 679946377,
 679813838,
 -1,
 -55160,
 679894247,
 43026,
 -1,
 679951444,
 43027,
 -55158,
 679894247,
 43030,
 -1,
 680082516,
 43031,
 680274062,
 679832938,
 -1,
 -55155,
 680227829,
 43040,
 -1,
 680287463,
 43038,
 680470673,
 680224515,
 -1,
 -55152,
 680418535,
 43033,
 -1,
 680475732,
 43034,
 680667284,
 680413238,
 -1,
 -55149,
 680615143,
 43015,
 -1,
 680672340,
 43016,
 680863895,
 680609584,
 -1,
 -55146,
 680811751,
 43022,
 -1,
 680868948,
 43023,
 681060506,
 680801482,
 -1,
 -55143,
 681008359,
 43017,
 -1,
 681065556,
 43018,
 681257117,
 680991686,
 -1,
 -55140,
 681204967,
 43020,
 -1,
 681262164,
 43021,
 681453728,
 681187317,
 -1,
 -55137,
 681401575,
 43035,
 -1,
 681458772,
 43036,
 -55135,
 681412171,
 43011,
 -55134,
 681605807,
 43041,
 -55133,
 681663719,
 43013,
 -55132,
 681728807,
 43032,
 -55131,
 681793281,
 43037,
 -55130,
 681857126,
 43039,
 -55129,
 681918047,
 43009,
 -55128,
 681983060,
 43042,
 -55127,
 682043515,
 43012,
 -1,
 682102465,
 43008,
 682305712,
 679382779,
 -1,
 -55124,
 682264139,
 43045,
 -55123,
 682320120,
 43047,
 -55122,
 682376799,
 43044,
 -55121,
 682436731,
 43046,
 -1,
 682495681,
 43043,
 682698933,
 682256913,
 -1,
 -55118,
 682626354,
 43051,
 -55117,
 682691786,
 43050,
 -55116,
 682757171,
 43049,
 -1,
 682822563,
 43048,
 683081727,
 682653841,
 -1,
 -55113,
 682965489,
 43014,
 -55112,
 683026520,
 43010,
 -1,
 683086940,
 43019,
 683288774,
 679309648,
 -1,
 683354309,
 683216854,
 -1,
 683419844,
 683298385,
 -1,
 683485376,
 683375291,
 -1,
 -55106,
 683448108,
 1869,
 -55105,
 683493896,
 1870,
 -1,
 683553299,
 1871,
 683802623,
 683436255,
 -1,
 -55102,
 683685548,
 1838,
 -55101,
 683746418,
 1839,
 -1,
 683809193,
 1837,
 -1,
 683375957,
 983201,
 -1,
 683301459,
 128137,
 684140744,
 683235437,
 983094,
 -1,
 684072547,
 983093,
 -1,
 684086430,
 8527,
 684337410,
 679238887,
 983077,
 684402934,
 684289491,
 -1,
 684468456,
 684346961,
 -1,
 684533968,
 684415085,
 -1,
 -55090,
 684496028,
 69857,
 -55089,
 684537146,
 69847,
 -1,
 684593519,
 69849,
 684796115,
 684479101,
 -1,
 -55086,
 684734619,
 69846,
 -1,
 684796027,
 69864,
 684992726,
 684730491,
 -1,
 -55083,
 684931227,
 69863,
 -1,
 684993280,
 69859,
 -55081,
 684954780,
 69852,
 -55080,
 685149173,
 69850,
 -55079,
 685213745,
 69861,
 -55078,
 685276923,
 69841,
 -55077,
 685340153,
 69840,
 -55076,
 685403687,
 69853,
 -55075,
 685467499,
 69851,
 -55074,
 685530745,
 69862,
 -55073,
 685591560,
 69848,
 -55072,
 685656268,
 69855,
 -55071,
 685721434,
 69856,
 -55070,
 685785401,
 69860,
 -55069,
 685848798,
 69854,
 -55068,
 685913402,
 69845,
 -55067,
 685974366,
 69844,
 -55066,
 686038021,
 69843,
 -55065,
 686102601,
 69842,
 -1,
 686166383,
 69858,
 686424063,
 684401904,
 -1,
 686434540,
 686325305,
 -1,
 -55061,
 686396050,
 69874,
 -1,
 686439774,
 69875,
 686631151,
 686388622,
 -1,
 -55058,
 686573273,
 69878,
 -1,
 686632832,
 69879,
 686827762,
 686567767,
 -1,
 -55055,
 686777466,
 69876,
 -1,
 686835336,
 69877,
 -55053,
 686790353,
 69872,
 -55052,
 686972926,
 69873,
 -55051,
 687037087,
 69881,
 -1,
 687090485,
 69880,
 687286525,
 684362664,
 -1,
 687352058,
 687247468,
 -1,
 -55047,
 687313062,
 11011,
 -1,
 687348254,
 11019,
 687603711,
 687286704,
 -1,
 -55044,
 687509670,
 11010,
 -1,
 687544862,
 11018,
 -55042,
 687240590,
 983181,
 -55041,
 687693781,
 128284,
 -55040,
 687749275,
 983043,
 -55039,
 687813767,
 127846,
 -1,
 687873350,
 9917,
 688072991,
 684293689,
 983189,
 688138514,
 688000705,
 -1,
 688204044,
 688092360,
 -1,
 688269576,
 688158094,
 -1,
 -55033,
 688227425,
 983180,
 -1,
 688270222,
 983132,
 -55031,
 688226507,
 983044,
 -55030,
 688417652,
 983175,
 -55029,
 688470565,
 983042,
 -1,
 688535631,
 983174,
 688728335,
 688160313,
 -1,
 -55026,
 688687120,
 128509,
 -1,
 688735472,
 128649,
 688979967,
 688665174,
 -1,
 -55023,
 688863884,
 9882,
 -1,
 688918727,
 9877,
 689121561,
 688090474,
 -1,
 689187096,
 689049281,
 -1,
 689252631,
 689127618,
 -1,
 -55018,
 689199644,
 9188,
 -1,
 689243672,
 128207,
 -1,
 689213492,
 127827,
 -1,
 689128244,
 983188,
 689580316,
 689056133,
 -1,
 -55013,
 689521311,
 127836,
 -1,
 689570540,
 128642,
 -55011,
 689542047,
 983045,
 -55010,
 689730958,
 983169,
 -1,
 689791553,
 9201,
 689973556,
 688023299,
 983117,
 690039084,
 689907835,
 -1,
 690104616,
 689967607,
 -1,
 690170151,
 690040161,
 128264,
 690290687,
 690096036,
 -1,
 -55003,
 690192817,
 128266,
 -55002,
 690249806,
 128265,
 -1,
 690297889,
 128263,
 -1,
 690096754,
 128586,
 690563371,
 690038907,
 -1,
 -54998,
 690496447,
 128676,
 -1,
 690560421,
 128172,
 -1,
 690518677,
 8375,
 690825521,
 689966785,
 983176,
 690891056,
 690779087,
 -1,
 -54993,
 690832114,
 128150,
 -1,
 690892332,
 10024,
 -1,
 690828993,
 127837,
 -54990,
 690775318,
 128051,
 -54989,
 691096653,
 128166,
 -1,
 691160352,
 128026,
 691349837,
 689918500,
 -1,
 691415368,
 691289695,
 -1,
 691480903,
 691359613,
 -1,
 691546436,
 691417532,
 -1,
 691611965,
 691495324,
 128515,
 691732479,
 691535930,
 -1,
 -54981,
 691634718,
 128518,
 -54980,
 691698312,
 128516,
 -1,
 691740696,
 128517,
 691939649,
 691550363,
 -1,
 -54977,
 691888888,
 128520,
 -54976,
 691939737,
 128525,
 -1,
 691999441,
 128519,
 692256767,
 691893646,
 -1,
 -54973,
 692160901,
 128526,
 -1,
 692213338,
 128522,
 692453375,
 691477742,
 -1,
 -54970,
 692347292,
 128570,
 -1,
 692402750,
 128571,
 -1,
 691434436,
 128527,
 692660556,
 691344053,
 -1,
 -54966,
 692618674,
 68411,
 -54965,
 692675174,
 128312,
 -1,
 692722314,
 128313,
 -1,
 692608694,
 128684,
 692988256,
 691289695,
 983080,
 693053790,
 692934765,
 -1,
 693119321,
 692991859,
 -1,
 693184854,
 693043200,
 -1,
 693250388,
 693139459,
 -1,
 -54957,
 693211794,
 983154,
 -1,
 693255518,
 983157,
 -54955,
 693188564,
 983182,
 -1,
 693378491,
 983184,
 693633023,
 693111525,
 -1,
 -54952,
 693505226,
 983158,
 -1,
 693570611,
 983155,
 693829631,
 693057784,
 -1,
 693840221,
 693726570,
 -1,
 -54948,
 693775654,
 983914,
 -1,
 693834238,
 983913,
 -1,
 693802221,
 983912,
 -54945,
 693015475,
 128303,
 -1,
 694046438,
 128510,
 694233449,
 692922491,
 -1,
 694298980,
 694167675,
 -1,
 -54941,
 694232446,
 127793,
 -1,
 694291058,
 128584,
 -54939,
 694260803,
 9913,
 -54938,
 694451859,
 983168,
 -54937,
 694516643,
 9916,
 -54936,
 694572727,
 9914,
 -1,
 694621796,
 128186,
 694823282,
 694176586,
 -1,
 694888815,
 694758062,
 -1,
 694954350,
 694829722,
 -1,
 -54931,
 694910454,
 128164,
 -1,
 694956471,
 128564,
 -1,
 694916202,
 128554,
 -54928,
 694838109,
 127920,
 -54927,
 695156567,
 127829,
 -1,
 695211889,
 42611,
 695413112,
 694754246,
 -1,
 695478645,
 695352488,
 127979,
 -1,
 695404073,
 127890,
 -54922,
 695432255,
 128220,
 -54921,
 695549535,
 983185,
 -1,
 695603842,
 9878,
 695806335,
 695359597,
 -1,
 695871868,
 695756399,
 -1,
 -54917,
 695817140,
 9924,
 -1,
 695868058,
 127938,
 696123391,
 695799489,
 -1,
 -54914,
 696011131,
 128013,
 -1,
 696074577,
 128012,
 696265091,
 695760270,
 -1,
 -54911,
 696192705,
 983133,
 -54910,
 696257738,
 983159,
 -1,
 696323123,
 983156,
 696527240,
 696207414,
 -1,
 696592775,
 696467039,
 -1,
 -54906,
 696528225,
 9975,
 -1,
 696582266,
 127935,
 -1,
 696551557,
 128128,
 696854923,
 696487788,
 -1,
 -54902,
 696813935,
 8275,
 -1,
 696861143,
 127946,
 -1,
 696792565,
 983183,
 697117842,
 637406913,
 -1,
 697183024,
 697068906,
 -1,
 697248556,
 697110425,
 -1,
 697314086,
 697171968,
 -1,
 697379405,
 697258621,
 -1,
 697444940,
 697336097,
 -1,
 697510331,
 697377486,
 -1,
 697575864,
 697457895,
 -1,
 697641395,
 697534353,
 -1,
 697706907,
 697597497,
 -1,
 697772441,
 697645211,
 -1,
 -54888,
 697707264,
 126646,
 -1,
 697766423,
 126648,
 -54886,
 697707264,
 126645,
 -1,
 697897327,
 126632,
 698100127,
 697660814,
 -1,
 -54883,
 698038892,
 126644,
 -54882,
 698100389,
 126638,
 -1,
 698159175,
 126641,
 698362274,
 698062403,
 -1,
 -54879,
 698302945,
 126630,
 -1,
 698366107,
 126650,
 698558885,
 698295083,
 -1,
 -54876,
 698501962,
 126627,
 -1,
 698557134,
 126649,
 -54874,
 698520848,
 126633,
 -54873,
 698716180,
 126629,
 -54872,
 698773603,
 126643,
 -54871,
 698838077,
 126642,
 -54870,
 698899258,
 126637,
 -54869,
 698963258,
 126636,
 -54868,
 699026452,
 126635,
 -54867,
 699091438,
 126647,
 -54866,
 699156351,
 126626,
 -54865,
 699218142,
 126631,
 -54864,
 699283110,
 126651,
 -54863,
 699347513,
 126640,
 -54862,
 699406631,
 126625,
 -1,
 699470259,
 126639,
 699727871,
 697598693,
 -1,
 -54859,
 699624509,
 126495,
 -54858,
 699685690,
 126493,
 -54857,
 699740729,
 126494,
 -1,
 699799847,
 126492,
 700055551,
 697503425,
 -1,
 -54854,
 699943754,
 126467,
 -1,
 699998926,
 126489,
 700197344,
 697453386,
 -1,
 700262879,
 700145973,
 -1,
 700328387,
 700218937,
 -1,
 700393921,
 700266651,
 -1,
 -54848,
 700328704,
 126614,
 -1,
 700387863,
 126616,
 -54846,
 700328704,
 126613,
 -1,
 700518767,
 126600,
 700721607,
 700282254,
 -1,
 -54843,
 700660332,
 126612,
 -54842,
 700721829,
 126606,
 -1,
 700780615,
 126609,
 700983754,
 700683843,
 -1,
 -54839,
 700924385,
 126598,
 -1,
 700987547,
 126618,
 701180365,
 700922011,
 -1,
 -54836,
 701115136,
 126596,
 -1,
 701174127,
 126599,
 701376976,
 701113131,
 -1,
 -54833,
 701320010,
 126595,
 -1,
 701375182,
 126617,
 701573587,
 701304513,
 -1,
 -54830,
 701517121,
 126592,
 -1,
 701579745,
 126607,
 -54828,
 701535504,
 126601,
 -54827,
 701730836,
 126597,
 -54826,
 701788259,
 126611,
 -54825,
 701852733,
 126610,
 -54824,
 701913914,
 126605,
 -54823,
 701977914,
 126604,
 -54822,
 702041108,
 126603,
 -54821,
 702106094,
 126615,
 -54820,
 702171007,
 126594,
 -54819,
 702232230,
 126619,
 -54818,
 702296633,
 126608,
 -1,
 702355751,
 126593,
 -1,
 700191478,
 126475,
 702622210,
 700151182,
 -1,
 702687743,
 702579728,
 -1,
 702753254,
 702643769,
 -1,
 -54812,
 702691953,
 126582,
 -54811,
 702753536,
 126581,
 -1,
 702812527,
 126568,
 703015402,
 702707086,
 -1,
 -54808,
 702954092,
 126580,
 -54807,
 703015589,
 126574,
 -1,
 703074375,
 126577,
 703277551,
 702948046,
 -1,
 703343086,
 703226828,
 -1,
 -54803,
 703279673,
 126590,
 -1,
 703338791,
 126588,
 -1,
 703270983,
 126585,
 703605234,
 703219766,
 -1,
 -54799,
 703543518,
 126583,
 -1,
 703598841,
 126570,
 703801845,
 703543451,
 -1,
 -54796,
 703736576,
 126564,
 -1,
 703795567,
 126567,
 -54794,
 703764038,
 126586,
 -54793,
 703960336,
 126569,
 -54792,
 704015421,
 126578,
 -54791,
 704076602,
 126573,
 -54790,
 704140602,
 126572,
 -54789,
 704202623,
 126562,
 -54788,
 704263846,
 126587,
 -54787,
 704328249,
 126576,
 -54786,
 704387367,
 126561,
 -1,
 704450995,
 126575,
 -54784,
 702626412,
 126484,
 -54783,
 704588453,
 126478,
 -1,
 704647239,
 126481,
 704850459,
 702563210,
 -1,
 704915975,
 704804238,
 -1,
 -54779,
 704854636,
 126516,
 -54778,
 704916133,
 126510,
 -1,
 704974919,
 126513,
 705178122,
 704871993,
 -1,
 -54775,
 705116785,
 126518,
 -1,
 705178368,
 126517,
 705374733,
 705120310,
 -1,
 -54772,
 705312990,
 126519,
 -1,
 705368313,
 126506,
 705571344,
 705312923,
 -1,
 -54769,
 705506048,
 126500,
 -1,
 705565039,
 126503,
 -54767,
 705533200,
 126505,
 -54766,
 705719357,
 126514,
 -54765,
 705780538,
 126509,
 -54764,
 705844538,
 126508,
 -54763,
 705907732,
 126507,
 -54762,
 705972095,
 126498,
 -54761,
 706033318,
 126523,
 -54760,
 706097721,
 126512,
 -54759,
 706159436,
 126521,
 -54758,
 706222375,
 126497,
 -1,
 706286003,
 126511,
 706488885,
 704806457,
 -1,
 706554417,
 706416321,
 -1,
 706619952,
 706494826,
 -1,
 706685474,
 706573710,
 -1,
 -54752,
 706624108,
 126548,
 -54751,
 706685605,
 126542,
 -1,
 706744391,
 126545,
 706947623,
 706618062,
 -1,
 707013158,
 706896844,
 -1,
 -54747,
 706964541,
 126559,
 -1,
 707025722,
 126557,
 -1,
 706940999,
 126553,
 -54744,
 706909456,
 126537,
 -54743,
 707226685,
 126546,
 -54742,
 707287866,
 126541,
 -54741,
 707349524,
 126539,
 -54740,
 707414510,
 126551,
 -54739,
 707479423,
 126530,
 -54738,
 707541214,
 126535,
 -54737,
 707606182,
 126555,
 -1,
 707662259,
 126543,
 -1,
 706558107,
 126472,
 707930676,
 706492571,
 -1,
 -54733,
 707865344,
 126486,
 -1,
 707924503,
 126488,
 -1,
 707865344,
 126485,
 708192824,
 706451011,
 -1,
 -54729,
 708133345,
 126470,
 -1,
 708196507,
 126490,
 708389435,
 708141497,
 -1,
 -54726,
 708334922,
 126704,
 -1,
 708393186,
 126705,
 708586046,
 708331574,
 -1,
 -54723,
 708524254,
 126487,
 -1,
 708579577,
 126474,
 708782657,
 708513473,
 -1,
 -54720,
 708726081,
 126464,
 -1,
 708788705,
 126479,
 -54718,
 708744464,
 126473,
 -54717,
 708939796,
 126469,
 -54716,
 708997219,
 126483,
 -54715,
 709061693,
 126482,
 -54714,
 709122874,
 126477,
 -54713,
 709186874,
 126476,
 -54712,
 709248895,
 126466,
 -54711,
 709310686,
 126471,
 -54710,
 709375654,
 126491,
 -54709,
 709440057,
 126480,
 -1,
 709499175,
 126465,
 -1,
 697398190,
 1624,
 709765825,
 697322314,
 -1,
 709831360,
 709699707,
 -1,
 709896893,
 709788886,
 -1,
 709962336,
 709833047,
 -1,
 710027867,
 709891517,
 -1,
 710093399,
 709963920,
 -1,
 710158934,
 710049337,
 -1,
 -54699,
 710120089,
 1909,
 -1,
 710163817,
 1910,
 -1,
 710095863,
 1911,
 710421082,
 710049337,
 -1,
 -54695,
 710382260,
 1598,
 -1,
 710425994,
 1599,
 -1,
 710362336,
 1597,
 710737919,
 709962499,
 -1,
 710748767,
 710639161,
 -1,
 -54690,
 710709954,
 1888,
 -1,
 710753741,
 1889,
 -1,
 710682084,
 2212,
 711010923,
 709892395,
 -1,
 711076455,
 710966841,
 -1,
 711141990,
 711015807,
 -1,
 711207525,
 711092836,
 1874,
 -1,
 711131282,
 1875,
 -1,
 711146732,
 1872,
 -1,
 711103184,
 1876,
 711469673,
 711031367,
 1878,
 -1,
 711393478,
 2208,
 -54678,
 711410889,
 1877,
 -1,
 711534052,
 1873,
 711731829,
 710962538,
 -1,
 711797364,
 711666435,
 -1,
 711862896,
 711751054,
 -1,
 -54673,
 711820428,
 1883,
 -1,
 711873355,
 1905,
 -54671,
 711820756,
 1899,
 -54670,
 712003793,
 2218,
 -54669,
 712066272,
 1775,
 -1,
 712128833,
 1900,
 -1,
 711745148,
 2220,
 712387201,
 711673910,
 -1,
 712452734,
 712321823,
 -1,
 712518269,
 712408633,
 -1,
 712583804,
 712457599,
 -1,
 -54662,
 712534628,
 1892,
 -54661,
 712579394,
 1596,
 -1,
 712642480,
 1891,
 -1,
 712544948,
 1595,
 -1,
 712451501,
 1890,
 713031679,
 712380097,
 -1,
 -54656,
 712931361,
 1568,
 -1,
 712978832,
 1919,
 713173645,
 712325275,
 -1,
 713239180,
 713101682,
 -1,
 713304712,
 713193865,
 -1,
 713370247,
 713232065,
 -1,
 -54650,
 713316663,
 1903,
 -1,
 713366251,
 1906,
 -1,
 713300290,
 1902,
 713632395,
 713260601,
 -1,
 -54646,
 713593524,
 1879,
 -1,
 713637325,
 1880,
 -1,
 713568468,
 1916,
 -1,
 713173772,
 1791,
 713960083,
 713127608,
 -1,
 -54641,
 713917908,
 1901,
 -54640,
 713980322,
 1904,
 -54639,
 714032352,
 1918,
 -54638,
 714093604,
 1884,
 -1,
 714158253,
 1917,
 714353308,
 713887425,
 -1,
 714418841,
 714293736,
 -1,
 714484376,
 714379947,
 -1,
 -54633,
 714444218,
 1887,
 -1,
 714477488,
 1885,
 -1,
 714423722,
 1886,
 714801151,
 714362181,
 -1,
 -54629,
 714707609,
 1907,
 -1,
 714751337,
 1908,
 714943139,
 714315028,
 -1,
 715008672,
 714904100,
 -1,
 -54625,
 714946881,
 2216,
 -1,
 715007405,
 2217,
 715259903,
 714938548,
 -1,
 -54622,
 715166361,
 1914,
 -1,
 715210089,
 1915,
 715401896,
 714903576,
 -1,
 715467431,
 715337979,
 -1,
 -54618,
 715428505,
 1912,
 -1,
 715472233,
 1913,
 -1,
 715400746,
 2219,
 715729581,
 715348799,
 -1,
 715795116,
 715684226,
 -1,
 -54613,
 715754452,
 1897,
 -1,
 715816699,
 1896,
 -1,
 715752867,
 1895,
 716057266,
 715674943,
 -1,
 716122801,
 715990440,
 -1,
 -54608,
 716052802,
 1894,
 -1,
 716115888,
 1893,
 -1,
 716079505,
 2215,
 716384951,
 715989864,
 -1,
 716450486,
 716325955,
 -1,
 -54603,
 716409812,
 1774,
 -1,
 716470877,
 1882,
 -1,
 716408302,
 1881,
 716712634,
 716327960,
 -1,
 -54599,
 716646053,
 2214,
 -1,
 716707970,
 1898,
 -54597,
 716668671,
 2211,
 -54596,
 716860481,
 2213,
 -1,
 716916612,
 2210,
 717160447,
 709833849,
 -1,
 -54593,
 717035842,
 2297,
 -1,
 717098928,
 2295,
 -1,
 709771405,
 65021,
 717368050,
 709719438,
 -1,
 717433564,
 717329803,
 -1,
 717499088,
 717389369,
 -1,
 717564618,
 717460139,
 -1,
 717630152,
 717524398,
 -1,
 -54585,
 717560130,
 64446,
 -1,
 717623216,
 64445,
 -54583,
 717560130,
 64437,
 -1,
 717754288,
 64436,
 718012415,
 717503871,
 -1,
 718023374,
 717908534,
 -1,
 -54579,
 717953346,
 64441,
 -1,
 718016432,
 64440,
 -54577,
 717953346,
 64439,
 -1,
 718147504,
 64438,
 718351061,
 717432196,
 -1,
 718416596,
 718306875,
 -1,
 -54573,
 718346562,
 64435,
 -1,
 718409648,
 64434,
 -1,
 718374777,
 64444,
 718678744,
 718305852,
 -1,
 -54569,
 718608706,
 64449,
 -1,
 718671792,
 64448,
 718875355,
 718615577,
 -1,
 -54566,
 718805314,
 64443,
 -1,
 718868400,
 64442,
 -1,
 718828270,
 64447,
 719137512,
 717373725,
 -1,
 719203042,
 719091170,
 -1,
 -54561,
 719149285,
 1537,
 -54560,
 719214664,
 1540,
 -54559,
 719278070,
 1552,
 -1,
 719336098,
 1539,
 719530725,
 719154632,
 -1,
 -54556,
 719469635,
 1554,
 -1,
 719529089,
 1555,
 -54554,
 719486777,
 1556,
 -54553,
 719673025,
 1551,
 -1,
 719721036,
 1553,
 719923953,
 719082302,
 -1,
 719989486,
 719862597,
 -1,
 -54549,
 719951438,
 1559,
 -54548,
 720015380,
 2291,
 -54547,
 720076539,
 1557,
 -1,
 720129805,
 1558,
 -54545,
 719931688,
 1562,
 -54544,
 720253436,
 1560,
 -1,
 720315263,
 1561,
 -1,
 719882142,
 1622,
 720579326,
 717323833,
 -1,
 720644861,
 720527362,
 -1,
 720710391,
 720602521,
 -1,
 -54538,
 720640322,
 2286,
 -1,
 720703408,
 2283,
 720907002,
 720658449,
 -1,
 -54535,
 720836930,
 2285,
 -1,
 720900016,
 2282,
 721158143,
 720851158,
 -1,
 -54532,
 721033538,
 2287,
 -1,
 721096624,
 2284,
 -1,
 720597833,
 1566,
 721365765,
 720511622,
 -1,
 721431297,
 721307944,
 2278,
 -1,
 721387388,
 2281,
 721562371,
 721367548,
 2276,
 -1,
 721518460,
 2279,
 721747967,
 721494911,
 2277,
 -1,
 721649532,
 2280,
 721824524,
 721317226,
 -1,
 721890058,
 721764557,
 -1,
 721955593,
 721817520,
 2296,
 -1,
 721881174,
 2301,
 -1,
 721885506,
 2298,
 -54517,
 721825788,
 1629,
 -1,
 722081730,
 1544,
 722283282,
 721760599,
 -1,
 722348817,
 722212503,
 -1,
 -54513,
 722306448,
 1630,
 -54512,
 722367214,
 2292,
 -1,
 722412973,
 2293,
 -1,
 722297148,
 1538,
 722676504,
 722215630,
 -1,
 722742037,
 722625593,
 2299,
 -1,
 722667606,
 2300,
 722927615,
 722669249,
 -1,
 -54505,
 722829256,
 1549,
 -1,
 722884307,
 2302,
 723069724,
 722636539,
 -1,
 -54502,
 723024463,
 1626,
 -54501,
 723076274,
 1627,
 -1,
 723133914,
 1628,
 723331872,
 723018093,
 -1,
 -54498,
 723274051,
 2290,
 -54497,
 723333634,
 2288,
 -1,
 723395461,
 2289,
 -54495,
 723294044,
 1625,
 -54494,
 723554307,
 1631,
 -54493,
 723610111,
 1550,
 -54492,
 723672119,
 1536,
 -54491,
 723732782,
 2294,
 -1,
 723797111,
 1623,
 724041727,
 697240138,
 -1,
 724052778,
 723937439,
 -1,
 -54487,
 724009034,
 1546,
 -1,
 724063846,
 1545,
 -54485,
 723989556,
 1543,
 -1,
 724181576,
 1542,
 724380463,
 697205238,
 -1,
 -54482,
 724335625,
 127912,
 -1,
 724378208,
 128667,
 -1,
 724325794,
 1423,
 724642778,
 697125706,
 -1,
 724708308,
 724573715,
 -1,
 724773707,
 724661646,
 -1,
 724839229,
 724731467,
 -1,
 724904764,
 724769405,
 -1,
 724970299,
 724838613,
 -1,
 725035833,
 724923930,
 -1,
 -54472,
 724967631,
 128807,
 -1,
 725029962,
 128814,
 -54470,
 724967631,
 128802,
 -1,
 725161034,
 128812,
 -1,
 724911344,
 128862,
 -1,
 724848346,
 128781,
 725494595,
 724767255,
 -1,
 725560130,
 725450297,
 128788,
 725680127,
 725484407,
 -1,
 -54463,
 725557462,
 128806,
 -1,
 725619786,
 128813,
 -1,
 725486060,
 128825,
 725887815,
 725450297,
 -1,
 725953350,
 725839640,
 128860,
 -1,
 725879267,
 128861,
 -1,
 725882255,
 128850,
 -54456,
 725838183,
 128839,
 -54455,
 726097182,
 128852,
 -54454,
 726155649,
 128795,
 -1,
 726211970,
 128847,
 726412126,
 724700865,
 -1,
 726477651,
 726363263,
 -1,
 726543186,
 726401024,
 -1,
 726608720,
 726502965,
 128776,
 -1,
 726534627,
 128777,
 726794239,
 726560861,
 128774,
 -1,
 726665699,
 128775,
 -1,
 726479843,
 128773,
 726936408,
 726420298,
 -1,
 727001942,
 726878440,
 128822,
 -1,
 726927843,
 128823,
 -54441,
 726960297,
 128837,
 -1,
 727067600,
 128874,
 -54439,
 726895375,
 128829,
 -54438,
 727218154,
 128855,
 -54437,
 727282871,
 128826,
 -54436,
 727342055,
 128811,
 -54435,
 727405367,
 128859,
 -1,
 727467280,
 128769,
 727657330,
 726342598,
 -1,
 727722858,
 727608682,
 -1,
 727788390,
 727680983,
 128869,
 727908351,
 727714270,
 -1,
 -54429,
 727780720,
 128873,
 -54428,
 727846194,
 128872,
 -54427,
 727911626,
 128871,
 -1,
 727977011,
 128870,
 728236031,
 727735712,
 -1,
 728247145,
 728113359,
 128803,
 -1,
 728173027,
 128804,
 -1,
 728188237,
 128798,
 728443758,
 727649985,
 -1,
 -54420,
 728394759,
 128846,
 -54419,
 728453649,
 128844,
 -1,
 728508443,
 128848,
 728705905,
 728392162,
 -1,
 -54416,
 728654487,
 128800,
 -1,
 728699966,
 128805,
 -1,
 728646590,
 128787,
 728968066,
 727608682,
 -1,
 729033600,
 728901755,
 -1,
 729099133,
 728971370,
 128818,
 729164665,
 729024990,
 -1,
 -54409,
 729091378,
 128821,
 -54408,
 729156810,
 128820,
 -1,
 729222195,
 128819,
 729481215,
 729088887,
 -1,
 729492348,
 729355338,
 128816,
 -1,
 729418211,
 128817,
 -1,
 729433421,
 128799,
 729688959,
 729027237,
 128827,
 -1,
 729614819,
 128828,
 -1,
 729645923,
 128877,
 729939967,
 728980862,
 128792,
 -1,
 729811427,
 128793,
 730016653,
 728897525,
 -1,
 730082183,
 729965173,
 128834,
 730202111,
 730008030,
 -1,
 -54394,
 730074314,
 128836,
 -1,
 730139699,
 128835,
 730344330,
 730011279,
 -1,
 -54391,
 730303501,
 128876,
 -1,
 730354745,
 128875,
 -54389,
 730296721,
 128857,
 -54388,
 730483630,
 128783,
 -1,
 730547631,
 128830,
 730737559,
 729975764,
 -1,
 730803094,
 730676831,
 -1,
 730868628,
 730749373,
 128778,
 730934163,
 730794462,
 -1,
 -54382,
 730860746,
 128780,
 -1,
 730926131,
 128779,
 -1,
 730858364,
 128815,
 731250687,
 730825831,
 128790,
 -1,
 731122147,
 128791,
 -1,
 730738098,
 128808,
 731392929,
 730687235,
 -1,
 731458460,
 731340007,
 -1,
 731523995,
 731418692,
 128843,
 -1,
 731458095,
 128858,
 -1,
 731479625,
 128856,
 731720607,
 731416139,
 -1,
 -54370,
 731677690,
 128868,
 -1,
 731738582,
 128867,
 -54368,
 731672551,
 128863,
 -1,
 731855782,
 128782,
 732048297,
 731348537,
 -1,
 732113829,
 731988449,
 -1,
 -54364,
 732045885,
 128840,
 -1,
 732103584,
 128809,
 732310439,
 732042700,
 128831,
 -1,
 732236259,
 128832,
 -54360,
 732269503,
 128845,
 -1,
 732393878,
 128849,
 732572592,
 731992612,
 -1,
 732638126,
 732507553,
 128784,
 732758015,
 732563934,
 -1,
 -54355,
 732630218,
 128786,
 -1,
 732695603,
 128785,
 -54353,
 732586219,
 128881,
 -1,
 732828902,
 128824,
 733031351,
 732510363,
 -1,
 733096884,
 732978407,
 -1,
 -54349,
 733055681,
 128878,
 -1,
 733115566,
 128854,
 733347839,
 733024922,
 -1,
 -54346,
 733242472,
 128883,
 -1,
 733292505,
 128882,
 733490109,
 732963534,
 -1,
 733555644,
 733431140,
 -1,
 733621179,
 733510365,
 128865,
 -1,
 733546979,
 128866,
 -1,
 733577836,
 128864,
 -1,
 733485005,
 128880,
 733883329,
 733431117,
 -1,
 733948864,
 733807520,
 128796,
 -1,
 733874659,
 128797,
 -1,
 733874694,
 128801,
 734145476,
 733843379,
 -1,
 -54333,
 734106527,
 128842,
 -1,
 734167155,
 128772,
 734342087,
 734096705,
 -1,
 -54330,
 734288857,
 128768,
 -1,
 734338882,
 128833,
 734538698,
 734288490,
 -1,
 -54327,
 734495729,
 128789,
 -1,
 734541538,
 128879,
 734735309,
 734481226,
 -1,
 -54324,
 734682556,
 128851,
 -1,
 734734711,
 128810,
 734931920,
 734672074,
 -1,
 -54321,
 734890153,
 128841,
 -1,
 734944987,
 128794,
 -54319,
 734890761,
 128853,
 -54318,
 735075979,
 128838,
 -54317,
 735130348,
 128770,
 -1,
 735193514,
 128771,
 735390679,
 724641915,
 -1,
 -54314,
 735343813,
 983054,
 -1,
 735401064,
 9879,
 -54312,
 735346838,
 9941,
 -54311,
 735526944,
 128126,
 -1,
 735581547,
 9200,
 735783980,
 724576379,
 -1,
 735849515,
 735720975,
 -1,
 735915034,
 735796271,
 -1,
 735980526,
 735870521,
 -1,
 736046053,
 735940460,
 -1,
 736111587,
 735993063,
 65800,
 736231423,
 736034816,
 -1,
 -54302,
 736133495,
 65827,
 -1,
 736181789,
 65818,
 736428031,
 736046320,
 65809,
 -1,
 736298683,
 65836,
 736504812,
 735983771,
 -1,
 736570346,
 736456754,
 65801,
 736690175,
 736493568,
 -1,
 -54295,
 736592247,
 65828,
 -1,
 736640541,
 65819,
 736886783,
 736511327,
 65810,
 -1,
 736757435,
 65837,
 737017855,
 736439293,
 65808,
 -1,
 736888507,
 65835,
 737094651,
 735933838,
 -1,
 737160181,
 737035993,
 65804,
 737225714,
 737117752,
 65813,
 -1,
 737150651,
 65840,
 737411071,
 737148928,
 -1,
 -54284,
 737313143,
 65831,
 -1,
 737361437,
 65822,
 737607679,
 737095552,
 65805,
 737618936,
 737510968,
 65814,
 -1,
 737543867,
 65841,
 737804287,
 737542144,
 -1,
 -54278,
 737706359,
 65832,
 -1,
 737754653,
 65823,
 737946634,
 737030487,
 -1,
 738012163,
 737893607,
 -1,
 738077697,
 737970881,
 65802,
 738197503,
 738000896,
 -1,
 -54272,
 738099575,
 65829,
 -1,
 738147869,
 65820,
 738394111,
 738030861,
 65811,
 -1,
 738264763,
 65838,
 738525183,
 737951327,
 -1,
 738536456,
 738430121,
 65803,
 738656255,
 738459648,
 -1,
 -54265,
 738558327,
 65830,
 -1,
 738606621,
 65821,
 738852863,
 738473137,
 65812,
 -1,
 738723515,
 65839,
 738929680,
 737893023,
 65807,
 738995213,
 738887224,
 65816,
 -1,
 738920123,
 65843,
 739180543,
 738918400,
 -1,
 -54257,
 739082615,
 65834,
 -1,
 739130909,
 65825,
 739322902,
 738863925,
 65806,
 739388435,
 739284051,
 65815,
 -1,
 739313339,
 65842,
 739573759,
 739311616,
 -1,
 -54251,
 739475831,
 65833,
 -1,
 739524125,
 65824,
 739770367,
 739270654,
 65799,
 739835903,
 739639296,
 -1,
 -54247,
 739737975,
 65826,
 -1,
 739786269,
 65817,
 739978277,
 735874924,
 -1,
 740043810,
 739912507,
 -1,
 740109343,
 739979607,
 -1,
 -54242,
 740058306,
 65851,
 -1,
 740115794,
 65848,
 -54240,
 740065617,
 65850,
 -54239,
 740259466,
 65849,
 -1,
 740301022,
 65847,
 740556799,
 739992200,
 -1,
 -54236,
 740446025,
 65792,
 -1,
 740500900,
 65793,
 740699176,
 739923208,
 -1,
 -54233,
 740655441,
 65855,
 -1,
 740718218,
 65854,
 -54231,
 740642708,
 65853,
 -54230,
 740829156,
 65852,
 -1,
 740892116,
 65794,
 -1,
 735801696,
 128673,
 741158001,
 735743444,
 -1,
 741223536,
 741101137,
 -1,
 741289014,
 741150401,
 68352,
 741354546,
 741215937,
 68353,
 -54223,
 741301479,
 68355,
 -1,
 741365869,
 68357,
 741551156,
 741288059,
 68358,
 -1,
 741484667,
 68359,
 -54219,
 741498087,
 68354,
 -1,
 741628013,
 68356,
 741813310,
 741234797,
 -1,
 741878843,
 741749962,
 -1,
 -54215,
 741840121,
 68387,
 -54214,
 741903529,
 68388,
 -1,
 741943419,
 68386,
 -54212,
 741840121,
 68390,
 -54211,
 742087069,
 68391,
 -1,
 742140027,
 68389,
 742337604,
 741766542,
 -1,
 742403138,
 742275227,
 -1,
 -54207,
 742364409,
 68403,
 -1,
 742402171,
 68401,
 -54205,
 742356946,
 68404,
 -1,
 742533243,
 68399,
 742730824,
 742298527,
 -1,
 -54202,
 742692089,
 68370,
 -54201,
 742755497,
 68371,
 -1,
 742795387,
 68369,
 742992972,
 742686265,
 -1,
 -54198,
 742948791,
 68381,
 -54197,
 742996499,
 68378,
 -1,
 743057531,
 68377,
 743255120,
 742929610,
 -1,
 -54194,
 743193107,
 68374,
 -54193,
 743257592,
 68373,
 -1,
 743319675,
 68372,
 743517267,
 743216691,
 -1,
 -54190,
 743455251,
 68402,
 -1,
 743516283,
 68400,
 743713878,
 743478355,
 -1,
 -54187,
 743675129,
 68394,
 -1,
 743712891,
 68395,
 743910488,
 743671371,
 68366,
 -1,
 743867979,
 68367,
 744041562,
 743857383,
 68362,
 -1,
 743988455,
 68363,
 744172636,
 743980639,
 68364,
 -1,
 744111711,
 68365,
 744303711,
 744110235,
 -1,
 -54178,
 744248532,
 68393,
 -1,
 744302715,
 68405,
 744500321,
 744237179,
 68360,
 -1,
 744433787,
 68361,
 744631396,
 744432334,
 -1,
 -54173,
 744569363,
 68380,
 -1,
 744630395,
 68379,
 744828007,
 744560629,
 -1,
 -54170,
 744765971,
 68385,
 -1,
 744827003,
 68384,
 -54168,
 744787113,
 68396,
 -54167,
 744976263,
 68397,
 -54166,
 745039896,
 68382,
 -54165,
 745100500,
 68392,
 -54164,
 745164022,
 68398,
 -54163,
 745228667,
 68368,
 -54162,
 745293680,
 68376,
 -54161,
 745353747,
 68383,
 -1,
 745413980,
 68375,
 -1,
 741150581,
 68409,
 745679994,
 741103725,
 -1,
 745745525,
 745635385,
 128028,
 -54156,
 745684836,
 128260,
 -1,
 745745572,
 128246,
 745942137,
 745682122,
 -1,
 -54153,
 745900094,
 128551,
 -54152,
 745960808,
 128544,
 -1,
 746007950,
 128162,
 -1,
 745872973,
 9875,
 746269824,
 745637451,
 -1,
 746335358,
 746226431,
 -1,
 -54147,
 746282289,
 128663,
 -1,
 746329723,
 127975,
 -54145,
 746290358,
 8371,
 -1,
 746461550,
 127814,
 746663044,
 746200006,
 -1,
 746728579,
 746604598,
 983053,
 -1,
 746675045,
 983052,
 -1,
 746652023,
 9190,
 746925191,
 746618425,
 -1,
 -54138,
 746872670,
 9883,
 -1,
 746929204,
 128095,
 747121802,
 746880006,
 -1,
 -54135,
 747074636,
 9954,
 -1,
 747135171,
 128562,
 747318413,
 747071235,
 -1,
 -54132,
 747268508,
 983194,
 -1,
 747314118,
 983195,
 747515024,
 747262500,
 -1,
 -54129,
 747449822,
 127944,
 -1,
 747510647,
 128657,
 -54127,
 747457286,
 8525,
 -1,
 747647638,
 1547,
 747843173,
 697054410,
 -1,
 747908485,
 747793770,
 -1,
 747974009,
 747842164,
 -1,
 748039541,
 747915320,
 -1,
 748104938,
 747966145,
 -1,
 748170471,
 748036441,
 -1,
 748235965,
 748099357,
 -1,
 748301484,
 748171942,
 -1,
 748367013,
 748260521,
 65859,
 748486655,
 748290048,
 -1,
 748498080,
 748387897,
 -1,
 748563615,
 748436784,
 65862,
 -1,
 748488350,
 65870,
 -1,
 748491381,
 65864,
 748760228,
 748437021,
 65861,
 748879871,
 748683264,
 -1,
 -54109,
 748781385,
 65868,
 -1,
 748846150,
 65875,
 -1,
 748715078,
 65871,
 749142015,
 748303537,
 65860,
 749207551,
 749010944,
 -1,
 749218987,
 749108793,
 -1,
 749284522,
 749157680,
 65863,
 -1,
 749209202,
 65878,
 -1,
 749212277,
 65866,
 -1,
 749173830,
 65873,
 749546679,
 748249090,
 -1,
 749612210,
 749484187,
 -1,
 749677745,
 749570403,
 -1,
 -54096,
 749633353,
 65867,
 -1,
 749698118,
 65874,
 -1,
 749605526,
 65857,
 749939893,
 749568384,
 -1,
 -54092,
 749895497,
 65869,
 -1,
 749960262,
 65876,
 -54090,
 749890766,
 65856,
 -1,
 750069700,
 65858,
 750321663,
 749502533,
 -1,
 750333115,
 750222905,
 -1,
 -54086,
 750271822,
 65877,
 -1,
 750326389,
 65865,
 -54084,
 750287942,
 65872,
 -1,
 750474981,
 65879,
 750660822,
 748191289,
 -1,
 750726350,
 750598815,
 -1,
 750791877,
 750681657,
 -1,
 750857411,
 750729371,
 -1,
 -54078,
 750809142,
 65899,
 -1,
 750863711,
 65893,
 -54076,
 750817938,
 65884,
 -1,
 750988285,
 65892,
 751185097,
 750739454,
 65881,
 751304703,
 751108096,
 -1,
 -54072,
 751206775,
 65905,
 -1,
 751255069,
 65898,
 751501311,
 751121062,
 -1,
 751512781,
 751406252,
 -1,
 -54068,
 751468919,
 65906,
 -1,
 751517213,
 65902,
 -1,
 751449265,
 65897,
 751828991,
 750679056,
 -1,
 751840468,
 751710886,
 -1,
 751906002,
 751799465,
 65887,
 -1,
 751829542,
 65901,
 752091135,
 751842481,
 65894,
 -1,
 751960102,
 65895,
 752222207,
 751796289,
 65888,
 -1,
 752091174,
 65889,
 752299228,
 750598792,
 -1,
 752364763,
 752244398,
 -1,
 -54055,
 752320577,
 65890,
 -54054,
 752377854,
 65882,
 -1,
 752431785,
 65896,
 -1,
 752292071,
 65880,
 752692448,
 752233791,
 -1,
 752757983,
 752649607,
 65883,
 -1,
 752681374,
 65886,
 -1,
 752694047,
 65900,
 752954595,
 752622534,
 -1,
 -54046,
 752915962,
 65885,
 -1,
 752948700,
 65903,
 -54044,
 752909505,
 65908,
 -54043,
 753096980,
 65904,
 -54042,
 753161689,
 65891,
 -1,
 753214454,
 65907,
 753467391,
 748121450,
 -1,
 -54039,
 753368799,
 65926,
 -1,
 753427640,
 65927,
 753610001,
 748045276,
 -1,
 753675507,
 753536306,
 119327,
 -54035,
 753602186,
 119356,
 -54034,
 753667670,
 119355,
 -54033,
 753733143,
 119354,
 -54032,
 753798512,
 119353,
 -54031,
 753863882,
 119352,
 -54030,
 753929267,
 119351,
 -1,
 753994528,
 119350,
 754199803,
 753601443,
 119325,
 -54027,
 754126474,
 119337,
 -54026,
 754191958,
 119336,
 -54025,
 754257431,
 119335,
 -54024,
 754322738,
 119334,
 -54023,
 754388170,
 119333,
 -54022,
 754453555,
 119332,
 -1,
 754518947,
 119331,
 754724098,
 754125875,
 119326,
 -54019,
 754650762,
 119343,
 -54018,
 754716183,
 119342,
 -54017,
 754781661,
 119341,
 -54016,
 754847088,
 119340,
 -54015,
 754912562,
 119339,
 -1,
 754977994,
 119338,
 755182856,
 754650480,
 119328,
 -54012,
 755109170,
 119361,
 -54011,
 755174602,
 119360,
 -54010,
 755239987,
 119359,
 -54009,
 755305379,
 119358,
 -1,
 755370784,
 119357,
 755576079,
 755109066,
 -1,
 -54006,
 755502730,
 119349,
 -54005,
 755568214,
 119348,
 -54004,
 755633687,
 119347,
 -54003,
 755699165,
 119346,
 -54002,
 755764275,
 119345,
 -1,
 755829536,
 119344,
 -54000,
 755502678,
 119330,
 -1,
 755961367,
 119329,
 756165935,
 753569342,
 -1,
 756231453,
 756091811,
 119296,
 -53996,
 756158090,
 119314,
 -53995,
 756223574,
 119313,
 -53994,
 756289047,
 119312,
 -53993,
 756354525,
 119311,
 -53992,
 756419952,
 119310,
 -53991,
 756485426,
 119309,
 -53990,
 756550858,
 119308,
 -53989,
 756616243,
 119307,
 -53988,
 756681635,
 119306,
 -1,
 756747040,
 119305,
 756952355,
 756157808,
 119300,
 -53985,
 756878642,
 119324,
 -53984,
 756944074,
 119323,
 -53983,
 757009459,
 119322,
 -53982,
 757074851,
 119321,
 -1,
 757140256,
 119320,
 757345577,
 756878387,
 119297,
 -53979,
 757271858,
 119319,
 -53978,
 757337290,
 119318,
 -53977,
 757402675,
 119317,
 -53976,
 757468067,
 119316,
 -1,
 757533472,
 119315,
 -53974,
 757272202,
 119304,
 -53973,
 757665366,
 119303,
 -53972,
 757730839,
 119302,
 -53971,
 757796317,
 119301,
 -53970,
 757861682,
 119299,
 -1,
 757927114,
 119298,
 758132034,
 756118926,
 -1,
 758197564,
 758076222,
 -1,
 758263096,
 758140497,
 -1,
 758328629,
 758216078,
 -1,
 -53964,
 758266964,
 1016,
 -1,
 758321959,
 1019,
 -53962,
 758278029,
 887,
 -53961,
 758463144,
 881,
 -1,
 758519033,
 883,
 758721851,
 758214896,
 -1,
 -53958,
 758665710,
 891,
 -1,
 758720091,
 893,
 -1,
 758654555,
 892,
 759037951,
 758155180,
 -1,
 -53954,
 758935861,
 7528,
 -53953,
 758999294,
 7529,
 -53952,
 759051608,
 7527,
 -53951,
 759111208,
 7530,
 -1,
 759175546,
 7526,
 759377233,
 758062204,
 -1,
 759442764,
 759319370,
 -1,
 759508299,
 759377601,
 -1,
 759573832,
 759461262,
 -1,
 -53945,
 759512148,
 1015,
 -1,
 759567143,
 1018,
 -53943,
 759523213,
 886,
 -53942,
 759708328,
 880,
 -1,
 759764217,
 882,
 -1,
 759466237,
 1017,
 760032591,
 759394544,
 -1,
 -53938,
 759976430,
 1021,
 -1,
 760030811,
 1023,
 -53936,
 759974096,
 975,
 -1,
 760161883,
 1022,
 760360282,
 759332409,
 -1,
 760425813,
 760320661,
 -1,
 -53932,
 760381799,
 65911,
 -1,
 760438101,
 65917,
 760622424,
 760364387,
 -1,
 -53929,
 760573163,
 65912,
 -1,
 760634709,
 65918,
 -53927,
 760575344,
 65929,
 -1,
 760746602,
 65914,
 760950115,
 760302410,
 -1,
 761015650,
 760884936,
 -1,
 761081183,
 760964867,
 -1,
 -53922,
 761034868,
 7466,
 -1,
 761085535,
 7464,
 -53920,
 761033013,
 7465,
 -53919,
 761220135,
 7463,
 -1,
 761279832,
 7462,
 -1,
 760956528,
 65923,
 761539944,
 760896743,
 -1,
 761605478,
 761485732,
 65909,
 -1,
 761528358,
 65910,
 -53913,
 761563563,
 65924,
 -1,
 761666224,
 65916,
 761867627,
 761483812,
 -1,
 -53910,
 761826173,
 119365,
 -1,
 761867956,
 65921,
 762064238,
 761803095,
 -1,
 -53907,
 762012833,
 65919,
 -1,
 762070683,
 65920,
 -53905,
 762025720,
 65930,
 -53904,
 762221820,
 65913,
 -53903,
 762287118,
 65925,
 -53902,
 762343737,
 1020,
 -53901,
 762399534,
 65922,
 -53900,
 762460095,
 65928,
 -1,
 762521548,
 65915,
 762773503,
 747985007,
 -1,
 -53897,
 762657336,
 128154,
 -53896,
 762714815,
 128215,
 -1,
 762778798,
 127823,
 762981759,
 747912799,
 -1,
 763047294,
 762927899,
 -1,
 763112829,
 762982839,
 128512,
 -1,
 763038075,
 128513,
 -1,
 763043095,
 128568,
 -1,
 762991250,
 128556,
 763374978,
 762928359,
 -1,
 -53887,
 763335001,
 128151,
 -1,
 763398682,
 983109,
 763625471,
 763301569,
 -1,
 -53884,
 763521256,
 127815,
 -1,
 763570191,
 127891,
 763768328,
 747850570,
 -1,
 763833861,
 763695447,
 -1,
 763899334,
 763787778,
 -1,
 763964817,
 763852174,
 -1,
 764030349,
 763902107,
 -1,
 764095884,
 763985583,
 11339,
 -1,
 764045608,
 11356,
 -1,
 764022465,
 11342,
 764292495,
 763974562,
 11348,
 -1,
 764217775,
 11349,
 -53872,
 764242227,
 11346,
 -1,
 764367123,
 11332,
 764554650,
 763925587,
 -1,
 764620183,
 764487803,
 -1,
 764685718,
 764570986,
 -1,
 -53867,
 764642891,
 11343,
 -1,
 764690015,
 11344,
 -1,
 764640569,
 11317,
 -53864,
 764577355,
 11347,
 -53863,
 764894439,
 11350,
 -1,
 764942056,
 11345,
 765144482,
 764493407,
 11323,
 765210014,
 765105934,
 -1,
 -53859,
 765150842,
 11355,
 -1,
 765208699,
 11321,
 765406625,
 765158300,
 -1,
 -53856,
 765360766,
 11351,
 -1,
 765401557,
 11353,
 -1,
 765352665,
 11322,
 765668774,
 765099577,
 -1,
 -53852,
 765628240,
 11333,
 -53851,
 765687924,
 11340,
 -1,
 765752371,
 11357,
 765930922,
 765600462,
 -1,
 -53848,
 765892274,
 11319,
 -53847,
 765943136,
 11316,
 -1,
 766003119,
 11324,
 766193069,
 765892147,
 -1,
 -53844,
 766131216,
 11318,
 -1,
 766192611,
 11320,
 766389680,
 766142211,
 -1,
 -53841,
 766336707,
 11330,
 -1,
 766388347,
 11338,
 766586291,
 766336231,
 -1,
 -53838,
 766543091,
 11337,
 -1,
 766598164,
 11329,
 766782902,
 766528330,
 -1,
 -53835,
 766724123,
 11326,
 -1,
 766777095,
 11358,
 766979513,
 766718295,
 -1,
 -53832,
 766931881,
 11335,
 -1,
 766985734,
 11354,
 767176124,
 766908405,
 -1,
 -53829,
 767133797,
 11313,
 -1,
 767180930,
 11352,
 -53827,
 767134924,
 11314,
 -53826,
 767330396,
 11334,
 -53825,
 767390627,
 11331,
 -53824,
 767449358,
 11328,
 -53823,
 767514725,
 11327,
 -53822,
 767576287,
 11325,
 -53821,
 767638163,
 11336,
 -53820,
 767702883,
 11315,
 -53819,
 767762012,
 11341,
 -1,
 767825905,
 11312,
 768081919,
 763829397,
 -1,
 768093648,
 767980942,
 -1,
 768159180,
 768030875,
 -1,
 768224715,
 768114351,
 11291,
 -1,
 768174376,
 11308,
 -1,
 768151233,
 11294,
 768421326,
 768103330,
 11300,
 -1,
 768346543,
 11301,
 -53809,
 768370995,
 11298,
 -1,
 768495891,
 11284,
 768683481,
 768054355,
 -1,
 768749014,
 768616571,
 -1,
 768814549,
 768699754,
 -1,
 -53804,
 768771659,
 11295,
 -1,
 768818783,
 11296,
 -1,
 768769337,
 11269,
 -53801,
 768706123,
 11299,
 -53800,
 769023207,
 11302,
 -1,
 769070824,
 11297,
 769273313,
 768622175,
 11275,
 769338845,
 769234702,
 -1,
 -53796,
 769279610,
 11307,
 -1,
 769337467,
 11273,
 769535456,
 769287068,
 -1,
 -53793,
 769489534,
 11303,
 -1,
 769530325,
 11305,
 -1,
 769481433,
 11274,
 769797605,
 769228345,
 -1,
 -53789,
 769757008,
 11285,
 -53788,
 769816692,
 11292,
 -1,
 769881139,
 11309,
 770059753,
 769729230,
 -1,
 -53785,
 770021042,
 11271,
 -53784,
 770071904,
 11268,
 -1,
 770131887,
 11276,
 770321900,
 770020915,
 -1,
 -53781,
 770259984,
 11270,
 -1,
 770321379,
 11272,
 770518511,
 770270979,
 -1,
 -53778,
 770465475,
 11282,
 -1,
 770517115,
 11290,
 770715122,
 770464999,
 -1,
 -53775,
 770671859,
 11289,
 -1,
 770726932,
 11281,
 770911733,
 770657098,
 -1,
 -53772,
 770852891,
 11278,
 -1,
 770905863,
 11310,
 771108344,
 770847063,
 -1,
 -53769,
 771060649,
 11287,
 -1,
 771114502,
 11306,
 771304955,
 771037173,
 -1,
 -53766,
 771262565,
 11265,
 -1,
 771309698,
 11304,
 -53764,
 771263692,
 11266,
 -53763,
 771459164,
 11286,
 -53762,
 771519395,
 11283,
 -53761,
 771578126,
 11280,
 -53760,
 771643493,
 11279,
 -53759,
 771705055,
 11277,
 -53758,
 771766931,
 11288,
 -53757,
 771831651,
 11267,
 -53756,
 771890780,
 11293,
 -1,
 771954673,
 11264,
 772210687,
 763780327,
 -1,
 -53753,
 772116836,
 127775,
 -1,
 772151562,
 127760,
 772353615,
 763701371,
 -1,
 772419146,
 772301467,
 -1,
 772484671,
 772372994,
 -1,
 772550162,
 772421787,
 -1,
 772615695,
 772476609,
 -1,
 -53746,
 772566378,
 11556,
 -1,
 772614267,
 11552,
 -53744,
 772562404,
 11557,
 -53743,
 772751374,
 11554,
 -1,
 772810875,
 11553,
 773008920,
 772479942,
 -1,
 773074454,
 772946075,
 -1,
 -53739,
 773013985,
 11545,
 -1,
 773067992,
 11549,
 -53737,
 773013841,
 11548,
 -1,
 773198631,
 11546,
 773402139,
 772970035,
 -1,
 -53734,
 773339576,
 11535,
 -1,
 773401597,
 11526,
 773598750,
 773357231,
 -1,
 -53731,
 773549418,
 11538,
 -1,
 773609581,
 11527,
 773795361,
 773551502,
 -1,
 -53728,
 773733315,
 11544,
 -1,
 773788455,
 11537,
 773991972,
 773744387,
 -1,
 -53725,
 773929400,
 11540,
 -1,
 773985496,
 11534,
 774188583,
 773933110,
 -1,
 -53722,
 774126008,
 11541,
 -1,
 774181671,
 11529,
 774385194,
 774129456,
 -1,
 -53719,
 774324561,
 11547,
 -1,
 774388045,
 11551,
 774581805,
 774321354,
 -1,
 -53716,
 774519117,
 11542,
 -1,
 774574887,
 11522,
 774778416,
 774508225,
 -1,
 -53713,
 774723693,
 11520,
 -1,
 774777853,
 11565,
 -53711,
 774739387,
 11559,
 -53710,
 774935551,
 11550,
 -53709,
 775000137,
 11555,
 -53708,
 775065101,
 11525,
 -53707,
 775129330,
 11539,
 -53706,
 775187969,
 11536,
 -53705,
 775253089,
 11543,
 -53704,
 775315342,
 11533,
 -53703,
 775379192,
 11532,
 -53702,
 775443371,
 11531,
 -53701,
 775507017,
 11530,
 -53700,
 775569889,
 11528,
 -53699,
 775629821,
 11524,
 -53698,
 775693728,
 11523,
 -1,
 775755885,
 11521,
 775958087,
 772427345,
 -1,
 776023619,
 775884481,
 -1,
 -53694,
 775963105,
 4346,
 -1,
 776023037,
 4349,
 -53692,
 775980704,
 983915,
 -53691,
 776176970,
 4345,
 -53690,
 776227735,
 4351,
 -1,
 776288736,
 4350,
 776536063,
 775888021,
 -1,
 -53687,
 776443323,
 4295,
 -1,
 776474790,
 4301,
 776678990,
 772347096,
 9881,
 776798207,
 776603550,
 -1,
 -53683,
 776692975,
 9965,
 -1,
 776733209,
 9966,
 -1,
 776622694,
 128142,
 777006688,
 772310603,
 -1,
 777072215,
 776947560,
 -1,
 777137747,
 777031465,
 2786,
 -1,
 777079626,
 2787,
 777268821,
 777080464,
 2700,
 -1,
 777210698,
 2785,
 -53674,
 777221466,
 2801,
 -1,
 777326471,
 2800,
 777530972,
 777024471,
 -1,
 -53671,
 777491667,
 2677,
 -53670,
 777555485,
 2563,
 -53669,
 777619425,
 2641,
 -1,
 777654354,
 2561,
 777858655,
 777458904,
 -1,
 -53666,
 777791486,
 128130,
 -1,
 777851927,
 8370,
 -1,
 777799224,
 127928,
 -53663,
 776959374,
 983110,
 -53662,
 778067234,
 128016,
 -53661,
 778126665,
 128103,
 -53660,
 778190103,
 128123,
 -1,
 778244862,
 127922,
 778448905,
 747792131,
 -1,
 778514199,
 778385563,
 -1,
 778579698,
 778440385,
 -1,
 778645170,
 778516541,
 -1,
 778710694,
 778587729,
 -1,
 778776179,
 778665529,
 -1,
 778841710,
 778731065,
 -1,
 -53651,
 778778801,
 43114,
 -1,
 778833601,
 43113,
 779038321,
 778794382,
 -1,
 -53648,
 778975409,
 43089,
 -1,
 779030209,
 43088,
 -53646,
 778975409,
 43081,
 -1,
 779161281,
 43080,
 779366008,
 778721389,
 -1,
 -53643,
 779326613,
 43079,
 -53642,
 779376835,
 43116,
 -53641,
 779433212,
 43075,
 -1,
 779488961,
 43083,
 779693692,
 779318670,
 -1,
 -53638,
 779637572,
 43094,
 -53637,
 779696305,
 43098,
 -1,
 779751105,
 43099,
 779955840,
 779625166,
 -1,
 -53634,
 779916867,
 43090,
 -53633,
 779952939,
 43115,
 -1,
 780013249,
 43082,
 780217988,
 779885510,
 -1,
 780283523,
 780144321,
 43076,
 -1,
 780228991,
 43123,
 -1,
 780220593,
 43077,
 780480135,
 780144321,
 43101,
 -53626,
 780434253,
 43120,
 -1,
 780489120,
 43117,
 780676746,
 780441139,
 -1,
 -53623,
 780613809,
 43092,
 -1,
 780668609,
 43093,
 780873357,
 780635770,
 -1,
 -53620,
 780815923,
 43118,
 -1,
 780870371,
 43119,
 781069968,
 780822275,
 -1,
 -53617,
 781007025,
 43085,
 -1,
 781061825,
 43084,
 781266579,
 781010998,
 -1,
 -53614,
 781203633,
 43073,
 -1,
 781258433,
 43072,
 781463190,
 781202634,
 -1,
 -53611,
 781399292,
 43109,
 -1,
 781455041,
 43074,
 781659800,
 781396091,
 43104,
 -1,
 781592699,
 43110,
 -53607,
 781620373,
 43095,
 -53606,
 781751274,
 43107,
 -53605,
 781815731,
 43091,
 -53604,
 781878859,
 43103,
 -53603,
 781938120,
 43096,
 -53602,
 782003253,
 43106,
 -53601,
 782064871,
 43105,
 -53600,
 782127741,
 43087,
 -53599,
 782191480,
 43097,
 -53598,
 782255950,
 43078,
 -53597,
 782319199,
 43102,
 -53596,
 782383281,
 43100,
 -53595,
 782447028,
 43108,
 -1,
 782506026,
 43086,
 782708398,
 778663310,
 -1,
 782773933,
 782665291,
 -1,
 782839468,
 782703118,
 -1,
 -53590,
 782800021,
 43112,
 -53589,
 782864307,
 43111,
 -1,
 782921160,
 43121,
 -1,
 782788780,
 43122,
 -1,
 782713685,
 43124,
 783232689,
 782652409,
 -1,
 -53584,
 783185785,
 43126,
 -1,
 783230751,
 43127,
 -1,
 783165184,
 43125,
 783548415,
 778585558,
 -1,
 783560382,
 783424454,
 -1,
 783625912,
 783506663,
 -1,
 783691447,
 783570004,
 66020,
 -1,
 783631211,
 66045,
 -1,
 783634921,
 66022,
 783888060,
 783552193,
 -1,
 -53574,
 783842873,
 66028,
 -53573,
 783905931,
 66018,
 -1,
 783969194,
 66003,
 -53571,
 783831513,
 66012,
 -1,
 784087969,
 66004,
 784281286,
 783512974,
 -1,
 784346818,
 784218851,
 -1,
 -53567,
 784295683,
 66024,
 -1,
 784345994,
 66011,
 -53565,
 784303017,
 66042,
 -53564,
 784487279,
 66043,
 -53563,
 784551800,
 66021,
 -1,
 784603057,
 66015,
 784805581,
 784209909,
 -1,
 784871114,
 784751847,
 -1,
 -53559,
 784830316,
 66010,
 -1,
 784883580,
 66017,
 785067724,
 784804468,
 66033,
 -1,
 785005579,
 66023,
 -1,
 785025170,
 66027,
 785264339,
 784754435,
 -1,
 785329873,
 785206090,
 -1,
 -53552,
 785287384,
 66001,
 -1,
 785322935,
 66034,
 -53550,
 785263190,
 66000,
 -1,
 785454286,
 66036,
 785657559,
 785219129,
 -1,
 -53547,
 785615286,
 66032,
 -53546,
 785661750,
 66008,
 -1,
 785717028,
 66002,
 785919707,
 785594523,
 -1,
 -53543,
 785867492,
 66025,
 -53542,
 785924046,
 66026,
 -1,
 785984441,
 66006,
 786181854,
 785878892,
 -1,
 -53539,
 786128744,
 66005,
 -1,
 786175897,
 66044,
 786378465,
 786132330,
 -1,
 -53536,
 786326330,
 66037,
 -1,
 786371318,
 66029,
 786575076,
 786322045,
 -1,
 -53533,
 786531554,
 66014,
 -1,
 786585822,
 66013,
 786771687,
 786517752,
 -1,
 -53530,
 786715156,
 66038,
 -1,
 786768590,
 66016,
 786968298,
 786707658,
 -1,
 -53527,
 786919158,
 66041,
 -1,
 786962249,
 66007,
 787164909,
 786900356,
 -1,
 -53524,
 787123369,
 66031,
 -1,
 787173313,
 66019,
 -53522,
 787123729,
 66035,
 -53521,
 787310324,
 66039,
 -53520,
 787362706,
 66040,
 -53519,
 787425663,
 66030,
 -1,
 787486116,
 66009,
 787742719,
 778526183,
 -1,
 787754765,
 787631697,
 -1,
 787820280,
 787707278,
 -1,
 -53514,
 787758019,
 67860,
 -53513,
 787819487,
 67854,
 -1,
 787877981,
 67857,
 788082427,
 787775033,
 -1,
 -53510,
 788016765,
 67848,
 -1,
 788076337,
 67861,
 788279037,
 788019731,
 67844,
 -1,
 788233785,
 67847,
 788410112,
 788205249,
 -1,
 -53505,
 788352699,
 67840,
 -1,
 788414945,
 67855,
 -53503,
 788371018,
 67846,
 -53502,
 788567493,
 67849,
 -53501,
 788631546,
 67845,
 -53500,
 788690024,
 67859,
 -53499,
 788753518,
 67858,
 -53498,
 788817944,
 67856,
 -53497,
 788880482,
 67853,
 -53496,
 788944259,
 67852,
 -53495,
 789007394,
 67851,
 -53494,
 789072072,
 67850,
 -53493,
 789132627,
 67842,
 -53492,
 789193736,
 67843,
 -1,
 789256566,
 67841,
 789458710,
 787700783,
 -1,
 789524244,
 789413433,
 -1,
 789589778,
 789483372,
 -1,
 -53487,
 789535975,
 67866,
 -1,
 789589232,
 67864,
 -53485,
 789527902,
 67867,
 -1,
 789720061,
 67863,
 789970943,
 789471230,
 67862,
 -1,
 789840422,
 67865,
 -1,
 789418850,
 67871,
 790114153,
 778455882,
 -1,
 790179687,
 790042597,
 -1,
 790245161,
 790134329,
 -1,
 790310687,
 790205172,
 -1,
 -53476,
 790264611,
 127138,
 -53475,
 790313552,
 127154,
 -53474,
 790373577,
 127170,
 -1,
 790437887,
 127186,
 790638372,
 790248952,
 -1,
 -53471,
 790592291,
 127139,
 -53470,
 790641232,
 127155,
 -53469,
 790701257,
 127171,
 -1,
 790765567,
 127187,
 791019519,
 790572070,
 -1,
 -53466,
 790919971,
 127146,
 -53465,
 790968912,
 127162,
 -53464,
 791028937,
 127178,
 -1,
 791093247,
 127194,
 791293748,
 790197646,
 -1,
 791359279,
 791234281,
 -1,
 -53460,
 791313187,
 127142,
 -53459,
 791362128,
 127158,
 -53458,
 791422153,
 127174,
 -1,
 791486463,
 127190,
 791740415,
 791293846,
 -1,
 -53455,
 791640867,
 127143,
 -53454,
 791689808,
 127159,
 -53453,
 791749833,
 127175,
 -1,
 791814143,
 127191,
 792014655,
 791234614,
 -1,
 792080186,
 791960199,
 -1,
 -53449,
 792034083,
 127148,
 -53448,
 792083024,
 127164,
 -53447,
 792143049,
 127180,
 -1,
 792207359,
 127196,
 792461311,
 792019718,
 -1,
 -53444,
 792361763,
 127150,
 -53443,
 792410704,
 127166,
 -53442,
 792470729,
 127182,
 -1,
 792535039,
 127198,
 792735562,
 791949655,
 -1,
 792801093,
 792683696,
 -1,
 -53438,
 792754979,
 127140,
 -53437,
 792803920,
 127156,
 -53436,
 792863945,
 127172,
 -1,
 792928255,
 127188,
 793182207,
 792741546,
 -1,
 -53433,
 793082659,
 127141,
 -53432,
 793131600,
 127157,
 -53431,
 793191625,
 127173,
 -1,
 793255935,
 127189,
 793456463,
 792685817,
 -1,
 -53428,
 793410339,
 127149,
 -53427,
 793459280,
 127165,
 -53426,
 793519305,
 127181,
 -1,
 793583615,
 127197,
 793784148,
 793402031,
 -1,
 -53423,
 793738019,
 127145,
 -53422,
 793786960,
 127161,
 -53421,
 793846985,
 127177,
 -1,
 793911295,
 127193,
 794111833,
 793724753,
 -1,
 -53418,
 794065699,
 127147,
 -53417,
 794114640,
 127163,
 -53416,
 794174665,
 127179,
 -1,
 794238975,
 127195,
 794439518,
 794045262,
 -1,
 -53413,
 794393379,
 127144,
 -53412,
 794442320,
 127160,
 -53411,
 794502345,
 127176,
 -1,
 794566655,
 127192,
 794767203,
 794365938,
 -1,
 -53408,
 794721059,
 127137,
 -53407,
 794770000,
 127153,
 -53406,
 794830025,
 127169,
 -1,
 794894335,
 127185,
 795094886,
 794695669,
 -1,
 -53403,
 795036579,
 127183,
 -1,
 795086846,
 127136,
 -1,
 795054300,
 127199,
 -53400,
 790136395,
 983150,
 -1,
 795288270,
 983147,
 795488164,
 790040257,
 -1,
 795553683,
 795438442,
 -1,
 795619210,
 795487430,
 -1,
 795684743,
 795561071,
 -1,
 -53394,
 795645491,
 127273,
 -53393,
 795710547,
 127272,
 -53392,
 795775903,
 127271,
 -53391,
 795840364,
 127270,
 -53390,
 795904980,
 127269,
 -53389,
 795969099,
 127268,
 -53388,
 796032569,
 127267,
 -53387,
 796095886,
 127266,
 -53386,
 796159338,
 127265,
 -53385,
 796224551,
 127264,
 -53384,
 796288771,
 127263,
 -53383,
 796351719,
 127262,
 -53382,
 796416109,
 127261,
 -53381,
 796480036,
 127260,
 -53380,
 796543818,
 127259,
 -53379,
 796608566,
 127258,
 -53378,
 796673840,
 127257,
 -53377,
 796737119,
 127256,
 -53376,
 796801179,
 127255,
 -53375,
 796865738,
 127254,
 -53374,
 796930391,
 127253,
 -53373,
 796993659,
 127252,
 -53372,
 797057742,
 127251,
 -53371,
 797121478,
 127250,
 -53370,
 797186037,
 127249,
 -1,
 797249217,
 127248,
 797507583,
 795626193,
 -1,
 -53367,
 797394853,
 12829,
 -1,
 797442594,
 12830,
 797650834,
 795573817,
 -1,
 797716368,
 797589193,
 -1,
 -53363,
 797673939,
 983149,
 -53362,
 797717482,
 983145,
 -53361,
 797779794,
 983146,
 -1,
 797841464,
 983148,
 -53359,
 797676657,
 127881,
 -1,
 797989391,
 12880,
 -1,
 797577574,
 11791,
 798240664,
 795495242,
 -1,
 798306199,
 798183974,
 -1,
 -53354,
 798262261,
 127796,
 -1,
 798300943,
 11801,
 -1,
 798248009,
 9908,
 798568349,
 798176760,
 -1,
 798633884,
 798490624,
 -1,
 -53349,
 798593425,
 128195,
 -1,
 798634458,
 128196,
 -1,
 798584170,
 128223,
 798896031,
 798499534,
 983121,
 -1,
 798827791,
 983120,
 -53344,
 798855053,
 128062,
 -53343,
 798981111,
 128706,
 -53342,
 799041700,
 128206,
 -53341,
 799103299,
 128060,
 -1,
 799154007,
 128230,
 799354819,
 795438442,
 -1,
 799420344,
 799288888,
 -1,
 799485867,
 799371749,
 -1,
 799551402,
 799445224,
 -1,
 -53335,
 799492470,
 65048,
 -1,
 799547234,
 983229,
 -1,
 799505265,
 65096,
 799813550,
 799427953,
 -1,
 -53331,
 799772925,
 65047,
 -1,
 799832945,
 65095,
 800010161,
 799752156,
 -1,
 -53328,
 799945913,
 65042,
 -1,
 800006224,
 65041,
 800206772,
 799940613,
 -1,
 -53325,
 800151247,
 65040,
 -1,
 800215179,
 65043,
 -53323,
 800159441,
 65044,
 -53322,
 800353560,
 65046,
 -53321,
 800406744,
 65049,
 -1,
 800469065,
 65045,
 800718847,
 799358559,
 -1,
 800731074,
 800623594,
 -1,
 800796609,
 800686037,
 -1,
 800862142,
 800721374,
 -1,
 -53315,
 800787507,
 983166,
 -1,
 800852899,
 983163,
 801112063,
 800784384,
 -1,
 -53312,
 801015175,
 983165,
 -1,
 801071102,
 983162,
 -1,
 800727738,
 983192,
 -1,
 800676141,
 128120,
 801386463,
 799287419,
 -1,
 801451991,
 801336682,
 -1,
 801517523,
 801404302,
 -1,
 801583058,
 801464206,
 -1,
 801648593,
 801505280,
 -1,
 801714126,
 801608075,
 -1,
 801779660,
 801642485,
 -1,
 -53301,
 801722511,
 128113,
 -1,
 801772209,
 9977,
 -53299,
 801729213,
 128590,
 -1,
 801911712,
 128591,
 -53297,
 801664627,
 128588,
 -53296,
 802042979,
 128589,
 -1,
 802102004,
 128583,
 -1,
 801575450,
 128187,
 -1,
 801517523,
 128547,
 -53292,
 801466457,
 10178,
 -53291,
 802378693,
 9854,
 -53290,
 802436054,
 127917,
 -1,
 802489929,
 8524,
 802697179,
 801396845,
 -1,
 -53287,
 802651892,
 9956,
 -53286,
 802715943,
 128532,
 -1,
 802764896,
 128039,
 802959326,
 802623169,
 -1,
 -53283,
 802909546,
 127824,
 -1,
 802954658,
 127825,
 -1,
 802890839,
 128694,
 803221489,
 801332455,
 -1,
 803287014,
 803178059,
 -1,
 803352548,
 803242677,
 -1,
 -53277,
 803287479,
 128545,
 -1,
 803347685,
 128574,
 -53275,
 803295681,
 127831,
 -1,
 803478946,
 128093,
 803680234,
 803229435,
 -1,
 803745769,
 803609781,
 128659,
 -1,
 803698118,
 128680,
 -1,
 803692037,
 128110,
 803942381,
 803634745,
 -1,
 -53268,
 803868574,
 128688,
 -1,
 803931017,
 127858,
 804138992,
 803896326,
 -1,
 -53265,
 804068098,
 128238,
 -1,
 804131366,
 128239,
 -1,
 804085215,
 128041,
 804401150,
 803159647,
 -1,
 804466678,
 804336842,
 128022,
 804585471,
 804388864,
 -1,
 -53259,
 804477770,
 128061,
 -1,
 804532663,
 128055,
 804728825,
 804411805,
 -1,
 -53256,
 804656302,
 127821,
 -1,
 804716928,
 127885,
 804925436,
 804670282,
 -1,
 -53253,
 804866890,
 128138,
 -1,
 804923611,
 128169,
 -53251,
 804879498,
 128299,
 -1,
 805052223,
 9935,
 805253127,
 804357707,
 -1,
 805318658,
 805203306,
 -1,
 -53247,
 805271171,
 128091,
 -1,
 805333374,
 128156,
 -53245,
 805273177,
 128686,
 -53244,
 805468260,
 128204,
 -53243,
 805509732,
 128226,
 -53242,
 805571635,
 983167,
 -1,
 805637027,
 983164,
 -53240,
 805196324,
 983193,
 -1,
 805774438,
 983219,
 805974443,
 778389558,
 -1,
 806039789,
 805910683,
 -1,
 806105232,
 805983677,
 -1,
 806170710,
 806057358,
 -1,
 806236245,
 806131083,
 -1,
 806301733,
 806184707,
 -1,
 806367265,
 806252190,
 -1,
 806432798,
 806291934,
 -1,
 806498328,
 806361077,
 -1,
 806563861,
 806455754,
 -1,
 -53228,
 806515724,
 6649,
 -1,
 806570661,
 6633,
 806813695,
 806497069,
 -1,
 -53225,
 806712332,
 6648,
 -1,
 806767269,
 6632,
 806957083,
 806447449,
 -1,
 -53222,
 806908940,
 6647,
 -1,
 806963877,
 6631,
 807206911,
 806901780,
 -1,
 -53219,
 807105548,
 6646,
 -1,
 807160485,
 6630,
 807403519,
 806354944,
 -1,
 -53216,
 807302156,
 6645,
 -1,
 807357093,
 6629,
 807546916,
 806306111,
 -1,
 -53213,
 807498764,
 6642,
 -1,
 807553701,
 6626,
 -1,
 807474850,
 6624,
 807809083,
 806232988,
 -1,
 807874616,
 807733726,
 -1,
 807940142,
 807823107,
 -1,
 808005675,
 807890594,
 -1,
 -53206,
 807957516,
 6655,
 -1,
 808012453,
 6639,
 808255487,
 807944511,
 -1,
 -53203,
 808154124,
 6652,
 -1,
 808209061,
 6636,
 808398901,
 807868405,
 -1,
 808464434,
 808356298,
 -1,
 -53199,
 808416268,
 6654,
 -1,
 808471205,
 6638,
 808714239,
 808397613,
 -1,
 -53196,
 808612876,
 6653,
 -1,
 808667813,
 6637,
 808910847,
 808343572,
 -1,
 -53193,
 808809484,
 6651,
 -1,
 808864421,
 6635,
 809107455,
 807796736,
 -1,
 -53190,
 809006092,
 6650,
 -1,
 809061029,
 6634,
 809250890,
 807751167,
 -1,
 809316421,
 809199363,
 -1,
 809381956,
 809266846,
 6133,
 809500671,
 809306590,
 -1,
 809513026,
 809375733,
 -1,
 -53183,
 809470406,
 6137,
 -1,
 809511722,
 6136,
 -53181,
 809462101,
 6135,
 -1,
 809654287,
 6134,
 -1,
 809320764,
 6130,
 809906248,
 809244661,
 -1,
 -53177,
 809863622,
 6132,
 -1,
 809904938,
 6131,
 -53175,
 809859811,
 6128,
 -1,
 810047503,
 6129,
 810233937,
 809179125,
 -1,
 810299470,
 810191306,
 -1,
 -53171,
 810251276,
 6644,
 -1,
 810306213,
 6628,
 810549247,
 810232621,
 -1,
 -53168,
 810447884,
 6643,
 -1,
 810502821,
 6627,
 810692692,
 810178580,
 -1,
 -53165,
 810644492,
 6641,
 -1,
 810699429,
 6625,
 -1,
 810648951,
 6640,
 -1,
 806175010,
 6109,
 811020422,
 806101138,
 -1,
 811085920,
 810974777,
 -1,
 811151451,
 811040981,
 -1,
 -53158,
 811097319,
 983929,
 -1,
 811142849,
 983927,
 811348062,
 811088027,
 -1,
 -53155,
 811293927,
 983934,
 -1,
 811339457,
 983932,
 -53153,
 811293927,
 983933,
 -1,
 811470529,
 983931,
 811675749,
 811030637,
 -1,
 -53150,
 811636158,
 983925,
 -53149,
 811687143,
 983935,
 -53148,
 811743095,
 983920,
 -1,
 811798209,
 983930,
 812003435,
 811616310,
 -1,
 812068969,
 811939995,
 -1,
 -53144,
 812014823,
 983919,
 -1,
 812060353,
 983917,
 -53142,
 812014823,
 983918,
 -1,
 812191425,
 983916,
 812396657,
 811932614,
 -1,
 812462191,
 812333211,
 -1,
 -53138,
 812408039,
 983924,
 -1,
 812453569,
 983922,
 -53136,
 812408039,
 983923,
 -1,
 812584641,
 983921,
 812789877,
 812348814,
 -1,
 -53133,
 812742114,
 983946,
 -53132,
 812791985,
 983945,
 -1,
 812846785,
 983947,
 813052026,
 812738307,
 -1,
 813117561,
 812988571,
 -1,
 -53128,
 813063399,
 983939,
 -1,
 813108929,
 983937,
 -1,
 813063399,
 983938,
 813379709,
 812993354,
 -1,
 -53124,
 813325543,
 983943,
 -1,
 813371073,
 983949,
 813576320,
 813310670,
 -1,
 -53121,
 813522151,
 983928,
 -1,
 813567681,
 983926,
 -53119,
 813536702,
 983941,
 -53118,
 813731387,
 983944,
 -53117,
 813790197,
 983942,
 -53116,
 813848321,
 983940,
 -53115,
 813906097,
 983948,
 -1,
 813963306,
 983936,
 814166156,
 810959386,
 -1,
 814231689,
 814118245,
 983952,
 -1,
 814191699,
 983953,
 814415871,
 814181415,
 -1,
 -53109,
 814319179,
 983951,
 -1,
 814360699,
 983954,
 814612479,
 814124795,
 -1,
 -53106,
 814505810,
 983955,
 -53105,
 814555151,
 983950,
 -1,
 814616385,
 983956,
 814874623,
 806032757,
 -1,
 814887104,
 814763601,
 -1,
 814952601,
 814841401,
 -1,
 815018135,
 814906937,
 -1,
 -53099,
 814973149,
 68147,
 -53098,
 815020209,
 68123,
 -1,
 815075009,
 68122,
 -53096,
 814954673,
 68128,
 -1,
 815206081,
 68127,
 815411359,
 814883534,
 -1,
 815476893,
 815342286,
 -1,
 -53092,
 815413425,
 68125,
 -1,
 815468225,
 68124,
 -53090,
 815413425,
 68130,
 -1,
 815599297,
 68129,
 815804579,
 815363470,
 -1,
 -53087,
 815756770,
 68142,
 -53086,
 815806641,
 68141,
 -1,
 815861441,
 68143,
 816066727,
 815749229,
 -1,
 -53083,
 816026773,
 68121,
 -53082,
 816076995,
 68126,
 -1,
 816123585,
 68131,
 816328875,
 816007222,
 -1,
 -53079,
 816269448,
 68146,
 -53078,
 816330929,
 68113,
 -1,
 816385729,
 68112,
 816591022,
 816277251,
 -1,
 -53075,
 816527537,
 68133,
 -1,
 816582337,
 68132,
 816787633,
 816526538,
 -1,
 -53072,
 816724145,
 68115,
 -1,
 816778945,
 68114,
 816984244,
 816716742,
 -1,
 -53069,
 816920753,
 68118,
 -1,
 816975553,
 68117,
 817180855,
 816912373,
 -1,
 -53066,
 817117361,
 68135,
 -1,
 817172161,
 68134,
 -53064,
 817141315,
 68144,
 -53063,
 817337493,
 68137,
 -53062,
 817400810,
 68140,
 -53061,
 817458632,
 68138,
 -53060,
 817517181,
 68136,
 -53059,
 817580920,
 68139,
 -53058,
 817645390,
 68119,
 -53057,
 817707185,
 68145,
 -1,
 817761985,
 68096,
 817967310,
 814836680,
 -1,
 818032838,
 817898190,
 -1,
 818098373,
 817978599,
 -1,
 -53052,
 818054967,
 68183,
 -1,
 818118201,
 68176,
 -1,
 818025378,
 68182,
 818360521,
 817974090,
 -1,
 -53048,
 818308108,
 68181,
 -1,
 818365049,
 68184,
 818557132,
 818289606,
 -1,
 -53045,
 818507935,
 68179,
 -1,
 818562353,
 68178,
 -53043,
 818510311,
 68177,
 -1,
 818697175,
 68180,
 818884824,
 817925076,
 -1,
 818950359,
 818833061,
 -1,
 819015894,
 818903185,
 -1,
 -53038,
 818974302,
 68099,
 -53037,
 819037771,
 68098,
 -53036,
 819092711,
 68102,
 -53035,
 819150431,
 68097,
 -1,
 819210363,
 68101,
 -1,
 818957852,
 68108,
 -1,
 818890027,
 68159,
 819540192,
 818837649,
 -1,
 819605724,
 819471748,
 -1,
 -53029,
 819562332,
 68109,
 -1,
 819625553,
 68154,
 -53027,
 819564061,
 68111,
 -53026,
 819731762,
 68153,
 -53025,
 819796102,
 68152,
 -1,
 819860572,
 68110,
 820064487,
 819485743,
 -1,
 820130020,
 820018745,
 -1,
 -53021,
 820088908,
 68165,
 -1,
 820128765,
 68164,
 820379647,
 820076546,
 -1,
 -53018,
 820281719,
 68167,
 -1,
 820330013,
 68166,
 820576255,
 819995888,
 -1,
 820588779,
 820477497,
 -1,
 -53014,
 820548242,
 68161,
 -1,
 820591966,
 68162,
 -53012,
 820535294,
 68160,
 -1,
 820720626,
 68163,
 820916638,
 805965505,
 -1,
 820982086,
 820856406,
 -1,
 821047594,
 820923985,
 -1,
 821113079,
 820978382,
 -1,
 821178613,
 821043918,
 -1,
 -53005,
 821115057,
 69787,
 -53004,
 821175406,
 69786,
 -1,
 821235393,
 69785,
 -53002,
 821115057,
 69793,
 -1,
 821366465,
 69792,
 821571837,
 821067321,
 -1,
 821637371,
 821526073,
 -1,
 -52998,
 821573809,
 69784,
 -1,
 821628609,
 69783,
 -52996,
 821573809,
 69791,
 -1,
 821759681,
 69790,
 821965058,
 821516397,
 -1,
 -52993,
 821925013,
 69782,
 -52992,
 821975235,
 69789,
 -52991,
 822031612,
 69777,
 -1,
 822087361,
 69794,
 822292742,
 821890753,
 69763,
 -52988,
 822249035,
 69772,
 -52987,
 822296159,
 69770,
 -1,
 822349505,
 69764,
 822554890,
 822244750,
 -1,
 -52984,
 822506978,
 69805,
 -52983,
 822556849,
 69804,
 -1,
 822611649,
 69806,
 822817036,
 822511179,
 69767,
 -1,
 822773323,
 69768,
 822948111,
 822766954,
 -1,
 -52978,
 822884529,
 69788,
 -1,
 822939329,
 69801,
 823144722,
 822896387,
 -1,
 -52975,
 823081137,
 69796,
 -1,
 823135937,
 69795,
 823341333,
 823085110,
 -1,
 -52972,
 823277745,
 69774,
 -1,
 823332545,
 69773,
 823537944,
 823281456,
 -1,
 -52969,
 823474353,
 69781,
 -1,
 823529153,
 69780,
 823734554,
 823475807,
 69765,
 -1,
 823672415,
 69766,
 823865629,
 823669962,
 -1,
 -52964,
 823802033,
 69776,
 -1,
 823856833,
 69775,
 824062240,
 823794630,
 -1,
 -52961,
 823998641,
 69779,
 -1,
 824053441,
 69778,
 824258851,
 823990261,
 -1,
 -52958,
 824195249,
 69798,
 -1,
 824250049,
 69797,
 -52956,
 824218773,
 69800,
 -52955,
 824413162,
 69803,
 -52954,
 824466663,
 69771,
 -52953,
 824529533,
 69799,
 -52952,
 824593272,
 69802,
 -52951,
 824654001,
 69807,
 -1,
 824715387,
 69769,
 824914229,
 821006075,
 -1,
 824979759,
 824839873,
 -1,
 -52947,
 824936011,
 69816,
 -52946,
 824983135,
 69814,
 -1,
 825036481,
 69808,
 825241905,
 824936011,
 69811,
 -1,
 825198155,
 69812,
 825372979,
 825179743,
 69809,
 -1,
 825310815,
 69810,
 -52940,
 825318631,
 69815,
 -1,
 825436283,
 69813,
 825635134,
 824866190,
 -1,
 825700669,
 825573661,
 -1,
 825766202,
 825658868,
 -1,
 -52935,
 825718331,
 69762,
 -1,
 825781936,
 69817,
 -52933,
 825711653,
 69818,
 -52932,
 825891931,
 69760,
 -1,
 825955420,
 69761,
 -1,
 825633311,
 69822,
 826224963,
 825565902,
 -1,
 826290498,
 826172436,
 -1,
 -52927,
 826242713,
 69823,
 -1,
 826286990,
 69825,
 -1,
 826217378,
 69824,
 -52924,
 826170423,
 69821,
 -52923,
 826486009,
 69820,
 -1,
 826544007,
 69819,
 826749318,
 820941984,
 -1,
 826814827,
 826691153,
 -1,
 826880332,
 826759277,
 -1,
 -52918,
 826840213,
 43281,
 -52917,
 826881276,
 43277,
 -1,
 826937025,
 43284,
 827142479,
 826834489,
 -1,
 -52914,
 827078833,
 43294,
 -1,
 827133633,
 43282,
 827339090,
 827094414,
 -1,
 -52911,
 827275441,
 43279,
 -1,
 827330241,
 43278,
 827535701,
 827287299,
 -1,
 -52908,
 827472049,
 43286,
 -1,
 827526849,
 43285,
 827732312,
 827481319,
 -1,
 -52905,
 827677927,
 43301,
 -1,
 827730043,
 43299,
 827928923,
 827672630,
 -1,
 -52902,
 827865265,
 43275,
 -1,
 827920065,
 43274,
 828125534,
 827865243,
 -1,
 -52899,
 828079791,
 43283,
 -1,
 828116673,
 43295,
 -52897,
 828085827,
 43280,
 -52896,
 828282005,
 43291,
 -52895,
 828346291,
 43293,
 -52894,
 828410858,
 43296,
 -52893,
 828468680,
 43290,
 -52892,
 828527229,
 43287,
 -52891,
 828590968,
 43292,
 -52890,
 828653151,
 43300,
 -52889,
 828716284,
 43276,
 -52888,
 828777259,
 43288,
 -52887,
 828840930,
 43297,
 -52886,
 828905514,
 43289,
 -1,
 828968641,
 43298,
 829174137,
 826746096,
 -1,
 829239663,
 829128249,
 -1,
 -52882,
 829198994,
 43266,
 -1,
 829242718,
 43267,
 829436274,
 829191566,
 -1,
 -52879,
 829376217,
 43270,
 -1,
 829435776,
 43271,
 829632885,
 829370711,
 -1,
 -52876,
 829580410,
 43268,
 -1,
 829638280,
 43269,
 -52874,
 829593297,
 43264,
 -52873,
 829775870,
 43265,
 -52872,
 829840031,
 43273,
 -1,
 829893429,
 43272,
 830091647,
 829132498,
 -1,
 830157180,
 830047819,
 43304,
 -1,
 830089339,
 43302,
 830288254,
 830089339,
 43303,
 -1,
 830220411,
 43305,
 -1,
 830233831,
 43306,
 830484867,
 830046991,
 -1,
 830550402,
 830413844,
 43308,
 -1,
 830473417,
 43309,
 -1,
 830499269,
 43307,
 830799871,
 830437521,
 -1,
 -52859,
 830699631,
 43311,
 -1,
 830743222,
 43310,
 830943637,
 826703658,
 -1,
 831009165,
 830872000,
 -1,
 -52855,
 830965323,
 983964,
 -52854,
 831020263,
 983966,
 -52853,
 831077983,
 983963,
 -52852,
 831137915,
 983965,
 -1,
 831196865,
 983962,
 831455231,
 830934721,
 -1,
 831467924,
 831341621,
 -1,
 831533458,
 831422009,
 -1,
 -52847,
 831489611,
 983968,
 -1,
 831544551,
 983969,
 -52845,
 831481603,
 983970,
 -1,
 831659356,
 983967,
 -1,
 831418183,
 110592,
 831979519,
 830888724,
 -1,
 831992219,
 831879313,
 -1,
 -52840,
 831949412,
 3314,
 -52839,
 832003109,
 3260,
 -52838,
 832063429,
 3313,
 -1,
 832116579,
 3261,
 832319901,
 831950633,
 3298,
 -1,
 832260938,
 3299,
 -1,
 832261731,
 983202,
 832516520,
 820854367,
 -1,
 832582055,
 832469936,
 128143,
 832647590,
 832520858,
 -1,
 832713125,
 832582071,
 128535,
 832831487,
 832636836,
 -1,
 -52828,
 832731784,
 128537,
 -1,
 832774043,
 128538,
 -1,
 832642301,
 128573,
 -1,
 832570149,
 128139,
 -1,
 832526179,
 128088,
 833171882,
 832450896,
 128273,
 -1,
 833100916,
 128287,
 -1,
 833117465,
 128040,
 833368858,
 805919975,
 -1,
 833434291,
 833309514,
 -1,
 833499763,
 833364686,
 -1,
 833565296,
 833421312,
 -1,
 833630720,
 833520955,
 -1,
 833696222,
 833577692,
 -1,
 833761736,
 833621697,
 68608,
 833827261,
 833693819,
 -1,
 -52812,
 833786963,
 68632,
 -52811,
 833846841,
 68677,
 -52810,
 833910158,
 68670,
 -52809,
 833973610,
 68668,
 -52808,
 834033773,
 68644,
 -52807,
 834095946,
 68640,
 -52806,
 834160694,
 68634,
 -52805,
 834221258,
 68623,
 -52804,
 834282190,
 68627,
 -1,
 834344949,
 68619,
 834548159,
 833779086,
 68669,
 -1,
 834484379,
 68671,
 -52800,
 834507859,
 68630,
 -52799,
 834633273,
 68675,
 -52798,
 834694506,
 68666,
 -52797,
 834759719,
 68660,
 -52796,
 834820205,
 68643,
 -52795,
 834882378,
 68638,
 -52794,
 834942154,
 68621,
 -52793,
 835003086,
 68625,
 -1,
 835065845,
 68617,
 835269076,
 833693819,
 -1,
 835334606,
 835213421,
 -1,
 -52789,
 835294291,
 68650,
 -52788,
 835354169,
 68646,
 -52787,
 835400906,
 68653,
 -1,
 835460038,
 68648,
 -52785,
 835294771,
 68628,
 -52784,
 835614501,
 68673,
 -52783,
 835675907,
 68655,
 -52782,
 835736100,
 68642,
 -52781,
 835801501,
 68641,
 -1,
 835853254,
 68658,
 836055514,
 835214567,
 68614,
 836121047,
 835987579,
 68615,
 -1,
 836061238,
 68636,
 -52776,
 836075065,
 68679,
 -52775,
 836201511,
 68664,
 -1,
 836265731,
 68656,
 836448733,
 835993183,
 68611,
 -52772,
 836398119,
 68662,
 -1,
 836443078,
 68657,
 -1,
 836376808,
 68680,
 836763647,
 833656104,
 -1,
 836776434,
 836636353,
 68609,
 836841960,
 836708475,
 68610,
 836907491,
 836786285,
 68645,
 -1,
 836842698,
 68654,
 -52764,
 836867155,
 68633,
 -52763,
 836992569,
 68678,
 -52762,
 837044278,
 68635,
 -52761,
 837104842,
 68624,
 -1,
 837162997,
 68620,
 -52759,
 836801619,
 68631,
 -52758,
 837320249,
 68676,
 -52757,
 837383973,
 68672,
 -52756,
 837447018,
 68667,
 -52755,
 837512231,
 68661,
 -52754,
 837573169,
 68652,
 -52753,
 837634890,
 68639,
 -52752,
 837694666,
 68622,
 -52751,
 837755598,
 68626,
 -1,
 837818357,
 68618,
 838021626,
 836708475,
 68613,
 838087159,
 837965933,
 -1,
 -52747,
 838046803,
 68651,
 -52746,
 838106681,
 68647,
 -1,
 838147014,
 68649,
 -52744,
 838047283,
 68629,
 -52743,
 838301477,
 68674,
 -1,
 838343622,
 68659,
 838545918,
 837967079,
 -1,
 838611453,
 838477947,
 68616,
 -1,
 838551606,
 68637,
 -1,
 838560807,
 68665,
 838860799,
 838483551,
 68612,
 -1,
 838757415,
 68663,
 838939203,
 833579231,
 -1,
 839004730,
 838891665,
 -1,
 839070216,
 838935246,
 -1,
 839135750,
 838995649,
 66477,
 839254015,
 839073360,
 66508,
 -1,
 839125475,
 66509,
 -52729,
 839091787,
 66479,
 -1,
 839269983,
 66478,
 839463436,
 838995649,
 66464,
 839581695,
 839420633,
 66504,
 -52725,
 839465137,
 66506,
 -1,
 839518691,
 66505,
 839725584,
 839417401,
 -1,
 -52722,
 839681611,
 66476,
 -52721,
 839727281,
 66480,
 -1,
 839782081,
 66475,
 839987732,
 839677326,
 -1,
 -52718,
 839939554,
 66498,
 -52717,
 839989425,
 66497,
 -1,
 840044225,
 66495,
 840249880,
 839930404,
 -1,
 -52714,
 840205899,
 66488,
 -52713,
 840253023,
 66487,
 -1,
 840306369,
 66486,
 840512028,
 840177653,
 -1,
 840577563,
 840437441,
 66482,
 -1,
 840512764,
 66510,
 -1,
 840534983,
 66511,
 840774175,
 840471455,
 -1,
 -52706,
 840726381,
 66507,
 -1,
 840765121,
 66471,
 840970786,
 840731604,
 -1,
 -52703,
 840908383,
 66491,
 -1,
 840961729,
 66490,
 841167397,
 840920426,
 -1,
 -52700,
 841123403,
 66493,
 -1,
 841158337,
 66492,
 841364008,
 841111661,
 -1,
 -52697,
 841320011,
 66485,
 -1,
 841354945,
 66484,
 841560619,
 841304118,
 -1,
 -52694,
 841516619,
 66468,
 -1,
 841551553,
 66467,
 841757230,
 841500464,
 -1,
 -52691,
 841694815,
 66474,
 -1,
 841748161,
 66473,
 841953841,
 841692362,
 -1,
 -52688,
 841909835,
 66470,
 -1,
 841944769,
 66469,
 -52686,
 841913923,
 66496,
 -52685,
 842110101,
 66489,
 -52684,
 842171979,
 66466,
 -52683,
 842229570,
 66481,
 -52682,
 842287992,
 66494,
 -52681,
 842350175,
 66465,
 -52680,
 842414257,
 66499,
 -52679,
 842478004,
 66483,
 -1,
 842537954,
 66472,
 842740290,
 838949935,
 -1,
 842805824,
 842694201,
 -1,
 842871359,
 842764140,
 -1,
 -52674,
 842816743,
 66514,
 -1,
 842870000,
 66516,
 -1,
 842804221,
 66515,
 -52671,
 842751998,
 66513,
 -1,
 843071005,
 66517,
 -1,
 842699584,
 66512,
 843382783,
 838892279,
 -1,
 843395691,
 843271761,
 -1,
 843461195,
 843349561,
 -1,
 843526729,
 843397275,
 -1,
 -52664,
 843460257,
 68220,
 -1,
 843519921,
 68219,
 -52662,
 843460257,
 68215,
 -1,
 843650993,
 68201,
 843854417,
 843412878,
 -1,
 843919952,
 843779777,
 -1,
 -52658,
 843873849,
 68202,
 -52657,
 843928938,
 68207,
 -1,
 843981946,
 68206,
 -1,
 843856835,
 68198,
 844247638,
 843784910,
 -1,
 844313173,
 844183729,
 -1,
 -52652,
 844254789,
 68217,
 -1,
 844309626,
 68211,
 -1,
 844239495,
 68213,
 844575321,
 844187702,
 -1,
 -52648,
 844511917,
 68205,
 -1,
 844567681,
 68203,
 844771931,
 844511763,
 68192,
 -1,
 844726485,
 68194,
 844903006,
 844707018,
 -1,
 -52643,
 844841377,
 68212,
 -1,
 844904974,
 68214,
 845099617,
 844828353,
 -1,
 -52640,
 845059515,
 68210,
 -1,
 845106497,
 68209,
 -52638,
 845059754,
 68216,
 -52637,
 845256137,
 68218,
 -52636,
 845320212,
 68197,
 -52635,
 845377707,
 68199,
 -52634,
 845442167,
 68196,
 -52633,
 845503586,
 68204,
 -52632,
 845567363,
 68195,
 -52631,
 845630509,
 68193,
 -52630,
 845689363,
 68208,
 -1,
 845748614,
 68200,
 846004223,
 843340843,
 -1,
 846017135,
 845879630,
 -1,
 -52626,
 845963262,
 68221,
 -1,
 846017193,
 68222,
 -1,
 845950415,
 68223,
 846331903,
 833498468,
 -1,
 -52622,
 846238498,
 128117,
 -1,
 846287787,
 128116,
 846528511,
 833421597,
 -1,
 846541466,
 846417489,
 -1,
 846606975,
 846466753,
 -1,
 846672507,
 846532289,
 -1,
 -52616,
 846630764,
 7267,
 -52615,
 846680612,
 7266,
 -52614,
 846743606,
 7264,
 -1,
 846808880,
 7265,
 -52612,
 846626361,
 7259,
 -52611,
 846944817,
 7261,
 -52610,
 847006538,
 7262,
 -1,
 847066314,
 7260,
 847262342,
 846547786,
 -1,
 847327874,
 847187649,
 7258,
 -1,
 847253185,
 7263,
 -52605,
 847283787,
 7273,
 -52604,
 847404263,
 7283,
 -52603,
 847461983,
 7268,
 -1,
 847521915,
 7278,
 847721099,
 847218251,
 -1,
 -52600,
 847680595,
 7277,
 -52599,
 847731469,
 7276,
 -52598,
 847782606,
 7275,
 -1,
 847846342,
 7274,
 848048784,
 847666407,
 -1,
 -52595,
 848006100,
 7286,
 -52594,
 848069811,
 7284,
 -52593,
 848115867,
 7287,
 -1,
 848173045,
 7285,
 848376469,
 847986271,
 -1,
 -52590,
 848328078,
 7269,
 -52589,
 848391530,
 7272,
 -52588,
 848452755,
 7271,
 -1,
 848509083,
 7270,
 848756735,
 848308347,
 -1,
 -52585,
 848655513,
 7282,
 -52584,
 848717571,
 7279,
 -52583,
 848779373,
 7281,
 -1,
 848831429,
 7280,
 849031848,
 846472432,
 -1,
 849097374,
 848985657,
 -1,
 -52579,
 849056402,
 7250,
 -1,
 849100126,
 7251,
 849293985,
 849048974,
 -1,
 -52576,
 849233625,
 7254,
 -1,
 849293184,
 7255,
 849490596,
 849228119,
 -1,
 -52573,
 849437818,
 7252,
 -1,
 849495688,
 7253,
 -52571,
 849450705,
 7248,
 -52570,
 849633278,
 7249,
 -52569,
 849697439,
 7257,
 -1,
 849750837,
 7256,
 849949357,
 848979715,
 -1,
 850014892,
 849905947,
 -1,
 -52565,
 849958849,
 7294,
 -1,
 850011921,
 7295,
 -1,
 849950922,
 7292,
 850277040,
 849893310,
 -1,
 -52561,
 850201137,
 7290,
 -1,
 850265988,
 7288,
 -52559,
 850227303,
 7291,
 -52558,
 850408707,
 7289,
 -1,
 850465147,
 7293,
 850670310,
 833385870,
 -1,
 850735845,
 850613216,
 -1,
 850801367,
 850677329,
 -1,
 850866873,
 850726593,
 66710,
 -52552,
 850808129,
 66688,
 -1,
 850857665,
 66715,
 851063484,
 850818446,
 -1,
 -52549,
 851000220,
 66697,
 -1,
 851054273,
 66696,
 851260094,
 851008743,
 66713,
 -1,
 851205351,
 66717,
 851391169,
 851200054,
 -1,
 -52544,
 851327153,
 66693,
 -1,
 851382077,
 66703,
 851587779,
 851323003,
 66711,
 -1,
 851519611,
 66716,
 851718854,
 851518158,
 -1,
 -52539,
 851654833,
 66698,
 -1,
 851716749,
 66694,
 -52537,
 851678357,
 66709,
 -52536,
 851874794,
 66692,
 -52535,
 851939348,
 66707,
 -52534,
 852002379,
 66714,
 -52533,
 852065967,
 66690,
 -52532,
 852127176,
 66695,
 -52531,
 852192312,
 66702,
 -52530,
 852253828,
 66706,
 -52529,
 852317776,
 66705,
 -52528,
 852380556,
 66704,
 -52527,
 852445006,
 66691,
 -52526,
 852508255,
 66712,
 -52525,
 852572337,
 66708,
 -52524,
 852636924,
 66700,
 -52523,
 852701620,
 66701,
 -52522,
 852761912,
 66699,
 -1,
 852826154,
 66689,
 853082111,
 850732272,
 -1,
 853095131,
 852983353,
 -1,
 -52518,
 853054098,
 66722,
 -1,
 853097822,
 66723,
 853291742,
 853046670,
 -1,
 -52515,
 853231321,
 66726,
 -1,
 853290880,
 66727,
 853488353,
 853225815,
 -1,
 -52512,
 853435514,
 66724,
 -1,
 853493384,
 66725,
 -52510,
 853448401,
 66720,
 -52509,
 853630974,
 66721,
 -52508,
 853695135,
 66729,
 -1,
 853748533,
 66728,
 -1,
 850664390,
 983191,
 854012666,
 850619754,
 -1,
 854078200,
 853952272,
 -1,
 854143729,
 854012992,
 -1,
 854209262,
 854089730,
 -1,
 -52501,
 854161727,
 2933,
 -52500,
 854224078,
 2930,
 -52499,
 854276365,
 2931,
 -1,
 854338392,
 2934,
 854589439,
 854163850,
 -1,
 -52496,
 854489417,
 2935,
 -1,
 854551778,
 2932,
 854733557,
 854101781,
 -1,
 854799092,
 854674250,
 2914,
 -1,
 854739786,
 2915,
 -1,
 854750361,
 2884,
 855048191,
 854675025,
 -1,
 -52489,
 854953907,
 2929,
 -1,
 855018474,
 2869,
 -52487,
 854004681,
 128217,
 -1,
 855115872,
 10183,
 855323402,
 853960451,
 -1,
 855388936,
 855255163,
 -1,
 855454471,
 855332975,
 -1,
 855520000,
 855407950,
 -1,
 -52481,
 855468223,
 10180,
 -1,
 855513934,
 10179,
 855716611,
 855462639,
 -1,
 -52478,
 855666255,
 128236,
 -1,
 855724384,
 128237,
 -52476,
 855658611,
 128275,
 -52475,
 855849346,
 128080,
 -52474,
 855913142,
 128194,
 -1,
 855972543,
 128214,
 -1,
 855404290,
 983190,
 -52471,
 855343609,
 128191,
 -1,
 856177667,
 9934,
 856371986,
 855267437,
 -1,
 856437520,
 856301624,
 -1,
 -52467,
 856391585,
 128662,
 -52466,
 856451707,
 128660,
 -52465,
 856497048,
 128653,
 -1,
 856561489,
 128664,
 -52463,
 856369319,
 11819,
 -1,
 856688764,
 128283,
 856896277,
 856329114,
 -1,
 -52460,
 856837991,
 9885,
 -1,
 856890118,
 128228,
 -52458,
 856855455,
 128002,
 -52457,
 857032773,
 128076,
 -52456,
 857092701,
 127970,
 -52455,
 857154573,
 127842,
 -1,
 857219627,
 128025,
 857420945,
 833304731,
 -1,
 857486284,
 857345729,
 -1,
 857551812,
 857430125,
 -1,
 857617347,
 857487461,
 -1,
 857682837,
 857556784,
 -1,
 857748332,
 857628853,
 -1,
 857813813,
 857699726,
 -1,
 857879340,
 857765422,
 -1,
 857944868,
 857834034,
 55245,
 -1,
 857868933,
 55246,
 858075943,
 857897213,
 -1,
 -52442,
 858030642,
 55277,
 -1,
 858081907,
 55276,
 -52440,
 858026426,
 55255,
 -52439,
 858220861,
 55270,
 -52438,
 858282614,
 4607,
 -52437,
 858347063,
 55264,
 -1,
 858398374,
 55289,
 858652671,
 857818360,
 -1,
 858665776,
 858528710,
 -1,
 -52433,
 858603596,
 55279,
 -1,
 858667793,
 55280,
 -52431,
 858620220,
 55281,
 -52430,
 858810284,
 55278,
 -52429,
 858871351,
 55274,
 -52428,
 858933500,
 55275,
 -1,
 858995480,
 55282,
 859190084,
 857761539,
 -1,
 859255614,
 859127896,
 -1,
 859321146,
 859184070,
 -1,
 -52423,
 859258956,
 55272,
 -1,
 859323153,
 55273,
 -52421,
 859275826,
 55267,
 -52420,
 859470107,
 55271,
 -52419,
 859533768,
 55268,
 -1,
 859592247,
 55269,
 859779905,
 859192112,
 -1,
 -52416,
 859734332,
 55291,
 -1,
 859797752,
 55290,
 860028927,
 859706409,
 -1,
 -52413,
 859924797,
 55283,
 -1,
 859982076,
 55284,
 860173134,
 859140531,
 -1,
 860238664,
 860132601,
 -1,
 -52409,
 860190853,
 55259,
 -1,
 860250791,
 55260,
 860435275,
 860186947,
 -1,
 -52406,
 860389938,
 55257,
 -1,
 860449026,
 55258,
 -52404,
 860388295,
 55253,
 -52403,
 860575300,
 55256,
 -1,
 860637818,
 55254,
 860828502,
 860127801,
 -1,
 860894033,
 860780792,
 55248,
 -1,
 860818002,
 55249,
 861025108,
 860822470,
 -1,
 -52397,
 860962892,
 55250,
 -1,
 861027089,
 55251,
 -52395,
 860979516,
 55252,
 -1,
 861169981,
 55247,
 861352798,
 860768310,
 -1,
 861418333,
 861292320,
 -1,
 -52391,
 861366589,
 4603,
 -52390,
 861428342,
 4602,
 -52389,
 861489678,
 4605,
 -52388,
 861551384,
 4606,
 -1,
 861609522,
 4604,
 -1,
 861344961,
 55261,
 861877091,
 861296189,
 -1,
 -52384,
 861830099,
 55263,
 -52383,
 861890890,
 55265,
 -52382,
 861952630,
 55262,
 -1,
 862002854,
 55266,
 862204774,
 861836618,
 -1,
 -52379,
 862148151,
 55285,
 -1,
 862206744,
 55286,
 862401385,
 862149244,
 -1,
 -52376,
 862351789,
 55243,
 -1,
 862395954,
 55244,
 862650367,
 862330540,
 -1,
 -52373,
 862551006,
 55288,
 -1,
 862611773,
 55287,
 862846975,
 857704847,
 -1,
 862860152,
 862731952,
 -1,
 862925686,
 862819411,
 -1,
 862991217,
 862857339,
 55232,
 -1,
 862936295,
 55231,
 863122292,
 862916289,
 -1,
 -52365,
 863053947,
 55230,
 -1,
 863111810,
 55229,
 -52363,
 863077963,
 55235,
 -1,
 863263975,
 55234,
 -52361,
 862870799,
 55233,
 -1,
 863387231,
 55236,
 863581058,
 862819411,
 -1,
 863646589,
 863526156,
 -1,
 863712124,
 863571649,
 55218,
 -1,
 863643771,
 55219,
 -1,
 863644938,
 55220,
 863908736,
 863602333,
 -1,
 -52353,
 863853799,
 55224,
 -1,
 863899776,
 55223,
 -52351,
 863841549,
 4517,
 -1,
 864030505,
 4516,
 864236424,
 863526156,
 -1,
 864301959,
 864195667,
 -1,
 864367494,
 864227009,
 4518,
 -1,
 864299131,
 4519,
 -1,
 864300298,
 55216,
 -1,
 864247055,
 55217,
 864629645,
 864169713,
 -1,
 864695179,
 864561275,
 55227,
 -1,
 864640231,
 55226,
 -52340,
 864640231,
 55228,
 -1,
 864751297,
 55225,
 864957330,
 864554689,
 -1,
 865022865,
 864906757,
 -1,
 -52336,
 864954491,
 55238,
 -1,
 865013441,
 55237,
 -1,
 864946733,
 4515,
 865337343,
 864913053,
 -1,
 -52332,
 865244465,
 55221,
 -1,
 865287859,
 55222,
 865533951,
 857611858,
 -1,
 865547173,
 865431987,
 -1,
 865612701,
 865498510,
 -1,
 865678236,
 865564206,
 -1,
 -52326,
 865632818,
 43367,
 -52325,
 865691965,
 43370,
 -1,
 865749619,
 43365,
 -1,
 865617140,
 43372,
 866005921,
 865552438,
 -1,
 -52321,
 865945370,
 43364,
 -52320,
 866007849,
 43374,
 -1,
 866063540,
 43371,
 -52318,
 865960498,
 43366,
 -52317,
 866216253,
 43369,
 -52316,
 866276919,
 43368,
 -1,
 866328230,
 43373,
 866530219,
 865501753,
 -1,
 -52313,
 866482424,
 43362,
 -52312,
 866546093,
 4446,
 -52311,
 866609469,
 43361,
 -52310,
 866670135,
 43360,
 -1,
 866721446,
 43363,
 866923440,
 866483137,
 -1,
 -52307,
 866882869,
 43388,
 -52306,
 866943292,
 43385,
 -52305,
 867006723,
 43381,
 -1,
 867049139,
 43384,
 867251126,
 866871043,
 -1,
 867316661,
 867188824,
 -1,
 -52301,
 867268878,
 43378,
 -52300,
 867322382,
 43379,
 -1,
 867384088,
 43380,
 -1,
 867253048,
 43386,
 867644346,
 867195516,
 -1,
 -52296,
 867596536,
 4443,
 -52295,
 867646232,
 4445,
 -1,
 867704486,
 4444,
 867906494,
 867587645,
 -1,
 -52292,
 867861042,
 43376,
 -52291,
 867924216,
 43377,
 -1,
 867977843,
 43375,
 868168641,
 867844177,
 -1,
 -52288,
 868118957,
 43382,
 -1,
 868170520,
 43383,
 -52286,
 868108935,
 4442,
 -1,
 868301598,
 43387,
 -1,
 857547706,
 128092,
 868561865,
 857494052,
 -1,
 868627399,
 868505017,
 128296,
 -1,
 868548720,
 9874,
 -52280,
 868580430,
 128057,
 -1,
 868686737,
 127828,
 -52278,
 868515754,
 128035,
 -52277,
 868838154,
 128587,
 -1,
 868894014,
 128135,
 869086294,
 857417851,
 -1,
 869151788,
 869045235,
 -1,
 869217251,
 869105209,
 -1,
 869282786,
 869153302,
 -1,
 869348308,
 869211078,
 -1,
 -52270,
 869298111,
 19904,
 -52269,
 869355395,
 19933,
 -1,
 869406529,
 19953,
 869610457,
 869273281,
 -1,
 869675992,
 869559658,
 -1,
 -52265,
 869623004,
 19954,
 -1,
 869685332,
 19910,
 -1,
 869604281,
 19932,
 869938140,
 869568364,
 -1,
 -52261,
 869870495,
 19951,
 -1,
 869929903,
 19959,
 -52259,
 869887959,
 19905,
 -52258,
 870077481,
 19957,
 -52257,
 870140311,
 19955,
 -52256,
 870205449,
 19961,
 -52255,
 870266443,
 19960,
 -1,
 870330869,
 19940,
 -1,
 869232522,
 19913,
 870593517,
 869147342,
 -1,
 870659048,
 870525051,
 -1,
 -52250,
 870616311,
 19956,
 -52249,
 870666182,
 19943,
 -1,
 870719792,
 19944,
 870921195,
 870596191,
 -1,
 -52246,
 870873917,
 19962,
 -1,
 870920823,
 19906,
 -52244,
 870877933,
 19935,
 -1,
 871044437,
 19939,
 871248888,
 870528202,
 -1,
 871314423,
 871198058,
 -1,
 871379958,
 871246298,
 -1,
 871445493,
 871327491,
 -1,
 871511028,
 871390439,
 -1,
 -52237,
 871469160,
 19937,
 -1,
 871529449,
 19917,
 -1,
 871460992,
 19931,
 -1,
 871399285,
 19929,
 -1,
 871305198,
 19925,
 -1,
 871241430,
 19948,
 871969790,
 871200142,
 -1,
 872035324,
 871912254,
 -1,
 -52229,
 871989109,
 19912,
 -1,
 872049454,
 19965,
 -52227,
 871989120,
 19915,
 -1,
 872180150,
 19926,
 872363012,
 871907809,
 -1,
 872428546,
 872306797,
 -1,
 -52223,
 872373623,
 19928,
 -1,
 872426904,
 19964,
 -52221,
 872362890,
 19934,
 -1,
 872554800,
 19945,
 872756233,
 872312711,
 -1,
 872821768,
 872709689,
 -1,
 -52217,
 872778528,
 19927,
 -1,
 872837032,
 19936,
 -1,
 872779438,
 19952,
 873083917,
 872703747,
 -1,
 -52213,
 873040751,
 19949,
 -52212,
 873100315,
 19938,
 -1,
 873146738,
 19914,
 873346066,
 873028839,
 -1,
 873411601,
 873294538,
 -1,
 -52208,
 873361592,
 19950,
 -1,
 873423681,
 19941,
 -1,
 873339735,
 19942,
 873673751,
 873275397,
 -1,
 873739286,
 873617517,
 -1,
 -52203,
 873693238,
 19923,
 -1,
 873739124,
 19909,
 -1,
 873682563,
 19947,
 874001435,
 873601013,
 -1,
 -52199,
 873951132,
 19946,
 -52198,
 874006114,
 19924,
 -1,
 874064592,
 19967,
 874263583,
 873926337,
 -1,
 -52195,
 874212085,
 19922,
 -52194,
 874263713,
 19966,
 -1,
 874322815,
 19958,
 874525730,
 874221420,
 -1,
 -52191,
 874472137,
 19921,
 -1,
 874516942,
 19908,
 874722341,
 874469121,
 -1,
 -52188,
 874679213,
 19930,
 -1,
 874718304,
 19918,
 874918952,
 874656087,
 -1,
 -52185,
 874864432,
 19920,
 -1,
 874916783,
 19916,
 -52183,
 874878414,
 19907,
 -52182,
 875056958,
 19963,
 -52181,
 875117686,
 19911,
 -1,
 875179218,
 19919,
 875377738,
 869076673,
 -1,
 875443264,
 875335522,
 -1,
 875508787,
 875372223,
 11096,
 875574322,
 875431844,
 -1,
 -52175,
 875527419,
 9955,
 -1,
 875568838,
 11095,
 -1,
 875504376,
 11097,
 875836472,
 875449162,
 -1,
 875902007,
 875783794,
 -1,
 -52170,
 875854035,
 10079,
 -1,
 875898570,
 10080,
 -1,
 875828527,
 11093,
 876164155,
 875766478,
 -1,
 -52166,
 876109605,
 128178,
 -1,
 876168908,
 10135,
 -52164,
 876122303,
 9947,
 -52163,
 876308981,
 10133,
 -52162,
 876373283,
 11094,
 -52161,
 876435107,
 10134,
 -1,
 876490868,
 10071,
 876688455,
 875392362,
 -1,
 876753990,
 876641851,
 -1,
 876819525,
 876712331,
 -1,
 -52156,
 876769663,
 128157,
 -1,
 876811684,
 128152,
 -1,
 876749799,
 128159,
 -1,
 876677746,
 128585,
 877199359,
 876618446,
 -1,
 -52151,
 877100175,
 9980,
 -1,
 877160714,
 127911,
 877343826,
 875305782,
 -1,
 877409360,
 877291267,
 -1,
 877474895,
 877354652,
 -1,
 -52146,
 877423700,
 1479,
 -1,
 877476962,
 1466,
 -1,
 877431095,
 1478,
 -52143,
 877351935,
 1477,
 -1,
 877662170,
 1442,
 877868117,
 877284170,
 -1,
 -52140,
 877811175,
 9937,
 -1,
 877871000,
 128641,
 -1,
 877817657,
 127807,
 878130291,
 869031143,
 -1,
 878195813,
 878079338,
 -1,
 878261345,
 878135079,
 -1,
 878326879,
 878214713,
 -1,
 878392414,
 878251980,
 983059,
 878510079,
 878313472,
 -1,
 -52131,
 878416305,
 983140,
 -1,
 878475014,
 983137,
 -1,
 878341643,
 128677,
 -52128,
 878269217,
 9897,
 -1,
 878647863,
 11043,
 878903295,
 878212739,
 128014,
 878968831,
 878772224,
 -1,
 -52124,
 878865891,
 127943,
 -1,
 878916023,
 128052,
 879113322,
 878151243,
 -1,
 879178857,
 879064710,
 -1,
 -52120,
 879137189,
 127969,
 -1,
 879172462,
 127968,
 -1,
 879128855,
 9203,
 879441005,
 879066681,
 -1,
 -52116,
 879373183,
 127976,
 -1,
 879427789,
 9749,
 879637616,
 879385133,
 -1,
 -52113,
 879565084,
 128029,
 -1,
 879625702,
 127855,
 -52111,
 879590243,
 127973,
 -52110,
 879781635,
 983123,
 -1,
 879828553,
 128298,
 880030855,
 878067295,
 -1,
 880096380,
 879980056,
 -1,
 880161915,
 880024000,
 -1,
 -52105,
 880117323,
 983959,
 -52104,
 880172263,
 983961,
 -52103,
 880229983,
 983958,
 -52102,
 880289915,
 983960,
 -1,
 880348865,
 983957,
 -1,
 880088327,
 110593,
 880620677,
 880031395,
 -1,
 880686209,
 880544222,
 -1,
 880751744,
 880638769,
 128644,
 -1,
 880674731,
 128645,
 -1,
 880687712,
 128096,
 881000447,
 880607232,
 -1,
 -52093,
 880905889,
 9889,
 -52092,
 880958867,
 983122,
 -1,
 881007420,
 128262,
 -52090,
 880573606,
 9964,
 -1,
 881138183,
 127802,
 881341578,
 879984185,
 983060,
 -52087,
 881292686,
 983138,
 -1,
 881346352,
 983141,
 881538189,
 881300970,
 -1,
 -52084,
 881483205,
 11794,
 -1,
 881539701,
 11802,
 881734800,
 881493579,
 -1,
 -52081,
 881686491,
 128559,
 -1,
 881744265,
 128175,
 -1,
 881685890,
 8372,
 881997261,
 857364589,
 -1,
 882062670,
 881928315,
 -1,
 882128135,
 882020204,
 -1,
 882193670,
 882049024,
 -1,
 882259202,
 882147095,
 -1,
 882324697,
 882200145,
 -1,
 882390196,
 882266396,
 -1,
 882455708,
 882343481,
 -1,
 -52070,
 882406882,
 6539,
 -52069,
 882456753,
 6546,
 -1,
 882511553,
 6545,
 882717855,
 882414495,
 -1,
 -52066,
 882674666,
 6569,
 -1,
 882708161,
 6534,
 882914466,
 882668942,
 -1,
 -52063,
 882869948,
 6571,
 -1,
 882904769,
 6540,
 883111077,
 882861827,
 -1,
 -52060,
 883046577,
 6552,
 -1,
 883101377,
 6551,
 883307688,
 883054701,
 -1,
 -52057,
 883242236,
 6535,
 -1,
 883297985,
 6547,
 883504299,
 883247158,
 -1,
 -52054,
 883461098,
 6568,
 -1,
 883494593,
 6533,
 -52052,
 883463317,
 6541,
 -52051,
 883657706,
 6558,
 -52050,
 883715125,
 6529,
 -52049,
 883774077,
 6553,
 -52048,
 883837816,
 6559,
 -52047,
 883898545,
 6563,
 -52046,
 883962292,
 6557,
 -52045,
 884024107,
 6564,
 -1,
 884086826,
 6565,
 884290769,
 882326341,
 -1,
 884356281,
 884244025,
 -1,
 -52041,
 884307426,
 6536,
 -52040,
 884357297,
 6543,
 -1,
 884412097,
 6542,
 884618428,
 884315039,
 -1,
 -52037,
 884575210,
 6567,
 -1,
 884608705,
 6531,
 884815039,
 884569486,
 -1,
 -52034,
 884770492,
 6570,
 -1,
 884805313,
 6537,
 885011650,
 884762371,
 -1,
 -52031,
 884947121,
 6549,
 -1,
 885001921,
 6548,
 885208261,
 884955245,
 -1,
 -52028,
 885142780,
 6532,
 -1,
 885198529,
 6544,
 885404872,
 885147702,
 -1,
 -52025,
 885361642,
 6566,
 -1,
 885395137,
 6530,
 -52023,
 885363861,
 6538,
 -52022,
 885558250,
 6555,
 -52021,
 885615669,
 6528,
 -52020,
 885674621,
 6550,
 -52019,
 885738360,
 6556,
 -52018,
 885799089,
 6560,
 -52017,
 885862836,
 6554,
 -52016,
 885924651,
 6561,
 -1,
 885987370,
 6562,
 886243327,
 884224714,
 -1,
 886256852,
 886134893,
 6595,
 -1,
 886191306,
 6594,
 -52011,
 886213588,
 6593,
 -52010,
 886329892,
 6596,
 -52009,
 886392886,
 6597,
 -52008,
 886448846,
 6598,
 -1,
 886511605,
 6599,
 886715629,
 882282235,
 -1,
 886781151,
 886670923,
 6579,
 886846685,
 886712443,
 6585,
 -1,
 886805587,
 6591,
 -52002,
 886805587,
 6588,
 -1,
 886933067,
 6580,
 887108835,
 886725863,
 6583,
 887174370,
 887033537,
 6584,
 -1,
 887133267,
 6590,
 -1,
 887133267,
 6589,
 887370984,
 887033537,
 -1,
 887436518,
 887295681,
 6577,
 -1,
 887395411,
 6587,
 -51993,
 887395411,
 6586,
 -1,
 887498875,
 6582,
 887698667,
 887307871,
 -1,
 -51990,
 887657555,
 6592,
 -1,
 887701087,
 6578,
 -51988,
 887656171,
 6576,
 -1,
 887826555,
 6581,
 888026363,
 886646000,
 -1,
 888091889,
 887979577,
 -1,
 -51984,
 888050322,
 6610,
 -1,
 888094046,
 6611,
 888288500,
 888042894,
 -1,
 -51981,
 888227545,
 6614,
 -1,
 888287104,
 6615,
 888485111,
 888222039,
 -1,
 -51978,
 888431738,
 6612,
 -1,
 888489608,
 6613,
 -51976,
 888444625,
 6608,
 -51975,
 888627198,
 6609,
 -51974,
 888691359,
 6617,
 -1,
 888744757,
 6616,
 888943872,
 887979577,
 -1,
 889009407,
 888889412,
 -1,
 -51970,
 888933427,
 6601,
 -1,
 888998819,
 6600,
 -1,
 888944947,
 6618,
 889323519,
 888895653,
 6622,
 -1,
 889228244,
 6623,
 889402629,
 882202507,
 -1,
 -51964,
 889360795,
 127770,
 -1,
 889421302,
 127761,
 -1,
 889343817,
 983063,
 -1,
 882146090,
 128240,
 889730376,
 882062743,
 -1,
 889795882,
 889682824,
 -1,
 889861412,
 889736303,
 -1,
 -51957,
 889820723,
 127369,
 -51956,
 889885779,
 127368,
 -51955,
 889951135,
 127367,
 -51954,
 890015596,
 127366,
 -51953,
 890080212,
 127365,
 -51952,
 890144331,
 127364,
 -51951,
 890207801,
 127363,
 -51950,
 890271118,
 127362,
 -51949,
 890334570,
 127361,
 -51948,
 890399783,
 127360,
 -51947,
 890464003,
 127359,
 -51946,
 890526951,
 127358,
 -51945,
 890591341,
 127357,
 -51944,
 890655268,
 127356,
 -51943,
 890719050,
 127355,
 -51942,
 890783798,
 127354,
 -51941,
 890849072,
 127353,
 -51940,
 890912351,
 127352,
 -51939,
 890976411,
 127351,
 -51938,
 891040970,
 127350,
 -51937,
 891105623,
 127349,
 -51936,
 891168891,
 127348,
 -51935,
 891232974,
 127347,
 -51934,
 891296710,
 127346,
 -51933,
 891361269,
 127345,
 -1,
 891424449,
 127344,
 -51931,
 889819201,
 127375,
 -51930,
 891581922,
 127373,
 -51929,
 891643714,
 127372,
 -51928,
 891699009,
 127371,
 -51927,
 891756906,
 10062,
 -1,
 891817820,
 127374,
 892024135,
 889724628,
 -1,
 892089670,
 891964527,
 -1,
 -51923,
 892048947,
 127337,
 -51922,
 892114003,
 127336,
 -51921,
 892179359,
 127335,
 -51920,
 892243820,
 127334,
 -51919,
 892308436,
 127333,
 -51918,
 892372555,
 127332,
 -51917,
 892436025,
 127331,
 -51916,
 892499342,
 127330,
 -51915,
 892562794,
 127329,
 -51914,
 892628007,
 127328,
 -51913,
 892692227,
 127327,
 -51912,
 892755175,
 127326,
 -51911,
 892819565,
 127325,
 -51910,
 892883492,
 127324,
 -51909,
 892947274,
 127323,
 -51908,
 893012022,
 127322,
 -51907,
 893077296,
 127321,
 -51906,
 893140575,
 127320,
 -51905,
 893204635,
 127319,
 -51904,
 893269194,
 127318,
 -51903,
 893333847,
 127317,
 -51902,
 893397115,
 127316,
 -51901,
 893461198,
 127315,
 -51900,
 893524934,
 127314,
 -51899,
 893589493,
 127313,
 -1,
 893652673,
 127312,
 -1,
 892019959,
 9471,
 -1,
 891949063,
 983091,
 893990219,
 889686938,
 -1,
 -51894,
 893939349,
 128528,
 -1,
 893988193,
 9906,
 -51892,
 893948987,
 983130,
 -51891,
 894126922,
 983131,
 -1,
 894181242,
 128084,
 894383512,
 882002593,
 -1,
 894449015,
 894323530,
 -1,
 894514549,
 894381761,
 -1,
 894580054,
 894457965,
 2002,
 894645588,
 894538901,
 2018,
 -1,
 894568909,
 2023,
 894828543,
 894570177,
 2019,
 -1,
 894699981,
 2016,
 894907740,
 894519088,
 -1,
 894973275,
 894853108,
 -1,
 -51879,
 894922184,
 2026,
 -51878,
 894977870,
 2024,
 -1,
 895032752,
 2025,
 -1,
 894897857,
 2006,
 895300959,
 894856554,
 -1,
 -51874,
 895249864,
 2010,
 -1,
 895291073,
 2009,
 895497569,
 895245543,
 2000,
 -1,
 895442151,
 1999,
 895628643,
 895428731,
 1997,
 -1,
 895559803,
 1995,
 895759717,
 895558443,
 2008,
 -1,
 895694297,
 2001,
 -51866,
 895718549,
 2022,
 -51865,
 895848371,
 2021,
 -51864,
 895911499,
 1998,
 -51863,
 895975087,
 2005,
 -51862,
 896038370,
 2011,
 -51861,
 896100162,
 2004,
 -51860,
 896160381,
 2017,
 -51859,
 896224120,
 2015,
 -51858,
 896288904,
 2014,
 -51857,
 896351839,
 1996,
 -51856,
 896415921,
 2020,
 -51855,
 896480701,
 2012,
 -51854,
 896545204,
 2013,
 -51853,
 896605616,
 2007,
 -51852,
 896669738,
 2003,
 -1,
 896732865,
 1994,
 -51850,
 894461586,
 2037,
 -1,
 896864749,
 2042,
 897070469,
 894379248,
 -1,
 897135995,
 897023545,
 -1,
 -51846,
 897094290,
 1986,
 -1,
 897138014,
 1987,
 897332606,
 897086862,
 -1,
 -51843,
 897271513,
 1990,
 -1,
 897331072,
 1991,
 897529217,
 897266007,
 -1,
 -51840,
 897475706,
 1988,
 -1,
 897533576,
 1989,
 -51838,
 897488593,
 1984,
 -51837,
 897671166,
 1985,
 -51836,
 897735327,
 1993,
 -1,
 897788725,
 1992,
 897987987,
 896999465,
 -1,
 898053522,
 897915372,
 -1,
 898119052,
 897994905,
 -1,
 -51831,
 898069386,
 2033,
 -51830,
 898126136,
 2032,
 -51829,
 898186109,
 2031,
 -1,
 898245691,
 2030,
 898446736,
 898070584,
 -1,
 -51826,
 898397066,
 2029,
 -51825,
 898453816,
 2028,
 -1,
 898513789,
 2027,
 -51823,
 898390268,
 2034,
 -1,
 898639599,
 2035,
 -1,
 897995389,
 2040,
 898905494,
 897940989,
 -1,
 -51819,
 898851067,
 2038,
 -1,
 898905537,
 2039,
 -51817,
 898841479,
 2036,
 -1,
 899035209,
 2041,
 899233215,
 894328039,
 -1,
 899298735,
 899183840,
 -1,
 899364265,
 899236431,
 -1,
 899429796,
 899298368,
 -1,
 899495329,
 899375106,
 -1,
 -51810,
 899447103,
 43059,
 -51809,
 899509454,
 43056,
 -51808,
 899561741,
 43057,
 -1,
 899623768,
 43060,
 899874815,
 899449226,
 -1,
 -51805,
 899774793,
 43061,
 -1,
 899837154,
 43058,
 900019623,
 899378303,
 -1,
 -51802,
 899970262,
 43062,
 -1,
 900029438,
 43065,
 -51800,
 899970383,
 43064,
 -1,
 900163949,
 43063,
 900347308,
 899321964,
 -1,
 -51797,
 900305062,
 11009,
 -1,
 900340254,
 11017,
 900595711,
 900278704,
 -1,
 -51794,
 900501670,
 11008,
 -1,
 900536862,
 11016,
 900740537,
 899219456,
 -1,
 900806066,
 900672746,
 9940,
 -1,
 900728393,
 128683,
 900937141,
 900732917,
 -1,
 -51788,
 900886418,
 983126,
 -1,
 900939698,
 128691,
 -51786,
 900889248,
 128685,
 -51785,
 901081133,
 128695,
 -51784,
 901144669,
 128286,
 -1,
 901207812,
 128245,
 901395901,
 900693561,
 -1,
 901461436,
 901327385,
 128211,
 -1,
 901384217,
 128212,
 -1,
 901389791,
 128323,
 -51778,
 901346947,
 128067,
 -1,
 901601444,
 128689,
 901789123,
 899188299,
 -1,
 901854658,
 901729098,
 983041,
 -1,
 901794634,
 983040,
 -1,
 901807678,
 128297,
 902051271,
 901713601,
 -1,
 -51771,
 901993687,
 128219,
 -51770,
 902055990,
 983092,
 -1,
 902119764,
 128133,
 902313418,
 901978101,
 -1,
 -51767,
 902265606,
 983196,
 -1,
 902314139,
 983127,
 -51765,
 902256936,
 983222,
 -51764,
 902449994,
 983066,
 -1,
 902512870,
 127747,
 902706927,
 881926862,
 -1,
 902772322,
 902651111,
 -1,
 902837830,
 902715032,
 -1,
 902903307,
 902794573,
 -1,
 902968842,
 902826464,
 -1,
 903034330,
 902893067,
 -1,
 -51756,
 902958557,
 127123,
 -51755,
 903023984,
 127122,
 -51754,
 903089458,
 127121,
 -51753,
 903154890,
 127120,
 -51752,
 903220275,
 127119,
 -51751,
 903285667,
 127118,
 -1,
 903351072,
 127117,
 903558626,
 902958524,
 -1,
 -51748,
 903482845,
 127116,
 -51747,
 903548272,
 127115,
 -51746,
 903613746,
 127114,
 -51745,
 903679178,
 127113,
 -51744,
 903744563,
 127112,
 -51743,
 903809955,
 127111,
 -1,
 903875360,
 127110,
 904082922,
 903482720,
 -1,
 -51740,
 904007133,
 127109,
 -51739,
 904072560,
 127108,
 -51738,
 904138034,
 127107,
 -51737,
 904203466,
 127106,
 -51736,
 904268851,
 127105,
 -51735,
 904334243,
 127104,
 -1,
 904399648,
 127103,
 904607218,
 904006945,
 -1,
 -51732,
 904531421,
 127102,
 -51731,
 904596848,
 127101,
 -51730,
 904662322,
 127100,
 -51729,
 904727754,
 127099,
 -51728,
 904793139,
 127098,
 -51727,
 904858531,
 127097,
 -1,
 904923936,
 127096,
 905131514,
 904531109,
 -1,
 -51724,
 905055709,
 127095,
 -51723,
 905121136,
 127094,
 -51722,
 905186610,
 127093,
 -51721,
 905252042,
 127092,
 -51720,
 905317427,
 127091,
 -51719,
 905382819,
 127090,
 -1,
 905448224,
 127089,
 905655810,
 905055249,
 -1,
 -51716,
 905579997,
 127088,
 -51715,
 905645424,
 127087,
 -51714,
 905710898,
 127086,
 -51713,
 905776330,
 127085,
 -51712,
 905841715,
 127084,
 -51711,
 905907107,
 127083,
 -1,
 905972512,
 127082,
 906231807,
 905579410,
 -1,
 -51708,
 906104285,
 127081,
 -51707,
 906169712,
 127080,
 -51706,
 906235186,
 127079,
 -51705,
 906300618,
 127078,
 -51704,
 906366003,
 127077,
 -51703,
 906431395,
 127076,
 -1,
 906496800,
 127075,
 -1,
 902889659,
 127074,
 906821631,
 902839486,
 -1,
 906835525,
 906693088,
 -1,
 906901013,
 906759691,
 -1,
 -51697,
 906825181,
 127073,
 -51696,
 906890608,
 127072,
 -51695,
 906956082,
 127071,
 -51694,
 907021514,
 127070,
 -51693,
 907086899,
 127069,
 -51692,
 907152291,
 127068,
 -1,
 907217696,
 127067,
 907425309,
 906825148,
 -1,
 -51689,
 907349469,
 127066,
 -51688,
 907414896,
 127065,
 -51687,
 907480370,
 127064,
 -51686,
 907545802,
 127063,
 -51685,
 907611187,
 127062,
 -51684,
 907676579,
 127061,
 -1,
 907741984,
 127060,
 907949605,
 907349344,
 -1,
 -51681,
 907873757,
 127059,
 -51680,
 907939184,
 127058,
 -51679,
 908004658,
 127057,
 -51678,
 908070090,
 127056,
 -51677,
 908135475,
 127055,
 -51676,
 908200867,
 127054,
 -1,
 908266272,
 127053,
 908473901,
 907873569,
 -1,
 -51673,
 908398045,
 127052,
 -51672,
 908463472,
 127051,
 -51671,
 908528946,
 127050,
 -51670,
 908594378,
 127049,
 -51669,
 908659763,
 127048,
 -51668,
 908725155,
 127047,
 -1,
 908790560,
 127046,
 908998197,
 908397733,
 -1,
 -51665,
 908922333,
 127045,
 -51664,
 908987760,
 127044,
 -51663,
 909053234,
 127043,
 -51662,
 909118666,
 127042,
 -51661,
 909184051,
 127041,
 -51660,
 909249443,
 127040,
 -1,
 909314848,
 127039,
 909522493,
 908921873,
 -1,
 -51657,
 909446621,
 127038,
 -51656,
 909512048,
 127037,
 -51655,
 909577522,
 127036,
 -51654,
 909642954,
 127035,
 -51653,
 909708339,
 127034,
 -51652,
 909773731,
 127033,
 -1,
 909839136,
 127032,
 910098431,
 909446034,
 -1,
 -51649,
 909970909,
 127031,
 -51648,
 910036336,
 127030,
 -51647,
 910101810,
 127029,
 -51646,
 910167242,
 127028,
 -51645,
 910232627,
 127027,
 -51644,
 910298019,
 127026,
 -1,
 910363424,
 127025,
 -1,
 906756283,
 127024,
 910636624,
 902792779,
 -1,
 910702159,
 910563927,
 -1,
 910767691,
 910631632,
 -1,
 -51638,
 910709527,
 9891,
 -1,
 910766653,
 9890,
 910964302,
 910688256,
 -1,
 -51635,
 910908727,
 11799,
 -1,
 910959259,
 10175,
 -1,
 910887683,
 8508,
 -1,
 910636759,
 127849,
 911291990,
 910591158,
 -1,
 -51630,
 911246279,
 11784,
 -51629,
 911309674,
 11034,
 -51628,
 911372894,
 11798,
 -51627,
 911433002,
 11795,
 -1,
 911483236,
 8284,
 911685213,
 911250023,
 -1,
 911750746,
 911642577,
 -1,
 -51623,
 911677982,
 11015,
 -1,
 911741760,
 11796,
 911998975,
 911673996,
 -1,
 -51620,
 911899166,
 128317,
 -1,
 911962138,
 128315,
 912143967,
 911619274,
 128021,
 -1,
 912064958,
 128054,
 -51616,
 912089699,
 128682,
 -51615,
 912216471,
 128044,
 -1,
 912261971,
 128687,
 912471717,
 902703227,
 -1,
 912537239,
 912427988,
 -1,
 912602768,
 912462647,
 -1,
 912668279,
 912543313,
 -1,
 912733801,
 912623179,
 -1,
 -51608,
 912689151,
 2423,
 -1,
 912730235,
 2422,
 912930412,
 912678119,
 -1,
 -51605,
 912874980,
 2420,
 -1,
 912926843,
 2419,
 913127023,
 912864458,
 -1,
 -51602,
 913068295,
 2429,
 -1,
 913126652,
 2427,
 -51600,
 913086248,
 2425,
 -51599,
 913274943,
 2308,
 -51598,
 913328081,
 2428,
 -51597,
 913390167,
 2426,
 -51596,
 913449928,
 2430,
 -51595,
 913513540,
 2418,
 -51594,
 913578233,
 2431,
 -1,
 913643441,
 2421,
 913847939,
 912619665,
 -1,
 913913470,
 913775719,
 -1,
 913979004,
 913866297,
 -1,
 -51589,
 913937042,
 43253,
 -1,
 913980766,
 43254,
 -51587,
 913935894,
 43251,
 -1,
 914102115,
 43255,
 -51585,
 913865487,
 43250,
 -51584,
 914254846,
 43256,
 -51583,
 914310242,
 2304,
 -51582,
 914373472,
 2417,
 -1,
 914433712,
 43252,
 914634381,
 913805051,
 -1,
 914699911,
 914589259,
 -1,
 -51578,
 914655231,
 2391,
 -1,
 914696315,
 2390,
 914896522,
 914644199,
 -1,
 -51575,
 914841060,
 2363,
 -1,
 914892923,
 2362,
 -51573,
 914844516,
 2382,
 -51572,
 915020877,
 2389,
 -1,
 915085233,
 2383,
 -51570,
 914569773,
 43259,
 -51569,
 915223935,
 43257,
 -1,
 915283129,
 43258,
 915537919,
 912539466,
 -1,
 915551892,
 915439161,
 -1,
 -51565,
 915509906,
 983085,
 -1,
 915553630,
 983087,
 -51563,
 915504341,
 983160,
 -51562,
 915693566,
 983083,
 -1,
 915747826,
 983089,
 915945118,
 912488191,
 -1,
 916010651,
 915896834,
 -1,
 -51558,
 915955336,
 66638,
 -1,
 916009008,
 66639,
 916258815,
 915938453,
 -1,
 -51555,
 916151944,
 66598,
 -1,
 916205616,
 66599,
 916403873,
 915884874,
 983119,
 -51552,
 916342464,
 128666,
 -1,
 916401809,
 983118,
 916600484,
 916332182,
 -1,
 -51549,
 916542211,
 9192,
 -1,
 916596788,
 127795,
 -1,
 916547564,
 127980,
 916862678,
 912408159,
 -1,
 916928197,
 916796618,
 -1,
 916993719,
 916866538,
 -1,
 917059243,
 916952790,
 -1,
 -51542,
 916993209,
 127232,
 -1,
 917053520,
 127233,
 917255854,
 917012025,
 -1,
 -51539,
 917213858,
 127235,
 -1,
 917257588,
 127236,
 917452465,
 917206414,
 -1,
 -51536,
 917391072,
 127239,
 -1,
 917450635,
 127240,
 917649076,
 917385559,
 -1,
 -51533,
 917595267,
 127237,
 -1,
 917653137,
 127238,
 -51531,
 917594119,
 127234,
 -51530,
 917789348,
 127242,
 -1,
 917842754,
 127241,
 918093823,
 916942503,
 -1,
 918107836,
 917973418,
 119557,
 918224895,
 918049303,
 -1,
 -51525,
 918128831,
 119556,
 -1,
 918170079,
 119555,
 918369983,
 918048316,
 -1,
 -51522,
 918307297,
 9869,
 -1,
 918361024,
 9870,
 918566594,
 918304923,
 -1,
 -51519,
 918522052,
 119554,
 -1,
 918563301,
 119553,
 918814719,
 918501401,
 -1,
 -51516,
 918700513,
 9871,
 -1,
 918754240,
 9868,
 918959820,
 916853519,
 -1,
 919025355,
 918917515,
 -1,
 -51512,
 918979396,
 11032,
 -51511,
 919040515,
 11031,
 -51510,
 919096716,
 11030,
 -1,
 919149265,
 11033,
 -1,
 918976419,
 128160,
 919418577,
 918910434,
 -1,
 919484112,
 919366355,
 -1,
 -51505,
 919417271,
 128542,
 -1,
 919477148,
 128549,
 -1,
 919411291,
 9933,
 919746260,
 919377772,
 -1,
 -51501,
 919698934,
 128171,
 -1,
 919744951,
 128565,
 -51499,
 919703227,
 9902,
 -1,
 919891954,
 127919,
 920073950,
 916811114,
 -1,
 920139482,
 920018151,
 -1,
 -51495,
 920086935,
 128167,
 -1,
 920147217,
 128042,
 920336092,
 920064353,
 128009,
 -1,
 920256958,
 128050,
 -51491,
 920274610,
 9946,
 -1,
 920399468,
 128087,
 920598247,
 919998145,
 -1,
 920663778,
 920541293,
 -1,
 -51487,
 920598391,
 127841,
 -1,
 920657297,
 128131,
 920860389,
 920598153,
 -1,
 -51484,
 920809964,
 11831,
 -1,
 920866167,
 11830,
 -51482,
 920813234,
 983081,
 -1,
 921007936,
 128168,
 921188077,
 920525766,
 -1,
 -51479,
 921138574,
 983161,
 -51478,
 921177394,
 983090,
 -51477,
 921242826,
 983088,
 -51476,
 921308211,
 983086,
 -1,
 921373603,
 983084,
 -51474,
 921144486,
 128192,
 -1,
 921521398,
 983082,
 921712619,
 902655338,
 -1,
 921778002,
 921643131,
 -1,
 921843488,
 921716578,
 -1,
 921909006,
 921783889,
 -1,
 921974524,
 921852013,
 -1,
 922040055,
 921932883,
 -1,
 -51466,
 921978702,
 43333,
 -1,
 922029761,
 43323,
 922236666,
 921973962,
 -1,
 -51463,
 922170620,
 43331,
 -1,
 922226369,
 43314,
 -51461,
 922166059,
 43332,
 -1,
 922357441,
 43317,
 922564351,
 921915940,
 -1,
 -51458,
 922490922,
 43330,
 -1,
 922554049,
 43320,
 -51456,
 922522773,
 43327,
 -51455,
 922718131,
 43328,
 -51454,
 922779311,
 43315,
 -51453,
 922842594,
 43324,
 -51452,
 922906056,
 43325,
 -51451,
 922969922,
 43318,
 -51450,
 923028344,
 43326,
 -51449,
 923093128,
 43312,
 -51448,
 923158350,
 43322,
 -51447,
 923220145,
 43329,
 -51446,
 923284732,
 43313,
 -51445,
 923345707,
 43316,
 -51444,
 923409378,
 43321,
 -51443,
 923473962,
 43319,
 -1,
 923537089,
 43334,
 923744026,
 921865172,
 -1,
 923809561,
 923690667,
 -1,
 923875091,
 923740283,
 43337,
 -51438,
 923829835,
 43341,
 -1,
 923864769,
 43342,
 924071702,
 923799233,
 -1,
 -51435,
 924026443,
 43340,
 -1,
 924073567,
 43338,
 -51433,
 924026443,
 43336,
 -51432,
 924212455,
 43339,
 -1,
 924270175,
 43335,
 -1,
 923747627,
 43347,
 924530463,
 923672706,
 -1,
 924595997,
 924473453,
 43344,
 -1,
 924529866,
 43343,
 -51426,
 924544362,
 43345,
 -1,
 924661915,
 43346,
 -1,
 924481177,
 43359,
 924923707,
 921777975,
 -1,
 -51422,
 924882483,
 127487,
 -51421,
 924947539,
 127486,
 -51420,
 925012895,
 127485,
 -51419,
 925077356,
 127484,
 -51418,
 925141972,
 127483,
 -51417,
 925206091,
 127482,
 -51416,
 925269561,
 127481,
 -51415,
 925332878,
 127480,
 -51414,
 925396330,
 127479,
 -51413,
 925461543,
 127478,
 -51412,
 925525763,
 127477,
 -51411,
 925588711,
 127476,
 -51410,
 925653101,
 127475,
 -51409,
 925717028,
 127474,
 -51408,
 925780810,
 127473,
 -51407,
 925845558,
 127472,
 -51406,
 925910832,
 127471,
 -51405,
 925974111,
 127470,
 -51404,
 926038171,
 127469,
 -51403,
 926102730,
 127468,
 -51402,
 926167383,
 127467,
 -51401,
 926230651,
 127466,
 -51400,
 926294734,
 127465,
 -51399,
 926358470,
 127464,
 -51398,
 926423029,
 127463,
 -1,
 926486209,
 127462,
 926693192,
 924879828,
 -1,
 926758727,
 926625290,
 -1,
 926824260,
 926679040,
 -1,
 926889793,
 926777942,
 -1,
 -51392,
 926839455,
 11079,
 -1,
 926895574,
 11073,
 -51390,
 926841540,
 10184,
 -51389,
 927027037,
 983151,
 -1,
 927089220,
 983152,
 927334399,
 926753488,
 -1,
 -51386,
 927231256,
 11822,
 -1,
 927282104,
 11793,
 -1,
 926703428,
 128158,
 927545165,
 926645426,
 -1,
 927610700,
 927481760,
 -1,
 -51381,
 927534131,
 9953,
 -1,
 927599523,
 9952,
 -1,
 927555878,
 128699,
 927872848,
 927472582,
 -1,
 -51377,
 927821741,
 128665,
 -1,
 927883898,
 983112,
 -51375,
 927813377,
 128524,
 -1,
 927998675,
 127822,
 928200585,
 921732683,
 -1,
 928266117,
 928142864,
 -1,
 928331634,
 928209967,
 -1,
 928397149,
 928284217,
 -1,
 928462681,
 928354156,
 -1,
 -51368,
 928406761,
 69235,
 -1,
 928460016,
 69226,
 928659292,
 928397467,
 -1,
 -51365,
 928608310,
 69236,
 -1,
 928662879,
 69227,
 -1,
 928590845,
 69225,
 928921444,
 928347534,
 -1,
 928986977,
 928859865,
 -1,
 -51360,
 928941624,
 69230,
 -1,
 928973350,
 69239,
 929234943,
 928919424,
 -1,
 -51357,
 929138232,
 69231,
 -1,
 929169958,
 69240,
 929380203,
 928854359,
 -1,
 929445736,
 929324263,
 -1,
 -51353,
 929401540,
 69237,
 -1,
 929461517,
 69228,
 929693695,
 929381983,
 -1,
 -51350,
 929598648,
 69238,
 -1,
 929641649,
 69229,
 929838958,
 929323679,
 -1,
 -51347,
 929793592,
 69233,
 -1,
 929825318,
 69242,
 930035569,
 929770293,
 -1,
 -51344,
 929993811,
 69232,
 -1,
 930021926,
 69241,
 -1,
 929980451,
 69234,
 930297727,
 928261360,
 -1,
 930363254,
 930250297,
 -1,
 -51339,
 930321042,
 69217,
 -1,
 930364766,
 69218,
 930559865,
 930313614,
 -1,
 -51336,
 930498265,
 69221,
 -1,
 930557824,
 69222,
 930756476,
 930492759,
 -1,
 -51333,
 930702458,
 69219,
 -1,
 930760328,
 69220,
 -51331,
 930701310,
 69216,
 -51330,
 930896543,
 69224,
 -1,
 930949941,
 69223,
 931201023,
 930231360,
 -1,
 931215236,
 931094530,
 -1,
 -51326,
 931168580,
 69245,
 -51325,
 931228878,
 69244,
 -1,
 931281165,
 69243,
 -1,
 931169825,
 69246,
 931542920,
 928209677,
 -1,
 -51321,
 931480352,
 127933,
 -1,
 931540321,
 127939,
 -1,
 931476968,
 127945,
 931805105,
 928136799,
 983153,
 931870635,
 931739362,
 -1,
 931936154,
 931790848,
 -1,
 932001680,
 931886478,
 -1,
 -51314,
 931956675,
 11779,
 -51313,
 932003836,
 11815,
 -1,
 932055748,
 10182,
 932263827,
 931931524,
 -1,
 -51310,
 932218699,
 11817,
 -1,
 932283580,
 11781,
 932460438,
 932189170,
 -1,
 -51307,
 932412785,
 11776,
 -1,
 932456066,
 11777,
 -51305,
 932416867,
 11809,
 -51304,
 932610993,
 11786,
 -51303,
 932671067,
 11789,
 -1,
 932729121,
 11805,
 932919206,
 931893201,
 -1,
 932984741,
 932844970,
 -1,
 933050271,
 932942362,
 -1,
 -51298,
 933005982,
 11023,
 -1,
 933046145,
 11022,
 933246882,
 933003727,
 -1,
 -51295,
 933199242,
 11076,
 -1,
 933247011,
 11075,
 933494783,
 933171133,
 -1,
 -51292,
 933397063,
 11084,
 -1,
 933434049,
 11080,
 -1,
 932932739,
 11078,
 933756927,
 932841950,
 -1,
 933771177,
 933638599,
 4053,
 -1,
 933693553,
 4055,
 -51286,
 933718602,
 128270,
 -1,
 933837158,
 9957,
 934033325,
 931813937,
 128141,
 -1,
 933955006,
 11824,
 934164400,
 933961055,
 -1,
 -51281,
 934093073,
 127832,
 -1,
 934156384,
 127833,
 -1,
 934091010,
 127872,
 934426576,
 931749095,
 -1,
 934492105,
 934368175,
 -1,
 934557627,
 934442382,
 -1,
 934623162,
 934488187,
 -1,
 934688696,
 934581304,
 -1,
 -51273,
 934643820,
 65939,
 -1,
 934679584,
 65936,
 -51271,
 934640745,
 65944,
 -1,
 934828027,
 65938,
 -1,
 934560117,
 65941,
 935081921,
 934501451,
 -1,
 935147455,
 935015087,
 -1,
 -51266,
 935100791,
 8583,
 -1,
 935143822,
 8582,
 -51264,
 935098673,
 8581,
 -1,
 935288879,
 8584,
 935475141,
 935011022,
 -1,
 -51261,
 935430768,
 65945,
 -51260,
 935477699,
 65940,
 -1,
 935537728,
 65942,
 -51258,
 935430416,
 65937,
 -51257,
 935685445,
 65943,
 -51256,
 935730547,
 65947,
 -1,
 935794176,
 65946,
 -51254,
 934449211,
 128675,
 -51253,
 935954766,
 128205,
 -51252,
 936015491,
 127801,
 -51251,
 936076116,
 128019,
 -51250,
 936136721,
 127906,
 -51249,
 936189794,
 128640,
 -1,
 936253000,
 127840,
 936458214,
 934350529,
 -1,
 936523744,
 936394335,
 -1,
 936589277,
 936474291,
 -1,
 936654806,
 936530468,
 -1,
 -51243,
 936583961,
 127339,
 -1,
 936647637,
 127338,
 936851416,
 936584612,
 11827,
 -1,
 936804348,
 11783,
 -51239,
 936803178,
 11787,
 -51238,
 936920084,
 11782,
 -51237,
 936982881,
 9995,
 -51236,
 937046805,
 9994,
 -1,
 937107536,
 11828,
 937310175,
 936532077,
 9926,
 -1,
 937237232,
 127752,
 -1,
 937251336,
 128643,
 937506786,
 936453406,
 128251,
 -1,
 937427166,
 128280,
 937637860,
 937433341,
 128007,
 -1,
 937558462,
 128048,
 -51227,
 937590329,
 128000,
 -1,
 937710116,
 128015,
 937900010,
 936397642,
 -1,
 -51224,
 937843943,
 983221,
 -51223,
 937906724,
 983216,
 -1,
 937961595,
 983218,
 -1,
 937850254,
 983113,
 938227843,
 921648735,
 -1,
 938293333,
 938170477,
 -1,
 938358842,
 938243700,
 -1,
 938424342,
 938308837,
 -1,
 938489866,
 938364497,
 -1,
 938555381,
 938440078,
 -1,
 938620916,
 938479297,
 -1,
 -51213,
 938562922,
 68430,
 -1,
 938615930,
 68433,
 -1,
 938556355,
 68436,
 938883064,
 938507833,
 -1,
 -51209,
 938815137,
 68424,
 -1,
 938874801,
 68437,
 939079674,
 938818067,
 68420,
 -1,
 939032789,
 68423,
 939210749,
 939003585,
 -1,
 -51204,
 939169120,
 68431,
 -1,
 939216430,
 68416,
 -51202,
 939169444,
 68422,
 -51201,
 939365833,
 68425,
 -51200,
 939429908,
 68421,
 -51199,
 939487403,
 68435,
 -51198,
 939551863,
 68434,
 -51197,
 939616280,
 68432,
 -51196,
 939678818,
 68429,
 -51195,
 939742595,
 68428,
 -51194,
 939805741,
 68427,
 -51193,
 939870455,
 68426,
 -51192,
 939931441,
 68418,
 -51191,
 939991928,
 68419,
 -1,
 940054918,
 68417,
 940310527,
 938433583,
 -1,
 940324881,
 940211769,
 -1,
 940390415,
 940281708,
 -1,
 -51186,
 940334311,
 68441,
 -1,
 940387568,
 68445,
 -51184,
 940326238,
 68442,
 -1,
 940518397,
 68444,
 940718101,
 940269566,
 68440,
 940834815,
 940638208,
 -1,
 -51180,
 940736887,
 68447,
 -1,
 940785181,
 68446,
 -1,
 940651506,
 68443,
 941096959,
 938359853,
 -1,
 941111342,
 940985937,
 -1,
 941176861,
 941061518,
 -1,
 941242396,
 941100737,
 -1,
 -51173,
 941184362,
 68462,
 -1,
 941237370,
 68464,
 -1,
 941177795,
 68465,
 941504544,
 941129273,
 -1,
 -51169,
 941436577,
 68456,
 -1,
 941496241,
 68466,
 941701154,
 941439507,
 68452,
 -1,
 941654229,
 68455,
 -51165,
 941659812,
 68454,
 -51164,
 941790665,
 68457,
 -51163,
 941854754,
 68453,
 -51162,
 941910040,
 68463,
 -51161,
 941972578,
 68461,
 -51160,
 942036359,
 68460,
 -51159,
 942099501,
 68459,
 -51158,
 942164215,
 68458,
 -51157,
 942225201,
 68450,
 -51156,
 942285688,
 68451,
 -51155,
 942348678,
 68449,
 -1,
 942412412,
 68448,
 942669823,
 941055023,
 -1,
 942684213,
 942571065,
 -1,
 942749747,
 942641004,
 -1,
 -51150,
 942693607,
 68473,
 -1,
 942746864,
 68477,
 -51148,
 942685534,
 68474,
 -1,
 942877693,
 68476,
 943077433,
 942628862,
 68472,
 943194111,
 942997504,
 -1,
 -51144,
 943096183,
 68479,
 -1,
 943144477,
 68478,
 -1,
 943010802,
 68475,
 943405121,
 938306579,
 -1,
 943470655,
 943344744,
 -1,
 -51139,
 943421968,
 128289,
 -51138,
 943476385,
 128292,
 -1,
 943529125,
 128288,
 -51136,
 943423013,
 128291,
 -1,
 943676483,
 128290,
 943863881,
 943338443,
 -1,
 943929416,
 943814373,
 -1,
 943994950,
 943881785,
 -1,
 -51131,
 943952530,
 983111,
 -1,
 943996254,
 983108,
 -51129,
 943939582,
 983114,
 -1,
 944124914,
 983105,
 -1,
 943858763,
 128129,
 944388175,
 943819732,
 -1,
 944453710,
 944320015,
 -1,
 -51124,
 944408922,
 8276,
 -51123,
 944466053,
 9959,
 -1,
 944522281,
 11800,
 -1,
 944391575,
 8292,
 944781394,
 944317134,
 983129,
 -51119,
 944717562,
 8377,
 -1,
 944779315,
 983128,
 -51117,
 944734327,
 9892,
 -51116,
 944906304,
 128232,
 -1,
 944970502,
 128229,
 945174655,
 938235815,
 128127,
 945291263,
 945106368,
 -1,
 945305714,
 945180241,
 -1,
 945371229,
 945255822,
 -1,
 945436764,
 945295041,
 -1,
 -51109,
 945378666,
 67662,
 -1,
 945431674,
 67665,
 -1,
 945372099,
 67668,
 945698912,
 945323577,
 -1,
 -51105,
 945630881,
 67656,
 -1,
 945690545,
 67669,
 945895522,
 945633811,
 67652,
 -1,
 945848533,
 67655,
 946026597,
 945819329,
 -1,
 -51100,
 945984864,
 67663,
 -1,
 946032174,
 67648,
 -51098,
 945985188,
 67654,
 -51097,
 946181577,
 67657,
 -51096,
 946245652,
 67653,
 -51095,
 946303147,
 67667,
 -51094,
 946367607,
 67666,
 -51093,
 946432024,
 67664,
 -51092,
 946494562,
 67661,
 -51091,
 946558339,
 67660,
 -51090,
 946621485,
 67659,
 -51089,
 946686199,
 67658,
 -51088,
 946747185,
 67650,
 -51087,
 946807672,
 67651,
 -1,
 946870662,
 67649,
 947075198,
 945249327,
 -1,
 947140730,
 947027513,
 -1,
 947206263,
 947097452,
 -1,
 -51082,
 947150055,
 67673,
 -1,
 947203312,
 67676,
 947402873,
 947137533,
 67675,
 -1,
 947324603,
 67679,
 -1,
 947338590,
 67674,
 947650559,
 947085310,
 67672,
 947716095,
 947519488,
 -1,
 -51075,
 947618167,
 67678,
 -1,
 947666461,
 67677,
 -1,
 947025574,
 67671,
 947927170,
 945102175,
 -1,
 -51071,
 947878262,
 9976,
 -1,
 947921177,
 127848,
 -1,
 947885651,
 127982,
 948189444,
 938166064,
 -1,
 948254978,
 948113089,
 -1,
 948320505,
 948210693,
 -1,
 948385982,
 948260086,
 -1,
 948451517,
 948339926,
 -1,
 948517008,
 948394093,
 -1,
 948582540,
 948450556,
 43412,
 948699135,
 948503262,
 43402,
 -1,
 948569600,
 43403,
 948779150,
 948540565,
 43418,
 -1,
 948699976,
 43416,
 948961279,
 948702913,
 43428,
 -1,
 948831048,
 43423,
 949041301,
 948469305,
 -1,
 949106835,
 948993711,
 43419,
 -1,
 949027610,
 43420,
 949288959,
 949030593,
 43424,
 -1,
 949158728,
 43425,
 949368986,
 948970190,
 -1,
 949434520,
 949297963,
 43421,
 -1,
 949355290,
 43422,
 949616639,
 949358273,
 43426,
 -1,
 949486362,
 43427,
 949696670,
 949319138,
 43441,
 949813247,
 949617415,
 -1,
 -51043,
 949717754,
 43439,
 -1,
 949752192,
 43440,
 949958818,
 949643074,
 43429,
 950075391,
 949878784,
 -1,
 -51039,
 949966874,
 43430,
 -1,
 950017436,
 43401,
 950220966,
 949897352,
 43407,
 950337535,
 950140928,
 -1,
 -51035,
 950236737,
 43408,
 -1,
 950294554,
 43409,
 950483113,
 950156895,
 43398,
 -51032,
 950419039,
 43399,
 -1,
 950469236,
 43397,
 950679723,
 950431176,
 43435,
 -1,
 950599711,
 43436,
 950810797,
 950617934,
 43415,
 -1,
 950731546,
 43417,
 950941871,
 950744316,
 43410,
 -1,
 950862664,
 43411,
 951072945,
 950868962,
 43413,
 -1,
 950993736,
 43414,
 951204019,
 950999082,
 43431,
 -1,
 951124808,
 43432,
 951335093,
 951127745,
 43396,
 -1,
 951271007,
 43405,
 -51018,
 951293077,
 43434,
 -51017,
 951422899,
 43438,
 -51016,
 951486027,
 43400,
 -51015,
 951540967,
 43406,
 -51014,
 951603837,
 43433,
 -51013,
 951667576,
 43437,
 -51012,
 951728305,
 43442,
 -1,
 951789691,
 43404,
 -1,
 948384916,
 43457,
 952056019,
 948332354,
 -1,
 952121552,
 951984942,
 -1,
 952187077,
 952060746,
 -1,
 952252612,
 952141387,
 -1,
 -51005,
 952195671,
 43465,
 -1,
 952254011,
 43461,
 -1,
 952189797,
 43464,
 952514761,
 952110785,
 -1,
 952580296,
 952443890,
 43466,
 -1,
 952500249,
 43467,
 -1,
 952523110,
 43459,
 952776908,
 952461059,
 -1,
 -50997,
 952714621,
 43468,
 -1,
 952767459,
 43463,
 -50995,
 952734035,
 43462,
 -50994,
 952926918,
 43486,
 -50993,
 952980162,
 43460,
 -1,
 953042308,
 43487,
 953286655,
 952064561,
 -1,
 -50990,
 953183956,
 43471,
 -1,
 953240243,
 43456,
 953432289,
 951985392,
 -1,
 953497815,
 953384505,
 -1,
 -50986,
 953455250,
 43474,
 -1,
 953498974,
 43475,
 953694426,
 953447822,
 -1,
 -50983,
 953632473,
 43478,
 -1,
 953692032,
 43479,
 953891037,
 953626967,
 -1,
 -50980,
 953836666,
 43476,
 -1,
 953894536,
 43477,
 -50978,
 953849553,
 43472,
 -50977,
 954032126,
 43473,
 -50976,
 954096287,
 43481,
 -1,
 954149685,
 43480,
 954349805,
 953388795,
 -1,
 954415335,
 954302009,
 -1,
 954480870,
 954339009,
 -1,
 -50971,
 954430794,
 43444,
 -1,
 954486648,
 43450,
 -1,
 954425150,
 43445,
 954743017,
 954373015,
 43446,
 -1,
 954663723,
 43447,
 954874091,
 954695045,
 43448,
 -1,
 954794802,
 43449,
 -50964,
 954820761,
 43452,
 -1,
 954934583,
 43451,
 955136243,
 954300561,
 -1,
 955201776,
 955063651,
 43393,
 -1,
 955123375,
 43443,
 -50959,
 955158859,
 43395,
 -50958,
 955279284,
 43392,
 -1,
 955337892,
 43394,
 955529463,
 955064450,
 -1,
 -50955,
 955476068,
 43454,
 -50954,
 955533757,
 43453,
 -1,
 955587593,
 43455,
 -50952,
 955483486,
 43469,
 -1,
 955740722,
 43458,
 955922689,
 948266916,
 -1,
 -50949,
 955874821,
 128304,
 -50948,
 955935398,
 127971,
 -50947,
 955997812,
 128121,
 -50946,
 956053370,
 128122,
 -50945,
 956114330,
 127886,
 -50944,
 956177630,
 127983,
 -1,
 956242038,
 9979,
 -1,
 955850570,
 127875,
 -50941,
 948210107,
 9909,
 -1,
 956443017,
 128086,
 956643696,
 948121943,
 -1,
 956709157,
 956567233,
 -1,
 956774687,
 956636102,
 -1,
 956840221,
 956704893,
 -1,
 956905752,
 956797318,
 -1,
 956971287,
 956825600,
 -1,
 957036814,
 956923197,
 128539,
 957153279,
 956956730,
 -1,
 -50931,
 957059438,
 128540,
 -1,
 957121054,
 128541,
 957298962,
 956980455,
 -1,
 957364497,
 957245513,
 128558,
 -1,
 957284416,
 128560,
 -1,
 957302843,
 128582,
 -50925,
 957251548,
 128514,
 -50924,
 957504298,
 128581,
 -50923,
 957568286,
 128567,
 -50922,
 957632700,
 128548,
 -1,
 957685784,
 128531,
 -1,
 956916983,
 128566,
 957954331,
 956855694,
 -1,
 -50918,
 957882655,
 128561,
 -1,
 957945729,
 128523,
 -50916,
 957907426,
 128536,
 -1,
 958092355,
 128134,
 -50914,
 956793727,
 127981,
 -1,
 958232761,
 8507,
 958413090,
 956714968,
 -1,
 -50911,
 958349992,
 9950,
 -1,
 958409732,
 127810,
 -50909,
 958370729,
 128224,
 -50908,
 958562605,
 127877,
 -1,
 958617201,
 128106,
 958806330,
 956644959,
 -1,
 958871855,
 958754154,
 -1,
 958937388,
 958802043,
 128293,
 959002923,
 958894961,
 -1,
 -50902,
 958952846,
 127878,
 -1,
 958989919,
 127879,
 -1,
 958923176,
 128658,
 959315967,
 958888980,
 -1,
 -50898,
 959222171,
 127771,
 -1,
 959282678,
 127763,
 959461684,
 958821774,
 -1,
 959527219,
 959395995,
 128031,
 -50894,
 959464206,
 127907,
 -1,
 959512806,
 127845,
 -1,
 959479790,
 128074,
 959789367,
 959417520,
 -1,
 -50890,
 959736764,
 8281,
 -1,
 959796212,
 11821,
 960036863,
 959728889,
 -1,
 -50887,
 959936219,
 983106,
 -1,
 959984557,
 128193,
 960182601,
 958749927,
 -1,
 960248130,
 960136779,
 -1,
 960313665,
 960195948,
 -1,
 960379200,
 960243112,
 -1,
 -50881,
 960326588,
 8280,
 -1,
 960386036,
 8283,
 -1,
 960318756,
 127808,
 -1,
 960256979,
 9970,
 960706887,
 960195946,
 -1,
 960772422,
 960645174,
 -1,
 -50875,
 960703039,
 11792,
 -1,
 960757861,
 127860,
 -1,
 960713271,
 983071,
 -50872,
 960652278,
 128099,
 -1,
 960968351,
 127745,
 961165655,
 960121674,
 -1,
 961231184,
 961109223,
 -1,
 961296719,
 961187944,
 9880,
 961413119,
 961217734,
 -1,
 -50866,
 961317159,
 8277,
 -1,
 961367210,
 127924,
 -1,
 961243905,
 128190,
 961624403,
 961161339,
 -1,
 -50862,
 961582083,
 128170,
 -1,
 961645263,
 9884,
 961821014,
 961547969,
 -1,
 -50859,
 961774322,
 9189,
 -1,
 961819859,
 9971,
 -1,
 961776476,
 128563,
 962083166,
 961119819,
 -1,
 962148699,
 962023387,
 -1,
 -50854,
 962105755,
 127773,
 -1,
 962166262,
 127765,
 -50852,
 962098819,
 9179,
 -50851,
 962288133,
 9905,
 -1,
 962341762,
 9981,
 962541925,
 962030954,
 -1,
 962607459,
 962485479,
 -1,
 -50847,
 962564727,
 128550,
 -50846,
 962616249,
 128037,
 -1,
 962671820,
 128056,
 -50844,
 962543633,
 127844,
 -1,
 962800727,
 127839,
 963000681,
 962498390,
 -1,
 -50841,
 962923722,
 983210,
 -50840,
 962989107,
 983209,
 -1,
 963054499,
 983208,
 963262830,
 962930811,
 -1,
 963328365,
 963212441,
 -1,
 -50836,
 963286099,
 9972,
 -1,
 963331440,
 127905,
 -1,
 963253534,
 128552,
 -50833,
 963212686,
 983107,
 -1,
 963522903,
 983072,
 963721678,
 956600172,
 -1,
 963787169,
 963655835,
 -1,
 963852703,
 963724861,
 -1,
 963918201,
 963781326,
 -1,
 963983735,
 963866412,
 -1,
 -50826,
 963924907,
 9920,
 -1,
 963988032,
 9921,
 -50824,
 963929787,
 128071,
 -1,
 964116189,
 9931,
 964311422,
 963870265,
 -1,
 964376957,
 964259178,
 -1,
 -50820,
 964312847,
 10177,
 -1,
 964367481,
 9186,
 -1,
 964334342,
 9943,
 964639107,
 964261262,
 -1,
 964704642,
 964580158,
 -1,
 -50815,
 964656193,
 11090,
 -1,
 964710765,
 11051,
 -1,
 964652218,
 128307,
 964966791,
 964580658,
 -1,
 -50811,
 964918337,
 11088,
 -50810,
 964972909,
 11048,
 -1,
 965027009,
 11046,
 965228940,
 964905802,
 -1,
 965294475,
 965159653,
 -1,
 -50806,
 965241374,
 128072,
 -1,
 965299252,
 9945,
 -1,
 965219643,
 11036,
 965556625,
 965163163,
 -1,
 965622160,
 965486715,
 -1,
 -50801,
 965579757,
 11041,
 -1,
 965613474,
 9989,
 -1,
 965567159,
 11053,
 965884309,
 965489452,
 -1,
 965949844,
 965808432,
 9872,
 -1,
 965871847,
 9983,
 -1,
 965895862,
 128174,
 966146456,
 965840144,
 -1,
 -50793,
 966104186,
 11038,
 -1,
 966164996,
 11055,
 966343067,
 966095327,
 -1,
 -50790,
 966265521,
 11092,
 -1,
 966329797,
 128073,
 -50788,
 966298111,
 128070,
 -50787,
 966487334,
 10068,
 -50786,
 966551676,
 11040,
 -1,
 966602842,
 10069,
 -50784,
 963783313,
 9855,
 -1,
 966726241,
 128011,
 966932914,
 963710657,
 -1,
 966998440,
 966885491,
 -1,
 967063975,
 966918144,
 -1,
 -50779,
 967020542,
 127754,
 -50778,
 967057356,
 128702,
 -1,
 967121766,
 128003,
 -1,
 967005565,
 127817,
 967391659,
 966956074,
 -1,
 -50774,
 967325464,
 127764,
 -1,
 967385412,
 127762,
 967588270,
 967347156,
 -1,
 -50771,
 967525077,
 128075,
 -1,
 967583880,
 11071,
 967784881,
 967531192,
 -1,
 -50768,
 967718680,
 127766,
 -1,
 967778628,
 127768,
 -1,
 967734250,
 9888,
 968047040,
 966876391,
 -1,
 968112572,
 967987748,
 -1,
 968178107,
 968037159,
 128105,
 968243642,
 968127888,
 -1,
 -50761,
 968193575,
 128097,
 -50760,
 968243711,
 128082,
 -50759,
 968302583,
 128090,
 -1,
 968366788,
 128098,
 -1,
 968165309,
 128111,
 -1,
 968109235,
 128698,
 968702399,
 968060266,
 -1,
 -50754,
 968651165,
 128543,
 -1,
 968696578,
 11825,
 -1,
 968642238,
 128058,
 968964550,
 967977083,
 -1,
 969030084,
 968889815,
 -1,
 -50749,
 968962487,
 128553,
 -1,
 969022693,
 128576,
 -50747,
 968966188,
 983225,
 -1,
 969155533,
 128146,
 969357770,
 968901089,
 -1,
 -50744,
 969296453,
 128521,
 -50743,
 969353421,
 127863,
 -1,
 969417435,
 127888,
 969619917,
 969305450,
 -1,
 -50740,
 969550930,
 128295,
 -1,
 969610400,
 127873,
 -1,
 969557808,
 983224,
 969882120,
 963675723,
 -1,
 969947640,
 969815438,
 -1,
 970013175,
 969887313,
 -1,
 970078679,
 969962894,
 -1,
 970144213,
 970002113,
 -1,
 -50732,
 970086091,
 66450,
 -1,
 970138579,
 66453,
 -50730,
 970095950,
 66461,
 -1,
 970275779,
 66444,
 970471899,
 970030649,
 -1,
 -50727,
 970415335,
 66458,
 -50726,
 970471854,
 66456,
 -1,
 970534525,
 66441,
 970734046,
 970430003,
 -1,
 -50723,
 970688075,
 66449,
 -1,
 970731149,
 66439,
 970930657,
 970672182,
 -1,
 -50720,
 970864817,
 66435,
 -1,
 970920185,
 66443,
 971127267,
 970865748,
 66437,
 -1,
 971079343,
 66440,
 971258342,
 971060426,
 -1,
 -50715,
 971192559,
 66457,
 -1,
 971248394,
 66434,
 971454953,
 971186894,
 -1,
 -50712,
 971389172,
 66447,
 -1,
 971451331,
 66436,
 971651564,
 971378369,
 -1,
 -50709,
 971592053,
 66432,
 -1,
 971653601,
 66451,
 -50707,
 971609541,
 66442,
 -50706,
 971805330,
 66438,
 -50705,
 971867723,
 66460,
 -50704,
 971927280,
 66455,
 -50703,
 971992178,
 66454,
 -50702,
 972057520,
 66452,
 -50701,
 972119138,
 66448,
 -50700,
 972182915,
 66446,
 -50699,
 972246055,
 66445,
 -50698,
 972308063,
 66459,
 -1,
 972364154,
 66433,
 -1,
 969970496,
 66463,
 972634624,
 969893635,
 -1,
 972700156,
 972591057,
 -1,
 -50693,
 972626462,
 11014,
 -1,
 972690240,
 11797,
 972896767,
 972622476,
 -1,
 -50690,
 972847646,
 128316,
 -1,
 972910618,
 128314,
 -1,
 972816780,
 11021,
 973158916,
 972576877,
 -1,
 -50686,
 973100046,
 9903,
 -50685,
 973161977,
 983115,
 -1,
 973214491,
 128530,
 973421063,
 973100221,
 -1,
 -50682,
 973378015,
 9748,
 -1,
 973430677,
 9969,
 -1,
 973370766,
 983116,
 973683214,
 969840473,
 -1,
 973748748,
 973625453,
 -1,
 -50677,
 973686576,
 983213,
 -1,
 973740883,
 983248,
 -50675,
 973699846,
 983212,
 -1,
 973883184,
 983214,
 974076433,
 973640787,
 -1,
 -50672,
 974012028,
 983228,
 -1,
 974072739,
 128155,
 -1,
 974024020,
 9915]
_charnames_564 = [
5688,
5718,
5549,
5700,
5702,
5770,
5855,
5934,
5757,
5922,
5849,
5590,
5761,
5962,
5775,
5982,
5898,
5841,
5832,
5569,
5979,
5787,
5904,
5768,
5884,
5639,
5969,
5784,
]

_charnames_751 = [
8913,
8917,
8907,
8916,
8915,
8944,
8942,
8943,
8918,
8955,
8967,
8938,
8966,
8937,
8861,
8969,
8906,
]

_charnames_848 = [
1388,
1377,
1430,
1427,
1374,
1389,
1386,
1391,
1342,
1412,
1335,
1420,
1334,
1333,
1331,
1332,
]

_charnames_880 = [
11593,
11574,
11594,
11575,
-1,
-1,
11592,
11573,
-1,
-1,
-1,
11577,
11579,
11578,
]

_charnames_1015 = [
11590,
11571,
11595,
11591,
11572,
11633,
11597,
11600,
11598,
]

_charnames_1270 = [
2015,
1942,
-1,
-1,
2014,
1941,
1996,
1920,
1995,
1919,
]

_charnames_1296 = [
1978,
1902,
2001,
1925,
2023,
1949,
1982,
1906,
1992,
1916,
2020,
1947,
2019,
1946,
2024,
1950,
2000,
1924,
2002,
1926,
2021,
1935,
1975,
1899,
]

_charnames_1536 = [
11043,
10974,
11025,
10977,
10975,
-1,
11051,
11050,
11019,
11049,
11048,
11409,
-1,
11030,
11042,
10982,
10976,
10983,
10979,
10980,
10981,
10988,
10989,
10986,
10991,
10992,
10990,
-1,
-1,
-1,
11005,
-1,
10879,
]

_charnames_1622 = [
10993,
11045,
10828,
11040,
11033,
11034,
11035,
11018,
11022,
11041,
]

_charnames_1869 = [
10429,
10430,
10431,
10853,
10858,
10851,
10852,
10854,
10857,
10855,
10889,
10890,
10934,
10933,
10862,
10897,
10903,
10904,
10902,
10845,
10846,
10877,
10875,
10873,
10928,
10927,
10924,
10923,
10922,
10937,
10864,
10867,
10894,
10887,
10885,
10895,
10863,
10886,
10906,
10907,
10836,
10837,
10838,
10917,
10918,
10913,
10914,
10891,
10898,
10896,
10880,
]

_charnames_1984 = [
13697,
13698,
13689,
13690,
13695,
13696,
13692,
13693,
13700,
13699,
13684,
13666,
13678,
13665,
13671,
13664,
13663,
13668,
13649,
13683,
13674,
13672,
13659,
13682,
13667,
13662,
13661,
13673,
13680,
13681,
13677,
13676,
13653,
13675,
13650,
13652,
13679,
13670,
13669,
13651,
13657,
13658,
13656,
13711,
13710,
13709,
13707,
13706,
13705,
13704,
13712,
13713,
13718,
13685,
13716,
13717,
13714,
13719,
13686,
-1,
-1,
-1,
-1,
-1,
9863,
9850,
9860,
9862,
9843,
9851,
9852,
9844,
9840,
9853,
9859,
9858,
9857,
9856,
9847,
9845,
9861,
9839,
9855,
9854,
9848,
9841,
9903,
9904,
9905,
9908,
9912,
9907,
9870,
9881,
9873,
9867,
9878,
9872,
9866,
9877,
9910,
9876,
9868,
9879,
9911,
9869,
9880,
9871,
9875,
9906,
-1,
-1,
9898,
9889,
9886,
9900,
9887,
9895,
9913,
9899,
9891,
9897,
9892,
9896,
9888,
9894,
9885,
-1,
9490,
9484,
9482,
9483,
9481,
9488,
9473,
9486,
9470,
9472,
9471,
9479,
9478,
9477,
9466,
9487,
9476,
9467,
9475,
9474,
9468,
9469,
9491,
9489,
9480,
9495,
9492,
9494,
-1,
-1,
9493,
]

_charnames_2208 = [
10856,
-1,
10940,
10938,
10847,
10939,
10936,
10929,
10910,
10911,
10865,
10919,
10868,
]

_charnames_2276 = [
11009,
11011,
11007,
11010,
11012,
11008,
11001,
10998,
11004,
11000,
10997,
11003,
11038,
11039,
11037,
10987,
11023,
11024,
11044,
10943,
11015,
10942,
11017,
11027,
11028,
11016,
11031,
-1,
13952,
-1,
-1,
-1,
13936,
]

_charnames_2382 = [
13962,
13964,
-1,
-1,
-1,
-1,
-1,
13963,
13958,
13957,
]

_charnames_2417 = [
13953,
13940,
13931,
13930,
13942,
13928,
13927,
-1,
13935,
13938,
13934,
13937,
13933,
13939,
13941,
]

_charnames_2555 = [
5494,
-1,
-1,
-1,
-1,
-1,
11867,
-1,
11865,
]

_charnames_2929 = [
13046,
13035,
13036,
13040,
13034,
13037,
13039,
]

_charnames_3059 = [
8015,
8020,
8016,
8014,
8011,
8022,
8017,
8019,
]

_charnames_3192 = [
8554,
8552,
8546,
8549,
8553,
8547,
8550,
8558,
]

_charnames_3386 = [
9512,
-1,
-1,
9529,
-1,
-1,
-1,
-1,
-1,
-1,
9518,
]

_charnames_3440 = [
9523,
9522,
9521,
9526,
9527,
9528,
-1,
-1,
-1,
9530,
9507,
9506,
9510,
9508,
9509,
9511,
]

_charnames_4046 = [
8659,
-1,
8645,
8649,
8648,
8651,
8652,
14247,
6636,
14248,
6637,
8650,
8647,
]

_charnames_4130 = [
9604,
-1,
-1,
-1,
-1,
-1,
9612,
-1,
-1,
9694,
]

_charnames_4147 = [
9691,
9690,
9696,
-1,
-1,
-1,
-1,
9651,
9700,
9702,
9701,
9703,
9621,
]

_charnames_4186 = [
9610,
9611,
9609,
9608,
9705,
9706,
9707,
9605,
9681,
9711,
9710,
9618,
9619,
9688,
9687,
9645,
9644,
9643,
9642,
9641,
9615,
9614,
9616,
9695,
9684,
9683,
9685,
9594,
9593,
9599,
9602,
9595,
9590,
9601,
9591,
9597,
9600,
9603,
9596,
9598,
9708,
9680,
9677,
9678,
9679,
9634,
9633,
9632,
9631,
9638,
9637,
9639,
9620,
9649,
9662,
9663,
9654,
9655,
9660,
9661,
9657,
9658,
9665,
9664,
9648,
9647,
9692,
9693,
9672,
9673,
]

_charnames_4295 = [
11848,
-1,
-1,
-1,
-1,
-1,
11849,
]

_charnames_4345 = [
11844,
11841,
-1,
8970,
11842,
11846,
11845,
]

_charnames_4992 = [
3840,
3921,
3920,
3919,
3842,
3857,
3856,
3855,
3841,
3926,
3925,
3924,
3839,
3914,
3913,
3912,
3945,
3939,
3947,
3946,
3941,
3944,
3949,
3948,
3940,
3943,
]

_charnames_5751 = [
2286,
2282,
2283,
2280,
2281,
2284,
2285,
2287,
2355,
]

_charnames_6128 = [
12360,
12361,
12356,
12359,
12358,
12349,
12355,
12354,
12353,
12352,
]

_charnames_6314 = [
8984,
-1,
-1,
-1,
-1,
-1,
2276,
2366,
2367,
2293,
2349,
2350,
2348,
2318,
2361,
2360,
2368,
2335,
2336,
2369,
2306,
2295,
2304,
2305,
2303,
2357,
2358,
2327,
2333,
2267,
2334,
2268,
2331,
2265,
2332,
2266,
2325,
2323,
2324,
2321,
2322,
2326,
2272,
2271,
2274,
2275,
2273,
2263,
2269,
2270,
2371,
2292,
2363,
2364,
2328,
2290,
2291,
2316,
2317,
2309,
2310,
2311,
2313,
2314,
2298,
2299,
2301,
2340,
2345,
2342,
2341,
2300,
2346,
2354,
2353,
2344,
]

_charnames_6400 = [
6395,
6342,
6341,
6348,
6347,
6338,
6354,
6353,
6345,
6344,
6330,
6333,
6332,
6351,
6350,
6339,
6336,
6335,
6357,
6356,
6360,
6329,
6359,
6361,
6358,
6327,
6326,
6328,
6362,
-1,
-1,
-1,
6386,
6394,
6393,
6392,
6388,
6390,
6387,
6391,
6389,
6381,
6383,
6382,
-1,
-1,
-1,
-1,
6373,
6366,
6374,
6368,
6367,
6370,
6371,
6369,
6372,
6377,
6379,
6376,
-1,
-1,
-1,
-1,
6378,
-1,
-1,
-1,
6411,
6410,
6406,
6407,
6398,
6399,
6404,
6405,
6401,
6402,
6409,
6408,
8317,
8319,
8313,
8296,
8321,
8318,
8298,
8297,
8324,
8309,
8308,
8323,
8327,
8320,
8326,
8322,
8316,
8295,
8314,
8302,
8325,
8301,
8300,
8305,
8311,
8310,
8306,
8299,
8303,
8304,
-1,
-1,
8293,
8292,
8291,
8290,
8289,
]

_charnames_6528 = [
13514,
13485,
13511,
13499,
13507,
13482,
13470,
13478,
13494,
13502,
13512,
13465,
13473,
13483,
13496,
13495,
13508,
13467,
13466,
13479,
13505,
13504,
13515,
13476,
13475,
13486,
13518,
13513,
13516,
13489,
13484,
13487,
13517,
13519,
13520,
13488,
13490,
13491,
13510,
13498,
13481,
13469,
13501,
13472,
-1,
-1,
-1,
-1,
13547,
13540,
13546,
13530,
13534,
13548,
13543,
13535,
13536,
13531,
13542,
13541,
13533,
13538,
13537,
13532,
13545,
13524,
13523,
13522,
13525,
13526,
13527,
13528,
13566,
13565,
-1,
-1,
-1,
-1,
-1,
-1,
13559,
13560,
13551,
13552,
13557,
13558,
13554,
13555,
13562,
13561,
13567,
-1,
-1,
-1,
13568,
13569,
12324,
12371,
12323,
12368,
12365,
12320,
12317,
12314,
12311,
12308,
12346,
12343,
12333,
12340,
12337,
12330,
12372,
12370,
12322,
12367,
12364,
12319,
12316,
12313,
12310,
12307,
12345,
12342,
12332,
12339,
12336,
12329,
5392,
5395,
5379,
5378,
5390,
5398,
5384,
5383,
5387,
5396,
5381,
5380,
5397,
5393,
5376,
5375,
5385,
5389,
5391,
5386,
5388,
5399,
5394,
5403,
5401,
5404,
5402,
5405,
-1,
-1,
5406,
5407,
8058,
8057,
8056,
8031,
8029,
8030,
8079,
8067,
8066,
8040,
8042,
8039,
8078,
8074,
8069,
8090,
8043,
8075,
8061,
8060,
8034,
8033,
8080,
8091,
8064,
8063,
8071,
8037,
8045,
8036,
8087,
8041,
8068,
8073,
8076,
8046,
8048,
8085,
8053,
8052,
8054,
8070,
8049,
8092,
8044,
8083,
8084,
8081,
8082,
8089,
8086,
8047,
8088,
8181,
8182,
8186,
8111,
8189,
8185,
8188,
8183,
8190,
8187,
-1,
8108,
8138,
8147,
8141,
8144,
8145,
8146,
8137,
8136,
8134,
8135,
8128,
8130,
8132,
8148,
8140,
8133,
8139,
8143,
8131,
8110,
8118,
8117,
8099,
8098,
8097,
8121,
8113,
8100,
-1,
-1,
8191,
8173,
8174,
8165,
8166,
8171,
8172,
8168,
8169,
8176,
8175,
-1,
-1,
-1,
-1,
-1,
-1,
8159,
8160,
8151,
8152,
8157,
8158,
8154,
8155,
8162,
8161,
-1,
-1,
-1,
-1,
-1,
-1,
8114,
8115,
8107,
8103,
8123,
8125,
8120,
8112,
8101,
8102,
8105,
8106,
8124,
8126,
]

_charnames_6912 = [
5092,
5093,
5096,
5094,
5097,
4978,
4979,
5000,
5001,
4992,
4993,
4987,
4988,
4990,
4991,
5005,
4981,
4996,
4997,
4967,
4969,
5002,
5003,
4965,
5007,
5008,
4998,
4999,
4964,
4959,
4958,
4975,
4974,
4963,
4955,
4957,
4971,
4976,
4962,
4994,
4995,
5009,
5010,
5015,
5012,
4986,
4989,
5013,
4985,
4984,
4982,
5016,
5095,
5065,
5066,
5067,
5068,
5069,
5070,
5071,
5074,
5075,
5060,
5062,
5064,
5063,
5072,
5073,
5109,
4968,
4970,
4960,
5006,
5014,
5011,
4980,
-1,
-1,
-1,
-1,
5086,
5087,
5078,
5079,
5084,
5085,
5081,
5082,
5089,
5088,
5102,
5101,
5108,
5106,
5107,
5105,
5100,
5030,
5028,
5029,
5020,
5022,
5031,
5025,
5027,
5024,
5023,
5038,
5041,
5034,
5036,
5039,
5035,
5037,
5042,
5040,
5053,
5054,
5056,
5057,
5047,
5045,
5050,
5049,
5046,
-1,
-1,
-1,
10338,
10337,
10336,
10281,
10295,
10288,
10282,
10292,
10276,
10277,
10275,
10290,
10297,
10257,
10299,
10294,
10283,
10256,
10289,
10298,
10258,
10291,
10263,
10287,
10280,
10293,
10284,
10269,
10272,
10286,
10266,
10285,
10296,
10348,
10347,
10346,
10328,
10326,
10330,
10327,
10331,
10329,
10339,
10340,
10344,
10343,
10274,
10265,
10310,
10311,
10302,
10303,
10308,
10309,
10305,
10306,
10313,
10312,
10349,
10268,
10271,
10279,
10262,
10261,
5156,
5125,
5151,
5123,
5139,
5155,
5148,
5141,
5120,
5133,
5138,
5144,
5117,
5142,
5152,
5124,
5149,
5153,
5146,
5119,
5135,
5121,
5126,
5130,
5127,
5118,
5137,
5143,
5116,
5131,
5147,
5122,
5129,
5154,
5132,
5140,
5150,
5145,
5175,
5163,
5165,
5164,
5167,
5162,
5166,
5161,
5158,
5159,
5180,
5181,
5178,
5177,
]

_charnames_7164 = [
5173,
5171,
5174,
5172,
6503,
6501,
6502,
6519,
6518,
6498,
6525,
6524,
6534,
6497,
6491,
6490,
6507,
6499,
6495,
6493,
6494,
6522,
6521,
6528,
6527,
6513,
6512,
6489,
6488,
6505,
6529,
6532,
6533,
6516,
6515,
6531,
6510,
6509,
6530,
6535,
6577,
6578,
6567,
6565,
6563,
6564,
6561,
6562,
6566,
6553,
6558,
6559,
6551,
6557,
6556,
6555,
6552,
6554,
6580,
6581,
-1,
-1,
-1,
6572,
6573,
6574,
6571,
6570,
6546,
6547,
6538,
6539,
6544,
6545,
6541,
6542,
6549,
6548,
-1,
-1,
-1,
6486,
6485,
6506,
12964,
12965,
12956,
12957,
12962,
12963,
12959,
12960,
12967,
12966,
12928,
12923,
12926,
12924,
12925,
12929,
12921,
12922,
12920,
12919,
12932,
12945,
12948,
12947,
12946,
12930,
12938,
12937,
12936,
12935,
12933,
12951,
12953,
12952,
12950,
12931,
12941,
12943,
12940,
12942,
12975,
12977,
12974,
12976,
12972,
12978,
12970,
12971,
]

_charnames_7360 = [
10318,
10317,
10316,
10322,
10319,
10320,
10321,
10323,
]

_charnames_7376 = [
7629,
7636,
7638,
7613,
7610,
7622,
7621,
7619,
7634,
7620,
7631,
7625,
7628,
7632,
7624,
7626,
7637,
7639,
7603,
7599,
7606,
7601,
7607,
7600,
7602,
7596,
7595,
7592,
7593,
7612,
7616,
7614,
7608,
7594,
7597,
7609,
7635,
7615,
7611,
]

_charnames_7424 = [
6002,
6003,
5540,
6017,
6016,
6015,
6001,
5999,
5531,
5533,
6013,
6012,
6011,
6010,
5994,
5996,
5998,
5582,
5583,
5584,
5532,
5997,
5552,
5782,
6009,
5993,
5988,
5986,
6007,
5585,
5587,
5586,
6006,
6005,
6004,
6000,
6018,
6019,
11617,
11616,
11614,
11615,
11613,
2026,
8874,
8875,
8872,
8873,
8889,
8888,
8867,
8887,
8870,
8886,
8885,
8884,
8883,
8882,
8881,
8866,
8868,
8869,
8880,
8864,
8879,
8878,
8876,
8837,
8778,
8838,
8780,
8810,
8834,
8799,
8807,
8824,
8784,
8830,
8785,
8853,
8847,
8803,
8821,
8823,
8787,
8811,
8842,
8776,
8818,
8808,
8781,
8840,
8839,
8812,
8833,
8836,
8832,
8797,
5812,
5804,
5802,
5801,
11585,
11583,
11581,
11582,
11584,
5680,
5780,
5696,
5791,
5733,
5716,
5727,
5642,
5643,
5593,
5547,
5763,
5539,
8901,
5614,
5545,
5796,
5618,
5723,
5795,
5678,
5779,
5695,
5790,
5773,
5744,
5685,
5732,
5714,
5726,
5640,
5591,
5574,
5706,
5792,
5762,
5625,
5632,
5697,
5570,
5666,
5648,
5595,
5608,
5663,
5573,
5677,
5578,
8779,
8790,
8798,
8801,
8852,
8855,
8835,
8806,
8786,
8851,
8850,
8792,
8793,
8854,
8827,
8828,
8796,
8848,
8782,
8846,
8845,
8795,
8813,
8843,
8809,
8802,
8789,
8820,
8819,
8794,
8841,
8783,
8814,
8816,
8817,
8800,
8788,
1340,
1341,
1426,
1425,
1397,
1408,
1395,
1415,
1409,
1416,
1352,
1431,
1396,
1337,
1428,
1419,
1429,
1423,
1422,
1361,
1349,
1348,
1347,
1363,
1359,
1362,
1360,
1369,
1358,
1353,
1368,
1367,
1357,
1366,
1365,
1351,
1356,
1354,
1355,
]

_charnames_8275 = [
10633,
14411,
14669,
8737,
-1,
14654,
14645,
8764,
14655,
13909,
8721,
7648,
-1,
-1,
-1,
-1,
-1,
14414,
]

_charnames_8336 = [
5815,
5814,
5806,
5800,
5799,
5813,
5810,
5809,
5808,
5807,
5805,
5798,
5803,
]

_charnames_8370 = [
11870,
11390,
13456,
2568,
6477,
10539,
8570,
14416,
8757,
]

_charnames_8524 = [
12246,
11408,
8750,
10440,
7662,
7663,
7661,
]

_charnames_9167 = [
4012,
7647,
9195,
9192,
9193,
9191,
9186,
9187,
9188,
9189,
9194,
3980,
14683,
8701,
5469,
8703,
5471,
8699,
5467,
14716,
5495,
10517,
14676,
11395,
3990,
13986,
5431,
5424,
5454,
5444,
5432,
5425,
5433,
11225,
10526,
8675,
13417,
]

_charnames_9866 = [
8976,
8975,
14020,
14013,
14014,
14019,
14738,
5457,
13254,
11385,
2548,
10513,
10615,
11222,
14667,
11850,
10512,
11397,
14674,
13075,
8733,
8734,
14769,
13442,
13898,
13897,
14418,
9535,
9533,
9534,
7646,
13407,
9198,
9200,
9199,
9556,
14036,
14849,
1646,
14684,
13642,
2567,
12183,
14594,
7650,
1867,
5439,
10596,
10599,
14865,
10598,
10497,
5206,
10213,
14709,
14710,
5442,
5443,
10618,
10354,
14301,
5421,
8744,
8752,
8755,
14712,
2555,
14032,
13065,
12285,
2431,
13395,
2533,
1858,
13744,
11223,
5449,
14717,
5426,
14730,
14044,
13371,
6634,
10207,
14624,
5450,
14155,
14154,
11400,
13360,
12248,
14250,
6639,
14412,
5458,
10102,
1870,
2437,
13445,
11852,
11853,
9555,
8987,
14854,
14657,
14677,
14699,
9917,
10249,
10629,
14464,
12235,
8568,
14592,
13384,
14685,
1238,
14739,
-1,
-1,
-1,
-1,
-1,
14735,
-1,
-1,
-1,
-1,
14299,
14298,
]

_charnames_10060 = [
2554,
-1,
13608,
-1,
-1,
-1,
-1,
5455,
14748,
14750,
-1,
13375,
]

_charnames_10175 = [
13901,
8738,
14715,
12243,
13055,
13054,
6617,
14223,
13049,
14145,
10363,
7649,
9541,
6715,
9552,
10202,
10201,
]

_charnames_11008 = [
13741,
13738,
10491,
10488,
6620,
6612,
14842,
13912,
13742,
13739,
10492,
10489,
6621,
14847,
14238,
14237,
6589,
6588,
10231,
10233,
10230,
10232,
14025,
14024,
14023,
14026,
13906,
5428,
14731,
5446,
14742,
5456,
14749,
14734,
5453,
13408,
5429,
5438,
14726,
5437,
14725,
5419,
5418,
14721,
5452,
14736,
5447,
14743,
6630,
8735,
6631,
6714,
6607,
6608,
6609,
6610,
6593,
6591,
6592,
6603,
6605,
6606,
6599,
14765,
4010,
14144,
6597,
14241,
14240,
6611,
14245,
14143,
14244,
8670,
6598,
6596,
14243,
-1,
-1,
-1,
14724,
5417,
14720,
5434,
14745,
13367,
13373,
13361,
13358,
13362,
]

_charnames_11264 = [
11780,
11769,
11771,
11778,
11751,
11733,
11754,
11750,
11755,
11740,
11744,
11737,
11752,
11776,
11763,
11775,
11774,
11761,
11757,
11773,
11727,
11746,
11772,
11766,
11777,
11760,
11758,
11721,
11747,
11779,
11723,
11731,
11732,
11736,
11726,
11734,
11724,
11725,
11735,
11742,
11770,
11743,
11767,
11739,
11722,
11748,
11764,
-1,
11717,
11706,
11708,
11715,
11688,
11670,
11691,
11687,
11692,
11677,
11681,
11674,
11689,
11713,
11700,
11712,
11711,
11698,
11694,
11710,
11664,
11683,
11709,
11703,
11714,
11697,
11695,
11658,
11684,
11716,
11660,
11668,
11669,
11673,
11663,
11671,
11661,
11662,
11672,
11679,
11707,
11680,
11704,
11676,
11659,
11685,
11701,
-1,
5921,
5687,
5919,
5944,
5883,
5624,
5548,
5958,
5752,
5928,
5743,
5967,
5764,
5862,
5954,
5839,
5840,
5705,
5983,
5793,
5708,
5960,
5751,
5553,
5571,
5537,
5658,
5990,
5811,
8877,
5902,
5966,
1571,
1490,
1574,
1493,
1581,
1500,
1545,
1464,
1583,
1502,
1554,
1473,
1573,
1492,
1580,
1499,
1562,
1481,
1579,
1498,
1560,
1479,
1568,
1487,
1578,
1497,
1577,
1496,
1558,
1477,
1516,
1435,
1566,
1485,
1576,
1495,
1555,
1474,
1563,
1482,
1575,
1494,
1582,
1501,
1559,
1478,
1565,
1484,
1538,
1457,
1544,
1463,
1531,
1450,
1551,
1470,
1542,
1461,
1541,
1460,
1549,
1468,
1527,
1446,
1556,
1475,
1552,
1471,
1526,
1445,
1529,
1448,
1572,
1491,
1543,
1462,
1522,
1441,
1520,
1439,
1569,
1488,
1523,
1442,
1521,
1440,
1528,
1447,
1530,
1449,
1525,
1444,
1537,
1456,
1535,
1454,
1534,
1453,
1536,
1455,
1510,
1513,
1512,
1506,
1511,
1509,
1507,
1548,
1467,
1550,
1469,
1589,
1588,
1587,
1584,
1503,
-1,
-1,
-1,
-1,
-1,
1593,
1594,
1592,
1591,
1597,
1596,
1598,
11822,
11838,
11820,
11837,
11836,
11827,
11802,
11805,
11835,
11814,
11834,
11833,
11832,
11831,
11811,
11801,
11829,
11808,
11804,
11828,
11810,
11813,
11819,
11830,
11807,
11796,
11799,
11816,
11798,
11797,
11825,
11817,
11790,
11793,
11792,
11826,
11789,
11791,
-1,
11824,
-1,
-1,
-1,
-1,
-1,
11823,
-1,
-1,
8578,
8602,
8603,
8595,
8597,
8634,
8612,
8579,
8582,
8580,
8581,
8617,
8613,
8592,
8623,
8594,
8600,
8635,
8631,
8601,
8615,
8593,
8624,
8607,
8629,
8620,
8585,
8638,
8628,
8611,
8610,
8609,
8626,
8630,
8608,
8618,
8598,
8599,
8596,
8627,
8637,
8589,
8590,
8591,
8586,
8588,
8614,
8587,
8606,
8605,
8604,
8583,
8632,
8584,
8616,
8619,
]

_charnames_11647 = [
8641,
3933,
3922,
3932,
3843,
3844,
3858,
3868,
3792,
3929,
3928,
3810,
3879,
3828,
3820,
3934,
3869,
3793,
3916,
3915,
3806,
3808,
3805,
3804,
]

_charnames_11680 = [
3833,
3835,
3837,
3834,
3832,
3831,
3836,
-1,
3787,
3789,
3791,
3788,
3786,
3785,
3790,
-1,
3874,
3876,
3878,
3875,
3873,
3872,
3877,
-1,
3780,
3782,
3784,
3781,
3779,
3778,
3783,
-1,
3894,
3896,
3898,
3895,
3893,
3892,
3897,
-1,
3904,
3906,
3908,
3905,
3903,
3902,
3907,
-1,
3884,
3886,
3888,
3885,
3883,
3882,
3887,
-1,
3798,
3800,
3802,
3799,
3797,
3796,
3801,
-1,
1284,
1285,
1290,
1281,
1268,
1269,
1289,
1250,
1249,
1248,
1275,
1286,
1247,
1245,
1274,
1277,
1273,
1292,
1265,
1264,
1291,
1246,
1293,
1256,
1280,
1287,
1261,
1258,
1255,
1288,
1283,
1254,
14228,
14229,
6615,
14221,
6628,
14226,
14297,
14295,
13905,
6633,
14231,
14296,
6622,
14232,
4013,
12178,
14660,
14150,
13451,
13908,
13913,
14843,
13907,
13900,
14413,
12182,
13452,
8669,
6625,
14233,
8668,
8667,
6632,
14230,
8702,
8700,
5470,
5468,
6616,
14222,
6627,
14225,
8763,
13072,
10219,
14646,
14149,
7645,
14252,
14782,
8754,
14294,
14300,
8751,
14052,
14051,
8753,
8697,
8768,
8739,
]

_charnames_12728 = [
5476,
5474,
5473,
-1,
-1,
-1,
-1,
-1,
2250,
2253,
2252,
2257,
2240,
2224,
2231,
2232,
2229,
2239,
2230,
2227,
2233,
2228,
2225,
2255,
2222,
2236,
2246,
2244,
2256,
2223,
2235,
2237,
2241,
2243,
2245,
2249,
2247,
2251,
2238,
2242,
2234,
2226,
2248,
2254,
]

_charnames_12868 = [
2527,
2522,
2526,
2521,
2510,
2508,
2509,
2515,
2516,
2512,
2513,
2517,
12177,
]

_charnames_19904 = [
13265,
13276,
13290,
13352,
13345,
13333,
13271,
13354,
13306,
13282,
13324,
13308,
13351,
13299,
13348,
13355,
13350,
13344,
13340,
13332,
13337,
13302,
13309,
13318,
13312,
13301,
13347,
13300,
13272,
13266,
13314,
13291,
13319,
13298,
13323,
13292,
13281,
13328,
13329,
13286,
13287,
13315,
13336,
13334,
13303,
13322,
13327,
13274,
13320,
13267,
13270,
13278,
13285,
13277,
13342,
13275,
13280,
13279,
13289,
13353,
13313,
13307,
13341,
13338,
]

_charnames_42192 = [
6473,
6440,
6439,
6459,
6428,
6427,
6454,
6448,
6447,
6470,
6462,
6461,
6458,
6426,
6425,
6468,
6445,
6469,
6437,
6433,
6434,
6444,
6451,
6466,
6450,
6472,
6467,
6436,
6465,
6453,
6463,
6464,
6455,
6456,
6471,
6441,
6429,
6431,
6430,
6442,
6418,
6423,
6421,
6422,
6419,
6420,
6476,
6475,
7028,
7029,
6951,
6888,
6889,
6995,
6934,
6941,
6793,
6832,
6785,
6854,
7011,
6979,
6909,
6902,
6817,
6810,
6961,
6987,
6824,
6753,
6925,
6918,
6878,
6871,
7019,
7003,
6769,
6971,
6842,
6734,
6860,
6800,
6776,
6761,
7033,
7034,
6954,
6955,
6893,
6894,
6997,
6936,
6943,
6795,
6838,
6787,
6856,
7013,
6981,
6911,
6904,
6819,
6812,
6965,
6989,
6826,
6755,
6927,
6920,
6880,
6873,
7021,
7005,
6771,
6973,
6846,
6738,
6864,
6802,
6778,
6763,
7035,
7036,
6742,
6956,
6957,
6895,
6896,
6998,
6937,
6944,
6796,
6835,
6836,
6788,
6857,
7014,
6982,
6912,
6905,
6820,
6813,
6966,
6990,
6827,
6756,
6928,
6921,
6881,
6874,
7022,
7006,
6772,
6974,
6843,
6844,
6739,
6865,
6803,
6779,
6764,
7024,
7025,
6947,
6884,
6885,
6993,
6932,
6939,
6791,
6834,
6783,
6850,
7009,
6977,
6907,
6900,
6815,
6808,
6963,
6985,
6822,
6751,
6923,
6916,
6876,
6869,
7017,
7001,
6767,
6969,
6840,
6736,
6862,
6798,
6774,
6759,
7031,
7032,
6952,
6953,
6891,
6892,
6996,
6935,
6942,
6794,
6837,
6786,
6855,
7012,
6980,
6910,
6903,
6818,
6811,
6964,
6988,
6825,
6754,
6926,
6919,
6879,
6872,
7020,
7004,
6770,
6972,
6845,
6737,
6863,
6801,
6777,
6762,
7023,
7026,
6740,
6946,
6948,
6883,
6886,
6992,
6931,
6938,
6790,
6833,
6782,
6849,
6851,
7008,
6976,
6906,
6899,
6814,
6807,
6962,
6984,
6821,
6744,
6922,
6915,
6875,
6868,
7016,
7000,
6766,
6968,
6839,
6735,
6861,
6797,
6773,
6758,
7027,
7030,
6741,
6949,
6950,
6887,
6890,
6994,
6933,
6940,
6792,
6830,
6831,
6784,
6852,
6853,
7010,
6978,
6908,
6901,
6816,
6809,
6959,
6986,
6823,
6752,
6924,
6917,
6877,
6870,
7018,
7002,
6768,
6970,
6841,
6732,
6733,
6858,
6859,
6799,
6775,
6760,
6730,
6960,
7072,
7071,
7070,
6749,
6748,
6746,
7051,
7049,
7040,
7053,
7055,
7052,
7041,
7046,
7044,
7048,
7039,
7045,
7054,
7066,
7067,
7058,
7059,
7064,
7065,
7061,
7062,
7069,
7068,
6747,
6750,
]

_charnames_42560 = [
2009,
1933,
1956,
1880,
1981,
1905,
1988,
1912,
1959,
1883,
2011,
1938,
2004,
1928,
2022,
1948,
1991,
1915,
1985,
1909,
1979,
1903,
1987,
1911,
2017,
1944,
2005,
1929,
1986,
1910,
1990,
1914,
1980,
1904,
1972,
1896,
1971,
1895,
1970,
1894,
2012,
1939,
2006,
1930,
1958,
1882,
2027,
1300,
1296,
1302,
1295,
10609,
1271,
1251,
1259,
1270,
1278,
1260,
1266,
1276,
1301,
1299,
2029,
2028,
1957,
1881,
1955,
1879,
2008,
1932,
2018,
1945,
1954,
1878,
1965,
1889,
1964,
1888,
1962,
1886,
1963,
1887,
1966,
1890,
1997,
1921,
1974,
1898,
]

_charnames_42655 = [
1253,
4939,
4877,
4935,
4874,
4938,
4903,
4914,
4936,
4860,
4937,
4922,
4845,
4905,
4906,
4921,
4881,
4915,
4863,
4850,
4878,
4895,
4885,
4893,
4896,
4894,
4897,
4873,
4871,
4856,
4855,
4848,
4930,
4891,
4929,
4931,
4861,
4870,
4842,
4849,
4859,
4839,
4933,
4843,
4926,
4907,
4918,
4887,
4862,
4901,
4908,
4872,
4852,
4853,
4854,
4892,
4840,
4924,
4925,
4934,
4864,
4920,
4844,
4919,
4866,
4883,
4902,
4880,
4888,
4916,
4876,
4886,
4884,
4911,
4875,
4912,
4858,
4898,
4927,
4867,
4868,
4944,
4943,
4949,
4950,
4946,
4945,
4947,
4948,
]

_charnames_42752 = [
8895,
8900,
8892,
8897,
8894,
8899,
8893,
8898,
8932,
8958,
8947,
8911,
8926,
8933,
8959,
8948,
8912,
8927,
8934,
8960,
8949,
8908,
8928,
8962,
8963,
8964,
8921,
8951,
8954,
8953,
8952,
8919,
8858,
8857,
5834,
5576,
5835,
5577,
5959,
5750,
5847,
5550,
5848,
5551,
5931,
5754,
5932,
5755,
6014,
6008,
5863,
5634,
5861,
5631,
5860,
5630,
5857,
5627,
5858,
5628,
5859,
5629,
5888,
5647,
5924,
5739,
5927,
5742,
5925,
5740,
5981,
5781,
5920,
5686,
5915,
5660,
5914,
5659,
5916,
5667,
5945,
5724,
5947,
5728,
5946,
5725,
5972,
5767,
5973,
5769,
5886,
5644,
5887,
5650,
5941,
5707,
5938,
5709,
5939,
5710,
5845,
5543,
5846,
5544,
5940,
5711,
5836,
5579,
5877,
5617,
5936,
5759,
8968,
5699,
5692,
5737,
5719,
5649,
5995,
5541,
5679,
5871,
5616,
5870,
5615,
5869,
5843,
5534,
5842,
5538,
5868,
5613,
5867,
5612,
5866,
5611,
8920,
8902,
8860,
5906,
5598,
5844,
5684,
-1,
5976,
5717,
5935,
5758,
]

_charnames_42912 = [
5964,
5774,
5929,
5745,
5975,
5715,
5885,
5641,
5903,
5592,
5957,
]

_charnames_43000 = [
8871,
8829,
5989,
6023,
6022,
6025,
6026,
6027,
10409,
10406,
10423,
10400,
10408,
10402,
10422,
10386,
10387,
10392,
10393,
10424,
10395,
10396,
10389,
10390,
10369,
10370,
10375,
10376,
10371,
10372,
10377,
10378,
10403,
10383,
10384,
10398,
10399,
10404,
10381,
10405,
10380,
10401,
10407,
10415,
10413,
10411,
10414,
10412,
10420,
10419,
10418,
10417,
-1,
-1,
-1,
-1,
13726,
13727,
13731,
13725,
13728,
13730,
13733,
13736,
13735,
13734,
-1,
-1,
-1,
-1,
-1,
-1,
11922,
11921,
11925,
11894,
11905,
11907,
11937,
11892,
11890,
11889,
11903,
11895,
11919,
11918,
11941,
11935,
11888,
11887,
11901,
11930,
11912,
11913,
11897,
11928,
11932,
11936,
11898,
11899,
11939,
11908,
11938,
11931,
11926,
11934,
11933,
11929,
11940,
11924,
11927,
11946,
11945,
11885,
11884,
11902,
11893,
11910,
11915,
11916,
11909,
11947,
11948,
11906,
11949,
11953,
11951,
11952,
]

_charnames_43136 = [
9834,
9832,
9754,
9757,
9778,
9779,
9762,
9763,
9732,
9733,
9734,
9735,
9783,
9784,
9756,
9767,
9768,
9755,
9774,
9773,
9782,
9781,
9746,
9787,
9786,
9777,
9776,
9744,
9740,
9739,
9751,
9750,
9745,
9742,
9741,
9753,
9752,
9747,
9766,
9765,
9790,
9789,
9793,
9791,
9792,
9771,
9736,
9760,
9759,
9761,
9794,
9770,
9835,
9804,
9809,
9810,
9805,
9806,
9797,
9798,
9799,
9800,
9811,
9812,
9803,
9807,
9808,
9802,
9833,
]

_charnames_43214 = [
9829,
9828,
9824,
9825,
9816,
9817,
9822,
9823,
9819,
9820,
9827,
9826,
-1,
-1,
-1,
-1,
-1,
-1,
1316,
1317,
1308,
1309,
1314,
1315,
1311,
1312,
1319,
1318,
1327,
1322,
1326,
1325,
1324,
1323,
1321,
1328,
13950,
13948,
13954,
13946,
13947,
13949,
13951,
13966,
13967,
13965,
-1,
-1,
-1,
-1,
12661,
12662,
12653,
12654,
12659,
12660,
12656,
12657,
12664,
12663,
12634,
12633,
12646,
12618,
12625,
12624,
12638,
12617,
12622,
12636,
12619,
12628,
12627,
12643,
12647,
12649,
12642,
12639,
12644,
12640,
12621,
12637,
12641,
12648,
12650,
12631,
12645,
12630,
12667,
12668,
12666,
12669,
12670,
12674,
12672,
12673,
12677,
12676,
14086,
14089,
14073,
14081,
14090,
14075,
14084,
14092,
14078,
14091,
14087,
14070,
14082,
14083,
14085,
14079,
14080,
14088,
14077,
14072,
14074,
14069,
14093,
14104,
14102,
14096,
14101,
14103,
14100,
14097,
14098,
14108,
14107,
14109,
14110,
14105,
]

_charnames_43359 = [
14111,
13225,
13224,
13222,
13226,
13214,
13211,
13217,
13209,
13219,
13218,
13210,
13216,
13212,
13220,
13215,
13245,
13243,
13244,
13234,
13235,
13236,
13230,
13247,
13248,
13231,
13229,
13237,
13250,
13228,
-1,
-1,
-1,
14577,
14574,
14578,
14576,
14515,
14504,
14502,
14503,
14519,
14497,
14474,
14475,
14524,
14516,
14520,
14498,
14500,
14501,
14509,
14510,
14473,
14511,
14512,
14507,
14477,
14508,
14476,
14481,
14482,
14486,
14487,
14479,
14483,
14484,
14488,
14489,
14478,
14494,
14496,
14513,
14514,
14521,
14517,
14505,
14506,
14522,
14518,
14492,
14493,
14490,
14523,
14575,
14564,
14566,
14567,
14568,
14569,
14570,
14565,
14572,
14571,
14581,
14580,
14582,
14546,
14525,
14584,
14536,
14542,
14531,
14540,
14539,
14532,
14530,
14534,
14535,
14538,
14583,
-1,
14545,
14557,
14558,
14549,
14550,
14555,
14556,
14552,
14553,
14560,
14559,
-1,
-1,
-1,
-1,
14541,
14543,
]

_charnames_43520 = [
1707,
1715,
1711,
1717,
1708,
1713,
1697,
1696,
1703,
1702,
1670,
1671,
1706,
1705,
1700,
1699,
1666,
1668,
1667,
1688,
1687,
1681,
1679,
1672,
1673,
1680,
1677,
1675,
1676,
1685,
1683,
1693,
1694,
1684,
1709,
1712,
1714,
1710,
1690,
1691,
1716,
1722,
1727,
1728,
1729,
1723,
1726,
1725,
1721,
1720,
1724,
1749,
1751,
1752,
1750,
]

_charnames_43584 = [
1661,
1662,
1654,
1746,
1663,
1656,
1653,
1659,
1655,
1658,
1660,
1657,
1747,
1748,
-1,
-1,
1740,
1741,
1732,
1733,
1738,
1739,
1735,
1736,
1743,
1742,
-1,
-1,
1758,
1756,
1755,
1757,
9585,
9580,
9579,
9574,
9573,
9570,
9568,
9567,
9564,
9563,
9565,
9571,
9583,
9577,
9576,
9586,
9712,
9582,
9581,
9584,
9625,
9624,
9626,
9670,
9669,
9668,
9622,
9650,
-1,
-1,
-1,
-1,
8203,
8234,
8201,
8232,
8202,
8233,
8221,
8252,
8198,
8229,
8211,
8242,
8212,
8243,
8215,
8246,
8196,
8227,
8223,
8254,
8205,
8236,
8206,
8237,
8197,
8228,
8224,
8255,
8208,
8239,
8209,
8240,
8222,
8253,
8218,
8249,
8213,
8244,
8216,
8247,
8219,
8250,
8214,
8245,
8220,
8251,
8217,
8248,
8285,
8262,
8267,
8264,
8263,
8270,
8269,
8284,
8268,
8265,
8266,
8259,
8258,
8260,
8261,
8282,
8281,
8279,
8280,
]

_charnames_43739 = [
8273,
8276,
8275,
8277,
8274,
9063,
9061,
9053,
9012,
9017,
9016,
9024,
9023,
9013,
9029,
9028,
9079,
9075,
9071,
9072,
9070,
9107,
9104,
9103,
9109,
9108,
9081,
9086,
]

_charnames_43777 = [
3863,
3865,
3866,
3862,
3861,
3864,
-1,
-1,
3816,
3818,
3819,
3815,
3814,
3817,
-1,
-1,
3824,
3826,
3827,
3823,
3822,
3825,
]

_charnames_43808 = [
3773,
3775,
3777,
3774,
3772,
3771,
3776,
-1,
3849,
3851,
3853,
3850,
3848,
3847,
3852,
]

_charnames_43968 = [
9036,
9030,
9041,
9039,
9032,
9010,
9052,
9018,
9038,
9008,
9020,
9058,
9057,
9062,
9059,
9046,
9034,
9064,
9049,
9045,
9060,
9056,
9044,
9025,
9050,
9026,
9055,
9037,
9042,
9040,
9033,
9011,
9019,
9009,
9047,
9083,
9078,
9073,
9080,
9082,
9076,
9085,
9084,
9106,
9065,
9102,
-1,
-1,
9097,
9098,
9089,
9090,
9095,
9096,
9092,
9093,
9100,
9099,
]

_charnames_55216 = [
13190,
13191,
13178,
13179,
13180,
13203,
13204,
13183,
13182,
13196,
13194,
13193,
13195,
13171,
13170,
13168,
13167,
13174,
13173,
13172,
13175,
13200,
13199,
-1,
-1,
-1,
-1,
13159,
13160,
13090,
13091,
13141,
13135,
13136,
13138,
13139,
13140,
13131,
13133,
13095,
13132,
13129,
13130,
13126,
13127,
13149,
13153,
13151,
13098,
13152,
13154,
13114,
13116,
13117,
13096,
13115,
13112,
13113,
13106,
13107,
13094,
13093,
13105,
13102,
13103,
13104,
13108,
13122,
13123,
13156,
13157,
13163,
13162,
13099,
13120,
13119,
]

_charnames_64107 = [
2217,
2216,
2215,
-1,
-1,
2202,
2201,
2200,
2199,
2198,
2197,
2196,
2195,
2194,
2193,
2192,
2191,
2190,
2189,
2188,
2187,
2185,
2184,
2183,
2182,
2181,
2180,
2179,
2178,
2177,
2176,
2175,
2174,
2173,
2172,
2171,
2170,
2168,
2167,
2166,
2165,
2164,
2163,
2162,
2161,
2160,
2159,
2158,
2157,
2156,
2155,
2154,
2153,
2151,
2150,
2149,
2148,
2147,
2146,
2145,
2144,
2143,
2142,
2141,
2140,
2139,
2138,
2137,
2136,
2134,
2133,
2132,
2131,
2130,
2129,
2128,
2127,
2126,
2125,
2124,
2123,
2122,
2121,
2120,
2119,
2117,
2116,
2115,
2114,
2113,
2112,
2111,
2110,
2109,
2108,
2107,
2106,
2105,
2104,
2103,
2102,
2213,
2212,
2211,
2210,
2209,
2208,
2207,
2206,
2205,
2204,
]

_charnames_64434 = [
10963,
10962,
10953,
10952,
10959,
10958,
10957,
10956,
10970,
10969,
10964,
10951,
10950,
10971,
10967,
10966,
]

_charnames_65040 = [
12210,
12208,
12207,
12211,
12212,
12215,
12213,
12204,
12200,
12214,
]

_charnames_65536 = [
6236,
6264,
6226,
6251,
6279,
6243,
6256,
6237,
6275,
6222,
6217,
6255,
-1,
6266,
6249,
6206,
6257,
6247,
6213,
6283,
6284,
6276,
6210,
6274,
6231,
6238,
6230,
6270,
6221,
6218,
6241,
6211,
6263,
6278,
6223,
6273,
6205,
6232,
6268,
-1,
6252,
6227,
6220,
6242,
6228,
6269,
6235,
6260,
6277,
6216,
6215,
6240,
6265,
6239,
6245,
6219,
6208,
6261,
6259,
-1,
6272,
6209,
-1,
6233,
6229,
6258,
6282,
6212,
6287,
6254,
6225,
6250,
6207,
6267,
6246,
6248,
6281,
6286,
-1,
-1,
6302,
6301,
6306,
6305,
6299,
6298,
6304,
6296,
6295,
6303,
6293,
6292,
6291,
6290,
]

_charnames_65664 = [
6080,
6079,
6078,
6065,
6064,
6063,
6077,
6076,
6074,
6073,
6071,
6070,
6068,
6067,
6130,
6129,
6128,
6127,
6126,
6314,
6313,
6134,
6133,
6132,
6311,
6310,
6124,
6123,
6122,
6121,
6120,
6110,
6109,
6108,
6107,
6106,
6315,
6105,
6104,
6103,
6091,
6090,
6089,
6088,
6087,
6086,
6085,
6084,
6083,
6082,
6101,
6100,
6099,
6098,
6097,
6096,
6095,
6094,
6093,
6118,
6117,
6116,
6115,
6114,
6113,
6112,
6137,
6136,
6167,
6166,
6164,
6163,
6162,
6161,
6160,
6159,
6157,
6156,
6155,
6154,
6153,
6152,
6316,
6151,
6150,
6148,
6147,
6146,
6145,
6144,
6143,
6142,
6141,
6140,
6201,
6191,
6190,
6189,
6188,
6187,
6186,
6185,
6184,
6183,
6182,
6180,
6179,
6178,
6177,
6176,
6175,
6174,
6173,
6172,
6171,
6198,
6197,
6196,
6195,
6194,
6193,
6199,
6200,
-1,
-1,
-1,
-1,
-1,
11299,
11300,
11306,
-1,
-1,
-1,
-1,
11286,
11231,
11238,
11261,
11268,
11247,
11253,
11280,
11274,
11244,
11235,
11242,
11265,
11272,
11248,
11254,
11281,
11275,
11289,
11234,
11241,
11264,
11271,
11252,
11258,
11285,
11279,
11288,
11233,
11240,
11263,
11270,
11251,
11257,
11284,
11278,
11245,
11236,
11243,
11266,
11273,
11249,
11255,
11282,
11276,
-1,
-1,
-1,
11297,
11294,
11296,
11295,
11293,
11305,
11304,
11303,
11302,
11445,
11441,
11446,
11418,
11429,
11424,
11421,
11432,
11423,
11450,
11434,
11439,
11426,
11443,
11422,
11428,
11451,
11435,
11440,
11427,
11444,
11449,
11433,
11452,
11483,
11461,
11481,
11485,
11459,
11489,
11486,
11472,
11476,
11477,
11480,
11493,
11460,
11458,
11474,
11475,
11482,
11469,
11464,
11457,
11487,
11473,
11468,
11490,
11492,
11463,
11467,
11494,
11491,
11620,
11621,
11603,
11606,
11631,
11609,
11636,
11623,
11604,
11607,
11628,
11629,
11626,
11634,
11618,
11622,
11632,
11496,
11497,
11635,
11608,
11630,
-1,
-1,
-1,
-1,
-1,
14263,
14277,
14265,
14262,
14275,
14266,
14276,
14278,
14264,
14274,
14280,
14279,
]

_charnames_66000 = [
11985,
11983,
11990,
11963,
11965,
11996,
11994,
12009,
11989,
12017,
11976,
11969,
11964,
12003,
12002,
11973,
12006,
11977,
11962,
12012,
11957,
11972,
11959,
11979,
11968,
11992,
11993,
11980,
11961,
12000,
12016,
12011,
11988,
11978,
11984,
12013,
11986,
11999,
12005,
12014,
12015,
12008,
11970,
11971,
11997,
11958,
]

_charnames_66176 = [
6659,
6655,
6657,
6658,
6673,
6674,
6671,
6663,
6661,
6648,
6670,
6653,
6667,
6669,
6651,
6649,
6652,
6650,
6664,
6668,
6654,
6666,
6665,
6646,
6647,
6660,
6656,
6672,
6662,
-1,
-1,
-1,
2421,
2407,
2416,
2401,
2379,
2404,
2402,
2422,
2424,
2426,
2389,
2425,
2417,
2398,
2386,
2387,
2383,
2420,
2377,
2395,
2423,
2394,
2400,
2406,
2388,
2410,
2414,
2380,
2408,
2409,
2397,
2378,
2412,
2413,
2384,
2385,
2396,
2411,
2419,
2399,
2382,
2405,
2390,
2393,
2392,
2391,
2403,
2415,
2381,
]

_charnames_66432 = [
14826,
14838,
14821,
14815,
14824,
14817,
14829,
14813,
14818,
14810,
14828,
14816,
14806,
14836,
14835,
14823,
14834,
14812,
14803,
14827,
14833,
14804,
14832,
14831,
14809,
14820,
14808,
14837,
14830,
14805,
-1,
14839,
12808,
12854,
12851,
12842,
12841,
12848,
12847,
12830,
12857,
12845,
12844,
12815,
12813,
12803,
12807,
12806,
12814,
12852,
12825,
12856,
12839,
12838,
12823,
12822,
12821,
12850,
12833,
12832,
12836,
12835,
12853,
12819,
12849,
12818,
12817,
12855,
-1,
-1,
-1,
-1,
12809,
12811,
12810,
12829,
12804,
12805,
12826,
12827,
12866,
12864,
12861,
12863,
12862,
12865,
]

_charnames_66638 = [
13977,
13978,
10085,
10061,
10088,
10091,
10059,
10074,
10073,
10093,
10068,
10079,
10094,
10092,
10090,
10082,
10060,
10081,
10077,
10089,
10071,
10080,
10087,
10076,
10063,
10056,
10039,
10043,
10048,
10070,
10045,
10041,
10084,
10086,
10053,
10042,
10064,
10083,
10050,
10047,
10049,
10038,
10037,
10046,
10040,
10055,
10036,
10054,
10065,
10067,
12983,
13014,
13002,
13008,
12999,
12991,
12997,
13003,
12987,
12986,
12996,
13013,
13011,
13012,
13004,
12992,
13007,
13006,
13005,
13000,
13010,
12998,
12982,
12993,
13009,
12988,
13001,
12984,
12994,
12989,
-1,
-1,
13025,
13026,
13017,
13018,
13023,
13024,
13020,
13021,
13028,
13027,
]

_charnames_67584 = [
2097,
2096,
2095,
2094,
2093,
2092,
-1,
-1,
2091,
-1,
2078,
2077,
2076,
2075,
2074,
2072,
2071,
2070,
2069,
2068,
2066,
2065,
2064,
2063,
2062,
2060,
2059,
2058,
2057,
2056,
2054,
2053,
2052,
2051,
2050,
2048,
2047,
2046,
2045,
2044,
2042,
2041,
2040,
2039,
2038,
2036,
2035,
2034,
2033,
2032,
2083,
2082,
2081,
2080,
-1,
2089,
2088,
-1,
-1,
-1,
2086,
-1,
-1,
2085,
14436,
14449,
14447,
14448,
14432,
14439,
14437,
14433,
14430,
14438,
14446,
14445,
14444,
14443,
14426,
14435,
14442,
14427,
14441,
14440,
14428,
14431,
-1,
14462,
14458,
14453,
14457,
14455,
14454,
14461,
14460,
14456,
]

_charnames_67840 = [
12030,
12044,
12042,
12043,
12027,
12034,
12032,
12028,
12025,
12033,
12041,
12040,
12039,
12038,
12022,
12031,
12037,
12023,
12036,
12035,
12021,
12026,
12052,
12051,
12049,
12053,
12048,
12050,
-1,
-1,
-1,
12054,
6687,
6702,
6698,
6700,
6685,
6690,
6697,
6689,
6696,
6683,
6695,
6681,
6694,
6692,
6680,
6677,
6691,
6699,
6693,
6679,
6678,
6688,
6686,
6684,
6682,
6701,
-1,
-1,
-1,
-1,
-1,
6703,
]

_charnames_67968 = [
9146,
9144,
9142,
9139,
9135,
9136,
9133,
9134,
9138,
9140,
9122,
9123,
9120,
9121,
9128,
9129,
9141,
9131,
9143,
9125,
9126,
9127,
9132,
9137,
9116,
9117,
9114,
9115,
9118,
9145,
9147,
9148,
9164,
9176,
9174,
9171,
9166,
9167,
9178,
9170,
9172,
9160,
9159,
9168,
9173,
9162,
9175,
9157,
9165,
9156,
9163,
9169,
9154,
9153,
9152,
9177,
-1,
-1,
-1,
-1,
-1,
-1,
9180,
9181,
]

_charnames_68096 = [
12479,
12500,
12498,
12497,
-1,
12501,
12499,
-1,
-1,
-1,
-1,
-1,
12502,
12506,
12511,
12508,
12458,
12457,
12464,
12463,
-1,
12467,
12466,
12477,
-1,
12452,
12438,
12437,
12444,
12443,
12453,
12440,
12439,
12446,
12445,
12454,
12461,
12460,
12470,
12469,
12475,
12472,
12474,
12476,
12473,
12449,
12448,
12450,
12471,
12478,
12456,
12436,
-1,
-1,
-1,
-1,
12510,
12509,
12507,
-1,
-1,
-1,
-1,
12503,
12523,
12521,
12522,
12524,
12515,
12514,
12518,
12517,
]

_charnames_68176 = [
12484,
12492,
12491,
12490,
12493,
12487,
12485,
12483,
12488,
]

_charnames_68192 = [
12889,
12904,
12890,
12903,
12901,
12899,
12880,
12900,
12906,
12874,
12877,
12888,
12902,
12887,
12879,
12878,
12905,
12896,
12895,
12884,
12892,
12885,
12893,
12873,
12897,
12883,
12898,
12872,
12871,
12909,
12910,
12911,
]

_charnames_68352 = [
11310,
11311,
11316,
11312,
11317,
11313,
11314,
11315,
11359,
11360,
11352,
11353,
11354,
11355,
11350,
11351,
11372,
11335,
11333,
11334,
11343,
11342,
11341,
11375,
11373,
11339,
11338,
11363,
11362,
11337,
11369,
11374,
11366,
11365,
11322,
11320,
11321,
11325,
11323,
11324,
11370,
11357,
11348,
11349,
11367,
11368,
11371,
11331,
11346,
11329,
11345,
11328,
11330,
11358,
-1,
-1,
-1,
11376,
8674,
10569,
6036,
6032,
6035,
6031,
14332,
14345,
14343,
14344,
14328,
14335,
14333,
14329,
14326,
14334,
14342,
14341,
14340,
14339,
14322,
14331,
14338,
14323,
14337,
14336,
14324,
14327,
-1,
-1,
14353,
14349,
14351,
14357,
14352,
14350,
14356,
14355,
14381,
14380,
14378,
14379,
14368,
14372,
14370,
14369,
14366,
14371,
14377,
14376,
14375,
14374,
14362,
14373,
14363,
14364,
14367,
-1,
-1,
-1,
-1,
-1,
14389,
14385,
14387,
14393,
14388,
14386,
14392,
14391,
]

_charnames_68608 = [
12721,
12767,
12768,
12762,
12798,
12786,
12756,
12757,
12795,
12743,
12785,
12732,
12775,
12741,
12783,
12730,
12774,
12742,
12784,
12731,
12750,
12791,
12735,
12776,
12723,
12771,
12729,
12773,
12758,
12796,
12740,
12782,
12728,
12754,
12753,
12739,
12727,
12769,
12747,
12789,
12749,
12790,
12746,
12788,
12781,
12748,
12770,
12752,
12761,
12764,
12755,
12793,
12738,
12780,
12763,
12799,
12760,
12797,
12737,
12779,
12726,
12733,
12725,
12734,
12778,
12751,
12792,
12736,
12777,
12724,
12772,
12759,
12765,
]

_charnames_69216 = [
14204,
14196,
14197,
14202,
14203,
14199,
14200,
14206,
14205,
14172,
14168,
14171,
14183,
14186,
14175,
14178,
14191,
14188,
14193,
14167,
14170,
14182,
14185,
14176,
14179,
14192,
14189,
14211,
14210,
14209,
14212,
]

_charnames_69632 = [
5350,
5351,
5347,
5349,
5348,
5243,
5246,
5265,
5266,
5251,
5252,
5216,
5217,
5218,
5219,
5280,
5245,
5227,
5244,
5261,
5260,
5269,
5268,
5235,
5272,
5271,
5264,
5263,
5233,
5224,
5223,
5240,
5239,
5234,
5226,
5225,
5242,
5241,
5236,
5255,
5254,
5275,
5274,
5278,
5276,
5277,
5258,
5220,
5249,
5248,
5250,
5279,
5257,
5231,
5229,
5230,
5320,
5327,
5323,
5324,
5321,
5322,
5313,
5314,
5315,
5316,
5326,
5319,
5325,
5318,
5328,
5345,
5344,
5358,
5357,
5355,
5359,
5354,
-1,
-1,
-1,
-1,
5302,
5284,
5287,
5297,
5300,
5291,
5293,
5308,
5306,
5289,
5285,
5288,
5298,
5301,
5292,
5294,
5309,
5307,
5305,
5304,
5340,
5341,
5332,
5333,
5338,
5339,
5335,
5336,
5343,
5342,
]

_charnames_69760 = [
12603,
12604,
12600,
12546,
12549,
12568,
12569,
12554,
12555,
12585,
12548,
12581,
12547,
12564,
12563,
12572,
12571,
12544,
12575,
12574,
12567,
12566,
12542,
12538,
12537,
12532,
12531,
12530,
12557,
12543,
12540,
12539,
12534,
12533,
12545,
12561,
12560,
12578,
12577,
12582,
12579,
12558,
12583,
12580,
12552,
12551,
12553,
12584,
12590,
12593,
12594,
12591,
12592,
12596,
12589,
12595,
12588,
12601,
12602,
12613,
12612,
12611,
12605,
12608,
12610,
12609,
]

_charnames_69840 = [
10458,
10457,
10470,
10469,
10468,
10467,
10449,
10446,
10462,
10447,
10455,
10460,
10454,
10459,
10466,
10463,
10464,
10445,
10471,
10453,
10465,
10456,
10461,
10452,
10450,
]

_charnames_69872 = [
10482,
10483,
10474,
10475,
10480,
10481,
10477,
10478,
10485,
10484,
-1,
-1,
-1,
-1,
-1,
-1,
1842,
1843,
1841,
1808,
1805,
1800,
1807,
1786,
1785,
1792,
1791,
1770,
1795,
1794,
1789,
1788,
1768,
1764,
1763,
1775,
1774,
1769,
1766,
1765,
1777,
1776,
1771,
1783,
1782,
1798,
1797,
1803,
1779,
1780,
1802,
1804,
1799,
1801,
1806,
1828,
1835,
1836,
1831,
1832,
1837,
1830,
1833,
1829,
1834,
1846,
1848,
1838,
1847,
-1,
1820,
1821,
1812,
1813,
1818,
1819,
1815,
1816,
1823,
1822,
1844,
1825,
1824,
1845,
]

_charnames_70016 = [
10028,
10025,
10021,
9946,
9949,
9968,
9969,
9954,
9955,
9924,
9925,
9926,
9927,
9984,
9948,
9981,
9947,
9964,
9963,
9972,
9971,
9938,
9975,
9974,
9967,
9966,
9936,
9932,
9931,
9943,
9942,
9937,
9934,
9933,
9945,
9944,
9939,
9958,
9957,
9978,
9977,
9982,
9979,
9980,
9961,
9960,
9928,
9952,
9951,
9953,
9983,
9994,
9997,
9998,
9995,
9996,
9987,
9988,
9989,
9990,
10000,
9993,
9999,
9992,
10022,
10024,
10027,
10026,
10030,
10017,
10016,
10031,
10029,
]

_charnames_70096 = [
10012,
10013,
10004,
10005,
10010,
10011,
10007,
10008,
10015,
10014,
]

_charnames_71296 = [
8347,
8350,
8368,
8369,
8351,
8352,
8385,
8349,
8381,
8348,
8364,
8363,
8372,
8371,
8339,
8375,
8374,
8367,
8366,
8337,
8333,
8332,
8344,
8343,
8338,
8335,
8334,
8346,
8345,
8340,
8361,
8360,
8378,
8377,
8382,
8379,
8358,
8383,
8380,
8354,
8355,
8384,
8357,
8416,
8413,
8404,
8407,
8408,
8405,
8406,
8410,
8403,
8409,
8402,
8414,
8415,
]

_charnames_71360 = [
8396,
8397,
8388,
8389,
8394,
8395,
8391,
8392,
8399,
8398,
]

_charnames_73728 = [
612,
669,
668,
667,
666,
665,
664,
663,
662,
690,
613,
627,
626,
621,
620,
625,
618,
617,
624,
623,
622,
628,
629,
635,
634,
633,
632,
631,
689,
682,
685,
684,
636,
646,
645,
644,
643,
640,
639,
642,
641,
648,
647,
686,
687,
670,
676,
675,
674,
673,
677,
688,
679,
680,
681,
660,
650,
656,
657,
655,
653,
654,
659,
658,
1036,
1044,
1043,
1042,
1037,
1039,
1038,
1040,
1041,
1055,
1059,
1058,
1057,
1045,
1049,
1048,
1050,
1053,
1054,
1051,
1052,
766,
767,
790,
789,
787,
786,
772,
773,
770,
771,
774,
796,
783,
784,
795,
779,
776,
778,
777,
794,
793,
792,
791,
782,
781,
801,
797,
800,
799,
819,
826,
820,
822,
821,
823,
824,
825,
802,
813,
814,
812,
808,
810,
809,
815,
816,
818,
803,
804,
805,
806,
807,
817,
827,
874,
875,
861,
869,
868,
867,
865,
864,
866,
879,
878,
877,
852,
855,
856,
857,
860,
859,
858,
872,
871,
876,
828,
835,
836,
837,
838,
851,
848,
849,
846,
847,
850,
840,
841,
842,
831,
832,
834,
833,
845,
844,
5,
97,
6,
13,
12,
11,
17,
16,
14,
15,
64,
63,
60,
61,
58,
55,
56,
57,
52,
53,
50,
51,
34,
33,
28,
29,
30,
31,
46,
44,
45,
48,
47,
75,
74,
40,
39,
36,
37,
41,
78,
72,
71,
68,
69,
77,
25,
24,
20,
21,
22,
26,
76,
65,
66,
67,
79,
93,
94,
91,
92,
86,
88,
87,
96,
80,
81,
83,
84,
85,
89,
90,
95,
153,
154,
98,
126,
125,
127,
119,
121,
122,
128,
107,
108,
100,
106,
105,
104,
103,
102,
118,
110,
117,
115,
114,
116,
129,
152,
130,
133,
134,
136,
135,
137,
143,
147,
146,
148,
151,
149,
150,
138,
142,
141,
140,
1003,
1005,
1006,
1007,
983,
985,
986,
993,
992,
991,
990,
989,
988,
987,
994,
995,
1001,
1000,
999,
998,
997,
1002,
955,
981,
980,
973,
976,
975,
963,
964,
969,
966,
967,
968,
970,
972,
971,
956,
958,
961,
960,
959,
962,
979,
978,
977,
293,
337,
338,
339,
340,
335,
334,
333,
336,
356,
355,
296,
300,
299,
297,
298,
301,
305,
303,
304,
306,
307,
353,
352,
344,
342,
343,
350,
349,
319,
323,
322,
321,
324,
325,
347,
346,
360,
359,
314,
315,
313,
312,
311,
310,
317,
316,
358,
326,
330,
329,
328,
327,
357,
380,
381,
382,
366,
365,
364,
362,
363,
378,
379,
371,
373,
374,
377,
376,
367,
370,
369,
408,
395,
404,
402,
403,
406,
405,
400,
399,
397,
398,
383,
394,
393,
388,
389,
392,
386,
387,
391,
384,
385,
390,
407,
156,
158,
161,
165,
164,
163,
168,
167,
166,
223,
222,
226,
225,
206,
207,
204,
205,
218,
219,
220,
202,
198,
201,
200,
190,
191,
189,
187,
188,
196,
195,
193,
194,
214,
215,
216,
224,
183,
182,
181,
178,
179,
184,
211,
210,
212,
169,
172,
171,
175,
174,
173,
227,
228,
230,
231,
232,
233,
239,
237,
238,
234,
235,
236,
288,
291,
290,
289,
240,
287,
241,
268,
267,
260,
261,
266,
265,
264,
249,
247,
248,
250,
259,
258,
263,
256,
255,
253,
252,
262,
269,
274,
273,
271,
272,
286,
275,
278,
279,
280,
285,
284,
281,
282,
283,
942,
946,
947,
950,
949,
948,
943,
944,
953,
954,
951,
952,
920,
941,
937,
938,
940,
939,
921,
926,
925,
924,
927,
928,
929,
930,
933,
934,
935,
936,
748,
758,
749,
753,
751,
752,
754,
757,
755,
756,
759,
763,
762,
764,
721,
747,
746,
741,
744,
743,
722,
732,
730,
731,
740,
739,
738,
737,
724,
728,
726,
727,
735,
734,
745,
692,
720,
693,
715,
714,
711,
712,
713,
718,
719,
716,
717,
694,
706,
705,
704,
703,
702,
701,
700,
699,
698,
697,
707,
708,
1030,
1033,
1032,
1031,
1034,
1009,
1019,
1020,
1018,
1017,
1021,
1014,
1015,
1012,
1013,
1022,
1023,
1028,
1027,
1026,
1029,
1081,
1082,
1084,
1083,
465,
490,
466,
488,
481,
482,
487,
480,
479,
486,
485,
484,
477,
476,
483,
474,
473,
472,
471,
470,
489,
491,
492,
493,
495,
494,
436,
437,
446,
445,
444,
443,
442,
441,
439,
440,
449,
448,
447,
450,
458,
457,
456,
460,
459,
451,
453,
452,
430,
433,
432,
412,
425,
418,
417,
424,
423,
414,
415,
422,
421,
420,
419,
435,
426,
428,
429,
434,
461,
464,
463,
462,
505,
511,
506,
507,
508,
510,
509,
496,
504,
501,
502,
503,
499,
500,
497,
498,
881,
896,
894,
893,
895,
897,
900,
899,
882,
890,
889,
886,
885,
888,
887,
902,
901,
917,
918,
903,
910,
909,
904,
908,
906,
907,
911,
916,
915,
914,
912,
913,
512,
602,
601,
600,
599,
598,
611,
610,
564,
573,
570,
569,
567,
568,
574,
571,
572,
575,
576,
581,
580,
579,
578,
586,
582,
585,
584,
607,
608,
513,
562,
561,
545,
554,
553,
555,
557,
556,
547,
550,
549,
563,
558,
559,
514,
533,
534,
542,
541,
517,
520,
519,
518,
521,
540,
529,
528,
527,
539,
538,
537,
536,
532,
531,
535,
525,
524,
523,
543,
544,
587,
592,
589,
590,
591,
593,
595,
594,
609,
604,
605,
606,
1073,
1075,
1076,
1078,
1077,
1079,
1061,
1067,
1066,
1062,
1063,
1065,
1064,
1068,
1069,
1070,
1072,
1071,
]

_charnames_74752 = [
1157,
1141,
1103,
1120,
1173,
1171,
1223,
1212,
1143,
1106,
1123,
1179,
1170,
1222,
1211,
1105,
1122,
1176,
1167,
1219,
1208,
1190,
1153,
1140,
1102,
1119,
1178,
1169,
1221,
1210,
1189,
1152,
1139,
1101,
1118,
1150,
1129,
1130,
1099,
1111,
1177,
1168,
1220,
1209,
1197,
1149,
1127,
1128,
1098,
1110,
1182,
1181,
1195,
1155,
1132,
1133,
1096,
1116,
1137,
1136,
1088,
1092,
1091,
1090,
1175,
1166,
1165,
1164,
1217,
1218,
1204,
1206,
1205,
1207,
1158,
1142,
1104,
1121,
1174,
1196,
1156,
1134,
1094,
1095,
1114,
1115,
1214,
1215,
1192,
1159,
1187,
1147,
1112,
1186,
1146,
1193,
1198,
1200,
1201,
]

_charnames_77824 = [
2616,
2615,
2614,
2613,
2608,
2609,
2605,
2607,
2606,
2612,
2611,
2610,
2603,
2602,
2601,
2600,
2594,
2595,
2599,
2598,
2592,
2593,
2597,
2596,
2661,
2660,
2659,
2658,
2657,
2656,
2655,
2654,
2653,
2652,
2628,
2627,
2618,
2619,
2626,
2625,
2624,
2623,
2622,
2621,
2620,
2583,
2584,
2590,
2581,
2582,
2579,
2580,
2589,
2577,
2578,
2588,
2587,
2586,
2585,
2650,
2649,
2648,
2647,
2646,
2645,
2644,
2643,
2642,
2641,
2639,
2638,
2637,
2636,
2635,
2634,
2633,
2632,
2631,
2630,
2662,
3725,
3724,
3723,
3722,
3716,
3717,
3721,
3720,
3719,
3718,
3634,
3623,
3626,
3625,
3624,
3633,
3632,
3631,
3630,
3629,
3628,
3627,
3636,
3637,
3646,
3645,
3644,
3643,
3642,
3641,
3640,
3639,
3638,
3652,
3651,
3650,
3649,
3648,
2912,
2911,
2910,
2909,
2908,
2907,
2906,
2903,
2904,
2905,
2901,
2900,
2899,
2898,
2897,
2896,
2895,
2894,
2893,
2892,
2890,
2889,
2888,
2887,
2886,
2885,
2884,
2880,
2881,
2883,
2882,
2878,
2869,
2870,
2877,
2876,
2867,
2868,
2875,
2874,
2873,
2872,
2871,
2865,
2864,
2863,
2862,
2861,
2860,
2856,
2857,
2859,
2854,
2855,
2858,
2815,
2824,
2823,
2822,
2821,
2820,
2819,
2818,
2817,
2816,
2835,
2827,
2828,
2834,
2825,
2826,
2833,
2832,
2831,
2830,
2829,
2852,
2851,
2850,
2849,
2848,
2847,
2846,
2837,
2845,
2844,
2843,
2842,
2841,
2840,
2839,
2838,
3492,
3491,
3490,
3489,
3488,
3487,
3486,
3484,
3485,
3482,
3483,
3480,
3479,
3478,
3477,
3476,
3475,
3471,
3472,
3469,
3470,
3474,
3473,
3458,
3459,
3467,
3466,
3465,
3464,
3463,
3462,
3461,
3456,
3457,
3460,
3502,
3501,
3500,
3499,
3494,
3495,
3498,
3497,
3496,
3203,
3204,
3212,
3211,
3210,
3209,
3208,
3207,
3206,
3205,
3201,
3200,
3199,
3191,
3192,
3198,
3197,
3196,
3195,
3194,
3193,
3189,
3179,
3180,
3188,
3187,
3186,
3185,
3184,
3183,
3182,
3181,
3177,
3169,
3170,
3176,
3175,
3174,
3173,
3172,
3167,
3168,
3165,
3166,
3171,
3163,
3162,
3161,
3160,
3159,
3155,
3156,
3153,
3154,
3151,
3152,
3158,
3157,
3220,
3214,
3217,
3216,
3215,
3219,
3218,
3273,
3272,
3271,
3270,
3269,
3265,
3266,
3262,
3264,
3263,
3268,
3267,
3285,
3275,
3276,
3284,
3283,
3282,
3281,
3280,
3279,
3278,
3277,
3251,
3252,
3260,
3259,
3258,
3257,
3256,
3249,
3250,
3255,
3254,
3253,
3247,
3246,
3245,
3244,
3243,
3242,
3238,
3239,
3236,
3237,
3241,
3240,
3234,
3233,
3232,
3225,
3226,
3231,
3223,
3224,
3230,
3229,
3228,
3227,
3291,
3290,
3289,
3288,
3287,
3745,
3744,
3743,
3742,
3741,
3737,
3738,
3740,
3739,
3665,
3664,
3663,
3662,
3657,
3658,
3661,
3660,
3659,
3655,
3656,
3669,
3670,
3667,
3668,
3674,
3673,
3672,
3671,
3754,
3753,
3752,
3751,
3750,
3749,
3748,
3747,
3714,
3707,
3708,
3713,
3712,
3711,
3705,
3706,
3710,
3709,
3130,
3132,
3131,
3141,
3133,
3134,
3140,
3139,
3138,
3137,
3136,
3135,
3094,
3095,
3100,
3079,
3087,
3086,
3085,
3084,
3083,
3082,
3081,
3080,
3099,
3098,
3092,
3093,
3090,
3091,
3088,
3089,
3097,
3096,
3128,
3127,
3120,
3121,
3126,
3118,
3119,
3125,
3124,
3123,
3116,
3117,
3122,
3114,
3105,
3106,
3113,
3102,
3104,
3103,
3112,
3111,
3110,
3109,
3108,
3107,
3143,
3144,
3148,
3147,
3146,
3145,
2753,
2752,
2751,
2750,
2749,
2748,
2747,
2746,
2745,
2731,
2730,
2729,
2728,
2727,
2726,
2725,
2724,
2720,
2722,
2721,
2723,
2743,
2742,
2741,
2740,
2739,
2733,
2734,
2738,
2737,
2736,
2735,
2718,
2717,
2716,
2711,
2712,
2709,
2710,
2707,
2708,
2715,
2705,
2706,
2714,
2713,
2757,
2756,
2755,
2811,
2810,
2809,
2808,
2802,
2803,
2807,
2806,
2805,
2804,
2800,
2799,
2798,
2797,
2796,
2795,
2794,
2790,
2791,
2793,
2792,
2812,
2782,
2781,
2780,
2779,
2778,
2777,
2776,
2775,
2774,
2764,
2765,
2762,
2763,
2772,
2771,
2770,
2769,
2768,
2767,
2760,
2761,
2766,
2787,
2786,
2784,
2785,
3006,
3007,
3013,
3012,
3011,
3004,
3005,
2997,
3003,
3002,
3001,
3000,
2999,
2998,
3010,
3009,
3008,
3047,
3050,
3049,
3048,
3060,
3059,
3058,
3057,
3056,
3055,
3054,
3053,
3051,
3052,
3038,
3039,
3045,
3044,
3043,
3036,
3037,
3034,
3035,
3042,
3041,
3040,
3032,
3033,
3022,
3023,
3030,
3029,
3020,
3021,
3028,
3027,
3015,
3019,
3018,
3017,
3016,
3026,
3025,
3024,
3071,
3070,
3069,
3068,
3067,
3066,
3065,
3064,
3063,
3062,
3073,
3075,
3074,
3076,
3679,
3680,
3687,
3677,
3678,
3686,
3685,
3684,
3683,
3682,
3681,
3690,
3689,
3762,
3761,
3760,
3759,
3758,
3757,
3756,
3573,
3565,
3566,
3562,
3564,
3563,
3572,
3571,
3570,
3569,
3568,
3567,
3551,
3552,
3560,
3559,
3558,
3557,
3556,
3549,
3550,
3555,
3554,
3553,
3584,
3583,
3582,
3581,
3580,
3579,
3578,
3577,
3576,
3575,
3343,
3335,
3336,
3342,
3341,
3340,
3333,
3334,
3339,
3338,
3337,
3306,
3305,
3304,
3303,
3294,
3296,
3295,
3302,
3301,
3297,
3298,
3300,
3299,
3319,
3318,
3317,
3316,
3315,
3314,
3308,
3310,
3309,
3313,
3312,
3311,
3331,
3330,
3329,
3328,
3327,
3321,
3322,
3326,
3325,
3324,
3323,
3351,
3350,
3349,
3348,
3347,
3346,
3345,
3419,
3418,
3413,
3414,
3417,
3416,
3415,
3411,
3412,
3409,
3410,
3407,
3408,
3432,
3423,
3424,
3431,
3430,
3429,
3428,
3421,
3422,
3427,
3426,
3425,
3443,
3442,
3441,
3440,
3439,
3438,
3437,
3436,
3435,
3434,
3453,
3452,
3447,
3448,
3445,
3446,
3451,
3450,
3449,
3389,
3388,
3387,
3386,
3385,
3379,
3381,
3380,
3384,
3383,
3382,
3400,
3399,
3398,
3397,
3396,
3395,
3394,
3393,
3392,
3391,
3365,
3364,
3363,
3356,
3357,
3362,
3361,
3360,
3359,
3358,
3354,
3355,
3377,
3376,
3367,
3368,
3375,
3374,
3373,
3372,
3371,
3370,
3369,
3404,
3403,
3402,
2941,
2950,
2949,
2948,
2947,
2946,
2945,
2944,
2943,
2942,
2954,
2955,
2961,
2960,
2959,
2958,
2951,
2953,
2952,
2957,
2956,
2977,
2963,
2966,
2965,
2964,
2967,
2969,
2968,
2976,
2975,
2974,
2973,
2972,
2971,
2970,
2915,
2927,
2926,
2925,
2924,
2923,
2922,
2921,
2920,
2919,
2918,
2917,
2916,
2939,
2938,
2932,
2933,
2937,
2936,
2935,
2934,
2930,
2931,
2928,
2929,
2985,
2986,
2983,
2984,
2992,
2981,
2982,
2991,
2990,
2989,
2979,
2980,
2988,
2987,
2993,
2994,
3612,
3611,
3604,
3605,
3610,
3609,
3608,
3607,
3606,
3602,
3603,
3593,
3594,
3600,
3599,
3598,
3591,
3592,
3597,
3596,
3589,
3590,
3587,
3588,
3595,
3620,
3619,
3618,
3617,
3614,
3615,
3616,
3703,
3702,
3701,
3692,
3694,
3693,
3700,
3697,
3698,
3699,
3695,
3696,
3727,
3728,
3735,
3734,
3733,
3732,
3731,
3730,
3729,
3546,
3530,
3534,
3533,
3532,
3531,
3535,
3537,
3536,
3540,
3541,
3538,
3539,
3545,
3544,
3543,
3542,
3528,
3527,
3526,
3525,
3524,
3505,
3514,
3513,
3512,
3511,
3510,
3509,
3508,
3507,
3506,
3515,
3523,
3522,
3521,
3520,
3519,
3518,
3517,
3516,
2675,
2674,
2673,
2672,
2671,
2670,
2665,
2667,
2666,
2669,
2668,
2697,
2696,
2695,
2694,
2693,
2692,
2691,
2690,
2689,
2688,
2686,
2685,
2684,
2683,
2682,
2681,
2680,
2679,
2678,
2677,
2701,
2700,
2699,
]

_charnames_92160 = [
4569,
4677,
4646,
4647,
4590,
4621,
4666,
4578,
4624,
4643,
4644,
4600,
4662,
4571,
4598,
4605,
4614,
4632,
4565,
4652,
4583,
4630,
4568,
4672,
4671,
4564,
4603,
4638,
4675,
4639,
4610,
4577,
4680,
4676,
4563,
4631,
4615,
4616,
4608,
4656,
4640,
4587,
4649,
4599,
4592,
4648,
4661,
4669,
4629,
4664,
4602,
4653,
4586,
4657,
4609,
4620,
4670,
4683,
4682,
4658,
4628,
4604,
4623,
4561,
4625,
4574,
4636,
4584,
4679,
4570,
4601,
4591,
4613,
4575,
4665,
4627,
4637,
4580,
4597,
4573,
4655,
4581,
4681,
4668,
4593,
4589,
4612,
4717,
4752,
4726,
4727,
4747,
4689,
4736,
4755,
4688,
4737,
4741,
4756,
4745,
4719,
4720,
4758,
4740,
4751,
4724,
4723,
4698,
4691,
4714,
4732,
4759,
4731,
4746,
4742,
4764,
4712,
4709,
4763,
4728,
4753,
4702,
4707,
4708,
4699,
4725,
4692,
4703,
4715,
4739,
4701,
4761,
4690,
4762,
4733,
4696,
4695,
4748,
4710,
4718,
4693,
4735,
4711,
4422,
4459,
4513,
4551,
4420,
4437,
4423,
4546,
4471,
4548,
4463,
4455,
4469,
4541,
4441,
4478,
4497,
4547,
4500,
4514,
4458,
4481,
4432,
4473,
4515,
4508,
4509,
4530,
4442,
4524,
4450,
4520,
4532,
4419,
4553,
4462,
4489,
4456,
4416,
4535,
4474,
4492,
4453,
4522,
4417,
4556,
4436,
4433,
4431,
4557,
4554,
4470,
4555,
4449,
4536,
4519,
4428,
4446,
4504,
4415,
4485,
4482,
4537,
4506,
4448,
4424,
4550,
4418,
4430,
4454,
4507,
4429,
4440,
4488,
4516,
4439,
4527,
4531,
4472,
4486,
4479,
4498,
4468,
4499,
4477,
4512,
4445,
4491,
4490,
4528,
4502,
4503,
4425,
4461,
4538,
4542,
4543,
4523,
4317,
4404,
4264,
4300,
4265,
4378,
4267,
4277,
4258,
4283,
4403,
4252,
4330,
4254,
4349,
4360,
4329,
4270,
4336,
4350,
4395,
4353,
4340,
4302,
4286,
4319,
4311,
4342,
4394,
4268,
4347,
4249,
4364,
4407,
4251,
4409,
4287,
4306,
4373,
4288,
4323,
4308,
4381,
4307,
4299,
4376,
4274,
4315,
4356,
4282,
4362,
4341,
4393,
4348,
4401,
4363,
4250,
4303,
4273,
4346,
4386,
4384,
4280,
4374,
4257,
4304,
4260,
4392,
4387,
4391,
4289,
4292,
4337,
4354,
4262,
4253,
4365,
4312,
4352,
4278,
4361,
4320,
4259,
4372,
4261,
4276,
4269,
4406,
4351,
4398,
4368,
4366,
4281,
4400,
4375,
4313,
4297,
4335,
4322,
4333,
4328,
4355,
4295,
4331,
4293,
4385,
4296,
4332,
4382,
4321,
4377,
4399,
4367,
4294,
4316,
4339,
4410,
4054,
4138,
4118,
4183,
4240,
4178,
4090,
4172,
4227,
4067,
4058,
4086,
4130,
4031,
4197,
4233,
4170,
4040,
4091,
4137,
4190,
4180,
4069,
4046,
4109,
4029,
4045,
4068,
4229,
4063,
4103,
4173,
4035,
4116,
4216,
4030,
4064,
4111,
4177,
4041,
4056,
4131,
4169,
4087,
4052,
4037,
4160,
4217,
4135,
4151,
4104,
4134,
4195,
4171,
4142,
4238,
4235,
4184,
4083,
4128,
4221,
4047,
4167,
4115,
4119,
4072,
4081,
4224,
4133,
4191,
4161,
4074,
4159,
4123,
4057,
4098,
4148,
4186,
4206,
4223,
4026,
4196,
4108,
4032,
4219,
4208,
4077,
4102,
4154,
4039,
4075,
4071,
4105,
4113,
4207,
4080,
4121,
4218,
4204,
4120,
4085,
4027,
4189,
4097,
4078,
4152,
4036,
4094,
4205,
4210,
4061,
4243,
4139,
4241,
4242,
4182,
4093,
4127,
4129,
4053,
4166,
4153,
4042,
4149,
4156,
4157,
4146,
4147,
4194,
4101,
4062,
4088,
4234,
4211,
4239,
4185,
4112,
4230,
4228,
4043,
4048,
4164,
4165,
4203,
4079,
4095,
4179,
4198,
4124,
4107,
4110,
4141,
4199,
4122,
4143,
4209,
4220,
4797,
4835,
4794,
4837,
4802,
4816,
4775,
4827,
4804,
4805,
4812,
4817,
4779,
4771,
4807,
4785,
4784,
4786,
4787,
4793,
4791,
4768,
4767,
4770,
4829,
4782,
4830,
4777,
4821,
4776,
4832,
4822,
4806,
4778,
4800,
4792,
4773,
4774,
4783,
4823,
4836,
4833,
4826,
4825,
4796,
4809,
4801,
4813,
4811,
4810,
4818,
4795,
4788,
4834,
]

_charnames_93952 = [
9313,
9324,
9259,
9312,
9316,
9315,
9288,
9323,
9307,
9306,
9226,
9281,
9257,
9258,
9225,
9280,
9237,
9239,
9260,
9286,
9233,
9232,
9295,
9294,
9293,
9292,
9224,
9279,
9223,
9278,
9322,
9304,
9261,
9310,
9309,
9236,
9235,
9285,
9319,
9320,
9303,
9302,
9219,
9274,
9230,
9229,
9220,
9275,
9255,
9262,
9271,
9298,
9297,
9250,
9248,
9221,
9276,
9256,
9299,
9251,
9249,
9246,
9244,
9287,
9245,
9243,
9321,
9289,
9318,
]

_charnames_94032 = [
9238,
9378,
9376,
9377,
9335,
9343,
9342,
9336,
9337,
9357,
9359,
9364,
9363,
9351,
9354,
9355,
9360,
9326,
9327,
9328,
9329,
9331,
9334,
9333,
9330,
9332,
9344,
9345,
9346,
9347,
9348,
9350,
9349,
9361,
9362,
9338,
9339,
9353,
9366,
9352,
9365,
9341,
9356,
9340,
9358,
9367,
9368,
]

_charnames_94095 = [
9371,
9370,
9373,
9372,
9217,
9216,
9215,
9214,
9213,
9212,
9211,
9270,
9269,
9268,
9267,
9266,
9265,
]

_charnames_119296 = [
11538,
11555,
11566,
11565,
11549,
11564,
11563,
11562,
11561,
11548,
11547,
11546,
11545,
11544,
11543,
11542,
11541,
11540,
11539,
11560,
11559,
11558,
11557,
11556,
11554,
11553,
11552,
11551,
11550,
11507,
11515,
11499,
11522,
11536,
11535,
11514,
11513,
11512,
11511,
11510,
11509,
11508,
11521,
11520,
11519,
11518,
11517,
11516,
11534,
11533,
11532,
11531,
11530,
11529,
11506,
11505,
11504,
11503,
11502,
11501,
11500,
11527,
11526,
11525,
11524,
11523,
1404,
1405,
1406,
11625,
]

_charnames_119552 = [
8977,
14017,
14016,
14011,
14010,
14008,
8441,
8478,
8510,
8521,
8530,
8428,
8505,
8526,
8519,
8451,
8447,
8537,
8533,
8503,
8473,
8430,
8535,
8524,
8481,
8507,
8472,
8469,
8464,
8540,
8429,
8459,
8453,
8440,
8452,
8520,
8501,
8517,
8437,
8529,
8493,
8489,
8502,
8477,
8470,
8515,
8471,
8497,
8460,
8487,
8496,
8458,
8500,
8474,
8482,
8538,
8431,
8511,
8462,
8539,
8446,
8438,
8495,
8494,
8512,
8508,
8463,
8454,
8523,
8490,
8532,
8450,
8455,
8445,
8461,
8491,
8488,
8536,
8434,
8439,
8483,
8506,
8433,
8527,
8448,
8516,
8480,
]

_charnames_119648 = [
1611,
1603,
1604,
1609,
1610,
1606,
1607,
1613,
1612,
1624,
1616,
1617,
1622,
1623,
1619,
1620,
1626,
1625,
]

_charnames_126464 = [
10815,
10827,
10823,
10681,
-1,
10818,
10806,
10824,
10800,
10817,
10813,
10719,
10822,
10821,
10752,
10816,
10826,
10753,
10820,
10819,
10751,
10804,
10802,
10812,
10803,
10682,
10807,
10825,
10679,
10677,
10678,
10676,
-1,
10777,
10773,
-1,
10766,
-1,
-1,
10767,
-1,
10768,
10764,
10772,
10771,
10770,
10757,
10778,
10775,
10758,
10769,
-1,
10756,
10761,
10760,
10763,
-1,
10776,
-1,
10774,
-1,
-1,
-1,
-1,
-1,
-1,
10796,
-1,
-1,
-1,
-1,
10797,
-1,
10791,
-1,
10794,
-1,
10793,
10784,
10799,
-1,
10785,
10792,
-1,
10783,
-1,
-1,
10795,
-1,
10790,
-1,
10798,
-1,
10789,
-1,
10788,
-1,
10749,
10746,
-1,
10739,
-1,
-1,
10740,
10725,
10742,
10737,
-1,
10745,
10744,
10728,
10750,
10748,
10729,
10743,
-1,
10727,
10724,
10723,
10736,
-1,
10734,
10741,
10747,
10733,
-1,
10732,
-1,
10705,
10718,
10715,
10702,
10699,
10708,
10696,
10700,
10690,
10707,
-1,
10713,
10712,
10711,
10693,
10706,
10717,
10694,
10710,
10709,
10692,
10689,
10687,
10714,
10688,
10703,
10697,
10716,
-1,
-1,
-1,
-1,
-1,
10673,
10669,
10659,
-1,
10662,
10656,
10670,
10650,
10661,
-1,
10667,
10666,
10665,
10653,
10674,
10672,
10654,
10664,
10663,
10652,
10649,
10647,
10668,
10648,
10660,
10657,
10671,
]

_charnames_126976 = [
9448,
9405,
9452,
9441,
9456,
9459,
9451,
9432,
9410,
9415,
9421,
9426,
9396,
9401,
9446,
9439,
9433,
9411,
9416,
9422,
9427,
9397,
9402,
9447,
9440,
9431,
9409,
9414,
9420,
9425,
9395,
9400,
9445,
9438,
9457,
9434,
9454,
9460,
9404,
9403,
9461,
9450,
9458,
9455,
-1,
-1,
-1,
-1,
13893,
13892,
13891,
13890,
13889,
13888,
13887,
13886,
13884,
13883,
13882,
13881,
13880,
13879,
13878,
13876,
13875,
13874,
13873,
13872,
13871,
13870,
13868,
13867,
13866,
13865,
13864,
13863,
13862,
13860,
13859,
13858,
13857,
13856,
13855,
13854,
13852,
13851,
13850,
13849,
13848,
13847,
13846,
13844,
13843,
13842,
13841,
13840,
13839,
13838,
13834,
13833,
13832,
13831,
13830,
13829,
13828,
13827,
13825,
13824,
13823,
13822,
13821,
13820,
13819,
13817,
13816,
13815,
13814,
13813,
13812,
13811,
13809,
13808,
13807,
13806,
13805,
13804,
13803,
13801,
13800,
13799,
13798,
13797,
13796,
13795,
13793,
13792,
13791,
13790,
13789,
13788,
13787,
13785,
13784,
13783,
13782,
13781,
13780,
13779,
]

_charnames_127136 = [
12133,
12127,
12059,
12064,
12097,
12102,
12075,
12080,
12122,
12112,
12069,
12117,
12086,
12107,
12091,
-1,
-1,
12128,
12060,
12065,
12098,
12103,
12076,
12081,
12123,
12113,
12070,
12118,
12087,
12108,
12092,
-1,
-1,
12129,
12061,
12066,
12099,
12104,
12077,
12082,
12124,
12114,
12071,
12119,
12088,
12109,
12093,
12132,
-1,
12130,
12062,
12067,
12100,
12105,
12078,
12083,
12125,
12115,
12072,
12120,
12089,
12110,
12094,
12134,
]

_charnames_127232 = [
13993,
13994,
14004,
13996,
13997,
14002,
14003,
13999,
14000,
14006,
14005,
-1,
-1,
-1,
-1,
-1,
12166,
12165,
12164,
12163,
12162,
12161,
12160,
12159,
12158,
12157,
12156,
12155,
12154,
12153,
12152,
12151,
12150,
12149,
12148,
12147,
12146,
12145,
12144,
12143,
12142,
12141,
8693,
2530,
2529,
2535,
2539,
-1,
10199,
10198,
10197,
10196,
10195,
10194,
10193,
10192,
10191,
10190,
10189,
10188,
10187,
10186,
10185,
10184,
10183,
10182,
10181,
10180,
10179,
10178,
10177,
10176,
10175,
10174,
10227,
10225,
10206,
10204,
10223,
10220,
13637,
13636,
13635,
13634,
13633,
13632,
13631,
13630,
13629,
13628,
13627,
13626,
13625,
13624,
13623,
13622,
13621,
13620,
13619,
13618,
13617,
13616,
13615,
13614,
13613,
13612,
14293,
14292,
-1,
-1,
-1,
-1,
13603,
13602,
13601,
13600,
13599,
13598,
13597,
13596,
13595,
13594,
13593,
13592,
13591,
13590,
13589,
13588,
13587,
13586,
13585,
13584,
13583,
13582,
13581,
13580,
13579,
13578,
2549,
13607,
13606,
13605,
13609,
13604,
10239,
10171,
10170,
10218,
10226,
10216,
10215,
10224,
10205,
10222,
10221,
]

_charnames_127462 = [
14138,
14137,
14136,
14135,
14134,
14133,
14132,
14131,
14130,
14129,
14128,
14127,
14126,
14125,
14124,
14123,
14122,
14121,
14120,
14119,
14118,
14117,
14116,
14115,
14114,
14113,
10241,
10211,
10210,
]

_charnames_127504 = [
10137,
10129,
10126,
10212,
10163,
10120,
10168,
10119,
10162,
10149,
10157,
10143,
10116,
10127,
10132,
10142,
10117,
10154,
10153,
10167,
10130,
10122,
10147,
10135,
10145,
10161,
10160,
10169,
10128,
10164,
10125,
10146,
10166,
10136,
10156,
10155,
10123,
10148,
10139,
10140,
10152,
10115,
10131,
-1,
-1,
-1,
-1,
-1,
8681,
8692,
8691,
8688,
8686,
8683,
8685,
8689,
8682,
]

_charnames_127744 = [
2098,
14664,
2494,
13772,
10351,
10350,
2542,
10355,
14302,
5362,
14756,
7667,
9389,
3979,
3978,
3977,
11783,
13572,
14762,
14638,
14761,
14682,
14767,
6052,
14768,
2564,
13571,
14637,
6051,
14681,
10353,
11782,
10106,
]

_charnames_127792 = [
1863,
10594,
4009,
13987,
12181,
2440,
-1,
8758,
1861,
14283,
13446,
10356,
5464,
3983,
3982,
13397,
14656,
9554,
14625,
6643,
9721,
8705,
11391,
11651,
9204,
14759,
8418,
6641,
5192,
12279,
14161,
11640,
12252,
12253,
1862,
10519,
13256,
10608,
9205,
12260,
14254,
14255,
1642,
1232,
10522,
10544,
5367,
14692,
14287,
14048,
13080,
10359,
14691,
14642,
10496,
10095,
14465,
13903,
1641,
1872,
2374,
6718,
1237,
13423,
10105,
5496,
12268,
1640,
14661,
8573,
9916,
14792,
1647,
8713,
5503,
2499,
5197,
-1,
-1,
-1,
14256,
14796,
5506,
14593,
1871,
14627,
14633,
14634,
5110,
12176,
1632,
8419,
2550,
12280,
14590,
2428,
14793,
9002,
10612,
11652,
]

_charnames_127904 = [
2429,
14700,
14285,
14641,
9382,
9001,
2543,
13385,
11053,
8696,
2541,
8676,
2502,
12245,
7654,
14037,
10607,
5511,
11876,
5484,
14670,
9719,
9722,
9914,
11871,
9720,
8727,
7657,
9718,
14214,
8569,
10630,
5205,
1864,
10619,
14215,
10362,
-1,
8714,
13411,
11406,
14216,
10634,
]

_charnames_127968 = [
13416,
13415,
13079,
14587,
4007,
13424,
5186,
11389,
13419,
6712,
1636,
10611,
13988,
14621,
14466,
14591,
4008,
]

_charnames_128000 = [
14308,
8993,
13077,
14758,
1643,
8671,
6640,
14306,
2432,
14042,
2557,
14752,
10622,
10621,
13409,
14309,
11873,
10108,
8979,
14284,
1869,
13917,
12274,
5486,
3991,
13081,
10547,
5370,
11378,
13422,
6053,
14640,
8712,
5463,
8756,
13257,
5196,
14689,
5507,
12250,
12714,
12272,
14041,
5203,
13920,
8994,
1644,
8672,
14307,
2433,
14043,
10545,
13412,
8980,
13918,
12277,
14690,
13255,
14783,
5502,
12194,
12276,
12191,
-1,
4001,
-1,
3973,
13757,
8995,
8704,
14747,
14711,
14729,
14746,
14643,
14764,
13078,
8742,
8743,
2501,
13060,
2556,
14775,
4002,
13645,
8770,
14595,
14045,
12711,
5512,
14776,
12288,
13251,
12261,
9501,
11398,
13440,
14774,
14777,
14663,
5411,
5410,
5483,
11874,
9462,
14772,
14628,
9500,
8766,
8765,
12265,
14778,
5363,
12234,
9499,
9498,
12914,
12913,
5193,
1634,
12226,
14588,
14589,
11875,
5198,
4004,
11224,
14421,
10631,
14408,
11869,
14049,
6478,
13766,
14620,
13259,
5208,
10437,
12282,
12710,
6711,
14251,
11854,
12703,
5485,
1627,
14789,
5501,
5368,
8767,
10542,
11648,
13380,
5460,
11638,
14864,
12289,
13379,
14151,
13381,
14027,
3989,
11384,
5482,
10604,
1645,
10546,
14040,
14054,
12283,
14673,
14034,
10538,
8745,
14740,
13455,
8983,
1233,
13369,
2565,
5188,
5191,
5190,
5189,
8982,
1852,
10600,
12241,
5364,
9387,
14671,
13064,
14061,
14649,
13061,
12186,
12187,
2439,
8572,
2430,
1851,
1853,
5209,
2498,
12291,
14282,
12193,
10518,
8718,
5479,
6642,
13754,
13755,
2496,
13062,
11639,
5461,
13048,
5480,
13764,
10613,
9203,
8566,
12188,
14626,
9915,
12292,
1865,
13076,
14420,
12195,
4014,
14419,
3972,
2493,
2492,
13057,
13058,
12270,
12271,
13574,
8996,
8998,
7658,
8999,
13752,
11380,
2438,
-1,
7655,
8564,
14304,
7656,
-1,
-1,
-1,
8769,
2487,
2488,
2489,
11379,
6716,
13444,
10534,
10530,
10533,
10532,
5184,
3988,
6638,
14249,
6709,
2495,
12712,
6705,
13059,
5498,
5499,
5478,
6321,
14305,
5202,
3969,
13073,
10494,
8698,
13751,
12713,
14398,
14396,
14400,
14399,
14397,
14631,
3987,
14795,
13253,
13762,
13426,
12284,
9381,
8565,
2562,
10590,
14586,
8720,
5420,
14722,
6040,
6039,
6033,
6038,
10570,
10571,
14846,
13916,
14845,
13915,
-1,
-1,
2534,
2553,
2552,
13756,
]

_charnames_128336 = [
2482,
2449,
2455,
2469,
2472,
2462,
2465,
2479,
2485,
2458,
2476,
2452,
2481,
2448,
2454,
2468,
2471,
2461,
2464,
2478,
2484,
2457,
2475,
2451,
]

_charnames_128507 = [
8992,
8706,
10509,
10591,
9000,
11643,
11644,
14610,
10552,
10555,
10556,
10554,
10560,
10558,
14791,
10563,
14618,
14160,
10559,
10562,
10567,
13641,
4005,
14851,
14614,
12249,
1630,
1631,
12705,
14619,
12707,
12708,
14602,
14604,
14605,
14030,
14781,
11383,
12258,
2560,
12242,
14613,
14031,
14688,
11382,
14701,
14786,
10606,
8673,
11646,
6717,
14607,
13454,
14608,
14617,
11401,
14678,
10605,
14035,
14615,
14612,
11645,
2436,
10565,
10566,
2435,
12709,
12259,
2561,
14787,
-1,
-1,
-1,
-1,
14611,
14609,
12240,
10595,
13382,
10535,
13258,
12238,
12239,
12236,
12237,
]

_charnames_128640 = [
14286,
13396,
10523,
14303,
13438,
13439,
8725,
9196,
6479,
10510,
8723,
8724,
5408,
13070,
8715,
5412,
9388,
11407,
14635,
12263,
13069,
8420,
13068,
11388,
13071,
14158,
13983,
11054,
8726,
8978,
8989,
10358,
8990,
11307,
10101,
14281,
10537,
13406,
7644,
1635,
12264,
8719,
13919,
13745,
10572,
13749,
12290,
13921,
12267,
13758,
5510,
13748,
5509,
8991,
12254,
13750,
1868,
9202,
14779,
14156,
5195,
8707,
14757,
10104,
5182,
5183,
12192,
1236,
5210,
6624,
]

_charnames_128768 = [
11205,
11101,
11218,
11219,
11203,
11090,
11088,
11089,
11086,
11087,
11151,
11154,
11153,
11068,
11168,
11147,
11178,
11181,
11180,
11121,
11070,
11208,
11156,
11157,
11136,
11137,
11215,
11081,
11198,
11199,
11113,
11132,
11119,
11200,
11065,
11111,
11112,
11120,
11072,
11063,
11158,
11172,
11212,
11099,
11066,
11073,
11064,
11155,
11130,
11131,
11124,
11128,
11127,
11126,
11092,
11093,
11183,
11074,
11098,
11133,
11134,
11096,
11148,
11173,
11174,
11206,
11139,
11142,
11141,
11094,
11217,
11079,
11171,
11214,
11202,
11161,
11116,
11175,
11115,
11082,
11117,
11176,
11078,
11211,
11080,
11216,
11187,
11097,
11163,
11146,
11162,
11100,
11076,
11077,
11067,
11167,
11195,
11193,
11194,
11166,
11165,
11104,
11109,
11108,
11107,
11106,
11095,
11145,
11144,
11135,
11186,
11209,
11196,
11182,
11190,
11189,
]

_charnames_917760 = [
7097,
7086,
7075,
7230,
7219,
7208,
7197,
7186,
7241,
7252,
7251,
7250,
7249,
7329,
7328,
7327,
7326,
7325,
7324,
7323,
7322,
7321,
7320,
7318,
7317,
7316,
7315,
7314,
7313,
7312,
7311,
7310,
7309,
7307,
7306,
7305,
7304,
7303,
7302,
7301,
7300,
7299,
7298,
7296,
7295,
7294,
7293,
7292,
7291,
7290,
7289,
7288,
7287,
7285,
7284,
7283,
7282,
7281,
7280,
7279,
7278,
7277,
7276,
7274,
7273,
7272,
7271,
7270,
7269,
7268,
7267,
7266,
7265,
7263,
7262,
7261,
7260,
7259,
7258,
7257,
7256,
7255,
7254,
7184,
7183,
7182,
7181,
7180,
7179,
7178,
7177,
7176,
7175,
7173,
7172,
7171,
7170,
7169,
7168,
7167,
7166,
7165,
7164,
7162,
7161,
7160,
7159,
7158,
7157,
7156,
7155,
7154,
7153,
7151,
7150,
7149,
7148,
7147,
7146,
7145,
7144,
7143,
7142,
7140,
7139,
7138,
7137,
7136,
7135,
7134,
7133,
7132,
7131,
7129,
7128,
7127,
7126,
7125,
7124,
7123,
7122,
7121,
7120,
7118,
7117,
7116,
7115,
7114,
7113,
7112,
7111,
7110,
7109,
7107,
7106,
7105,
7104,
7103,
7102,
7101,
7100,
7099,
7098,
7096,
7095,
7094,
7093,
7092,
7091,
7090,
7089,
7088,
7087,
7085,
7084,
7083,
7082,
7081,
7080,
7079,
7078,
7077,
7076,
7240,
7239,
7238,
7237,
7236,
7235,
7234,
7233,
7232,
7231,
7229,
7228,
7227,
7226,
7225,
7224,
7223,
7222,
7221,
7220,
7218,
7217,
7216,
7215,
7214,
7213,
7212,
7211,
7210,
7209,
7207,
7206,
7205,
7204,
7203,
7202,
7201,
7200,
7199,
7198,
7196,
7195,
7194,
7193,
7192,
7191,
7190,
7189,
7188,
7187,
7248,
7247,
7246,
7245,
7244,
7243,
7242,
]

_charnames_983040 = [
13761,
13760,
10506,
10495,
10504,
10524,
3963,
3955,
3961,
3997,
3971,
3970,
11394,
11393,
11221,
5497,
5201,
5516,
1854,
13402,
13447,
8421,
6320,
13573,
3967,
6723,
13771,
3999,
6318,
7642,
7665,
14662,
14703,
2427,
2544,
10099,
6708,
10441,
10100,
6707,
10573,
14053,
14062,
13973,
14060,
13970,
14059,
13971,
14058,
13974,
14057,
13639,
13765,
10439,
10438,
3962,
3956,
2372,
2259,
3966,
3998,
10361,
10360,
3994,
3993,
14407,
14648,
14702,
14405,
11649,
11872,
14404,
14159,
14314,
14406,
14850,
14855,
10527,
13984,
13982,
12190,
12189,
13443,
13425,
5366,
5517,
13747,
13769,
14417,
14415,
13643,
13644,
10503,
10624,
3964,
3995,
1857,
13405,
13448,
1856,
13404,
13449,
6319,
7643,
7666,
12173,
12174,
12136,
12175,
12172,
12135,
14146,
14147,
14217,
10578,
10584,
10626,
10579,
10583,
10625,
13972,
14056,
12224,
12221,
12294,
12223,
12220,
12293,
10597,
10525,
2373,
2571,
9201,
9723,
10507,
10505,
10540,
3968,
3965,
4011,
10502,
10493,
10580,
10635,
10581,
10614,
1637,
2569,
10520,
10498,
13063,
13029,
12225,
12295,
11403,
11404,
13768,
10107,
5963,
5776,
2570,
10436,
12701,
6046,
6047,
6048,
6049,
8646,
14696,
14695,
14694,
9724,
14860,
14858,
14861,
6721,
14312,
6722,
14313,
12296,
6720,
14311,
13770,
9725,
14797,
14788,
9384,
9385,
14863,
12201,
7331,
7442,
7576,
7565,
7554,
7543,
7532,
7521,
7510,
7431,
7420,
7409,
7398,
7387,
7376,
7365,
5515,
5481,
14859,
5514,
7354,
7343,
7332,
7487,
7476,
7465,
7454,
7443,
7498,
7509,
7508,
7507,
7506,
7586,
7585,
7584,
7583,
7582,
7581,
7580,
7579,
7578,
7577,
7575,
7574,
7573,
7572,
7571,
7570,
7569,
7568,
7567,
7566,
7564,
7563,
7562,
7561,
7560,
7559,
7558,
7557,
7556,
7555,
7553,
7552,
7551,
7550,
7549,
7548,
7547,
7546,
7545,
7544,
7542,
7541,
7540,
7539,
7538,
7537,
7536,
7535,
7534,
7533,
7531,
7530,
7529,
7528,
7527,
7526,
7525,
7524,
7523,
7522,
7520,
7519,
7518,
7517,
7516,
7515,
7514,
7513,
7512,
7511,
7441,
7440,
7439,
7438,
7437,
7436,
7435,
7434,
7433,
7432,
7430,
7429,
7428,
7427,
7426,
7425,
7424,
7423,
7422,
7421,
7419,
7418,
7417,
7416,
7415,
7414,
7413,
7412,
7411,
7410,
7408,
7407,
7406,
7405,
7404,
7403,
7402,
7401,
7400,
7399,
7397,
7396,
7395,
7394,
7393,
7392,
7391,
7390,
7389,
7388,
7386,
7385,
7384,
7383,
7382,
7381,
7380,
7379,
7378,
7377,
7375,
7374,
7373,
7372,
7371,
7370,
7369,
7368,
7367,
7366,
7364,
7363,
7362,
7361,
7360,
7359,
7358,
7357,
7356,
7355,
7353,
7352,
7351,
7350,
7349,
7348,
7347,
7346,
7345,
7344,
7342,
7341,
7340,
7339,
7338,
7337,
7336,
7335,
7334,
7333,
7497,
7496,
7495,
7494,
7493,
7492,
7491,
7490,
7489,
7488,
7486,
7485,
7484,
7483,
7482,
7481,
7480,
7479,
7478,
7477,
7475,
7474,
7473,
7472,
7471,
7470,
7469,
7468,
7467,
7466,
7464,
7463,
7462,
7461,
7460,
7459,
7458,
7457,
7456,
7455,
7453,
7452,
7451,
7450,
7449,
7448,
7447,
7446,
7445,
7444,
7505,
7504,
7503,
7502,
7501,
7500,
7499,
]

_charnames_983552 = [
5856,
5626,
5819,
5556,
5821,
5558,
5822,
5559,
5830,
5567,
5831,
5568,
5876,
5609,
5604,
5720,
5909,
5653,
5911,
5655,
5912,
5656,
5901,
5589,
5893,
5672,
5854,
5623,
5853,
5622,
5825,
5562,
5824,
5561,
5828,
5565,
5827,
5564,
5603,
5602,
5875,
5607,
5874,
5606,
5978,
5788,
5918,
5683,
5953,
5731,
5882,
5638,
5897,
5676,
5896,
5675,
5894,
5673,
5892,
5671,
5633,
5664,
5665,
5528,
5529,
5596,
5597,
5748,
5749,
5491,
8002,
7991,
8010,
7990,
7999,
7988,
7998,
7987,
8006,
8007,
8004,
8000,
7995,
8005,
7997,
7996,
8001,
7989,
8008,
7994,
7993,
7992,
8009,
8003,
7833,
7838,
7839,
7834,
7835,
7840,
7841,
7832,
7836,
7837,
7831,
7716,
7721,
7722,
7717,
7718,
7723,
7724,
7715,
7719,
7720,
7714,
7976,
7981,
7982,
7977,
7978,
7983,
7984,
7975,
7979,
7980,
7974,
7703,
7708,
7709,
7704,
7705,
7710,
7711,
7702,
7706,
7707,
7701,
7847,
7852,
7853,
7848,
7849,
7854,
7855,
7846,
7850,
7851,
7845,
7690,
7695,
7696,
7691,
7692,
7697,
7698,
7689,
7693,
7694,
7688,
7859,
7864,
7865,
7860,
7861,
7866,
7867,
7858,
7862,
7863,
7857,
7728,
7733,
7734,
7729,
7730,
7735,
7736,
7727,
7731,
7732,
7726,
7924,
7929,
7930,
7925,
7926,
7931,
7932,
7923,
7927,
7928,
7922,
7937,
7942,
7943,
7938,
7939,
7944,
7945,
7936,
7940,
7941,
7935,
7898,
7903,
7904,
7899,
7900,
7905,
7906,
7897,
7901,
7902,
7896,
7885,
7890,
7891,
7886,
7887,
7892,
7893,
7884,
7888,
7889,
7883,
7807,
7812,
7813,
7808,
7809,
7814,
7815,
7806,
7810,
7811,
7805,
7911,
7916,
7917,
7912,
7913,
7918,
7919,
7910,
7914,
7915,
7909,
7783,
7788,
7789,
7784,
7785,
7790,
7791,
7782,
7786,
7787,
7781,
7795,
7800,
7801,
7796,
7797,
7802,
7803,
7794,
7798,
7799,
7793,
7873,
7878,
7879,
7874,
7875,
7880,
7881,
7872,
7876,
7877,
7871,
7678,
7683,
7684,
7679,
7680,
7685,
7686,
7677,
7681,
7682,
7676,
7950,
7955,
7956,
7951,
7952,
7957,
7958,
7949,
7953,
7954,
7948,
7742,
7747,
7748,
7743,
7744,
7749,
7750,
7741,
7745,
7746,
7740,
7756,
7761,
7762,
7757,
7758,
7763,
7764,
7755,
7759,
7760,
7754,
7768,
7773,
7774,
7769,
7770,
7775,
7776,
7767,
7771,
7772,
7766,
7963,
7968,
7969,
7964,
7965,
7970,
7971,
7962,
7966,
7967,
7961,
7818,
7821,
7826,
7827,
7822,
7823,
7828,
7829,
7820,
7824,
7825,
7819,
7751,
10589,
10588,
10587,
11843,
12394,
12392,
12393,
12391,
12387,
12400,
12398,
12399,
12397,
12385,
12415,
12378,
12414,
12377,
12388,
12383,
12381,
12382,
12380,
12386,
12421,
12408,
12409,
12407,
12419,
12416,
12418,
12411,
12417,
12403,
12402,
12404,
12420,
12412,
12430,
12426,
12423,
12424,
12427,
12429,
12431,
13434,
13432,
13430,
13433,
13431,
12684,
12682,
12680,
12683,
12681,
12691,
12688,
12689,
12690,
8935,
8929,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 5698
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 5535
    elif code == 687: res = 5536
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 893: res = _charnames_880[code-880]
    elif code == 975: res = 11599
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1298
    elif code == 1231: res = 1936
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1319: res = _charnames_1296[code-1296]
    elif code == 1423: res = 11055
    elif code == 1442: res = 13393
    elif code == 1466: res = 13390
    elif code == 1477: res = 13392
    elif code == 1478: res = 13391
    elif code == 1479: res = 13389
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 10876
    elif code == 1596: res = 10874
    elif code == 1597: res = 10842
    elif code == 1598: res = 10840
    elif code == 1599: res = 10841
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 10932
    elif code == 1775: res = 10866
    elif code == 1791: res = 10892
    elif code == 1837: res = 10435
    elif code == 1838: res = 10433
    elif code == 1839: res = 10434
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2142: res = _charnames_1984[code-1984]
    elif 2208 <= code <= 2220: res = _charnames_2208[code-2208]
    elif 2276 <= code <= 2308: res = _charnames_2276[code-2276]
    elif code == 2362: res = 13961
    elif code == 2363: res = 13960
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2431: res = _charnames_2417[code-2417]
    elif code == 2493: res = 5493
    elif code == 2510: res = 5492
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 11866
    elif code == 2677: res = 11864
    elif code == 2700: res = 11859
    elif code == 2785: res = 11860
    elif code == 2786: res = 11857
    elif code == 2787: res = 11858
    elif code == 2800: res = 11862
    elif code == 2801: res = 11861
    elif code == 2869: res = 13047
    elif code == 2884: res = 13044
    elif code == 2914: res = 13042
    elif code == 2915: res = 13043
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 8021
    elif code == 3024: res = 8018
    elif code == 3046: res = 8013
    elif 3059 <= code <= 3066: res = _charnames_3059[code-3059]
    elif code == 3133: res = 8559
    elif code == 3160: res = 8561
    elif code == 3161: res = 8562
    elif code == 3170: res = 8555
    elif code == 3171: res = 8556
    elif 3192 <= code <= 3199: res = _charnames_3192[code-3192]
    elif code == 3260: res = 12696
    elif code == 3261: res = 12698
    elif code == 3298: res = 12699
    elif code == 3299: res = 12700
    elif code == 3313: res = 12697
    elif code == 3314: res = 12695
    elif code == 3369: res = 9513
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif code == 3406: res = 9514
    elif code == 3426: res = 9516
    elif code == 3427: res = 9517
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif code == 3806: res = 6044
    elif code == 3807: res = 6043
    elif code == 3947: res = 8663
    elif code == 3948: res = 8662
    elif code == 3980: res = 8660
    elif code == 3981: res = 8656
    elif code == 3982: res = 8655
    elif code == 3983: res = 8657
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif 4345 <= code <= 4351: res = _charnames_4345[code-4345]
    elif code == 4442: res = 13249
    elif code == 4443: res = 13239
    elif code == 4444: res = 13241
    elif code == 4445: res = 13240
    elif code == 4446: res = 13223
    elif code == 4515: res = 13201
    elif code == 4516: res = 13185
    elif code == 4517: res = 13184
    elif code == 4518: res = 13188
    elif code == 4519: res = 13189
    elif code == 4602: res = 13145
    elif code == 4603: res = 13144
    elif code == 4604: res = 13148
    elif code == 4605: res = 13146
    elif code == 4606: res = 13147
    elif code == 4607: res = 13097
    elif code == 4615: res = 3935
    elif code == 4679: res = 3899
    elif code == 4743: res = 3889
    elif code == 4783: res = 3909
    elif code == 4815: res = 3931
    elif code == 4847: res = 3930
    elif code == 4879: res = 3809
    elif code == 4895: res = 3807
    elif code == 4935: res = 3867
    elif code == 4957: res = 3953
    elif code == 4958: res = 3954
    elif code == 4959: res = 3952
    elif code == 4960: res = 3936
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif code == 5120: res = 2370
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif code == 6109: res = 12373
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6829: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7295: res = _charnames_7164[code-7164]
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif 7376 <= code <= 7414: res = _charnames_7376[code-7376]
    elif 7424 <= code <= 7654: res = _charnames_7424[code-7424]
    elif code == 7676: res = 1336
    elif code == 7677: res = 1417
    elif code == 7678: res = 1375
    elif code == 7679: res = 1387
    elif code == 7836: res = 5691
    elif code == 7837: res = 5690
    elif code == 7838: res = 5905
    elif code == 7839: res = 5701
    elif code == 7930: res = 5951
    elif code == 7931: res = 5736
    elif code == 7932: res = 5950
    elif code == 7933: res = 5735
    elif code == 7934: res = 5970
    elif code == 7935: res = 5785
    elif 8275 <= code <= 8292: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8378: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1379
    elif code == 8428: res = 1392
    elif code == 8429: res = 1378
    elif code == 8430: res = 1376
    elif code == 8431: res = 1390
    elif code == 8432: res = 1413
    elif code == 8507: res = 14622
    elif code == 8508: res = 13902
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif code == 8580: res = 5646
    elif code == 8581: res = 14271
    elif code == 8582: res = 14270
    elif code == 8583: res = 14269
    elif code == 8584: res = 14272
    elif code == 8585: res = 7664
    elif 9167 <= code <= 9203: res = _charnames_9167[code-9167]
    elif code == 9471: res = 13638
    elif code == 9748: res = 14853
    elif code == 9749: res = 13420
    elif code == 9752: res = 10096
    elif code == 9854: res = 12244
    elif code == 9855: res = 14751
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 10543
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 13365
    elif code == 10080: res = 13366
    elif code == 10133: res = 13372
    elif code == 10134: res = 13374
    elif code == 10135: res = 13370
    elif code == 10160: res = 1234
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 9543
    elif code == 10221: res = 9539
    elif code == 10222: res = 9544
    elif code == 10223: res = 9540
    elif 11008 <= code <= 11097: res = _charnames_11008[code-11008]
    elif 11264 <= code <= 11623: res = _charnames_11264[code-11264]
    elif code == 11631: res = 8640
    elif code == 11632: res = 8639
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11835: res = _charnames_11680[code-11680]
    elif code == 12589: res = 5475
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 12168
    elif code == 12830: res = 12169
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 2538
    elif code == 12925: res = 2537
    elif code == 12926: res = 2540
    elif code == 13004: res = 10242
    elif code == 13005: res = 10245
    elif code == 13006: res = 10244
    elif code == 13007: res = 6412
    elif code == 13175: res = 10235
    elif code == 13176: res = 10237
    elif code == 13177: res = 10238
    elif code == 13178: res = 10247
    elif code == 13278: res = 10246
    elif code == 13279: res = 10250
    elif code == 13311: res = 10248
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42647: res = _charnames_42560[code-42560]
    elif 42655 <= code <= 42743: res = _charnames_42655[code-42655]
    elif 42752 <= code <= 42899: res = _charnames_42752[code-42752]
    elif 42912 <= code <= 42922: res = _charnames_42912[code-42912]
    elif 43000 <= code <= 43127: res = _charnames_43000[code-43000]
    elif 43136 <= code <= 43204: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43487: res = _charnames_43359[code-43359]
    elif 43520 <= code <= 43574: res = _charnames_43520[code-43520]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif 43739 <= code <= 43766: res = _charnames_43739[code-43739]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43822: res = _charnames_43808[code-43808]
    elif 43968 <= code <= 44025: res = _charnames_43968[code-43968]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif code == 64046: res = 2220
    elif code == 64047: res = 2219
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 10944
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif code == 65060: res = 1400
    elif code == 65061: res = 1399
    elif code == 65062: res = 1303
    elif code == 65095: res = 12205
    elif code == 65096: res = 12202
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65947: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66432 <= code <= 66517: res = _charnames_66432[code-66432]
    elif code == 66598: res = 13980
    elif code == 66599: res = 13981
    elif 66638 <= code <= 66729: res = _charnames_66638[code-66638]
    elif 67584 <= code <= 67679: res = _charnames_67584[code-67584]
    elif 67840 <= code <= 67903: res = _charnames_67840[code-67840]
    elif 67968 <= code <= 68031: res = _charnames_67968[code-67968]
    elif 68096 <= code <= 68167: res = _charnames_68096[code-68096]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68223: res = _charnames_68192[code-68192]
    elif 68352 <= code <= 68479: res = _charnames_68352[code-68352]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69760 <= code <= 69825: res = _charnames_69760[code-69760]
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 70016 <= code <= 70088: res = _charnames_70016[code-70016]
    elif 70096 <= code <= 70105: res = _charnames_70096[code-70096]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 73728 <= code <= 74606: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74850: res = _charnames_74752[code-74752]
    elif code == 74864: res = 1229
    elif code == 74865: res = 1228
    elif code == 74866: res = 1227
    elif code == 74867: res = 1226
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 110592: res = 12692
    elif code == 110593: res = 13435
    elif code == 119081: res = 9717
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119665: res = _charnames_119648[code-119648]
    elif code == 120001: res = 9551
    elif code == 120484: res = 9547
    elif code == 120485: res = 9546
    elif code == 120778: res = 9550
    elif code == 120779: res = 9549
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 10809
    elif code == 126705: res = 10810
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127199: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127386: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 2524
    elif code == 127569: res = 2525
    elif 127744 <= code <= 127776: res = _charnames_127744[code-127744]
    elif 127792 <= code <= 127891: res = _charnames_127792[code-127792]
    elif 127904 <= code <= 127946: res = _charnames_127904[code-127904]
    elif 127968 <= code <= 127984: res = _charnames_127968[code-127968]
    elif 128000 <= code <= 128323: res = _charnames_128000[code-128000]
    elif 128336 <= code <= 128359: res = _charnames_128336[code-128336]
    elif 128507 <= code <= 128591: res = _charnames_128507[code-128507]
    elif 128640 <= code <= 128709: res = _charnames_128640[code-128640]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983489: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983972: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdklddddmddddddddd\x15\x15\x15noddddddddddd\x15\x15\x15\x15pddddddddddd'
'dddddddddddddddddddddddddddddddddddddddd\x15\x15qddddrdddddddddddddddd'
'ddddddddddddddddddddddddddddddddddddddddddddddddsddddddddddddddd'
'ddddddddddddddddtuvwxyz{dddddddddddddddddddddd|d}~\x7f\x80\x81\x82\x83\x84dddddddd'
'\x85\x865555555\x87\x88\x8955555555555555555555555\x8a55555\x8b55555555555555555\x8c5555'
'5555555555555555555555555555555555\x8d55555555555555555555555555555'
'55555555555555555555555555555555555555\x8e5555555555555555\x8f\x90\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x8a5\x90\x91\x91\x91\x91\x92'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x92'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x93\x94dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xcd\x89\x89~\x9b~\x89\x8a\x93h\x89\xa8w^xw??????????x\x89\xb6\xb5\xb6\x89'
'\x8933333333333333333333333333\x93\x89h\xa2[\xa2\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x93\xb5h\xb5\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xca\x81\x9b\x9b\x97\x9b\xc6\x81\x9f\xc5(q\xb5\x07\xc2\xa2\xba\xaaLL\x9f\x17\x81\x83\x9fL(mRRR\x81'
'22222202222222220222222\xad0222220\x15\x15\x15\x17\x17\x17\x17\x15\x17\x15\x15\x15\x17\x15\x15\x17\x17\x15\x17\x15\x15\x17\x17\x17\xad\x15\x15\x15\x17\x15\x17\x15\x17'
'2\x152\x172\x172\x172\x172\x172\x172\x172\x152\x152\x172\x172\x172\x152\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x150\x152\x172\x17\x152\x172\x172\x170'
'\x150\x152\x152\x172\x15\x150\x152\x152\x172\x170\x152\x172\x172\x172\x172\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x172\x172\x172\x1722\x172\x172\x17\x17'
'\x1722\x172\x1722\x17222\x17\x172222\x1722\x17222\x17\x17\x1722\x1722\x172\x172\x1722\x172\x17\x172\x1722\x17222\x172\x1722\x17\x17+2\x17\x17\x17'
'++++2/\x172/\x172/\x172\x152\x152\x152\x152\x152\x152\x152\x15\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x172/\x172\x17222\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x1722\x1722\x17'
'\x172\x172222\x172\x172\x172\x172\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17+\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17         $$\x1f\x1f\x1f\x1f\x1f'
'  \xa1\xa1\x9f\xa1$"$"""$"$$\x1a\x1f\xa1\xa1\xa1\xa1\xa1\xa1\x9f\x9f\x9f\x9f\xa1\x9f\xa1\x9f     \xa1\xa1\xa1\xa1\xa1\xa1\xa1$\xa1\x1f\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888898888888888888888888888888888888888888888882\x172\x17$\xa12\x17\x11\x11\x1e\x17\x17\x17\x87\x11'
'\x11\x11\x11\x11\xa1\xa12\x88222\x112\x1122\x1700000000000000000\x11000000022\x17\x17\x17\x17\x17\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x17\x15\x15\x15\x15\x15\x15\x15\x17\x17\x17\x17\x172\x17\x17222\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x172\x17\xb22\x1722\x17\x17222'
'202222222222222200000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x17\xc0:::::662\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'22\x172\x172\x172\x172\x172\x172\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11222222222222222'
'22222222222222222222222\x11\x11\x1f\x80\x80\x80\x80\x80\x80\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x11\x80a\x11\x11\x11\x11\x9a\x11:::::::::::::::::::::::::::::::::::::::::::::c:'
'\x8d::\x8d::\x8d:\x11\x11\x11\x11\x11\x11\x11\x11...........................\x11\x11\x11\x11\x11...\x8d\x8e\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x06\x06\x06\x06\x06\x11\xb2\xb2\xa4}}\x96vr\xc5\xc5:::::::::::r\x11\x11rr''''''''''''''''''''''''''''''''"
"\x19'''''''''':::::::::::::::::::::<<<<<<<<<<}ssr'':'''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''r':::::::\x06\xc5::::::\x19\x19::\xc5::::''>>>>>>>>>>'''\xb9\xb9'"
"rrrrrrrrrrrrrr\x11\x05':''''''''''''''''''''''''''''''::::::::::::::::"
":::::::::::\x11\x11'''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''':::::::::::'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'AAAAAAAAAA.................................:::::::::%%\xc5\x87\x87\x87%\x11\x11\x11\x11\x11'
'......................::::%:::::::::%:::%:::::\x11\x11\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x11'
'.........................:::\x11\x11\x8d\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'\x11'''''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::::::::::::::::\x11'
':::4++++++++++++++++++++++++++++++++++++++++++++++++++++++:4:+44'
'4::::::::4444:44+:::::::++++++++++::\x80\x80@@@@@@@@@@\x80\x1f++++++\x11+++++++'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11+\x11\x11\x11++++\x11\x11:+44'
'4::::\x11\x1144\x11\x1144:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@++\x9a\x9aOOOOOO\xc0\x9a\x11\x11\x11\x11'
'\x11::4\x11++++++\x11\x11\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11++\x11++\x11\x11:\x1144'
'4::\x11\x11\x11\x11::\x11\x11:::\x11\x11\x11:\x11\x11\x11\x11\x11\x11\x11++++\x11+\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@::+++:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11::4\x11+++++++++\x11+++\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+44'
'4:::::\x11::4\x1144:\x11\x11+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x80\x9a\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+4:'
'4::::\x11\x1144\x11\x1144:\x11\x11\x11\x11\x11\x11\x11\x11:4\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@\xc0+OOOOOO\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11:+\x11++++++\x11\x11\x11+++\x11++++\x11\x11\x11++\x11+\x11++\x11\x11\x11++\x11\x11\x11+++\x11\x11\x11++++++++++++\x11\x11\x11\x1144'
':44\x11\x11\x11444\x11444:\x11\x11+\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@OOO\xc5\xc5\xc5\xc5\xc5\xc5\x9a\xc5\x11\x11\x11\x11\x11'
'\x11444\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11\x11+::'
':4444\x11:::\x11::::\x11\x11\x11\x11\x11\x11\x11::\x11++\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11TTTTTTT\xc0'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11:+47'
'44444\x11744\x1144::\x11\x11\x11\x11\x11\x11\x1144\x11\x11\x11\x11\x11\x11\x11+\x11++::\x11\x11@@@@@@@@@@\x11++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++++++++++++++++++++\x11\x11+44'
'4::::\x11444\x11444:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@OOOOOO\x11\x11\x11\xc0++++++'
'\x11\x1144\x11++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++\x11+++++++++\x11+\x11\x11'
'+++++++\x11\x11\x11:\x11\x11\x11\x11444:::\x11:\x1144444444\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x1144\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++++++++++++++++++++++++++++++++++++++++++++:+*:::::::\x11\x11\x11\x11\x9a'
'++++++\x1f::::::::\x80@@@@@@@@@@\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++\x11+\x11\x11++\x11+\x11\x11+\x11\x11\x11\x11\x11\x11++++\x11+++++++\x11+++\x11+\x11+\x11\x11++\x11++++:+*::::::\x11::+\x11\x11'
'+++++\x11\x1f\x11::::::\x11\x11@@@@@@@@@@\x11\x11++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+\xc0\xc0\xc0\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\xc0\x80\xc0\xc0\xc0::\xc0\xc0\xc0\xc0\xc0\xc0@@@@@@@@@@OOOOOOOOOO\xc0:\xc0:\xc0:\x92g\x92g44'
'++++++++\x11++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11::::::::::::::4'
':::::\x80::+++++:::::::::::\x11::::::::::::::::::::::::::::::::::::\x11\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0:\xc0\xc0\xc0\xc0\xc0\xc0\x11\xc0\xc0\x80\x80\x80\x80\x80\xc0\xc0\xc0\xc0\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++44::::4::::::4::44::+'
'@@@@@@@@@@\x80\x80\x80\x80\x80\x80++++++44::++++:::+444++4444444+++::::+++++++++++'
'++:44::444444:+4@@@@@@@@@@444:\xc0\xc022222222222222222222222222222222'
'222222\x112\x11\x11\x11\x11\x112\x11\x11+++++++++++++++++++++++++++++++++++++++++++\x80\x1f+++'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++\x11+\x11++++\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++++++++++++++++++++++++++++\x11++++\x11\x11+++++++\x11'
'+\x11++++\x11\x11+++++++++++++++\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11++++\x11\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++\x11\x11:::\x80\x80\x80\x80\x80\x80\x80\x80\x80PPPPPPPPPOOOOOOOOOOO\x11\x11\x11'
'++++++++++++++++\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'a+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++\x80\x80+++++++++++++++++'
'\xcc++++++++++++++++++++++++++\x92g\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++\x80\x80\x80DDD\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++\x11++++:::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++:::\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++\x11+++\x11::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++::4:::::::44'
'444444:44:::::::::::\x80\x80\x80\x1f\x80\x80\x80\x9a+:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11TTTTTTTTTT\x11\x11\x11\x11\x11\x11'
'\x87\x87\x87\x87\x87\x87a\x87\x87\x87\x87:::\xcc\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++\x1f++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++:+\x11\x11\x11\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11:::4444::444\x11\x11\x11\x1144:444444:::\x11\x11\x11\x11'
'\xc5\x11\x11\x11\x87\x87@@@@@@@@@@++++++++++++++++++++++++++++++\x11\x11+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x114444444444444444'
'4+++++++44\x11\x11\x11\x11\x11\x11@@@@@@@@@@P\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'+++++++++++++++++++++++::444\x11\x11\x80\x80++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++4:4:::::::\x11:4:44::::::::444444::::::::::\x11\x11:'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x80\x80\x80\x80\x80\x80\x80\x1f\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::::4+++++++++++++++++++++++++++++++++++++++++++++++:4:::::4:444'
'44:44+++++++\x11\x11\x11\x11@@@@@@@@@@\x80\x80\x80\x80\x80\x80\x80\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0:::::::::\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\x11'
'::4++++++++++++++++++++++++++++++4::::44::4:44++@@@@@@@@@@++++++'
'++++++++++++++++++++++++++++++++++++++:4::444:4:::44\x11\x11\x11\x11\x11\x11\x11\x11\x80\x80\x80\x80'
'++++++++++++++++++++++++++++++++++++44444444::::::::44::\x11\x11\x11\x80\x80\x80\x80\x80'
'@@@@@@@@@@\x11\x11\x11+++@@@@@@@@@@++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x80\x80'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x80\x80\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11:::\x80:::::::::::::4:::::::++++:++++44:++\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                    '
'                                           \x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17 \x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                                     '
':::::::::::::::::::::::::::::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x1722222222'
'\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x17\x112\x112\x112\x112\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x11\x17\x172222/\xa1\x17\xa1'
'\xa1\xa1\x17\x17\x17\x11\x17\x172222/\xa1\xa1\xa1\x17\x17\x17\x17\x11\x11\x17\x172222\x11\xa1\xa1\xa1\x17\x17\x17\x17\x17\x17\x17\x1722222\xa1\xa1\xa1\x11\x11\x17\x17\x17\x11\x17\x172222/\xa1\xa1\x11'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x08\x08\x08\t\x0e`aa```\x81\x87ol\x91pnk\x91p\x81\x81\x81\x87\x82\x81\x81\x82\xc8\xc9\n\x0f\r\x0b\x10\xca{}{{}\x81\x87\x87\x87qm\x81\x87\x87\x81Z'
'Z\x87\x87\x87\xa5\x92g\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\xb2\x87Z\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\xcc\x08\x08\x08\x08\x08\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08M \x11\x11LMMMMM\xa7\xa7\xb2\x92g\x1b'
'MLLLLMMMMM\xa7\xa7\xb2\x92g\x11             \x11\x11\x11\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x99\x9a\x9a\x97\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::6666:666::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc52\xc2\xc5\xc2\xc52\xc5\xc2\x17222\x17\x17222\x15\xc52\xc2\xc5\xb422222\xc5\xc5\xc5\xc2\xc2\xc52\xc50\xc52\xc52022\xbc\x172222\x17++++\x17\xc5\xc5\x17\x1722'
'\xb3\xb2\xb2\xb2\xb22\x17\x17\x17\x17\xc5\xb2\xc5\xc5\x17\xc0TTTRRTTTTTTRRRRTBBBBBBBBBBBBEEEECCCCCCCCCCFFFFFF'
'DDD2\x17DDDDR\x11\x11\x11\x11\x11\x11\xad\xad\xad\xad\xad\xc2\xc2\xc2\xc2\xc2\xb2\xb2\xc5\xc5\xc5\xc5\xb2\xc5\xc5\xb2\xc5\xc5\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xc5\xc5\xad\xc5\xad\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xad\xb3\xae\xae\xb3\xb2\xb2\xad\xae\xb3\xb3\xae\xb3\xb3\xb2\xad\xb2\xae\xa7\xab\xb2\xae\xb3\xb2\xb2\xb2\xae\xb3\xb3\xae\xad\xae\xae\xb3\xb3\xad\xb3\xad\xb3\xad\xad\xad\xad\xae\xae\xb3\xae\xb3\xb3\xb3\xb3\xb3\xad\xad\xad\xad\xb2\xb3\xb2\xb3\xae\xae\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xae\xb3\xb3\xb3\xae\xb2\xb2\xb2\xb2\xb2\xae\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xae\xad\xb3\xb2\xae\xae\xae\xae\xb3\xb3\xae\xae\xb2\xb2\xae\xae\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xae\xae\xb3\xb3\xae\xae\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xad\xb2\xb2\xb3\xad\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xad\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xae'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb3\xb3\xb3\xb3\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb3\xb3\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x95j\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc5\xb2\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc0\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11SSSSSSSSSRRRRRRRRRRRSSSSSSSSSRRR'
'RRRRRRRRLLLLLLLLLKKKKKKKKKKK\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbfURRRRRRRRRRSSSSSSSSSRS'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc2\xad\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5'
'\xc2\xad\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc5\xc5\xc2\xc5\xc5\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc2\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc2\xc2\xc2\xc5\xc2\xc2\xc2\xc2\xc5\xc2\xc2\xc5\xad\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc0\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2'
'\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x92g\x92g\x92g\x92g\x92g\x92g\x92gSSSSSSSSSR'
'UUUUUUUUUTUUUUUUUUUT\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xb3\xb2\xb2\xb3\xb3\x92g\xb2\xb3\xb3\xb2\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb2\xb2\xb2\xb3\xb3\xb3\xb3\x93h\x93h\x93h\x93h\x92g\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\x92g\x93h\x92g\x92g\x92g\x92g\x92g\x92g\x92g\x92g\x92g\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb2\xb2\x92g\x92g\xb3\xb2\xb2\xb2\xb2\xb3\xb2\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\x92g\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb2\xb3\xb2\xb2\xb3\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb2\xb3\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb2\xb2'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222222222222222222222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x112\x17222\x17\x172\x172\x172\x172222\x172\x17\x172\x17\x17\x17\x17\x17\x17  22'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\xc5\xc5\xc5\xc5\xc5\xc52\x172\x17:::2\x17\x11\x11\x11\x11\x11\x87\x87\x87\x87T\x87\x87'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x17\x11\x11\x11\x11\x11\x17\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x1f\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:'
'+++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11+++++++\x11+++++++\x11'
'+++++++\x11+++++++\x11+++++++\x11+++++++\x11::::::::::::::::::::::::::::::::'
'\x87\x87qmqm\x87\x87\x87qm\x87qm\x87\x87\x87\x87\x87\x87\x87\x87\x87a\x87\x87a\x87qm\x87\x87qm\x92g\x92g\x92g\x92g\x87\x87\x87\x87\x87#\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87aa\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11'
'\xcb\x8b\x8b\x8b\xc7!,G\x95j\x95j\x95j\x95j\x95j\xc7\xc7\x95j\x95j\x95j\x95jb\x94ii\xc7GGGGGGGGG;;;;55b!!!!!\xc7\xc7GGG!,\x8b\xc7\xc5'
'\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x11\x11;;\xa3\xa3!!,b,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x8b!!!,'
'\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,\x11\xc1\xc1QQQQ\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\x11QQQQQQQQQQ\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1NNNNNNNN\xc7VVVVVVVVVVVVVVV\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc7\xc1'
'QQQQQQQQQQ\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1VVVVVVVVVVVVVVV'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc7\xc7\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc7\xc7\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7'
',,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'-,,-,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-'
'-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,-,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',-,---,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',----,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,--'
',,,,,,,,,,,,---,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,-,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x11\x11\x11\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x80\x80'
'++++++++++++\x1f\x87\x87\x87++++++++++++++++@@@@@@@@@@++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17+:666\x87::::::::::\x87$'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11:++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++DDDDDDDDDD::\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11'
'\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1$$$$$$$$$\xa1\xa12\x172\x172\x172\x172\x172\x172\x17\x17\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17 \x17\x17\x17\x17\x17\x17\x17\x172\x172\x1722\x17'
'2\x172\x172\x172\x17$\x9e\x9e2\x172\x17\x112\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x112\x172\x172\x172\x172\x172\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11  \x17+++++'
'++:+++:++++:+++++++++++++++++++++++44::4\xc5\xc5\xc5\xc5\x11\x11\x11\x11OOOOOO\xc0\xc0\x9a\xbb\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++\x87\x87\x87\x87\x11\x11\x11\x11\x11\x11\x11\x11'
'44++++++++++++++++++++++++++++++++++++++++++++++++++444444444444'
'4444:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x80\x80@@@@@@@@@@\x11\x11\x11\x11\x11\x11::::::::::::::::::++++++\x80\x80\x80+\x11\x11\x11\x11'
'@@@@@@@@@@++++++++++++++++++++++++++++::::::::\x80\x80++++++++++++++++'
'+++++++:::::::::::44\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x80,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11'
':::4+++++++++++++++++++++++++++++++++++++++++++++++:44::::44:444'
'4\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x11\x1f@@@@@@@@@@\x11\x11\x11\x11\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++::::::44::44::\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++:++++++++:4\x11\x11@@@@@@@@@@\x11\x11\x80\x80\x80\x80++++++++++++++++\x1f++++++\xc0\xc0\xc0+4\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++:+:::++::+++++::'
'+:+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++\x1f\x80\x80+++++++++++4::44\x80\x80+\x1f\x1f4:\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++\x11\x11++++++\x11\x11++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++44:44:44\x804:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++'
'+++++++\x11\x11\x11\x11+++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x17\x17\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11.:..........\xa7.............\x11.....\x11.\x11'
"..\x11..\x11..........''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d"
"\x9d\x9d\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''&&&&&&''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x91f"
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''\x11\x11''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''&&\x96\xc5\x11\x11"
'8888888888888888\x8b\x8b\x8b\x8c\x8b\x8b\x8b\x94i\x8b\x11\x11\x11\x11\x11\x11:::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x8bbb\\\\\x94i\x94i\x94i\x94i\x94i\x94'
"i\x94i\x94i\x8b\x8b\x94i\x8b\x8b\x8b\x8b\\\\\\y\x8bz\x11\x8bz\x8b\x8bb\x95j\x95j\x95j\x7f\x8b\x8b\xa9_\xb8\xb8\xb7\x11\x8b\x9c\x7f\x8b\x11\x11\x11\x11&'&'&\x11&'&'&'&'&'"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x11\x11\x08"
'\x11\x84\x84|\x98|\x84\x85\x8fd\x84\xa6t]ut==========u\x84\xb0\xaf\xb0\x84\x8411111111111111111111111111\x8f\x84d\xa0Y'
'\xa0\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x8f\xafd\xaf\x8fd\x86\x90e\x86\x86))))))))))\x1d)))))))))))))))'
'))))))))))))))))))))))))))))))\x1c\x1c)))))))))))))))))))))))))))))))\x11'
'\x11\x11))))))\x11\x11))))))\x11\x11))))))\x11\x11)))\x11\x11\x11\x98\x98\xaf\xa0\xc3\x98\x98\x11\xc4\xb1\xb1\xb1\xb1\xc4\xc4\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x0c\x0c\x0c\xc5\xc2\x11\x11'
'++++++++++++\x11++++++++++++++++++++++++++\x11+++++++++++++++++++\x11++\x11+'
'++++++++++++++\x11\x11++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11'
'\x80\x87\x80\x11\x11\x11\x11OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\x11\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHTTTT\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5T\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0:\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++\x11OOOO\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++'
'+D++++++++D\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++\x11\x80++++++++++++++++++++++++++++++++'
'++++\x11\x11\x11\x11++++++++\x80DDDDD\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2222222222222222222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......\x11\x11.\x11............................................\x11..\x11\x11\x11.\x11\x11.'
'......................\x11\x8dWWWWWWWW\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................WWWWWW\x11\x11\x11\x87..........................\x11\x11\x11\x11\x11\x8d'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'........................................................\x11\x11\x11\x11\x11\x11..'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'.:::\x11::\x11\x11\x11\x11\x11::::....\x11...\x11...........................\x11\x11\x11\x11:::\x11\x11\x11\x11:'
'XXXXWWWW\x11\x11\x11\x11\x11\x11\x11\x11\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x11\x11\x11\x11\x11\x11\x11.............................WW\x8d'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................................................\x11\x11\x11\x87\x87\x87\x87\x87\x87\x87'
'......................\x11\x11WWWWWWWW...................\x11\x11\x11\x11\x11WWWWWWWW'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'................................................................'
'.........\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11JJJJJJJJJIIIIIIIIIIIIIIIIIIIIII\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'4:4+++++++++++++++++++++++++++++++++++++++++++++++++++++::::::::'
':::::::\x80\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11UUUUUUUUUTTTTTTTTTTT@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4+++++++++++++++++++++++++++++++++++++++++++++444::::44::\x80\x80\t\x80\x80'
'\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
':::++++++++++++++++++++++++++++++++++++:::::4::::::::\x11@@@@@@@@@@'
'\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4++++++++++++++++++++++++++++++++++++++++++++++++444:::::::::4'
'4++++\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++:4:44::::::4:\x11\x11\x11\x11\x11\x11\x11\x11'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD'
'DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+4444444444444444444444444444444444444444444444\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc044:::\xc0\xc0\xc0444444\x08\x08\x08\x08\x08\x08\x08\x08:::::'
':::\xc0\xc0:::::::\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0::::\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5:::\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11OOOOOOOOOOOOOOOOOO\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222'
'22222222222222\x17\x17\x17\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222222222222222'
'22\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x1122\x11\x112\x11\x1122\x11\x112222\x1122222222\x17\x17\x17\x17\x11\x17\x11\x17\x17\x17'
'\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x1722\x112222\x11\x1122222222\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722\x112222\x11'
'22222\x112\x11\x11\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222'
'222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222'
'2222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222222222222222'
'2222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11222222222222222222222222'
'2\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172\x17\x11\x11>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
"''''\x11'''''''''''''''''''''''''''\x11''\x11'\x11\x11'\x11''''''''''\x11''''\x11'\x11'\x11\x11\x11\x11"
"\x11\x11'\x11\x11\x11\x11'\x11'\x11'\x11'''\x11''\x11'\x11\x11'\x11'\x11'\x11'\x11'\x11''\x11'\x11\x11''''\x11'''''''\x11''''\x11''''\x11'\x11"
"''''''''''\x11'''''''''''''''''\x11\x11\x11\x11\x11'''\x11'''''\x11'''''''''''''''''\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xb2\xb2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11'
'\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'LLLLLLLLLLL\x11\x11\x11\x11\x11\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc0\x11\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc5\xc5\x11\x11\x11\x11\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11'
'\xc5\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11'
'\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,-,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x11\x11'
'\x11\x08\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'888888888888888888888888888888888888888888888888\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x11\x11'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
}

_decimal_corrected = {
178: None,
179: None,
185: None,
4969: None,
4970: None,
4971: None,
4972: None,
4973: None,
4974: None,
4975: None,
4976: None,
4977: None,
8304: None,
8308: None,
8309: None,
8310: None,
8311: None,
8312: None,
8313: None,
8320: None,
8321: None,
8322: None,
8323: None,
8324: None,
8325: None,
8326: None,
8327: None,
8328: None,
8329: None,
}
_digit = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6618: 1,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
9471: 0,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
68160: 1,
68161: 2,
68162: 3,
68163: 4,
69216: 1,
69217: 2,
69218: 3,
69219: 4,
69220: 5,
69221: 6,
69222: 7,
69223: 8,
69224: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
127232: 0,
127233: 0,
127234: 1,
127235: 2,
127236: 3,
127237: 4,
127238: 5,
127239: 6,
127240: 7,
127241: 8,
127242: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
1984: 0.0,
1985: 1.0,
1986: 2.0,
1987: 3.0,
1988: 4.0,
1989: 5.0,
1990: 6.0,
1991: 7.0,
1992: 8.0,
1993: 9.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3046: 0.0,
3192: 0.0,
3193: 1.0,
3194: 2.0,
3195: 3.0,
3196: 1.0,
3197: 2.0,
3198: 3.0,
3440: 10.0,
3441: 100.0,
3442: 1000.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
4240: 0.0,
4241: 1.0,
4242: 2.0,
4243: 3.0,
4244: 4.0,
4245: 5.0,
4246: 6.0,
4247: 7.0,
4248: 8.0,
4249: 9.0,
6128: 0.0,
6129: 1.0,
6130: 2.0,
6131: 3.0,
6132: 4.0,
6133: 5.0,
6134: 6.0,
6135: 7.0,
6136: 8.0,
6137: 9.0,
6470: 0.0,
6471: 1.0,
6472: 2.0,
6473: 3.0,
6474: 4.0,
6475: 5.0,
6476: 6.0,
6477: 7.0,
6478: 8.0,
6479: 9.0,
6608: 0.0,
6609: 1.0,
6610: 2.0,
6611: 3.0,
6612: 4.0,
6613: 5.0,
6614: 6.0,
6615: 7.0,
6616: 8.0,
6617: 9.0,
6618: 1.0,
6784: 0.0,
6785: 1.0,
6786: 2.0,
6787: 3.0,
6788: 4.0,
6789: 5.0,
6790: 6.0,
6791: 7.0,
6792: 8.0,
6793: 9.0,
6800: 0.0,
6801: 1.0,
6802: 2.0,
6803: 3.0,
6804: 4.0,
6805: 5.0,
6806: 6.0,
6807: 7.0,
6808: 8.0,
6809: 9.0,
6992: 0.0,
6993: 1.0,
6994: 2.0,
6995: 3.0,
6996: 4.0,
6997: 5.0,
6998: 6.0,
6999: 7.0,
7000: 8.0,
7001: 9.0,
7088: 0.0,
7089: 1.0,
7090: 2.0,
7091: 3.0,
7092: 4.0,
7093: 5.0,
7094: 6.0,
7095: 7.0,
7096: 8.0,
7097: 9.0,
7232: 0.0,
7233: 1.0,
7234: 2.0,
7235: 3.0,
7236: 4.0,
7237: 5.0,
7238: 6.0,
7239: 7.0,
7240: 8.0,
7241: 9.0,
7248: 0.0,
7249: 1.0,
7250: 2.0,
7251: 3.0,
7252: 4.0,
7253: 5.0,
7254: 6.0,
7255: 7.0,
7256: 8.0,
7257: 9.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
8581: 6.0,
8582: 50.0,
8583: 50000.0,
8584: 100000.0,
8585: 0.0,
9471: 0.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
13317: 5.0,
13443: 2.0,
14378: 5.0,
15181: 7.0,
20118: 4.0,
20160: 10.0,
20200: 3.0,
21316: 20.0,
21324: 40.0,
21444: 3.0,
24186: 1.0,
24318: 9.0,
28422: 7.0,
36019: 2.0,
38433: 1000.0,
42528: 0.0,
42529: 1.0,
42530: 2.0,
42531: 3.0,
42532: 4.0,
42533: 5.0,
42534: 6.0,
42535: 7.0,
42536: 8.0,
42537: 9.0,
42726: 1.0,
42727: 2.0,
42728: 3.0,
42729: 4.0,
42730: 5.0,
42731: 6.0,
42732: 7.0,
42733: 8.0,
42734: 9.0,
42735: 0.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43216: 0.0,
43217: 1.0,
43218: 2.0,
43219: 3.0,
43220: 4.0,
43221: 5.0,
43222: 6.0,
43223: 7.0,
43224: 8.0,
43225: 9.0,
43264: 0.0,
43265: 1.0,
43266: 2.0,
43267: 3.0,
43268: 4.0,
43269: 5.0,
43270: 6.0,
43271: 7.0,
43272: 8.0,
43273: 9.0,
43472: 0.0,
43473: 1.0,
43474: 2.0,
43475: 3.0,
43476: 4.0,
43477: 5.0,
43478: 6.0,
43479: 7.0,
43480: 8.0,
43481: 9.0,
43600: 0.0,
43601: 1.0,
43602: 2.0,
43603: 3.0,
43604: 4.0,
43605: 5.0,
43606: 6.0,
43607: 7.0,
43608: 8.0,
43609: 9.0,
44016: 0.0,
44017: 1.0,
44018: 2.0,
44019: 3.0,
44020: 4.0,
44021: 5.0,
44022: 6.0,
44023: 7.0,
44024: 8.0,
44025: 9.0,
63851: 3.0,
63859: 10.0,
63864: 2.0,
63922: 0.0,
63953: 6.0,
63955: 6.0,
63997: 10.0,
65799: 1.0,
65800: 2.0,
65801: 3.0,
65802: 4.0,
65803: 5.0,
65804: 6.0,
65805: 7.0,
65806: 8.0,
65807: 9.0,
65808: 10.0,
65809: 20.0,
65810: 30.0,
65811: 40.0,
65812: 50.0,
65813: 60.0,
65814: 70.0,
65815: 80.0,
65816: 90.0,
65817: 100.0,
65818: 200.0,
65819: 300.0,
65820: 400.0,
65821: 500.0,
65822: 600.0,
65823: 700.0,
65824: 800.0,
65825: 900.0,
65826: 1000.0,
65827: 2000.0,
65828: 3000.0,
65829: 4000.0,
65830: 5000.0,
65831: 6000.0,
65832: 7000.0,
65833: 8000.0,
65834: 9000.0,
65835: 10000.0,
65836: 20000.0,
65837: 30000.0,
65838: 40000.0,
65839: 50000.0,
65840: 60000.0,
65841: 70000.0,
65842: 80000.0,
65843: 90000.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65858: 1.0,
65859: 5.0,
65860: 50.0,
65861: 500.0,
65862: 5000.0,
65863: 50000.0,
65864: 5.0,
65865: 10.0,
65866: 50.0,
65867: 100.0,
65868: 500.0,
65869: 1000.0,
65870: 5000.0,
65871: 5.0,
65872: 10.0,
65873: 50.0,
65874: 100.0,
65875: 500.0,
65876: 1000.0,
65877: 10000.0,
65878: 50000.0,
65879: 10.0,
65880: 1.0,
65881: 1.0,
65882: 1.0,
65883: 2.0,
65884: 2.0,
65885: 2.0,
65886: 2.0,
65887: 5.0,
65888: 10.0,
65889: 10.0,
65890: 10.0,
65891: 10.0,
65892: 10.0,
65893: 30.0,
65894: 50.0,
65895: 50.0,
65896: 50.0,
65897: 50.0,
65898: 100.0,
65899: 300.0,
65900: 500.0,
65901: 500.0,
65902: 500.0,
65903: 500.0,
65904: 500.0,
65905: 1000.0,
65906: 5000.0,
65907: 5.0,
65908: 50.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65930: 0.0,
66369: 90.0,
66378: 900.0,
66513: 1.0,
66514: 2.0,
66515: 10.0,
66516: 20.0,
66517: 100.0,
66720: 0.0,
66721: 1.0,
66722: 2.0,
66723: 3.0,
66724: 4.0,
66725: 5.0,
66726: 6.0,
66727: 7.0,
66728: 8.0,
66729: 9.0,
67672: 1.0,
67673: 2.0,
67674: 3.0,
67675: 10.0,
67676: 20.0,
67677: 100.0,
67678: 1000.0,
67679: 10000.0,
67862: 1.0,
67863: 10.0,
67864: 20.0,
67865: 100.0,
67866: 2.0,
67867: 3.0,
68160: 1.0,
68161: 2.0,
68162: 3.0,
68163: 4.0,
68164: 10.0,
68165: 20.0,
68166: 100.0,
68167: 1000.0,
68221: 1.0,
68222: 50.0,
68440: 1.0,
68441: 2.0,
68442: 3.0,
68443: 4.0,
68444: 10.0,
68445: 20.0,
68446: 100.0,
68447: 1000.0,
68472: 1.0,
68473: 2.0,
68474: 3.0,
68475: 4.0,
68476: 10.0,
68477: 20.0,
68478: 100.0,
68479: 1000.0,
69216: 1.0,
69217: 2.0,
69218: 3.0,
69219: 4.0,
69220: 5.0,
69221: 6.0,
69222: 7.0,
69223: 8.0,
69224: 9.0,
69225: 10.0,
69226: 20.0,
69227: 30.0,
69228: 40.0,
69229: 50.0,
69230: 60.0,
69231: 70.0,
69232: 80.0,
69233: 90.0,
69234: 100.0,
69235: 200.0,
69236: 300.0,
69237: 400.0,
69238: 500.0,
69239: 600.0,
69240: 700.0,
69241: 800.0,
69242: 900.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
74752: 2.0,
74753: 3.0,
74754: 4.0,
74755: 5.0,
74756: 6.0,
74757: 7.0,
74758: 8.0,
74759: 9.0,
74760: 3.0,
74761: 4.0,
74762: 5.0,
74763: 6.0,
74764: 7.0,
74765: 8.0,
74766: 9.0,
74767: 4.0,
74768: 5.0,
74769: 6.0,
74770: 7.0,
74771: 8.0,
74772: 9.0,
74773: 1.0,
74774: 2.0,
74775: 3.0,
74776: 4.0,
74777: 5.0,
74778: 6.0,
74779: 7.0,
74780: 8.0,
74781: 9.0,
74782: 1.0,
74783: 2.0,
74784: 3.0,
74785: 4.0,
74786: 5.0,
74787: 2.0,
74788: 3.0,
74789: 3.0,
74790: 4.0,
74791: 5.0,
74792: 6.0,
74793: 7.0,
74794: 8.0,
74795: 9.0,
74796: 1.0,
74797: 2.0,
74798: 3.0,
74799: 3.0,
74800: 4.0,
74801: 5.0,
74802: 216000.0,
74803: 432000.0,
74804: 1.0,
74805: 2.0,
74806: 3.0,
74807: 3.0,
74808: 4.0,
74809: 5.0,
74810: 3.0,
74811: 3.0,
74812: 4.0,
74813: 4.0,
74814: 4.0,
74815: 4.0,
74816: 6.0,
74817: 7.0,
74818: 7.0,
74819: 7.0,
74820: 8.0,
74821: 8.0,
74822: 9.0,
74823: 9.0,
74824: 9.0,
74825: 9.0,
74826: 2.0,
74827: 3.0,
74828: 4.0,
74829: 5.0,
74830: 6.0,
74831: 1.0,
74832: 2.0,
74833: 3.0,
74834: 4.0,
74835: 4.0,
74836: 5.0,
74837: 5.0,
74838: -1.0,
74839: -1.0,
74840: 1.0,
74841: 2.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
119648: 1.0,
119649: 2.0,
119650: 3.0,
119651: 4.0,
119652: 5.0,
119653: 6.0,
119654: 7.0,
119655: 8.0,
119656: 9.0,
119657: 10.0,
119658: 20.0,
119659: 30.0,
119660: 40.0,
119661: 50.0,
119662: 60.0,
119663: 70.0,
119664: 80.0,
119665: 90.0,
127232: 0.0,
127233: 0.0,
127234: 1.0,
127235: 2.0,
127236: 3.0,
127237: 4.0,
127238: 5.0,
127239: 6.0,
127240: 7.0,
127241: 8.0,
127242: 9.0,
131073: 7.0,
131172: 4.0,
131298: 4.0,
131361: 5.0,
133418: 1.0,
133507: 30.0,
133516: 40.0,
133532: 40.0,
133866: 6.0,
133885: 3.0,
133913: 3.0,
140176: 2.0,
141720: 3.0,
146203: 3.0,
156269: 4.0,
194704: 9.0,
}

_numeric_corrected = {
20140: None,
22419: None,
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
384: 579,
410: 573,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
613: 42893,
614: 42922,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11507: 11506,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
11559: 4295,
11565: 4301,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
66638: 66598,
66639: 66599,
}

_toupper_corrected = {
}
_tolower = {
570: 11365,
571: 572,
573: 410,
574: 11366,
577: 578,
579: 384,
580: 649,
581: 652,
582: 583,
584: 585,
586: 587,
588: 589,
590: 591,
880: 881,
882: 883,
886: 887,
975: 983,
1015: 1016,
1017: 1010,
1018: 1019,
1021: 891,
1022: 892,
1023: 893,
1216: 1231,
1270: 1271,
1274: 1275,
1276: 1277,
1278: 1279,
1296: 1297,
1298: 1299,
1300: 1301,
1302: 1303,
1304: 1305,
1306: 1307,
1308: 1309,
1310: 1311,
1312: 1313,
1314: 1315,
1316: 1317,
1318: 1319,
4256: 11520,
4257: 11521,
4258: 11522,
4259: 11523,
4260: 11524,
4261: 11525,
4262: 11526,
4263: 11527,
4264: 11528,
4265: 11529,
4266: 11530,
4267: 11531,
4268: 11532,
4269: 11533,
4270: 11534,
4271: 11535,
4272: 11536,
4273: 11537,
4274: 11538,
4275: 11539,
4276: 11540,
4277: 11541,
4278: 11542,
4279: 11543,
4280: 11544,
4281: 11545,
4282: 11546,
4283: 11547,
4284: 11548,
4285: 11549,
4286: 11550,
4287: 11551,
4288: 11552,
4289: 11553,
4290: 11554,
4291: 11555,
4292: 11556,
4293: 11557,
4295: 11559,
4301: 11565,
7838: 223,
7930: 7931,
7932: 7933,
7934: 7935,
8498: 8526,
8579: 8580,
11264: 11312,
11265: 11313,
11266: 11314,
11267: 11315,
11268: 11316,
11269: 11317,
11270: 11318,
11271: 11319,
11272: 11320,
11273: 11321,
11274: 11322,
11275: 11323,
11276: 11324,
11277: 11325,
11278: 11326,
11279: 11327,
11280: 11328,
11281: 11329,
11282: 11330,
11283: 11331,
11284: 11332,
11285: 11333,
11286: 11334,
11287: 11335,
11288: 11336,
11289: 11337,
11290: 11338,
11291: 11339,
11292: 11340,
11293: 11341,
11294: 11342,
11295: 11343,
11296: 11344,
11297: 11345,
11298: 11346,
11299: 11347,
11300: 11348,
11301: 11349,
11302: 11350,
11303: 11351,
11304: 11352,
11305: 11353,
11306: 11354,
11307: 11355,
11308: 11356,
11309: 11357,
11310: 11358,
11360: 11361,
11362: 619,
11363: 7549,
11364: 637,
11367: 11368,
11369: 11370,
11371: 11372,
11373: 593,
11374: 625,
11375: 592,
11376: 594,
11378: 11379,
11381: 11382,
11390: 575,
11391: 576,
11392: 11393,
11394: 11395,
11396: 11397,
11398: 11399,
11400: 11401,
11402: 11403,
11404: 11405,
11406: 11407,
11408: 11409,
11410: 11411,
11412: 11413,
11414: 11415,
11416: 11417,
11418: 11419,
11420: 11421,
11422: 11423,
11424: 11425,
11426: 11427,
11428: 11429,
11430: 11431,
11432: 11433,
11434: 11435,
11436: 11437,
11438: 11439,
11440: 11441,
11442: 11443,
11444: 11445,
11446: 11447,
11448: 11449,
11450: 11451,
11452: 11453,
11454: 11455,
11456: 11457,
11458: 11459,
11460: 11461,
11462: 11463,
11464: 11465,
11466: 11467,
11468: 11469,
11470: 11471,
11472: 11473,
11474: 11475,
11476: 11477,
11478: 11479,
11480: 11481,
11482: 11483,
11484: 11485,
11486: 11487,
11488: 11489,
11490: 11491,
11499: 11500,
11501: 11502,
11506: 11507,
42560: 42561,
42562: 42563,
42564: 42565,
42566: 42567,
42568: 42569,
42570: 42571,
42572: 42573,
42574: 42575,
42576: 42577,
42578: 42579,
42580: 42581,
42582: 42583,
42584: 42585,
42586: 42587,
42588: 42589,
42590: 42591,
42592: 42593,
42594: 42595,
42596: 42597,
42598: 42599,
42600: 42601,
42602: 42603,
42604: 42605,
42624: 42625,
42626: 42627,
42628: 42629,
42630: 42631,
42632: 42633,
42634: 42635,
42636: 42637,
42638: 42639,
42640: 42641,
42642: 42643,
42644: 42645,
42646: 42647,
42786: 42787,
42788: 42789,
42790: 42791,
42792: 42793,
42794: 42795,
42796: 42797,
42798: 42799,
42802: 42803,
42804: 42805,
42806: 42807,
42808: 42809,
42810: 42811,
42812: 42813,
42814: 42815,
42816: 42817,
42818: 42819,
42820: 42821,
42822: 42823,
42824: 42825,
42826: 42827,
42828: 42829,
42830: 42831,
42832: 42833,
42834: 42835,
42836: 42837,
42838: 42839,
42840: 42841,
42842: 42843,
42844: 42845,
42846: 42847,
42848: 42849,
42850: 42851,
42852: 42853,
42854: 42855,
42856: 42857,
42858: 42859,
42860: 42861,
42862: 42863,
42873: 42874,
42875: 42876,
42877: 7545,
42878: 42879,
42880: 42881,
42882: 42883,
42884: 42885,
42886: 42887,
42891: 42892,
42893: 613,
42896: 42897,
42898: 42899,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
66598: 66638,
66599: 66639,
}

_tolower_corrected = {
}
_totitle = {
384: 579,
410: 573,
453: 453,
456: 456,
459: 459,
498: 498,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
613: 42893,
614: 42922,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11507: 11506,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
11559: 4295,
11565: 4301,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
66638: 66598,
66639: 66599,
}

_totitle_corrected = {
}
_special_casing = {
223: ([223], [83, 115], [83, 83]),
304: ([105, 775], [304], [304]),
329: ([329], [700, 78], [700, 78]),
496: ([496], [74, 780], [74, 780]),
912: ([912], [921, 776, 769], [921, 776, 769]),
944: ([944], [933, 776, 769], [933, 776, 769]),
1415: ([1415], [1333, 1410], [1333, 1362]),
7830: ([7830], [72, 817], [72, 817]),
7831: ([7831], [84, 776], [84, 776]),
7832: ([7832], [87, 778], [87, 778]),
7833: ([7833], [89, 778], [89, 778]),
7834: ([7834], [65, 702], [65, 702]),
8016: ([8016], [933, 787], [933, 787]),
8018: ([8018], [933, 787, 768], [933, 787, 768]),
8020: ([8020], [933, 787, 769], [933, 787, 769]),
8022: ([8022], [933, 787, 834], [933, 787, 834]),
8064: ([8064], [8072], [7944, 921]),
8065: ([8065], [8073], [7945, 921]),
8066: ([8066], [8074], [7946, 921]),
8067: ([8067], [8075], [7947, 921]),
8068: ([8068], [8076], [7948, 921]),
8069: ([8069], [8077], [7949, 921]),
8070: ([8070], [8078], [7950, 921]),
8071: ([8071], [8079], [7951, 921]),
8072: ([8064], [8072], [7944, 921]),
8073: ([8065], [8073], [7945, 921]),
8074: ([8066], [8074], [7946, 921]),
8075: ([8067], [8075], [7947, 921]),
8076: ([8068], [8076], [7948, 921]),
8077: ([8069], [8077], [7949, 921]),
8078: ([8070], [8078], [7950, 921]),
8079: ([8071], [8079], [7951, 921]),
8080: ([8080], [8088], [7976, 921]),
8081: ([8081], [8089], [7977, 921]),
8082: ([8082], [8090], [7978, 921]),
8083: ([8083], [8091], [7979, 921]),
8084: ([8084], [8092], [7980, 921]),
8085: ([8085], [8093], [7981, 921]),
8086: ([8086], [8094], [7982, 921]),
8087: ([8087], [8095], [7983, 921]),
8088: ([8080], [8088], [7976, 921]),
8089: ([8081], [8089], [7977, 921]),
8090: ([8082], [8090], [7978, 921]),
8091: ([8083], [8091], [7979, 921]),
8092: ([8084], [8092], [7980, 921]),
8093: ([8085], [8093], [7981, 921]),
8094: ([8086], [8094], [7982, 921]),
8095: ([8087], [8095], [7983, 921]),
8096: ([8096], [8104], [8040, 921]),
8097: ([8097], [8105], [8041, 921]),
8098: ([8098], [8106], [8042, 921]),
8099: ([8099], [8107], [8043, 921]),
8100: ([8100], [8108], [8044, 921]),
8101: ([8101], [8109], [8045, 921]),
8102: ([8102], [8110], [8046, 921]),
8103: ([8103], [8111], [8047, 921]),
8104: ([8096], [8104], [8040, 921]),
8105: ([8097], [8105], [8041, 921]),
8106: ([8098], [8106], [8042, 921]),
8107: ([8099], [8107], [8043, 921]),
8108: ([8100], [8108], [8044, 921]),
8109: ([8101], [8109], [8045, 921]),
8110: ([8102], [8110], [8046, 921]),
8111: ([8103], [8111], [8047, 921]),
8114: ([8114], [8122, 837], [8122, 921]),
8115: ([8115], [8124], [913, 921]),
8116: ([8116], [902, 837], [902, 921]),
8118: ([8118], [913, 834], [913, 834]),
8119: ([8119], [913, 834, 837], [913, 834, 921]),
8124: ([8115], [8124], [913, 921]),
8130: ([8130], [8138, 837], [8138, 921]),
8131: ([8131], [8140], [919, 921]),
8132: ([8132], [905, 837], [905, 921]),
8134: ([8134], [919, 834], [919, 834]),
8135: ([8135], [919, 834, 837], [919, 834, 921]),
8140: ([8131], [8140], [919, 921]),
8146: ([8146], [921, 776, 768], [921, 776, 768]),
8147: ([8147], [921, 776, 769], [921, 776, 769]),
8150: ([8150], [921, 834], [921, 834]),
8151: ([8151], [921, 776, 834], [921, 776, 834]),
8162: ([8162], [933, 776, 768], [933, 776, 768]),
8163: ([8163], [933, 776, 769], [933, 776, 769]),
8164: ([8164], [929, 787], [929, 787]),
8166: ([8166], [933, 834], [933, 834]),
8167: ([8167], [933, 776, 834], [933, 776, 834]),
8178: ([8178], [8186, 837], [8186, 921]),
8179: ([8179], [8188], [937, 921]),
8180: ([8180], [911, 837], [911, 921]),
8182: ([8182], [937, 834], [937, 834]),
8183: ([8183], [937, 834, 837], [937, 834, 921]),
8188: ([8179], [8188], [937, 921]),
64256: ([64256], [70, 102], [70, 70]),
64257: ([64257], [70, 105], [70, 73]),
64258: ([64258], [70, 108], [70, 76]),
64259: ([64259], [70, 102, 105], [70, 70, 73]),
64260: ([64260], [70, 102, 108], [70, 70, 76]),
64261: ([64261], [83, 116], [83, 84]),
64262: ([64262], [83, 116], [83, 84]),
64275: ([64275], [1348, 1398], [1348, 1350]),
64276: ([64276], [1348, 1381], [1348, 1333]),
64277: ([64277], [1348, 1387], [1348, 1339]),
64278: ([64278], [1358, 1398], [1358, 1350]),
64279: ([64279], [1348, 1389], [1348, 1341]),
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
1017: '<compat> 03A3',
4348: '<super> 10DC',
6918: '1B05 1B35',
6920: '1B07 1B35',
6922: '1B09 1B35',
6924: '1B0B 1B35',
6926: '1B0D 1B35',
6930: '1B11 1B35',
6971: '1B3A 1B35',
6973: '1B3C 1B35',
6976: '1B3E 1B35',
6977: '1B3F 1B35',
6979: '1B42 1B35',
7468: '<super> 0041',
7469: '<super> 00C6',
7470: '<super> 0042',
7472: '<super> 0044',
7473: '<super> 0045',
7474: '<super> 018E',
7475: '<super> 0047',
7476: '<super> 0048',
7477: '<super> 0049',
7478: '<super> 004A',
7479: '<super> 004B',
7480: '<super> 004C',
7481: '<super> 004D',
7482: '<super> 004E',
7484: '<super> 004F',
7485: '<super> 0222',
7486: '<super> 0050',
7487: '<super> 0052',
7488: '<super> 0054',
7489: '<super> 0055',
7490: '<super> 0057',
7491: '<super> 0061',
7492: '<super> 0250',
7493: '<super> 0251',
7494: '<super> 1D02',
7495: '<super> 0062',
7496: '<super> 0064',
7497: '<super> 0065',
7498: '<super> 0259',
7499: '<super> 025B',
7500: '<super> 025C',
7501: '<super> 0067',
7503: '<super> 006B',
7504: '<super> 006D',
7505: '<super> 014B',
7506: '<super> 006F',
7507: '<super> 0254',
7508: '<super> 1D16',
7509: '<super> 1D17',
7510: '<super> 0070',
7511: '<super> 0074',
7512: '<super> 0075',
7513: '<super> 1D1D',
7514: '<super> 026F',
7515: '<super> 0076',
7516: '<super> 1D25',
7517: '<super> 03B2',
7518: '<super> 03B3',
7519: '<super> 03B4',
7520: '<super> 03C6',
7521: '<super> 03C7',
7522: '<sub> 0069',
7523: '<sub> 0072',
7524: '<sub> 0075',
7525: '<sub> 0076',
7526: '<sub> 03B2',
7527: '<sub> 03B3',
7528: '<sub> 03C1',
7529: '<sub> 03C6',
7530: '<sub> 03C7',
7544: '<super> 043D',
7579: '<super> 0252',
7580: '<super> 0063',
7581: '<super> 0255',
7582: '<super> 00F0',
7583: '<super> 025C',
7584: '<super> 0066',
7585: '<super> 025F',
7586: '<super> 0261',
7587: '<super> 0265',
7588: '<super> 0268',
7589: '<super> 0269',
7590: '<super> 026A',
7591: '<super> 1D7B',
7592: '<super> 029D',
7593: '<super> 026D',
7594: '<super> 1D85',
7595: '<super> 029F',
7596: '<super> 0271',
7597: '<super> 0270',
7598: '<super> 0272',
7599: '<super> 0273',
7600: '<super> 0274',
7601: '<super> 0275',
7602: '<super> 0278',
7603: '<super> 0282',
7604: '<super> 0283',
7605: '<super> 01AB',
7606: '<super> 0289',
7607: '<super> 028A',
7608: '<super> 1D1C',
7609: '<super> 028B',
7610: '<super> 028C',
7611: '<super> 007A',
7612: '<super> 0290',
7613: '<super> 0291',
7614: '<super> 0292',
7615: '<super> 03B8',
8336: '<sub> 0061',
8337: '<sub> 0065',
8338: '<sub> 006F',
8339: '<sub> 0078',
8340: '<sub> 0259',
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
8507: '<compat> 0046 0041 0058',
8508: '<font> 03C0',
8528: '<fraction> 0031 2044 0037',
8529: '<fraction> 0031 2044 0039',
8530: '<fraction> 0031 2044 0031 0030',
8585: '<fraction> 0030 2044 0033',
11388: '<sub> 006A',
11389: '<super> 0056',
11631: '<super> 2D61',
12829: '<compat> 0028 110B 1169 110C 1165 11AB 0029',
12830: '<compat> 0028 110B 1169 1112 116E 0029',
12868: '<circle> 554F',
12869: '<circle> 5E7C',
12870: '<circle> 6587',
12871: '<circle> 7B8F',
12880: '<square> 0050 0054 0045',
12924: '<circle> 110E 1161 11B7 1100 1169',
12925: '<circle> 110C 116E 110B 1174',
12926: '<circle> 110B 116E',
13004: '<square> 0048 0067',
13005: '<square> 0065 0072 0067',
13006: '<square> 0065 0056',
13007: '<square> 004C 0054 0044',
13175: '<square> 0064 006D',
13176: '<square> 0064 006D 00B2',
13177: '<square> 0064 006D 00B3',
13178: '<square> 0049 0055',
13278: '<square> 0056 2215 006D',
13279: '<square> 0041 2215 006D',
13311: '<square> 0067 0061 006C',
42864: '<super> A76F',
43000: '<super> 0126',
43001: '<super> 0153',
64046: '90DE',
64047: '96B7',
64107: '6075',
64108: '242EE',
64109: '8218',
64112: '4E26',
64113: '51B5',
64114: '5168',
64115: '4F80',
64116: '5145',
64117: '5180',
64118: '52C7',
64119: '52FA',
64120: '559D',
64121: '5555',
64122: '5599',
64123: '55E2',
64124: '585A',
64125: '58B3',
64126: '5944',
64127: '5954',
64128: '5A62',
64129: '5B28',
64130: '5ED2',
64131: '5ED9',
64132: '5F69',
64133: '5FAD',
64134: '60D8',
64135: '614E',
64136: '6108',
64137: '618E',
64138: '6160',
64139: '61F2',
64140: '6234',
64141: '63C4',
64142: '641C',
64143: '6452',
64144: '6556',
64145: '6674',
64146: '6717',
64147: '671B',
64148: '6756',
64149: '6B79',
64150: '6BBA',
64151: '6D41',
64152: '6EDB',
64153: '6ECB',
64154: '6F22',
64155: '701E',
64156: '716E',
64157: '77A7',
64158: '7235',
64159: '72AF',
64160: '732A',
64161: '7471',
64162: '7506',
64163: '753B',
64164: '761D',
64165: '761F',
64166: '76CA',
64167: '76DB',
64168: '76F4',
64169: '774A',
64170: '7740',
64171: '78CC',
64172: '7AB1',
64173: '7BC0',
64174: '7C7B',
64175: '7D5B',
64176: '7DF4',
64177: '7F3E',
64178: '8005',
64179: '8352',
64180: '83EF',
64181: '8779',
64182: '8941',
64183: '8986',
64184: '8996',
64185: '8ABF',
64186: '8AF8',
64187: '8ACB',
64188: '8B01',
64189: '8AFE',
64190: '8AED',
64191: '8B39',
64192: '8B8A',
64193: '8D08',
64194: '8F38',
64195: '9072',
64196: '9199',
64197: '9276',
64198: '967C',
64199: '96E3',
64200: '9756',
64201: '97DB',
64202: '97FF',
64203: '980B',
64204: '983B',
64205: '9B12',
64206: '9F9C',
64207: '2284A',
64208: '22844',
64209: '233D5',
64210: '3B9D',
64211: '4018',
64212: '4039',
64213: '25249',
64214: '25CD0',
64215: '27ED3',
64216: '9F43',
64217: '9F8E',
65040: '<vertical> 002C',
65041: '<vertical> 3001',
65042: '<vertical> 3002',
65043: '<vertical> 003A',
65044: '<vertical> 003B',
65045: '<vertical> 0021',
65046: '<vertical> 003F',
65047: '<vertical> 3016',
65048: '<vertical> 3017',
65049: '<vertical> 2026',
65095: '<vertical> 005B',
65096: '<vertical> 005D',
69786: '11099 110BA',
69788: '1109B 110BA',
69803: '110A5 110BA',
69934: '11131 11127',
69935: '11132 11127',
120001: '<font> 006C',
120484: '<font> 0131',
120485: '<font> 0237',
120778: '<font> 03DC',
120779: '<font> 03DD',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127232: '<compat> 0030 002E',
127233: '<compat> 0030 002C',
127234: '<compat> 0031 002C',
127235: '<compat> 0032 002C',
127236: '<compat> 0033 002C',
127237: '<compat> 0034 002C',
127238: '<compat> 0035 002C',
127239: '<compat> 0036 002C',
127240: '<compat> 0037 002C',
127241: '<compat> 0038 002C',
127242: '<compat> 0039 002C',
127248: '<compat> 0028 0041 0029',
127249: '<compat> 0028 0042 0029',
127250: '<compat> 0028 0043 0029',
127251: '<compat> 0028 0044 0029',
127252: '<compat> 0028 0045 0029',
127253: '<compat> 0028 0046 0029',
127254: '<compat> 0028 0047 0029',
127255: '<compat> 0028 0048 0029',
127256: '<compat> 0028 0049 0029',
127257: '<compat> 0028 004A 0029',
127258: '<compat> 0028 004B 0029',
127259: '<compat> 0028 004C 0029',
127260: '<compat> 0028 004D 0029',
127261: '<compat> 0028 004E 0029',
127262: '<compat> 0028 004F 0029',
127263: '<compat> 0028 0050 0029',
127264: '<compat> 0028 0051 0029',
127265: '<compat> 0028 0052 0029',
127266: '<compat> 0028 0053 0029',
127267: '<compat> 0028 0054 0029',
127268: '<compat> 0028 0055 0029',
127269: '<compat> 0028 0056 0029',
127270: '<compat> 0028 0057 0029',
127271: '<compat> 0028 0058 0029',
127272: '<compat> 0028 0059 0029',
127273: '<compat> 0028 005A 0029',
127274: '<compat> 3014 0053 3015',
127275: '<circle> 0043',
127276: '<circle> 0052',
127277: '<circle> 0043 0044',
127278: '<circle> 0057 005A',
127280: '<square> 0041',
127281: '<square> 0042',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127293: '<square> 004E',
127294: '<square> 004F',
127295: '<square> 0050',
127296: '<square> 0051',
127297: '<square> 0052',
127298: '<square> 0053',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127302: '<square> 0057',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127306: '<square> 0048 0056',
127307: '<square> 004D 0056',
127308: '<square> 0053 0044',
127309: '<square> 0053 0053',
127310: '<square> 0050 0050 0056',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127376: '<square> 0044 004A',
127488: '<square> 307B 304B',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127504: '<square> 624B',
127505: '<square> 5B57',
127506: '<square> 53CC',
127507: '<square> 30C7',
127508: '<square> 4E8C',
127509: '<square> 591A',
127510: '<square> 89E3',
127511: '<square> 5929',
127512: '<square> 4EA4',
127513: '<square> 6620',
127514: '<square> 7121',
127515: '<square> 6599',
127516: '<square> 524D',
127517: '<square> 5F8C',
127518: '<square> 518D',
127519: '<square> 65B0',
127520: '<square> 521D',
127521: '<square> 7D42',
127522: '<square> 751F',
127523: '<square> 8CA9',
127524: '<square> 58F0',
127525: '<square> 5439',
127526: '<square> 6F14',
127527: '<square> 6295',
127528: '<square> 6355',
127529: '<square> 4E00',
127530: '<square> 4E09',
127531: '<square> 904A',
127532: '<square> 5DE6',
127533: '<square> 4E2D',
127534: '<square> 53F3',
127535: '<square> 6307',
127536: '<square> 8D70',
127537: '<square> 6253',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127552: '<compat> 3014 672C 3015',
127553: '<compat> 3014 4E09 3015',
127554: '<compat> 3014 4E8C 3015',
127555: '<compat> 3014 5B89 3015',
127556: '<compat> 3014 70B9 3015',
127557: '<compat> 3014 6253 3015',
127558: '<compat> 3014 76D7 3015',
127559: '<compat> 3014 52DD 3015',
127560: '<compat> 3014 6557 3015',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
194664: '36FC',
194676: '5F53',
194847: '243AB',
194911: '7AEE',
195007: '45D7',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
}

_canon_decomposition = {
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
64046: [37086],
64047: [38583],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
69934: [69937, 69927],
69935: [69938, 69927],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
1017: [931],
4348: [4316],
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
7468: [65],
7469: [198],
7470: [66],
7472: [68],
7473: [69],
7474: [398],
7475: [71],
7476: [72],
7477: [73],
7478: [74],
7479: [75],
7480: [76],
7481: [77],
7482: [78],
7484: [79],
7485: [546],
7486: [80],
7487: [82],
7488: [84],
7489: [85],
7490: [87],
7491: [97],
7492: [592],
7493: [593],
7494: [7426],
7495: [98],
7496: [100],
7497: [101],
7498: [601],
7499: [603],
7500: [604],
7501: [103],
7503: [107],
7504: [109],
7505: [331],
7506: [111],
7507: [596],
7508: [7446],
7509: [7447],
7510: [112],
7511: [116],
7512: [117],
7513: [7453],
7514: [623],
7515: [118],
7516: [7461],
7517: [946],
7518: [947],
7519: [948],
7520: [966],
7521: [967],
7522: [105],
7523: [114],
7524: [117],
7525: [118],
7526: [946],
7527: [947],
7528: [961],
7529: [966],
7530: [967],
7544: [1085],
7579: [594],
7580: [99],
7581: [597],
7582: [240],
7583: [604],
7584: [102],
7585: [607],
7586: [609],
7587: [613],
7588: [616],
7589: [617],
7590: [618],
7591: [7547],
7592: [669],
7593: [621],
7594: [7557],
7595: [671],
7596: [625],
7597: [624],
7598: [626],
7599: [627],
7600: [628],
7601: [629],
7602: [632],
7603: [642],
7604: [643],
7605: [427],
7606: [649],
7607: [650],
7608: [7452],
7609: [651],
7610: [652],
7611: [122],
7612: [656],
7613: [657],
7614: [658],
7615: [952],
8336: [97],
8337: [101],
8338: [111],
8339: [120],
8340: [601],
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
8507: [70, 65, 88],
8508: [960],
8528: [49, 8260, 55],
8529: [49, 8260, 57],
8530: [49, 8260, 49, 48],
8585: [48, 8260, 51],
11388: [106],
11389: [86],
11631: [11617],
12829: [40, 4363, 4457, 4364, 4453, 4523, 41],
12830: [40, 4363, 4457, 4370, 4462, 41],
12868: [21839],
12869: [24188],
12870: [25991],
12871: [31631],
12880: [80, 84, 69],
12924: [4366, 4449, 4535, 4352, 4457],
12925: [4364, 4462, 4363, 4468],
12926: [4363, 4462],
13004: [72, 103],
13005: [101, 114, 103],
13006: [101, 86],
13007: [76, 84, 68],
13175: [100, 109],
13176: [100, 109, 50],
13177: [100, 109, 51],
13178: [73, 85],
13278: [86, 8725, 109],
13279: [65, 8725, 109],
13311: [103, 97, 108],
42864: [42863],
43000: [294],
43001: [339],
64046: [37086],
64047: [38583],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
65040: [44],
65041: [12289],
65042: [12290],
65043: [58],
65044: [59],
65045: [33],
65046: [63],
65047: [12310],
65048: [12311],
65049: [46, 46, 46],
65095: [91],
65096: [93],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
69934: [69937, 69927],
69935: [69938, 69927],
120001: [108],
120484: [305],
120485: [567],
120778: [988],
120779: [989],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127232: [48, 46],
127233: [48, 44],
127234: [49, 44],
127235: [50, 44],
127236: [51, 44],
127237: [52, 44],
127238: [53, 44],
127239: [54, 44],
127240: [55, 44],
127241: [56, 44],
127242: [57, 44],
127248: [40, 65, 41],
127249: [40, 66, 41],
127250: [40, 67, 41],
127251: [40, 68, 41],
127252: [40, 69, 41],
127253: [40, 70, 41],
127254: [40, 71, 41],
127255: [40, 72, 41],
127256: [40, 73, 41],
127257: [40, 74, 41],
127258: [40, 75, 41],
127259: [40, 76, 41],
127260: [40, 77, 41],
127261: [40, 78, 41],
127262: [40, 79, 41],
127263: [40, 80, 41],
127264: [40, 81, 41],
127265: [40, 82, 41],
127266: [40, 83, 41],
127267: [40, 84, 41],
127268: [40, 85, 41],
127269: [40, 86, 41],
127270: [40, 87, 41],
127271: [40, 88, 41],
127272: [40, 89, 41],
127273: [40, 90, 41],
127274: [12308, 83, 12309],
127275: [67],
127276: [82],
127277: [67, 68],
127278: [87, 90],
127280: [65],
127281: [66],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127293: [78],
127294: [79],
127295: [80],
127296: [81],
127297: [82],
127298: [83],
127299: [84],
127300: [85],
127301: [86],
127302: [87],
127303: [88],
127304: [89],
127305: [90],
127306: [72, 86],
127307: [77, 86],
127308: [83, 68],
127309: [83, 83],
127310: [80, 80, 86],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127376: [68, 74],
127488: [12411, 12363],
127489: [12467, 12467],
127490: [12469],
127504: [25163],
127505: [23383],
127506: [21452],
127507: [12486, 12441],
127508: [20108],
127509: [22810],
127510: [35299],
127511: [22825],
127512: [20132],
127513: [26144],
127514: [28961],
127515: [26009],
127516: [21069],
127517: [24460],
127518: [20877],
127519: [26032],
127520: [21021],
127521: [32066],
127522: [29983],
127523: [36009],
127524: [22768],
127525: [21561],
127526: [28436],
127527: [25237],
127528: [25429],
127529: [19968],
127530: [19977],
127531: [36938],
127532: [24038],
127533: [20013],
127534: [21491],
127535: [25351],
127536: [36208],
127537: [25171],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127552: [12308, 26412, 12309],
127553: [12308, 19977, 12309],
127554: [12308, 20108, 12309],
127555: [12308, 23433, 12309],
127556: [12308, 28857, 12309],
127557: [12308, 25171, 12309],
127558: [12308, 30423, 12309],
127559: [12308, 21213, 12309],
127560: [12308, 25943, 12309],
127568: [24471],
127569: [21487],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
1801,
3294,
3741,
3743,
3747,
3749,
4048,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8472,
9288,
9289,
40981,
65048,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65279,
65279,
65279,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
7838: [115, 115],
}

_casefolds_corrected = {
1010: None,
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
848: 230,
849: 230,
850: 230,
851: 220,
852: 220,
853: 220,
854: 220,
855: 230,
856: 232,
857: 220,
858: 220,
859: 230,
860: 233,
861: 234,
862: 234,
863: 233,
1159: 230,
1442: 220,
1466: 19,
1477: 220,
1479: 18,
1552: 230,
1553: 230,
1554: 230,
1555: 230,
1556: 230,
1557: 230,
1558: 230,
1559: 230,
1560: 30,
1561: 31,
1562: 32,
1622: 220,
1623: 230,
1624: 230,
1625: 230,
1626: 230,
1627: 230,
1628: 220,
1629: 230,
1630: 230,
1631: 220,
2027: 230,
2028: 230,
2029: 230,
2030: 230,
2031: 230,
2032: 230,
2033: 230,
2034: 220,
2035: 230,
2070: 230,
2071: 230,
2072: 230,
2073: 230,
2075: 230,
2076: 230,
2077: 230,
2078: 230,
2079: 230,
2080: 230,
2081: 230,
2082: 230,
2083: 230,
2085: 230,
2086: 230,
2087: 230,
2089: 230,
2090: 230,
2091: 230,
2092: 230,
2093: 230,
2137: 220,
2138: 220,
2139: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
3260: 7,
4154: 9,
4237: 220,
4957: 230,
4958: 230,
4959: 230,
6109: 230,
6457: 222,
6458: 230,
6459: 220,
6679: 230,
6680: 220,
6752: 9,
6773: 230,
6774: 230,
6775: 230,
6776: 230,
6777: 230,
6778: 230,
6779: 230,
6780: 230,
6783: 220,
6964: 7,
6980: 9,
7019: 230,
7020: 220,
7021: 230,
7022: 230,
7023: 230,
7024: 230,
7025: 230,
7026: 230,
7027: 230,
7082: 9,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7223: 7,
7376: 230,
7377: 230,
7378: 230,
7380: 1,
7381: 220,
7382: 220,
7383: 220,
7384: 220,
7385: 220,
7386: 230,
7387: 230,
7388: 220,
7389: 220,
7390: 220,
7391: 220,
7392: 230,
7394: 1,
7395: 1,
7396: 1,
7397: 1,
7398: 1,
7399: 1,
7400: 1,
7405: 220,
7412: 230,
7616: 230,
7617: 230,
7618: 220,
7619: 230,
7620: 230,
7621: 230,
7622: 230,
7623: 230,
7624: 230,
7625: 230,
7626: 220,
7627: 230,
7628: 230,
7629: 234,
7630: 214,
7631: 220,
7632: 202,
7633: 230,
7634: 230,
7635: 230,
7636: 230,
7637: 230,
7638: 230,
7639: 230,
7640: 230,
7641: 230,
7642: 230,
7643: 230,
7644: 230,
7645: 230,
7646: 230,
7647: 230,
7648: 230,
7649: 230,
7650: 230,
7651: 230,
7652: 230,
7653: 230,
7654: 230,
7676: 233,
7677: 220,
7678: 230,
7679: 220,
8427: 1,
8428: 220,
8429: 220,
8430: 220,
8431: 220,
8432: 230,
11503: 230,
11504: 230,
11505: 230,
11647: 9,
11744: 230,
11745: 230,
11746: 230,
11747: 230,
11748: 230,
11749: 230,
11750: 230,
11751: 230,
11752: 230,
11753: 230,
11754: 230,
11755: 230,
11756: 230,
11757: 230,
11758: 230,
11759: 230,
11760: 230,
11761: 230,
11762: 230,
11763: 230,
11764: 230,
11765: 230,
11766: 230,
11767: 230,
11768: 230,
11769: 230,
11770: 230,
11771: 230,
11772: 230,
11773: 230,
11774: 230,
11775: 230,
42607: 230,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42620: 230,
42621: 230,
42655: 230,
42736: 230,
42737: 230,
43014: 9,
43204: 9,
43232: 230,
43233: 230,
43234: 230,
43235: 230,
43236: 230,
43237: 230,
43238: 230,
43239: 230,
43240: 230,
43241: 230,
43242: 230,
43243: 230,
43244: 230,
43245: 230,
43246: 230,
43247: 230,
43248: 230,
43249: 230,
43307: 220,
43308: 220,
43309: 220,
43347: 9,
43443: 7,
43456: 9,
43696: 230,
43698: 230,
43699: 230,
43700: 220,
43703: 230,
43704: 230,
43710: 230,
43711: 230,
43713: 230,
43766: 9,
44013: 9,
65060: 230,
65061: 230,
65062: 230,
66045: 220,
68109: 220,
68111: 230,
68152: 230,
68153: 1,
68154: 220,
68159: 9,
69702: 9,
69817: 9,
69818: 7,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70080: 9,
71350: 9,
71351: 7,
119362: 230,
119363: 230,
119364: 230,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

