# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=5.2.0 --output=unicodedb_5_2_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '5.2.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x0c ABOVE RIGHT'
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x03 AN'
'\x05 AND '
'\x14 AND DIAGONAL STROKE'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\x06 ARROW'
'\x05 BACK'
'\x04 BAR'
'\r BEHIND CLOUD'
'\x06 BELOW'
'\x07 CER-WA'
'\x07 CHIKI '
'\x07 CIRCLE'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING GABA'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x11 DOWN BLACK ARROW'
'\t DRACHMAS'
'\x06 ENTRY'
'\x06 EQUID'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ILUT'
'\x03 IN'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x0e KISIM5 TIMES '
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x06 LELET'
'\x06 LENGA'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\n MAHAPRANA'
'\x06 MELIK'
'\x07 MENDUT'
'\x06 MURDA'
'\x08 NUTILLU'
'\x0f OBLIQUE HYPHEN'
'\r OPPOSING KUR'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\x12 PLUS LU PLUS ESH2'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\x11 PLUS SHA3 PLUS A'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x0c PUNCTUATION'
'\x11 PUNCTUATION MARK'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x08 ROTUNDA'
'\x03 SA'
'\x05 SARI'
'\n SCHROEDER'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\x08 SQUARED'
'\x08 STATERS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\x12 THROUGH DESCENDER'
'\x07 TIMES '
'\x08 TIMES A'
'\x10 TIMES A PLUS NA'
'\n TIMES BAD'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x08 TIMES U'
'\x06 TONE-'
'\x08 TTUDDAG'
'\x02 U'
'\r VARIANT FORM'
'\x05 WITH'
'\x06 WITH '
'\x0b WITH COMMA'
'\n WITH CURL'
'\x0f WITH DESCENDER'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH JEGOGAN'
'\x0e WITH LONG LEG'
'\x12 WITH PALATAL HOOK'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x07 WOLOSO'
'\x01-'
'\x02-0'
'\x02-2'
'\x05-ALAF'
'\x0f-CARRIER LETTER'
'\x07-CREE L'
'\t-CREE RWE'
'\x03-EU'
'\x13-FACING SVASTI SIGN'
'\x11-GAAHLAA TTUDDAAG'
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\n-LUE KARAN'
'\x02-O'
'\x06-PIEUP'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x010'
'\x080 BRONZE'
'\x050 DWO'
'\x0b0 FOOTSTOOL'
'\x040 KO'
'\x040 MA'
'\x050 MAN'
'\x040 NI'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x070 SPEAR'
'\x030 U'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 ZO'
'\x030-0'
'\x0207'
'\x0209'
'\x030B9'
'\x011'
'\x071 ARROW'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DU'
'\x051 DWE'
'\x061 GOLD'
'\x081 HELMET'
'\x061 HORN'
'\x041 KU'
'\x031 O'
'\x041 PO'
'\x041 QI'
'\x041 SA'
'\x041 SI'
'\x051 TWO'
'\x061 WINE'
'\x031-0'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x012'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\n2 PLUS ASH'
'\n2 PLUS GAL'
'\x0b2 PLUS GIR2'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x042 SO'
'\x042 WO'
'\x072 WOMAN'
'\x032-0'
'\x0220'
'\x0221'
'\x0222'
'\t247 DIPTE'
'\x03253'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x043 PA'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x073 WHEEL'
'\x033-0'
'\x03305'
'\x0234'
'\x0239'
'\x014'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x044 KE'
'\x044 NE'
'\x044 TE'
'\x044 WA'
'\x044 ZE'
'\x034-0'
'\x0240'
'\x03439'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AU'
'\t5 BATHTUB'
'\t5 CYPERUS'
'\x045 DE'
'\x045 JU'
'\x065 MERI'
'\x045 MO'
'\x045 NU'
'\x045 TO'
'\x045 WE'
'\x065 WOOL'
'\x035-0'
'\x0250'
'\x0351F'
'\x0253'
'\x0255'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x016'
'\x046 JE'
'\x046 JO'
'\x046 NA'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x056 TA2'
'\x066 TREE'
'\x036-0'
'\x03620'
'\x036D7'
'\x017'
'\x047 DI'
'\x047 JA'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 ZA'
'\x0270'
'\x0372C'
'\x0279'
'\x018'
'\x038 A'
'\x038 E'
'\x038 I'
'\x088 KANAKO'
'\x058 NWA'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 TA'
'\x049 TU'
'\x04904A'
'\x0295'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x06A HAAM'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\nA TANG LAI'
'\x07A WITH '
'\x04A-HA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x02AA'
'\x03AAF'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x02AB'
'\nAB2 TIMES '
'\x11ABBREVIATION MARK'
'\x11ABBREVIATION SIGN'
'\x05ABOVE'
'\x06ABOVE '
'\x0eABOVE REVERSE '
'\x13ACCENT ATNAH HAFUKH'
'\x03ACE'
'\x03ACH'
'\x03ACT'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x03ADU'
'\x02AE'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x0bAESCULAPIUS'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x16AF WITH TWO DOTS ABOVE'
'\x07AFF OF '
'\x02AG'
'\x04AGAB'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x08AGRAPHOS'
'\x08AH WITH '
'\x04AHAD'
'\x08AHAPRANA'
'\x02AI'
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\tAJANYALAN'
'\x02AK'
'\x04AKRA'
'\x02AL'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x05ALF H'
'\x05ALING'
'\x06ALL AA'
'\x0fALMOST EQUAL TO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x04AMBA'
'\x04AMLA'
'\x0bAMOND WITH '
'\x04AMPI'
'\x02AN'
'\x03AN2'
'\x04ANAP'
'\x06ANCORA'
'\x0fAND FEMALE SIGN'
'\x18AND MALE AND FEMALE SIGN'
'\x04ANDA'
'\x07ANDERER'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\x06ANGKAT'
'\x06ANGLE '
'\x08ANS SIGN'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x03APA'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\tAPUN IYEK'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AR'
'\nARANI SIGN'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\x07ARDNESS'
'\x05ARGE '
'\x0bARGE SQUARE'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\x06ARRIER'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW WITH '
'\x0eARSI YEH WITH '
'\x0bARTH GROUND'
'\x15ARYSTIAN FIVE HUNDRED'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x04ASAT'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x05ASKAL'
'\x05ASPER'
'\x06ASSING'
'\x08AST WIND'
'\x08ASTERISK'
'\x02AT'
'\nATAKANA DE'
'\x12ATHA WITH TWO DOTS'
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x02AU'
'\x04AULA'
'\x07AULDRON'
'\x07AUNTLET'
'\x06AUTUMN'
'\x08AVAGRAHA'
'\x04AVE-'
'\x08AVY BAND'
'\x02AW'
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x07AYALAM '
'\x06AYEROK'
'\x03AZU'
'\x01B'
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\x03BAD'
'\x0cBAHIRGOMUKHA'
'\x05BALAG'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x08BARRED B'
'\tBASE UNIT'
'\x04BASH'
'\x03BAU'
'\x02BB'
'\x03BBA'
'\x06BEGIN '
'\tBEH WITH '
'\x05BELOW'
'\x05BENDE'
'\x04BER '
'\x11BERBER ACADEMY YA'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\x07BIG YUS'
'\x03BIN'
'\x07BINING '
'\x0cBINING MARK '
'\x05BISAH'
'\x0fBJOINED LETTER '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\rBLACK HEXAGON'
'\x11BLACK SHOGI PIECE'
'\x02BO'
'\x08BOL SIGN'
'\x05BOLD '
'\x11BOTTOM HALF BLACK'
'\x07BOURING'
'\x04BOVE'
'\x05BREVE'
'\x0cBREVE-MACRON'
'\x05BREW '
'\x04BSET'
'\nBSTRUCTION'
'\x03BU '
'\x08BUNDANCE'
'\x03BUR'
'\x03BWA'
'\x03BXG'
'\x0cBYSMAL WATER'
'\x01C'
'\tC CEDILLA'
'\tC CURRENT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x05CAKRA'
'\x05CALES'
'\x05CALYA'
'\x06CANDRA'
'\x08CANDRA A'
'\x0cCANDRA BELOW'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\x0fCAPITAL LETTER '
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x08CE SKATE'
'\x05CECAK'
'\x05CECEK'
'\x0eCENTURIAL SIGN'
'\x06CER-WA'
'\x05CEREK'
'\x02CH'
'\x03CHA'
'\x06CHAMKO'
'\x03CHE'
'\nCHECK MARK'
'\x08CHEIKHEI'
'\x07CHEINAP'
'\x03CHI'
'\x07CHIEUCH'
'\x04CHIL'
'\x06CHIRET'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRYSANTHEMUM'
'\x06CHURCH'
'\x18CHWA WITH RETROFLEX HOOK'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x15CIMAL EXPONENT SYMBOL'
'\x06CIRCLE'
'\rCIRCLE INSIDE'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x04CKET'
'\x05CKING'
'\x0cCLOSED ENTRY'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x02CO'
'\x08COENG QA'
'\x05COLON'
'\x03COM'
'\nCOMBINING '
'\x19COMBINING GEMINATION MARK'
'\x05COMMA'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x11CONSONANT SIGN PA'
'\x07COPTIC '
'\x08COUNCIL '
'\x08COUNTERS'
'\x02CR'
'\x06CREASE'
'\nCROPHONIC '
'\x05CROSS'
'\x0fCROSS ON SHIELD'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x0cCSIMILE SIGN'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\x04CURL'
'\rCURLY BRACKET'
'\x05CUTE-'
'\x03CWI'
'\x03CYA'
'\x01D'
'\x02D '
'\x04D HA'
'\x07D MOUTH'
'\tD SALTIRE'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\x03DAA'
'\x06DAGESH'
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x05DAMMA'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\tDATE MARK'
'\x0eDATE SEPARATOR'
'\x02DD'
'\x04DDDA'
'\x02DE'
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\tDEOGRAPH '
'\tDESCENDER'
'\x0fDESCENDING TONE'
'\x05DESTY'
'\x03DHA'
'\x07DHALATH'
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\rDIAERESIZED U'
'\tDIAGONAL '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\x0eDIFIER LETTER '
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x04DIM2'
'\x03DIN'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISH'
'\x10DITORIAL CORONIS'
'\x05DIUM '
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x02DO'
'\x03DOA'
'\x06DOKMAI'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x1bDOTTED INTERPOLATION MARKER'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x07DOUBLE '
'\nDOUBLE BAR'
'\x19DOUBLE CANDRABINDU VIRAMA'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\rDOUBLE MUCAAD'
'\x0bDOUBLE SHAD'
'\x16DOUBLE VERTICAL STROKE'
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\tDOWNWARDS'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\tDRAUGHTS '
'\x19DRY MEASURE FIRST SUBUNIT'
'\x17DSTONE GRAVEYARD SYMBOL'
'\x02DU'
'\x03DUG'
'\x03DUN'
'\tDUN3 GUNU'
'\x06DVANCE'
'\x08DVISVARA'
'\x03DZA'
'\x03DZE'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x05E GEE'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x02E0'
'\x02E2'
'\x04EACE'
'\x05EAGLE'
'\nEARLY FORM'
'\x05EARTH'
'\x05EAST '
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\tEBATBEIT '
'\tEBIT SIGN'
'\x0bECTION MARK'
'\x03ED '
'\tEDESTRIAN'
'\x06EDIAL '
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x04EENG'
'\x0cEEPING SMALL'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x0eEFT LANE MERGE'
'\x0fEFTWARDS ARROWS'
'\x06EGEAN '
'\x05EGION'
'\x12EH WITH INVERTED V'
'\tEH WITH T'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\x06EIGHTH'
'\x16EIGHTY ON BLACK SQUARE'
'\x02EK'
'\x07EL PUMP'
'\x03ELD'
'\x03ELF'
'\x03ELL'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x04ELTA'
'\x05EMBIC'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x10EN MILLIONS SIGN'
'\x12EN ON BLACK SQUARE'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x03END'
'\x0eEND OF SECTION'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x02EO'
'\x05EO-YA'
'\x03EOW'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02ER'
'\x15ER RIGHT CORNER ANGLE'
'\x08ER TRUTH'
'\x04ERET'
'\x0eERIC INDICATOR'
'\x05ERIN2'
'\x05ERN W'
'\x04ERRY'
'\x06ERTED '
'\x11ERU WITH BACK YER'
'\x08ESCENDER'
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x06ESHTIN'
'\x03EST'
'\x08EST WIND'
'\x02ET'
'\x03ETA'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\x02EU'
'\x03EU-'
'\x07EULEUNG'
'\nEUR-DE-LIS'
'\x03EUX'
'\nEVANAGARI '
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x08EVERSED '
'\x12EVERSED C WITH DOT'
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x02EW'
'\x06EXAGON'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x17EXCLAMATION MARK SYMBOL'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x01F'
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x06FAMILY'
'\x05FATHA'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIFTY'
'\x06FIFTY '
'\x07FINAGH '
'\x06FINAL '
'\tFINAL NGA'
'\x08FINAL TH'
'\x07FINAL Y'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FITA'
'\x0cFIVE HUNDRED'
'\x04FLAG'
'\x16FLATTENED OPEN A ABOVE'
'\x15FLATTENED PARENTHESIS'
'\x05FLICT'
'\x08FLOURISH'
'\x07FLUENCE'
'\x05FLUTE'
'\x02FO'
'\x04FO F'
'\x12FORKED PARAGRAPHOS'
'\x04FOUR'
'\nFOUR BELOW'
'\x0cFOUR CORNERS'
'\x14FOUR DOT PUNCTUATION'
'\tFOUR DOTS'
'\x0fFOUR DOTS ABOVE'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x08FROM BAR'
'\x05FSAAQ'
'\x02FT'
'\x0cFT RERENGGAN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\tG IN HOLE'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x03GAG'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x03GAR'
'\x08GARITIC '
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x08GBASINNA'
'\x02GE'
'\x07GE SIGN'
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\nGGRAVATION'
'\x0fGH VOLTAGE SIGN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x04GHOM'
'\x03GHT'
'\rGHT ARROWHEAD'
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x04GIDA'
'\x05GIMEL'
'\x03GIR'
'\x04GISH'
'\x07GLAGOLI'
'\x02GO'
'!GOLIAN LETTER MANCHU ALI GALI LHA'
'\x04GONG'
'\x03GOU'
'\x02GR'
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\x03GUD'
'\x04GUNU'
'\x02GW'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x07HAARKAA'
'\x0bHAGGAR YAZH'
'\x04HAIN'
'\x03HAL'
'\x04HALF'
'\x0fHALF RING ABOVE'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\x06HARP S'
'\x07HASANTA'
'\x04HATE'
'\x05HATHI'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x04HEAD'
'\x05HEAD '
'\nHEADSTROKE'
'\x08HEAVY YA'
'\x12HEN WITH DIAERESIS'
'\x03HER'
'\x06HERMES'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x16HEXIFORM LONG ANUSVARA'
'\x02HI'
'\x05HI RO'
'\x0cHI TIMES BAD'
'\x03HID'
'\x05HIDET'
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x04HIIN'
'\x04HILD'
'\tHIMA SIMA'
'\x03HIN'
'\rHINESE TONE Y'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x0bHJONG TILE '
'\x06HLAVI '
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOO'
'\x04HOOK'
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x06HORT A'
'\tHOT SASAK'
'\x03HOU'
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
'"HREE DOTS POINTING DOWNWARDS ABOVE'
' HREE DOTS POINTING UPWARDS BELOW'
'\tHREE FOR '
'\x08HREE OF '
'\x04HSHU'
'\x02HU'
'\x04HUEN'
'\x03HUK'
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x03HUR'
'\x02HV'
'\x02HW'
'\x03HWA'
'\x03HWE'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x05I KOI'
'\tI PLUS LI'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x02I0'
'\x0eIAGONAL STROKE'
'\tIALECT-P '
'\x10IAMOND IN SQUARE'
'\x0bIAN LETTER '
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IAUDA'
'\x02IC'
'\x03ICK'
'\x02ID'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x02IE'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\x06IFIED '
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\x03IGH'
'\x05IGHT '
'\x08IGHT OF '
'\tIGHTH ASH'
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\x02II'
'\x03II '
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\x06ILBOAT'
'\x04ILDE'
'\x0bILIQUA SIGN'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x13IMIDIA SEXTULA SIGN'
'\x02IN'
'\x03IN '
'\tIN WITH T'
'\x03IN2'
'\x04INAP'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x03ING'
'\tING LANES'
'\x06INGAAT'
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x06INKING'
'\nINOCULAR O'
'\x03INS'
'\x06INSHIP'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x0bINTO SHRINE'
'\x08INVERTED'
'\tINVERTED '
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x03IP '
'\x04IQAA'
'\x02IR'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x05IRCLE'
'\x07IRCLED '
'\x06IRCLES'
'\x04IRED'
'\x04IRON'
'\x0cIRST SUBUNIT'
'\x04IRTY'
'\x08IS BELOW'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\x03ITA'
'\x0eITA PLUS GISH '
'\x15ITALIC SMALL DOTLESS '
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\tITRA SIGN'
'\x04ITSA'
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x08IVE DOT '
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\nIXTHS DISH'
'\x14IXTY ON BLACK SQUARE'
'\x04IYA '
'\x05IYEOK'
'\x06IYEOK-'
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x05JANG '
'\x07JARATI '
'\x02JE'
'\x0bJECT SYMBOL'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JJA'
'\x03JK '
'\x03JOA'
'\x06JOINED'
'\x05JOKER'
'\x04JONG'
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x07K WITH '
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x04KAD3'
'\x03KAF'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x04KARA'
'\x06KASKAL'
'\x05KASRA'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x06KAVYKA'
'\x06KAYAH '
'\x04KCET'
'\x02KE'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x07KHAMTI '
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x02KI'
'\x04KICK'
'\x04KIER'
'\x03KIN'
'\x04KING'
'\x0fKISIM5 TIMES BI'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x0bKTIESELSKAB'
'\x02KU'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x11KYATHOS BASE SIGN'
'\x01L'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x04LAAN'
'\x05LABAT'
'\x05LACK '
'\nLACKFOOT W'
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\nLAGOLITIC '
'\x03LAI'
'\x03LAL'
'\x03LAM'
'\x0cLAM WITH BAR'
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\x0cLARGE CIRCLE'
'\tLARGEMENT'
'\x03LAS'
'\x05LATIK'
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x10LAVONIC ASTERISK'
'\x03LAY'
'\x05LAYAR'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x04LDE '
'\x02LE'
'\x03LE '
'\nLE LETTER '
'\x05LEASE'
'\x16LECTRICAL INTERSECTION'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\tLEFT HOOK'
'\nLEFT-HAND '
'\x12LEFT-STEM TONE BAR'
'\x0fLEFTWARDS ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\nLEK ATTAK '
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x05LENIS'
'\x04LEPH'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x07LETTER '
'\x0eLETTER CHILLU '
'\x10LETTER KHANDA TA'
'\x0bLETTER LLLA'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x10LETTER VOCALIC L'
'\x02LF'
'\x03LFA'
'\x02LH'
'\x03LHA'
'\x02LI'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\nLIMITATION'
'\x04LINE'
'\x0eLINE EXTENSION'
'\x07LINESE '
'\x04LING'
'\x0cLINGING FIRE'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x02LL'
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'.LLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\x07LLOWING'
'\x15LMET WITH WHITE CROSS'
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x04LOLL'
'\x03LON'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG OVER '
'\x03LOO'
'\x04LOOP'
'\x03LOS'
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'\x16LOW PARAPHRASE BRACKET'
'\x08LOW TONE'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x02LT'
'\x0bLTERNATE YA'
'\x02LU'
'\x0bLU PLUS IGI'
'\x03LUB'
'\x03LUG'
'\x05LUGU '
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x02LY'
'\x04LY H'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x08M BRANCH'
'\x06M BULL'
'\tM HE-GOAT'
'\x05M RAM'
'\nM STALLION'
'\x0bM TIMES SHE'
'\x02M0'
'\x02MA'
'\x05MAAEH'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x05MADYA'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x05MALL '
'\x06MALL A'
'#MALL ARABIC LETTER TAH AND TWO DOTS'
'\x08MALL AXE'
'\x0cMALL LETTER '
'\x15MALL Q WITH HOOK TAIL'
'&MALL TWO DOTS OVER ONE DOT PUNCTUATION'
'\x08MALL YUS'
'\x03MAN'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\x0eMARK LOWER DOT'
'\x10MARK NOON GHUNNA'
'\x0fMARRYING MAIDEN'
'\x04MASH'
'\x03MAY'
'\x02MB'
'\x0cMBELLISHMENT'
'\x08MBINING '
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\x19MBOL FOR SAMARITAN SOURCE'
'\x04MBOO'
'\x08MBRELLA '
'\x02ME'
'\nME PLUS DA'
'\nME PLUS EN'
'\x11ME PLUS GAN2 TENU'
'\x08MEASURE '
'\x07MEDIUM '
'\x0eMEEM WITH DOT '
'\x04MEKH'
'\rMELODIC QITSA'
'\x03MEM'
'\x08MEM-QOPH'
'\x05MEPET'
'\x04MER '
'\rMESSENIAN TEN'
'\x02MI'
'\x05MI RO'
'\x03MID'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE TILDE'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIN'
'\x04MIL '
'\nMILLE SIGN'
'\x03MIM'
'\x03MIN'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\x08MIONIAN '
'\tMISEXTILE'
'\x05MISRA'
'\x03MIT'
'\x03MKA'
'\x03MMA'
'\rMMER AND PICK'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x04MON '
'\x04MONO'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x15MORPHOLOGICAL DIVIDER'
'\x10MPERIAL ARAMAIC '
'\x03MPL'
'\x05MROCK'
'\x02MU'
'\x06MUCAAD'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x0bN THE VERGE'
'\x07N WITH '
'\x12N WITH MIDDLE HOOK'
'\x07N2 TENU'
'\x02NA'
'\x05NA PO'
'\x04NAAU'
'\x06NACLES'
'\x11NADIAN SYLLABICS '
'\x03NAH'
'\nNAKE BELOW'
'\x03NAR'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x13NAXIAN FIVE HUNDRED'
'\x05NCHOR'
'\x03ND '
'\x0bND TWO DOTS'
'\x04NDA2'
'\x04NDAP'
'\tNDRABINDU'
'\x02NE'
'\x03NE '
' NE DOT OVER TWO DOTS PUNCTUATION'
'\x0cNE HALF SIGN'
'\x06NE OF '
'\x07NEAR B '
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x04NESS'
'\x0bNEUTRAL YER'
'\x02NG'
'\x08NG POINT'
'\x11NG STROKE OVERLAY'
'\x03NGA'
'\x04NGA2'
'\x04NGSI'
'\x08NGTHENER'
'\x05NGUL '
'\x02NI'
'\x08NI ABOVE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIHSHVASA'
'\x03NII'
'\x04NINE'
'\nNINE COMMA'
'\x05NINTH'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x1bNMARRIED PARTNERSHIP SYMBOL'
'\x02NN'
'\x03NNA'
'\x06NNADA '
'\x02NO'
'\nNOON WITH '
'\x05NOTCH'
'\x06NOWMAN'
'\x13NOWMAN WITHOUT SNOW'
'\rNSONANT SIGN '
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x05NTAIN'
'\x03NTI'
'\nNTITY MARK'
'\x02NU'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x12NYET THYOOM TA-ROL'
'\nNYIS TSHEG'
'\x01O'
'\tO HUNDRED'
'\tO LETTER '
'\x15O WITH RETROFLEX HOOK'
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x03OAY'
'\x06OBELOS'
'\nOBOLS SIGN'
'\x04OBRO'
'\x07OCALIC '
'\tOCCLUSION'
'\x06OCENCE'
'\x12ODD POWERS OF FOUR'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x02OE'
'\tOENICIAN '
'\x0bOF MASHFAAT'
'\x04OFT '
'\x0fOGOGRAM KHAMTI '
'\x0cOGONEK ABOVE'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\nOGRAM FOR '
'\x02OI'
'\x0cOING TO MEET'
'\x05OINT '
'\x02OK'
'\x05OKARA'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x0bOLDING BACK'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\x02OM'
'\x04OMAN'
'\x05OMAN '
'\tOMBINING '
'\x07OMERANG'
'\x02ON'
'\tON GROUND'
'\nON MEDIAL '
'\x04ONA '
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\tONE MARK-'
'\x04ONE-'
'\x03ONG'
'\x04ONG '
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\x05ONG S'
'\x0bONG S WITH '
'\tONGSEONG '
'\x10ONJOINING MACRON'
'\tONSONANT '
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\nOON LILITH'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\x06OPEN P'
'\nOPEN SHELF'
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x02OQ'
'\x0eORD SEPARATOR '
'\x18ORD SEPARATOR MIDDLE DOT'
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\x14ORTY ON BLACK SQUARE'
'\x06OSETTE'
'\x07OSITION'
'\nOSSED SHEI'
'\x02OT'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x0fOTA WITH STROKE'
'\x07OTATED '
'\x08OTIFIED '
'\x08OTLESS J'
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x0cOTTOM HALF O'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x11OUBLE MONOCULAR O'
'\x04OUBT'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\tOURA SIGN'
'\rOURTH SUBUNIT'
'\x0eOUSING THUNDER'
'\x07OUT HUB'
'\tOUTH WIND'
'\x15OVAL WITH OVAL INSIDE'
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\tOVER LONG'
'\tOVER MUSH'
'\x08OVER NUN'
'\x08OVER SAG'
'\tOVER SHE '
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x03OW '
'\x05OW PA'
'\x12OW TONE APOSTROPHE'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x07OX BACK'
'\x02OY'
'\x03OZE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\x11P ON BLACK SQUARE'
'\x17P SYMBOL FOR LIGHTHOUSE'
'\x07P WITH '
'\x02P0'
'\x02PA'
'\x17PA OVER PA GAR OVER GAR'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x12PAMPHYLIAN DIGAMMA'
'\x12PANESE BANK SYMBOL'
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x0cPAP PLUS PAP'
'\x0bPARENTHESIS'
'\x07PARTURE'
'\x07PAYEROK'
'\x05PCHA '
'\x02PE'
'\x11PE WITH DESCENDER'
'\x04PEEP'
'\x04PEN '
'\x05PEN E'
'\x05PEN O'
'\x06PEN SU'
'\nPENDICULAR'
'\x07PENGKAL'
'\x08PENTAGON'
'\tPENTASEME'
'\x05PEPET'
'\x04PER '
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x18PERSET PRECEDING SOLIDUS'
'\x08PERSIAN '
'\x0cPESMILO SIGN'
'\x03PHA'
'\x03PHI'
'\x07PHIEUPH'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x10PLACEHOLDER MARK'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUM'
'\nPLUS ERIN2'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x16POINTING UPWARDS BELOW'
'\x10POMOFO LETTER IH'
'\x05PONSE'
'\x02PP'
'\x05PPAGE'
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x05PRING'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x05PTIC '
'\x05PTIVE'
'\x02PU'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x11PUNCTUATION SIGN '
'\x08PUSHPIKA'
'\x03PWA'
'\x01Q'
'\x07Q WITH '
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x0fQUADRUPLE ARROW'
' QUALS SIGN ABOVE LEFTWARDS ARROW'
'\x05QUARE'
'\x06QUARED'
'\x07QUARTER'
'\x0bQUARTER ASH'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\x08QUESTION'
'\rQUESTION MARK'
'\x03QUF'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x06R DOT '
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x0bR WITH TAIL'
'\x02R0'
'\x02R2'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x05RABIC'
'\x10RACTION ONE HALF'
'\x03RAE'
'\x05RAEA-'
'\x03RAI'
'\nRAIGHTNESS'
'\x07RAISED '
'\nRAISED DOT'
'\x17RAISED OMISSION BRACKET'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x0cRANCHING OUT'
'\x07RANGKEP'
'\x07RARIETY'
'\x05RASHA'
'\x05RATER'
'\x05RATHA'
'\x08RAUGHTS '
'\x03RAY'
'\x05RCHID'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\x0bREAKTHROUGH'
'\x04REAT'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x0fRECEPTIVE EARTH'
'\nRED DRAGON'
'\nREDIT SIGN'
'\x03REE'
'\x04REE '
'\x0bREE HUNDRED'
'\x05REEK '
'\tREH WITH '
'\x05RELAA'
'\x06RENGTH'
'\x04REPA'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x1eRESENTATION FORM FOR VERTICAL '
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x08REVERSE '
'\tREVERSED '
'\x0fREVERSED OPEN E'
'\x02RG'
'\x04RGE '
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x0cRIAC LETTER '
'\x11RIATION SELECTOR-'
'\x05RICEM'
'\x07RICOLON'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x03RIG'
'\x05RIGHT'
'\x06RIGHT '
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x0fRIGHT RERENGGAN'
'\x0bRIGHT-HAND '
'\x14RIGHT-POINTING ANGLE'
'\x17RIGHT-POINTING PENTAGON'
'\x10RIGHTWARDS ARROW'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x03RII'
'\x06RIKRIK'
'\x07RILLIC '
'\x04RIN2'
'\nRING ABOVE'
'\nRING BELOW'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\rRIPLE SVARITA'
'\x06RIPT G'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x05RITSI'
'\x04RITU'
'\x0eRIVE SLOW SIGN'
'\tRIZONTAL '
'\x06RKAANU'
'\x10RKED PARAGRAPHOS'
'\x0cRMUKHI SIGN '
'\x05RNED '
'\nRNING SIGN'
'\x02RO'
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x04ROSH'
'\x04ROSS'
'\rROSSING LANES'
'\x07ROTUNDA'
'\rRPENTRY PLANE'
'\x02RR'
'\x03RRA'
'\rRRIAGE SYMBOL'
'\x06RSHANA'
'\tRTER MARK'
'\x04RTH '
'\x07RTHIAN '
'\x07RTICAL '
'\x17RTOISE SHELL BRACKETED '
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x07S ABOVE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x02S0'
'\x02SA'
'\x04SA-I'
'\x06SAADIY'
'\nSABLED CAR'
'\x03SAG'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x03SAM'
'\x04SANG'
'\x05SARGA'
'\x05SASAK'
'\x05SCENT'
'\x06SCHOOL'
'\x05SCHWA'
'\x0eSCRIPT SMALL L'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x06SEBALL'
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\nSEEN WITH '
'\tSEMICOLON'
'\x06SERET '
'\x07SEVENTH'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\x04SHAD'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x05SHANG'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\x04SHEI'
'\x05SHESH'
'\x07SHESHIG'
'\x05SHGAB'
'\x05SHIMA'
'\x0fSHITA PLUS GISH'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x04SHU2'
'\x04SHYA'
'\x02SI'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x07SIGN PA'
'\x17SIGN RDEL NAG RDEL DKAR'
'\x04SIKI'
'\x05SILA3'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SLASH'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x0eSMALL CAPITAL '
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x07SMALL F'
'\rSMALL LETTER '
'\nSMALL RING'
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\x12SMALL WHITE CIRCLE'
'\tSMALL YUS'
'\x07SMANYA '
'\x02SO'
'\x08SOGDIAN '
'\x18SOLIDUS PRECEDING SUBSET'
'\x03SON'
'\rSON WITH BALL'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x0eSOUTH ARABIAN '
'\x13SPACING CANDRABINDU'
'\x08SPERSION'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x0cSQUIQUADRATE'
'\x02SS'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x03STA'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x07STATERS'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x04STLE'
'\x0bSTORIC SITE'
'\x13STRATIAN FIFTY MNAS'
'\x14STRICTED LEFT ENTRY-'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x18STROKE THROUGH DESCENDER'
'\x03STU'
'\x02SU'
'\x03SU '
'\x13SUBSTITUTION MARKER'
'\x04SUKU'
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x07SVARITA'
'\nSWASH TAIL'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\x07SYMBOL '
'\x0bSYURA SASAK'
'\x01T'
'\x07T BELOW'
'\nT BEVERAGE'
'\x02T0'
'\x02TA'
'\x03TAB'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\x03TAH'
'\x04TAIL'
'\x04TAK4'
'\x14TAKANA LETTER AINU P'
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x06TAMING'
'\tTANDSTILL'
'\x03TAR'
'\x06TAU RO'
'\x06TAUROS'
'\x04TAWA'
'\x03TCH'
'\x02TE'
'\x04TED '
'\x06TEDUNG'
'\x05TEGEH'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENTH'
'\x04TENU'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x02TH'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\x0bTHEMATICAL '
'\x07THIEUTH'
'\x08THIOPIC '
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\x06THREE '
'\x0eTHREE QUARTERS'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x03THW'
'\x02TI'
'\rTICAL ELLIPSE'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x05TKAAN'
'\x05TMAAU'
'\rTNERSHIP SIGN'
'\x05TNESS'
'\nTOM SYMBOL'
'\x0bTONAL MARK '
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x15TONE MARK SGAW KAREN '
'\x05TONE-'
'\x0eTOP HALF BLACK'
'\x16TORTOISE SHELL BRACKET'
'\x0cTRAGRAM FOR '
'\x07TRAINER'
'\x15TRANSPOSITION BRACKET'
'\x14TRANSPOSITION MARKER'
'\nTRESS AND '
'\x0fTRIANGULAR MARK'
'\x07TRICAL '
'\x08TRICOLON'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x1bTRIPLE DOT PUNCTUATION MARK'
'\x05TROKE'
'\x03TSA'
'\x02TT'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x05TTOM '
'\x02TU'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x0eTURKIC LETTER '
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x03TWO'
'\x04TWO '
'\x0eTWO DOTS BELOW'
'\x19TWO DOTS VERTICALLY ABOVE'
"'TWO DOTS VERTICALLY BELOW AND SMALL TAH"
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x0bTWO-HEADED '
'\x02TY'
'\x01U'
'\x02U '
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x03U U'
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x02U0'
'\x02U2'
'\x02U3'
'\nU3 PLUS AN'
'\x02UA'
'\x03UAE'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x04UBLE'
'\x05UBLE '
'\nUBLE DANDA'
'\x10UBLE PARENTHESIS'
'\x0fUBLE RING BELOW'
'\x0cUBLE SVARITA'
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x02UD'
'\x05UDAAT'
'\x06UDATTA'
'\x02UE'
'\x02UG'
'\x08UGINESE '
'\x04UHUR'
'\x02UK'
'\x05UKARA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x04UMAN'
'\nUMAN EARTH'
'\tUMED HEAD'
'\x04UMI '
'\x05UMMER'
'\x03UMX'
'\x02UN'
'\x04UNAP'
'\x12UNATE SIGMA SYMBOL'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x16UNCTUATION NUN HAFUKHA'
'\x14UNDER CLOUD AND RAIN'
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x03UNO'
'\x06UNTAIN'
'\x0bUNTING ROD '
'\x03UON'
'\x04UON '
'\x02UP'
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\x02UQ'
'\x02UR'
'\nUR HUNDRED'
'\tURAMAZDAA'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x05URITY'
'\x03URN'
'\x06URNED '
'\x03URT'
'\x03URU'
'\x02US'
'\x03USH'
'\rUSHING UPWARD'
'\rUSICAL LEIMMA'
'#USICAL SYMBOL MULTIPLE MEASURE REST'
'\x0eUSPENSION MARK'
'\x0bUSTRAL SIGN'
'\x02UT'
'\x04UTER'
'\x04UTH '
'\x0bUTH CORNERS'
'\x05UTIES'
'\x12UTLINED WHITE STAR'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x02V0'
'\x02VA'
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x02VE'
'\x03VE '
'\x1fVE ARROW POINTING DIRECTLY LEFT'
'\nVE HUNDRED'
'\x08VE SASAK'
'\x04VEDE'
'\tVELOPMENT'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\tVERLONG A'
'\x05VERSE'
'\rVERSE DIVIDER'
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x17VERTICAL BAR WITH QUILL'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL STROKE'
'\x10VERTICALLY ABOVE'
'\x08VESSEL B'
'\x07VESTAN '
'\x02VI'
'\x0cVIAN LETTER '
'\x04VIDA'
'\x05VIET '
'\x03VIN'
'\x04VINE'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC R'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x08VOLUTION'
'\x0cVORCE SYMBOL'
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\nW OR MODEL'
'\rW RING INSIDE'
'\nW TAI LUE '
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x04WAAK'
'\x03WAI'
'\x03WAN'
'\x06WARDS '
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x03WAW'
'&WAW WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WE'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x05WEST '
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x02WG'
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x1cWHITE DOWN-POINTING TRIANGLE'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\x05WIANG'
'\x07WIGNYAN'
'\x05WINDU'
'\x05WISAD'
'\x05WITH '
'\x0fWITH RAIN DROPS'
'\x0cWITH STROKE '
'\tWITH TIP '
'\x0cWN ARROWHEAD'
'\x08WNWARDS '
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x06WO DOT'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x0cWORD DIVIDER'
'\x0eWORD SEPARATOR'
'\x03WOY'
'\x05WU318'
'\x04WULU'
'\tWUNG DASH'
'\x02WZ'
'\x01X'
'\x07X BELOW'
'\x13X WITH PALATAL HOOK'
'\x03X00'
'\x02XA'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x0bXESTES SIGN'
'\x02XG'
'\tXHAUSTION'
'\x02XT'
'\x05XTILE'
'\x05XTRA-'
'\x03XWG'
'\x01Y'
'\x0eY SMALL SQUARE'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x07YAH LI '
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x04YANG'
'\x07YANMAR '
'\x03YAT'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'-YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\tYESIEUNG-'
'\x02YI'
'\x1aYI SYLLABLE ITERATION MARK'
'\x03YIN'
'\x06YIN-DO'
'\x05YIZET'
'\x08YLLABLE '
'\x06YMBOL '
'\x02YN'
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x04YODH'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x02YP'
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x08YRILLIC '
'\nYRILLIC EN'
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'3YZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAI'
'\x04ZAIN'
'\tZAL SASAK'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\tZIR SASAK'
'\x03ZOA'
'\x03ZOO'
'\x08ZWARAKAY'
)
_charnodes =[67838,
 -60600,
 -1,
 132303,
 23794,
 -1,
 197838,
 81611,
 -1,
 263229,
 152460,
 -1,
 327835,
 205831,
 -1,
 393314,
 265047,
 73909,
 458832,
 329935,
 73911,
 589823,
 393216,
 -1,
 589903,
 481811,
 -1,
 655378,
 527191,
 -1,
 720910,
 590709,
 -1,
 -65524,
 666771,
 73914,
 -65523,
 730781,
 73913,
 -1,
 792593,
 73912,
 983056,
 676477,
 73917,
 -1,
 919816,
 73918,
 -65519,
 933278,
 73916,
 -1,
 1053039,
 73915,
 1245211,
 610691,
 -1,
 1310743,
 1189511,
 -1,
 1376278,
 1252351,
 73957,
 -1,
 1311832,
 73958,
 -1,
 1321916,
 73959,
 1572890,
 1248087,
 -1,
 -65511,
 1526732,
 73956,
 -1,
 1586057,
 73955,
 -1,
 1531550,
 73960,
 1835043,
 1188871,
 -1,
 1900576,
 1780494,
 73933,
 1966111,
 1837515,
 73934,
 -1,
 1901436,
 73935,
 -1,
 1920013,
 73936,
 2228223,
 1837911,
 -1,
 -65502,
 2116556,
 73932,
 -1,
 2178503,
 73931,
 2359338,
 1782166,
 -1,
 2424870,
 2304956,
 73946,
 -1,
 2360278,
 73947,
 2555945,
 2362199,
 -1,
 -65496,
 2511939,
 73945,
 -1,
 2568598,
 73944,
 -1,
 2514257,
 73948,
 2818097,
 2303623,
 -1,
 2883631,
 2755415,
 -1,
 2949166,
 2831241,
 73938,
 -1,
 2884557,
 73939,
 -1,
 2884585,
 73937,
 -65488,
 2841987,
 73941,
 -1,
 3091225,
 73940,
 3276854,
 2759679,
 -1,
 3342388,
 3227038,
 73929,
 -1,
 3278180,
 73930,
 3538943,
 3289993,
 73927,
 -1,
 3408845,
 73928,
 3604539,
 3217379,
 -1,
 3670073,
 3549966,
 73924,
 -1,
 3619099,
 73925,
 -65478,
 3628416,
 73926,
 -1,
 3738455,
 73923,
 3932225,
 3543385,
 -1,
 3997758,
 3891213,
 73921,
 -1,
 3933215,
 73922,
 4194303,
 3935063,
 -1,
 -65472,
 4082673,
 73920,
 -1,
 4134883,
 73919,
 4325444,
 3890418,
 73962,
 4456447,
 4265955,
 73963,
 -1,
 4326295,
 73964,
 4522054,
 4276323,
 73952,
 -1,
 4457234,
 73953,
 4653129,
 4471012,
 -1,
 -65464,
 4598542,
 73951,
 -1,
 4660267,
 73950,
 4849740,
 4598542,
 -1,
 -65461,
 4805252,
 73943,
 -1,
 4859291,
 73942,
 -65459,
 4806612,
 73961,
 -65458,
 4999129,
 73954,
 -1,
 5059511,
 73949,
 -1,
 542301,
 73965,
 5308502,
 408990,
 73974,
 5439487,
 5245135,
 73975,
 5505023,
 5308416,
 -1,
 -65452,
 5396643,
 73976,
 -65451,
 5457510,
 73977,
 -1,
 5510927,
 73978,
 5701721,
 5256073,
 73970,
 -65448,
 5639725,
 73972,
 -1,
 5701926,
 73971,
 5898331,
 5655500,
 73979,
 -1,
 5835110,
 73980,
 6029405,
 5838819,
 73968,
 -1,
 5964402,
 73969,
 6160479,
 5968267,
 73966,
 -1,
 6095058,
 73967,
 -65440,
 6116044,
 73981,
 -65439,
 6240484,
 73973,
 -1,
 6291797,
 73910,
 6488193,
 338702,
 73984,
 6553709,
 6441932,
 -1,
 6619243,
 6490470,
 73994,
 6750207,
 6554904,
 -1,
 -65433,
 6637529,
 73999,
 -65432,
 6699169,
 73998,
 -65431,
 6761619,
 73997,
 -65430,
 6825100,
 73996,
 -1,
 6884222,
 73995,
 7143423,
 6555855,
 73992,
 -1,
 7012693,
 73993,
 7209079,
 6508931,
 -1,
 7274614,
 7153287,
 74001,
 7405567,
 7208960,
 -1,
 7405685,
 7296904,
 -1,
 7471220,
 7351571,
 -1,
 -65421,
 7428052,
 74004,
 -1,
 7475598,
 74003,
 -1,
 7413499,
 74005,
 -1,
 7345974,
 74002,
 -1,
 7212435,
 74000,
 7864443,
 7145931,
 73988,
 7995391,
 7798784,
 -1,
 -65414,
 7882352,
 73989,
 -1,
 7935785,
 73990,
 8126592,
 7798784,
 -1,
 8192127,
 8083987,
 -1,
 -65410,
 8150258,
 73986,
 -1,
 8199167,
 73985,
 -1,
 8132381,
 73987,
 -1,
 8067433,
 73991,
 8519833,
 6446322,
 74006,
 8585354,
 8456399,
 74008,
 8716287,
 8519680,
 -1,
 8716425,
 8608275,
 -1,
 8781959,
 8663541,
 74009,
 -1,
 8717685,
 74010,
 -65400,
 8737229,
 74012,
 -1,
 8863843,
 74011,
 -1,
 8660572,
 74013,
 9109647,
 8539084,
 74021,
 9175182,
 9067762,
 -1,
 -65395,
 9130621,
 74024,
 -1,
 9190814,
 74023,
 -1,
 9112244,
 74022,
 9437333,
 9050083,
 74014,
 9568255,
 9371648,
 -1,
 9568404,
 9460243,
 -1,
 -65389,
 9515874,
 74016,
 -1,
 9571209,
 74015,
 -1,
 9520761,
 74017,
 9830551,
 9386212,
 74019,
 -1,
 9766313,
 74020,
 -65384,
 9778057,
 74018,
 -1,
 9896161,
 74007,
 10158079,
 8462279,
 73982,
 -1,
 10028435,
 73983,
 10223908,
 275337,
 -1,
 10289392,
 10160983,
 74167,
 10354922,
 10232882,
 -1,
 10420452,
 10293593,
 74168,
 10551295,
 10354688,
 -1,
 10551523,
 10443283,
 -1,
 10617001,
 10488663,
 74169,
 10682534,
 10552181,
 -1,
 -65372,
 10630197,
 74172,
 -65371,
 10691763,
 74171,
 -1,
 10754065,
 74170,
 -65369,
 10637985,
 74175,
 -65368,
 10894750,
 74174,
 -1,
 10957705,
 74173,
 11141296,
 10575090,
 74213,
 11206829,
 11076469,
 -1,
 -65364,
 11164919,
 74215,
 -1,
 11209559,
 74214,
 -65362,
 11162237,
 74218,
 -65361,
 11343843,
 74217,
 -1,
 11405565,
 74216,
 11600057,
 11096451,
 -1,
 11665592,
 11544199,
 -1,
 11731124,
 11623755,
 74207,
 -1,
 11666499,
 74208,
 11862199,
 11677679,
 -1,
 -65354,
 11819171,
 74206,
 -1,
 11880872,
 74205,
 -1,
 11803701,
 74204,
 -1,
 11624094,
 74209,
 12189888,
 11547030,
 -1,
 12255422,
 12147954,
 -1,
 12320957,
 12202889,
 74194,
 -1,
 12256179,
 74195,
 -1,
 12257638,
 74193,
 12582911,
 12200718,
 74191,
 -1,
 12467614,
 74192,
 12648645,
 12137353,
 -1,
 12714179,
 12606706,
 74198,
 -1,
 12661641,
 74199,
 -65340,
 12660658,
 74197,
 -1,
 12782815,
 74196,
 12976331,
 12593934,
 -1,
 13041866,
 12925156,
 74188,
 13172735,
 12977013,
 -1,
 -65335,
 13056158,
 74190,
 -1,
 13117085,
 74189,
 -1,
 12985755,
 74187,
 13369552,
 12919815,
 -1,
 13435086,
 13327908,
 74182,
 -1,
 13370281,
 74183,
 13631487,
 13372247,
 74180,
 -1,
 13519820,
 74181,
 13697237,
 13326216,
 -1,
 13762772,
 13634391,
 -1,
 -65325,
 13709746,
 74211,
 -1,
 13771783,
 74210,
 -1,
 13704210,
 74212,
 14024921,
 13646052,
 -1,
 14090456,
 13966335,
 74200,
 -1,
 14025632,
 74201,
 -1,
 14049383,
 74202,
 14287069,
 13969031,
 -1,
 14352604,
 14224215,
 74184,
 -1,
 14300041,
 74185,
 -1,
 14297891,
 74186,
 14549216,
 14225753,
 -1,
 -65313,
 14494478,
 74177,
 -1,
 14552161,
 74176,
 -65311,
 14499423,
 74203,
 -65310,
 14687851,
 74179,
 -1,
 14751830,
 74178,
 -1,
 10507742,
 74219,
 15073279,
 10374092,
 74220,
 15138815,
 14942208,
 -1,
 15139048,
 15030830,
 74221,
 -1,
 15074382,
 74222,
 15335423,
 15083100,
 74223,
 -1,
 15205098,
 74224,
 15401197,
 10303716,
 74228,
 15532031,
 15336851,
 74229,
 -1,
 15402024,
 74230,
 15597807,
 15348617,
 74226,
 -1,
 15533470,
 74227,
 -1,
 15542974,
 74225,
 15794464,
 10247410,
 74235,
 15859987,
 15730895,
 74237,
 15990783,
 15794176,
 -1,
 15991054,
 15882120,
 -1,
 16056589,
 15936787,
 -1,
 16122107,
 16003478,
 -1,
 16187642,
 16059489,
 -1,
 16253177,
 16124262,
 74246,
 -1,
 16188292,
 74247,
 -1,
 16189647,
 74245,
 -1,
 16132878,
 74248,
 16515326,
 16077693,
 -1,
 -65283,
 16462247,
 74255,
 -1,
 16515972,
 74254,
 16711937,
 16465310,
 -1,
 -65280,
 16669938,
 74253,
 -1,
 16718847,
 74252,
 16908548,
 16659383,
 -1,
 -65277,
 16852038,
 74250,
 -1,
 16909188,
 74249,
 17105158,
 16850876,
 74240,
 -1,
 17040629,
 74241,
 -65273,
 17062893,
 74256,
 -65272,
 17185550,
 74251,
 -65271,
 17247470,
 74244,
 -65270,
 17311734,
 74243,
 -65269,
 17376396,
 74242,
 -65268,
 17437070,
 74239,
 -1,
 17501587,
 74238,
 -1,
 15998715,
 74257,
 17760529,
 15946115,
 -1,
 -65264,
 17714010,
 74260,
 -1,
 17770422,
 74261,
 -65262,
 17712145,
 74259,
 -1,
 17897309,
 74258,
 18088217,
 15803500,
 74263,
 18219007,
 18022400,
 -1,
 18219288,
 18104530,
 -1,
 -65257,
 18178582,
 74264,
 -1,
 18237981,
 74265,
 -1,
 18174743,
 74266,
 18481436,
 18036964,
 74269,
 18612223,
 18416383,
 74270,
 -1,
 18481473,
 74271,
 -65251,
 18428809,
 74268,
 -65250,
 18622087,
 74267,
 -65249,
 18680166,
 74262,
 -1,
 18744634,
 74236,
 19005439,
 15739662,
 74231,
 -65246,
 18895485,
 74234,
 -65245,
 18955320,
 74233,
 -1,
 19018633,
 74232,
 19202457,
 10170774,
 -1,
 19267967,
 19139415,
 74071,
 19333481,
 19203352,
 -1,
 19398964,
 19276807,
 -1,
 19464493,
 19336023,
 74082,
 19530027,
 19418060,
 74085,
 -1,
 19465265,
 74086,
 -65236,
 19480007,
 74084,
 -1,
 19608457,
 74083,
 19792178,
 19409678,
 74087,
 19857713,
 19747456,
 -1,
 -65232,
 19810750,
 74089,
 -1,
 19863350,
 74090,
 -1,
 19811338,
 74088,
 20185087,
 19750130,
 74091,
 -1,
 20073496,
 74092,
 20250942,
 19353987,
 -1,
 20316474,
 20194951,
 -1,
 -65225,
 20274418,
 74115,
 -65224,
 20327356,
 74114,
 -65223,
 20388863,
 74113,
 -1,
 20450135,
 74112,
 20644156,
 20253527,
 74110,
 -1,
 20597708,
 74111,
 -65219,
 20602435,
 74117,
 -1,
 20720706,
 74116,
 20906310,
 20199652,
 -1,
 20971844,
 20847615,
 74100,
 21102591,
 20906869,
 -1,
 -65214,
 20994134,
 74103,
 -65213,
 21046680,
 74102,
 -1,
 21109714,
 74101,
 21364735,
 20917006,
 74104,
 -1,
 21234707,
 74105,
 21430603,
 20864242,
 74119,
 -65208,
 21385853,
 74123,
 -65207,
 21445933,
 74122,
 -65206,
 21501923,
 74121,
 -1,
 21563599,
 74120,
 21758289,
 21369177,
 -1,
 21823824,
 21695319,
 -1,
 -65202,
 21777356,
 74078,
 -65201,
 21836771,
 74077,
 -1,
 21895139,
 74076,
 -1,
 21768974,
 74079,
 22151509,
 21695319,
 74072,
 22217044,
 22091747,
 74073,
 -1,
 22152131,
 74074,
 -1,
 22172334,
 74075,
 22413657,
 22098326,
 -1,
 22479192,
 22358798,
 74096,
 -1,
 22419427,
 74097,
 -1,
 22416779,
 74095,
 22675804,
 22363550,
 -1,
 -65189,
 22634205,
 74107,
 -1,
 22682623,
 74106,
 22872415,
 22623113,
 -1,
 -65186,
 22830322,
 74099,
 -1,
 22883086,
 74098,
 23069026,
 22817550,
 -1,
 -65183,
 23017700,
 74094,
 -1,
 23078296,
 74093,
 23265637,
 23010303,
 -1,
 -65180,
 23220910,
 74081,
 -1,
 23285611,
 74080,
 -65178,
 23226784,
 74124,
 -65177,
 23418939,
 74118,
 -65176,
 23482644,
 74109,
 -1,
 23546171,
 74108,
 23724399,
 19273699,
 -1,
 23789932,
 23661069,
 74131,
 -1,
 23724754,
 74132,
 -65171,
 23726539,
 74130,
 -65170,
 23857510,
 74129,
 -1,
 23922895,
 74128,
 24117619,
 23680067,
 74140,
 24248319,
 24051712,
 -1,
 -65166,
 24135339,
 74142,
 -1,
 24196077,
 74141,
 24379767,
 24064905,
 74135,
 24510463,
 24313856,
 -1,
 -65162,
 24402458,
 74136,
 -1,
 24450896,
 74137,
 24641914,
 24328420,
 -1,
 -65159,
 24578507,
 74139,
 -1,
 24643791,
 74138,
 24838524,
 24588694,
 74133,
 -1,
 24774005,
 74134,
 24969598,
 24774863,
 74125,
 -1,
 24903918,
 74126,
 -1,
 24908121,
 74127,
 25166219,
 19225842,
 74154,
 25231746,
 25119692,
 74163,
 -1,
 25166414,
 74164,
 25362820,
 25179017,
 74160,
 -1,
 25297237,
 74161,
 25493894,
 25299403,
 74157,
 -1,
 25429456,
 74158,
 -65145,
 25449331,
 74165,
 -65144,
 25574814,
 74162,
 -65143,
 25627316,
 74159,
 -65142,
 25692518,
 74156,
 -1,
 25756297,
 74155,
 25952663,
 25111310,
 74144,
 26018193,
 25907587,
 -1,
 26083727,
 25963761,
 74152,
 -1,
 26018525,
 74153,
 -65136,
 26027655,
 74151,
 -1,
 26152339,
 74150,
 26345877,
 25953560,
 -1,
 26411412,
 26303730,
 74146,
 -1,
 26351587,
 74147,
 -1,
 26349966,
 74145,
 -65130,
 26295710,
 74149,
 -1,
 26548195,
 74148,
 -65128,
 25912991,
 74166,
 -1,
 26681276,
 74143,
 26870272,
 19157379,
 -1,
 26935761,
 26814087,
 -1,
 27001268,
 26880782,
 -1,
 27066794,
 26949860,
 74438,
 27197439,
 27002136,
 -1,
 27197856,
 27077779,
 74444,
 -1,
 27132245,
 74445,
 27328931,
 27136345,
 -1,
 -65118,
 27287193,
 74441,
 -1,
 27331987,
 74440,
 -65116,
 27283913,
 74449,
 -65115,
 27475212,
 74448,
 -65114,
 27539643,
 74447,
 -65113,
 27603814,
 74446,
 -65112,
 27665587,
 74443,
 -65111,
 27728242,
 74442,
 -1,
 27790167,
 74439,
 27984302,
 27020236,
 74451,
 28114943,
 27918336,
 -1,
 -65107,
 28006563,
 74452,
 -1,
 28067592,
 74453,
 28246450,
 27924451,
 74435,
 28377087,
 28181784,
 -1,
 -65103,
 28257518,
 74437,
 -1,
 28314455,
 74436,
 -65101,
 28202912,
 74454,
 -1,
 28458831,
 74450,
 28639682,
 26938199,
 74413,
 28705215,
 28576102,
 74414,
 28835839,
 28640536,
 -1,
 28836281,
 28728562,
 74421,
 -1,
 28771196,
 74422,
 -65094,
 28793891,
 74420,
 -65093,
 28922739,
 74419,
 -65092,
 28982879,
 74418,
 -65091,
 29042098,
 74417,
 -65090,
 29102478,
 74416,
 -1,
 29166423,
 74415,
 -65088,
 28658698,
 74425,
 -65087,
 29299076,
 74424,
 -1,
 29362810,
 74423,
 29557197,
 28580863,
 74426,
 29622726,
 29512317,
 74432,
 -65083,
 29570105,
 74434,
 -1,
 29624527,
 74433,
 29819339,
 29556736,
 -1,
 29884874,
 29771518,
 -1,
 -65079,
 29841319,
 74429,
 -1,
 29893710,
 74428,
 -1,
 29829827,
 74427,
 -65076,
 29769118,
 74431,
 -1,
 30090287,
 74430,
 30343167,
 29514994,
 74455,
 -65073,
 30217007,
 74458,
 -65072,
 30279887,
 74457,
 -1,
 30343871,
 74456,
 30540272,
 26872663,
 74387,
 30605804,
 30483463,
 74389,
 30736383,
 30539776,
 -1,
 30736873,
 30628371,
 -1,
 30802395,
 30694642,
 -1,
 -65065,
 30757501,
 74406,
 -65064,
 30821324,
 74405,
 -65063,
 30882020,
 74404,
 -65062,
 30937433,
 74403,
 -1,
 31000783,
 74402,
 31195614,
 30757251,
 -1,
 -65059,
 31139843,
 74400,
 -1,
 31198611,
 74399,
 31392225,
 31142294,
 -1,
 -65056,
 31350797,
 74395,
 -1,
 31395211,
 74394,
 31588835,
 31333330,
 74391,
 -1,
 31527257,
 74392,
 -65052,
 31545251,
 74401,
 -65051,
 31670371,
 74398,
 -65050,
 31734660,
 74397,
 -65049,
 31799487,
 74396,
 -65048,
 31860381,
 74393,
 -1,
 31918935,
 74390,
 -65046,
 30689013,
 74407,
 -65045,
 32063605,
 74388,
 -1,
 32122460,
 74408,
 32309742,
 30552969,
 74409,
 -1,
 32244171,
 74410,
 -65041,
 32263116,
 74412,
 -1,
 32390941,
 74411,
 32571897,
 30498034,
 74466,
 32637427,
 32525260,
 74473,
 -1,
 32574244,
 74474,
 32768501,
 32585956,
 74471,
 -1,
 32706596,
 74472,
 32899575,
 32708579,
 74468,
 -1,
 32835791,
 74469,
 -65032,
 32844525,
 74470,
 -1,
 32965446,
 74467,
 33226751,
 32516878,
 74459,
 33227261,
 33104903,
 74461,
 33357823,
 33163723,
 74462,
 -1,
 33227574,
 74463,
 -65026,
 33174467,
 74465,
 -65025,
 33370532,
 74464,
 -1,
 33423701,
 74460,
 33620580,
 26828018,
 74507,
 33686068,
 33573836,
 74536,
 33751585,
 33643762,
 74551,
 33817119,
 33686808,
 -1,
 33882634,
 33760263,
 -1,
 33948169,
 33819479,
 74556,
 -65017,
 33901516,
 74559,
 -65016,
 33963463,
 74558,
 -1,
 34026377,
 74557,
 -1,
 33905906,
 74560,
 34275854,
 33840370,
 -1,
 -65012,
 34230556,
 74574,
 -65011,
 34281443,
 74573,
 -1,
 34341801,
 74572,
 34538002,
 34220814,
 -1,
 -65008,
 34493053,
 74564,
 -65007,
 34552036,
 74563,
 -1,
 34612632,
 74562,
 34800149,
 34492803,
 -1,
 -65004,
 34745420,
 74570,
 -1,
 34809709,
 74569,
 34996759,
 34736983,
 74552,
 -1,
 34951967,
 74553,
 -65000,
 34954218,
 74571,
 -64999,
 35080153,
 74568,
 -64998,
 35142620,
 74567,
 -64997,
 35207359,
 74566,
 -64996,
 35271366,
 74565,
 -64995,
 35333789,
 74561,
 -64994,
 35396569,
 74555,
 -1,
 35459510,
 74554,
 35717119,
 33757194,
 74575,
 -1,
 35587508,
 74576,
 35783214,
 33687759,
 74539,
 35913727,
 35718424,
 -1,
 35914279,
 35806539,
 74545,
 36044799,
 35849077,
 -1,
 -64986,
 35918417,
 74547,
 -1,
 35983396,
 74546,
 36176428,
 35851095,
 -1,
 36241963,
 36111221,
 -1,
 -64982,
 36191695,
 74541,
 -1,
 36251293,
 74540,
 -1,
 36189065,
 74542,
 -64979,
 36126819,
 74544,
 -1,
 36447901,
 74543,
 36635184,
 35728142,
 74549,
 -1,
 36571494,
 74550,
 36766259,
 36569088,
 -1,
 -64974,
 36721431,
 74538,
 -1,
 36771729,
 74537,
 -1,
 36702667,
 74548,
 37028416,
 33626083,
 74515,
 37093951,
 36962304,
 -1,
 37159483,
 37050899,
 -1,
 37225017,
 37117184,
 74519,
 -1,
 37159253,
 74520,
 -64966,
 37174148,
 74518,
 -1,
 37294478,
 74517,
 37487165,
 37114647,
 74522,
 -1,
 37422394,
 74523,
 -64962,
 37434214,
 74516,
 -1,
 37561948,
 74521,
 -1,
 37051959,
 74524,
 37814859,
 36976868,
 74525,
 37880390,
 37750040,
 -1,
 -64957,
 37838066,
 74529,
 -64956,
 37900982,
 74528,
 -64955,
 37960451,
 74527,
 -1,
 38024167,
 74526,
 38208074,
 37838494,
 74531,
 38338559,
 38143256,
 -1,
 -64951,
 38225881,
 74533,
 -1,
 38285860,
 74532,
 -1,
 38146656,
 74530,
 38535764,
 37769853,
 74577,
 38601297,
 38470936,
 -1,
 38666831,
 38548319,
 74579,
 -1,
 38620108,
 74580,
 -64944,
 38623188,
 74581,
 -1,
 38734679,
 74578,
 -64942,
 38561463,
 74582,
 -64941,
 38887129,
 74584,
 -1,
 38930639,
 74583,
 39125595,
 38469632,
 -1,
 39191129,
 39077707,
 -1,
 -64937,
 39148816,
 74512,
 -64936,
 39212857,
 74511,
 -1,
 39274460,
 74510,
 -64934,
 39148843,
 74509,
 -1,
 39396952,
 74508,
 39584351,
 39086311,
 -1,
 39649886,
 39520614,
 74586,
 -1,
 39585157,
 74587,
 -1,
 39607538,
 74588,
 39846497,
 39533982,
 74534,
 -1,
 39780693,
 74535,
 -64926,
 39803924,
 74585,
 -64925,
 39915865,
 74514,
 -1,
 39979215,
 74513,
 40174259,
 33557335,
 73728,
 40239740,
 40112473,
 73738,
 40305269,
 40173568,
 -1,
 40370804,
 40262163,
 -1,
 40436331,
 40315662,
 -1,
 -64918,
 40385500,
 73745,
 -1,
 40445339,
 73744,
 40632942,
 40379442,
 -1,
 -64915,
 40582599,
 73742,
 -1,
 40645513,
 73741,
 -64913,
 40590592,
 73748,
 -64912,
 40784657,
 73747,
 -64911,
 40842215,
 73746,
 -64910,
 40904349,
 73743,
 -64909,
 40967133,
 73740,
 -1,
 41029672,
 73739,
 -1,
 40314460,
 73749,
 41353215,
 40241359,
 73750,
 41418751,
 41223448,
 -1,
 -64904,
 41310164,
 73755,
 -64903,
 41374390,
 73754,
 -64902,
 41433870,
 73753,
 -64901,
 41493644,
 73752,
 -1,
 41554335,
 73751,
 41747081,
 40186761,
 73760,
 41812615,
 41682200,
 -1,
 41878145,
 41759126,
 -1,
 -64896,
 41822990,
 73766,
 -1,
 41880676,
 73765,
 -64894,
 41836647,
 73768,
 -64893,
 42029827,
 73767,
 -64892,
 42083997,
 73764,
 -64891,
 42149298,
 73763,
 -64890,
 42211693,
 73762,
 -1,
 42274195,
 73761,
 -64888,
 41754412,
 73770,
 -1,
 42405451,
 73769,
 42599061,
 41701763,
 -1,
 42664596,
 42542727,
 73784,
 42730130,
 42598400,
 -1,
 42795664,
 42681902,
 -1,
 42861199,
 42747429,
 73788,
 -1,
 42795186,
 73789,
 -1,
 42818546,
 73787,
 -64879,
 42756515,
 73785,
 -1,
 43004375,
 73786,
 -64877,
 42673222,
 73791,
 -1,
 43124943,
 73790,
 -1,
 42601878,
 73783,
 43385502,
 42534168,
 -1,
 -64873,
 43340229,
 73736,
 -64872,
 43400559,
 73735,
 -64871,
 43463694,
 73734,
 -64870,
 43527315,
 73733,
 -64869,
 43591325,
 73732,
 -64868,
 43656332,
 73731,
 -64867,
 43717006,
 73730,
 -1,
 43780951,
 73729,
 43975334,
 43335070,
 73773,
 44040869,
 43909120,
 -1,
 44106403,
 43993523,
 -1,
 -64862,
 44062174,
 73777,
 -1,
 44123107,
 73776,
 -64860,
 44063141,
 73775,
 -1,
 44254749,
 73774,
 -1,
 43995907,
 73778,
 44499626,
 43928524,
 -1,
 44565161,
 44436577,
 73780,
 -1,
 44500371,
 73781,
 -1,
 44511699,
 73782,
 44761774,
 44446102,
 73757,
 44892159,
 44696856,
 -1,
 -64851,
 44782379,
 73759,
 -1,
 44834693,
 73758,
 45023920,
 44710470,
 73771,
 -1,
 44959145,
 73772,
 -64847,
 44976499,
 73779,
 -64846,
 45094883,
 73756,
 -1,
 45156559,
 73737,
 45351677,
 40123806,
 -1,
 45417169,
 45309170,
 74337,
 45482704,
 45366686,
 74339,
 45548229,
 45441285,
 74349,
 45678591,
 45481984,
 -1,
 45679299,
 45550551,
 -1,
 -64838,
 45636939,
 74359,
 -64837,
 45700046,
 74358,
 -64836,
 45760095,
 74357,
 -64835,
 45822903,
 74356,
 -64834,
 45887969,
 74355,
 -64833,
 45952151,
 74354,
 -64832,
 46016088,
 74353,
 -64831,
 46078933,
 74352,
 -64830,
 46142033,
 74351,
 -1,
 46207021,
 74350,
 46465023,
 45626076,
 74360,
 -1,
 46335437,
 74361,
 46596095,
 45481984,
 -1,
 46596812,
 46478361,
 -1,
 46662345,
 46551497,
 74342,
 -1,
 46596892,
 74343,
 -64822,
 46620775,
 74344,
 -64821,
 46742158,
 74341,
 -1,
 46802099,
 74340,
 46990030,
 46536568,
 74347,
 -1,
 46924253,
 74348,
 -64817,
 46946467,
 74345,
 -1,
 47073004,
 74346,
 -1,
 45418676,
 74338,
 47317740,
 45361934,
 74316,
 47383269,
 47267403,
 74322,
 47513599,
 47318296,
 -1,
 47514329,
 47403779,
 74330,
 47644671,
 47448956,
 -1,
 47645400,
 47534717,
 74332,
 -1,
 47580036,
 74333,
 -1,
 47579190,
 74331,
 47842013,
 47450967,
 -1,
 47907548,
 47796861,
 74324,
 -1,
 47842180,
 74325,
 -1,
 47857054,
 74323,
 48104160,
 47799538,
 -1,
 -64801,
 48059005,
 74335,
 -1,
 48105725,
 74334,
 48300771,
 48053662,
 -1,
 -64798,
 48258781,
 74329,
 -1,
 48307199,
 74328,
 -64796,
 48249625,
 74327,
 -1,
 48440920,
 74326,
 48628457,
 47331556,
 74319,
 48758783,
 48563546,
 -1,
 -64792,
 48647136,
 74321,
 -1,
 48709063,
 74320,
 -64790,
 48583109,
 74336,
 -64789,
 48826575,
 74318,
 -1,
 48891205,
 74317,
 49087223,
 47254359,
 74302,
 49152755,
 49030194,
 74304,
 49218290,
 49086464,
 -1,
 -64784,
 49175096,
 74306,
 -64783,
 49234974,
 74307,
 -1,
 49295025,
 74305,
 -1,
 49171404,
 74308,
 49545974,
 49101028,
 74310,
 -64779,
 49481935,
 74311,
 -1,
 49545781,
 74309,
 -1,
 49481935,
 74303,
 49872895,
 49028095,
 74312,
 49938431,
 49741824,
 -1,
 49939196,
 49830419,
 -1,
 -64773,
 49896996,
 74314,
 -1,
 49941335,
 74313,
 -1,
 49894167,
 74315,
 50201403,
 45291491,
 -1,
 50266914,
 50137943,
 73813,
 50332445,
 50209799,
 73814,
 50462719,
 50266550,
 -1,
 50463495,
 50340871,
 -1,
 50529028,
 50408206,
 73821,
 -1,
 50482186,
 73822,
 50660102,
 50465623,
 73819,
 -1,
 50594812,
 73820,
 -1,
 50617892,
 73823,
 50856716,
 50410377,
 -1,
 50922251,
 50814194,
 73829,
 -64758,
 50870500,
 73831,
 -1,
 50922503,
 73830,
 -1,
 50858839,
 73828,
 51184399,
 50814194,
 -1,
 -64754,
 51139197,
 73837,
 -1,
 51185939,
 73836,
 51381009,
 51130193,
 73825,
 -1,
 51315680,
 73826,
 51512084,
 51319129,
 -1,
 -64749,
 51456782,
 73818,
 -1,
 51514783,
 73817,
 51708695,
 51448663,
 -1,
 -64746,
 51657286,
 73816,
 -1,
 51708924,
 73815,
 -64744,
 51664852,
 73835,
 -64743,
 51860349,
 73834,
 -64742,
 51923024,
 73833,
 -64741,
 51986015,
 73832,
 -64740,
 52048373,
 73827,
 -1,
 52111005,
 73824,
 52298529,
 50285516,
 73839,
 52428799,
 52235095,
 -1,
 -64736,
 52300235,
 73841,
 -1,
 52365670,
 73840,
 -1,
 52246756,
 73838,
 52626227,
 50224370,
 73850,
 52691752,
 52575646,
 73860,
 52757287,
 52627814,
 73861,
 52887551,
 52691285,
 73862,
 -1,
 52756821,
 73863,
 -1,
 52693451,
 73864,
 53019435,
 52629849,
 73854,
 -64726,
 52955343,
 73856,
 -1,
 53019982,
 73855,
 53216047,
 52953088,
 -1,
 -64723,
 53170967,
 73853,
 -64722,
 53233217,
 73851,
 -1,
 53290588,
 73852,
 53478193,
 53158919,
 73857,
 -1,
 53435940,
 73858,
 -64718,
 53431306,
 73865,
 -1,
 53552775,
 73859,
 53805055,
 52570894,
 73842,
 53805879,
 53688548,
 73844,
 -64714,
 53741775,
 73846,
 -1,
 53806505,
 73845,
 54002489,
 53755294,
 73847,
 -1,
 53936531,
 73848,
 -64710,
 53957245,
 73849,
 -1,
 54071641,
 73843,
 54264688,
 50142207,
 73866,
 54330196,
 54225189,
 73889,
 54460415,
 54265112,
 -1,
 54461251,
 54342537,
 -1,
 54526785,
 54397783,
 73903,
 -1,
 54473611,
 73904,
 -64702,
 54484210,
 73906,
 -1,
 54602510,
 73905,
 54788935,
 54397783,
 73890,
 54854470,
 54723542,
 73891,
 -1,
 54789534,
 73892,
 -1,
 54803870,
 73893,
 55051083,
 54735254,
 -1,
 55116618,
 54988852,
 73900,
 -1,
 55051468,
 73901,
 -1,
 55074126,
 73902,
 55313230,
 55008498,
 -1,
 -64691,
 55252963,
 73908,
 -1,
 55314639,
 73907,
 55509840,
 55256733,
 73897,
 -1,
 55443797,
 73898,
 55640914,
 55450589,
 73895,
 -1,
 55574869,
 73896,
 -64685,
 55585943,
 73899,
 -1,
 55710094,
 73894,
 55903069,
 54279582,
 73879,
 56033279,
 55836672,
 -1,
 56034138,
 55925267,
 -1,
 56099673,
 55977095,
 73880,
 -1,
 56034549,
 73881,
 -1,
 56048384,
 73882,
 -64677,
 55989726,
 73885,
 -64676,
 56247289,
 73884,
 -1,
 56301315,
 73883,
 56492902,
 55838927,
 73869,
 56623103,
 56427800,
 -1,
 56623970,
 56512899,
 -1,
 -64671,
 56567661,
 73874,
 -1,
 56626579,
 73873,
 -64669,
 56581362,
 73875,
 -64668,
 56769412,
 73872,
 -64667,
 56829107,
 73871,
 -1,
 56888172,
 73870,
 57082729,
 56445900,
 -1,
 -64664,
 57027902,
 73887,
 -1,
 57089643,
 73886,
 57279340,
 57016320,
 -1,
 -64661,
 57236004,
 73867,
 -1,
 57296457,
 73868,
 -64659,
 57234094,
 73888,
 -64658,
 57422729,
 73878,
 -64657,
 57484718,
 73877,
 -1,
 57547122,
 73876,
 57738135,
 54220680,
 -1,
 57803655,
 57674583,
 74475,
 57869179,
 57746439,
 74483,
 57999359,
 57804056,
 -1,
 58000247,
 57889405,
 -1,
 -64650,
 57957618,
 74487,
 -1,
 58006527,
 74486,
 -64648,
 57957924,
 74489,
 -64647,
 58153965,
 74488,
 -64646,
 58205784,
 74485,
 -1,
 58266193,
 74484,
 58459009,
 57802752,
 -1,
 58524543,
 58415635,
 -1,
 -64642,
 58473348,
 74478,
 -1,
 58533869,
 74477,
 -64640,
 58467932,
 74479,
 -1,
 58658896,
 74476,
 58852229,
 58397017,
 74480,
 58982399,
 58785792,
 -1,
 -64636,
 58873310,
 74482,
 -1,
 58935071,
 74481,
 -64634,
 58805196,
 74491,
 -1,
 59060658,
 74490,
 59245455,
 57748238,
 74494,
 59310989,
 59198412,
 74497,
 59441151,
 59244544,
 -1,
 59442060,
 59328322,
 74499,
 -1,
 59375910,
 74500,
 -1,
 59398727,
 74498,
 -64626,
 59257737,
 74496,
 -1,
 59573493,
 74495,
 59769749,
 59202802,
 74501,
 59835282,
 59722700,
 74505,
 -1,
 59769679,
 74506,
 -64621,
 59783396,
 74504,
 -64620,
 59912598,
 74503,
 -1,
 59974697,
 74502,
 60227583,
 59710463,
 74492,
 -1,
 60096853,
 74493,
 60294075,
 57686244,
 -1,
 60359598,
 60251378,
 74284,
 60425129,
 60314237,
 74290,
 60490658,
 60358656,
 -1,
 60556191,
 60447251,
 -1,
 -64611,
 60516599,
 74293,
 -64610,
 60568418,
 74292,
 -1,
 60623703,
 74291,
 60818337,
 60507874,
 74294,
 -1,
 60753193,
 74295,
 -1,
 60757866,
 74296,
 61079551,
 60426598,
 74297,
 61145087,
 60948480,
 -1,
 61146024,
 61037075,
 -1,
 61211559,
 61082455,
 74298,
 -1,
 61145998,
 74299,
 -1,
 61151470,
 74300,
 -1,
 61089372,
 74301,
 61473707,
 60367879,
 74286,
 -1,
 61407573,
 74287,
 -64596,
 61427220,
 74289,
 -64595,
 61554674,
 74288,
 -1,
 61604617,
 74285,
 61801399,
 60296023,
 74272,
 61866929,
 61756029,
 74278,
 -1,
 61802703,
 74279,
 61998004,
 61800448,
 -1,
 -64589,
 61954631,
 74273,
 -1,
 62006876,
 74274,
 -64587,
 61950924,
 74277,
 -64586,
 62137991,
 74276,
 -1,
 62195919,
 74275,
 62391225,
 61745934,
 74282,
 -1,
 62340510,
 74283,
 62586879,
 62331903,
 74280,
 -1,
 62476675,
 74281,
 62653398,
 60238606,
 74047,
 62718915,
 62601444,
 74062,
 62784450,
 62652416,
 -1,
 -64577,
 62741063,
 74063,
 -64576,
 62805470,
 74066,
 -64575,
 62866437,
 74065,
 -1,
 62920516,
 74064,
 -1,
 62729517,
 74067,
 63177674,
 62661639,
 74053,
 63307775,
 63122190,
 74054,
 63373311,
 63176704,
 -1,
 -64569,
 63262260,
 74056,
 -64568,
 63325832,
 74057,
 -64567,
 63383132,
 74058,
 -1,
 63445311,
 74055,
 63636429,
 63124361,
 74059,
 -64564,
 63572175,
 74061,
 -1,
 63636836,
 74060,
 63833041,
 63576425,
 74050,
 63963135,
 63767219,
 -1,
 -64560,
 63854046,
 74052,
 -1,
 63902511,
 74051,
 -64558,
 63787645,
 74070,
 -64557,
 64048076,
 74069,
 -64556,
 64109982,
 74068,
 -64555,
 64164185,
 74049,
 -1,
 64225282,
 74048,
 64422896,
 62596743,
 -1,
 64488418,
 64367374,
 74029,
 64618495,
 64423192,
 -1,
 64619483,
 64491556,
 74030,
 -1,
 64555215,
 74031,
 -64548,
 64576754,
 74038,
 -64547,
 64705283,
 74037,
 -64546,
 64766051,
 74036,
 -64545,
 64828115,
 74035,
 -64544,
 64889930,
 74034,
 -64543,
 64952726,
 74033,
 -1,
 65016206,
 74032,
 65209323,
 64445682,
 74039,
 65274858,
 65147244,
 74040,
 65404927,
 65209624,
 -1,
 -64538,
 65297956,
 74045,
 -64537,
 65353464,
 74044,
 -64536,
 65417764,
 74043,
 -64535,
 65480377,
 74042,
 -1,
 65539659,
 74041,
 -1,
 65221556,
 74046,
 65863679,
 65145687,
 74025,
 65864687,
 65732608,
 -1,
 -64530,
 65820835,
 74026,
 -1,
 65873500,
 74027,
 -1,
 65811337,
 74028,
 66126859,
 64374677,
 -1,
 66192390,
 66071310,
 74367,
 66257919,
 66125824,
 -1,
 66323454,
 66214419,
 -1,
 66388982,
 66280690,
 74375,
 -1,
 66324687,
 74376,
 66520056,
 66333454,
 74373,
 -1,
 66457945,
 74374,
 66651131,
 66457945,
 -1,
 -64518,
 66608370,
 74371,
 -1,
 66661134,
 74370,
 66847741,
 66587479,
 74368,
 -1,
 66785625,
 74369,
 -1,
 66788351,
 74372,
 -1,
 66262917,
 74377,
 67174399,
 66211469,
 74378,
 67239935,
 67043328,
 -1,
 67240965,
 67131923,
 -1,
 -64509,
 67201271,
 74381,
 -64508,
 67264036,
 74380,
 -1,
 67318270,
 74379,
 -1,
 67191852,
 74382,
 67568650,
 66128727,
 74362,
 -64504,
 67520405,
 74365,
 -64503,
 67583390,
 74364,
 -1,
 67639267,
 74363,
 -1,
 67510204,
 74366,
 67896356,
 66064729,
 -1,
 67961877,
 67832663,
 73792,
 68027408,
 67908489,
 73796,
 -64497,
 67964124,
 73798,
 -1,
 68026972,
 73797,
 68224018,
 67980236,
 73799,
 -1,
 68160441,
 73800,
 -64493,
 68167466,
 73795,
 -64492,
 68297772,
 73794,
 -1,
 68360163,
 73793,
 68551711,
 67919090,
 73805,
 68617243,
 68485120,
 -1,
 68682778,
 68568632,
 -1,
 -64487,
 68640477,
 73807,
 -1,
 68684756,
 73806,
 -1,
 68622071,
 73808,
 68944925,
 68570060,
 73811,
 -1,
 68880591,
 73812,
 69140479,
 68892849,
 73809,
 -1,
 69010022,
 73810,
 69271551,
 68496142,
 73801,
 69337087,
 69141784,
 -1,
 -64478,
 69217431,
 73804,
 -64477,
 69280947,
 73803,
 -1,
 69339991,
 73802,
 69534776,
 67856615,
 -1,
 69600300,
 69479182,
 74595,
 69665832,
 69538137,
 74598,
 -1,
 69599617,
 74599,
 -64471,
 69626100,
 74601,
 -64470,
 69739527,
 74600,
 -64469,
 69798246,
 74597,
 -1,
 69862244,
 74596,
 70059057,
 69557490,
 74602,
 70124591,
 69995021,
 74603,
 -1,
 70059296,
 74604,
 -64464,
 70072548,
 74606,
 -1,
 70193967,
 74605,
 70386743,
 69995351,
 74589,
 70452277,
 70320128,
 -1,
 -64460,
 70408355,
 74590,
 -1,
 70473199,
 74591,
 -64458,
 70401419,
 74593,
 -1,
 70591495,
 74592,
 -1,
 70327421,
 74594,
 70909951,
 69487564,
 -1,
 70911035,
 70781783,
 74383,
 -1,
 70848857,
 74384,
 -64452,
 70868210,
 74386,
 -1,
 70986510,
 74385,
 71173320,
 213077,
 -1,
 71238756,
 71115198,
 -1,
 71304275,
 71189928,
 -1,
 71369797,
 71262607,
 74812,
 71435332,
 71303168,
 -1,
 -64445,
 71373145,
 74815,
 -1,
 71437143,
 74814,
 -1,
 71371211,
 74813,
 71697481,
 71307609,
 -1,
 71763016,
 71634510,
 74834,
 -1,
 71697872,
 74835,
 -1,
 71721056,
 74808,
 71959628,
 71652076,
 -1,
 -64437,
 71916786,
 74800,
 -1,
 71960783,
 74790,
 72156239,
 71902520,
 -1,
 -64434,
 72113394,
 74785,
 -1,
 72157391,
 74776,
 72352849,
 72093732,
 74754,
 -1,
 72287477,
 74828,
 -64430,
 72310002,
 74767,
 -1,
 72423830,
 74761,
 72679423,
 71250019,
 -1,
 72680537,
 72569219,
 -1,
 72746072,
 72623910,
 -1,
 -64425,
 72703218,
 74801,
 -1,
 72747215,
 74791,
 -1,
 72691881,
 74844,
 73008221,
 72618329,
 -1,
 73073756,
 72945230,
 74836,
 -1,
 73008592,
 74837,
 -1,
 73031776,
 74809,
 73270368,
 72951096,
 -1,
 -64417,
 73227506,
 74786,
 -1,
 73271503,
 74777,
 73466978,
 73207844,
 74755,
 -1,
 73401589,
 74829,
 -64413,
 73424114,
 74768,
 -1,
 73537942,
 74762,
 73729160,
 71194504,
 -1,
 73794680,
 73673248,
 -1,
 73860203,
 73749228,
 -1,
 73925737,
 73817330,
 74798,
 -1,
 73860560,
 74799,
 74121215,
 73861327,
 74788,
 -1,
 73991632,
 74789,
 74187887,
 73797977,
 -1,
 74253422,
 74145888,
 74806,
 -1,
 74188240,
 74807,
 -1,
 74190414,
 74833,
 74450034,
 74146136,
 -1,
 -64399,
 74385736,
 74811,
 -1,
 74451135,
 74810,
 74646645,
 74392888,
 -1,
 -64396,
 74603762,
 74784,
 -1,
 74647759,
 74775,
 74843255,
 74584100,
 74753,
 -1,
 74777845,
 74827,
 -1,
 74783126,
 74760,
 75104255,
 73754091,
 -1,
 75105404,
 74996068,
 -1,
 -64389,
 75063607,
 74846,
 -1,
 75110806,
 74843,
 75302015,
 75059948,
 -1,
 -64386,
 75259122,
 74797,
 -1,
 75303119,
 74787,
 75498626,
 75244856,
 -1,
 -64383,
 75455730,
 74783,
 -1,
 75499727,
 74774,
 75695237,
 75436377,
 -1,
 -64380,
 75653216,
 74805,
 -1,
 75697742,
 74832,
 75891847,
 75632676,
 74752,
 -1,
 75826421,
 74826,
 -1,
 75833281,
 74841,
 76088479,
 73683331,
 -1,
 76154004,
 76030040,
 -1,
 76219535,
 76112253,
 -1,
 76285070,
 76152832,
 -1,
 -64371,
 76222809,
 74819,
 -1,
 76286807,
 74818,
 -1,
 76220774,
 74817,
 -64368,
 76176626,
 74770,
 -64367,
 76501745,
 74793,
 -64366,
 76555581,
 74779,
 -64365,
 76618134,
 74764,
 -1,
 76681252,
 74757,
 76874908,
 76099733,
 -1,
 76940439,
 76812324,
 74756,
 -1,
 76874997,
 74830,
 -64360,
 76898630,
 74816,
 -64359,
 77028594,
 74769,
 -64358,
 77091569,
 74792,
 -64357,
 77145405,
 74778,
 -1,
 77207958,
 74763,
 77463551,
 76818223,
 -1,
 -64354,
 77347804,
 74803,
 -1,
 77404566,
 74802,
 77595826,
 76038354,
 -1,
 77661359,
 77545058,
 -1,
 77726884,
 77617487,
 -1,
 -64349,
 77685047,
 74845,
 -1,
 77732246,
 74842,
 77923495,
 77669688,
 -1,
 -64346,
 77880562,
 74782,
 -1,
 77924559,
 74773,
 78120106,
 77863935,
 -1,
 -64343,
 78074631,
 74840,
 -1,
 78130313,
 74847,
 78316717,
 78057817,
 -1,
 -64340,
 78274656,
 74804,
 -1,
 78319182,
 74831,
 -64338,
 78271229,
 74796,
 -1,
 78465897,
 74848,
 78708735,
 77608137,
 -1,
 -64335,
 78599206,
 74849,
 -1,
 78662497,
 74850,
 78841024,
 77545270,
 -1,
 78906557,
 78790242,
 -1,
 78972088,
 78864745,
 74822,
 -64330,
 78907851,
 74824,
 -64329,
 78973286,
 74823,
 -1,
 79036418,
 74825,
 -64327,
 78929138,
 74772,
 -64326,
 79188721,
 74795,
 -64325,
 79242557,
 74781,
 -64324,
 79305110,
 74766,
 -1,
 79368228,
 74759,
 79626239,
 78849443,
 -1,
 -64321,
 79510492,
 74838,
 -1,
 79568824,
 74839,
 79822847,
 78781926,
 -1,
 79824067,
 79716770,
 74820,
 -1,
 79759718,
 74821,
 -64316,
 79781106,
 74771,
 -64315,
 79909617,
 74794,
 -64314,
 79963453,
 74780,
 -64313,
 80026006,
 74765,
 -1,
 80089124,
 74758,
 80347135,
 71125695,
 -1,
 80348364,
 80222487,
 -1,
 -64309,
 80304993,
 74867,
 -1,
 80352789,
 74866,
 -64307,
 80306805,
 74865,
 -1,
 80495112,
 74864,
 -1,
 149412,
 9982,
 80741959,
 82130,
 -1,
 80807302,
 80689831,
 -1,
 80872711,
 80745288,
 -1,
 80938246,
 80832655,
 -1,
 81003773,
 80885253,
 -1,
 81069275,
 80944127,
 -1,
 81134807,
 81023363,
 11757,
 -1,
 81070014,
 11765,
 -64296,
 81087436,
 11756,
 -64295,
 81214878,
 11753,
 -64294,
 81279204,
 11752,
 -1,
 81343369,
 11751,
 81528032,
 81013518,
 -1,
 81593567,
 81478970,
 -1,
 -64290,
 81531480,
 11775,
 -1,
 81595223,
 11772,
 -1,
 81533951,
 11767,
 81855715,
 81488103,
 -1,
 -64286,
 81799021,
 11748,
 -1,
 81861631,
 11749,
 82052326,
 81815320,
 -1,
 -64283,
 82009330,
 11771,
 -1,
 82055257,
 11770,
 82248937,
 82007944,
 -1,
 -64280,
 82203169,
 11760,
 -1,
 82254847,
 11758,
 82445548,
 82203261,
 -1,
 -64277,
 82383975,
 11763,
 -1,
 82447191,
 11762,
 82642159,
 82384867,
 -1,
 -64274,
 82587942,
 11768,
 -1,
 82648063,
 11747,
 82838770,
 82579801,
 -1,
 -64271,
 82783301,
 11774,
 -1,
 82844671,
 11744,
 -64269,
 82797000,
 11745,
 -64268,
 82987135,
 11755,
 -64267,
 83050706,
 11754,
 -64266,
 83115193,
 11769,
 -64265,
 83179261,
 11773,
 -64264,
 83243445,
 11750,
 -64263,
 83306141,
 11759,
 -64262,
 83371368,
 11746,
 -64261,
 83436245,
 11764,
 -64260,
 83498098,
 11761,
 -1,
 83561303,
 11766,
 83756288,
 80959368,
 -1,
 -64257,
 83700213,
 42610,
 -1,
 83762798,
 42608,
 83952899,
 83707797,
 -1,
 -64254,
 83902973,
 1159,
 -1,
 83956046,
 42621,
 -64252,
 83911660,
 42607,
 -64251,
 84095565,
 42620,
 -1,
 84159191,
 42609,
 -1,
 80888619,
 65062,
 84411692,
 80819081,
 -1,
 84477218,
 84349124,
 -1,
 84542748,
 84432086,
 -1,
 84608270,
 84478807,
 -1,
 -64244,
 84566280,
 7638,
 -64243,
 84623570,
 7637,
 -1,
 84679679,
 7636,
 84870417,
 84560846,
 -1,
 -64240,
 84824231,
 7651,
 -1,
 84873747,
 7626,
 85067027,
 84816777,
 7645,
 -1,
 85017359,
 7653,
 -64236,
 85027047,
 7654,
 -64235,
 85152131,
 7652,
 -64234,
 85212574,
 7648,
 -64233,
 85275030,
 7644,
 -64232,
 85339754,
 7640,
 -64231,
 85402631,
 7642,
 -64230,
 85467884,
 7635,
 -64229,
 85532654,
 7641,
 -1,
 85594954,
 7639,
 85852159,
 84489796,
 -1,
 -64226,
 85740492,
 7650,
 -64225,
 85802398,
 7649,
 -64224,
 85866724,
 7647,
 -64223,
 85930889,
 7646,
 -1,
 85992455,
 7643,
 86181163,
 84417917,
 -1,
 86246698,
 86114304,
 -1,
 86312233,
 86183867,
 -1,
 86377768,
 86255481,
 -1,
 -64217,
 86315539,
 852,
 -1,
 86379526,
 7678,
 -1,
 86311059,
 8430,
 -1,
 86255298,
 849,
 -1,
 86205502,
 8429,
 -1,
 86131444,
 8427,
 86836562,
 84350947,
 -1,
 86902085,
 86777928,
 -1,
 86967612,
 86841687,
 -1,
 87033138,
 86923144,
 -1,
 -64207,
 86992360,
 43234,
 -1,
 87042587,
 43235,
 87229749,
 86987139,
 -1,
 -64204,
 87175314,
 43238,
 -1,
 87236691,
 43239,
 87426360,
 87171518,
 -1,
 -64201,
 87377316,
 43236,
 -1,
 87437407,
 43237,
 -64199,
 87386431,
 43232,
 -64198,
 87573151,
 43233,
 -64197,
 87637857,
 43241,
 -1,
 87694816,
 43240,
 87885124,
 86914565,
 -1,
 -64194,
 87843530,
 43248,
 -64193,
 87907570,
 43243,
 -64192,
 87968795,
 43247,
 -64191,
 88033241,
 43246,
 -64190,
 88096207,
 43245,
 -64189,
 88158645,
 43244,
 -1,
 88214359,
 43242,
 -1,
 87839634,
 43249,
 88539135,
 86851794,
 -1,
 88540493,
 88432044,
 -1,
 88606025,
 88488243,
 862,
 -1,
 88539283,
 863,
 88737099,
 88543993,
 861,
 -1,
 88670355,
 860,
 -64180,
 88690555,
 858,
 -1,
 88806736,
 7629,
 89063423,
 88496008,
 -1,
 89064785,
 88954969,
 -1,
 -64176,
 89007627,
 7616,
 -1,
 89066568,
 7617,
 -1,
 88997900,
 856,
 89326943,
 86789777,
 -1,
 89392478,
 89260032,
 -1,
 89458013,
 89329595,
 -1,
 89523548,
 89401209,
 -1,
 89589083,
 89459543,
 -1,
 89654618,
 89538107,
 -1,
 -64167,
 89612213,
 854,
 -1,
 89660258,
 7679,
 -1,
 89592564,
 848,
 -1,
 89526803,
 853,
 -1,
 89456787,
 8431,
 -1,
 89401026,
 855,
 -1,
 89351230,
 8428,
 90178919,
 89274675,
 -1,
 90244452,
 90113783,
 -1,
 -64158,
 90187269,
 7622,
 -64157,
 90247929,
 7628,
 -1,
 90311746,
 7620,
 90570751,
 90177536,
 -1,
 -64154,
 90459806,
 65061,
 -1,
 90518852,
 65060,
 90703216,
 90121709,
 -1,
 90768749,
 90643769,
 -1,
 90834284,
 90724232,
 -1,
 -64149,
 90787803,
 119362,
 -1,
 90841080,
 119363,
 -1,
 90785997,
 119364,
 91160575,
 90706204,
 -1,
 -64145,
 91044147,
 7621,
 -1,
 91098197,
 7624,
 91293048,
 90639191,
 -1,
 91358580,
 91248233,
 -1,
 -64141,
 91296275,
 857,
 -1,
 91360262,
 8432,
 91555191,
 91297749,
 -1,
 -64138,
 91502899,
 7623,
 -1,
 91563544,
 7625,
 -1,
 91502484,
 7677,
 91817339,
 91253165,
 -1,
 -64134,
 91755027,
 7631,
 -1,
 91819014,
 859,
 92013950,
 91774194,
 -1,
 -64131,
 91967877,
 7634,
 -1,
 92031953,
 7633,
 92210561,
 91967875,
 -1,
 -64128,
 92168363,
 7619,
 -1,
 92225018,
 7618,
 -64126,
 92169913,
 851,
 -64125,
 92357018,
 7630,
 -64124,
 92417944,
 7632,
 -64123,
 92480063,
 850,
 -1,
 92541695,
 7627,
 92735019,
 80759447,
 -1,
 92800471,
 92688771,
 -1,
 92865997,
 92748244,
 -1,
 92931488,
 92815570,
 11423,
 92997023,
 92878021,
 -1,
 93062553,
 92935858,
 -1,
 93128081,
 93005447,
 -1,
 93193615,
 93064023,
 11471,
 -1,
 93149064,
 11477,
 -64112,
 93144174,
 11469,
 -1,
 93265365,
 11475,
 93455764,
 93082237,
 -1,
 -64109,
 93400309,
 11483,
 -1,
 93461973,
 11461,
 -64107,
 93406072,
 11455,
 -64106,
 93594785,
 11479,
 -64105,
 93659064,
 11463,
 -64104,
 93723067,
 11481,
 -1,
 93785415,
 11445,
 94044159,
 93012000,
 -1,
 94045597,
 93928862,
 -1,
 -64100,
 94005244,
 11489,
 -1,
 94053784,
 11487,
 -64098,
 94004320,
 11491,
 -1,
 94196517,
 11485,
 -1,
 92947831,
 11441,
 94438823,
 92870627,
 -1,
 94504358,
 94382934,
 -1,
 -64093,
 94453558,
 11451,
 -64092,
 94515719,
 11449,
 -64091,
 94579073,
 11467,
 -1,
 94637497,
 11443,
 -1,
 94440884,
 11399,
 94897582,
 94377676,
 -1,
 94963117,
 94857325,
 -1,
 -64086,
 94917388,
 11500,
 -64085,
 94977846,
 11453,
 -64084,
 95036577,
 11502,
 -1,
 95100380,
 11447,
 -1,
 94913793,
 11459,
 95356338,
 94851459,
 -1,
 -64080,
 95307127,
 11403,
 -64079,
 95366389,
 11429,
 -1,
 95424070,
 11457,
 95618486,
 95302038,
 -1,
 -64076,
 95572861,
 11421,
 -64075,
 95627245,
 11437,
 -1,
 95686372,
 11413,
 95880633,
 95573896,
 -1,
 -64072,
 95823824,
 11409,
 -1,
 95883508,
 11431,
 96077244,
 95831957,
 -1,
 -64069,
 96031613,
 11439,
 -1,
 96086798,
 11425,
 96273855,
 96023433,
 -1,
 -64066,
 96211191,
 11415,
 -1,
 96274323,
 11473,
 96470466,
 96209751,
 -1,
 -64063,
 96417390,
 11393,
 -1,
 96481977,
 11465,
 -64061,
 96430349,
 11405,
 -64060,
 96625370,
 11395,
 -64059,
 96689500,
 11433,
 -64058,
 96751693,
 11427,
 -64057,
 96812854,
 11419,
 -64056,
 96877444,
 11417,
 -64055,
 96938927,
 11411,
 -64054,
 97003357,
 11407,
 -64053,
 97068161,
 11397,
 -64052,
 97133185,
 11435,
 -1,
 97197532,
 11401,
 97452031,
 92825652,
 -1,
 97453521,
 97341827,
 -1,
 -64048,
 97409094,
 11495,
 -1,
 97462434,
 11498,
 97650132,
 97399190,
 -1,
 -64045,
 97593328,
 11497,
 -1,
 97652003,
 11492,
 -64043,
 97605695,
 11496,
 -64042,
 97798462,
 11494,
 -1,
 97860487,
 11493,
 98043426,
 92738376,
 -1,
 98108957,
 97980156,
 -1,
 98174448,
 98058450,
 11422,
 98239983,
 98120901,
 -1,
 98305513,
 98178738,
 -1,
 98371041,
 98248327,
 -1,
 98436575,
 98306903,
 11470,
 -1,
 98391944,
 11476,
 -64032,
 98387054,
 11468,
 -1,
 98508245,
 11474,
 98698724,
 98325117,
 -1,
 -64029,
 98643189,
 11482,
 -1,
 98704853,
 11460,
 -64027,
 98648952,
 11454,
 -64026,
 98837665,
 11478,
 -64025,
 98901944,
 11462,
 -64024,
 98965947,
 11480,
 -1,
 99028295,
 11444,
 99287039,
 98254880,
 -1,
 99288557,
 99171742,
 -1,
 -64020,
 99248124,
 11488,
 -1,
 99296664,
 11486,
 -64018,
 99247200,
 11490,
 -1,
 99439397,
 11484,
 -1,
 98190711,
 11440,
 99681783,
 98113507,
 -1,
 99747318,
 99625814,
 -1,
 -64013,
 99696438,
 11450,
 -64012,
 99758599,
 11448,
 -64011,
 99821953,
 11466,
 -1,
 99880377,
 11442,
 -1,
 99683764,
 11398,
 100140542,
 99620556,
 -1,
 100206077,
 100100205,
 -1,
 -64006,
 100160268,
 11499,
 -64005,
 100220726,
 11452,
 -64004,
 100279457,
 11501,
 -1,
 100343260,
 11446,
 -1,
 100156673,
 11458,
 100599298,
 100094339,
 -1,
 -64000,
 100550007,
 11402,
 -63999,
 100609269,
 11428,
 -1,
 100666950,
 11456,
 100861446,
 100544918,
 -1,
 -63996,
 100815741,
 11420,
 -63995,
 100870125,
 11436,
 -1,
 100929252,
 11412,
 101123593,
 100816776,
 -1,
 -63992,
 101066704,
 11408,
 -1,
 101126388,
 11430,
 101320204,
 101074837,
 -1,
 -63989,
 101274493,
 11438,
 -1,
 101329678,
 11424,
 101516815,
 101266313,
 -1,
 -63986,
 101454071,
 11414,
 -1,
 101517203,
 11472,
 101713426,
 101452631,
 -1,
 -63983,
 101660270,
 11392,
 -1,
 101724857,
 11464,
 -63981,
 101673229,
 11404,
 -63980,
 101868250,
 11394,
 -63979,
 101932380,
 11432,
 -63978,
 101994573,
 11426,
 -63977,
 102055734,
 11418,
 -63976,
 102120324,
 11416,
 -63975,
 102181807,
 11410,
 -63974,
 102246237,
 11406,
 -63973,
 102311041,
 11396,
 -63972,
 102376065,
 11434,
 -1,
 102440412,
 11400,
 102694911,
 98058859,
 -1,
 102696481,
 102585790,
 -1,
 -63968,
 102643171,
 11505,
 -1,
 102699066,
 11504,
 -1,
 102645561,
 11503,
 102958631,
 97993250,
 -1,
 -63964,
 102916665,
 11516,
 -63963,
 102968716,
 11515,
 -63962,
 103031798,
 11513,
 -1,
 103094646,
 11514,
 103286314,
 102900158,
 -1,
 -63959,
 103243390,
 11518,
 -1,
 103304236,
 11517,
 -1,
 103234769,
 11519,
 103548486,
 92692359,
 -1,
 103614009,
 103505754,
 -1,
 103679536,
 103569288,
 -1,
 -63953,
 103638504,
 119649,
 -1,
 103688731,
 119650,
 103876147,
 103633283,
 -1,
 -63950,
 103821458,
 119653,
 -1,
 103882835,
 119654,
 104072758,
 103817662,
 -1,
 -63947,
 104023460,
 119651,
 -1,
 104083551,
 119652,
 -63945,
 104022687,
 119648,
 -63944,
 104218465,
 119656,
 -1,
 104275424,
 119655,
 104529919,
 103569553,
 -1,
 104531517,
 104421256,
 -1,
 -63940,
 104490472,
 119658,
 -1,
 104540699,
 119659,
 104728128,
 104485251,
 -1,
 -63937,
 104673426,
 119662,
 -1,
 104734803,
 119663,
 104924739,
 104669630,
 -1,
 -63934,
 104875428,
 119660,
 -1,
 104935519,
 119661,
 -63932,
 104874655,
 119657,
 -63931,
 105070433,
 119665,
 -1,
 105127392,
 119664,
 -1,
 103490156,
 9904,
 105383714,
 80701208,
 -1,
 105449182,
 105336675,
 -1,
 105514642,
 105403606,
 -1,
 105580114,
 105453539,
 -1,
 105645647,
 105539815,
 -1,
 -63923,
 105605405,
 42633,
 -63922,
 105669793,
 42627,
 -1,
 105717310,
 42563,
 -63920,
 105604257,
 42625,
 -63919,
 105858445,
 42605,
 -1,
 105918758,
 42569,
 106104409,
 105535368,
 -1,
 106169942,
 106058115,
 -1,
 -63915,
 106128545,
 42639,
 -1,
 106189345,
 42641,
 -63913,
 106128545,
 42637,
 -63912,
 106306641,
 42635,
 -1,
 106370162,
 42643,
 106563168,
 106058115,
 -1,
 106628703,
 106512773,
 -1,
 106694238,
 106568703,
 -1,
 -63907,
 106641636,
 42599,
 -1,
 106705801,
 42597,
 -1,
 106633339,
 42595,
 -1,
 106572539,
 42647,
 107021926,
 106515404,
 -1,
 107087461,
 106963110,
 -1,
 -63901,
 107047197,
 1297,
 -63900,
 107112611,
 42581,
 -1,
 107158523,
 42565,
 -1,
 107030173,
 1303,
 107415148,
 106966852,
 -1,
 107480683,
 107359270,
 -1,
 -63895,
 107440001,
 42579,
 -63894,
 107484608,
 42589,
 -1,
 107547479,
 42583,
 -1,
 107416407,
 42567,
 107808368,
 107374360,
 -1,
 -63890,
 107756958,
 42591,
 -63889,
 107814813,
 42577,
 -1,
 107875465,
 1305,
 108070517,
 107751047,
 -1,
 108136052,
 108006303,
 -1,
 -63885,
 108091066,
 1279,
 -1,
 108144984,
 1277,
 -1,
 108094625,
 42645,
 108398202,
 108010495,
 -1,
 108463737,
 108344215,
 -1,
 -63880,
 108411793,
 1313,
 -1,
 108472664,
 1299,
 -1,
 108412340,
 1315,
 108725886,
 108335449,
 -1,
 -63876,
 108679252,
 42573,
 -63875,
 108737996,
 42587,
 -1,
 108801590,
 42603,
 108988033,
 108685543,
 -1,
 -63872,
 108931835,
 42629,
 -1,
 108994135,
 42561,
 109184644,
 108939157,
 -1,
 -63869,
 109124672,
 1317,
 -1,
 109186572,
 1231,
 109381255,
 109132969,
 -1,
 -63866,
 109323772,
 42571,
 -1,
 109385658,
 42601,
 109577866,
 109323628,
 -1,
 -63863,
 109532873,
 1275,
 -1,
 109582526,
 1271,
 109774477,
 109515592,
 -1,
 -63860,
 109721573,
 42585,
 -1,
 109778034,
 42631,
 -63858,
 109733025,
 1309,
 -63857,
 109923052,
 1307,
 -63856,
 109985519,
 42575,
 -63855,
 110048885,
 1301,
 -1,
 110104028,
 1311,
 110298841,
 105452512,
 -1,
 110364315,
 110237667,
 -1,
 110429848,
 110323943,
 -1,
 -63850,
 110389533,
 42632,
 -63849,
 110453921,
 42626,
 -1,
 110501438,
 42562,
 -63847,
 110388385,
 42624,
 -63846,
 110642573,
 42604,
 -1,
 110702886,
 42568,
 110888610,
 110319496,
 -1,
 110954143,
 110842243,
 -1,
 -63842,
 110912673,
 42638,
 -1,
 110973473,
 42640,
 -63840,
 110912673,
 42636,
 -63839,
 111090769,
 42634,
 -1,
 111154290,
 42642,
 111347369,
 110842243,
 -1,
 111412904,
 111296901,
 -1,
 111478439,
 111352831,
 -1,
 -63834,
 111425764,
 42598,
 -1,
 111489929,
 42596,
 -1,
 111417467,
 42594,
 -1,
 111356667,
 42646,
 111806127,
 111299532,
 -1,
 111871662,
 111747238,
 -1,
 -63828,
 111831325,
 1296,
 -63827,
 111896739,
 42580,
 -1,
 111942651,
 42564,
 -1,
 111814301,
 1302,
 112199349,
 111750980,
 -1,
 112264884,
 112143398,
 -1,
 -63822,
 112224129,
 42578,
 -63821,
 112268736,
 42588,
 -1,
 112331607,
 42582,
 -1,
 112200535,
 42566,
 112592569,
 112158488,
 -1,
 -63817,
 112541086,
 42590,
 -63816,
 112598941,
 42576,
 -1,
 112659593,
 1304,
 112854718,
 112535175,
 -1,
 112920253,
 112790431,
 -1,
 -63812,
 112875194,
 1278,
 -1,
 112929112,
 1276,
 -1,
 112878753,
 42644,
 113182403,
 112794623,
 -1,
 113247938,
 113128343,
 -1,
 -63807,
 113195921,
 1312,
 -1,
 113256792,
 1298,
 -1,
 113196468,
 1314,
 113510087,
 113119577,
 -1,
 -63803,
 113463380,
 42572,
 -63802,
 113522124,
 42586,
 -1,
 113585718,
 42602,
 113772234,
 113469671,
 -1,
 -63799,
 113715963,
 42628,
 -1,
 113778263,
 42560,
 113968845,
 113720489,
 -1,
 -63796,
 113911292,
 42570,
 -1,
 113973178,
 42600,
 114165456,
 113911148,
 -1,
 -63793,
 114120393,
 1274,
 -1,
 114170046,
 1270,
 114362067,
 114103112,
 -1,
 -63790,
 114309093,
 42584,
 -1,
 114365554,
 42630,
 -63788,
 114320545,
 1308,
 -63787,
 114510572,
 1306,
 -63786,
 114575490,
 1316,
 -63785,
 114638575,
 42574,
 -63784,
 114701941,
 1300,
 -1,
 114757084,
 1310,
 114951900,
 110245381,
 -1,
 -63781,
 114906274,
 7467,
 -1,
 114965786,
 42606,
 -63779,
 114903153,
 42623,
 -1,
 115094093,
 42622,
 115343359,
 105400925,
 -1,
 115345125,
 115234696,
 -1,
 -63775,
 115301618,
 67633,
 -63774,
 115359954,
 67632,
 -63773,
 115419918,
 67631,
 -63772,
 115481599,
 67630,
 -1,
 115542871,
 67629,
 115738347,
 115298691,
 -1,
 -63769,
 115694834,
 67628,
 -63768,
 115753170,
 67627,
 -63767,
 115813134,
 67626,
 -63766,
 115874815,
 67625,
 -1,
 115936087,
 67624,
 116131569,
 115690444,
 -1,
 -63763,
 116088050,
 67623,
 -63762,
 116146386,
 67622,
 -63761,
 116206350,
 67621,
 -63760,
 116268031,
 67620,
 -1,
 116329303,
 67619,
 116524791,
 116082581,
 -1,
 -63757,
 116481266,
 67618,
 -63756,
 116539602,
 67617,
 -63755,
 116599566,
 67616,
 -63754,
 116661247,
 67615,
 -1,
 116722519,
 67614,
 116918013,
 116473246,
 -1,
 -63751,
 116874482,
 67613,
 -63750,
 116932818,
 67612,
 -63749,
 116992782,
 67611,
 -63748,
 117054463,
 67610,
 -1,
 117115735,
 67609,
 117311235,
 116865252,
 -1,
 -63745,
 117267698,
 67608,
 -63744,
 117326034,
 67607,
 -63743,
 117385998,
 67606,
 -63742,
 117447679,
 67605,
 -1,
 117508951,
 67604,
 117704457,
 117257097,
 -1,
 -63739,
 117660914,
 67603,
 -63738,
 117719250,
 67602,
 -63737,
 117779214,
 67601,
 -63736,
 117840895,
 67600,
 -1,
 117902167,
 67599,
 118097679,
 117649814,
 -1,
 -63733,
 118054130,
 67598,
 -63732,
 118112466,
 67597,
 -63731,
 118172430,
 67596,
 -63730,
 118234111,
 67595,
 -1,
 118295383,
 67594,
 118490900,
 118055922,
 -1,
 -63727,
 118440146,
 67637,
 -63726,
 118500110,
 67636,
 -63725,
 118561791,
 67635,
 -1,
 118623063,
 67634,
 118818583,
 118450407,
 -1,
 -63722,
 118767826,
 67647,
 -1,
 118819671,
 67644,
 119015194,
 118777527,
 -1,
 -63719,
 118955007,
 67640,
 -1,
 119016279,
 67639,
 119211805,
 118960347,
 -1,
 -63716,
 119161042,
 67592,
 -1,
 119212887,
 67589,
 -63714,
 119168242,
 67588,
 -63713,
 119357650,
 67587,
 -63712,
 119417614,
 67586,
 -63711,
 119479295,
 67585,
 -1,
 119540567,
 67584,
 119736254,
 105328977,
 -1,
 119801753,
 119674442,
 -1,
 119867189,
 119739208,
 -1,
 -63706,
 119808446,
 64207,
 -63705,
 119872511,
 64206,
 -63704,
 119936995,
 64205,
 -63703,
 120001352,
 64204,
 -63702,
 120066393,
 64203,
 -63701,
 120130391,
 64202,
 -63700,
 120195876,
 64201,
 -63699,
 120261360,
 64200,
 -63698,
 120326836,
 64199,
 -63697,
 120392314,
 64198,
 -63696,
 120457741,
 64197,
 -63695,
 120523211,
 64196,
 -63694,
 120588646,
 64195,
 -63693,
 120654031,
 64194,
 -63692,
 120719426,
 64193,
 -1,
 120784834,
 64192,
 120981318,
 119804249,
 -1,
 -63689,
 120922558,
 64191,
 -63688,
 120986623,
 64190,
 -63687,
 121051107,
 64189,
 -63686,
 121115464,
 64188,
 -63685,
 121180505,
 64187,
 -63684,
 121244503,
 64186,
 -63683,
 121309988,
 64185,
 -63682,
 121375472,
 64184,
 -63681,
 121440948,
 64183,
 -63680,
 121506426,
 64182,
 -63679,
 121571853,
 64181,
 -63678,
 121637323,
 64180,
 -63677,
 121702758,
 64179,
 -63676,
 121768143,
 64178,
 -63675,
 121833538,
 64177,
 -1,
 121898946,
 64176,
 122095447,
 120916823,
 -1,
 -63672,
 122036670,
 64175,
 -63671,
 122100735,
 64174,
 -63670,
 122165219,
 64173,
 -63669,
 122229576,
 64172,
 -63668,
 122294617,
 64171,
 -63667,
 122358615,
 64170,
 -63666,
 122424100,
 64169,
 -63665,
 122489584,
 64168,
 -63664,
 122555060,
 64167,
 -63663,
 122620538,
 64166,
 -63662,
 122685965,
 64165,
 -63661,
 122751435,
 64164,
 -63660,
 122816870,
 64163,
 -63659,
 122882255,
 64162,
 -63658,
 122947650,
 64161,
 -1,
 123013058,
 64160,
 123209576,
 122030884,
 -1,
 -63655,
 123150782,
 64159,
 -63654,
 123214847,
 64158,
 -63653,
 123279331,
 64157,
 -63652,
 123343688,
 64156,
 -63651,
 123408729,
 64155,
 -63650,
 123472727,
 64154,
 -63649,
 123538212,
 64153,
 -63648,
 123603696,
 64152,
 -63647,
 123669172,
 64151,
 -63646,
 123734650,
 64150,
 -63645,
 123800077,
 64149,
 -63644,
 123865547,
 64148,
 -63643,
 123930982,
 64147,
 -63642,
 123996367,
 64146,
 -63641,
 124061762,
 64145,
 -1,
 124127170,
 64144,
 124323705,
 123144944,
 -1,
 -63638,
 124264894,
 64143,
 -63637,
 124328959,
 64142,
 -63636,
 124393443,
 64141,
 -63635,
 124457800,
 64140,
 -63634,
 124522841,
 64139,
 -63633,
 124586839,
 64138,
 -63632,
 124652324,
 64137,
 -63631,
 124717808,
 64136,
 -63630,
 124783284,
 64135,
 -63629,
 124848762,
 64134,
 -63628,
 124914189,
 64133,
 -63627,
 124979659,
 64132,
 -63626,
 125045094,
 64131,
 -63625,
 125110479,
 64130,
 -63624,
 125175874,
 64129,
 -1,
 125241282,
 64128,
 125437834,
 124258996,
 -1,
 -63621,
 125379006,
 64127,
 -63620,
 125443071,
 64126,
 -63619,
 125507555,
 64125,
 -63618,
 125571912,
 64124,
 -63617,
 125636953,
 64123,
 -63616,
 125700951,
 64122,
 -63615,
 125766436,
 64121,
 -63614,
 125831920,
 64120,
 -63613,
 125897396,
 64119,
 -63612,
 125962874,
 64118,
 -63611,
 126028301,
 64117,
 -63610,
 126093771,
 64116,
 -63609,
 126159206,
 64115,
 -63608,
 126224591,
 64114,
 -63607,
 126289986,
 64113,
 -1,
 126355394,
 64112,
 126551957,
 125376483,
 -1,
 -63604,
 126487332,
 64217,
 -63603,
 126552816,
 64216,
 -63602,
 126618292,
 64215,
 -63601,
 126683770,
 64214,
 -63600,
 126749197,
 64213,
 -63599,
 126814667,
 64212,
 -63598,
 126880102,
 64211,
 -63597,
 126945487,
 64210,
 -63596,
 127010882,
 64209,
 -1,
 127076290,
 64208,
 127336447,
 126487162,
 -1,
 -63593,
 127211491,
 64109,
 -63592,
 127275848,
 64108,
 -1,
 127340889,
 64107,
 127598591,
 119756481,
 -1,
 127600552,
 127477383,
 12752,
 127666084,
 127559911,
 12757,
 127731616,
 127625447,
 12741,
 127797151,
 127690983,
 12750,
 -1,
 127738887,
 12769,
 -1,
 127747989,
 12747,
 127993762,
 127689714,
 12749,
 -1,
 127935495,
 12744,
 -63581,
 127948680,
 12746,
 -1,
 128066567,
 12742,
 128255910,
 127616917,
 12743,
 -1,
 128214261,
 12748,
 -63577,
 128214804,
 12768,
 -1,
 128328711,
 12758,
 128518066,
 127553923,
 12753,
 128583596,
 128477415,
 12759,
 -63573,
 128542951,
 12766,
 -1,
 128607477,
 12745,
 128780207,
 128541682,
 12740,
 -63570,
 128739559,
 12760,
 -1,
 128787463,
 12767,
 -63568,
 128735112,
 12761,
 -63567,
 128927637,
 12755,
 -1,
 128984071,
 12762,
 129173430,
 128468885,
 12754,
 -63564,
 129132775,
 12764,
 -63563,
 129180679,
 12770,
 -1,
 129243107,
 12763,
 129435576,
 129128328,
 12736,
 -1,
 129383838,
 12765,
 -63559,
 129394424,
 12738,
 -63558,
 129524981,
 12737,
 -63557,
 129583838,
 12771,
 -63556,
 129645982,
 12751,
 -63555,
 129701859,
 12756,
 -1,
 129766199,
 12739,
 129960037,
 119671639,
 -1,
 130025519,
 129908196,
 -1,
 130090960,
 129974482,
 -1,
 130156495,
 130036025,
 -1,
 130222024,
 130104734,
 6361,
 130351103,
 130180082,
 -1,
 130353094,
 130236626,
 6347,
 -1,
 130302162,
 6349,
 130547711,
 130296590,
 6343,
 -1,
 130427662,
 6345,
 130615242,
 130175363,
 6362,
 -1,
 130557575,
 6363,
 -63541,
 130570120,
 6357,
 -63540,
 130697109,
 6356,
 -63539,
 130758884,
 6360,
 -63538,
 130822550,
 6358,
 -1,
 130880328,
 6359,
 -1,
 130115352,
 6320,
 131139553,
 130049010,
 -1,
 131205083,
 131089235,
 -1,
 131270618,
 131160516,
 -1,
 131336149,
 131219666,
 5754,
 -1,
 131285202,
 5755,
 131467223,
 131279630,
 5752,
 -1,
 131410702,
 5753,
 131598297,
 131402583,
 5756,
 -1,
 131533655,
 5757,
 -1,
 131538221,
 5751,
 -1,
 131211946,
 5758,
 131860448,
 131145678,
 -1,
 131925983,
 131794709,
 -1,
 -63522,
 131875654,
 6369,
 -1,
 131926975,
 6370,
 -1,
 131866507,
 6365,
 -1,
 131797307,
 6323,
 132253678,
 131092867,
 -1,
 132319209,
 132190523,
 6335,
 132448255,
 132263862,
 -1,
 132450279,
 132338301,
 -1,
 -63514,
 132408481,
 6378,
 -1,
 132465478,
 6379,
 -63512,
 132395406,
 6385,
 -1,
 132589908,
 6380,
 132777965,
 132261511,
 -1,
 -63509,
 132736667,
 6338,
 -63508,
 132794254,
 6336,
 -1,
 132845883,
 6337,
 -1,
 132728718,
 6334,
 133105658,
 132208520,
 -1,
 133171187,
 133060848,
 -1,
 -63503,
 133129377,
 6373,
 -63502,
 133186374,
 6374,
 -1,
 133237695,
 6375,
 133433334,
 133117554,
 -1,
 -63499,
 133391521,
 6376,
 -1,
 133448518,
 6377,
 133629945,
 133376756,
 -1,
 -63496,
 133569535,
 6371,
 -1,
 133630807,
 6372,
 -1,
 133566779,
 6327,
 133892100,
 133057484,
 -1,
 133957634,
 133850098,
 -1,
 134023166,
 133906642,
 6353,
 -1,
 133972178,
 6354,
 134154240,
 133966606,
 6351,
 -1,
 134097678,
 6352,
 -63487,
 134094125,
 6350,
 -1,
 134220631,
 6355,
 -63485,
 133894459,
 6341,
 -1,
 134350621,
 6368,
 134547468,
 133840286,
 -1,
 134613002,
 134505458,
 -1,
 134678536,
 134562002,
 6346,
 -1,
 134627538,
 6348,
 134873087,
 134621966,
 6342,
 -1,
 134753038,
 6344,
 -63477,
 134563726,
 6331,
 -1,
 134877499,
 6332,
 135071766,
 134484995,
 -1,
 135137298,
 135013383,
 -1,
 135202833,
 135095282,
 -1,
 -63472,
 135159026,
 6381,
 -1,
 135203671,
 6384,
 -1,
 135138239,
 6383,
 135464981,
 135076010,
 -1,
 -63468,
 135419896,
 6389,
 -1,
 135470092,
 6382,
 -1,
 135410066,
 6386,
 135727130,
 135022485,
 -1,
 -63464,
 135685787,
 6326,
 -63463,
 135743374,
 6324,
 -1,
 135795003,
 6325,
 135989279,
 135663961,
 -1,
 136054814,
 135929055,
 -1,
 -63459,
 136006604,
 6388,
 -1,
 136065929,
 6387,
 -1,
 136000472,
 5759,
 136316962,
 135948056,
 -1,
 -63455,
 136267662,
 6339,
 -1,
 136319291,
 6340,
 136513573,
 136262038,
 -1,
 -63452,
 136471709,
 6329,
 -1,
 136515899,
 6328,
 136710184,
 136454809,
 -1,
 -63449,
 136664292,
 6366,
 -1,
 136727646,
 6367,
 136906795,
 136645463,
 -1,
 -63446,
 136865560,
 6321,
 -1,
 136909115,
 6322,
 -63444,
 136854163,
 6330,
 -63443,
 137049275,
 6333,
 -63442,
 137112327,
 5120,
 -1,
 137174197,
 6364,
 137365604,
 129977292,
 -1,
 137431139,
 137309041,
 -1,
 137496631,
 137387250,
 66226,
 137625599,
 137452786,
 66239,
 137691135,
 137518322,
 66212,
 -63435,
 137583858,
 66235,
 -63434,
 137628006,
 66256,
 -1,
 137693391,
 66248,
 137889853,
 137449859,
 66224,
 137955386,
 137844616,
 66242,
 -1,
 137889999,
 66243,
 138086460,
 137897607,
 66222,
 -1,
 138021071,
 66223,
 -1,
 138039683,
 66232,
 138283074,
 137836772,
 66218,
 138412031,
 138219865,
 66250,
 -63424,
 138283467,
 66253,
 -63423,
 138348902,
 66252,
 -1,
 138414287,
 66251,
 138610758,
 138231198,
 66229,
 -63420,
 138558878,
 66227,
 -63419,
 138617863,
 66244,
 -1,
 138680291,
 66238,
 138872905,
 138565512,
 66221,
 139001855,
 138827656,
 66247,
 -1,
 138873039,
 66230,
 139069516,
 138818441,
 66211,
 139198463,
 139007971,
 66214,
 -1,
 139069647,
 66254,
 139266126,
 139021260,
 66213,
 -1,
 139217868,
 66249,
 139397200,
 139216789,
 66231,
 -1,
 139331791,
 66209,
 139528274,
 139342230,
 66236,
 -1,
 139462863,
 66237,
 139659348,
 139471630,
 66233,
 -1,
 139602702,
 66245,
 139790422,
 139600903,
 66240,
 -1,
 139725007,
 66241,
 139921496,
 139729919,
 66234,
 -1,
 139856079,
 66255,
 140052570,
 139859939,
 66210,
 -1,
 139987151,
 66220,
 140183645,
 139989854,
 -1,
 -63396,
 140118472,
 66246,
 -1,
 140183746,
 66225,
 140380255,
 140118871,
 66208,
 -1,
 140314831,
 66215,
 -63392,
 140338871,
 66228,
 -63391,
 140462814,
 66216,
 -63390,
 140525778,
 66219,
 -1,
 140579161,
 66217,
 -1,
 137364675,
 9936,
 -1,
 137320064,
 9963,
 140904663,
 129902215,
 -1,
 140970197,
 140839767,
 -1,
 141035732,
 140916966,
 -1,
 141101227,
 140981765,
 -1,
 141166709,
 141042329,
 -1,
 141232236,
 141114782,
 43590,
 -1,
 141173767,
 43586,
 -63379,
 141190936,
 43592,
 -63378,
 141318024,
 43589,
 -63377,
 141383182,
 43595,
 -63376,
 141446092,
 43593,
 -63375,
 141510549,
 43591,
 -63374,
 141570953,
 43594,
 -63373,
 141635990,
 43584,
 -63372,
 141698055,
 43585,
 -1,
 141759588,
 43588,
 141953151,
 141114782,
 -1,
 142018682,
 141895303,
 -1,
 -63368,
 141975092,
 43536,
 -63367,
 142029049,
 43538,
 -1,
 142084951,
 43537,
 142280829,
 141960199,
 -1,
 -63364,
 142237236,
 43530,
 -1,
 142281559,
 43531,
 -63362,
 142237236,
 43543,
 -1,
 142412631,
 43544,
 142608515,
 141903765,
 -1,
 -63359,
 142559193,
 43547,
 -63358,
 142616221,
 43548,
 -1,
 142674775,
 43546,
 142870663,
 142546915,
 -1,
 -63355,
 142812829,
 43542,
 -63354,
 142874634,
 43545,
 -1,
 142936919,
 43541,
 143132811,
 142807385,
 -1,
 -63351,
 143074973,
 43550,
 -63350,
 143135115,
 43553,
 -1,
 143199063,
 43549,
 143394958,
 143087496,
 -1,
 -63347,
 143337117,
 43540,
 -1,
 143395671,
 43539,
 143591569,
 143348099,
 -1,
 -63344,
 143544747,
 43558,
 -1,
 143592279,
 43559,
 143788180,
 143538404,
 -1,
 -63341,
 143744564,
 43551,
 -1,
 143788887,
 43552,
 143984791,
 143733142,
 -1,
 -63338,
 143926941,
 43527,
 -1,
 143985495,
 43526,
 144181402,
 143929563,
 -1,
 -63335,
 144123549,
 43535,
 -1,
 144182103,
 43534,
 144378013,
 144122887,
 -1,
 -63332,
 144320157,
 43529,
 -1,
 144378711,
 43528,
 144574624,
 144315492,
 -1,
 -63329,
 144516765,
 43533,
 -1,
 144575319,
 43532,
 144771234,
 144509783,
 43520,
 -1,
 144714510,
 43524,
 -63325,
 144729909,
 43554,
 -63324,
 144859414,
 43557,
 -63323,
 144923890,
 43522,
 -63322,
 144985115,
 43555,
 -63321,
 145047762,
 43525,
 -63320,
 145109943,
 43556,
 -63319,
 145173262,
 43521,
 -63318,
 145237661,
 43560,
 -1,
 145300479,
 43523,
 145492151,
 141058953,
 -1,
 145557680,
 145427287,
 -1,
 -63314,
 145513714,
 43569,
 -63313,
 145566478,
 43568,
 -1,
 145623895,
 43561,
 145819826,
 145513714,
 43565,
 -1,
 145759231,
 43570,
 145950900,
 145768658,
 43567,
 -1,
 145890303,
 43566,
 146081974,
 145894158,
 43562,
 -1,
 146025230,
 43563,
 -1,
 146021845,
 43564,
 146278597,
 145430871,
 -1,
 146344123,
 146233224,
 -1,
 -63302,
 146302440,
 43602,
 -1,
 146352667,
 43603,
 146540734,
 146297219,
 -1,
 -63299,
 146485394,
 43606,
 -1,
 146546771,
 43607,
 146737345,
 146481598,
 -1,
 -63296,
 146687396,
 43604,
 -1,
 146747487,
 43605,
 -63294,
 146696511,
 43600,
 -63293,
 146883231,
 43601,
 -63292,
 146947937,
 43609,
 -1,
 147004896,
 43608,
 147196110,
 146216549,
 -1,
 147261642,
 147137177,
 -1,
 -63288,
 147209979,
 43587,
 -63287,
 147273956,
 43596,
 -1,
 147334791,
 43597,
 -63285,
 147220277,
 43571,
 -63284,
 147481639,
 43574,
 -63283,
 147541019,
 43572,
 -1,
 147600311,
 43573,
 147849215,
 147147442,
 -1,
 147851474,
 147724259,
 -1,
 -63279,
 147801473,
 43614,
 -1,
 147852935,
 43613,
 -63277,
 147807082,
 43615,
 -1,
 148002219,
 43612,
 -1,
 140979777,
 9939,
 -63274,
 140927031,
 9962,
 -1,
 148189057,
 9911,
 148375798,
 140849005,
 -1,
 148441316,
 148324408,
 -1,
 148506845,
 148395912,
 -1,
 -63269,
 148464810,
 12873,
 -63268,
 148515006,
 12874,
 -1,
 148577919,
 12872,
 148768992,
 148459907,
 -1,
 -63265,
 148713652,
 12877,
 -1,
 148775046,
 12878,
 148965603,
 148709822,
 -1,
 -63262,
 148915421,
 12875,
 -1,
 148974637,
 12876,
 -1,
 148905472,
 12879,
 149227758,
 148384526,
 -1,
 149293291,
 149166260,
 -1,
 149358825,
 149238166,
 -1,
 -63256,
 149308769,
 12871,
 -1,
 149368185,
 12869,
 -63254,
 149311990,
 12870,
 -1,
 149506956,
 12868,
 149749759,
 149248006,
 -1,
 -63251,
 149638092,
 127276,
 -1,
 149689160,
 127275,
 149883121,
 149173034,
 -1,
 -63248,
 149827976,
 12925,
 -1,
 149886059,
 12924,
 150079732,
 149820232,
 -1,
 -63245,
 150032537,
 9938,
 -1,
 150083555,
 127277,
 -63243,
 150038196,
 127278,
 -1,
 150218513,
 12926,
 150407419,
 148328596,
 -1,
 150472954,
 150347019,
 -1,
 -63239,
 150427488,
 9876,
 -1,
 150486691,
 127370,
 -1,
 150416837,
 9932,
 150798335,
 150346751,
 -1,
 -63235,
 150687126,
 9907,
 -1,
 150739201,
 8373,
 150933055,
 7167,
 -1,
 150998437,
 150873700,
 -1,
 151062912,
 150932311,
 -1,
 151128409,
 150996930,
 -1,
 151193873,
 151062987,
 -1,
 151259397,
 151128589,
 77877,
 -1,
 151194455,
 77878,
 151390471,
 151193958,
 77874,
 -1,
 151325527,
 77875,
 151521545,
 151324879,
 77872,
 -1,
 151456599,
 77873,
 151652619,
 151455682,
 77869,
 -1,
 151587671,
 77870,
 -63220,
 151587620,
 77882,
 -63219,
 151718640,
 77881,
 -63218,
 151784116,
 77880,
 -63217,
 151849594,
 77879,
 -63216,
 151914955,
 77876,
 -1,
 151980098,
 77871,
 152176926,
 151128130,
 -1,
 152242452,
 152111796,
 77844,
 -1,
 152177495,
 77845,
 152373526,
 152177099,
 77840,
 -1,
 152308567,
 77841,
 -63209,
 152308516,
 77847,
 -63208,
 152439536,
 77846,
 -63207,
 152504954,
 77843,
 -63206,
 152570381,
 77842,
 -63205,
 152635750,
 77839,
 -63204,
 152701135,
 77838,
 -63203,
 152766530,
 77837,
 -1,
 152831938,
 77836,
 153028907,
 152111042,
 -1,
 153094434,
 152963706,
 77830,
 -63199,
 153031001,
 77832,
 -1,
 153094999,
 77831,
 153291044,
 153029133,
 77828,
 -1,
 153226071,
 77829,
 -63195,
 153226020,
 77835,
 -63194,
 153357040,
 77834,
 -63193,
 153422516,
 77833,
 -63192,
 153487819,
 77827,
 -63191,
 153553254,
 77826,
 -63190,
 153618639,
 77825,
 -1,
 153684034,
 77824,
 153880887,
 152963430,
 -1,
 153946414,
 153815247,
 77860,
 -1,
 153881431,
 77861,
 -63185,
 153881380,
 77868,
 -63184,
 154012400,
 77867,
 -63183,
 154077876,
 77866,
 -63182,
 154143354,
 77865,
 -63181,
 154208781,
 77864,
 -63180,
 154274251,
 77863,
 -63179,
 154339686,
 77862,
 -63178,
 154404930,
 77859,
 -1,
 154470338,
 77858,
 154667330,
 153815674,
 -1,
 -63175,
 154602276,
 77902,
 -63174,
 154667760,
 77901,
 -63173,
 154733236,
 77900,
 -63172,
 154798714,
 77899,
 -63171,
 154864141,
 77898,
 -63170,
 154929611,
 77897,
 -63169,
 154995046,
 77896,
 -63168,
 155060431,
 77895,
 -63167,
 155125826,
 77894,
 -1,
 155191234,
 77893,
 155388237,
 154601997,
 -1,
 -63164,
 155323172,
 77892,
 -63163,
 155388656,
 77891,
 -63162,
 155454132,
 77890,
 -63161,
 155519610,
 77889,
 -63160,
 155585037,
 77888,
 -63159,
 155650507,
 77887,
 -63158,
 155715942,
 77886,
 -63157,
 155781327,
 77885,
 -63156,
 155846722,
 77884,
 -1,
 155912130,
 77883,
 156109144,
 155322575,
 -1,
 -63153,
 156044068,
 77857,
 -63152,
 156109552,
 77856,
 -63151,
 156175028,
 77855,
 -63150,
 156240506,
 77854,
 -63149,
 156305933,
 77853,
 -63148,
 156371403,
 77852,
 -63147,
 156436838,
 77851,
 -63146,
 156502223,
 77850,
 -63145,
 156567618,
 77849,
 -1,
 156633026,
 77848,
 -1,
 156044006,
 77903,
 156958719,
 151063478,
 -1,
 156961126,
 156829634,
 -1,
 157026654,
 156895924,
 78867,
 -63139,
 156963161,
 78869,
 -1,
 157027159,
 78868,
 -63137,
 156961572,
 78871,
 -63136,
 157158128,
 78870,
 -63135,
 157223546,
 78866,
 -63134,
 157288973,
 78865,
 -63133,
 157354443,
 78864,
 -63132,
 157419878,
 78863,
 -63131,
 157485263,
 78862,
 -1,
 157550658,
 78861,
 157747569,
 156895439,
 -1,
 -63128,
 157682468,
 78891,
 -63127,
 157747952,
 78890,
 -63126,
 157813428,
 78889,
 -63125,
 157878906,
 78888,
 -63124,
 157944333,
 78887,
 -63123,
 158009803,
 78886,
 -63122,
 158075238,
 78885,
 -63121,
 158140623,
 78884,
 -63120,
 158206018,
 78883,
 -1,
 158271426,
 78882,
 158468476,
 157681730,
 -1,
 -63117,
 158403364,
 78881,
 -63116,
 158468848,
 78880,
 -63115,
 158534324,
 78879,
 -63114,
 158599802,
 78878,
 -63113,
 158665229,
 78877,
 -63112,
 158730699,
 78876,
 -63111,
 158796134,
 78875,
 -63110,
 158861519,
 78874,
 -63109,
 158926914,
 78873,
 -1,
 158992322,
 78872,
 159252479,
 158402918,
 -1,
 -63106,
 159123663,
 78894,
 -63105,
 159189058,
 78893,
 -1,
 159254466,
 78892,
 159451631,
 151010718,
 -1,
 159517112,
 159385538,
 -1,
 159582609,
 159451494,
 -1,
 159648133,
 159517364,
 78361,
 -1,
 159583063,
 78362,
 159779207,
 159582733,
 78358,
 -1,
 159714135,
 78359,
 159910281,
 159713739,
 78356,
 -1,
 159845207,
 78357,
 160041355,
 159844710,
 78354,
 -1,
 159976279,
 78355,
 -63092,
 159976228,
 78364,
 -63091,
 160107248,
 78363,
 -63090,
 160172666,
 78360,
 -63089,
 160237775,
 78353,
 -63088,
 160303170,
 78352,
 -1,
 160368578,
 78351,
 160565662,
 159516738,
 -1,
 160631189,
 160500464,
 78336,
 -63084,
 160567641,
 78338,
 -1,
 160631639,
 78337,
 -63082,
 160566052,
 78339,
 -63081,
 160762548,
 78335,
 -63080,
 160828026,
 78334,
 -63079,
 160893453,
 78333,
 -63078,
 160958923,
 78332,
 -63077,
 161024358,
 78331,
 -63076,
 161089743,
 78330,
 -63075,
 161155138,
 78329,
 -1,
 161220546,
 78328,
 161417642,
 160499919,
 -1,
 161483169,
 161352205,
 78345,
 -1,
 161418071,
 78346,
 -63070,
 161418020,
 78350,
 -63069,
 161549040,
 78349,
 -63068,
 161614516,
 78348,
 -63067,
 161679994,
 78347,
 -63066,
 161745355,
 78344,
 -63065,
 161810790,
 78343,
 -63064,
 161876175,
 78342,
 -63063,
 161941570,
 78341,
 -1,
 162006978,
 78340,
 162204084,
 161351618,
 -1,
 -63060,
 162138916,
 78327,
 -63059,
 162204400,
 78326,
 -63058,
 162269876,
 78325,
 -63057,
 162335354,
 78324,
 -63056,
 162400781,
 78323,
 -63055,
 162466251,
 78322,
 -63054,
 162531686,
 78321,
 -63053,
 162597071,
 78320,
 -1,
 162662466,
 78319,
 162922495,
 162138571,
 -1,
 -63050,
 162793679,
 78367,
 -63049,
 162859074,
 78366,
 -1,
 162924482,
 78365,
 163121622,
 159472968,
 -1,
 163187143,
 163055682,
 -1,
 163252668,
 163121904,
 78409,
 -1,
 163187543,
 78410,
 163383742,
 163186754,
 78401,
 -1,
 163318615,
 78402,
 163514816,
 163317698,
 78399,
 -1,
 163449687,
 78400,
 -63039,
 163449636,
 78411,
 -63038,
 163580596,
 78408,
 -63037,
 163646074,
 78407,
 -63036,
 163711501,
 78406,
 -63035,
 163776971,
 78405,
 -63034,
 163842406,
 78404,
 -1,
 163907791,
 78403,
 164104657,
 163121090,
 -1,
 -63031,
 164039460,
 78398,
 -63030,
 164104944,
 78397,
 -63029,
 164170420,
 78396,
 -63028,
 164235898,
 78395,
 -63027,
 164301325,
 78394,
 -63026,
 164366795,
 78393,
 -63025,
 164432230,
 78392,
 -63024,
 164497615,
 78391,
 -1,
 164563010,
 78390,
 164823039,
 164038863,
 -1,
 164825556,
 164694223,
 78414,
 -1,
 164760407,
 78415,
 -63019,
 164759618,
 78413,
 -1,
 164890562,
 78412,
 165150719,
 163066797,
 -1,
 165153251,
 165021762,
 -1,
 165218778,
 165087924,
 78385,
 -1,
 165153623,
 78386,
 -63013,
 165153572,
 78388,
 -63012,
 165284592,
 78387,
 -63011,
 165350010,
 78384,
 -63010,
 165415437,
 78383,
 -63009,
 165480907,
 78382,
 -63008,
 165546342,
 78381,
 -63007,
 165611727,
 78380,
 -63006,
 165677122,
 78379,
 -1,
 165742530,
 78378,
 165939694,
 165087170,
 -1,
 166005222,
 165874189,
 78372,
 -1,
 165940055,
 78373,
 -63001,
 165940004,
 78377,
 -63000,
 166071024,
 78376,
 -62999,
 166136500,
 78375,
 -62998,
 166201978,
 78374,
 -62997,
 166267339,
 78371,
 -62996,
 166332774,
 78370,
 -62995,
 166398159,
 78369,
 -1,
 166463554,
 78368,
 -1,
 165873989,
 78389,
 166726227,
 159389695,
 -1,
 166791686,
 166660621,
 -1,
 166857211,
 166725570,
 77997,
 -62989,
 166800142,
 78006,
 -62988,
 166864519,
 78005,
 -62987,
 166929415,
 78004,
 -62986,
 166994366,
 78003,
 -62985,
 167058431,
 78002,
 -62984,
 167122915,
 78001,
 -62983,
 167187272,
 78000,
 -62982,
 167252313,
 77999,
 -1,
 167316311,
 77998,
 167512573,
 166791627,
 78011,
 -1,
 167447383,
 78012,
 167643647,
 167446735,
 78008,
 -1,
 167578455,
 78009,
 -62976,
 167578404,
 78017,
 -62975,
 167709424,
 78016,
 -62974,
 167774900,
 78015,
 -62973,
 167840378,
 78014,
 -62972,
 167905805,
 78013,
 -62971,
 167971174,
 78010,
 -1,
 168036418,
 78007,
 168233495,
 166726266,
 -1,
 168299024,
 168168116,
 78025,
 -62967,
 168240775,
 78033,
 -62966,
 168305671,
 78032,
 -62965,
 168370622,
 78031,
 -62964,
 168434687,
 78030,
 -62963,
 168499171,
 78029,
 -62962,
 168563528,
 78028,
 -62961,
 168628569,
 78027,
 -1,
 168692567,
 78026,
 -62959,
 168233594,
 78024,
 -62958,
 168823309,
 78023,
 -62957,
 168888779,
 78022,
 -62956,
 168954214,
 78021,
 -62955,
 169019599,
 78020,
 -62954,
 169084994,
 78019,
 -1,
 169150402,
 78018,
 169347620,
 168167883,
 -1,
 169413146,
 169282288,
 77994,
 -1,
 169347927,
 77995,
 169544220,
 169347706,
 77991,
 -1,
 169478999,
 77992,
 -62947,
 169478948,
 77996,
 -62946,
 169609908,
 77993,
 -62945,
 169675277,
 77990,
 -62944,
 169740747,
 77989,
 -62943,
 169806182,
 77988,
 -62942,
 169871567,
 77987,
 -62941,
 169936962,
 77986,
 -1,
 170002370,
 77985,
 170199601,
 169281894,
 -1,
 170265127,
 170133963,
 77978,
 -1,
 170199895,
 77979,
 170396201,
 170199106,
 77974,
 -1,
 170330967,
 77975,
 -62934,
 170330916,
 77984,
 -62933,
 170461936,
 77983,
 -62932,
 170527412,
 77982,
 -62931,
 170592890,
 77981,
 -62930,
 170658317,
 77980,
 -62929,
 170723686,
 77977,
 -62928,
 170789071,
 77976,
 -1,
 170854338,
 77973,
 171051581,
 170133711,
 -1,
 171117108,
 170986164,
 77969,
 -1,
 171051863,
 77970,
 -62923,
 171051812,
 77972,
 -62922,
 171182832,
 77971,
 -62921,
 171248250,
 77968,
 -62920,
 171313677,
 77967,
 -62919,
 171379147,
 77966,
 -62918,
 171444582,
 77965,
 -62917,
 171509967,
 77964,
 -62916,
 171575362,
 77963,
 -1,
 171640770,
 77962,
 171838024,
 170985538,
 -1,
 -62913,
 171772708,
 77961,
 -62912,
 171838192,
 77960,
 -62911,
 171903668,
 77959,
 -62910,
 171969146,
 77958,
 -62909,
 172034573,
 77957,
 -62908,
 172100043,
 77956,
 -62907,
 172165478,
 77955,
 -62906,
 172230863,
 77954,
 -62905,
 172296258,
 77953,
 -1,
 172361666,
 77952,
 172621823,
 171771842,
 -1,
 172624459,
 172493552,
 77949,
 -1,
 172559191,
 77950,
 -62900,
 172559140,
 77951,
 -62899,
 172690100,
 77948,
 -62898,
 172755578,
 77947,
 -62897,
 172821005,
 77946,
 -62896,
 172886475,
 77945,
 -62895,
 172951910,
 77944,
 -62894,
 173017295,
 77943,
 -1,
 173082690,
 77942,
 173279909,
 166682899,
 -1,
 173345390,
 173213903,
 -1,
 173410914,
 173279170,
 78726,
 -62889,
 173355913,
 78738,
 -62888,
 173420950,
 78737,
 -62887,
 173486299,
 78736,
 -62886,
 173550350,
 78735,
 -62885,
 173614727,
 78734,
 -62884,
 173679623,
 78733,
 -62883,
 173744574,
 78732,
 -62882,
 173808639,
 78731,
 -62881,
 173873123,
 78730,
 -62880,
 173937480,
 78729,
 -62879,
 174002521,
 78728,
 -1,
 174066519,
 78727,
 174262884,
 173345572,
 78749,
 -1,
 174197591,
 78750,
 174393958,
 174197488,
 78747,
 -1,
 174328663,
 78748,
 174525032,
 174328166,
 78741,
 -1,
 174459735,
 78742,
 -62871,
 174459572,
 78746,
 -62870,
 174590586,
 78745,
 -62869,
 174656013,
 78744,
 -62868,
 174721483,
 78743,
 -62867,
 174786767,
 78740,
 -1,
 174852162,
 78739,
 175049348,
 173279170,
 -1,
 175114873,
 174983234,
 78690,
 -62863,
 175057678,
 78699,
 -62862,
 175122055,
 78698,
 -62861,
 175186951,
 78697,
 -62860,
 175251902,
 78696,
 -62859,
 175315967,
 78695,
 -62858,
 175380451,
 78694,
 -62857,
 175444808,
 78693,
 -62856,
 175509849,
 78692,
 -1,
 175573847,
 78691,
 175770236,
 175049396,
 78706,
 -62853,
 175706457,
 78708,
 -1,
 175770455,
 78707,
 175966846,
 175704271,
 78700,
 -1,
 175901527,
 78701,
 -62849,
 175901476,
 78710,
 -62848,
 176032496,
 78709,
 -62847,
 176097914,
 78705,
 -62846,
 176163341,
 78704,
 -62845,
 176228811,
 78703,
 -1,
 176294246,
 78702,
 176491156,
 174983234,
 -1,
 176556681,
 176425026,
 78712,
 -62841,
 176493384,
 78715,
 -62840,
 176558425,
 78714,
 -1,
 176622423,
 78713,
 176818828,
 176490703,
 78716,
 -62837,
 176755033,
 78718,
 -1,
 176819031,
 78717,
 -62835,
 176753444,
 78725,
 -62834,
 176950000,
 78724,
 -62833,
 177015476,
 78723,
 -62832,
 177080954,
 78722,
 -62831,
 177146381,
 78721,
 -62830,
 177211851,
 78720,
 -62829,
 177277286,
 78719,
 -1,
 177342402,
 78711,
 177539747,
 176425318,
 -1,
 177605271,
 177474228,
 78761,
 -1,
 177539927,
 78762,
 177736345,
 177539430,
 78756,
 -1,
 177670999,
 78757,
 177867419,
 177670210,
 78753,
 -1,
 177802071,
 78754,
 177998493,
 177801154,
 78751,
 -1,
 177933143,
 78752,
 -62818,
 177933092,
 78764,
 -62817,
 178064112,
 78763,
 -62816,
 178129530,
 78760,
 -62815,
 178194957,
 78759,
 -62814,
 178260427,
 78758,
 -1,
 178325711,
 78755,
 178585599,
 177474045,
 78765,
 -1,
 178457431,
 78766,
 178653943,
 173228293,
 -1,
 178719416,
 178587586,
 -1,
 178784942,
 178653818,
 78423,
 -62807,
 178725310,
 78429,
 -62806,
 178789375,
 78428,
 -62805,
 178853859,
 78427,
 -62804,
 178918216,
 78426,
 -62803,
 178983257,
 78425,
 -1,
 179047255,
 78424,
 179243696,
 178719245,
 78421,
 -1,
 179178327,
 78422,
 179374770,
 179177538,
 78416,
 -1,
 179309399,
 78417,
 -62797,
 179309348,
 78432,
 -62796,
 179440368,
 78431,
 -62795,
 179505844,
 78430,
 -62794,
 179571147,
 78420,
 -62793,
 179636582,
 78419,
 -1,
 179701967,
 78418,
 179899081,
 178653542,
 -1,
 179964606,
 179833466,
 78469,
 -62789,
 179902435,
 78473,
 -62788,
 179966792,
 78472,
 -62787,
 180031833,
 78471,
 -1,
 180095831,
 78470,
 180292288,
 179898726,
 78465,
 -1,
 180226903,
 78466,
 180423362,
 180225986,
 78461,
 -1,
 180357975,
 78462,
 -62781,
 180357924,
 78476,
 -62780,
 180488944,
 78475,
 -62779,
 180554420,
 78474,
 -62778,
 180619789,
 78468,
 -62777,
 180685259,
 78467,
 -62776,
 180750543,
 78464,
 -1,
 180815938,
 78463,
 181013208,
 179833039,
 -1,
 181078732,
 180947748,
 78459,
 -1,
 181013335,
 78460,
 181209806,
 181013005,
 78454,
 -1,
 181144407,
 78455,
 181340880,
 181144011,
 78452,
 -1,
 181275479,
 78453,
 181471954,
 181274562,
 78447,
 -1,
 181406551,
 78448,
 -62765,
 181406448,
 78458,
 -62764,
 181537460,
 78457,
 -62763,
 181602938,
 78456,
 -62762,
 181668198,
 78451,
 -62761,
 181733583,
 78450,
 -1,
 181798978,
 78449,
 181996263,
 180947010,
 -1,
 182061789,
 181929922,
 78433,
 -62757,
 181998408,
 78436,
 -62756,
 182063449,
 78435,
 -1,
 182127447,
 78434,
 182323935,
 181996324,
 78445,
 -1,
 182258519,
 78446,
 -62752,
 182258416,
 78444,
 -62751,
 182389428,
 78443,
 -62750,
 182454906,
 78442,
 -62749,
 182520333,
 78441,
 -62748,
 182585803,
 78440,
 -62747,
 182651238,
 78439,
 -62746,
 182716623,
 78438,
 -1,
 182782018,
 78437,
 182979314,
 181930443,
 -1,
 -62743,
 182913828,
 78486,
 -62742,
 182979312,
 78485,
 -62741,
 183044788,
 78484,
 -62740,
 183110266,
 78483,
 -62739,
 183175693,
 78482,
 -62738,
 183241163,
 78481,
 -62737,
 183306598,
 78480,
 -62736,
 183371983,
 78479,
 -62735,
 183437378,
 78478,
 -1,
 183502786,
 78477,
 183762943,
 182913549,
 -1,
 183765750,
 183633858,
 78487,
 -62731,
 183701849,
 78489,
 -1,
 183765847,
 78488,
 -1,
 183699522,
 78490,
 184027967,
 178600231,
 -1,
 184093455,
 183961666,
 -1,
 184158978,
 184027343,
 78268,
 -62725,
 184100487,
 78276,
 -62724,
 184165383,
 78275,
 -62723,
 184230334,
 78274,
 -62722,
 184294399,
 78273,
 -62721,
 184358883,
 78272,
 -62720,
 184423240,
 78271,
 -62719,
 184488281,
 78270,
 -1,
 184552279,
 78269,
 184748804,
 184093364,
 78283,
 -1,
 184683351,
 78284,
 184879878,
 184683130,
 78281,
 -1,
 184814423,
 78282,
 185010952,
 184814093,
 78279,
 -1,
 184945495,
 78280,
 185142026,
 184944578,
 78265,
 -1,
 185076567,
 78266,
 -62709,
 185076516,
 78286,
 -62708,
 185207536,
 78285,
 -62707,
 185272779,
 78278,
 -62706,
 185338214,
 78277,
 -1,
 185403458,
 78267,
 185600797,
 184027494,
 -1,
 185666323,
 185534822,
 78304,
 -62702,
 185602393,
 78306,
 -1,
 185666391,
 78305,
 185862933,
 185600066,
 78301,
 -1,
 185797463,
 78302,
 -62698,
 185797412,
 78312,
 -62697,
 185928432,
 78311,
 -62696,
 185993908,
 78310,
 -62695,
 186059386,
 78309,
 -62694,
 186124813,
 78308,
 -62693,
 186190283,
 78307,
 -62692,
 186255567,
 78303,
 -1,
 186320834,
 78300,
 186518315,
 185534671,
 -1,
 186583840,
 186452720,
 78297,
 -1,
 186518359,
 78298,
 186714914,
 186517963,
 78292,
 -1,
 186649431,
 78293,
 186845988,
 186648783,
 78289,
 -1,
 186780503,
 78290,
 -62683,
 186780452,
 78299,
 -62682,
 186911412,
 78296,
 -62681,
 186976890,
 78295,
 -62680,
 187042317,
 78294,
 -62679,
 187107686,
 78291,
 -62678,
 187172930,
 78288,
 -1,
 187238338,
 78287,
 187435832,
 186451906,
 -1,
 187501359,
 187369538,
 78253,
 -62674,
 187437401,
 78255,
 -1,
 187501399,
 78254,
 187697969,
 187435366,
 78257,
 -1,
 187632471,
 78258,
 -62670,
 187632420,
 78264,
 -62669,
 187763440,
 78263,
 -62668,
 187828916,
 78262,
 -62667,
 187894394,
 78261,
 -62666,
 187959821,
 78260,
 -62665,
 188025291,
 78259,
 -1,
 188090575,
 78256,
 188350463,
 187369931,
 -1,
 188353339,
 188221378,
 78313,
 -1,
 188287831,
 78314,
 -62660,
 188287435,
 78318,
 -62659,
 188418406,
 78317,
 -62658,
 188483791,
 78316,
 -1,
 188549186,
 78315,
 188746631,
 183968244,
 -1,
 188812110,
 188680651,
 -1,
 188877635,
 188746420,
 78132,
 -1,
 188812119,
 78133,
 189008709,
 188811898,
 78130,
 -1,
 188943191,
 78131,
 189139783,
 188942861,
 78128,
 -1,
 189074263,
 78129,
 -62648,
 189074212,
 78135,
 -62647,
 189205232,
 78134,
 -62646,
 189270475,
 78127,
 -62645,
 189335910,
 78126,
 -62644,
 189401295,
 78125,
 -62643,
 189466690,
 78124,
 -1,
 189532098,
 78123,
 189729628,
 188746086,
 -1,
 189795153,
 189663984,
 78120,
 -1,
 189729623,
 78121,
 189926227,
 189729460,
 78118,
 -1,
 189860695,
 78119,
 190057301,
 189859906,
 78111,
 -1,
 189991767,
 78112,
 -62634,
 189991716,
 78122,
 -62633,
 190122618,
 78117,
 -62632,
 190188045,
 78116,
 -62631,
 190253515,
 78115,
 -62630,
 190318950,
 78114,
 -62629,
 190384335,
 78113,
 -1,
 190449602,
 78110,
 190647144,
 189663439,
 -1,
 190712671,
 190580802,
 78100,
 -1,
 190647127,
 78101,
 -62624,
 190647076,
 78109,
 -62623,
 190778096,
 78108,
 -62622,
 190843572,
 78107,
 -62621,
 190909050,
 78106,
 -62620,
 190974477,
 78105,
 -62619,
 191039947,
 78104,
 -62618,
 191105382,
 78103,
 -62617,
 191170767,
 78102,
 -1,
 191236034,
 78099,
 191433588,
 190580802,
 -1,
 191499115,
 191367526,
 78091,
 -1,
 191433559,
 78092,
 -62612,
 191433508,
 78098,
 -62611,
 191564528,
 78097,
 -62610,
 191630004,
 78096,
 -62609,
 191695482,
 78095,
 -62608,
 191760909,
 78094,
 -62607,
 191826379,
 78093,
 -62606,
 191891663,
 78090,
 -62605,
 191957058,
 78089,
 -1,
 192022466,
 78088,
 192220031,
 191367106,
 -1,
 192285559,
 192153666,
 78078,
 -1,
 192219991,
 78079,
 -62600,
 192219940,
 78087,
 -62599,
 192350960,
 78086,
 -62598,
 192416436,
 78085,
 -62597,
 192481914,
 78084,
 -62596,
 192547341,
 78083,
 -62595,
 192612811,
 78082,
 -62594,
 192678246,
 78081,
 -1,
 192743631,
 78080,
 193003519,
 192154125,
 -1,
 193006468,
 192874562,
 78137,
 -62590,
 192942920,
 78140,
 -62589,
 193007961,
 78139,
 -1,
 193071959,
 78138,
 -62587,
 192940390,
 78142,
 -62586,
 193202383,
 78141,
 -1,
 193267650,
 78136,
 193465294,
 188687398,
 -1,
 193530773,
 193399243,
 -1,
 193596299,
 193464845,
 78196,
 -1,
 193530711,
 78197,
 193727373,
 193530214,
 78193,
 -1,
 193661783,
 78194,
 -62578,
 193661732,
 78201,
 -62577,
 193792752,
 78200,
 -62576,
 193858228,
 78199,
 -62575,
 193923706,
 78198,
 -62574,
 193989067,
 78195,
 -62573,
 194054351,
 78192,
 -62572,
 194119746,
 78191,
 -1,
 194185154,
 78190,
 194382754,
 193464678,
 -1,
 194448280,
 194316980,
 78186,
 -1,
 194382679,
 78187,
 194579354,
 194382458,
 78184,
 -1,
 194513751,
 78185,
 -62565,
 194513700,
 78189,
 -62564,
 194644720,
 78188,
 -62563,
 194710029,
 78183,
 -62562,
 194775499,
 78182,
 -62561,
 194840934,
 78181,
 -62560,
 194906319,
 78180,
 -62559,
 194971714,
 78179,
 -1,
 195037122,
 78178,
 195234735,
 194316495,
 -1,
 195300261,
 195168890,
 78173,
 -1,
 195234647,
 78174,
 195431335,
 195233730,
 78166,
 -1,
 195365719,
 78167,
 -62552,
 195365668,
 78177,
 -62551,
 195496688,
 78176,
 -62550,
 195562164,
 78175,
 -62549,
 195627533,
 78172,
 -62548,
 195693003,
 78171,
 -62547,
 195758438,
 78170,
 -62546,
 195823823,
 78169,
 -1,
 195889218,
 78168,
 196086716,
 195168194,
 -1,
 196152243,
 196020916,
 78150,
 -62542,
 196088153,
 78152,
 -1,
 196152151,
 78151,
 196348853,
 196086394,
 78148,
 -1,
 196283223,
 78149,
 -62538,
 196283172,
 78154,
 -62537,
 196414192,
 78153,
 -62536,
 196479501,
 78147,
 -62535,
 196544971,
 78146,
 -62534,
 196610406,
 78145,
 -62533,
 196675791,
 78144,
 -1,
 196741186,
 78143,
 196938696,
 196020290,
 -1,
 197004223,
 196872258,
 78156,
 -1,
 196938583,
 78157,
 -62528,
 196938532,
 78165,
 -62527,
 197069552,
 78164,
 -62526,
 197135028,
 78163,
 -62525,
 197200506,
 78162,
 -62524,
 197265933,
 78161,
 -62523,
 197331403,
 78160,
 -62522,
 197396838,
 78159,
 -62521,
 197462223,
 78158,
 -1,
 197527490,
 78155,
 197787647,
 196872717,
 -1,
 -62518,
 197659083,
 78206,
 -62517,
 197724518,
 78205,
 -62516,
 197789903,
 78204,
 -62515,
 197855298,
 78203,
 -1,
 197920706,
 78202,
 198118410,
 193417640,
 -1,
 198183901,
 198051906,
 -1,
 198249427,
 198117835,
 78560,
 -62510,
 198185305,
 78562,
 -1,
 198249303,
 78561,
 198446037,
 198183604,
 78565,
 -1,
 198380375,
 78566,
 -62506,
 198380324,
 78568,
 -62505,
 198511344,
 78567,
 -62504,
 198576762,
 78564,
 -62503,
 198642189,
 78563,
 -62502,
 198707558,
 78559,
 -62501,
 198772943,
 78558,
 -62500,
 198838338,
 78557,
 -1,
 198903746,
 78556,
 199101418,
 198117583,
 -1,
 199166945,
 199035514,
 78575,
 -62496,
 199102809,
 78577,
 -1,
 199166807,
 78576,
 -62494,
 199101220,
 78580,
 -62493,
 199297776,
 78579,
 -62492,
 199363252,
 78578,
 -62491,
 199428621,
 78574,
 -62490,
 199494091,
 78573,
 -62489,
 199559526,
 78572,
 -62488,
 199624911,
 78571,
 -62487,
 199690306,
 78570,
 -1,
 199755714,
 78569,
 199953398,
 199035238,
 -1,
 200018925,
 199887373,
 78586,
 -1,
 199953239,
 78587,
 -62482,
 199953188,
 78591,
 -62481,
 200084208,
 78590,
 -62480,
 200149684,
 78589,
 -62479,
 200215162,
 78588,
 -62478,
 200280523,
 78585,
 -62477,
 200345958,
 78584,
 -62476,
 200411343,
 78583,
 -62475,
 200476738,
 78582,
 -1,
 200542146,
 78581,
 200739842,
 199886786,
 -1,
 200805369,
 200673914,
 78551,
 -1,
 200739671,
 78552,
 200936443,
 200739023,
 78546,
 -1,
 200870743,
 78547,
 -62468,
 200870692,
 78555,
 -62467,
 201001712,
 78554,
 -62466,
 201067188,
 78553,
 -62465,
 201132557,
 78550,
 -62464,
 201198027,
 78549,
 -62463,
 201263462,
 78548,
 -1,
 201328706,
 78545,
 201588735,
 200673739,
 -1,
 -62460,
 201460346,
 78598,
 -62459,
 201525773,
 78597,
 -62458,
 201591243,
 78596,
 -62457,
 201656678,
 78595,
 -62456,
 201722063,
 78594,
 -62455,
 201787458,
 78593,
 -1,
 201852866,
 78592,
 202050623,
 198073672,
 -1,
 202116120,
 201984207,
 -1,
 202181646,
 202050340,
 78674,
 -1,
 202115927,
 78675,
 202312720,
 202115430,
 78667,
 -1,
 202246999,
 78668,
 -62447,
 202246896,
 78673,
 -62446,
 202377908,
 78672,
 -62445,
 202443386,
 78671,
 -62444,
 202508813,
 78670,
 -62443,
 202574283,
 78669,
 -62442,
 202639567,
 78666,
 -62441,
 202704962,
 78665,
 -1,
 202770370,
 78664,
 202968100,
 202049894,
 -1,
 203033627,
 202901711,
 78678,
 -1,
 202967895,
 78679,
 -62436,
 202967844,
 78686,
 -62435,
 203098864,
 78685,
 -62434,
 203164340,
 78684,
 -62433,
 203229818,
 78683,
 -62432,
 203295245,
 78682,
 -62431,
 203360715,
 78681,
 -62430,
 203426150,
 78680,
 -62429,
 203491394,
 78677,
 -1,
 203556802,
 78676,
 203754544,
 202901442,
 -1,
 203820072,
 203688570,
 78648,
 -62425,
 203755865,
 78650,
 -1,
 203819863,
 78649,
 -62423,
 203754276,
 78653,
 -62422,
 203950832,
 78652,
 -62421,
 204016308,
 78651,
 -62420,
 204081677,
 78647,
 -62419,
 204147147,
 78646,
 -62418,
 204212582,
 78645,
 -62417,
 204277967,
 78644,
 -1,
 204343362,
 78643,
 204540987,
 203688002,
 -1,
 -62414,
 204475172,
 78663,
 -62413,
 204540656,
 78662,
 -62412,
 204606132,
 78661,
 -62411,
 204671610,
 78660,
 -62410,
 204737037,
 78659,
 -62409,
 204802507,
 78658,
 -62408,
 204867942,
 78657,
 -62407,
 204933327,
 78656,
 -62406,
 204998722,
 78655,
 -1,
 205064130,
 78654,
 205324287,
 204474827,
 -1,
 -62403,
 205195471,
 78689,
 -62402,
 205260866,
 78688,
 -1,
 205326274,
 78687,
 205524080,
 202004381,
 -1,
 205589582,
 205457346,
 -1,
 205655107,
 205523748,
 78610,
 -1,
 205589335,
 78611,
 205786181,
 205589232,
 78608,
 -1,
 205720407,
 78609,
 205917255,
 205720244,
 78606,
 -1,
 205851479,
 78607,
 206048329,
 205850982,
 78601,
 -1,
 205982551,
 78602,
 -62390,
 205982330,
 78605,
 -62389,
 206113293,
 78604,
 -62388,
 206178763,
 78603,
 -62387,
 206244047,
 78600,
 -1,
 206309442,
 78599,
 206507099,
 205523010,
 -1,
 206572625,
 206441082,
 78619,
 -1,
 206506839,
 78620,
 206703699,
 206506050,
 78613,
 -1,
 206637911,
 78614,
 -62380,
 206637860,
 78623,
 -62379,
 206768880,
 78622,
 -62378,
 206834356,
 78621,
 -62377,
 206899725,
 78618,
 -62376,
 206965195,
 78617,
 -62375,
 207030630,
 78616,
 -62374,
 207096015,
 78615,
 -1,
 207161282,
 78612,
 207359078,
 206440655,
 -1,
 -62371,
 207293220,
 78633,
 -62370,
 207358704,
 78632,
 -62369,
 207424180,
 78631,
 -62368,
 207489658,
 78630,
 -62367,
 207555085,
 78629,
 -62366,
 207620555,
 78628,
 -62365,
 207685990,
 78627,
 -62364,
 207751375,
 78626,
 -62363,
 207816770,
 78625,
 -1,
 207882178,
 78624,
 208142335,
 207292774,
 -1,
 208145513,
 208013670,
 78638,
 -1,
 208079703,
 78639,
 208276587,
 208079055,
 78636,
 -1,
 208210775,
 78637,
 -62356,
 208210554,
 78642,
 -62355,
 208341517,
 78641,
 -62354,
 208406987,
 78640,
 -62353,
 208472130,
 78635,
 -1,
 208537538,
 78634,
 208735393,
 205462650,
 -1,
 208800894,
 208668879,
 -1,
 208866420,
 208734960,
 78066,
 -1,
 208800599,
 78067,
 208997494,
 208799682,
 78057,
 -1,
 208931671,
 78058,
 -62345,
 208931620,
 78068,
 -62344,
 209062580,
 78065,
 -62343,
 209128058,
 78064,
 -62342,
 209193485,
 78063,
 -62341,
 209258955,
 78062,
 -62340,
 209324390,
 78061,
 -62339,
 209389775,
 78060,
 -1,
 209455170,
 78059,
 209652875,
 208734274,
 -1,
 209718401,
 209586868,
 78053,
 -1,
 209652567,
 78054,
 209849475,
 209652346,
 78051,
 -1,
 209783639,
 78052,
 -62332,
 209783588,
 78056,
 -62331,
 209914608,
 78055,
 -62330,
 209979917,
 78050,
 -62329,
 210045387,
 78049,
 -62328,
 210110822,
 78048,
 -62327,
 210176207,
 78047,
 -62326,
 210241602,
 78046,
 -1,
 210307010,
 78045,
 210504855,
 209586114,
 -1,
 210570382,
 210438948,
 78043,
 -1,
 210504535,
 78044,
 210701456,
 210504432,
 78041,
 -1,
 210635607,
 78042,
 -62319,
 210635444,
 78040,
 -62318,
 210766458,
 78039,
 -62317,
 210831885,
 78038,
 -62316,
 210897355,
 78037,
 -62315,
 210962790,
 78036,
 -62314,
 211028175,
 78035,
 -1,
 211093570,
 78034,
 211353599,
 210438502,
 -1,
 211356826,
 211225035,
 78073,
 -1,
 211290967,
 78074,
 -62309,
 211290864,
 78077,
 -62308,
 211421876,
 78076,
 -62307,
 211487354,
 78075,
 -62306,
 211552614,
 78072,
 -62305,
 211617999,
 78071,
 -62304,
 211683394,
 78070,
 -1,
 211748802,
 78069,
 211946701,
 208693489,
 -1,
 212012219,
 211880002,
 -1,
 212077741,
 211945997,
 78842,
 -62299,
 212019982,
 78851,
 -62298,
 212084359,
 78850,
 -62297,
 212149255,
 78849,
 -62296,
 212214206,
 78848,
 -62295,
 212278271,
 78847,
 -62294,
 212342755,
 78846,
 -62293,
 212407112,
 78845,
 -62292,
 212472153,
 78844,
 -1,
 212536151,
 78843,
 212733110,
 212011642,
 78852,
 -62289,
 212674183,
 78860,
 -62288,
 212739079,
 78859,
 -62287,
 212804030,
 78858,
 -62286,
 212868095,
 78857,
 -62285,
 212932579,
 78856,
 -62284,
 212996936,
 78855,
 -62283,
 213061977,
 78854,
 -1,
 213125975,
 78853,
 -62281,
 212666827,
 78841,
 -62280,
 213256550,
 78840,
 -62279,
 213321935,
 78839,
 -62278,
 213387330,
 78838,
 -1,
 213452738,
 78837,
 213712895,
 211945410,
 -1,
 213716161,
 213584079,
 78821,
 -62274,
 213653475,
 78825,
 -62273,
 213717832,
 78824,
 -62272,
 213782873,
 78823,
 -1,
 213846871,
 78822,
 214043844,
 213649766,
 78826,
 -62269,
 213979481,
 78828,
 -1,
 214043479,
 78827,
 214240454,
 213977613,
 78831,
 -1,
 214174551,
 78832,
 214371528,
 214174155,
 78829,
 -1,
 214305623,
 78830,
 -62263,
 214305572,
 78836,
 -62262,
 214436592,
 78835,
 -62261,
 214502068,
 78834,
 -62260,
 214567546,
 78833,
 -1,
 214632514,
 78820,
 214830323,
 211897351,
 -1,
 214895835,
 214763586,
 -1,
 214961361,
 214829690,
 78530,
 -1,
 214895447,
 78531,
 215092435,
 214894530,
 78523,
 -1,
 215026519,
 78524,
 -62252,
 215026468,
 78534,
 -62251,
 215157488,
 78533,
 -62250,
 215222964,
 78532,
 -62249,
 215288333,
 78529,
 -62248,
 215353803,
 78528,
 -62247,
 215419238,
 78527,
 -62246,
 215484623,
 78526,
 -1,
 215550018,
 78525,
 215747816,
 214828994,
 -1,
 215813343,
 215681382,
 78514,
 -62242,
 215748953,
 78516,
 -1,
 215812951,
 78515,
 216009953,
 215746767,
 78512,
 -1,
 215944023,
 78513,
 -62238,
 215943972,
 78522,
 -62237,
 216074992,
 78521,
 -62236,
 216140468,
 78520,
 -62235,
 216205946,
 78519,
 -62234,
 216271373,
 78518,
 -62233,
 216336843,
 78517,
 -1,
 216401986,
 78511,
 216662015,
 215681231,
 -1,
 -62230,
 216533796,
 78544,
 -62229,
 216599280,
 78543,
 -62228,
 216664756,
 78542,
 -62227,
 216730234,
 78541,
 -62226,
 216795661,
 78540,
 -62225,
 216861131,
 78539,
 -62224,
 216926566,
 78538,
 -62223,
 216991951,
 78537,
 -62222,
 217057346,
 78536,
 -1,
 217122754,
 78535,
 217320727,
 214787108,
 -1,
 217386243,
 217253954,
 -1,
 217451767,
 217320176,
 78789,
 -1,
 217385815,
 78790,
 217582841,
 217385652,
 78787,
 -1,
 217516887,
 78788,
 217713915,
 217516491,
 78783,
 -1,
 217647959,
 78784,
 217844989,
 217647042,
 78778,
 -1,
 217779031,
 78779,
 -62210,
 217778980,
 78791,
 -62209,
 217909882,
 78786,
 -62208,
 217975309,
 78785,
 -62207,
 218040678,
 78782,
 -62206,
 218106063,
 78781,
 -1,
 218171458,
 78780,
 218369295,
 217319362,
 -1,
 218434822,
 218303268,
 78776,
 -1,
 218368855,
 78777,
 218565896,
 218368358,
 78769,
 -1,
 218499927,
 78770,
 -62199,
 218499824,
 78775,
 -62198,
 218630836,
 78774,
 -62197,
 218696314,
 78773,
 -62196,
 218761741,
 78772,
 -62195,
 218827211,
 78771,
 -62194,
 218892495,
 78768,
 -1,
 218957890,
 78767,
 219217919,
 218302671,
 -1,
 219221266,
 219089355,
 78796,
 -1,
 219155287,
 78797,
 -62189,
 219154957,
 78798,
 -62188,
 219285862,
 78795,
 -62187,
 219351247,
 78794,
 -62186,
 219416642,
 78793,
 -1,
 219482050,
 78792,
 219680055,
 217256801,
 -1,
 219745573,
 219613122,
 -1,
 219811101,
 219678927,
 77915,
 -62181,
 219747144,
 77918,
 -62180,
 219812185,
 77917,
 -1,
 219876183,
 77916,
 -62178,
 219745060,
 77925,
 -62177,
 220007152,
 77924,
 -62176,
 220072628,
 77923,
 -62175,
 220138106,
 77922,
 -62174,
 220203533,
 77921,
 -62173,
 220269003,
 77920,
 -62172,
 220334438,
 77919,
 -1,
 220399682,
 77914,
 220597553,
 219678786,
 -1,
 220663080,
 220530626,
 77926,
 -1,
 220597079,
 77927,
 -62167,
 220597028,
 77936,
 -62166,
 220728048,
 77935,
 -62165,
 220793524,
 77934,
 -62164,
 220859002,
 77933,
 -62163,
 220924429,
 77932,
 -62162,
 220989899,
 77931,
 -62161,
 221055334,
 77930,
 -62160,
 221120719,
 77929,
 -1,
 221186114,
 77928,
 221446143,
 220530895,
 -1,
 -62157,
 221317579,
 77941,
 -62156,
 221383014,
 77940,
 -62155,
 221448399,
 77939,
 -62154,
 221513794,
 77938,
 -1,
 221579202,
 77937,
 221777229,
 219622212,
 -1,
 221842756,
 221710274,
 -1,
 221908283,
 221776676,
 78225,
 -1,
 221842263,
 78226,
 222039357,
 221841933,
 78220,
 -1,
 221973335,
 78221,
 -62146,
 221973232,
 78224,
 -62145,
 222104244,
 78223,
 -62144,
 222169722,
 78222,
 -62143,
 222235083,
 78219,
 -62142,
 222300518,
 78218,
 -62141,
 222365903,
 78217,
 -1,
 222431298,
 78216,
 222691327,
 221775938,
 -1,
 222694727,
 222562370,
 78229,
 -1,
 222628695,
 78230,
 222825801,
 222627778,
 78227,
 -1,
 222759767,
 78228,
 -62134,
 222759437,
 78234,
 -62133,
 222890443,
 78233,
 -62132,
 222955878,
 78232,
 -1,
 223021263,
 78231,
 223219037,
 221726678,
 -1,
 223284570,
 223152066,
 -1,
 223350097,
 223218022,
 78494,
 -1,
 223284055,
 78495,
 223481171,
 223283266,
 78491,
 -1,
 223415127,
 78492,
 -62124,
 223415076,
 78501,
 -62123,
 223546096,
 78500,
 -62122,
 223611572,
 78499,
 -62121,
 223677050,
 78498,
 -62120,
 223742477,
 78497,
 -62119,
 223807947,
 78496,
 -1,
 223873231,
 78493,
 224133119,
 223217730,
 -1,
 -62116,
 224004162,
 78503,
 -1,
 224069570,
 78502,
 224267626,
 223176405,
 -1,
 224333153,
 224201163,
 78802,
 -62112,
 224268633,
 78804,
 -1,
 224332631,
 78803,
 224529763,
 224266992,
 78809,
 -1,
 224463703,
 78810,
 224660837,
 224463482,
 78806,
 -1,
 224594775,
 78807,
 -62106,
 224594612,
 78808,
 -62105,
 224725517,
 78805,
 -62104,
 224790886,
 78801,
 -62103,
 224856271,
 78800,
 -1,
 224921666,
 78799,
 225119605,
 224211888,
 -1,
 225185133,
 225053306,
 78249,
 -1,
 225119063,
 78250,
 225316207,
 225118415,
 78244,
 -1,
 225250135,
 78245,
 -62096,
 225250032,
 78252,
 -62095,
 225381044,
 78251,
 -62094,
 225446413,
 78248,
 -62093,
 225511883,
 78247,
 -62092,
 225577318,
 78246,
 -1,
 225642562,
 78243,
 225840512,
 225055080,
 -1,
 225906040,
 225774093,
 77908,
 -1,
 225839959,
 77909,
 -62087,
 225839908,
 77913,
 -62086,
 225970928,
 77912,
 -62085,
 226036404,
 77911,
 -62084,
 226101882,
 77910,
 -62083,
 226167243,
 77907,
 -62082,
 226232678,
 77906,
 -62081,
 226298063,
 77905,
 -1,
 226363458,
 77904,
 226561418,
 225797937,
 -1,
 226626947,
 226494530,
 78811,
 -1,
 226560855,
 78812,
 -62076,
 226560752,
 78819,
 -62075,
 226691764,
 78818,
 -62074,
 226757242,
 78817,
 -62073,
 226822669,
 78816,
 -62072,
 226888139,
 78815,
 -62071,
 226953574,
 78814,
 -1,
 227018959,
 78813,
 227216788,
 226502297,
 -1,
 227282317,
 227150458,
 78212,
 -1,
 227216215,
 78213,
 -62066,
 227216112,
 78215,
 -62065,
 227347124,
 78214,
 -62064,
 227412493,
 78211,
 -62063,
 227477963,
 78210,
 -62062,
 227543398,
 78209,
 -62061,
 227608783,
 78208,
 -1,
 227674178,
 78207,
 227872157,
 227160480,
 -1,
 -62058,
 227805936,
 78242,
 -62057,
 227871412,
 78241,
 -62056,
 227936890,
 78240,
 -62055,
 228002317,
 78239,
 -62054,
 228067787,
 78238,
 -62053,
 228133222,
 78237,
 -62052,
 228198607,
 78236,
 -1,
 228264002,
 78235,
 228524031,
 227822312,
 -1,
 -62049,
 228395700,
 78510,
 -62048,
 228461178,
 78509,
 -62047,
 228526605,
 78508,
 -62046,
 228592075,
 78507,
 -62045,
 228657510,
 78506,
 -62044,
 228722895,
 78505,
 -1,
 228788290,
 78504,
 228986426,
 150952256,
 -1,
 229051948,
 228938115,
 -1,
 229117483,
 229009451,
 -1,
 229182907,
 229053256,
 -1,
 229248441,
 229118792,
 -1,
 229313970,
 229189255,
 -1,
 229379501,
 229252095,
 11709,
 -1,
 229317631,
 11708,
 229510575,
 229313367,
 11704,
 -1,
 229444439,
 11707,
 -62032,
 229465330,
 11705,
 -62031,
 229589202,
 11710,
 -1,
 229649166,
 11706,
 229838260,
 229252095,
 11693,
 -1,
 229776383,
 11692,
 229969334,
 229772119,
 11688,
 -1,
 229903191,
 11691,
 -62025,
 229924082,
 11689,
 -62024,
 230047954,
 11694,
 -1,
 230107918,
 11690,
 -62022,
 229196040,
 11655,
 -1,
 230238507,
 11664,
 230428108,
 229123079,
 -1,
 230493636,
 230385432,
 -1,
 230559167,
 230431743,
 11741,
 -1,
 230497279,
 11740,
 230690241,
 230493015,
 11736,
 -1,
 230624087,
 11739,
 -62014,
 230644978,
 11737,
 -62013,
 230768850,
 11742,
 -1,
 230828814,
 11738,
 231017930,
 230434401,
 -1,
 231083463,
 230956031,
 11670,
 -1,
 231021567,
 11669,
 231214537,
 231017303,
 11667,
 -1,
 231148375,
 4895,
 -1,
 231156494,
 11668,
 -62005,
 230965512,
 4879,
 -1,
 231356418,
 11658,
 231542236,
 230379907,
 -1,
 231607765,
 231494019,
 -1,
 231673296,
 231545855,
 11685,
 -1,
 231611391,
 11684,
 231804370,
 231607127,
 11680,
 -1,
 231738199,
 11683,
 -61997,
 231759090,
 11681,
 -61996,
 231882962,
 11686,
 -1,
 231942926,
 11682,
 232132058,
 231546091,
 -1,
 -61993,
 232082138,
 5004,
 -61992,
 232144263,
 4992,
 -61991,
 232203267,
 5000,
 -1,
 232264499,
 4996,
 -61989,
 232079624,
 11651,
 -1,
 232401195,
 11652,
 232590822,
 231500007,
 -1,
 232656357,
 232548583,
 -1,
 232721888,
 232594431,
 11701,
 -1,
 232659967,
 11700,
 232852962,
 232655703,
 11696,
 -1,
 232786775,
 11699,
 -61981,
 232807666,
 11697,
 -61980,
 232931538,
 11702,
 -1,
 232991502,
 11698,
 -1,
 232603912,
 11659,
 233246192,
 232548023,
 -1,
 233311727,
 233203480,
 -1,
 233377258,
 233249791,
 11733,
 -1,
 233315327,
 11732,
 233508332,
 233311063,
 11728,
 -1,
 233442135,
 11731,
 -61971,
 233463026,
 11729,
 -61970,
 233586898,
 11734,
 -1,
 233646862,
 11730,
 -1,
 233259272,
 4743,
 233901562,
 233196254,
 -1,
 233967097,
 233858840,
 -1,
 234032628,
 233905151,
 11717,
 -1,
 233970687,
 11716,
 234163702,
 233966423,
 11712,
 -1,
 234097495,
 11715,
 -61961,
 234118386,
 11713,
 -61960,
 234242258,
 11718,
 -1,
 234302222,
 11714,
 -1,
 233914632,
 4679,
 234556932,
 233845142,
 -1,
 234622467,
 234514200,
 -1,
 234687998,
 234560511,
 11725,
 -1,
 234626047,
 11724,
 234819072,
 234621783,
 11720,
 -1,
 234752855,
 11723,
 -61951,
 234773746,
 11721,
 -61950,
 234897618,
 11726,
 -1,
 234957582,
 11722,
 -1,
 234569992,
 4783,
 235212299,
 234506133,
 -1,
 235277833,
 235168754,
 -1,
 235343368,
 235215871,
 5007,
 -1,
 235281407,
 5006,
 -1,
 235285262,
 5005,
 -61942,
 235225352,
 11666,
 -1,
 235481387,
 11665,
 235671057,
 235157732,
 -1,
 235736592,
 235627506,
 -1,
 235802127,
 235674623,
 4995,
 -1,
 235740159,
 4994,
 -1,
 235744014,
 4993,
 -1,
 235684104,
 11649,
 236064279,
 235606361,
 -1,
 236129814,
 236020722,
 -1,
 236195349,
 236067839,
 4999,
 -1,
 236133375,
 4998,
 -1,
 236137230,
 4997,
 -1,
 236077320,
 11653,
 236457499,
 236017544,
 -1,
 -61927,
 236415423,
 4935,
 -61926,
 236470536,
 11654,
 -1,
 236529963,
 11663,
 236719647,
 236397568,
 -1,
 236785182,
 236657663,
 5003,
 -1,
 236723199,
 5002,
 -1,
 236727054,
 5001,
 236981794,
 236666270,
 -1,
 -61919,
 236939329,
 11657,
 -1,
 236994824,
 11656,
 237178405,
 236918755,
 -1,
 -61916,
 237125896,
 11660,
 -1,
 237181383,
 11661,
 -61914,
 237135937,
 4847,
 -61913,
 237332091,
 4815,
 -61912,
 237391952,
 11650,
 -61911,
 237451180,
 11648,
 -61910,
 237515093,
 11662,
 -1,
 237578539,
 4615,
 -1,
 229055743,
 4960,
 237833785,
 229005975,
 -1,
 237899313,
 237770723,
 -1,
 237964848,
 237838193,
 5009,
 -1,
 237897553,
 5016,
 -1,
 237906977,
 5012,
 238161460,
 237842838,
 -1,
 -61901,
 238116956,
 5017,
 -1,
 238165663,
 5013,
 -61899,
 238118949,
 5008,
 -61898,
 238310246,
 5011,
 -61897,
 238374748,
 5010,
 -61896,
 238430215,
 5015,
 -1,
 238490787,
 5014,
 -1,
 237770282,
 4959,
 -61893,
 228936499,
 11072,
 -61892,
 238695671,
 9191,
 -61891,
 238760205,
 9167,
 -61890,
 238819739,
 11790,
 -1,
 238882787,
 9178,
 239080089,
 150877065,
 -1,
 239144990,
 239012695,
 -1,
 239210513,
 239098450,
 -1,
 239275850,
 239161731,
 -1,
 239341375,
 239221146,
 -1,
 239406908,
 239285765,
 -1,
 239472224,
 239359880,
 -1,
 239537748,
 239426802,
 -1,
 239603283,
 239489084,
 -1,
 239668811,
 239550674,
 -1,
 -61878,
 239618206,
 7432,
 -1,
 239672319,
 7444,
 239865421,
 239610638,
 7433,
 -1,
 239812607,
 42879,
 239996495,
 239806089,
 686,
 -1,
 239927381,
 687,
 -61872,
 239946747,
 11385,
 -61871,
 240071561,
 42881,
 -61870,
 240133127,
 7543,
 -1,
 240192649,
 7426,
 -1,
 239548644,
 42871,
 240455256,
 239478407,
 -1,
 240520791,
 240403635,
 42853,
 -1,
 240452869,
 42855,
 -1,
 240453315,
 7546,
 240717404,
 240387556,
 -1,
 -61862,
 240663453,
 7541,
 -61861,
 240720161,
 11366,
 -1,
 240785346,
 566,
 -61859,
 240675047,
 42793,
 -61858,
 240930250,
 42795,
 -61857,
 240993151,
 7446,
 -1,
 241044788,
 11383,
 241241722,
 239410175,
 -1,
 241307250,
 241173988,
 -1,
 241372774,
 241263236,
 983555,
 241500159,
 241303610,
 -1,
 -61851,
 241378821,
 983557,
 -1,
 241437762,
 983559,
 241634921,
 241320359,
 -1,
 -61848,
 241588712,
 983585,
 -1,
 241634370,
 983583,
 241831532,
 241572329,
 -1,
 -61845,
 241785320,
 983589,
 -1,
 241830978,
 983587,
 242028143,
 241767795,
 -1,
 -61842,
 241973555,
 983561,
 -1,
 242029565,
 983563,
 -61840,
 241981114,
 583,
 -61839,
 242175450,
 7570,
 -1,
 242237379,
 11384,
 242421365,
 241259160,
 -1,
 -61836,
 242372058,
 7576,
 -1,
 242436084,
 7563,
 242617976,
 242361976,
 -1,
 -61833,
 242562318,
 42787,
 -1,
 242625837,
 42789,
 -61831,
 242575743,
 7578,
 -1,
 242767752,
 42859,
 242945678,
 241183502,
 -1,
 243011205,
 242877924,
 -1,
 243076736,
 242948585,
 -1,
 -61826,
 243030504,
 983591,
 -61825,
 243082757,
 983590,
 -1,
 243141698,
 983566,
 243338883,
 243024307,
 -1,
 -61822,
 243292648,
 983595,
 -1,
 243338306,
 983593,
 -61820,
 243289562,
 7574,
 -1,
 243480902,
 983565,
 243666572,
 242958327,
 -1,
 -61817,
 243619720,
 42887,
 -61816,
 243683715,
 42885,
 -61815,
 243747788,
 42883,
 -61814,
 243803143,
 7545,
 -61813,
 243868094,
 42876,
 -1,
 243931107,
 42874,
 -61811,
 243618179,
 42861,
 -1,
 244073762,
 7548,
 244256413,
 242897283,
 -1,
 244321942,
 244198375,
 -1,
 244387475,
 244269266,
 7441,
 -61806,
 244336804,
 7442,
 -1,
 244385495,
 7443,
 -61804,
 244342002,
 7453,
 -61803,
 244538433,
 7455,
 -1,
 244586761,
 7454,
 244780699,
 244254180,
 -1,
 -61800,
 244736644,
 983575,
 -61799,
 244799317,
 575,
 -61798,
 244860916,
 7562,
 -1,
 244923293,
 7540,
 -61796,
 244716752,
 7573,
 -1,
 245042718,
 42892,
 245239468,
 244190039,
 -1,
 245304997,
 245171684,
 -1,
 245370530,
 245252519,
 -1,
 -61791,
 245324264,
 983581,
 -1,
 245369922,
 983579,
 -61789,
 245323450,
 11365,
 -61788,
 245517786,
 7567,
 -1,
 245578054,
 983553,
 245763751,
 245260552,
 42809,
 -1,
 245696089,
 42811,
 -61784,
 245720856,
 42813,
 -61783,
 245849330,
 42807,
 -61782,
 245907666,
 42805,
 -61781,
 245971062,
 7568,
 -1,
 246025047,
 42803,
 246222523,
 245189580,
 -1,
 246288053,
 246153216,
 -1,
 246353588,
 246244773,
 -1,
 -61776,
 246307304,
 983603,
 -61775,
 246372026,
 589,
 -61774,
 246433780,
 7561,
 -61773,
 246496157,
 7538,
 -1,
 246555323,
 7539,
 -1,
 246304935,
 42843,
 246812345,
 246227110,
 -1,
 246877880,
 246747976,
 8580,
 -1,
 246810152,
 42815,
 -1,
 246825879,
 7572,
 247136255,
 246767262,
 42869,
 -1,
 247006360,
 42845,
 247205576,
 246177010,
 -1,
 247271109,
 247137764,
 -1,
 247336641,
 247216442,
 -1,
 -61761,
 247290344,
 983611,
 -61760,
 247342597,
 983577,
 -1,
 247401538,
 983609,
 247598788,
 247284135,
 -1,
 -61757,
 247552488,
 983607,
 -1,
 247598146,
 983605,
 -1,
 247549402,
 7577,
 -61754,
 247220868,
 7551,
 -61753,
 247806180,
 42872,
 -1,
 247864319,
 7531,
 248057558,
 247152850,
 -1,
 248123090,
 247989732,
 -1,
 248188622,
 248078980,
 983569,
 248315903,
 248119354,
 -1,
 -61747,
 248194565,
 983571,
 -1,
 248253506,
 983573,
 248512511,
 248133545,
 -1,
 -61744,
 248407039,
 11386,
 -61743,
 248464252,
 42829,
 -1,
 248528647,
 42827,
 248712917,
 248072345,
 -1,
 -61740,
 248660200,
 7575,
 -1,
 248716388,
 7571,
 -1,
 248660178,
 42831,
 248975073,
 248001417,
 -1,
 249040605,
 248907236,
 -1,
 -61735,
 248994280,
 983599,
 -61734,
 249055220,
 7557,
 -61733,
 249112685,
 42825,
 -61732,
 249174751,
 11361,
 -1,
 249239490,
 564,
 249433824,
 248988437,
 -1,
 -61729,
 249374829,
 7837,
 -1,
 249436449,
 7836,
 -1,
 249388702,
 42866,
 249695979,
 248911843,
 -1,
 249761511,
 249628132,
 -1,
 -61724,
 249710580,
 7553,
 -61723,
 249772957,
 7533,
 -61722,
 249833821,
 7569,
 -1,
 249894850,
 545,
 -61720,
 249716382,
 42865,
 -61719,
 250037571,
 567,
 -61718,
 250093122,
 7839,
 -1,
 250155355,
 568,
 250351348,
 249651464,
 -1,
 250416881,
 250283492,
 -1,
 -61714,
 250367693,
 11377,
 -61713,
 250431476,
 7564,
 -61712,
 250485025,
 42847,
 -1,
 250550210,
 11380,
 -61710,
 250373912,
 42849,
 -61709,
 250687431,
 42851,
 -1,
 250748580,
 42857,
 250941180,
 250300366,
 -1,
 251006713,
 250892675,
 -1,
 251072248,
 250960805,
 7549,
 -1,
 251004165,
 42833,
 -1,
 251022271,
 42837,
 -61702,
 250955764,
 7560,
 -61701,
 251214749,
 7537,
 -1,
 251274015,
 42835,
 251465477,
 250886372,
 -1,
 251531009,
 251397604,
 -1,
 -61697,
 251484648,
 983601,
 -61696,
 251545588,
 7558,
 -1,
 251607965,
 7535,
 251793156,
 251472831,
 -1,
 -61693,
 251748616,
 7933,
 -1,
 251803415,
 7931,
 -1,
 251747998,
 42867,
 252055308,
 251411870,
 -1,
 252120842,
 251987428,
 -1,
 -61688,
 252069876,
 7559,
 -61687,
 252132253,
 7536,
 -1,
 252188610,
 565,
 -61685,
 252075678,
 42868,
 -1,
 252322835,
 983567,
 252514067,
 251998616,
 -1,
 252579599,
 252466874,
 42817,
 -1,
 252510272,
 42821,
 252710674,
 252516323,
 -1,
 -61679,
 252652359,
 42819,
 -1,
 252714927,
 11370,
 -1,
 252659700,
 7556,
 252972824,
 252471529,
 -1,
 -61675,
 252925781,
 576,
 -61674,
 252987380,
 7566,
 -61673,
 253049757,
 7542,
 -1,
 253106366,
 11372,
 253300510,
 252922590,
 -1,
 253366045,
 253232612,
 -1,
 -61669,
 253318899,
 42839,
 -61668,
 253372779,
 587,
 -1,
 253434145,
 42841,
 -1,
 253314970,
 569,
 253693731,
 253236040,
 -1,
 253759265,
 253648247,
 42797,
 -1,
 253691371,
 42799,
 -61662,
 253706877,
 42863,
 -1,
 253822679,
 572,
 254021417,
 253628761,
 -1,
 254086951,
 253953508,
 -1,
 -61658,
 254035956,
 7552,
 -1,
 254098333,
 7532,
 -61656,
 254038139,
 42823,
 -1,
 254231909,
 7447,
 254414637,
 253961863,
 -1,
 -61653,
 254353102,
 42791,
 -61652,
 254414313,
 11382,
 -1,
 254477826,
 11368,
 254676785,
 254354439,
 -1,
 -61649,
 254621708,
 578,
 -61648,
 254682781,
 983041,
 -1,
 254740144,
 7555,
 254938932,
 254633769,
 -1,
 -61645,
 254891706,
 591,
 -1,
 254949340,
 7935,
 255135543,
 254882013,
 -1,
 -61642,
 255088314,
 585,
 -1,
 255138296,
 983597,
 255332154,
 255074796,
 -1,
 -61639,
 255281140,
 7554,
 -1,
 255343517,
 7534,
 -61637,
 255289025,
 7565,
 -1,
 255484952,
 11379,
 255721471,
 239342560,
 -1,
 -61634,
 255614255,
 7550,
 -1,
 255666991,
 7547,
 255918079,
 239295993,
 -1,
 -61631,
 255813303,
 8339,
 -61630,
 255877384,
 7525,
 -61629,
 255941874,
 7524,
 -61628,
 256004605,
 8340,
 -61627,
 256068556,
 7523,
 -61626,
 256131282,
 8338,
 -61625,
 256192731,
 11388,
 -61624,
 256256782,
 7522,
 -61623,
 256318463,
 8337,
 -1,
 256379735,
 8336,
 256577510,
 239211488,
 -1,
 256642911,
 256515071,
 -1,
 256708443,
 256574948,
 -1,
 256773969,
 256664196,
 983554,
 256901119,
 256704570,
 -1,
 -61616,
 256779781,
 983556,
 -1,
 256838722,
 983558,
 257036116,
 256721319,
 -1,
 -61613,
 256989672,
 983584,
 -1,
 257035330,
 983582,
 257232727,
 256973289,
 -1,
 -61610,
 257186280,
 983588,
 -1,
 257231938,
 983586,
 257429338,
 257168755,
 -1,
 -61607,
 257374515,
 983560,
 -1,
 257430525,
 983562,
 -1,
 257382074,
 582,
 257691486,
 256648824,
 -1,
 -61603,
 257635598,
 42786,
 -1,
 257699117,
 42788,
 -1,
 257644424,
 42858,
 257953645,
 256576343,
 -1,
 258019174,
 257885668,
 -1,
 258084708,
 257966503,
 -1,
 -61597,
 258038248,
 983580,
 -1,
 258083906,
 983578,
 -61595,
 258037434,
 570,
 -1,
 258226502,
 983552,
 258412392,
 257974536,
 42808,
 -1,
 258344537,
 42810,
 -61591,
 258369304,
 42812,
 -61590,
 258497778,
 42806,
 -61589,
 258556114,
 42804,
 -61588,
 258619505,
 11373,
 -1,
 258673495,
 42802,
 258871161,
 257906568,
 -1,
 258936692,
 258826325,
 -1,
 259002225,
 258870103,
 11375,
 -1,
 258947185,
 11376,
 -61582,
 258957576,
 581,
 -61581,
 259077001,
 42880,
 -1,
 259141236,
 42878,
 259329910,
 258877895,
 42852,
 -1,
 259261701,
 42854,
 -61577,
 259287271,
 42792,
 -61576,
 259411402,
 42794,
 -1,
 259458578,
 574,
 259657607,
 258812686,
 -1,
 259723137,
 259604471,
 -1,
 -61572,
 259676040,
 42886,
 -61571,
 259740035,
 42884,
 -61570,
 259804108,
 42882,
 -61569,
 259859463,
 42877,
 -61568,
 259924414,
 42875,
 -1,
 259987427,
 42873,
 260181894,
 259655140,
 -1,
 260247429,
 260129191,
 -1,
 -61564,
 260200936,
 983594,
 -1,
 260246594,
 983592,
 -1,
 260192582,
 983564,
 -1,
 260133251,
 42860,
 260575121,
 259611892,
 -1,
 260640656,
 260531621,
 -1,
 260706189,
 260585786,
 -1,
 -61557,
 260659688,
 983610,
 -61556,
 260711941,
 983576,
 -1,
 260770882,
 983608,
 261029887,
 260653479,
 -1,
 -61553,
 260921832,
 983606,
 -1,
 260967490,
 983604,
 -1,
 260575670,
 580,
 261230491,
 260525004,
 -1,
 261296025,
 261160960,
 -1,
 261361560,
 261252517,
 -1,
 261427095,
 261314440,
 -1,
 -61546,
 261369053,
 983602,
 -1,
 261426470,
 11364,
 -1,
 261379770,
 588,
 -1,
 261312679,
 42842,
 -61542,
 261250729,
 42844,
 -1,
 261693615,
 42814,
 261885861,
 261177554,
 -1,
 261951396,
 261817828,
 -1,
 262016929,
 261907076,
 983568,
 262143999,
 261947450,
 -1,
 -61536,
 262022661,
 983570,
 -1,
 262081602,
 983572,
 262340607,
 261961641,
 -1,
 -61533,
 262226812,
 42828,
 -1,
 262291207,
 42826,
 -1,
 261898450,
 42830,
 262541228,
 261837187,
 -1,
 262606761,
 262473188,
 -1,
 -61528,
 262562436,
 983574,
 -1,
 262625109,
 11390,
 -61526,
 262552033,
 586,
 -61525,
 262743886,
 7838,
 -1,
 262802974,
 42891,
 262999986,
 262484887,
 -1,
 -61522,
 262953448,
 983598,
 -61521,
 263011229,
 11362,
 -61520,
 263071853,
 42824,
 -61519,
 263133919,
 11360,
 -1,
 263197110,
 573,
 263393207,
 262955272,
 -1,
 -61516,
 263350040,
 42848,
 -61515,
 263401415,
 42850,
 -61514,
 263462564,
 42856,
 -1,
 263521810,
 42846,
 263720893,
 263342030,
 -1,
 263786428,
 263672195,
 -1,
 263851963,
 263740325,
 11363,
 -1,
 263783685,
 42832,
 -1,
 263801791,
 42836,
 -1,
 263725855,
 42834,
 264114116,
 263665892,
 -1,
 264179649,
 264055743,
 -1,
 -61504,
 264134920,
 7932,
 -1,
 264189719,
 7930,
 264437759,
 264111588,
 -1,
 -61501,
 264329704,
 983600,
 -1,
 264382808,
 11374,
 264572874,
 264057240,
 -1,
 264638407,
 264525498,
 42816,
 -1,
 264568896,
 42820,
 264830975,
 264574947,
 -1,
 -61495,
 264710983,
 42818,
 -1,
 264773551,
 11369,
 264966095,
 264508232,
 -1,
 265031629,
 264920439,
 42796,
 -1,
 264963563,
 42798,
 -61490,
 264979069,
 42862,
 -1,
 265094871,
 571,
 265293779,
 264906375,
 -1,
 -61487,
 265232078,
 42790,
 -61486,
 265293289,
 11381,
 -1,
 265356802,
 11367,
 265555926,
 265251049,
 -1,
 -61483,
 265508693,
 11391,
 -1,
 265558206,
 11371,
 265752537,
 265512745,
 -1,
 -61480,
 265705146,
 590,
 -1,
 265762780,
 7934,
 265949148,
 265702112,
 -1,
 -61477,
 265901811,
 42838,
 -1,
 265951521,
 42840,
 266145759,
 265892061,
 -1,
 -61474,
 266099176,
 983596,
 -1,
 266163898,
 584,
 266342370,
 266085383,
 -1,
 -61471,
 266287116,
 577,
 -1,
 266348189,
 983040,
 266538981,
 266277209,
 -1,
 -61468,
 266489979,
 42822,
 -1,
 266536663,
 579,
 -1,
 266495000,
 11378,
 266801161,
 256521733,
 -1,
 266866695,
 266753171,
 -1,
 266932204,
 266819464,
 7451,
 267059199,
 266887253,
 -1,
 -61461,
 266947532,
 7450,
 -1,
 267000831,
 11387,
 267194353,
 266881996,
 -1,
 267259888,
 267133094,
 -1,
 -61457,
 267209676,
 7449,
 -1,
 267271582,
 7438,
 -1,
 267214494,
 42870,
 267522036,
 267141330,
 7439,
 -61453,
 267476210,
 7445,
 -1,
 267536548,
 7440,
 267718647,
 267459583,
 7431,
 -61450,
 267676028,
 7459,
 -1,
 267737328,
 7430,
 267915257,
 267651927,
 7424,
 -1,
 267852799,
 7425,
 -61446,
 267872487,
 7458,
 -61445,
 268002290,
 7457,
 -61444,
 268067080,
 7456,
 -61443,
 268131570,
 7452,
 -61442,
 268194179,
 42801,
 -61441,
 268257173,
 7448,
 -61440,
 268318948,
 7437,
 -61439,
 268383135,
 7436,
 -61438,
 268448150,
 7435,
 -61437,
 268513499,
 7434,
 -61436,
 268575166,
 42800,
 -61435,
 268638179,
 7429,
 -61434,
 268702536,
 7428,
 -1,
 268767711,
 7427,
 -61432,
 266822457,
 7460,
 -1,
 268897607,
 7461,
 269156351,
 266739516,
 -1,
 269160461,
 269045234,
 -1,
 -61428,
 269109141,
 43004,
 -1,
 269164990,
 43003,
 269357072,
 269101838,
 -1,
 -61425,
 269303938,
 43005,
 -1,
 269353474,
 43006,
 -1,
 269291332,
 43007,
 269619224,
 239160847,
 -1,
 269684757,
 269573239,
 -1,
 -61420,
 269635494,
 68414,
 -1,
 269687379,
 68412,
 269942783,
 269632163,
 -1,
 -61417,
 269832070,
 68415,
 -1,
 269883957,
 68413,
 270139391,
 269566174,
 -1,
 270143516,
 270017337,
 -1,
 -61413,
 270090877,
 983043,
 -1,
 270143803,
 983044,
 -61411,
 270094413,
 983045,
 -1,
 270284713,
 983046,
 270471615,
 239086350,
 -1,
 270536995,
 270417563,
 -1,
 270602416,
 270478288,
 -1,
 270667918,
 270537049,
 -1,
 270733424,
 270600258,
 -1,
 270798903,
 270665666,
 -1,
 270864424,
 270731789,
 -1,
 -61402,
 270809360,
 65669,
 -61401,
 270868940,
 65668,
 -1,
 270926111,
 65667,
 271126571,
 270797604,
 -1,
 -61398,
 271071481,
 65677,
 -1,
 271131072,
 65676,
 271323182,
 271059696,
 -1,
 -61395,
 271268073,
 65675,
 -1,
 271327718,
 65674,
 271519793,
 271256244,
 -1,
 -61392,
 271464704,
 65673,
 -1,
 271524315,
 65672,
 271716404,
 271452794,
 -1,
 -61389,
 271661322,
 65671,
 -1,
 271720902,
 65670,
 -61387,
 271649236,
 65666,
 -61386,
 271845689,
 65665,
 -1,
 271910889,
 65664,
 272109634,
 270731898,
 -1,
 -61383,
 272042788,
 65713,
 -61382,
 272108272,
 65712,
 -61381,
 272173748,
 65711,
 -61380,
 272239226,
 65710,
 -61379,
 272304653,
 65709,
 -61378,
 272370123,
 65708,
 -61377,
 272435573,
 65707,
 -61376,
 272500961,
 65706,
 -61375,
 272566338,
 65705,
 -1,
 272631746,
 65704,
 272830540,
 272042676,
 -1,
 -61372,
 272763684,
 65722,
 -61371,
 272829168,
 65721,
 -61370,
 272894644,
 65720,
 -61369,
 272960161,
 65719,
 -61368,
 273025483,
 65718,
 -61367,
 273090952,
 65717,
 -61366,
 273156303,
 65716,
 -61365,
 273221698,
 65715,
 -1,
 273287106,
 65714,
 273485909,
 272763405,
 -1,
 -61362,
 273419046,
 65703,
 -61361,
 273484528,
 65702,
 -61360,
 273550004,
 65701,
 -61359,
 273615307,
 65699,
 -61358,
 273680742,
 65698,
 -61357,
 273746127,
 65697,
 -61356,
 273811583,
 65696,
 -1,
 273876930,
 65695,
 274075741,
 273418992,
 -1,
 -61353,
 274008868,
 65729,
 -61352,
 274074125,
 65728,
 -61351,
 274139595,
 65727,
 -61350,
 274205030,
 65726,
 -61349,
 274270415,
 65725,
 -61348,
 274335810,
 65724,
 -1,
 274401218,
 65723,
 274600035,
 274008523,
 -1,
 -61345,
 274532986,
 65694,
 -61344,
 274598482,
 65693,
 -61343,
 274663631,
 65692,
 -61342,
 274729071,
 65691,
 -1,
 274794436,
 65690,
 274993257,
 274532559,
 -1,
 -61339,
 274926115,
 65682,
 -61338,
 274991525,
 65681,
 -61337,
 275056880,
 65680,
 -61336,
 275122252,
 65679,
 -1,
 275187728,
 65678,
 275386477,
 274925926,
 -1,
 -61333,
 275318991,
 65687,
 -61332,
 275384489,
 65686,
 -1,
 275449844,
 65685,
 275709951,
 275319588,
 -1,
 -61329,
 275581046,
 65731,
 -1,
 275646402,
 65730,
 275906559,
 270665935,
 -1,
 275910779,
 275778061,
 -1,
 -61325,
 275843876,
 65757,
 -61324,
 275909360,
 65756,
 -61323,
 275974836,
 65755,
 -61322,
 276040314,
 65754,
 -61321,
 276105741,
 65753,
 -61320,
 276171213,
 65752,
 -61319,
 276236646,
 65751,
 -61318,
 276302031,
 65750,
 -1,
 276367426,
 65749,
 276566148,
 275843531,
 -1,
 -61315,
 276499236,
 65748,
 -61314,
 276564720,
 65747,
 -61313,
 276630138,
 65745,
 -61312,
 276695565,
 65744,
 -61311,
 276761013,
 65743,
 -61310,
 276826321,
 65742,
 -61309,
 276891733,
 65741,
 -1,
 276957208,
 65740,
 277155979,
 276498790,
 -1,
 -61306,
 277088890,
 65739,
 -61305,
 277154251,
 65738,
 -61304,
 277219757,
 65737,
 -61303,
 277285071,
 65736,
 -61302,
 277350468,
 65735,
 -1,
 277415940,
 65734,
 277676031,
 277088463,
 -1,
 -61299,
 277547545,
 65733,
 -1,
 277612499,
 65732,
 277872639,
 270623417,
 -1,
 277876910,
 277743823,
 -1,
 277942427,
 277809218,
 -1,
 -61294,
 277875492,
 65778,
 -61293,
 277940976,
 65777,
 -61292,
 278006452,
 65776,
 -61291,
 278071930,
 65775,
 -61290,
 278137357,
 65774,
 -61289,
 278202827,
 65773,
 -61288,
 278268262,
 65772,
 -61287,
 278333647,
 65771,
 -61286,
 278399042,
 65770,
 -1,
 278464450,
 65769,
 278663334,
 277874626,
 -1,
 -61283,
 278596388,
 65768,
 -61282,
 278661872,
 65767,
 -61281,
 278727348,
 65766,
 -61280,
 278792826,
 65765,
 -61279,
 278858253,
 65764,
 -61278,
 278923723,
 65763,
 -61277,
 278989158,
 65762,
 -61276,
 279054543,
 65761,
 -61275,
 279119938,
 65760,
 -1,
 279185346,
 65759,
 279384237,
 278595791,
 -1,
 -61272,
 279317284,
 65784,
 -61271,
 279382768,
 65783,
 -61270,
 279448244,
 65782,
 -61269,
 279513722,
 65781,
 -61268,
 279578831,
 65780,
 -1,
 279644226,
 65779,
 -1,
 279317085,
 65785,
 -61265,
 277809601,
 65786,
 -1,
 279840955,
 65758,
 280039705,
 270554983,
 -1,
 280105222,
 279983906,
 -1,
 280170684,
 280038068,
 -1,
 -61260,
 280103693,
 65572,
 -61259,
 280169152,
 65551,
 -61258,
 280234640,
 65608,
 -61257,
 280300109,
 65592,
 -61256,
 280365556,
 65597,
 -61255,
 280430979,
 65558,
 -61254,
 280496376,
 65567,
 -61253,
 280561769,
 65603,
 -1,
 280627167,
 65554,
 280826054,
 280103437,
 -1,
 -61250,
 280759102,
 65586,
 -61249,
 280824600,
 65585,
 -61248,
 280890043,
 65546,
 -61247,
 280955459,
 65565,
 -61246,
 281020911,
 65591,
 -61245,
 281086368,
 65578,
 -61244,
 281151723,
 65564,
 -61243,
 281217124,
 65545,
 -1,
 281282554,
 65570,
 281481424,
 280758479,
 -1,
 -61240,
 281414451,
 65606,
 -61239,
 281479930,
 65538,
 -61238,
 281545425,
 65577,
 -61237,
 281610902,
 65580,
 -61236,
 281676303,
 65600,
 -61235,
 281741797,
 65562,
 -61234,
 281807248,
 65560,
 -61233,
 281872532,
 65573,
 -1,
 281937967,
 65599,
 282136794,
 281413570,
 -1,
 -61230,
 282069817,
 65582,
 -61229,
 282135282,
 65536,
 -61228,
 282200758,
 65543,
 -61227,
 282266246,
 65561,
 -61226,
 282331720,
 65589,
 -61225,
 282397162,
 65587,
 -61224,
 282462613,
 65566,
 -61223,
 282528042,
 65579,
 -1,
 282593375,
 65541,
 282792163,
 282069626,
 -1,
 -61220,
 282725187,
 65590,
 -61219,
 282790674,
 65610,
 -61218,
 282856140,
 65553,
 -61217,
 282921627,
 65611,
 -61216,
 282987058,
 65550,
 -61215,
 283052319,
 65607,
 -61214,
 283117707,
 65539,
 -1,
 283183103,
 65576,
 283381996,
 282724811,
 -1,
 -61211,
 283314951,
 65605,
 -61210,
 283380348,
 65547,
 -61209,
 283445805,
 65542,
 -61208,
 283511264,
 65552,
 -61207,
 283576680,
 65601,
 -61206,
 283642164,
 65594,
 -61205,
 283707550,
 65583,
 -1,
 283772970,
 65593,
 283971829,
 283314534,
 -1,
 -61202,
 283904814,
 65568,
 -61201,
 283970294,
 65537,
 -61200,
 284035798,
 65588,
 -61199,
 284101249,
 65549,
 -61198,
 284166554,
 65609,
 -61197,
 284231973,
 65574,
 -61196,
 284297369,
 65581,
 -1,
 284362735,
 65563,
 284561662,
 283904066,
 -1,
 -61193,
 284494561,
 65596,
 -61192,
 284560011,
 65571,
 -61191,
 284625470,
 65559,
 -61190,
 284690907,
 65544,
 -61189,
 284756350,
 65557,
 -61188,
 284821807,
 65584,
 -61187,
 284887183,
 65569,
 -1,
 284952588,
 65540,
 285151491,
 284494576,
 -1,
 -61184,
 285084379,
 65612,
 -61183,
 285149716,
 65602,
 -61182,
 285214854,
 65555,
 -1,
 285280228,
 65556,
 285540351,
 285084452,
 -1,
 -61179,
 285411491,
 65613,
 -1,
 285476813,
 65604,
 285736959,
 280050384,
 -1,
 285741324,
 285608688,
 -1,
 -61175,
 285674276,
 65629,
 -61174,
 285739642,
 65628,
 -61173,
 285804902,
 65627,
 -1,
 285870287,
 65626,
 286069007,
 285674106,
 -1,
 -61170,
 286001611,
 65624,
 -1,
 286067046,
 65623,
 286265618,
 286001611,
 -1,
 -61167,
 286198564,
 65621,
 -1,
 286263988,
 65620,
 286462229,
 286197826,
 -1,
 -61164,
 286395172,
 65617,
 -1,
 286460656,
 65616,
 -61162,
 286395117,
 65625,
 -61161,
 286591598,
 65622,
 -61160,
 286656965,
 65619,
 -1,
 286722379,
 65618,
 286982143,
 279985326,
 -1,
 286986530,
 286853186,
 -1,
 287052062,
 286919014,
 -1,
 -61155,
 286984759,
 65689,
 -1,
 287050093,
 65688,
 287248673,
 286984399,
 -1,
 -61152,
 287181566,
 65684,
 -1,
 287247045,
 65683,
 -1,
 287181425,
 65700,
 -1,
 286918990,
 65746,
 287576446,
 270481636,
 -1,
 287641981,
 287511330,
 -1,
 287707468,
 287585797,
 -1,
 287772970,
 287658371,
 -1,
 -61144,
 287723947,
 6426,
 -61143,
 287778461,
 6425,
 -1,
 287837015,
 6427,
 288035116,
 287729461,
 6421,
 -1,
 287980958,
 6410,
 288166191,
 287987592,
 -1,
 -61138,
 288106141,
 6412,
 -1,
 288164695,
 6411,
 288362802,
 288114581,
 -1,
 -61135,
 288302749,
 6417,
 -1,
 288361303,
 6416,
 288559413,
 288308638,
 -1,
 -61132,
 288498738,
 6405,
 -1,
 288557911,
 6415,
 288756024,
 288502166,
 -1,
 -61129,
 288695965,
 6402,
 -1,
 288754519,
 6401,
 288952635,
 288698587,
 -1,
 -61126,
 288892573,
 6409,
 -1,
 288951127,
 6408,
 289149246,
 288891911,
 -1,
 -61123,
 289089181,
 6404,
 -1,
 289147735,
 6403,
 289345857,
 289085411,
 -1,
 -61120,
 289285789,
 6414,
 -1,
 289344343,
 6413,
 289542468,
 289280840,
 -1,
 -61117,
 289482397,
 6407,
 -1,
 289540951,
 6406,
 289739079,
 289476953,
 -1,
 -61114,
 289679005,
 6419,
 -1,
 289737559,
 6418,
 -61112,
 289694759,
 6424,
 -61111,
 289885211,
 6422,
 -61110,
 289945898,
 6420,
 -61109,
 290010039,
 6423,
 -1,
 290072221,
 6428,
 290263393,
 287658371,
 -1,
 290328920,
 290208212,
 -1,
 290394449,
 290274718,
 -1,
 -61104,
 290333746,
 6449,
 -1,
 290392919,
 6452,
 -61102,
 290346912,
 6451,
 -61101,
 290540571,
 6455,
 -61100,
 290605017,
 6453,
 -61099,
 290666794,
 6454,
 -61098,
 290730935,
 6456,
 -61097,
 290795957,
 6448,
 -1,
 290852571,
 6450,
 291049821,
 290270384,
 -1,
 -61094,
 291000750,
 6459,
 -61093,
 291061008,
 6457,
 -61092,
 291125208,
 6464,
 -1,
 291189382,
 6458,
 291438591,
 291003798,
 -1,
 -61089,
 291333941,
 6441,
 -61088,
 291398695,
 6443,
 -1,
 291458075,
 6442,
 291639661,
 290218860,
 -1,
 291705196,
 291570876,
 -1,
 291770726,
 291638103,
 6432,
 -61083,
 291724530,
 6438,
 -1,
 291777294,
 6436,
 291967336,
 291717330,
 6440,
 -1,
 291913938,
 6437,
 292098410,
 291904511,
 6439,
 -1,
 292035583,
 6435,
 -61077,
 292052210,
 6434,
 -1,
 292170510,
 6433,
 -1,
 291636997,
 6400,
 292426107,
 291576151,
 -1,
 292491633,
 292378504,
 -1,
 -61072,
 292447720,
 6472,
 -1,
 292497947,
 6473,
 292688244,
 292442499,
 -1,
 -61069,
 292630674,
 6476,
 -1,
 292692051,
 6477,
 292884855,
 292626878,
 -1,
 -61066,
 292832676,
 6474,
 -1,
 292892767,
 6475,
 -61064,
 292841791,
 6470,
 -61063,
 293028511,
 6471,
 -61062,
 293093217,
 6479,
 -1,
 293150176,
 6478,
 -61060,
 292375445,
 6469,
 -1,
 293282060,
 6468,
 -1,
 287584281,
 13007,
 293540286,
 287528723,
 -1,
 293605819,
 293484037,
 -1,
 293671310,
 293558152,
 -1,
 293736841,
 293618339,
 -1,
 293802376,
 293682577,
 -1,
 -61052,
 293755336,
 42232,
 -61051,
 293813711,
 42236,
 -61050,
 293876017,
 42237,
 -61049,
 293935071,
 42234,
 -1,
 293999304,
 42235,
 -1,
 293748178,
 42233,
 294261132,
 293687683,
 -1,
 -61045,
 294200989,
 42206,
 -1,
 294259543,
 42205,
 -61043,
 294200989,
 42197,
 -1,
 294390615,
 42196,
 294588817,
 293625074,
 42228,
 -61040,
 294528647,
 42230,
 -1,
 294591487,
 42229,
 294785428,
 294545639,
 -1,
 -61037,
 294725277,
 42211,
 -1,
 294783831,
 42212,
 294982039,
 294736259,
 -1,
 -61034,
 294921885,
 42219,
 -1,
 294980439,
 42210,
 295178650,
 294930325,
 -1,
 -61031,
 295118493,
 42194,
 -1,
 295177047,
 42193,
 295375260,
 295125202,
 42227,
 -1,
 295312383,
 42231,
 295506335,
 295320990,
 -1,
 -61026,
 295445554,
 42213,
 -1,
 295504727,
 42208,
 295702946,
 295448982,
 -1,
 -61023,
 295642781,
 42200,
 -1,
 295701335,
 42199,
 295899557,
 295642759,
 -1,
 -61020,
 295839389,
 42216,
 -1,
 295897943,
 42214,
 296096168,
 295838727,
 -1,
 -61017,
 296035997,
 42221,
 -1,
 296094551,
 42198,
 296292778,
 296033279,
 42224,
 -1,
 296246514,
 42225,
 296423853,
 296228835,
 -1,
 -61012,
 296380663,
 42204,
 -1,
 296422231,
 42195,
 296620464,
 296358728,
 -1,
 -61009,
 296560285,
 42203,
 -1,
 296618839,
 42202,
 296817074,
 296553303,
 42222,
 -1,
 296754175,
 42223,
 -61005,
 296773429,
 42220,
 -61004,
 296904409,
 42215,
 -61003,
 296969255,
 42218,
 -61002,
 297023786,
 42207,
 -61001,
 297087927,
 42209,
 -61000,
 297152761,
 42201,
 -60999,
 297216782,
 42226,
 -60998,
 297280002,
 42217,
 -1,
 297341323,
 42192,
 297598975,
 293554866,
 -1,
 -60995,
 297477110,
 42239,
 -1,
 297539140,
 42238,
 -1,
 293495756,
 8374,
 297800282,
 270408703,
 -1,
 297865765,
 297748601,
 -1,
 297931255,
 297809413,
 -1,
 297996747,
 297883528,
 -1,
 298062278,
 297949064,
 -1,
 -60987,
 298002077,
 7246,
 -1,
 298060631,
 7245,
 298258889,
 298013059,
 -1,
 -60984,
 298198685,
 7192,
 -1,
 298257239,
 7191,
 -60982,
 298198685,
 7179,
 -1,
 298388311,
 7178,
 298586575,
 297944981,
 -1,
 -60979,
 298529719,
 7183,
 -60978,
 298591901,
 7184,
 -1,
 298650455,
 7182,
 298848723,
 298532254,
 -1,
 -60975,
 298805045,
 7177,
 -60974,
 298853426,
 7173,
 -1,
 298912599,
 7181,
 299110871,
 298791318,
 -1,
 -60971,
 299054007,
 7169,
 -60970,
 299116189,
 7170,
 -1,
 299174743,
 7168,
 299373019,
 299046883,
 -1,
 -60967,
 299329783,
 7193,
 -60966,
 299374602,
 7247,
 -1,
 299436887,
 7180,
 299635166,
 299323779,
 -1,
 -60963,
 299574941,
 7201,
 -1,
 299633495,
 7200,
 299831777,
 299579620,
 -1,
 -60960,
 299774903,
 7190,
 -1,
 299830103,
 7189,
 300028388,
 299771527,
 -1,
 -60957,
 299971511,
 7198,
 -1,
 300026711,
 7197,
 300224999,
 299967495,
 -1,
 -60954,
 300168119,
 7172,
 -1,
 300223319,
 7171,
 300421610,
 300163518,
 -1,
 -60951,
 300364727,
 7186,
 -1,
 300419927,
 7185,
 300618221,
 300356424,
 -1,
 -60948,
 300557981,
 7175,
 -1,
 300616535,
 7174,
 300814832,
 300552537,
 -1,
 -60945,
 300757943,
 7188,
 -1,
 300813143,
 7187,
 -60943,
 300771125,
 7194,
 -60942,
 300966951,
 7202,
 -60941,
 301031702,
 7199,
 -60940,
 301091867,
 7195,
 -60939,
 301151159,
 7196,
 -60938,
 301215993,
 7176,
 -1,
 301271895,
 7203,
 301470213,
 297867607,
 -1,
 301535739,
 301422472,
 -1,
 -60934,
 301491688,
 7234,
 -1,
 301541915,
 7235,
 301732350,
 301486467,
 -1,
 -60931,
 301674642,
 7238,
 -1,
 301736019,
 7239,
 301928961,
 301670846,
 -1,
 -60928,
 301876644,
 7236,
 -1,
 301936735,
 7237,
 -60926,
 301885759,
 7232,
 -60925,
 302072479,
 7233,
 -60924,
 302137185,
 7241,
 -1,
 302194144,
 7240,
 302387727,
 301405797,
 -1,
 302453256,
 302333342,
 7216,
 -1,
 302409758,
 7220,
 302584330,
 302395798,
 7213,
 -1,
 302517917,
 7221,
 -60917,
 302536584,
 7219,
 -60916,
 302664652,
 7218,
 -60915,
 302729109,
 7217,
 -60914,
 302790884,
 7214,
 -1,
 302855049,
 7215,
 303043095,
 302343049,
 -1,
 303108626,
 302996722,
 7210,
 -1,
 303062258,
 7211,
 303239700,
 303055058,
 7208,
 -1,
 303186130,
 7209,
 -60907,
 303180558,
 7207,
 -60906,
 303307775,
 7212,
 -1,
 303369151,
 7206,
 303567390,
 302992050,
 -1,
 303632924,
 303519624,
 -1,
 303698459,
 303584059,
 7231,
 -1,
 303628442,
 7230,
 -1,
 303631276,
 7227,
 -60899,
 303579316,
 7228,
 -1,
 303830103,
 7229,
 304087039,
 303518083,
 -1,
 304091682,
 303979926,
 -1,
 -60895,
 304047925,
 7204,
 -1,
 304106523,
 7205,
 304349183,
 304032944,
 -1,
 -60892,
 304237720,
 7222,
 -1,
 304300078,
 7223,
 304545791,
 297804754,
 -1,
 304550468,
 304440375,
 -1,
 304615991,
 304484289,
 -1,
 304681521,
 304571813,
 -1,
 304747056,
 304633736,
 -1,
 304812589,
 304688968,
 -1,
 -60884,
 304766978,
 11025,
 -1,
 304814967,
 11024,
 305070079,
 304745770,
 -1,
 -60881,
 304964248,
 11065,
 -1,
 305011520,
 11066,
 -1,
 304683696,
 11064,
 305271350,
 304614412,
 -1,
 305336885,
 305221097,
 -1,
 -60876,
 305289710,
 11083,
 -1,
 305335804,
 11074,
 -1,
 305270268,
 11082,
 -1,
 305224122,
 11070,
 305664578,
 304569571,
 -1,
 305730113,
 305598401,
 -1,
 305795648,
 305685925,
 -1,
 305861182,
 305747919,
 11067,
 305987583,
 305792484,
 -1,
 -60867,
 305881752,
 11068,
 -1,
 305929024,
 11069,
 -60865,
 305816216,
 11060,
 -1,
 306060096,
 11061,
 -1,
 305734595,
 11062,
 -1,
 305683319,
 11063,
 -60861,
 305613603,
 11077,
 -1,
 306320015,
 11013,
 306516568,
 304480256,
 -1,
 306582089,
 306467203,
 -1,
 -60857,
 306535952,
 11778,
 -60856,
 306588666,
 11814,
 -1,
 306644861,
 10181,
 306844238,
 306531276,
 -1,
 306909773,
 306785402,
 -1,
 -60852,
 306865400,
 11012,
 -1,
 306909839,
 11020,
 -1,
 306842955,
 11788,
 307171921,
 306780612,
 -1,
 -60848,
 307125693,
 11816,
 -1,
 307190712,
 11780,
 307368532,
 307105736,
 -1,
 -60845,
 307319987,
 11056,
 -1,
 307369283,
 11058,
 -60843,
 307323485,
 11808,
 -60842,
 307518227,
 11785,
 -60841,
 307574822,
 11804,
 -1,
 307631539,
 9948,
 307888127,
 306448171,
 4054,
 -1,
 307758659,
 4056,
 307958422,
 297756440,
 -1,
 308023929,
 307893481,
 -1,
 308089439,
 307976072,
 66199,
 -60834,
 308041608,
 66200,
 -1,
 308094599,
 66185,
 308286049,
 308034974,
 66191,
 -1,
 308231582,
 66193,
 308417123,
 308230372,
 66190,
 -1,
 308361444,
 66192,
 308548197,
 308359574,
 66187,
 -1,
 308490646,
 66196,
 308679271,
 308485119,
 66177,
 -1,
 308624798,
 66202,
 308810345,
 308613465,
 66178,
 -1,
 308749959,
 66179,
 308941419,
 308742999,
 66176,
 -1,
 308886942,
 66201,
 -60820,
 308898023,
 66184,
 -60819,
 309028535,
 66204,
 -60818,
 309093362,
 66183,
 -60817,
 309157106,
 66194,
 -60816,
 309219715,
 66198,
 -60815,
 309283788,
 66197,
 -60814,
 309349086,
 66188,
 -60813,
 309413781,
 66195,
 -60812,
 309474185,
 66189,
 -60811,
 309539035,
 66186,
 -60810,
 309603086,
 66182,
 -60809,
 309667463,
 66203,
 -60808,
 309732359,
 66180,
 -1,
 309794787,
 66181,
 310050815,
 307960121,
 -1,
 310055573,
 309933573,
 -1,
 310121085,
 310007688,
 67887,
 -1,
 310073224,
 67892,
 310252159,
 310071683,
 67891,
 -1,
 310202755,
 67886,
 310383233,
 310197662,
 67883,
 -1,
 310328734,
 67896,
 310514307,
 310326153,
 67881,
 -1,
 310470424,
 67895,
 310645381,
 310451199,
 67876,
 -1,
 310590878,
 67894,
 310776455,
 310578007,
 67872,
 -1,
 310721950,
 67893,
 -60792,
 310732568,
 67879,
 -60791,
 310862088,
 67877,
 -60790,
 310926578,
 67888,
 -60789,
 310987724,
 67885,
 -60788,
 311053022,
 67890,
 -60787,
 311115986,
 67884,
 -60786,
 311179492,
 67882,
 -60785,
 311243158,
 67880,
 -60784,
 311307022,
 67878,
 -60783,
 311370759,
 67874,
 -60782,
 311435710,
 67889,
 -60781,
 311498723,
 67875,
 -60780,
 311563080,
 67897,
 -1,
 311628121,
 67873,
 -1,
 310008649,
 67903,
 311951359,
 307905263,
 -1,
 -60776,
 311834024,
 11059,
 -1,
 311892402,
 10188,
 312088123,
 239032200,
 -1,
 312153389,
 312019799,
 -1,
 312218620,
 312097736,
 -1,
 312284118,
 312170346,
 -1,
 312349406,
 312229278,
 -1,
 312414904,
 312294814,
 -1,
 312480428,
 312360350,
 -1,
 312545956,
 312413015,
 -1,
 -60766,
 312499442,
 983833,
 -60765,
 312552206,
 983830,
 -1,
 312609623,
 983823,
 312808102,
 312499442,
 983826,
 -1,
 312761586,
 983827,
 312939176,
 312754386,
 983831,
 -1,
 312885458,
 983832,
 313070250,
 312879886,
 983824,
 -1,
 313010958,
 983825,
 313262079,
 313007103,
 983828,
 -1,
 313138175,
 983829,
 313332400,
 312413015,
 -1,
 -60754,
 313285874,
 983701,
 -60753,
 313338638,
 983698,
 -1,
 313396055,
 983691,
 313594546,
 313285874,
 983694,
 -1,
 313548018,
 983695,
 313725620,
 313540818,
 983699,
 -1,
 313671890,
 983700,
 313856694,
 313666318,
 983692,
 -1,
 313797390,
 983693,
 314048511,
 313793535,
 983696,
 -1,
 313924607,
 983697,
 314118853,
 312370968,
 -1,
 314184381,
 314051415,
 -1,
 -60741,
 314137842,
 983679,
 -60740,
 314190606,
 983676,
 -1,
 314248023,
 983669,
 314446527,
 314137842,
 983672,
 -1,
 314399986,
 983673,
 314577601,
 314392786,
 983677,
 -1,
 314523858,
 983678,
 314708675,
 314518286,
 983670,
 -1,
 314649358,
 983671,
 314900479,
 314645503,
 983674,
 -1,
 314776575,
 983675,
 314970834,
 314057735,
 -1,
 315036362,
 314903383,
 -1,
 -60728,
 314989810,
 983657,
 -60727,
 315042574,
 983654,
 -1,
 315099991,
 983647,
 315298508,
 314989810,
 983650,
 -1,
 315251954,
 983651,
 315429582,
 315244754,
 983655,
 -1,
 315375826,
 983656,
 315560656,
 315370254,
 983648,
 -1,
 315501326,
 983649,
 315752447,
 315497471,
 983652,
 -1,
 315628543,
 983653,
 315822806,
 314903383,
 -1,
 -60716,
 315776242,
 983723,
 -60715,
 315829006,
 983720,
 -1,
 315886423,
 983713,
 316084952,
 315776242,
 983716,
 -1,
 316038386,
 983717,
 316216026,
 316031186,
 983721,
 -1,
 316162258,
 983722,
 316347100,
 316156686,
 983714,
 -1,
 316287758,
 983715,
 316538879,
 316283903,
 983718,
 -1,
 316414975,
 983719,
 316609286,
 312299907,
 -1,
 316674797,
 316548743,
 -1,
 316740324,
 316607319,
 -1,
 -60702,
 316693746,
 983855,
 -60701,
 316746510,
 983852,
 -1,
 316803927,
 983845,
 317002470,
 316693746,
 983848,
 -1,
 316955890,
 983849,
 317133544,
 316948690,
 983853,
 -1,
 317079762,
 983854,
 317264618,
 317074190,
 983846,
 -1,
 317205262,
 983847,
 317395692,
 317201407,
 983850,
 -1,
 317332479,
 983851,
 -1,
 317345624,
 983901,
 317592314,
 316625283,
 -1,
 317657842,
 317524823,
 -1,
 -60688,
 317611250,
 983866,
 -60687,
 317664014,
 983863,
 -1,
 317721431,
 983856,
 317919988,
 317611250,
 983859,
 -1,
 317873394,
 983860,
 318051062,
 317866194,
 983864,
 -1,
 317997266,
 983865,
 318182136,
 317991694,
 983857,
 -1,
 318122766,
 983858,
 318373887,
 318118911,
 983861,
 -1,
 318249983,
 983862,
 318444286,
 317524823,
 -1,
 -60676,
 318397682,
 983877,
 -60675,
 318450446,
 983874,
 -1,
 318507863,
 983867,
 318706432,
 318397682,
 983870,
 -1,
 318659826,
 983871,
 318837506,
 318652626,
 983875,
 -1,
 318783698,
 983876,
 318968580,
 318778126,
 983868,
 -1,
 318909198,
 983869,
 319160319,
 318905343,
 983872,
 -1,
 319036415,
 983873,
 319230765,
 316552073,
 -1,
 319296289,
 319173513,
 -1,
 319361813,
 319239049,
 -1,
 319427341,
 319294295,
 -1,
 -60661,
 319380722,
 983800,
 -60660,
 319433486,
 983797,
 -1,
 319490903,
 983790,
 319689487,
 319380722,
 983793,
 -1,
 319642866,
 983794,
 319820561,
 319635666,
 983798,
 -1,
 319766738,
 983799,
 319951635,
 319761166,
 983791,
 -1,
 319892238,
 983792,
 320143359,
 319888383,
 983795,
 -1,
 320019455,
 983796,
 320213785,
 319294295,
 -1,
 -60649,
 320167154,
 983811,
 -60648,
 320219918,
 983808,
 -1,
 320277335,
 983801,
 320475931,
 320167154,
 983804,
 -1,
 320429298,
 983805,
 320607005,
 320422098,
 983809,
 -1,
 320553170,
 983810,
 320738079,
 320547598,
 983802,
 -1,
 320678670,
 983803,
 320929791,
 320674815,
 983806,
 -1,
 320805887,
 983807,
 321000229,
 319228759,
 -1,
 -60637,
 320953586,
 983778,
 -60636,
 321006350,
 983775,
 -1,
 321063767,
 983768,
 321262375,
 320953586,
 983771,
 -1,
 321215730,
 983772,
 321393449,
 321208530,
 983776,
 -1,
 321339602,
 983777,
 321524523,
 321334030,
 983769,
 -1,
 321465102,
 983770,
 321716223,
 321461247,
 983773,
 -1,
 321592319,
 983774,
 321786695,
 319173014,
 -1,
 321852219,
 321738254,
 -1,
 321917747,
 321784663,
 983889,
 -60623,
 321871090,
 983900,
 -60622,
 321923854,
 983897,
 -1,
 321981271,
 983890,
 322179893,
 321871090,
 983893,
 -1,
 322133234,
 983894,
 322310967,
 322126034,
 983898,
 -1,
 322257106,
 983899,
 322442041,
 322251534,
 983891,
 -1,
 322382606,
 983892,
 322633727,
 322378751,
 983895,
 -1,
 322509823,
 983896,
 322704191,
 321784663,
 -1,
 -60611,
 322657522,
 983646,
 -60610,
 322710286,
 983643,
 -1,
 322767703,
 983636,
 322966337,
 322657522,
 983639,
 -1,
 322919666,
 983640,
 323097411,
 322912466,
 983644,
 -1,
 323043538,
 983645,
 323228485,
 323037966,
 983637,
 -1,
 323169038,
 983638,
 323420159,
 323165183,
 983641,
 -1,
 323296255,
 983642,
 323490657,
 321738632,
 -1,
 323556181,
 323442568,
 -1,
 323621709,
 323488599,
 -1,
 -60597,
 323575026,
 983690,
 -60596,
 323627790,
 983687,
 -1,
 323685207,
 983680,
 323883855,
 323575026,
 983683,
 -1,
 323837170,
 983684,
 324014929,
 323829970,
 983688,
 -1,
 323961042,
 983689,
 324146003,
 323955470,
 983681,
 -1,
 324086542,
 983682,
 324337663,
 324082687,
 983685,
 -1,
 324213759,
 983686,
 324408153,
 323488599,
 -1,
 -60585,
 324361458,
 983712,
 -60584,
 324414222,
 983709,
 -1,
 324471639,
 983702,
 324670299,
 324361458,
 983705,
 -1,
 324623602,
 983706,
 324801373,
 324616402,
 983710,
 -1,
 324747474,
 983711,
 324932447,
 324741902,
 983703,
 -1,
 324872974,
 983704,
 325124095,
 324869119,
 983707,
 -1,
 325000191,
 983708,
 325194619,
 323439564,
 -1,
 325260143,
 325143500,
 -1,
 325325671,
 325192535,
 -1,
 -60571,
 325278962,
 983822,
 -60570,
 325331726,
 983819,
 -1,
 325389143,
 983812,
 325587817,
 325278962,
 983815,
 -1,
 325541106,
 983816,
 325718891,
 325533906,
 983820,
 -1,
 325664978,
 983821,
 325849965,
 325659406,
 983813,
 -1,
 325790478,
 983814,
 326041599,
 325786623,
 983817,
 -1,
 325917695,
 983818,
 326112115,
 325192535,
 -1,
 -60559,
 326065394,
 983767,
 -60558,
 326118158,
 983764,
 -1,
 326175575,
 983757,
 326374261,
 326065394,
 983760,
 -1,
 326327538,
 983761,
 326505335,
 326320338,
 983765,
 -1,
 326451410,
 983766,
 326636409,
 326445838,
 983758,
 -1,
 326576910,
 983759,
 326828031,
 326573055,
 983762,
 -1,
 326704127,
 983763,
 326898568,
 325150488,
 -1,
 326964096,
 326830935,
 -1,
 -60546,
 326917362,
 983756,
 -60545,
 326970126,
 983753,
 -1,
 327027543,
 983746,
 327226242,
 326917362,
 983749,
 -1,
 327179506,
 983750,
 327357316,
 327172306,
 983754,
 -1,
 327303378,
 983755,
 327488390,
 327297806,
 983747,
 -1,
 327428878,
 983748,
 327679999,
 327425023,
 983751,
 -1,
 327556095,
 983752,
 327750549,
 326852872,
 -1,
 327816077,
 327682903,
 -1,
 -60533,
 327769330,
 983789,
 -60532,
 327822094,
 983786,
 -1,
 327879511,
 983779,
 328078223,
 327769330,
 983782,
 -1,
 328031474,
 983783,
 328209297,
 328024274,
 983787,
 -1,
 328155346,
 983788,
 328340371,
 328149774,
 983780,
 -1,
 328280846,
 983781,
 328531967,
 328276991,
 983784,
 -1,
 328408063,
 983785,
 328602530,
 327698325,
 -1,
 328668058,
 328534871,
 -1,
 -60520,
 328621298,
 983734,
 -60519,
 328674062,
 983731,
 -1,
 328731479,
 983724,
 328930204,
 328621298,
 983727,
 -1,
 328883442,
 983728,
 329061278,
 328876242,
 983732,
 -1,
 329007314,
 983733,
 329192352,
 329001742,
 983725,
 -1,
 329132814,
 983726,
 329383935,
 329128959,
 983729,
 -1,
 329260031,
 983730,
 329454511,
 328546532,
 -1,
 329520039,
 329386839,
 -1,
 -60507,
 329473266,
 983745,
 -60506,
 329526030,
 983742,
 -1,
 329583447,
 983735,
 329782185,
 329473266,
 983738,
 -1,
 329735410,
 983739,
 329913259,
 329728210,
 983743,
 -1,
 329859282,
 983744,
 330044333,
 329853710,
 983736,
 -1,
 329984782,
 983737,
 330235903,
 329980927,
 983740,
 -1,
 330111999,
 983741,
 330306492,
 329396443,
 -1,
 330372020,
 330238807,
 -1,
 -60494,
 330325234,
 983844,
 -60493,
 330377998,
 983841,
 -1,
 330435415,
 983834,
 330634166,
 330325234,
 983837,
 -1,
 330587378,
 983838,
 330765240,
 330580178,
 983842,
 -1,
 330711250,
 983843,
 330896314,
 330705678,
 983835,
 -1,
 330836750,
 983836,
 331087871,
 330832895,
 983839,
 -1,
 330963967,
 983840,
 331158473,
 330245767,
 -1,
 331224001,
 331090775,
 -1,
 -60481,
 331177202,
 983888,
 -60480,
 331229966,
 983885,
 -1,
 331287383,
 983878,
 331486147,
 331177202,
 983881,
 -1,
 331439346,
 983882,
 331617221,
 331432146,
 983886,
 -1,
 331563218,
 983887,
 331748295,
 331557646,
 983879,
 -1,
 331688718,
 983880,
 331939839,
 331684863,
 983883,
 -1,
 331815935,
 983884,
 332070911,
 331092808,
 -1,
 332075982,
 331942743,
 -1,
 -60468,
 332029170,
 983668,
 -60467,
 332081934,
 983665,
 -1,
 332139351,
 983658,
 332338128,
 332029170,
 983661,
 -1,
 332291314,
 983662,
 332469202,
 332284114,
 983666,
 -1,
 332415186,
 983667,
 332600276,
 332409614,
 983659,
 -1,
 332540686,
 983660,
 332791807,
 332536831,
 983663,
 -1,
 332667903,
 983664,
 332862449,
 312218440,
 -1,
 332927984,
 332809020,
 -1,
 332993501,
 332873118,
 983619,
 333059035,
 332938654,
 983617,
 -1,
 333004190,
 983629,
 -60452,
 333014808,
 983615,
 -1,
 333128711,
 983613,
 333321184,
 332943747,
 983633,
 -60449,
 333271427,
 983632,
 -1,
 333325959,
 983631,
 333517795,
 333263753,
 983624,
 333643775,
 333460361,
 983627,
 -1,
 333525897,
 983626,
 333714405,
 333469576,
 983618,
 -1,
 333666184,
 983616,
 333845479,
 333663180,
 983623,
 -1,
 333794252,
 983628,
 333976553,
 333787542,
 983612,
 -1,
 333927950,
 983635,
 -60438,
 333932312,
 983622,
 -60437,
 334061832,
 983625,
 -60436,
 334120853,
 983620,
 -60435,
 334182628,
 983621,
 -60434,
 334246107,
 983630,
 -60433,
 334308999,
 983634,
 -1,
 334369608,
 983614,
 -1,
 332877113,
 3063,
 334631925,
 332797923,
 -1,
 -60429,
 334572710,
 3046,
 -60428,
 334634229,
 3062,
 -1,
 334696766,
 3059,
 -60426,
 334587784,
 3061,
 -60425,
 334844247,
 3065,
 -60424,
 334905949,
 3024,
 -60423,
 334970944,
 3066,
 -60422,
 335035590,
 3060,
 -60421,
 335099449,
 2998,
 -1,
 335155205,
 3064,
 335413247,
 312158992,
 -1,
 335418533,
 335304966,
 -1,
 335483970,
 335361541,
 -1,
 335549463,
 335426441,
 -1,
 335614995,
 335497043,
 -1,
 335680517,
 335557014,
 -1,
 -60413,
 335636185,
 6692,
 -60412,
 335685277,
 6693,
 -1,
 335743831,
 6691,
 335942664,
 335632264,
 -1,
 -60409,
 335881885,
 6709,
 -1,
 335940439,
 6708,
 336139275,
 335890325,
 -1,
 -60406,
 336078493,
 6717,
 -1,
 336137047,
 6715,
 336335886,
 336073544,
 -1,
 -60403,
 336275101,
 6699,
 -1,
 336333655,
 6697,
 -60401,
 336291637,
 6719,
 -60400,
 336482731,
 6698,
 -60399,
 336547013,
 6704,
 -60398,
 336602781,
 6732,
 -1,
 336667138,
 6716,
 336860181,
 335547223,
 6723,
 -1,
 336796671,
 6739,
 -60394,
 336813620,
 6724,
 -1,
 336933815,
 6730,
 337122349,
 335489089,
 -1,
 337187868,
 337072515,
 -1,
 -60390,
 337138091,
 6727,
 -60389,
 337192605,
 6726,
 -1,
 337251159,
 6728,
 337450016,
 337129878,
 -1,
 -60386,
 337405657,
 6690,
 -60385,
 337454749,
 6689,
 -1,
 337513303,
 6688,
 337712163,
 337401736,
 -1,
 -60382,
 337651357,
 6707,
 -1,
 337709911,
 6706,
 337908774,
 337659797,
 -1,
 -60379,
 337847965,
 6713,
 -1,
 337906519,
 6712,
 338105385,
 337843016,
 -1,
 -60376,
 338044573,
 6696,
 -1,
 338103127,
 6695,
 -60374,
 338061109,
 6720,
 -60373,
 338250949,
 6702,
 -60372,
 338306717,
 6729,
 -1,
 338371074,
 6714,
 338564146,
 337071052,
 -1,
 338629681,
 338496343,
 6721,
 -60368,
 338581408,
 6701,
 -1,
 338640335,
 6705,
 -1,
 338583092,
 6722,
 338891830,
 338509214,
 -1,
 -60364,
 338847541,
 6700,
 -60363,
 338895922,
 6694,
 -1,
 338955095,
 6710,
 339153976,
 338844914,
 6735,
 -1,
 339107058,
 6736,
 339285050,
 339094286,
 6733,
 -1,
 339225358,
 6734,
 -60357,
 339239975,
 6725,
 -60356,
 339362630,
 6738,
 -60355,
 339425578,
 6718,
 -60354,
 339486244,
 6740,
 -60353,
 339549485,
 6737,
 -60352,
 339613706,
 6703,
 -60351,
 339677579,
 6711,
 -1,
 339741527,
 6731,
 339940452,
 335434636,
 -1,
 340005965,
 339882390,
 -1,
 340071498,
 339946182,
 -1,
 340137033,
 340002237,
 -1,
 -60345,
 340068877,
 6777,
 -60344,
 340134347,
 6776,
 -1,
 340199782,
 6775,
 -1,
 340068200,
 6780,
 340464716,
 340003792,
 6824,
 -1,
 340407149,
 6825,
 -1,
 340401945,
 6819,
 340661330,
 339956139,
 -1,
 340726864,
 340613740,
 6826,
 -1,
 340669293,
 6827,
 -60335,
 340681779,
 6818,
 -1,
 340800335,
 6752,
 340989015,
 340605287,
 -1,
 341054549,
 340931074,
 6772,
 -1,
 340984303,
 6744,
 -60330,
 341010286,
 6823,
 -1,
 341135835,
 6779,
 341316697,
 340944267,
 6816,
 -1,
 341271594,
 6817,
 341447772,
 341269202,
 -1,
 -60325,
 341379279,
 6774,
 -1,
 341444674,
 6773,
 341644383,
 341396428,
 -1,
 -60322,
 341582032,
 6822,
 -1,
 341642076,
 6778,
 341840994,
 341583495,
 -1,
 -60319,
 341788558,
 6820,
 -1,
 341839517,
 6828,
 -60317,
 341776843,
 6821,
 -1,
 341971819,
 6829,
 342168698,
 339895177,
 -1,
 342234219,
 342114514,
 6763,
 342299753,
 342166361,
 -1,
 -60312,
 342233619,
 6764,
 -1,
 342297606,
 6771,
 -60310,
 342255384,
 6765,
 -1,
 342442194,
 6768,
 342627439,
 342187250,
 6761,
 342692974,
 342580466,
 6762,
 -1,
 342629375,
 6760,
 -1,
 342629375,
 6759,
 342889587,
 342559575,
 6753,
 -60303,
 342829838,
 6769,
 -60302,
 342891519,
 6767,
 -1,
 342952791,
 6755,
 343151734,
 342841224,
 -1,
 -60299,
 343090902,
 6770,
 -1,
 343150069,
 6756,
 343348344,
 343091982,
 6757,
 -1,
 343288590,
 6758,
 -60295,
 343292274,
 6754,
 -1,
 343415807,
 6766,
 343610504,
 342120716,
 -1,
 343676030,
 343562120,
 -1,
 -60291,
 343631336,
 6802,
 -1,
 343681563,
 6803,
 343872641,
 343626115,
 -1,
 -60288,
 343814290,
 6806,
 -1,
 343875667,
 6807,
 344069252,
 343810494,
 -1,
 -60285,
 344016292,
 6804,
 -1,
 344076383,
 6805,
 -60283,
 344025407,
 6800,
 -60282,
 344212127,
 6801,
 -60281,
 344276833,
 6809,
 -1,
 344333792,
 6808,
 344528022,
 343550325,
 -1,
 344593548,
 344479624,
 -1,
 -60277,
 344548840,
 6786,
 -1,
 344599067,
 6787,
 344790159,
 344543619,
 -1,
 -60274,
 344731794,
 6790,
 -1,
 344793171,
 6791,
 344986770,
 344727998,
 -1,
 -60271,
 344933796,
 6788,
 -1,
 344993887,
 6789,
 -60269,
 344942911,
 6784,
 -60268,
 345129631,
 6785,
 -60267,
 345194337,
 6793,
 -1,
 345251296,
 6792,
 345505791,
 344462857,
 -1,
 345511076,
 345391076,
 -1,
 345576605,
 345454820,
 -1,
 345642140,
 345513241,
 -1,
 -60261,
 345590811,
 6741,
 -1,
 345650103,
 6742,
 -1,
 345574231,
 6748,
 345904288,
 345518985,
 -1,
 -60257,
 345851735,
 6746,
 -1,
 345901972,
 6743,
 -60255,
 345854379,
 6750,
 -60254,
 346040391,
 6747,
 -60253,
 346104480,
 6745,
 -1,
 346165643,
 6749,
 -1,
 345455280,
 6783,
 346428675,
 335373023,
 -1,
 346494181,
 346371589,
 -1,
 346559686,
 346437665,
 -1,
 346625196,
 346504606,
 -1,
 -60246,
 346581054,
 43664,
 -60245,
 346636498,
 43672,
 -1,
 346695103,
 43656,
 346887345,
 346567062,
 -1,
 346952880,
 346826375,
 -1,
 -60241,
 346898642,
 43650,
 -1,
 346958113,
 43652,
 -1,
 346898642,
 43648,
 347215028,
 346838920,
 -1,
 -60237,
 347160786,
 43668,
 -1,
 347220257,
 43670,
 347411639,
 347162517,
 -1,
 -60234,
 347357394,
 43676,
 -1,
 347416865,
 43678,
 347608250,
 347345736,
 -1,
 -60231,
 347554002,
 43658,
 -1,
 347613473,
 43660,
 -60229,
 347564094,
 43684,
 -60228,
 347759366,
 43690,
 -60227,
 347821368,
 43662,
 -60226,
 347885645,
 43686,
 -60225,
 347947218,
 43694,
 -60224,
 348011609,
 43682,
 -60223,
 348075945,
 43688,
 -60222,
 348137761,
 43692,
 -60221,
 348202431,
 43654,
 -60220,
 348267318,
 43680,
 -60219,
 348330436,
 43666,
 -1,
 348394184,
 43674,
 348651519,
 346499137,
 -1,
 348656843,
 348536222,
 -1,
 -60215,
 348612670,
 43665,
 -60214,
 348668114,
 43673,
 -1,
 348726719,
 43657,
 348918992,
 348598678,
 -1,
 348984527,
 348857991,
 -1,
 -60210,
 348930258,
 43651,
 -1,
 348989729,
 43653,
 -1,
 348930258,
 43649,
 349246675,
 348870536,
 -1,
 -60206,
 349192402,
 43669,
 -1,
 349251873,
 43671,
 349443286,
 349194133,
 -1,
 -60203,
 349389010,
 43677,
 -1,
 349448481,
 43679,
 349639897,
 349377352,
 -1,
 -60200,
 349585618,
 43659,
 -1,
 349645089,
 43661,
 -60198,
 349595710,
 43685,
 -60197,
 349790982,
 43691,
 -60196,
 349852984,
 43663,
 -60195,
 349917261,
 43687,
 -60194,
 349978834,
 43695,
 -60193,
 350043225,
 43683,
 -60192,
 350107561,
 43689,
 -60191,
 350169377,
 43693,
 -60190,
 350234047,
 43655,
 -60189,
 350298934,
 43681,
 -60188,
 350362052,
 43667,
 -1,
 350425800,
 43675,
 350622964,
 346448754,
 -1,
 350688492,
 350554967,
 -1,
 -60184,
 350643992,
 43708,
 -60183,
 350707252,
 43707,
 -60182,
 350764446,
 43709,
 -60181,
 350828772,
 43710,
 -1,
 350882647,
 43697,
 351081712,
 350641394,
 43700,
 351147247,
 351017983,
 43699,
 -1,
 351079255,
 43705,
 -1,
 351079255,
 43706,
 351343858,
 351021838,
 43698,
 -1,
 351275863,
 43704,
 -60173,
 351289554,
 43702,
 -1,
 351411199,
 43701,
 351606011,
 350574452,
 -1,
 351671544,
 351548178,
 -1,
 -60169,
 351616414,
 43739,
 -1,
 351677203,
 43743,
 -60167,
 351621595,
 43741,
 -60166,
 351813672,
 43740,
 -1,
 351873316,
 43742,
 352064768,
 351558322,
 -1,
 -60163,
 352016760,
 43713,
 -60162,
 352081263,
 43714,
 -60161,
 352141352,
 43712,
 -1,
 352198167,
 43711,
 352452607,
 352008556,
 -1,
 -60158,
 352331988,
 43703,
 -1,
 352390813,
 43696,
 352649215,
 346371302,
 -1,
 352654608,
 352540552,
 -1,
 352720139,
 352600806,
 -1,
 -60153,
 352651898,
 6516,
 -60152,
 352717325,
 6515,
 -60151,
 352782795,
 6514,
 -60150,
 352848230,
 6513,
 -1,
 352913615,
 6512,
 353113358,
 352670083,
 -1,
 -60147,
 353052317,
 6497,
 -1,
 353110871,
 6483,
 -60145,
 353052317,
 6487,
 -1,
 353241943,
 6486,
 353441043,
 352590847,
 6507,
 -60142,
 353379975,
 6502,
 -1,
 353442815,
 6501,
 353637654,
 353373015,
 6499,
 -60139,
 353590836,
 6508,
 -1,
 353643278,
 6509,
 353834264,
 353590514,
 6503,
 -1,
 353770495,
 6506,
 353965339,
 353781653,
 -1,
 -60134,
 353904285,
 6490,
 -1,
 353962839,
 6489,
 354161949,
 353910994,
 6505,
 -1,
 354107602,
 6504,
 354293024,
 354106782,
 -1,
 -60129,
 354231346,
 6482,
 -1,
 354290519,
 6498,
 354489635,
 354234774,
 -1,
 -60126,
 354428573,
 6496,
 -1,
 354487127,
 6480,
 -60124,
 354445109,
 6485,
 -60123,
 354641625,
 6481,
 -60122,
 354705686,
 6493,
 -60121,
 354767275,
 6484,
 -60120,
 354831084,
 6495,
 -60119,
 354892074,
 6491,
 -60118,
 354956215,
 6488,
 -60117,
 355019534,
 6500,
 -60116,
 355083933,
 6494,
 -1,
 355148290,
 6492,
 355341756,
 312089599,
 -1,
 355407268,
 355293950,
 -1,
 355472705,
 355341128,
 -1,
 355538234,
 355418322,
 -1,
 355603767,
 355483038,
 -1,
 355669302,
 355555208,
 -1,
 -60108,
 355617969,
 119563,
 -60107,
 355671785,
 119582,
 -1,
 355732542,
 119573,
 -1,
 355620429,
 119608,
 356057087,
 355548408,
 -1,
 -60103,
 355937149,
 119634,
 -1,
 355999730,
 119630,
 356193599,
 355481569,
 -1,
 356259134,
 356129791,
 -1,
 -60099,
 356204266,
 119590,
 -1,
 356259821,
 119613,
 -1,
 356212807,
 119631,
 -60096,
 356132619,
 119585,
 -1,
 356458224,
 119558,
 356652367,
 355407843,
 -1,
 356717896,
 356592398,
 -1,
 356783430,
 356661476,
 -1,
 -60091,
 356727776,
 119625,
 -1,
 356789761,
 119612,
 -60089,
 356737568,
 119568,
 -1,
 356917831,
 119636,
 357111116,
 356654079,
 -1,
 -60086,
 357058665,
 119623,
 -60085,
 357114389,
 119567,
 -1,
 357176707,
 119586,
 -60083,
 357064927,
 119584,
 -60082,
 357320095,
 119619,
 -1,
 357371771,
 119624,
 357569880,
 356588543,
 -1,
 357635412,
 357514654,
 -1,
 -60078,
 357577833,
 119603,
 -60077,
 357636231,
 119583,
 -1,
 357701315,
 119600,
 -60075,
 357590779,
 119626,
 -60074,
 357849320,
 119610,
 -60073,
 357907098,
 119618,
 -1,
 357961760,
 119580,
 358159714,
 357518284,
 -1,
 358225249,
 358095871,
 -1,
 358290783,
 358175107,
 -1,
 358356318,
 358230798,
 -1,
 -60067,
 358307398,
 119579,
 -1,
 358357166,
 119596,
 -1,
 358304270,
 119598,
 -60064,
 358233329,
 119578,
 -1,
 358550586,
 119572,
 -1,
 358166614,
 119605,
 358815083,
 358097342,
 -1,
 358880614,
 358768250,
 -1,
 -60059,
 358825706,
 119595,
 -1,
 358875306,
 119559,
 359077225,
 358826194,
 -1,
 -60056,
 359028321,
 119638,
 -1,
 359085942,
 119576,
 -60054,
 359020188,
 119606,
 -1,
 359206208,
 119632,
 359404915,
 358764931,
 -1,
 359470449,
 359356296,
 -1,
 359535984,
 359416018,
 -1,
 -60049,
 359489992,
 119601,
 -1,
 359549463,
 119628,
 -1,
 359484783,
 119593,
 -60046,
 359411247,
 119621,
 -1,
 359735453,
 119627,
 359929209,
 359343111,
 -1,
 359994742,
 359862437,
 119592,
 -1,
 359924087,
 119615,
 -60041,
 359947619,
 119614,
 -60040,
 360074517,
 119602,
 -1,
 360137179,
 119599,
 360322431,
 359876501,
 -1,
 360387965,
 360254295,
 -1,
 -60036,
 360340440,
 119604,
 -1,
 360388013,
 119588,
 -60034,
 360341579,
 119594,
 -1,
 360521411,
 119571,
 360715652,
 360254295,
 -1,
 -60031,
 360665584,
 119564,
 -60030,
 360719686,
 119633,
 -60029,
 360782823,
 119577,
 -1,
 360846372,
 119617,
 361043336,
 360659172,
 -1,
 -60026,
 360984444,
 119560,
 -60025,
 361045183,
 119609,
 -1,
 361107520,
 119616,
 361305485,
 360985481,
 -1,
 361371020,
 361237335,
 -1,
 -60021,
 361325556,
 119597,
 -1,
 361370348,
 119637,
 -1,
 361307559,
 119589,
 361633169,
 361238873,
 -1,
 -60017,
 361581724,
 119566,
 -60016,
 361644590,
 119587,
 -1,
 361697204,
 119561,
 361895316,
 361587751,
 -1,
 -60013,
 361846866,
 119620,
 -1,
 361902131,
 119575,
 362091927,
 361840850,
 -1,
 -60010,
 362039851,
 119565,
 -1,
 362102176,
 119635,
 362288538,
 362033558,
 -1,
 -60007,
 362229317,
 119591,
 -1,
 362290527,
 119562,
 362485149,
 362229037,
 -1,
 -60004,
 362430172,
 119622,
 -1,
 362485455,
 119570,
 362681760,
 362423943,
 -1,
 -60001,
 362627645,
 119574,
 -1,
 362680156,
 119629,
 -59999,
 362637405,
 119569,
 -59998,
 362832308,
 119607,
 -59997,
 362897254,
 119611,
 -1,
 362951019,
 119581,
 363140537,
 355350709,
 -1,
 363206065,
 363078579,
 -1,
 363271597,
 363157384,
 -1,
 363337130,
 363226697,
 -1,
 -59991,
 363282751,
 3194,
 -1,
 363339890,
 3197,
 363593727,
 363276971,
 -1,
 -59988,
 363479359,
 3195,
 -1,
 363536498,
 3198,
 363730352,
 363217586,
 -1,
 -59985,
 363675967,
 3193,
 -1,
 363733106,
 3196,
 -1,
 363686218,
 3192,
 363992499,
 363160503,
 3170,
 -1,
 363934601,
 3171,
 364123574,
 363942796,
 -1,
 -59979,
 364076141,
 3199,
 -1,
 364122387,
 3133,
 364380159,
 364066309,
 -1,
 -59976,
 364272555,
 3160,
 -1,
 364321783,
 3161,
 364576767,
 363085214,
 -1,
 -59973,
 364468104,
 9978,
 -1,
 364520705,
 8376,
 364713489,
 355281678,
 -1,
 364779004,
 364651153,
 -1,
 364844539,
 364721669,
 -1,
 364910057,
 364799768,
 -1,
 364975590,
 364841815,
 11568,
 365041093,
 364910563,
 11575,
 365106628,
 364976099,
 11577,
 -1,
 365045383,
 11578,
 -1,
 365045383,
 11576,
 365303240,
 364996839,
 11619,
 -59961,
 365258983,
 11621,
 -1,
 365307527,
 11594,
 365499851,
 365254536,
 11612,
 -59958,
 365451144,
 11615,
 -1,
 365504135,
 11613,
 365696462,
 365449603,
 11609,
 -59955,
 365646211,
 11610,
 -1,
 365700743,
 11611,
 365893073,
 365638038,
 11581,
 366018559,
 365831815,
 11589,
 -1,
 365897351,
 11583,
 366089684,
 365831175,
 11571,
 366215167,
 366028423,
 11606,
 -1,
 366093959,
 11572,
 366286294,
 366037964,
 11604,
 -1,
 366234572,
 11605,
 366417368,
 366225031,
 11584,
 -1,
 366356103,
 11587,
 366548442,
 366350681,
 11569,
 -1,
 366487175,
 11570,
 -59941,
 366503704,
 11618,
 -59940,
 366633970,
 11617,
 -59939,
 366698760,
 11616,
 -59938,
 366758622,
 11591,
 -59937,
 366823317,
 11602,
 -59936,
 366886302,
 11599,
 -59935,
 366950628,
 11598,
 -59934,
 367014793,
 11597,
 -59933,
 367079643,
 11574,
 -59932,
 367141310,
 11580,
 -59931,
 367203428,
 11614,
 -1,
 367266647,
 11588,
 -59929,
 364928242,
 11603,
 -59928,
 367405838,
 11593,
 -1,
 367468987,
 11579,
 367662581,
 364861320,
 -1,
 367728116,
 367615342,
 -1,
 367793645,
 367669654,
 11582,
 -1,
 367732359,
 11590,
 367924720,
 367731719,
 -1,
 -59921,
 367869342,
 11600,
 -1,
 367928967,
 11607,
 -59919,
 367880572,
 11596,
 -59918,
 368069342,
 11592,
 -59917,
 368131835,
 11601,
 -1,
 368191111,
 11586,
 -1,
 367661357,
 11620,
 368449016,
 367596068,
 -1,
 -59913,
 368390363,
 11573,
 -1,
 368453255,
 11585,
 368705535,
 368380759,
 -1,
 -59910,
 368601065,
 11608,
 -1,
 368649896,
 11595,
 -1,
 364788865,
 11631,
 368907785,
 364712511,
 -1,
 368973317,
 368851544,
 -1,
 369038849,
 368906585,
 -1,
 -59904,
 368989228,
 4048,
 -1,
 369045944,
 983047,
 -59902,
 368984263,
 4050,
 -59901,
 369179714,
 4049,
 -59900,
 369241611,
 4051,
 -1,
 369300965,
 4052,
 369497608,
 368915973,
 -1,
 -59897,
 369447104,
 3948,
 -1,
 369505038,
 3947,
 -1,
 369447857,
 4046,
 369759760,
 368850138,
 -1,
 369825295,
 369714597,
 -1,
 369890830,
 369760730,
 -1,
 -59891,
 369824275,
 11807,
 -1,
 369888262,
 11806,
 -1,
 369839984,
 11803,
 -1,
 369771460,
 11081,
 -1,
 369705103,
 68410,
 370284072,
 364658898,
 -1,
 370349602,
 370233592,
 -1,
 370415137,
 370283918,
 -1,
 370480664,
 370346618,
 -1,
 -59882,
 370412265,
 127552,
 -59881,
 370477674,
 127560,
 -1,
 370542936,
 127557,
 370742811,
 370412212,
 -1,
 -59878,
 370674352,
 127558,
 -1,
 370739262,
 127556,
 370939422,
 370674189,
 -1,
 -59875,
 370872711,
 127555,
 -1,
 370936162,
 127559,
 371195903,
 370870794,
 -1,
 -59872,
 371067677,
 127554,
 -1,
 371132475,
 127553,
 -1,
 370357395,
 127274,
 371458047,
 370296727,
 -1,
 -59868,
 371350247,
 9184,
 -59867,
 371412666,
 11811,
 -59866,
 371476573,
 9180,
 -59865,
 371537246,
 11810,
 -1,
 371595207,
 9182,
 371791411,
 370222727,
 -1,
 371856946,
 371739976,
 -1,
 371922479,
 371798921,
 -1,
 371988014,
 371862960,
 -1,
 -59859,
 371936913,
 9886,
 -1,
 371995961,
 9887,
 -1,
 371924368,
 11057,
 372310015,
 371857379,
 -1,
 -59855,
 372196623,
 8278,
 -1,
 372256002,
 10176,
 -1,
 371810086,
 9928,
 372512311,
 371744853,
 -1,
 -59851,
 372467036,
 9929,
 -59850,
 372528334,
 8526,
 -1,
 372576950,
 9930,
 372774458,
 372467201,
 -1,
 -59847,
 372724109,
 11818,
 -1,
 372769890,
 8282,
 -1,
 372723292,
 8285,
 373037270,
 312041736,
 -1,
 373102745,
 372968279,
 -1,
 373168024,
 373041936,
 -1,
 373233543,
 373118823,
 -1,
 373299060,
 373176090,
 -1,
 373364339,
 373243294,
 -1,
 373429838,
 373302279,
 42507,
 373495371,
 373367815,
 -1,
 373560902,
 373431295,
 42500,
 -59835,
 373505438,
 42501,
 -1,
 373562367,
 42271,
 373757512,
 373506258,
 42460,
 -1,
 373702866,
 42384,
 -59831,
 373710066,
 42421,
 -59830,
 373828366,
 42308,
 -1,
 373885783,
 42348,
 -59828,
 373441149,
 42428,
 -59827,
 374021739,
 42467,
 -1,
 374083147,
 42315,
 374281820,
 373364707,
 -1,
 374347351,
 374227154,
 42450,
 374412886,
 374289634,
 -1,
 -59822,
 374363508,
 42514,
 -59821,
 374421802,
 42538,
 -59820,
 374485429,
 42513,
 -59819,
 374546946,
 42512,
 -1,
 374610372,
 42539,
 -1,
 374358226,
 42374,
 374871641,
 374283263,
 42490,
 -1,
 374807551,
 42261,
 -59814,
 374824178,
 42411,
 -59813,
 374942478,
 42298,
 -1,
 374999895,
 42337,
 375199332,
 374236952,
 -1,
 375264863,
 375144658,
 42464,
 -1,
 375210194,
 42388,
 375395937,
 375200767,
 42506,
 -1,
 375331839,
 42275,
 -59806,
 375348466,
 42425,
 -59805,
 375466766,
 42312,
 -1,
 375524183,
 42352,
 375723628,
 375140571,
 -1,
 375789159,
 375668946,
 42457,
 -1,
 375734482,
 42381,
 375920233,
 375725055,
 42497,
 -1,
 375856127,
 42268,
 -59798,
 375872754,
 42418,
 -59797,
 375991054,
 42305,
 -1,
 376048471,
 42344,
 376247918,
 375668946,
 42463,
 -1,
 376193234,
 42387,
 376378992,
 376183807,
 42505,
 -1,
 376314879,
 42274,
 -59791,
 376331506,
 42424,
 -59790,
 376449806,
 42311,
 -1,
 376507223,
 42351,
 376706699,
 373307620,
 -1,
 376772220,
 376644835,
 -1,
 376837751,
 376717522,
 42438,
 -1,
 376783058,
 42363,
 376968825,
 376773631,
 42478,
 -1,
 376904703,
 42250,
 -59782,
 376921330,
 42400,
 -59781,
 377039630,
 42287,
 -1,
 377097047,
 42326,
 377296516,
 376705369,
 -1,
 377362047,
 377241810,
 42436,
 -1,
 377307346,
 42361,
 377493121,
 377297919,
 42475,
 -1,
 377428991,
 42248,
 -59774,
 377445618,
 42398,
 -59773,
 377563918,
 42285,
 -1,
 377621335,
 42323,
 377820806,
 377241810,
 42462,
 -1,
 377766098,
 42386,
 377951880,
 377756671,
 42504,
 -1,
 377887743,
 42273,
 -59767,
 377904370,
 42423,
 -59766,
 378022670,
 42310,
 -1,
 378080087,
 42350,
 378279587,
 376641507,
 -1,
 378345116,
 378218119,
 -1,
 378410645,
 378283655,
 -1,
 378476176,
 378355922,
 42446,
 -1,
 378421458,
 42370,
 378607250,
 378412031,
 42486,
 -1,
 378543103,
 42257,
 -59757,
 378559730,
 42407,
 -59756,
 378678030,
 42294,
 -1,
 378735447,
 42333,
 378934935,
 378355922,
 42445,
 -1,
 378880210,
 42369,
 379066009,
 378870783,
 42485,
 -1,
 379001855,
 42256,
 -59750,
 379018482,
 42406,
 -59749,
 379136782,
 42293,
 -1,
 379194199,
 42332,
 379393694,
 378290386,
 42449,
 -1,
 379338962,
 42373,
 379524768,
 379329535,
 42489,
 -1,
 379460607,
 42260,
 -59743,
 379477234,
 42410,
 -59742,
 379595534,
 42297,
 -1,
 379652951,
 42336,
 379852470,
 378220950,
 -1,
 379917998,
 379799445,
 -1,
 379983528,
 379853823,
 42476,
 -59737,
 379927966,
 42477,
 -1,
 379984895,
 42249,
 380180138,
 379928786,
 42437,
 -1,
 380125394,
 42362,
 380311212,
 380111703,
 42324,
 -1,
 380255646,
 42325,
 -59731,
 380263666,
 42399,
 -1,
 380381966,
 42286,
 380573360,
 379863250,
 42459,
 -1,
 380518610,
 42383,
 380704434,
 380509183,
 42499,
 -1,
 380640255,
 42270,
 380835508,
 380635991,
 42346,
 -1,
 380779934,
 42347,
 -59723,
 380787954,
 42420,
 -1,
 380906254,
 42307,
 381097673,
 379790343,
 -1,
 381163201,
 381030745,
 -1,
 381228731,
 381108434,
 42439,
 -59718,
 381173970,
 42364,
 -1,
 381238686,
 42440,
 381425342,
 381164543,
 42479,
 -59715,
 381369758,
 42480,
 -1,
 381426687,
 42251,
 -59713,
 381377778,
 42401,
 -59712,
 381561614,
 42288,
 -1,
 381619031,
 42327,
 381818564,
 381099007,
 42502,
 -59709,
 381762974,
 42503,
 -1,
 381819903,
 42272,
 382015174,
 381763794,
 42461,
 -1,
 381960402,
 42385,
 -59705,
 381967602,
 42422,
 -59704,
 382085902,
 42309,
 -1,
 382143319,
 42349,
 382342873,
 381053159,
 -1,
 382408402,
 382281351,
 -1,
 382473933,
 382353618,
 42454,
 -1,
 382419154,
 42378,
 382605007,
 382409727,
 42494,
 -1,
 382540799,
 42265,
 -59696,
 382557426,
 42415,
 -59695,
 382675726,
 42302,
 -1,
 382733143,
 42341,
 382932692,
 382353618,
 42453,
 -1,
 382877906,
 42377,
 383063766,
 382868479,
 42493,
 -1,
 382999551,
 42264,
 -59689,
 383016178,
 42414,
 -59688,
 383134478,
 42301,
 -1,
 383191895,
 42340,
 383391464,
 382297074,
 -1,
 383456990,
 383336658,
 42431,
 383522525,
 383402194,
 42356,
 -1,
 383466910,
 42357,
 -1,
 383466910,
 42432,
 383719138,
 383392767,
 42470,
 383784673,
 383654911,
 42243,
 -1,
 383729054,
 42244,
 -1,
 383729054,
 42471,
 383981284,
 383671538,
 42393,
 -1,
 383925662,
 42394,
 384112358,
 383920910,
 42280,
 -1,
 384056734,
 42281,
 384303103,
 384043863,
 42318,
 -1,
 384187806,
 42319,
 384374520,
 383342472,
 -1,
 384440049,
 384312967,
 -1,
 384505580,
 384385234,
 42444,
 -1,
 384450770,
 42368,
 384636654,
 384441343,
 42484,
 -1,
 384572415,
 42255,
 -59665,
 384589042,
 42405,
 -59664,
 384707342,
 42292,
 -1,
 384764759,
 42331,
 384964339,
 384385234,
 42443,
 -1,
 384909522,
 42367,
 385095413,
 384900095,
 42483,
 -1,
 385031167,
 42254,
 -59658,
 385047794,
 42404,
 -59657,
 385166094,
 42291,
 -1,
 385223511,
 42330,
 385423112,
 384323971,
 -1,
 385488641,
 385361543,
 -1,
 385554172,
 385433810,
 42452,
 -1,
 385499346,
 42376,
 385685246,
 385489919,
 42492,
 -1,
 385620991,
 42263,
 -59649,
 385637618,
 42413,
 -59648,
 385755918,
 42300,
 -1,
 385813335,
 42339,
 386012931,
 385433810,
 42451,
 -1,
 385958098,
 42375,
 386144005,
 385948671,
 42491,
 -1,
 386079743,
 42262,
 -59642,
 386096370,
 42412,
 -59641,
 386214670,
 42299,
 -1,
 386272087,
 42338,
 386471704,
 385356121,
 -1,
 386537233,
 386410119,
 -1,
 386602764,
 386482386,
 42434,
 -1,
 386547922,
 42359,
 386733838,
 386538495,
 42473,
 -1,
 386669567,
 42246,
 -59633,
 386686194,
 42396,
 -59632,
 386804494,
 42283,
 -1,
 386861911,
 42321,
 387061523,
 386482386,
 42435,
 -1,
 387006674,
 42360,
 387192597,
 386997247,
 42474,
 -1,
 387128319,
 42247,
 -59626,
 387144946,
 42397,
 -59625,
 387263246,
 42284,
 -1,
 387320663,
 42322,
 387520293,
 386410119,
 -1,
 387585820,
 387465426,
 42429,
 -59621,
 387530962,
 42355,
 -1,
 387595678,
 42430,
 387782431,
 387521535,
 42468,
 -59618,
 387726750,
 42469,
 -1,
 387783679,
 42242,
 387979041,
 387734770,
 42391,
 -1,
 387923358,
 42392,
 388110115,
 387918606,
 42278,
 -1,
 388054430,
 42279,
 388300799,
 388041559,
 42316,
 -1,
 388185502,
 42317,
 388372270,
 387462025,
 -1,
 388437801,
 388307967,
 42487,
 -59608,
 388382503,
 42508,
 -1,
 388439039,
 42258,
 388634411,
 388382930,
 42447,
 -1,
 388579538,
 42371,
 -59604,
 388586738,
 42408,
 -59603,
 388705038,
 42295,
 -1,
 388762455,
 42334,
 388962102,
 388327192,
 -1,
 389027633,
 388907218,
 42458,
 -1,
 388972754,
 42382,
 389158707,
 388963327,
 42498,
 -1,
 389094399,
 42269,
 -59596,
 389111026,
 42419,
 -59595,
 389229326,
 42306,
 -1,
 389286743,
 42345,
 389486398,
 388915464,
 -1,
 389551929,
 389431506,
 42442,
 -1,
 389497042,
 42366,
 389683003,
 389487615,
 42482,
 -1,
 389618687,
 42253,
 -59588,
 389635314,
 42403,
 -59587,
 389753614,
 42290,
 -1,
 389811031,
 42329,
 390010694,
 389434316,
 -1,
 390076225,
 389955794,
 42448,
 -1,
 390021330,
 42372,
 390207299,
 390011903,
 42488,
 -1,
 390142975,
 42259,
 -59580,
 390159602,
 42409,
 -59579,
 390277902,
 42296,
 -1,
 390335319,
 42335,
 390534990,
 389957525,
 -1,
 390600521,
 390480082,
 42433,
 -1,
 390545618,
 42358,
 390731595,
 390536191,
 42472,
 -1,
 390667263,
 42245,
 -59572,
 390683890,
 42395,
 -59571,
 390802190,
 42282,
 -1,
 390859607,
 42320,
 391059286,
 390475995,
 -1,
 391124817,
 391004370,
 42456,
 -1,
 391069906,
 42380,
 391255891,
 391060479,
 42496,
 -1,
 391191551,
 42267,
 -59564,
 391208178,
 42417,
 -59563,
 391326478,
 42304,
 -1,
 391383895,
 42343,
 391583582,
 390996414,
 -1,
 391649113,
 391528658,
 42441,
 -1,
 391594194,
 42365,
 391780187,
 391584767,
 42481,
 -1,
 391715839,
 42252,
 -59556,
 391732466,
 42402,
 -59555,
 391850766,
 42289,
 -1,
 391908183,
 42328,
 392107878,
 391517000,
 -1,
 392173409,
 392052946,
 42455,
 -1,
 392118482,
 42379,
 392304483,
 392109055,
 42495,
 -1,
 392240127,
 42266,
 -59548,
 392256754,
 42416,
 -59547,
 392375054,
 42303,
 -1,
 392432471,
 42342,
 392632170,
 392052946,
 42426,
 392697705,
 392577234,
 42353,
 -1,
 392641950,
 42354,
 -1,
 392641950,
 42427,
 392894318,
 392567807,
 42465,
 392959853,
 392829951,
 42240,
 -1,
 392904094,
 42241,
 -1,
 392904094,
 42466,
 393156464,
 392846578,
 42389,
 -1,
 393100702,
 42390,
 393287538,
 393095950,
 42276,
 -1,
 393231774,
 42277,
 393478143,
 393218903,
 42313,
 -1,
 393362846,
 42314,
 393609215,
 373242570,
 -1,
 393615225,
 393500552,
 -1,
 -59529,
 393560811,
 42525,
 -59528,
 393620929,
 42517,
 -1,
 393677759,
 42521,
 393877374,
 393549795,
 -1,
 393942909,
 393822418,
 -1,
 -59524,
 393888491,
 42523,
 -1,
 393938803,
 42526,
 -1,
 393875101,
 42522,
 394205057,
 393818518,
 -1,
 -59520,
 394157900,
 42524,
 -1,
 394206554,
 42516,
 394401668,
 394142142,
 -1,
 -59517,
 394337626,
 42515,
 -1,
 394398655,
 42520,
 -59515,
 394346333,
 42518,
 -59514,
 394539366,
 42527,
 -1,
 394596785,
 42519,
 394794901,
 373168471,
 -1,
 394860427,
 394745736,
 -1,
 -59510,
 394814952,
 42530,
 -1,
 394865179,
 42531,
 395057038,
 394809731,
 -1,
 -59507,
 394997906,
 42534,
 -1,
 395059283,
 42535,
 395253649,
 394994110,
 -1,
 -59504,
 395199908,
 42532,
 -1,
 395259999,
 42533,
 -59502,
 395209023,
 42528,
 -59501,
 395395743,
 42529,
 -59500,
 395460449,
 42537,
 -1,
 395517408,
 42536,
 -59498,
 394742677,
 42511,
 -59497,
 395650038,
 42510,
 -1,
 395712068,
 42509,
 395968511,
 373116484,
 -1,
 395974664,
 395839554,
 -1,
 396040101,
 395905828,
 917762,
 -59492,
 395971364,
 917942,
 -59491,
 396036848,
 917941,
 -59490,
 396102324,
 917940,
 -59489,
 396167802,
 917939,
 -59488,
 396233229,
 917938,
 -59487,
 396298699,
 917937,
 -59486,
 396364134,
 917936,
 -59485,
 396429519,
 917935,
 -59484,
 396494914,
 917934,
 -1,
 396560322,
 917933,
 396761008,
 395971312,
 917761,
 -59481,
 396692260,
 917932,
 -59480,
 396757744,
 917931,
 -59479,
 396823220,
 917930,
 -59478,
 396888698,
 917929,
 -59477,
 396954125,
 917928,
 -59476,
 397019595,
 917927,
 -59475,
 397085030,
 917926,
 -59474,
 397150415,
 917925,
 -59473,
 397215810,
 917924,
 -1,
 397281218,
 917923,
 397481915,
 396692148,
 917760,
 -59470,
 397413156,
 917922,
 -59469,
 397478640,
 917921,
 -59468,
 397544116,
 917920,
 -59467,
 397609594,
 917919,
 -59466,
 397675021,
 917918,
 -59465,
 397740491,
 917917,
 -59464,
 397805926,
 917916,
 -59463,
 397871311,
 917915,
 -59462,
 397936706,
 917914,
 -1,
 398002114,
 917913,
 398202822,
 397412986,
 -1,
 -59459,
 398134052,
 917912,
 -59458,
 398199536,
 917911,
 -59457,
 398265012,
 917910,
 -59456,
 398330490,
 917909,
 -59455,
 398395917,
 917908,
 -59454,
 398461387,
 917907,
 -59453,
 398526822,
 917906,
 -59452,
 398592207,
 917905,
 -59451,
 398657602,
 917904,
 -1,
 398723010,
 917903,
 398923729,
 398133773,
 -1,
 -59448,
 398854948,
 917902,
 -59447,
 398920432,
 917901,
 -59446,
 398985908,
 917900,
 -59445,
 399051386,
 917899,
 -59444,
 399116813,
 917898,
 -59443,
 399182283,
 917897,
 -59442,
 399247718,
 917896,
 -59441,
 399313103,
 917895,
 -59440,
 399378498,
 917894,
 -1,
 399443906,
 917893,
 399644636,
 398854603,
 -1,
 -59437,
 399575844,
 917892,
 -59436,
 399641328,
 917891,
 -59435,
 399706804,
 917890,
 -59434,
 399772282,
 917889,
 -59433,
 399837709,
 917888,
 -59432,
 399903179,
 917887,
 -59431,
 399968614,
 917886,
 -59430,
 400033999,
 917885,
 -59429,
 400099394,
 917884,
 -1,
 400164802,
 917883,
 400365543,
 399575398,
 -1,
 -59426,
 400296740,
 917882,
 -59425,
 400362224,
 917881,
 -59424,
 400427700,
 917880,
 -59423,
 400493178,
 917879,
 -59422,
 400558605,
 917878,
 -59421,
 400624075,
 917877,
 -59420,
 400689510,
 917876,
 -59419,
 400754895,
 917875,
 -59418,
 400820290,
 917874,
 -1,
 400885698,
 917873,
 401086450,
 400296143,
 -1,
 -59415,
 401017636,
 917872,
 -59414,
 401083120,
 917871,
 -59413,
 401148596,
 917870,
 -59412,
 401214074,
 917869,
 -59411,
 401279501,
 917868,
 -59410,
 401344971,
 917867,
 -59409,
 401410406,
 917866,
 -59408,
 401475791,
 917865,
 -59407,
 401541186,
 917864,
 -1,
 401606594,
 917863,
 401807357,
 401016898,
 -1,
 -59404,
 401738532,
 917862,
 -59403,
 401804016,
 917861,
 -59402,
 401869492,
 917860,
 -59401,
 401934970,
 917859,
 -59400,
 402000397,
 917858,
 -59399,
 402065867,
 917857,
 -59398,
 402131302,
 917856,
 -59397,
 402196687,
 917855,
 -59396,
 402262082,
 917854,
 -1,
 402327490,
 917853,
 402587647,
 401737666,
 -1,
 -59393,
 402459428,
 917852,
 -59392,
 402524912,
 917851,
 -59391,
 402590388,
 917850,
 -59390,
 402655866,
 917849,
 -59389,
 402721293,
 917848,
 -59388,
 402786763,
 917847,
 -59387,
 402852198,
 917846,
 -59386,
 402917583,
 917845,
 -59385,
 402982978,
 917844,
 -1,
 403048386,
 917843,
 403249228,
 395905231,
 -1,
 403314708,
 403179979,
 917767,
 -59381,
 403245860,
 917992,
 -59380,
 403311344,
 917991,
 -59379,
 403376820,
 917990,
 -59378,
 403442298,
 917989,
 -59377,
 403507725,
 917988,
 -59376,
 403573195,
 917987,
 -59375,
 403638630,
 917986,
 -59374,
 403704015,
 917985,
 -59373,
 403769410,
 917984,
 -1,
 403834818,
 917983,
 404035615,
 403245414,
 917766,
 -59370,
 403966756,
 917982,
 -59369,
 404032240,
 917981,
 -59368,
 404097716,
 917980,
 -59367,
 404163194,
 917979,
 -59366,
 404228621,
 917978,
 -59365,
 404294091,
 917977,
 -59364,
 404359526,
 917976,
 -59363,
 404424911,
 917975,
 -59362,
 404490306,
 917974,
 -1,
 404555714,
 917973,
 404756522,
 403966159,
 917765,
 -59359,
 404687652,
 917972,
 -59358,
 404753136,
 917971,
 -59357,
 404818612,
 917970,
 -59356,
 404884090,
 917969,
 -59355,
 404949517,
 917968,
 -59354,
 405014987,
 917967,
 -59353,
 405080422,
 917966,
 -59352,
 405145807,
 917965,
 -59351,
 405211202,
 917964,
 -1,
 405276610,
 917963,
 405477429,
 404686914,
 917764,
 -59348,
 405408548,
 917962,
 -59347,
 405474032,
 917961,
 -59346,
 405539508,
 917960,
 -59345,
 405604986,
 917959,
 -59344,
 405670413,
 917958,
 -59343,
 405735883,
 917957,
 -59342,
 405801318,
 917956,
 -59341,
 405866703,
 917955,
 -59340,
 405932098,
 917954,
 -1,
 405997506,
 917953,
 406198336,
 405407682,
 917763,
 -59337,
 406129444,
 917952,
 -59336,
 406194928,
 917951,
 -59335,
 406260404,
 917950,
 -59334,
 406325882,
 917949,
 -59333,
 406391309,
 917948,
 -59332,
 406456779,
 917947,
 -59331,
 406522214,
 917946,
 -59330,
 406587599,
 917945,
 -59329,
 406652994,
 917944,
 -1,
 406718402,
 917943,
 406919240,
 406129165,
 917768,
 -59326,
 406850170,
 917999,
 -59325,
 406915597,
 917998,
 -59324,
 406981067,
 917997,
 -59323,
 407046502,
 917996,
 -59322,
 407111887,
 917995,
 -59321,
 407177282,
 917994,
 -1,
 407242690,
 917993,
 -59319,
 406850340,
 917772,
 -59318,
 407374576,
 917771,
 -59317,
 407440052,
 917770,
 -1,
 407505530,
 917769,
 407705687,
 403180324,
 -1,
 -59314,
 407636772,
 917842,
 -59313,
 407702256,
 917841,
 -59312,
 407767732,
 917840,
 -59311,
 407833210,
 917839,
 -59310,
 407898637,
 917838,
 -59309,
 407964107,
 917837,
 -59308,
 408029542,
 917836,
 -59307,
 408094927,
 917835,
 -59306,
 408160322,
 917834,
 -1,
 408225730,
 917833,
 408426594,
 407636720,
 -1,
 -59303,
 408357668,
 917832,
 -59302,
 408423152,
 917831,
 -59301,
 408488628,
 917830,
 -59300,
 408554106,
 917829,
 -59299,
 408619533,
 917828,
 -59298,
 408685003,
 917827,
 -59297,
 408750438,
 917826,
 -59296,
 408815823,
 917825,
 -59295,
 408881218,
 917824,
 -1,
 408946626,
 917823,
 409147501,
 408357556,
 -1,
 -59292,
 409078564,
 917822,
 -59291,
 409144048,
 917821,
 -59290,
 409209524,
 917820,
 -59289,
 409275002,
 917819,
 -59288,
 409340429,
 917818,
 -59287,
 409405899,
 917817,
 -59286,
 409471334,
 917816,
 -59285,
 409536719,
 917815,
 -59284,
 409602114,
 917814,
 -1,
 409667522,
 917813,
 409868408,
 409078394,
 -1,
 -59281,
 409799460,
 917812,
 -59280,
 409864944,
 917811,
 -59279,
 409930420,
 917810,
 -59278,
 409995898,
 917809,
 -59277,
 410061325,
 917808,
 -59276,
 410126795,
 917807,
 -59275,
 410192230,
 917806,
 -59274,
 410257615,
 917805,
 -59273,
 410323010,
 917804,
 -1,
 410388418,
 917803,
 410589315,
 409799181,
 -1,
 -59270,
 410520356,
 917802,
 -59269,
 410585840,
 917801,
 -59268,
 410651316,
 917800,
 -59267,
 410716794,
 917799,
 -59266,
 410782221,
 917798,
 -59265,
 410847691,
 917797,
 -59264,
 410913126,
 917796,
 -59263,
 410978511,
 917795,
 -59262,
 411043906,
 917794,
 -1,
 411109314,
 917793,
 411310222,
 410520011,
 -1,
 -59259,
 411241252,
 917792,
 -59258,
 411306736,
 917791,
 -59257,
 411372212,
 917790,
 -59256,
 411437690,
 917789,
 -59255,
 411503117,
 917788,
 -59254,
 411568587,
 917787,
 -59253,
 411634022,
 917786,
 -59252,
 411699407,
 917785,
 -59251,
 411764802,
 917784,
 -1,
 411830210,
 917783,
 412090367,
 411240806,
 -1,
 -59248,
 411962148,
 917782,
 -59247,
 412027632,
 917781,
 -59246,
 412093108,
 917780,
 -59245,
 412158586,
 917779,
 -59244,
 412224013,
 917778,
 -59243,
 412289483,
 917777,
 -59242,
 412354918,
 917776,
 -59241,
 412420303,
 917775,
 -59240,
 412485698,
 917774,
 -1,
 412551106,
 917773,
 412752080,
 373038079,
 -1,
 412817609,
 412686659,
 -1,
 412883124,
 412767116,
 -1,
 412948644,
 412814167,
 -1,
 413014179,
 412893292,
 -1,
 413079712,
 412967193,
 7403,
 -1,
 413009636,
 7404,
 -59231,
 413031815,
 7409,
 -59230,
 413143442,
 7402,
 -1,
 413208261,
 7401,
 -1,
 412962014,
 7410,
 413472938,
 412902141,
 -1,
 413538471,
 413425197,
 7395,
 -1,
 413468388,
 7399,
 413669545,
 413470418,
 7397,
 -1,
 413599460,
 7400,
 -1,
 413620045,
 7394,
 413866159,
 413420492,
 -1,
 413931694,
 413802725,
 -1,
 -59219,
 413883949,
 7396,
 -1,
 413929170,
 7398,
 -1,
 413882648,
 7408,
 -59216,
 413820748,
 7380,
 -59215,
 414145125,
 7405,
 -59214,
 414203731,
 7379,
 -59213,
 414267327,
 7407,
 -1,
 414328790,
 7406,
 414580735,
 412834467,
 -1,
 414587066,
 414476096,
 -1,
 414652600,
 414528049,
 7383,
 -1,
 414581931,
 7385,
 -59207,
 414592327,
 7382,
 -1,
 414715108,
 7381,
 414914750,
 414537608,
 -1,
 -59204,
 414869023,
 7390,
 -59203,
 414928838,
 7387,
 -1,
 414984791,
 7391,
 415176897,
 414855605,
 -1,
 -59200,
 415127799,
 7388,
 -1,
 415191250,
 7376,
 415373508,
 415111620,
 -1,
 -59197,
 415325662,
 7386,
 -1,
 415389578,
 7389,
 -59195,
 415322871,
 7377,
 -59194,
 415518514,
 7392,
 -59193,
 415582785,
 7378,
 -59192,
 415634323,
 7384,
 -1,
 415699076,
 7393,
 415897807,
 412766448,
 -1,
 -59189,
 415848936,
 11823,
 -59188,
 415906180,
 9896,
 -59187,
 415970994,
 9168,
 -59186,
 416031619,
 8286,
 -1,
 416092612,
 10186,
 -1,
 415848002,
 9910,
 416415743,
 412704362,
 -1,
 416422101,
 416301731,
 -1,
 -59181,
 416372893,
 8530,
 -59180,
 416436853,
 8528,
 -1,
 416497521,
 8529,
 -1,
 416377200,
 8585,
 416750351,
 372979940,
 -1,
 416815522,
 416694482,
 -1,
 416881050,
 416749896,
 -1,
 416946479,
 416829827,
 -1,
 417012009,
 416889242,
 -1,
 417077481,
 416962440,
 7511,
 417143014,
 417030229,
 -1,
 417208544,
 417074007,
 7492,
 -59169,
 417151089,
 7579,
 -1,
 417209343,
 7494,
 417405154,
 417151204,
 7514,
 -1,
 417334945,
 7597,
 -59165,
 417358088,
 7610,
 -59164,
 417481616,
 7500,
 -59163,
 417540878,
 7502,
 -1,
 417605255,
 7587,
 -59161,
 417088383,
 7508,
 -59160,
 417736646,
 7615,
 -1,
 417793712,
 7605,
 417994994,
 417010504,
 7580,
 418060528,
 417926900,
 -1,
 418126061,
 417999630,
 7590,
 -1,
 418055895,
 7591,
 -59154,
 418077938,
 7608,
 -59153,
 418200990,
 7600,
 -1,
 418263945,
 7595,
 -59151,
 417998829,
 7521,
 -1,
 418383351,
 7581,
 418584823,
 417930239,
 7497,
 -59148,
 418539900,
 7614,
 -59147,
 418601200,
 7582,
 -59146,
 418665085,
 7604,
 -1,
 418725627,
 7505,
 418912509,
 418533763,
 -1,
 418978043,
 418845512,
 -1,
 -59142,
 418926548,
 7586,
 -1,
 418982647,
 7498,
 -59140,
 418917360,
 7513,
 -1,
 419104334,
 7603,
 419305729,
 418845017,
 7495,
 -59137,
 419251557,
 7509,
 -59136,
 419307486,
 7517,
 -1,
 419368876,
 7601,
 419567877,
 419260647,
 7611,
 419692543,
 419497444,
 -1,
 -59132,
 419581402,
 7612,
 -1,
 419633090,
 7613,
 419830024,
 419519730,
 7512,
 -59129,
 419777149,
 7607,
 -1,
 419823744,
 7606,
 420026636,
 419774674,
 7506,
 420151295,
 419973273,
 -1,
 -59125,
 420036818,
 7507,
 -1,
 420092927,
 7499,
 420288784,
 419963911,
 7501,
 420413439,
 420236633,
 -1,
 -59121,
 420301103,
 7520,
 -1,
 420357249,
 7518,
 420550931,
 420222947,
 7496,
 -59118,
 420496716,
 7585,
 -1,
 420552258,
 7519,
 420747542,
 420481879,
 7491,
 -59115,
 420690033,
 7493,
 -1,
 420752685,
 7516,
 420944152,
 420700424,
 7515,
 -1,
 420873806,
 7609,
 421075226,
 420890517,
 7510,
 -1,
 421013485,
 7602,
 421206301,
 421019052,
 -1,
 -59108,
 421154266,
 7599,
 -1,
 421213552,
 7598,
 421402911,
 421148900,
 7504,
 -1,
 421332558,
 7596,
 421533986,
 421344151,
 -1,
 -59103,
 421481946,
 7593,
 -1,
 421545972,
 7594,
 421730597,
 421473038,
 -1,
 -59100,
 421676318,
 7589,
 -1,
 421725911,
 7588,
 -59098,
 421678588,
 7583,
 -59097,
 421867926,
 7503,
 -59096,
 421933285,
 7592,
 -1,
 421994942,
 7584,
 422189356,
 416963390,
 -1,
 -59093,
 422131773,
 42785,
 -1,
 422193273,
 42784,
 422445055,
 422127239,
 -1,
 -59090,
 422331587,
 42890,
 -1,
 422387238,
 765,
 422582615,
 416879432,
 -1,
 422648138,
 422514420,
 -1,
 422713653,
 422595532,
 7487,
 422838271,
 422650022,
 -1,
 -59084,
 422722974,
 7483,
 -1,
 422779903,
 7474,
 422975799,
 422658258,
 7484,
 -1,
 422927602,
 7485,
 423106873,
 422908249,
 7470,
 -1,
 423038884,
 7471,
 423237947,
 423037783,
 7468,
 -1,
 423173119,
 7469,
 -59076,
 423191538,
 7490,
 -59075,
 423321864,
 11389,
 -59074,
 423386354,
 7489,
 -59073,
 423450504,
 7488,
 -59072,
 423511957,
 7486,
 -59071,
 423574942,
 7482,
 -59070,
 423639268,
 7481,
 -59069,
 423703433,
 7480,
 -59068,
 423768470,
 7479,
 -59067,
 423833819,
 7478,
 -59066,
 423897870,
 7477,
 -59065,
 423962247,
 7476,
 -59064,
 424027143,
 7475,
 -59063,
 424090623,
 7473,
 -1,
 424155107,
 7472,
 424352085,
 422586544,
 -1,
 424417616,
 424291632,
 -1,
 -59059,
 424366822,
 42754,
 -59058,
 424431892,
 42758,
 -59057,
 424495900,
 42756,
 -1,
 424561015,
 42752,
 424804351,
 424349345,
 -1,
 -59054,
 424694502,
 42755,
 -59053,
 424759572,
 42759,
 -59052,
 424823580,
 42757,
 -1,
 424888695,
 42753,
 -59050,
 424306840,
 7544,
 -1,
 425017938,
 42889,
 425204074,
 422524957,
 -1,
 425269609,
 425132032,
 -1,
 425335133,
 425211193,
 -1,
 425400668,
 425263219,
 767,
 -1,
 425338740,
 753,
 -1,
 425330590,
 42773,
 425597282,
 425269700,
 -1,
 425662817,
 425548722,
 -1,
 -59040,
 425613993,
 42763,
 -1,
 425670021,
 42768,
 -1,
 425616850,
 751,
 425924965,
 425545268,
 -1,
 -59036,
 425869051,
 755,
 -1,
 425928063,
 754,
 -59034,
 425877416,
 752,
 -59033,
 426072552,
 759,
 -59032,
 426127080,
 42783,
 -1,
 426186081,
 42888,
 -1,
 425205586,
 42778,
 426449274,
 425139199,
 -1,
 426514807,
 426403598,
 -1,
 426580338,
 426453057,
 -1,
 426645872,
 426515057,
 -1,
 -59025,
 426597033,
 42760,
 -1,
 426653061,
 42765,
 -59023,
 426587525,
 42770,
 -1,
 426779040,
 983945,
 427032575,
 426522657,
 -1,
 427039094,
 426908273,
 -1,
 -59019,
 426990249,
 42764,
 -1,
 427046277,
 42769,
 -1,
 426980741,
 42774,
 427360255,
 426458683,
 -1,
 -59015,
 427243581,
 764,
 -1,
 427305081,
 762,
 427497861,
 426392461,
 -1,
 427563392,
 427432383,
 -1,
 427628927,
 427498199,
 -1,
 -59010,
 427566603,
 757,
 -1,
 427625544,
 758,
 -1,
 427566603,
 756,
 427950079,
 427491328,
 -1,
 427956612,
 427825777,
 -1,
 -59005,
 427907753,
 42762,
 -1,
 427963781,
 42767,
 -1,
 427898245,
 42772,
 428218763,
 427445334,
 -1,
 -59001,
 428171167,
 42779,
 -59000,
 428224232,
 42782,
 -58999,
 428286220,
 42781,
 -58998,
 428350295,
 42780,
 -1,
 428414485,
 760,
 428611984,
 428156993,
 -1,
 428677519,
 428546673,
 -1,
 -58994,
 428628649,
 42761,
 -1,
 428684677,
 42766,
 -1,
 428619141,
 42771,
 428939668,
 428546522,
 -1,
 -58990,
 428892752,
 42775,
 -58989,
 428954696,
 42776,
 -1,
 429009297,
 42777,
 429201815,
 428872194,
 -1,
 -58986,
 429144125,
 763,
 -1,
 429205625,
 761,
 -58984,
 429154404,
 42864,
 -58983,
 429343673,
 766,
 -1,
 429401387,
 4348,
 429595041,
 416824734,
 -1,
 429660576,
 429539789,
 -1,
 429726111,
 429614872,
 -1,
 -58978,
 429665581,
 9867,
 -1,
 429723293,
 9866,
 -1,
 429661334,
 119552,
 -1,
 429598146,
 6314,
 -1,
 429547392,
 9968,
 430119486,
 416769913,
 -1,
 430184936,
 430060425,
 -1,
 430250468,
 430120974,
 -1,
 430315968,
 430191254,
 -1,
 430381483,
 430249955,
 -1,
 430447018,
 430315491,
 -1,
 -58967,
 430384797,
 43625,
 -1,
 430443351,
 43624,
 -1,
 430384797,
 43626,
 430709166,
 430332847,
 -1,
 -58963,
 430646941,
 43623,
 -1,
 430705495,
 43622,
 430905777,
 430652830,
 -1,
 -58960,
 430860085,
 43621,
 -1,
 430902103,
 43627,
 431102388,
 430846171,
 -1,
 -58957,
 431040157,
 43620,
 -1,
 431098711,
 43619,
 431298999,
 431040135,
 -1,
 -58954,
 431236765,
 43630,
 -1,
 431295319,
 43629,
 431495610,
 431231816,
 -1,
 -58951,
 431433373,
 43618,
 -1,
 431491927,
 43617,
 -58949,
 431450359,
 43634,
 -58948,
 431646425,
 43633,
 -58947,
 431706539,
 43628,
 -58946,
 431770651,
 43635,
 -58945,
 431825970,
 43616,
 -1,
 431890946,
 43631,
 432085459,
 430264707,
 -1,
 432150994,
 432023291,
 -1,
 432216517,
 432094622,
 -1,
 -58940,
 432170805,
 4218,
 -1,
 432212823,
 4220,
 432413128,
 432157078,
 -1,
 -58937,
 432350877,
 4214,
 -1,
 432409431,
 4213,
 -58935,
 432367863,
 4217,
 -58934,
 432560371,
 4224,
 -58933,
 432621867,
 4221,
 -58932,
 432678557,
 4225,
 -58931,
 432743474,
 4215,
 -58930,
 432808450,
 4222,
 -58929,
 432871434,
 4219,
 -58928,
 432935780,
 4216,
 -58927,
 433000843,
 4223,
 -1,
 433064791,
 4130,
 -1,
 432088277,
 4193,
 433330650,
 432028836,
 -1,
 433396183,
 433263099,
 -1,
 -58922,
 433331199,
 4189,
 -1,
 433392471,
 4188,
 -58920,
 433340185,
 4186,
 -58919,
 433533237,
 4187,
 -1,
 433593343,
 4136,
 433789406,
 433265826,
 -1,
 -58916,
 433744047,
 4207,
 -58915,
 433799082,
 4206,
 -1,
 433857939,
 4208,
 434051553,
 433743050,
 -1,
 -58912,
 434002163,
 4197,
 -1,
 434064090,
 4198,
 -58910,
 434000161,
 4238,
 -58909,
 434185764,
 4159,
 -1,
 434244984,
 43642,
 434503679,
 430195082,
 -1,
 -58906,
 434391819,
 43637,
 -58905,
 434454795,
 43636,
 -1,
 434514189,
 43638,
 434706967,
 430133635,
 -1,
 434772481,
 434646192,
 -1,
 434838005,
 434721489,
 -1,
 434903536,
 434789074,
 -1,
 -58899,
 434834042,
 4234,
 -58898,
 434899469,
 4233,
 -58897,
 434964838,
 4232,
 -1,
 435030223,
 4231,
 435290111,
 434837178,
 -1,
 435296756,
 435182290,
 -1,
 -58893,
 435226982,
 4236,
 -1,
 435292367,
 4235,
 -1,
 435232349,
 4237,
 435558907,
 434791645,
 -1,
 -58889,
 435489293,
 4205,
 -58888,
 435554763,
 4204,
 -58887,
 435620198,
 4203,
 -58886,
 435685583,
 4202,
 -1,
 435750978,
 4201,
 435952126,
 435499678,
 -1,
 -58883,
 435882342,
 4251,
 -1,
 435947586,
 4250,
 -58881,
 435900722,
 4239,
 -58880,
 436095041,
 43643,
 -1,
 436146203,
 4154,
 436345359,
 434710272,
 -1,
 436410885,
 436295560,
 -1,
 -58876,
 436364776,
 4242,
 -1,
 436415003,
 4243,
 436607496,
 436359555,
 -1,
 -58873,
 436547730,
 4246,
 -1,
 436609107,
 4247,
 436804107,
 436543934,
 -1,
 -58870,
 436749732,
 4244,
 -1,
 436809823,
 4245,
 -58868,
 436758847,
 4240,
 -58867,
 436945567,
 4241,
 -58866,
 437010273,
 4249,
 -1,
 437067232,
 4248,
 437321727,
 436299828,
 -1,
 437328404,
 437194089,
 -1,
 -58862,
 437279859,
 43641,
 -58861,
 437338783,
 43640,
 -1,
 437395712,
 43639,
 437649407,
 437277393,
 -1,
 -58858,
 437535391,
 4254,
 -1,
 437592320,
 4255,
 437787182,
 434660233,
 -1,
 437852703,
 437735811,
 -1,
 437918238,
 437790459,
 -1,
 437983772,
 437853183,
 4228,
 -1,
 437911557,
 4229,
 -58851,
 437920435,
 4230,
 -1,
 438045631,
 4227,
 -1,
 437855432,
 4194,
 438311459,
 437793364,
 -1,
 -58847,
 438263026,
 4211,
 -58846,
 438321516,
 4210,
 -1,
 438377773,
 4212,
 438573606,
 438265034,
 -1,
 -58843,
 438525492,
 4200,
 -1,
 438575146,
 4199,
 438770217,
 438516900,
 -1,
 -58840,
 438714578,
 4148,
 -1,
 438774978,
 4147,
 438966827,
 438701424,
 4252,
 -1,
 438905614,
 4253,
 -58836,
 438917154,
 4139,
 -58835,
 439035145,
 4209,
 -1,
 439098372,
 4149,
 439294522,
 437720677,
 -1,
 439360057,
 439236836,
 -1,
 439425589,
 439295257,
 -1,
 -58830,
 439379765,
 4155,
 -58829,
 439444519,
 4157,
 -58828,
 439503899,
 4156,
 -1,
 439559837,
 4158,
 439812095,
 439370378,
 -1,
 -58825,
 439696847,
 4190,
 -58824,
 439761194,
 4191,
 -1,
 439825335,
 4192,
 -1,
 439309015,
 4226,
 440080957,
 439245500,
 -1,
 -58820,
 440021603,
 4196,
 -1,
 440084322,
 4195,
 -1,
 440024156,
 43632,
 440343220,
 430050135,
 -1,
 440408710,
 440281338,
 -1,
 440474190,
 440357251,
 -1,
 440539718,
 440414370,
 -1,
 440605253,
 440472392,
 -1,
 -58812,
 440545141,
 127006,
 -1,
 440608580,
 126988,
 -1,
 440537509,
 126997,
 440867403,
 440475753,
 -1,
 440932938,
 440800072,
 -1,
 -58807,
 440872821,
 127007,
 -1,
 440936260,
 126989,
 -1,
 440865189,
 126998,
 -58804,
 440819411,
 127015,
 -58803,
 441141847,
 127014,
 -1,
 441206269,
 126977,
 441391705,
 440424328,
 -1,
 441457236,
 441345617,
 -1,
 441522771,
 441389896,
 -1,
 -58798,
 441462645,
 127002,
 -1,
 441526084,
 126984,
 -1,
 441455013,
 126993,
 441843711,
 441395893,
 -1,
 441850456,
 441717576,
 -1,
 -58793,
 441790325,
 127003,
 -1,
 441853764,
 126985,
 -1,
 441782693,
 126994,
 442112612,
 441328062,
 -1,
 442178143,
 442058182,
 -1,
 442243678,
 442110792,
 -1,
 -58787,
 442183541,
 127004,
 -1,
 442246980,
 126986,
 -1,
 442175909,
 126995,
 442564607,
 442118282,
 -1,
 442571363,
 442438472,
 -1,
 -58782,
 442511221,
 127005,
 -1,
 442574660,
 126987,
 -1,
 442503589,
 126996,
 442833515,
 442056914,
 -1,
 442899050,
 442777236,
 -1,
 442964585,
 442831688,
 -1,
 -58776,
 442904437,
 127001,
 -1,
 442967876,
 126983,
 -1,
 442896805,
 126992,
 -1,
 442846424,
 127011,
 443292274,
 442776990,
 -1,
 443357809,
 443231651,
 -1,
 443423344,
 443290440,
 -1,
 -58769,
 443363189,
 127009,
 -1,
 443426628,
 126991,
 -1,
 443355557,
 127000,
 -1,
 443303123,
 126979,
 443751033,
 443227135,
 -1,
 443816568,
 443690112,
 -1,
 443882103,
 443749192,
 -1,
 -58762,
 443821941,
 127008,
 -1,
 443885380,
 126990,
 -1,
 443814309,
 126999,
 -1,
 443748423,
 126976,
 444209789,
 443704306,
 -1,
 -58757,
 444149374,
 127017,
 -58756,
 444213464,
 126982,
 -1,
 444276690,
 126978,
 444471936,
 444141963,
 -1,
 -58753,
 444414706,
 127012,
 -1,
 444470693,
 127019,
 -58751,
 444419374,
 126980,
 -58750,
 444615075,
 127010,
 -58749,
 444674400,
 127018,
 -58748,
 444737092,
 126981,
 -58747,
 444798139,
 127013,
 -1,
 444862732,
 127016,
 445061796,
 440349577,
 -1,
 445127327,
 444993862,
 -1,
 445192847,
 445068813,
 -1,
 445258379,
 445136286,
 3451,
 -1,
 445201822,
 3450,
 445389453,
 445199241,
 3453,
 -1,
 445330313,
 3454,
 -58738,
 445337789,
 3452,
 -1,
 445460886,
 3455,
 445651603,
 445146019,
 -1,
 445717138,
 445592457,
 3426,
 -1,
 445657993,
 3427,
 -1,
 445665469,
 3396,
 445913752,
 445595704,
 -1,
 445979287,
 445858467,
 -1,
 -58730,
 445929852,
 3442,
 -1,
 445983439,
 3441,
 -1,
 445929590,
 3440,
 446241437,
 445850537,
 -1,
 446306972,
 446186147,
 -1,
 -58725,
 446253921,
 3443,
 -1,
 446310077,
 3444,
 -1,
 446257558,
 3445,
 -58722,
 446190482,
 3389,
 -1,
 446503002,
 3449,
 446758911,
 445062145,
 -1,
 446765731,
 446653883,
 -1,
 -58718,
 446714759,
 9894,
 -1,
 446762606,
 9895,
 -1,
 446697054,
 9893,
 447027890,
 445012268,
 -1,
 447093416,
 446975639,
 -1,
 -58713,
 447047022,
 10221,
 -1,
 447095555,
 10223,
 447290027,
 447034686,
 -1,
 -58710,
 447243630,
 10220,
 -1,
 447292163,
 10222,
 447486638,
 447229950,
 -1,
 -58707,
 447426779,
 120485,
 -1,
 447490830,
 120484,
 447683249,
 447419092,
 -1,
 -58704,
 447632576,
 120779,
 -1,
 447681488,
 120778,
 -1,
 447631875,
 120001,
 -58701,
 446976196,
 9901,
 -1,
 447891382,
 9967,
 448076558,
 440278015,
 -1,
 448142077,
 448012258,
 -1,
 448207588,
 448082825,
 -1,
 448273123,
 448143374,
 -1,
 448338621,
 448216478,
 -1,
 448404155,
 448275945,
 43977,
 -1,
 448332297,
 44001,
 448593919,
 448334679,
 43973,
 -1,
 448463369,
 43999,
 448666305,
 448288648,
 -1,
 448731840,
 448605395,
 43975,
 -1,
 448659977,
 44000,
 -1,
 448670185,
 43978,
 448928453,
 448612245,
 -1,
 448993988,
 448858967,
 43972,
 -1,
 448922121,
 43998,
 -1,
 448931538,
 43984,
 449190601,
 448868758,
 -1,
 449256136,
 449135086,
 43968,
 -1,
 449184265,
 43995,
 -1,
 449194473,
 43976,
 449452747,
 449133598,
 43971,
 -1,
 449380873,
 43997,
 449583821,
 449393713,
 43970,
 -1,
 449511945,
 43996,
 449714896,
 449523931,
 -1,
 -58673,
 449653971,
 43990,
 -1,
 449717970,
 43987,
 449911506,
 449653518,
 43983,
 -1,
 449839625,
 44002,
 450042581,
 449848327,
 -1,
 -58668,
 449987054,
 43986,
 -1,
 450046441,
 43992,
 450239192,
 449976291,
 -1,
 -58665,
 450178259,
 43991,
 -1,
 450243049,
 43993,
 450435803,
 450171225,
 -1,
 -58662,
 450373330,
 43994,
 -1,
 450431831,
 43989,
 -58660,
 450389876,
 43980,
 -58659,
 450585647,
 43979,
 -58658,
 450649821,
 43982,
 -58657,
 450712027,
 43969,
 -58656,
 450776135,
 43988,
 -58655,
 450833099,
 43981,
 -58654,
 450892958,
 43974,
 -1,
 450957530,
 43985,
 -1,
 448224929,
 44012,
 451222258,
 448141655,
 -1,
 451287784,
 451172232,
 -1,
 -58649,
 451241448,
 44018,
 -1,
 451291675,
 44019,
 451484395,
 451236227,
 -1,
 -58646,
 451424402,
 44022,
 -1,
 451485779,
 44023,
 451681006,
 451420606,
 -1,
 -58643,
 451626404,
 44020,
 -1,
 451686495,
 44021,
 -58641,
 451635519,
 44016,
 -58640,
 451822239,
 44017,
 -58639,
 451886945,
 44025,
 -1,
 451943904,
 44024,
 452139771,
 451175305,
 -1,
 -58636,
 452093898,
 44006,
 -58635,
 452157152,
 44008,
 -58634,
 452220280,
 44007,
 -58633,
 452280986,
 44003,
 -58632,
 452345959,
 44010,
 -58631,
 452406594,
 44004,
 -58630,
 452465802,
 44009,
 -1,
 452529746,
 44005,
 -58628,
 452072577,
 44011,
 -1,
 452661003,
 44013,
 452860682,
 448093017,
 -1,
 452926212,
 452810632,
 -1,
 452991746,
 452879960,
 -1,
 -58623,
 452937432,
 9173,
 -1,
 452997465,
 9174,
 -58621,
 452939739,
 9175,
 -1,
 453124088,
 9176,
 453319431,
 452868045,
 -1,
 -58618,
 453270733,
 9172,
 -1,
 453333825,
 9170,
 -58616,
 453268310,
 9171,
 -58615,
 453462221,
 9177,
 -1,
 453513977,
 9169,
 453771263,
 452794796,
 -1,
 -58612,
 453666052,
 9898,
 -58611,
 453727507,
 9900,
 -1,
 453776027,
 9899,
 -1,
 448028807,
 119081,
 454040849,
 416698755,
 -1,
 454106060,
 453970775,
 -1,
 454171517,
 454058021,
 -1,
 454237012,
 454112773,
 -1,
 454302490,
 454189320,
 -1,
 454368025,
 454246694,
 -1,
 454433559,
 454314956,
 43144,
 -1,
 454380492,
 43145,
 454623231,
 454374281,
 43146,
 -1,
 454505353,
 43147,
 -1,
 454298455,
 43182,
 454761248,
 454252424,
 -1,
 454826782,
 454711176,
 -1,
 -58595,
 454764189,
 43165,
 -1,
 454822743,
 43164,
 -58593,
 454764189,
 43170,
 -1,
 454953815,
 43169,
 455154469,
 454704542,
 -1,
 -58590,
 455108405,
 43163,
 -58589,
 455163343,
 43168,
 -58588,
 455222322,
 43158,
 -1,
 455281495,
 43173,
 455482155,
 455088099,
 -1,
 455547689,
 455415779,
 -1,
 -58584,
 455485085,
 43167,
 -1,
 455543639,
 43166,
 -58582,
 455485085,
 43172,
 -1,
 455674711,
 43171,
 455875375,
 455412567,
 43138,
 -58579,
 455826674,
 43153,
 -58578,
 455879438,
 43150,
 -1,
 455936855,
 43139,
 456137523,
 455823747,
 -1,
 -58575,
 456085931,
 43184,
 -58574,
 456140445,
 43183,
 -1,
 456198999,
 43185,
 456399669,
 456088818,
 43142,
 -1,
 456350962,
 43143,
 456530744,
 456345493,
 -1,
 -58569,
 456468125,
 43175,
 -1,
 456526679,
 43174,
 456727354,
 456474834,
 43151,
 -1,
 456671442,
 43152,
 456858429,
 456668041,
 -1,
 -58564,
 456799159,
 43187,
 -1,
 456854359,
 43181,
 457055040,
 456798614,
 -1,
 -58561,
 456992413,
 43155,
 -1,
 457050967,
 43154,
 457251651,
 456995035,
 -1,
 -58558,
 457189021,
 43162,
 -1,
 457247575,
 43161,
 457448261,
 457190158,
 43140,
 -1,
 457386766,
 43141,
 457579336,
 457384967,
 -1,
 -58553,
 457516701,
 43157,
 -1,
 457575255,
 43156,
 457775946,
 457513983,
 43148,
 -1,
 457710591,
 43149,
 457907021,
 457708360,
 -1,
 -58548,
 457844381,
 43160,
 -1,
 457902935,
 43159,
 458103632,
 457838937,
 -1,
 -58545,
 458040989,
 43177,
 -1,
 458099543,
 43176,
 -58543,
 458057525,
 43179,
 -58542,
 458247195,
 43180,
 -58541,
 458307882,
 43178,
 -1,
 458368669,
 43186,
 458562406,
 454189961,
 -1,
 458627930,
 458515232,
 -1,
 458693464,
 458574796,
 43194,
 -1,
 458640332,
 43195,
 458883071,
 458634121,
 43196,
 -1,
 458765193,
 43197,
 458955614,
 458558295,
 -1,
 -58532,
 458906866,
 43203,
 -58531,
 458959630,
 43200,
 -1,
 459017047,
 43189,
 459217760,
 458906866,
 43192,
 -1,
 459169010,
 43193,
 459348834,
 459161810,
 43201,
 -1,
 459292882,
 43202,
 459479908,
 459287310,
 43190,
 -1,
 459418382,
 43191,
 459669503,
 459414527,
 43198,
 -1,
 459545599,
 43199,
 459742071,
 458495971,
 -1,
 459807605,
 459680928,
 -1,
 459873131,
 459757448,
 -1,
 -58518,
 459826664,
 43218,
 -1,
 459876891,
 43219,
 460069742,
 459821443,
 -1,
 -58515,
 460009618,
 43222,
 -1,
 460070995,
 43223,
 460266353,
 460005822,
 -1,
 -58512,
 460211620,
 43220,
 -1,
 460271711,
 43221,
 -58510,
 460220735,
 43216,
 -58509,
 460407455,
 43217,
 -58508,
 460472161,
 43225,
 -1,
 460529120,
 43224,
 -58506,
 459752833,
 43215,
 -1,
 460656263,
 43214,
 460856188,
 459690892,
 -1,
 460921723,
 460808906,
 -1,
 -58502,
 460870116,
 43137,
 -1,
 460934291,
 43204,
 -1,
 460852955,
 43136,
 -1,
 460789387,
 43188,
 461249483,
 454113866,
 -1,
 461314969,
 461190661,
 -1,
 461380483,
 461264776,
 -1,
 -58495,
 461328819,
 2065,
 -58494,
 461385700,
 2056,
 -1,
 461441986,
 2069,
 461642631,
 461318926,
 -1,
 -58491,
 461596440,
 2052,
 -58490,
 461657992,
 2055,
 -1,
 461716894,
 2063,
 461904778,
 461590915,
 -1,
 -58487,
 461843919,
 2062,
 -1,
 461907703,
 2068,
 462101389,
 461836633,
 -1,
 -58484,
 462041060,
 2049,
 -1,
 462097343,
 2053,
 -58482,
 462055717,
 2054,
 -58481,
 462252203,
 2057,
 -58480,
 462311394,
 2067,
 -58479,
 462375843,
 2066,
 -58478,
 462438499,
 2061,
 -58477,
 462502872,
 2060,
 -58476,
 462566348,
 2059,
 -58475,
 462631374,
 2058,
 -58474,
 462693494,
 2050,
 -58473,
 462758529,
 2064,
 -58472,
 462821425,
 2051,
 -1,
 462884250,
 2048,
 463084459,
 461267849,
 -1,
 463149984,
 463026105,
 -1,
 463215517,
 463080279,
 2082,
 -1,
 463145815,
 2079,
 -58466,
 463166706,
 2086,
 -58465,
 463285006,
 2089,
 -1,
 463346687,
 2076,
 463543203,
 463093970,
 2091,
 463667199,
 463495721,
 2081,
 -1,
 463539031,
 2078,
 463739814,
 463491459,
 -1,
 -58459,
 463691349,
 2092,
 -1,
 463743448,
 2085,
 463936424,
 463670103,
 2083,
 -1,
 463866711,
 2080,
 -58455,
 463887602,
 2087,
 -58454,
 464005902,
 2090,
 -1,
 464067583,
 2077,
 464264126,
 463030962,
 -1,
 464329651,
 464194391,
 -1,
 464395184,
 464272798,
 -1,
 -58449,
 464338392,
 2110,
 -1,
 464397590,
 2098,
 -58447,
 464345714,
 2100,
 -58446,
 464539671,
 2108,
 -1,
 464593868,
 2097,
 464788406,
 464283879,
 -1,
 -58443,
 464727884,
 2104,
 -1,
 464784524,
 2106,
 464985017,
 464736643,
 -1,
 -58440,
 464929145,
 2109,
 -1,
 464988400,
 2101,
 -58438,
 464936030,
 2107,
 -58437,
 465128197,
 2105,
 -58436,
 465190612,
 2096,
 -58435,
 465255248,
 2103,
 -1,
 465310199,
 2099,
 465509322,
 464206052,
 -1,
 465574854,
 465440630,
 -1,
 465640386,
 465513773,
 2070,
 -1,
 465569535,
 2071,
 -58429,
 465584430,
 2072,
 -58428,
 465714900,
 2093,
 -58427,
 465772317,
 2075,
 -1,
 465836064,
 2073,
 466092031,
 465518940,
 -1,
 -58424,
 465982286,
 2084,
 -58423,
 466037518,
 2088,
 -1,
 466099997,
 2074,
 -1,
 465439714,
 2102,
 -1,
 461188310,
 9973,
 466426916,
 454052692,
 -1,
 466492429,
 466360293,
 -1,
 466557948,
 466425230,
 -1,
 466623455,
 466487821,
 -1,
 466688979,
 466553636,
 -1,
 -58414,
 466618716,
 127511,
 -1,
 466684105,
 127509,
 466885590,
 466618726,
 -1,
 -58411,
 466821627,
 127534,
 -1,
 466883607,
 127506,
 467082201,
 466815183,
 -1,
 -58408,
 467012103,
 127516,
 -1,
 467077324,
 127520,
 -58406,
 467018238,
 127517,
 -58405,
 467212414,
 127532,
 -58404,
 467276160,
 127505,
 -58403,
 467340064,
 127524,
 -58402,
 467405312,
 127525,
 -1,
 467470533,
 127518,
 467672044,
 466553466,
 -1,
 467737572,
 467601615,
 -1,
 -58398,
 467667789,
 127527,
 -58397,
 467733092,
 127537,
 -1,
 467798532,
 127504,
 467999719,
 467667469,
 -1,
 -58394,
 467931493,
 127519,
 -1,
 467995472,
 127515,
 468196330,
 467929446,
 -1,
 -58391,
 468126311,
 127528,
 -1,
 468191288,
 127535,
 -58389,
 468132343,
 127526,
 -1,
 468322988,
 127513,
 468524019,
 467601930,
 -1,
 468589552,
 468453314,
 -1,
 -58385,
 468519716,
 127530,
 -1,
 468584386,
 127529,
 -58383,
 468519868,
 127512,
 -58382,
 468716317,
 127508,
 -1,
 468781407,
 127533,
 468982775,
 468454128,
 -1,
 -58379,
 468916230,
 127536,
 -58378,
 468980583,
 127523,
 -1,
 469044051,
 127510,
 469244923,
 468912820,
 -1,
 -58375,
 469178370,
 127521,
 -58374,
 469240416,
 127522,
 -1,
 469305527,
 127514,
 -1,
 469175112,
 127531,
 469572610,
 466498685,
 -1,
 -58370,
 469525490,
 127302,
 -58369,
 469586307,
 127298,
 -58368,
 469649301,
 127295,
 -58367,
 469712286,
 127293,
 -1,
 469766489,
 127281,
 469965830,
 469520771,
 -1,
 -58364,
 469913987,
 127309,
 -58363,
 469964771,
 127308,
 -1,
 470027814,
 9949,
 470227977,
 469905814,
 -1,
 -58360,
 470163899,
 9919,
 -1,
 470224988,
 127507,
 -58358,
 470174269,
 127310,
 -58357,
 470367620,
 127307,
 -58356,
 470428401,
 127306,
 -1,
 470492014,
 11820,
 470745087,
 466419712,
 -1,
 470752275,
 470640037,
 -1,
 -58352,
 470704098,
 11028,
 -58351,
 470768344,
 11026,
 -58350,
 470825030,
 11029,
 -1,
 470880986,
 11027,
 471079961,
 470685667,
 -1,
 471145496,
 471021796,
 13175,
 471269375,
 471072768,
 -1,
 -58345,
 471160286,
 13176,
 -1,
 471209908,
 13177,
 -1,
 471085275,
 127376,
 471473180,
 471017095,
 -1,
 -58341,
 471412564,
 127488,
 -1,
 471475207,
 13004,
 471669791,
 471407615,
 -1,
 -58338,
 471621896,
 13006,
 -1,
 471682572,
 13005,
 -58336,
 471621898,
 13278,
 -58335,
 471806044,
 13178,
 -58334,
 471868524,
 13311,
 -58333,
 471933793,
 9974,
 -1,
 471993187,
 13279,
 472194159,
 466377970,
 -1,
 472259694,
 472137118,
 -1,
 472325229,
 472193098,
 -1,
 472390731,
 472266245,
 -1,
 472456236,
 472333726,
 -1,
 -58326,
 472409909,
 7057,
 -58325,
 472458290,
 7053,
 -1,
 472517463,
 7060,
 472718383,
 472404355,
 -1,
 -58322,
 472672053,
 7087,
 -1,
 472714071,
 7070,
 472914994,
 472658326,
 -1,
 -58319,
 472852125,
 7086,
 -1,
 472910679,
 7050,
 473111604,
 472849407,
 7048,
 -1,
 473062642,
 7049,
 473242678,
 473041751,
 7043,
 -1,
 473177087,
 7046,
 -58313,
 473196791,
 7056,
 -58312,
 473327413,
 7066,
 -58311,
 473392857,
 7071,
 -58310,
 473457703,
 7069,
 -58309,
 473522454,
 7063,
 -58308,
 473586930,
 7045,
 -58307,
 473651104,
 7058,
 -58306,
 473713691,
 7067,
 -58305,
 473778924,
 7051,
 -58304,
 473843673,
 7061,
 -58303,
 473907410,
 7047,
 -58302,
 473970986,
 7065,
 -58301,
 474035127,
 7068,
 -58300,
 474099961,
 7055,
 -58299,
 474163982,
 7044,
 -58298,
 474228381,
 7072,
 -58297,
 474293298,
 7052,
 -58296,
 474358274,
 7062,
 -58295,
 474421258,
 7059,
 -58294,
 474485604,
 7054,
 -1,
 474550667,
 7064,
 474750041,
 472324439,
 -1,
 474815567,
 474699656,
 -1,
 -58290,
 474768872,
 7090,
 -1,
 474819099,
 7091,
 475012178,
 474763651,
 -1,
 -58287,
 474951826,
 7094,
 -1,
 475013203,
 7095,
 475208789,
 474948030,
 -1,
 -58284,
 475153828,
 7092,
 -1,
 475213919,
 7093,
 -58282,
 475162943,
 7088,
 -58281,
 475349663,
 7089,
 -58280,
 475414369,
 7097,
 -1,
 475471328,
 7096,
 475667553,
 474702741,
 -1,
 475733088,
 475610526,
 -1,
 -58276,
 475687078,
 7077,
 -58275,
 475742807,
 7079,
 -58274,
 475800973,
 7076,
 -58273,
 475865137,
 7081,
 -1,
 475925648,
 7078,
 -1,
 475675499,
 7080,
 476191848,
 475616169,
 -1,
 476257383,
 476134814,
 -1,
 476322918,
 476193799,
 -1,
 -58267,
 476276127,
 7042,
 -1,
 476329151,
 7041,
 -1,
 476276626,
 7040,
 -1,
 476199213,
 7082,
 476708863,
 476124832,
 -1,
 476716140,
 476594316,
 -1,
 -58261,
 476654799,
 7075,
 -1,
 476712334,
 7074,
 -1,
 476658674,
 7073,
 -1,
 472252549,
 9925,
 -1,
 472205564,
 10185,
 477109430,
 472147736,
 -1,
 477174956,
 477050870,
 -1,
 477240477,
 477115909,
 -1,
 477305976,
 477190024,
 -1,
 477371510,
 477255560,
 -1,
 -58251,
 477315282,
 43024,
 -1,
 477374753,
 43025,
 -58249,
 477315282,
 43028,
 -1,
 477505825,
 43029,
 477699198,
 477239267,
 -1,
 477764732,
 477632483,
 -1,
 -58245,
 477708498,
 43026,
 -1,
 477767969,
 43027,
 -58243,
 477708498,
 43030,
 -1,
 477899041,
 43031,
 478092417,
 477645772,
 -1,
 -58240,
 478040141,
 43040,
 -1,
 478101714,
 43038,
 478289028,
 478037909,
 -1,
 -58237,
 478232786,
 43033,
 -1,
 478292257,
 43034,
 478485639,
 478228886,
 -1,
 -58234,
 478429394,
 43015,
 -1,
 478488865,
 43016,
 478682250,
 478425307,
 -1,
 -58231,
 478626002,
 43022,
 -1,
 478685473,
 43023,
 478878861,
 478618631,
 -1,
 -58228,
 478822610,
 43017,
 -1,
 478882081,
 43018,
 479075472,
 478810952,
 -1,
 -58225,
 479019218,
 43020,
 -1,
 479078689,
 43021,
 479272083,
 479007065,
 -1,
 -58222,
 479215826,
 43035,
 -1,
 479275297,
 43036,
 -58220,
 479223026,
 43011,
 -58219,
 479417656,
 43041,
 -58218,
 479477970,
 43013,
 -58217,
 479543221,
 43032,
 -58216,
 479607897,
 43037,
 -58215,
 479672233,
 43039,
 -58214,
 479734542,
 43009,
 -58213,
 479799585,
 43042,
 -58212,
 479861759,
 43012,
 -1,
 479923031,
 43008,
 480124067,
 477193097,
 -1,
 -58209,
 480074994,
 43045,
 -58208,
 480133958,
 43047,
 -58207,
 480193294,
 43044,
 -58206,
 480254975,
 43046,
 -1,
 480316247,
 43043,
 480517288,
 480070105,
 -1,
 -58203,
 480446923,
 43051,
 -58202,
 480512358,
 43050,
 -58201,
 480577743,
 43049,
 -1,
 480643138,
 43048,
 480903167,
 480465804,
 -1,
 -58198,
 480782165,
 43014,
 -58197,
 480844782,
 43010,
 -1,
 480906971,
 43019,
 481107125,
 477122103,
 -1,
 481172657,
 481056059,
 -1,
 -58193,
 481126810,
 1869,
 -58192,
 481178283,
 1870,
 -1,
 481239570,
 1871,
 481492991,
 481118485,
 -1,
 -58189,
 481371489,
 1838,
 -58188,
 481433826,
 1839,
 -1,
 481497675,
 1837,
 -1,
 481049304,
 8527,
 481762552,
 477046407,
 -1,
 481828087,
 481692503,
 -1,
 481893622,
 481780429,
 -1,
 481959107,
 481823575,
 -1,
 482024637,
 481905612,
 -1,
 -58180,
 481971412,
 66684,
 -1,
 482024447,
 66680,
 -58178,
 481977505,
 66679,
 -58177,
 482169469,
 66664,
 -58176,
 482226001,
 66682,
 -58175,
 482289287,
 66669,
 -58174,
 482354430,
 66673,
 -1,
 482417092,
 66665,
 482614474,
 481902802,
 -1,
 -58171,
 482566342,
 66668,
 -58170,
 482626508,
 66681,
 -58169,
 482690961,
 66677,
 -58168,
 482753950,
 66666,
 -58167,
 482815187,
 66678,
 -1,
 482872715,
 66676,
 483073232,
 482548735,
 -1,
 483138766,
 483003223,
 -1,
 -58163,
 483088264,
 66672,
 -1,
 483150796,
 66685,
 -58161,
 483086525,
 66683,
 -1,
 483272003,
 66663,
 483466453,
 483022728,
 -1,
 483531988,
 483403399,
 -1,
 -58157,
 483470454,
 66644,
 -1,
 483533243,
 66654,
 -1,
 483476748,
 66641,
 483794137,
 483404558,
 -1,
 -58153,
 483729854,
 66662,
 -58152,
 483791920,
 66674,
 -1,
 483855947,
 66686,
 484056284,
 483747717,
 -1,
 -58149,
 484008946,
 66687,
 -1,
 484051799,
 66648,
 484252895,
 484009448,
 -1,
 -58146,
 484196869,
 66667,
 -1,
 484252671,
 66658,
 484449506,
 484200835,
 -1,
 -58143,
 484401223,
 66646,
 -1,
 484458706,
 66645,
 484646117,
 484391140,
 -1,
 -58140,
 484584697,
 66661,
 -1,
 484646079,
 66656,
 484842728,
 484583047,
 -1,
 -58137,
 484794188,
 66649,
 -1,
 484838311,
 66659,
 -58135,
 484796867,
 66655,
 -58134,
 484991848,
 66653,
 -58133,
 485056412,
 66675,
 -58132,
 485118047,
 66670,
 -58131,
 485181588,
 66640,
 -58130,
 485245027,
 66671,
 -58129,
 485308336,
 66660,
 -58128,
 485372617,
 66642,
 -58127,
 485437819,
 66657,
 -58126,
 485500008,
 66652,
 -58125,
 485564975,
 66643,
 -58124,
 485628034,
 66651,
 -58123,
 485692617,
 66647,
 -1,
 485757524,
 66650,
 -1,
 481836284,
 9752,
 -1,
 481767077,
 9961,
 486087937,
 481706194,
 -1,
 486153472,
 486039758,
 -1,
 486219005,
 486106308,
 -1,
 -58116,
 486171896,
 11011,
 -1,
 486216335,
 11019,
 486473727,
 486153372,
 -1,
 -58113,
 486368504,
 11010,
 -1,
 486412943,
 11018,
 -1,
 486085658,
 9917,
 486677766,
 486037384,
 -1,
 486743301,
 486608084,
 -1,
 -58108,
 486680490,
 9882,
 -1,
 486739100,
 9877,
 -1,
 486689867,
 9188,
 487005450,
 486611967,
 -1,
 -58104,
 486958856,
 9913,
 -58103,
 487020033,
 9916,
 -1,
 487078926,
 9914,
 -58101,
 486958762,
 8275,
 -58100,
 487213342,
 8375,
 -58099,
 487276496,
 9924,
 -58098,
 487340535,
 68411,
 -58097,
 487404714,
 42611,
 -58096,
 487469774,
 9975,
 -1,
 487527287,
 9878,
 487726778,
 453977095,
 -1,
 487792114,
 487673177,
 -1,
 487857511,
 487721815,
 -1,
 487923044,
 487790294,
 -1,
 487988538,
 487854304,
 -1,
 488054057,
 487924353,
 -1,
 488119586,
 488006088,
 65859,
 488243199,
 488046592,
 -1,
 488250653,
 488134536,
 -1,
 488316188,
 488188397,
 65862,
 -1,
 488244446,
 65870,
 -1,
 488246729,
 65864,
 488512801,
 488188623,
 65861,
 488636415,
 488439808,
 -1,
 -58080,
 488527870,
 65868,
 -1,
 488592985,
 65875,
 -1,
 488461913,
 65871,
 488898559,
 488055794,
 65860,
 488964095,
 488767488,
 -1,
 488971560,
 488855432,
 -1,
 489037095,
 488909293,
 65863,
 -1,
 488965333,
 65878,
 -1,
 488967625,
 65866,
 -1,
 488920665,
 65873,
 489299252,
 487998115,
 -1,
 489364783,
 489236103,
 -1,
 489430318,
 489316164,
 -1,
 -58067,
 489379838,
 65867,
 -1,
 489444953,
 65874,
 -1,
 489360869,
 65857,
 489692466,
 489314693,
 -1,
 -58063,
 489641982,
 65869,
 -1,
 489707097,
 65876,
 -58061,
 489638753,
 65856,
 -1,
 489823105,
 65858,
 490078207,
 489248890,
 -1,
 490085688,
 489969544,
 -1,
 -58057,
 490023435,
 65877,
 -1,
 490081737,
 65865,
 -58055,
 490034777,
 65872,
 -1,
 490224701,
 65879,
 490413395,
 487937928,
 -1,
 490478923,
 490350525,
 -1,
 490544450,
 490428296,
 -1,
 490609984,
 490481287,
 -1,
 -58049,
 490556749,
 65899,
 -1,
 490614675,
 65893,
 -58047,
 490563048,
 65884,
 -1,
 490741355,
 65892,
 490937670,
 490488479,
 65881,
 491061247,
 490864640,
 -1,
 -58043,
 490953084,
 65905,
 -1,
 491006671,
 65898,
 491257855,
 490873473,
 -1,
 491265354,
 491151819,
 -1,
 -58039,
 491215228,
 65906,
 -1,
 491268815,
 65902,
 -1,
 491201522,
 65897,
 491585535,
 490426472,
 -1,
 491593041,
 491463297,
 -1,
 491658575,
 491545032,
 65887,
 -1,
 491585896,
 65901,
 491847679,
 491594738,
 65894,
 -1,
 491716646,
 65895,
 491978751,
 491542646,
 65888,
 -1,
 491847718,
 65889,
 492051801,
 490350502,
 -1,
 492117336,
 491994117,
 -1,
 -58026,
 492066934,
 65890,
 -58025,
 492126879,
 65882,
 -1,
 492184196,
 65896,
 -1,
 492047528,
 65880,
 492445021,
 491986736,
 -1,
 492510556,
 492395635,
 65883,
 -1,
 492437774,
 65886,
 -1,
 492446426,
 65900,
 492707168,
 492376904,
 -1,
 -58017,
 492660858,
 65885,
 -1,
 492703727,
 65903,
 -58015,
 492656273,
 65908,
 -58014,
 492846625,
 65904,
 -58013,
 492911478,
 65891,
 -1,
 492968083,
 65907,
 493223935,
 487869388,
 -1,
 -58010,
 493115329,
 65926,
 -1,
 493176270,
 65927,
 493362574,
 487796300,
 -1,
 493428080,
 493291979,
 119327,
 -58006,
 493357860,
 119356,
 -58005,
 493423344,
 119355,
 -58004,
 493488820,
 119354,
 -58003,
 493554189,
 119353,
 -58002,
 493619558,
 119352,
 -58001,
 493684943,
 119351,
 -1,
 493750210,
 119350,
 493952376,
 493357122,
 119325,
 -57998,
 493882148,
 119337,
 -57997,
 493947632,
 119336,
 -57996,
 494013108,
 119335,
 -57995,
 494078411,
 119334,
 -57994,
 494143846,
 119333,
 -57993,
 494209231,
 119332,
 -1,
 494274626,
 119331,
 494476671,
 493881551,
 119326,
 -57990,
 494406436,
 119343,
 -57989,
 494471860,
 119342,
 -57988,
 494537338,
 119341,
 -57987,
 494602765,
 119340,
 -57986,
 494668235,
 119339,
 -1,
 494733670,
 119338,
 494935429,
 494406157,
 119328,
 -57983,
 494864843,
 119361,
 -57982,
 494930278,
 119360,
 -57981,
 494995663,
 119359,
 -57980,
 495061058,
 119358,
 -1,
 495126466,
 119357,
 495328652,
 494864742,
 -1,
 -57977,
 495258404,
 119349,
 -57976,
 495323888,
 119348,
 -57975,
 495389364,
 119347,
 -57974,
 495454842,
 119346,
 -57973,
 495519951,
 119345,
 -1,
 495585218,
 119344,
 -57971,
 495258352,
 119330,
 -1,
 495717044,
 119329,
 495918508,
 493314825,
 -1,
 495984026,
 495847490,
 119296,
 -57967,
 495913764,
 119314,
 -57966,
 495979248,
 119313,
 -57965,
 496044724,
 119312,
 -57964,
 496110202,
 119311,
 -57963,
 496175629,
 119310,
 -57962,
 496241099,
 119309,
 -57961,
 496306534,
 119308,
 -57960,
 496371919,
 119307,
 -57959,
 496437314,
 119306,
 -1,
 496502722,
 119305,
 496704928,
 495913485,
 119300,
 -57956,
 496634315,
 119324,
 -57955,
 496699750,
 119323,
 -57954,
 496765135,
 119322,
 -57953,
 496830530,
 119321,
 -1,
 496895938,
 119320,
 497098150,
 496634063,
 119297,
 -57950,
 497027531,
 119319,
 -57949,
 497092966,
 119318,
 -57948,
 497158351,
 119317,
 -57947,
 497223746,
 119316,
 -1,
 497289154,
 119315,
 -57945,
 497027876,
 119304,
 -57944,
 497421040,
 119303,
 -57943,
 497486516,
 119302,
 -57942,
 497551994,
 119301,
 -57941,
 497617355,
 119299,
 -1,
 497682790,
 119298,
 497884607,
 495866243,
 -1,
 497950137,
 497826202,
 -1,
 498015669,
 497890821,
 -1,
 498081202,
 497963395,
 -1,
 -57935,
 498018593,
 1016,
 -1,
 498077259,
 1019,
 -57933,
 498026505,
 887,
 -57932,
 498214854,
 881,
 -1,
 498274126,
 883,
 498474424,
 497962482,
 -1,
 -57929,
 498415816,
 891,
 -1,
 498473621,
 893,
 -1,
 498408085,
 892,
 498794495,
 497901049,
 -1,
 -57925,
 498683417,
 7528,
 -57924,
 498747695,
 7529,
 -57923,
 498803841,
 7527,
 -57922,
 498865298,
 7530,
 -1,
 498930234,
 7526,
 499129806,
 497816519,
 -1,
 499195337,
 499069833,
 -1,
 499260872,
 499130382,
 -1,
 499326405,
 499208579,
 -1,
 -57916,
 499263777,
 1015,
 -1,
 499322443,
 1018,
 -57914,
 499271689,
 886,
 -57913,
 499460038,
 880,
 -1,
 499519310,
 882,
 -1,
 499212005,
 1017,
 499785164,
 499142130,
 -1,
 -57909,
 499726536,
 1021,
 -1,
 499784341,
 1023,
 -57907,
 499724778,
 975,
 -1,
 499915413,
 1022,
 500112855,
 499079048,
 -1,
 500178386,
 500065771,
 -1,
 -57903,
 500128108,
 65911,
 -1,
 500187414,
 65917,
 500374997,
 500116000,
 -1,
 -57900,
 500321150,
 65912,
 -1,
 500384022,
 65918,
 -57898,
 500322661,
 65929,
 -1,
 500501950,
 65914,
 500702688,
 500052873,
 -1,
 500768223,
 500637717,
 -1,
 500833756,
 500713365,
 -1,
 -57893,
 500781949,
 7466,
 -1,
 500837134,
 7464,
 -57891,
 500780569,
 7465,
 -57890,
 500970575,
 7463,
 -1,
 501032065,
 7462,
 -1,
 500707399,
 65923,
 501292517,
 500646098,
 -1,
 501358051,
 501235335,
 65909,
 -1,
 501284902,
 65910,
 -57884,
 501309292,
 65924,
 -1,
 501420747,
 65916,
 501620200,
 501233892,
 -1,
 -57881,
 501571705,
 119365,
 -1,
 501620737,
 65921,
 501816811,
 501555646,
 -1,
 -57878,
 501761463,
 65919,
 -1,
 501821563,
 65920,
 -57876,
 501770598,
 65930,
 -57875,
 501966728,
 65913,
 -57874,
 502032108,
 65925,
 -57873,
 502091293,
 1020,
 -57872,
 502150007,
 65922,
 -57871,
 502212080,
 65928,
 -1,
 502274953,
 65915,
 502472305,
 487732262,
 -1,
 502537778,
 502420694,
 -1,
 502603261,
 502485379,
 -1,
 502668793,
 502539911,
 -1,
 502734328,
 502618016,
 11339,
 -1,
 502679876,
 11356,
 -1,
 502664023,
 11342,
 502930939,
 502610462,
 11348,
 -1,
 502859492,
 11349,
 -57860,
 502876488,
 11346,
 -1,
 503003160,
 11332,
 503193094,
 502556440,
 -1,
 503258627,
 503127039,
 -1,
 503324162,
 503204812,
 -1,
 -57855,
 503274738,
 11343,
 -1,
 503327502,
 11344,
 -1,
 503273228,
 11317,
 -57852,
 503209202,
 11347,
 -57851,
 503529682,
 11350,
 -1,
 503582912,
 11345,
 503782926,
 503130894,
 11323,
 503848458,
 503736700,
 -1,
 -57847,
 503787601,
 11355,
 -1,
 503847935,
 11321,
 504045069,
 503792946,
 -1,
 -57844,
 503993638,
 11351,
 -1,
 504042072,
 11353,
 -1,
 503988087,
 11322,
 504307218,
 503732104,
 -1,
 -57840,
 504259550,
 11333,
 -57839,
 504320893,
 11340,
 -1,
 504385667,
 11357,
 504569366,
 504240099,
 -1,
 -57836,
 504523040,
 11319,
 -57835,
 504578337,
 11316,
 -1,
 504639787,
 11324,
 504831513,
 504522983,
 -1,
 -57832,
 504768745,
 11318,
 -1,
 504831569,
 11320,
 505028124,
 504776597,
 -1,
 -57829,
 504971767,
 11330,
 -1,
 505027583,
 11338,
 505224735,
 504971474,
 -1,
 -57826,
 505175018,
 11337,
 -1,
 505233437,
 11329,
 505421346,
 505164681,
 -1,
 -57823,
 505360769,
 11326,
 -1,
 505417930,
 11358,
 505617957,
 505356734,
 -1,
 -57820,
 505565177,
 11335,
 -1,
 505622507,
 11354,
 505814568,
 505549145,
 -1,
 -57817,
 505765466,
 11313,
 -1,
 505818181,
 11352,
 -57815,
 505766403,
 11314,
 -57814,
 505962065,
 11334,
 -57813,
 506023923,
 11331,
 -57812,
 506084891,
 11328,
 -57811,
 506150294,
 11327,
 -57810,
 506212857,
 11325,
 -57809,
 506275761,
 11336,
 -57808,
 506340791,
 11315,
 -57807,
 506401972,
 11341,
 -1,
 506466645,
 11312,
 506724351,
 502469600,
 -1,
 506732092,
 506614147,
 -1,
 506797624,
 506668679,
 -1,
 506863159,
 506746784,
 11291,
 -1,
 506808644,
 11308,
 -1,
 506792791,
 11294,
 507059770,
 506739230,
 11300,
 -1,
 506988260,
 11301,
 -57797,
 507005256,
 11298,
 -1,
 507131928,
 11284,
 507321925,
 506685208,
 -1,
 507387458,
 507255807,
 -1,
 507452993,
 507333580,
 -1,
 -57792,
 507403506,
 11295,
 -1,
 507456270,
 11296,
 -1,
 507401996,
 11269,
 -57789,
 507337970,
 11299,
 -57788,
 507658450,
 11302,
 -1,
 507711680,
 11297,
 507911757,
 507259662,
 11275,
 507977289,
 507865468,
 -1,
 -57784,
 507916369,
 11307,
 -1,
 507976703,
 11273,
 508173900,
 507921714,
 -1,
 -57781,
 508122406,
 11303,
 -1,
 508170840,
 11305,
 -1,
 508116855,
 11274,
 508436049,
 507860872,
 -1,
 -57777,
 508388318,
 11285,
 -57776,
 508449661,
 11292,
 -1,
 508514435,
 11309,
 508698197,
 508368867,
 -1,
 -57773,
 508651808,
 11271,
 -57772,
 508707105,
 11268,
 -1,
 508768555,
 11276,
 508960344,
 508651751,
 -1,
 -57769,
 508897513,
 11270,
 -1,
 508960337,
 11272,
 509156955,
 508905365,
 -1,
 -57766,
 509100535,
 11282,
 -1,
 509156351,
 11290,
 509353566,
 509100242,
 -1,
 -57763,
 509303786,
 11289,
 -1,
 509362205,
 11281,
 509550177,
 509293449,
 -1,
 -57760,
 509489537,
 11278,
 -1,
 509546698,
 11310,
 509746788,
 509485502,
 -1,
 -57757,
 509693945,
 11287,
 -1,
 509751275,
 11306,
 509943399,
 509677913,
 -1,
 -57754,
 509894234,
 11265,
 -1,
 509946949,
 11304,
 -57752,
 509895171,
 11266,
 -57751,
 510090833,
 11286,
 -57750,
 510152691,
 11283,
 -57749,
 510213659,
 11280,
 -57748,
 510279062,
 11279,
 -57747,
 510341625,
 11277,
 -57746,
 510404529,
 11288,
 -57745,
 510469559,
 11267,
 -57744,
 510530740,
 11293,
 -1,
 510595413,
 11264,
 510795437,
 502406143,
 -1,
 510860969,
 510739558,
 -1,
 510926501,
 510809302,
 -1,
 510991995,
 510862983,
 -1,
 511057528,
 510921559,
 -1,
 -57737,
 511003596,
 11556,
 -1,
 511056895,
 11552,
 -57735,
 511000940,
 11557,
 -57734,
 511192076,
 11554,
 -1,
 511253503,
 11553,
 511450753,
 510923592,
 -1,
 511516287,
 511387271,
 -1,
 -57730,
 511454509,
 11545,
 -1,
 511512374,
 11549,
 -57728,
 511454419,
 11548,
 -1,
 511643211,
 11546,
 511843972,
 511404263,
 -1,
 -57725,
 511780646,
 11535,
 -1,
 511843947,
 11526,
 512040583,
 511793056,
 -1,
 -57722,
 511986636,
 11538,
 -1,
 512048542,
 11527,
 512237194,
 511988099,
 -1,
 -57719,
 512174252,
 11544,
 -1,
 512233035,
 11537,
 512433805,
 512182165,
 -1,
 -57716,
 512370470,
 11540,
 -1,
 512429878,
 11534,
 512630416,
 512373142,
 -1,
 -57713,
 512567078,
 11541,
 -1,
 512626251,
 11529,
 512827027,
 512569563,
 -1,
 -57710,
 512765139,
 11547,
 -1,
 512829175,
 11551,
 513023638,
 512762887,
 -1,
 -57707,
 512960247,
 11542,
 -1,
 513019467,
 11522,
 -57705,
 512976616,
 11550,
 -57704,
 513172641,
 11555,
 -57703,
 513237733,
 11525,
 -57702,
 513302237,
 11539,
 -57701,
 513363005,
 11536,
 -57700,
 513428225,
 11543,
 -57699,
 513491581,
 11533,
 -57698,
 513555973,
 11532,
 -57697,
 513620519,
 11531,
 -57696,
 513684595,
 11530,
 -57695,
 513748269,
 11528,
 -57694,
 513810027,
 11524,
 -57693,
 513874386,
 11523,
 -57692,
 513937837,
 11521,
 -1,
 514002507,
 11520,
 514260991,
 510866949,
 -1,
 -57689,
 514153792,
 983902,
 -57688,
 514219062,
 4345,
 -1,
 514264391,
 4346,
 514523135,
 510791478,
 9881,
 514588671,
 514393566,
 -1,
 -57684,
 514475509,
 9965,
 -1,
 514523483,
 9966,
 514785279,
 510745842,
 -1,
 514793140,
 514666754,
 -1,
 514858673,
 514745271,
 2786,
 -1,
 514798473,
 2787,
 514989747,
 514799194,
 2700,
 -1,
 514929545,
 2785,
 -1,
 514937175,
 2801,
 515186361,
 514740271,
 -1,
 -57674,
 515139431,
 2677,
 -57673,
 515203829,
 2563,
 -57672,
 515268135,
 2641,
 -1,
 515312748,
 2561,
 -1,
 515116857,
 8370,
 515579940,
 487657817,
 -1,
 515645391,
 515509079,
 -1,
 515710810,
 515585729,
 -1,
 515776253,
 515651077,
 -1,
 515841733,
 515725192,
 -1,
 515907268,
 515771223,
 6946,
 516030463,
 515833856,
 -1,
 -57662,
 515921997,
 6947,
 -57661,
 515980639,
 6942,
 -1,
 516043895,
 6941,
 -1,
 515860917,
 6983,
 516300490,
 515784094,
 -1,
 516366024,
 516229975,
 6950,
 -1,
 516293761,
 6945,
 -57655,
 516319029,
 6940,
 -1,
 516432946,
 6935,
 516628175,
 516239766,
 -1,
 516693710,
 516557655,
 6931,
 -57651,
 516628947,
 6981,
 -1,
 516686356,
 6932,
 -1,
 516631007,
 6982,
 516955861,
 516560906,
 6948,
 517079039,
 516882961,
 -1,
 517086932,
 516972609,
 -1,
 -57645,
 517028189,
 6944,
 -1,
 517082644,
 6943,
 -1,
 517016709,
 6949,
 517349082,
 516885335,
 -1,
 517414616,
 517288479,
 6917,
 -1,
 517342439,
 6918,
 -57639,
 517363580,
 6987,
 -1,
 517483721,
 6928,
 517676766,
 517296555,
 6962,
 517799935,
 517604513,
 -1,
 -57635,
 517687257,
 6961,
 -1,
 517743666,
 6960,
 517938913,
 517622811,
 6957,
 518062079,
 517866642,
 6923,
 -1,
 517932263,
 6924,
 518135524,
 517878711,
 6958,
 518258687,
 518062587,
 6925,
 -1,
 518128871,
 6926,
 518332134,
 518086219,
 6921,
 -1,
 518259943,
 6922,
 518463208,
 518277081,
 6951,
 -1,
 518390156,
 6952,
 518594282,
 518406641,
 6929,
 -1,
 518522087,
 6930,
 518725356,
 518533369,
 6938,
 -1,
 518652283,
 6939,
 518856430,
 518663369,
 6919,
 -1,
 518784231,
 6920,
 518987504,
 518792242,
 6933,
 -1,
 518914383,
 6934,
 519118579,
 518921215,
 -1,
 -57614,
 519057951,
 6927,
 -1,
 519119315,
 6984,
 519315189,
 519050084,
 6936,
 -1,
 519242181,
 6937,
 519446263,
 519246219,
 6953,
 -1,
 519373229,
 6954,
 -57608,
 519399683,
 6986,
 -57607,
 519530293,
 6956,
 -57606,
 519595047,
 6959,
 -57605,
 519660026,
 6985,
 -57604,
 519715114,
 6955,
 -1,
 519775901,
 6963,
 519970598,
 515718516,
 -1,
 520036108,
 519903203,
 -1,
 520101638,
 519965527,
 -1,
 520167172,
 520044283,
 7012,
 520290303,
 520093696,
 -1,
 -57597,
 520181574,
 7013,
 -1,
 520234266,
 7018,
 -57595,
 520105409,
 7017,
 -1,
 520363726,
 7015,
 520560393,
 520035327,
 -1,
 -57592,
 520511308,
 7016,
 -1,
 520568571,
 7010,
 -57590,
 520511308,
 7011,
 -57589,
 520700651,
 7009,
 -1,
 520760769,
 7014,
 520953623,
 519968287,
 -1,
 521019154,
 520893057,
 -1,
 521084688,
 520969822,
 7021,
 -1,
 521012883,
 7024,
 521273343,
 521025145,
 7022,
 -1,
 521143955,
 7025,
 -57581,
 520968293,
 7019,
 -57580,
 521285913,
 7023,
 -57579,
 521348580,
 7027,
 -57578,
 521412279,
 7020,
 -1,
 521474585,
 7026,
 521674527,
 520893818,
 -1,
 521740060,
 521618354,
 -1,
 -57574,
 521690956,
 7033,
 -57573,
 521743809,
 7036,
 -1,
 521801373,
 7032,
 522059775,
 521672146,
 -1,
 -57570,
 521952840,
 7035,
 -1,
 521997707,
 7034,
 522256383,
 521621224,
 -1,
 522264355,
 522142601,
 -1,
 -57566,
 522214967,
 7028,
 -1,
 522259676,
 7029,
 522518527,
 522196444,
 -1,
 -57563,
 522411592,
 7030,
 -1,
 522456459,
 7031,
 522657592,
 519922569,
 -1,
 522723118,
 522606472,
 -1,
 522788653,
 522653167,
 6974,
 522911743,
 522715136,
 -1,
 522919724,
 522800502,
 6975,
 -1,
 522847463,
 6977,
 -1,
 522868830,
 6976,
 -1,
 522722599,
 6965,
 523181872,
 522673808,
 6966,
 -1,
 523109541,
 6967,
 523312946,
 523130667,
 6968,
 -1,
 523239793,
 6969,
 523444020,
 523258910,
 6970,
 -1,
 523371751,
 6971,
 523575094,
 523389143,
 6978,
 -1,
 523502823,
 6979,
 523763711,
 523514810,
 6972,
 -1,
 523633895,
 6973,
 523837254,
 522590551,
 -1,
 523902780,
 523786120,
 -1,
 -57541,
 523855336,
 6994,
 -1,
 523905563,
 6995,
 524099391,
 523850115,
 -1,
 -57538,
 524038290,
 6998,
 -1,
 524099667,
 6999,
 524296002,
 524034494,
 -1,
 -57535,
 524240292,
 6996,
 -1,
 524300383,
 6997,
 -57533,
 524249407,
 6992,
 -57532,
 524436127,
 6993,
 -57531,
 524500833,
 7001,
 -1,
 524557792,
 7000,
 524754766,
 523785100,
 -1,
 524820298,
 524705428,
 -1,
 -57527,
 524766806,
 6912,
 -1,
 524817283,
 6913,
 -57525,
 524769094,
 6915,
 -57524,
 524963208,
 6964,
 -57523,
 525014082,
 6914,
 -1,
 525079161,
 6916,
 525279059,
 524699609,
 -1,
 525344594,
 525220068,
 -1,
 -57519,
 525278909,
 7008,
 -1,
 525339752,
 7003,
 -1,
 525287438,
 7002,
 525606744,
 525210614,
 -1,
 525672279,
 525551577,
 -1,
 -57514,
 525618576,
 7007,
 -1,
 525679942,
 7005,
 -1,
 525620169,
 7006,
 -57511,
 525559193,
 7004,
 -1,
 525864059,
 6980,
 526065614,
 515652904,
 -1,
 526131139,
 526005765,
 -1,
 526196591,
 526073246,
 -1,
 526262113,
 526135515,
 -1,
 -57505,
 526212447,
 42686,
 -57504,
 526261549,
 42694,
 -1,
 526322840,
 42674,
 526524261,
 526197767,
 -1,
 -57501,
 526463857,
 42707,
 -57500,
 526525490,
 42708,
 -1,
 526584663,
 42709,
 526786407,
 526474482,
 42685,
 -1,
 526716041,
 42684,
 526917482,
 526735240,
 -1,
 -57495,
 526868728,
 42731,
 -1,
 526916909,
 42695,
 -57493,
 526870524,
 42664,
 -57492,
 527061682,
 42691,
 -57491,
 527117070,
 42703,
 -57490,
 527177756,
 42673,
 -1,
 527240023,
 42715,
 527441788,
 526135702,
 -1,
 527507315,
 527384786,
 42719,
 -57486,
 527459300,
 42734,
 -1,
 527508854,
 42735,
 527703927,
 527440895,
 -1,
 -57483,
 527655170,
 42692,
 -57482,
 527718280,
 42683,
 -1,
 527777182,
 42706,
 -57480,
 527656856,
 42682,
 -57479,
 527916274,
 42659,
 -57478,
 527976409,
 42729,
 -57477,
 528034574,
 42725,
 -1,
 528091991,
 42657,
 528293767,
 527382756,
 42675,
 528359296,
 528227327,
 -1,
 -57473,
 528301470,
 42722,
 -1,
 528358704,
 42671,
 528555907,
 528290137,
 -1,
 -57470,
 528490091,
 42720,
 -1,
 528550847,
 42727,
 -57468,
 528506098,
 42677,
 -57467,
 528695506,
 42726,
 -57466,
 528755470,
 42702,
 -1,
 528812887,
 42723,
 529014673,
 528241027,
 -1,
 529080205,
 528950919,
 -1,
 -57462,
 529030386,
 42688,
 -57461,
 529088722,
 42710,
 -57460,
 529149122,
 42678,
 -1,
 529211460,
 42680,
 -57458,
 529031416,
 42676,
 -57457,
 529345294,
 42679,
 -57456,
 529408068,
 42681,
 -1,
 529468976,
 42732,
 529670043,
 528960460,
 -1,
 529735574,
 529603583,
 -1,
 -57452,
 529686786,
 42704,
 -57451,
 529743262,
 42721,
 -1,
 529800191,
 42661,
 529997721,
 529672974,
 -1,
 -57448,
 529935118,
 42668,
 -1,
 529997101,
 42669,
 -57446,
 529947890,
 42700,
 -1,
 530123913,
 42705,
 530325412,
 529614741,
 -1,
 530390943,
 530275570,
 -1,
 -57442,
 530324479,
 42696,
 -1,
 530386057,
 42711,
 530587554,
 530324479,
 -1,
 -57439,
 530538754,
 42693,
 -1,
 530586623,
 42698,
 -57437,
 530524942,
 42717,
 -1,
 530713431,
 42667,
 530915244,
 530274184,
 -1,
 530980776,
 530848767,
 -1,
 -57433,
 530929544,
 42728,
 -1,
 530988446,
 42730,
 531177387,
 530910039,
 -1,
 -57430,
 531110911,
 42662,
 -1,
 531172183,
 42672,
 -1,
 531114766,
 42724,
 531439538,
 530854793,
 -1,
 -57426,
 531389682,
 42701,
 -57425,
 531448891,
 42718,
 -57424,
 531507982,
 42716,
 -57423,
 531569972,
 42670,
 -1,
 531630935,
 42666,
 531832759,
 531374526,
 -1,
 -57420,
 531782898,
 42712,
 -57419,
 531841629,
 42713,
 -57418,
 531897645,
 42699,
 -1,
 531958730,
 42733,
 532160443,
 531785496,
 -1,
 -57415,
 532111370,
 42689,
 -57414,
 532169787,
 42687,
 -1,
 532220759,
 42690,
 532422590,
 532112370,
 -1,
 -57411,
 532373044,
 42697,
 -1,
 532417367,
 42714,
 -57409,
 532372722,
 42658,
 -57408,
 532562130,
 42663,
 -57407,
 532622094,
 42665,
 -57406,
 532684077,
 42660,
 -1,
 532745047,
 42656,
 532946890,
 526063113,
 -1,
 533012425,
 532887780,
 -1,
 533077960,
 532943468,
 -1,
 -57401,
 533027865,
 42737,
 -1,
 533082914,
 42736,
 -1,
 533018922,
 42741,
 -1,
 532953013,
 42740,
 -57397,
 532894308,
 42742,
 -57396,
 533351317,
 42743,
 -57395,
 533413763,
 42738,
 -1,
 533472246,
 42739,
 -1,
 526012964,
 9918,
 533733364,
 515595834,
 -1,
 533798892,
 533673477,
 -1,
 533864410,
 533740958,
 -1,
 533929941,
 533817112,
 -1,
 -57388,
 533861220,
 6671,
 -1,
 533924695,
 6670,
 534126552,
 533865479,
 -1,
 -57385,
 534065589,
 6659,
 -1,
 534121303,
 6658,
 -57383,
 534072347,
 6667,
 -1,
 534252375,
 6666,
 534454237,
 533805284,
 -1,
 -57380,
 534398937,
 6663,
 -1,
 534448983,
 6662,
 -57378,
 534406965,
 6672,
 -57377,
 534602006,
 6675,
 -57376,
 534665120,
 6664,
 -57375,
 534729131,
 6676,
 -57374,
 534793243,
 6673,
 -57373,
 534857689,
 6660,
 -57372,
 534918071,
 6674,
 -57371,
 534983093,
 6656,
 -57370,
 535048441,
 6669,
 -57369,
 535111325,
 6678,
 -57368,
 535176242,
 6657,
 -57367,
 535238666,
 6665,
 -57366,
 535303012,
 6668,
 -57365,
 535368075,
 6661,
 -1,
 535432023,
 6677,
 535633906,
 533750665,
 -1,
 -57362,
 535583986,
 6680,
 -57361,
 535642322,
 6682,
 -57360,
 535702286,
 6679,
 -57359,
 535763967,
 6681,
 -1,
 535825545,
 6683,
 -57357,
 535578625,
 6686,
 -1,
 535961256,
 6687,
 536158229,
 533672914,
 -1,
 536223739,
 536105347,
 -1,
 536289274,
 536164762,
 -1,
 -57352,
 536237652,
 11089,
 -57351,
 536295525,
 11050,
 -1,
 536353073,
 11049,
 -1,
 536231881,
 9927,
 536616960,
 536164580,
 -1,
 536682495,
 536550688,
 -1,
 -57346,
 536623205,
 11047,
 -1,
 536680753,
 11045,
 -1,
 536626014,
 9912,
 536944645,
 536556425,
 -1,
 537010180,
 536874852,
 -1,
 -57341,
 536958408,
 11035,
 -1,
 537007397,
 11044,
 -1,
 536944001,
 9944,
 537272328,
 536896018,
 -1,
 -57337,
 537224986,
 11037,
 -1,
 537287115,
 11054,
 537468939,
 537221000,
 -1,
 -57334,
 537421411,
 9942,
 -1,
 537481495,
 9951,
 537665550,
 537405063,
 -1,
 -57331,
 537609346,
 11052,
 -1,
 537665785,
 11042,
 537862161,
 537598870,
 -1,
 -57328,
 537803303,
 9922,
 -1,
 537866967,
 9923,
 -57326,
 537808649,
 11091,
 -57325,
 538003652,
 11039,
 -57324,
 538059495,
 9873,
 -1,
 538121959,
 9960,
 538320925,
 536101074,
 -1,
 538386460,
 538270692,
 -1,
 -57320,
 538335975,
 9185,
 -57319,
 538398394,
 11813,
 -57318,
 538462301,
 9181,
 -57317,
 538522974,
 11812,
 -1,
 538580935,
 9183,
 -1,
 538331645,
 12589,
 538845219,
 538254955,
 -1,
 538910754,
 538780784,
 -1,
 -57312,
 538858386,
 2493,
 -57311,
 538916380,
 2510,
 -1,
 538977430,
 2555,
 -1,
 538863913,
 9187,
 -1,
 538798259,
 983050,
 539304363,
 515518870,
 -1,
 539369736,
 539240071,
 -1,
 539435179,
 539310961,
 -1,
 539500657,
 539382147,
 -1,
 539566192,
 539453492,
 -1,
 539631680,
 539510677,
 -1,
 539697212,
 539577473,
 -1,
 539762745,
 539625207,
 -1,
 539828275,
 539693401,
 -1,
 539893808,
 539778967,
 -1,
 -57297,
 539840612,
 6649,
 -1,
 539898649,
 6633,
 540147711,
 539827672,
 -1,
 -57294,
 540037220,
 6648,
 -1,
 540095257,
 6632,
 540287030,
 539773294,
 -1,
 -57291,
 540233828,
 6647,
 -1,
 540291865,
 6631,
 540540927,
 540228947,
 -1,
 -57288,
 540430436,
 6646,
 -1,
 540488473,
 6630,
 540737535,
 539688960,
 -1,
 -57285,
 540627044,
 6645,
 -1,
 540685081,
 6629,
 540876863,
 539634885,
 -1,
 -57282,
 540823652,
 6642,
 -1,
 540881689,
 6626,
 -1,
 540807290,
 6624,
 541139030,
 539564114,
 -1,
 541204563,
 541066999,
 -1,
 541270089,
 541149077,
 -1,
 541335622,
 541215877,
 -1,
 -57275,
 541282404,
 6655,
 -1,
 541340441,
 6639,
 541589503,
 541273285,
 -1,
 -57272,
 541479012,
 6652,
 -1,
 541537049,
 6636,
 541728848,
 541200729,
 -1,
 541794381,
 541679511,
 -1,
 -57268,
 541741156,
 6654,
 -1,
 541799193,
 6638,
 542048255,
 541728216,
 -1,
 -57265,
 541937764,
 6653,
 -1,
 541995801,
 6637,
 542244863,
 541670739,
 -1,
 -57262,
 542134372,
 6651,
 -1,
 542192409,
 6635,
 542441471,
 541130752,
 -1,
 -57259,
 542330980,
 6650,
 -1,
 542389017,
 6634,
 542580837,
 541078977,
 -1,
 542646368,
 542525333,
 -1,
 542711903,
 542592129,
 6133,
 542834687,
 542639863,
 -1,
 542842973,
 542708057,
 -1,
 -57252,
 542793619,
 6137,
 -1,
 542842325,
 6136,
 -57250,
 542787946,
 6135,
 -1,
 542981454,
 6134,
 -1,
 542649538,
 6130,
 543236195,
 542576985,
 -1,
 -57246,
 543186835,
 6132,
 -1,
 543235541,
 6131,
 -57244,
 543184221,
 6128,
 -1,
 543374670,
 6129,
 543563884,
 542511449,
 -1,
 543629417,
 543514519,
 -1,
 -57240,
 543576164,
 6644,
 -1,
 543634201,
 6628,
 543883263,
 543563224,
 -1,
 -57237,
 543772772,
 6643,
 -1,
 543830809,
 6627,
 544022639,
 543505747,
 -1,
 -57234,
 543969380,
 6641,
 -1,
 544027417,
 6625,
 -1,
 543972451,
 6640,
 -1,
 539503797,
 6109,
 544350369,
 539432565,
 -1,
 544415867,
 544298888,
 -1,
 544481398,
 544364784,
 -1,
 -57227,
 544424146,
 983916,
 -1,
 544475991,
 983914,
 544678009,
 544417415,
 -1,
 -57224,
 544620754,
 983921,
 -1,
 544672599,
 983919,
 -57222,
 544620754,
 983920,
 -1,
 544803671,
 983918,
 545005696,
 544357790,
 -1,
 -57219,
 544958526,
 983912,
 -57218,
 545013970,
 983922,
 -57217,
 545072575,
 983907,
 -1,
 545131351,
 983917,
 545333382,
 544944534,
 -1,
 545398916,
 545269383,
 -1,
 -57213,
 545341650,
 983906,
 -1,
 545393495,
 983904,
 -57211,
 545341650,
 983905,
 -1,
 545524567,
 983903,
 545726604,
 545264456,
 -1,
 545792138,
 545662599,
 -1,
 -57207,
 545734866,
 983911,
 -1,
 545786711,
 983909,
 -57205,
 545734866,
 983910,
 -1,
 545917783,
 983908,
 546119824,
 545673603,
 -1,
 -57202,
 546066859,
 983933,
 -57201,
 546121373,
 983932,
 -1,
 546179927,
 983934,
 546381973,
 546064277,
 -1,
 546447508,
 546317959,
 -1,
 -57197,
 546390226,
 983926,
 -1,
 546442071,
 983924,
 -1,
 546390226,
 983925,
 546709656,
 546321289,
 -1,
 -57193,
 546652370,
 983930,
 -1,
 546704215,
 983936,
 546906267,
 546641891,
 -1,
 -57190,
 546848978,
 983915,
 -1,
 546900823,
 983913,
 -57188,
 546859070,
 983928,
 -57187,
 547054342,
 983931,
 -57186,
 547115085,
 983929,
 -57185,
 547175513,
 983927,
 -57184,
 547235485,
 983935,
 -1,
 547295627,
 983923,
 547496103,
 544288091,
 -1,
 547561636,
 547443042,
 983939,
 -1,
 547514136,
 983940,
 547749887,
 547506910,
 -1,
 -57178,
 547642610,
 983938,
 -1,
 547691519,
 983941,
 547946495,
 547447689,
 -1,
 -57175,
 547832413,
 983942,
 -57174,
 547886604,
 983937,
 -1,
 547949510,
 983943,
 548208639,
 539365274,
 -1,
 548217051,
 548091397,
 -1,
 548282548,
 548165512,
 -1,
 548348082,
 548231048,
 -1,
 -57168,
 548296947,
 68147,
 -57167,
 548349597,
 68123,
 -1,
 548408151,
 68122,
 -57165,
 548284061,
 68128,
 -1,
 548539223,
 68127,
 548741306,
 548214755,
 -1,
 548806840,
 548673507,
 -1,
 -57161,
 548742813,
 68125,
 -1,
 548801367,
 68124,
 -57159,
 548742813,
 68130,
 -1,
 548932439,
 68129,
 549134526,
 548688259,
 -1,
 -57156,
 549081515,
 68142,
 -57155,
 549136029,
 68141,
 -1,
 549194583,
 68143,
 549396674,
 549076382,
 -1,
 -57152,
 549349173,
 68121,
 -57151,
 549404111,
 68126,
 -1,
 549456727,
 68131,
 549658822,
 549335446,
 -1,
 -57148,
 549597621,
 68146,
 -57147,
 549660317,
 68113,
 -1,
 549718871,
 68112,
 549920969,
 549603221,
 -1,
 -57144,
 549856925,
 68133,
 -1,
 549915479,
 68132,
 550117580,
 549856263,
 -1,
 -57141,
 550053533,
 68115,
 -1,
 550112087,
 68114,
 550314191,
 550048584,
 -1,
 -57138,
 550250141,
 68118,
 -1,
 550308695,
 68117,
 550510802,
 550244697,
 -1,
 -57135,
 550446749,
 68135,
 -1,
 550505303,
 68134,
 -57133,
 550463735,
 68144,
 -57132,
 550659893,
 68137,
 -57131,
 550723862,
 68140,
 -57130,
 550784027,
 68138,
 -57129,
 550844714,
 68136,
 -57128,
 550908855,
 68139,
 -57127,
 550973689,
 68119,
 -57126,
 551036573,
 68145,
 -1,
 551095127,
 68096,
 551297257,
 548162226,
 -1,
 551362785,
 551229411,
 -1,
 551428320,
 551305426,
 -1,
 -57121,
 551378354,
 68183,
 -1,
 551442312,
 68176,
 -1,
 551358087,
 68182,
 551690468,
 551302025,
 -1,
 -57117,
 551634290,
 68181,
 -1,
 551693739,
 68184,
 551887079,
 551621448,
 -1,
 -57114,
 551832986,
 68179,
 -1,
 551890791,
 68178,
 -57112,
 551834803,
 68177,
 -1,
 552024637,
 68180,
 552214771,
 551248136,
 -1,
 552280306,
 552159088,
 -1,
 552345841,
 552227724,
 -1,
 -57107,
 552297257,
 68099,
 -57106,
 552361202,
 68098,
 -57105,
 552419538,
 68102,
 -57104,
 552479502,
 68097,
 -1,
 552541183,
 68101,
 -1,
 552285655,
 68108,
 -1,
 552218465,
 68159,
 552870139,
 552162188,
 -1,
 552935671,
 552802756,
 -1,
 -57098,
 552885710,
 68109,
 -1,
 552949642,
 68154,
 -57096,
 552887029,
 68111,
 -57095,
 553063436,
 68153,
 -57094,
 553128378,
 68152,
 -1,
 553193179,
 68110,
 553394434,
 552812600,
 -1,
 553459967,
 553342856,
 -1,
 -57090,
 553411748,
 68165,
 -1,
 553459307,
 68164,
 553713663,
 553403043,
 -1,
 -57087,
 553605500,
 68167,
 -1,
 553659087,
 68166,
 553910271,
 553326935,
 -1,
 553918726,
 553801608,
 -1,
 -57083,
 553870824,
 68161,
 -1,
 553921051,
 68162,
 -57081,
 553861791,
 68160,
 -1,
 554050385,
 68163,
 554303487,
 539298647,
 -1,
 554312033,
 554184749,
 -1,
 554377541,
 554251781,
 -1,
 554443026,
 554309603,
 -1,
 554508560,
 554375139,
 -1,
 -57074,
 554444445,
 69787,
 -57073,
 554506462,
 69786,
 -1,
 554568535,
 69785,
 -57071,
 554444445,
 69793,
 -1,
 554699607,
 69792,
 554901784,
 554391432,
 -1,
 554967318,
 554850184,
 -1,
 -57067,
 554903197,
 69784,
 -1,
 554961751,
 69783,
 -57065,
 554903197,
 69791,
 -1,
 555092823,
 69790,
 555295005,
 554843550,
 -1,
 -57062,
 555247413,
 69782,
 -57061,
 555302351,
 69789,
 -57060,
 555361330,
 69777,
 -1,
 555420503,
 69794,
 555622689,
 555223895,
 69763,
 -57057,
 555572466,
 69772,
 -57056,
 555625230,
 69770,
 -1,
 555682647,
 69764,
 555884837,
 555569539,
 -1,
 -57053,
 555831723,
 69805,
 -57052,
 555886237,
 69804,
 -1,
 555944791,
 69806,
 556146983,
 555834610,
 69767,
 -1,
 556096754,
 69768,
 556278058,
 556092364,
 -1,
 -57047,
 556213917,
 69788,
 -1,
 556272471,
 69801,
 556474669,
 556222357,
 -1,
 -57044,
 556410525,
 69796,
 -1,
 556469079,
 69795,
 556671280,
 556413334,
 -1,
 -57041,
 556607133,
 69774,
 -1,
 556665687,
 69773,
 556867891,
 556609755,
 -1,
 -57038,
 556803741,
 69781,
 -1,
 556862295,
 69780,
 557064501,
 556804878,
 69765,
 -1,
 557001486,
 69766,
 557195576,
 556999687,
 -1,
 -57033,
 557131421,
 69776,
 -1,
 557189975,
 69775,
 557392187,
 557126472,
 -1,
 -57030,
 557328029,
 69779,
 -1,
 557386583,
 69778,
 557588798,
 557322585,
 -1,
 -57027,
 557524637,
 69798,
 -1,
 557583191,
 69797,
 -57025,
 557541173,
 69800,
 -57024,
 557736214,
 69803,
 -57023,
 557793490,
 69771,
 -57022,
 557857066,
 69799,
 -57021,
 557921207,
 69802,
 -57020,
 557983389,
 69807,
 -1,
 558046207,
 69769,
 558244176,
 554328969,
 -1,
 558309706,
 558173015,
 -1,
 -57016,
 558259442,
 69816,
 -57015,
 558312206,
 69814,
 -1,
 558369623,
 69808,
 558571852,
 558259442,
 69811,
 -1,
 558521586,
 69812,
 558702926,
 558508814,
 69809,
 -1,
 558639886,
 69810,
 -57009,
 558645458,
 69815,
 -1,
 558767103,
 69813,
 558965081,
 558190979,
 -1,
 559030616,
 558902448,
 -1,
 559096149,
 558981834,
 -1,
 -57004,
 559043044,
 69762,
 -1,
 559107219,
 69817,
 -57002,
 559038510,
 69818,
 -57001,
 559223726,
 69760,
 -1,
 559288027,
 69761,
 -1,
 558963967,
 69822,
 559554910,
 558897123,
 -1,
 559620445,
 559498618,
 -1,
 -56996,
 559567418,
 69823,
 -1,
 559618116,
 69825,
 -1,
 559550087,
 69824,
 -56993,
 559497280,
 69821,
 -56992,
 559816447,
 69820,
 -1,
 559877108,
 69819,
 560079265,
 554264376,
 -1,
 560144774,
 560018949,
 -1,
 560210279,
 560086430,
 -1,
 -56987,
 560162613,
 43281,
 -56986,
 560210994,
 43277,
 -1,
 560270167,
 43284,
 560472426,
 560158600,
 -1,
 -56983,
 560408221,
 43294,
 -1,
 560466775,
 43282,
 560669037,
 560419203,
 -1,
 -56980,
 560604829,
 43279,
 -1,
 560663383,
 43278,
 560865648,
 560613269,
 -1,
 -56977,
 560801437,
 43286,
 -1,
 560859991,
 43285,
 561062259,
 560808146,
 -1,
 -56974,
 561004754,
 43301,
 -1,
 561060863,
 43299,
 561258870,
 561000854,
 -1,
 -56971,
 561194653,
 43275,
 -1,
 561253207,
 43274,
 561455481,
 561194631,
 -1,
 -56968,
 561403808,
 43283,
 -1,
 561449815,
 43295,
 -56966,
 561408247,
 43280,
 -56965,
 561604405,
 43291,
 -56964,
 561669159,
 43293,
 -56963,
 561733910,
 43296,
 -56962,
 561794075,
 43290,
 -56961,
 561854762,
 43287,
 -56960,
 561918903,
 43292,
 -56959,
 561982222,
 43300,
 -56958,
 562046002,
 43276,
 -56957,
 562108426,
 43288,
 -56956,
 562172772,
 43297,
 -56955,
 562237835,
 43289,
 -1,
 562301783,
 43298,
 562504084,
 560077143,
 -1,
 562569610,
 562452360,
 -1,
 -56951,
 562521576,
 43266,
 -1,
 562571803,
 43267,
 562766221,
 562516355,
 -1,
 -56948,
 562704530,
 43270,
 -1,
 562765907,
 43271,
 562962832,
 562700734,
 -1,
 -56945,
 562906532,
 43268,
 -1,
 562966623,
 43269,
 -56943,
 562915647,
 43264,
 -56942,
 563102367,
 43265,
 -56941,
 563167073,
 43273,
 -1,
 563224032,
 43272,
 563421594,
 562455410,
 -1,
 563487127,
 563371250,
 43304,
 -1,
 563420159,
 43302,
 563618201,
 563420159,
 43303,
 -1,
 563551231,
 43305,
 -1,
 563560658,
 43306,
 563814814,
 563370659,
 -1,
 563880349,
 563745661,
 43308,
 -1,
 563807085,
 43309,
 -1,
 563825052,
 43307,
 564133887,
 563762060,
 -1,
 -56928,
 564024184,
 43311,
 -1,
 564074459,
 43310,
 564273578,
 560021422,
 -1,
 564339111,
 564220812,
 -1,
 -56924,
 564289480,
 3314,
 -56923,
 564346926,
 3260,
 -56922,
 564408641,
 3313,
 -1,
 564465939,
 3261,
 564666793,
 564290487,
 3298,
 -1,
 564605833,
 3299,
 -1,
 564606509,
 983042,
 -1,
 564221913,
 983944,
 564929263,
 539246802,
 -1,
 564994735,
 564867977,
 -1,
 565060207,
 564926437,
 -1,
 565125631,
 565009447,
 -1,
 565191133,
 565068967,
 -1,
 565256647,
 565119831,
 68608,
 565322172,
 565189631,
 -1,
 -56909,
 565274392,
 68632,
 -56908,
 565335944,
 68677,
 -56907,
 565399939,
 68670,
 -56906,
 565464012,
 68668,
 -56905,
 565525918,
 68644,
 -56904,
 565588873,
 68640,
 -56903,
 565653910,
 68634,
 -56902,
 565715975,
 68623,
 -56901,
 565778403,
 68627,
 -1,
 565842265,
 68619,
 566043070,
 565268867,
 68669,
 -1,
 565978759,
 68671,
 -56897,
 565995288,
 68630,
 -56896,
 566122376,
 68675,
 -56895,
 566184908,
 68666,
 -56894,
 566250206,
 68660,
 -56893,
 566312350,
 68643,
 -56892,
 566375305,
 68638,
 -56891,
 566436871,
 68621,
 -56890,
 566499299,
 68625,
 -1,
 566563161,
 68617,
 566763987,
 565189631,
 -1,
 566829517,
 566705566,
 -1,
 -56886,
 566781720,
 68650,
 -56885,
 566843272,
 68646,
 -56884,
 566895623,
 68653,
 -1,
 566956872,
 68648,
 -56882,
 566782183,
 68628,
 -56881,
 567104125,
 68673,
 -56880,
 567166869,
 68655,
 -56879,
 567228644,
 68642,
 -56878,
 567294095,
 68641,
 -1,
 567350088,
 68658,
 567550425,
 566706386,
 68614,
 567615958,
 567483391,
 68615,
 -1,
 567554454,
 68636,
 -56873,
 567564168,
 68679,
 -56872,
 567691998,
 68664,
 -1,
 567756693,
 68656,
 567943644,
 567487246,
 68611,
 -56869,
 567888606,
 68662,
 -1,
 567939912,
 68657,
 -1,
 567874034,
 68680,
 568262655,
 565143504,
 -1,
 568271345,
 568134487,
 68609,
 568336871,
 568204287,
 68610,
 568402402,
 568278430,
 68645,
 -1,
 568337415,
 68654,
 -56861,
 568354584,
 68633,
 -56860,
 568481672,
 68678,
 -56859,
 568537494,
 68635,
 -56858,
 568599559,
 68624,
 -1,
 568660313,
 68620,
 -56856,
 568289048,
 68631,
 -56855,
 568809352,
 68676,
 -56854,
 568873597,
 68672,
 -56853,
 568937420,
 68667,
 -56852,
 569002718,
 68661,
 -56851,
 569065211,
 68652,
 -56850,
 569127817,
 68639,
 -56849,
 569189383,
 68622,
 -56848,
 569251811,
 68626,
 -1,
 569315673,
 68618,
 569516537,
 568204287,
 68613,
 569582070,
 569458078,
 -1,
 -56844,
 569534232,
 68651,
 -56843,
 569595784,
 68647,
 -1,
 569643848,
 68649,
 -56841,
 569534695,
 68629,
 -56840,
 569791101,
 68674,
 -1,
 569840456,
 68659,
 570040829,
 569458898,
 -1,
 570106364,
 569973759,
 68616,
 -1,
 570044822,
 68637,
 -1,
 570051294,
 68665,
 570359807,
 569977614,
 68612,
 -1,
 570247902,
 68663,
 570434114,
 565070101,
 -1,
 570499641,
 570381196,
 -1,
 570565127,
 570431459,
 -1,
 570630661,
 570493783,
 66477,
 570753023,
 570567423,
 66508,
 -1,
 570623740,
 66509,
 -56826,
 570580210,
 66479,
 -1,
 570764046,
 66478,
 570958347,
 570493783,
 66464,
 571080703,
 570908699,
 66504,
 -56822,
 570959517,
 66506,
 -1,
 571016956,
 66505,
 571220495,
 570906504,
 -1,
 -56819,
 571170034,
 66476,
 -56818,
 571221661,
 66480,
 -1,
 571280215,
 66475,
 571482643,
 571167107,
 -1,
 -56815,
 571429291,
 66498,
 -56814,
 571483805,
 66497,
 -1,
 571542359,
 66495,
 571744791,
 571422948,
 -1,
 -56811,
 571694322,
 66488,
 -56810,
 571747086,
 66487,
 -1,
 571804503,
 66486,
 572006939,
 571674969,
 -1,
 572072474,
 571935575,
 66482,
 -1,
 572007474,
 66510,
 -1,
 572023035,
 66511,
 572269086,
 571958967,
 -1,
 -56803,
 572215995,
 66507,
 -1,
 572263255,
 66471,
 572465697,
 572219656,
 -1,
 -56800,
 572402446,
 66491,
 -1,
 572459863,
 66490,
 572662308,
 572410828,
 -1,
 -56797,
 572611826,
 66493,
 -1,
 572656471,
 66492,
 572858919,
 572603806,
 -1,
 -56794,
 572808434,
 66485,
 -1,
 572853079,
 66484,
 573055530,
 572797334,
 -1,
 -56791,
 573005042,
 66468,
 -1,
 573049687,
 66467,
 573252141,
 572993755,
 -1,
 -56788,
 573188878,
 66474,
 -1,
 573246295,
 66473,
 573448752,
 573187079,
 -1,
 -56785,
 573398258,
 66470,
 -1,
 573442903,
 66469,
 -56783,
 573401335,
 66496,
 -56782,
 573597493,
 66489,
 -56781,
 573660402,
 66466,
 -56780,
 573720537,
 66481,
 -56779,
 573780919,
 66494,
 -56778,
 573844238,
 66465,
 -56777,
 573908637,
 66499,
 -56776,
 573972994,
 66483,
 -1,
 574034788,
 66472,
 574235201,
 570441784,
 -1,
 574300735,
 574183304,
 -1,
 574366270,
 574252018,
 -1,
 -56771,
 574308562,
 66514,
 -1,
 574365430,
 66516,
 -1,
 574299755,
 66515,
 -56768,
 574243487,
 66513,
 -1,
 574565071,
 66517,
 -1,
 574187135,
 66512,
 574881791,
 570381695,
 -1,
 574890602,
 574764549,
 -1,
 574956106,
 574838664,
 -1,
 575021640,
 574891655,
 -1,
 -56761,
 574955502,
 68220,
 -1,
 575017258,
 68219,
 -56759,
 574955502,
 68215,
 -1,
 575148330,
 68201,
 575349328,
 574902659,
 -1,
 575414863,
 575277911,
 -1,
 -56755,
 575362952,
 68202,
 -56754,
 575421259,
 68207,
 -1,
 575477994,
 68206,
 -1,
 575350956,
 68198,
 575742549,
 575281123,
 -1,
 575808084,
 575678109,
 -1,
 -56749,
 575747584,
 68217,
 -1,
 575805674,
 68211,
 -1,
 575737302,
 68213,
 576070232,
 575680918,
 -1,
 -56745,
 576006091,
 68205,
 -1,
 576065264,
 68203,
 576266842,
 576005997,
 68192,
 -1,
 576215280,
 68194,
 576397917,
 576201735,
 -1,
 -56740,
 576335101,
 68212,
 -1,
 576399208,
 68214,
 576594528,
 576326487,
 -1,
 -56737,
 576546875,
 68210,
 -1,
 576599310,
 68209,
 -56735,
 576547096,
 68216,
 -56734,
 576743497,
 68218,
 -56733,
 576808036,
 68197,
 -56732,
 576867781,
 68199,
 -56731,
 576932631,
 68196,
 -56730,
 576995427,
 68204,
 -56729,
 577059678,
 68195,
 -56728,
 577123413,
 68193,
 -56727,
 577184274,
 68208,
 -1,
 577245766,
 68200,
 577503231,
 574832692,
 -1,
 577512046,
 577376799,
 -1,
 -56723,
 577454751,
 68221,
 -1,
 577512068,
 68222,
 -1,
 577445750,
 68223,
 577830911,
 564986018,
 -1,
 577839766,
 577713669,
 -1,
 577905275,
 577768279,
 -1,
 577970807,
 577833815,
 -1,
 -56716,
 577922034,
 7267,
 -56715,
 577976548,
 7266,
 -56714,
 578040214,
 7264,
 -1,
 578105563,
 7265,
 -56712,
 577918856,
 7259,
 -56711,
 578240251,
 7261,
 -56710,
 578302857,
 7262,
 -1,
 578364423,
 7260,
 578560642,
 577844105,
 -1,
 578626174,
 578489175,
 7258,
 -1,
 578554711,
 7263,
 -56705,
 578575602,
 7273,
 -56704,
 578699474,
 7283,
 -56703,
 578759438,
 7268,
 -1,
 578821119,
 7278,
 579019399,
 578510066,
 -1,
 -56700,
 578971416,
 7277,
 -56699,
 579026855,
 7276,
 -56698,
 579082211,
 7275,
 -1,
 579146568,
 7274,
 579347084,
 578961618,
 -1,
 -56695,
 579297544,
 7286,
 -56694,
 579361711,
 7284,
 -56693,
 579413639,
 7287,
 -1,
 579473753,
 7285,
 579674769,
 579283726,
 -1,
 -56690,
 579621251,
 7269,
 -56689,
 579685324,
 7272,
 -56688,
 579747980,
 7271,
 -1,
 579806855,
 7270,
 580059135,
 579607551,
 -1,
 -56685,
 579948733,
 7282,
 -56684,
 580011925,
 7279,
 -56683,
 580074910,
 7281,
 -1,
 580130931,
 7280,
 580330148,
 577771863,
 -1,
 580395674,
 580278152,
 -1,
 -56679,
 580347368,
 7250,
 -1,
 580397595,
 7251,
 580592285,
 580342147,
 -1,
 -56676,
 580530322,
 7254,
 -1,
 580591699,
 7255,
 580788896,
 580526526,
 -1,
 -56673,
 580732324,
 7252,
 -1,
 580792415,
 7253,
 -56671,
 580741439,
 7248,
 -56670,
 580928159,
 7249,
 -56669,
 580992865,
 7257,
 -1,
 581049824,
 7256,
 581247657,
 580274069,
 -1,
 581313192,
 581197571,
 -1,
 -56665,
 581254405,
 7294,
 -1,
 581311270,
 7295,
 -1,
 581248672,
 7292,
 581575340,
 581188866,
 -1,
 -56661,
 581502783,
 7290,
 -1,
 581567940,
 7288,
 -56659,
 581520745,
 7291,
 -56658,
 581706805,
 7289,
 -1,
 581766421,
 7293,
 581968608,
 564942128,
 -1,
 582034130,
 581907973,
 -1,
 582099636,
 581962583,
 66710,
 -56653,
 582038798,
 66688,
 -1,
 582093655,
 66715,
 582296247,
 582046083,
 -1,
 -56650,
 582232216,
 66697,
 -1,
 582290263,
 66696,
 582492857,
 582238418,
 66713,
 -1,
 582435026,
 66717,
 582623932,
 582431126,
 -1,
 -56645,
 582559389,
 66693,
 -1,
 582618050,
 66703,
 582820542,
 582556671,
 66711,
 -1,
 582753279,
 66716,
 582951617,
 582752227,
 -1,
 -56640,
 582887069,
 66698,
 -1,
 582950214,
 66694,
 -56638,
 582903605,
 66709,
 -56637,
 583100121,
 66692,
 -56636,
 583165028,
 66707,
 -56635,
 583228658,
 66714,
 -56634,
 583292832,
 66690,
 -56633,
 583355419,
 66695,
 -56632,
 583420655,
 66702,
 -56631,
 583483517,
 66706,
 -56630,
 583547843,
 66705,
 -56629,
 583611335,
 66704,
 -56628,
 583676153,
 66691,
 -56627,
 583740174,
 66712,
 -56626,
 583804573,
 66708,
 -56625,
 583869490,
 66700,
 -56624,
 583934466,
 66701,
 -56623,
 583996434,
 66699,
 -1,
 584061323,
 66689,
 584318975,
 581966167,
 -1,
 584327894,
 584210312,
 -1,
 -56619,
 584279528,
 66722,
 -1,
 584329755,
 66723,
 584524505,
 584274307,
 -1,
 -56616,
 584462482,
 66726,
 -1,
 584523859,
 66727,
 584721116,
 584458686,
 -1,
 -56613,
 584664484,
 66724,
 -1,
 584724575,
 66725,
 -56611,
 584673599,
 66720,
 -56610,
 584860319,
 66721,
 -56609,
 584925025,
 66729,
 -1,
 584981984,
 66728,
 585179882,
 581913548,
 -1,
 585245417,
 585117897,
 -1,
 585310950,
 585196451,
 -1,
 585376485,
 585249673,
 2914,
 -1,
 585315209,
 2915,
 -1,
 585322685,
 2884,
 585629695,
 585250309,
 -1,
 -56600,
 585524263,
 2929,
 -1,
 585589014,
 2869,
 -1,
 585172530,
 10183,
 585835245,
 585124010,
 -1,
 -56596,
 585779445,
 10180,
 -1,
 585831186,
 10179,
 -56594,
 585785573,
 9885,
 -1,
 585973350,
 11819,
 586163223,
 564857687,
 -1,
 586228601,
 586107942,
 -1,
 586294131,
 586153984,
 -1,
 586359629,
 586232713,
 -1,
 586425164,
 586293262,
 -1,
 586490626,
 586359230,
 -1,
 586556159,
 586420180,
 -1,
 586621691,
 586490165,
 -1,
 586687226,
 586569608,
 -1,
 -56583,
 586638831,
 1909,
 -1,
 586689062,
 1910,
 -1,
 586621782,
 1911,
 586949374,
 586569608,
 -1,
 -56579,
 586901009,
 1598,
 -1,
 586951239,
 1599,
 -1,
 586886960,
 1597,
 587268095,
 586489280,
 -1,
 -56575,
 587163167,
 1888,
 -1,
 587213450,
 1889,
 587408142,
 586425991,
 -1,
 587473677,
 587336972,
 -1,
 587539209,
 587420757,
 -1,
 587604744,
 587467607,
 -1,
 -56569,
 587546175,
 1903,
 -1,
 587600628,
 1906,
 -1,
 587534867,
 1902,
 587866892,
 587487112,
 -1,
 -56565,
 587818513,
 1879,
 -1,
 587868810,
 1880,
 -1,
 587800953,
 1916,
 -1,
 587406765,
 1791,
 588194584,
 587338249,
 -1,
 588260117,
 588142472,
 -1,
 588325652,
 588196412,
 -1,
 588391187,
 588270054,
 1874,
 -1,
 588316767,
 1875,
 -1,
 588327348,
 1872,
 -1,
 588277293,
 1876,
 -56554,
 588207343,
 1878,
 -56553,
 588590873,
 1877,
 -1,
 588651030,
 1873,
 588849954,
 588132758,
 -1,
 588915489,
 588783050,
 -1,
 588981024,
 588863368,
 -1,
 589046559,
 588917308,
 -1,
 -56547,
 588990950,
 1892,
 -56546,
 589042195,
 1596,
 -1,
 589106182,
 1891,
 -1,
 588998161,
 1595,
 -1,
 588913119,
 1890,
 -1,
 588844221,
 1919,
 589505320,
 588796505,
 -1,
 -56540,
 589454475,
 1901,
 -56539,
 589517934,
 1904,
 -56538,
 589573936,
 1918,
 -56537,
 589636493,
 1884,
 -1,
 589701458,
 1917,
 589898543,
 589450591,
 -1,
 589964076,
 589844867,
 -1,
 -56533,
 589912997,
 1883,
 -1,
 589969831,
 1905,
 -56531,
 589913227,
 1899,
 -56530,
 590098224,
 1775,
 -1,
 590161643,
 1900,
 590357304,
 589826903,
 -1,
 590422837,
 590294324,
 -1,
 590488372,
 590374408,
 -1,
 -56525,
 590439080,
 1887,
 -1,
 590482438,
 1885,
 -1,
 590424679,
 1886,
 590807039,
 590361874,
 -1,
 -56521,
 590702063,
 1907,
 -1,
 590752294,
 1908,
 590947133,
 590299064,
 -1,
 591012668,
 590894158,
 -1,
 -56517,
 590962952,
 1897,
 -1,
 591026123,
 1896,
 -1,
 590961788,
 1895,
 591274818,
 590878759,
 -1,
 591340353,
 591212218,
 -1,
 -56512,
 591290632,
 1774,
 -1,
 591353093,
 1882,
 -1,
 591289509,
 1881,
 591602501,
 591226780,
 -1,
 -56508,
 591554031,
 1914,
 -1,
 591604262,
 1915,
 591799112,
 591553640,
 -1,
 -56505,
 591750639,
 1912,
 -1,
 591800870,
 1913,
 591995723,
 591739708,
 -1,
 -56502,
 591925779,
 1894,
 -1,
 591989766,
 1893,
 -1,
 591934525,
 1898,
 -1,
 586361936,
 65021,
 592323426,
 586305923,
 -1,
 592388953,
 592260272,
 -1,
 592454483,
 592335275,
 -1,
 -56495,
 592395766,
 1537,
 -56494,
 592459564,
 1552,
 -1,
 592519805,
 1539,
 592716630,
 592399387,
 -1,
 -56491,
 592652560,
 1554,
 -1,
 592713969,
 1555,
 -56489,
 592664558,
 1556,
 -56488,
 592854040,
 1551,
 -1,
 592907684,
 1553,
 593109857,
 592329114,
 -1,
 593175390,
 593045569,
 -1,
 -56484,
 593127678,
 1559,
 -56483,
 593188811,
 1557,
 -1,
 593245820,
 1558,
 -56481,
 593113643,
 1562,
 -56480,
 593371660,
 1560,
 -1,
 593434686,
 1561,
 -1,
 593059307,
 1622,
 593699686,
 592274313,
 -1,
 -56476,
 593646839,
 1626,
 -56475,
 593702658,
 1627,
 -1,
 593762828,
 1628,
 593961833,
 593644492,
 -1,
 -56472,
 593895618,
 1629,
 -1,
 593957179,
 1544,
 594158444,
 593895870,
 -1,
 -56469,
 594101097,
 1538,
 -1,
 594153575,
 1630,
 -56467,
 594110919,
 1625,
 -56466,
 594303881,
 1566,
 -56465,
 594364871,
 1550,
 -56464,
 594427968,
 1536,
 -56463,
 594492013,
 1624,
 -56462,
 594554585,
 1623,
 -1,
 594614372,
 1549,
 594870271,
 586221400,
 -1,
 594879351,
 594757853,
 -1,
 -56458,
 594827391,
 1546,
 -1,
 594885581,
 1545,
 -56456,
 594813853,
 1543,
 -1,
 595007402,
 1542,
 595207113,
 586161568,
 -1,
 595272632,
 595148856,
 -1,
 595338124,
 595220360,
 -1,
 595403651,
 595289074,
 -1,
 595469185,
 595345618,
 65800,
 595591167,
 595394560,
 -1,
 -56448,
 595483004,
 65827,
 -1,
 595536591,
 65818,
 595787775,
 595402486,
 65809,
 -1,
 595657979,
 65836,
 595862410,
 595338887,
 -1,
 595927944,
 595807556,
 65801,
 596049919,
 595853312,
 -1,
 -56441,
 595941756,
 65828,
 -1,
 595995343,
 65819,
 596246527,
 595865491,
 65810,
 -1,
 596116731,
 65837,
 596377599,
 595795563,
 65808,
 -1,
 596247803,
 65835,
 596452249,
 595284355,
 -1,
 596517779,
 596390034,
 65804,
 596583312,
 596466927,
 65813,
 -1,
 596509947,
 65840,
 596770815,
 596508672,
 -1,
 -56430,
 596662652,
 65831,
 -1,
 596716239,
 65822,
 596967423,
 596451411,
 65805,
 596976534,
 596860143,
 65814,
 -1,
 596903163,
 65841,
 597164031,
 596901888,
 -1,
 -56424,
 597055868,
 65832,
 -1,
 597109455,
 65823,
 597304232,
 596386238,
 -1,
 597369761,
 597246162,
 -1,
 597435295,
 597319693,
 65802,
 597557247,
 597360640,
 -1,
 -56418,
 597449084,
 65829,
 -1,
 597502671,
 65820,
 597753855,
 597381392,
 65811,
 -1,
 597624059,
 65838,
 597884927,
 597306126,
 -1,
 597894054,
 597778888,
 65803,
 598015999,
 597819392,
 -1,
 -56411,
 597907836,
 65830,
 -1,
 597961423,
 65821,
 598212607,
 597828594,
 65812,
 -1,
 598082811,
 65839,
 598287278,
 597245793,
 65807,
 598352811,
 598236399,
 65816,
 -1,
 598279419,
 65843,
 598540287,
 598278144,
 -1,
 -56403,
 598432124,
 65834,
 -1,
 598485711,
 65825,
 598680500,
 598220256,
 65806,
 598746033,
 598632216,
 65815,
 -1,
 598672635,
 65842,
 598933503,
 598671360,
 -1,
 -56397,
 598825340,
 65833,
 -1,
 598878927,
 65824,
 599130111,
 598622879,
 65799,
 599195647,
 598999040,
 -1,
 -56393,
 599087484,
 65826,
 -1,
 599141071,
 65817,
 599335875,
 595223538,
 -1,
 599401408,
 599268838,
 -1,
 599466941,
 599335358,
 -1,
 -56388,
 599410136,
 65851,
 -1,
 599469958,
 65848,
 -56386,
 599415126,
 65850,
 -56385,
 599609899,
 65849,
 -1,
 599658984,
 65847,
 599916543,
 599344190,
 -1,
 -56382,
 599799469,
 65792,
 -1,
 599857622,
 65793,
 600056774,
 599276331,
 -1,
 -56379,
 600004950,
 65855,
 -1,
 600068651,
 65854,
 -56377,
 599996123,
 65853,
 -56376,
 600185760,
 65852,
 -1,
 600249462,
 65794,
 600450062,
 595157698,
 -1,
 600515597,
 600389125,
 -1,
 600581075,
 600443735,
 68352,
 600646607,
 600509271,
 68353,
 -56370,
 600588498,
 68355,
 -1,
 600653214,
 68357,
 600843217,
 600579071,
 68358,
 -1,
 600775679,
 68359,
 -56366,
 600785106,
 68354,
 -1,
 600915358,
 68356,
 601105371,
 600522142,
 -1,
 601170904,
 601039879,
 -1,
 -56362,
 601122693,
 68387,
 -56361,
 601186760,
 68388,
 -1,
 601234431,
 68386,
 -56359,
 601122693,
 68390,
 -56358,
 601374303,
 68391,
 -1,
 601431039,
 68389,
 601629665,
 601051523,
 -1,
 601695199,
 601564807,
 -1,
 -56354,
 601646981,
 68403,
 -1,
 601693183,
 68401,
 -56352,
 601641731,
 68404,
 -1,
 601824255,
 68399,
 602022885,
 601581239,
 -1,
 -56349,
 601974661,
 68370,
 -56348,
 602038728,
 68371,
 -1,
 602086399,
 68369,
 602285033,
 601970568,
 -1,
 -56345,
 602232918,
 68381,
 -56344,
 602285933,
 68378,
 -1,
 602348543,
 68377,
 602547181,
 602219527,
 -1,
 -56341,
 602482541,
 68374,
 -56340,
 602547454,
 68373,
 -1,
 602610687,
 68372,
 602809328,
 602499303,
 -1,
 -56337,
 602744685,
 68402,
 -1,
 602807295,
 68400,
 603005939,
 602760984,
 -1,
 -56334,
 602957701,
 68394,
 -1,
 603003903,
 68395,
 603202549,
 602954994,
 68366,
 -1,
 603151602,
 68367,
 603333623,
 603144402,
 68362,
 -1,
 603275474,
 68363,
 603464697,
 603269902,
 68364,
 -1,
 603400974,
 68365,
 603595772,
 603399815,
 -1,
 -56325,
 603536128,
 68393,
 -1,
 603593727,
 68405,
 603792382,
 603528191,
 68360,
 -1,
 603724799,
 68361,
 603923457,
 603723747,
 -1,
 -56320,
 603858797,
 68380,
 -1,
 603921407,
 68379,
 604120068,
 603853145,
 -1,
 -56317,
 604055405,
 68385,
 -1,
 604118015,
 68384,
 -56315,
 604070344,
 68396,
 -56314,
 604261610,
 68397,
 -56313,
 604326015,
 68382,
 -56312,
 604388096,
 68392,
 -56311,
 604452063,
 68398,
 -56310,
 604516960,
 68368,
 -56309,
 604582154,
 68376,
 -56308,
 604643858,
 68383,
 -1,
 604705840,
 68375,
 -1,
 600443874,
 68409,
 604972049,
 600388489,
 -1,
 -56304,
 604920007,
 9941,
 -1,
 604970567,
 9879,
 -56302,
 604922042,
 8371,
 -56301,
 605117068,
 9883,
 -56300,
 605175349,
 9875,
 -56299,
 605238099,
 8525,
 -56298,
 605299313,
 1547,
 -1,
 605360980,
 9190,
 605562177,
 586098311,
 -1,
 605627584,
 605490007,
 -1,
 605693119,
 605568816,
 -1,
 605758609,
 605630683,
 -1,
 605824104,
 605700897,
 -1,
 605889585,
 605770115,
 -1,
 605955112,
 605835743,
 -1,
 606020640,
 605903321,
 55245,
 -1,
 605947766,
 55246,
 606151715,
 605967321,
 -1,
 -56286,
 606099929,
 55277,
 -1,
 606155500,
 55276,
 -56284,
 606097009,
 55255,
 -56283,
 606292306,
 55270,
 -56282,
 606355266,
 4607,
 -56281,
 606419882,
 55264,
 -1,
 606475510,
 55289,
 606732287,
 605892415,
 -1,
 606741548,
 606606152,
 -1,
 -56277,
 606678031,
 55279,
 -1,
 606742541,
 55280,
 -56275,
 606689592,
 55281,
 -56274,
 606881839,
 55278,
 -56273,
 606944170,
 55274,
 -56272,
 607007249,
 55275,
 -1,
 607070228,
 55282,
 607265856,
 605833109,
 -1,
 607331386,
 607202331,
 -1,
 607396918,
 607261512,
 -1,
 -56267,
 607333391,
 55272,
 -1,
 607397901,
 55273,
 -56265,
 607345113,
 55267,
 -56264,
 607540215,
 55271,
 -56263,
 607604351,
 55268,
 -1,
 607665066,
 55269,
 607855677,
 607266860,
 -1,
 -56260,
 607803704,
 55291,
 -1,
 607867860,
 55290,
 608108543,
 607784637,
 -1,
 -56257,
 607996242,
 55283,
 -1,
 608055825,
 55284,
 608248906,
 607211114,
 -1,
 608314436,
 608200581,
 -1,
 -56253,
 608260992,
 55259,
 -1,
 608322674,
 55260,
 608511047,
 608258392,
 -1,
 -56250,
 608459225,
 55257,
 -1,
 608520499,
 55258,
 -56248,
 608458263,
 55253,
 -56247,
 608648119,
 55256,
 -1,
 608711411,
 55254,
 608904274,
 608197088,
 -1,
 608969805,
 608850900,
 55248,
 -1,
 608896864,
 55249,
 609100880,
 608899912,
 -1,
 -56241,
 609037327,
 55250,
 -1,
 609101837,
 55251,
 -56239,
 609048888,
 55252,
 -1,
 609241426,
 55247,
 609428570,
 608842134,
 -1,
 609494105,
 609366228,
 -1,
 -56235,
 609438034,
 4603,
 -56234,
 609500994,
 4602,
 -56233,
 609563313,
 4605,
 -56232,
 609626132,
 4606,
 -1,
 609686678,
 4604,
 -1,
 609423138,
 55261,
 609952863,
 609369008,
 -1,
 -56228,
 609900067,
 55263,
 -56227,
 609962335,
 55265,
 -56226,
 610025282,
 55262,
 -1,
 610079990,
 55266,
 610280546,
 609904626,
 -1,
 -56223,
 610220970,
 55285,
 -1,
 610281492,
 55286,
 610477157,
 610221896,
 -1,
 -56220,
 610422372,
 55243,
 -1,
 610473110,
 55244,
 610729983,
 610407676,
 -1,
 -56217,
 610620974,
 55288,
 -1,
 610683218,
 55287,
 610926591,
 605773648,
 -1,
 610935924,
 610806589,
 -1,
 611001458,
 610887448,
 -1,
 611066989,
 610933759,
 55232,
 -1,
 611008722,
 55231,
 611198064,
 610995031,
 -1,
 -56209,
 611130367,
 55230,
 -1,
 611190643,
 55229,
 -56207,
 611146994,
 55235,
 -1,
 611336402,
 55234,
 -56205,
 610943233,
 55233,
 -1,
 611461902,
 55236,
 611656830,
 610887448,
 -1,
 611722361,
 611598590,
 -1,
 611787896,
 611650391,
 55218,
 -1,
 611720191,
 55219,
 -1,
 611720976,
 55220,
 611984508,
 611671357,
 -1,
 -56197,
 611926226,
 55224,
 -1,
 611978377,
 55223,
 -56195,
 611917587,
 4517,
 -1,
 612109234,
 4516,
 612312196,
 611598590,
 -1,
 612377731,
 612263704,
 -1,
 612443266,
 612305751,
 4518,
 -1,
 612375551,
 4519,
 -1,
 612376336,
 55216,
 -1,
 612319489,
 55217,
 612705417,
 612245549,
 -1,
 612770951,
 612637695,
 55227,
 -1,
 612712658,
 55226,
 -56184,
 612712658,
 55228,
 -1,
 612830039,
 55225,
 613033102,
 612633431,
 -1,
 613098637,
 612977729,
 -1,
 -56180,
 613030911,
 55238,
 -1,
 613092183,
 55237,
 -1,
 613025575,
 4515,
 613416959,
 612982077,
 -1,
 -56176,
 613312473,
 55221,
 -1,
 613362496,
 55222,
 613613567,
 605689002,
 -1,
 613622945,
 613502570,
 -1,
 613688473,
 613568899,
 -1,
 613754008,
 613634527,
 -1,
 -56170,
 613702105,
 43367,
 -56169,
 613763410,
 43370,
 -1,
 613823212,
 43365,
 -1,
 613691195,
 43372,
 614081693,
 613626262,
 -1,
 -56165,
 614019278,
 43364,
 -56164,
 614082597,
 43374,
 -1,
 614141717,
 43371,
 -56162,
 614029785,
 43366,
 -56161,
 614287698,
 43369,
 -56160,
 614349738,
 43368,
 -1,
 614405366,
 43373,
 614605991,
 613571040,
 -1,
 -56157,
 614552532,
 43362,
 -56156,
 614616676,
 4446,
 -56155,
 614680914,
 43361,
 -56154,
 614742954,
 43360,
 -1,
 614798582,
 43363,
 614999212,
 614553105,
 -1,
 -56151,
 614950877,
 43388,
 -56150,
 615012664,
 43385,
 -56149,
 615076831,
 43381,
 -1,
 615126275,
 43384,
 615326898,
 614942613,
 -1,
 615392433,
 615263259,
 -1,
 -56145,
 615338986,
 43378,
 -56144,
 615396017,
 43379,
 -1,
 615458836,
 43380,
 -1,
 615327796,
 43386,
 615720118,
 615268168,
 -1,
 -56140,
 615666644,
 4443,
 -56139,
 615720980,
 4445,
 -1,
 615781622,
 4444,
 615982266,
 615660464,
 -1,
 -56136,
 615930329,
 43376,
 -56135,
 615994324,
 43377,
 -1,
 616051436,
 43375,
 616244413,
 615918612,
 -1,
 -56132,
 616189540,
 43382,
 -1,
 616245268,
 43383,
 -56130,
 616182528,
 4442,
 -1,
 616376346,
 43387,
 -1,
 605633578,
 9874,
 616637749,
 605559807,
 -1,
 616703264,
 616589020,
 -1,
 616768727,
 616650632,
 -1,
 616834262,
 616703856,
 -1,
 616899784,
 616764232,
 -1,
 -56122,
 616844550,
 19904,
 -56121,
 616904398,
 19933,
 -1,
 616960252,
 19953,
 617161933,
 616827735,
 -1,
 617227468,
 617106380,
 -1,
 -56117,
 617170406,
 19954,
 -1,
 617233806,
 19910,
 -1,
 617157435,
 19932,
 617489616,
 617112562,
 -1,
 -56113,
 617422378,
 19951,
 -1,
 617483916,
 19959,
 -56111,
 617434398,
 19905,
 -56110,
 617626238,
 19957,
 -56109,
 617689706,
 19955,
 -56108,
 617754991,
 19961,
 -56107,
 617817375,
 19960,
 -1,
 617882117,
 19940,
 -1,
 616778989,
 19913,
 618144993,
 616699875,
 -1,
 618210524,
 618077183,
 -1,
 -56102,
 618160648,
 19956,
 -56101,
 618215181,
 19943,
 -1,
 618272463,
 19944,
 618472671,
 618146574,
 -1,
 -56098,
 618419618,
 19962,
 -1,
 618472018,
 19906,
 -56096,
 618422319,
 19935,
 -1,
 618598276,
 19939,
 618800364,
 618079239,
 -1,
 618865899,
 618744780,
 -1,
 618931434,
 618798278,
 -1,
 618996969,
 618874773,
 -1,
 619062504,
 618938578,
 -1,
 -56089,
 619013312,
 19937,
 -1,
 619075129,
 19917,
 -1,
 619007355,
 19931,
 -1,
 618944554,
 19929,
 -1,
 618859574,
 19925,
 -1,
 618795182,
 19948,
 619521266,
 618746243,
 -1,
 619586800,
 619461018,
 -1,
 -56081,
 619534378,
 19912,
 -1,
 619596361,
 19965,
 -56079,
 619534385,
 19915,
 -1,
 619727245,
 19926,
 619914488,
 619457837,
 -1,
 619980022,
 619855262,
 -1,
 -56075,
 619921720,
 19928,
 -1,
 619978600,
 19964,
 -56073,
 619914024,
 19934,
 -1,
 620107471,
 19945,
 620307709,
 619859178,
 -1,
 620373244,
 620255112,
 -1,
 -56069,
 620322897,
 19927,
 -1,
 620383489,
 19936,
 -1,
 620323666,
 19952,
 620635393,
 620251029,
 -1,
 -56065,
 620585067,
 19949,
 -56064,
 620646515,
 19938,
 -1,
 620698752,
 19914,
 620897542,
 620576978,
 -1,
 620963077,
 620841492,
 -1,
 -56060,
 620907986,
 19950,
 -1,
 620971257,
 19941,
 -1,
 620892951,
 19942,
 621225227,
 620828169,
 -1,
 621290762,
 621165982,
 -1,
 -56055,
 621238379,
 19923,
 -1,
 621290265,
 19909,
 -1,
 621231077,
 19947,
 621552911,
 621154649,
 -1,
 -56051,
 621497589,
 19946,
 -56050,
 621555769,
 19924,
 -1,
 621616492,
 19967,
 621815059,
 621480791,
 -1,
 -56047,
 621759029,
 19922,
 -56046,
 621814754,
 19966,
 -1,
 621876006,
 19958,
 622077206,
 621765618,
 -1,
 -56043,
 622019732,
 19921,
 -1,
 622071138,
 19908,
 622273817,
 622017625,
 -1,
 -56040,
 622223571,
 19930,
 -1,
 622270680,
 19918,
 622470428,
 622207422,
 -1,
 -56037,
 622412361,
 19920,
 -1,
 622468654,
 19916,
 -56035,
 622422094,
 19907,
 -56034,
 622605986,
 19963,
 -56033,
 622668099,
 19911,
 -1,
 622730974,
 19919,
 622929196,
 616631127,
 -1,
 622994731,
 622879720,
 -1,
 623060263,
 622925093,
 11096,
 623125798,
 622986724,
 -1,
 -56027,
 623072985,
 9955,
 -1,
 623121708,
 11095,
 -1,
 623056885,
 11097,
 -56024,
 623011089,
 9947,
 -56023,
 623330823,
 11094,
 -56022,
 623391836,
 11093,
 -1,
 623452445,
 10071,
 -1,
 622926778,
 9980,
 623715636,
 622859020,
 -1,
 623781170,
 623658901,
 -1,
 623846705,
 623722984,
 -1,
 -56016,
 623790836,
 1479,
 -1,
 623847727,
 1466,
 -1,
 623795983,
 1478,
 -56013,
 623721054,
 1477,
 -1,
 624036898,
 1442,
 -1,
 623654782,
 9937,
 624305466,
 616579282,
 -1,
 624371001,
 624250893,
 -1,
 -56008,
 624310660,
 9897,
 -1,
 624366248,
 11043,
 -1,
 624318354,
 9749,
 624633149,
 624257130,
 -1,
 -56004,
 624574802,
 11794,
 -1,
 624633747,
 11802,
 624829760,
 624569102,
 -1,
 -56001,
 624776837,
 9964,
 -1,
 624829777,
 9889,
 -1,
 624775543,
 8372,
 625092146,
 605505429,
 -1,
 625157619,
 625026695,
 -1,
 625223118,
 625085271,
 -1,
 625288590,
 625157713,
 -1,
 625354114,
 625227269,
 -1,
 625419599,
 625301384,
 -1,
 625485130,
 625366920,
 -1,
 -55991,
 625419933,
 43114,
 -1,
 625478487,
 43113,
 625681741,
 625430915,
 -1,
 -55988,
 625616541,
 43089,
 -1,
 625675095,
 43088,
 -55986,
 625616541,
 43081,
 -1,
 625806167,
 43080,
 626009428,
 625360286,
 -1,
 -55983,
 625960757,
 43079,
 -55982,
 626015695,
 43116,
 -55981,
 626074674,
 43075,
 -1,
 626133847,
 43083,
 626337112,
 625955203,
 -1,
 -55978,
 626276768,
 43094,
 -55977,
 626337437,
 43098,
 -1,
 626395991,
 43099,
 626599260,
 626268131,
 -1,
 -55974,
 626551031,
 43090,
 -55973,
 626595850,
 43115,
 -1,
 626658135,
 43082,
 626861408,
 626529096,
 -1,
 626926943,
 626789207,
 43076,
 -1,
 626867797,
 43123,
 -1,
 626861725,
 43077,
 627123555,
 626789207,
 43101,
 -55966,
 627070386,
 43120,
 -1,
 627128466,
 43117,
 627320166,
 627075303,
 -1,
 -55963,
 627254941,
 43092,
 -1,
 627313495,
 43093,
 627516777,
 627270451,
 -1,
 -55960,
 627455470,
 43118,
 -1,
 627513320,
 43119,
 627713388,
 627459989,
 -1,
 -55957,
 627648157,
 43085,
 -1,
 627706711,
 43084,
 627909999,
 627650966,
 -1,
 -55954,
 627844765,
 43073,
 -1,
 627903319,
 43072,
 628106610,
 627844103,
 -1,
 -55951,
 628040754,
 43109,
 -1,
 628099927,
 43074,
 628303220,
 628038655,
 43104,
 -1,
 628235263,
 43110,
 -55947,
 628254517,
 43095,
 -55946,
 628385497,
 43107,
 -55945,
 628450343,
 43091,
 -55944,
 628514034,
 43103,
 -55943,
 628575259,
 43096,
 -55942,
 628640492,
 43106,
 -55941,
 628703442,
 43105,
 -55940,
 628767018,
 43087,
 -55939,
 628831159,
 43097,
 -55938,
 628895993,
 43078,
 -55937,
 628960014,
 43102,
 -55936,
 629024413,
 43100,
 -55935,
 629088770,
 43108,
 -1,
 629150091,
 43086,
 629351818,
 625299843,
 -1,
 629417353,
 629300466,
 -1,
 629482888,
 629346943,
 -1,
 -55930,
 629434165,
 43112,
 -55929,
 629498919,
 43111,
 -1,
 629558299,
 43121,
 -1,
 629426402,
 43122,
 -1,
 629353942,
 43124,
 629876109,
 629291608,
 -1,
 -55924,
 629822151,
 43126,
 -1,
 629873460,
 43127,
 -1,
 629807893,
 43125,
 630194175,
 625225683,
 -1,
 630203802,
 630068040,
 -1,
 630269332,
 630145234,
 -1,
 630334867,
 630209175,
 66020,
 -1,
 630271468,
 66045,
 -1,
 630274243,
 66022,
 630531480,
 630197079,
 -1,
 -55914,
 630478728,
 66028,
 -55913,
 630542511,
 66018,
 -1,
 630606493,
 66003,
 -55911,
 630470829,
 66012,
 -1,
 630728861,
 66004,
 630924706,
 630149507,
 -1,
 630990238,
 630859757,
 -1,
 -55907,
 630933397,
 66024,
 -1,
 630988322,
 66011,
 -55905,
 630938379,
 66042,
 -55904,
 631126475,
 66043,
 -55903,
 631191241,
 66021,
 -1,
 631247146,
 66015,
 631449001,
 630853977,
 -1,
 631514534,
 631390418,
 -1,
 -55899,
 631464946,
 66010,
 -1,
 631521909,
 66017,
 631711144,
 631446829,
 66033,
 -1,
 631646436,
 66023,
 -1,
 631660167,
 66027,
 631907759,
 631392149,
 -1,
 631973293,
 631845769,
 -1,
 -55892,
 631922372,
 66001,
 -1,
 631967380,
 66034,
 -55890,
 631905551,
 66000,
 -1,
 632098607,
 66036,
 632300979,
 631854984,
 -1,
 -55887,
 632250231,
 66032,
 -55886,
 632302506,
 66008,
 -1,
 632361191,
 66002,
 632563127,
 632235655,
 -1,
 -55883,
 632505519,
 66025,
 -55882,
 632564684,
 66026,
 -1,
 632626744,
 66006,
 632825274,
 632513522,
 -1,
 -55879,
 632767072,
 66005,
 -1,
 632820001,
 66044,
 633021885,
 632769484,
 -1,
 -55876,
 632964338,
 66037,
 -1,
 633015853,
 66029,
 633218496,
 632961322,
 -1,
 -55873,
 633166814,
 66014,
 -1,
 633224669,
 66013,
 633415107,
 633157241,
 -1,
 -55870,
 633354460,
 66038,
 -1,
 633411555,
 66016,
 633611718,
 633349127,
 -1,
 -55867,
 633556159,
 66041,
 -1,
 633606404,
 66007,
 633808329,
 633543108,
 -1,
 -55864,
 633758152,
 66031,
 -1,
 633812744,
 66019,
 -55862,
 633758441,
 66035,
 -55861,
 633948038,
 66039,
 -55860,
 634004272,
 66040,
 -55859,
 634068101,
 66030,
 -1,
 634130363,
 66009,
 634388479,
 625164655,
 -1,
 634398185,
 634271237,
 -1,
 634463700,
 634343811,
 -1,
 -55854,
 634398892,
 67860,
 -55853,
 634461773,
 67854,
 -1,
 634522743,
 67857,
 634725847,
 634410888,
 -1,
 -55850,
 634658779,
 67848,
 -1,
 634720500,
 67861,
 634922457,
 634660717,
 67844,
 -1,
 634869640,
 67847,
 635053532,
 634850135,
 -1,
 -55845,
 634992235,
 67840,
 -1,
 635055405,
 67855,
 -55843,
 635005178,
 67846,
 -55842,
 635201605,
 67849,
 -55841,
 635266144,
 67845,
 -55840,
 635326607,
 67859,
 -55839,
 635390734,
 67858,
 -55838,
 635455615,
 67856,
 -55837,
 635519075,
 67853,
 -55836,
 635583326,
 67852,
 -55835,
 635647050,
 67851,
 -55834,
 635711974,
 67850,
 -55833,
 635774076,
 67842,
 -55832,
 635836581,
 67843,
 -1,
 635900470,
 67841,
 636102130,
 634339384,
 -1,
 636167664,
 636049288,
 -1,
 636233198,
 636118002,
 -1,
 -55827,
 636174546,
 67866,
 -1,
 636231414,
 67864,
 -55825,
 636168731,
 67867,
 -1,
 636362347,
 67863,
 636616703,
 636109471,
 67862,
 -1,
 636485992,
 67865,
 -1,
 636053132,
 67871,
 636757529,
 625085271,
 -1,
 636823062,
 636701644,
 -1,
 636888596,
 636755666,
 -1,
 636954129,
 636826749,
 -1,
 -55816,
 636905703,
 127273,
 -55815,
 636970776,
 127272,
 -55814,
 637036215,
 127271,
 -55813,
 637101042,
 127270,
 -55812,
 637165832,
 127269,
 -55811,
 637230322,
 127268,
 -55810,
 637294472,
 127267,
 -55809,
 637358467,
 127266,
 -55808,
 637422540,
 127265,
 -55807,
 637487838,
 127264,
 -55806,
 637552533,
 127263,
 -55805,
 637616338,
 127262,
 -55804,
 637681054,
 127261,
 -55803,
 637745380,
 127260,
 -55802,
 637809545,
 127259,
 -55801,
 637874582,
 127258,
 -55800,
 637939931,
 127257,
 -55799,
 638003982,
 127256,
 -55798,
 638068359,
 127255,
 -55797,
 638133255,
 127254,
 -55796,
 638198206,
 127253,
 -55795,
 638262271,
 127252,
 -55794,
 638326755,
 127251,
 -55793,
 638391112,
 127250,
 -55792,
 638456153,
 127249,
 -1,
 638520151,
 127248,
 638779391,
 636891964,
 -1,
 -55789,
 638660897,
 12829,
 -1,
 638714212,
 12830,
 -55787,
 636836472,
 12880,
 -1,
 638848259,
 11791,
 639107071,
 636760969,
 -1,
 -55784,
 638990576,
 11801,
 -1,
 639054963,
 9908,
 639247916,
 636702118,
 -1,
 639313439,
 639192727,
 -1,
 639378974,
 639264046,
 -1,
 -55779,
 639316571,
 65048,
 -1,
 639374760,
 983049,
 -1,
 639325647,
 65096,
 639641122,
 639251774,
 -1,
 -55775,
 639591747,
 65047,
 -1,
 639653327,
 65095,
 639837733,
 639577050,
 -1,
 -55772,
 639771638,
 65042,
 -1,
 639833668,
 65041,
 640034344,
 639768073,
 -1,
 -55769,
 639974438,
 65040,
 -1,
 640038837,
 65043,
 -55767,
 639980132,
 65044,
 -55766,
 640174997,
 65046,
 -55765,
 640231840,
 65049,
 -1,
 640295180,
 65045,
 640493105,
 639180623,
 -1,
 -55762,
 640439649,
 9977,
 -55761,
 640501937,
 10178,
 -55760,
 640563755,
 9854,
 -1,
 640615606,
 8524,
 -1,
 640428984,
 9935,
 640886547,
 625032606,
 -1,
 640951985,
 640818175,
 -1,
 641017505,
 640902157,
 -1,
 641083000,
 640955909,
 -1,
 641148499,
 641021985,
 -1,
 641214011,
 641095560,
 -1,
 -55751,
 641159595,
 6539,
 -55750,
 641214109,
 6546,
 -1,
 641272663,
 6545,
 641476158,
 641164983,
 -1,
 -55747,
 641425686,
 6569,
 -1,
 641469271,
 6534,
 641672769,
 641421699,
 -1,
 -55744,
 641621340,
 6571,
 -1,
 641665879,
 6540,
 641869380,
 641615765,
 -1,
 -55741,
 641803933,
 6552,
 -1,
 641862487,
 6551,
 642065991,
 641809822,
 -1,
 -55738,
 641999922,
 6535,
 -1,
 642059095,
 6547,
 642262602,
 642003350,
 -1,
 -55735,
 642212118,
 6568,
 -1,
 642255703,
 6533,
 -55733,
 642213685,
 6541,
 -55732,
 642408726,
 6558,
 -55731,
 642468588,
 6529,
 -55730,
 642529578,
 6553,
 -55729,
 642593719,
 6559,
 -55728,
 642655901,
 6563,
 -55727,
 642720258,
 6557,
 -55726,
 642783242,
 6564,
 -1,
 642847115,
 6565,
 643049072,
 641083457,
 -1,
 643114584,
 642996104,
 -1,
 -55722,
 643060139,
 6536,
 -55721,
 643114653,
 6543,
 -1,
 643173207,
 6542,
 643376731,
 643065527,
 -1,
 -55718,
 643326230,
 6567,
 -1,
 643369815,
 6531,
 643573342,
 643322243,
 -1,
 -55715,
 643521884,
 6570,
 -1,
 643566423,
 6537,
 643769953,
 643516309,
 -1,
 -55712,
 643704477,
 6549,
 -1,
 643763031,
 6548,
 643966564,
 643710366,
 -1,
 -55709,
 643900466,
 6532,
 -1,
 643959639,
 6544,
 644163175,
 643903894,
 -1,
 -55706,
 644112662,
 6566,
 -1,
 644156247,
 6530,
 -55704,
 644114229,
 6538,
 -55703,
 644309270,
 6555,
 -55702,
 644369132,
 6528,
 -55701,
 644430122,
 6550,
 -55700,
 644494263,
 6556,
 -55699,
 644556445,
 6560,
 -55698,
 644620802,
 6554,
 -55697,
 644683786,
 6561,
 -1,
 644747659,
 6562,
 645005311,
 642982553,
 -1,
 645015155,
 644890014,
 6595,
 -1,
 644948999,
 6594,
 -55692,
 644964616,
 6593,
 -55691,
 645085412,
 6596,
 -55690,
 645149078,
 6597,
 -55689,
 645208035,
 6598,
 -1,
 645271897,
 6599,
 645473932,
 641033097,
 -1,
 645539454,
 645422322,
 6579,
 645604988,
 645471231,
 6585,
 -1,
 645555992,
 6591,
 -55683,
 645555992,
 6588,
 -1,
 645684466,
 6580,
 645867138,
 645480658,
 6583,
 645932673,
 645794647,
 6584,
 -1,
 645883672,
 6590,
 -1,
 645883672,
 6589,
 646129287,
 645794647,
 -1,
 646194821,
 646056791,
 6577,
 -1,
 646145816,
 6587,
 -55674,
 646145816,
 6586,
 -1,
 646257663,
 6582,
 646456970,
 646064910,
 -1,
 -55671,
 646407960,
 6592,
 -1,
 646458126,
 6578,
 -55669,
 646407033,
 6576,
 -1,
 646585343,
 6581,
 646784666,
 645405015,
 -1,
 646850192,
 646731656,
 -1,
 -55665,
 646800872,
 6610,
 -1,
 646851099,
 6611,
 647046803,
 646795651,
 -1,
 -55662,
 646983826,
 6614,
 -1,
 647045203,
 6615,
 647243414,
 646980030,
 -1,
 -55659,
 647185828,
 6612,
 -1,
 647245919,
 6613,
 -55657,
 647194943,
 6608,
 -55656,
 647381663,
 6609,
 -55655,
 647446369,
 6617,
 -1,
 647503328,
 6616,
 647702175,
 646731656,
 -1,
 647767710,
 647643868,
 -1,
 -55651,
 647694543,
 6601,
 -1,
 647759938,
 6600,
 -1,
 647702237,
 6618,
 648085503,
 647648160,
 6622,
 -1,
 647979272,
 6623,
 648160944,
 640951488,
 -1,
 648226475,
 648107494,
 -1,
 648292008,
 648164477,
 -1,
 -55643,
 648234901,
 127359,
 -55642,
 648296676,
 127356,
 -55641,
 648360841,
 127355,
 -1,
 648425691,
 127353,
 -55639,
 648237483,
 127373,
 -55638,
 648562649,
 127372,
 -1,
 648620981,
 127371,
 648871935,
 648156474,
 -1,
 648881839,
 648754301,
 -1,
 -55634,
 648824725,
 127327,
 -1,
 648881799,
 127319,
 -1,
 648812894,
 9471,
 -1,
 648110281,
 9906,
 649209595,
 640889621,
 -1,
 649275098,
 649147273,
 -1,
 649340632,
 649207822,
 -1,
 649406137,
 649280926,
 2002,
 649471671,
 649357109,
 2018,
 -1,
 649397999,
 2023,
 649658367,
 649399127,
 2019,
 -1,
 649529071,
 2016,
 649733823,
 649343195,
 -1,
 649799358,
 649675413,
 -1,
 -55620,
 649743387,
 2026,
 -55619,
 649801977,
 2024,
 -1,
 649860199,
 2025,
 -1,
 649726807,
 2006,
 650127042,
 649677772,
 -1,
 -55615,
 650071067,
 2010,
 -1,
 650120023,
 2009,
 650323652,
 650068178,
 2000,
 -1,
 650264786,
 1999,
 650454726,
 650255359,
 1997,
 -1,
 650386431,
 1995,
 650585800,
 650385418,
 2008,
 -1,
 650519797,
 2001,
 -55607,
 650536757,
 2022,
 -55606,
 650667047,
 2021,
 -55605,
 650730738,
 1998,
 -55604,
 650794912,
 2005,
 -55603,
 650858923,
 2011,
 -55602,
 650921945,
 2004,
 -55601,
 650983722,
 2017,
 -55600,
 651047863,
 2015,
 -55599,
 651112885,
 2014,
 -55598,
 651176718,
 1996,
 -55597,
 651241117,
 2020,
 -55596,
 651306214,
 2012,
 -55595,
 651371010,
 2013,
 -55594,
 651433063,
 2007,
 -55593,
 651497867,
 2003,
 -1,
 651561815,
 1994,
 -55591,
 649283421,
 2037,
 -1,
 651693441,
 2042,
 651896552,
 649206103,
 -1,
 651962078,
 651843464,
 -1,
 -55587,
 651912680,
 1986,
 -1,
 651962907,
 1987,
 652158689,
 651907459,
 -1,
 -55584,
 652095634,
 1990,
 -1,
 652157011,
 1991,
 652355300,
 652091838,
 -1,
 -55581,
 652297636,
 1988,
 -1,
 652357727,
 1989,
 -55579,
 652306751,
 1984,
 -55578,
 652493471,
 1985,
 -55577,
 652558177,
 1993,
 -1,
 652615136,
 1992,
 652814070,
 651826715,
 -1,
 652879605,
 652743268,
 -1,
 652945135,
 652818361,
 -1,
 -55572,
 652890087,
 2033,
 -55571,
 652949565,
 2032,
 -55570,
 653011065,
 2031,
 -1,
 653072584,
 2030,
 653272819,
 652890951,
 -1,
 -55567,
 653217767,
 2029,
 -55566,
 653277245,
 2028,
 -1,
 653338745,
 2027,
 -55564,
 653213193,
 2034,
 -1,
 653466372,
 2035,
 -1,
 652818730,
 2040,
 653731577,
 652760948,
 -1,
 -55560,
 653673289,
 2038,
 -1,
 653731050,
 2039,
 -55558,
 653666435,
 2036,
 -1,
 653861132,
 2041,
 654114815,
 649150674,
 -1,
 654124818,
 654004451,
 -1,
 654190348,
 654060933,
 -1,
 654255879,
 654123945,
 -1,
 654321412,
 654197411,
 -1,
 -55551,
 654267409,
 43059,
 -55550,
 654330721,
 43056,
 -55549,
 654386877,
 43057,
 -1,
 654450169,
 43060,
 654704639,
 654268815,
 -1,
 -55546,
 654595099,
 43061,
 -1,
 654658421,
 43058,
 654845706,
 654199583,
 -1,
 -55543,
 654790873,
 43062,
 -1,
 654852114,
 43065,
 -55541,
 654790988,
 43064,
 -1,
 654985596,
 43063,
 655173391,
 654140612,
 -1,
 -55538,
 655123704,
 11009,
 -1,
 655168143,
 11017,
 655425535,
 655105180,
 -1,
 -55535,
 655320312,
 11008,
 -1,
 655364751,
 11016,
 -1,
 654049560,
 9940,
 655632362,
 640817123,
 -1,
 655697819,
 655573202,
 -1,
 655763340,
 655637498,
 -1,
 655828817,
 655712839,
 -1,
 655894352,
 655755001,
 -1,
 655959840,
 655821480,
 -1,
 -55526,
 655886970,
 127123,
 -55525,
 655952397,
 127122,
 -55524,
 656017867,
 127121,
 -55523,
 656083302,
 127120,
 -55522,
 656148687,
 127119,
 -55521,
 656214082,
 127118,
 -1,
 656279490,
 127117,
 656484136,
 655886937,
 -1,
 -55518,
 656411258,
 127116,
 -55517,
 656476685,
 127115,
 -55516,
 656542155,
 127114,
 -55515,
 656607590,
 127113,
 -55514,
 656672975,
 127112,
 -55513,
 656738370,
 127111,
 -1,
 656803778,
 127110,
 657008432,
 656411129,
 -1,
 -55510,
 656935546,
 127109,
 -55509,
 657000973,
 127108,
 -55508,
 657066443,
 127107,
 -55507,
 657131878,
 127106,
 -55506,
 657197263,
 127105,
 -55505,
 657262658,
 127104,
 -1,
 657328066,
 127103,
 657532728,
 656935357,
 -1,
 -55502,
 657459834,
 127102,
 -55501,
 657525261,
 127101,
 -55500,
 657590731,
 127100,
 -55499,
 657656166,
 127099,
 -55498,
 657721551,
 127098,
 -55497,
 657786946,
 127097,
 -1,
 657852354,
 127096,
 658057024,
 657459521,
 -1,
 -55494,
 657984122,
 127095,
 -55493,
 658049549,
 127094,
 -55492,
 658115019,
 127093,
 -55491,
 658180454,
 127092,
 -55490,
 658245839,
 127091,
 -55489,
 658311234,
 127090,
 -1,
 658376642,
 127089,
 658581320,
 657983664,
 -1,
 -55486,
 658508410,
 127088,
 -55485,
 658573837,
 127087,
 -55484,
 658639307,
 127086,
 -55483,
 658704742,
 127085,
 -55482,
 658770127,
 127084,
 -55481,
 658835522,
 127083,
 -1,
 658900930,
 127082,
 659161087,
 658507828,
 -1,
 -55478,
 659032698,
 127081,
 -55477,
 659098125,
 127080,
 -55476,
 659163595,
 127079,
 -55475,
 659229030,
 127078,
 -55474,
 659294415,
 127077,
 -55473,
 659359810,
 127076,
 -1,
 659425218,
 127075,
 -1,
 655818874,
 127074,
 659750911,
 655763846,
 -1,
 659761035,
 659621625,
 -1,
 659826523,
 659688104,
 -1,
 -55467,
 659753594,
 127073,
 -55466,
 659819021,
 127072,
 -55465,
 659884491,
 127071,
 -55464,
 659949926,
 127070,
 -55463,
 660015311,
 127069,
 -55462,
 660080706,
 127068,
 -1,
 660146114,
 127067,
 660350819,
 659753561,
 -1,
 -55459,
 660277882,
 127066,
 -55458,
 660343309,
 127065,
 -55457,
 660408779,
 127064,
 -55456,
 660474214,
 127063,
 -55455,
 660539599,
 127062,
 -55454,
 660604994,
 127061,
 -1,
 660670402,
 127060,
 660875115,
 660277753,
 -1,
 -55451,
 660802170,
 127059,
 -55450,
 660867597,
 127058,
 -55449,
 660933067,
 127057,
 -55448,
 660998502,
 127056,
 -55447,
 661063887,
 127055,
 -55446,
 661129282,
 127054,
 -1,
 661194690,
 127053,
 661399411,
 660801981,
 -1,
 -55443,
 661326458,
 127052,
 -55442,
 661391885,
 127051,
 -55441,
 661457355,
 127050,
 -55440,
 661522790,
 127049,
 -55439,
 661588175,
 127048,
 -55438,
 661653570,
 127047,
 -1,
 661718978,
 127046,
 661923707,
 661326145,
 -1,
 -55435,
 661850746,
 127045,
 -55434,
 661916173,
 127044,
 -55433,
 661981643,
 127043,
 -55432,
 662047078,
 127042,
 -55431,
 662112463,
 127041,
 -55430,
 662177858,
 127040,
 -1,
 662243266,
 127039,
 662448003,
 661850288,
 -1,
 -55427,
 662375034,
 127038,
 -55426,
 662440461,
 127037,
 -55425,
 662505931,
 127036,
 -55424,
 662571366,
 127035,
 -55423,
 662636751,
 127034,
 -55422,
 662702146,
 127033,
 -1,
 662767554,
 127032,
 663027711,
 662374452,
 -1,
 -55419,
 662899322,
 127031,
 -55418,
 662964749,
 127030,
 -55417,
 663030219,
 127029,
 -55416,
 663095654,
 127028,
 -55415,
 663161039,
 127027,
 -55414,
 663226434,
 127026,
 -1,
 663291842,
 127025,
 -1,
 659685498,
 127024,
 663562130,
 655711154,
 -1,
 -55410,
 663509801,
 11784,
 -55409,
 663573960,
 11034,
 -55408,
 663637748,
 11798,
 -55407,
 663699727,
 11795,
 -1,
 663754465,
 8284,
 663955352,
 663510439,
 -1,
 664020886,
 663885797,
 -1,
 -55403,
 663959930,
 9891,
 -1,
 664019507,
 9890,
 -55401,
 663947181,
 8508,
 -1,
 664142398,
 11799,
 664403967,
 663905759,
 -1,
 -55398,
 664277647,
 11015,
 -1,
 664342103,
 11796,
 664545218,
 655629311,
 -1,
 664610746,
 664494373,
 -1,
 664676265,
 664556428,
 -1,
 664741796,
 664605626,
 -1,
 664807330,
 664688520,
 -1,
 -55391,
 664757736,
 43253,
 -1,
 664807963,
 43254,
 -55389,
 664756974,
 43251,
 -1,
 664932627,
 43255,
 -55387,
 664688014,
 43250,
 -55386,
 665078481,
 43256,
 -55385,
 665136836,
 2304,
 -55384,
 665200732,
 2417,
 -1,
 665262826,
 43252,
 665462708,
 664614405,
 -1,
 665528237,
 665396231,
 -1,
 -55380,
 665466892,
 2429,
 -1,
 665527346,
 2427,
 -55378,
 665479574,
 2425,
 -55377,
 665670478,
 2308,
 -55376,
 665727309,
 2428,
 -55375,
 665790346,
 2426,
 -55374,
 665852022,
 2430,
 -55373,
 665916298,
 2418,
 -1,
 665981438,
 2431,
 666183607,
 665412489,
 -1,
 -55370,
 666126957,
 2382,
 -1,
 666178464,
 2389,
 -55368,
 666118015,
 43259,
 -55367,
 666313896,
 43257,
 -1,
 666375152,
 43258,
 666576833,
 664556142,
 -1,
 666642366,
 666522838,
 -1,
 -55363,
 666583512,
 66638,
 -1,
 666640630,
 66639,
 666894335,
 666571744,
 -1,
 -55360,
 666780120,
 66598,
 -1,
 666837238,
 66599,
 -1,
 666506511,
 9192,
 667101161,
 664480526,
 -1,
 667166690,
 667034631,
 -1,
 667232212,
 667103207,
 -1,
 667297736,
 667183428,
 -1,
 -55353,
 667231222,
 127232,
 -1,
 667293252,
 127233,
 667494347,
 667244424,
 -1,
 -55350,
 667444728,
 127235,
 -1,
 667494961,
 127236,
 667690958,
 667439491,
 -1,
 -55347,
 667627673,
 127239,
 -1,
 667689054,
 127240,
 667887569,
 667623870,
 -1,
 -55344,
 667829677,
 127237,
 -1,
 667889768,
 127238,
 -55342,
 667828904,
 127234,
 -55341,
 668024678,
 127242,
 -1,
 668081645,
 127241,
 668336127,
 667176074,
 -1,
 668346329,
 668212374,
 119557,
 668467199,
 668285151,
 -1,
 -55336,
 668360372,
 119556,
 -1,
 668409035,
 119555,
 668608476,
 668284407,
 -1,
 -55333,
 668544301,
 9869,
 -1,
 668602013,
 9870,
 668805087,
 668542599,
 -1,
 -55330,
 668753593,
 119554,
 -1,
 668802257,
 119553,
 669057023,
 668739117,
 -1,
 -55327,
 668937517,
 9871,
 -1,
 668995229,
 9868,
 669198311,
 667094586,
 -1,
 -55324,
 669145816,
 11032,
 -55323,
 669208233,
 11031,
 -55322,
 669267278,
 11030,
 -1,
 669323994,
 11033,
 -55320,
 669147995,
 9902,
 -1,
 669471162,
 9933,
 -1,
 667045886,
 9946,
 669722774,
 655576012,
 -1,
 669788199,
 669654015,
 -1,
 669853723,
 669724924,
 -1,
 669919241,
 669791749,
 -1,
 669984759,
 669859230,
 -1,
 670050290,
 669935384,
 -1,
 -55311,
 669987065,
 43333,
 -1,
 670042967,
 43323,
 670246901,
 669983751,
 -1,
 -55308,
 670180402,
 43331,
 -1,
 670239575,
 43314,
 -55306,
 670177290,
 43332,
 -1,
 670370647,
 43317,
 670574586,
 669923556,
 -1,
 -55303,
 670503307,
 43330,
 -1,
 670567255,
 43320,
 -55301,
 670525237,
 43327,
 -55300,
 670721063,
 43328,
 -55299,
 670783392,
 43315,
 -55298,
 670847403,
 43324,
 -55297,
 670911515,
 43325,
 -55296,
 670975961,
 43318,
 -55295,
 671036343,
 43326,
 -55294,
 671101365,
 43312,
 -55293,
 671166713,
 43322,
 -55292,
 671229597,
 43329,
 -55291,
 671294514,
 43313,
 -55290,
 671356938,
 43316,
 -55289,
 671421284,
 43321,
 -55288,
 671486347,
 43319,
 -1,
 671550295,
 43334,
 671754261,
 669868296,
 -1,
 671819796,
 671696758,
 -1,
 671885326,
 671751167,
 43337,
 -55283,
 671833330,
 43341,
 -1,
 671877975,
 43342,
 672081937,
 671812439,
 -1,
 -55280,
 672029938,
 43340,
 -1,
 672082702,
 43338,
 -55278,
 672029938,
 43336,
 -55277,
 672219346,
 43339,
 -1,
 672279310,
 43335,
 -1,
 671756129,
 43347,
 672540698,
 671684197,
 -1,
 672606232,
 672480670,
 43344,
 -1,
 672539655,
 43343,
 -55271,
 672549836,
 43345,
 -1,
 672671367,
 43346,
 -1,
 672485946,
 43359,
 672933924,
 669803059,
 -1,
 672999457,
 672858112,
 -1,
 673064992,
 672946685,
 -1,
 -55265,
 673009441,
 11079,
 -1,
 673068440,
 11073,
 -1,
 673011012,
 10184,
 673382399,
 672929765,
 -1,
 -55261,
 673270677,
 11822,
 -1,
 673325886,
 11793,
 673579007,
 672880293,
 -1,
 -55258,
 673450191,
 9953,
 -1,
 673515586,
 9952,
 673720409,
 669736654,
 -1,
 673785926,
 673660984,
 -1,
 673851441,
 673732488,
 -1,
 673916973,
 673801202,
 -1,
 -55252,
 673857748,
 69235,
 -1,
 673914614,
 69226,
 674113584,
 673851015,
 -1,
 -55249,
 674057549,
 69236,
 -1,
 674115475,
 69227,
 -1,
 674045547,
 69225,
 674375736,
 673796483,
 -1,
 674441269,
 674312338,
 -1,
 -55244,
 674389231,
 69230,
 -1,
 674431336,
 69239,
 674693119,
 674373715,
 -1,
 -55241,
 674585839,
 69231,
 -1,
 674627944,
 69240,
 674834495,
 674308542,
 -1,
 674900028,
 674775250,
 -1,
 -55237,
 674848784,
 69237,
 -1,
 674910480,
 69228,
 675151871,
 674835214,
 -1,
 -55234,
 675045871,
 69238,
 -1,
 675095538,
 69229,
 675293250,
 674774881,
 -1,
 -55231,
 675241199,
 69233,
 -1,
 675283304,
 69242,
 675489861,
 675225056,
 -1,
 -55228,
 675440408,
 69232,
 -1,
 675479912,
 69241,
 -1,
 675431099,
 69234,
 675752019,
 673716567,
 -1,
 675817546,
 675698568,
 -1,
 -55223,
 675767784,
 69217,
 -1,
 675818011,
 69218,
 676014157,
 675762563,
 -1,
 -55220,
 675950738,
 69221,
 -1,
 676012115,
 69222,
 676210768,
 675946942,
 -1,
 -55217,
 676152740,
 69219,
 -1,
 676212831,
 69220,
 -55215,
 676151967,
 69216,
 -55214,
 676347745,
 69224,
 -1,
 676404704,
 69223,
 676659199,
 675685289,
 -1,
 676669528,
 676545187,
 -1,
 -55210,
 676616521,
 69245,
 -55209,
 676678497,
 69244,
 -1,
 676734653,
 69243,
 -1,
 676617432,
 69246,
 676997241,
 673655566,
 -1,
 677062776,
 676930939,
 -1,
 677128298,
 676986880,
 -1,
 677193824,
 677073283,
 -1,
 -55202,
 677142032,
 11779,
 -55201,
 677194746,
 11815,
 -1,
 677250941,
 10182,
 677455971,
 677124548,
 -1,
 -55198,
 677404093,
 11817,
 -1,
 677469112,
 11781,
 677652582,
 677383853,
 -1,
 -55195,
 677598999,
 11776,
 -1,
 677649084,
 11777,
 -55193,
 677601885,
 11809,
 -55192,
 677796627,
 11786,
 -55191,
 677858409,
 11789,
 -1,
 677918758,
 11805,
 678111350,
 677078071,
 -1,
 678176885,
 678039489,
 -1,
 678242415,
 678127048,
 -1,
 -55186,
 678191106,
 11023,
 -1,
 678239095,
 11022,
 678439026,
 678189489,
 -1,
 -55183,
 678385456,
 11076,
 -1,
 678438455,
 11075,
 678690815,
 678366227,
 -1,
 -55180,
 678582766,
 11084,
 -1,
 678628860,
 11080,
 -1,
 678120227,
 11078,
 678952959,
 678037291,
 4053,
 -1,
 678823491,
 4055,
 -1,
 677003006,
 11824,
 679094416,
 676938341,
 -1,
 679159938,
 679039363,
 -1,
 679225473,
 679091199,
 -1,
 679291007,
 679175941,
 -1,
 -55170,
 679239265,
 65939,
 -1,
 679284404,
 65936,
 -55168,
 679237234,
 65944,
 -1,
 679427386,
 65938,
 -1,
 679161058,
 65941,
 679684232,
 679100492,
 -1,
 679749766,
 679617162,
 -1,
 -55163,
 679696764,
 8583,
 -1,
 679746699,
 8582,
 -55161,
 679695363,
 8581,
 -1,
 679887559,
 8584,
 680077452,
 679614435,
 -1,
 -55158,
 680026068,
 65945,
 -55157,
 680078617,
 65940,
 -1,
 680140434,
 65942,
 -55155,
 680025848,
 65937,
 -55154,
 680283047,
 65943,
 -55153,
 680334408,
 65947,
 -1,
 680398867,
 65946,
 680656895,
 679021859,
 -1,
 680667285,
 680546900,
 -1,
 -55149,
 680613320,
 11787,
 -55148,
 680668804,
 11782,
 -1,
 680729209,
 11783,
 -1,
 680607134,
 9926,
 680995086,
 669659355,
 -1,
 681060621,
 680921943,
 -1,
 681126156,
 681009455,
 -1,
 681191633,
 681063647,
 -1,
 681257168,
 681139154,
 -1,
 681322659,
 681196958,
 -1,
 681388191,
 681255986,
 43412,
 681508863,
 681312756,
 43402,
 -1,
 681378953,
 43403,
 681584801,
 681338677,
 43418,
 -1,
 681509422,
 43416,
 681771007,
 681511767,
 43428,
 -1,
 681640494,
 43423,
 681846952,
 681269128,
 -1,
 681912486,
 681793440,
 43419,
 -1,
 681837076,
 43420,
 682098687,
 681839447,
 43424,
 -1,
 681968174,
 43425,
 682174637,
 681777123,
 -1,
 682240171,
 682104842,
 43421,
 -1,
 682164756,
 43422,
 682426367,
 682167127,
 43426,
 -1,
 682295828,
 43427,
 682502321,
 682119595,
 43441,
 682622975,
 682426897,
 -1,
 -55120,
 682516540,
 43439,
 -1,
 682560794,
 43440,
 682764469,
 682444761,
 43429,
 682885119,
 682688512,
 -1,
 -55116,
 682769753,
 43430,
 -1,
 682824798,
 43401,
 683026617,
 682701237,
 43407,
 683147263,
 682950656,
 -1,
 -55112,
 683037162,
 43408,
 -1,
 683097433,
 43409,
 683288764,
 682961678,
 43398,
 -55109,
 683223822,
 43399,
 -1,
 683278759,
 43397,
 683485374,
 683232283,
 43435,
 -1,
 683409439,
 43436,
 683616448,
 683421945,
 43415,
 -1,
 683541012,
 43417,
 683747522,
 683549746,
 43410,
 -1,
 683672110,
 43411,
 683878596,
 683676516,
 43413,
 -1,
 683803182,
 43414,
 684009670,
 683807115,
 43431,
 -1,
 683934254,
 43432,
 684140744,
 683936599,
 43396,
 -1,
 684075790,
 43405,
 -55095,
 684091189,
 43434,
 -55094,
 684221479,
 43438,
 -55093,
 684285170,
 43400,
 -55092,
 684343506,
 43406,
 -55091,
 684407082,
 43433,
 -55090,
 684471223,
 43437,
 -55089,
 684533405,
 43442,
 -1,
 684596223,
 43404,
 -1,
 681190357,
 43457,
 684861670,
 681134041,
 -1,
 684927203,
 684791821,
 -1,
 684992728,
 684864393,
 -1,
 685058263,
 684940530,
 -1,
 -55082,
 684998434,
 43465,
 -1,
 685058797,
 43461,
 -1,
 684994022,
 43464,
 685320412,
 684919639,
 -1,
 685385947,
 685250703,
 43466,
 -1,
 685309977,
 43467,
 -1,
 685325904,
 43459,
 685582559,
 685262741,
 -1,
 -55074,
 685518753,
 43468,
 -1,
 685575846,
 43463,
 -55072,
 685532569,
 43462,
 -55071,
 685726295,
 43486,
 -55070,
 685783383,
 43460,
 -1,
 685846440,
 43487,
 686096383,
 684867323,
 -1,
 -55067,
 685984937,
 43471,
 -1,
 686043934,
 43456,
 686237940,
 684792151,
 -1,
 686303466,
 686184328,
 -1,
 -55063,
 686253544,
 43474,
 -1,
 686303771,
 43475,
 686500077,
 686248323,
 -1,
 -55060,
 686436498,
 43478,
 -1,
 686497875,
 43479,
 686696688,
 686432702,
 -1,
 -55057,
 686638500,
 43476,
 -1,
 686698591,
 43477,
 -55055,
 686647615,
 43472,
 -55054,
 686834335,
 43473,
 -55053,
 686899041,
 43481,
 -1,
 686956000,
 43480,
 687155456,
 686187401,
 -1,
 687220986,
 687101832,
 -1,
 687286521,
 687147863,
 -1,
 -55048,
 687231303,
 43444,
 -1,
 687290057,
 43450,
 -1,
 687227479,
 43445,
 687548668,
 687171237,
 43446,
 -1,
 687473183,
 43447,
 687679742,
 687494955,
 43448,
 -1,
 687604262,
 43449,
 -55041,
 687622359,
 43452,
 -1,
 687741323,
 43451,
 687941894,
 687100812,
 -1,
 688007427,
 687871036,
 43393,
 -1,
 687932655,
 43443,
 -55036,
 687957393,
 43395,
 -55035,
 688080951,
 43392,
 -1,
 688141503,
 43394,
 688335114,
 687871589,
 -1,
 -55032,
 688277692,
 43454,
 -55031,
 688337552,
 43453,
 -1,
 688395121,
 43455,
 -55029,
 688282698,
 43469,
 -1,
 688541400,
 43458,
 -1,
 681068572,
 9979,
 -1,
 681009020,
 9909,
 688859533,
 680930062,
 -1,
 688925027,
 688799134,
 -1,
 688990557,
 688869906,
 -1,
 689056057,
 688935144,
 -1,
 689121581,
 688993797,
 -1,
 689187096,
 689066371,
 -1,
 689252631,
 689113943,
 -1,
 -55018,
 689191755,
 68430,
 -1,
 689248490,
 68433,
 -1,
 689186988,
 68436,
 689514779,
 689133448,
 -1,
 -55014,
 689446894,
 68424,
 -1,
 689508650,
 68437,
 689711389,
 689448813,
 68420,
 -1,
 689658096,
 68423,
 689842464,
 689638231,
 -1,
 -55009,
 689793050,
 68431,
 -1,
 689845737,
 68416,
 -55007,
 689793298,
 68422,
 -55006,
 689989705,
 68425,
 -55005,
 690054244,
 68421,
 -55004,
 690113989,
 68435,
 -55003,
 690178839,
 68434,
 -55002,
 690243711,
 68432,
 -55001,
 690307171,
 68429,
 -55000,
 690371422,
 68428,
 -54999,
 690435157,
 68427,
 -54998,
 690500108,
 68426,
 -54997,
 690562472,
 68418,
 -54996,
 690624567,
 68419,
 -1,
 690688582,
 68417,
 690946047,
 689061944,
 -1,
 690956596,
 690837384,
 -1,
 691022130,
 690906098,
 -1,
 -54991,
 690962642,
 68441,
 -1,
 691019510,
 68445,
 -54989,
 690956827,
 68442,
 -1,
 691150443,
 68444,
 691349816,
 690897567,
 68440,
 691470335,
 691273728,
 -1,
 -54985,
 691362172,
 68447,
 -1,
 691415759,
 68446,
 -1,
 691282769,
 68443,
 691732479,
 688990470,
 -1,
 691743057,
 691615237,
 -1,
 691808576,
 691687811,
 -1,
 691874111,
 691735383,
 -1,
 -54978,
 691813195,
 68462,
 -1,
 691869930,
 68464,
 -1,
 691808428,
 68465,
 692136259,
 691754888,
 -1,
 -54974,
 692068334,
 68456,
 -1,
 692130090,
 68466,
 692332869,
 692070253,
 68452,
 -1,
 692279536,
 68455,
 -54970,
 692283666,
 68454,
 -54969,
 692414537,
 68457,
 -54968,
 692479119,
 68453,
 -54967,
 692537471,
 68463,
 -54966,
 692600931,
 68461,
 -54965,
 692665186,
 68460,
 -54964,
 692728917,
 68459,
 -54963,
 692793868,
 68458,
 -54962,
 692856232,
 68450,
 -54961,
 692918327,
 68451,
 -54960,
 692982342,
 68449,
 -1,
 693046736,
 68448,
 693305343,
 691683384,
 -1,
 693315928,
 693196680,
 -1,
 693381462,
 693265394,
 -1,
 -54955,
 693321938,
 68473,
 -1,
 693378806,
 68477,
 -54953,
 693316123,
 68474,
 -1,
 693509739,
 68476,
 693709148,
 693256863,
 68472,
 693829631,
 693633024,
 -1,
 -54949,
 693721468,
 68479,
 -1,
 693775055,
 68478,
 -1,
 693642065,
 68475,
 694036834,
 688939272,
 -1,
 694102369,
 693968790,
 -1,
 -54944,
 694050619,
 8276,
 -1,
 694103705,
 11800,
 -1,
 694038459,
 8292,
 -1,
 693983400,
 9892,
 694430092,
 688864487,
 -1,
 694495615,
 694367749,
 -1,
 694561130,
 694440323,
 -1,
 694626665,
 694487895,
 -1,
 -54936,
 694565707,
 67662,
 -1,
 694622442,
 67665,
 -1,
 694560940,
 67668,
 694888813,
 694507400,
 -1,
 -54932,
 694820846,
 67656,
 -1,
 694882602,
 67669,
 695085423,
 694822765,
 67652,
 -1,
 695032048,
 67655,
 695216498,
 695012183,
 -1,
 -54927,
 695167002,
 67663,
 -1,
 695219689,
 67648,
 -54925,
 695167250,
 67654,
 -54924,
 695363657,
 67657,
 -54923,
 695428196,
 67653,
 -54922,
 695487941,
 67667,
 -54921,
 695552791,
 67666,
 -54920,
 695617663,
 67664,
 -54919,
 695681123,
 67661,
 -54918,
 695745374,
 67660,
 -54917,
 695809109,
 67659,
 -54916,
 695874060,
 67658,
 -54915,
 695936424,
 67650,
 -54914,
 695998519,
 67651,
 -1,
 696062534,
 67649,
 696265099,
 694435896,
 -1,
 696330631,
 696211336,
 -1,
 696396164,
 696280050,
 -1,
 -54909,
 696336594,
 67673,
 -1,
 696393462,
 67676,
 696592774,
 696327787,
 67675,
 -1,
 696517883,
 67679,
 -1,
 696527387,
 67674,
 696844287,
 696271519,
 67672,
 696909823,
 696713216,
 -1,
 -54902,
 696801660,
 67678,
 -1,
 696855247,
 67677,
 -1,
 696209991,
 67671,
 -1,
 694359091,
 9976,
 697182656,
 688807154,
 -1,
 697248183,
 697115831,
 -1,
 697313718,
 697185797,
 -1,
 697379222,
 697258371,
 -1,
 697444756,
 697305943,
 -1,
 -54893,
 697383970,
 66450,
 -1,
 697440379,
 66453,
 -54891,
 697390864,
 66461,
 -1,
 697575596,
 66444,
 697772442,
 697325448,
 -1,
 -54888,
 697712850,
 66458,
 -54887,
 697771808,
 66456,
 -1,
 697835483,
 66441,
 698034589,
 697723111,
 -1,
 -54884,
 697982194,
 66449,
 -1,
 698032094,
 66439,
 698231200,
 697971094,
 -1,
 -54881,
 698164893,
 66435,
 -1,
 698223802,
 66443,
 698427810,
 698165537,
 66437,
 -1,
 698374048,
 66440,
 698558885,
 698360839,
 -1,
 -54876,
 698492596,
 66457,
 -1,
 698551861,
 66434,
 698755496,
 698488803,
 -1,
 -54873,
 698689209,
 66447,
 -1,
 698752578,
 66436,
 698952107,
 698682199,
 -1,
 -54870,
 698890349,
 66432,
 -1,
 698953005,
 66451,
 -54868,
 698902597,
 66442,
 -54867,
 699098600,
 66438,
 -54866,
 699161842,
 66460,
 -54865,
 699223225,
 66455,
 -54864,
 699288338,
 66454,
 -54863,
 699353763,
 66452,
 -54862,
 699416675,
 66448,
 -54861,
 699480926,
 66446,
 -54860,
 699544655,
 66445,
 -54859,
 699607822,
 66459,
 -1,
 699667002,
 66433,
 -1,
 697263743,
 66463,
 699935164,
 697190293,
 -1,
 700000699,
 699884599,
 -1,
 -54854,
 699929231,
 11014,
 -1,
 699993687,
 11797,
 -1,
 699924732,
 11021,
 700262847,
 699874039,
 -1,
 -54850,
 700212651,
 9748,
 -1,
 700269184,
 9969,
 -1,
 700202891,
 9903,
 700525030,
 697132018,
 -1,
 700590562,
 700458631,
 -1,
 700656097,
 700526612,
 -1,
 700721608,
 700602248,
 -1,
 700787143,
 700664780,
 -1,
 -54842,
 700722051,
 10177,
 -1,
 700780264,
 9186,
 -1,
 700737123,
 9943,
 701049292,
 700660532,
 -1,
 -54838,
 700995156,
 11088,
 -54837,
 701053029,
 11048,
 -1,
 701110577,
 11046,
 701311441,
 700979171,
 -1,
 701376976,
 701254859,
 -1,
 -54833,
 701315623,
 9920,
 -1,
 701379287,
 9921,
 -1,
 701311840,
 9931,
 701639124,
 701260306,
 -1,
 -54829,
 701589274,
 11038,
 -1,
 701651403,
 11055,
 701835735,
 701584462,
 -1,
 -54826,
 701781588,
 11090,
 -1,
 701839461,
 11051,
 702032346,
 701772681,
 -1,
 -54823,
 701963649,
 9945,
 -1,
 702025578,
 11036,
 702228957,
 701965959,
 -1,
 -54820,
 702170242,
 11053,
 -1,
 702226681,
 11041,
 702425567,
 702161639,
 9872,
 -1,
 702350958,
 9983,
 -54816,
 702369545,
 11092,
 -1,
 702499012,
 11040,
 -1,
 700587338,
 9855,
 702753253,
 700517207,
 -1,
 -54812,
 702702031,
 11071,
 -1,
 702763074,
 9888,
 -1,
 702694477,
 11825,
 703015424,
 700457406,
 -1,
 703080942,
 702952329,
 -1,
 703146474,
 703022977,
 9880,
 -1,
 703071343,
 8277,
 703277549,
 703073111,
 -1,
 -54804,
 703224454,
 9189,
 -1,
 703276041,
 9971,
 -1,
 703209529,
 9884,
 703539701,
 703021266,
 -1,
 703605236,
 703487218,
 -1,
 703670771,
 703548377,
 -1,
 -54798,
 703613606,
 8280,
 -1,
 703674963,
 8283,
 -1,
 703610888,
 9970,
 -1,
 703549470,
 11792,
 703998457,
 703487218,
 -1,
 -54793,
 703943201,
 9179,
 -54792,
 704003808,
 9905,
 -1,
 704060954,
 9981,
 704260604,
 703934578,
 -1,
 -54789,
 704203430,
 8281,
 -1,
 704264787,
 11821,
 704457215,
 704187223,
 -1,
 -54786,
 704395079,
 9950,
 -1,
 704452509,
 8507,
 -1,
 704389009,
 9972,
 -54783,
 702965759,
 983048,
 -1,
 704662454,
 9915]
_charnames_564 = [
3804,
3849,
3675,
3816,
3818,
3869,
3940,
4046,
3874,
4017,
3960,
3736,
3860,
4064,
3886,
4068,
3984,
3953,
3930,
3695,
4062,
3893,
4009,
3867,
3991,
3760,
4055,
3890,
]

_charnames_751 = [
6497,
6501,
6491,
6500,
6499,
6527,
6525,
6526,
6502,
6538,
6550,
6521,
6549,
6520,
6446,
6552,
6490,
]

_charnames_848 = [
1370,
1321,
1412,
1409,
1318,
1371,
1368,
1373,
1361,
1394,
1355,
1402,
1354,
1353,
1351,
1352,
]

_charnames_880 = [
7622,
7603,
7623,
7604,
-1,
-1,
7621,
7602,
-1,
-1,
-1,
7606,
7608,
7607,
]

_charnames_1015 = [
7619,
7600,
7624,
7620,
7601,
7662,
7626,
7629,
7627,
]

_charnames_1270 = [
1743,
1673,
-1,
-1,
1742,
1672,
1724,
1651,
1723,
1650,
]

_charnames_1296 = [
1707,
1634,
1729,
1656,
1751,
1680,
1710,
1637,
1720,
1647,
1748,
1678,
1747,
1677,
1752,
1681,
1728,
1655,
1730,
1657,
1749,
1666,
]

_charnames_1536 = [
9071,
9040,
9066,
9042,
-1,
-1,
9080,
9079,
9064,
9078,
9077,
9237,
-1,
9074,
9070,
9047,
9041,
9048,
9044,
9045,
9046,
9052,
9053,
9051,
9055,
9056,
9054,
-1,
-1,
-1,
9069,
]

_charnames_1622 = [
9057,
9073,
9072,
9068,
9059,
9060,
9061,
9063,
9067,
]

_charnames_1869 = [
7342,
7343,
7344,
8979,
8983,
8977,
8978,
8980,
8982,
8981,
8970,
8971,
9025,
9024,
9002,
8998,
9011,
9012,
9010,
8960,
8961,
8992,
8990,
8988,
9034,
9033,
9020,
9019,
9018,
9035,
9004,
9006,
8995,
8968,
8966,
8996,
9003,
8967,
9014,
9015,
8952,
8953,
8954,
9030,
9031,
9027,
9028,
8972,
8999,
8997,
8993,
]

_charnames_1984 = [
9956,
9957,
9948,
9949,
9954,
9955,
9951,
9952,
9959,
9958,
9943,
9925,
9937,
9924,
9930,
9923,
9922,
9927,
9908,
9942,
9933,
9931,
9918,
9941,
9926,
9921,
9920,
9932,
9939,
9940,
9936,
9935,
9912,
9934,
9909,
9911,
9938,
9929,
9928,
9910,
9916,
9917,
9915,
9970,
9969,
9968,
9966,
9965,
9964,
9963,
9971,
9972,
9977,
9944,
9975,
9976,
9973,
9978,
9945,
-1,
-1,
-1,
-1,
-1,
7064,
7051,
7061,
7063,
7044,
7052,
7053,
7045,
7041,
7054,
7060,
7059,
7058,
7057,
7048,
7046,
7062,
7040,
7056,
7055,
7049,
7042,
7104,
7105,
7106,
7109,
7113,
7108,
7071,
7082,
7074,
7068,
7079,
7073,
7067,
7078,
7111,
7077,
7069,
7080,
7112,
7070,
7081,
7072,
7076,
7107,
-1,
-1,
7099,
7090,
7087,
7101,
7088,
7096,
7114,
7100,
7092,
7098,
7093,
7097,
7089,
7095,
7086,
]

_charnames_2382 = [
10165,
-1,
-1,
-1,
-1,
-1,
-1,
10166,
]

_charnames_2417 = [
10151,
10162,
-1,
-1,
-1,
-1,
-1,
-1,
10157,
10160,
10156,
10159,
10155,
10161,
10163,
]

_charnames_2555 = [
8225,
-1,
-1,
-1,
-1,
-1,
7864,
-1,
7862,
]

_charnames_3059 = [
5108,
5113,
5109,
5107,
5104,
5115,
5110,
5112,
]

_charnames_3192 = [
5552,
5550,
5544,
5547,
5551,
5545,
5548,
5556,
]

_charnames_3389 = [
6813,
-1,
-1,
-1,
-1,
-1,
-1,
6802,
]

_charnames_3440 = [
6807,
6806,
6805,
6810,
6811,
6812,
-1,
-1,
-1,
6814,
6794,
6793,
6797,
6795,
6796,
6798,
]

_charnames_4046 = [
5640,
-1,
5631,
5634,
5633,
5635,
5636,
10358,
4696,
10359,
4697,
]

_charnames_4130 = [
6609,
-1,
-1,
-1,
-1,
-1,
6617,
-1,
-1,
6699,
]

_charnames_4147 = [
6696,
6695,
6701,
-1,
-1,
-1,
-1,
6656,
6705,
6707,
6706,
6708,
6626,
]

_charnames_4186 = [
6615,
6616,
6614,
6613,
6710,
6711,
6712,
6610,
6686,
6716,
6715,
6623,
6624,
6693,
6692,
6650,
6649,
6648,
6647,
6646,
6620,
6619,
6621,
6700,
6689,
6688,
6690,
6599,
6598,
6604,
6607,
6600,
6595,
6606,
6596,
6602,
6605,
6608,
6601,
6603,
6713,
6685,
6682,
6683,
6684,
6639,
6638,
6637,
6636,
6643,
6642,
6644,
6625,
6654,
6667,
6668,
6659,
6660,
6665,
6666,
6662,
6663,
6670,
6669,
6653,
6652,
6697,
6698,
6677,
6678,
]

_charnames_4992 = [
3543,
3599,
3598,
3597,
3545,
3605,
3604,
3603,
3544,
3614,
3613,
3612,
3542,
3592,
3591,
3590,
3636,
3630,
3638,
3637,
3632,
3635,
3640,
3639,
3631,
3634,
]

_charnames_5751 = [
2009,
2005,
2006,
2003,
2004,
2007,
2008,
2010,
2078,
]

_charnames_6128 = [
8291,
8292,
8287,
8290,
8289,
8280,
8286,
8285,
8284,
8283,
]

_charnames_6314 = [
6560,
-1,
-1,
-1,
-1,
-1,
1999,
2089,
2090,
2016,
2072,
2073,
2071,
2041,
2084,
2083,
2091,
2058,
2059,
2092,
2029,
2018,
2027,
2028,
2026,
2080,
2081,
2050,
2056,
1990,
2057,
1991,
2054,
1988,
2055,
1989,
2048,
2046,
2047,
2044,
2045,
2049,
1995,
1994,
1997,
1998,
1996,
1986,
1992,
1993,
2094,
2015,
2086,
2087,
2051,
2013,
2014,
2039,
2040,
2032,
2033,
2034,
2036,
2037,
2021,
2022,
2024,
2063,
2068,
2065,
2064,
2023,
2069,
2077,
2076,
2067,
]

_charnames_6400 = [
4460,
4407,
4406,
4413,
4412,
4403,
4419,
4418,
4410,
4409,
4395,
4398,
4397,
4416,
4415,
4404,
4401,
4400,
4422,
4421,
4425,
4394,
4424,
4426,
4423,
4392,
4391,
4393,
4427,
-1,
-1,
-1,
4451,
4459,
4458,
4457,
4453,
4455,
4452,
4456,
4454,
4446,
4448,
4447,
-1,
-1,
-1,
-1,
4438,
4431,
4439,
4433,
4432,
4435,
4436,
4434,
4437,
4442,
4444,
4441,
-1,
-1,
-1,
-1,
4443,
-1,
-1,
-1,
4476,
4475,
4471,
4472,
4463,
4464,
4469,
4470,
4466,
4467,
4474,
4473,
5410,
5412,
5406,
5389,
5414,
5411,
5391,
5390,
5417,
5402,
5401,
5416,
5420,
5413,
5419,
5415,
5409,
5388,
5407,
5395,
5418,
5394,
5393,
5398,
5404,
5403,
5399,
5392,
5396,
5397,
-1,
-1,
5386,
5385,
5384,
5383,
5382,
]

_charnames_6528 = [
9833,
9804,
9830,
9818,
9826,
9801,
9789,
9797,
9813,
9821,
9831,
9784,
9792,
9802,
9815,
9814,
9827,
9786,
9785,
9798,
9824,
9823,
9834,
9795,
9794,
9805,
9837,
9832,
9835,
9808,
9803,
9806,
9836,
9838,
9839,
9807,
9809,
9810,
9829,
9817,
9800,
9788,
9820,
9791,
-1,
-1,
-1,
-1,
9866,
9859,
9865,
9849,
9853,
9867,
9862,
9854,
9855,
9850,
9861,
9860,
9852,
9857,
9856,
9851,
9864,
9843,
9842,
9841,
9844,
9845,
9846,
9847,
9885,
9884,
-1,
-1,
-1,
-1,
-1,
-1,
9878,
9879,
9870,
9871,
9876,
9877,
9873,
9874,
9881,
9880,
9886,
-1,
-1,
-1,
9887,
9888,
8255,
8302,
8254,
8299,
8296,
8251,
8248,
8245,
8242,
8239,
8277,
8274,
8264,
8271,
8268,
8261,
8303,
8301,
8253,
8298,
8295,
8250,
8247,
8244,
8241,
8238,
8276,
8273,
8263,
8270,
8267,
8260,
8164,
8167,
8151,
8150,
8162,
8170,
8156,
8155,
8159,
8168,
8153,
8152,
8169,
8165,
8148,
8147,
8157,
8161,
8163,
8158,
8160,
8171,
8166,
8175,
8173,
8176,
8174,
8177,
-1,
-1,
8178,
8179,
5151,
5150,
5149,
5124,
5122,
5123,
5172,
5160,
5159,
5133,
5135,
5132,
5171,
5167,
5162,
5183,
5136,
5168,
5154,
5153,
5127,
5126,
5173,
5184,
5157,
5156,
5164,
5130,
5138,
5129,
5180,
5134,
5161,
5166,
5169,
5139,
5141,
5178,
5146,
5145,
5147,
5163,
5142,
5185,
5137,
5176,
5177,
5174,
5175,
5182,
5179,
5140,
5181,
5274,
5275,
5279,
5204,
5282,
5278,
5281,
5276,
5283,
5280,
-1,
5201,
5231,
5240,
5234,
5237,
5238,
5239,
5230,
5229,
5227,
5228,
5221,
5223,
5225,
5241,
5233,
5226,
5232,
5236,
5224,
5203,
5211,
5210,
5192,
5191,
5190,
5214,
5206,
5193,
-1,
-1,
5284,
5266,
5267,
5258,
5259,
5264,
5265,
5261,
5262,
5269,
5268,
-1,
-1,
-1,
-1,
-1,
-1,
5252,
5253,
5244,
5245,
5250,
5251,
5247,
5248,
5255,
5254,
-1,
-1,
-1,
-1,
-1,
-1,
5207,
5208,
5200,
5196,
5216,
5218,
5213,
5205,
5194,
5195,
5198,
5199,
5217,
5219,
]

_charnames_6912 = [
8008,
8009,
8012,
8010,
8013,
7894,
7895,
7916,
7917,
7908,
7909,
7903,
7904,
7906,
7907,
7921,
7897,
7912,
7913,
7883,
7885,
7918,
7919,
7881,
7923,
7924,
7914,
7915,
7880,
7875,
7874,
7891,
7890,
7879,
7871,
7873,
7887,
7892,
7878,
7910,
7911,
7925,
7926,
7931,
7928,
7902,
7905,
7929,
7901,
7900,
7898,
7932,
8011,
7981,
7982,
7983,
7984,
7985,
7986,
7987,
7990,
7991,
7976,
7978,
7980,
7979,
7988,
7989,
8025,
7884,
7886,
7876,
7922,
7930,
7927,
7896,
-1,
-1,
-1,
-1,
8002,
8003,
7994,
7995,
8000,
8001,
7997,
7998,
8005,
8004,
8018,
8017,
8024,
8022,
8023,
8021,
8016,
7946,
7944,
7945,
7936,
7938,
7947,
7941,
7943,
7940,
7939,
7954,
7957,
7950,
7952,
7955,
7951,
7953,
7958,
7956,
7969,
7970,
7972,
7973,
7963,
7961,
7966,
7965,
7962,
-1,
-1,
-1,
7270,
7269,
7268,
7220,
7236,
7227,
7221,
7232,
7218,
7219,
7217,
7230,
7238,
7210,
7241,
7235,
7222,
7209,
7228,
7240,
7211,
7231,
7239,
7226,
7242,
7233,
7223,
7229,
7234,
7225,
7214,
7224,
7237,
7276,
7275,
7274,
7261,
7259,
7263,
7260,
7264,
7262,
7271,
-1,
-1,
-1,
7216,
7213,
7253,
7254,
7245,
7246,
7251,
7252,
7248,
7249,
7256,
7255,
]

_charnames_7168 = [
4566,
4564,
4565,
4582,
4581,
4561,
4588,
4587,
4597,
4560,
4554,
4553,
4570,
4562,
4558,
4556,
4557,
4585,
4584,
4591,
4590,
4576,
4575,
4552,
4551,
4568,
4592,
4595,
4596,
4579,
4578,
4594,
4573,
4572,
4593,
4598,
4640,
4641,
4630,
4628,
4626,
4627,
4624,
4625,
4629,
4616,
4621,
4622,
4614,
4620,
4619,
4618,
4615,
4617,
4643,
4644,
-1,
-1,
-1,
4635,
4636,
4637,
4634,
4633,
4609,
4610,
4601,
4602,
4607,
4608,
4604,
4605,
4612,
4611,
-1,
-1,
-1,
4549,
4548,
4569,
8864,
8865,
8856,
8857,
8862,
8863,
8859,
8860,
8867,
8866,
8828,
8823,
8826,
8824,
8825,
8829,
8821,
8822,
8820,
8819,
8832,
8845,
8848,
8847,
8846,
8830,
8838,
8837,
8836,
8835,
8833,
8851,
8853,
8852,
8850,
8831,
8841,
8843,
8840,
8842,
8875,
8877,
8874,
8876,
8872,
8878,
8870,
8871,
]

_charnames_7376 = [
6336,
6340,
6342,
6321,
6319,
6329,
6328,
6326,
6343,
6327,
6338,
6332,
6335,
6339,
6331,
6333,
6341,
6344,
6313,
6309,
6316,
6311,
6317,
6310,
6312,
6306,
6305,
6302,
6303,
6320,
6323,
6322,
6318,
6304,
6307,
]

_charnames_7424 = [
4087,
4088,
3666,
4102,
4101,
4100,
4086,
4084,
3657,
3659,
4098,
4097,
4096,
4095,
4079,
4081,
4083,
3728,
3729,
3730,
3658,
4082,
3678,
3880,
4094,
4078,
4074,
4072,
4092,
3731,
3733,
3732,
4091,
4090,
4089,
4085,
4103,
4104,
7646,
7645,
7643,
7644,
7642,
1754,
6457,
6458,
6455,
6456,
6473,
6472,
6452,
6471,
6470,
6469,
6468,
6467,
6466,
6465,
6464,
6451,
6453,
6454,
6463,
6449,
6462,
6461,
6459,
6419,
6365,
6420,
6367,
6397,
6416,
6386,
6394,
6411,
6371,
6412,
6372,
6438,
6429,
6390,
6408,
6410,
6374,
6398,
6424,
6363,
6405,
6395,
6368,
6422,
6421,
6399,
6415,
6418,
6414,
6384,
3911,
3908,
3906,
3905,
7614,
7612,
7610,
7611,
7613,
3783,
3878,
3812,
3897,
3840,
3848,
3834,
3762,
3763,
3738,
3673,
3862,
3665,
6485,
3721,
3671,
3902,
3725,
3830,
3901,
3781,
3877,
3811,
3896,
3888,
3858,
3801,
3839,
3847,
3833,
3761,
3737,
3700,
3822,
3898,
3861,
3747,
3754,
3813,
3696,
3796,
3768,
3739,
3715,
3795,
3699,
3780,
3704,
6366,
6377,
6385,
6388,
6437,
6440,
6417,
6393,
6373,
6436,
6435,
6379,
6380,
6439,
6432,
6433,
6383,
6430,
6369,
6428,
6427,
6382,
6400,
6425,
6396,
6389,
6376,
6407,
6406,
6381,
6423,
6370,
6401,
6403,
6404,
6387,
6375,
1359,
1360,
1408,
1407,
1379,
1390,
1377,
1397,
1391,
1398,
1296,
1413,
1378,
1356,
1410,
1401,
1411,
1405,
1404,
1305,
1293,
1292,
1291,
1307,
1303,
1306,
1304,
1313,
1302,
1297,
1312,
1311,
1301,
1310,
1309,
1295,
1300,
1298,
1299,
]

_charnames_8275 = [
7434,
10591,
10729,
5680,
-1,
10737,
10746,
5689,
10738,
10129,
5690,
6349,
-1,
-1,
-1,
-1,
-1,
10593,
]

_charnames_8370 = [
7865,
9233,
9536,
2301,
4542,
7435,
5563,
]

_charnames_8524 = [
9776,
9236,
5685,
7349,
6355,
6356,
6354,
]

_charnames_9167 = [
3644,
6348,
6921,
6918,
6919,
6917,
6912,
6913,
6914,
6915,
6920,
3646,
10742,
5669,
8217,
5671,
8219,
5667,
8215,
10694,
8226,
7429,
10731,
9238,
3643,
10177,
]

_charnames_9866 = [
6558,
6557,
10209,
10202,
10203,
10208,
10717,
8211,
9407,
9235,
2296,
7428,
7440,
9232,
10728,
7849,
7427,
9234,
10733,
8941,
5676,
5677,
10724,
9535,
10133,
10132,
10594,
6819,
6817,
6818,
6347,
9527,
6923,
6925,
6924,
6834,
10215,
10687,
1606,
10743,
9904,
2300,
9752,
10509,
6351,
2262,
8191,
7431,
7433,
10753,
7432,
7424,
8142,
7175,
10702,
10703,
8207,
8208,
7436,
7277,
10389,
8186,
5682,
5684,
5686,
10704,
2298,
10216,
-1,
9777,
2147,
9524,
2290,
2260,
10002,
9231,
8201,
10695,
8196,
10712,
10217,
9511,
4695,
7173,
10749,
8202,
10278,
10277,
-1,
9508,
-1,
-1,
-1,
-1,
8212,
7415,
2261,
2148,
9534,
7851,
7852,
6835,
6561,
10686,
10739,
10732,
10751,
7115,
7202,
7439,
10636,
9773,
5562,
10508,
9515,
10744,
1230,
10718,
]

_charnames_10176 = [
5681,
10693,
9774,
8940,
8939,
4680,
10335,
8937,
10272,
7278,
6350,
-1,
4760,
]

_charnames_11008 = [
10000,
9997,
7422,
7419,
4683,
4675,
10681,
10137,
10001,
9998,
7423,
7420,
4684,
10683,
10350,
10349,
4652,
4651,
7184,
7186,
7183,
7185,
10213,
10212,
10211,
10214,
10126,
8194,
10713,
8198,
10706,
8210,
10720,
10716,
8205,
9528,
8195,
8190,
10699,
8189,
10698,
8185,
8184,
10710,
8204,
10715,
8199,
10707,
4690,
5678,
4691,
4759,
4670,
4671,
4672,
4673,
4656,
4654,
4655,
4666,
4668,
4669,
4662,
10723,
3642,
10271,
4660,
10353,
10352,
4674,
10357,
10270,
10356,
5647,
4661,
4659,
10355,
-1,
-1,
-1,
10697,
8183,
10709,
8209,
10719,
9513,
9512,
9509,
9506,
9510,
]

_charnames_11264 = [
7792,
7781,
7783,
7790,
7763,
7745,
7766,
7762,
7767,
7752,
7756,
7749,
7764,
7788,
7775,
7787,
7786,
7773,
7769,
7785,
7739,
7758,
7784,
7778,
7789,
7772,
7770,
7733,
7759,
7791,
7735,
7743,
7744,
7748,
7738,
7746,
7736,
7737,
7747,
7754,
7782,
7755,
7779,
7751,
7734,
7760,
7776,
-1,
7729,
7718,
7720,
7727,
7700,
7682,
7703,
7699,
7704,
7689,
7693,
7686,
7701,
7725,
7712,
7724,
7723,
7710,
7706,
7722,
7676,
7695,
7721,
7715,
7726,
7709,
7707,
7670,
7696,
7728,
7672,
7680,
7681,
7685,
7675,
7683,
7673,
7674,
7684,
7691,
7719,
7692,
7716,
7688,
7671,
7697,
7713,
-1,
4016,
3803,
4014,
4025,
3990,
3746,
3674,
4050,
3884,
4041,
3857,
4053,
3863,
3947,
4035,
3951,
3952,
3821,
4069,
3899,
3824,
4049,
3883,
3679,
3697,
3663,
3791,
4075,
3910,
6460,
4008,
4052,
1552,
1472,
1555,
1475,
1562,
1482,
1526,
1446,
1564,
1484,
1535,
1455,
1554,
1474,
1561,
1481,
1543,
1463,
1560,
1480,
1541,
1461,
1549,
1469,
1559,
1479,
1558,
1478,
1539,
1459,
1497,
1417,
1547,
1467,
1557,
1477,
1536,
1456,
1544,
1464,
1556,
1476,
1563,
1483,
1540,
1460,
1546,
1466,
1519,
1439,
1525,
1445,
1512,
1432,
1532,
1452,
1523,
1443,
1522,
1442,
1530,
1450,
1508,
1428,
1537,
1457,
1533,
1453,
1507,
1427,
1510,
1430,
1553,
1473,
1524,
1444,
1503,
1423,
1501,
1421,
1550,
1470,
1504,
1424,
1502,
1422,
1509,
1429,
1511,
1431,
1506,
1426,
1518,
1438,
1516,
1436,
1515,
1435,
1517,
1437,
1491,
1494,
1493,
1487,
1492,
1490,
1488,
1529,
1449,
1531,
1451,
1569,
1568,
1567,
]

_charnames_11513 = [
1573,
1574,
1572,
1571,
1577,
1576,
1578,
7844,
7843,
7829,
7842,
7841,
7832,
7811,
7814,
7840,
7823,
7839,
7838,
7837,
7836,
7820,
7810,
7834,
7817,
7813,
7833,
7819,
7822,
7828,
7835,
7816,
7805,
7808,
7825,
7807,
7806,
7830,
7826,
7799,
7802,
7801,
7831,
7798,
7800,
]

_charnames_11568 = [
5568,
5592,
5593,
5585,
5587,
5622,
5602,
5569,
5572,
5570,
5571,
5608,
5603,
5582,
5611,
5584,
5590,
5623,
5619,
5591,
5605,
5583,
5612,
5597,
5617,
5607,
5575,
5626,
5616,
5601,
5600,
5599,
5614,
5618,
5598,
5606,
5588,
5589,
5586,
5615,
5625,
5579,
5580,
5581,
5576,
5578,
5604,
5577,
5596,
5595,
5594,
5573,
5620,
5574,
]

_charnames_11648 = [
3624,
3600,
3623,
3546,
3547,
3606,
3609,
3513,
3617,
3616,
3531,
3557,
3619,
3620,
3625,
3610,
3514,
3594,
3593,
3527,
3529,
3526,
3525,
]

_charnames_11680 = [
3536,
3538,
3540,
3537,
3535,
3534,
3539,
-1,
3508,
3510,
3512,
3509,
3507,
3506,
3511,
-1,
3552,
3554,
3556,
3553,
3551,
3550,
3555,
-1,
3501,
3503,
3505,
3502,
3500,
3499,
3504,
-1,
3572,
3574,
3576,
3573,
3571,
3570,
3575,
-1,
3582,
3584,
3586,
3583,
3581,
3580,
3585,
-1,
3562,
3564,
3566,
3563,
3561,
3560,
3565,
-1,
3519,
3521,
3523,
3520,
3518,
3517,
3522,
-1,
1265,
1266,
1273,
1262,
1249,
1250,
1271,
1242,
1241,
1240,
1268,
1267,
1239,
1237,
1256,
1272,
1255,
1275,
1259,
1258,
1274,
1238,
1276,
1247,
1261,
1269,
1253,
1252,
1246,
1270,
1264,
1245,
10340,
10341,
4678,
10333,
4688,
10338,
10387,
10388,
10125,
4693,
10343,
10386,
4685,
10344,
3645,
9749,
10740,
10275,
9531,
10128,
10138,
10682,
10127,
10135,
10592,
9751,
9532,
5646,
4694,
10345,
5645,
5644,
4692,
10342,
5670,
5668,
8218,
8216,
4679,
10334,
4687,
10337,
5688,
8942,
7180,
10747,
10274,
6346,
10360,
10725,
]

_charnames_12736 = [
1974,
1977,
1976,
1981,
1964,
1948,
1955,
1956,
1953,
1963,
1954,
1951,
1957,
1952,
1949,
1979,
1946,
1960,
1970,
1968,
1980,
1947,
1959,
1961,
1965,
1967,
1969,
1973,
1971,
1975,
1962,
1966,
1958,
1950,
1972,
1978,
]

_charnames_12868 = [
2282,
2280,
2281,
2279,
2268,
2266,
2267,
2273,
2274,
2270,
2271,
2275,
9748,
]

_charnames_19904 = [
9413,
9424,
9438,
9500,
9493,
9481,
9419,
9502,
9454,
9430,
9472,
9456,
9499,
9447,
9496,
9503,
9498,
9492,
9488,
9480,
9485,
9450,
9457,
9466,
9460,
9449,
9495,
9448,
9420,
9414,
9462,
9439,
9467,
9446,
9471,
9440,
9429,
9476,
9477,
9434,
9435,
9463,
9484,
9482,
9451,
9470,
9475,
9422,
9468,
9415,
9418,
9426,
9433,
9425,
9490,
9423,
9428,
9427,
9437,
9501,
9461,
9455,
9489,
9486,
]

_charnames_42192 = [
4538,
4505,
4504,
4524,
4493,
4492,
4519,
4513,
4512,
4535,
4527,
4526,
4523,
4491,
4490,
4533,
4510,
4534,
4502,
4498,
4499,
4509,
4516,
4531,
4515,
4537,
4532,
4501,
4530,
4518,
4528,
4529,
4520,
4521,
4536,
4506,
4494,
4496,
4495,
4507,
4483,
4488,
4486,
4487,
4484,
4485,
4541,
4540,
5995,
5996,
5918,
5855,
5856,
5962,
5901,
5908,
5760,
5799,
5752,
5821,
5978,
5946,
5876,
5869,
5784,
5777,
5928,
5954,
5791,
5720,
5892,
5885,
5845,
5838,
5986,
5970,
5736,
5938,
5809,
5701,
5827,
5767,
5743,
5728,
6000,
6001,
5921,
5922,
5860,
5861,
5964,
5903,
5910,
5762,
5805,
5754,
5823,
5980,
5948,
5878,
5871,
5786,
5779,
5932,
5956,
5793,
5722,
5894,
5887,
5847,
5840,
5988,
5972,
5738,
5940,
5813,
5705,
5831,
5769,
5745,
5730,
6002,
6003,
5709,
5923,
5924,
5862,
5863,
5965,
5904,
5911,
5763,
5802,
5803,
5755,
5824,
5981,
5949,
5879,
5872,
5787,
5780,
5933,
5957,
5794,
5723,
5895,
5888,
5848,
5841,
5989,
5973,
5739,
5941,
5810,
5811,
5706,
5832,
5770,
5746,
5731,
5991,
5992,
5914,
5851,
5852,
5960,
5899,
5906,
5758,
5801,
5750,
5817,
5976,
5944,
5874,
5867,
5782,
5775,
5930,
5952,
5789,
5718,
5890,
5883,
5843,
5836,
5984,
5968,
5734,
5936,
5807,
5703,
5829,
5765,
5741,
5726,
5998,
5999,
5919,
5920,
5858,
5859,
5963,
5902,
5909,
5761,
5804,
5753,
5822,
5979,
5947,
5877,
5870,
5785,
5778,
5931,
5955,
5792,
5721,
5893,
5886,
5846,
5839,
5987,
5971,
5737,
5939,
5812,
5704,
5830,
5768,
5744,
5729,
5990,
5993,
5707,
5913,
5915,
5850,
5853,
5959,
5898,
5905,
5757,
5800,
5749,
5816,
5818,
5975,
5943,
5873,
5866,
5781,
5774,
5929,
5951,
5788,
5711,
5889,
5882,
5842,
5835,
5983,
5967,
5733,
5935,
5806,
5702,
5828,
5764,
5740,
5725,
5994,
5997,
5708,
5916,
5917,
5854,
5857,
5961,
5900,
5907,
5759,
5797,
5798,
5751,
5819,
5820,
5977,
5945,
5875,
5868,
5783,
5776,
5926,
5953,
5790,
5719,
5891,
5884,
5844,
5837,
5985,
5969,
5735,
5937,
5808,
5699,
5700,
5825,
5826,
5766,
5742,
5727,
5697,
5927,
6039,
6038,
6037,
5716,
5715,
5713,
6018,
6016,
6007,
6020,
6022,
6019,
6008,
6013,
6011,
6015,
6006,
6012,
6021,
6033,
6034,
6025,
6026,
6031,
6032,
6028,
6029,
6036,
6035,
5714,
5717,
]

_charnames_42560 = [
1737,
1664,
1687,
1614,
1709,
1636,
1716,
1643,
1690,
1617,
1739,
1669,
1732,
1659,
1750,
1679,
1719,
1646,
1713,
1640,
1708,
1635,
1715,
1642,
1745,
1675,
1733,
1660,
1714,
1641,
1718,
1645,
-1,
-1,
1703,
1630,
1702,
1629,
1701,
1628,
1740,
1670,
1734,
1661,
1689,
1616,
1755,
1283,
1279,
1285,
1278,
7438,
]

_charnames_42620 = [
1284,
1282,
1757,
1756,
1688,
1615,
1686,
1613,
1736,
1663,
1746,
1676,
1685,
1612,
1696,
1623,
1695,
1622,
1693,
1620,
1694,
1621,
1697,
1624,
1725,
1652,
1704,
1631,
]

_charnames_42656 = [
8130,
8059,
8126,
8056,
8129,
8085,
8105,
8127,
8042,
8128,
8113,
8099,
8087,
8088,
8112,
8063,
8106,
8045,
8032,
8060,
8077,
8067,
8075,
8078,
8076,
8079,
8055,
8053,
8038,
8037,
8030,
8121,
8073,
8120,
8122,
8043,
8052,
8096,
8031,
8041,
8093,
8124,
8097,
8117,
8089,
8109,
8069,
8044,
8083,
8090,
8054,
8034,
8035,
8036,
8074,
8094,
8115,
8116,
8125,
8046,
8111,
8098,
8110,
8048,
8065,
8084,
8062,
8070,
8107,
8058,
8068,
8066,
8102,
8057,
8103,
8040,
8080,
8118,
8049,
8050,
8135,
8134,
8140,
8141,
8137,
8136,
8138,
8139,
]

_charnames_42752 = [
6479,
6484,
6476,
6481,
6478,
6483,
6477,
6482,
6510,
6541,
6530,
6495,
6516,
6511,
6542,
6531,
6496,
6517,
6512,
6543,
6532,
6492,
6518,
6545,
6546,
6547,
6505,
6534,
6537,
6536,
6535,
6503,
6443,
6442,
3932,
3702,
3933,
3703,
4048,
3882,
3958,
3676,
3959,
3677,
4043,
3871,
4044,
3872,
4099,
4093,
3948,
3755,
3946,
3753,
3945,
3752,
3942,
3749,
3943,
3750,
3944,
3751,
3994,
3767,
4037,
3853,
4040,
3856,
4038,
3854,
4067,
3879,
4015,
3802,
4003,
3793,
4002,
3792,
4004,
3797,
4026,
3831,
4028,
3835,
4027,
3832,
4058,
3866,
4059,
3868,
3992,
3764,
3993,
3770,
4022,
3823,
4019,
3825,
4020,
3826,
3956,
3669,
3957,
3670,
4021,
3827,
3934,
3705,
3974,
3724,
4045,
3873,
6551,
3815,
3808,
3844,
3850,
3769,
4080,
3667,
3782,
3968,
3723,
3967,
3722,
3966,
3955,
3660,
3954,
3664,
3965,
3720,
3964,
3719,
3963,
3718,
6504,
6486,
6445,
4011,
3740,
]

_charnames_43003 = [
4108,
4107,
4110,
4111,
4112,
7324,
7321,
7338,
7315,
7323,
7317,
7337,
7301,
7302,
7307,
7308,
7339,
7310,
7311,
7304,
7305,
7284,
7285,
7290,
7291,
7286,
7287,
7292,
7293,
7318,
7298,
7299,
7313,
7314,
7319,
7296,
7320,
7295,
7316,
7322,
7330,
7328,
7326,
7329,
7327,
7335,
7334,
7333,
7332,
-1,
-1,
-1,
-1,
9985,
9986,
9990,
9984,
9987,
9989,
9992,
9995,
9994,
9993,
-1,
-1,
-1,
-1,
-1,
-1,
9582,
9581,
9585,
9554,
9565,
9567,
9597,
9552,
9550,
9549,
9563,
9555,
9579,
9578,
9601,
9595,
9548,
9547,
9561,
9590,
9572,
9573,
9557,
9588,
9592,
9596,
9558,
9559,
9599,
9568,
9598,
9591,
9586,
9594,
9593,
9589,
9600,
9584,
9587,
9606,
9605,
9545,
9544,
9562,
9553,
9570,
9575,
9576,
9569,
9607,
9608,
9566,
9609,
9613,
9611,
9612,
]

_charnames_43136 = [
7035,
7033,
6955,
6958,
6979,
6980,
6963,
6964,
6933,
6934,
6935,
6936,
6984,
6985,
6957,
6968,
6969,
6956,
6975,
6974,
6983,
6982,
6947,
6988,
6987,
6978,
6977,
6945,
6941,
6940,
6952,
6951,
6946,
6943,
6942,
6954,
6953,
6948,
6967,
6966,
6991,
6990,
6994,
6992,
6993,
6972,
6937,
6961,
6960,
6962,
6995,
6971,
7036,
7005,
7010,
7011,
7006,
7007,
6998,
6999,
7000,
7001,
7012,
7013,
7004,
7008,
7009,
7003,
7034,
]

_charnames_43214 = [
7030,
7029,
7025,
7026,
7017,
7018,
7023,
7024,
7020,
7021,
7028,
7027,
-1,
-1,
-1,
-1,
-1,
-1,
1336,
1337,
1328,
1329,
1334,
1335,
1331,
1332,
1339,
1338,
1347,
1342,
1346,
1345,
1344,
1343,
1341,
1348,
10148,
10146,
10152,
10144,
10145,
10147,
10149,
10168,
10169,
10167,
-1,
-1,
-1,
-1,
8592,
8593,
8584,
8585,
8590,
8591,
8587,
8588,
8595,
8594,
8565,
8564,
8577,
8549,
8556,
8555,
8569,
8548,
8553,
8567,
8550,
8559,
8558,
8574,
8578,
8580,
8573,
8570,
8575,
8571,
8552,
8568,
8572,
8579,
8581,
8562,
8576,
8561,
8598,
8599,
8597,
8600,
8601,
8605,
8603,
8604,
8608,
8607,
10241,
10244,
10228,
10236,
10245,
10230,
10239,
10247,
10233,
10246,
10242,
10225,
10237,
10238,
10240,
10234,
10235,
10243,
10232,
10227,
10229,
10224,
10248,
10259,
10257,
10251,
10256,
10258,
10255,
10252,
10253,
10263,
10262,
10264,
10265,
10260,
]

_charnames_43359 = [
10266,
9381,
9380,
9378,
9382,
9370,
9367,
9373,
9365,
9375,
9374,
9366,
9372,
9368,
9376,
9371,
9401,
9399,
9400,
9390,
9391,
9392,
9386,
9403,
9404,
9387,
9385,
9393,
9406,
9384,
-1,
-1,
-1,
10500,
10497,
10501,
10499,
10438,
10427,
10425,
10426,
10442,
10420,
10397,
10398,
10447,
10439,
10443,
10421,
10423,
10424,
10432,
10433,
10396,
10434,
10435,
10430,
10400,
10431,
10399,
10404,
10405,
10409,
10410,
10402,
10406,
10407,
10411,
10412,
10401,
10417,
10419,
10436,
10437,
10444,
10440,
10428,
10429,
10445,
10441,
10415,
10416,
10413,
10446,
10498,
10487,
10489,
10490,
10491,
10492,
10493,
10488,
10495,
10494,
10504,
10503,
10505,
10469,
10448,
10507,
10459,
10465,
10454,
10463,
10462,
10455,
10453,
10457,
10458,
10461,
10506,
-1,
10468,
10480,
10481,
10472,
10473,
10478,
10479,
10475,
10476,
10483,
10482,
-1,
-1,
-1,
-1,
10464,
10466,
]

_charnames_43520 = [
2208,
2216,
2212,
2218,
2209,
2214,
2198,
2197,
2204,
2203,
2171,
2172,
2207,
2206,
2201,
2200,
2167,
2169,
2168,
2189,
2188,
2182,
2180,
2173,
2174,
2181,
2178,
2176,
2177,
2186,
2184,
2194,
2195,
2185,
2210,
2213,
2215,
2211,
2191,
2192,
2217,
2223,
2228,
2229,
2230,
2224,
2227,
2226,
2222,
2221,
2225,
2250,
2252,
2253,
2251,
]

_charnames_43584 = [
2162,
2163,
2155,
2247,
2164,
2157,
2154,
2160,
2156,
2159,
2161,
2158,
2248,
2249,
-1,
-1,
2241,
2242,
2233,
2234,
2239,
2240,
2236,
2237,
2244,
2243,
-1,
-1,
2259,
2257,
2256,
2258,
6590,
6585,
6584,
6579,
6578,
6575,
6573,
6572,
6569,
6568,
6570,
6576,
6588,
6582,
6581,
6591,
6717,
6587,
6586,
6589,
6630,
6629,
6631,
6675,
6674,
6673,
6627,
6655,
-1,
-1,
-1,
-1,
5296,
5327,
5294,
5325,
5295,
5326,
5314,
5345,
5291,
5322,
5304,
5335,
5305,
5336,
5308,
5339,
5289,
5320,
5316,
5347,
5298,
5329,
5299,
5330,
5290,
5321,
5317,
5348,
5301,
5332,
5302,
5333,
5315,
5346,
5311,
5342,
5306,
5337,
5309,
5340,
5312,
5343,
5307,
5338,
5313,
5344,
5310,
5341,
5378,
5355,
5360,
5357,
5356,
5363,
5362,
5377,
5361,
5358,
5359,
5352,
5351,
5353,
5354,
5375,
5374,
5372,
5373,
]

_charnames_43968 = [
6854,
6878,
6859,
6857,
6850,
6843,
6881,
6846,
6856,
6841,
6848,
6876,
6875,
6880,
6877,
6864,
6852,
6882,
6867,
6863,
6879,
6874,
6862,
6870,
6868,
6871,
6873,
6855,
6860,
6858,
6851,
6844,
6847,
6842,
6865,
6902,
6904,
6906,
6899,
6901,
6900,
6905,
6903,
6907,
6883,
6908,
-1,
-1,
6894,
6895,
6886,
6887,
6892,
6893,
6889,
6890,
6897,
6896,
]

_charnames_55216 = [
9346,
9347,
9334,
9335,
9336,
9359,
9360,
9339,
9338,
9352,
9350,
9349,
9351,
9327,
9326,
9324,
9323,
9330,
9329,
9328,
9331,
9356,
9355,
-1,
-1,
-1,
-1,
9315,
9316,
9246,
9247,
9297,
9291,
9292,
9294,
9295,
9296,
9287,
9289,
9251,
9288,
9285,
9286,
9282,
9283,
9305,
9309,
9307,
9254,
9308,
9310,
9270,
9272,
9273,
9252,
9271,
9268,
9269,
9262,
9263,
9250,
9249,
9261,
9258,
9259,
9260,
9264,
9278,
9279,
9312,
9313,
9319,
9318,
9255,
9276,
9275,
]

_charnames_64107 = [
1944,
1943,
1942,
-1,
-1,
1929,
1928,
1927,
1926,
1925,
1924,
1923,
1922,
1921,
1920,
1919,
1918,
1917,
1916,
1915,
1914,
1912,
1911,
1910,
1909,
1908,
1907,
1906,
1905,
1904,
1903,
1902,
1901,
1900,
1899,
1898,
1897,
1895,
1894,
1893,
1892,
1891,
1890,
1889,
1888,
1887,
1886,
1885,
1884,
1883,
1882,
1881,
1880,
1878,
1877,
1876,
1875,
1874,
1873,
1872,
1871,
1870,
1869,
1868,
1867,
1866,
1865,
1864,
1863,
1861,
1860,
1859,
1858,
1857,
1856,
1855,
1854,
1853,
1852,
1851,
1850,
1849,
1848,
1847,
1846,
1844,
1843,
1842,
1841,
1840,
1839,
1838,
1837,
1836,
1835,
1834,
1833,
1832,
1831,
1830,
1829,
1940,
1939,
1938,
1937,
1936,
1935,
1934,
1933,
1932,
1931,
]

_charnames_65040 = [
9766,
9764,
9763,
9767,
9768,
9771,
9769,
9760,
9756,
9770,
]

_charnames_65536 = [
4306,
4334,
4296,
4321,
4349,
4313,
4326,
4307,
4345,
4292,
4287,
4325,
-1,
4336,
4319,
4276,
4327,
4317,
4283,
4353,
4354,
4346,
4280,
4344,
4301,
4308,
4300,
4340,
4291,
4288,
4311,
4281,
4333,
4348,
4293,
4343,
4275,
4302,
4338,
-1,
4322,
4297,
4290,
4312,
4298,
4339,
4305,
4330,
4347,
4286,
4285,
4310,
4335,
4309,
4315,
4289,
4278,
4331,
4329,
-1,
4342,
4279,
-1,
4303,
4299,
4328,
4352,
4282,
4357,
4324,
4295,
4320,
4277,
4337,
4316,
4318,
4351,
4356,
-1,
-1,
4372,
4371,
4376,
4375,
4369,
4368,
4374,
4366,
4365,
4373,
4363,
4362,
4361,
4360,
]

_charnames_65664 = [
4150,
4149,
4148,
4135,
4134,
4133,
4147,
4146,
4144,
4143,
4141,
4140,
4138,
4137,
4200,
4199,
4198,
4197,
4196,
4384,
4383,
4204,
4203,
4202,
4381,
4380,
4194,
4193,
4192,
4191,
4190,
4180,
4179,
4178,
4177,
4176,
4385,
4175,
4174,
4173,
4161,
4160,
4159,
4158,
4157,
4156,
4155,
4154,
4153,
4152,
4171,
4170,
4169,
4168,
4167,
4166,
4165,
4164,
4163,
4188,
4187,
4186,
4185,
4184,
4183,
4182,
4207,
4206,
4237,
4236,
4234,
4233,
4232,
4231,
4230,
4229,
4227,
4226,
4225,
4224,
4223,
4222,
4386,
4221,
4220,
4218,
4217,
4216,
4215,
4214,
4213,
4212,
4211,
4210,
4271,
4261,
4260,
4259,
4258,
4257,
4256,
4255,
4254,
4253,
4252,
4250,
4249,
4248,
4247,
4246,
4245,
4244,
4243,
4242,
4241,
4268,
4267,
4266,
4265,
4264,
4263,
4269,
4270,
-1,
-1,
-1,
-1,
-1,
9153,
9154,
9160,
-1,
-1,
-1,
-1,
9140,
9085,
9092,
9115,
9122,
9101,
9107,
9134,
9128,
9098,
9089,
9096,
9119,
9126,
9102,
9108,
9135,
9129,
9143,
9088,
9095,
9118,
9125,
9106,
9112,
9139,
9133,
9142,
9087,
9094,
9117,
9124,
9105,
9111,
9138,
9132,
9099,
9090,
9097,
9120,
9127,
9103,
9109,
9136,
9130,
-1,
-1,
-1,
9151,
9148,
9150,
9149,
9147,
9159,
9158,
9157,
9156,
7474,
7470,
7475,
7447,
7458,
7453,
7450,
7461,
7452,
7479,
7463,
7468,
7455,
7472,
7451,
7457,
7480,
7464,
7469,
7456,
7473,
7478,
7462,
7481,
7512,
7490,
7510,
7514,
7488,
7518,
7515,
7501,
7505,
7506,
7509,
7522,
7489,
7487,
7503,
7504,
7511,
7498,
7493,
7486,
7516,
7502,
7497,
7519,
7521,
7492,
7496,
7523,
7520,
7649,
7650,
7632,
7635,
7660,
7638,
7665,
7652,
7633,
7636,
7657,
7658,
7655,
7663,
7647,
7651,
7661,
7525,
7526,
7664,
7637,
7659,
-1,
-1,
-1,
-1,
-1,
10366,
10380,
10368,
10365,
10378,
10369,
10379,
10381,
10367,
10377,
10383,
10382,
]

_charnames_66000 = [
9645,
9643,
9650,
9623,
9625,
9656,
9654,
9669,
9649,
9677,
9636,
9629,
9624,
9663,
9662,
9633,
9666,
9637,
9622,
9672,
9617,
9632,
9619,
9639,
9628,
9652,
9653,
9640,
9621,
9660,
9676,
9671,
9648,
9638,
9644,
9673,
9646,
9659,
9665,
9674,
9675,
9668,
9630,
9631,
9657,
9618,
]

_charnames_66176 = [
4713,
4709,
4711,
4712,
4727,
4728,
4725,
4717,
4715,
4702,
4724,
4707,
4721,
4723,
4705,
4703,
4706,
4704,
4718,
4722,
4708,
4720,
4719,
4700,
4701,
4714,
4710,
4726,
4716,
-1,
-1,
-1,
2141,
2127,
2136,
2121,
2099,
2124,
2122,
2142,
2144,
2146,
2109,
2145,
2137,
2118,
2106,
2107,
2103,
2140,
2097,
2115,
2143,
2114,
2120,
2126,
2108,
2130,
2134,
2100,
2128,
2129,
2117,
2098,
2132,
2133,
2104,
2105,
2116,
2131,
2139,
2119,
2102,
2125,
2110,
2113,
2112,
2111,
2123,
2135,
2101,
]

_charnames_66432 = [
10665,
10677,
10660,
10654,
10663,
10656,
10668,
10652,
10657,
10649,
10667,
10655,
10645,
10675,
10674,
10662,
10673,
10651,
10642,
10666,
10672,
10643,
10671,
10670,
10648,
10659,
10647,
10676,
10669,
10644,
-1,
10678,
8711,
8757,
8754,
8745,
8744,
8751,
8750,
8733,
8760,
8748,
8747,
8718,
8716,
8706,
8710,
8709,
8717,
8755,
8728,
8759,
8742,
8741,
8726,
8725,
8724,
8753,
8736,
8735,
8739,
8738,
8756,
8722,
8752,
8721,
8720,
8758,
-1,
-1,
-1,
-1,
8712,
8714,
8713,
8732,
8707,
8708,
8729,
8730,
8769,
8767,
8764,
8766,
8765,
8768,
]

_charnames_66638 = [
10172,
10173,
7404,
7380,
7407,
7410,
7378,
7393,
7392,
7412,
7387,
7398,
7413,
7411,
7409,
7401,
7379,
7400,
7396,
7408,
7390,
7399,
7406,
7395,
7382,
7375,
7358,
7362,
7367,
7389,
7364,
7360,
7403,
7405,
7372,
7361,
7383,
7402,
7369,
7366,
7368,
7357,
7356,
7365,
7359,
7374,
7355,
7373,
7384,
7386,
8882,
8913,
8901,
8907,
8898,
8890,
8896,
8902,
8886,
8885,
8895,
8912,
8910,
8911,
8903,
8891,
8906,
8905,
8904,
8899,
8909,
8897,
8881,
8892,
8908,
8887,
8900,
8883,
8893,
8888,
-1,
-1,
8924,
8925,
8916,
8917,
8922,
8923,
8919,
8920,
8927,
8926,
]

_charnames_67584 = [
1825,
1824,
1823,
1822,
1821,
1820,
-1,
-1,
1819,
-1,
1806,
1805,
1804,
1803,
1802,
1800,
1799,
1798,
1797,
1796,
1794,
1793,
1792,
1791,
1790,
1788,
1787,
1786,
1785,
1784,
1782,
1781,
1780,
1779,
1778,
1776,
1775,
1774,
1773,
1772,
1770,
1769,
1768,
1767,
1766,
1764,
1763,
1762,
1761,
1760,
1811,
1810,
1809,
1808,
-1,
1817,
1816,
-1,
-1,
-1,
1814,
-1,
-1,
1813,
10609,
10622,
10620,
10621,
10605,
10612,
10610,
10606,
10603,
10611,
10619,
10618,
10617,
10616,
10599,
10608,
10615,
10600,
10614,
10613,
10601,
10604,
-1,
10635,
10631,
10626,
10630,
10628,
10627,
10634,
10633,
10629,
]

_charnames_67840 = [
9690,
9704,
9702,
9703,
9687,
9694,
9692,
9688,
9685,
9693,
9701,
9700,
9699,
9698,
9682,
9691,
9697,
9683,
9696,
9695,
9681,
9686,
9712,
9711,
9709,
9713,
9708,
9710,
-1,
-1,
-1,
9714,
4741,
4756,
4752,
4754,
4739,
4744,
4751,
4743,
4750,
4737,
4749,
4735,
4748,
4746,
4734,
4731,
4745,
4753,
4747,
4733,
4732,
4742,
4740,
4738,
4736,
4755,
-1,
-1,
-1,
-1,
-1,
4757,
]

_charnames_68096 = [
8410,
8431,
8429,
8428,
-1,
8432,
8430,
-1,
-1,
-1,
-1,
-1,
8433,
8437,
8442,
8439,
8389,
8388,
8395,
8394,
-1,
8398,
8397,
8408,
-1,
8383,
8369,
8368,
8375,
8374,
8384,
8371,
8370,
8377,
8376,
8385,
8392,
8391,
8401,
8400,
8406,
8403,
8405,
8407,
8404,
8380,
8379,
8381,
8402,
8409,
8387,
8367,
-1,
-1,
-1,
-1,
8441,
8440,
8438,
-1,
-1,
-1,
-1,
8434,
8454,
8452,
8453,
8455,
8446,
8445,
8449,
8448,
]

_charnames_68176 = [
8415,
8423,
8422,
8421,
8424,
8418,
8416,
8414,
8419,
]

_charnames_68192 = [
8792,
8807,
8793,
8806,
8804,
8802,
8783,
8803,
8809,
8777,
8780,
8791,
8805,
8790,
8782,
8781,
8808,
8799,
8798,
8787,
8795,
8788,
8796,
8776,
8800,
8786,
8801,
8775,
8774,
8812,
8813,
8814,
]

_charnames_68352 = [
9163,
9164,
9169,
9165,
9170,
9166,
9167,
9168,
9212,
9213,
9205,
9206,
9207,
9208,
9203,
9204,
9225,
9188,
9186,
9187,
9196,
9195,
9194,
9228,
9226,
9192,
9191,
9216,
9215,
9190,
9222,
9227,
9219,
9218,
9175,
9173,
9174,
9178,
9176,
9177,
9223,
9210,
9201,
9202,
9220,
9221,
9224,
9184,
9199,
9182,
9198,
9181,
9183,
9211,
-1,
-1,
-1,
9229,
5648,
7437,
4116,
4119,
4115,
4118,
10527,
10540,
10538,
10539,
10523,
10530,
10528,
10524,
10521,
10529,
10537,
10536,
10535,
10534,
10517,
10526,
10533,
10518,
10532,
10531,
10519,
10522,
-1,
-1,
10548,
10544,
10546,
10552,
10547,
10545,
10551,
10550,
10576,
10575,
10573,
10574,
10563,
10567,
10565,
10564,
10561,
10566,
10572,
10571,
10570,
10569,
10557,
10568,
10558,
10559,
10562,
-1,
-1,
-1,
-1,
-1,
10584,
10580,
10582,
10588,
10583,
10581,
10587,
10586,
]

_charnames_68608 = [
8624,
8670,
8671,
8665,
8701,
8689,
8659,
8660,
8698,
8646,
8688,
8635,
8678,
8644,
8686,
8633,
8677,
8645,
8687,
8634,
8653,
8694,
8638,
8679,
8626,
8674,
8632,
8676,
8661,
8699,
8643,
8685,
8631,
8657,
8656,
8642,
8630,
8672,
8650,
8692,
8652,
8693,
8649,
8691,
8684,
8651,
8673,
8655,
8664,
8667,
8658,
8696,
8641,
8683,
8666,
8702,
8663,
8700,
8640,
8682,
8629,
8636,
8628,
8637,
8681,
8654,
8695,
8639,
8680,
8627,
8675,
8662,
8668,
]

_charnames_69216 = [
10320,
10312,
10313,
10318,
10319,
10315,
10316,
10322,
10321,
10288,
10284,
10287,
10299,
10302,
10291,
10294,
10307,
10304,
10309,
10283,
10286,
10298,
10301,
10292,
10295,
10308,
10305,
10327,
10326,
10325,
10328,
]

_charnames_69760 = [
8534,
8535,
8531,
8477,
8480,
8499,
8500,
8485,
8486,
8516,
8479,
8512,
8478,
8495,
8494,
8503,
8502,
8475,
8506,
8505,
8498,
8497,
8473,
8469,
8468,
8463,
8462,
8461,
8488,
8474,
8471,
8470,
8465,
8464,
8476,
8492,
8491,
8509,
8508,
8513,
8510,
8489,
8514,
8511,
8483,
8482,
8484,
8515,
8521,
8524,
8525,
8522,
8523,
8527,
8520,
8526,
8519,
8532,
8533,
8544,
8543,
8542,
8536,
8539,
8541,
8540,
]

_charnames_73728 = [
612,
669,
668,
667,
666,
665,
664,
663,
662,
690,
613,
627,
626,
621,
620,
625,
618,
617,
624,
623,
622,
628,
629,
635,
634,
633,
632,
631,
689,
682,
685,
684,
636,
646,
645,
644,
643,
640,
639,
642,
641,
648,
647,
686,
687,
670,
676,
675,
674,
673,
677,
688,
679,
680,
681,
660,
650,
656,
657,
655,
653,
654,
659,
658,
1036,
1044,
1043,
1042,
1037,
1039,
1038,
1040,
1041,
1055,
1059,
1058,
1057,
1045,
1049,
1048,
1050,
1053,
1054,
1051,
1052,
766,
767,
790,
789,
787,
786,
772,
773,
770,
771,
774,
796,
783,
784,
795,
779,
776,
778,
777,
794,
793,
792,
791,
782,
781,
801,
797,
800,
799,
819,
826,
820,
822,
821,
823,
824,
825,
802,
813,
814,
812,
808,
810,
809,
815,
816,
818,
803,
804,
805,
806,
807,
817,
827,
874,
875,
861,
869,
868,
867,
865,
864,
866,
879,
878,
877,
852,
855,
856,
857,
860,
859,
858,
872,
871,
876,
828,
835,
836,
837,
838,
851,
848,
849,
846,
847,
850,
840,
841,
842,
831,
832,
834,
833,
845,
844,
5,
97,
6,
13,
12,
11,
17,
16,
14,
15,
64,
63,
60,
61,
58,
55,
56,
57,
52,
53,
50,
51,
34,
33,
28,
29,
30,
31,
46,
44,
45,
48,
47,
75,
74,
40,
39,
36,
37,
41,
78,
72,
71,
68,
69,
77,
25,
24,
20,
21,
22,
26,
76,
65,
66,
67,
79,
93,
94,
91,
92,
86,
88,
87,
96,
80,
81,
83,
84,
85,
89,
90,
95,
153,
154,
98,
126,
125,
127,
119,
121,
122,
128,
107,
108,
100,
106,
105,
104,
103,
102,
118,
110,
117,
115,
114,
116,
129,
152,
130,
133,
134,
136,
135,
137,
143,
147,
146,
148,
151,
149,
150,
138,
142,
141,
140,
1003,
1005,
1006,
1007,
983,
985,
986,
993,
992,
991,
990,
989,
988,
987,
994,
995,
1001,
1000,
999,
998,
997,
1002,
955,
981,
980,
973,
976,
975,
963,
964,
969,
966,
967,
968,
970,
972,
971,
956,
958,
961,
960,
959,
962,
979,
978,
977,
293,
337,
338,
339,
340,
335,
334,
333,
336,
356,
355,
296,
300,
299,
297,
298,
301,
305,
303,
304,
306,
307,
353,
352,
344,
342,
343,
350,
349,
319,
323,
322,
321,
324,
325,
347,
346,
360,
359,
314,
315,
313,
312,
311,
310,
317,
316,
358,
326,
330,
329,
328,
327,
357,
380,
381,
382,
366,
365,
364,
362,
363,
378,
379,
371,
373,
374,
377,
376,
367,
370,
369,
408,
395,
404,
402,
403,
406,
405,
400,
399,
397,
398,
383,
394,
393,
388,
389,
392,
386,
387,
391,
384,
385,
390,
407,
156,
158,
161,
165,
164,
163,
168,
167,
166,
223,
222,
226,
225,
206,
207,
204,
205,
218,
219,
220,
202,
198,
201,
200,
190,
191,
189,
187,
188,
196,
195,
193,
194,
214,
215,
216,
224,
183,
182,
181,
178,
179,
184,
211,
210,
212,
169,
172,
171,
175,
174,
173,
227,
228,
230,
231,
232,
233,
239,
237,
238,
234,
235,
236,
288,
291,
290,
289,
240,
287,
241,
268,
267,
260,
261,
266,
265,
264,
249,
247,
248,
250,
259,
258,
263,
256,
255,
253,
252,
262,
269,
274,
273,
271,
272,
286,
275,
278,
279,
280,
285,
284,
281,
282,
283,
942,
946,
947,
950,
949,
948,
943,
944,
953,
954,
951,
952,
920,
941,
937,
938,
940,
939,
921,
926,
925,
924,
927,
928,
929,
930,
933,
934,
935,
936,
748,
758,
749,
753,
751,
752,
754,
757,
755,
756,
759,
763,
762,
764,
721,
747,
746,
741,
744,
743,
722,
732,
730,
731,
740,
739,
738,
737,
724,
728,
726,
727,
735,
734,
745,
692,
720,
693,
715,
714,
711,
712,
713,
718,
719,
716,
717,
694,
706,
705,
704,
703,
702,
701,
700,
699,
698,
697,
707,
708,
1030,
1033,
1032,
1031,
1034,
1009,
1019,
1020,
1018,
1017,
1021,
1014,
1015,
1012,
1013,
1022,
1023,
1028,
1027,
1026,
1029,
1081,
1082,
1084,
1083,
465,
490,
466,
488,
481,
482,
487,
480,
479,
486,
485,
484,
477,
476,
483,
474,
473,
472,
471,
470,
489,
491,
492,
493,
495,
494,
436,
437,
446,
445,
444,
443,
442,
441,
439,
440,
449,
448,
447,
450,
458,
457,
456,
460,
459,
451,
453,
452,
430,
433,
432,
412,
425,
418,
417,
424,
423,
414,
415,
422,
421,
420,
419,
435,
426,
428,
429,
434,
461,
464,
463,
462,
505,
511,
506,
507,
508,
510,
509,
496,
504,
501,
502,
503,
499,
500,
497,
498,
881,
896,
894,
893,
895,
897,
900,
899,
882,
890,
889,
886,
885,
888,
887,
902,
901,
917,
918,
903,
910,
909,
904,
908,
906,
907,
911,
916,
915,
914,
912,
913,
512,
602,
601,
600,
599,
598,
611,
610,
564,
573,
570,
569,
567,
568,
574,
571,
572,
575,
576,
581,
580,
579,
578,
586,
582,
585,
584,
607,
608,
513,
562,
561,
545,
554,
553,
555,
557,
556,
547,
550,
549,
563,
558,
559,
514,
533,
534,
542,
541,
517,
520,
519,
518,
521,
540,
529,
528,
527,
539,
538,
537,
536,
532,
531,
535,
525,
524,
523,
543,
544,
587,
592,
589,
590,
591,
593,
595,
594,
609,
604,
605,
606,
1073,
1075,
1076,
1078,
1077,
1079,
1061,
1067,
1066,
1062,
1063,
1065,
1064,
1068,
1069,
1070,
1072,
1071,
]

_charnames_74752 = [
1157,
1141,
1103,
1120,
1173,
1171,
1223,
1212,
1143,
1106,
1123,
1179,
1170,
1222,
1211,
1105,
1122,
1176,
1167,
1219,
1208,
1190,
1153,
1140,
1102,
1119,
1178,
1169,
1221,
1210,
1189,
1152,
1139,
1101,
1118,
1150,
1129,
1130,
1099,
1111,
1177,
1168,
1220,
1209,
1197,
1149,
1127,
1128,
1098,
1110,
1182,
1181,
1195,
1155,
1132,
1133,
1096,
1116,
1137,
1136,
1088,
1092,
1091,
1090,
1175,
1166,
1165,
1164,
1217,
1218,
1204,
1206,
1205,
1207,
1158,
1142,
1104,
1121,
1174,
1196,
1156,
1134,
1094,
1095,
1114,
1115,
1214,
1215,
1192,
1159,
1187,
1147,
1112,
1186,
1146,
1193,
1198,
1200,
1201,
]

_charnames_77824 = [
2346,
2345,
2344,
2343,
2338,
2339,
2335,
2337,
2336,
2342,
2341,
2340,
2333,
2332,
2331,
2330,
2324,
2325,
2329,
2328,
2322,
2323,
2327,
2326,
2391,
2390,
2389,
2388,
2387,
2386,
2385,
2384,
2383,
2382,
2358,
2357,
2348,
2349,
2356,
2355,
2354,
2353,
2352,
2351,
2350,
2313,
2314,
2320,
2311,
2312,
2309,
2310,
2319,
2307,
2308,
2318,
2317,
2316,
2315,
2380,
2379,
2378,
2377,
2376,
2375,
2374,
2373,
2372,
2371,
2369,
2368,
2367,
2366,
2365,
2364,
2363,
2362,
2361,
2360,
2392,
3455,
3454,
3453,
3452,
3446,
3447,
3451,
3450,
3449,
3448,
3364,
3353,
3356,
3355,
3354,
3363,
3362,
3361,
3360,
3359,
3358,
3357,
3366,
3367,
3376,
3375,
3374,
3373,
3372,
3371,
3370,
3369,
3368,
3382,
3381,
3380,
3379,
3378,
2642,
2641,
2640,
2639,
2638,
2637,
2636,
2633,
2634,
2635,
2631,
2630,
2629,
2628,
2627,
2626,
2625,
2624,
2623,
2622,
2620,
2619,
2618,
2617,
2616,
2615,
2614,
2610,
2611,
2613,
2612,
2608,
2599,
2600,
2607,
2606,
2597,
2598,
2605,
2604,
2603,
2602,
2601,
2595,
2594,
2593,
2592,
2591,
2590,
2586,
2587,
2589,
2584,
2585,
2588,
2545,
2554,
2553,
2552,
2551,
2550,
2549,
2548,
2547,
2546,
2565,
2557,
2558,
2564,
2555,
2556,
2563,
2562,
2561,
2560,
2559,
2582,
2581,
2580,
2579,
2578,
2577,
2576,
2567,
2575,
2574,
2573,
2572,
2571,
2570,
2569,
2568,
3222,
3221,
3220,
3219,
3218,
3217,
3216,
3214,
3215,
3212,
3213,
3210,
3209,
3208,
3207,
3206,
3205,
3201,
3202,
3199,
3200,
3204,
3203,
3188,
3189,
3197,
3196,
3195,
3194,
3193,
3192,
3191,
3186,
3187,
3190,
3232,
3231,
3230,
3229,
3224,
3225,
3228,
3227,
3226,
2933,
2934,
2942,
2941,
2940,
2939,
2938,
2937,
2936,
2935,
2931,
2930,
2929,
2921,
2922,
2928,
2927,
2926,
2925,
2924,
2923,
2919,
2909,
2910,
2918,
2917,
2916,
2915,
2914,
2913,
2912,
2911,
2907,
2899,
2900,
2906,
2905,
2904,
2903,
2902,
2897,
2898,
2895,
2896,
2901,
2893,
2892,
2891,
2890,
2889,
2885,
2886,
2883,
2884,
2881,
2882,
2888,
2887,
2950,
2944,
2947,
2946,
2945,
2949,
2948,
3003,
3002,
3001,
3000,
2999,
2995,
2996,
2992,
2994,
2993,
2998,
2997,
3015,
3005,
3006,
3014,
3013,
3012,
3011,
3010,
3009,
3008,
3007,
2981,
2982,
2990,
2989,
2988,
2987,
2986,
2979,
2980,
2985,
2984,
2983,
2977,
2976,
2975,
2974,
2973,
2972,
2968,
2969,
2966,
2967,
2971,
2970,
2964,
2963,
2962,
2955,
2956,
2961,
2953,
2954,
2960,
2959,
2958,
2957,
3021,
3020,
3019,
3018,
3017,
3475,
3474,
3473,
3472,
3471,
3467,
3468,
3470,
3469,
3395,
3394,
3393,
3392,
3387,
3388,
3391,
3390,
3389,
3385,
3386,
3399,
3400,
3397,
3398,
3404,
3403,
3402,
3401,
3484,
3483,
3482,
3481,
3480,
3479,
3478,
3477,
3444,
3437,
3438,
3443,
3442,
3441,
3435,
3436,
3440,
3439,
2860,
2862,
2861,
2871,
2863,
2864,
2870,
2869,
2868,
2867,
2866,
2865,
2824,
2825,
2830,
2809,
2817,
2816,
2815,
2814,
2813,
2812,
2811,
2810,
2829,
2828,
2822,
2823,
2820,
2821,
2818,
2819,
2827,
2826,
2858,
2857,
2850,
2851,
2856,
2848,
2849,
2855,
2854,
2853,
2846,
2847,
2852,
2844,
2835,
2836,
2843,
2832,
2834,
2833,
2842,
2841,
2840,
2839,
2838,
2837,
2873,
2874,
2878,
2877,
2876,
2875,
2483,
2482,
2481,
2480,
2479,
2478,
2477,
2476,
2475,
2461,
2460,
2459,
2458,
2457,
2456,
2455,
2454,
2450,
2452,
2451,
2453,
2473,
2472,
2471,
2470,
2469,
2463,
2464,
2468,
2467,
2466,
2465,
2448,
2447,
2446,
2441,
2442,
2439,
2440,
2437,
2438,
2445,
2435,
2436,
2444,
2443,
2487,
2486,
2485,
2541,
2540,
2539,
2538,
2532,
2533,
2537,
2536,
2535,
2534,
2530,
2529,
2528,
2527,
2526,
2525,
2524,
2520,
2521,
2523,
2522,
2542,
2512,
2511,
2510,
2509,
2508,
2507,
2506,
2505,
2504,
2494,
2495,
2492,
2493,
2502,
2501,
2500,
2499,
2498,
2497,
2490,
2491,
2496,
2517,
2516,
2514,
2515,
2736,
2737,
2743,
2742,
2741,
2734,
2735,
2727,
2733,
2732,
2731,
2730,
2729,
2728,
2740,
2739,
2738,
2777,
2780,
2779,
2778,
2790,
2789,
2788,
2787,
2786,
2785,
2784,
2783,
2781,
2782,
2768,
2769,
2775,
2774,
2773,
2766,
2767,
2764,
2765,
2772,
2771,
2770,
2762,
2763,
2752,
2753,
2760,
2759,
2750,
2751,
2758,
2757,
2745,
2749,
2748,
2747,
2746,
2756,
2755,
2754,
2801,
2800,
2799,
2798,
2797,
2796,
2795,
2794,
2793,
2792,
2803,
2805,
2804,
2806,
3409,
3410,
3417,
3407,
3408,
3416,
3415,
3414,
3413,
3412,
3411,
3420,
3419,
3492,
3491,
3490,
3489,
3488,
3487,
3486,
3303,
3295,
3296,
3292,
3294,
3293,
3302,
3301,
3300,
3299,
3298,
3297,
3281,
3282,
3290,
3289,
3288,
3287,
3286,
3279,
3280,
3285,
3284,
3283,
3314,
3313,
3312,
3311,
3310,
3309,
3308,
3307,
3306,
3305,
3073,
3065,
3066,
3072,
3071,
3070,
3063,
3064,
3069,
3068,
3067,
3036,
3035,
3034,
3033,
3024,
3026,
3025,
3032,
3031,
3027,
3028,
3030,
3029,
3049,
3048,
3047,
3046,
3045,
3044,
3038,
3040,
3039,
3043,
3042,
3041,
3061,
3060,
3059,
3058,
3057,
3051,
3052,
3056,
3055,
3054,
3053,
3081,
3080,
3079,
3078,
3077,
3076,
3075,
3149,
3148,
3143,
3144,
3147,
3146,
3145,
3141,
3142,
3139,
3140,
3137,
3138,
3162,
3153,
3154,
3161,
3160,
3159,
3158,
3151,
3152,
3157,
3156,
3155,
3173,
3172,
3171,
3170,
3169,
3168,
3167,
3166,
3165,
3164,
3183,
3182,
3177,
3178,
3175,
3176,
3181,
3180,
3179,
3119,
3118,
3117,
3116,
3115,
3109,
3111,
3110,
3114,
3113,
3112,
3130,
3129,
3128,
3127,
3126,
3125,
3124,
3123,
3122,
3121,
3095,
3094,
3093,
3086,
3087,
3092,
3091,
3090,
3089,
3088,
3084,
3085,
3107,
3106,
3097,
3098,
3105,
3104,
3103,
3102,
3101,
3100,
3099,
3134,
3133,
3132,
2671,
2680,
2679,
2678,
2677,
2676,
2675,
2674,
2673,
2672,
2684,
2685,
2691,
2690,
2689,
2688,
2681,
2683,
2682,
2687,
2686,
2707,
2693,
2696,
2695,
2694,
2697,
2699,
2698,
2706,
2705,
2704,
2703,
2702,
2701,
2700,
2645,
2657,
2656,
2655,
2654,
2653,
2652,
2651,
2650,
2649,
2648,
2647,
2646,
2669,
2668,
2662,
2663,
2667,
2666,
2665,
2664,
2660,
2661,
2658,
2659,
2715,
2716,
2713,
2714,
2722,
2711,
2712,
2721,
2720,
2719,
2709,
2710,
2718,
2717,
2723,
2724,
3342,
3341,
3334,
3335,
3340,
3339,
3338,
3337,
3336,
3332,
3333,
3323,
3324,
3330,
3329,
3328,
3321,
3322,
3327,
3326,
3319,
3320,
3317,
3318,
3325,
3350,
3349,
3348,
3347,
3344,
3345,
3346,
3433,
3432,
3431,
3422,
3424,
3423,
3430,
3427,
3428,
3429,
3425,
3426,
3457,
3458,
3465,
3464,
3463,
3462,
3461,
3460,
3459,
3276,
3260,
3264,
3263,
3262,
3261,
3265,
3267,
3266,
3270,
3271,
3268,
3269,
3275,
3274,
3273,
3272,
3258,
3257,
3256,
3255,
3254,
3235,
3244,
3243,
3242,
3241,
3240,
3239,
3238,
3237,
3236,
3245,
3253,
3252,
3251,
3250,
3249,
3248,
3247,
3246,
2405,
2404,
2403,
2402,
2401,
2400,
2395,
2397,
2396,
2399,
2398,
2427,
2426,
2425,
2424,
2423,
2422,
2421,
2420,
2419,
2418,
2416,
2415,
2414,
2413,
2412,
2411,
2410,
2409,
2408,
2407,
2431,
2430,
2429,
]

_charnames_119296 = [
7567,
7584,
7595,
7594,
7578,
7593,
7592,
7591,
7590,
7577,
7576,
7575,
7574,
7573,
7572,
7571,
7570,
7569,
7568,
7589,
7588,
7587,
7586,
7585,
7583,
7582,
7581,
7580,
7579,
7536,
7544,
7528,
7551,
7565,
7564,
7543,
7542,
7541,
7540,
7539,
7538,
7537,
7550,
7549,
7548,
7547,
7546,
7545,
7563,
7562,
7561,
7560,
7559,
7558,
7535,
7534,
7533,
7532,
7531,
7530,
7529,
7556,
7555,
7554,
7553,
7552,
1386,
1387,
1388,
7654,
]

_charnames_119552 = [
6559,
10206,
10205,
10200,
10199,
10197,
5440,
5477,
5509,
5520,
5529,
5427,
5504,
5525,
5518,
5450,
5446,
5536,
5532,
5502,
5472,
5429,
5534,
5523,
5480,
5506,
5471,
5468,
5463,
5539,
5428,
5458,
5452,
5439,
5451,
5519,
5500,
5516,
5436,
5528,
5492,
5488,
5501,
5476,
5469,
5514,
5470,
5496,
5459,
5486,
5495,
5457,
5499,
5473,
5481,
5537,
5430,
5510,
5461,
5538,
5445,
5437,
5494,
5493,
5511,
5507,
5462,
5453,
5522,
5489,
5531,
5449,
5454,
5444,
5460,
5490,
5487,
5535,
5433,
5438,
5482,
5505,
5432,
5526,
5447,
5515,
5479,
]

_charnames_119648 = [
1590,
1582,
1583,
1588,
1589,
1585,
1586,
1592,
1591,
1603,
1595,
1596,
1601,
1602,
1598,
1599,
1605,
1604,
]

_charnames_126976 = [
6776,
6733,
6780,
6769,
6784,
6787,
6779,
6760,
6738,
6743,
6749,
6754,
6724,
6729,
6774,
6767,
6761,
6739,
6744,
6750,
6755,
6725,
6730,
6775,
6768,
6759,
6737,
6742,
6748,
6753,
6723,
6728,
6773,
6766,
6785,
6762,
6782,
6788,
6732,
6731,
6789,
6778,
6786,
6783,
-1,
-1,
-1,
-1,
10123,
10122,
10121,
10120,
10119,
10118,
10117,
10116,
10114,
10113,
10112,
10111,
10110,
10109,
10108,
10106,
10105,
10104,
10103,
10102,
10101,
10100,
10098,
10097,
10096,
10095,
10094,
10093,
10092,
10090,
10089,
10088,
10087,
10086,
10085,
10084,
10082,
10081,
10080,
10079,
10078,
10077,
10076,
10074,
10073,
10072,
10071,
10070,
10069,
10068,
10064,
10063,
10062,
10061,
10060,
10059,
10058,
10057,
10055,
10054,
10053,
10052,
10051,
10050,
10049,
10047,
10046,
10045,
10044,
10043,
10042,
10041,
10039,
10038,
10037,
10036,
10035,
10034,
10033,
10031,
10030,
10029,
10028,
10027,
10026,
10025,
10023,
10022,
10021,
10020,
10019,
10018,
10017,
10015,
10014,
10013,
10012,
10011,
10010,
10009,
]

_charnames_127232 = [
10182,
10183,
10193,
10185,
10186,
10191,
10192,
10188,
10189,
10195,
10194,
-1,
-1,
-1,
-1,
-1,
9744,
9743,
9742,
9741,
9740,
9739,
9738,
9737,
9736,
9735,
9734,
9733,
9732,
9731,
9730,
9729,
9728,
9727,
9726,
9725,
9724,
9723,
9722,
9721,
9720,
9719,
5665,
2285,
2284,
2291,
2292,
-1,
-1,
7169,
]

_charnames_127293 = [
7168,
-1,
7167,
-1,
-1,
7166,
-1,
-1,
-1,
7165,
-1,
-1,
-1,
7179,
7178,
7172,
7171,
7177,
]

_charnames_127353 = [
9895,
-1,
9894,
9893,
-1,
-1,
9892,
]

_charnames_127370 = [
2297,
9898,
9897,
9896,
-1,
-1,
7192,
]

_charnames_127504 = [
7139,
7131,
7125,
7176,
7153,
7122,
7158,
7121,
7152,
7147,
7162,
7142,
7127,
7129,
7134,
7141,
7128,
7160,
7161,
7157,
7132,
7133,
7146,
7137,
7144,
7151,
7150,
7163,
7130,
7154,
7124,
7145,
7156,
7138,
]

_charnames_127552 = [
5653,
5664,
5663,
5660,
5658,
5655,
5657,
5661,
5654,
]

_charnames_917760 = [
6064,
6053,
6042,
6197,
6186,
6175,
6164,
6153,
6208,
6219,
6218,
6217,
6216,
6296,
6295,
6294,
6293,
6292,
6291,
6290,
6289,
6288,
6287,
6285,
6284,
6283,
6282,
6281,
6280,
6279,
6278,
6277,
6276,
6274,
6273,
6272,
6271,
6270,
6269,
6268,
6267,
6266,
6265,
6263,
6262,
6261,
6260,
6259,
6258,
6257,
6256,
6255,
6254,
6252,
6251,
6250,
6249,
6248,
6247,
6246,
6245,
6244,
6243,
6241,
6240,
6239,
6238,
6237,
6236,
6235,
6234,
6233,
6232,
6230,
6229,
6228,
6227,
6226,
6225,
6224,
6223,
6222,
6221,
6151,
6150,
6149,
6148,
6147,
6146,
6145,
6144,
6143,
6142,
6140,
6139,
6138,
6137,
6136,
6135,
6134,
6133,
6132,
6131,
6129,
6128,
6127,
6126,
6125,
6124,
6123,
6122,
6121,
6120,
6118,
6117,
6116,
6115,
6114,
6113,
6112,
6111,
6110,
6109,
6107,
6106,
6105,
6104,
6103,
6102,
6101,
6100,
6099,
6098,
6096,
6095,
6094,
6093,
6092,
6091,
6090,
6089,
6088,
6087,
6085,
6084,
6083,
6082,
6081,
6080,
6079,
6078,
6077,
6076,
6074,
6073,
6072,
6071,
6070,
6069,
6068,
6067,
6066,
6065,
6063,
6062,
6061,
6060,
6059,
6058,
6057,
6056,
6055,
6054,
6052,
6051,
6050,
6049,
6048,
6047,
6046,
6045,
6044,
6043,
6207,
6206,
6205,
6204,
6203,
6202,
6201,
6200,
6199,
6198,
6196,
6195,
6194,
6193,
6192,
6191,
6190,
6189,
6188,
6187,
6185,
6184,
6183,
6182,
6181,
6180,
6179,
6178,
6177,
6176,
6174,
6173,
6172,
6171,
6170,
6169,
6168,
6167,
6166,
6165,
6163,
6162,
6161,
6160,
6159,
6158,
6157,
6156,
6155,
6154,
6215,
6214,
6213,
6212,
6211,
6210,
6209,
]

_charnames_983040 = [
4065,
3887,
8617,
4122,
4123,
4124,
4125,
5632,
10752,
9757,
8227,
]

_charnames_983552 = [
3941,
3748,
3917,
3682,
3919,
3684,
3920,
3685,
3928,
3693,
3929,
3694,
3973,
3716,
3711,
3851,
3997,
3786,
3999,
3788,
4000,
3789,
4007,
3735,
3979,
3775,
3939,
3745,
3938,
3744,
3923,
3688,
3922,
3687,
3926,
3691,
3925,
3690,
3710,
3709,
3972,
3714,
3971,
3713,
4061,
3894,
4013,
3800,
4034,
3838,
3989,
3759,
3983,
3779,
3982,
3778,
3980,
3776,
3978,
3774,
5095,
5084,
5103,
5083,
5092,
5081,
5091,
5080,
5099,
5100,
5097,
5093,
5088,
5098,
5090,
5089,
5094,
5082,
5101,
5087,
5086,
5085,
5102,
5096,
4926,
4931,
4932,
4927,
4928,
4933,
4934,
4925,
4929,
4930,
4924,
4809,
4814,
4815,
4810,
4811,
4816,
4817,
4808,
4812,
4813,
4807,
5069,
5074,
5075,
5070,
5071,
5076,
5077,
5068,
5072,
5073,
5067,
4796,
4801,
4802,
4797,
4798,
4803,
4804,
4795,
4799,
4800,
4794,
4940,
4945,
4946,
4941,
4942,
4947,
4948,
4939,
4943,
4944,
4938,
4783,
4788,
4789,
4784,
4785,
4790,
4791,
4782,
4786,
4787,
4781,
4952,
4957,
4958,
4953,
4954,
4959,
4960,
4951,
4955,
4956,
4950,
4821,
4826,
4827,
4822,
4823,
4828,
4829,
4820,
4824,
4825,
4819,
5017,
5022,
5023,
5018,
5019,
5024,
5025,
5016,
5020,
5021,
5015,
5030,
5035,
5036,
5031,
5032,
5037,
5038,
5029,
5033,
5034,
5028,
4991,
4996,
4997,
4992,
4993,
4998,
4999,
4990,
4994,
4995,
4989,
4978,
4983,
4984,
4979,
4980,
4985,
4986,
4977,
4981,
4982,
4976,
4900,
4905,
4906,
4901,
4902,
4907,
4908,
4899,
4903,
4904,
4898,
5004,
5009,
5010,
5005,
5006,
5011,
5012,
5003,
5007,
5008,
5002,
4876,
4881,
4882,
4877,
4878,
4883,
4884,
4875,
4879,
4880,
4874,
4888,
4893,
4894,
4889,
4890,
4895,
4896,
4887,
4891,
4892,
4886,
4966,
4971,
4972,
4967,
4968,
4973,
4974,
4965,
4969,
4970,
4964,
4771,
4776,
4777,
4772,
4773,
4778,
4779,
4770,
4774,
4775,
4769,
5043,
5048,
5049,
5044,
5045,
5050,
5051,
5042,
5046,
5047,
5041,
4835,
4840,
4841,
4836,
4837,
4842,
4843,
4834,
4838,
4839,
4833,
4849,
4854,
4855,
4850,
4851,
4856,
4857,
4848,
4852,
4853,
4847,
4861,
4866,
4867,
4862,
4863,
4868,
4869,
4860,
4864,
4865,
4859,
5056,
5061,
5062,
5057,
5058,
5063,
5064,
5055,
5059,
5060,
5054,
4911,
4914,
4919,
4920,
4915,
4916,
4921,
4922,
4913,
4917,
4918,
4912,
4844,
7846,
8325,
8323,
8324,
8322,
8318,
8331,
8329,
8330,
8328,
8316,
8346,
8309,
8345,
8308,
8319,
8314,
8312,
8313,
8311,
8317,
8352,
8339,
8340,
8338,
8350,
8347,
8349,
8342,
8348,
8334,
8333,
8335,
8351,
8343,
8361,
8357,
8354,
8355,
8358,
8360,
8362,
8618,
6513,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 3814
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 3661
    elif code == 687: res = 3662
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 893: res = _charnames_880[code-880]
    elif code == 975: res = 7628
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1281
    elif code == 1231: res = 1667
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1317: res = _charnames_1296[code-1296]
    elif code == 1442: res = 9523
    elif code == 1466: res = 9520
    elif code == 1477: res = 9522
    elif code == 1478: res = 9521
    elif code == 1479: res = 9519
    elif 1536 <= code <= 1566: res = _charnames_1536[code-1536]
    elif code == 1595: res = 8991
    elif code == 1596: res = 8989
    elif code == 1597: res = 8958
    elif code == 1598: res = 8956
    elif code == 1599: res = 8957
    elif 1622 <= code <= 1630: res = _charnames_1622[code-1622]
    elif code == 1774: res = 9023
    elif code == 1775: res = 9005
    elif code == 1791: res = 8973
    elif code == 1837: res = 7348
    elif code == 1838: res = 7346
    elif code == 1839: res = 7347
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2110: res = _charnames_1984[code-1984]
    elif code == 2304: res = 10150
    elif code == 2308: res = 10158
    elif 2382 <= code <= 2389: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2431: res = _charnames_2417[code-2417]
    elif code == 2493: res = 8223
    elif code == 2510: res = 8224
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 7863
    elif code == 2677: res = 7861
    elif code == 2700: res = 7857
    elif code == 2785: res = 7858
    elif code == 2786: res = 7855
    elif code == 2787: res = 7856
    elif code == 2801: res = 7859
    elif code == 2869: res = 8936
    elif code == 2884: res = 8933
    elif code == 2914: res = 8931
    elif code == 2915: res = 8932
    elif code == 2929: res = 8935
    elif code == 2998: res = 5114
    elif code == 3024: res = 5111
    elif code == 3046: res = 5106
    elif 3059 <= code <= 3066: res = _charnames_3059[code-3059]
    elif code == 3133: res = 5557
    elif code == 3160: res = 5559
    elif code == 3161: res = 5560
    elif code == 3170: res = 5553
    elif code == 3171: res = 5554
    elif 3192 <= code <= 3199: res = _charnames_3192[code-3192]
    elif code == 3260: res = 8612
    elif code == 3261: res = 8614
    elif code == 3298: res = 8615
    elif code == 3299: res = 8616
    elif code == 3313: res = 8613
    elif code == 3314: res = 8611
    elif 3389 <= code <= 3396: res = _charnames_3389[code-3389]
    elif code == 3426: res = 6800
    elif code == 3427: res = 6801
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif code == 3947: res = 5639
    elif code == 3948: res = 5638
    elif 4046 <= code <= 4056: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif code == 4345: res = 7847
    elif code == 4346: res = 7848
    elif code == 4348: res = 6553
    elif code == 4442: res = 9405
    elif code == 4443: res = 9395
    elif code == 4444: res = 9397
    elif code == 4445: res = 9396
    elif code == 4446: res = 9379
    elif code == 4515: res = 9357
    elif code == 4516: res = 9341
    elif code == 4517: res = 9340
    elif code == 4518: res = 9344
    elif code == 4519: res = 9345
    elif code == 4602: res = 9301
    elif code == 4603: res = 9300
    elif code == 4604: res = 9304
    elif code == 4605: res = 9302
    elif code == 4606: res = 9303
    elif code == 4607: res = 9253
    elif code == 4615: res = 3626
    elif code == 4679: res = 3577
    elif code == 4743: res = 3567
    elif code == 4783: res = 3587
    elif code == 4815: res = 3622
    elif code == 4847: res = 3621
    elif code == 4879: res = 3530
    elif code == 4895: res = 3528
    elif code == 4935: res = 3608
    elif code == 4959: res = 3641
    elif code == 4960: res = 3627
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif code == 5120: res = 2093
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif code == 6109: res = 8304
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6829: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7097: res = _charnames_6912[code-6912]
    elif 7168 <= code <= 7295: res = _charnames_7168[code-7168]
    elif 7376 <= code <= 7410: res = _charnames_7376[code-7376]
    elif 7424 <= code <= 7654: res = _charnames_7424[code-7424]
    elif code == 7677: res = 1399
    elif code == 7678: res = 1319
    elif code == 7679: res = 1369
    elif code == 7836: res = 3807
    elif code == 7837: res = 3806
    elif code == 7838: res = 4010
    elif code == 7839: res = 3817
    elif code == 7930: res = 4032
    elif code == 7931: res = 3843
    elif code == 7932: res = 4031
    elif code == 7933: res = 3842
    elif code == 7934: res = 4056
    elif code == 7935: res = 3891
    elif 8275 <= code <= 8292: res = _charnames_8275[code-8275]
    elif code == 8336: res = 3913
    elif code == 8337: res = 3912
    elif code == 8338: res = 3909
    elif code == 8339: res = 3904
    elif code == 8340: res = 3907
    elif 8370 <= code <= 8376: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1323
    elif code == 8428: res = 1374
    elif code == 8429: res = 1322
    elif code == 8430: res = 1320
    elif code == 8431: res = 1372
    elif code == 8432: res = 1395
    elif code == 8507: res = 10750
    elif code == 8508: res = 10134
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif code == 8580: res = 3766
    elif code == 8581: res = 10374
    elif code == 8582: res = 10373
    elif code == 8583: res = 10372
    elif code == 8584: res = 10375
    elif code == 8585: res = 6357
    elif 9167 <= code <= 9192: res = _charnames_9167[code-9167]
    elif code == 9471: res = 9903
    elif code == 9748: res = 10685
    elif code == 9749: res = 9529
    elif code == 9752: res = 7414
    elif code == 9854: res = 9775
    elif code == 9855: res = 10721
    elif 9866 <= code <= 9983: res = _charnames_9866[code-9866]
    elif code == 10071: res = 9514
    elif 10176 <= code <= 10188: res = _charnames_10176[code-10176]
    elif code == 10220: res = 6825
    elif code == 10221: res = 6822
    elif code == 10222: res = 6826
    elif code == 10223: res = 6823
    elif 11008 <= code <= 11097: res = _charnames_11008[code-11008]
    elif 11264 <= code <= 11505: res = _charnames_11264[code-11264]
    elif 11513 <= code <= 11557: res = _charnames_11513[code-11513]
    elif 11568 <= code <= 11621: res = _charnames_11568[code-11568]
    elif code == 11631: res = 5627
    elif 11648 <= code <= 11670: res = _charnames_11648[code-11648]
    elif 11680 <= code <= 11825: res = _charnames_11680[code-11680]
    elif code == 12589: res = 8220
    elif 12736 <= code <= 12771: res = _charnames_12736[code-12736]
    elif code == 12829: res = 9746
    elif code == 12830: res = 9747
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 2288
    elif code == 12925: res = 2287
    elif code == 12926: res = 2293
    elif code == 13004: res = 7195
    elif code == 13005: res = 7198
    elif code == 13006: res = 7197
    elif code == 13007: res = 4477
    elif code == 13175: res = 7188
    elif code == 13176: res = 7190
    elif code == 13177: res = 7191
    elif code == 13178: res = 7200
    elif code == 13278: res = 7199
    elif code == 13279: res = 7203
    elif code == 13311: res = 7201
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42611: res = _charnames_42560[code-42560]
    elif 42620 <= code <= 42647: res = _charnames_42620[code-42620]
    elif 42656 <= code <= 42743: res = _charnames_42656[code-42656]
    elif 42752 <= code <= 42892: res = _charnames_42752[code-42752]
    elif 43003 <= code <= 43127: res = _charnames_43003[code-43003]
    elif 43136 <= code <= 43204: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43487: res = _charnames_43359[code-43359]
    elif 43520 <= code <= 43574: res = _charnames_43520[code-43520]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif code == 43739: res = 5366
    elif code == 43740: res = 5369
    elif code == 43741: res = 5368
    elif code == 43742: res = 5370
    elif code == 43743: res = 5367
    elif 43968 <= code <= 44025: res = _charnames_43968[code-43968]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif code == 65021: res = 9036
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif code == 65060: res = 1382
    elif code == 65061: res = 1381
    elif code == 65062: res = 1286
    elif code == 65095: res = 9761
    elif code == 65096: res = 9758
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65947: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66432 <= code <= 66517: res = _charnames_66432[code-66432]
    elif code == 66598: res = 10175
    elif code == 66599: res = 10176
    elif 66638 <= code <= 66729: res = _charnames_66638[code-66638]
    elif 67584 <= code <= 67679: res = _charnames_67584[code-67584]
    elif 67840 <= code <= 67903: res = _charnames_67840[code-67840]
    elif 68096 <= code <= 68167: res = _charnames_68096[code-68096]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68223: res = _charnames_68192[code-68192]
    elif 68352 <= code <= 68479: res = _charnames_68352[code-68352]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69760 <= code <= 69825: res = _charnames_69760[code-69760]
    elif 73728 <= code <= 74606: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74850: res = _charnames_74752[code-74752]
    elif code == 74864: res = 1229
    elif code == 74865: res = 1228
    elif code == 74866: res = 1227
    elif code == 74867: res = 1226
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif code == 119081: res = 6926
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119665: res = _charnames_119648[code-119648]
    elif code == 120001: res = 6833
    elif code == 120484: res = 6829
    elif code == 120485: res = 6828
    elif code == 120778: res = 6832
    elif code == 120779: res = 6831
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127232 <= code <= 127281: res = _charnames_127232[code-127232]
    elif 127293 <= code <= 127310: res = _charnames_127293[code-127293]
    elif code == 127319: res = 9902
    elif code == 127327: res = 9901
    elif 127353 <= code <= 127359: res = _charnames_127353[code-127353]
    elif 127370 <= code <= 127376: res = _charnames_127370[code-127370]
    elif code == 127488: res = 7194
    elif 127504 <= code <= 127537: res = _charnames_127504[code-127504]
    elif 127552 <= code <= 127560: res = _charnames_127552[code-127552]
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983050: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983945: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCB or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCB or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12290),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7232),
('Nl', 'L', 'N', 7168),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'N', 7168),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdkddddddddddddddd\x15\x15\x15lmddddddddddd\x15\x15\x15\x15nddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'ddddddddddddddddopqrstuvddddddddddddddddddddddddwxyddddddddddddd'
'z{5555555|}~55555555555555555555555\x7f55555\x8055555555555555555\x815555'
'5555555555555555555555555555555555\x8255555555555555555555555555555'
'55555555555555555555555555555555555555\x835555555555555555\x84\x85\x85\x85\x85\x85\x85\x85\x85'
'\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x7f5\x86\x85\x85\x85\x85\x87'
'\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85'
'\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85'
'\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85'
'\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x85\x87'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x88\x89dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x8a'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x8a'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xc1\x80\x80u\x92u\x80\x81\x8a_\x80\x9enUon9999999999o\x80\xab\xaa\xab\x80'
'\x80//////////////////////////\x8a\x80_\x98R\x98\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x8a\xaa_\xaa\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xbex\x92\x92\x8e\x92\xba\xb5\x95\xb8\x14h\xaa\x06\xb5\x98\xaf\xa0DD\x95\x16\xb5z\x95D\x14dIIIx'
'......,.........,......\xa3,.....,\x14\x14\x14\x16\x16\x16\x16\x14\x16\x14\x14\x14\x16\x14\x14\x16\x16\x14\x16\x14\x14\x16\x16\x16\xa3\x14\x14\x14\x16\x14\x16\x14\x16'
'.\x14.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x14.\x14.\x16.\x16.\x16.\x14.\x16.\x16.\x16.\x16.\x16,\x14.\x16.\x14.\x16.\x16.\x14,\x14.\x16.\x16\x14.\x16.\x16.\x16,'
'\x14,\x14.\x14.\x16.\x14\x14,\x14.\x14.\x16.\x16,\x14.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16,\x14.\x16.\x14.\x16.\x16.\x16.\x16.\x16.\x16..\x16.\x16.\x16\x16'
"\x16..\x16.\x16..\x16...\x16\x16....\x16..\x16...\x16\x16\x16..\x16..\x16.\x16.\x16..\x16.\x16\x16.\x16..\x16...\x16.\x16..\x16\x16'.\x16\x16\x16"
"''''.+\x16.+\x16.+\x16.\x14.\x14.\x14.\x14.\x14.\x14.\x14.\x14\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16.+\x16.\x16...\x16.\x16.\x16.\x16"
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16\x16\x16\x16\x16\x16..\x16..\x16'
'\x16.\x16....\x16.\x16.\x16.\x16.\x16\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
"\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d!!\x1d\x1d\x1d\x1d\x1d"
'\x1d\x1d\x97\x97\x95\x97!\x1f!\x1f\x1f\x1f!\x1f!!\x19\x1d\x97\x97\x97\x97\x97\x97\x95\x95\x95\x95\x97\x95\x97\x95\x1d\x1d\x1d\x1d\x1d\x97\x97\x97\x97\x97\x97\x97!\x97\x1d\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333333333333333333333333333333333333333333.\x16.\x16!\x97.\x16\x10\x10\x1c\x16\x16\x16~\x10'
'\x10\x10\x10\x10\x97\x97.\x7f...\x10.\x10..\x16,,,,,,,,,,,,,,,,,\x10,,,,,,,..\x16\x16\x16\x16\x16\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x16\x14\x14\x14\x14\x14\x14\x14\x16\x16\x16\x16\x16.\x16\x16...\x16\x16\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16\x16\x16\x16.\x16\xa8.\x16..\x16\x16...'
'.,..............,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16\xb34444411.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'..\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10...............'
'.......................\x10\x10\x1dwwwwww\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x10wX\x10\x10\x10\x10\x10\x10444444444444444444444444444444444444444444444Z4'
'\x8444\x8444\x844\x10\x10\x10\x10\x10\x10\x10\x10***************************\x10\x10\x10\x10\x10***\x84\x85\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x05\x05\x05\x05\x10\x10\xa8\xa8\x9att\x8dmi\xb8\xb844444444444i\x10\x10ii\x10$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'\x18$$$$$$$$$$44444444444444444444\x106666666666tjji$$4$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$i$4444444\x051444444\x18\x1844\xb84444$$8888888888$$$\xae\xae$'
'iiiiiiiiiiiiii\x10\x07$4$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$4444444444444444'
'44444444444\x10\x10$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$44444444444$\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
';;;;;;;;;;*********************************444444444""\xb8~~~"\x10\x10\x10\x10\x10'
'**********************4444"444444444"444"44444\x10\x10\x84\x84\x84\x84\x84\x84\x84\x84\x84\x84\x84\x84\x84\x84\x84\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"4440''''''''''''''''''''''''''''''''''''''''''''''''''''''\x10\x104'00"
"044444444000040\x10'44444\x10\x10''''''''''44ww::::::::::w\x1d'\x10\x10\x10\x10\x10\x10'''''''"
"\x10400\x10''''''''\x10\x10''\x10\x10''''''''''''''''''''''\x10'''''''\x10'\x10\x10\x10''''\x10\x104'00"
"04444\x10\x1000\x10\x10004'\x10\x10\x10\x10\x10\x10\x10\x100\x10\x10\x10\x10''\x10'''44\x10\x10::::::::::''\x91\x91FFFFFF\xb3\x91\x10\x10\x10\x10"
"\x10440\x10''''''\x10\x10\x10\x10''\x10\x10''''''''''''''''''''''\x10'''''''\x10''\x10''\x10''\x10\x104\x1000"
"044\x10\x10\x10\x1044\x10\x10444\x10\x10\x104\x10\x10\x10\x10\x10\x10\x10''''\x10'\x10\x10\x10\x10\x10\x10\x10::::::::::44'''4\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"\x10440\x10'''''''''\x10'''\x10''''''''''''''''''''''\x10'''''''\x10''\x10'''''\x10\x104'00"
"044444\x10440\x10004\x10\x10'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10''44\x10\x10::::::::::\x10\x91\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"\x10400\x10''''''''\x10\x10''\x10\x10''''''''''''''''''''''\x10'''''''\x10''\x10'''''\x10\x104'04"
"04444\x10\x1000\x10\x10004\x10\x10\x10\x10\x10\x10\x10\x1040\x10\x10\x10\x10''\x10'''44\x10\x10::::::::::\xb3'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"\x10\x104'\x10''''''\x10\x10\x10'''\x10''''\x10\x10\x10''\x10'\x10''\x10\x10\x10''\x10\x10\x10'''\x10\x10\x10''''''''''''\x10\x10\x10\x1000"
"400\x10\x10\x10000\x100004\x10\x10'\x10\x10\x10\x10\x10\x100\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10::::::::::FFF\xb8\xb8\xb8\xb8\xb8\xb8\x91\xb8\x10\x10\x10\x10\x10"
"\x10000\x10''''''''\x10'''\x10'''''''''''''''''''''''\x10''''''''''\x10'''''\x10\x10\x10'44"
"40000\x10444\x104444\x10\x10\x10\x10\x10\x10\x1044\x10''\x10\x10\x10\x10\x10\x10''44\x10\x10::::::::::\x10\x10\x10\x10\x10\x10\x10\x10KKKKKKK\xb3"
"\x10\x1000\x10''''''''\x10'''\x10'''''''''''''''''''''''\x10''''''''''\x10'''''\x10\x104'02"
"00000\x10200\x100044\x10\x10\x10\x10\x10\x10\x1000\x10\x10\x10\x10\x10\x10\x10'\x10''44\x10\x10::::::::::\x10\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"\x10\x1000\x10''''''''\x10'''\x10'''''''''''''''''''''''\x10''''''''''''''''\x10\x10\x10'00"
"04444\x10000\x100004\x10\x10\x10\x10\x10\x10\x10\x10\x100\x10\x10\x10\x10\x10\x10\x10\x10''44\x10\x10::::::::::FFFFFF\x10\x10\x10\xb3''''''"
"\x10\x1000\x10''''''''''''''''''\x10\x10\x10''''''''''''''''''''''''\x10'''''''''\x10'\x10\x10"
"'''''''\x10\x10\x104\x10\x10\x10\x10000444\x104\x1000000000\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x1000w\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"\x10''''''''''''''''''''''''''''''''''''''''''''''''4'&4444444\x10\x10\x10\x10\x91"
"''''''\x1d44444444w::::::::::ww\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"\x10''\x10'\x10\x10''\x10'\x10\x10'\x10\x10\x10\x10\x10\x10''''\x10'''''''\x10'''\x10'\x10'\x10\x10''\x10''''4'&444444\x1044'\x10\x10"
"'''''\x10\x1d\x10444444\x10\x10::::::::::\x10\x10''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"'\xb3\xb3\xb3wwwwwwwwwwwwwww\xb3\xb3\xb3\xb3\xb344\xb3\xb3\xb3\xb3\xb3\xb3::::::::::FFFFFFFFFF\xb34\xb34\xb34\x89^\x89^00"
"''''''''\x10''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10444444444444440"
"44444w44''''\x10\x10\x10\x1044444444\x10444444444444444444444444444444444444\x10\xb3\xb3"
'\xb3\xb3\xb3\xb3\xb3\xb34\xb3\xb3\xb3\xb3\xb3\xb3\x10\xb3\xb3wwwww\xb3\xb3\xb3\xb3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"'''''''''''''''''''''''''''''''''''''''''''00444404444440440044'"
"::::::::::wwwwww''''''0044''''444'000''0000000'''4444'''''''''''"
"''400440000004'0::::::::::0004\xb3\xb3................................"
"......\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'''''''''''''''''''''''''''''''''''''''''''w\x1d\x10\x10\x10"
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
"((((((((((((((((((((((((((((((((''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''(((((''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''(((((("
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''\x10''''\x10\x10'''''''\x10'\x10''''\x10\x10''''''''''''''''''''''''''''''''"
"'''''''''\x10''''\x10\x10'''''''''''''''''''''''''''''''''\x10''''\x10\x10'''''''\x10"
"'\x10''''\x10\x10'''''''''''''''\x10''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''\x10''''\x10\x10''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''\x10\x10\x10\x104\xb3wwwwwwwwGGGGGGGGGFFFFFFFFFFF\x10\x10\x10"
"''''''''''''''''\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"X'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''ww'''''''''''''''''"
"\xc0''''''''''''''''''''''''''\x89^\x10\x10\x10''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''www>>>\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"'''''''''''''\x10''''444\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10''''''''''''''''''444ww\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"''''''''''''''''''44\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'''''''''''''\x10'''\x1044\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"''''''''''''''''''''''''''''''''''''''''''''''''''''\x08\x080444444400"
"00000040044444444444www\x1dwww\x91'4\x10\x10::::::::::\x10\x10\x10\x10\x10\x10KKKKKKKKKK\x10\x10\x10\x10\x10\x10"
"~~~~~~X~~~~444\xc0\x10::::::::::\x10\x10\x10\x10\x10\x10''''''''''''''''''''''''''''''''"
"'''\x1d''''''''''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10"
"'''''''''''''''''''''''''''''''''''''''''4'\x10\x10\x10\x10\x10''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"'''''''''''''''''''''''''''''\x10\x10\x10444000044000\x10\x10\x10\x10004000000444\x10\x10\x10\x10"
"\xb8\x10\x10\x10~~::::::::::''''''''''''''''''''''''''''''\x10\x10'''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x100000000000000000"
"0'''''''00\x10\x10\x10\x10\x10\x10:::::::::::\x10\x10\x10~~\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8"
"'''''''''''''''''''''''44000\x10\x10ww''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''0404444444\x1040400444444440000004444444444\x10\x104"
'::::::::::\x10\x10\x10\x10\x10\x10::::::::::\x10\x10\x10\x10\x10\x10wwwwwww\x1dwwwwww\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"44440'''''''''''''''''''''''''''''''''''''''''''''''404444404000"
"00400'''''''\x10\x10\x10\x10::::::::::wwwwwww\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3444444444\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\x10\x10\x10"
"440''''''''''''''''''''''''''''''0444400440\x10\x10\x10''::::::::::\x10\x10\x10\x10\x10\x10"
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"''''''''''''''''''''''''''''''''''''00000000444444440044\x10\x10\x10wwwww"
"::::::::::\x10\x10\x10'''::::::::::''''''''''''''''''''''''''''''\x1d\x1d\x1d\x1d\x1d\x1dww"
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10444w444444444444404444444''''4''''0\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1d\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d'
'444444444444444444444444444444444444444\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10444'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16\x16\x16\x16\x16\x16\x16\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16........\x16\x16\x16\x16\x16\x16\x10\x10......\x10\x10\x16\x16\x16\x16\x16\x16\x16\x16........\x16\x16\x16\x16\x16\x16\x16\x16........'
'\x16\x16\x16\x16\x16\x16\x10\x10......\x10\x10\x16\x16\x16\x16\x16\x16\x16\x16\x10.\x10.\x10.\x10.\x16\x16\x16\x16\x16\x16\x16\x16........\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10'
'\x16\x16\x16\x16\x16\x16\x16\x16++++++++\x16\x16\x16\x16\x16\x16\x16\x16++++++++\x16\x16\x16\x16\x16\x16\x16\x16++++++++\x16\x16\x16\x16\x16\x10\x16\x16....+\x97\x16\x97'
'\x97\x97\x16\x16\x16\x10\x16\x16....+\x97\x97\x97\x16\x16\x16\x16\x10\x10\x16\x16....\x10\x97\x97\x97\x16\x16\x16\x16\x16\x16\x16\x16.....\x97\x97\x97\x10\x10\x16\x16\x16\x10\x16\x16....+\x97\x97\x10'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x07\x07\x07\x08\rWXXWWWx~fc\x88geb\x88gxxx~yxxy\xbc\xbd\t\x0e\x0c\n\x0f\xbertrrtx~~~hdx~~xQ'
'Q~~~\x9b\x89^~~~~~~~~~~~\xa8~Q~~~~~~~~~~\xc0\x07\x07\x07\x07\x07\x10\x10\x10\x10\x10\x07\x07\x07\x07\x07\x07E\x1d\x10\x10DEEEEE\x9d\x9d\xa8\x89^\x19'
'EDDDDEEEEE\x9d\x9d\xa8\x89^\x10\x1d\x1d\x1d\x1d\x1d\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x91\x91\x91\x91\x91\x91\x91\x91\x91\x90\x91\x91\x8e\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10444444444444411114111444444444444\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\xb8\xb8.\xb5\xb8\xb5\xb8.\xb8\xb5\x16...\x16\x16...\x14\xb8.\xb5\xb8\xb9.....\xb8\xb8\xb8\xb5\xb5\xb8.\xb8,\xb8.\xb8.,..\xb1\x16....\x16''''\x16\xb8\xb8\x16\x16.."
'\xa9\xa8\xa8\xa8\xa8.\x16\x16\x16\x16\xb8\xa8\xb8\xb8\x16\xb3KKKIIKKKKKKIIIIK<<<<<<<<<<<<>>>><<<<<<<<<<>>>>>>'
'>>>.\x16>>>>I\x10\x10\x10\x10\x10\x10\xa3\xa3\xa3\xa3\xa3\xb5\xb5\xb5\xb5\xb5\xa8\xa8\xb8\xb8\xb8\xb8\xa8\xb8\xb8\xa8\xb8\xb8\xa8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa8\xa8\xb8\xb8\xa3\xb8\xa3\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa3\xa9\xa4\xa4\xa9\xa8\xa8\xa3\xa4\xa9\xa9\xa4\xa9\xa9\xa8\xa3\xa8\xa4\x9d\xa1\xa8\xa4\xa9\xa8\xa8\xa8\xa4\xa9\xa9\xa4\xa3\xa4\xa4\xa9\xa9\xa3\xa9\xa3\xa9\xa3\xa3\xa3\xa3\xa4\xa4\xa9\xa4\xa9\xa9\xa9\xa9\xa9\xa3\xa3\xa3\xa3\xa8\xa9\xa8\xa9\xa4\xa4\xa9\xa9'
'\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa4\xa9\xa9\xa9\xa4\xa8\xa8\xa8\xa8\xa8\xa4\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa4\xa3\xa9\xa8\xa4\xa4\xa4\xa4\xa9\xa9\xa4\xa4\xa8\xa8\xa4\xa4\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9'
'\xa9\xa9\xa4\xa4\xa9\xa9\xa4\xa4\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa9\xa9\xa9\xa9\xa8\xa8\xa3\xa8\xa8\xa9\xa3\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa8\xa3\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa9\xa4'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa9\xa9\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa9\xa9\xa9\xa9\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa9\xa9\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x8ca\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb8\xa8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb3\xb8\xb8\xb8\xb8\xb8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa8\xa8\xa8\xa8\xa8\xa8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10JJJJJJJJJIIIIIIIIIIIJJJJJJJJJIII'
'IIIIIIIIDDDDDDDDDCCCCCCCCCCC\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2LIIIIIIIIIIJJJJJJJJJIJ'
'\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5'
'\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb8\xb8\xb8\xb8\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb8\xb8\xb5\xb5\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8\xb5\xa3\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8'
'\xb5\xa3\xb8\xb8\xb8\xb8\xb5\xb5\xb5\xb8\xb8\xb5\xb8\xb8\xb5\xb5\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8\xb5\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb8\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb5\xb8\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb5\xb5\xb5\xb8\xb5\xb5\xb5\xb5\xb8\xb5\xb5\xb8\xa3\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb3\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb5'
'\xb8\xb8\xb8\xb8\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\x10\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\x10\xb5\x10\x10\x10\x10\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5\xb5'
'\x10\xb8\xb8\xb8\xb8\x10\xb8\xb8\xb8\xb8\x10\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb5\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\xb8\x10\xb8\xb8\xb8\xb8\x10\x10\x10\xb8\xb5\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x89^\x89^\x89^\x89^\x89^\x89^\x89^JJJJJJJJJI'
'LLLLLLLLLKLLLLLLLLLK\xb8\x10\x10\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10'
'\xa9\xa8\xa8\xa9\xa9\x89^\xa8\xa9\xa9\xa8\x10\xa9\x10\x10\x10\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa8\xa8\xa8\xa9\xa9\xa9\xa9\x8a_\x8a_\x8a_\x8a_\x89^\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\x89^\x8a_\x89^\x89^\x89^\x89^\x89^\x89^\x89^\x89^\x89^\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa9\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa8\xa9\xa9\xa8\xa8\x89^\x89^\xa9\xa8\xa8\xa8\xa8\xa9\xa8\xa9\xa9\xa9\xa8\xa8\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\x89^\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa9\xa9\xa9\xa9\xa8\xa8\xa9\xa8\xa9\xa8\xa8\xa9\xa8\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa8\xa9\xa9\xa8\xa8\xa9\xa9\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9'
'\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9'
'\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa9\xa8\xa9\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa8\xa9\xa9\xa9\xa8\xa8\xa8\xa8\xa9\xa8\xa8\xa8\xa9\xa9\xa9\xa9\xa9\xa8\xa9\xa8\xa8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xb8\xb8\xa8\xa8\xa8\xa8\xa8\xa8\x10\x10\x10\xb8\xb8\xb8\xb8\xb8\xb5\xb5\xb5\xb5\xb5\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'...............................................\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10.\x16...\x16\x16.\x16.\x16.\x16....\x16.\x16\x16.\x16\x16\x16\x16\x16\x16\x16\x1d..'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16\xb8\xb8\xb8\xb8\xb8\xb8.\x16.\x16444\x10\x10\x10\x10\x10\x10\x10~~~~K~~'
"\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x1d\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"'''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10'''''''\x10'''''''\x10'''''''\x10'''''''\x10"
"'''''''\x10'''''''\x10'''''''\x10'''''''\x1044444444444444444444444444444444"
'~~hdhd~~~hd~hd~~~~~~~~~X~~X~hd~~hd\x89^\x89^\x89^\x89^~~~~~ ~~\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\x10\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\x10\x10\x10\x10'
'\xbf\x82\x82\x82\xbb\x1e(?\x8ca\x8ca\x8ca\x8ca\x8ca\xbb\xbb\x8ca\x8ca\x8ca\x8caY\x8b``\xbb?????????555555Y\x1e\x1e\x1e\x1e\x1e\xbb\xbb???\x1e(\x82\xbb\xb8'
'\x10((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((\x10\x1055\x99\x99\x1e\x1e(Y((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\x82\x1e\x1e\x1e('
'\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((((((((((((\x10\x10\x10((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((\x10\xb4\xb4HHHH\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((('
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xbb\xbb\x10HHHHHHHHHH\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xbbMMMMMMMMMMMMMMM\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xbb\xbb\xbb\xb4'
'HHHHHHHHHH\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4MMMMMMMMMMMMMMM'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xbb\xbb\xbb\xbb\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\x10'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xbb\xbb\xbb\xbb\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xbb\xbb\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xbb'
'((((()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((()((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((()(((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((((((((((((((\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
')(()((()()(((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((()(((((((((((((((((((((((((((((((((('
'(((((((((((()((((((()()(((((((((((((((((((((((((((((((((((((((()'
')(((((((((((((((((((((((((((((()(((((((()((((((((((((((((((((((('
'((((((((((((()(((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((()((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((()((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((()(((((((((((((((((((((((((((((((((()()()(((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'()()))(((((()((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'())))((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((()(((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((((((((()((((((()(((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((()((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((())'
'(((((((((((()))()((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((()('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((()((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((()((((((((((((((((((((((((((((((((((((((((((((('
'(((((()((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((()((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((()('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((()((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((()((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((()(((()(((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((()((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((()(((((((((((((((((((((((((((((('
'(((((()((((()((((((((((((((((((((((((((((((((((((((((((()((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((()((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'(((((((((((((((((((((\x1e(((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((\x10\x10\x10\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
"\xbb\xbb\xbb\xbb\xbb\xbb\xbb\x10\x10\x10\x10\x10\x10\x10\x10\x10''''''''''''''''''''''''''''''''''''''''\x1d\x1d\x1d\x1d\x1d\x1dww"
"''''''''''''\x1d~~~''''''''''''''''::::::::::''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
".\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x10\x10.\x16.\x16.\x16.\x16.\x16.\x16'4111~\x10\x10\x10\x10\x10\x10\x10\x1044~!"
".\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x10\x10\x10\x10\x10\x10\x10\x10''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''>>>>>>>>>>44wwwwww\x10\x10\x10\x10\x10\x10\x10\x10"
'\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97\x97!!!!!!!!!\x97\x97.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x16\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16'
'.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16.\x16\x1d\x16\x16\x16\x16\x16\x16\x16\x16.\x16.\x16..\x16'
'.\x16.\x16.\x16.\x16!\x94\x94.\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'''''"
"''4'''4''''4'''''''''''''''''''''''00440\xb8\xb8\xb8\xb8\x10\x10\x10\x10FFFFFF\xb3\xb3\x91\xb0\x10\x10\x10\x10\x10\x10"
"''''''''''''''''''''''''''''''''''''''''''''''''''''~~~~\x10\x10\x10\x10\x10\x10\x10\x10"
"00''''''''''''''''''''''''''''''''''''''''''''''''''000000000000"
"00004\x10\x10\x10\x10\x10\x10\x10\x10\x10ww::::::::::\x10\x10\x10\x10\x10\x10444444444444444444''''''www'\x10\x10\x10\x10"
"::::::::::''''''''''''''''''''''''''''44444444ww''''''''''''''''"
"'''''''4444444444400\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10w(((((((((((((((((((((((((((((\x10\x10\x10"
"4440'''''''''''''''''''''''''''''''''''''''''''''''4004444004000"
'0wwwwwwwwwwwww\x10\x1d::::::::::\x10\x10\x10\x10ww\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"'''''''''''''''''''''''''''''''''''''''''44444400440044\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"'''4''''''''40\x10\x10::::::::::\x10\x10wwww''''''''''''''''\x1d''''''\xb3\xb3\xb3'0\x10\x10\x10\x10"
"''''''''''''''''''''''''''''''''''''''''''''''''4'444''44'''''44"
"'4'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10''\x1dww\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"'''''''''''''''''''''''''''''''''''00400400w04\x10\x10::::::::::\x10\x10\x10\x10\x10\x10"
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((('
'(((((((\x10\x10\x10\x10(((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((()((((((()(((()((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((()((((((((((((('
'((((((((((((((((()()((((((((((((((((((((((((((((((((((((((((()(('
'((((((((((((((((((((((((((((((((((((((((((((((\x11\x11(((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((((((\x11\x11(((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x16\x16\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10*4**********\x9d*************\x10*****\x10*\x10'
'**\x10**\x10**********$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$######$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\x88]'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$\x10\x10$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10$$$$$$$$$$##\x8d\xb8\x10\x10'
'3333333333333333\x82\x82\x82\x83\x82\x82\x82\x8b`\x82\x10\x10\x10\x10\x10\x104444444\x10\x10\x10\x10\x10\x10\x10\x10\x10\x82YYSS\x8b`\x8b`\x8b`\x8b`\x8b`\x8b'
'`\x8b`\x8b`\x82\x82\x8b`\x82\x82\x82\x82SSSp\x82q\x10\x82q\x82\x82Y\x8ca\x8ca\x8cav\x82\x82\x9fV\xad\xad\xac\x10\x82\x93v\x82\x10\x10\x10\x10#$#$#\x10#$#$#$#$#$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'
'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\x10\x10\x07'
'\x10{{s\x8fs{|\x86[{\x9ckTlk7777777777l{\xa6\xa5\xa6{{--------------------------\x86{[\x96P'
'\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x86\xa5[\xa5\x86[}\x87\\}}%%%%%%%%%%\x1b%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1a\x1a%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x10'
'\x10\x10%%%%%%\x10\x10%%%%%%\x10\x10%%%%%%\x10\x10%%%\x10\x10\x10\x8f\x8f\xa5\x96\xb6\x8f\x8f\x10\xb7\xa7\xa7\xa7\xa7\xb7\xb7\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x0b\x0b\x0b\xb8\xb5\x10\x10'
"''''''''''''\x10''''''''''''''''''''''''''\x10'''''''''''''''''''\x10''\x10'"
"''''''''''''''\x10\x10''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10"
'w~\xb3\x10\x10\x10\x10FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF\x10\x10\x10\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@KKKK\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8K\x10\x10\x10\x10\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb34\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"'''''''''''''''''''''''''''''\x10\x10\x10''''''''''''''''''''''''''''''''"
"'''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"'''''''''''''''''''''''''''''''\x10FFFF\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10''''''''''''''''"
"'>''''''''>\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
"''''''''''''''''''''''''''''''\x10w''''''''''''''''''''''''''''''''"
"''''\x10\x10\x10\x10''''''''w>>>>>\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
'........................................\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
"\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''\x10\x10::::::::::\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'******\x10\x10*\x10********************************************\x10**\x10\x10\x10*\x10\x10*'
'**********************\x10\x84NNNNNNNN\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'**********************NNNNNN\x10\x10\x10~**************************\x10\x10\x10\x10\x10\x84'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'*444\x1044\x10\x10\x10\x10\x104444****\x10***\x10***************************\x10\x10\x10\x10444\x10\x10\x10\x104'
'OOOONNNN\x10\x10\x10\x10\x10\x10\x10\x10\x84\x84\x84\x84\x84\x84\x84\x84\x84\x10\x10\x10\x10\x10\x10\x10*****************************NN\x84'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'******************************************************\x10\x10\x10~~~~~~~'
'**********************\x10\x10NNNNNNNN*******************\x10\x10\x10\x10\x10NNNNNNNN'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'****************************************************************'
'*********\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10BBBBBBBBBAAAAAAAAAAAAAAAAAAAAAA\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"440'''''''''''''''''''''''''''''''''''''''''''''00044440044ww\x08ww"
'ww\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>==>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>==>>>>>>>>>>>\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10wwww\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"'''''''''''''''''''''''''''''''''''''''''''''''\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\x10\x10\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb300444\xb3\xb3\xb3000000\x07\x07\x07\x07\x07\x07\x07\x0744444'
'444\xb3\xb34444444\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb34444\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8444\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10FFFFFFFFFFFFFFFFFF\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'..........................\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16............'
'..............\x16\x16\x16\x16\x16\x16\x16\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16........................'
'..\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16.\x10..\x10\x10.\x10\x10..\x10\x10....\x10........\x16\x16\x16\x16\x10\x16\x10\x16\x16\x16'
'\x16\x16\x16\x16\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16..........................\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16..\x10....\x10\x10........\x10.......\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16..\x10....\x10'
'.....\x10.\x10\x10\x10.......\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16....................'
'......\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16..........................\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16..........................\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16..........................\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16....'
'......................\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16................'
'..........\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10........................'
'.\xa2\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xa9\x16\x16\x16\x16\x16\x16.........................\xa2\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xa9\x16\x16\x16\x16\x16\x16.........................\xa2\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xa9\x16\x16\x16\x16\x16\x16.........................\xa2\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\xa9\x16\x16\x16\x16\x16\x16.........................\xa2\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\xa9\x16\x16\x16\x16\x16\x16.\x16\x10\x1088888888888888888888888888888888888888888888888888'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8'
'\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\xb8\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'DDDDDDDDDDD\x10\x10\x10\x10\x10\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\x10\x10\xb2\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xb2\x10\xb2'
'\x10\x10\xb2\x10\x10\x10\xb2\x10\x10\x10\xb2\xb2\xb2\xb2\xb2\x10\x10\x10\x10\x10\x10\x10\x10\xb2\x10\x10\x10\x10\x10\x10\x10\xb2\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xb2\x10\xb2\xb2\x10\x10\xb2'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xb2\xb2\xb2\xb2\x10\x10\xb2\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb4\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((()((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((()((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((()(((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((()((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((()(((((((()((((((((((((((()((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((()(((((((((((((((((()(('
'((((((((((((((((((((((((()(((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((()((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((()((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((()(((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((((()(((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'((((((((((((((((((((((((((((((\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x10\x10'
'\x10\x07\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07'
'\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333333333333333333333333333333333333333333\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x10\x10'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6618: 1,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
}

_decimal_corrected = {
178: None,
179: None,
185: None,
4969: None,
4970: None,
4971: None,
4972: None,
4973: None,
4974: None,
4975: None,
4976: None,
4977: None,
8304: None,
8308: None,
8309: None,
8310: None,
8311: None,
8312: None,
8313: None,
8320: None,
8321: None,
8322: None,
8323: None,
8324: None,
8325: None,
8326: None,
8327: None,
8328: None,
8329: None,
}
_digit = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6618: 1,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
9471: 0,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
68160: 1,
68161: 2,
68162: 3,
68163: 4,
69216: 1,
69217: 2,
69218: 3,
69219: 4,
69220: 5,
69221: 6,
69222: 7,
69223: 8,
69224: 9,
127232: 0,
127233: 0,
127234: 1,
127235: 2,
127236: 3,
127237: 4,
127238: 5,
127239: 6,
127240: 7,
127241: 8,
127242: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
1984: 0.0,
1985: 1.0,
1986: 2.0,
1987: 3.0,
1988: 4.0,
1989: 5.0,
1990: 6.0,
1991: 7.0,
1992: 8.0,
1993: 9.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
3046: 0.0,
3192: 0.0,
3193: 1.0,
3194: 2.0,
3195: 3.0,
3196: 1.0,
3197: 2.0,
3198: 3.0,
3440: 10.0,
3441: 100.0,
3442: 1000.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
4240: 0.0,
4241: 1.0,
4242: 2.0,
4243: 3.0,
4244: 4.0,
4245: 5.0,
4246: 6.0,
4247: 7.0,
4248: 8.0,
4249: 9.0,
6128: 0.0,
6129: 1.0,
6130: 2.0,
6131: 3.0,
6132: 4.0,
6133: 5.0,
6134: 6.0,
6135: 7.0,
6136: 8.0,
6137: 9.0,
6470: 0.0,
6471: 1.0,
6472: 2.0,
6473: 3.0,
6474: 4.0,
6475: 5.0,
6476: 6.0,
6477: 7.0,
6478: 8.0,
6479: 9.0,
6608: 0.0,
6609: 1.0,
6610: 2.0,
6611: 3.0,
6612: 4.0,
6613: 5.0,
6614: 6.0,
6615: 7.0,
6616: 8.0,
6617: 9.0,
6618: 1.0,
6784: 0.0,
6785: 1.0,
6786: 2.0,
6787: 3.0,
6788: 4.0,
6789: 5.0,
6790: 6.0,
6791: 7.0,
6792: 8.0,
6793: 9.0,
6800: 0.0,
6801: 1.0,
6802: 2.0,
6803: 3.0,
6804: 4.0,
6805: 5.0,
6806: 6.0,
6807: 7.0,
6808: 8.0,
6809: 9.0,
6992: 0.0,
6993: 1.0,
6994: 2.0,
6995: 3.0,
6996: 4.0,
6997: 5.0,
6998: 6.0,
6999: 7.0,
7000: 8.0,
7001: 9.0,
7088: 0.0,
7089: 1.0,
7090: 2.0,
7091: 3.0,
7092: 4.0,
7093: 5.0,
7094: 6.0,
7095: 7.0,
7096: 8.0,
7097: 9.0,
7232: 0.0,
7233: 1.0,
7234: 2.0,
7235: 3.0,
7236: 4.0,
7237: 5.0,
7238: 6.0,
7239: 7.0,
7240: 8.0,
7241: 9.0,
7248: 0.0,
7249: 1.0,
7250: 2.0,
7251: 3.0,
7252: 4.0,
7253: 5.0,
7254: 6.0,
7255: 7.0,
7256: 8.0,
7257: 9.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
8581: 6.0,
8582: 50.0,
8583: 50000.0,
8584: 100000.0,
8585: 0.0,
9471: 0.0,
11517: 1.0 / 2.0,
13317: 5.0,
13443: 2.0,
14378: 5.0,
15181: 7.0,
20118: 4.0,
20160: 10.0,
20200: 3.0,
21316: 20.0,
21324: 40.0,
21444: 3.0,
24186: 1.0,
24318: 9.0,
28422: 7.0,
36019: 2.0,
38433: 1000.0,
42528: 0.0,
42529: 1.0,
42530: 2.0,
42531: 3.0,
42532: 4.0,
42533: 5.0,
42534: 6.0,
42535: 7.0,
42536: 8.0,
42537: 9.0,
42726: 1.0,
42727: 2.0,
42728: 3.0,
42729: 4.0,
42730: 5.0,
42731: 6.0,
42732: 7.0,
42733: 8.0,
42734: 9.0,
42735: 0.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43216: 0.0,
43217: 1.0,
43218: 2.0,
43219: 3.0,
43220: 4.0,
43221: 5.0,
43222: 6.0,
43223: 7.0,
43224: 8.0,
43225: 9.0,
43264: 0.0,
43265: 1.0,
43266: 2.0,
43267: 3.0,
43268: 4.0,
43269: 5.0,
43270: 6.0,
43271: 7.0,
43272: 8.0,
43273: 9.0,
43472: 0.0,
43473: 1.0,
43474: 2.0,
43475: 3.0,
43476: 4.0,
43477: 5.0,
43478: 6.0,
43479: 7.0,
43480: 8.0,
43481: 9.0,
43600: 0.0,
43601: 1.0,
43602: 2.0,
43603: 3.0,
43604: 4.0,
43605: 5.0,
43606: 6.0,
43607: 7.0,
43608: 8.0,
43609: 9.0,
44016: 0.0,
44017: 1.0,
44018: 2.0,
44019: 3.0,
44020: 4.0,
44021: 5.0,
44022: 6.0,
44023: 7.0,
44024: 8.0,
44025: 9.0,
63851: 3.0,
63859: 10.0,
63864: 2.0,
63922: 0.0,
63953: 6.0,
63955: 6.0,
63997: 10.0,
65799: 1.0,
65800: 2.0,
65801: 3.0,
65802: 4.0,
65803: 5.0,
65804: 6.0,
65805: 7.0,
65806: 8.0,
65807: 9.0,
65808: 10.0,
65809: 20.0,
65810: 30.0,
65811: 40.0,
65812: 50.0,
65813: 60.0,
65814: 70.0,
65815: 80.0,
65816: 90.0,
65817: 100.0,
65818: 200.0,
65819: 300.0,
65820: 400.0,
65821: 500.0,
65822: 600.0,
65823: 700.0,
65824: 800.0,
65825: 900.0,
65826: 1000.0,
65827: 2000.0,
65828: 3000.0,
65829: 4000.0,
65830: 5000.0,
65831: 6000.0,
65832: 7000.0,
65833: 8000.0,
65834: 9000.0,
65835: 10000.0,
65836: 20000.0,
65837: 30000.0,
65838: 40000.0,
65839: 50000.0,
65840: 60000.0,
65841: 70000.0,
65842: 80000.0,
65843: 90000.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65858: 1.0,
65859: 5.0,
65860: 50.0,
65861: 500.0,
65862: 5000.0,
65863: 50000.0,
65864: 5.0,
65865: 10.0,
65866: 50.0,
65867: 100.0,
65868: 500.0,
65869: 1000.0,
65870: 5000.0,
65871: 5.0,
65872: 10.0,
65873: 50.0,
65874: 100.0,
65875: 500.0,
65876: 1000.0,
65877: 10000.0,
65878: 50000.0,
65879: 10.0,
65880: 1.0,
65881: 1.0,
65882: 1.0,
65883: 2.0,
65884: 2.0,
65885: 2.0,
65886: 2.0,
65887: 5.0,
65888: 10.0,
65889: 10.0,
65890: 10.0,
65891: 10.0,
65892: 10.0,
65893: 30.0,
65894: 50.0,
65895: 50.0,
65896: 50.0,
65897: 50.0,
65898: 100.0,
65899: 300.0,
65900: 500.0,
65901: 500.0,
65902: 500.0,
65903: 500.0,
65904: 500.0,
65905: 1000.0,
65906: 5000.0,
65907: 5.0,
65908: 50.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65930: 0.0,
66369: 90.0,
66378: 900.0,
66513: 1.0,
66514: 2.0,
66515: 10.0,
66516: 20.0,
66517: 100.0,
66720: 0.0,
66721: 1.0,
66722: 2.0,
66723: 3.0,
66724: 4.0,
66725: 5.0,
66726: 6.0,
66727: 7.0,
66728: 8.0,
66729: 9.0,
67672: 1.0,
67673: 2.0,
67674: 3.0,
67675: 10.0,
67676: 20.0,
67677: 100.0,
67678: 1000.0,
67679: 10000.0,
67862: 1.0,
67863: 10.0,
67864: 20.0,
67865: 100.0,
67866: 2.0,
67867: 3.0,
68160: 1.0,
68161: 2.0,
68162: 3.0,
68163: 4.0,
68164: 10.0,
68165: 20.0,
68166: 100.0,
68167: 1000.0,
68221: 1.0,
68222: 50.0,
68440: 1.0,
68441: 2.0,
68442: 3.0,
68443: 4.0,
68444: 10.0,
68445: 20.0,
68446: 100.0,
68447: 1000.0,
68472: 1.0,
68473: 2.0,
68474: 3.0,
68475: 4.0,
68476: 10.0,
68477: 20.0,
68478: 100.0,
68479: 1000.0,
69216: 1.0,
69217: 2.0,
69218: 3.0,
69219: 4.0,
69220: 5.0,
69221: 6.0,
69222: 7.0,
69223: 8.0,
69224: 9.0,
69225: 10.0,
69226: 20.0,
69227: 30.0,
69228: 40.0,
69229: 50.0,
69230: 60.0,
69231: 70.0,
69232: 80.0,
69233: 90.0,
69234: 100.0,
69235: 200.0,
69236: 300.0,
69237: 400.0,
69238: 500.0,
69239: 600.0,
69240: 700.0,
69241: 800.0,
69242: 900.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
74752: 2.0,
74753: 3.0,
74754: 4.0,
74755: 5.0,
74756: 6.0,
74757: 7.0,
74758: 8.0,
74759: 9.0,
74760: 3.0,
74761: 4.0,
74762: 5.0,
74763: 6.0,
74764: 7.0,
74765: 8.0,
74766: 9.0,
74767: 4.0,
74768: 5.0,
74769: 6.0,
74770: 7.0,
74771: 8.0,
74772: 9.0,
74773: 1.0,
74774: 2.0,
74775: 3.0,
74776: 4.0,
74777: 5.0,
74778: 6.0,
74779: 7.0,
74780: 8.0,
74781: 9.0,
74782: 1.0,
74783: 2.0,
74784: 3.0,
74785: 4.0,
74786: 5.0,
74787: 2.0,
74788: 3.0,
74789: 3.0,
74790: 4.0,
74791: 5.0,
74792: 6.0,
74793: 7.0,
74794: 8.0,
74795: 9.0,
74796: 1.0,
74797: 2.0,
74798: 3.0,
74799: 3.0,
74800: 4.0,
74801: 5.0,
74804: 1.0,
74805: 2.0,
74806: 3.0,
74807: 3.0,
74808: 4.0,
74809: 5.0,
74810: 3.0,
74811: 3.0,
74812: 4.0,
74813: 4.0,
74814: 4.0,
74815: 4.0,
74816: 6.0,
74817: 7.0,
74818: 7.0,
74819: 7.0,
74820: 8.0,
74821: 8.0,
74822: 9.0,
74823: 9.0,
74824: 9.0,
74825: 9.0,
74826: 2.0,
74827: 3.0,
74828: 4.0,
74829: 5.0,
74830: 6.0,
74831: 1.0,
74832: 2.0,
74833: 3.0,
74834: 4.0,
74835: 4.0,
74836: 5.0,
74837: 5.0,
74840: 1.0,
74841: 2.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
119648: 1.0,
119649: 2.0,
119650: 3.0,
119651: 4.0,
119652: 5.0,
119653: 6.0,
119654: 7.0,
119655: 8.0,
119656: 9.0,
119657: 10.0,
119658: 20.0,
119659: 30.0,
119660: 40.0,
119661: 50.0,
119662: 60.0,
119663: 70.0,
119664: 80.0,
119665: 90.0,
127232: 0.0,
127233: 0.0,
127234: 1.0,
127235: 2.0,
127236: 3.0,
127237: 4.0,
127238: 5.0,
127239: 6.0,
127240: 7.0,
127241: 8.0,
127242: 9.0,
131073: 7.0,
131172: 4.0,
131298: 4.0,
131361: 5.0,
133418: 1.0,
133507: 30.0,
133516: 40.0,
133532: 40.0,
133866: 6.0,
133885: 3.0,
133913: 3.0,
140176: 2.0,
141720: 3.0,
146203: 3.0,
156269: 4.0,
194704: 9.0,
}

_numeric_corrected = {
20140: None,
22419: None,
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
384: 579,
410: 573,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
66638: 66598,
66639: 66599,
}

_toupper_corrected = {
}
_tolower = {
570: 11365,
571: 572,
573: 410,
574: 11366,
577: 578,
579: 384,
580: 649,
581: 652,
582: 583,
584: 585,
586: 587,
588: 589,
590: 591,
880: 881,
882: 883,
886: 887,
975: 983,
1015: 1016,
1017: 1010,
1018: 1019,
1021: 891,
1022: 892,
1023: 893,
1216: 1231,
1270: 1271,
1274: 1275,
1276: 1277,
1278: 1279,
1296: 1297,
1298: 1299,
1300: 1301,
1302: 1303,
1304: 1305,
1306: 1307,
1308: 1309,
1310: 1311,
1312: 1313,
1314: 1315,
1316: 1317,
4256: 11520,
4257: 11521,
4258: 11522,
4259: 11523,
4260: 11524,
4261: 11525,
4262: 11526,
4263: 11527,
4264: 11528,
4265: 11529,
4266: 11530,
4267: 11531,
4268: 11532,
4269: 11533,
4270: 11534,
4271: 11535,
4272: 11536,
4273: 11537,
4274: 11538,
4275: 11539,
4276: 11540,
4277: 11541,
4278: 11542,
4279: 11543,
4280: 11544,
4281: 11545,
4282: 11546,
4283: 11547,
4284: 11548,
4285: 11549,
4286: 11550,
4287: 11551,
4288: 11552,
4289: 11553,
4290: 11554,
4291: 11555,
4292: 11556,
4293: 11557,
7838: 223,
7930: 7931,
7932: 7933,
7934: 7935,
8498: 8526,
8579: 8580,
11264: 11312,
11265: 11313,
11266: 11314,
11267: 11315,
11268: 11316,
11269: 11317,
11270: 11318,
11271: 11319,
11272: 11320,
11273: 11321,
11274: 11322,
11275: 11323,
11276: 11324,
11277: 11325,
11278: 11326,
11279: 11327,
11280: 11328,
11281: 11329,
11282: 11330,
11283: 11331,
11284: 11332,
11285: 11333,
11286: 11334,
11287: 11335,
11288: 11336,
11289: 11337,
11290: 11338,
11291: 11339,
11292: 11340,
11293: 11341,
11294: 11342,
11295: 11343,
11296: 11344,
11297: 11345,
11298: 11346,
11299: 11347,
11300: 11348,
11301: 11349,
11302: 11350,
11303: 11351,
11304: 11352,
11305: 11353,
11306: 11354,
11307: 11355,
11308: 11356,
11309: 11357,
11310: 11358,
11360: 11361,
11362: 619,
11363: 7549,
11364: 637,
11367: 11368,
11369: 11370,
11371: 11372,
11373: 593,
11374: 625,
11375: 592,
11376: 594,
11378: 11379,
11381: 11382,
11390: 575,
11391: 576,
11392: 11393,
11394: 11395,
11396: 11397,
11398: 11399,
11400: 11401,
11402: 11403,
11404: 11405,
11406: 11407,
11408: 11409,
11410: 11411,
11412: 11413,
11414: 11415,
11416: 11417,
11418: 11419,
11420: 11421,
11422: 11423,
11424: 11425,
11426: 11427,
11428: 11429,
11430: 11431,
11432: 11433,
11434: 11435,
11436: 11437,
11438: 11439,
11440: 11441,
11442: 11443,
11444: 11445,
11446: 11447,
11448: 11449,
11450: 11451,
11452: 11453,
11454: 11455,
11456: 11457,
11458: 11459,
11460: 11461,
11462: 11463,
11464: 11465,
11466: 11467,
11468: 11469,
11470: 11471,
11472: 11473,
11474: 11475,
11476: 11477,
11478: 11479,
11480: 11481,
11482: 11483,
11484: 11485,
11486: 11487,
11488: 11489,
11490: 11491,
11499: 11500,
11501: 11502,
42560: 42561,
42562: 42563,
42564: 42565,
42566: 42567,
42568: 42569,
42570: 42571,
42572: 42573,
42574: 42575,
42576: 42577,
42578: 42579,
42580: 42581,
42582: 42583,
42584: 42585,
42586: 42587,
42588: 42589,
42590: 42591,
42594: 42595,
42596: 42597,
42598: 42599,
42600: 42601,
42602: 42603,
42604: 42605,
42624: 42625,
42626: 42627,
42628: 42629,
42630: 42631,
42632: 42633,
42634: 42635,
42636: 42637,
42638: 42639,
42640: 42641,
42642: 42643,
42644: 42645,
42646: 42647,
42786: 42787,
42788: 42789,
42790: 42791,
42792: 42793,
42794: 42795,
42796: 42797,
42798: 42799,
42802: 42803,
42804: 42805,
42806: 42807,
42808: 42809,
42810: 42811,
42812: 42813,
42814: 42815,
42816: 42817,
42818: 42819,
42820: 42821,
42822: 42823,
42824: 42825,
42826: 42827,
42828: 42829,
42830: 42831,
42832: 42833,
42834: 42835,
42836: 42837,
42838: 42839,
42840: 42841,
42842: 42843,
42844: 42845,
42846: 42847,
42848: 42849,
42850: 42851,
42852: 42853,
42854: 42855,
42856: 42857,
42858: 42859,
42860: 42861,
42862: 42863,
42873: 42874,
42875: 42876,
42877: 7545,
42878: 42879,
42880: 42881,
42882: 42883,
42884: 42885,
42886: 42887,
42891: 42892,
66598: 66638,
66599: 66639,
}

_tolower_corrected = {
}
_totitle = {
384: 579,
410: 573,
453: 453,
456: 456,
459: 459,
498: 498,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
66638: 66598,
66639: 66599,
}

_totitle_corrected = {
}
_special_casing = {
223: ([223], [83, 115], [83, 83]),
304: ([105, 775], [304], [304]),
329: ([329], [700, 78], [700, 78]),
496: ([496], [74, 780], [74, 780]),
912: ([912], [921, 776, 769], [921, 776, 769]),
944: ([944], [933, 776, 769], [933, 776, 769]),
1415: ([1415], [1333, 1410], [1333, 1362]),
7830: ([7830], [72, 817], [72, 817]),
7831: ([7831], [84, 776], [84, 776]),
7832: ([7832], [87, 778], [87, 778]),
7833: ([7833], [89, 778], [89, 778]),
7834: ([7834], [65, 702], [65, 702]),
8016: ([8016], [933, 787], [933, 787]),
8018: ([8018], [933, 787, 768], [933, 787, 768]),
8020: ([8020], [933, 787, 769], [933, 787, 769]),
8022: ([8022], [933, 787, 834], [933, 787, 834]),
8064: ([8064], [8072], [7944, 921]),
8065: ([8065], [8073], [7945, 921]),
8066: ([8066], [8074], [7946, 921]),
8067: ([8067], [8075], [7947, 921]),
8068: ([8068], [8076], [7948, 921]),
8069: ([8069], [8077], [7949, 921]),
8070: ([8070], [8078], [7950, 921]),
8071: ([8071], [8079], [7951, 921]),
8072: ([8064], [8072], [7944, 921]),
8073: ([8065], [8073], [7945, 921]),
8074: ([8066], [8074], [7946, 921]),
8075: ([8067], [8075], [7947, 921]),
8076: ([8068], [8076], [7948, 921]),
8077: ([8069], [8077], [7949, 921]),
8078: ([8070], [8078], [7950, 921]),
8079: ([8071], [8079], [7951, 921]),
8080: ([8080], [8088], [7976, 921]),
8081: ([8081], [8089], [7977, 921]),
8082: ([8082], [8090], [7978, 921]),
8083: ([8083], [8091], [7979, 921]),
8084: ([8084], [8092], [7980, 921]),
8085: ([8085], [8093], [7981, 921]),
8086: ([8086], [8094], [7982, 921]),
8087: ([8087], [8095], [7983, 921]),
8088: ([8080], [8088], [7976, 921]),
8089: ([8081], [8089], [7977, 921]),
8090: ([8082], [8090], [7978, 921]),
8091: ([8083], [8091], [7979, 921]),
8092: ([8084], [8092], [7980, 921]),
8093: ([8085], [8093], [7981, 921]),
8094: ([8086], [8094], [7982, 921]),
8095: ([8087], [8095], [7983, 921]),
8096: ([8096], [8104], [8040, 921]),
8097: ([8097], [8105], [8041, 921]),
8098: ([8098], [8106], [8042, 921]),
8099: ([8099], [8107], [8043, 921]),
8100: ([8100], [8108], [8044, 921]),
8101: ([8101], [8109], [8045, 921]),
8102: ([8102], [8110], [8046, 921]),
8103: ([8103], [8111], [8047, 921]),
8104: ([8096], [8104], [8040, 921]),
8105: ([8097], [8105], [8041, 921]),
8106: ([8098], [8106], [8042, 921]),
8107: ([8099], [8107], [8043, 921]),
8108: ([8100], [8108], [8044, 921]),
8109: ([8101], [8109], [8045, 921]),
8110: ([8102], [8110], [8046, 921]),
8111: ([8103], [8111], [8047, 921]),
8114: ([8114], [8122, 837], [8122, 921]),
8115: ([8115], [8124], [913, 921]),
8116: ([8116], [902, 837], [902, 921]),
8118: ([8118], [913, 834], [913, 834]),
8119: ([8119], [913, 834, 837], [913, 834, 921]),
8124: ([8115], [8124], [913, 921]),
8130: ([8130], [8138, 837], [8138, 921]),
8131: ([8131], [8140], [919, 921]),
8132: ([8132], [905, 837], [905, 921]),
8134: ([8134], [919, 834], [919, 834]),
8135: ([8135], [919, 834, 837], [919, 834, 921]),
8140: ([8131], [8140], [919, 921]),
8146: ([8146], [921, 776, 768], [921, 776, 768]),
8147: ([8147], [921, 776, 769], [921, 776, 769]),
8150: ([8150], [921, 834], [921, 834]),
8151: ([8151], [921, 776, 834], [921, 776, 834]),
8162: ([8162], [933, 776, 768], [933, 776, 768]),
8163: ([8163], [933, 776, 769], [933, 776, 769]),
8164: ([8164], [929, 787], [929, 787]),
8166: ([8166], [933, 834], [933, 834]),
8167: ([8167], [933, 776, 834], [933, 776, 834]),
8178: ([8178], [8186, 837], [8186, 921]),
8179: ([8179], [8188], [937, 921]),
8180: ([8180], [911, 837], [911, 921]),
8182: ([8182], [937, 834], [937, 834]),
8183: ([8183], [937, 834, 837], [937, 834, 921]),
8188: ([8179], [8188], [937, 921]),
64256: ([64256], [70, 102], [70, 70]),
64257: ([64257], [70, 105], [70, 73]),
64258: ([64258], [70, 108], [70, 76]),
64259: ([64259], [70, 102, 105], [70, 70, 73]),
64260: ([64260], [70, 102, 108], [70, 70, 76]),
64261: ([64261], [83, 116], [83, 84]),
64262: ([64262], [83, 116], [83, 84]),
64275: ([64275], [1348, 1398], [1348, 1350]),
64276: ([64276], [1348, 1381], [1348, 1333]),
64277: ([64277], [1348, 1387], [1348, 1339]),
64278: ([64278], [1358, 1398], [1358, 1350]),
64279: ([64279], [1348, 1389], [1348, 1341]),
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
1017: '<compat> 03A3',
4348: '<super> 10DC',
6918: '1B05 1B35',
6920: '1B07 1B35',
6922: '1B09 1B35',
6924: '1B0B 1B35',
6926: '1B0D 1B35',
6930: '1B11 1B35',
6971: '1B3A 1B35',
6973: '1B3C 1B35',
6976: '1B3E 1B35',
6977: '1B3F 1B35',
6979: '1B42 1B35',
7468: '<super> 0041',
7469: '<super> 00C6',
7470: '<super> 0042',
7472: '<super> 0044',
7473: '<super> 0045',
7474: '<super> 018E',
7475: '<super> 0047',
7476: '<super> 0048',
7477: '<super> 0049',
7478: '<super> 004A',
7479: '<super> 004B',
7480: '<super> 004C',
7481: '<super> 004D',
7482: '<super> 004E',
7484: '<super> 004F',
7485: '<super> 0222',
7486: '<super> 0050',
7487: '<super> 0052',
7488: '<super> 0054',
7489: '<super> 0055',
7490: '<super> 0057',
7491: '<super> 0061',
7492: '<super> 0250',
7493: '<super> 0251',
7494: '<super> 1D02',
7495: '<super> 0062',
7496: '<super> 0064',
7497: '<super> 0065',
7498: '<super> 0259',
7499: '<super> 025B',
7500: '<super> 025C',
7501: '<super> 0067',
7503: '<super> 006B',
7504: '<super> 006D',
7505: '<super> 014B',
7506: '<super> 006F',
7507: '<super> 0254',
7508: '<super> 1D16',
7509: '<super> 1D17',
7510: '<super> 0070',
7511: '<super> 0074',
7512: '<super> 0075',
7513: '<super> 1D1D',
7514: '<super> 026F',
7515: '<super> 0076',
7516: '<super> 1D25',
7517: '<super> 03B2',
7518: '<super> 03B3',
7519: '<super> 03B4',
7520: '<super> 03C6',
7521: '<super> 03C7',
7522: '<sub> 0069',
7523: '<sub> 0072',
7524: '<sub> 0075',
7525: '<sub> 0076',
7526: '<sub> 03B2',
7527: '<sub> 03B3',
7528: '<sub> 03C1',
7529: '<sub> 03C6',
7530: '<sub> 03C7',
7544: '<super> 043D',
7579: '<super> 0252',
7580: '<super> 0063',
7581: '<super> 0255',
7582: '<super> 00F0',
7583: '<super> 025C',
7584: '<super> 0066',
7585: '<super> 025F',
7586: '<super> 0261',
7587: '<super> 0265',
7588: '<super> 0268',
7589: '<super> 0269',
7590: '<super> 026A',
7591: '<super> 1D7B',
7592: '<super> 029D',
7593: '<super> 026D',
7594: '<super> 1D85',
7595: '<super> 029F',
7596: '<super> 0271',
7597: '<super> 0270',
7598: '<super> 0272',
7599: '<super> 0273',
7600: '<super> 0274',
7601: '<super> 0275',
7602: '<super> 0278',
7603: '<super> 0282',
7604: '<super> 0283',
7605: '<super> 01AB',
7606: '<super> 0289',
7607: '<super> 028A',
7608: '<super> 1D1C',
7609: '<super> 028B',
7610: '<super> 028C',
7611: '<super> 007A',
7612: '<super> 0290',
7613: '<super> 0291',
7614: '<super> 0292',
7615: '<super> 03B8',
8336: '<sub> 0061',
8337: '<sub> 0065',
8338: '<sub> 006F',
8339: '<sub> 0078',
8340: '<sub> 0259',
8507: '<compat> 0046 0041 0058',
8508: '<font> 03C0',
8528: '<fraction> 0031 2044 0037',
8529: '<fraction> 0031 2044 0039',
8530: '<fraction> 0031 2044 0031 0030',
8585: '<fraction> 0030 2044 0033',
11388: '<sub> 006A',
11389: '<super> 0056',
11631: '<super> 2D61',
12829: '<compat> 0028 110B 1169 110C 1165 11AB 0029',
12830: '<compat> 0028 110B 1169 1112 116E 0029',
12868: '<circle> 554F',
12869: '<circle> 5E7C',
12870: '<circle> 6587',
12871: '<circle> 7B8F',
12880: '<square> 0050 0054 0045',
12924: '<circle> 110E 1161 11B7 1100 1169',
12925: '<circle> 110C 116E 110B 1174',
12926: '<circle> 110B 116E',
13004: '<square> 0048 0067',
13005: '<square> 0065 0072 0067',
13006: '<square> 0065 0056',
13007: '<square> 004C 0054 0044',
13175: '<square> 0064 006D',
13176: '<square> 0064 006D 00B2',
13177: '<square> 0064 006D 00B3',
13178: '<square> 0049 0055',
13278: '<square> 0056 2215 006D',
13279: '<square> 0041 2215 006D',
13311: '<square> 0067 0061 006C',
42864: '<super> A76F',
64107: '6075',
64108: '242EE',
64109: '8218',
64112: '4E26',
64113: '51B5',
64114: '5168',
64115: '4F80',
64116: '5145',
64117: '5180',
64118: '52C7',
64119: '52FA',
64120: '559D',
64121: '5555',
64122: '5599',
64123: '55E2',
64124: '585A',
64125: '58B3',
64126: '5944',
64127: '5954',
64128: '5A62',
64129: '5B28',
64130: '5ED2',
64131: '5ED9',
64132: '5F69',
64133: '5FAD',
64134: '60D8',
64135: '614E',
64136: '6108',
64137: '618E',
64138: '6160',
64139: '61F2',
64140: '6234',
64141: '63C4',
64142: '641C',
64143: '6452',
64144: '6556',
64145: '6674',
64146: '6717',
64147: '671B',
64148: '6756',
64149: '6B79',
64150: '6BBA',
64151: '6D41',
64152: '6EDB',
64153: '6ECB',
64154: '6F22',
64155: '701E',
64156: '716E',
64157: '77A7',
64158: '7235',
64159: '72AF',
64160: '732A',
64161: '7471',
64162: '7506',
64163: '753B',
64164: '761D',
64165: '761F',
64166: '76CA',
64167: '76DB',
64168: '76F4',
64169: '774A',
64170: '7740',
64171: '78CC',
64172: '7AB1',
64173: '7BC0',
64174: '7C7B',
64175: '7D5B',
64176: '7DF4',
64177: '7F3E',
64178: '8005',
64179: '8352',
64180: '83EF',
64181: '8779',
64182: '8941',
64183: '8986',
64184: '8996',
64185: '8ABF',
64186: '8AF8',
64187: '8ACB',
64188: '8B01',
64189: '8AFE',
64190: '8AED',
64191: '8B39',
64192: '8B8A',
64193: '8D08',
64194: '8F38',
64195: '9072',
64196: '9199',
64197: '9276',
64198: '967C',
64199: '96E3',
64200: '9756',
64201: '97DB',
64202: '97FF',
64203: '980B',
64204: '983B',
64205: '9B12',
64206: '9F9C',
64207: '2284A',
64208: '22844',
64209: '233D5',
64210: '3B9D',
64211: '4018',
64212: '4039',
64213: '25249',
64214: '25CD0',
64215: '27ED3',
64216: '9F43',
64217: '9F8E',
65040: '<vertical> 002C',
65041: '<vertical> 3001',
65042: '<vertical> 3002',
65043: '<vertical> 003A',
65044: '<vertical> 003B',
65045: '<vertical> 0021',
65046: '<vertical> 003F',
65047: '<vertical> 3016',
65048: '<vertical> 3017',
65049: '<vertical> 2026',
65095: '<vertical> 005B',
65096: '<vertical> 005D',
69786: '11099 110BA',
69788: '1109B 110BA',
69803: '110A5 110BA',
120001: '<font> 006C',
120484: '<font> 0131',
120485: '<font> 0237',
120778: '<font> 03DC',
120779: '<font> 03DD',
127232: '<compat> 0030 002E',
127233: '<compat> 0030 002C',
127234: '<compat> 0031 002C',
127235: '<compat> 0032 002C',
127236: '<compat> 0033 002C',
127237: '<compat> 0034 002C',
127238: '<compat> 0035 002C',
127239: '<compat> 0036 002C',
127240: '<compat> 0037 002C',
127241: '<compat> 0038 002C',
127242: '<compat> 0039 002C',
127248: '<compat> 0028 0041 0029',
127249: '<compat> 0028 0042 0029',
127250: '<compat> 0028 0043 0029',
127251: '<compat> 0028 0044 0029',
127252: '<compat> 0028 0045 0029',
127253: '<compat> 0028 0046 0029',
127254: '<compat> 0028 0047 0029',
127255: '<compat> 0028 0048 0029',
127256: '<compat> 0028 0049 0029',
127257: '<compat> 0028 004A 0029',
127258: '<compat> 0028 004B 0029',
127259: '<compat> 0028 004C 0029',
127260: '<compat> 0028 004D 0029',
127261: '<compat> 0028 004E 0029',
127262: '<compat> 0028 004F 0029',
127263: '<compat> 0028 0050 0029',
127264: '<compat> 0028 0051 0029',
127265: '<compat> 0028 0052 0029',
127266: '<compat> 0028 0053 0029',
127267: '<compat> 0028 0054 0029',
127268: '<compat> 0028 0055 0029',
127269: '<compat> 0028 0056 0029',
127270: '<compat> 0028 0057 0029',
127271: '<compat> 0028 0058 0029',
127272: '<compat> 0028 0059 0029',
127273: '<compat> 0028 005A 0029',
127274: '<compat> 3014 0053 3015',
127275: '<circle> 0043',
127276: '<circle> 0052',
127277: '<circle> 0043 0044',
127278: '<circle> 0057 005A',
127281: '<square> 0042',
127293: '<square> 004E',
127295: '<square> 0050',
127298: '<square> 0053',
127302: '<square> 0057',
127306: '<square> 0048 0056',
127307: '<square> 004D 0056',
127308: '<square> 0053 0044',
127309: '<square> 0053 0053',
127310: '<square> 0050 0050 0056',
127376: '<square> 0044 004A',
127488: '<square> 307B 304B',
127504: '<square> 624B',
127505: '<square> 5B57',
127506: '<square> 53CC',
127507: '<square> 30C7',
127508: '<square> 4E8C',
127509: '<square> 591A',
127510: '<square> 89E3',
127511: '<square> 5929',
127512: '<square> 4EA4',
127513: '<square> 6620',
127514: '<square> 7121',
127515: '<square> 6599',
127516: '<square> 524D',
127517: '<square> 5F8C',
127518: '<square> 518D',
127519: '<square> 65B0',
127520: '<square> 521D',
127521: '<square> 7D42',
127522: '<square> 751F',
127523: '<square> 8CA9',
127524: '<square> 58F0',
127525: '<square> 5439',
127526: '<square> 6F14',
127527: '<square> 6295',
127528: '<square> 6355',
127529: '<square> 4E00',
127530: '<square> 4E09',
127531: '<square> 904A',
127532: '<square> 5DE6',
127533: '<square> 4E2D',
127534: '<square> 53F3',
127535: '<square> 6307',
127536: '<square> 8D70',
127537: '<square> 6253',
127552: '<compat> 3014 672C 3015',
127553: '<compat> 3014 4E09 3015',
127554: '<compat> 3014 4E8C 3015',
127555: '<compat> 3014 5B89 3015',
127556: '<compat> 3014 70B9 3015',
127557: '<compat> 3014 6253 3015',
127558: '<compat> 3014 76D7 3015',
127559: '<compat> 3014 52DD 3015',
127560: '<compat> 3014 6557 3015',
194664: '36FC',
194676: '5F53',
194847: '243AB',
194911: '7AEE',
195007: '45D7',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
}

_canon_decomposition = {
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
1017: [931],
4348: [4316],
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
7468: [65],
7469: [198],
7470: [66],
7472: [68],
7473: [69],
7474: [398],
7475: [71],
7476: [72],
7477: [73],
7478: [74],
7479: [75],
7480: [76],
7481: [77],
7482: [78],
7484: [79],
7485: [546],
7486: [80],
7487: [82],
7488: [84],
7489: [85],
7490: [87],
7491: [97],
7492: [592],
7493: [593],
7494: [7426],
7495: [98],
7496: [100],
7497: [101],
7498: [601],
7499: [603],
7500: [604],
7501: [103],
7503: [107],
7504: [109],
7505: [331],
7506: [111],
7507: [596],
7508: [7446],
7509: [7447],
7510: [112],
7511: [116],
7512: [117],
7513: [7453],
7514: [623],
7515: [118],
7516: [7461],
7517: [946],
7518: [947],
7519: [948],
7520: [966],
7521: [967],
7522: [105],
7523: [114],
7524: [117],
7525: [118],
7526: [946],
7527: [947],
7528: [961],
7529: [966],
7530: [967],
7544: [1085],
7579: [594],
7580: [99],
7581: [597],
7582: [240],
7583: [604],
7584: [102],
7585: [607],
7586: [609],
7587: [613],
7588: [616],
7589: [617],
7590: [618],
7591: [7547],
7592: [669],
7593: [621],
7594: [7557],
7595: [671],
7596: [625],
7597: [624],
7598: [626],
7599: [627],
7600: [628],
7601: [629],
7602: [632],
7603: [642],
7604: [643],
7605: [427],
7606: [649],
7607: [650],
7608: [7452],
7609: [651],
7610: [652],
7611: [122],
7612: [656],
7613: [657],
7614: [658],
7615: [952],
8336: [97],
8337: [101],
8338: [111],
8339: [120],
8340: [601],
8507: [70, 65, 88],
8508: [960],
8528: [49, 8260, 55],
8529: [49, 8260, 57],
8530: [49, 8260, 49, 48],
8585: [48, 8260, 51],
11388: [106],
11389: [86],
11631: [11617],
12829: [40, 4363, 4457, 4364, 4453, 4523, 41],
12830: [40, 4363, 4457, 4370, 4462, 41],
12868: [21839],
12869: [24188],
12870: [25991],
12871: [31631],
12880: [80, 84, 69],
12924: [4366, 4449, 4535, 4352, 4457],
12925: [4364, 4462, 4363, 4468],
12926: [4363, 4462],
13004: [72, 103],
13005: [101, 114, 103],
13006: [101, 86],
13007: [76, 84, 68],
13175: [100, 109],
13176: [100, 109, 50],
13177: [100, 109, 51],
13178: [73, 85],
13278: [86, 8725, 109],
13279: [65, 8725, 109],
13311: [103, 97, 108],
42864: [42863],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
65040: [44],
65041: [12289],
65042: [12290],
65043: [58],
65044: [59],
65045: [33],
65046: [63],
65047: [12310],
65048: [12311],
65049: [46, 46, 46],
65095: [91],
65096: [93],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
120001: [108],
120484: [305],
120485: [567],
120778: [988],
120779: [989],
127232: [48, 46],
127233: [48, 44],
127234: [49, 44],
127235: [50, 44],
127236: [51, 44],
127237: [52, 44],
127238: [53, 44],
127239: [54, 44],
127240: [55, 44],
127241: [56, 44],
127242: [57, 44],
127248: [40, 65, 41],
127249: [40, 66, 41],
127250: [40, 67, 41],
127251: [40, 68, 41],
127252: [40, 69, 41],
127253: [40, 70, 41],
127254: [40, 71, 41],
127255: [40, 72, 41],
127256: [40, 73, 41],
127257: [40, 74, 41],
127258: [40, 75, 41],
127259: [40, 76, 41],
127260: [40, 77, 41],
127261: [40, 78, 41],
127262: [40, 79, 41],
127263: [40, 80, 41],
127264: [40, 81, 41],
127265: [40, 82, 41],
127266: [40, 83, 41],
127267: [40, 84, 41],
127268: [40, 85, 41],
127269: [40, 86, 41],
127270: [40, 87, 41],
127271: [40, 88, 41],
127272: [40, 89, 41],
127273: [40, 90, 41],
127274: [12308, 83, 12309],
127275: [67],
127276: [82],
127277: [67, 68],
127278: [87, 90],
127281: [66],
127293: [78],
127295: [80],
127298: [83],
127302: [87],
127306: [72, 86],
127307: [77, 86],
127308: [83, 68],
127309: [83, 83],
127310: [80, 80, 86],
127376: [68, 74],
127488: [12411, 12363],
127504: [25163],
127505: [23383],
127506: [21452],
127507: [12486, 12441],
127508: [20108],
127509: [22810],
127510: [35299],
127511: [22825],
127512: [20132],
127513: [26144],
127514: [28961],
127515: [26009],
127516: [21069],
127517: [24460],
127518: [20877],
127519: [26032],
127520: [21021],
127521: [32066],
127522: [29983],
127523: [36009],
127524: [22768],
127525: [21561],
127526: [28436],
127527: [25237],
127528: [25429],
127529: [19968],
127530: [19977],
127531: [36938],
127532: [24038],
127533: [20013],
127534: [21491],
127535: [25351],
127536: [36208],
127537: [25171],
127552: [12308, 26412, 12309],
127553: [12308, 19977, 12309],
127554: [12308, 20108, 12309],
127555: [12308, 23433, 12309],
127556: [12308, 28857, 12309],
127557: [12308, 25171, 12309],
127558: [12308, 30423, 12309],
127559: [12308, 21213, 12309],
127560: [12308, 25943, 12309],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u31f7\u309a',
u'\u02e5\u02e9',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
418,
419,
3294,
3741,
3743,
3747,
3749,
4048,
40981,
65048,
118981,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
7838: [115, 115],
}

_casefolds_corrected = {
1010: None,
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
848: 230,
849: 230,
850: 230,
851: 220,
852: 220,
853: 220,
854: 220,
855: 230,
856: 232,
857: 220,
858: 220,
859: 230,
860: 233,
861: 234,
862: 234,
863: 233,
1159: 230,
1442: 220,
1466: 19,
1477: 220,
1479: 18,
1552: 230,
1553: 230,
1554: 230,
1555: 230,
1556: 230,
1557: 230,
1558: 230,
1559: 230,
1560: 30,
1561: 31,
1562: 32,
1622: 220,
1623: 230,
1624: 230,
1625: 230,
1626: 230,
1627: 230,
1628: 220,
1629: 230,
1630: 230,
2027: 230,
2028: 230,
2029: 230,
2030: 230,
2031: 230,
2032: 230,
2033: 230,
2034: 220,
2035: 230,
2070: 230,
2071: 230,
2072: 230,
2073: 230,
2075: 230,
2076: 230,
2077: 230,
2078: 230,
2079: 230,
2080: 230,
2081: 230,
2082: 230,
2083: 230,
2085: 230,
2086: 230,
2087: 230,
2089: 230,
2090: 230,
2091: 230,
2092: 230,
2093: 230,
3260: 7,
4154: 9,
4237: 220,
4959: 230,
6109: 230,
6457: 222,
6458: 230,
6459: 220,
6679: 230,
6680: 220,
6752: 9,
6773: 230,
6774: 230,
6775: 230,
6776: 230,
6777: 230,
6778: 230,
6779: 230,
6780: 230,
6783: 220,
6964: 7,
6980: 9,
7019: 230,
7020: 220,
7021: 230,
7022: 230,
7023: 230,
7024: 230,
7025: 230,
7026: 230,
7027: 230,
7082: 9,
7223: 7,
7376: 230,
7377: 230,
7378: 230,
7380: 1,
7381: 220,
7382: 220,
7383: 220,
7384: 220,
7385: 220,
7386: 230,
7387: 230,
7388: 220,
7389: 220,
7390: 220,
7391: 220,
7392: 230,
7394: 1,
7395: 1,
7396: 1,
7397: 1,
7398: 1,
7399: 1,
7400: 1,
7405: 220,
7616: 230,
7617: 230,
7618: 220,
7619: 230,
7620: 230,
7621: 230,
7622: 230,
7623: 230,
7624: 230,
7625: 230,
7626: 220,
7627: 230,
7628: 230,
7629: 234,
7630: 214,
7631: 220,
7632: 202,
7633: 230,
7634: 230,
7635: 230,
7636: 230,
7637: 230,
7638: 230,
7639: 230,
7640: 230,
7641: 230,
7642: 230,
7643: 230,
7644: 230,
7645: 230,
7646: 230,
7647: 230,
7648: 230,
7649: 230,
7650: 230,
7651: 230,
7652: 230,
7653: 230,
7654: 230,
7677: 220,
7678: 230,
7679: 220,
8427: 1,
8428: 220,
8429: 220,
8430: 220,
8431: 220,
8432: 230,
11503: 230,
11504: 230,
11505: 230,
11744: 230,
11745: 230,
11746: 230,
11747: 230,
11748: 230,
11749: 230,
11750: 230,
11751: 230,
11752: 230,
11753: 230,
11754: 230,
11755: 230,
11756: 230,
11757: 230,
11758: 230,
11759: 230,
11760: 230,
11761: 230,
11762: 230,
11763: 230,
11764: 230,
11765: 230,
11766: 230,
11767: 230,
11768: 230,
11769: 230,
11770: 230,
11771: 230,
11772: 230,
11773: 230,
11774: 230,
11775: 230,
42607: 230,
42620: 230,
42621: 230,
42736: 230,
42737: 230,
43014: 9,
43204: 9,
43232: 230,
43233: 230,
43234: 230,
43235: 230,
43236: 230,
43237: 230,
43238: 230,
43239: 230,
43240: 230,
43241: 230,
43242: 230,
43243: 230,
43244: 230,
43245: 230,
43246: 230,
43247: 230,
43248: 230,
43249: 230,
43307: 220,
43308: 220,
43309: 220,
43347: 9,
43443: 7,
43456: 9,
43696: 230,
43698: 230,
43699: 230,
43700: 220,
43703: 230,
43704: 230,
43710: 230,
43711: 230,
43713: 230,
44013: 9,
65060: 230,
65061: 230,
65062: 230,
66045: 220,
68109: 220,
68111: 230,
68152: 230,
68153: 1,
68154: 220,
68159: 9,
69817: 9,
69818: 7,
119362: 230,
119363: 230,
119364: 230,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

